<?php
/**
 * File containing the ezcDocumentDocbookToOdtAnchorHandler class.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 * @package Document
 * @version //autogen//
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @access private
 */

/**
 * Visit anchors.
 *
 * Visit docbook <anchor/> and transform them into ODT <text:reference-mark/>.
 *
 * Note that additional reference-marks are generated by the {@link 
 * ezcDocumentDocbookToOdtSectionHandler} to make sections linkable.
 *
 * @package Document
 * @version //autogen//
 * @access private
 */
class ezcDocumentDocbookToOdtAnchorHandler extends ezcDocumentDocbookToOdtBaseHandler
{
    /**
     * Handle a node
     *
     * Handle / transform a given node, and return the result of the
     * conversion.
     *
     * @param ezcDocumentElementVisitorConverter $converter
     * @param DOMElement $node
     * @param mixed $root
     * @return mixed
     */
    public function handle( ezcDocumentElementVisitorConverter $converter, DOMElement $node, $root )
    {
        $this->createRefMark(
            $node,
            $root
        );

        return $root;
    }

    /**
     * Creates a ref-mark as the first element of the given $odtElement, based 
     * on the ID attribute of the given $docbookElement.
     * 
     * @param DOMElement $docbookElement 
     * @param DOMElement $odtElement 
     */
    protected function createRefMark( DOMElement $docbookElement, DOMElement $odtElement )
    {
        // Work around for DocBook inconsistency in using ID or id. id 
        // would  be correct, if one follows the specs here…
        if ( $docbookElement->hasAttribute( 'ID' ) || $docbookElement->hasAttribute( 'id' ) )
        {
            $refMark = $odtElement->insertBefore(
                $odtElement->ownerDocument->createElementNS(
                    ezcDocumentOdt::NS_ODT_TEXT,
                    'text:reference-mark'
                ),
                $odtElement->firstChild
            );
            $refMark->setAttributeNS(
                ezcDocumentOdt::NS_ODT_TEXT,
                'text:name',
                ( $docbookElement->hasAttribute( 'ID' ) ? $docbookElement->getAttribute( 'ID' ) : $docbookElement->getAttribute( 'id' ) )
            );
        }
    }
}

?>
