<?php

namespace Psalm\Internal;

return [
    // file io
    'chdir' => true,
    'chgrp' => true,
    'chmod' => true,
    'chown' => true,
    'chroot' => true,
    'copy' => true,
    'file_get_contents' => true,
    'file_put_contents' => true,
    'opendir' => true,
    'readdir' => true,
    'closedir' => true,
    'rewinddir' => true,
    'scandir' => true,
    'fopen' => true,
    'fread' => true,
    'fwrite' => true,
    'fclose' => true,
    'touch' => true,
    'fpassthru' => true,
    'fputs' => true,
    'fscanf' => true,
    'fseek' => true,
    'flock' => true,
    'ftruncate' => true,
    'fprintf' => true,
    'symlink' => true,
    'mkdir' => true,
    'unlink' => true,
    'rename' => true,
    'rmdir' => true,
    'popen' => true,
    'pclose' => true,
    'fgetcsv' => true,
    'fputcsv' => true,
    'umask' => true,
    'finfo_open' => true,
    'finfo_close' => true,
    'finfo_file' => true,
    'stream_set_timeout' => true,
    'fgets' => true,
    'fflush' => true,
    'move_uploaded_file' => true,
    'file_exists' => true,
    'realpath' => true,
    'glob' => true,
    'is_readable' => true,
    'is_dir' => true,
    'is_file' => true,
    // stream/socket io
    'stream_context_set_option' => true,
    'socket_write' => true,
    'stream_set_blocking' => true,
    'socket_close' => true,
    'socket_set_option' => true,
    'stream_set_write_buffer' => true,
    'stream_socket_enable_crypto' => true,
    'stream_copy_to_stream' => true,
    'stream_wrapper_register' => true,
    'socket_connect' => true,
    'socket_bind' => true,
    'socket_set_block' => true,
    'socket_set_nonblock' => true,
    'socket_listen' => true,
    // meta calls
    'call_user_func' => true,
    'call_user_func_array' => true,
    'define' => true,
    'create_function' => true,
    // http
    'header' => true,
    'header_remove' => true,
    'http_response_code' => true,
    'setcookie' => true,
    'setrawcookie' => true,
    // output buffer
    'ob_start' => true,
    'ob_end_clean' => true,
    'ob_get_clean' => true,
    'readfile' => true,
    'printf' => true,
    'var_dump' => true,
    'phpinfo' => true,
    'ob_implicit_flush' => true,
    'vprintf' => true,
    // mcrypt
    'mcrypt_generic_init' => true,
    'mcrypt_generic_deinit' => true,
    'mcrypt_module_close' => true,
    // internal optimisation
    'opcache_compile_file' => true,
    'clearstatcache' => true,
    // process-related
    'pcntl_signal' => true,
    'pcntl_alarm' => true,
    'posix_kill' => true,
    'cli_set_process_title' => true,
    'pcntl_async_signals' => true,
    'proc_close' => true,
    'proc_nice' => true,
    'proc_open' => true,
    'proc_terminate' => true,
    // curl
    'curl_setopt' => true,
    'curl_close' => true,
    'curl_multi_add_handle' => true,
    'curl_multi_remove_handle' => true,
    'curl_multi_select' => true,
    'curl_multi_close' => true,
    'curl_setopt_array' => true,
    // apc, apcu
    'apc_store' => true,
    'apc_delete' => true,
    'apc_clear_cache' => true,
    'apc_add' => true,
    'apc_inc' => true,
    'apc_dec' => true,
    'apc_cas' => true,
    'apcu_store' => true,
    'apcu_delete' => true,
    'apcu_clear_cache' => true,
    'apcu_add' => true,
    'apcu_inc' => true,
    'apcu_dec' => true,
    'apcu_cas' => true,
    // gz
    'gzwrite' => true,
    'gzrewind' => true,
    'gzseek' => true,
    'gzclose' => true,
    // newrelic
    'newrelic_start_transaction' => true,
    'newrelic_name_transaction' => true,
    'newrelic_add_custom_parameter' => true,
    'newrelic_add_custom_tracer' => true,
    'newrelic_background_job' => true,
    'newrelic_end_transaction' => true,
    'newrelic_set_appname' => true,
    // execution
    'shell_exec' => true,
    'exec' => true,
    'system' => true,
    'passthru' => true,
    'pcntl_exec' => true,
    // well-known functions
    'libxml_use_internal_errors' => true,
    'libxml_disable_entity_loader' => true,
    'curl_exec' => true,
    'mt_srand' => true,
    'openssl_pkcs7_sign' => true,
    'openssl_sign' => true,
    'mt_rand' => true,
    'rand' => true,
    'random_int' => true,
    'random_bytes' => true,
    'wincache_ucache_delete' => true,
    'wincache_ucache_set' => true,
    'wincache_ucache_inc' => true,
    'class_alias' => true,
    'class_exists' => true, // impure by virtue of triggering autoloader
    'enum_exists' => true, // impure by virtue of triggering autoloader
    // php environment
    'ini_set' => true,
    'sleep' => true,
    'usleep' => true,
    'register_shutdown_function' => true,
    'error_reporting' => true,
    'register_tick_function' => true,
    'unregister_tick_function' => true,
    'set_error_handler' => true,
    'user_error' => true,
    'trigger_error' => true,
    'restore_error_handler' => true,
    'date_default_timezone_set' => true,
    'assert_options' => true,
    'setlocale' => true,
    'set_exception_handler' => true,
    'set_time_limit' => true,
    'putenv' => true,
    'spl_autoload_register' => true,
    'spl_autoload_unregister' => true,
    'microtime' => true,
    'array_rand' => true,
    'set_include_path' => true,
    // logging
    'openlog' => true,
    'syslog' => true,
    'error_log' => true,
    'define_syslog_variables' => true,
    // session
    'session_id' => true,
    'session_decode' => true,
    'session_name' => true,
    'session_set_cookie_params' => true,
    'session_set_save_handler' => true,
    'session_regenerate_id' => true,
    'mb_internal_encoding' => true,
    'session_start' => true,
    'session_cache_limiter' => true,
    // ldap
    'ldap_set_option' => true,
    // iterators
    'rewind' => true,
    'iterator_apply' => true,
    'iterator_to_array' => true,
    // mysqli
    'mysqli_select_db' => true,
    'mysqli_dump_debug_info' => true,
    'mysqli_kill' => true,
    'mysqli_multi_query' => true,
    'mysqli_next_result' => true,
    'mysqli_options' => true,
    'mysqli_ping' => true,
    'mysqli_query' => true,
    'mysqli_report' => true,
    'mysqli_rollback' => true,
    'mysqli_savepoint' => true,
    'mysqli_set_charset' => true,
    'mysqli_ssl_set' => true,
    'mysqli_close' => true,
    // script execution
    'ignore_user_abort' => true,
    // ftp
    'ftp_close' => true,
    'ftp_pasv' => true,
    // bcmath
    'bcscale' => true,
    // json
    'json_last_error' => true,
    // opcache
    'opcache_compile_file' => true,
    'opcache_get_configuration' => true,
    'opcache_get_status' => true,
    'opcache_invalidate' => true,
    'opcache_is_script_cached' => true,
    'opcache_reset' => true,
    //gettext
    'bindtextdomain' => true,
    // hash
    'hash_update' => true,
    'hash_update_file' => true,
    'hash_update_stream' => true,
    // unserialize
    'unserialize' => true,
    // openssl
    'openssl_csr_export_to_file' => true,
    'openssl_pkcs12_export_to_file' => true,
    'openssl_pkey_export_to_file' => true,
    'openssl_x509_export_to_file' => true,
];
