# Atomic types

Atomic types are the basic building block of all type information used in Psalm. Multiple atomic types can be combined, either with [union types](union_types.md) or [intersection types](intersection_types.md). Psalm allows many different sorts of atomic types to be expressed in docblock syntax:

_Click on the &raquo; next to each type to view detailed documentation and examples._

* [Scalar types &raquo;](scalar_types.md)
    * [bool &raquo;](scalar_types.md#scalar)
    * [int &raquo;](scalar_types.md#scalar)
    * [float &raquo;](scalar_types.md#scalar)
    * [string &raquo;](scalar_types.md#scalar)
    * [`int-range<x, y>` &raquo;](scalar_types.md#int-range)
    * [`int-mask<1, 2, 4>` &raquo;](scalar_types.md#int-mask1-2-4)
    * [`int-mask-of<MyClass::CLASS_CONSTANT_*>` &raquo;](scalar_types.md#int-mask-ofmyclassclass_constant_)
    * [class-string and class-string&lt;Foo&gt; &raquo;](scalar_types.md#class-string-interface-string)
    * [trait-string &raquo;](scalar_types.md#trait-string)
    * [enum-string &raquo;](scalar_types.md#enum-string)
    * [callable-string &raquo;](scalar_types.md#callable-string)
    * [numeric-string &raquo;](scalar_types.md#numeric-string)
    * [literal-string &raquo;](scalar_types.md#literal-string)
    * [literal-int &raquo;](scalar_types.md#literal-int)
    * [array-key &raquo;](scalar_types.md#array-key)
    * [numeric &raquo;](scalar_types.md#numeric)
    * [scalar &raquo;](scalar_types.md#scalar)
* [Object types &raquo;](object_types.md)
    * [object &raquo;](object_types.md#unnamed-objects)
    * [object{foo: string} &raquo;](object_types.md#object-properties)
    * [Exception, Foo\MyClass and `Foo\MyClass<Bar>` &raquo;](object_types.md#named-objectsmd)
    * [Generator](object_types.md#generators)
* [Array types &raquo;](array_types.md)
    * [array&lt;int, string&gt;  &raquo;](array_types.md#generic-arrays)
    * [non-empty-array &raquo;](array_types.md#non-empty-array)
    * [string\[\] &raquo;](array_types.md#phpdoc-syntax)
    * [list & non-empty-list &raquo;](array_types.md#lists)
    * [list&lt;string&gt; &raquo;](array_types.md#lists)
    * [array{foo: int, bar: string} and list{int, string} &raquo;](array_types.md#object-like-arrays)
        * [Sealed arrays &raquo;](array_types.md#sealed-object-like-arrays)
        * [Unsealed arrays &raquo;](array_types.md#unsealed-object-like-arrays)
    * [callable-array &raquo;](array_types.md#callable-arrays)
* [Callable types &raquo;](callable_types.md)
* [Value types &raquo;](value_types.md)
    * [null &raquo;](value_types.md#null)
    * [true, false &raquo;](value_types.md#true-false)
    * [6, 7.0, "forty-two" and 'forty two' &raquo;](value_types.md#some_string-4-314)
    * [Foo\Bar::MY_SCALAR_CONST &raquo;](value_types.md#regular-class-constants)
* [Utility types &raquo;](utility_types.md)
    * [(T is true ? string : bool) &raquo;](conditional_types.md)
    * [`key-of<T>` &raquo;](utility_types.md#key-oft)
    * [`value-of<T>` &raquo;](utility_types.md#value-oft)
    * [`properties-of<T>` &raquo;](utility_types.md#properties-oft)
    * [`class-string-map<T as Foo, T>` &raquo;](utility_types.md#class-string-mapt-as-foo-t)
    * [`T[K]` &raquo;](utility_types.md#tk)
    * [Type aliases &raquo;](utility_types.md#type-aliases)
    * [Variable templates &raquo;](utility_types.md#variable-templates)
* [Other types &raquo;](other_types.md)
    * [`iterable<TKey, TValue>` &raquo;](other_types.md)
    * [void &raquo;](other_types.md)
    * [resource &raquo;](other_types.md)
    * [closed-resource &raquo;](other_types.md)
* [Top and bottom types &raquo;](top_bottom_types.md)
    * [mixed &raquo;](top_bottom_types.md#mixed)
    * [never &raquo;](top_bottom_types.md#never)
