<?php
namespace Psalm\Tests\Config;

use const DIRECTORY_SEPARATOR;
use function dirname;
use Psalm\Config\Creator;

class CreatorTest extends \Psalm\Tests\TestCase
{
    public static function setUpBeforeClass() : void
    {
    }

    public function setUp() : void
    {
    }

    /**
     * @return void
     */
    public function testDiscoverLibDirectory()
    {
        $lib_contents = Creator::getContents(
            dirname(__DIR__, 1)
                . DIRECTORY_SEPARATOR . 'fixtures'
                . DIRECTORY_SEPARATOR . 'config_discovery'
                . DIRECTORY_SEPARATOR . 'files_in_lib',
            null,
            1,
            'vendor'
        );

        $this->assertSame('<?xml version="1.0"?>
<psalm
    totallyTyped="true"
    errorLevel="1"
    resolveFromConfigFile="true"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns="https://getpsalm.org/schema/config"
    xsi:schemaLocation="https://getpsalm.org/schema/config vendor/vimeo/psalm/config.xsd"
>
    <projectFiles>
        <directory name="lib" />
        <ignoreFiles>
            <directory name="vendor" />
        </ignoreFiles>
    </projectFiles>
</psalm>
', $lib_contents);
    }
}
