/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical;

import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.stage.mxCoordinateAssignment;
import com.mxgraph.layout.hierarchical.stage.mxMedianHybridCrossingReduction;
import com.mxgraph.layout.hierarchical.stage.mxMinimumCycleRemover;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;

public class mxHierarchicalLayout
extends mxGraphLayout {
    protected List<Object> roots = null;
    protected boolean resizeParent = true;
    protected boolean moveParent = false;
    protected int parentBorder = 0;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 50.0;
    protected double interHierarchySpacing = 60.0;
    protected double parallelEdgeSpacing = 10.0;
    protected int orientation = 1;
    protected boolean disableEdgeStyle = true;
    protected boolean fineTuning = true;
    protected boolean traverseAncestors = true;
    protected mxGraphHierarchyModel model = null;

    public mxHierarchicalLayout(mxGraph mxGraph2) {
        this(mxGraph2, 1);
    }

    public mxHierarchicalLayout(mxGraph mxGraph2, int n) {
        super(mxGraph2);
        this.orientation = n;
    }

    public mxGraphHierarchyModel getModel() {
        return this.model;
    }

    @Override
    public void execute(Object object) {
        this.execute(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object object, List<Object> list) {
        super.execute(object);
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        if (list == null && object == null) {
            return;
        }
        if (list != null && object != null) {
            for (Object object2 : list) {
                if (mxIGraphModel2.isAncestor(object, object2)) continue;
                list.remove(object2);
            }
        }
        this.roots = list;
        mxIGraphModel2.beginUpdate();
        try {
            this.run(object);
            if (this.isResizeParent() && !this.graph.isCellCollapsed(object)) {
                this.graph.updateGroupBounds(new Object[]{object}, this.getParentBorder(), this.isMoveParent());
            }
        }
        finally {
            mxIGraphModel2.endUpdate();
        }
    }

    public List<Object> findRoots(Object object, Set<Object> set) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = null;
        int n = -100000;
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        for (Object object3 : set) {
            int n2;
            if (!mxIGraphModel2.isVertex(object3) || !this.graph.isCellVisible(object3)) continue;
            Object[] objectArray = this.getEdges(object3);
            int n3 = 0;
            int n4 = 0;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object4 = this.graph.getView().getVisibleTerminal(objectArray[n2], true);
                if (object4 == object3) {
                    ++n3;
                    continue;
                }
                ++n4;
            }
            if (n4 == 0 && n3 > 0) {
                arrayList.add(object3);
            }
            if ((n2 = n3 - n4) <= n) continue;
            n = n2;
            object2 = object3;
        }
        if (arrayList.isEmpty() && object2 != null) {
            arrayList.add(object2);
        }
        return arrayList;
    }

    public Object[] getEdges(Object object) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        boolean bl = this.graph.isCellCollapsed(object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = mxIGraphModel2.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Iterator iterator = mxIGraphModel2.getChildAt(object, i);
            if (!bl && this.graph.isCellVisible(iterator)) continue;
            arrayList.addAll(Arrays.asList(mxGraphModel.getEdges(mxIGraphModel2, iterator, true, true, false)));
        }
        arrayList.addAll(Arrays.asList(mxGraphModel.getEdges(mxIGraphModel2, object, true, true, false)));
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (Object e : arrayList) {
            Object object2;
            mxCellState mxCellState2 = this.graph.getView().getState(e);
            Object object3 = mxCellState2 != null ? mxCellState2.getVisibleTerminal(true) : this.graph.getView().getVisibleTerminal(e, true);
            if (object3 == (object2 = mxCellState2 != null ? mxCellState2.getVisibleTerminal(false) : this.graph.getView().getVisibleTerminal(e, false)) || (object2 != object || this.parent != null && !this.graph.isValidAncestor(object3, this.parent, this.traverseAncestors)) && (object3 != object || this.parent != null && !this.graph.isValidAncestor(object2, this.parent, this.traverseAncestors))) continue;
            arrayList2.add(e);
        }
        return arrayList2.toArray();
    }

    public void run(Object object) {
        SequencedCollection<Object> sequencedCollection;
        ArrayList<Set<Object>> arrayList = new ArrayList<Set<Object>>();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (this.roots == null && object != null) {
            Set<Object> set = this.filterDescendants(object);
            this.roots = new ArrayList<Object>();
            while (!set.isEmpty()) {
                sequencedCollection = this.findRoots(object, set);
                for (Object set2 : sequencedCollection) {
                    LinkedHashSet<Object> linkedHashSet2 = new LinkedHashSet<Object>();
                    arrayList.add(linkedHashSet2);
                    this.traverse(set2, true, null, linkedHashSet, linkedHashSet2, arrayList, set);
                }
                this.roots.addAll(sequencedCollection);
            }
        } else {
            for (int i = 0; i < this.roots.size(); ++i) {
                sequencedCollection = new LinkedHashSet();
                arrayList.add((Set<Object>)((Object)sequencedCollection));
                this.traverse(this.roots.get(i), true, null, (Set<Object>)linkedHashSet, (Set<Object>)((Object)sequencedCollection), (List<Set<Object>>)arrayList, null);
            }
        }
        double d = 0.0;
        for (Set set : arrayList) {
            this.model = new mxGraphHierarchyModel(this, set.toArray(), this.roots, object);
            this.cycleStage(object);
            this.layeringStage();
            this.crossingStage(object);
            d = this.placementStage(d, object);
        }
    }

    public Set<Object> filterDescendants(Object object) {
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (mxIGraphModel2.isVertex(object) && object != this.parent && this.graph.isCellVisible(object)) {
            linkedHashSet.add(object);
        }
        if (this.traverseAncestors || object == this.parent && this.graph.isCellVisible(object)) {
            int n = mxIGraphModel2.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = mxIGraphModel2.getChildAt(object, i);
                linkedHashSet.addAll(this.filterDescendants(object2));
            }
        }
        return linkedHashSet;
    }

    protected void traverse(Object object, boolean bl, Object object2, Set<Object> set, Set<Object> set2, List<Set<Object>> list, Set<Object> set3) {
        mxGraphView mxGraphView2 = this.graph.getView();
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        if (object != null && set != null) {
            if (!set.contains(object) && (set3 == null || set3.contains(object))) {
                int n;
                set2.add(object);
                set.add(object);
                if (set3 != null) {
                    set3.remove(object);
                }
                if ((n = mxIGraphModel2.getEdgeCount(object)) > 0) {
                    for (int i = 0; i < n; ++i) {
                        boolean bl2;
                        Object object3 = mxIGraphModel2.getEdgeAt(object, i);
                        boolean bl3 = bl2 = mxGraphView2.getVisibleTerminal(object3, true) == object;
                        if (bl && !bl2) continue;
                        Object object4 = mxGraphView2.getVisibleTerminal(object3, !bl2);
                        this.traverse(object4, bl, object3, set, set2, list, set3);
                    }
                }
            } else if (!set2.contains(object)) {
                Set<Object> set4 = null;
                for (Set<Object> set5 : list) {
                    if (!set5.contains(object)) continue;
                    set2.addAll(set5);
                    set4 = set5;
                    break;
                }
                if (set4 != null) {
                    list.remove(set4);
                }
            }
        }
    }

    public void cycleStage(Object object) {
        mxMinimumCycleRemover mxMinimumCycleRemover2 = new mxMinimumCycleRemover(this);
        mxMinimumCycleRemover2.execute(object);
    }

    public void layeringStage() {
        this.model.initialRank();
        this.model.fixRanks();
    }

    public void crossingStage(Object object) {
        mxMedianHybridCrossingReduction mxMedianHybridCrossingReduction2 = new mxMedianHybridCrossingReduction(this);
        mxMedianHybridCrossingReduction2.execute(object);
    }

    public double placementStage(double d, Object object) {
        mxCoordinateAssignment mxCoordinateAssignment2 = new mxCoordinateAssignment(this, this.intraCellSpacing, this.interRankCellSpacing, this.orientation, d, this.parallelEdgeSpacing);
        mxCoordinateAssignment2.setFineTuning(this.fineTuning);
        mxCoordinateAssignment2.execute(object);
        return mxCoordinateAssignment2.getLimitX() + this.interHierarchySpacing;
    }

    public boolean isResizeParent() {
        return this.resizeParent;
    }

    public void setResizeParent(boolean bl) {
        this.resizeParent = bl;
    }

    public boolean isMoveParent() {
        return this.moveParent;
    }

    public void setMoveParent(boolean bl) {
        this.moveParent = bl;
    }

    public int getParentBorder() {
        return this.parentBorder;
    }

    public void setParentBorder(int n) {
        this.parentBorder = n;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double d) {
        this.intraCellSpacing = d;
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double d) {
        this.interRankCellSpacing = d;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public double getInterHierarchySpacing() {
        return this.interHierarchySpacing;
    }

    public void setInterHierarchySpacing(double d) {
        this.interHierarchySpacing = d;
    }

    public double getParallelEdgeSpacing() {
        return this.parallelEdgeSpacing;
    }

    public void setParallelEdgeSpacing(double d) {
        this.parallelEdgeSpacing = d;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean bl) {
        this.fineTuning = bl;
    }

    public boolean isDisableEdgeStyle() {
        return this.disableEdgeStyle;
    }

    public void setDisableEdgeStyle(boolean bl) {
        this.disableEdgeStyle = bl;
    }

    public String toString() {
        return "Hierarchical";
    }
}

