/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io;

import com.mxgraph.io.mxCellCodec;
import com.mxgraph.io.mxChildChangeCodec;
import com.mxgraph.io.mxGenericChangeCodec;
import com.mxgraph.io.mxModelCodec;
import com.mxgraph.io.mxObjectCodec;
import com.mxgraph.io.mxRootChangeCodec;
import com.mxgraph.io.mxStylesheetCodec;
import com.mxgraph.io.mxTerminalChangeCodec;
import com.mxgraph.model.mxGraphModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class mxCodecRegistry {
    private static final Logger log = Logger.getLogger(mxCodecRegistry.class.getName());
    protected static Hashtable<String, mxObjectCodec> codecs = new Hashtable();
    protected static Hashtable<String, String> aliases = new Hashtable();
    protected static List<String> packages = new ArrayList<String>();

    public static mxObjectCodec register(mxObjectCodec mxObjectCodec2) {
        if (mxObjectCodec2 != null) {
            String string = mxObjectCodec2.getName();
            codecs.put(string, mxObjectCodec2);
            String string2 = mxCodecRegistry.getName(mxObjectCodec2.getTemplate());
            if (!string2.equals(string)) {
                mxCodecRegistry.addAlias(string2, string);
            }
        }
        return mxObjectCodec2;
    }

    public static void addAlias(String string, String string2) {
        aliases.put(string, string2);
    }

    public static mxObjectCodec getCodec(String string) {
        mxObjectCodec mxObjectCodec2;
        String string2 = aliases.get(string);
        if (string2 != null) {
            string = string2;
        }
        if ((mxObjectCodec2 = codecs.get(string)) == null) {
            Object object = mxCodecRegistry.getInstanceForName(string);
            if (object != null) {
                try {
                    mxObjectCodec2 = new mxObjectCodec(object);
                    mxCodecRegistry.register(mxObjectCodec2);
                }
                catch (Exception exception) {
                    log.log(Level.FINEST, "Failed to create and register a codec for the name: " + string, exception);
                }
            } else {
                log.log(Level.FINEST, "Failed to create codec for " + string);
            }
        }
        return mxObjectCodec2;
    }

    public static void addPackage(String string) {
        packages.add(string);
    }

    public static Object getInstanceForName(String string) {
        Class<?> clazz = mxCodecRegistry.getClassForName(string);
        if (clazz != null) {
            if (clazz.isEnum()) {
                return clazz.getEnumConstants()[0];
            }
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                log.log(Level.FINEST, "Failed to construct class instance for " + string, exception);
            }
        }
        log.log(Level.FINEST, "Failed to construct instance for " + string);
        return null;
    }

    public static Class<?> getClassForName(String string) {
        try {
            return Class.forName(string);
        }
        catch (Exception exception) {
            log.log(Level.FINEST, "Failed to get a class object for " + string, exception);
            for (int i = 0; i < packages.size(); ++i) {
                String string2 = packages.get(i);
                String string3 = string2 + "." + string;
                try {
                    return Class.forName(string3);
                }
                catch (Exception exception2) {
                    log.log(Level.FINEST, "Failed to get a class object for " + string3, exception2);
                    continue;
                }
            }
            log.log(Level.FINEST, "Class " + string + " not found");
            return null;
        }
    }

    public static String getName(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) {
            return "Array";
        }
        if (packages.contains(clazz.getPackage().getName())) {
            return clazz.getSimpleName();
        }
        return clazz.getName();
    }

    static {
        mxCodecRegistry.addPackage("com.mxgraph");
        mxCodecRegistry.addPackage("com.mxgraph.util");
        mxCodecRegistry.addPackage("com.mxgraph.model");
        mxCodecRegistry.addPackage("com.mxgraph.view");
        mxCodecRegistry.addPackage("java.lang");
        mxCodecRegistry.addPackage("java.util");
        mxCodecRegistry.register(new mxObjectCodec(new ArrayList()));
        mxCodecRegistry.register(new mxModelCodec());
        mxCodecRegistry.register(new mxCellCodec());
        mxCodecRegistry.register(new mxStylesheetCodec());
        mxCodecRegistry.register(new mxRootChangeCodec());
        mxCodecRegistry.register(new mxChildChangeCodec());
        mxCodecRegistry.register(new mxTerminalChangeCodec());
        mxCodecRegistry.register(new mxGenericChangeCodec(new mxGraphModel.mxValueChange(), "value"));
        mxCodecRegistry.register(new mxGenericChangeCodec(new mxGraphModel.mxStyleChange(), "style"));
        mxCodecRegistry.register(new mxGenericChangeCodec(new mxGraphModel.mxGeometryChange(), "geometry"));
        mxCodecRegistry.register(new mxGenericChangeCodec(new mxGraphModel.mxCollapseChange(), "collapsed"));
        mxCodecRegistry.register(new mxGenericChangeCodec(new mxGraphModel.mxVisibleChange(), "visible"));
    }
}

