/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxImageCanvas;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxICell;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEvent;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxImageBundle;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxResources;
import com.mxgraph.util.mxStyleUtils;
import com.mxgraph.util.mxUndoableEdit;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxConnectionConstraint;
import com.mxgraph.view.mxEdgeStyle;
import com.mxgraph.view.mxGraphSelectionModel;
import com.mxgraph.view.mxGraphView;
import com.mxgraph.view.mxMultiplicity;
import com.mxgraph.view.mxStylesheet;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxGraph
extends mxEventSource {
    private static final Logger log = Logger.getLogger(mxGraph.class.getName());
    public static final String VERSION = "3.9.11";
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected mxIGraphModel model;
    protected mxGraphView view;
    protected mxStylesheet stylesheet;
    protected mxGraphSelectionModel selectionModel;
    protected int gridSize = 10;
    protected boolean gridEnabled = true;
    protected boolean portsEnabled = true;
    protected double defaultOverlap = 0.5;
    protected Object defaultParent;
    protected String alternateEdgeStyle;
    protected boolean enabled = true;
    protected boolean cellsLocked = false;
    protected boolean cellsEditable = true;
    protected boolean cellsResizable = true;
    protected boolean cellsMovable = true;
    protected boolean cellsBendable = true;
    protected boolean cellsSelectable = true;
    protected boolean cellsDeletable = true;
    protected boolean cellsCloneable = true;
    protected boolean cellsDisconnectable = true;
    protected boolean labelsClipped = false;
    protected boolean edgeLabelsMovable = true;
    protected boolean vertexLabelsMovable = false;
    protected boolean dropEnabled = true;
    protected boolean splitEnabled = true;
    protected boolean autoSizeCells = false;
    protected mxRectangle maximumGraphBounds = null;
    protected mxRectangle minimumGraphSize = null;
    protected int border = 0;
    protected boolean keepEdgesInForeground = false;
    protected boolean keepEdgesInBackground = false;
    protected boolean collapseToPreferredSize = true;
    protected boolean allowNegativeCoordinates = true;
    protected boolean constrainChildren = true;
    protected boolean extendParents = true;
    protected boolean extendParentsOnAdd = true;
    protected boolean resetViewOnRootChange = true;
    protected boolean resetEdgesOnResize = false;
    protected boolean resetEdgesOnMove = false;
    protected boolean resetEdgesOnConnect = true;
    protected boolean allowLoops = false;
    protected mxMultiplicity[] multiplicities;
    protected mxEdgeStyle.mxEdgeStyleFunction defaultLoopStyle = mxEdgeStyle.Loop;
    protected boolean multigraph = true;
    protected boolean connectableEdges = false;
    protected boolean allowDanglingEdges = true;
    protected boolean cloneInvalidEdges = false;
    protected boolean disconnectOnMove = true;
    protected boolean labelsVisible = true;
    protected boolean htmlLabels = false;
    protected boolean swimlaneNesting = true;
    protected int changesRepaintThreshold = 1000;
    protected boolean autoOrigin = false;
    protected mxPoint origin = new mxPoint();
    protected static List<mxImageBundle> imageBundles;
    protected mxEventSource.mxIEventListener fullRepaintHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object object, mxEventObject mxEventObject2) {
            mxGraph.this.repaint();
        }
    };
    protected mxEventSource.mxIEventListener updateOriginHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object object, mxEventObject mxEventObject2) {
            if (mxGraph.this.isAutoOrigin()) {
                mxGraph.this.updateOrigin();
            }
        }
    };
    protected mxEventSource.mxIEventListener graphModelChangeHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object object, mxEventObject mxEventObject2) {
            mxRectangle mxRectangle2 = mxGraph.this.graphModelChanged((mxIGraphModel)object, ((mxUndoableEdit)mxEventObject2.getProperty("edit")).getChanges());
            mxGraph.this.repaint(mxRectangle2);
        }
    };

    public mxGraph() {
        this(null, null);
    }

    public mxGraph(mxIGraphModel mxIGraphModel2) {
        this(mxIGraphModel2, null);
    }

    public mxGraph(mxStylesheet mxStylesheet2) {
        this(null, mxStylesheet2);
    }

    public mxGraph(mxIGraphModel mxIGraphModel2, mxStylesheet mxStylesheet2) {
        this.selectionModel = this.createSelectionModel();
        this.setModel(mxIGraphModel2 != null ? mxIGraphModel2 : new mxGraphModel());
        this.setStylesheet(mxStylesheet2 != null ? mxStylesheet2 : this.createStylesheet());
        this.setView(this.createGraphView());
    }

    protected mxGraphSelectionModel createSelectionModel() {
        return new mxGraphSelectionModel(this);
    }

    protected mxStylesheet createStylesheet() {
        return new mxStylesheet();
    }

    protected mxGraphView createGraphView() {
        return new mxGraphView(this);
    }

    public mxIGraphModel getModel() {
        return this.model;
    }

    public void setModel(mxIGraphModel mxIGraphModel2) {
        if (this.model != null) {
            this.model.removeListener(this.graphModelChangeHandler);
        }
        mxIGraphModel mxIGraphModel3 = this.model;
        this.model = mxIGraphModel2;
        if (this.view != null) {
            this.view.revalidate();
        }
        this.model.addListener("change", this.graphModelChangeHandler);
        this.changeSupport.firePropertyChange("model", mxIGraphModel3, this.model);
        this.repaint();
    }

    public mxGraphView getView() {
        return this.view;
    }

    public void setView(mxGraphView mxGraphView2) {
        if (this.view != null) {
            this.view.removeListener(this.fullRepaintHandler);
            this.view.removeListener(this.updateOriginHandler);
        }
        mxGraphView mxGraphView3 = this.view;
        this.view = mxGraphView2;
        if (this.view != null) {
            this.view.revalidate();
        }
        this.view.addListener("scale", this.fullRepaintHandler);
        this.view.addListener("scale", this.updateOriginHandler);
        this.view.addListener("translate", this.fullRepaintHandler);
        this.view.addListener("scaleAndTranslate", this.fullRepaintHandler);
        this.view.addListener("scaleAndTranslate", this.updateOriginHandler);
        this.view.addListener("up", this.fullRepaintHandler);
        this.view.addListener("down", this.fullRepaintHandler);
        this.changeSupport.firePropertyChange("view", mxGraphView3, this.view);
    }

    public mxStylesheet getStylesheet() {
        return this.stylesheet;
    }

    public void setStylesheet(mxStylesheet mxStylesheet2) {
        mxStylesheet mxStylesheet3 = this.stylesheet;
        this.stylesheet = mxStylesheet2;
        this.changeSupport.firePropertyChange("stylesheet", mxStylesheet3, this.stylesheet);
    }

    public Object[] getSelectionCellsForChanges(List<mxUndoableEdit.mxUndoableChange> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (mxUndoableEdit.mxUndoableChange mxUndoableChange2 : list) {
            mxGraphModel.mxVisibleChange mxVisibleChange2;
            if (mxUndoableChange2 instanceof mxGraphModel.mxChildChange) {
                arrayList.add(((mxGraphModel.mxChildChange)mxUndoableChange2).getChild());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxTerminalChange) {
                arrayList.add(((mxGraphModel.mxTerminalChange)mxUndoableChange2).getCell());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxValueChange) {
                arrayList.add(((mxGraphModel.mxValueChange)mxUndoableChange2).getCell());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxStyleChange) {
                arrayList.add(((mxGraphModel.mxStyleChange)mxUndoableChange2).getCell());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxGeometryChange) {
                arrayList.add(((mxGraphModel.mxGeometryChange)mxUndoableChange2).getCell());
                continue;
            }
            if (mxUndoableChange2 instanceof mxGraphModel.mxCollapseChange) {
                arrayList.add(((mxGraphModel.mxCollapseChange)mxUndoableChange2).getCell());
                continue;
            }
            if (!(mxUndoableChange2 instanceof mxGraphModel.mxVisibleChange) || !(mxVisibleChange2 = (mxGraphModel.mxVisibleChange)mxUndoableChange2).isVisible()) continue;
            arrayList.add(((mxGraphModel.mxVisibleChange)mxUndoableChange2).getCell());
        }
        return mxGraphModel.getTopmostCells(this.model, arrayList.toArray());
    }

    public mxRectangle graphModelChanged(mxIGraphModel mxIGraphModel2, List<mxUndoableEdit.mxUndoableChange> list) {
        mxRectangle mxRectangle2;
        Object object;
        boolean bl;
        int n = this.getChangesRepaintThreshold();
        boolean bl2 = bl = n > 0 && list.size() > n;
        if (!bl) {
            object = list.iterator();
            while (object.hasNext()) {
                if (!(object.next() instanceof mxGraphModel.mxRootChange)) continue;
                bl = true;
                break;
            }
        }
        object = this.processChanges(list, true, bl);
        this.view.validate();
        if (this.isAutoOrigin()) {
            this.updateOrigin();
        }
        if (!bl && (mxRectangle2 = this.processChanges(list, false, bl)) != null) {
            if (object == null) {
                object = mxRectangle2;
            } else {
                ((mxRectangle)object).add(mxRectangle2);
            }
        }
        this.removeSelectionCells(this.getRemovedCellsForChanges(list));
        return object;
    }

    protected void updateOrigin() {
        mxRectangle mxRectangle2 = this.getGraphBounds();
        if (mxRectangle2 != null) {
            double d = this.getView().getScale();
            double d2 = mxRectangle2.getX() / d - (double)this.getBorder();
            double d3 = mxRectangle2.getY() / d - (double)this.getBorder();
            if (d2 < 0.0 || d3 < 0.0) {
                double d4 = Math.min(0.0, d2);
                double d5 = Math.min(0.0, d3);
                this.origin.setX(this.origin.getX() + d4);
                this.origin.setY(this.origin.getY() + d5);
                mxPoint mxPoint2 = this.getView().getTranslate();
                this.getView().setTranslate(new mxPoint(mxPoint2.getX() - d4, mxPoint2.getY() - d5));
            } else if ((d2 > 0.0 || d3 > 0.0) && (this.origin.getX() < 0.0 || this.origin.getY() < 0.0)) {
                double d6 = Math.min(-this.origin.getX(), d2);
                double d7 = Math.min(-this.origin.getY(), d3);
                this.origin.setX(this.origin.getX() + d6);
                this.origin.setY(this.origin.getY() + d7);
                mxPoint mxPoint3 = this.getView().getTranslate();
                this.getView().setTranslate(new mxPoint(mxPoint3.getX() - d6, mxPoint3.getY() - d7));
            }
        }
    }

    public Object[] getRemovedCellsForChanges(List<mxUndoableEdit.mxUndoableChange> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (mxUndoableEdit.mxUndoableChange mxUndoableChange2 : list) {
            Object object;
            if (mxUndoableChange2 instanceof mxGraphModel.mxRootChange) break;
            if (mxUndoableChange2 instanceof mxGraphModel.mxChildChange) {
                object = (mxGraphModel.mxChildChange)mxUndoableChange2;
                if (((mxGraphModel.mxChildChange)object).getParent() != null) continue;
                arrayList.addAll(mxGraphModel.getDescendants(this.model, ((mxGraphModel.mxChildChange)object).getChild()));
                continue;
            }
            if (!(mxUndoableChange2 instanceof mxGraphModel.mxVisibleChange)) continue;
            object = ((mxGraphModel.mxVisibleChange)mxUndoableChange2).getCell();
            arrayList.addAll(mxGraphModel.getDescendants(this.model, object));
        }
        return arrayList.toArray();
    }

    public mxRectangle processChanges(List<mxUndoableEdit.mxUndoableChange> list, boolean bl, boolean bl2) {
        mxRectangle mxRectangle2 = null;
        Iterator<mxUndoableEdit.mxUndoableChange> iterator = list.iterator();
        while (iterator.hasNext()) {
            mxRectangle mxRectangle3 = this.processChange(iterator.next(), bl, bl2);
            if (mxRectangle2 == null) {
                mxRectangle2 = mxRectangle3;
                continue;
            }
            mxRectangle2.add(mxRectangle3);
        }
        return mxRectangle2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public mxRectangle processChange(mxUndoableEdit.mxUndoableChange mxUndoableChange2, boolean bl, boolean bl2) {
        mxRectangle mxRectangle2 = null;
        if (mxUndoableChange2 instanceof mxGraphModel.mxRootChange) {
            mxRectangle mxRectangle3 = mxRectangle2 = bl2 ? null : this.getGraphBounds();
            if (bl) {
                this.clearSelection();
                this.removeStateForCell(((mxGraphModel.mxRootChange)mxUndoableChange2).getPrevious());
                if (this.isResetViewOnRootChange()) {
                    this.view.setEventsEnabled(false);
                    try {
                        this.view.scaleAndTranslate(1.0, 0.0, 0.0);
                    }
                    finally {
                        this.view.setEventsEnabled(true);
                    }
                }
            }
            this.fireEvent(new mxEventObject(mxEvent.ROOT));
        } else if (mxUndoableChange2 instanceof mxGraphModel.mxChildChange) {
            mxGraphModel.mxChildChange mxChildChange2 = (mxGraphModel.mxChildChange)mxUndoableChange2;
            if (!bl2) {
                if (mxChildChange2.getParent() != mxChildChange2.getPrevious()) {
                    if (this.model.isVertex(mxChildChange2.getParent()) || this.model.isEdge(mxChildChange2.getParent())) {
                        mxRectangle2 = this.getBoundingBox(mxChildChange2.getParent(), true, true);
                    }
                    if (this.model.isVertex(mxChildChange2.getPrevious()) || this.model.isEdge(mxChildChange2.getPrevious())) {
                        if (mxRectangle2 != null) {
                            mxRectangle2.add(this.getBoundingBox(mxChildChange2.getPrevious(), true, true));
                        } else {
                            mxRectangle2 = this.getBoundingBox(mxChildChange2.getPrevious(), true, true);
                        }
                    }
                }
                if (mxRectangle2 == null) {
                    mxRectangle2 = this.getBoundingBox(mxChildChange2.getChild(), true, true);
                }
            }
            if (bl) {
                if (mxChildChange2.getParent() != null) {
                    this.view.clear(mxChildChange2.getChild(), false, true);
                } else {
                    this.removeStateForCell(mxChildChange2.getChild());
                }
            }
        } else if (mxUndoableChange2 instanceof mxGraphModel.mxTerminalChange) {
            Object object = ((mxGraphModel.mxTerminalChange)mxUndoableChange2).getCell();
            if (!bl2) {
                mxRectangle2 = this.getBoundingBox(object, true);
            }
            if (bl) {
                this.view.invalidate(object);
            }
        } else if (mxUndoableChange2 instanceof mxGraphModel.mxValueChange) {
            Object object = ((mxGraphModel.mxValueChange)mxUndoableChange2).getCell();
            if (!bl2) {
                mxRectangle2 = this.getBoundingBox(object);
            }
            if (bl) {
                this.view.clear(object, false, false);
            }
        } else if (mxUndoableChange2 instanceof mxGraphModel.mxStyleChange) {
            Object object = ((mxGraphModel.mxStyleChange)mxUndoableChange2).getCell();
            if (!bl2) {
                mxRectangle2 = this.getBoundingBox(object, true);
            }
            if (bl) {
                this.view.clear(object, false, false);
                this.view.invalidate(object);
            }
        } else if (mxUndoableChange2 instanceof mxGraphModel.mxGeometryChange) {
            Object object = ((mxGraphModel.mxGeometryChange)mxUndoableChange2).getCell();
            if (!bl2) {
                mxRectangle2 = this.getBoundingBox(object, true, true);
            }
            if (bl) {
                this.view.invalidate(object);
            }
        } else if (mxUndoableChange2 instanceof mxGraphModel.mxCollapseChange) {
            Object object = ((mxGraphModel.mxCollapseChange)mxUndoableChange2).getCell();
            if (!bl2) {
                mxRectangle2 = this.getBoundingBox(((mxGraphModel.mxCollapseChange)mxUndoableChange2).getCell(), true, true);
            }
            if (bl) {
                this.removeStateForCell(object);
            }
        } else if (mxUndoableChange2 instanceof mxGraphModel.mxVisibleChange) {
            Object object = ((mxGraphModel.mxVisibleChange)mxUndoableChange2).getCell();
            if (!bl2) {
                mxRectangle2 = this.getBoundingBox(((mxGraphModel.mxVisibleChange)mxUndoableChange2).getCell(), true, true);
            }
            if (bl) {
                this.removeStateForCell(object);
            }
        }
        return mxRectangle2;
    }

    protected void removeStateForCell(Object object) {
        int n = this.model.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            this.removeStateForCell(this.model.getChildAt(object, i));
        }
        this.view.invalidate(object);
        this.view.removeState(object);
    }

    public Map<String, Object> getCellStyle(Object object) {
        Map<String, Object> map = this.model.isEdge(object) ? this.stylesheet.getDefaultEdgeStyle() : this.stylesheet.getDefaultVertexStyle();
        String string = this.model.getStyle(object);
        if (string != null) {
            map = this.postProcessCellStyle(this.stylesheet.getCellStyle(string, map));
        }
        if (map == null) {
            map = mxStylesheet.EMPTY_STYLE;
        }
        return map;
    }

    protected Map<String, Object> postProcessCellStyle(Map<String, Object> map) {
        if (map != null) {
            String string = mxUtils.getString(map, mxConstants.STYLE_IMAGE);
            String string2 = this.getImageFromBundles(string);
            if (string2 != null) {
                map.put(mxConstants.STYLE_IMAGE, string2);
            } else {
                string2 = string;
            }
            if (string2 != null && string2.startsWith("data:image/")) {
                int n = string2.indexOf(44);
                if (n > 0) {
                    string2 = string2.substring(0, n) + ";base64," + string2.substring(n + 1);
                }
                map.put(mxConstants.STYLE_IMAGE, string2);
            }
        }
        return map;
    }

    public Object[] setCellStyle(String string) {
        return this.setCellStyle(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] setCellStyle(String string, Object[] objectArray) {
        if (objectArray == null) {
            objectArray = this.getSelectionCells();
        }
        if (objectArray != null) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.model.setStyle(objectArray[i], string);
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
        return objectArray;
    }

    public Object toggleCellStyle(String string, boolean bl, Object object) {
        return this.toggleCellStyles(string, bl, new Object[]{object})[0];
    }

    public Object[] toggleCellStyles(String string, boolean bl) {
        return this.toggleCellStyles(string, bl, null);
    }

    public Object[] toggleCellStyles(String string, boolean bl, Object[] objectArray) {
        if (objectArray == null) {
            objectArray = this.getSelectionCells();
        }
        if (objectArray != null && objectArray.length > 0) {
            Map<String, Object> map;
            mxCellState mxCellState2 = this.view.getState(objectArray[0]);
            Map<String, Object> map2 = map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(objectArray[0]);
            if (map != null) {
                String string2 = mxUtils.isTrue(map, string, bl) ? "0" : "1";
                this.setCellStyles(string, string2, objectArray);
            }
        }
        return objectArray;
    }

    public Object[] setCellStyles(String string, String string2) {
        return this.setCellStyles(string, string2, null);
    }

    public Object[] setCellStyles(String string, String string2, Object[] objectArray) {
        if (objectArray == null) {
            objectArray = this.getSelectionCells();
        }
        mxStyleUtils.setCellStyles(this.model, objectArray, string, string2);
        return objectArray;
    }

    public Object[] toggleCellStyleFlags(String string, int n) {
        return this.toggleCellStyleFlags(string, n, null);
    }

    public Object[] toggleCellStyleFlags(String string, int n, Object[] objectArray) {
        return this.setCellStyleFlags(string, n, null, objectArray);
    }

    public Object[] setCellStyleFlags(String string, int n, boolean bl) {
        return this.setCellStyleFlags(string, n, bl, null);
    }

    public Object[] setCellStyleFlags(String string, int n, Boolean bl, Object[] objectArray) {
        if (objectArray == null) {
            objectArray = this.getSelectionCells();
        }
        if (objectArray != null && objectArray.length > 0) {
            if (bl == null) {
                Map<String, Object> map;
                mxCellState mxCellState2 = this.view.getState(objectArray[0]);
                Map<String, Object> map2 = map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(objectArray[0]);
                if (map != null) {
                    int n2 = mxUtils.getInt(map, string);
                    bl = (n2 & n) != n;
                }
            }
            mxStyleUtils.setCellStyleFlags(this.model, objectArray, string, n, bl);
        }
        return objectArray;
    }

    public void addImageBundle(mxImageBundle mxImageBundle2) {
        imageBundles.add(mxImageBundle2);
    }

    public void removeImageBundle(mxImageBundle mxImageBundle2) {
        imageBundles.remove(mxImageBundle2);
    }

    public String getImageFromBundles(String string) {
        if (string != null) {
            Iterator<mxImageBundle> iterator = imageBundles.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().getImage(string);
                if (string2 == null) continue;
                return string2;
            }
        }
        return null;
    }

    public List<mxImageBundle> getImageBundles() {
        return imageBundles;
    }

    public void getImageBundles(List<mxImageBundle> list) {
        imageBundles = list;
    }

    public Object[] alignCells(String string) {
        return this.alignCells(string, null);
    }

    public Object[] alignCells(String string, Object[] objectArray) {
        return this.alignCells(string, objectArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] alignCells(String string, Object[] objectArray, Object object) {
        if (objectArray == null) {
            objectArray = this.getSelectionCells();
        }
        if (objectArray != null && objectArray.length > 1) {
            if (object == null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    mxGeometry mxGeometry2 = this.getCellGeometry(objectArray[i]);
                    if (mxGeometry2 == null || this.model.isEdge(objectArray[i])) continue;
                    if (object == null) {
                        if (string == null || string.equals("left")) {
                            object = mxGeometry2.getX();
                            continue;
                        }
                        if (string.equals("center")) {
                            object = mxGeometry2.getX() + mxGeometry2.getWidth() / 2.0;
                            break;
                        }
                        if (string.equals("right")) {
                            object = mxGeometry2.getX() + mxGeometry2.getWidth();
                            continue;
                        }
                        if (string.equals("top")) {
                            object = mxGeometry2.getY();
                            continue;
                        }
                        if (string.equals("middle")) {
                            object = mxGeometry2.getY() + mxGeometry2.getHeight() / 2.0;
                            break;
                        }
                        if (!string.equals("bottom")) continue;
                        object = mxGeometry2.getY() + mxGeometry2.getHeight();
                        continue;
                    }
                    double d = Double.parseDouble(String.valueOf(object));
                    if (string == null || string.equals("left")) {
                        object = Math.min(d, mxGeometry2.getX());
                        continue;
                    }
                    if (string.equals("right")) {
                        object = Math.max(d, mxGeometry2.getX() + mxGeometry2.getWidth());
                        continue;
                    }
                    if (string.equals("top")) {
                        object = Math.min(d, mxGeometry2.getY());
                        continue;
                    }
                    if (!string.equals("bottom")) continue;
                    object = Math.max(d, mxGeometry2.getY() + mxGeometry2.getHeight());
                }
            }
            this.model.beginUpdate();
            try {
                double d = Double.parseDouble(String.valueOf(object));
                for (int i = 0; i < objectArray.length; ++i) {
                    mxGeometry mxGeometry3 = this.getCellGeometry(objectArray[i]);
                    if (mxGeometry3 == null || this.model.isEdge(objectArray[i])) continue;
                    mxGeometry3 = (mxGeometry)mxGeometry3.clone();
                    if (string == null || string.equals("left")) {
                        mxGeometry3.setX(d);
                    } else if (string.equals("center")) {
                        mxGeometry3.setX(d - mxGeometry3.getWidth() / 2.0);
                    } else if (string.equals("right")) {
                        mxGeometry3.setX(d - mxGeometry3.getWidth());
                    } else if (string.equals("top")) {
                        mxGeometry3.setY(d);
                    } else if (string.equals("middle")) {
                        mxGeometry3.setY(d - mxGeometry3.getHeight() / 2.0);
                    } else if (string.equals("bottom")) {
                        mxGeometry3.setY(d - mxGeometry3.getHeight());
                    }
                    this.model.setGeometry(objectArray[i], mxGeometry3);
                    if (!this.isResetEdgesOnMove()) continue;
                    this.resetEdges(new Object[]{objectArray[i]});
                }
                this.fireEvent(new mxEventObject("alignCells", "cells", objectArray, "align", string));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return objectArray;
    }

    public Object flipEdge(Object object) {
        if (object != null && this.alternateEdgeStyle != null) {
            this.model.beginUpdate();
            try {
                String string = this.model.getStyle(object);
                if (string == null || string.length() == 0) {
                    this.model.setStyle(object, this.alternateEdgeStyle);
                } else {
                    this.model.setStyle(object, null);
                }
                this.resetEdge(object);
                this.fireEvent(new mxEventObject("flipEdge", "edge", object));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return object;
    }

    public Object[] orderCells(boolean bl) {
        return this.orderCells(bl, null);
    }

    public Object[] orderCells(boolean bl, Object[] objectArray) {
        if (objectArray == null) {
            objectArray = mxUtils.sortCells(this.getSelectionCells(), true);
        }
        this.model.beginUpdate();
        try {
            this.cellsOrdered(objectArray, bl);
            this.fireEvent(new mxEventObject("orderCells", "cells", objectArray, "back", bl));
        }
        finally {
            this.model.endUpdate();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsOrdered(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = this.model.getParent(objectArray[i]);
                    if (bl) {
                        this.model.add(object, objectArray[i], i);
                        continue;
                    }
                    this.model.add(object, objectArray[i], this.model.getChildCount(object) - 1);
                }
                this.fireEvent(new mxEventObject("cellsOrdered", "cells", objectArray, "back", bl));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object groupCells() {
        return this.groupCells(null);
    }

    public Object groupCells(Object object) {
        return this.groupCells(object, 0.0);
    }

    public Object groupCells(Object object, double d) {
        return this.groupCells(object, d, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object groupCells(Object object, double d, Object[] objectArray) {
        if (objectArray == null) {
            objectArray = mxUtils.sortCells(this.getSelectionCells(), true);
        }
        objectArray = this.getCellsForGroup(objectArray);
        if (object == null) {
            object = this.createGroupCell(objectArray);
        }
        mxRectangle mxRectangle2 = this.getBoundsForGroup(object, objectArray, d);
        if (objectArray.length > 0 && mxRectangle2 != null) {
            Object object2 = this.model.getParent(object);
            if (object2 == null) {
                object2 = this.model.getParent(objectArray[0]);
            }
            this.model.beginUpdate();
            try {
                if (this.getCellGeometry(object) == null) {
                    this.model.setGeometry(object, new mxGeometry());
                }
                int n = this.model.getChildCount(object);
                this.cellsAdded(objectArray, object, n, null, null, false);
                this.cellsMoved(objectArray, -mxRectangle2.getX(), -mxRectangle2.getY(), false, true);
                n = this.model.getChildCount(object2);
                this.cellsAdded(new Object[]{object}, object2, n, null, null, false, false);
                this.cellsResized(new Object[]{object}, new mxRectangle[]{mxRectangle2});
                this.fireEvent(new mxEventObject("groupCells", "group", object, "cells", objectArray, "border", d));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return object;
    }

    public Object[] getCellsForGroup(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        if (objectArray.length > 0) {
            Object object = this.model.getParent(objectArray[0]);
            arrayList.add(objectArray[0]);
            for (int i = 1; i < objectArray.length; ++i) {
                if (this.model.getParent(objectArray[i]) != object) continue;
                arrayList.add(objectArray[i]);
            }
        }
        return arrayList.toArray();
    }

    public mxRectangle getBoundsForGroup(Object object, Object[] objectArray, double d) {
        mxRectangle mxRectangle2 = this.getBoundingBoxFromGeometry(objectArray);
        if (mxRectangle2 != null) {
            if (this.isSwimlane(object)) {
                mxRectangle mxRectangle3 = this.getStartSize(object);
                mxRectangle2.setX(mxRectangle2.getX() - mxRectangle3.getWidth());
                mxRectangle2.setY(mxRectangle2.getY() - mxRectangle3.getHeight());
                mxRectangle2.setWidth(mxRectangle2.getWidth() + mxRectangle3.getWidth());
                mxRectangle2.setHeight(mxRectangle2.getHeight() + mxRectangle3.getHeight());
            }
            mxRectangle2.setX(mxRectangle2.getX() - d);
            mxRectangle2.setY(mxRectangle2.getY() - d);
            mxRectangle2.setWidth(mxRectangle2.getWidth() + 2.0 * d);
            mxRectangle2.setHeight(mxRectangle2.getHeight() + 2.0 * d);
        }
        return mxRectangle2;
    }

    public Object createGroupCell(Object[] objectArray) {
        mxCell mxCell2 = new mxCell("", new mxGeometry(), null);
        mxCell2.setVertex(true);
        mxCell2.setConnectable(false);
        return mxCell2;
    }

    public Object[] ungroupCells() {
        return this.ungroupCells(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] ungroupCells(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray == null) {
            objectArray = this.getSelectionCells();
            ArrayList<Object> arrayList2 = new ArrayList<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.model.getChildCount(objectArray[i]) <= 0) continue;
                arrayList2.add(objectArray[i]);
            }
            objectArray = arrayList2.toArray();
        }
        if (objectArray != null && objectArray.length > 0) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object[] objectArray2 = mxGraphModel.getChildren(this.model, objectArray[i]);
                    if (objectArray2 == null || objectArray2.length <= 0) continue;
                    Object object = this.model.getParent(objectArray[i]);
                    int n = this.model.getChildCount(object);
                    this.cellsAdded(objectArray2, object, n, null, null, true);
                    arrayList.addAll(Arrays.asList(objectArray2));
                }
                this.cellsRemoved(this.addAllEdges(objectArray));
                this.fireEvent(new mxEventObject("ungroupCells", "cells", objectArray));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return arrayList.toArray();
    }

    public Object[] removeCellsFromParent() {
        return this.removeCellsFromParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] removeCellsFromParent(Object[] objectArray) {
        if (objectArray == null) {
            objectArray = this.getSelectionCells();
        }
        this.model.beginUpdate();
        try {
            Object object = this.getDefaultParent();
            int n = this.model.getChildCount(object);
            this.cellsAdded(objectArray, object, n, null, null, true);
            this.fireEvent(new mxEventObject("removeCellsFromParent", "cells", objectArray));
        }
        finally {
            this.model.endUpdate();
        }
        return objectArray;
    }

    public Object[] updateGroupBounds() {
        return this.updateGroupBounds(null);
    }

    public Object[] updateGroupBounds(Object[] objectArray) {
        return this.updateGroupBounds(objectArray, 0);
    }

    public Object[] updateGroupBounds(Object[] objectArray, int n) {
        return this.updateGroupBounds(objectArray, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] updateGroupBounds(Object[] objectArray, int n, boolean bl) {
        if (objectArray == null) {
            objectArray = this.getSelectionCells();
        }
        this.model.beginUpdate();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                mxRectangle mxRectangle2;
                Object[] objectArray2;
                mxGeometry mxGeometry2 = this.getCellGeometry(objectArray[i]);
                if (mxGeometry2 == null || (objectArray2 = this.getChildCells(objectArray[i])) == null || objectArray2.length <= 0 || !((mxRectangle2 = this.getBoundingBoxFromGeometry(objectArray2)).getWidth() > 0.0) || !(mxRectangle2.getHeight() > 0.0)) continue;
                mxRectangle mxRectangle3 = this.isSwimlane(objectArray[i]) ? this.getStartSize(objectArray[i]) : new mxRectangle();
                mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                if (bl) {
                    mxGeometry2.setX(mxGeometry2.getX() + mxRectangle2.getX() - mxRectangle3.getWidth() - (double)n);
                    mxGeometry2.setY(mxGeometry2.getY() + mxRectangle2.getY() - mxRectangle3.getHeight() - (double)n);
                }
                mxGeometry2.setWidth(mxRectangle2.getWidth() + mxRectangle3.getWidth() + (double)(2 * n));
                mxGeometry2.setHeight(mxRectangle2.getHeight() + mxRectangle3.getHeight() + (double)(2 * n));
                this.model.setGeometry(objectArray[i], mxGeometry2);
                this.moveCells(objectArray2, -mxRectangle2.getX() + mxRectangle3.getWidth() + (double)n, -mxRectangle2.getY() + mxRectangle3.getHeight() + (double)n);
            }
        }
        finally {
            this.model.endUpdate();
        }
        return objectArray;
    }

    public Object[] cloneCells(Object[] objectArray) {
        return this.cloneCells(objectArray, true);
    }

    public Object[] cloneCells(Object[] objectArray, boolean bl) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(objectArray.length);
            linkedHashSet.addAll(Arrays.asList(objectArray));
            if (!linkedHashSet.isEmpty()) {
                double d = this.view.getScale();
                mxPoint mxPoint2 = this.view.getTranslate();
                objectArray2 = this.model.cloneCells(objectArray, true);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!bl && this.model.isEdge(objectArray2[i]) && this.getEdgeValidationError(objectArray2[i], this.model.getTerminal(objectArray2[i], true), this.model.getTerminal(objectArray2[i], false)) != null) {
                        objectArray2[i] = null;
                        continue;
                    }
                    mxGeometry mxGeometry2 = this.model.getGeometry(objectArray2[i]);
                    if (mxGeometry2 == null) continue;
                    mxCellState mxCellState2 = this.view.getState(objectArray[i]);
                    mxCellState mxCellState3 = this.view.getState(this.model.getParent(objectArray[i]));
                    if (mxCellState2 == null || mxCellState3 == null) continue;
                    double d2 = mxCellState3.getOrigin().getX();
                    double d3 = mxCellState3.getOrigin().getY();
                    if (this.model.isEdge(objectArray2[i])) {
                        Object object;
                        Object object2;
                        Object object3 = this.model.getTerminal(objectArray[i], true);
                        while (object3 != null && !linkedHashSet.contains(object3)) {
                            object3 = this.model.getParent(object3);
                        }
                        if (object3 == null) {
                            object2 = mxCellState2.getAbsolutePoint(0);
                            mxGeometry2.setTerminalPoint(new mxPoint(((mxPoint)object2).getX() / d - mxPoint2.getX(), ((mxPoint)object2).getY() / d - mxPoint2.getY()), true);
                        }
                        object2 = this.model.getTerminal(objectArray[i], false);
                        while (object2 != null && !linkedHashSet.contains(object2)) {
                            object2 = this.model.getParent(object2);
                        }
                        if (object2 == null) {
                            object = mxCellState2.getAbsolutePoint(mxCellState2.getAbsolutePointCount() - 1);
                            mxGeometry2.setTerminalPoint(new mxPoint(((mxPoint)object).getX() / d - mxPoint2.getX(), ((mxPoint)object).getY() / d - mxPoint2.getY()), false);
                        }
                        if ((object = mxGeometry2.getPoints()) == null) continue;
                        Iterator<mxPoint> iterator = object.iterator();
                        while (iterator.hasNext()) {
                            mxPoint mxPoint3 = iterator.next();
                            mxPoint3.setX(mxPoint3.getX() + d2);
                            mxPoint3.setY(mxPoint3.getY() + d3);
                        }
                        continue;
                    }
                    mxGeometry2.setX(mxGeometry2.getX() + d2);
                    mxGeometry2.setY(mxGeometry2.getY() + d3);
                }
            } else {
                objectArray2 = new Object[]{};
            }
        }
        return objectArray2;
    }

    public Object insertVertex(Object object, String string, Object object2, double d, double d2, double d3, double d4) {
        return this.insertVertex(object, string, object2, d, d2, d3, d4, null);
    }

    public Object insertVertex(Object object, String string, Object object2, double d, double d2, double d3, double d4, String string2) {
        return this.insertVertex(object, string, object2, d, d2, d3, d4, string2, false);
    }

    public Object insertVertex(Object object, String string, Object object2, double d, double d2, double d3, double d4, String string2, boolean bl) {
        Object object3 = this.createVertex(object, string, object2, d, d2, d3, d4, string2, bl);
        return this.addCell(object3, object);
    }

    public Object createVertex(Object object, String string, Object object2, double d, double d2, double d3, double d4, String string2) {
        return this.createVertex(object, string, object2, d, d2, d3, d4, string2, false);
    }

    public Object createVertex(Object object, String string, Object object2, double d, double d2, double d3, double d4, String string2, boolean bl) {
        mxGeometry mxGeometry2 = new mxGeometry(d, d2, d3, d4);
        mxGeometry2.setRelative(bl);
        mxCell mxCell2 = new mxCell(object2, mxGeometry2, string2);
        mxCell2.setId(string);
        mxCell2.setVertex(true);
        mxCell2.setConnectable(true);
        return mxCell2;
    }

    public Object insertEdge(Object object, String string, Object object2, Object object3, Object object4) {
        return this.insertEdge(object, string, object2, object3, object4, null);
    }

    public Object insertEdge(Object object, String string, Object object2, Object object3, Object object4, String string2) {
        Object object5 = this.createEdge(object, string, object2, object3, object4, string2);
        return this.addEdge(object5, object, object3, object4, null);
    }

    public Object createEdge(Object object, String string, Object object2, Object object3, Object object4, String string2) {
        mxCell mxCell2 = new mxCell(object2, new mxGeometry(), string2);
        mxCell2.setId(string);
        mxCell2.setEdge(true);
        mxCell2.getGeometry().setRelative(true);
        return mxCell2;
    }

    public Object addEdge(Object object, Object object2, Object object3, Object object4, Integer n) {
        return this.addCell(object, object2, n, object3, object4);
    }

    public Object addCell(Object object) {
        return this.addCell(object, null);
    }

    public Object addCell(Object object, Object object2) {
        return this.addCell(object, object2, null, null, null);
    }

    public Object addCell(Object object, Object object2, Integer n, Object object3, Object object4) {
        return this.addCells(new Object[]{object}, object2, n, object3, object4)[0];
    }

    public Object[] addCells(Object[] objectArray) {
        return this.addCells(objectArray, null);
    }

    public Object[] addCells(Object[] objectArray, Object object) {
        return this.addCells(objectArray, object, null);
    }

    public Object[] addCells(Object[] objectArray, Object object, Integer n) {
        return this.addCells(objectArray, object, n, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] addCells(Object[] objectArray, Object object, Integer n, Object object2, Object object3) {
        if (object == null) {
            object = this.getDefaultParent();
        }
        if (n == null) {
            n = this.model.getChildCount(object);
        }
        this.model.beginUpdate();
        try {
            this.cellsAdded(objectArray, object, n, object2, object3, false, true);
            this.fireEvent(new mxEventObject("addCells", "cells", objectArray, "parent", object, "index", n, "source", object2, "target", object3));
        }
        finally {
            this.model.endUpdate();
        }
        return objectArray;
    }

    public void cellsAdded(Object[] objectArray, Object object, Integer n, Object object2, Object object3, boolean bl) {
        this.cellsAdded(objectArray, object, n, object2, object3, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsAdded(Object[] objectArray, Object object, Integer n, Object object2, Object object3, boolean bl, boolean bl2) {
        if (objectArray != null && object != null && n != null) {
            this.model.beginUpdate();
            try {
                mxCellState mxCellState2 = bl ? this.view.getState(object) : null;
                mxPoint mxPoint2 = mxCellState2 != null ? mxCellState2.getOrigin() : null;
                mxPoint mxPoint3 = new mxPoint(0.0, 0.0);
                for (int i = 0; i < objectArray.length; ++i) {
                    Serializable serializable;
                    Serializable serializable2;
                    Object object4;
                    if (objectArray[i] == null) {
                        object4 = n;
                        n = n - 1;
                        serializable2 = n;
                        continue;
                    }
                    object4 = this.model.getParent(objectArray[i]);
                    if (mxPoint2 != null && objectArray[i] != object && object != object4) {
                        serializable2 = this.view.getState(object4);
                        serializable = serializable2 != null ? ((mxCellState)serializable2).getOrigin() : mxPoint3;
                        mxGeometry mxGeometry2 = this.model.getGeometry(objectArray[i]);
                        if (mxGeometry2 != null) {
                            double d = ((mxPoint)serializable).getX() - mxPoint2.getX();
                            double d2 = ((mxPoint)serializable).getY() - mxPoint2.getY();
                            mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                            mxGeometry2.translate(d, d2);
                            if (!mxGeometry2.isRelative() && this.model.isVertex(objectArray[i]) && !this.isAllowNegativeCoordinates()) {
                                mxGeometry2.setX(Math.max(0.0, mxGeometry2.getX()));
                                mxGeometry2.setY(Math.max(0.0, mxGeometry2.getY()));
                            }
                            this.model.setGeometry(objectArray[i], mxGeometry2);
                        }
                    }
                    if (object == object4) {
                        serializable2 = n;
                        n = n - 1;
                        serializable = n;
                    }
                    this.model.add(object, objectArray[i], n + i);
                    if (this.isExtendParentsOnAdd() && this.isExtendParent(objectArray[i])) {
                        this.extendParent(objectArray[i]);
                    }
                    if (bl2) {
                        this.constrainChild(objectArray[i]);
                    }
                    if (object2 != null) {
                        this.cellConnected(objectArray[i], object2, true, null);
                    }
                    if (object3 == null) continue;
                    this.cellConnected(objectArray[i], object3, false, null);
                }
                this.fireEvent(new mxEventObject("cellsAdded", "cells", objectArray, "parent", object, "index", n, "source", object2, "target", object3, "absolute", bl));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object[] removeCells() {
        return this.removeCells(null);
    }

    public Object[] removeCells(Object[] objectArray) {
        return this.removeCells(objectArray, true);
    }

    public Object[] removeCells(Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            objectArray = this.getDeletableCells(this.getSelectionCells());
        }
        if (bl) {
            objectArray = this.getDeletableCells(this.addAllEdges(objectArray));
        }
        this.model.beginUpdate();
        try {
            this.cellsRemoved(objectArray);
            this.fireEvent(new mxEventObject("removeCells", "cells", objectArray, "includeEdges", bl));
        }
        finally {
            this.model.endUpdate();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsRemoved(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            double d = this.view.getScale();
            mxPoint mxPoint2 = this.view.getTranslate();
            this.model.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    HashSet<Object> hashSet = new HashSet<Object>();
                    hashSet.addAll(Arrays.asList(objectArray));
                    Object[] objectArray2 = this.getConnections(objectArray[i]);
                    for (int j = 0; j < objectArray2.length; ++j) {
                        mxCellState mxCellState2;
                        mxGeometry mxGeometry2;
                        if (hashSet.contains(objectArray2[j]) || (mxGeometry2 = this.model.getGeometry(objectArray2[j])) == null || (mxCellState2 = this.view.getState(objectArray2[j])) == null) continue;
                        Object object = mxCellState2.getVisibleTerminal(true);
                        boolean bl = false;
                        while (object != null) {
                            if (objectArray[i] == object) {
                                bl = true;
                                break;
                            }
                            object = this.model.getParent(object);
                        }
                        mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                        int n = bl ? 0 : mxCellState2.getAbsolutePointCount() - 1;
                        mxPoint mxPoint3 = mxCellState2.getAbsolutePoint(n);
                        mxGeometry2.setTerminalPoint(new mxPoint(mxPoint3.getX() / d - mxPoint2.getX(), mxPoint3.getY() / d - mxPoint2.getY()), bl);
                        this.model.setTerminal(objectArray2[j], null, bl);
                        this.model.setGeometry(objectArray2[j], mxGeometry2);
                    }
                    this.model.remove(objectArray[i]);
                }
                this.fireEvent(new mxEventObject("cellsRemoved", "cells", objectArray));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object splitEdge(Object object, Object[] objectArray) {
        return this.splitEdge(object, objectArray, null, 0.0, 0.0);
    }

    public Object splitEdge(Object object, Object[] objectArray, double d, double d2) {
        return this.splitEdge(object, objectArray, null, d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object splitEdge(Object object, Object[] objectArray, Object object2, double d, double d2) {
        if (object2 == null) {
            object2 = this.cloneCells(new Object[]{object})[0];
        }
        Object object3 = this.model.getParent(object);
        Object object4 = this.model.getTerminal(object, true);
        this.model.beginUpdate();
        try {
            this.cellsMoved(objectArray, d, d2, false, false);
            this.cellsAdded(objectArray, object3, this.model.getChildCount(object3), null, null, true);
            this.cellsAdded(new Object[]{object2}, object3, this.model.getChildCount(object3), object4, objectArray[0], false);
            this.cellConnected(object, objectArray[0], true, null);
            this.fireEvent(new mxEventObject("splitEdge", "edge", object, "cells", objectArray, "newEdge", object2, "dx", d, "dy", d2));
        }
        finally {
            this.model.endUpdate();
        }
        return object2;
    }

    public Object[] toggleCells(boolean bl) {
        return this.toggleCells(bl, null);
    }

    public Object[] toggleCells(boolean bl, Object[] objectArray) {
        return this.toggleCells(bl, objectArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toggleCells(boolean bl, Object[] objectArray, boolean bl2) {
        if (objectArray == null) {
            objectArray = this.getSelectionCells();
        }
        if (bl2) {
            objectArray = this.addAllEdges(objectArray);
        }
        this.model.beginUpdate();
        try {
            this.cellsToggled(objectArray, bl);
            this.fireEvent(new mxEventObject("toggleCells", "show", bl, "cells", objectArray, "includeEdges", bl2));
        }
        finally {
            this.model.endUpdate();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsToggled(Object[] objectArray, boolean bl) {
        if (objectArray != null && objectArray.length > 0) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    this.model.setVisible(objectArray[i], bl);
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object[] foldCells(boolean bl) {
        return this.foldCells(bl, false);
    }

    public Object[] foldCells(boolean bl, boolean bl2) {
        return this.foldCells(bl, bl2, null);
    }

    public Object[] foldCells(boolean bl, boolean bl2, Object[] objectArray) {
        return this.foldCells(bl, bl2, objectArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] foldCells(boolean bl, boolean bl2, Object[] objectArray, boolean bl3) {
        if (objectArray == null) {
            objectArray = this.getFoldableCells(this.getSelectionCells(), bl);
        }
        this.model.beginUpdate();
        try {
            this.cellsFolded(objectArray, bl, bl2, bl3);
            this.fireEvent(new mxEventObject("foldCells", "cells", objectArray, "collapse", bl, "recurse", bl2));
        }
        finally {
            this.model.endUpdate();
        }
        return objectArray;
    }

    public void cellsFolded(Object[] objectArray, boolean bl, boolean bl2) {
        this.cellsFolded(objectArray, bl, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsFolded(Object[] objectArray, boolean bl, boolean bl2, boolean bl3) {
        if (objectArray != null && objectArray.length > 0) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (bl3 && !this.isCellFoldable(objectArray[i], bl) || bl == this.isCellCollapsed(objectArray[i])) continue;
                    this.model.setCollapsed(objectArray[i], bl);
                    this.swapBounds(objectArray[i], bl);
                    if (this.isExtendParent(objectArray[i])) {
                        this.extendParent(objectArray[i]);
                    }
                    if (!bl2) continue;
                    Object[] objectArray2 = mxGraphModel.getChildren(this.model, objectArray[i]);
                    this.cellsFolded(objectArray2, bl, bl2);
                }
                this.fireEvent(new mxEventObject("cellsFolded", "cells", objectArray, "collapse", bl, "recurse", bl2));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public void swapBounds(Object object, boolean bl) {
        mxGeometry mxGeometry2;
        if (object != null && (mxGeometry2 = this.model.getGeometry(object)) != null) {
            mxGeometry2 = (mxGeometry)mxGeometry2.clone();
            this.updateAlternateBounds(object, mxGeometry2, bl);
            mxGeometry2.swap();
            this.model.setGeometry(object, mxGeometry2);
        }
    }

    public void updateAlternateBounds(Object object, mxGeometry mxGeometry2, boolean bl) {
        if (object != null && mxGeometry2 != null) {
            if (mxGeometry2.getAlternateBounds() == null) {
                mxRectangle mxRectangle2 = null;
                if (this.isCollapseToPreferredSize()) {
                    mxRectangle2 = this.getPreferredSizeForCell(object);
                    if (this.isSwimlane(object)) {
                        mxRectangle mxRectangle3 = this.getStartSize(object);
                        mxRectangle2.setHeight(Math.max(mxRectangle2.getHeight(), mxRectangle3.getHeight()));
                        mxRectangle2.setWidth(Math.max(mxRectangle2.getWidth(), mxRectangle3.getWidth()));
                    }
                }
                if (mxRectangle2 == null) {
                    mxRectangle2 = mxGeometry2;
                }
                mxGeometry2.setAlternateBounds(new mxRectangle(mxGeometry2.getX(), mxGeometry2.getY(), mxRectangle2.getWidth(), mxRectangle2.getHeight()));
            } else {
                mxGeometry2.getAlternateBounds().setX(mxGeometry2.getX());
                mxGeometry2.getAlternateBounds().setY(mxGeometry2.getY());
            }
        }
    }

    public Object[] addAllEdges(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        arrayList.addAll(Arrays.asList(objectArray));
        arrayList.addAll(Arrays.asList(this.getAllEdges(objectArray)));
        return arrayList.toArray();
    }

    public Object[] getAllEdges(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                int n = this.model.getEdgeCount(objectArray[i]);
                for (int j = 0; j < n; ++j) {
                    arrayList.add(this.model.getEdgeAt(objectArray[i], j));
                }
                Object[] objectArray2 = mxGraphModel.getChildren(this.model, objectArray[i]);
                arrayList.addAll(Arrays.asList(this.getAllEdges(objectArray2)));
            }
        }
        return arrayList.toArray();
    }

    public Object updateCellSize(Object object) {
        return this.updateCellSize(object, false);
    }

    public Object updateCellSize(Object object, boolean bl) {
        this.model.beginUpdate();
        try {
            this.cellSizeUpdated(object, bl);
            this.fireEvent(new mxEventObject("updateCellSize", "cell", object, "ignoreChildren", bl));
        }
        finally {
            this.model.endUpdate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellSizeUpdated(Object object, boolean bl) {
        if (object != null) {
            this.model.beginUpdate();
            try {
                mxRectangle mxRectangle2 = this.getPreferredSizeForCell(object);
                mxGeometry mxGeometry2 = this.model.getGeometry(object);
                if (mxRectangle2 != null && mxGeometry2 != null) {
                    Object object2;
                    mxRectangle mxRectangle3;
                    boolean bl2 = this.isCellCollapsed(object);
                    mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                    if (this.isSwimlane(object)) {
                        mxRectangle3 = this.view.getState(object);
                        object2 = mxRectangle3 != null ? ((mxCellState)mxRectangle3).getStyle() : this.getCellStyle(object);
                        String string = this.model.getStyle(object);
                        if (string == null) {
                            string = "";
                        }
                        if (mxUtils.isTrue(object2, mxConstants.STYLE_HORIZONTAL, true)) {
                            string = mxStyleUtils.setStyle(string, mxConstants.STYLE_STARTSIZE, String.valueOf(mxRectangle2.getHeight() + 8.0));
                            if (bl2) {
                                mxGeometry2.setHeight(mxRectangle2.getHeight() + 8.0);
                            }
                            mxGeometry2.setWidth(mxRectangle2.getWidth());
                        } else {
                            string = mxStyleUtils.setStyle(string, mxConstants.STYLE_STARTSIZE, String.valueOf(mxRectangle2.getWidth() + 8.0));
                            if (bl2) {
                                mxGeometry2.setWidth(mxRectangle2.getWidth() + 8.0);
                            }
                            mxGeometry2.setHeight(mxRectangle2.getHeight());
                        }
                        this.model.setStyle(object, string);
                    } else {
                        mxGeometry2.setWidth(mxRectangle2.getWidth());
                        mxGeometry2.setHeight(mxRectangle2.getHeight());
                    }
                    if (!bl && !bl2 && (mxRectangle3 = this.view.getBounds(mxGraphModel.getChildren(this.model, object))) != null) {
                        object2 = this.view.getTranslate();
                        double d = this.view.getScale();
                        double d2 = (mxRectangle3.getX() + mxRectangle3.getWidth()) / d - mxGeometry2.getX() - ((mxPoint)object2).getX();
                        double d3 = (mxRectangle3.getY() + mxRectangle3.getHeight()) / d - mxGeometry2.getY() - ((mxPoint)object2).getY();
                        mxGeometry2.setWidth(Math.max(mxGeometry2.getWidth(), d2));
                        mxGeometry2.setHeight(Math.max(mxGeometry2.getHeight(), d3));
                    }
                    this.cellsResized(new Object[]{object}, new mxRectangle[]{mxGeometry2});
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public mxRectangle getPreferredSizeForCell(Object object) {
        mxRectangle mxRectangle2 = null;
        if (object != null) {
            Map<String, Object> map;
            mxCellState mxCellState2 = this.view.getState(object);
            Map<String, Object> map2 = map = mxCellState2 != null ? mxCellState2.style : this.getCellStyle(object);
            if (map != null && !this.model.isEdge(object)) {
                double d = 0.0;
                double d2 = 0.0;
                if ((this.getImage(mxCellState2) != null || mxUtils.getString(map, mxConstants.STYLE_IMAGE) != null) && mxUtils.getString(map, mxConstants.STYLE_SHAPE, "").equals("label")) {
                    if (mxUtils.getString(map, mxConstants.STYLE_VERTICAL_ALIGN, "").equals("middle")) {
                        d += mxUtils.getDouble(map, mxConstants.STYLE_IMAGE_WIDTH, mxConstants.DEFAULT_IMAGESIZE);
                    }
                    if (mxUtils.getString(map, mxConstants.STYLE_ALIGN, "").equals("center")) {
                        d2 += mxUtils.getDouble(map, mxConstants.STYLE_IMAGE_HEIGHT, mxConstants.DEFAULT_IMAGESIZE);
                    }
                }
                double d3 = mxUtils.getDouble(map, mxConstants.STYLE_SPACING);
                d += 2.0 * d3;
                d += mxUtils.getDouble(map, mxConstants.STYLE_SPACING_LEFT);
                d += mxUtils.getDouble(map, mxConstants.STYLE_SPACING_RIGHT);
                d2 += 2.0 * d3;
                d2 += mxUtils.getDouble(map, mxConstants.STYLE_SPACING_TOP);
                d2 += mxUtils.getDouble(map, mxConstants.STYLE_SPACING_BOTTOM);
                String string = this.getLabel(object);
                if (string != null && string.length() > 0) {
                    mxRectangle mxRectangle3 = mxUtils.getLabelSize(string, map, this.isHtmlLabel(object), 1.0);
                    double d4 = mxRectangle3.getWidth() + d;
                    double d5 = mxRectangle3.getHeight() + d2;
                    if (!mxUtils.isTrue(map, mxConstants.STYLE_HORIZONTAL, true)) {
                        double d6 = d5;
                        d5 = d4;
                        d4 = d6;
                    }
                    if (this.gridEnabled) {
                        d4 = this.snap(d4 + (double)(this.gridSize / 2));
                        d5 = this.snap(d5 + (double)(this.gridSize / 2));
                    }
                    mxRectangle2 = new mxRectangle(0.0, 0.0, d4, d5);
                } else {
                    double d7 = 4 * this.gridSize;
                    mxRectangle2 = new mxRectangle(0.0, 0.0, d7, d7);
                }
            }
        }
        return mxRectangle2;
    }

    public Object resizeCell(Object object, mxRectangle mxRectangle2) {
        return this.resizeCells(new Object[]{object}, new mxRectangle[]{mxRectangle2})[0];
    }

    public Object[] resizeCells(Object[] objectArray, mxRectangle[] mxRectangleArray) {
        this.model.beginUpdate();
        try {
            this.cellsResized(objectArray, mxRectangleArray);
            this.fireEvent(new mxEventObject("resizeCells", "cells", objectArray, "bounds", mxRectangleArray));
        }
        finally {
            this.model.endUpdate();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsResized(Object[] objectArray, mxRectangle[] mxRectangleArray) {
        if (objectArray != null && mxRectangleArray != null && objectArray.length == mxRectangleArray.length) {
            this.model.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    mxRectangle mxRectangle2 = mxRectangleArray[i];
                    mxGeometry mxGeometry2 = this.model.getGeometry(objectArray[i]);
                    if (mxGeometry2 == null || mxGeometry2.getX() == mxRectangle2.getX() && mxGeometry2.getY() == mxRectangle2.getY() && mxGeometry2.getWidth() == mxRectangle2.getWidth() && mxGeometry2.getHeight() == mxRectangle2.getHeight()) continue;
                    if ((mxGeometry2 = (mxGeometry)mxGeometry2.clone()).isRelative()) {
                        mxPoint mxPoint2 = mxGeometry2.getOffset();
                        if (mxPoint2 != null) {
                            mxPoint2.setX(mxPoint2.getX() + mxRectangle2.getX());
                            mxPoint2.setY(mxPoint2.getY() + mxRectangle2.getY());
                        }
                    } else {
                        mxGeometry2.setX(mxRectangle2.getX());
                        mxGeometry2.setY(mxRectangle2.getY());
                    }
                    mxGeometry2.setWidth(mxRectangle2.getWidth());
                    mxGeometry2.setHeight(mxRectangle2.getHeight());
                    if (!mxGeometry2.isRelative() && this.model.isVertex(objectArray[i]) && !this.isAllowNegativeCoordinates()) {
                        mxGeometry2.setX(Math.max(0.0, mxGeometry2.getX()));
                        mxGeometry2.setY(Math.max(0.0, mxGeometry2.getY()));
                    }
                    this.model.setGeometry(objectArray[i], mxGeometry2);
                    if (!this.isExtendParent(objectArray[i])) continue;
                    this.extendParent(objectArray[i]);
                }
                if (this.isResetEdgesOnResize()) {
                    this.resetEdges(objectArray);
                }
                this.fireEvent(new mxEventObject("cellsResized", "cells", objectArray, "bounds", mxRectangleArray));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public void extendParent(Object object) {
        if (object != null) {
            mxGeometry mxGeometry2;
            Object object2 = this.model.getParent(object);
            mxGeometry mxGeometry3 = this.model.getGeometry(object2);
            if (object2 != null && mxGeometry3 != null && !this.isCellCollapsed(object2) && (mxGeometry2 = this.model.getGeometry(object)) != null && (mxGeometry3.getWidth() < mxGeometry2.getX() + mxGeometry2.getWidth() || mxGeometry3.getHeight() < mxGeometry2.getY() + mxGeometry2.getHeight())) {
                mxGeometry3 = (mxGeometry)mxGeometry3.clone();
                mxGeometry3.setWidth(Math.max(mxGeometry3.getWidth(), mxGeometry2.getX() + mxGeometry2.getWidth()));
                mxGeometry3.setHeight(Math.max(mxGeometry3.getHeight(), mxGeometry2.getY() + mxGeometry2.getHeight()));
                this.cellsResized(new Object[]{object2}, new mxRectangle[]{mxGeometry3});
            }
        }
    }

    public Object[] moveCells(Object[] objectArray, double d, double d2) {
        return this.moveCells(objectArray, d, d2, false);
    }

    public Object[] moveCells(Object[] objectArray, double d, double d2, boolean bl) {
        return this.moveCells(objectArray, d, d2, bl, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] moveCells(Object[] objectArray, double d, double d2, boolean bl, Object object, Point point) {
        if (objectArray != null && (d != 0.0 || d2 != 0.0 || bl || object != null)) {
            this.model.beginUpdate();
            try {
                if (bl) {
                    objectArray = this.cloneCells(objectArray, this.isCloneInvalidEdges());
                    if (object == null) {
                        object = this.getDefaultParent();
                    }
                }
                boolean bl2 = this.isAllowNegativeCoordinates();
                if (object != null) {
                    this.setAllowNegativeCoordinates(true);
                }
                this.cellsMoved(objectArray, d, d2, !bl && this.isDisconnectOnMove() && this.isAllowDanglingEdges(), object == null);
                this.setAllowNegativeCoordinates(bl2);
                if (object != null) {
                    Integer n = this.model.getChildCount(object);
                    this.cellsAdded(objectArray, object, n, null, null, true);
                }
                this.fireEvent(new mxEventObject("moveCells", "cells", objectArray, "dx", d, "dy", d2, "clone", bl, "target", object, "location", point));
            }
            finally {
                this.model.endUpdate();
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellsMoved(Object[] objectArray, double d, double d2, boolean bl, boolean bl2) {
        if (objectArray != null && (d != 0.0 || d2 != 0.0)) {
            this.model.beginUpdate();
            try {
                if (bl) {
                    this.disconnectGraph(objectArray);
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    this.translateCell(objectArray[i], d, d2);
                    if (!bl2) continue;
                    this.constrainChild(objectArray[i]);
                }
                if (this.isResetEdgesOnMove()) {
                    this.resetEdges(objectArray);
                }
                this.fireEvent(new mxEventObject("cellsMoved", "cells", objectArray, "dx", d, "dy", d2, "disconnect", bl));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public void translateCell(Object object, double d, double d2) {
        mxGeometry mxGeometry2 = this.model.getGeometry(object);
        if (mxGeometry2 != null) {
            mxGeometry2 = (mxGeometry)mxGeometry2.clone();
            mxGeometry2.translate(d, d2);
            if (!mxGeometry2.isRelative() && this.model.isVertex(object) && !this.isAllowNegativeCoordinates()) {
                mxGeometry2.setX(Math.max(0.0, mxGeometry2.getX()));
                mxGeometry2.setY(Math.max(0.0, mxGeometry2.getY()));
            }
            if (mxGeometry2.isRelative() && !this.model.isEdge(object)) {
                if (mxGeometry2.getOffset() == null) {
                    mxGeometry2.setOffset(new mxPoint(d, d2));
                } else {
                    mxPoint mxPoint2 = mxGeometry2.getOffset();
                    mxPoint2.setX(mxPoint2.getX() + d);
                    mxPoint2.setY(mxPoint2.getY() + d2);
                }
            }
            this.model.setGeometry(object, mxGeometry2);
        }
    }

    public mxRectangle getCellContainmentArea(Object object) {
        if (object != null && !this.model.isEdge(object)) {
            mxGeometry mxGeometry2;
            Object object2 = this.model.getParent(object);
            if (object2 == this.getDefaultParent() || object2 == this.getCurrentRoot()) {
                return this.getMaximumGraphBounds();
            }
            if (object2 != null && object2 != this.getDefaultParent() && (mxGeometry2 = this.model.getGeometry(object2)) != null) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = mxGeometry2.getWidth();
                double d4 = mxGeometry2.getHeight();
                if (this.isSwimlane(object2)) {
                    mxRectangle mxRectangle2 = this.getStartSize(object2);
                    d = mxRectangle2.getWidth();
                    d3 -= mxRectangle2.getWidth();
                    d2 = mxRectangle2.getHeight();
                    d4 -= mxRectangle2.getHeight();
                }
                return new mxRectangle(d, d2, d3, d4);
            }
        }
        return null;
    }

    public mxRectangle getMaximumGraphBounds() {
        return this.maximumGraphBounds;
    }

    public void setMaximumGraphBounds(mxRectangle mxRectangle2) {
        mxRectangle mxRectangle3 = this.maximumGraphBounds;
        this.maximumGraphBounds = mxRectangle2;
        this.changeSupport.firePropertyChange("maximumGraphBounds", mxRectangle3, this.maximumGraphBounds);
    }

    public void constrainChild(Object object) {
        if (object != null) {
            mxRectangle mxRectangle2;
            mxGeometry mxGeometry2 = this.model.getGeometry(object);
            mxRectangle mxRectangle3 = mxRectangle2 = this.isConstrainChild(object) ? this.getCellContainmentArea(object) : this.getMaximumGraphBounds();
            if (mxGeometry2 != null && mxRectangle2 != null && !mxGeometry2.isRelative() && (mxGeometry2.getX() < mxRectangle2.getX() || mxGeometry2.getY() < mxRectangle2.getY() || mxRectangle2.getWidth() < mxGeometry2.getX() + mxGeometry2.getWidth() || mxRectangle2.getHeight() < mxGeometry2.getY() + mxGeometry2.getHeight())) {
                double d = this.getOverlap(object);
                if (mxRectangle2.getWidth() > 0.0) {
                    mxGeometry2.setX(Math.min(mxGeometry2.getX(), mxRectangle2.getX() + mxRectangle2.getWidth() - (1.0 - d) * mxGeometry2.getWidth()));
                }
                if (mxRectangle2.getHeight() > 0.0) {
                    mxGeometry2.setY(Math.min(mxGeometry2.getY(), mxRectangle2.getY() + mxRectangle2.getHeight() - (1.0 - d) * mxGeometry2.getHeight()));
                }
                mxGeometry2.setX(Math.max(mxGeometry2.getX(), mxRectangle2.getX() - mxGeometry2.getWidth() * d));
                mxGeometry2.setY(Math.max(mxGeometry2.getY(), mxRectangle2.getY() - mxGeometry2.getHeight() * d));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEdges(Object[] objectArray) {
        if (objectArray != null) {
            HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(objectArray));
            this.model.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    Object[] objectArray2 = mxGraphModel.getEdges(this.model, objectArray[i]);
                    if (objectArray2 != null) {
                        for (int j = 0; j < objectArray2.length; ++j) {
                            Object object;
                            mxCellState mxCellState2 = this.view.getState(objectArray2[j]);
                            Object object2 = mxCellState2 != null ? mxCellState2.getVisibleTerminal(true) : this.view.getVisibleTerminal(objectArray2[j], true);
                            Object object3 = object = mxCellState2 != null ? mxCellState2.getVisibleTerminal(false) : this.view.getVisibleTerminal(objectArray2[j], false);
                            if (hashSet.contains(object2) && hashSet.contains(object)) continue;
                            this.resetEdge(objectArray2[j]);
                        }
                    }
                    this.resetEdges(mxGraphModel.getChildren(this.model, objectArray[i]));
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object resetEdge(Object object) {
        List<mxPoint> list;
        mxGeometry mxGeometry2 = this.model.getGeometry(object);
        if (mxGeometry2 != null && (list = mxGeometry2.getPoints()) != null && !list.isEmpty()) {
            mxGeometry2 = (mxGeometry)mxGeometry2.clone();
            mxGeometry2.setPoints(null);
            this.model.setGeometry(object, mxGeometry2);
        }
        return object;
    }

    public mxConnectionConstraint[] getAllConnectionConstraints(mxCellState mxCellState2, boolean bl) {
        return null;
    }

    public mxConnectionConstraint getConnectionConstraint(mxCellState mxCellState2, mxCellState mxCellState3, boolean bl) {
        Object object;
        mxPoint mxPoint2 = null;
        Object object2 = mxCellState2.getStyle().get(bl ? mxConstants.STYLE_EXIT_X : mxConstants.STYLE_ENTRY_X);
        if (object2 != null && (object = mxCellState2.getStyle().get(bl ? mxConstants.STYLE_EXIT_Y : mxConstants.STYLE_ENTRY_Y)) != null) {
            mxPoint2 = new mxPoint(Double.parseDouble(object2.toString()), Double.parseDouble(object.toString()));
        }
        boolean bl2 = false;
        if (mxPoint2 != null) {
            bl2 = mxUtils.isTrue(mxCellState2.style, bl ? mxConstants.STYLE_EXIT_PERIMETER : mxConstants.STYLE_ENTRY_PERIMETER, true);
        }
        return new mxConnectionConstraint(mxPoint2, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionConstraint(Object object, Object object2, boolean bl, mxConnectionConstraint mxConnectionConstraint2) {
        if (mxConnectionConstraint2 != null) {
            this.model.beginUpdate();
            try {
                Object[] objectArray = new Object[]{object};
                if (mxConnectionConstraint2 == null || mxConnectionConstraint2.point == null) {
                    this.setCellStyles(bl ? mxConstants.STYLE_EXIT_X : mxConstants.STYLE_ENTRY_X, null, objectArray);
                    this.setCellStyles(bl ? mxConstants.STYLE_EXIT_Y : mxConstants.STYLE_ENTRY_Y, null, objectArray);
                    this.setCellStyles(bl ? mxConstants.STYLE_EXIT_PERIMETER : mxConstants.STYLE_ENTRY_PERIMETER, null, objectArray);
                } else if (mxConnectionConstraint2.point != null) {
                    this.setCellStyles(bl ? mxConstants.STYLE_EXIT_X : mxConstants.STYLE_ENTRY_X, String.valueOf(mxConnectionConstraint2.point.getX()), objectArray);
                    this.setCellStyles(bl ? mxConstants.STYLE_EXIT_Y : mxConstants.STYLE_ENTRY_Y, String.valueOf(mxConnectionConstraint2.point.getY()), objectArray);
                    if (!mxConnectionConstraint2.perimeter) {
                        this.setCellStyles(bl ? mxConstants.STYLE_EXIT_PERIMETER : mxConstants.STYLE_ENTRY_PERIMETER, "0", objectArray);
                    } else {
                        this.setCellStyles(bl ? mxConstants.STYLE_EXIT_PERIMETER : mxConstants.STYLE_ENTRY_PERIMETER, null, objectArray);
                    }
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public mxPoint getConnectionPoint(mxCellState mxCellState2, mxConnectionConstraint mxConnectionConstraint2) {
        mxPoint mxPoint2 = null;
        if (mxCellState2 != null && mxConnectionConstraint2.point != null) {
            double d;
            mxRectangle mxRectangle2 = this.view.getPerimeterBounds(mxCellState2, 0.0);
            mxPoint mxPoint3 = new mxPoint(mxRectangle2.getCenterX(), mxRectangle2.getCenterY());
            String string = mxUtils.getString(mxCellState2.getStyle(), mxConstants.STYLE_DIRECTION);
            double d2 = 0.0;
            if (string != null) {
                if (string.equals("north")) {
                    d2 += 270.0;
                } else if (string.equals("west")) {
                    d2 += 180.0;
                } else if (string.equals("south")) {
                    d2 += 90.0;
                }
                if (string == "north" || string == "south") {
                    mxRectangle2.rotate90();
                }
            }
            mxPoint2 = new mxPoint(mxRectangle2.getX() + mxConnectionConstraint2.point.getX() * mxRectangle2.getWidth(), mxRectangle2.getY() + mxConnectionConstraint2.point.getY() * mxRectangle2.getHeight());
            double d3 = mxUtils.getDouble(mxCellState2.getStyle(), mxConstants.STYLE_ROTATION);
            if (mxConnectionConstraint2.perimeter) {
                if (d2 != 0.0) {
                    double d4 = 0.0;
                    d = 0.0;
                    if (d2 == 90.0) {
                        d = 1.0;
                    } else if (d2 == 180.0) {
                        d4 = -1.0;
                    } else if (d2 == 270.0) {
                        d = -1.0;
                    }
                    mxPoint2 = mxUtils.getRotatedPoint(mxPoint2, d4, d, mxPoint3);
                }
                mxPoint2 = this.view.getPerimeterPoint(mxCellState2, mxPoint2, false);
            } else {
                d3 += d2;
                if (this.getModel().isVertex(mxCellState2.cell)) {
                    boolean bl = mxUtils.getString(mxCellState2.getStyle(), mxConstants.STYLE_FLIPH).equals(1);
                    boolean bl2 = mxUtils.getString(mxCellState2.getStyle(), mxConstants.STYLE_FLIPV).equals(1);
                    if (bl) {
                        mxPoint2.setX(2.0 * mxRectangle2.getCenterX() - mxPoint2.getX());
                    }
                    if (bl2) {
                        mxPoint2.setY(2.0 * mxRectangle2.getCenterY() - mxPoint2.getY());
                    }
                }
            }
            if (d3 != 0.0 && mxPoint2 != null) {
                double d5 = Math.toRadians(2.0);
                d = Math.cos(d5);
                double d6 = Math.sin(d5);
                mxPoint2 = mxUtils.getRotatedPoint(mxPoint2, d, d6, mxPoint3);
            }
        }
        if (mxPoint2 != null) {
            mxPoint2.setX(Math.round(mxPoint2.getX()));
            mxPoint2.setY(Math.round(mxPoint2.getY()));
        }
        return mxPoint2;
    }

    public Object connectCell(Object object, Object object2, boolean bl) {
        return this.connectCell(object, object2, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object connectCell(Object object, Object object2, boolean bl, mxConnectionConstraint mxConnectionConstraint2) {
        this.model.beginUpdate();
        try {
            Object object3 = this.model.getTerminal(object, bl);
            this.cellConnected(object, object2, bl, mxConnectionConstraint2);
            this.fireEvent(new mxEventObject("connectCell", "edge", object, "terminal", object2, "source", bl, "previous", object3));
        }
        finally {
            this.model.endUpdate();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellConnected(Object object, Object object2, boolean bl, mxConnectionConstraint mxConnectionConstraint2) {
        if (object != null) {
            this.model.beginUpdate();
            try {
                Object object3 = this.model.getTerminal(object, bl);
                this.setConnectionConstraint(object, object2, bl, mxConnectionConstraint2);
                if (this.isPortsEnabled()) {
                    String string = null;
                    if (this.isPort(object2) && object2 instanceof mxICell) {
                        string = ((mxICell)object2).getId();
                        object2 = this.getTerminalForPort(object2, bl);
                    }
                    String string2 = bl ? mxConstants.STYLE_SOURCE_PORT : mxConstants.STYLE_TARGET_PORT;
                    this.setCellStyles(string2, string, new Object[]{object});
                }
                this.model.setTerminal(object, object2, bl);
                if (this.isResetEdgesOnConnect()) {
                    this.resetEdge(object);
                }
                this.fireEvent(new mxEventObject("cellConnected", "edge", object, "terminal", object2, "source", bl, "previous", object3));
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectGraph(Object[] objectArray) {
        if (objectArray != null) {
            this.model.beginUpdate();
            try {
                int n;
                double d = this.view.getScale();
                mxPoint mxPoint2 = this.view.getTranslate();
                HashSet<Object> hashSet = new HashSet<Object>();
                for (n = 0; n < objectArray.length; ++n) {
                    hashSet.add(objectArray[n]);
                }
                for (n = 0; n < objectArray.length; ++n) {
                    mxGeometry mxGeometry2;
                    if (!this.model.isEdge(objectArray[n]) || (mxGeometry2 = this.model.getGeometry(objectArray[n])) == null) continue;
                    mxCellState mxCellState2 = this.view.getState(objectArray[n]);
                    mxCellState mxCellState3 = this.view.getState(this.model.getParent(objectArray[n]));
                    if (mxCellState2 != null && mxCellState3 != null) {
                        Object object;
                        mxGeometry2 = (mxGeometry)mxGeometry2.clone();
                        double d2 = -mxCellState3.getOrigin().getX();
                        double d3 = -mxCellState3.getOrigin().getY();
                        Object object2 = this.model.getTerminal(objectArray[n], true);
                        if (object2 != null && this.isCellDisconnectable(objectArray[n], object2, true)) {
                            while (object2 != null && !hashSet.contains(object2)) {
                                object2 = this.model.getParent(object2);
                            }
                            if (object2 == null) {
                                object = mxCellState2.getAbsolutePoint(0);
                                mxGeometry2.setTerminalPoint(new mxPoint(((mxPoint)object).getX() / d - mxPoint2.getX() + d2, ((mxPoint)object).getY() / d - mxPoint2.getY() + d3), true);
                                this.model.setTerminal(objectArray[n], null, true);
                            }
                        }
                        if ((object = this.model.getTerminal(objectArray[n], false)) != null && this.isCellDisconnectable(objectArray[n], object, false)) {
                            while (object != null && !hashSet.contains(object)) {
                                object = this.model.getParent(object);
                            }
                            if (object == null) {
                                int n2 = mxCellState2.getAbsolutePointCount() - 1;
                                mxPoint mxPoint3 = mxCellState2.getAbsolutePoint(n2);
                                mxGeometry2.setTerminalPoint(new mxPoint(mxPoint3.getX() / d - mxPoint2.getX() + d2, mxPoint3.getY() / d - mxPoint2.getY() + d3), false);
                                this.model.setTerminal(objectArray[n], null, false);
                            }
                        }
                    }
                    this.model.setGeometry(objectArray[n], mxGeometry2);
                }
            }
            finally {
                this.model.endUpdate();
            }
        }
    }

    public Object getCurrentRoot() {
        return this.view.getCurrentRoot();
    }

    public mxPoint getTranslateForRoot(Object object) {
        return null;
    }

    public boolean isPort(Object object) {
        return false;
    }

    public Object getTerminalForPort(Object object, boolean bl) {
        return this.getModel().getParent(object);
    }

    public mxPoint getChildOffsetForCell(Object object) {
        return null;
    }

    public void enterGroup() {
        this.enterGroup(null);
    }

    public void enterGroup(Object object) {
        if (object == null) {
            object = this.getSelectionCell();
        }
        if (object != null && this.isValidRoot(object)) {
            this.view.setCurrentRoot(object);
            this.clearSelection();
        }
    }

    public void exitGroup() {
        Object object = this.model.getRoot();
        Object object2 = this.getCurrentRoot();
        if (object2 != null) {
            Object object3 = this.model.getParent(object2);
            while (object3 != object && !this.isValidRoot(object3) && this.model.getParent(object3) != object) {
                object3 = this.model.getParent(object3);
            }
            if (object3 == object || this.model.getParent(object3) == object) {
                this.view.setCurrentRoot(null);
            } else {
                this.view.setCurrentRoot(object3);
            }
            mxCellState mxCellState2 = this.view.getState(object2);
            if (mxCellState2 != null) {
                this.setSelectionCell(object2);
            }
        }
    }

    public void home() {
        Object object = this.getCurrentRoot();
        if (object != null) {
            this.view.setCurrentRoot(null);
            mxCellState mxCellState2 = this.view.getState(object);
            if (mxCellState2 != null) {
                this.setSelectionCell(object);
            }
        }
    }

    public boolean isValidRoot(Object object) {
        return object != null;
    }

    public mxRectangle getGraphBounds() {
        return this.view.getGraphBounds();
    }

    public mxRectangle getCellBounds(Object object) {
        return this.getCellBounds(object, false);
    }

    public mxRectangle getCellBounds(Object object, boolean bl) {
        return this.getCellBounds(object, bl, false);
    }

    public mxRectangle getCellBounds(Object object, boolean bl, boolean bl2) {
        return this.getCellBounds(object, bl, bl2, false);
    }

    public mxRectangle getBoundingBoxFromGeometry(Object[] objectArray) {
        mxRectangle mxRectangle2 = null;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.getModel().isVertex(objectArray[i])) continue;
                mxGeometry mxGeometry2 = this.getCellGeometry(objectArray[i]);
                if (mxRectangle2 == null) {
                    mxRectangle2 = new mxRectangle(mxGeometry2);
                    continue;
                }
                mxRectangle2.add(mxGeometry2);
            }
        }
        return mxRectangle2;
    }

    public mxRectangle getBoundingBox(Object object) {
        return this.getBoundingBox(object, false);
    }

    public mxRectangle getBoundingBox(Object object, boolean bl) {
        return this.getBoundingBox(object, bl, false);
    }

    public mxRectangle getBoundingBox(Object object, boolean bl, boolean bl2) {
        return this.getCellBounds(object, bl, bl2, true);
    }

    public mxRectangle getPaintBounds(Object[] objectArray) {
        return this.getBoundsForCells(objectArray, false, true, true);
    }

    public mxRectangle getBoundsForCells(Object[] objectArray, boolean bl, boolean bl2, boolean bl3) {
        mxRectangle mxRectangle2 = null;
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                mxRectangle mxRectangle3 = this.getCellBounds(objectArray[i], bl, bl2, bl3);
                if (mxRectangle3 == null) continue;
                if (mxRectangle2 == null) {
                    mxRectangle2 = new mxRectangle(mxRectangle3);
                    continue;
                }
                mxRectangle2.add(mxRectangle3);
            }
        }
        return mxRectangle2;
    }

    public mxRectangle getCellBounds(Object object, boolean bl, boolean bl2, boolean bl3) {
        Object[] objectArray;
        Cloneable cloneable;
        if (bl) {
            cloneable = new HashSet<Object>();
            cloneable.add(object);
            HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(this.getEdges(object)));
            while (!hashSet.isEmpty() && !cloneable.containsAll(hashSet)) {
                cloneable.addAll(hashSet);
                HashSet<Object> hashSet2 = new HashSet<Object>();
                for (Object object2 : hashSet) {
                    hashSet2.addAll(Arrays.asList(this.getEdges(object2)));
                }
                hashSet = hashSet2;
            }
            objectArray = cloneable.toArray();
        } else {
            objectArray = new Object[]{object};
        }
        cloneable = this.view.getBounds(objectArray, bl3);
        if (bl2) {
            for (int i = 0; i < objectArray.length; ++i) {
                int n = this.model.getChildCount(objectArray[i]);
                for (int j = 0; j < n; ++j) {
                    mxRectangle mxRectangle2 = this.getCellBounds(this.model.getChildAt(objectArray[i], j), bl, true, bl3);
                    if (cloneable != null) {
                        ((mxRectangle)cloneable).add(mxRectangle2);
                        continue;
                    }
                    cloneable = mxRectangle2;
                }
            }
        }
        return cloneable;
    }

    public void refresh() {
        this.view.reload();
        this.repaint();
    }

    public void repaint() {
        this.repaint(null);
    }

    public void repaint(mxRectangle mxRectangle2) {
        this.fireEvent(new mxEventObject("repaint", "region", mxRectangle2));
    }

    public double snap(double d) {
        if (this.gridEnabled) {
            d = Math.round(d / (double)this.gridSize) * (long)this.gridSize;
        }
        return d;
    }

    public mxGeometry getCellGeometry(Object object) {
        return this.model.getGeometry(object);
    }

    public boolean isCellVisible(Object object) {
        return this.model.isVisible(object);
    }

    public boolean isCellCollapsed(Object object) {
        return this.model.isCollapsed(object);
    }

    public boolean isCellConnectable(Object object) {
        return this.model.isConnectable(object);
    }

    public boolean isOrthogonal(mxCellState mxCellState2) {
        if (mxCellState2.getStyle().containsKey(mxConstants.STYLE_ORTHOGONAL)) {
            return mxUtils.isTrue(mxCellState2.getStyle(), mxConstants.STYLE_ORTHOGONAL);
        }
        mxEdgeStyle.mxEdgeStyleFunction mxEdgeStyleFunction2 = this.view.getEdgeStyle(mxCellState2, null, null, null);
        return mxEdgeStyleFunction2 == mxEdgeStyle.SegmentConnector || mxEdgeStyleFunction2 == mxEdgeStyle.ElbowConnector || mxEdgeStyleFunction2 == mxEdgeStyle.SideToSide || mxEdgeStyleFunction2 == mxEdgeStyle.TopToBottom || mxEdgeStyleFunction2 == mxEdgeStyle.EntityRelation || mxEdgeStyleFunction2 == mxEdgeStyle.OrthConnector;
    }

    public boolean isLoop(mxCellState mxCellState2) {
        mxCellState mxCellState3 = mxCellState2.getVisibleTerminalState(true);
        mxCellState mxCellState4 = mxCellState2.getVisibleTerminalState(false);
        return mxCellState3 != null && mxCellState3 == mxCellState4;
    }

    public void setMultiplicities(mxMultiplicity[] mxMultiplicityArray) {
        mxMultiplicity[] mxMultiplicityArray2 = this.multiplicities;
        this.multiplicities = mxMultiplicityArray;
        this.changeSupport.firePropertyChange("multiplicities", mxMultiplicityArray2, this.multiplicities);
    }

    public mxMultiplicity[] getMultiplicities() {
        return this.multiplicities;
    }

    public boolean isEdgeValid(Object object, Object object2, Object object3) {
        return this.getEdgeValidationError(object, object2, object3) == null;
    }

    public String getEdgeValidationError(Object object, Object object2, Object object3) {
        if (!(object == null || this.isAllowDanglingEdges() || object2 != null && object3 != null)) {
            return "";
        }
        if (object != null && this.model.getTerminal(object, true) == null && this.model.getTerminal(object, false) == null) {
            return null;
        }
        if (!this.isAllowLoops() && object2 == object3 && object2 != null) {
            return "";
        }
        if (!this.isValidConnection(object2, object3)) {
            return "";
        }
        if (object2 != null && object3 != null) {
            String string;
            Object[] objectArray;
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.multigraph && ((objectArray = mxGraphModel.getEdgesBetween(this.model, object2, object3, true)).length > 1 || objectArray.length == 1 && objectArray[0] != object)) {
                stringBuffer.append(mxResources.get("alreadyConnected", "Already Connected") + "\n");
            }
            int n = mxGraphModel.getDirectedEdgeCount(this.model, object2, true, object);
            int n2 = mxGraphModel.getDirectedEdgeCount(this.model, object3, false, object);
            if (this.multiplicities != null) {
                for (int i = 0; i < this.multiplicities.length; ++i) {
                    String string2 = this.multiplicities[i].check(this, object, object2, object3, n, n2);
                    if (string2 == null) continue;
                    stringBuffer.append(string2);
                }
            }
            if ((string = this.validateEdge(object, object2, object3)) != null) {
                stringBuffer.append(string);
            }
            return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
        }
        return this.allowDanglingEdges ? null : "";
    }

    public String validateEdge(Object object, Object object2, Object object3) {
        return null;
    }

    public String getCellValidationError(Object object) {
        int n = mxGraphModel.getDirectedEdgeCount(this.model, object, true);
        int n2 = mxGraphModel.getDirectedEdgeCount(this.model, object, false);
        StringBuffer stringBuffer = new StringBuffer();
        Object object2 = this.model.getValue(object);
        if (this.multiplicities != null) {
            for (int i = 0; i < this.multiplicities.length; ++i) {
                mxMultiplicity mxMultiplicity2 = this.multiplicities[i];
                int n3 = mxMultiplicity2.getMaxValue();
                if (mxMultiplicity2.source && mxUtils.isNode(object2, mxMultiplicity2.type, mxMultiplicity2.attr, mxMultiplicity2.value) && (n3 == 0 && n > 0 || mxMultiplicity2.min == 1 && n == 0 || n3 == 1 && n > 1)) {
                    stringBuffer.append(mxMultiplicity2.countError + '\n');
                    continue;
                }
                if (mxMultiplicity2.source || !mxUtils.isNode(object2, mxMultiplicity2.type, mxMultiplicity2.attr, mxMultiplicity2.value) || !(n3 == 0 && n2 > 0 || mxMultiplicity2.min == 1 && n2 == 0) && (n3 != 1 || n2 <= 1)) continue;
                stringBuffer.append(mxMultiplicity2.countError + '\n');
            }
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    public String validateCell(Object object, Hashtable<Object, Object> hashtable) {
        return null;
    }

    public boolean isLabelsVisible() {
        return this.labelsVisible;
    }

    public void setLabelsVisible(boolean bl) {
        boolean bl2 = this.labelsVisible;
        this.labelsVisible = bl;
        this.changeSupport.firePropertyChange("labelsVisible", bl2, this.labelsVisible);
    }

    public void setHtmlLabels(boolean bl) {
        boolean bl2 = this.htmlLabels;
        this.htmlLabels = bl;
        this.changeSupport.firePropertyChange("htmlLabels", bl2, this.htmlLabels);
    }

    public boolean isHtmlLabels() {
        return this.htmlLabels;
    }

    public String convertValueToString(Object object) {
        Object object2 = this.model.getValue(object);
        return object2 != null ? object2.toString() : "";
    }

    public String getLabel(Object object) {
        String string = "";
        if (object != null) {
            Map<String, Object> map;
            mxCellState mxCellState2 = this.view.getState(object);
            Map<String, Object> map2 = map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
            if (this.labelsVisible && !mxUtils.isTrue(map, mxConstants.STYLE_NOLABEL, false)) {
                string = this.convertValueToString(object);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellLabelChanged(Object object, Object object2, boolean bl) {
        this.model.beginUpdate();
        try {
            this.getModel().setValue(object, object2);
            if (bl) {
                this.cellSizeUpdated(object, false);
            }
        }
        finally {
            this.model.endUpdate();
        }
    }

    public boolean isHtmlLabel(Object object) {
        return this.isHtmlLabels();
    }

    public String getToolTipForCell(Object object) {
        return this.convertValueToString(object);
    }

    public mxRectangle getStartSize(Object object) {
        Map<String, Object> map;
        mxRectangle mxRectangle2 = new mxRectangle();
        mxCellState mxCellState2 = this.view.getState(object);
        Map<String, Object> map2 = map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
        if (map != null) {
            double d = mxUtils.getDouble(map, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE);
            if (mxUtils.isTrue(map, mxConstants.STYLE_HORIZONTAL, true)) {
                mxRectangle2.setHeight(d);
            } else {
                mxRectangle2.setWidth(d);
            }
        }
        return mxRectangle2;
    }

    public String getImage(mxCellState mxCellState2) {
        return mxCellState2 != null && mxCellState2.getStyle() != null ? mxUtils.getString(mxCellState2.getStyle(), mxConstants.STYLE_IMAGE) : null;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public mxEdgeStyle.mxEdgeStyleFunction getDefaultLoopStyle() {
        return this.defaultLoopStyle;
    }

    public void setDefaultLoopStyle(mxEdgeStyle.mxEdgeStyleFunction mxEdgeStyleFunction2) {
        mxEdgeStyle.mxEdgeStyleFunction mxEdgeStyleFunction3 = this.defaultLoopStyle;
        this.defaultLoopStyle = mxEdgeStyleFunction2;
        this.changeSupport.firePropertyChange("defaultLoopStyle", mxEdgeStyleFunction3, this.defaultLoopStyle);
    }

    public boolean isSwimlane(Object object) {
        if (object != null && this.model.getParent(object) != this.model.getRoot()) {
            Map<String, Object> map;
            mxCellState mxCellState2 = this.view.getState(object);
            Map<String, Object> map2 = map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
            if (map != null && !this.model.isEdge(object)) {
                return mxUtils.getString(map, mxConstants.STYLE_SHAPE, "").equals("swimlane");
            }
        }
        return false;
    }

    public boolean isCellLocked(Object object) {
        mxGeometry mxGeometry2 = this.model.getGeometry(object);
        return this.isCellsLocked() || mxGeometry2 != null && this.model.isVertex(object) && mxGeometry2.isRelative();
    }

    public boolean isCellsLocked() {
        return this.cellsLocked;
    }

    public void setCellsLocked(boolean bl) {
        boolean bl2 = this.cellsLocked;
        this.cellsLocked = bl;
        this.changeSupport.firePropertyChange("cellsLocked", bl2, this.cellsLocked);
    }

    public boolean isCellEditable(Object object) {
        mxCellState mxCellState2 = this.view.getState(object);
        Map<String, Object> map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
        return this.isCellsEditable() && !this.isCellLocked(object) && mxUtils.isTrue(map, mxConstants.STYLE_EDITABLE, true);
    }

    public boolean isCellsEditable() {
        return this.cellsEditable;
    }

    public void setCellsEditable(boolean bl) {
        boolean bl2 = this.cellsEditable;
        this.cellsEditable = bl;
        this.changeSupport.firePropertyChange("cellsEditable", bl2, this.cellsEditable);
    }

    public boolean isCellResizable(Object object) {
        mxCellState mxCellState2 = this.view.getState(object);
        Map<String, Object> map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
        return this.isCellsResizable() && !this.isCellLocked(object) && mxUtils.isTrue(map, mxConstants.STYLE_RESIZABLE, true);
    }

    public boolean isCellsResizable() {
        return this.cellsResizable;
    }

    public void setCellsResizable(boolean bl) {
        boolean bl2 = this.cellsResizable;
        this.cellsResizable = bl;
        this.changeSupport.firePropertyChange("cellsResizable", bl2, this.cellsResizable);
    }

    public Object[] getMovableCells(Object[] objectArray) {
        return mxGraphModel.filterCells(objectArray, new mxGraphModel.Filter(){

            @Override
            public boolean filter(Object object) {
                return mxGraph.this.isCellMovable(object);
            }
        });
    }

    public boolean isCellMovable(Object object) {
        mxCellState mxCellState2 = this.view.getState(object);
        Map<String, Object> map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
        return this.isCellsMovable() && !this.isCellLocked(object) && mxUtils.isTrue(map, mxConstants.STYLE_MOVABLE, true);
    }

    public boolean isCellsMovable() {
        return this.cellsMovable;
    }

    public void setCellsMovable(boolean bl) {
        boolean bl2 = this.cellsMovable;
        this.cellsMovable = bl;
        this.changeSupport.firePropertyChange("cellsMovable", bl2, this.cellsMovable);
    }

    public boolean isTerminalPointMovable(Object object, boolean bl) {
        return true;
    }

    public boolean isCellBendable(Object object) {
        mxCellState mxCellState2 = this.view.getState(object);
        Map<String, Object> map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
        return this.isCellsBendable() && !this.isCellLocked(object) && mxUtils.isTrue(map, mxConstants.STYLE_BENDABLE, true);
    }

    public boolean isCellsBendable() {
        return this.cellsBendable;
    }

    public void setCellsBendable(boolean bl) {
        boolean bl2 = this.cellsBendable;
        this.cellsBendable = bl;
        this.changeSupport.firePropertyChange("cellsBendable", bl2, this.cellsBendable);
    }

    public boolean isCellSelectable(Object object) {
        return this.isCellsSelectable();
    }

    public boolean isCellsSelectable() {
        return this.cellsSelectable;
    }

    public void setCellsSelectable(boolean bl) {
        boolean bl2 = this.cellsSelectable;
        this.cellsSelectable = bl;
        this.changeSupport.firePropertyChange("cellsSelectable", bl2, this.cellsSelectable);
    }

    public Object[] getDeletableCells(Object[] objectArray) {
        return mxGraphModel.filterCells(objectArray, new mxGraphModel.Filter(){

            @Override
            public boolean filter(Object object) {
                return mxGraph.this.isCellDeletable(object);
            }
        });
    }

    public boolean isCellDeletable(Object object) {
        mxCellState mxCellState2 = this.view.getState(object);
        Map<String, Object> map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
        return this.isCellsDeletable() && mxUtils.isTrue(map, mxConstants.STYLE_DELETABLE, true);
    }

    public boolean isCellsDeletable() {
        return this.cellsDeletable;
    }

    public void setCellsDeletable(boolean bl) {
        boolean bl2 = this.cellsDeletable;
        this.cellsDeletable = bl;
        this.changeSupport.firePropertyChange("cellsDeletable", bl2, this.cellsDeletable);
    }

    public Object[] getCloneableCells(Object[] objectArray) {
        return mxGraphModel.filterCells(objectArray, new mxGraphModel.Filter(){

            @Override
            public boolean filter(Object object) {
                return mxGraph.this.isCellCloneable(object);
            }
        });
    }

    public boolean isCellCloneable(Object object) {
        mxCellState mxCellState2 = this.view.getState(object);
        Map<String, Object> map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
        return this.isCellsCloneable() && mxUtils.isTrue(map, mxConstants.STYLE_CLONEABLE, true);
    }

    public boolean isCellsCloneable() {
        return this.cellsCloneable;
    }

    public void setCellsCloneable(boolean bl) {
        boolean bl2 = this.cellsCloneable;
        this.cellsCloneable = bl;
        this.changeSupport.firePropertyChange("cellsCloneable", bl2, this.cellsCloneable);
    }

    public boolean isCellDisconnectable(Object object, Object object2, boolean bl) {
        return this.isCellsDisconnectable() && !this.isCellLocked(object);
    }

    public boolean isCellsDisconnectable() {
        return this.cellsDisconnectable;
    }

    public void setCellsDisconnectable(boolean bl) {
        boolean bl2 = this.cellsDisconnectable;
        this.cellsDisconnectable = bl;
        this.changeSupport.firePropertyChange("cellsDisconnectable", bl2, this.cellsDisconnectable);
    }

    public boolean isLabelClipped(Object object) {
        if (!this.isLabelsClipped()) {
            mxCellState mxCellState2 = this.view.getState(object);
            Map<String, Object> map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
            return map != null ? mxUtils.getString(map, mxConstants.STYLE_OVERFLOW, "").equals("hidden") : false;
        }
        return this.isLabelsClipped();
    }

    public boolean isLabelsClipped() {
        return this.labelsClipped;
    }

    public void setLabelsClipped(boolean bl) {
        boolean bl2 = this.labelsClipped;
        this.labelsClipped = bl;
        this.changeSupport.firePropertyChange("labelsClipped", bl2, this.labelsClipped);
    }

    public boolean isLabelMovable(Object object) {
        return !this.isCellLocked(object) && (this.model.isEdge(object) && this.isEdgeLabelsMovable() || this.model.isVertex(object) && this.isVertexLabelsMovable());
    }

    public boolean isVertexLabelsMovable() {
        return this.vertexLabelsMovable;
    }

    public void setVertexLabelsMovable(boolean bl) {
        boolean bl2 = this.vertexLabelsMovable;
        this.vertexLabelsMovable = bl;
        this.changeSupport.firePropertyChange("vertexLabelsMovable", bl2, this.vertexLabelsMovable);
    }

    public boolean isEdgeLabelsMovable() {
        return this.edgeLabelsMovable;
    }

    public void setEdgeLabelsMovable(boolean bl) {
        boolean bl2 = this.edgeLabelsMovable;
        this.edgeLabelsMovable = bl;
        this.changeSupport.firePropertyChange("edgeLabelsMovable", bl2, this.edgeLabelsMovable);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        this.changeSupport.firePropertyChange("enabled", bl2, this.enabled);
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean bl) {
        boolean bl2 = this.dropEnabled;
        this.dropEnabled = bl;
        this.changeSupport.firePropertyChange("dropEnabled", bl2, this.dropEnabled);
    }

    public boolean isSplitEnabled() {
        return this.splitEnabled;
    }

    public void setSplitEnabled(boolean bl) {
        this.splitEnabled = bl;
    }

    public boolean isMultigraph() {
        return this.multigraph;
    }

    public void setMultigraph(boolean bl) {
        boolean bl2 = this.multigraph;
        this.multigraph = bl;
        this.changeSupport.firePropertyChange("multigraph", bl2, this.multigraph);
    }

    public boolean isSwimlaneNesting() {
        return this.swimlaneNesting;
    }

    public void setSwimlaneNesting(boolean bl) {
        boolean bl2 = this.swimlaneNesting;
        this.swimlaneNesting = bl;
        this.changeSupport.firePropertyChange("swimlaneNesting", bl2, this.swimlaneNesting);
    }

    public boolean isAllowDanglingEdges() {
        return this.allowDanglingEdges;
    }

    public void setAllowDanglingEdges(boolean bl) {
        boolean bl2 = this.allowDanglingEdges;
        this.allowDanglingEdges = bl;
        this.changeSupport.firePropertyChange("allowDanglingEdges", bl2, this.allowDanglingEdges);
    }

    public boolean isCloneInvalidEdges() {
        return this.cloneInvalidEdges;
    }

    public void setCloneInvalidEdges(boolean bl) {
        boolean bl2 = this.cloneInvalidEdges;
        this.cloneInvalidEdges = bl;
        this.changeSupport.firePropertyChange("cloneInvalidEdges", bl2, this.cloneInvalidEdges);
    }

    public boolean isDisconnectOnMove() {
        return this.disconnectOnMove;
    }

    public void setDisconnectOnMove(boolean bl) {
        boolean bl2 = this.disconnectOnMove;
        this.disconnectOnMove = bl;
        this.changeSupport.firePropertyChange("disconnectOnMove", bl2, this.disconnectOnMove);
    }

    public boolean isAllowLoops() {
        return this.allowLoops;
    }

    public void setAllowLoops(boolean bl) {
        boolean bl2 = this.allowLoops;
        this.allowLoops = bl;
        this.changeSupport.firePropertyChange("allowLoops", bl2, this.allowLoops);
    }

    public boolean isConnectableEdges() {
        return this.connectableEdges;
    }

    public void setConnectableEdges(boolean bl) {
        boolean bl2 = this.connectableEdges;
        this.connectableEdges = bl;
        this.changeSupport.firePropertyChange("connectableEdges", bl2, this.connectableEdges);
    }

    public boolean isResetEdgesOnMove() {
        return this.resetEdgesOnMove;
    }

    public void setResetEdgesOnMove(boolean bl) {
        boolean bl2 = this.resetEdgesOnMove;
        this.resetEdgesOnMove = bl;
        this.changeSupport.firePropertyChange("resetEdgesOnMove", bl2, this.resetEdgesOnMove);
    }

    public boolean isResetViewOnRootChange() {
        return this.resetViewOnRootChange;
    }

    public void setResetViewOnRootChange(boolean bl) {
        boolean bl2 = this.resetViewOnRootChange;
        this.resetViewOnRootChange = bl;
        this.changeSupport.firePropertyChange("resetViewOnRootChange", bl2, this.resetViewOnRootChange);
    }

    public boolean isResetEdgesOnResize() {
        return this.resetEdgesOnResize;
    }

    public void setResetEdgesOnResize(boolean bl) {
        boolean bl2 = this.resetEdgesOnResize;
        this.resetEdgesOnResize = bl;
        this.changeSupport.firePropertyChange("resetEdgesOnResize", bl2, this.resetEdgesOnResize);
    }

    public boolean isResetEdgesOnConnect() {
        return this.resetEdgesOnConnect;
    }

    public void setResetEdgesOnConnect(boolean bl) {
        boolean bl2 = this.resetEdgesOnConnect;
        this.resetEdgesOnConnect = bl;
        this.changeSupport.firePropertyChange("resetEdgesOnConnect", bl2, this.resetEdgesOnResize);
    }

    public boolean isAutoSizeCell(Object object) {
        mxCellState mxCellState2 = this.view.getState(object);
        Map<String, Object> map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
        return this.isAutoSizeCells() || mxUtils.isTrue(map, mxConstants.STYLE_AUTOSIZE, false);
    }

    public boolean isAutoSizeCells() {
        return this.autoSizeCells;
    }

    public void setAutoSizeCells(boolean bl) {
        boolean bl2 = this.autoSizeCells;
        this.autoSizeCells = bl;
        this.changeSupport.firePropertyChange("autoSizeCells", bl2, this.autoSizeCells);
    }

    public boolean isExtendParent(Object object) {
        return !this.getModel().isEdge(object) && this.isExtendParents();
    }

    public boolean isExtendParents() {
        return this.extendParents;
    }

    public void setExtendParents(boolean bl) {
        boolean bl2 = this.extendParents;
        this.extendParents = bl;
        this.changeSupport.firePropertyChange("extendParents", bl2, this.extendParents);
    }

    public boolean isExtendParentsOnAdd() {
        return this.extendParentsOnAdd;
    }

    public void setExtendParentsOnAdd(boolean bl) {
        boolean bl2 = this.extendParentsOnAdd;
        this.extendParentsOnAdd = bl;
        this.changeSupport.firePropertyChange("extendParentsOnAdd", bl2, this.extendParentsOnAdd);
    }

    public boolean isConstrainChild(Object object) {
        return this.isConstrainChildren() && !this.getModel().isEdge(this.getModel().getParent(object));
    }

    public boolean isConstrainChildren() {
        return this.constrainChildren;
    }

    public void setConstrainChildren(boolean bl) {
        boolean bl2 = this.constrainChildren;
        this.constrainChildren = bl;
        this.changeSupport.firePropertyChange("constrainChildren", bl2, this.constrainChildren);
    }

    public boolean isAutoOrigin() {
        return this.autoOrigin;
    }

    public void setAutoOrigin(boolean bl) {
        boolean bl2 = this.autoOrigin;
        this.autoOrigin = bl;
        this.changeSupport.firePropertyChange("autoOrigin", bl2, this.autoOrigin);
    }

    public mxPoint getOrigin() {
        return this.origin;
    }

    public void setOrigin(mxPoint mxPoint2) {
        mxPoint mxPoint3 = this.origin;
        this.origin = mxPoint2;
        this.changeSupport.firePropertyChange("origin", mxPoint3, this.origin);
    }

    public int getChangesRepaintThreshold() {
        return this.changesRepaintThreshold;
    }

    public void setChangesRepaintThreshold(int n) {
        int n2 = this.changesRepaintThreshold;
        this.changesRepaintThreshold = n;
        this.changeSupport.firePropertyChange("changesRepaintThreshold", n2, this.changesRepaintThreshold);
    }

    public boolean isAllowNegativeCoordinates() {
        return this.allowNegativeCoordinates;
    }

    public void setAllowNegativeCoordinates(boolean bl) {
        boolean bl2 = this.allowNegativeCoordinates;
        this.allowNegativeCoordinates = bl;
        this.changeSupport.firePropertyChange("allowNegativeCoordinates", bl2, this.allowNegativeCoordinates);
    }

    public boolean isCollapseToPreferredSize() {
        return this.collapseToPreferredSize;
    }

    public void setCollapseToPreferredSize(boolean bl) {
        boolean bl2 = this.collapseToPreferredSize;
        this.collapseToPreferredSize = bl;
        this.changeSupport.firePropertyChange("collapseToPreferredSize", bl2, this.collapseToPreferredSize);
    }

    public boolean isKeepEdgesInForeground() {
        return this.keepEdgesInForeground;
    }

    public void setKeepEdgesInForeground(boolean bl) {
        boolean bl2 = this.keepEdgesInForeground;
        this.keepEdgesInForeground = bl;
        this.changeSupport.firePropertyChange("keepEdgesInForeground", bl2, this.keepEdgesInForeground);
    }

    public boolean isKeepEdgesInBackground() {
        return this.keepEdgesInBackground;
    }

    public void setKeepEdgesInBackground(boolean bl) {
        boolean bl2 = this.keepEdgesInBackground;
        this.keepEdgesInBackground = bl;
        this.changeSupport.firePropertyChange("keepEdgesInBackground", bl2, this.keepEdgesInBackground);
    }

    public boolean isValidSource(Object object) {
        return object == null && this.allowDanglingEdges || object != null && (!this.model.isEdge(object) || this.isConnectableEdges()) && this.isCellConnectable(object);
    }

    public boolean isValidTarget(Object object) {
        return this.isValidSource(object);
    }

    public boolean isValidConnection(Object object, Object object2) {
        return this.isValidSource(object) && this.isValidTarget(object2) && (this.isAllowLoops() || object != object2);
    }

    public mxRectangle getMinimumGraphSize() {
        return this.minimumGraphSize;
    }

    public void setMinimumGraphSize(mxRectangle mxRectangle2) {
        mxRectangle mxRectangle3 = this.minimumGraphSize;
        this.minimumGraphSize = mxRectangle2;
        this.changeSupport.firePropertyChange("minimumGraphSize", mxRectangle3, mxRectangle2);
    }

    public double getOverlap(Object object) {
        return this.isAllowOverlapParent(object) ? this.getDefaultOverlap() : 0.0;
    }

    public double getDefaultOverlap() {
        return this.defaultOverlap;
    }

    public void setDefaultOverlap(double d) {
        double d2 = this.defaultOverlap;
        this.defaultOverlap = d;
        this.changeSupport.firePropertyChange("defaultOverlap", d2, d);
    }

    public boolean isAllowOverlapParent(Object object) {
        return false;
    }

    public Object[] getFoldableCells(Object[] objectArray, final boolean bl) {
        return mxGraphModel.filterCells(objectArray, new mxGraphModel.Filter(){

            @Override
            public boolean filter(Object object) {
                return mxGraph.this.isCellFoldable(object, bl);
            }
        });
    }

    public boolean isCellFoldable(Object object, boolean bl) {
        mxCellState mxCellState2 = this.view.getState(object);
        Map<String, Object> map = mxCellState2 != null ? mxCellState2.getStyle() : this.getCellStyle(object);
        return this.model.getChildCount(object) > 0 && mxUtils.isTrue(map, mxConstants.STYLE_FOLDABLE, true);
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean bl) {
        boolean bl2 = this.gridEnabled;
        this.gridEnabled = bl;
        this.changeSupport.firePropertyChange("gridEnabled", bl2, this.gridEnabled);
    }

    public boolean isPortsEnabled() {
        return this.portsEnabled;
    }

    public void setPortsEnabled(boolean bl) {
        boolean bl2 = this.portsEnabled;
        this.portsEnabled = bl;
        this.changeSupport.firePropertyChange("portsEnabled", bl2, this.portsEnabled);
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int n) {
        int n2 = this.gridSize;
        this.gridSize = n;
        this.changeSupport.firePropertyChange("gridSize", n2, this.gridSize);
    }

    public String getAlternateEdgeStyle() {
        return this.alternateEdgeStyle;
    }

    public void setAlternateEdgeStyle(String string) {
        String string2 = this.alternateEdgeStyle;
        this.alternateEdgeStyle = string;
        this.changeSupport.firePropertyChange("alternateEdgeStyle", string2, this.alternateEdgeStyle);
    }

    public boolean isValidDropTarget(Object object, Object[] objectArray) {
        return object != null && (this.isSplitEnabled() && this.isSplitTarget(object, objectArray) || !this.model.isEdge(object) && (this.isSwimlane(object) || this.model.getChildCount(object) > 0 && !this.isCellCollapsed(object)));
    }

    public boolean isSplitTarget(Object object, Object[] objectArray) {
        if (object != null && objectArray != null && objectArray.length == 1) {
            Object object2 = this.model.getTerminal(object, true);
            Object object3 = this.model.getTerminal(object, false);
            return this.model.isEdge(object) && this.isCellConnectable(objectArray[0]) && this.getEdgeValidationError(object, this.model.getTerminal(object, true), objectArray[0]) == null && !this.model.isAncestor(objectArray[0], object2) && !this.model.isAncestor(objectArray[0], object3);
        }
        return false;
    }

    public Object getDropTarget(Object[] objectArray, Point point, Object object) {
        if (!this.isSwimlaneNesting()) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isSwimlane(objectArray[i])) continue;
                return null;
            }
        }
        Object var4_5 = null;
        if (object == null) {
            object = var4_5;
        }
        while (object != null && !this.isValidDropTarget(object, objectArray) && this.model.getParent(object) != this.model.getRoot()) {
            object = this.model.getParent(object);
        }
        return this.model.getParent(object) != this.model.getRoot() && !mxUtils.contains(objectArray, object) ? object : null;
    }

    public Object getDefaultParent() {
        Object object = this.defaultParent;
        if (object == null && (object = this.view.getCurrentRoot()) == null) {
            Object object2 = this.model.getRoot();
            object = this.model.getChildAt(object2, 0);
        }
        return object;
    }

    public void setDefaultParent(Object object) {
        this.defaultParent = object;
    }

    public Object[] getChildVertices(Object object) {
        return this.getChildCells(object, true, false);
    }

    public Object[] getChildEdges(Object object) {
        return this.getChildCells(object, false, true);
    }

    public Object[] getChildCells(Object object) {
        return this.getChildCells(object, false, false);
    }

    public Object[] getChildCells(Object object, boolean bl, boolean bl2) {
        Object[] objectArray = mxGraphModel.getChildCells(this.model, object, bl, bl2);
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.isCellVisible(objectArray[i])) continue;
            arrayList.add(objectArray[i]);
        }
        return arrayList.toArray();
    }

    public Object[] getConnections(Object object) {
        return this.getConnections(object, null);
    }

    public Object[] getConnections(Object object, Object object2) {
        return this.getConnections(object, object2, false);
    }

    public Object[] getConnections(Object object, Object object2, boolean bl) {
        return this.getEdges(object, object2, true, true, false, bl);
    }

    public Object[] getIncomingEdges(Object object) {
        return this.getIncomingEdges(object, null);
    }

    public Object[] getIncomingEdges(Object object, Object object2) {
        return this.getEdges(object, object2, true, false, false);
    }

    public Object[] getOutgoingEdges(Object object) {
        return this.getOutgoingEdges(object, null);
    }

    public Object[] getOutgoingEdges(Object object, Object object2) {
        return this.getEdges(object, object2, false, true, false);
    }

    public Object[] getEdges(Object object) {
        return this.getEdges(object, null);
    }

    public Object[] getEdges(Object object, Object object2) {
        return this.getEdges(object, object2, true, true, true);
    }

    public Object[] getEdges(Object object, Object object2, boolean bl, boolean bl2, boolean bl3) {
        return this.getEdges(object, object2, bl, bl2, bl3, false);
    }

    public Object[] getEdges(Object object, Object object2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = this.isCellCollapsed(object);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this.model.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Iterator iterator = this.model.getChildAt(object, i);
            if (!bl5 && this.isCellVisible(iterator)) continue;
            arrayList.addAll(Arrays.asList(mxGraphModel.getEdges(this.model, iterator, bl, bl2, bl3)));
        }
        arrayList.addAll(Arrays.asList(mxGraphModel.getEdges(this.model, object, bl, bl2, bl3)));
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        for (Object e : arrayList) {
            Object object3;
            mxCellState mxCellState2 = this.view.getState(e);
            Object object4 = mxCellState2 != null ? mxCellState2.getVisibleTerminal(true) : this.view.getVisibleTerminal(e, true);
            Object object5 = object3 = mxCellState2 != null ? mxCellState2.getVisibleTerminal(false) : this.view.getVisibleTerminal(e, false);
            if ((!bl3 || object4 != object3) && (object4 == object3 || (!bl || object3 != object || object2 != null && !this.isValidAncestor(object4, object2, bl4)) && (!bl2 || object4 != object || object2 != null && !this.isValidAncestor(object3, object2, bl4)))) continue;
            arrayList2.add(e);
        }
        return arrayList2.toArray();
    }

    public boolean isValidAncestor(Object object, Object object2, boolean bl) {
        return bl ? this.model.isAncestor(object2, object) : this.model.getParent(object) == object2;
    }

    public Object[] getOpposites(Object[] objectArray, Object object) {
        return this.getOpposites(objectArray, object, true, true);
    }

    public Object[] getOpposites(Object[] objectArray, Object object, boolean bl, boolean bl2) {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2;
                mxCellState mxCellState2 = this.view.getState(objectArray[i]);
                Object object3 = mxCellState2 != null ? mxCellState2.getVisibleTerminal(true) : this.view.getVisibleTerminal(objectArray[i], true);
                Object object4 = object2 = mxCellState2 != null ? mxCellState2.getVisibleTerminal(false) : this.view.getVisibleTerminal(objectArray[i], false);
                if (bl2 && object3 == object && object2 != null && object2 != object) {
                    linkedHashSet.add(object2);
                    continue;
                }
                if (!bl || object2 != object || object3 == null || object3 == object) continue;
                linkedHashSet.add(object3);
            }
        }
        return linkedHashSet.toArray();
    }

    public Object[] getEdgesBetween(Object object, Object object2) {
        return this.getEdgesBetween(object, object2, false);
    }

    public Object[] getEdgesBetween(Object object, Object object2, boolean bl) {
        Object[] objectArray = this.getEdges(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object3;
            mxCellState mxCellState2 = this.view.getState(objectArray[i]);
            Object object4 = mxCellState2 != null ? mxCellState2.getVisibleTerminal(true) : this.view.getVisibleTerminal(objectArray[i], true);
            Object object5 = object3 = mxCellState2 != null ? mxCellState2.getVisibleTerminal(false) : this.view.getVisibleTerminal(objectArray[i], false);
            if ((object4 != object || object3 != object2) && (bl || object4 != object2 || object3 != object)) continue;
            arrayList.add(objectArray[i]);
        }
        return arrayList.toArray();
    }

    public Object[] getCellsBeyond(double d, double d2, Object object, boolean bl, boolean bl2) {
        if (object == null) {
            object = this.getDefaultParent();
        }
        int n = this.model.getChildCount(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        if ((bl || bl2) && object != null) {
            for (int i = 0; i < n; ++i) {
                Object object2 = this.model.getChildAt(object, i);
                mxCellState mxCellState2 = this.view.getState(object2);
                if (!this.isCellVisible(object2) || mxCellState2 == null || bl && !(mxCellState2.getX() >= d) || bl2 && !(mxCellState2.getY() >= d2)) continue;
                arrayList.add(object2);
            }
        }
        return arrayList.toArray();
    }

    public List<Object> findTreeRoots(Object object) {
        return this.findTreeRoots(object, false);
    }

    public List<Object> findTreeRoots(Object object, boolean bl) {
        return this.findTreeRoots(object, bl, false);
    }

    public List<Object> findTreeRoots(Object object, boolean bl, boolean bl2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object != null) {
            int n = this.model.getChildCount(object);
            Object object2 = null;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3;
                Object object3 = this.model.getChildAt(object, i);
                if (!this.model.isVertex(object3) || !this.isCellVisible(object3)) continue;
                Object[] objectArray = this.getConnections(object3, bl ? object : null);
                int n4 = 0;
                int n5 = 0;
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    Object object4 = this.view.getVisibleTerminal(objectArray[n3], true);
                    if (object4 == object3) {
                        ++n4;
                        continue;
                    }
                    ++n5;
                }
                if (bl2 && n4 == 0 && n5 > 0 || !bl2 && n5 == 0 && n4 > 0) {
                    arrayList.add(object3);
                }
                int n6 = n3 = bl2 ? n5 - n4 : n4 - n5;
                if (n3 <= n2) continue;
                n2 = n3;
                object2 = object3;
            }
            if (arrayList.isEmpty() && object2 != null) {
                arrayList.add(object2);
            }
        }
        return arrayList;
    }

    public void traverse(Object object, boolean bl, mxICellVisitor mxICellVisitor2) {
        this.traverse(object, bl, mxICellVisitor2, null, null);
    }

    public void traverse(Object object, boolean bl, mxICellVisitor mxICellVisitor2, Object object2, Set<Object> set) {
        if (object != null && mxICellVisitor2 != null) {
            if (set == null) {
                set = new HashSet<Object>();
            }
            if (!set.contains(object)) {
                int n;
                set.add(object);
                if (mxICellVisitor2.visit(object, object2) && (n = this.model.getEdgeCount(object)) > 0) {
                    for (int i = 0; i < n; ++i) {
                        boolean bl2;
                        Object object3 = this.model.getEdgeAt(object, i);
                        boolean bl3 = bl2 = this.model.getTerminal(object3, true) == object;
                        if (bl && !bl2) continue;
                        Object object4 = this.model.getTerminal(object3, !bl2);
                        this.traverse(object4, bl, mxICellVisitor2, object3, set);
                    }
                }
            }
        }
    }

    public mxGraphSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public int getSelectionCount() {
        return this.selectionModel.size();
    }

    public boolean isCellSelected(Object object) {
        return this.selectionModel.isSelected(object);
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isEmpty();
    }

    public void clearSelection() {
        this.selectionModel.clear();
    }

    public Object getSelectionCell() {
        return this.selectionModel.getCell();
    }

    public void setSelectionCell(Object object) {
        this.selectionModel.setCell(object);
    }

    public Object[] getSelectionCells() {
        return this.selectionModel.getCells();
    }

    public void setSelectionCells(Object[] objectArray) {
        this.selectionModel.setCells(objectArray);
    }

    public void setSelectionCells(Collection<Object> collection) {
        if (collection != null) {
            this.setSelectionCells(collection.toArray());
        }
    }

    public void addSelectionCell(Object object) {
        this.selectionModel.addCell(object);
    }

    public void addSelectionCells(Object[] objectArray) {
        this.selectionModel.addCells(objectArray);
    }

    public void removeSelectionCell(Object object) {
        this.selectionModel.removeCell(object);
    }

    public void removeSelectionCells(Object[] objectArray) {
        this.selectionModel.removeCells(objectArray);
    }

    public void selectNextCell() {
        this.selectCell(true, false, false);
    }

    public void selectPreviousCell() {
        this.selectCell(false, false, false);
    }

    public void selectParentCell() {
        this.selectCell(false, true, false);
    }

    public void selectChildCell() {
        this.selectCell(false, false, true);
    }

    public void selectCell(boolean bl, boolean bl2, boolean bl3) {
        Object object = this.getSelectionCell();
        if (this.getSelectionCount() > 1) {
            this.clearSelection();
        }
        Object object2 = object != null ? this.model.getParent(object) : this.getDefaultParent();
        int n = this.model.getChildCount(object2);
        if (object == null && n > 0) {
            Object object3 = this.model.getChildAt(object2, 0);
            this.setSelectionCell(object3);
        } else if ((object == null || bl2) && this.view.getState(object2) != null && this.model.getGeometry(object2) != null) {
            if (this.getCurrentRoot() != object2) {
                this.setSelectionCell(object2);
            }
        } else if (object != null && bl3) {
            int n2 = this.model.getChildCount(object);
            if (n2 > 0) {
                Object object4 = this.model.getChildAt(object, 0);
                this.setSelectionCell(object4);
            }
        } else if (n > 0) {
            int n3 = ((mxICell)object2).getIndex((mxICell)object);
            if (bl) {
                this.setSelectionCell(this.model.getChildAt(object2, ++n3 % n));
            } else {
                int n4 = --n3 < 0 ? n - 1 : n3;
                this.setSelectionCell(this.model.getChildAt(object2, n4));
            }
        }
    }

    public void selectVertices() {
        this.selectVertices(null);
    }

    public void selectVertices(Object object) {
        this.selectCells(true, false, object);
    }

    public void selectEdges() {
        this.selectEdges(null);
    }

    public void selectEdges(Object object) {
        this.selectCells(false, true, object);
    }

    public void selectCells(boolean bl, boolean bl2) {
        this.selectCells(bl, bl2, null);
    }

    public void selectCells(final boolean bl, final boolean bl2, Object object) {
        if (object == null) {
            object = this.getDefaultParent();
        }
        Collection<Object> collection = mxGraphModel.filterDescendants(this.getModel(), new mxGraphModel.Filter(){

            @Override
            public boolean filter(Object object) {
                return mxGraph.this.view.getState(object) != null && mxGraph.this.model.getChildCount(object) == 0 && (mxGraph.this.model.isVertex(object) && bl || mxGraph.this.model.isEdge(object) && bl2);
            }
        });
        this.setSelectionCells(collection);
    }

    public void selectAll() {
        this.selectAll(null);
    }

    public void selectAll(Object object) {
        Object[] objectArray;
        if (object == null) {
            object = this.getDefaultParent();
        }
        if ((objectArray = mxGraphModel.getChildren(this.model, object)) != null) {
            this.setSelectionCells(objectArray);
        }
    }

    public void drawGraph(mxICanvas mxICanvas2) {
        this.drawCell(mxICanvas2, this.getModel().getRoot());
    }

    public void drawCell(mxICanvas mxICanvas2, Object object) {
        this.drawState(mxICanvas2, this.getView().getState(object), true);
        int n = this.model.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = this.model.getChildAt(object, i);
            this.drawCell(mxICanvas2, object2);
        }
    }

    public void drawState(mxICanvas mxICanvas2, mxCellState mxCellState2, boolean bl) {
        Object object;
        Object object2 = object = mxCellState2 != null ? mxCellState2.getCell() : null;
        if (object != null && object != this.view.getCurrentRoot() && object != this.model.getRoot() && (this.model.isVertex(object) || this.model.isEdge(object))) {
            Object object3;
            mxICanvas mxICanvas3;
            Object object4 = mxICanvas2.drawCell(mxCellState2);
            Object object5 = null;
            Shape shape = null;
            Rectangle rectangle = mxCellState2.getRectangle();
            mxICanvas mxICanvas4 = mxICanvas3 = this.isLabelClipped(mxCellState2.getCell()) ? mxICanvas2 : null;
            if (mxICanvas3 instanceof mxImageCanvas) {
                mxICanvas3 = ((mxImageCanvas)mxICanvas3).getGraphicsCanvas();
            }
            if (mxICanvas3 instanceof mxGraphics2DCanvas) {
                object3 = ((mxGraphics2DCanvas)mxICanvas3).getGraphics();
                shape = ((Graphics)object3).getClip();
                if (shape instanceof Rectangle) {
                    ((Graphics)object3).setClip(rectangle.intersection((Rectangle)shape));
                } else {
                    ((Graphics)object3).setClip(rectangle);
                }
            }
            if (bl && (object3 = mxCellState2.getLabel()) != null && mxCellState2.getLabelBounds() != null) {
                object5 = mxICanvas2.drawLabel((String)object3, mxCellState2, this.isHtmlLabel(object));
            }
            if (mxICanvas3 instanceof mxGraphics2DCanvas) {
                ((mxGraphics2DCanvas)mxICanvas3).getGraphics().setClip(shape);
            }
            if (object4 != null) {
                this.cellDrawn(mxICanvas2, mxCellState2, object4, object5);
            }
        }
    }

    protected void cellDrawn(mxICanvas mxICanvas2, mxCellState mxCellState2, Object object, Object object2) {
        String string;
        if (object instanceof Element && (string = this.getLinkForCell(mxCellState2.getCell())) != null) {
            Object object3;
            String string2 = this.getToolTipForCell(mxCellState2.getCell());
            Object object4 = (Element)object;
            if (object4.getNodeName().startsWith("v:")) {
                object4.setAttribute("href", string.toString());
                if (string2 != null) {
                    object4.setAttribute("title", string2);
                }
            } else if (object4.getOwnerDocument().getElementsByTagName("svg").getLength() > 0) {
                object3 = object4.getOwnerDocument().createElement("a");
                object3.setAttribute("xlink:href", string.toString());
                object4.getParentNode().replaceChild((Node)object3, (Node)object4);
                object3.appendChild((Node)object4);
                if (string2 != null) {
                    object3.setAttribute("xlink:title", string2);
                }
                object4 = object3;
            } else {
                object3 = object4.getOwnerDocument().createElement("a");
                object3.setAttribute("href", string.toString());
                object3.setAttribute("style", "text-decoration:none;");
                object4.getParentNode().replaceChild((Node)object3, (Node)object4);
                object3.appendChild((Node)object4);
                if (string2 != null) {
                    object3.setAttribute("title", string2);
                }
                object4 = object3;
            }
            if ((object3 = this.getTargetForCell(mxCellState2.getCell())) != null) {
                object4.setAttribute("target", (String)object3);
            }
        }
    }

    protected String getLinkForCell(Object object) {
        return null;
    }

    protected String getTargetForCell(Object object) {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        stringBuilder.append("model=");
        stringBuilder.append(this.model);
        stringBuilder.append(", view=");
        stringBuilder.append(this.view);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        log.info("mxGraph version \"3.9.11\"");
    }

    static {
        try {
            mxResources.add("com.mxgraph.resources.graph");
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Failed to add the resource bundle", exception);
        }
        imageBundles = new LinkedList<mxImageBundle>();
    }

    public static interface mxICellVisitor {
        public boolean visit(Object var1, Object var2);
    }
}

