<?php

use Symfony\Component\DependencyInjection\Argument\RewindableGenerator;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\ParameterNotFoundException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

/**
 * @internal This class has been auto-generated by the Symfony Dependency Injection Component.
 */
class Symfony_DI_PhpDumper_Test_Uninitialized_Reference extends Container
{
    protected $parameters = [];
    protected readonly \WeakReference $ref;

    public function __construct()
    {
        $this->ref = \WeakReference::create($this);
        $this->services = $this->privates = [];
        $this->methodMap = [
            'bar' => 'getBarService',
            'baz' => 'getBazService',
            'foo1' => 'getFoo1Service',
        ];

        $this->aliases = [];
    }

    public function compile(): void
    {
        throw new LogicException('You cannot compile a dumped container that was already compiled.');
    }

    public function isCompiled(): bool
    {
        return true;
    }

    public function getRemovedIds(): array
    {
        return [
            'foo2' => true,
            'foo3' => true,
        ];
    }

    /**
     * Gets the public 'bar' shared service.
     *
     * @return \stdClass
     */
    protected static function getBarService($container)
    {
        $containerRef = $container->ref;

        $container->services['bar'] = $instance = new \stdClass();

        $instance->foo1 = ($container->services['foo1'] ?? null);
        $instance->foo2 = null;
        $instance->foo3 = ($container->privates['foo3'] ?? null);
        $instance->closures = [#[\Closure(name: 'foo1', class: 'stdClass')] function () use ($containerRef) {
            $container = $containerRef->get();

            return ($container->services['foo1'] ?? null);
        }, #[\Closure(name: 'foo2')] fn () => null, #[\Closure(name: 'foo3', class: 'stdClass')] function () use ($containerRef) {
            $container = $containerRef->get();

            return ($container->privates['foo3'] ?? null);
        }];
        $instance->iter = new RewindableGenerator(function () use ($containerRef) {
            $container = $containerRef->get();

            if (isset($container->services['foo1'])) {
                yield 'foo1' => ($container->services['foo1'] ?? null);
            }
            if (false) {
                yield 'foo2' => null;
            }
            if (isset($container->privates['foo3'])) {
                yield 'foo3' => ($container->privates['foo3'] ?? null);
            }
        }, function () use ($containerRef) {
            $container = $containerRef->get();

            return 0 + (int) (isset($container->services['foo1'])) + (int) (false) + (int) (isset($container->privates['foo3']));
        });

        return $instance;
    }

    /**
     * Gets the public 'baz' shared service.
     *
     * @return \stdClass
     */
    protected static function getBazService($container)
    {
        $container->services['baz'] = $instance = new \stdClass();

        $instance->foo3 = ($container->privates['foo3'] ??= new \stdClass());

        return $instance;
    }

    /**
     * Gets the public 'foo1' shared service.
     *
     * @return \stdClass
     */
    protected static function getFoo1Service($container)
    {
        return $container->services['foo1'] = new \stdClass();
    }
}
