<?php

namespace setasign\Fpdi\functional\PdfParser\Filter;

use PHPUnit\Framework\TestCase;
use setasign\Fpdi\PdfParser\Filter\Flate;
use setasign\Fpdi\PdfParser\Filter\FlateException;

class FlateTest extends TestCase
{
    public function decodeProvider()
    {
        return array(
            ['', ''],
            ["\x78\x9c\xF3\x48\xCC\xC9\xC9\x57\x08\x4F\xCD\x29\x01\x00\x13\xA8\x03\xAD", 'Hallo Welt'],
            ["\x78\x3F\xF3\x48\xCC\xC9\xC9\x57\x08\x4F\xCD\x29\x01\x00", 'Hallo Welt'],
            // This is the compressed-crossreference with an invalid checksum
            [
                "\x78\x9c\x62\x64\x60\xd9\xf1\x8b\x81\x81\x91\x81\x65\xe7\x2a\x30\xb5\x6b\x07\x98\xda\x7d\x1e\x4c\xed\x55\x03\x53\xfb\x6a\x19\x18\x00\x00\x00\x00\xff\xff",
                "\x01\x00\x04\xb8\xfa\x00\x00\x01\x00\x04\xb9\xaa\x00\x00\x01\x00\x04\xba\xb8\x00\x00\x01\x00\x04\xbb\xcf\x00\x00\x01\x00\x04\xbd\x26\x00\x00\x01\x00\x04\xbe\x7d\x00\x00"
            ],
            [
                hex2bin('789c626460174b6060606460177f0ca624de8329292630252d09a6644cc1946c049892eb04530a86604ab10e4c29298129e55c30a5b2034ca9898029f524060600000000ffff'),
                hex2bin('0100071660000001000717e3000001000718ef00000100071a0200000100071b1900000100071c3500000100071d5800000100071e89000001000720310000010007217e000001000722220000010007236d000001000724b800000100072614000001000727620000')
            ],
            [
                hex2bin('789c24cf394b02700040f1bf43383a358448383be9d2281e691a791f85b77984468a592adea20dcdd1a2207e02411071567010829c83b6a0cd555c84e7f41b1f4f22a4da85101221d59940ef0343148c45b8ec80e913cc23b89a826505d61fb8dec18d0c6c0ab0ebc0e10067005cafe03e163cefe01d826f06fe35dc6ee06e0b815308aa21e48570102219882a212687780aee27901490b2437a000fff90b9806c0f1ebfe1e91c7259c8cfa17002cfc7a3621f5efea0a48172132a5f503d835a02ea6368eca16586f607747ea1ab825e09de96421c000000ffff'),
                hex2bin('0100073fc3000001000741460000010007425600000100074360000001000744740000010007458200000100074696000001000747a1000001000748b5000001000749c700000100074adc00000100074bf900000100074d0f00000100074e1d00000100074f41000001000750500000010007515b00000100075276000001000753740000010007548a0000010007559f000001000756b7000001000757cb000001000758d2000001000759f000000100075b1500000100075c3100000100075d5500000100075e5c00000100075f6a000001000760210000010007611b00000100076266000001000763b2000001000765000000010007664f0000010007679c000001000768e900000100076a3700000100076b8500000100076cd100000100076e1f00000100076f6b000001000770b900000100077205000001000773500000010007749b000001000775e6000001000777320000010007787f000001000779ce00000100077b1900000100077c6400000100077daf00000100077efb0000010007804700000100078194000001000782df0000010007842b00000100078577000001000786c40000')
            ],
            [
                hex2bin('789c6264607be0ccc0c0c8c0f6f038987af41e4c3d6107534f95c1d4334330f5dc1d4cbd4804532fa783a95797c0d4eba760eacd7730f58e194cbd6701531f92c0d4c75d60eab31098fa9205a6be1e0253df25c1d48f4230f5f30498fa2d0fa6fe9481a9bf67191800000000ffff'),
                hex2bin('010006e0430000010006e1c70000010006e2ef0000010006e4070000010006e5230000010006e6310000010006e7470000010006e8610000010006e9970000010006ead20000010006ebe50000010006ecf70000010006ee030000010006ef040000010006f0620000010006f1ba0000010006f3120000010006f46a0000010006f5c20000010006f7190000010006f8710000010006f9c80000010006fb1f0000010006fc760000010006fdcd0000')
            ],
            [
                hex2bin('58857595cd6edb301084ef05fa0e3cb6e84111c9251dc030102408e0437f50370f4049942b2096045a3ef8ed2b698cd89a26bc18fa44d2b3331457298cec71fbb46d9b4165bf5257eee2a0eaa6ad523c76a7544655c47dd37efe7499ac72adaaa61c18cf8fe521f45734edbb3b1f8778d8b67577e5ebb5ca7e8fd38f433aab2f0fd378fcf6909af0fad2366557c5af2afb99aa989a76ffd1fbdda9ef5fe321b683ba539b8daa627dfbc7df43ff231ca2cade59fdcedc3fe73e2abd7c915f4a1a571cfb50c614da7dbc29e26e1c1bb57e1ec7e68a635b7db4c25d762ceaf26f48ffef34ff2cb199b1662cc09a7001bc225c02df13ae81cb25cea144578473e04818020d09cc2d704ed8011bc22b60217c0fec0807604f18c51b2a3eaf80c3126b28b1a4447b604b18022d09d4106849a086124b4a3462b01483460c96623088c1520c4603d7841183500c063108c560707c848e8f8127429e187822e48941f142c51ba423948e8512474a2c94385262a1c491120b258e9458a4e3281d0b818e045a08742c10a1390acd223447a1599c2a47a7ca224b47590ab27494a5e09372f44909227614b120624f110b8cf564acc0584fc60a8cf564acc0584fc60a8cf564acc0584fc60a8cf564acc0584fc6ae303b50f1abc96f9df3cd564c56e9e9b65962034c7e171698fc2e1cf06d96e36dcdb7f174812fbad85b2f294f298dfd666e7e73d798fa45d3c6b746d977fd621f7af807a772b731'),
                hex2bin('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')
            ]
        );
    }

    /**
     * @dataProvider decodeProvider
     */
    public function testDecode($in, $expected)
    {
        $filter = new Flate();

        $decoded = $filter->decode($in);

        $this->assertSame($expected, $decoded);
    }

    /**
     * @covers \setasign\Fpdi\PdfParser\Filter\Flate::decode
     */
    public function testDecodeWithoutZlib()
    {
        $mock = $this->getMockBuilder(Flate::class)
            ->setMethods(['extensionLoaded'])
            ->getMock();

        $mock->expects($this->once())
            ->method('extensionLoaded')
            ->will($this->returnValue(false));

        $this->expectException(FlateException::class);
        $this->expectExceptionCode(FlateException::NO_ZLIB);
        $mock->decode("\x78\x9c\xF3\x48\xCC\xC9\xC9\x57\x08\x4F\xCD\x29\x01\x00\x13\xA8\x03\xAD");
    }
}
