# Change Log for PHPCSUtils for PHP CodeSniffer

All notable changes to this project will be documented in this file.

This projects adheres to [Keep a CHANGELOG](https://keepachangelog.com/) and uses [Semantic Versioning](https://semver.org/).


## [Unreleased]

_Nothing yet._


## [1.0.0] - 2023-01-04

For the full list of features, please see the changelogs of the alpha/rc releases:
* [1.0.0-rc1](https://github.com/PHPCSStandards/PHPCSUtils/releases/tag/1.0.0-rc1)
* [1.0.0-alpha4](https://github.com/PHPCSStandards/PHPCSUtils/releases/tag/1.0.0-alpha4)
* [1.0.0-alpha3](https://github.com/PHPCSStandards/PHPCSUtils/releases/tag/1.0.0-alpha3)
* [1.0.0-alpha2](https://github.com/PHPCSStandards/PHPCSUtils/releases/tag/1.0.0-alpha2)
* [1.0.0-alpha1](https://github.com/PHPCSStandards/PHPCSUtils/releases/tag/1.0.0-alpha1)

### Changed

#### Other

* Minor documentation improvements.
* Maintainability improvements.


## [1.0.0-rc1] - 2022-12-27

### Added

#### Tokens

* New [`Collections::constantModifierKeywords()`][`Collections`] method. [#400]
* New [`Collections::listOpenTokensBC()`][`Collections`] method. [#405]

### Changed

#### Utils

* `ObjectDeclarations::getClassProperties()`: the array return value will now include `'abstract_token'`, `'final_token'`, and `'readonly_token'` indexes identifying the stack pointers to these keyword, where applicable. If the keyword is not used, the value will be set to `false`. [#401]

#### Other

* Various housekeeping and CI maintainance.

### Removed

Everything which was previously deprecated in the [1.0.0-alpha4 release], has now been removed. [#410]

This includes:
* The `PHPCS23Utils` standard.
* [`Collections`] class: direct access to the properties in the class.
* [`Collections`] class: the `Collections::arrowFunctionTokensBC()`, `Collections::functionDeclarationTokensBC()`, `Collections::parameterTypeTokensBC()`, `Collections::propertyTypeTokensBC()` and `Collections::returnTypeTokensBC()` methods.
* The `ControlStructures::getDeclareScopeOpenClose()` method.
* The `FunctionDeclarations::getArrowFunctionOpenClose()` method.
* The `FunctionDeclarations::isArrowFunction()` method.

See the changelog for the [1.0.0-alpha4 release] for details about replacements for the removed functionality.

### Fixed

#### Utils

* `Arrays::getOpenClose()`: small efficiency fix. [#406]
* `ControlStructures::hasBody()`: correctly identify that a control structure does not have a body - `'has_body' = false` -, when the control structure is ended by a PHP close tag. [#403]
* `Lists::getOpenClose()`: small efficiency fix. [#407]

[1.0.0-alpha4 release]: https://github.com/PHPCSStandards/PHPCSUtils/releases/tag/1.0.0-alpha4

[#400]: https://github.com/PHPCSStandards/PHPCSUtils/pull/400
[#401]: https://github.com/PHPCSStandards/PHPCSUtils/pull/401
[#403]: https://github.com/PHPCSStandards/PHPCSUtils/pull/403
[#405]: https://github.com/PHPCSStandards/PHPCSUtils/pull/405
[#406]: https://github.com/PHPCSStandards/PHPCSUtils/pull/406
[#407]: https://github.com/PHPCSStandards/PHPCSUtils/pull/407
[#410]: https://github.com/PHPCSStandards/PHPCSUtils/pull/410


## [1.0.0-alpha4] - 2022-10-25

Notes:
* While still in alpha, some BC-breaks may be introduced. These are clearly indicated in the changelog with the :warning: symbol.
* Until PHPCS 4.x has been released, PHPCSUtils does not formally support it, though an effort is made to keep up with the changes and anticipate potential compatibility issues.
    For testing purposes only, the composer configuration allows for PHPCSUtils to be installed with PHPCS 4.x.

### Breaking Changes

Support for PHP_CodeSniffer < 3.7.1 has been dropped after consultation with the principle external standards which depend on PHPCSUtils. [#347]

This was unfortunately necessary as the incessant additions of new syntaxes since PHP 7.4 made it impossible to continue to support PHPCS < 3.7.1, while still providing reliable results for modern PHP code.

### Added

Now support for PHPCS < 3.7.1 has been dropped, this edition adds support to all functionality in PHPCSUtils for new syntaxes and features from PHP 8.0 and 8.1 and preliminary support for PHP 8.2.

This means that support for the following syntaxes/features has been added (or existing support verified/improved):
* PHP 7.4
    - Array unpacking in array expressions.
* PHP 8.0
    - The `mixed` type. [#163]
    - Union types, including supporting the `false` and `null` types. [#168], [#225]
    - Constructor property promotion. [#169], [#226]
    - Nullsafe object operators. [#176], [#183]
    - Namespaced names as single token (cross-version PHPCS 3.x vs 4.x). [#205], [#206], [#207], [#208], [#209], [#210], [#211], [#212], [#213], [#217], [#241]
    - Dereferencing of interpolated text strings.
    - Named arguments in function calls. [#235], [#243], [#383]
    - Match expressions. [#247], [#335], [#356]
    - Trailing commas in parameter lists and closure `use` lists.
    - Attributes. [#357]
* PHP 8.1
    - Enumerations. [#285], [#358]
    - Explicit octal notation. [#293]
    - Array unpacking with string keys.
    - `never` type.
    - Named parameters after argument unpacking. [#383]
    - First class callables. [#362]
    - Readonly properties. [#363]
    - `new` in initializers.
    - Intersection types. [#365]
* PHP 8.2
    - Constants in traits. [#366]
    - Readonly classes. [#367]
    - `true` type. [#368]
    - `null` and `false` as stand-alone types.

Please report any bugs/oversights you encounter!

#### PHPCS Backcompat

* `BCTokens::magicConstants()` as introduced in PHPCS 3.5.6. [#172]
    The same token array previously already existed in PHPCSUtils as `Collections::$magicConstants` (which has now been deprecated).

#### TestUtils

* New [`UtilityMethodTestCase::usesPhp8NameTokens()`][UtilityMethodTestCase::usesPhp8NameTokens] method as a helper for tests using token position calculations when testing against both PHPCS 3.x as well as 4.x. [#200], [#217], [#241]

#### Tokens

* New [`PHPCSUtils\Tokens\TokenHelper`][`TokenHelper`] class: Utility functions for working with tokens and token collections. [#304]
    This class initially contains a `tokenExists()` method to work around potential interference from PHP-Parser also backfilling tokens.
    :point_right: External standards using a function call to `defined()` to determine whether a token is available should replace those with a function call to the `TokenHelper::tokenExists()` method.
* New [`Collections::arrayOpenTokensBC()`][`Collections`] method. [#233], [#311]
* New [`Collections::functionCallTokens()`][`Collections`] method to retrieve the tokens which can represent function calls and function-call-like language constructs, like class instantiations. [#233]
* New [`Collections::nameTokens()`][`Collections`] method to retrieve the tokens which can be used for "names", be it namespace, OO, function or constant names. [#204], [#217]
* New [`Collections::namespacedNameTokens()`][`Collections`] method to retrieve the tokens which can be encountered in a fully, partially or unqualified name and in namespace relative names. [#202], [#217]
* New [`Collections::parameterPassingTokens()`][`Collections`] method to retrieve the tokens which can be passed to the methods in the [`PassedParameters`] class. [#233]
* New [`Collections::phpOpenTags()`][`Collections`] method. [#254]
* New [`Collections::shortArrayListOpenTokensBC()`][`Collections`] method. [#381]

#### Utils

* New [`PHPCSUtils\Utils\Context`][`Context`] class: Utility functions to determine the context in which an arbitrary token is used. [#219]. [#390]
    Initial set of available methods: `inEmpty()`, `inIsset()`, `inUnset()`, `inAttribute`, `inForeachCondition()` and `inForCondition()`.
* New [`PHPCSUtils\Utils\MessageHelper`][`MessageHelper`] class: Utility functions for creating error/warning messages. [#249], [#391]
    Initial set of available methods: `addMessage()`, `addFixableMessage()`, `stringToErrorcode()` and `showEscapeChars()`.
* New [`PHPCSUtils\Utils\PassedParameters::getParameterFromStack()`][PassedParameters::getParameterFromStack] efficiency method to retrieve a potentially named function call parameter from a parameter information stack as previously retrieved via `PassedParameters::getParameters()`. [#235], [#237], [#383]
* New [`PHPCSUtils\Utils\TextStrings::getEndOfCompleteTextString()`][TextStrings::getEndOfCompleteTextString] method. [#320]
    This method allows to retrieve the stack pointer to the last token within a - potentially multi-line - text string.
    This method compliments the `TextStrings::getCompleteTextString()` method which will retrieve the contents of the complete text string.
* New [`PHPCSUtils\Utils\TextStrings::getEmbeds()`][TextStrings::getEmbeds] method to retrieve an array with all variables/expressions as embedded in a text string. [#321]
* New [`PHPCSUtils\Utils\TextStrings::stripEmbeds()`][TextStrings::stripEmbeds] method to strip all embedded variables/expressions from a text string.  [#321]
* New [`PHPCSUtils\Utils\TextStrings::getStripEmbeds()`][TextStrings::getStripEmbeds] method. [#321]
    This method is `public` for those rare cases where both the embeds, as well as the text stripped off embeds, is needed.
* New [`PHPCSUtils\Utils\UseStatements::mergeImportUseStatements()`][UseStatements::mergeImportUseStatements] method. [#196]

#### Other

* PHPCSUtils will now cache the results of (potentially) token walking intensive or processing intensive function calls during a run. [#332], [#377]
    This should significantly improve performance when multiple sniffs call these functions for the same token during a PHPCS run.
    The results of the following functions will now be cached:
    - `Arrays::getDoubleArrowPtr()`
    - `Arrays::isShortArray()`
    - `FunctionDeclarations::getParameters()`
    - `Lists::getAssignments()`
    - `Lists::isShortList()`
    - `Namespaces::findNamespacePtr()`
    - `PassedParameters::getParameters()`
    - `TextStrings::getEndOfCompleteTextString()`
    - `TextStrings::getStripEmbeds()`
    - `UseStatements::splitImportUseStatement()`

### Changed

#### PHPCS Backcompat

* All token array methods in the [`BCTokens`] class are fully up-to-date with the upstream `PHP_CodeSniffer\Util\Tokens` properties as per PHPCS `master` at the time of this release. [#327], [#347], [#360]
* All methods in the [`BCFile`] class are fully up-to-date with the upstream `PHP_CodeSniffer\Files\File` methods as per PHPCS `master` at the time of this release. [#347]
* `BCFile::getMethodParameters()`: forward compatibility with PHPCS 4.x in which closure `use` will be a parenthesis owner. [#251]
* If a non-existent token array is requested from the `BCTokens` class, a `PHPCSUtils\Exceptions\InvalidTokenArray` exception will be thrown. [#344]
    The `PHPCSUtils\Exceptions\InvalidTokenArray` exception extends the PHPCS native `PHP_CodeSniffer\Exceptions\RuntimeException`.
    Previously, an empty array would be returned.

#### TestUtils

* `UtilityMethodTestCase`: all properties contained in the test case class will now always be reset after the tests have run. [#325]
* `UtilityMethodTestCase::getTargetToken()`: when the target token cannot be found, the method will now throw a (catchable) `PHPCSUtils\Exceptions\TestTargetNotFound` exception instead of failing the test. [#248], [#371]
    If uncaught, this means that the test will be marked as _errored_ instead of _failed_.
* `UtilityMethodTestCase::getTargetToken()`: this method is now `static`, which allows for it to be used in "set up before class" fixtures. [#382]. [#385]

#### Tokens

* `Collections::functionCallTokens()` and `Collections::parameterPassingTokens()`: now include the `T_PARENT` token. [#328]
    This accounts for a change in PHPCS 3.7.0 for how `parent` in `new parent` is tokenized.
* If a non-existent token array is requested from the `Collections` class, a `PHPCSUtils\Exceptions\InvalidTokenArray` exception will be thrown. [#349]
    The `PHPCSUtils\Exceptions\InvalidTokenArray` exception extends the PHPCS native `PHP_CodeSniffer\Exceptions\RuntimeException`.

#### Utils

* `Arrays::isShortArray()`/`Lists::isShortList()`: the underlying logic has been completely refactored for improved accuracy and improved performance. [#392]
* `FunctionDeclarations::getParameters()`: the return array of the method may contain two new keys - `property_visibility` and `visibility_token`. [#169]
    These keys will only be included if constructor property promotion is detected.
* `FunctionDeclarations::getParameters()`: forward compatibility with PHPCS 4.x in which closure `use` will be a parenthesis owner. [#251]
* [`GetTokensAsString`]: previously the `tabReplaced()` method was an alias for the `normal()` method. This has now been reversed. [#297]
* `Operators::isReference()`: forward compatibility with PHPCS 4.x in which closure `use` will be a parenthesis owner. [#195]
* [`Parentheses`]: all methods will now recognize `isset()`, `unset()`, `empty()`, `exit()`, `die()` and `eval()` as parentheses owners. [#215]
    Note: PHPCS natively does not recognize these constructs as parentheses owners, though this _may_ change in the future. See: [PHPCS#3118]
* [`PassedParameters`]: all methods will now recognize anonymous class instantiations as constructs which can pass parameters. [#234]
* `PassedParameters::getParameters()`: when a named parameter is encountered in a function call, the returned parameter information array for that parameter will now contain the following additional keys: `'name'`, `'name_token'` and the top-level index for the parameter will be set to the parameter `'name'` instead of its position. [#235], [#243], [#383]
    The existing `'start'`, `'end'`, `'raw'` and `'clean'` keys will contain the same content as before: the information about the parameter value (excluding the name part).
* `PassedParameters::getParameters()`: new, optional parameter `$limit` to allow for limiting the number of parameters/array items to be parsed. [#261]
    This allows for higher efficiency when retrieving the parameters/array entries, especially for large arrays if only the first few entries need to be examined.
    Use with care on function calls, as this can break support for named parameters!
* `PassedParameters::getParameters()`: new, optional parameter `$isShortArray` to allow for skipping the "is short array" check for predetermined short arrays. [#269], [#270]
     Use judiciously and with extreme care!
* `PassedParameters::getParameter()`: new _semi-optional_ `$paramNames` parameter to allow for retrieving a parameter from a function call using named parameters. [#235]
    :warning: This parameter is **_required_** when examining a function call and an exception will be thrown if it was not passed.
    This new `$paramNames` parameter allows for passing either the parameter name as a _string_ or as an _array of strings_.
    _While a parameter can only have one name, a lot of packages have been, and may still be, reviewing and renaming parameters to more descriptive names to support named parameters in PHP 8.0, so, to allow for supporting multiple versions of packages, different names can be used for the same parameter in a PHP 8.0+ function call and by allowing multiple names to be passed, the method supports this._
* `PassedParameters::getParameter()`: efficiency improvement applicable to function calls not using named parameters and arrays. [#261], [#262]
* `PassedParameters::hasParameters()`: now allows for the `T_PARENT` token for `new parent()` class instantiations. [#328]
    This accounts for a change in PHPCS 3.7.0 regarding how `parent` in `new parent` is tokenized.
* `PassedParameters::hasParameters()`: new, optional parameter `$isShortArray` to allow for skipping the "is short array" check for predetermined short arrays. [#269], [#270]
     Use judiciously and with extreme care!
* `UseStatements::getType()`: forward compatibility with PHPCS 4.x in which closure `use` will be a parenthesis owner. [#251]

#### Other

* The `master` branch has been renamed to `stable`. [#397]
* :warning: All non-`abstract` classes in this package are now `final`. [#376]
* The parameter names in various function declarations have been changed to not intersect with reserved keywords. [#256]
    :warning: In the unlikely event an external standard using PHPCSUtils would be using function calls with named parameters, the parameter names will need to be updated to match.
* Composer: The package will now identify itself as a static analysis tool. Thanks [@GaryJones]! [#341]
* Readme/website homepage: the installation instructions have been updated to include information on installing this library and the included [Composer PHPCS plugin] in combination with Composer >= 2.2. [#291], [#292]
* Various documentation improvements. [#216], [#309], [#394], [#395], [#396], [#398]
* Various housekeeping and CI maintainance.
    Amongst other things, CI is now run via GitHub Actions ([#239]), the PHPCSUtils native tests now use the [PHPUnit Polyfills] package ([#277]) and the tests are now run against PHP 5.4 - 8.2.

### Deprecated

:warning: Everything which has currently been deprecated, will be removed before the final `1.0.0` version of PHPCSUtils is tagged.

#### Tokens

[`Collections`] class: direct access to the properties in the class is now deprecated for forward-compatibility reasons.
All properties have a replacement which should be used instead, in most cases this will be a method with the same name as the previously used property,

| Deprecated                                                    | Replacement                                                                                          | PR             | Remarks                                  |
|---------------------------------------------------------------|------------------------------------------------------------------------------------------------------|----------------|------------------------------------------|
| `Collections::$alternativeControlStructureSyntaxTokens`       | `Collections::alternativeControlStructureSyntaxes()`                                                 | [#311]         | Mind the change in the name!             |
| `Collections::$alternativeControlStructureSyntaxCloserTokens` | `Collections::alternativeControlStructureSyntaxClosers()`                                            | [#311]         | Mind the change in the name!             |
| `Collections::$arrayTokens`                                   | `Collections::arrayTokens()`                                                                         | [#311]         |                                          |
| `Collections::$arrayTokensBC`                                 | `Collections::arrayTokensBC()`                                                                       | [#311]         |                                          |
| `Collections::$classModifierKeywords`                         | `Collections::classModifierKeywords()`                                                               | [#311]         |                                          |
| `Collections::$closedScopes`                                  | `Collections::closedScopes()`                                                                        | [#311]         |                                          |
| `Collections::$controlStructureTokens`                        | `Collections::controlStructureTokens()`                                                              | [#311]         |                                          |
| `Collections::$incrementDecrementOperators`                   | `Collections::incrementDecrementOperators()`                                                         | [#311]         |                                          |
| `Collections::$listTokens`                                    | `Collections::listTokens()`                                                                          | [#311]         |                                          |
| `Collections::$listTokensBC`                                  | `Collections::listTokensBC()`                                                                        | [#311]         |                                          |
| `Collections::$magicConstants`                                | `PHPCSUtils\BackCompat\BCTokens::magicConstants()` or `PHP_CodeSniffer\Util\Tokens::$magicConstants` | [#311]         |                                          |
| `Collections::$namespaceDeclarationClosers`                   | `Collections::namespaceDeclarationClosers()`                                                         | [#311]         |                                          |
| `Collections::$objectOperators`                               | `Collections::objectOperators()`                                                                     | [#176]         |                                          |
| `Collections::$OOCanImplement`                                | `Collections::ooCanImplement()`                                                                      | [#311]         | Mind the case change in the `oo` prefix! |
| `Collections::$OOCanExtend`                                   | `Collections::ooCanExtend()`                                                                         | [#311]         | Mind the case change in the `oo` prefix! |
| `Collections::$OOConstantScopes`                              | `Collections::ooConstantScopes()`                                                                    | [#311]         | Mind the case change in the `oo` prefix! |
| `Collections::$OOPropertyScopes`                              | `Collections::ooPropertyScopes()`                                                                    | [#311]         | Mind the case change in the `oo` prefix! |
| `Collections::$OOHierarchyKeywords`                           | `Collections::ooHierarchyKeywords()`                                                                 | [#311]         | Mind the case change in the `oo` prefix! |
| `Collections::$OONameTokens`                                  | `Collections::namespacedNameTokens()`                                                                | [#202]         | Mind the change name!                    |
| `Collections::$parameterTypeTokens`                           | `Collections::parameterTypeTokens()`                                                                 | [#168]         |                                          |
| `Collections::$propertyModifierKeywords`                      | `Collections::propertyModifierKeywords()`                                                            | [#311]         |                                          |
| `Collections::$propertyTypeTokens`                            | `Collections::propertyTypeTokens()`                                                                  | [#168]         |                                          |
| `Collections::$returnTypeTokens`                              | `Collections::returnTypeTokens()`                                                                    | [#168]         |                                          |
| `Collections::$shortArrayTokens`                              | `Collections::shortArrayTokens()`                                                                    | [#311]         |                                          |
| `Collections::$shortArrayTokensBC`                            | `Collections::shortArrayTokensBC()`                                                                  | [#311]         |                                          |
| `Collections::$shortListTokens`                               | `Collections::shortListTokens()`                                                                     | [#311]         |                                          |
| `Collections::$shortListTokensBC`                             | `Collections::shortListTokensBC()`                                                                   | [#311]         |                                          |
| `Collections::$textStingStartTokens`                          | `Collections::textStringStartTokens()`                                                               | [#311], [#319] | Mind the fixed typo in the name!         |

Additionally, the following methods in the `Collections` class have been deprecated:

| Deprecated                                   | Replacement                                | PR     |
|----------------------------------------------|--------------------------------------------|--------|
| `Collections::arrowFunctionTokensBC()`       | Use the `T_FN` token instead.              | [#347] |
| `Collections::functionDeclarationTokensBC()` | `Collections::functionDeclarationTokens()` | [#347] |
| `Collections::parameterTypeTokensBC()`       | `Collections::parameterTypeTokens()`       | [#347] |
| `Collections::propertyTypeTokensBC()`        | `Collections::propertyTypeTokens()`        | [#347] |
| `Collections::returnTypeTokensBC()`          | `Collections::returnTypeTokens()`          | [#347] |

#### Utils

* `ControlStructures::getDeclareScopeOpenClose()`: this method is no longer needed, check the `scope_opener`/`scope_closer` on the `T_DECLARE` token instead. [#347]
* `FunctionDeclarations::getArrowFunctionOpenClose()`: this method is no longer needed, check the `scope_opener`/`scope_closer` etc on the `T_FN` token instead. [#347]
* `FunctionDeclarations::isArrowFunction()`: this method is no longer needed, use the `T_FN` token instead. [#347]

#### Other

* The `PHPCS23Utils` standard, which is no longer needed now support for PHPCS < 3.7.1 has been dropped. [#347]

### Removed

* Support for PHPCS < 3.7.1. [#347]

#### Utils

* The following constants, which were only intended for internal use, have been removed: [#347]
    - `PHPCSUtils\Utils\Numbers::REGEX_NUMLIT_STRING`
    - `PHPCSUtils\Utils\Numbers::REGEX_HEX_NUMLIT_STRING`
    - `PHPCSUtils\Utils\Numbers::UNSUPPORTED_PHPCS_VERSION`

### Fixed

#### Abstract Sniffs

* `AbstractArrayDeclarationSniff::getActualArrayKey()`: will now handle escaped vars in heredoc array keys better. [#379]

#### Fixers

* [`SpacesFixer`]: in a specific new line vs trailing comment situation, the fixer would incorrectly add a stray new line. [#229]

#### TestUtils

* `UtilityMethodTestCase::getTargetToken()`: will now throw a `PHPCSUtils\Exceptions\TestMarkerNotFound` exception if the provided test marker comment is not found. [#273], [#372]
    This prevents the method potentially misidentifying the target token.

#### Tokens

* `Collections::parameterTypeTokens()`, `Collections::propertyTypeTokens()` and `Collections::returnTypeTokens()`: include the `namespace` keyword for namespace relative identifier names. [#180]

#### Utils

* `Arrays::isShortArray()`/`Lists::isShortList()`: fixed a number of bugs which previously resulted in an incorrect short list/short array determination. [#392]
* `FunctionDeclarations::getParameters()`: will now correctly recognize namespace relative names when used in a parameter type. [#180]
* `FunctionDeclarations::getProperties()`: will now correctly recognize namespace relative names when used in the return type. [#180]
* `ObjectDeclarations::findExtendedClassName()`: will now correctly recognize namespace relative names when used as the _extended_ parent class name. [#181]
* `ObjectDeclarations::findExtendedInterfaceNames()`: will now correctly recognize namespace relative names when used in _extended_ interface names. [#181]
* `ObjectDeclarations::findImplementedInterfaceNames()`: will now correctly recognize namespace relative names when used in _implemented_ interface names. [#181]
* `ObjectDeclarations::getClassProperties()`: will now correctly handle classes declared with both the `final` as well as the `abstract` keyword. [#252]
* `Operators::isReference()`: if one parameter in a function declaration was passed by reference, then all `T_BITWISE_AND` (not intersection type `&`'s) tokens would be regarded as references. [#188]
* `Operators::isReference()`: the `&` would not be recognized as a reference for arrow function parameters passed by reference. [#192]
* `Operators::isUnaryPlusMinus()`: a preceding `exit`, `break`, `continue` or arrow function `=>` is now recognized as an indicator that a plus/minus sign is unary. [#187], [#197]
* `Variables::getMemberProperties()`: will now correctly recognize namespace relative names when used in a property type. [#180]

[UtilityMethodTestCase::usesPhp8NameTokens]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-TestUtils-UtilityMethodTestCase.html#method_usesPhp8NameTokens
[PassedParameters::getParameterFromStack]:   https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-PassedParameters.html#method_getParameterFromStack
[TextStrings::getEndOfCompleteTextString]:   https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-TextStrings.html#method_getEndOfCompleteTextString
[TextStrings::getEmbeds]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-TextStrings.html#method_getEmbeds
[TextStrings::getStripEmbeds]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-TextStrings.html#method_getStripEmbeds
[TextStrings::stripEmbeds]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-TextStrings.html#method_stripEmbeds
[UseStatements::mergeImportUseStatements]:   https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-UseStatements.html#method_mergeImportUseStatements

[#163]: https://github.com/PHPCSStandards/PHPCSUtils/pull/163
[#168]: https://github.com/PHPCSStandards/PHPCSUtils/pull/168
[#169]: https://github.com/PHPCSStandards/PHPCSUtils/pull/169
[#172]: https://github.com/PHPCSStandards/PHPCSUtils/pull/172
[#176]: https://github.com/PHPCSStandards/PHPCSUtils/pull/176
[#180]: https://github.com/PHPCSStandards/PHPCSUtils/pull/180
[#181]: https://github.com/PHPCSStandards/PHPCSUtils/pull/181
[#183]: https://github.com/PHPCSStandards/PHPCSUtils/pull/183
[#187]: https://github.com/PHPCSStandards/PHPCSUtils/pull/187
[#188]: https://github.com/PHPCSStandards/PHPCSUtils/pull/188
[#192]: https://github.com/PHPCSStandards/PHPCSUtils/pull/192
[#195]: https://github.com/PHPCSStandards/PHPCSUtils/pull/195
[#196]: https://github.com/PHPCSStandards/PHPCSUtils/pull/196
[#197]: https://github.com/PHPCSStandards/PHPCSUtils/pull/197
[#200]: https://github.com/PHPCSStandards/PHPCSUtils/pull/200
[#202]: https://github.com/PHPCSStandards/PHPCSUtils/pull/202
[#204]: https://github.com/PHPCSStandards/PHPCSUtils/pull/204
[#205]: https://github.com/PHPCSStandards/PHPCSUtils/pull/205
[#206]: https://github.com/PHPCSStandards/PHPCSUtils/pull/206
[#207]: https://github.com/PHPCSStandards/PHPCSUtils/pull/207
[#208]: https://github.com/PHPCSStandards/PHPCSUtils/pull/208
[#209]: https://github.com/PHPCSStandards/PHPCSUtils/pull/209
[#210]: https://github.com/PHPCSStandards/PHPCSUtils/pull/210
[#211]: https://github.com/PHPCSStandards/PHPCSUtils/pull/211
[#212]: https://github.com/PHPCSStandards/PHPCSUtils/pull/212
[#213]: https://github.com/PHPCSStandards/PHPCSUtils/pull/213
[#215]: https://github.com/PHPCSStandards/PHPCSUtils/pull/215
[#216]: https://github.com/PHPCSStandards/PHPCSUtils/pull/216
[#217]: https://github.com/PHPCSStandards/PHPCSUtils/pull/217
[#219]: https://github.com/PHPCSStandards/PHPCSUtils/pull/219
[#225]: https://github.com/PHPCSStandards/PHPCSUtils/pull/225
[#226]: https://github.com/PHPCSStandards/PHPCSUtils/pull/226
[#229]: https://github.com/PHPCSStandards/PHPCSUtils/pull/229
[#233]: https://github.com/PHPCSStandards/PHPCSUtils/pull/233
[#234]: https://github.com/PHPCSStandards/PHPCSUtils/pull/234
[#235]: https://github.com/PHPCSStandards/PHPCSUtils/pull/235
[#237]: https://github.com/PHPCSStandards/PHPCSUtils/pull/237
[#239]: https://github.com/PHPCSStandards/PHPCSUtils/pull/239
[#241]: https://github.com/PHPCSStandards/PHPCSUtils/pull/241
[#243]: https://github.com/PHPCSStandards/PHPCSUtils/pull/243
[#247]: https://github.com/PHPCSStandards/PHPCSUtils/pull/247
[#248]: https://github.com/PHPCSStandards/PHPCSUtils/pull/248
[#249]: https://github.com/PHPCSStandards/PHPCSUtils/pull/249
[#251]: https://github.com/PHPCSStandards/PHPCSUtils/pull/251
[#252]: https://github.com/PHPCSStandards/PHPCSUtils/pull/252
[#254]: https://github.com/PHPCSStandards/PHPCSUtils/pull/254
[#256]: https://github.com/PHPCSStandards/PHPCSUtils/pull/256
[#261]: https://github.com/PHPCSStandards/PHPCSUtils/pull/261
[#262]: https://github.com/PHPCSStandards/PHPCSUtils/pull/262
[#269]: https://github.com/PHPCSStandards/PHPCSUtils/pull/269
[#270]: https://github.com/PHPCSStandards/PHPCSUtils/pull/270
[#273]: https://github.com/PHPCSStandards/PHPCSUtils/pull/273
[#277]: https://github.com/PHPCSStandards/PHPCSUtils/pull/277
[#285]: https://github.com/PHPCSStandards/PHPCSUtils/pull/285
[#291]: https://github.com/PHPCSStandards/PHPCSUtils/pull/291
[#292]: https://github.com/PHPCSStandards/PHPCSUtils/pull/292
[#293]: https://github.com/PHPCSStandards/PHPCSUtils/pull/293
[#297]: https://github.com/PHPCSStandards/PHPCSUtils/pull/297
[#304]: https://github.com/PHPCSStandards/PHPCSUtils/pull/304
[#309]: https://github.com/PHPCSStandards/PHPCSUtils/pull/309
[#311]: https://github.com/PHPCSStandards/PHPCSUtils/pull/311
[#319]: https://github.com/PHPCSStandards/PHPCSUtils/pull/319
[#320]: https://github.com/PHPCSStandards/PHPCSUtils/pull/320
[#321]: https://github.com/PHPCSStandards/PHPCSUtils/pull/321
[#325]: https://github.com/PHPCSStandards/PHPCSUtils/pull/325
[#327]: https://github.com/PHPCSStandards/PHPCSUtils/pull/327
[#328]: https://github.com/PHPCSStandards/PHPCSUtils/pull/328
[#332]: https://github.com/PHPCSStandards/PHPCSUtils/pull/332
[#335]: https://github.com/PHPCSStandards/PHPCSUtils/pull/335
[#341]: https://github.com/PHPCSStandards/PHPCSUtils/pull/341
[#344]: https://github.com/PHPCSStandards/PHPCSUtils/pull/344
[#347]: https://github.com/PHPCSStandards/PHPCSUtils/pull/347
[#349]: https://github.com/PHPCSStandards/PHPCSUtils/pull/349
[#356]: https://github.com/PHPCSStandards/PHPCSUtils/pull/356
[#357]: https://github.com/PHPCSStandards/PHPCSUtils/pull/357
[#358]: https://github.com/PHPCSStandards/PHPCSUtils/pull/358
[#360]: https://github.com/PHPCSStandards/PHPCSUtils/pull/360
[#362]: https://github.com/PHPCSStandards/PHPCSUtils/pull/362
[#363]: https://github.com/PHPCSStandards/PHPCSUtils/pull/363
[#365]: https://github.com/PHPCSStandards/PHPCSUtils/pull/365
[#366]: https://github.com/PHPCSStandards/PHPCSUtils/pull/366
[#367]: https://github.com/PHPCSStandards/PHPCSUtils/pull/367
[#368]: https://github.com/PHPCSStandards/PHPCSUtils/pull/368
[#371]: https://github.com/PHPCSStandards/PHPCSUtils/pull/371
[#372]: https://github.com/PHPCSStandards/PHPCSUtils/pull/372
[#376]: https://github.com/PHPCSStandards/PHPCSUtils/pull/376
[#377]: https://github.com/PHPCSStandards/PHPCSUtils/pull/377
[#379]: https://github.com/PHPCSStandards/PHPCSUtils/pull/379
[#381]: https://github.com/PHPCSStandards/PHPCSUtils/pull/381
[#382]: https://github.com/PHPCSStandards/PHPCSUtils/pull/382
[#383]: https://github.com/PHPCSStandards/PHPCSUtils/pull/383
[#385]: https://github.com/PHPCSStandards/PHPCSUtils/pull/385
[#390]: https://github.com/PHPCSStandards/PHPCSUtils/pull/390
[#391]: https://github.com/PHPCSStandards/PHPCSUtils/pull/391
[#392]: https://github.com/PHPCSStandards/PHPCSUtils/pull/392
[#394]: https://github.com/PHPCSStandards/PHPCSUtils/pull/394
[#395]: https://github.com/PHPCSStandards/PHPCSUtils/pull/395
[#396]: https://github.com/PHPCSStandards/PHPCSUtils/pull/396
[#397]: https://github.com/PHPCSStandards/PHPCSUtils/pull/397
[#398]: https://github.com/PHPCSStandards/PHPCSUtils/pull/398

[PHPCS#3118]: https://github.com/squizlabs/PHP_CodeSniffer/issues/3118
[PHPUnit Polyfills]: https://github.com/Yoast/PHPUnit-Polyfills


## [1.0.0-alpha3] - 2020-06-29

Notes:

* While still in alpha, some BC-breaks may be introduced. These are clearly indicated in the changelog with the :warning: symbol.
* Until PHPCS 4.x has been released, PHPCSUtils does not formally support it, though an effort is made to keep up with the changes and anticipate potential compatibility issues.
    For testing purposes, the composer configuration allows for PHPCSUtils to be installed with PHPCS 4.x.
* Until PHP 8.0 has been released, PHPCSUtils does not formally support it, though an effort is made to keep up with the changes and anticipate potential compatibility issues.
    For testing purposes, the composer configuration allows for PHPCSUtils to be installed with PHP 8.

### Added

* New [`PHPCSUtils\Utils\NamingConventions`][`NamingConventions`] class: Utility functions for working with identifier names (namespace names, class/trait/interface names, function names, variable and constant names). [#119]
* New [`PHPCSUtils\BackCompat\Helper::getEncoding()`][Helper::getEncoding] method. [#118]
* New [`PHPCSUtils\Utils\ControlStructures::getCaughtExceptions()`][ControlStructures::getCaughtExceptions] method. [#114], [#138]
* New [`PHPCSUtils\Utils\UseStatements::splitAndMergeImportUseStatement()`][UseStatements::splitAndMergeImportUseStatement] method. [#117]

#### PHPCS BackCompat

* `BCFile::getMethodProperties()`: support for "static" as a return type (PHP 8.0). [#134], [PHPCS#2952]

#### TestUtils

* [`UtilityMethodTestCase`]: new public `$phpcsVersion` property for use in tests. [#107]
    **Note**: if the PHPCS version is needed within a data provider method for a test, `Helper::getVersion()` still needs to be used as the data providers are run before the `setUpBeforeClass()`-like methods which set the property.

#### Tokens

* New [`Collections::$incrementDecrementOperators`][`Collections`] property. [#130]
* New [`Collections::$magicConstants`][`Collections`] property. [#106]
* New [`Collections::$objectOperators`][`Collections`] property. [#130]
* New [`Collections::$OOHierarchyKeywords`][`Collections`] property representing the keywords to access properties or methods from inside a class definition, i.e `self`, `parent` and `static`. [#115]
* New [`Collections::$OONameTokens`][`Collections`] property containing tokens which can be part of a partially/fully qualified name when used in inline code. [#113]
* New [`Collections::functionDeclarationTokens()`][`Collections`] method to retrieve the tokens which represent a keyword starting a function declaration. [#133]
    This method is compatible with PHPCS 3.5.3 and higher.
* New [`Collections::functionDeclarationTokensBC()`][`Collections`] method to retrieve the tokens which represent a keyword starting a function declaration (cross-version compatible). [#133]
    This method is compatible with PHPCS 2.6.0 and higher.
* New [`Collections::parameterTypeTokensBC()`][`Collections`] method to retrieve the tokens which need to be recognized for parameter types cross-version. [#109]
    Use this method when the implementing standard needs to support PHPCS < 3.3.0.
* New [`Collections::propertyTypeTokensBC()`][`Collections`] method to retrieve the tokens which need to be recognized for property types cross-version. [#109]
    Use this method when the implementing standard needs to support PHPCS < 3.3.0.
* New [`Collections::returnTypeTokensBC()`][`Collections`] method to retrieve the tokens which need to be recognized for return types cross-version. [#109]
    Use this method when the implementing standard needs to support PHPCS < 3.5.4.
* `Collections::$returnTypeTokens`: support for "static" as a return type (PHP 8.0). [#134]

#### Utils

* `FunctionDeclarations::getProperties()`: support for "static" as a return type (PHP 8.0). [#134]

### Changed

#### PHPCS BackCompat

* `BCFile::getDeclarationName()`: has been made compatible with PHPCS 4.x. [#110]
* `BCFile::getMethodProperties()`: has been made compatible with PHPCS 4.x. [#109]
* `BCFile::getMemberProperties()`: has been made compatible with PHPCS 4.x. [#109]
* `BCTokens`: :warning: The visibility of the `BCTokens::$phpcsCommentTokensTypes`, `BCTokens::$ooScopeTokens`, `BCTokens::$textStringTokens` properties has changed from `protected` to `private`. [#139]
* `Helper::setConfigData()`: has been made compatible with PHPCS 4.x. [#137]
    A new `$config` parameter has been added to the method. This parameter is a required parameter when the method is used with PHPCS 4.x.

#### TestUtils

* [`UtilityMethodTestCase`]: tests for JS/CSS will now automatically be skipped when run in combination with PHPCS 4.x (which drops JS/CSS support). [#111]
* Confirmed that the currently available test utils are compatible with PHPUnit 9.x. [#103]

#### Tokens

* `Collections::$parameterTypeTokens`: has been made compatible with PHPCS 4.x. [#109]
    :warning: This removes support for PHPCS < 3.3.0 from the property. Use the [`Collections::parameterTypeTokensBC()`][`Collections`] method instead if PHPCS < 3.3.0 needs to be supported.
* `Collections::$propertyTypeTokens`: has been made compatible with PHPCS 4.x. [#109]
    :warning: This removes support for PHPCS < 3.3.0 from the property. Use the [`Collections::propertyTypeTokensBC()`][`Collections`] method instead if PHPCS < 3.3.0 needs to be supported.
* `Collections::$returnTypeTokens`: has been made compatible with PHPCS 4.x. [#109]
    :warning: This removes support for PHPCS < 3.5.4 from the property. Use the [`Collections::returnTypeTokensBC()`][`Collections`] method instead if PHPCS < 3.5.4 needs to be supported.

#### Utils

* `FunctionDeclarations::getArrowFunctionOpenClose()`: has been made compatible with PHPCS 4.x. [#109]
* `FunctionDeclarations::getProperties()`: has been made compatible with PHPCS 4.x. [#109]
* :warning: `Lists::getAssignments()`: the return value of the method has been consolidated to be less fiddly to work with. [#129]
    - :warning: The `nested_list` index key in the return value has been renamed to `is_nested_list`.
* `ObjectDeclarations::getName()`: has been made compatible with PHPCS 4.x. [#110]
* `Variables::getMemberProperties()`: has been made compatible with PHPCS 4.x. [#109]

#### Other

* Composer: PHPCSUtils can now be installed in combination with PHPCS `4.0.x-dev@dev` for testing purposes.
* Composer: The version requirements for the [Composer PHPCS plugin] have been widened to allow for version 0.7.0 which supports Composer 2.0.0.
* Readme/website homepage: textual improvements. Props [@GaryJones]. [#121]
* Readme/website homepage: added additional FAQ question & answers. [#157]
* The website homepage is now generated using the GitHub Pages gem with Jekyll, making maintenance easier. [#141]
* Significant improvements to the docblock documentation and by extension the [generated API documentation]. [#145], [#146], [#147], [#148], [#149], [#150], [#151], [#152], [#153], [#154], [#155], [#156]
* Various housekeeping.

### Fixed

#### Abstract Sniffs

* `AbstractArrayDeclarationSniff`: improved parse error handling. [#99]

#### PHPCS BackCompat

* `BCFile::findEndOfStatement()`: now supports arrow functions when used as a function argument, in line with the same change made in PHPCS 3.5.5. [#143]
* `BcFile::isReference()`: bug fix, the reference operator was not recognized as such for closures declared to return by reference. [#160], [PHPCS#2977]

#### Utils

* `FunctionDeclarations::getArrowFunctionOpenClose()`: now supports arrow functions when used as a function argument, in line with the same change made in PHPCS 3.5.5. [#143]
* `FunctionDeclarations::getArrowFunctionOpenClose()`: now supports for arrow functions returning heredoc/nowdocs, in line with the same change made in PHPCS `master` and expected to be released in PHPCS 3.5.6. [#143]
* `FunctionDeclarations::getName()`: bug fix for functions declared to return by reference. [#131]
* `FunctionDeclarations::isMagicFunction()`: bug fix for nested functions. [#127]
* `Operators::isReference()`: bug fix, the reference operator was not recognized as such for closures declared to return by reference. [#142]
* `Namespaces::getType()`: improved type detection for when the `namespace` keyword is used as an operator in the global namespace. [#132]
* `TextStrings::getCompleteTextString()`: will now remove the newline at the end of a heredoc/nowdoc. [#136]
    PHP itself does not include the last new line in a heredoc/nowdoc text string when handling it, so the method shouldn't either.

[generated API documentation]: https://phpcsutils.com/phpdoc/
[Helper::getEncoding]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-BackCompat-Helper.html#method_getEncoding
[ControlStructures::getCaughtExceptions]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-ControlStructures.html#method_getCaughtExceptions
[UseStatements::splitAndMergeImportUseStatement]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-UseStatements.html#method_splitAndMergeImportUseStatement

[#99]: https://github.com/PHPCSStandards/PHPCSUtils/pull/99
[#103]: https://github.com/PHPCSStandards/PHPCSUtils/pull/103
[#106]: https://github.com/PHPCSStandards/PHPCSUtils/pull/106
[#107]: https://github.com/PHPCSStandards/PHPCSUtils/pull/107
[#109]: https://github.com/PHPCSStandards/PHPCSUtils/pull/109
[#110]: https://github.com/PHPCSStandards/PHPCSUtils/pull/110
[#111]: https://github.com/PHPCSStandards/PHPCSUtils/pull/111
[#113]: https://github.com/PHPCSStandards/PHPCSUtils/pull/113
[#114]: https://github.com/PHPCSStandards/PHPCSUtils/pull/114
[#115]: https://github.com/PHPCSStandards/PHPCSUtils/pull/115
[#117]: https://github.com/PHPCSStandards/PHPCSUtils/pull/117
[#118]: https://github.com/PHPCSStandards/PHPCSUtils/pull/118
[#119]: https://github.com/PHPCSStandards/PHPCSUtils/pull/119
[#129]: https://github.com/PHPCSStandards/PHPCSUtils/pull/129
[#121]: https://github.com/PHPCSStandards/PHPCSUtils/pull/121
[#127]: https://github.com/PHPCSStandards/PHPCSUtils/pull/127
[#130]: https://github.com/PHPCSStandards/PHPCSUtils/pull/130
[#131]: https://github.com/PHPCSStandards/PHPCSUtils/pull/131
[#132]: https://github.com/PHPCSStandards/PHPCSUtils/pull/132
[#133]: https://github.com/PHPCSStandards/PHPCSUtils/pull/133
[#134]: https://github.com/PHPCSStandards/PHPCSUtils/pull/134
[#136]: https://github.com/PHPCSStandards/PHPCSUtils/pull/136
[#137]: https://github.com/PHPCSStandards/PHPCSUtils/pull/137
[#138]: https://github.com/PHPCSStandards/PHPCSUtils/pull/138
[#139]: https://github.com/PHPCSStandards/PHPCSUtils/pull/139
[#141]: https://github.com/PHPCSStandards/PHPCSUtils/pull/141
[#142]: https://github.com/PHPCSStandards/PHPCSUtils/pull/142
[#143]: https://github.com/PHPCSStandards/PHPCSUtils/pull/143
[#145]: https://github.com/PHPCSStandards/PHPCSUtils/pull/145
[#146]: https://github.com/PHPCSStandards/PHPCSUtils/pull/146
[#147]: https://github.com/PHPCSStandards/PHPCSUtils/pull/147
[#148]: https://github.com/PHPCSStandards/PHPCSUtils/pull/148
[#149]: https://github.com/PHPCSStandards/PHPCSUtils/pull/149
[#150]: https://github.com/PHPCSStandards/PHPCSUtils/pull/150
[#151]: https://github.com/PHPCSStandards/PHPCSUtils/pull/151
[#152]: https://github.com/PHPCSStandards/PHPCSUtils/pull/152
[#153]: https://github.com/PHPCSStandards/PHPCSUtils/pull/153
[#154]: https://github.com/PHPCSStandards/PHPCSUtils/pull/154
[#155]: https://github.com/PHPCSStandards/PHPCSUtils/pull/155
[#156]: https://github.com/PHPCSStandards/PHPCSUtils/pull/156
[#157]: https://github.com/PHPCSStandards/PHPCSUtils/pull/157
[#160]: https://github.com/PHPCSStandards/PHPCSUtils/pull/160
[PHPCS#2952]: https://github.com/squizlabs/PHP_CodeSniffer/pull/2952
[PHPCS#2977]: https://github.com/squizlabs/PHP_CodeSniffer/pull/2977


## [1.0.0-alpha2] - 2020-02-16

Note:

* While still in alpha, some BC-breaks may be introduced. These are clearly indicated in the changelog with the :warning: symbol.

### Added

* New [`PHPCSUtils\Utils\ControlStructures`][`ControlStructures`] class: Utility functions for use when examining control structures. [#70]
* New [`PHPCSUtils\Utils\FunctionDeclarations::isArrowFunction()`][FunctionDeclarations::isArrowFunction] method. [#77], [#79]
* New [`PHPCSUtils\Utils\FunctionDeclarations::getArrowFunctionOpenClose()`][FunctionDeclarations::getArrowFunctionOpenClose] method. [#77], [#79]

#### PHPCS BackCompat

* `BCFile::isReference()`: support for arrow functions returning by reference. [#77]
* `BCFile::getMethodParameters()`: support for arrow functions. [#77], [#79]
* `BCFile::getMethodProperties()`: support for arrow functions. [#77], [#79], [#89]
* `BCFile::getDeclarationName()`: allow functions to be called "fn". [#77]
* `BCFile::findEndOfStatement()`: support for arrow functions. [#77], [#79]
* `BCFile::findStartOfStatement()`: support for arrow functions. [#77]

#### Tokens

* New [`Collections::$alternativeControlStructureSyntaxTokens`][`Collections`] property. [#70]
* New [`Collections::$alternativeControlStructureSyntaxCloserTokens`][`Collections`] property. [#68], [#69]
* New [`Collections::$controlStructureTokens`][`Collections`] property. [#70]
* New [`Collections::arrowFunctionTokensBC()`][`Collections`] method. [#79]

#### Utils

* `Arrays::getDoubleArrowPtr()`: support for arrow functions. [#77], [#79], [#84]
* `FunctionDeclarations::getParameters()`: support for arrow functions. [#77], [#79]
* `FunctionDeclarations::getProperties()`: support for arrow functions. [#77], [#79]
* `Operators::isReference()`: support for arrow functions returning by reference. [#77]
* `Parentheses::getOwner()`: support for arrow functions. [#77]
* `Parentheses::isOwnerIn()`: support for arrow functions. [#77], [#79]

#### Other

* Documentation website at <https://phpcsutils.com/>

### Changed

#### PHPCS BackCompat

* `BCFile::getCondition()`: sync with PHPCS 3.5.4 - added support for new `$first` parameter. [#73]

#### Tokens

* The `Collections::$returnTypeTokens` property now includes `T_ARRAY` to allow for supporting arrow functions in PHPCS < 3.5.3. [#77]

#### Utils

* :warning: `Conditions::getCondition()`: sync with PHPCS 3.5.4 - renamed the existing `$reverse` parameter to `$first` and reversing the meaning of the boolean values, to stay in line with PHPCS itself. [#73]
* :warning: `Numbers`: the `$unsupportedPHPCSVersions` property has been replaced with an `UNSUPPORTED_PHPCS_VERSION` constant. [#88]

#### Other

* Various housekeeping.

[FunctionDeclarations::isArrowFunction]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-FunctionDeclarations.html#method_isArrowFunction
[FunctionDeclarations::getArrowFunctionOpenClose]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-FunctionDeclarations.html#method_getArrowFunctionOpenClose

[#68]: https://github.com/PHPCSStandards/PHPCSUtils/pull/68
[#69]: https://github.com/PHPCSStandards/PHPCSUtils/pull/69
[#70]: https://github.com/PHPCSStandards/PHPCSUtils/pull/70
[#73]: https://github.com/PHPCSStandards/PHPCSUtils/pull/73
[#77]: https://github.com/PHPCSStandards/PHPCSUtils/pull/77
[#79]: https://github.com/PHPCSStandards/PHPCSUtils/pull/79
[#84]: https://github.com/PHPCSStandards/PHPCSUtils/pull/84
[#88]: https://github.com/PHPCSStandards/PHPCSUtils/pull/88
[#89]: https://github.com/PHPCSStandards/PHPCSUtils/pull/89


## 1.0.0-alpha1 - 2020-01-23

Initial alpha release containing:

* A `PHPCS23Utils` standard which can be used to allow an external PHPCS standard to be compatible with both PHPCS 2.x as well as 3.x.
* A `PHPCSUtils` standard which contains generic utilities which can be used when writing sniffs.
    **_This standard does not contain any sniffs!_**
    To use these utilities in PHPCS 3.x, all that is needed is for this package to be installed and registered with PHPCS using `installed_paths`. If the package is requested via Composer, this will automatically be handled by the [Composer PHPCS plugin].
    To use these utilities in PHPCS 2.x, make sure the external standard includes the `PHPCS23Utils` standard in the `ruleset.xml` file like so: `<rule ref="PHPCS23Utils"/>`.

All utilities offered are compatible with PHP_CodeSniffer 2.6.0 up to the latest stable release.

This initial alpha release contains the following utility classes:

### Abstract Sniffs

* [`AbstractArrayDeclarationSniff`]: to examine array declarations.

### BackCompat

* [`BCFile`]: Backport of the latest versions of PHPCS native utility functions from the `PHP_CodeSniffer\Files\File` class to make them available in older PHPCS versions without the bugs and other quirks that the older versions of the native functions had.
* [`BCTokens`]: Backport of the latest versions of PHPCS native token arrays from the `PHP_CodeSniffer\Util\Tokens` class to make them available in older PHPCS versions.
* [`Helper`]: Utility methods to retrieve (configuration) information from PHP_CodeSniffer 2.x as well as 3.x.

### Fixers

* [`SpacesFixer`]: Utility to check and, if necessary, fix the whitespace between two tokens.

### TestUtils

* [`UtilityMethodTestCase`]: Base class for use when testing utility methods for PHP_CodeSniffer.
    Compatible with both PHPCS 2.x as well as 3.x. Supports PHPUnit 4.x up to 8.x.
    See the usage instructions in the class docblock.

### Tokens

* [`Collections`]: Collections of related tokens as often used and needed for sniffs.
    These are additional "token groups" to compliment the ones available through the PHPCS native `PHP_CodeSniffer\Util\Tokens` class.

### Utils

* [`Arrays`]: Utility functions for use when examining arrays.
* [`Conditions`]: Utility functions for use when examining token conditions.
* [`FunctionDeclarations`]: Utility functions for use when examining function declaration statements.
* [`GetTokensAsString`]: Utility functions to retrieve the content of a set of tokens as a string.
* [`Lists`]: Utility functions to retrieve information when working with lists.
* [`Namespaces`]: Utility functions for use when examining T_NAMESPACE tokens and to determine the namespace of arbitrary tokens.
* [`Numbers`]: Utility functions for working with integer/float tokens.
* [`ObjectDeclarations`]: Utility functions for use when examining object declaration statements.
* [`Operators`]: Utility functions for use when working with operators.
* [`Orthography`]: Utility functions for checking the orthography of arbitrary text strings.
* [`Parentheses`]: Utility functions for use when examining parenthesis tokens and arbitrary tokens wrapped in parentheses.
* [`PassedParameters`]: Utility functions to retrieve information about parameters passed to function calls, array declarations, isset and unset constructs.
* [`Scopes`]: Utility functions for use when examining token scopes.
* [`TextStrings`]: Utility functions for working with text string tokens.
* [`UseStatements`]: Utility functions for examining use statements.
* [`Variables`]: Utility functions for use when examining variables.


[Unreleased]:   https://github.com/PHPCSStandards/PHPCSUtils/compare/stable...HEAD
[1.0.0]:        https://github.com/PHPCSStandards/PHPCSUtils/compare/1.0.0-rc1...1.0.0
[1.0.0-rc1]:    https://github.com/PHPCSStandards/PHPCSUtils/compare/1.0.0-alpha4...1.0.0-rc1
[1.0.0-alpha4]: https://github.com/PHPCSStandards/PHPCSUtils/compare/1.0.0-alpha3...1.0.0-alpha4
[1.0.0-alpha3]: https://github.com/PHPCSStandards/PHPCSUtils/compare/1.0.0-alpha2...1.0.0-alpha3
[1.0.0-alpha2]: https://github.com/PHPCSStandards/PHPCSUtils/compare/1.0.0-alpha1...1.0.0-alpha2

[Composer PHPCS plugin]: https://github.com/PHPCSStandards/composer-installer

[`AbstractArrayDeclarationSniff`]: https://phpcsutils.com/phpdoc/classes/PHPCSUtils-AbstractSniffs-AbstractArrayDeclarationSniff.html
[`BCFile`]:                        https://phpcsutils.com/phpdoc/classes/PHPCSUtils-BackCompat-BCFile.html
[`BCTokens`]:                      https://phpcsutils.com/phpdoc/classes/PHPCSUtils-BackCompat-BCTokens.html
[`Helper`]:                        https://phpcsutils.com/phpdoc/classes/PHPCSUtils-BackCompat-Helper.html
[`SpacesFixer`]:                   https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Fixers-SpacesFixer.html
[`UtilityMethodTestCase`]:         https://phpcsutils.com/phpdoc/classes/PHPCSUtils-TestUtils-UtilityMethodTestCase.html
[`Collections`]:                   https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Tokens-Collections.html
[`TokenHelper`]:                   https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Tokens-TokenHelper.html
[`Arrays`]:                        https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Arrays.html
[`Conditions`]:                    https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Conditions.html
[`Context`]:                       https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Context.html
[`ControlStructures`]:             https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-ControlStructures.html
[`FunctionDeclarations`]:          https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-FunctionDeclarations.html
[`GetTokensAsString`]:             https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-GetTokensAsString.html
[`Lists`]:                         https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Lists.html
[`MessageHelper`]:                 https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-MessageHelper.html
[`Namespaces`]:                    https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Namespaces.html
[`NamingConventions`]:             https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-NamingConventions.html
[`Numbers`]:                       https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Numbers.html
[`ObjectDeclarations`]:            https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-ObjectDeclarations.html
[`Operators`]:                     https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Operators.html
[`Orthography`]:                   https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Orthography.html
[`Parentheses`]:                   https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Parentheses.html
[`PassedParameters`]:              https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-PassedParameters.html
[`Scopes`]:                        https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Scopes.html
[`TextStrings`]:                   https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-TextStrings.html
[`UseStatements`]:                 https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-UseStatements.html
[`Variables`]:                     https://phpcsutils.com/phpdoc/classes/PHPCSUtils-Utils-Variables.html

[@GaryJones]: https://github.com/GaryJones
