<!-- markdownlint-disable MD013 MD024 -->
# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [Changie](https://github.com/miniscruff/changie).

## 9.2.0 - 2024-05-03

### Added

- [#186](https://github.com/overtrue/phplint/issues/186) : Add SARIF output format

### Changed

- Reorganize binary launcher (`bin/phplint`) and autoloader (`autoload.php` replaced `config/bootstrap.php`)

**Full Changelog**: [9.1.2...9.2.0](https://github.com/overtrue/phplint/compare/9.1.2...9.2.0)

## 9.1.2 - 2024-02-06

### Fixed

- [#202](https://github.com/overtrue/phplint/issues/202) : composer config vendor-dir is ignored
- [#203](https://github.com/overtrue/phplint/issues/203) : Uncaught Error: Failed opening required "phar:///usr/local/bin/phplint/config/bootstrap.php"
- [#204](https://github.com/overtrue/phplint/issues/204) : PHPLint 9.1.1 is unable to interpret correctly command arguments/options

**Full Changelog**: [9.1.1...9.1.2](https://github.com/overtrue/phplint/compare/9.1.1...9.1.2)

## 9.1.1 - 2024-02-05

### Fixed

- [#200](https://github.com/overtrue/phplint/issues/200) : Unable to create file `/github/home/.composer/config.json` in GitHub Action
- [#201](https://github.com/overtrue/phplint/issues/201) : GitHub Action build docker on fly with wrong version

**Full Changelog**: [9.1.0...9.1.1](https://github.com/overtrue/phplint/compare/9.1.0...9.1.1)

## 9.1.0 - 2023-12-17

### Added

- PHPStan dev tool to enforce code quality of this project (see Contributor guide)
- Introduces a `DebugFormatterHelper` for asynchronous process
- Introduces a `ProcessHelper` for asynchronous process
- Introduces a new extension (`ProgressIndicator`) to let users know that the `phplint` command isn't stalled. Uses `--progress=indicator`.

### Changed

- Replaces Symfony components constraint to new LTS (6.4), and drop support to old one (5.4)
- `ProgressPrinter` and `ProgressBar` extensions must now implement the `Overtrue\PHPLint\Output\ConsoleOutputInterface` specification
- Reorganize dev tools under their own composer namespace (`check-style` begins `style:check`, and `fix-style` begins `style:fix`)
- [#197](https://github.com/overtrue/phplint/issues/197) : Faster process linter
- rename BOX config file to `box.json.dist`
- Dockerfile bump default PHP version from 8.2 to 8.3 (to produce better perf)

### Removed

- drop support of PHPUnit 9
- drop support of PHP 8.0
- `setApplicationVersion` and `setConfigResolver` methods were removed from `Overtrue\PHPLint\Output\ConsoleOutputInterface` 
as there are no more required

**Full Changelog**: [9.0.6...9.1.0](https://github.com/overtrue/phplint/compare/9.0.6...9.1.0)

## 9.0.8 - 2024-02-05

**IMPORTANT** Do not use version 9.0.7 (wrong fixes for Docker targets, including GitHub Actions)

### Fixed

- [#200](https://github.com/overtrue/phplint/issues/200) : Unable to create file `/github/home/.composer/config.json` in GitHub Action
- [#201](https://github.com/overtrue/phplint/issues/201) : GitHub Action build docker on fly with wrong version

**Full Changelog**: [9.0.6...9.0.8](https://github.com/overtrue/phplint/compare/9.0.6...9.0.7)

## 9.0.7 - 2024-02-05

### Fixed

- [#200](https://github.com/overtrue/phplint/issues/200) : Unable to create file `/github/home/.composer/config.json` in GitHub Action
- [#201](https://github.com/overtrue/phplint/issues/201) : GitHub Action build docker on fly with wrong version

**Full Changelog**: [9.0.6...9.0.7](https://github.com/overtrue/phplint/compare/9.0.6...9.0.7)

## 9.0.6 - 2023-12-02

### Fixed

- [#196](https://github.com/overtrue/phplint/issues/196) : Better Symfony 7 support

**Full Changelog**: [9.0.5...9.0.6](https://github.com/overtrue/phplint/compare/9.0.5...9.0.6)

## 9.0.5 - 2023-12-01

This version is compatible PHP 8.0, 8.1, 8.2 and 8.3

**CAUTION** Next minor release 9.1 will drop support to PHP 8.0

### Changed

- Upgrade Phive installation documentation
- Migrate PHPUnit configuration file to 10.4 format
- Raise PHPUnit 9 constraint to latest v9 minor release
- [PR #195](https://github.com/overtrue/phplint/pull/195) : Add Symfony 7 support (thanks to @olegpro)

### Fixed

- [PR #194](https://github.com/overtrue/phplint/pull/194) : Fix link to Configuration in console.md (thanks to @hNczy)
- [#193](https://github.com/overtrue/phplint/issues/193) : PHP CS Fixer deprecated rules

**Full Changelog**: [9.0.4...9.0.5](https://github.com/overtrue/phplint/compare/9.0.4...9.0.5)

## 9.0.4 - 2023-02-23

### Added

- PHPUnit 10 support

### Changed

- ConsoleOutput is no more final to be able to customize it
- LinterOutput implement Countable interface
- Finder implement JsonSerializable interface

### Fixed

- [#182](https://github.com/overtrue/phplint/issues/182) : Docker usage may raise a permission denied
- [#183](https://github.com/overtrue/phplint/issues/183) : Error is unintuitive when there are no files to lint
- [#185](https://github.com/overtrue/phplint/issues/185) : Analyse multiple path at same time did not work with console command
- [#187](https://github.com/overtrue/phplint/issues/187) : Improve log options implementation

**Full Changelog**: [9.0.3...9.0.4](https://github.com/overtrue/phplint/compare/9.0.3...9.0.4)

## 9.0.3 - 2023-02-14

### Fixed

- [#178](https://github.com/overtrue/phplint/issues/178) : "no configuration file is found" message without --no-configuration flag
- [#175](https://github.com/overtrue/phplint/issues/175) : PHAR version not available since release 9.0.0

**Full Changelog**: [9.0.2...9.0.3](https://github.com/overtrue/phplint/compare/9.0.2...9.0.3)

## 9.0.2 - 2023-02-13

### Fixed

- [#176](https://github.com/overtrue/phplint/issues/176) : Enhance Cache support for Windows platform

**Full Changelog**: [9.0.1...9.0.2](https://github.com/overtrue/phplint/compare/9.0.1...9.0.2)

## 9.0.1 - 2023-02-13

### Changed

- configure Release Workflow to run manually

### Fixed

- [#175](https://github.com/overtrue/phplint/issues/175) : Release Workflow was not able to build a PHAR with manifest distribution

**Full Changelog**: [9.0.0...9.0.1](https://github.com/overtrue/phplint/compare/9.0.0...9.0.1)

## 9.0.0 - 2023-02-13

### Added

- introduces [Changie](https://github.com/miniscruff/changie) for changelog automation
- add declare strict_types directive on top of each php script
- add PHP DocBlock header comment on top of each php script
- introduces test automation with PHPUnit
- introduces Finder component to find source files to analyse
- introduces Logger component (basic PSR-3) for cache debugging purpose
- introduces Dispatcher component with events to allow extensible code more easy
- introduces extensions to display checking progress
- introduces OptionsResolver component to resolve configuration with options
- [#173](https://github.com/overtrue/phplint/issues/173) : Improve PHAR build with BOX v4 by adding a manifest
- `--manifest` option to display contents of manifest of the PHAR version (only) of PHPLinter

### Changed

- raise minimum version constraint on Symfony Components to use the current LTS (5.4)
- update `jetbrains/phpstorm-stubs` requirement to accept v2022
- update `brainmaestro/composer-git-hooks` requirement to accept v3.0 alpha1 : that will allow to update psr/log to v3 and symfony/console to v6
- code-rewrites to use Symfony Cache Component
- Lint process class was renamed and some minor type declaration were fixed
- Remove [n98/junit-xml](https://packagist.org/packages/n98/junit-xml) dependency and replace it by new JunitXmlReporter extension (about 30 lines of code)
- JsonOutput console/output is specialized to produce JSON output results (see `--log-json` option)
- JunitOutput console/output is specialized to produce JUnit XML format results (see `--log-junit` option)
- ConsoleOutput is specialized to produce CLI output (default results)
- upgrade `humbug/php-scoper` to allow usage of Box v4 with at least PHP 8.1
- Integration with PHP-Scoper to provide a PHAR code isolation with BOX project
- All dev tools are now under bamarni/composer-bin-plugin control

### Removed

- remove platform emulation by Composer [config/platform directive](https://getcomposer.org/doc/06-config.md#platform)
