<!-- markdownlint-disable MD013 MD024 -->
# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [Changie](https://github.com/miniscruff/changie).

## 9.0.4 - 2023-02-23

### Added

- PHPUnit 10 support

### Changed

- ConsoleOutput is no more final to be able to customize it
- LinterOutput implement Countable interface
- Finder implement JsonSerializable interface

### Fixed

- [#182](https://github.com/overtrue/phplint/issues/182) : Docker usage may raise a permission denied
- [#183](https://github.com/overtrue/phplint/issues/183) : Error is unintuitive when there are no files to lint
- [#185](https://github.com/overtrue/phplint/issues/185) : Analyse multiple path at same time did not work with console command
- [#187](https://github.com/overtrue/phplint/issues/187) : Improve log options implementation

**Full Changelog**: [9.0.3...9.0.4](https://github.com/overtrue/phplint/compare/9.0.3...9.0.4)

## 9.0.3 - 2023-02-14

### Fixed

- [#178](https://github.com/overtrue/phplint/issues/178) : "no configuration file is found" message without --no-configuration flag
- [#175](https://github.com/overtrue/phplint/issues/175) : PHAR version not available since release 9.0.0

**Full Changelog**: [9.0.2...9.0.3](https://github.com/overtrue/phplint/compare/9.0.2...9.0.3)

## 9.0.2 - 2023-02-13

### Fixed

- [#176](https://github.com/overtrue/phplint/issues/176) : Enhance Cache support for Windows platform

**Full Changelog**: [9.0.1...9.0.2](https://github.com/overtrue/phplint/compare/9.0.1...9.0.2)

## 9.0.1 - 2023-02-13

### Changed

- configure Release Workflow to run manually

### Fixed

- [#175](https://github.com/overtrue/phplint/issues/175) : Release Workflow was not able to build a PHAR with manifest distribution

**Full Changelog**: [9.0.0...9.0.1](https://github.com/overtrue/phplint/compare/9.0.0...9.0.1)

## 9.0.0 - 2023-02-13

### Added

- introduces [Changie](https://github.com/miniscruff/changie) for changelog automation
- add declare strict_types directive on top of each php script
- add PHP DocBlock header comment on top of each php script
- introduces test automation with PHPUnit
- introduces Finder component to find source files to analyse
- introduces Logger component (basic PSR-3) for cache debugging purpose
- introduces Dispatcher component with events to allow extensible code more easy
- introduces extensions to display checking progress
- introduces OptionsResolver component to resolve configuration with options
- [#173](https://github.com/overtrue/phplint/issues/173) : Improve PHAR build with BOX v4 by adding a manifest
- `--manifest` option to display contents of manifest of the PHAR version (only) of PHPLinter

### Changed

- raise minimum version constraint on Symfony Components to use the current LTS (5.4)
- update `jetbrains/phpstorm-stubs` requirement to accept v2022
- update `brainmaestro/composer-git-hooks` requirement to accept v3.0 alpha1 : that will allow to update psr/log to v3 and symfony/console to v6
- code-rewrites to use Symfony Cache Component
- Lint process class was renamed and some minor type declaration were fixed
- Remove [n98/junit-xml](https://packagist.org/packages/n98/junit-xml) dependency and replace it by new JunitXmlReporter extension (about 30 lines of code)
- JsonOutput console/output is specialized to produce JSON output results (see `--log-json` option)
- JunitOutput console/output is specialized to produce JUnit XML format results (see `--log-junit` option)
- ConsoleOutput is specialized to produce CLI output (default results)
- upgrade `humbug/php-scoper` to allow usage of Box v4 with at least PHP 8.1
- Integration with PHP-Scoper to provide a PHAR code isolation with BOX project
- All dev tools are now under bamarni/composer-bin-plugin control

### Removed

- remove platform emulation by Composer [config/platform directive](https://getcomposer.org/doc/06-config.md#platform)
