import { declare } from "@babel/helper-plugin-utils";
import type { NodePath } from "@babel/traverse";
import type * as t from "@babel/types";

export default declare((api, options) => {
  api.assertVersion(7);

  const noNewArrows = api.assumption("noNewArrows") ?? !options.spec;

  return {
    name: "transform-arrow-functions",

    visitor: {
      ArrowFunctionExpression(path: NodePath<t.ArrowFunctionExpression>) {
        // In some conversion cases, it may have already been converted to a function while this callback
        // was queued up.
        if (!path.isArrowFunctionExpression()) return;

        path.arrowFunctionToExpression({
          // While other utils may be fine inserting other arrows to make more transforms possible,
          // the arrow transform itself absolutely cannot insert new arrow functions.
          allowInsertArrow: false,
          noNewArrows,

          // TODO(Babel 8): This is only needed for backward compat with @babel/traverse <7.13.0
          specCompliant: !noNewArrows,
        });
      },
    },
  };
});
