<?php

/**
 * Test: Nette\Utils\Image alpha channel.
 * @phpExtension gd
 */

declare(strict_types=1);

use Nette\Utils\Image;
use Tester\Assert;


require __DIR__ . '/../bootstrap.php';


function exportStrUtf($s)
{
	$s = addcslashes($s, '\\"');

	$s = preg_replace_callback('#[^\ -z]#u', function ($m) {
		$code = iconv('UTF-8', 'UTF-32BE//IGNORE', $m[0]);		
		return '\u{' . ltrim(bin2hex($code), '0') . '}';
	}, $s);

	return '"' . $s . '"';
}

function utfChar($ord)
{
	if ($ord<128) return chr($ord);  // ASCII 0xxxxxxx	
	if ($ord<2048) return chr(($ord>>6)+192) . chr(($ord&63)+128); // 110xxxxx  10xxxxxx 
	if ($ord<65536) return chr(($ord>>12)+224) . chr((($ord>>6)&63)+128) . chr(($ord&63)+128); // 1110xxxx  10xxxxxx  10xxxxxx
	if ($ord<2097152) return chr(($ord>>18)+240) . chr((($ord>>12)&63)+128) . chr((($ord>>6)&63)+128) . chr(($ord&63)+128); // 11110xxx  10xxxxxx  10xxxxxx  10xxxxxx
	if ($ord<67108864) return chr(($ord>>24)+248) . chr((($ord>>18)&63)+128) . chr((($ord>>12)&63)+128) . chr((($ord>>6)&63)+128) . chr(($ord&63)+128); // 111110xx  10xxxxxx  10xxxxxx  10xxxxxx (not defined)
	if ($ord<2147483648) return chr(($ord>>30)+252) . chr((($ord>>24)&63)+128) . chr((($ord>>18)&63)+128) . chr((($ord>>12)&63)+128) . chr((($ord>>6)&63)+128) . chr(($ord&63)+128); // 1111110x  10xxxxxx  10xxxxxx  10xxxxxx  10xxxxxx (not defined)
	return ''; // invalid
}

@mkdir(__DIR__ . '/output');

$f = fopen(__DIR__ . '/output/glibc.php', 'w');
fwrite($f, "<?php\nreturn [\n");

$f2 = fopen(__DIR__ . '/output/intl.php', 'w');
fwrite($f2, "<?php\nreturn [\n");

$transliterator = \Transliterator::create('Any-Latin; Latin-ASCII');

for ($i = 127; $i<655350 + 10; $i++)
{
	$s = utfChar($i);
	
	$s2 = iconv('UTF-8', 'ASCII//TRANSLIT//IGNORE', $s);
	fwrite($f, "\t" . exportStrUtf($s) . ' => ' . exportStrUtf($s2) . ",\n");

	$s2 = (string)$transliterator->transliterate($s);
	fwrite($f2, "\t" . exportStrUtf($s) . ' => ' . exportStrUtf($s2) . ",\n");
}

fwrite($f, "];\n");
fwrite($f2, "];\n");
