<?php

declare(strict_types=1);

use Nette\Utils\Type;
use Tester\Assert;

require __DIR__ . '/../bootstrap.php';


$type = Type::fromReflection(new ReflectionFunction(function (): string {}));

Assert::same(['string'], $type->getNames());
Assert::same('string', (string) $type);
Assert::same('string', $type->getSingleName());
Assert::false($type->isClass());
Assert::false($type->isUnion());
Assert::false($type->isIntersection());
Assert::true($type->isSingle());
Assert::true($type->isBuiltin());


$type = Type::fromReflection(new ReflectionFunction(function (): ?string {}));

Assert::same(['string', 'null'], $type->getNames());
Assert::same('?string', (string) $type);
Assert::same('string', $type->getSingleName());
Assert::false($type->isClass());
Assert::true($type->isUnion());
Assert::false($type->isIntersection());
Assert::true($type->isSingle());
Assert::true($type->isBuiltin());


$type = Type::fromReflection(new ReflectionFunction(function (): Foo {}));

Assert::same(['Foo'], $type->getNames());
Assert::same('Foo', (string) $type);
Assert::same('Foo', $type->getSingleName());
Assert::true($type->isClass());
Assert::false($type->isUnion());
Assert::false($type->isIntersection());
Assert::true($type->isSingle());
Assert::false($type->isBuiltin());
