<?php

/**
 * @phpversion 8.1
 */

declare(strict_types=1);

use Nette\Utils\Type;
use Tester\Assert;

require __DIR__ . '/../bootstrap.php';


$type = Type::fromReflection(new ReflectionFunction(function (): string {}));

Assert::same(['string'], $type->getNames());
Assert::same('string', (string) $type);
Assert::same('string', $type->getSingleName());
Assert::false($type->isClass());
Assert::false($type->isUnion());
Assert::false($type->isIntersection());
Assert::true($type->isSingle());
Assert::true($type->isBuiltin());


$type = Type::fromReflection(new ReflectionFunction(function (): ?string {}));

Assert::same(['string', 'null'], $type->getNames());
Assert::same('?string', (string) $type);
Assert::same('string', $type->getSingleName());
Assert::false($type->isClass());
Assert::true($type->isUnion());
Assert::false($type->isIntersection());
Assert::true($type->isSingle());
Assert::true($type->isBuiltin());


$type = Type::fromReflection(new ReflectionFunction(function (): Foo {}));

Assert::same(['Foo'], $type->getNames());
Assert::same('Foo', (string) $type);
Assert::same('Foo', (string) $type);
Assert::same('Foo', $type->getSingleName());
Assert::true($type->isClass());
Assert::false($type->isUnion());
Assert::false($type->isIntersection());
Assert::true($type->isSingle());
Assert::false($type->isBuiltin());


$type = Type::fromReflection(new ReflectionFunction(function (): Foo|string {}));

Assert::same(['Foo', 'string'], $type->getNames());
Assert::same('Foo|string', (string) $type);
Assert::null($type->getSingleName());
Assert::false($type->isClass());
Assert::true($type->isUnion());
Assert::false($type->isIntersection());
Assert::false($type->isSingle());
Assert::false($type->isBuiltin());


$type = Type::fromReflection(new ReflectionFunction(function (): mixed {}));

Assert::same(['mixed'], $type->getNames());
Assert::same('mixed', (string) $type);
Assert::same('mixed', $type->getSingleName());
Assert::false($type->isClass());
Assert::false($type->isUnion());
Assert::false($type->isIntersection());
Assert::true($type->isSingle());
Assert::true($type->isBuiltin());


$type = Type::fromReflection(new ReflectionFunction(function (): Bar&Foo {}));

Assert::same(['Bar', 'Foo'], $type->getNames());
Assert::same('Bar&Foo', (string) $type);
Assert::null($type->getSingleName());
Assert::false($type->isClass());
Assert::false($type->isUnion());
Assert::true($type->isIntersection());
Assert::false($type->isSingle());
Assert::false($type->isBuiltin());


// tentative type
$type = Type::fromReflection(new \ReflectionMethod(\ArrayObject::class, 'count'));
Assert::same('int', (string) $type);
