<?php

declare(strict_types=1);

namespace Nette\PhpGenerator;

class PropertyHook
{
	use Traits\AttributeAware;
	use Traits\CommentAware;

	private ?string $body = null;
	private bool $shortcut = false; // Whether to use the '=>' syntax
	private ?Parameter $parameter = null;
	private bool $returnReference = false;


	public function setBody(string $body, bool $shortcut = false): self
	{
		$this->body = $body;
		$this->shortcut = $shortcut;
		return $this;
	}


	public function getBody(): ?string
	{
		return $this->body;
	}


	public function isShortcut(): bool
	{
		return $this->shortcut;
	}


	/**
	 * Adds a parameter. If it already exists, it overwrites it.
	 * @param  string  $name without $
	 */
	public function setParameter(string $name = 'value'): Parameter
	{
		$param = new Parameter($name);
		return $this->parameter = $param;
	}


	public function getParameter(): ?Parameter
	{
		return $this->parameter;
	}


	/** @internal */
	public function getParameters(): array
	{
		return $this->parameter ? [$this->parameter] : [];
	}


	public function setReturnReference(bool $state = true): static
	{
		$this->returnReference = $state;
		return $this;
	}


	public function getReturnReference(): bool
	{
		return $this->returnReference;
	}
}
