<?php

/**
 * Test: Nette\PhpGenerator\Dumper::dump() enum
 * @phpVersion 8.1
 */

declare(strict_types=1);

use Nette\PhpGenerator\Dumper;
use Tester\Assert;


require __DIR__ . '/../bootstrap.php';


enum Suit {
	case Clubs;
	case Diamonds;
	case Hearts;
	case Spades;
}

$dumper = new Dumper;
Assert::same('Suit::Clubs', $dumper->dump(Suit::Clubs));


$class = new Nette\PhpGenerator\ClassType('Test');
$class->addConstant('a', Suit::Diamonds);
$class->addProperty('b', Suit::Hearts);
$class->addMethod('c')
	->addParameter('d', Suit::Spades);

Assert::match(<<<'XX'
class Test
{
	const a = Suit::Diamonds;

	public $b = Suit::Hearts;


	public function c($d = Suit::Spades)
	{
	}
}
XX
, (string) $class);
