<?php

/**
 * This file is part of the Nette Framework (https://nette.org)
 * Copyright (c) 2004 David Grudl (https://davidgrudl.com)
 */

declare(strict_types=1);

namespace Nette\PhpGenerator\Traits;

use Nette;
use Nette\PhpGenerator\Modifier;


/**
 * @internal
 */
trait VisibilityAware
{
	/** public|protected|private */
	private ?string $visibility = null;


	/**
	 * @param  string|null  $val  public|protected|private
	 */
	public function setVisibility(?string $val): static
	{
		if (!in_array($val, [Modifier::Public, Modifier::Protected, Modifier::Private, null], true)) {
			throw new Nette\InvalidArgumentException('Argument must be public|protected|private.');
		}

		$this->visibility = $val;
		return $this;
	}


	public function getVisibility(): ?string
	{
		return $this->visibility;
	}


	public function setPublic(): static
	{
		$this->visibility = Modifier::Public;
		return $this;
	}


	public function isPublic(): bool
	{
		return $this->visibility === Modifier::Public || $this->visibility === null;
	}


	public function setProtected(): static
	{
		$this->visibility = Modifier::Protected;
		return $this;
	}


	public function isProtected(): bool
	{
		return $this->visibility === Modifier::Protected;
	}


	public function setPrivate(): static
	{
		$this->visibility = Modifier::Private;
		return $this;
	}


	public function isPrivate(): bool
	{
		return $this->visibility === Modifier::Private;
	}
}
