<?php

/**
 * This file is part of the Nette Framework (https://nette.org)
 * Copyright (c) 2004 David Grudl (https://davidgrudl.com)
 */

declare(strict_types=1);

namespace Nette\Neon\Node;

use Nette\Neon\Node;


/** @internal */
final class ArrayNode extends Node
{
	/** @var ArrayItemNode[] */
	public $items = [];

	/** @var ?string */
	public $indentation;


	public function __construct(?string $indentation = null, int $pos = null)
	{
		$this->indentation = $indentation;
		$this->startPos = $this->endPos = $pos;
	}


	public function toValue(callable $evaluator = null): array
	{
		return ArrayItemNode::itemsToArray($this->items, $evaluator);
	}


	public function toString(callable $serializer = null): string
	{
		if ($this->indentation === null) {
			$isList = !array_filter($this->items, function ($item) { return $item->key; });
			$res = ArrayItemNode::itemsToInlineString($this->items, $serializer);
			return ($isList ? '[' : '{') . $res . ($isList ? ']' : '}');

		} elseif (count($this->items) === 0) {
			return '[]';

		} else {
			$res = ArrayItemNode::itemsToBlockString($this->items, $serializer);
			return preg_replace('#^(?=.)#m', $this->indentation, $res);
		}
	}


	public function getSubNodes(): array
	{
		$res = [];
		foreach ($this->items as &$item) {
			$res[] = &$item;
		}
		return $res;
	}
}
