<?php

declare(strict_types=1);

use Nette\DI\Config\Adapters\NeonAdapter;
use Tester\Assert;

require __DIR__ . '/../bootstrap.php';


$adapter = new NeonAdapter;
$data = $adapter->load('files/neonAdapter.neon');

Assert::match(<<<'EOD'
	# generated by Nette

	parameters:
		type: Ipsum

	services:
		referencedService: @one
		referencedServiceWithSetup:
			factory: @one
			setup:
				- $x(10)

		serviceAsParam: Ipsum(@one)
		calledService: @one()
		calledServiceWithArgs: @one(1)
		calledServiceAsParam: Ipsum(@one())
		calledServiceWithArgsAsParam: Ipsum(@one(1))
		one:
			type: %class%
			arguments:
				- 1

		two:
			factory: %class%(1)

		three:
			type: Lorem
			factory: Factory::createLorem
			arguments:
				- 1

		four:
			factory: Factory::createLorem(1)

		five:
			factory: Factory::createLorem(1)

		six: Factory::createLorem(1)
		seven: @factory
		eight: @factory()
		nine:
			- @three
			- foo

		stdClass: stdClass
		factory: Lorem
		rich1: Lorem(1)::foo()
		rich2:
			factory: Lorem(Ipsum(@one))::foo(1)

		rich3: Factory::createLorem(1)::foo()
		rich4: Factory()::createLorem(1)::foo()
		- Lorem(1)::foo()

	EOD, $adapter->dump($data));
