<?php

/**
 * Test: AccessorDefinition
 */

declare(strict_types=1);

use Nette\DI\Definitions\AccessorDefinition;
use Tester\Assert;


require __DIR__ . '/../bootstrap.php';


interface Good1
{
	public function get();
}

interface Good2
{
	public function get(): stdClass;
}


Assert::exception(function () {
	$def = new AccessorDefinition;
	$resolver = new Nette\DI\Resolver(new Nette\DI\ContainerBuilder);
	$resolver->resolveDefinition($def);
}, Nette\DI\ServiceCreationException::class, "Service '': Type is missing in definition of service.");


Assert::exception(function () {
	$def = new AccessorDefinition;
	$def->setImplement('Good1');
	$resolver = new Nette\DI\Resolver(new Nette\DI\ContainerBuilder);
	$resolver->resolveDefinition($def);
}, Nette\DI\ServiceCreationException::class, "Service '' (type of Good1): Method Good1::get() has not return type hint or annotation @return.");


Assert::noError(function () {
	$def = new AccessorDefinition;
	$def->setImplement('Good1');
	$def->setReference('stdClass');

	$resolver = new Nette\DI\Resolver(new Nette\DI\ContainerBuilder);
	$resolver->resolveDefinition($def);
	Assert::same('stdClass', $def->getResultType());
});


Assert::noError(function () {
	$def = new AccessorDefinition;
	$def->setImplement('Good2');

	$resolver = new Nette\DI\Resolver(new Nette\DI\ContainerBuilder);
	$resolver->resolveDefinition($def);
	Assert::same('stdClass', $def->getResultType());
});


Assert::exception(function () {
	$def = new AccessorDefinition;
	$def->setImplement('Good2');

	$resolver = new Nette\DI\Resolver(new Nette\DI\ContainerBuilder);
	$resolver->resolveDefinition($def);
	$resolver->completeDefinition($def);
}, Nette\DI\ServiceCreationException::class, "Service '' (type of Good2): Service of type 'stdClass' not found.");
