<?php

/**
 * Test: Nette\DI\Compiler: services by Class.
 */

declare(strict_types=1);

use Nette\DI;
use Tester\Assert;


require __DIR__ . '/../bootstrap.php';


class Lorem
{
	public function __construct(Ipsum $arg)
	{
	}
}

class Ipsum
{
	public $value;


	public function __construct($value)
	{
		$this->value = $value;
	}


	public static function foo()
	{
	}
}

class FooExtension extends Nette\DI\CompilerExtension
{
	public function loadConfiguration()
	{
		$builder = $this->getContainerBuilder();
		$builder->addDefinition('ipsum')
			->setFactory('Ipsum', [1]);
	}
}


$compiler = new DI\Compiler;
$compiler->addExtension('foo', new FooExtension);
$container = createContainer($compiler, '
services:
	three: @\Lorem

	one:
		factory: Lorem(@\Ipsum)

	two:
		factory: @\Lorem(1)
		setup:
			- @\Ipsum::foo()

	four: @\Lorem

	@\Ipsum:
		arguments: [2]
');


Assert::type(Lorem::class, $container->getService('one'));
Assert::type(Lorem::class, $container->getService('two'));
Assert::type(Lorem::class, $container->getService('three'));
Assert::same($container->getService('one'), $container->getService('three'));
Assert::type(Lorem::class, $container->getService('four'));
Assert::same($container->getService('one'), $container->getService('four'));
Assert::type(Ipsum::class, $container->getService('ipsum'));
Assert::same(2, $container->getService('ipsum')->value);
