<?php

/**
 * Test: Nette\DI\Definitions\Reference usage.
 */

declare(strict_types=1);

use Nette\DI\Definitions\Reference;
use Tester\Assert;


require __DIR__ . '/../bootstrap.php';


$ref = new Reference('a');
Assert::true($ref->isName());
Assert::same('a', $ref->getValue());
Assert::same('a', $ref->getName());


$ref = new Reference('a\b');
Assert::false($ref->isName());
Assert::same('a\b', $ref->getValue());
Assert::exception(function () use ($ref) {
	$ref->getName();
}, Nette\InvalidStateException::class, 'Reference @a\b is not a name.');


$ref = new Reference('a', true);
Assert::false($ref->isName());
Assert::same('\a', $ref->getValue());
