<?php

/**
 * This file is part of the Nette Framework (https://nette.org)
 * Copyright (c) 2004 David Grudl (https://davidgrudl.com)
 */

declare(strict_types=1);

namespace Nette\DI\Definitions;

use Nette;


/**
 * Service reference.
 */
final class Reference
{
	use Nette\SmartObject;

	/** @var string */
	private $value;


	public function __construct(string $value, bool $forceType = null)
	{
		if ($forceType && strpos($value, '\\') === false) {
			$value = '\\' . $value;
		}
		$this->value = $value;
	}


	public function getValue(): string
	{
		return $this->value;
	}


	public function getName(): string
	{
		if (!$this->isName()) {
			throw new Nette\InvalidStateException("Reference @{$this->value} is not a name.");
		}
		return $this->value;
	}


	public function isName(): bool
	{
		return strpos($this->value, '\\') === false;
	}
}
