let colors = {
    'transparent': 'transparent',

    'black': '#22292f',
    'grey-darkest': '#3d4852',
    'grey-darker': '#606f7b',
    'grey-dark': '#8795a1',
    'grey': '#b8c2cc',
    'grey-light': '#dae1e7',
    'grey-lighter': '#f1f5f8',
    'grey-lightest': '#f8fafc',
    'white': '#ffffff',

    'red-darkest': '#3b0d0c',
    'red-darker': '#621b18',
    'red-dark': '#cc1f1a',
    'red': '#e3342f',
    'red-light': '#ef5753',
    'red-lighter': '#f9acaa',
    'red-lightest': '#fcebea',

    'orange-darkest': '#462a16',
    'orange-darker': '#613b1f',
    'orange-dark': '#de751f',
    'orange': '#f6993f',
    'orange-light': '#faad63',
    'orange-lighter': '#fcd9b6',
    'orange-lightest': '#fff5eb',

    'yellow-darkest': '#453411',
    'yellow-darker': '#684f1d',
    'yellow-dark': '#f2d024',
    'yellow': '#ffed4a',
    'yellow-light': '#fff382',
    'yellow-lighter': '#fff9c2',
    'yellow-lightest': '#fcfbeb',

    'green-darkest': '#0f2f21',
    'green-darker': '#1a4731',
    'green-dark': '#1f9d55',
    'green': '#38c172',
    'green-light': '#51d88a',
    'green-lighter': '#a2f5bf',
    'green-lightest': '#e3fcec',

    'teal-darkest': '#0d3331',
    'teal-darker': '#20504f',
    'teal-dark': '#38a89d',
    'teal': '#4dc0b5',
    'teal-light': '#64d5ca',
    'teal-lighter': '#a0f0ed',
    'teal-lightest': '#e8fffe',

    'blue-darkest': '#182341',
    'blue-darker': '#1D2F64',
    'blue-dark': '#354B8E',
    'blue': '#677AB2',
    'blue-light': '#D9DFF1',
    'blue-lighter': '#F0F3FC',
    'blue-lightest': '#F7F9FE',

    // 'indigo-darkest': '#182341',
    'indigo-darkest': '#253461',
    'indigo-body-text': '#535E7E',
    'indigo-grey-darkest': '#253461',
    'indigo-darker': '#2A3F7D',
    'indigo-dark': '#4764BD',
    'indigo': '#637FD6',
    'indigo-light': '#ACBDF1',
    'indigo-lighter': '#D9DFF1',
    'indigo-lightest': '#F7F9FE',

    'purple-darkest': '#21183c',
    'purple-darker': '#382b5f',
    'purple-dark': '#794acf',
    'purple': '#9561e2',
    'purple-light': '#a779e9',
    'purple-lighter': '#d6bbfc',
    'purple-lightest': '#f3ebff',

    'pink-darkest': '#451225',
    'pink-darker': '#6f213f',
    'pink-dark': '#eb5286',
    'pink': '#f66d9b',
    'pink-light': '#fa7ea8',
    'pink-lighter': '#ffbbca',
    'pink-lightest': '#ffebef',
};

module.exports = {
    prefix: '',
    important: false,
    separator: ':',
    theme: {
        extend: {
            colors: colors,
            screens: {
                '-sm': {'max': '576px'},
                'sm': '576px',
                '-md': {'max': '768px'},
                'sm-md': {'min': '576px', 'max': '768px'},
                'md': '768px',
                'md-lg': {'min': '768px', 'max': '992px'},
                '-lg': {'max': '992px'},
                'lg': '992px',
                'lg-xl': {'min': '992px', 'max': '1200px'},
                'xl': '1200px',
            },
            fontFamily: {
                'heading': ['Lato', 'sans-serif'],
                'body': ['Open Sans', 'sans-serif']
            },
            fontSize: {
                'xs': '.75rem',     // 12px
                'xs-sm': '.8rem',   // 12px
                'sm': '.875rem',    // 14px
                'base': '1rem',     // 16px
                'lg': '1.125rem',   // 18px
                'xl': '1.25rem',    // 20px
                '2xl': '1.5rem',    // 24px
                '3xl': '1.875rem',  // 30px
                '4xl': '2.25rem',   // 36px
                '5xl': '3rem',      // 48px
            },
            fontWeight: {
                'hairline': 100,
                'thin': 200,
                'light': 300,
                'normal': 400,
                'medium': 500,
                'semibold': 600,
                'bold': 700,
                'extrabold': 800,
                'black': 900,
            },
            lineHeight: {
                'squash': 0,
                'none': 1,
                'tight': 1.25,
                'normal': 1.5,
                'loose': 2,
                'very-loose': 3.5,
            },
            letterSpacing: {
                'tight': '-0.05em',
                'normal': '0',
                'wide': '0.05em',
            },
            textColor: colors,
            backgroundColor: colors,
            borderWidth: {
                default: '1px',
                '0': '0',
                '2': '2px',
                '4': '4px',
                '8': '8px',
            },
            borderColor: Object.assign({ default: colors['grey-light'] }, colors),
            borderRadius: {
                'none': '0',
                'sm': '.125rem',
                default: '.25rem',
                'lg': '.5rem',
                'full': '9999px',
            },
            width: {
                'auto': 'auto',
                'px': '1px',
                '1': '0.25rem',
                '2': '0.5rem',
                '3': '0.75rem',
                '4': '1rem',
                '5': '1.25rem',
                '6': '1.5rem',
                '8': '2rem',
                '10': '2.5rem',
                '12': '3rem',
                '16': '4rem',
                '24': '6rem',
                '32': '8rem',
                '48': '12rem',
                '64': '16rem',
                '1/2': '50%',
                '1/3': '33.33333%',
                '2/3': '66.66667%',
                '1/4': '25%',
                '3/4': '75%',
                '1/5': '20%',
                '2/5': '40%',
                '3/5': '60%',
                '4/5': '80%',
                '1/6': '16.66667%',
                '5/6': '83.33333%',
                '1/14': 'calc(100% / 14)',
                '2/14': 'calc(100% / 14 * 2)',
                '3/14': 'calc(100% / 14 * 3)',
                '4/14': 'calc(100% / 14 * 4)',
                '5/14': 'calc(100% / 14 * 5)',
                '6/14': 'calc(100% / 14 * 6)',
                '7/14': 'calc(100% / 14 * 7)',
                '8/14': 'calc(100% / 14 * 8)',
                '9/14': 'calc(100% / 14 * 9)',
                '10/14': 'calc(100% / 14 * 10)',
                '11/14': 'calc(100% / 14 * 11)',
                '12/14': 'calc(100% / 14 * 12)',
                '13/14': 'calc(100% / 14 * 13)',
                'full': '100%',
                'screen': '100vw',
            },
            height: {
                'auto': 'auto',
                'px': '1px',
                '1': '0.25rem',
                '2': '0.5rem',
                '3': '0.75rem',
                '4': '1rem',
                '5': '1.25rem',
                '6': '1.5rem',
                '8': '2rem',
                '10': '2.5rem',
                '12': '3rem',
                '16': '4rem',
                '20': '5rem',
                '24': '6rem',
                '32': '8rem',
                '48': '12rem',
                '64': '16rem',
                'full': '100%',
                'screen': '100vh'
            },
            boxShadow: {
                default: '0 2px 4px 0 rgba(0,0,0,0.10)',
                'md': '0 4px 8px 0 rgba(0,0,0,0.12), 0 2px 4px 0 rgba(0,0,0,0.08)',
                'lg': '0 15px 30px 0 rgba(0,0,0,0.11), 0 5px 15px 0 rgba(0,0,0,0.08)',
                'inner': 'inset 0 2px 4px 0 rgba(0,0,0,0.06)',
                'inner-md': 'inset 0 4px 8px 0 rgba(0,0,0,0.08), inset 0 2px 4px 0 rgba(0,0,0,0.12)',
                'none': 'none',
            },
            minWidth: {
                '0': '0',
                'full': '100%',
            },
            minHeight: {
                '0': '0',
                'full': '100%',
                'screen': '100vh'
            },
            maxWidth: {
                'xs': '20rem',
                'sm': '30rem',
                'md': '40rem',
                'lg': '44rem',
                'xl': '60rem',
                '2xl': '70rem',
                '3xl': '80rem',
                '4xl': '90rem',
                '5xl': '100rem',
                'full': '100%',
            },
            maxHeight: {
                'full': '100%',
                'screen': '100vh',
            },
            padding: {
                'px': '1px',
                '0': '0',
                '1': '0.25rem',
                '2': '0.5rem',
                '3': '0.75rem',
                '4': '1rem',
                '5': '1.25rem',
                '6': '1.5rem',
                '8': '2rem',
                '10': '3rem',
                '12': '4rem',
                '14': '6rem',
                '16': '10rem',
            },
            margin: {
                'auto': 'auto',
                'px': '1px',
                '0': '0',
                '1': '0.25rem',
                '2': '0.5rem',
                '3': '0.75rem',
                '4': '1rem',
                '6': '1.5rem',
                '8': '2rem',
                '10': '4rem',
                '12': '4rem',
                '14': '6rem',
                '16': '10rem',
                '-px': '-1px',
                '-0': '-0',
                '-1': '-0.25rem',
                '-2': '-0.5rem',
                '-3': '-0.75rem',
                '-4': '-1rem',
                '-6': '-1.5rem',
                '-8': '-2rem',
                '-10': '-4rem',
                '-12': '-4rem',
                '-14': '-6rem',
                '-16': '-10rem',
            },
            zIndex: {
                'auto': 'auto',
                '0': 0,
                '10': 10,
                '20': 20,
                '30': 30,
                '40': 40,
                '50': 50,
            },
            opacity: {
                '0': '0',
                '25': '.25',
                '50': '.5',
                '75': '.75',
                '100': '1',
            },
            fill: {
                'current': 'currentColor',
            },
            stroke: {
                'current': 'currentColor',
            },
        },
    },
    variants: {
        appearance: ['responsive'],
        backgroundAttachment: ['responsive'],
        backgroundColor: ['responsive', 'hover', 'focus'],
        backgroundPosition: ['responsive'],
        backgroundRepeat: ['responsive'],
        backgroundSize: ['responsive'],
        borderColor: ['responsive', 'hover', 'focus'],
        borderRadius: ['responsive'],
        borderStyle: ['responsive'],
        borderWidth: ['responsive'],
        cursor: ['responsive'],
        display: ['responsive'],
        flexbox: ['responsive'],
        float: ['responsive'],
        fontFamily: ['responsive'],
        fontWeight: ['responsive', 'hover'],
        height: ['responsive'],
        leading: ['responsive'],
        lists: ['responsive'],
        margin: ['responsive'],
        maxHeight: ['responsive'],
        maxWidth: ['responsive'],
        minHeight: ['responsive'],
        minWidth: ['responsive'],
        opacity: ['responsive'],
        overflow: ['responsive'],
        padding: ['responsive'],
        pointerEvents: ['responsive'],
        position: ['responsive'],
        resize: ['responsive'],
        shadow: ['responsive'],
        fill: [],
        stroke: [],
        textAlign: ['responsive'],
        textColor: ['responsive', 'hover'],
        fontSize: ['responsive'],
        textStyle: ['responsive', 'hover'],
        letterSpacing: ['responsive'],
        userSelect: ['responsive'],
        verticalAlign: ['responsive'],
        visibility: ['responsive'],
        whitespace: ['responsive'],
        width: ['responsive'],
        zIndex: ['responsive'],
    },
};
