<?php

/*
 * This file is part of the league/commonmark package.
 *
 * (c) Colin O'Dell <colinodell@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace League\CommonMark\Tests\Functional\Extension\Footnote;

use League\CommonMark\CommonMarkConverter;
use League\CommonMark\Environment\Environment;
use League\CommonMark\Extension\Footnote\FootnoteExtension;
use League\CommonMark\Tests\Functional\AbstractSpecTest;

final class FootnoteSpecTest extends AbstractSpecTest
{
    protected function setUp(): void
    {
        $environment = Environment::createCommonMarkEnvironment();
        $environment->addExtension(new FootnoteExtension());

        $this->converter = new CommonMarkConverter([], $environment);
    }

    protected function getFileName(): string
    {
        return __DIR__ . '/spec.txt';
    }
}
