## Enterprise API
[Back to the navigation](README.md)

Provides information about a GitHub Enterprise installation. Wraps [GitHub Enterprise API](http://developer.github.com/v3/enterprise/).

### Configuration
In order to configure the client to point to a GitHub Enterprise installation, do the following:

```php
<?php

// This file is generated by Composer
require_once 'vendor/autoload.php';

// Specify the URL of your GitHub Enterprise installation on client initialization
$client = new \Github\Client(null, null, 'https://ghe.host');

// Use the client as you would ordinarily
$repositories = $client->api('user')->repositories('ornicar');
```

### Authentication
The Admin Stats, License, and User Administration API endpoints are only accessible to GitHub Enterprise site administrators. The Management Console API endpoints are only accessible via the Management Console password.

### User Administration

#### Suspend a user (Enterprise only)

> Requires [authentication](security.md).

```php
$client->api('enterprise')->userAdmin()->suspend('ornicar');
```

#### Unsuspend a user (Enterprise only)

> Requires [authentication](security.md).

```php
$client->api('enterprise')->userAdmin()->unsuspend('ornicar');
```
