<?php

/*
 * This file is part of PHP CS Fixer.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *     Dariusz Rumiński <dariusz.ruminski@gmail.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

namespace PhpCsFixer\Tests\Fixer\LanguageConstruct;

use PhpCsFixer\Tests\Test\AbstractFixerTestCase;

/**
 * @author Jules Pietri <jules@heahprod.com>
 *
 * @internal
 *
 * @covers \PhpCsFixer\Fixer\LanguageConstruct\SilencedDeprecationErrorFixer
 */
final class SilencedDeprecationErrorFixerTest extends AbstractFixerTestCase
{
    /**
     * @param string      $expected
     * @param null|string $input
     *
     * @dataProvider provideFixCases
     */
    public function testFix($expected, $input = null)
    {
        $this->doTest($expected, $input);
    }

    public function provideFixCases()
    {
        return [
            [
                '<?php trigger_error("This is a deprecation warning."); ?>',
            ],
            [
                '<?php trigger_error("This is a deprecation warning.", E_USER_WARNING); ?>',
            ],
            [
                '<?php A\B\trigger_error("This is a deprecation warning.", E_USER_DEPRECATED); ?>',
            ],
            [
                '<?php @trigger_error("This is a deprecation warning.", E_USER_DEPRECATED); ?>',
                '<?php trigger_error("This is a deprecation warning.", E_USER_DEPRECATED); ?>',
            ],
            [
                '<?php @\trigger_error("This is a deprecation warning.", E_USER_DEPRECATED); ?>',
                '<?php \trigger_error("This is a deprecation warning.", E_USER_DEPRECATED); ?>',
            ],
            [
                '<?php echo "test";@trigger_error("This is a deprecation warning.", E_USER_DEPRECATED); ?>',
                '<?php echo "test";trigger_error("This is a deprecation warning.", E_USER_DEPRECATED); ?>',
            ],
            [
                '<?php //
@Trigger_Error/**/("This is a deprecation warning.", E_USER_DEPRECATED/***/); ?>',
                '<?php //
Trigger_Error/**/("This is a deprecation warning.", E_USER_DEPRECATED/***/); ?>',
            ],
            [
                '<?php new trigger_error("This is not a deprecation warning.", E_USER_DEPRECATED); ?>',
            ],
            [
                '<?php new \trigger_error("This is not a deprecation warning.", E_USER_DEPRECATED); ?>',
            ],
            [
                '<?php $foo->trigger_error("This is not a deprecation warning.", E_USER_DEPRECATED); ?>',
            ],
            [
                '<?php Foo::trigger_error("This is not a deprecation warning.", E_USER_DEPRECATED); ?>',
            ],
        ];
    }

    /**
     * @requires PHP 7.3
     */
    public function testFix73()
    {
        $this->doTest(
            '<?php @trigger_error("This is a deprecation warning.", E_USER_DEPRECATED, );',
            '<?php trigger_error("This is a deprecation warning.", E_USER_DEPRECATED, );'
        );
    }

    /**
     * @requires PHP <8.0
     */
    public function testFixPrePHP80()
    {
        $this->doTest('<?php \A\B/* */\trigger_error("This is a deprecation warning.", E_USER_DEPRECATED); ?>');
    }
}
