<!-- markdownlint-disable MD013 -->
# About

This PHP SDK produces the SARIF output, which is a JSON file formatted
in accordance with the latest [specification](https://docs.oasis-open.org/sarif/sarif/v2.1.0/sarif-v2.1.0.html).
This implementation follows the general format rules but also specifies several custom properties
written in [property bags](https://docs.oasis-open.org/sarif/sarif/v2.1.0/os/sarif-v2.1.0-os.html#_Toc34317448).

![GraPHP Composer](./assets/images/graph-composer.svg)

## Installation

> Learn how to install this library in different way.

See [Installation Guide](installation.md)

## API Reference

> Discover all API objects with each one at least an example of how to generate a SARIF report.

See [Reference Guide](reference/README.md)

## Converter Reference

> Discover all PHP converters that are able to generate a SARIF report.

See [Converter Guide](converter/README.md)
