<!-- markdownlint-disable MD013 MD024 -->
# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html),
and is generated by [Changie](https://github.com/miniscruff/changie).

## 1.2.0 - 2024-05-02

I'm happy to announce adds of SARIF converters for three well-known PHP linters :

- PHP_CodeSniffer (see feature request <https://github.com/squizlabs/PHP_CodeSniffer/issues/3496>)
- PHPLint (see feature request <https://github.com/overtrue/phplint/issues/186>)
- PHPStan (see feature request <https://github.com/phpstan/phpstan/issues/5973>)

### Added

- `Bartlett\Sarif\Factory\SerializerFactory` contract that define encoder and serializer
for json data (compatible with [Symfony Serializer Component](https://symfony.com/serializer))
- Native PHP JSON implementation with `Bartlett\Sarif\Factory\PhpSerializerFactory`
- Symfony Serializer implementation with `Bartlett\Sarif\Factory\SymfonySerializerFactory`

**Full Changelog**: [1.1.0...1.2.0](https://github.com/llaville/sarif-php-sdk/compare/1.1.0...1.2.0)

## 1.1.0 - 2024-01-07

### Added

- introduces the new `resources/serialize.php` script (to demonstrate usage with help of Symfony/Serializer component)
- all unit tests missing from first release 1.0

### Changed

- raise minimum PHP requirement (7.4 or greater) for property type hinting
- add type hinting on properties and upgrade phpDoc blocks
- remove try/catch bloc that print the final SarifLog object in json format on all examples scripts
- API: `SarifLog` is no more marked as final to be able to extends or change current (`__toString`, `jsonSerializable`) behavior

### Fixed

Codebase is now PHPStan rule level 9 compatible :

- `ExternalPropertyFileReference` definition with optional values
- `GraphTraversal` definition with optional values
- `PhysicalLocation` definition with optional values
- `Region` definition with optional values
- `Taxonomies` property

**Full Changelog**: [1.0.1...1.1.0](https://github.com/llaville/sarif-php-sdk/compare/1.0.1...1.1.0)

## 1.0.1 - 2021-12-20

### Fixed

- clean-up code in `PropertyBag` because duplicated keys is not possible

**Full Changelog**: [1.0.0...1.0.1](https://github.com/llaville/sarif-php-sdk/compare/1.0.0...1.0.1)

## 1.0.0 - 2021-11-09

Implements full [SARIF specifications 2.1.0](https://docs.oasis-open.org/sarif/sarif/v2.1.0/sarif-v2.1.0.html)

**Full Changelog**: [1584943...1.0.0](https://github.com/llaville/sarif-php-sdk/compare/1584943...1.0.0)
