<?php
// This file was auto-generated from sdk-root/src/data/sagemaker/2017-07-24/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Provides APIs for creating and managing Amazon SageMaker resources. </p> <p>Other Resources:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/whatis.html#first-time-user">Amazon SageMaker Developer Guide</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/augmented-ai/2019-11-07/APIReference/Welcome.html">Amazon Augmented AI Runtime API Reference</a> </p> </li> </ul>', 'operations' => [ 'AddAssociation' => '<p>Creates an <i>association</i> between the source and the destination. A source can be associated with multiple destinations, and a destination can be associated with multiple sources. An association is a lineage tracking entity. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>', 'AddTags' => '<p>Adds or overwrites one or more tags for the specified Amazon SageMaker resource. You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints.</p> <p>Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information about tags, see For more information, see <a href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging Strategies</a>.</p> <note> <p>Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you first create the tuning job by specifying them in the <code>Tags</code> parameter of <a>CreateHyperParameterTuningJob</a> </p> </note> <note> <p>Tags that you add to a SageMaker Studio Domain or User Profile by calling this API are also added to any Apps that the Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile by specifying them in the <code>Tags</code> parameter of <a>CreateDomain</a> or <a>CreateUserProfile</a>.</p> </note>', 'AssociateTrialComponent' => '<p>Associates a trial component with a trial. A trial component can be associated with multiple trials. To disassociate a trial component from a trial, call the <a>DisassociateTrialComponent</a> API.</p>', 'BatchDescribeModelPackage' => '<p>This action batch describes a list of versioned model packages</p>', 'CreateAction' => '<p>Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>', 'CreateAlgorithm' => '<p>Create a machine learning algorithm that you can use in Amazon SageMaker and list in the Amazon Web Services Marketplace.</p>', 'CreateApp' => '<p>Creates a running app for the specified UserProfile. Supported apps are <code>JupyterServer</code> and <code>KernelGateway</code>. This operation is automatically invoked by Amazon SageMaker Studio upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may have multiple Apps active simultaneously.</p>', 'CreateAppImageConfig' => '<p>Creates a configuration for running a SageMaker image as a KernelGateway app. The configuration specifies the Amazon Elastic File System (EFS) storage volume on the image, and a list of the kernels in the image.</p>', 'CreateArtifact' => '<p>Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>', 'CreateAutoMLJob' => '<p>Creates an Autopilot job.</p> <p>Find the best-performing model after you run an Autopilot job by calling .</p> <p>For information about how to use Autopilot, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html">Automate Model Development with Amazon SageMaker Autopilot</a>.</p>', 'CreateCodeRepository' => '<p>Creates a Git repository as a resource in your Amazon SageMaker account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your Amazon SageMaker account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.</p> <p>The repository can be hosted either in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository.</p>', 'CreateCompilationJob' => '<p>Starts a model compilation job. After the model has been compiled, Amazon SageMaker saves the resulting model artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify. </p> <p>If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that case, deploy them as an ML resource.</p> <p>In the request body, you provide the following:</p> <ul> <li> <p>A name for the compilation job</p> </li> <li> <p> Information about the input model artifacts </p> </li> <li> <p>The output location for the compiled model and the device (target) that the model runs on </p> </li> <li> <p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job. </p> </li> </ul> <p>You can also provide a <code>Tag</code> to track the model compilation job\'s resource use and costs. The response body contains the <code>CompilationJobArn</code> for the compiled job.</p> <p>To stop a model compilation job, use <a>StopCompilationJob</a>. To get information about a particular model compilation job, use <a>DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use <a>ListCompilationJobs</a>.</p>', 'CreateContext' => '<p>Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage Tracking</a>.</p>', 'CreateDataQualityJobDefinition' => '<p>Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>', 'CreateDeviceFleet' => '<p>Creates a device fleet.</p>', 'CreateDomain' => '<p>Creates a <code>Domain</code> used by Amazon SageMaker Studio. A domain consists of an associated Amazon Elastic File System (EFS) volume, a list of authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC) configurations. An Amazon Web Services account is limited to one domain per region. Users within a domain can share notebook files and other artifacts with each other.</p> <p> <b>EFS storage</b> </p> <p>When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.</p> <p>SageMaker uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can specify a customer managed key. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using Encryption</a>.</p> <p> <b>VPC configuration</b> </p> <p>All SageMaker Studio traffic between the domain and the EFS volume is through the specified VPC and subnets. For other Studio traffic, you can specify the <code>AppNetworkAccessType</code> parameter. <code>AppNetworkAccessType</code> corresponds to the network access type that you choose when you onboard to Studio. The following options are available:</p> <ul> <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker, which allows internet access. This is the default value.</p> </li> <li> <p> <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets. Internet access is disabled by default. To allow internet access, you must specify a NAT gateway.</p> <p>When internet access is disabled, you won\'t be able to run a Studio notebook or to train or host models unless your VPC has an interface endpoint to the SageMaker API and runtime or a NAT gateway and your security groups allow outbound connections.</p> </li> </ul> <important> <p>NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a SageMaker Studio app successfully.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect SageMaker Studio Notebooks to Resources in a VPC</a>.</p>', 'CreateEdgePackagingJob' => '<p>Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the resulting artifacts to an S3 bucket that you specify.</p>', 'CreateEndpoint' => '<p>Creates an endpoint using the endpoint configuration specified in the request. Amazon SageMaker uses the endpoint to provision resources and deploy models. You create the endpoint configuration with the <a>CreateEndpointConfig</a> API. </p> <p> Use this API to deploy models using Amazon SageMaker hosting services. </p> <p>For an example that calls this method when deploying a model to Amazon SageMaker hosting services, see the <a href="https://github.com/aws/amazon-sagemaker-examples/blob/master/sagemaker-fundamentals/create-endpoint/create_endpoint.ipynb">Create Endpoint example notebook.</a> </p> <note> <p> You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To update an endpoint, you must create a new <code>EndpointConfig</code>.</p> </note> <p>The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account. </p> <p>When it receives the request, Amazon SageMaker creates the endpoint, launches the resources (ML compute instances), and deploys the model(s) on them. </p> <note> <p>When you call <a>CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html"> <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call <a>DescribeEndpointConfig</a> before calling <a>CreateEndpoint</a> to minimize the potential impact of a DynamoDB eventually consistent read.</p> </note> <p>When Amazon SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the endpoint, it sets the status to <code>InService</code>. Amazon SageMaker can then process incoming requests for inferences. To check the status of an endpoint, use the <a>DescribeEndpoint</a> API.</p> <p>If any of the models hosted at this endpoint get model data from an Amazon S3 location, Amazon SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> <note> <p> To add the IAM role policies for using this API operation, go to the <a href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search the IAM role that you want to grant access to use the <a>CreateEndpoint</a> and <a>CreateEndpointConfig</a> API operations, add the following policies to the role. </p> <ul> <li> <p>Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.</p> </li> <li> <p>Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the JSON file of the IAM role: </p> <p> <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code> </p> <p> <code>"Resource": [</code> </p> <p> <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code> </p> <p> <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code> </p> <p> <code>]</code> </p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions: Actions, Permissions, and Resources Reference</a>.</p> </li> </ul> </note>', 'CreateEndpointConfig' => '<p>Creates an endpoint configuration that Amazon SageMaker hosting services uses to deploy models. In the configuration, you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that you want Amazon SageMaker to provision. Then you call the <a>CreateEndpoint</a> API.</p> <note> <p> Use this API if you want to use Amazon SageMaker hosting services to deploy models into production. </p> </note> <p>In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each <code>ProductionVariant</code> parameter also describes the resources that you want Amazon SageMaker to provision. This includes the number and type of ML compute instances to deploy. </p> <p>If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign traffic weight 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds of the traffic to Model A, and one-third to model B. </p> <note> <p>When you call <a>CreateEndpoint</a>, a load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a DynamoDB table supporting <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html"> <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB, this causes a validation error. If you repeat your read request after a short time, the response should return the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers call <a>DescribeEndpointConfig</a> before calling <a>CreateEndpoint</a> to minimize the potential impact of a DynamoDB eventually consistent read.</p> </note>', 'CreateExperiment' => '<p>Creates an SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed, compared and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a machine learning model.</p> <p>The goal of an experiment is to determine the components that produce the best model. Multiple trials are performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the remaining inputs constant.</p> <p>When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p> <p>You can add tags to experiments, trials, trial components and then use the <a>Search</a> API to search for the tags.</p> <p>To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a description later, or to change the description, call the <a>UpdateExperiment</a> API.</p> <p>To get a list of all your experiments, call the <a>ListExperiments</a> API. To view an experiment\'s properties, call the <a>DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the <a>ListTrials</a> API. To create a trial call the <a>CreateTrial</a> API.</p>', 'CreateFeatureGroup' => '<p>Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined in the <code>FeatureStore</code> to describe a <code>Record</code>. </p> <p>The <code>FeatureGroup</code> defines the schema and features contained in the FeatureGroup. A <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.</p> <important> <p>You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a <code>FeatureGroup</code>.</p> </important>', 'CreateFlowDefinition' => '<p>Creates a flow definition.</p>', 'CreateHumanTaskUi' => '<p>Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel interface with an instruction area, the item to review, and an input area.</p>', 'CreateHyperParameterTuningJob' => '<p>Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured by an objective metric that you choose.</p>', 'CreateImage' => '<p>Creates a custom SageMaker image. A SageMaker image is a set of image versions. Each image version represents a container image stored in Amazon Container Registry (ECR). For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.</p>', 'CreateImageVersion' => '<p>Creates a version of the SageMaker image specified by <code>ImageName</code>. The version represents the Amazon Container Registry (ECR) container image specified by <code>BaseImage</code>.</p>', 'CreateInferenceRecommendationsJob' => '<p>Starts a recommendation job. You can create either an instance recommendation or load test job.</p>', 'CreateLabelingJob' => '<p>Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to train machine learning models. </p> <p>You can select your workforce from one of three providers:</p> <ul> <li> <p>A private workforce that you create. It can include employees, contractors, and outside experts. Use a private workforce when want the data to stay within your organization or when a specific set of skills is required.</p> </li> <li> <p>One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in specific areas. </p> </li> <li> <p>The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data or data that has been stripped of any personally identifiable information.</p> </li> </ul> <p>You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by machine or if it needs to be sent to a human worker. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data Labeling</a>.</p> <p>The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that describes the location of each object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.</p> <p>The output can be used as the manifest file for another labeling job or as training data for your machine learning models.</p> <p>You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled. A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to create a static labeling job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling Job</a>.</p>', 'CreateModel' => '<p>Creates a model in Amazon SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.</p> <p>Use this API to create a model if you want to use Amazon SageMaker hosting services or run a batch transform job.</p> <p>To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then create an endpoint with the <code>CreateEndpoint</code> API. Amazon SageMaker then deploys all of the containers that you defined for the model in the hosting environment. </p> <p>For an example that calls this method when deploying a model to Amazon SageMaker hosting services, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html#ex1-deploy-model-boto">Deploy the Model to Amazon SageMaker Hosting Services (Amazon Web Services SDK for Python (Boto 3)).</a> </p> <p>To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API. Amazon SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.</p> <p>In the <code>CreateModel</code> request, you must define a container with the <code>PrimaryContainer</code> parameter.</p> <p>In the request, you also provide an IAM role that Amazon SageMaker can assume to access model artifacts and docker image for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM role to manage permissions the inference code needs. For example, if the inference code access any other Amazon Web Services resources, you grant necessary permissions via this role.</p>', 'CreateModelBiasJobDefinition' => '<p>Creates the definition for a model bias job.</p>', 'CreateModelExplainabilityJobDefinition' => '<p>Creates the definition for a model explainability job.</p>', 'CreateModelPackage' => '<p>Creates a model package that you can use to create Amazon SageMaker models or list on Amazon Web Services Marketplace, or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in Amazon SageMaker.</p> <p>To create a model package by specifying a Docker container that contains your inference code and the Amazon S3 location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for <code>SourceAlgorithmSpecification</code>.</p> <note> <p>There are two types of model packages:</p> <ul> <li> <p>Versioned - a model that is part of a model group in the model registry.</p> </li> <li> <p>Unversioned - a model package that is not part of a model group.</p> </li> </ul> </note>', 'CreateModelPackageGroup' => '<p>Creates a model group. A model group contains a group of model versions.</p>', 'CreateModelQualityJobDefinition' => '<p>Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>', 'CreateMonitoringSchedule' => '<p>Creates a schedule that regularly starts Amazon SageMaker Processing Jobs to monitor the data captured for an Amazon SageMaker Endoint.</p>', 'CreateNotebookInstance' => '<p>Creates an Amazon SageMaker notebook instance. A notebook instance is a machine learning (ML) compute instance running on a Jupyter notebook. </p> <p>In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run. Amazon SageMaker launches the instance, installs common libraries that you can use to explore datasets for model training, and attaches an ML storage volume to the notebook instance. </p> <p>Amazon SageMaker also provides a set of example notebooks. Each notebook demonstrates how to use Amazon SageMaker with a specific algorithm or with a machine learning framework. </p> <p>After receiving the request, Amazon SageMaker does the following:</p> <ol> <li> <p>Creates a network interface in the Amazon SageMaker VPC.</p> </li> <li> <p>(Option) If you specified <code>SubnetId</code>, Amazon SageMaker creates a network interface in your own VPC, which is inferred from the subnet ID that you provide in the input. When creating this network interface, Amazon SageMaker attaches the security group that you specified in the request to the network interface that it creates in your VPC.</p> </li> <li> <p>Launches an EC2 instance of the type specified in the request in the Amazon SageMaker VPC. If you specified <code>SubnetId</code> of your VPC, Amazon SageMaker specifies both network interfaces when launching this instance. This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow it.</p> </li> </ol> <p>After creating the notebook instance, Amazon SageMaker returns its Amazon Resource Name (ARN). You can\'t change the name of a notebook instance after you create it.</p> <p>After Amazon SageMaker creates the notebook instance, you can connect to the Jupyter server and work in Jupyter notebooks. For example, you can write code to explore a dataset that you can use for model training, train a model, host models by creating Amazon SageMaker endpoints, and validate hosted models. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>. </p>', 'CreateNotebookInstanceLifecycleConfig' => '<p>Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.</p> <p>Each lifecycle configuration script has a limit of 16384 characters.</p> <p>The value of the <code>$PATH</code> environment variable that is available to both scripts is <code>/sbin:bin:/usr/sbin:/usr/bin</code>.</p> <p>View CloudWatch Logs for notebook instance lifecycle configurations in log group <code>/aws/sagemaker/NotebookInstances</code> in log stream <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.</p> <p>Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'CreatePipeline' => '<p>Creates a pipeline using a JSON pipeline definition.</p>', 'CreatePresignedDomainUrl' => '<p>Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be automatically signed in to Amazon SageMaker Studio, and granted access to all of the Apps and files associated with the Domain\'s Amazon Elastic File System (EFS) volume. This operation can only be called when the authentication mode equals IAM. </p> <p>The IAM role or user used to call this API defines the permissions to access the app. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.</p> <p>You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or Amazon VPC Endpoints that you specify. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to SageMaker Studio Through an Interface VPC Endpoint</a> .</p> <note> <p>The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit expires, you are directed to the Amazon Web Services console sign-in page.</p> </note>', 'CreatePresignedNotebookInstanceUrl' => '<p>Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the Amazon SageMaker console, when you choose <code>Open</code> next to a notebook instance, Amazon SageMaker opens a new tab showing the Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.</p> <p> The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook instance.</p> <p>You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify. Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to specify the list of IP addresses that you want to have access to the notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter">Limit Access to a Notebook Instance by IP Address</a>.</p> <note> <p>The URL that you get from a call to <a>CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you try to use the URL after the 5-minute limit expires, you are directed to the Amazon Web Services console sign-in page.</p> </note>', 'CreateProcessingJob' => '<p>Creates a processing job.</p>', 'CreateProject' => '<p>Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from training to deploying an approved model.</p>', 'CreateStudioLifecycleConfig' => '<p>Creates a new Studio Lifecycle Configuration.</p>', 'CreateTrainingJob' => '<p>Starts a model training job. After training completes, Amazon SageMaker saves the resulting model artifacts to an Amazon S3 location that you specify. </p> <p>If you choose to host your model using Amazon SageMaker hosting services, you can use the resulting model artifacts as part of the model. You can also use the artifacts in a machine learning service other than Amazon SageMaker, provided that you know how to use them for inference. </p> <p>In the request body, you provide the following: </p> <ul> <li> <p> <code>AlgorithmSpecification</code> - Identifies the training algorithm to use. </p> </li> <li> <p> <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of hyperparameters for each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p> </li> <li> <p> <code>InputDataConfig</code> - Describes the training dataset and the Amazon S3, EFS, or FSx location where it is stored.</p> </li> <li> <p> <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of model training. </p> </li> <li> <p> <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy for model training. In distributed training, you specify more than one instance. </p> </li> <li> <p> <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by using Amazon EC2 Spot instances. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot Training</a>. </p> </li> <li> <p> <code>RoleArn</code> - The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during model training. You must grant this role the necessary permissions so that Amazon SageMaker can successfully complete model training. </p> </li> <li> <p> <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to complete. </p> </li> <li> <p> <code>Environment</code> - The environment variables to set in the Docker container.</p> </li> <li> <p> <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p> </li> </ul> <p> For more information about Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>. </p>', 'CreateTransformJob' => '<p>Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.</p> <p>To perform batch transformations, you create a transform job and use the data that you have readily available.</p> <p>In the request body, you provide the following:</p> <ul> <li> <p> <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account.</p> </li> <li> <p> <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on creating a model, see <a>CreateModel</a>.</p> </li> <li> <p> <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p> </li> <li> <p> <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p> </li> <li> <p> <code>TransformResources</code> - Identifies the ML compute instances for the transform job.</p> </li> </ul> <p>For more information about how batch transformation works, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.</p>', 'CreateTrial' => '<p>Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a machine learning model. A trial is part of a single SageMaker <i>experiment</i>.</p> <p>When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p> <p>You can add tags to a trial and then use the <a>Search</a> API to search for the tags.</p> <p>To get a list of all your trials, call the <a>ListTrials</a> API. To view a trial\'s properties, call the <a>DescribeTrial</a> API. To create a trial component, call the <a>CreateTrialComponent</a> API.</p>', 'CreateTrialComponent' => '<p>Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one or more trial components. A trial component can be used in multiple trials.</p> <p>Trial components include pre-processing jobs, training jobs, and batch transform jobs.</p> <p>When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must use the logging APIs provided by the SDK.</p> <p>You can add tags to a trial component and then use the <a>Search</a> API to search for the tags.</p>', 'CreateUserProfile' => '<p>Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when a user onboards to Amazon SageMaker Studio. If an administrator invites a person by email or imports them from SSO, a user profile is automatically created. A user profile is the primary holder of settings for an individual user and has a reference to the user\'s private Amazon Elastic File System (EFS) home directory. </p>', 'CreateWorkforce' => '<p>Use this operation to create a workforce. This operation will return an error if a workforce already exists in the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services Region per Amazon Web Services account.</p> <p>If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new workforce.</p> <p>To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private Workforce (Amazon Cognito)</a>.</p> <p>To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and Amazon A2I to create work teams. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private Workforce (OIDC IdP)</a>.</p>', 'CreateWorkteam' => '<p>Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools. You must first create the user pools before you can create a work team.</p> <p>You cannot create more than 25 work teams in an account and region.</p>', 'DeleteAction' => '<p>Deletes an action.</p>', 'DeleteAlgorithm' => '<p>Removes the specified algorithm from your account.</p>', 'DeleteApp' => '<p>Used to stop and delete an app.</p>', 'DeleteAppImageConfig' => '<p>Deletes an AppImageConfig.</p>', 'DeleteArtifact' => '<p>Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.</p>', 'DeleteAssociation' => '<p>Deletes an association.</p>', 'DeleteCodeRepository' => '<p>Deletes the specified Git repository from your account.</p>', 'DeleteContext' => '<p>Deletes an context.</p>', 'DeleteDataQualityJobDefinition' => '<p>Deletes a data quality monitoring job definition.</p>', 'DeleteDeviceFleet' => '<p>Deletes a fleet.</p>', 'DeleteDomain' => '<p>Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again using SSO. Use with caution. All of the members of the domain will lose access to their EFS volume, including data, notebooks, and other artifacts. </p>', 'DeleteEndpoint' => '<p>Deletes an endpoint. Amazon SageMaker frees up all of the resources that were deployed when the endpoint was created. </p> <p>Amazon SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don\'t need to use the <a href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.</p>', 'DeleteEndpointConfig' => '<p>Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified configuration. It does not delete endpoints created using the configuration. </p> <p>You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.</p>', 'DeleteExperiment' => '<p>Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the <a>ListTrials</a> API to get a list of the trials associated with the experiment.</p>', 'DeleteFeatureGroup' => '<p>Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after <code>DeleteFeatureGroup</code> is called. </p> <p>Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and tables that are automatically created for your <code>OfflineStore</code> are not deleted. </p>', 'DeleteFlowDefinition' => '<p>Deletes the specified flow definition.</p>', 'DeleteHumanTaskUi' => '<p>Use this operation to delete a human task user interface (worker task template).</p> <p> To see a list of human task user interfaces (work task templates) in your account, use . When you delete a worker task template, it no longer appears when you call <code>ListHumanTaskUis</code>.</p>', 'DeleteImage' => '<p>Deletes a SageMaker image and all versions of the image. The container images aren\'t deleted.</p>', 'DeleteImageVersion' => '<p>Deletes a version of a SageMaker image. The container image the version represents isn\'t deleted.</p>', 'DeleteModel' => '<p>Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in Amazon SageMaker when you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role that you specified when creating the model. </p>', 'DeleteModelBiasJobDefinition' => '<p>Deletes an Amazon SageMaker model bias job definition.</p>', 'DeleteModelExplainabilityJobDefinition' => '<p>Deletes an Amazon SageMaker model explainability job definition.</p>', 'DeleteModelPackage' => '<p>Deletes a model package.</p> <p>A model package is used to create Amazon SageMaker models or list on Amazon Web Services Marketplace. Buyers can subscribe to model packages listed on Amazon Web Services Marketplace to create models in Amazon SageMaker.</p>', 'DeleteModelPackageGroup' => '<p>Deletes the specified model group.</p>', 'DeleteModelPackageGroupPolicy' => '<p>Deletes a model group resource policy.</p>', 'DeleteModelQualityJobDefinition' => '<p>Deletes the secified model quality monitoring job definition.</p>', 'DeleteMonitoringSchedule' => '<p>Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job execution history of the monitoring schedule. </p>', 'DeleteNotebookInstance' => '<p> Deletes an Amazon SageMaker notebook instance. Before you can delete a notebook instance, you must call the <code>StopNotebookInstance</code> API. </p> <important> <p>When you delete a notebook instance, you lose all of your data. Amazon SageMaker removes the ML compute instance, and deletes the ML storage volume and the network interface associated with the notebook instance. </p> </important>', 'DeleteNotebookInstanceLifecycleConfig' => '<p>Deletes a notebook instance lifecycle configuration.</p>', 'DeletePipeline' => '<p>Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline, all instances of the pipeline are deleted.</p>', 'DeleteProject' => '<p>Delete the specified project.</p>', 'DeleteStudioLifecycleConfig' => '<p>Deletes the Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration, there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration from UserSettings in all Domains and UserProfiles.</p>', 'DeleteTags' => '<p>Deletes the specified tags from an Amazon SageMaker resource.</p> <p>To list a resource\'s tags, use the <code>ListTags</code> API. </p> <note> <p>When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from training jobs that the hyperparameter tuning job launched before you called this API.</p> </note> <note> <p>When you call this API to delete tags from a SageMaker Studio Domain or User Profile, the deleted tags are not removed from Apps that the SageMaker Studio Domain or User Profile launched before you called this API.</p> </note>', 'DeleteTrial' => '<p>Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the <a>DescribeTrialComponent</a> API to get the list of trial components.</p>', 'DeleteTrialComponent' => '<p>Deletes the specified trial component. A trial component must be disassociated from all trials before the trial component can be deleted. To disassociate a trial component from a trial, call the <a>DisassociateTrialComponent</a> API.</p>', 'DeleteUserProfile' => '<p>Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including data, notebooks, and other artifacts.</p>', 'DeleteWorkforce' => '<p>Use this operation to delete a workforce.</p> <p>If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this operation to delete the existing workforce and then use to create a new workforce.</p> <important> <p>If a private workforce contains one or more work teams, you must use the operation to delete all work teams before you delete the workforce. If you try to delete a workforce that contains one or more work teams, you will recieve a <code>ResourceInUse</code> error.</p> </important>', 'DeleteWorkteam' => '<p>Deletes an existing work team. This operation can\'t be undone.</p>', 'DeregisterDevices' => '<p>Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.</p>', 'DescribeAction' => '<p>Describes an action.</p>', 'DescribeAlgorithm' => '<p>Returns a description of the specified algorithm that is in your account.</p>', 'DescribeApp' => '<p>Describes the app.</p>', 'DescribeAppImageConfig' => '<p>Describes an AppImageConfig.</p>', 'DescribeArtifact' => '<p>Describes an artifact.</p>', 'DescribeAutoMLJob' => '<p>Returns information about an Amazon SageMaker AutoML job.</p>', 'DescribeCodeRepository' => '<p>Gets details about the specified Git repository.</p>', 'DescribeCompilationJob' => '<p>Returns information about a model compilation job.</p> <p>To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about multiple model compilation jobs, use <a>ListCompilationJobs</a>.</p>', 'DescribeContext' => '<p>Describes a context.</p>', 'DescribeDataQualityJobDefinition' => '<p>Gets the details of a data quality monitoring job definition.</p>', 'DescribeDevice' => '<p>Describes the device.</p>', 'DescribeDeviceFleet' => '<p>A description of the fleet the device belongs to.</p>', 'DescribeDomain' => '<p>The description of the domain.</p>', 'DescribeEdgePackagingJob' => '<p>A description of edge packaging jobs.</p>', 'DescribeEndpoint' => '<p>Returns the description of an endpoint.</p>', 'DescribeEndpointConfig' => '<p>Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.</p>', 'DescribeExperiment' => '<p>Provides a list of an experiment\'s properties.</p>', 'DescribeFeatureGroup' => '<p>Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.</p>', 'DescribeFlowDefinition' => '<p>Returns information about the specified flow definition.</p>', 'DescribeHumanTaskUi' => '<p>Returns information about the requested human task user interface (worker task template).</p>', 'DescribeHyperParameterTuningJob' => '<p>Gets a description of a hyperparameter tuning job.</p>', 'DescribeImage' => '<p>Describes a SageMaker image.</p>', 'DescribeImageVersion' => '<p>Describes a version of a SageMaker image.</p>', 'DescribeInferenceRecommendationsJob' => '<p>Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.</p>', 'DescribeLabelingJob' => '<p>Gets information about a labeling job.</p>', 'DescribeLineageGroup' => '<p>Provides a list of properties for the requested lineage group. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', 'DescribeModel' => '<p>Describes a model that you created using the <code>CreateModel</code> API.</p>', 'DescribeModelBiasJobDefinition' => '<p>Returns a description of a model bias job definition.</p>', 'DescribeModelExplainabilityJobDefinition' => '<p>Returns a description of a model explainability job definition.</p>', 'DescribeModelPackage' => '<p>Returns a description of the specified model package, which is used to create SageMaker models or list them on Amazon Web Services Marketplace.</p> <p>To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.</p>', 'DescribeModelPackageGroup' => '<p>Gets a description for the specified model group.</p>', 'DescribeModelQualityJobDefinition' => '<p>Returns a description of a model quality job definition.</p>', 'DescribeMonitoringSchedule' => '<p>Describes the schedule for a monitoring job.</p>', 'DescribeNotebookInstance' => '<p>Returns information about a notebook instance.</p>', 'DescribeNotebookInstanceLifecycleConfig' => '<p>Returns a description of a notebook instance lifecycle configuration.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'DescribePipeline' => '<p>Describes the details of a pipeline.</p>', 'DescribePipelineDefinitionForExecution' => '<p>Describes the details of an execution\'s pipeline definition.</p>', 'DescribePipelineExecution' => '<p>Describes the details of a pipeline execution.</p>', 'DescribeProcessingJob' => '<p>Returns a description of a processing job.</p>', 'DescribeProject' => '<p>Describes the details of a project.</p>', 'DescribeStudioLifecycleConfig' => '<p>Describes the Studio Lifecycle Configuration.</p>', 'DescribeSubscribedWorkteam' => '<p>Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor in the Amazon Web Services Marketplace.</p>', 'DescribeTrainingJob' => '<p>Returns information about a training job. </p> <p>Some of the attributes below only appear if the training job successfully starts. If the training job fails, <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>, attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>, and <code>BillableTimeInSeconds</code> may not be present in the response.</p>', 'DescribeTransformJob' => '<p>Returns information about a transform job.</p>', 'DescribeTrial' => '<p>Provides a list of a trial\'s properties.</p>', 'DescribeTrialComponent' => '<p>Provides a list of a trials component\'s properties.</p>', 'DescribeUserProfile' => '<p>Describes a user profile. For more information, see <code>CreateUserProfile</code>.</p>', 'DescribeWorkforce' => '<p>Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable, allowed IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges are the IP addresses that workers can use to access tasks. </p> <important> <p>This operation applies only to private workforces.</p> </important>', 'DescribeWorkteam' => '<p>Gets information about a specific work team. You can see information such as the create date, the last updated date, membership information, and the work team\'s Amazon Resource Name (ARN).</p>', 'DisableSagemakerServicecatalogPortfolio' => '<p>Disables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.</p>', 'DisassociateTrialComponent' => '<p>Disassociates a trial component from a trial. This doesn\'t effect other trials the component is associated with. Before you can delete a component, you must disassociate the component from all trials it is associated with. To associate a trial component with a trial, call the <a>AssociateTrialComponent</a> API.</p> <p>To get a list of the trials a component is associated with, use the <a>Search</a> API. Specify <code>ExperimentTrialComponent</code> for the <code>Resource</code> parameter. The list appears in the response under <code>Results.TrialComponent.Parents</code>.</p>', 'EnableSagemakerServicecatalogPortfolio' => '<p>Enables using Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.</p>', 'GetDeviceFleetReport' => '<p>Describes a fleet.</p>', 'GetLineageGroupPolicy' => '<p>The resource policy for the lineage group.</p>', 'GetModelPackageGroupPolicy' => '<p>Gets a resource policy that manages access for a model group. For information about resource policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User Guide.</i>.</p>', 'GetSagemakerServicecatalogPortfolioStatus' => '<p>Gets the status of Service Catalog in SageMaker. Service Catalog is used to create SageMaker projects.</p>', 'GetSearchSuggestions' => '<p>An auto-complete API for the search functionality in the Amazon SageMaker console. It returns suggestions of possible matches for the property name to use in <code>Search</code> queries. Provides suggestions for <code>HyperParameters</code>, <code>Tags</code>, and <code>Metrics</code>.</p>', 'ListActions' => '<p>Lists the actions in your account and their properties.</p>', 'ListAlgorithms' => '<p>Lists the machine learning algorithms that have been created.</p>', 'ListAppImageConfigs' => '<p>Lists the AppImageConfigs in your account and their properties. The list can be filtered by creation time or modified time, and whether the AppImageConfig name contains a specified string.</p>', 'ListApps' => '<p>Lists apps.</p>', 'ListArtifacts' => '<p>Lists the artifacts in your account and their properties.</p>', 'ListAssociations' => '<p>Lists the associations in your account and their properties.</p>', 'ListAutoMLJobs' => '<p>Request a list of jobs.</p>', 'ListCandidatesForAutoMLJob' => '<p>List the candidates created for the job.</p>', 'ListCodeRepositories' => '<p>Gets a list of the Git repositories in your account.</p>', 'ListCompilationJobs' => '<p>Lists model compilation jobs that satisfy various filters.</p> <p>To create a model compilation job, use <a>CreateCompilationJob</a>. To get information about a particular model compilation job you have created, use <a>DescribeCompilationJob</a>.</p>', 'ListContexts' => '<p>Lists the contexts in your account and their properties.</p>', 'ListDataQualityJobDefinitions' => '<p>Lists the data quality job definitions in your account.</p>', 'ListDeviceFleets' => '<p>Returns a list of devices in the fleet.</p>', 'ListDevices' => '<p>A list of devices.</p>', 'ListDomains' => '<p>Lists the domains.</p>', 'ListEdgePackagingJobs' => '<p>Returns a list of edge packaging jobs.</p>', 'ListEndpointConfigs' => '<p>Lists endpoint configurations.</p>', 'ListEndpoints' => '<p>Lists endpoints.</p>', 'ListExperiments' => '<p>Lists all the experiments in your account. The list can be filtered to show only experiments that were created in a specific time range. The list can be sorted by experiment name or creation time.</p>', 'ListFeatureGroups' => '<p>List <code>FeatureGroup</code>s based on given filter and order.</p>', 'ListFlowDefinitions' => '<p>Returns information about the flow definitions in your account.</p>', 'ListHumanTaskUis' => '<p>Returns information about the human task user interfaces in your account.</p>', 'ListHyperParameterTuningJobs' => '<p>Gets a list of <a>HyperParameterTuningJobSummary</a> objects that describe the hyperparameter tuning jobs launched in your account.</p>', 'ListImageVersions' => '<p>Lists the versions of a specified image and their properties. The list can be filtered by creation time or modified time.</p>', 'ListImages' => '<p>Lists the images in your account and their properties. The list can be filtered by creation time or modified time, and whether the image name contains a specified string.</p>', 'ListInferenceRecommendationsJobs' => '<p>Lists recommendation jobs that satisfy various filters.</p>', 'ListLabelingJobs' => '<p>Gets a list of labeling jobs.</p>', 'ListLabelingJobsForWorkteam' => '<p>Gets a list of labeling jobs assigned to a specified work team.</p>', 'ListLineageGroups' => '<p>A list of lineage groups shared with your Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', 'ListModelBiasJobDefinitions' => '<p>Lists model bias jobs definitions that satisfy various filters.</p>', 'ListModelExplainabilityJobDefinitions' => '<p>Lists model explainability job definitions that satisfy various filters.</p>', 'ListModelMetadata' => '<p>Lists the domain, framework, task, and model name of standard machine learning models found in common model zoos.</p>', 'ListModelPackageGroups' => '<p>Gets a list of the model groups in your Amazon Web Services account.</p>', 'ListModelPackages' => '<p>Lists the model packages that have been created.</p>', 'ListModelQualityJobDefinitions' => '<p>Gets a list of model quality monitoring job definitions in your account.</p>', 'ListModels' => '<p>Lists models created with the <code>CreateModel</code> API.</p>', 'ListMonitoringExecutions' => '<p>Returns list of all monitoring job executions.</p>', 'ListMonitoringSchedules' => '<p>Returns list of all monitoring schedules.</p>', 'ListNotebookInstanceLifecycleConfigs' => '<p>Lists notebook instance lifestyle configurations created with the <a>CreateNotebookInstanceLifecycleConfig</a> API.</p>', 'ListNotebookInstances' => '<p>Returns a list of the Amazon SageMaker notebook instances in the requester\'s account in an Amazon Web Services Region. </p>', 'ListPipelineExecutionSteps' => '<p>Gets a list of <code>PipeLineExecutionStep</code> objects.</p>', 'ListPipelineExecutions' => '<p>Gets a list of the pipeline executions.</p>', 'ListPipelineParametersForExecution' => '<p>Gets a list of parameters for a pipeline execution.</p>', 'ListPipelines' => '<p>Gets a list of pipelines.</p>', 'ListProcessingJobs' => '<p>Lists processing jobs that satisfy various filters.</p>', 'ListProjects' => '<p>Gets a list of the projects in an Amazon Web Services account.</p>', 'ListStudioLifecycleConfigs' => '<p>Lists the Studio Lifecycle Configurations in your Amazon Web Services Account.</p>', 'ListSubscribedWorkteams' => '<p>Gets a list of the work teams that you are subscribed to in the Amazon Web Services Marketplace. The list may be empty if no work team satisfies the filter specified in the <code>NameContains</code> parameter.</p>', 'ListTags' => '<p>Returns the tags for the specified Amazon SageMaker resource.</p>', 'ListTrainingJobs' => '<p>Lists training jobs.</p> <note> <p>When <code>StatusEquals</code> and <code>MaxResults</code> are set at the same time, the <code>MaxResults</code> number of training jobs are first retrieved ignoring the <code>StatusEquals</code> parameter and then they are filtered by the <code>StatusEquals</code> parameter, which is returned as a response.</p> <p>For example, if <code>ListTrainingJobs</code> is invoked with the following parameters:</p> <p> <code>{ ... MaxResults: 100, StatusEquals: InProgress ... }</code> </p> <p>First, 100 trainings jobs with any status, including those other than <code>InProgress</code>, are selected (sorted according to the creation time, from the most current to the oldest). Next, those with a status of <code>InProgress</code> are returned.</p> <p>You can quickly test the API using the following Amazon Web Services CLI code.</p> <p> <code>aws sagemaker list-training-jobs --max-results 100 --status-equals InProgress</code> </p> </note>', 'ListTrainingJobsForHyperParameterTuningJob' => '<p>Gets a list of <a>TrainingJobSummary</a> objects that describe the training jobs that a hyperparameter tuning job launched.</p>', 'ListTransformJobs' => '<p>Lists transform jobs.</p>', 'ListTrialComponents' => '<p>Lists the trial components in your account. You can sort the list by trial component name or creation time. You can filter the list to show only components that were created in a specific time range. You can also filter on one of the following:</p> <ul> <li> <p> <code>ExperimentName</code> </p> </li> <li> <p> <code>SourceArn</code> </p> </li> <li> <p> <code>TrialName</code> </p> </li> </ul>', 'ListTrials' => '<p>Lists the trials in your account. Specify an experiment name to limit the list to the trials that are part of that experiment. Specify a trial component name to limit the list to the trials that associated with that trial component. The list can be filtered to show only trials that were created in a specific time range. The list can be sorted by trial name or creation time.</p>', 'ListUserProfiles' => '<p>Lists user profiles.</p>', 'ListWorkforces' => '<p>Use this operation to list all private and vendor workforces in an Amazon Web Services Region. Note that you can only have one private workforce per Amazon Web Services Region.</p>', 'ListWorkteams' => '<p>Gets a list of private work teams that you have defined in a region. The list may be empty if no work team satisfies the filter specified in the <code>NameContains</code> parameter.</p>', 'PutModelPackageGroupPolicy' => '<p>Adds a resouce policy to control access to a model group. For information about resoure policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_identity-vs-resource.html">Identity-based policies and resource-based policies</a> in the <i>Amazon Web Services Identity and Access Management User Guide.</i>.</p>', 'QueryLineage' => '<p>Use this action to inspect your lineage and discover relationships between entities. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/querying-lineage-entities.html"> Querying Lineage Entities</a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', 'RegisterDevices' => '<p>Register devices.</p>', 'RenderUiTemplate' => '<p>Renders the UI template so that you can preview the worker\'s experience. </p>', 'RetryPipelineExecution' => '<p>Retry the execution of the pipeline.</p>', 'Search' => '<p>Finds Amazon SageMaker resources that match a search query. Matching resources are returned as a list of <code>SearchRecord</code> objects in the response. You can sort the search results by any resource property in a ascending or descending order.</p> <p>You can query against the following value types: numeric, text, Boolean, and timestamp.</p>', 'SendPipelineExecutionStepFailure' => '<p>Notifies the pipeline that the execution of a callback step failed, along with a message describing why. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).</p>', 'SendPipelineExecutionStepSuccess' => '<p>Notifies the pipeline that the execution of a callback step succeeded and provides a list of the step\'s output parameters. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).</p>', 'StartMonitoringSchedule' => '<p>Starts a previously stopped monitoring schedule.</p> <note> <p>By default, when you successfully create a new schedule, the status of a monitoring schedule is <code>scheduled</code>.</p> </note>', 'StartNotebookInstance' => '<p>Launches an ML compute instance with the latest version of the libraries and attaches your ML storage volume. After configuring the notebook instance, Amazon SageMaker sets the notebook instance status to <code>InService</code>. A notebook instance\'s status must be <code>InService</code> before you can connect to your Jupyter notebook. </p>', 'StartPipelineExecution' => '<p>Starts a pipeline execution.</p>', 'StopAutoMLJob' => '<p>A method for forcing the termination of a running job.</p>', 'StopCompilationJob' => '<p>Stops a model compilation job.</p> <p> To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal. This gracefully shuts the job down. If the job hasn\'t stopped, it sends the SIGKILL signal.</p> <p>When it receives a <code>StopCompilationJob</code> request, Amazon SageMaker changes the <a>CompilationJobSummary$CompilationJobStatus</a> of the job to <code>Stopping</code>. After Amazon SageMaker stops the job, it sets the <a>CompilationJobSummary$CompilationJobStatus</a> to <code>Stopped</code>. </p>', 'StopEdgePackagingJob' => '<p>Request to stop an edge packaging job.</p>', 'StopHyperParameterTuningJob' => '<p>Stops a running hyperparameter tuning job and all running training jobs that the tuning job launched.</p> <p>All model artifacts output from the training jobs are stored in Amazon Simple Storage Service (Amazon S3). All data that the training jobs write to Amazon CloudWatch Logs are still available in CloudWatch. After the tuning job moves to the <code>Stopped</code> state, it releases all reserved resources for the tuning job.</p>', 'StopInferenceRecommendationsJob' => '<p>Stops an Inference Recommender job.</p>', 'StopLabelingJob' => '<p>Stops a running labeling job. A job that is stopped cannot be restarted. Any results obtained before the job is stopped are placed in the Amazon S3 output bucket.</p>', 'StopMonitoringSchedule' => '<p>Stops a previously started monitoring schedule.</p>', 'StopNotebookInstance' => '<p>Terminates the ML compute instance. Before terminating the instance, Amazon SageMaker disconnects the ML storage volume from it. Amazon SageMaker preserves the ML storage volume. Amazon SageMaker stops charging you for the ML compute instance when you call <code>StopNotebookInstance</code>.</p> <p>To access data on the ML storage volume for a notebook instance that has been terminated, call the <code>StartNotebookInstance</code> API. <code>StartNotebookInstance</code> launches another ML compute instance, configures it, and attaches the preserved ML storage volume so you can continue your work. </p>', 'StopPipelineExecution' => '<p>Stops a pipeline execution.</p> <p> <b>Callback Step</b> </p> <p>A pipeline execution won\'t stop while a callback step is running. When you call <code>StopPipelineExecution</code> on a pipeline execution with a running callback step, SageMaker Pipelines sends an additional Amazon SQS message to the specified SQS queue. The body of the SQS message contains a "Status" field which is set to "Stopping".</p> <p>You should add logic to your Amazon SQS message consumer to take any needed action (for example, resource cleanup) upon receipt of the message followed by a call to <code>SendPipelineExecutionStepSuccess</code> or <code>SendPipelineExecutionStepFailure</code>.</p> <p>Only when SageMaker Pipelines receives one of these calls will it stop the pipeline execution.</p> <p> <b>Lambda Step</b> </p> <p>A pipeline execution can\'t be stopped while a lambda step is running because the Lambda function invoked by the lambda step can\'t be stopped. If you attempt to stop the execution while the Lambda function is running, the pipeline waits for the Lambda function to finish or until the timeout is hit, whichever occurs first, and then stops. If the Lambda function finishes, the pipeline execution status is <code>Stopped</code>. If the timeout is hit the pipeline execution status is <code>Failed</code>.</p>', 'StopProcessingJob' => '<p>Stops a processing job.</p>', 'StopTrainingJob' => '<p>Stops a training job. To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms might use this 120-second window to save the model artifacts, so the results of the training is not lost. </p> <p>When it receives a <code>StopTrainingJob</code> request, Amazon SageMaker changes the status of the job to <code>Stopping</code>. After Amazon SageMaker stops the job, it sets the status to <code>Stopped</code>.</p>', 'StopTransformJob' => '<p>Stops a batch transform job.</p> <p>When Amazon SageMaker receives a <code>StopTransformJob</code> request, the status of the job changes to <code>Stopping</code>. After Amazon SageMaker stops the job, the status is set to <code>Stopped</code>. When you stop a batch transform job before it is completed, Amazon SageMaker doesn\'t store the job\'s output in Amazon S3.</p>', 'UpdateAction' => '<p>Updates an action.</p>', 'UpdateAppImageConfig' => '<p>Updates the properties of an AppImageConfig.</p>', 'UpdateArtifact' => '<p>Updates an artifact.</p>', 'UpdateCodeRepository' => '<p>Updates the specified Git repository with the specified values.</p>', 'UpdateContext' => '<p>Updates a context.</p>', 'UpdateDeviceFleet' => '<p>Updates a fleet of devices.</p>', 'UpdateDevices' => '<p>Updates one or more devices in a fleet.</p>', 'UpdateDomain' => '<p>Updates the default settings for new user profiles in the domain.</p>', 'UpdateEndpoint' => '<p>Deploys the new <code>EndpointConfig</code> specified in the request, switches to using newly created endpoint, and then deletes resources provisioned for the endpoint using the previous <code>EndpointConfig</code> (there is no availability loss). </p> <p>When Amazon SageMaker receives the request, it sets the endpoint status to <code>Updating</code>. After updating the endpoint, it sets the status to <code>InService</code>. To check the status of an endpoint, use the <a>DescribeEndpoint</a> API. </p> <note> <p>You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To update an endpoint, you must create a new <code>EndpointConfig</code>.</p> <p>If you delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring charges.</p> </note>', 'UpdateEndpointWeightsAndCapacities' => '<p>Updates variant weight of one or more variants associated with an existing endpoint, or capacity of one variant associated with an existing endpoint. When it receives the request, Amazon SageMaker sets the endpoint status to <code>Updating</code>. After updating the endpoint, it sets the status to <code>InService</code>. To check the status of an endpoint, use the <a>DescribeEndpoint</a> API. </p>', 'UpdateExperiment' => '<p>Adds, updates, or removes the description of an experiment. Updates the display name of an experiment.</p>', 'UpdateImage' => '<p>Updates the properties of a SageMaker image. To change the image\'s tags, use the <a>AddTags</a> and <a>DeleteTags</a> APIs.</p>', 'UpdateModelPackage' => '<p>Updates a versioned model.</p>', 'UpdateMonitoringSchedule' => '<p>Updates a previously created schedule.</p>', 'UpdateNotebookInstance' => '<p>Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.</p>', 'UpdateNotebookInstanceLifecycleConfig' => '<p>Updates a notebook instance lifecycle configuration created with the <a>CreateNotebookInstanceLifecycleConfig</a> API.</p>', 'UpdatePipeline' => '<p>Updates a pipeline.</p>', 'UpdatePipelineExecution' => '<p>Updates a pipeline execution.</p>', 'UpdateProject' => '<p>Updates a machine learning (ML) project that is created from a template that sets up an ML pipeline from training to deploying an approved model.</p> <note> <p>You must not update a project that is in use. If you update the <code>ServiceCatalogProvisioningUpdateDetails</code> of a project that is active or being created, or updated, you may lose resources already created by the project.</p> </note>', 'UpdateTrainingJob' => '<p>Update a model training job to request a new Debugger profiling configuration.</p>', 'UpdateTrial' => '<p>Updates the display name of a trial.</p>', 'UpdateTrialComponent' => '<p>Updates one or more properties of a trial component.</p>', 'UpdateUserProfile' => '<p>Updates a user profile.</p>', 'UpdateWorkforce' => '<p>Use this operation to update your workforce. You can use this operation to require that workers use specific IP addresses to work on tasks and to update your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.</p> <p> Use <code>SourceIpConfig</code> to restrict worker access to tasks to a specific range of IP addresses. You specify allowed IP addresses by creating a list of up to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>. By default, a workforce isn\'t restricted to specific IP addresses. If you specify a range of IP addresses, workers who attempt to access tasks using any IP address outside the specified range are denied and get a <code>Not Found</code> error message on the worker portal.</p> <p>Use <code>OidcConfig</code> to update the configuration of a workforce created using your own OIDC IdP. </p> <important> <p>You can only update your OIDC IdP configuration when there are no work teams associated with your workforce. You can delete work teams using the operation.</p> </important> <p>After restricting access to a range of IP addresses or updating your OIDC IdP configuration with this operation, you can view details about your update workforce using the operation.</p> <important> <p>This operation only applies to private workforces.</p> </important>', 'UpdateWorkteam' => '<p>Updates an existing work team with new member definitions or description.</p>', ], 'shapes' => [ 'Accept' => [ 'base' => NULL, 'refs' => [ 'TransformOutput$Accept' => '<p>The MIME type used to specify the output data. Amazon SageMaker uses the MIME type with each http call to transfer data from the transform job.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'LabelingJobForWorkteamSummary$WorkRequesterAccountId' => '<p>The Amazon Web Services account ID of the account used to start the labeling job.</p>', ], ], 'ActionArn' => [ 'base' => NULL, 'refs' => [ 'ActionSummary$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'CreateActionResponse$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'DeleteActionResponse$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'DescribeActionResponse$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'UpdateActionResponse$ActionArn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', ], ], 'ActionSource' => [ 'base' => '<p>A structure describing the source of an action.</p>', 'refs' => [ 'ActionSummary$Source' => '<p>The source of the action.</p>', 'CreateActionRequest$Source' => '<p>The source type, ID, and URI.</p>', 'DescribeActionResponse$Source' => '<p>The source of the action.</p>', ], ], 'ActionStatus' => [ 'base' => NULL, 'refs' => [ 'ActionSummary$Status' => '<p>The status of the action.</p>', 'CreateActionRequest$Status' => '<p>The status of the action.</p>', 'DescribeActionResponse$Status' => '<p>The status of the action.</p>', 'UpdateActionRequest$Status' => '<p>The new status for the action.</p>', ], ], 'ActionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListActionsResponse$ActionSummaries' => '<p>A list of actions and their properties.</p>', ], ], 'ActionSummary' => [ 'base' => '<p>Lists the properties of an <i>action</i>. An action represents an action or activity. Some examples are a workflow step and a model deployment. Generally, an action involves at least one input artifact or output artifact.</p>', 'refs' => [ 'ActionSummaries$member' => NULL, ], ], 'AddAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'AddTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'AdditionalCodeRepositoryNamesOrUrls' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'DescribeNotebookInstanceOutput$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'NotebookInstanceSummary$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories associated with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'UpdateNotebookInstanceInput$AdditionalCodeRepositories' => '<p>An array of up to three Git repositories to associate with the notebook instance. These can be either the names of Git repositories stored as resources in your account, or the URL of Git repositories in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default repository of your notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', ], ], 'AdditionalInferenceSpecificationDefinition' => [ 'base' => '<p>A structure of additional Inference Specification. Additional Inference Specification specifies details about inference jobs that can be run with models based on this model package</p>', 'refs' => [ 'AdditionalInferenceSpecifications$member' => NULL, ], ], 'AdditionalInferenceSpecifications' => [ 'base' => NULL, 'refs' => [ 'CreateModelPackageInput$AdditionalInferenceSpecifications' => '<p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts. </p>', 'DescribeModelPackageOutput$AdditionalInferenceSpecifications' => '<p>An array of additional Inference Specification objects. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.</p>', 'ModelPackage$AdditionalInferenceSpecifications' => '<p>An array of additional Inference Specification objects.</p>', 'UpdateModelPackageInput$AdditionalInferenceSpecificationsToAdd' => '<p>An array of additional Inference Specification objects to be added to the existing array additional Inference Specification. Total number of additional Inference Specifications can not exceed 15. Each additional Inference Specification specifies artifacts based on this model package that can be used on inference endpoints. Generally used with SageMaker Neo to store the compiled artifacts.</p>', ], ], 'AgentVersion' => [ 'base' => '<p>Edge Manager agent version.</p>', 'refs' => [ 'AgentVersions$member' => NULL, ], ], 'AgentVersions' => [ 'base' => NULL, 'refs' => [ 'GetDeviceFleetReportResponse$AgentVersions' => '<p>The versions of Edge Manager agent deployed on the fleet.</p>', ], ], 'Alarm' => [ 'base' => '<p>An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.</p>', 'refs' => [ 'AlarmList$member' => NULL, ], ], 'AlarmList' => [ 'base' => NULL, 'refs' => [ 'AutoRollbackConfig$Alarms' => '<p>List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment.</p>', ], ], 'AlarmName' => [ 'base' => NULL, 'refs' => [ 'Alarm$AlarmName' => '<p>The name of a CloudWatch alarm in your account.</p>', ], ], 'AlgorithmArn' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm.</p>', 'CreateAlgorithmOutput$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the new algorithm.</p>', 'DescribeAlgorithmOutput$AlgorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm.</p>', ], ], 'AlgorithmImage' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$TrainingImage' => '<p>The registry path of the Docker image that contains the training algorithm. For information about docker registry paths for built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Algorithms Provided by Amazon SageMaker: Common Parameters</a>. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>', 'DebugRuleConfiguration$RuleEvaluatorImage' => '<p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>', 'HyperParameterAlgorithmSpecification$TrainingImage' => '<p> The registry path of the Docker image that contains the training algorithm. For information about Docker registry paths for built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Algorithms Provided by Amazon SageMaker: Common Parameters</a>. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>', 'ProfilerRuleConfiguration$RuleEvaluatorImage' => '<p>The Amazon Elastic Container (ECR) Image for the managed rule evaluation.</p>', ], ], 'AlgorithmSortBy' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsInput$SortBy' => '<p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>', ], ], 'AlgorithmSpecification' => [ 'base' => '<p>Specifies the training algorithm to use in a <a>CreateTrainingJob</a> request.</p> <p>For more information about algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about using your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>', 'refs' => [ 'CreateTrainingJobRequest$AlgorithmSpecification' => '<p>The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata, including the input mode. For more information about algorithms provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about providing your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>. </p>', 'DescribeTrainingJobResponse$AlgorithmSpecification' => '<p>Information about the algorithm used for training, and algorithm metadata. </p>', 'TrainingJob$AlgorithmSpecification' => '<p>Information about the algorithm used for training, and algorithm metadata.</p>', ], ], 'AlgorithmStatus' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$AlgorithmStatus' => '<p>The overall status of the algorithm.</p>', 'DescribeAlgorithmOutput$AlgorithmStatus' => '<p>The current status of the algorithm.</p>', ], ], 'AlgorithmStatusDetails' => [ 'base' => '<p>Specifies the validation and image scan statuses of the algorithm.</p>', 'refs' => [ 'DescribeAlgorithmOutput$AlgorithmStatusDetails' => '<p>Details about the current status of the algorithm.</p>', ], ], 'AlgorithmStatusItem' => [ 'base' => '<p>Represents the overall status of an algorithm.</p>', 'refs' => [ 'AlgorithmStatusItemList$member' => NULL, ], ], 'AlgorithmStatusItemList' => [ 'base' => NULL, 'refs' => [ 'AlgorithmStatusDetails$ValidationStatuses' => '<p>The status of algorithm validation.</p>', 'AlgorithmStatusDetails$ImageScanStatuses' => '<p>The status of the scan of the algorithm\'s Docker image container.</p>', ], ], 'AlgorithmSummary' => [ 'base' => '<p>Provides summary information about an algorithm.</p>', 'refs' => [ 'AlgorithmSummaryList$member' => NULL, ], ], 'AlgorithmSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsOutput$AlgorithmSummaryList' => '<p>&gt;An array of <code>AlgorithmSummary</code> objects, each of which lists an algorithm.</p>', ], ], 'AlgorithmValidationProfile' => [ 'base' => '<p>Defines a training job and a batch transform job that Amazon SageMaker runs to validate your algorithm.</p> <p>The data provided in the validation profile is made available to your buyers on Amazon Web Services Marketplace.</p>', 'refs' => [ 'AlgorithmValidationProfiles$member' => NULL, ], ], 'AlgorithmValidationProfiles' => [ 'base' => NULL, 'refs' => [ 'AlgorithmValidationSpecification$ValidationProfiles' => '<p>An array of <code>AlgorithmValidationProfile</code> objects, each of which specifies a training job and batch transform job that Amazon SageMaker runs to validate your algorithm.</p>', ], ], 'AlgorithmValidationSpecification' => [ 'base' => '<p>Specifies configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.</p>', 'refs' => [ 'CreateAlgorithmInput$ValidationSpecification' => '<p>Specifies configurations for one or more training jobs and that Amazon SageMaker runs to test the algorithm\'s training code and, optionally, one or more batch transform jobs that Amazon SageMaker runs to test the algorithm\'s inference code.</p>', 'DescribeAlgorithmOutput$ValidationSpecification' => '<p>Details about configurations for one or more training jobs that Amazon SageMaker runs to test the algorithm.</p>', ], ], 'AnnotationConsolidationConfig' => [ 'base' => '<p>Configures how labels are consolidated across human workers and processes output data. </p>', 'refs' => [ 'HumanTaskConfig$AnnotationConsolidationConfig' => '<p>Configures how labels are consolidated across human workers.</p>', ], ], 'AppArn' => [ 'base' => NULL, 'refs' => [ 'CreateAppResponse$AppArn' => '<p>The Amazon Resource Name (ARN) of the app.</p>', 'DescribeAppResponse$AppArn' => '<p>The Amazon Resource Name (ARN) of the app.</p>', ], ], 'AppDetails' => [ 'base' => '<p>Details about an Amazon SageMaker app.</p>', 'refs' => [ 'AppList$member' => NULL, ], ], 'AppImageConfigArn' => [ 'base' => NULL, 'refs' => [ 'AppImageConfigDetails$AppImageConfigArn' => '<p>The Amazon Resource Name (ARN) of the AppImageConfig.</p>', 'CreateAppImageConfigResponse$AppImageConfigArn' => '<p>The Amazon Resource Name (ARN) of the AppImageConfig.</p>', 'DescribeAppImageConfigResponse$AppImageConfigArn' => '<p>The Amazon Resource Name (ARN) of the AppImageConfig.</p>', 'UpdateAppImageConfigResponse$AppImageConfigArn' => '<p>The Amazon Resource Name (ARN) for the AppImageConfig.</p>', ], ], 'AppImageConfigDetails' => [ 'base' => '<p>The configuration for running a SageMaker image as a KernelGateway app.</p>', 'refs' => [ 'AppImageConfigList$member' => NULL, ], ], 'AppImageConfigList' => [ 'base' => NULL, 'refs' => [ 'ListAppImageConfigsResponse$AppImageConfigs' => '<p>A list of AppImageConfigs and their properties.</p>', ], ], 'AppImageConfigName' => [ 'base' => NULL, 'refs' => [ 'AppImageConfigDetails$AppImageConfigName' => '<p>The name of the AppImageConfig. Must be unique to your account.</p>', 'CreateAppImageConfigRequest$AppImageConfigName' => '<p>The name of the AppImageConfig. Must be unique to your account.</p>', 'CustomImage$AppImageConfigName' => '<p>The name of the AppImageConfig.</p>', 'DeleteAppImageConfigRequest$AppImageConfigName' => '<p>The name of the AppImageConfig to delete.</p>', 'DescribeAppImageConfigRequest$AppImageConfigName' => '<p>The name of the AppImageConfig to describe.</p>', 'DescribeAppImageConfigResponse$AppImageConfigName' => '<p>The name of the AppImageConfig.</p>', 'ListAppImageConfigsRequest$NameContains' => '<p>A filter that returns only AppImageConfigs whose name contains the specified string.</p>', 'UpdateAppImageConfigRequest$AppImageConfigName' => '<p>The name of the AppImageConfig to update.</p>', ], ], 'AppImageConfigSortKey' => [ 'base' => NULL, 'refs' => [ 'ListAppImageConfigsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'AppInstanceType' => [ 'base' => NULL, 'refs' => [ 'ResourceSpec$InstanceType' => '<p>The instance type that the image version runs on.</p>', ], ], 'AppList' => [ 'base' => NULL, 'refs' => [ 'ListAppsResponse$Apps' => '<p>The list of apps.</p>', ], ], 'AppManaged' => [ 'base' => NULL, 'refs' => [ 'ProcessingInput$AppManaged' => '<p>When <code>True</code>, input operations such as data download are managed natively by the processing job application. When <code>False</code> (default), input operations are managed by Amazon SageMaker.</p>', 'ProcessingOutput$AppManaged' => '<p>When <code>True</code>, output operations such as data upload are managed natively by the processing job application. When <code>False</code> (default), output operations are managed by Amazon SageMaker.</p>', ], ], 'AppName' => [ 'base' => NULL, 'refs' => [ 'AppDetails$AppName' => '<p>The name of the app.</p>', 'CreateAppRequest$AppName' => '<p>The name of the app.</p>', 'DeleteAppRequest$AppName' => '<p>The name of the app.</p>', 'DescribeAppRequest$AppName' => '<p>The name of the app.</p>', 'DescribeAppResponse$AppName' => '<p>The name of the app.</p>', ], ], 'AppNetworkAccessType' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$AppNetworkAccessType' => '<p>Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p> <ul> <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access</p> </li> <li> <p> <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</p> </li> </ul>', 'DescribeDomainResponse$AppNetworkAccessType' => '<p>Specifies the VPC used for non-EFS traffic. The default value is <code>PublicInternetOnly</code>.</p> <ul> <li> <p> <code>PublicInternetOnly</code> - Non-EFS traffic is through a VPC managed by Amazon SageMaker, which allows direct internet access</p> </li> <li> <p> <code>VpcOnly</code> - All Studio traffic is through the specified VPC and subnets</p> </li> </ul>', ], ], 'AppSecurityGroupManagement' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$AppSecurityGroupManagement' => '<p>The entity that creates and manages the required security groups for inter-app communication in <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.</p>', 'DescribeDomainResponse$AppSecurityGroupManagement' => '<p>The entity that creates and manages the required security groups for inter-app communication in <code>VPCOnly</code> mode. Required when <code>CreateDomain.AppNetworkAccessType</code> is <code>VPCOnly</code> and <code>DomainSettings.RStudioServerProDomainSettings.DomainExecutionRoleArn</code> is provided.</p>', ], ], 'AppSortKey' => [ 'base' => NULL, 'refs' => [ 'ListAppsRequest$SortBy' => '<p>The parameter by which to sort the results. The default is CreationTime.</p>', ], ], 'AppSpecification' => [ 'base' => '<p>Configuration to run a processing job in a specified container image.</p>', 'refs' => [ 'CreateProcessingJobRequest$AppSpecification' => '<p>Configures the processing job to run a specified Docker container image.</p>', 'DescribeProcessingJobResponse$AppSpecification' => '<p>Configures the processing job to run a specified container image.</p>', 'ProcessingJob$AppSpecification' => NULL, ], ], 'AppStatus' => [ 'base' => NULL, 'refs' => [ 'AppDetails$Status' => '<p>The status.</p>', 'DescribeAppResponse$Status' => '<p>The status.</p>', ], ], 'AppType' => [ 'base' => NULL, 'refs' => [ 'AppDetails$AppType' => '<p>The type of app.</p>', 'CreateAppRequest$AppType' => '<p>The type of app. Supported apps are <code>JupyterServer</code> and <code>KernelGateway</code>. <code>TensorBoard</code> is not supported.</p>', 'DeleteAppRequest$AppType' => '<p>The type of app.</p>', 'DescribeAppRequest$AppType' => '<p>The type of app.</p>', 'DescribeAppResponse$AppType' => '<p>The type of app.</p>', ], ], 'ApprovalDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeModelPackageOutput$ApprovalDescription' => '<p>A description provided for the model approval.</p>', 'ModelPackage$ApprovalDescription' => '<p>A description provided when the model approval is set.</p>', 'UpdateModelPackageInput$ApprovalDescription' => '<p>A description for the approval status of the model.</p>', ], ], 'ArnOrName' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$AlgorithmName' => '<p>The name of the algorithm resource to use for the training job. This must be an algorithm resource that you created or subscribe to on Amazon Web Services Marketplace. If you specify a value for this parameter, you can\'t specify a value for <code>TrainingImage</code>.</p>', 'CreateModelPackageInput$ModelPackageGroupName' => '<p>The name or Amazon Resource Name (ARN) of the model package group that this model version belongs to.</p> <p>This parameter is required for versioned models, and does not apply to unversioned models.</p>', 'DeleteModelPackageGroupInput$ModelPackageGroupName' => '<p>The name of the model group to delete.</p>', 'DescribeAlgorithmInput$AlgorithmName' => '<p>The name of the algorithm to describe.</p>', 'DescribeModelPackageGroupInput$ModelPackageGroupName' => '<p>The name of the model group to describe.</p>', 'HyperParameterAlgorithmSpecification$AlgorithmName' => '<p>The name of the resource algorithm to use for the hyperparameter tuning job. If you specify a value for this parameter, do not specify a value for <code>TrainingImage</code>.</p>', 'ListModelPackagesInput$ModelPackageGroupName' => '<p>A filter that returns only model versions that belong to the specified model group.</p>', 'SourceAlgorithm$AlgorithmName' => '<p>The name of an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you are subscribed to.</p>', ], ], 'ArtifactArn' => [ 'base' => NULL, 'refs' => [ 'ArtifactSummary$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', 'CreateArtifactResponse$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', 'DeleteArtifactRequest$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact to delete.</p>', 'DeleteArtifactResponse$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', 'DescribeArtifactRequest$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact to describe.</p>', 'DescribeArtifactResponse$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', 'UpdateArtifactRequest$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact to update.</p>', 'UpdateArtifactResponse$ArtifactArn' => '<p>The Amazon Resource Name (ARN) of the artifact.</p>', ], ], 'ArtifactDigest' => [ 'base' => NULL, 'refs' => [ 'ModelDigests$ArtifactDigest' => '<p>Provides a hash value that uniquely identifies the stored model artifacts.</p>', ], ], 'ArtifactSource' => [ 'base' => '<p>A structure describing the source of an artifact.</p>', 'refs' => [ 'ArtifactSummary$Source' => '<p>The source of the artifact.</p>', 'CreateArtifactRequest$Source' => '<p>The ID, ID type, and URI of the source.</p>', 'DeleteArtifactRequest$Source' => '<p>The URI of the source.</p>', 'DescribeArtifactResponse$Source' => '<p>The source of the artifact.</p>', ], ], 'ArtifactSourceIdType' => [ 'base' => NULL, 'refs' => [ 'ArtifactSourceType$SourceIdType' => '<p>The type of ID.</p>', ], ], 'ArtifactSourceType' => [ 'base' => '<p>The ID and ID type of an artifact source.</p>', 'refs' => [ 'ArtifactSourceTypes$member' => NULL, ], ], 'ArtifactSourceTypes' => [ 'base' => NULL, 'refs' => [ 'ArtifactSource$SourceTypes' => '<p>A list of source types.</p>', ], ], 'ArtifactSummaries' => [ 'base' => NULL, 'refs' => [ 'ListArtifactsResponse$ArtifactSummaries' => '<p>A list of artifacts and their properties.</p>', ], ], 'ArtifactSummary' => [ 'base' => '<p>Lists a summary of the properties of an artifact. An artifact represents a URI addressable object or data. Some examples are a dataset and a model.</p>', 'refs' => [ 'ArtifactSummaries$member' => NULL, ], ], 'AssemblyType' => [ 'base' => NULL, 'refs' => [ 'TransformOutput$AssembleWith' => '<p>Defines how to assemble the results of the transform job as a single S3 object. Choose a format that is most convenient to you. To concatenate the results in binary format, specify <code>None</code>. To add a newline character at the end of every transformed record, specify <code>Line</code>.</p>', ], ], 'AssociateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociationEdgeType' => [ 'base' => NULL, 'refs' => [ 'AddAssociationRequest$AssociationType' => '<p>The type of association. The following are suggested uses for each type. Amazon SageMaker places no restrictions on their use.</p> <ul> <li> <p>ContributedTo - The source contributed to the destination or had a part in enabling the destination. For example, the training data contributed to the training job.</p> </li> <li> <p>AssociatedWith - The source is connected to the destination. For example, an approval workflow is associated with a model deployment.</p> </li> <li> <p>DerivedFrom - The destination is a modification of the source. For example, a digest output of a channel input for a processing job is derived from the original inputs.</p> </li> <li> <p>Produced - The source generated the destination. For example, a training job produced a model artifact.</p> </li> </ul>', 'AssociationSummary$AssociationType' => '<p>The type of the association.</p>', 'Edge$AssociationType' => '<p>The type of the Association(Edge) between the source and destination. For example <code>ContributedTo</code>, <code>Produced</code>, or <code>DerivedFrom</code>.</p>', 'ListAssociationsRequest$AssociationType' => '<p>A filter that returns only associations of the specified type.</p>', ], ], 'AssociationEntityArn' => [ 'base' => NULL, 'refs' => [ 'AddAssociationRequest$SourceArn' => '<p>The ARN of the source.</p>', 'AddAssociationRequest$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'AddAssociationResponse$SourceArn' => '<p>The ARN of the source.</p>', 'AddAssociationResponse$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'AssociationSummary$SourceArn' => '<p>The ARN of the source.</p>', 'AssociationSummary$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'DeleteAssociationRequest$SourceArn' => '<p>The ARN of the source.</p>', 'DeleteAssociationRequest$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'DeleteAssociationResponse$SourceArn' => '<p>The ARN of the source.</p>', 'DeleteAssociationResponse$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination.</p>', 'Edge$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source lineage entity of the directed edge.</p>', 'Edge$DestinationArn' => '<p>The Amazon Resource Name (ARN) of the destination lineage entity of the directed edge.</p>', 'ListAssociationsRequest$SourceArn' => '<p>A filter that returns only associations with the specified source ARN.</p>', 'ListAssociationsRequest$DestinationArn' => '<p>A filter that returns only associations with the specified destination Amazon Resource Name (ARN).</p>', 'QueryLineageStartArns$member' => NULL, 'Vertex$Arn' => '<p>The Amazon Resource Name (ARN) of the lineage entity resource.</p>', ], ], 'AssociationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsResponse$AssociationSummaries' => '<p>A list of associations and their properties.</p>', ], ], 'AssociationSummary' => [ 'base' => '<p>Lists a summary of the properties of an association. An association is an entity that links other lineage or experiment entities. An example would be an association between a training job and a model.</p>', 'refs' => [ 'AssociationSummaries$member' => NULL, ], ], 'AsyncInferenceClientConfig' => [ 'base' => '<p>Configures the behavior of the client used by Amazon SageMaker to interact with the model container during asynchronous inference.</p>', 'refs' => [ 'AsyncInferenceConfig$ClientConfig' => '<p>Configures the behavior of the client used by Amazon SageMaker to interact with the model container during asynchronous inference.</p>', ], ], 'AsyncInferenceConfig' => [ 'base' => '<p>Specifies configuration for how an endpoint performs asynchronous inference.</p>', 'refs' => [ 'CreateEndpointConfigInput$AsyncInferenceConfig' => '<p>Specifies configuration for how an endpoint performs asynchronous inference. This is a required field in order for your Endpoint to be invoked using <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpointAsync.html">InvokeEndpointAsync</a>.</p>', 'DescribeEndpointConfigOutput$AsyncInferenceConfig' => '<p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>', 'DescribeEndpointOutput$AsyncInferenceConfig' => '<p>Returns the description of an endpoint configuration created using the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"> <code>CreateEndpointConfig</code> </a> API.</p>', ], ], 'AsyncInferenceNotificationConfig' => [ 'base' => '<p>Specifies the configuration for notifications of inference results for asynchronous inference.</p>', 'refs' => [ 'AsyncInferenceOutputConfig$NotificationConfig' => '<p>Specifies the configuration for notifications of inference results for asynchronous inference.</p>', ], ], 'AsyncInferenceOutputConfig' => [ 'base' => '<p>Specifies the configuration for asynchronous inference invocation outputs.</p>', 'refs' => [ 'AsyncInferenceConfig$OutputConfig' => '<p>Specifies the configuration for asynchronous inference invocation outputs.</p>', ], ], 'AthenaCatalog' => [ 'base' => '<p>The name of the data catalog used in Athena query execution.</p>', 'refs' => [ 'AthenaDatasetDefinition$Catalog' => NULL, ], ], 'AthenaDatabase' => [ 'base' => '<p>The name of the database used in the Athena query execution.</p>', 'refs' => [ 'AthenaDatasetDefinition$Database' => NULL, ], ], 'AthenaDatasetDefinition' => [ 'base' => '<p>Configuration for Athena Dataset Definition input.</p>', 'refs' => [ 'DatasetDefinition$AthenaDatasetDefinition' => NULL, ], ], 'AthenaQueryString' => [ 'base' => '<p>The SQL query statements, to be executed.</p>', 'refs' => [ 'AthenaDatasetDefinition$QueryString' => NULL, ], ], 'AthenaResultCompressionType' => [ 'base' => '<p>The compression used for Athena query results.</p>', 'refs' => [ 'AthenaDatasetDefinition$OutputCompression' => NULL, ], ], 'AthenaResultFormat' => [ 'base' => '<p>The data storage format for Athena query results.</p>', 'refs' => [ 'AthenaDatasetDefinition$OutputFormat' => NULL, ], ], 'AthenaWorkGroup' => [ 'base' => '<p>The name of the workgroup in which the Athena query is being started.</p>', 'refs' => [ 'AthenaDatasetDefinition$WorkGroup' => NULL, ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'AttributeNames$member' => NULL, ], ], 'AttributeNames' => [ 'base' => NULL, 'refs' => [ 'S3DataSource$AttributeNames' => '<p>A list of one or more attribute names to use that are found in a specified augmented manifest file.</p>', ], ], 'AuthMode' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$AuthMode' => '<p>The mode of authentication that members use to access the domain.</p>', 'DescribeDomainResponse$AuthMode' => '<p>The domain\'s authentication mode.</p>', ], ], 'AutoGenerateEndpointName' => [ 'base' => NULL, 'refs' => [ 'ModelDeployConfig$AutoGenerateEndpointName' => '<p>Set to <code>True</code> to automatically generate an endpoint name for a one-click Autopilot model deployment; set to <code>False</code> otherwise. The default value is <code>False</code>.</p> <note> <p>If you set <code>AutoGenerateEndpointName</code> to <code>True</code>, do not specify the <code>EndpointName</code>; otherwise a 400 error is thrown.</p> </note>', ], ], 'AutoMLCandidate' => [ 'base' => '<p>Information about a candidate produced by an AutoML training job, including its status, steps, and other properties.</p>', 'refs' => [ 'AutoMLCandidates$member' => NULL, 'DescribeAutoMLJobResponse$BestCandidate' => '<p>Returns the job\'s best <code>AutoMLCandidate</code>.</p>', ], ], 'AutoMLCandidateStep' => [ 'base' => '<p>Information about the steps for a candidate and what step it is working on.</p>', 'refs' => [ 'CandidateSteps$member' => NULL, ], ], 'AutoMLCandidates' => [ 'base' => NULL, 'refs' => [ 'ListCandidatesForAutoMLJobResponse$Candidates' => '<p>Summaries about the <code>AutoMLCandidates</code>.</p>', ], ], 'AutoMLChannel' => [ 'base' => '<p>A channel is a named input source that training algorithms can consume. For more information, see .</p>', 'refs' => [ 'AutoMLInputDataConfig$member' => NULL, ], ], 'AutoMLContainerDefinition' => [ 'base' => '<p>A list of container definitions that describe the different containers that make up an AutoML candidate. For more information, see .</p>', 'refs' => [ 'AutoMLContainerDefinitions$member' => NULL, ], ], 'AutoMLContainerDefinitions' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$InferenceContainers' => '<p>Information about the inference container definitions.</p>', ], ], 'AutoMLDataSource' => [ 'base' => '<p>The data source for the Autopilot job.</p>', 'refs' => [ 'AutoMLChannel$DataSource' => '<p>The data source for an AutoML channel.</p>', ], ], 'AutoMLFailureReason' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$FailureReason' => '<p>The failure reason.</p>', 'AutoMLJobSummary$FailureReason' => '<p>The failure reason of an AutoML job.</p>', 'AutoMLPartialFailureReason$PartialFailureMessage' => '<p>The message containing the reason for a partial failure of an AutoML job.</p>', 'DescribeAutoMLJobResponse$FailureReason' => '<p>Returns the failure reason for an AutoML job, when applicable.</p>', ], ], 'AutoMLInputDataConfig' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobRequest$InputDataConfig' => '<p>An array of channel objects that describes the input data and its location. Each channel is a named input source. Similar to <code>InputDataConfig</code> supported by . Format(s) supported: CSV. Minimum of 500 rows.</p>', 'DescribeAutoMLJobResponse$InputDataConfig' => '<p>Returns the input data configuration for the AutoML job..</p>', ], ], 'AutoMLJobArn' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobArn' => '<p>The ARN of the AutoML job.</p>', 'CreateAutoMLJobResponse$AutoMLJobArn' => '<p>The unique ARN assigned to the AutoML job when it is created.</p>', 'DescribeAutoMLJobResponse$AutoMLJobArn' => '<p>Returns the ARN of the AutoML job.</p>', 'DescribeProcessingJobResponse$AutoMLJobArn' => '<p>The ARN of an AutoML job associated with this processing job.</p>', 'DescribeTrainingJobResponse$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of an AutoML job.</p>', 'DescribeTransformJobResponse$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the AutoML transform job.</p>', 'ProcessingJob$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the AutoML job associated with this processing job.</p>', 'TrainingJob$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the job.</p>', 'TransformJob$AutoMLJobArn' => '<p>The Amazon Resource Name (ARN) of the AutoML job that created the transform job.</p>', ], ], 'AutoMLJobArtifacts' => [ 'base' => '<p>The artifacts that are generated during an AutoML job.</p>', 'refs' => [ 'DescribeAutoMLJobResponse$AutoMLJobArtifacts' => '<p>Returns information on the job\'s artifacts found in <code>AutoMLJobArtifacts</code>.</p>', ], ], 'AutoMLJobCompletionCriteria' => [ 'base' => '<p>How long a job is allowed to run, or how many candidates a job is allowed to generate.</p>', 'refs' => [ 'AutoMLJobConfig$CompletionCriteria' => '<p>How long an AutoML job is allowed to run, or how many candidates a job is allowed to generate.</p>', 'ResolvedAttributes$CompletionCriteria' => NULL, ], ], 'AutoMLJobConfig' => [ 'base' => '<p>A collection of settings used for an AutoML job.</p>', 'refs' => [ 'CreateAutoMLJobRequest$AutoMLJobConfig' => '<p>Contains <code>CompletionCriteria</code> and <code>SecurityConfig</code> settings for the AutoML job.</p>', 'DescribeAutoMLJobResponse$AutoMLJobConfig' => '<p>Returns the configuration for the AutoML job.</p>', ], ], 'AutoMLJobName' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobName' => '<p>The name of the AutoML job you are requesting.</p>', 'CreateAutoMLJobRequest$AutoMLJobName' => '<p>Identifies an Autopilot job. The name must be unique to your account and is case-insensitive.</p>', 'DescribeAutoMLJobRequest$AutoMLJobName' => '<p>Requests information about an AutoML job using its unique name.</p>', 'DescribeAutoMLJobResponse$AutoMLJobName' => '<p>Returns the name of the AutoML job.</p>', 'ListCandidatesForAutoMLJobRequest$AutoMLJobName' => '<p>List the candidates created for the job by providing the job\'s name.</p>', 'StopAutoMLJobRequest$AutoMLJobName' => '<p>The name of the object you are requesting.</p>', ], ], 'AutoMLJobObjective' => [ 'base' => '<p>Specifies a metric to minimize or maximize as the objective of a job.</p>', 'refs' => [ 'CreateAutoMLJobRequest$AutoMLJobObjective' => '<p>Defines the objective metric used to measure the predictive quality of an AutoML job. You provide an <a>AutoMLJobObjective$MetricName</a> and Autopilot infers whether to minimize or maximize it.</p>', 'DescribeAutoMLJobResponse$AutoMLJobObjective' => '<p>Returns the job\'s objective.</p>', 'ResolvedAttributes$AutoMLJobObjective' => NULL, ], ], 'AutoMLJobObjectiveType' => [ 'base' => NULL, 'refs' => [ 'FinalAutoMLJobObjectiveMetric$Type' => '<p>The type of metric with the best result.</p>', ], ], 'AutoMLJobSecondaryStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobSecondaryStatus' => '<p>The secondary status of the AutoML job.</p>', 'DescribeAutoMLJobResponse$AutoMLJobSecondaryStatus' => '<p>Returns the secondary status of the AutoML job.</p>', ], ], 'AutoMLJobStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$AutoMLJobStatus' => '<p>The status of the AutoML job.</p>', 'DescribeAutoMLJobResponse$AutoMLJobStatus' => '<p>Returns the status of the AutoML job.</p>', 'ListAutoMLJobsRequest$StatusEquals' => '<p>Request a list of jobs, using a filter for status.</p>', ], ], 'AutoMLJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsResponse$AutoMLJobSummaries' => '<p>Returns a summary list of jobs.</p>', ], ], 'AutoMLJobSummary' => [ 'base' => '<p>Provides a summary about an AutoML job.</p>', 'refs' => [ 'AutoMLJobSummaries$member' => NULL, ], ], 'AutoMLMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$MaxResults' => '<p>Request a list of jobs up to a specified limit.</p>', 'ListCandidatesForAutoMLJobRequest$MaxResults' => '<p>List the job\'s candidates up to a specified limit.</p>', ], ], 'AutoMLMetricEnum' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobObjective$MetricName' => '<p>The name of the objective metric used to measure the predictive quality of a machine learning system. This metric is optimized during training to provide the best estimate for model parameter values from data.</p> <p>Here are the options:</p> <ul> <li> <p> <code>MSE</code>: The mean squared error (MSE) is the average of the squared differences between the predicted and actual values. It is used for regression. MSE values are always positive: the better a model is at predicting the actual values, the smaller the MSE value is. When the data contains outliers, they tend to dominate the MSE, which might cause subpar prediction performance.</p> </li> <li> <p> <code>Accuracy</code>: The ratio of the number of correctly classified items to the total number of (correctly and incorrectly) classified items. It is used for binary and multiclass classification. It measures how close the predicted class values are to the actual values. Accuracy values vary between zero and one: one indicates perfect accuracy and zero indicates perfect inaccuracy.</p> </li> <li> <p> <code>F1</code>: The F1 score is the harmonic mean of the precision and recall. It is used for binary classification into classes traditionally referred to as positive and negative. Predictions are said to be true when they match their actual (correct) class and false when they do not. Precision is the ratio of the true positive predictions to all positive predictions (including the false positives) in a data set and measures the quality of the prediction when it predicts the positive class. Recall (or sensitivity) is the ratio of the true positive predictions to all actual positive instances and measures how completely a model predicts the actual class members in a data set. The standard F1 score weighs precision and recall equally. But which metric is paramount typically depends on specific aspects of a problem. F1 scores vary between zero and one: one indicates the best possible performance and zero the worst.</p> </li> <li> <p> <code>AUC</code>: The area under the curve (AUC) metric is used to compare and evaluate binary classification by algorithms such as logistic regression that return probabilities. A threshold is needed to map the probabilities into classifications. The relevant curve is the receiver operating characteristic curve that plots the true positive rate (TPR) of predictions (or recall) against the false positive rate (FPR) as a function of the threshold value, above which a prediction is considered positive. Increasing the threshold results in fewer false positives but more false negatives. AUC is the area under this receiver operating characteristic curve and so provides an aggregated measure of the model performance across all possible classification thresholds. The AUC score can also be interpreted as the probability that a randomly selected positive data point is more likely to be predicted positive than a randomly selected negative example. AUC scores vary between zero and one: a score of one indicates perfect accuracy and a score of one half indicates that the prediction is not better than a random classifier. Values under one half predict less accurately than a random predictor. But such consistently bad predictors can simply be inverted to obtain better than random predictors.</p> </li> <li> <p> <code>F1macro</code>: The F1macro score applies F1 scoring to multiclass classification. In this context, you have multiple classes to predict. You just calculate the precision and recall for each class as you did for the positive class in binary classification. Then, use these values to calculate the F1 score for each class and average them to obtain the F1macro score. F1macro scores vary between zero and one: one indicates the best possible performance and zero the worst.</p> </li> </ul> <p>If you do not specify a metric explicitly, the default behavior is to automatically use:</p> <ul> <li> <p> <code>MSE</code>: for regression.</p> </li> <li> <p> <code>F1</code>: for binary classification</p> </li> <li> <p> <code>Accuracy</code>: for multiclass classification.</p> </li> </ul>', 'FinalAutoMLJobObjectiveMetric$MetricName' => '<p>The name of the metric with the best result. For a description of the possible objective metrics, see <a>AutoMLJobObjective$MetricName</a>.</p>', 'MetricDatum$MetricName' => '<p>The name of the metric.</p>', ], ], 'AutoMLNameContains' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$NameContains' => '<p>Request a list of jobs, using a search filter for name.</p>', ], ], 'AutoMLOutputDataConfig' => [ 'base' => '<p>The output data configuration.</p>', 'refs' => [ 'CreateAutoMLJobRequest$OutputDataConfig' => '<p>Provides information about encryption and the Amazon S3 output path needed to store artifacts from an AutoML job. Format(s) supported: CSV.</p>', 'DescribeAutoMLJobResponse$OutputDataConfig' => '<p>Returns the job\'s output data config.</p>', ], ], 'AutoMLPartialFailureReason' => [ 'base' => '<p>The reason for a partial failure of an AutoML job.</p>', 'refs' => [ 'AutoMLPartialFailureReasons$member' => NULL, ], ], 'AutoMLPartialFailureReasons' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobSummary$PartialFailureReasons' => '<p>The list of reasons for partial failures within an AutoML job.</p>', 'DescribeAutoMLJobResponse$PartialFailureReasons' => '<p>Returns a list of reasons for partial failures within an AutoML job.</p>', ], ], 'AutoMLS3DataSource' => [ 'base' => '<p>The Amazon S3 data source.</p>', 'refs' => [ 'AutoMLDataSource$S3DataSource' => '<p>The Amazon S3 location of the input data.</p> <note> <p>The input data must be in CSV format and contain at least 500 rows.</p> </note>', ], ], 'AutoMLS3DataType' => [ 'base' => NULL, 'refs' => [ 'AutoMLS3DataSource$S3DataType' => '<p>The data type.</p>', ], ], 'AutoMLSecurityConfig' => [ 'base' => '<p>Security options.</p>', 'refs' => [ 'AutoMLJobConfig$SecurityConfig' => '<p>The security configuration for traffic encryption or Amazon VPC settings.</p>', ], ], 'AutoMLSortBy' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$SortBy' => '<p>The parameter by which to sort the results. The default is <code>Name</code>.</p>', ], ], 'AutoMLSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListAutoMLJobsRequest$SortOrder' => '<p>The sort order for the results. The default is <code>Descending</code>.</p>', 'ListCandidatesForAutoMLJobRequest$SortOrder' => '<p>The sort order for the results. The default is <code>Ascending</code>.</p>', ], ], 'AutoRollbackConfig' => [ 'base' => '<p>Automatic rollback configuration for handling endpoint deployment failures and recovery.</p>', 'refs' => [ 'DeploymentConfig$AutoRollbackConfiguration' => '<p>Automatic rollback configuration for handling endpoint deployment failures and recovery.</p>', ], ], 'AwsManagedHumanLoopRequestSource' => [ 'base' => NULL, 'refs' => [ 'HumanLoopRequestSource$AwsManagedHumanLoopRequestSource' => '<p>Specifies whether Amazon Rekognition or Amazon Textract are used as the integration source. The default field settings and JSON parsing rules are different based on the integration source. Valid values:</p>', ], ], 'BatchDescribeModelPackageError' => [ 'base' => '<p>The error code and error description associated with the resource.</p>', 'refs' => [ 'BatchDescribeModelPackageErrorMap$value' => NULL, ], ], 'BatchDescribeModelPackageErrorMap' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageOutput$BatchDescribeModelPackageErrorMap' => '<p>A map of the resource and BatchDescribeModelPackageError objects reporting the error associated with describing the model package.</p>', ], ], 'BatchDescribeModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDescribeModelPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDescribeModelPackageSummary' => [ 'base' => '<p>Provides summary information about the model package.</p>', 'refs' => [ 'ModelPackageSummaries$value' => NULL, ], ], 'BatchStrategy' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$BatchStrategy' => '<p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p> <p>To enable the batch strategy, you must set the <code>SplitType</code> property to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p> <p>To use only one record when making an HTTP invocation request to a container, set <code>BatchStrategy</code> to <code>SingleRecord</code> and <code>SplitType</code> to <code>Line</code>.</p> <p>To fit as many records in a mini-batch as can fit within the <code>MaxPayloadInMB</code> limit, set <code>BatchStrategy</code> to <code>MultiRecord</code> and <code>SplitType</code> to <code>Line</code>.</p>', 'DescribeTransformJobResponse$BatchStrategy' => '<p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A <i>record</i> <i/> is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record. </p> <p>To enable the batch strategy, you must set <code>SplitType</code> to <code>Line</code>, <code>RecordIO</code>, or <code>TFRecord</code>.</p>', 'TransformJob$BatchStrategy' => '<p>Specifies the number of records to include in a mini-batch for an HTTP inference request. A record is a single unit of input data that inference can be made on. For example, a single line in a CSV file is a record.</p>', 'TransformJobDefinition$BatchStrategy' => '<p>A string that determines the number of records included in a single mini-batch.</p> <p> <code>SingleRecord</code> means only one record is used per mini-batch. <code>MultiRecord</code> means a mini-batch is set to contain as many records that can fit within the <code>MaxPayloadInMB</code> limit.</p>', ], ], 'Bias' => [ 'base' => '<p>Contains bias metrics for a model.</p>', 'refs' => [ 'ModelMetrics$Bias' => '<p>Metrics that measure bais in a model.</p>', ], ], 'BillableTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$BillableTimeInSeconds' => '<p>The billable time in seconds. Billable time refers to the absolute wall-clock time.</p> <p>Multiply <code>BillableTimeInSeconds</code> by the number of instances (<code>InstanceCount</code>) in your training cluster to get the total compute time SageMaker will bill you if you run distributed training. The formula is as follows: <code>BillableTimeInSeconds * InstanceCount</code> .</p> <p>You can calculate the savings from using managed spot training using the formula <code>(1 - BillableTimeInSeconds / TrainingTimeInSeconds) * 100</code>. For example, if <code>BillableTimeInSeconds</code> is 100 and <code>TrainingTimeInSeconds</code> is 500, the savings is 80%.</p>', 'TrainingJob$BillableTimeInSeconds' => '<p>The billable time in seconds.</p>', ], ], 'BlockedReason' => [ 'base' => NULL, 'refs' => [ 'OfflineStoreStatus$BlockedReason' => '<p>The justification for why the OfflineStoreStatus is Blocked (if applicable).</p>', ], ], 'BlueGreenUpdatePolicy' => [ 'base' => '<p>Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.</p>', 'refs' => [ 'DeploymentConfig$BlueGreenUpdatePolicy' => '<p>Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$EnableSageMakerMetricsTimeSeries' => '<p>To generate and save time-series metrics during training, set to <code>true</code>. The default is <code>false</code> and time-series metrics aren\'t generated except in the following cases:</p> <ul> <li> <p>You use one of the Amazon SageMaker built-in algorithms</p> </li> <li> <p>You use one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html">Prebuilt Amazon SageMaker Docker Images</a>:</p> <ul> <li> <p>Tensorflow (version &gt;= 1.15)</p> </li> <li> <p>MXNet (version &gt;= 1.6)</p> </li> <li> <p>PyTorch (version &gt;= 1.3)</p> </li> </ul> </li> <li> <p>You specify at least one <a>MetricDefinition</a> </p> </li> </ul>', 'AutoMLSecurityConfig$EnableInterContainerTrafficEncryption' => '<p>Whether to use traffic encryption between the container layers.</p>', 'ChannelSpecification$IsRequired' => '<p>Indicates whether the channel is required by the algorithm.</p>', 'ClarifyCheckStepMetadata$SkipCheck' => '<p>This flag indicates if the drift check against the previous baseline will be skipped or not. If it is set to <code>False</code>, the previous baseline of the configured check type must be available.</p>', 'ClarifyCheckStepMetadata$RegisterNewBaseline' => '<p>This flag indicates if a newly calculated baseline can be accessed through step properties <code>BaselineUsedForDriftCheckConstraints</code> and <code>BaselineUsedForDriftCheckStatistics</code>. If it is set to <code>False</code>, the previous baseline of the configured check type must also be available. These can be accessed through the <code>BaselineUsedForDriftCheckConstraints</code> property. </p>', 'CreateModelInput$EnableNetworkIsolation' => '<p>Isolates the model container. No inbound or outbound network calls can be made to or from the model container.</p>', 'CreateTrainingJobRequest$EnableNetworkIsolation' => '<p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>', 'CreateTrainingJobRequest$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML Compute Instances in a Distributed Training Job</a>.</p>', 'CreateTrainingJobRequest$EnableManagedSpotTraining' => '<p>To train models using managed spot training, choose <code>True</code>. Managed spot training provides a fully managed and scalable infrastructure for training machine learning models. this option is useful when training jobs can be interrupted and when there is flexibility when the training job is run. </p> <p>The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They can be used to see when managed spot training jobs are running, interrupted, resumed, or completed. </p>', 'DescribeModelOutput$EnableNetworkIsolation' => '<p>If <code>True</code>, no inbound or outbound network calls can be made to or from the model container.</p>', 'DescribeTrainingJobResponse$EnableNetworkIsolation' => '<p>If you want to allow inbound or outbound network calls, except for calls between peers within a training cluster for distributed training, choose <code>True</code>. If you enable network isolation for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>', 'DescribeTrainingJobResponse$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithms in distributed training.</p>', 'DescribeTrainingJobResponse$EnableManagedSpotTraining' => '<p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>', 'HyperParameterSpecification$IsTunable' => '<p>Indicates whether this hyperparameter is tunable in a hyperparameter tuning job.</p>', 'HyperParameterSpecification$IsRequired' => '<p>Indicates whether this hyperparameter is required.</p>', 'HyperParameterTrainingJobDefinition$EnableNetworkIsolation' => '<p>Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers within a training cluster for distributed training. If network isolation is used for training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the specified VPC, but the training container does not have network access.</p>', 'HyperParameterTrainingJobDefinition$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.</p>', 'HyperParameterTrainingJobDefinition$EnableManagedSpotTraining' => '<p>A Boolean indicating whether managed spot training is enabled (<code>True</code>) or not (<code>False</code>).</p>', 'MonitoringNetworkConfig$EnableInterContainerTrafficEncryption' => '<p>Whether to encrypt all communications between the instances used for the monitoring jobs. Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed jobs, but the processing might take longer.</p>', 'MonitoringNetworkConfig$EnableNetworkIsolation' => '<p>Whether to allow inbound and outbound network calls to and from the containers used for the monitoring job.</p>', 'NetworkConfig$EnableInterContainerTrafficEncryption' => '<p>Whether to encrypt all communications between distributed processing jobs. Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.</p>', 'NetworkConfig$EnableNetworkIsolation' => '<p>Whether to allow inbound and outbound network calls to and from the containers used for the processing job.</p>', 'OfflineStoreConfig$DisableGlueTableCreation' => '<p>Set to <code>True</code> to disable the automatic creation of an Amazon Web Services Glue table when configuring an <code>OfflineStore</code>.</p>', 'OnlineStoreConfig$EnableOnlineStore' => '<p>Turn <code>OnlineStore</code> off by specifying <code>False</code> for the <code>EnableOnlineStore</code> flag. Turn <code>OnlineStore</code> on by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag. </p> <p>The default value is <code>False</code>.</p>', 'QualityCheckStepMetadata$SkipCheck' => '<p>This flag indicates if the drift check against the previous baseline will be skipped or not. If it is set to <code>False</code>, the previous baseline of the configured check type must be available.</p>', 'QualityCheckStepMetadata$RegisterNewBaseline' => '<p>This flag indicates if a newly calculated baseline can be accessed through step properties <code>BaselineUsedForDriftCheckConstraints</code> and <code>BaselineUsedForDriftCheckStatistics</code>. If it is set to <code>False</code>, the previous baseline of the configured check type must also be available. These can be accessed through the <code>BaselineUsedForDriftCheckConstraints</code> and <code> BaselineUsedForDriftCheckStatistics</code> properties. </p>', 'QueryLineageRequest$IncludeEdges' => '<p> Setting this value to <code>True</code> will retrieve not only the entities of interest but also the <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking-entities.html">Associations</a> and lineage entities on the path. Set to <code>False</code> to only return lineage entities that match your query.</p>', 'TrainingJob$EnableNetworkIsolation' => '<p>If the <code>TrainingJob</code> was created with network isolation, the value is set to <code>true</code>. If network isolation is enabled, nodes can\'t communicate beyond the VPC they run in.</p>', 'TrainingJob$EnableInterContainerTrafficEncryption' => '<p>To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>. Encryption provides greater security for distributed training, but training might take longer. How long it takes depends on the amount of communication between compute instances, especially if you use a deep learning algorithm in distributed training.</p>', 'TrainingJob$EnableManagedSpotTraining' => '<p>When true, enables managed spot training using Amazon EC2 Spot instances to run training jobs instead of on-demand instances. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot Training</a>.</p>', 'TrainingSpecification$SupportsDistributedTraining' => '<p>Indicates whether the algorithm supports distributed training. If set to false, buyers can\'t request more than one instance during training.</p>', 'UpdateEndpointInput$RetainAllVariantProperties' => '<p>When updating endpoint resources, enables or disables the retention of <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VariantProperty.html">variant properties</a>, such as the instance count or the variant weight. To retain the variant properties of an endpoint when updating it, set <code>RetainAllVariantProperties</code> to <code>true</code>. To use the variant properties specified in a new <code>EndpointConfig</code> call when updating an endpoint, set <code>RetainAllVariantProperties</code> to <code>false</code>. The default is <code>false</code>.</p>', 'UpdateEndpointInput$RetainDeploymentConfig' => '<p>Specifies whether to reuse the last deployment configuration. The default value is false (the configuration is not reused).</p>', ], ], 'BooleanOperator' => [ 'base' => NULL, 'refs' => [ 'SearchExpression$Operator' => '<p>A Boolean operator used to evaluate the search expression. If you want every conditional statement in all lists to be satisfied for the entire search expression to be true, specify <code>And</code>. If only a single conditional statement needs to be true for the entire search expression to be true, specify <code>Or</code>. The default value is <code>And</code>.</p>', ], ], 'Branch' => [ 'base' => NULL, 'refs' => [ 'GitConfig$Branch' => '<p>The default branch for the Git repository.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'PipelineDefinitionS3Location$Bucket' => '<p>Name of the S3 bucket.</p>', ], ], 'CacheHitResult' => [ 'base' => '<p>Details on the cache hit of a pipeline execution step.</p>', 'refs' => [ 'PipelineExecutionStep$CacheHitResult' => '<p>If this pipeline execution step was cached, details on the cache hit.</p>', ], ], 'CallbackStepMetadata' => [ 'base' => '<p>Metadata about a callback step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Callback' => '<p>The URL of the Amazon SQS queue used by this step execution, the pipeline generated token, and a list of output parameters.</p>', ], ], 'CallbackToken' => [ 'base' => NULL, 'refs' => [ 'CallbackStepMetadata$CallbackToken' => '<p>The pipeline generated token from the Amazon SQS queue.</p>', 'SendPipelineExecutionStepFailureRequest$CallbackToken' => '<p>The pipeline generated token from the Amazon SQS queue.</p>', 'SendPipelineExecutionStepSuccessRequest$CallbackToken' => '<p>The pipeline generated token from the Amazon SQS queue.</p>', ], ], 'CandidateArtifactLocations' => [ 'base' => '<p>The location of artifacts for an AutoML candidate job.</p>', 'refs' => [ 'CandidateProperties$CandidateArtifactLocations' => '<p>The Amazon S3 prefix to the artifacts generated for an AutoML candidate.</p>', ], ], 'CandidateDefinitionNotebookLocation' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobArtifacts$CandidateDefinitionNotebookLocation' => '<p>The URL of the notebook location.</p>', ], ], 'CandidateName' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CandidateName' => '<p>The name of the candidate.</p>', 'ListCandidatesForAutoMLJobRequest$CandidateNameEquals' => '<p>List the candidates for the job and filter by candidate name.</p>', ], ], 'CandidateProperties' => [ 'base' => '<p>The properties of an AutoML candidate job.</p>', 'refs' => [ 'AutoMLCandidate$CandidateProperties' => '<p>The properties of an AutoML candidate job.</p>', ], ], 'CandidateSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCandidatesForAutoMLJobRequest$SortBy' => '<p>The parameter by which to sort the results. The default is <code>Descending</code>.</p>', ], ], 'CandidateStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CandidateStatus' => '<p>The candidate\'s status.</p>', 'ListCandidatesForAutoMLJobRequest$StatusEquals' => '<p>List the candidates for the job and filter by status.</p>', ], ], 'CandidateStepArn' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateStep$CandidateStepArn' => '<p>The ARN for the candidate\'s step.</p>', ], ], 'CandidateStepName' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateStep$CandidateStepName' => '<p>The name for the candidate\'s step.</p>', ], ], 'CandidateStepType' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidateStep$CandidateStepType' => '<p>Whether the candidate is at the transform, training, or processing step.</p>', ], ], 'CandidateSteps' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$CandidateSteps' => '<p>Information about the candidate\'s steps.</p>', ], ], 'CapacitySize' => [ 'base' => '<p>Specifies the endpoint capacity to activate for production.</p>', 'refs' => [ 'TrafficRoutingConfig$CanarySize' => '<p>Batch size for the first step to turn on traffic on the new endpoint fleet. <code>Value</code> must be less than or equal to 50% of the variant\'s total instance count.</p>', 'TrafficRoutingConfig$LinearStepSize' => '<p>Batch size for each step to turn on traffic on the new endpoint fleet. <code>Value</code> must be 10-50% of the variant\'s total instance count.</p>', ], ], 'CapacitySizeType' => [ 'base' => NULL, 'refs' => [ 'CapacitySize$Type' => '<p>Specifies the endpoint capacity type.</p> <ul> <li> <p> <code>INSTANCE_COUNT</code>: The endpoint activates based on the number of instances.</p> </li> <li> <p> <code>CAPACITY_PERCENT</code>: The endpoint activates based on the specified percentage of capacity.</p> </li> </ul>', ], ], 'CapacitySizeValue' => [ 'base' => NULL, 'refs' => [ 'CapacitySize$Value' => '<p>Defines the capacity size, either as a number of instances or a capacity percentage.</p>', ], ], 'CaptureContentTypeHeader' => [ 'base' => '<p/>', 'refs' => [ 'DataCaptureConfig$CaptureContentTypeHeader' => '<p/>', ], ], 'CaptureMode' => [ 'base' => NULL, 'refs' => [ 'CaptureOption$CaptureMode' => '<p/>', ], ], 'CaptureOption' => [ 'base' => '<p/>', 'refs' => [ 'CaptureOptionList$member' => NULL, ], ], 'CaptureOptionList' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfig$CaptureOptions' => '<p/>', ], ], 'CaptureStatus' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfigSummary$CaptureStatus' => '<p/>', ], ], 'Catalog' => [ 'base' => NULL, 'refs' => [ 'DataCatalogConfig$Catalog' => '<p>The name of the Glue table catalog.</p>', ], ], 'CategoricalParameter' => [ 'base' => '<p>Environment parameters you want to benchmark your load test against.</p>', 'refs' => [ 'CategoricalParameters$member' => NULL, ], ], 'CategoricalParameterRange' => [ 'base' => '<p>A list of categorical hyperparameters to tune.</p>', 'refs' => [ 'CategoricalParameterRanges$member' => NULL, ], ], 'CategoricalParameterRangeSpecification' => [ 'base' => '<p>Defines the possible values for a categorical hyperparameter.</p>', 'refs' => [ 'ParameterRange$CategoricalParameterRangeSpecification' => '<p>A <code>CategoricalParameterRangeSpecification</code> object that defines the possible values for a categorical hyperparameter.</p>', ], ], 'CategoricalParameterRangeValues' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameter$Value' => '<p>The list of values you can pass.</p>', ], ], 'CategoricalParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$CategoricalParameterRanges' => '<p>The array of <a>CategoricalParameterRange</a> objects that specify ranges of categorical hyperparameters that a hyperparameter tuning job searches.</p>', ], ], 'CategoricalParameters' => [ 'base' => NULL, 'refs' => [ 'EnvironmentParameterRanges$CategoricalParameterRanges' => '<p>Specified a list of parameters for each category.</p>', ], ], 'Cents' => [ 'base' => NULL, 'refs' => [ 'USD$Cents' => '<p>The fractional portion, in cents, of the amount. </p>', ], ], 'CertifyForMarketplace' => [ 'base' => NULL, 'refs' => [ 'CreateAlgorithmInput$CertifyForMarketplace' => '<p>Whether to certify the algorithm so that it can be listed in Amazon Web Services Marketplace.</p>', 'CreateModelPackageInput$CertifyForMarketplace' => '<p>Whether to certify the model package for listing on Amazon Web Services Marketplace.</p> <p>This parameter is optional for unversioned models, and does not apply to versioned models.</p>', 'DescribeAlgorithmOutput$CertifyForMarketplace' => '<p>Whether the algorithm is certified to be listed in Amazon Web Services Marketplace.</p>', 'DescribeModelPackageOutput$CertifyForMarketplace' => '<p>Whether the model package is certified for listing on Amazon Web Services Marketplace.</p>', 'ModelPackage$CertifyForMarketplace' => '<p>Whether the model package is to be certified to be listed on Amazon Web Services Marketplace. For information about listing model packages on Amazon Web Services Marketplace, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html">List Your Algorithm or Model Package on Amazon Web Services Marketplace</a>.</p>', ], ], 'Channel' => [ 'base' => '<p>A channel is a named input source that training algorithms can consume. </p>', 'refs' => [ 'InputDataConfig$member' => NULL, ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'Channel$ChannelName' => '<p>The name of the channel. </p>', 'ChannelSpecification$Name' => '<p>The name of the channel.</p>', ], ], 'ChannelSpecification' => [ 'base' => '<p>Defines a named input source, called a channel, to be used by an algorithm.</p>', 'refs' => [ 'ChannelSpecifications$member' => NULL, ], ], 'ChannelSpecifications' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$TrainingChannels' => '<p>A list of <code>ChannelSpecification</code> objects, which specify the input sources to be used by the algorithm.</p>', ], ], 'CheckpointConfig' => [ 'base' => '<p>Contains information about the output location for managed spot training checkpoint data. </p>', 'refs' => [ 'CreateTrainingJobRequest$CheckpointConfig' => '<p>Contains information about the output location for managed spot training checkpoint data.</p>', 'DescribeTrainingJobResponse$CheckpointConfig' => NULL, 'HyperParameterTrainingJobDefinition$CheckpointConfig' => NULL, 'TrainingJob$CheckpointConfig' => NULL, ], ], 'Cidr' => [ 'base' => NULL, 'refs' => [ 'Cidrs$member' => NULL, ], ], 'Cidrs' => [ 'base' => NULL, 'refs' => [ 'SourceIpConfig$Cidrs' => '<p>A list of one to ten <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">Classless Inter-Domain Routing</a> (CIDR) values.</p> <p>Maximum: Ten CIDR values</p> <note> <p>The following Length Constraints apply to individual CIDR values in the CIDR value list.</p> </note>', ], ], 'ClarifyCheckStepMetadata' => [ 'base' => '<p>The container for the metadata for the ClarifyCheck step. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/build-and-manage-steps.html#step-type-clarify-check">ClarifyCheck step</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'refs' => [ 'PipelineExecutionStepMetadata$ClarifyCheck' => '<p>Container for the metadata for a Clarify check step. The configurations and outcomes of the check step execution. This includes: </p> <ul> <li> <p>The type of the check conducted,</p> </li> <li> <p>The Amazon S3 URIs of baseline constraints and statistics files to be used for the drift check.</p> </li> <li> <p>The Amazon S3 URIs of newly calculated baseline constraints and statistics.</p> </li> <li> <p>The model package group name provided.</p> </li> <li> <p>The Amazon S3 URI of the violation report if violations detected.</p> </li> <li> <p>The Amazon Resource Name (ARN) of check processing job initiated by the step execution.</p> </li> <li> <p>The boolean flags indicating if the drift check is skipped.</p> </li> <li> <p>If step property <code>BaselineUsedForDriftCheck</code> is set the same as <code>CalculatedBaseline</code>.</p> </li> </ul>', ], ], 'ClientId' => [ 'base' => NULL, 'refs' => [ 'CognitoConfig$ClientId' => '<p>The client ID for your Amazon Cognito user pool.</p>', 'CognitoMemberDefinition$ClientId' => '<p>An identifier for an application client. You must create the app client ID using Amazon Cognito.</p>', 'OidcConfig$ClientId' => '<p>The OIDC IdP client ID used to configure your private workforce.</p>', 'OidcConfigForResponse$ClientId' => '<p>The OIDC IdP client ID used to configure your private workforce.</p>', ], ], 'ClientSecret' => [ 'base' => NULL, 'refs' => [ 'OidcConfig$ClientSecret' => '<p>The OIDC IdP client secret used to configure your private workforce.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$ClientToken' => '<p>A unique ID. If not specified, the Amazon Web Services CLI and Amazon Web Services SDKs, such as the SDK for Python (Boto3), add a unique value to the call.</p>', 'CreateModelPackageInput$ClientToken' => '<p>A unique token that guarantees that the call to this API is idempotent.</p>', ], ], 'CodeRepositoryArn' => [ 'base' => NULL, 'refs' => [ 'CodeRepositorySummary$CodeRepositoryArn' => '<p>The Amazon Resource Name (ARN) of the Git repository.</p>', 'CreateCodeRepositoryOutput$CodeRepositoryArn' => '<p>The Amazon Resource Name (ARN) of the new repository.</p>', 'DescribeCodeRepositoryOutput$CodeRepositoryArn' => '<p>The Amazon Resource Name (ARN) of the Git repository.</p>', 'UpdateCodeRepositoryOutput$CodeRepositoryArn' => '<p>The ARN of the Git repository.</p>', ], ], 'CodeRepositoryContains' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$DefaultCodeRepositoryContains' => '<p>A string in the name or URL of a Git repository associated with this notebook instance. This filter returns only notebook instances associated with a git repository with a name that contains the specified string.</p>', ], ], 'CodeRepositoryNameContains' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesInput$NameContains' => '<p>A string in the Git repositories name. This filter returns only repositories whose name contains the specified string.</p>', ], ], 'CodeRepositoryNameOrUrl' => [ 'base' => NULL, 'refs' => [ 'AdditionalCodeRepositoryNamesOrUrls$member' => NULL, 'CreateNotebookInstanceInput$DefaultCodeRepository' => '<p>A Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'DescribeNotebookInstanceOutput$DefaultCodeRepository' => '<p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'ListNotebookInstancesInput$AdditionalCodeRepositoryEquals' => '<p>A filter that returns only notebook instances with associated with the specified git repository.</p>', 'NotebookInstanceSummary$DefaultCodeRepository' => '<p>The Git repository associated with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', 'UpdateNotebookInstanceInput$DefaultCodeRepository' => '<p>The Git repository to associate with the notebook instance as its default code repository. This can be either the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon SageMaker Notebook Instances</a>.</p>', ], ], 'CodeRepositorySortBy' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesInput$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p>', ], ], 'CodeRepositorySortOrder' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesInput$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', ], ], 'CodeRepositorySummary' => [ 'base' => '<p>Specifies summary information about a Git repository.</p>', 'refs' => [ 'CodeRepositorySummaryList$member' => NULL, ], ], 'CodeRepositorySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCodeRepositoriesOutput$CodeRepositorySummaryList' => '<p>Gets a list of summaries of the Git repositories. Each summary specifies the following values for the repository: </p> <ul> <li> <p>Name</p> </li> <li> <p>Amazon Resource Name (ARN)</p> </li> <li> <p>Creation time</p> </li> <li> <p>Last modified time</p> </li> <li> <p>Configuration information, including the URL location of the repository and the ARN of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p> </li> </ul>', ], ], 'CognitoConfig' => [ 'base' => '<p>Use this parameter to configure your Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p>', 'refs' => [ 'CreateWorkforceRequest$CognitoConfig' => '<p>Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p> <p>Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.</p>', 'Workforce$CognitoConfig' => '<p>The configuration of an Amazon Cognito workforce. A single Cognito workforce is created using and corresponds to a single <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito user pool</a>.</p>', ], ], 'CognitoMemberDefinition' => [ 'base' => '<p>Identifies a Amazon Cognito user group. A user group can be used in on or more work teams.</p>', 'refs' => [ 'MemberDefinition$CognitoMemberDefinition' => '<p>The Amazon Cognito user group that is part of the work team.</p>', ], ], 'CognitoUserGroup' => [ 'base' => NULL, 'refs' => [ 'CognitoMemberDefinition$UserGroup' => '<p>An identifier for a user group.</p>', ], ], 'CognitoUserPool' => [ 'base' => NULL, 'refs' => [ 'CognitoConfig$UserPool' => '<p>A <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> user pool</a> is a user directory in Amazon Cognito. With a user pool, your users can sign in to your web or mobile app through Amazon Cognito. Your users can also sign in through social identity providers like Google, Facebook, Amazon, or Apple, and through SAML identity providers.</p>', 'CognitoMemberDefinition$UserPool' => '<p>An identifier for a user pool. The user pool must be in the same region as the service that you are calling.</p>', ], ], 'CollectionConfiguration' => [ 'base' => '<p>Configuration information for the Debugger output tensor collections.</p>', 'refs' => [ 'CollectionConfigurations$member' => NULL, ], ], 'CollectionConfigurations' => [ 'base' => NULL, 'refs' => [ 'DebugHookConfig$CollectionConfigurations' => '<p>Configuration information for Debugger tensor collections. To learn more about how to configure the <code>CollectionConfiguration</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>. </p>', ], ], 'CollectionName' => [ 'base' => NULL, 'refs' => [ 'CollectionConfiguration$CollectionName' => '<p>The name of the tensor collection. The name must be unique relative to other rule configuration names.</p>', ], ], 'CollectionParameters' => [ 'base' => NULL, 'refs' => [ 'CollectionConfiguration$CollectionParameters' => '<p>Parameter values for the tensor collection. The allowed parameters are <code>"name"</code>, <code>"include_regex"</code>, <code>"reduction_config"</code>, <code>"save_config"</code>, <code>"tensor_names"</code>, and <code>"save_histogram"</code>.</p>', ], ], 'CompilationJobArn' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationJobArn' => '<p>The Amazon Resource Name (ARN) of the model compilation job.</p>', 'CreateCompilationJobResponse$CompilationJobArn' => '<p>If the action is successful, the service sends back an HTTP 200 response. Amazon SageMaker returns the following data in JSON format:</p> <ul> <li> <p> <code>CompilationJobArn</code>: The Amazon Resource Name (ARN) of the compiled job.</p> </li> </ul>', 'DescribeCompilationJobResponse$CompilationJobArn' => '<p>The Amazon Resource Name (ARN) of the model compilation job.</p>', ], ], 'CompilationJobStatus' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationJobStatus' => '<p>The status of the model compilation job.</p>', 'DescribeCompilationJobResponse$CompilationJobStatus' => '<p>The status of the model compilation job.</p>', 'ListCompilationJobsRequest$StatusEquals' => '<p>A filter that retrieves model compilation jobs with a specific <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.</p>', ], ], 'CompilationJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCompilationJobsResponse$CompilationJobSummaries' => '<p>An array of <a>CompilationJobSummary</a> objects, each describing a model compilation job. </p>', ], ], 'CompilationJobSummary' => [ 'base' => '<p>A summary of a model compilation job.</p>', 'refs' => [ 'CompilationJobSummaries$member' => NULL, ], ], 'CompilerOptions' => [ 'base' => NULL, 'refs' => [ 'OutputConfig$CompilerOptions' => '<p>Specifies additional parameters for compiler options in JSON format. The compiler options are <code>TargetPlatform</code> specific. It is required for NVIDIA accelerators and highly recommended for CPU compilations. For any other cases, it is optional to specify <code>CompilerOptions.</code> </p> <ul> <li> <p> <code>DTYPE</code>: Specifies the data type for the input. When compiling for <code>ml_*</code> (except for <code>ml_inf</code>) instances using PyTorch framework, provide the data type (dtype) of the model\'s input. <code>"float32"</code> is used if <code>"DTYPE"</code> is not specified. Options for data type are:</p> <ul> <li> <p>float32: Use either <code>"float"</code> or <code>"float32"</code>.</p> </li> <li> <p>int64: Use either <code>"int64"</code> or <code>"long"</code>.</p> </li> </ul> <p> For example, <code>{"dtype" : "float32"}</code>.</p> </li> <li> <p> <code>CPU</code>: Compilation for CPU supports the following compiler options.</p> <ul> <li> <p> <code>mcpu</code>: CPU micro-architecture. For example, <code>{\'mcpu\': \'skylake-avx512\'}</code> </p> </li> <li> <p> <code>mattr</code>: CPU flags. For example, <code>{\'mattr\': [\'+neon\', \'+vfpv4\']}</code> </p> </li> </ul> </li> <li> <p> <code>ARM</code>: Details of ARM CPU compilations.</p> <ul> <li> <p> <code>NEON</code>: NEON is an implementation of the Advanced SIMD extension used in ARMv7 processors.</p> <p>For example, add <code>{\'mattr\': [\'+neon\']}</code> to the compiler options if compiling for ARM 32-bit platform with the NEON support.</p> </li> </ul> </li> <li> <p> <code>NVIDIA</code>: Compilation for NVIDIA GPU supports the following compiler options.</p> <ul> <li> <p> <code>gpu_code</code>: Specifies the targeted architecture.</p> </li> <li> <p> <code>trt-ver</code>: Specifies the TensorRT versions in x.y.z. format.</p> </li> <li> <p> <code>cuda-ver</code>: Specifies the CUDA version in x.y format.</p> </li> </ul> <p>For example, <code>{\'gpu-code\': \'sm_72\', \'trt-ver\': \'6.0.1\', \'cuda-ver\': \'10.1\'}</code> </p> </li> <li> <p> <code>ANDROID</code>: Compilation for the Android OS supports the following compiler options:</p> <ul> <li> <p> <code>ANDROID_PLATFORM</code>: Specifies the Android API levels. Available levels range from 21 to 29. For example, <code>{\'ANDROID_PLATFORM\': 28}</code>.</p> </li> <li> <p> <code>mattr</code>: Add <code>{\'mattr\': [\'+neon\']}</code> to compiler options if compiling for ARM 32-bit platform with NEON support.</p> </li> </ul> </li> <li> <p> <code>INFERENTIA</code>: Compilation for target ml_inf1 uses compiler options passed in as a JSON string. For example, <code>"CompilerOptions": "\\"--verbose 1 --num-neuroncores 2 -O2\\""</code>. </p> <p>For information about supported compiler options, see <a href="https://github.com/aws/aws-neuron-sdk/blob/master/docs/neuron-cc/command-line-reference.md"> Neuron Compiler CLI</a>. </p> </li> <li> <p> <code>CoreML</code>: Compilation for the CoreML <a>OutputConfig$TargetDevice</a> supports the following compiler options:</p> <ul> <li> <p> <code>class_labels</code>: Specifies the classification labels file name inside input tar.gz file. For example, <code>{"class_labels": "imagenet_labels_1000.txt"}</code>. Labels inside the txt file should be separated by newlines.</p> </li> </ul> </li> <li> <p> <code>EIA</code>: Compilation for the Elastic Inference Accelerator supports the following compiler options:</p> <ul> <li> <p> <code>precision_mode</code>: Specifies the precision of compiled artifacts. Supported values are <code>"FP16"</code> and <code>"FP32"</code>. Default is <code>"FP32"</code>.</p> </li> <li> <p> <code>signature_def_key</code>: Specifies the signature to use for models in SavedModel format. Defaults is TensorFlow\'s default signature def key.</p> </li> <li> <p> <code>output_names</code>: Specifies a list of output tensor names for models in FrozenGraph format. Set at most one API field, either: <code>signature_def_key</code> or <code>output_names</code>.</p> </li> </ul> <p>For example: <code>{"precision_mode": "FP32", "output_names": ["output:0"]}</code> </p> </li> </ul>', ], ], 'CompressionType' => [ 'base' => NULL, 'refs' => [ 'AutoMLChannel$CompressionType' => '<p>You can use <code>Gzip</code> or <code>None</code>. The default value is <code>None</code>.</p>', 'Channel$CompressionType' => '<p>If training data is compressed, the compression type. The default value is <code>None</code>. <code>CompressionType</code> is used only in Pipe input mode. In File mode, leave this field unset or set it to None.</p>', 'CompressionTypes$member' => NULL, 'TransformInput$CompressionType' => '<p>If your transform data is compressed, specify the compression type. Amazon SageMaker automatically decompresses the data for the transform job accordingly. The default value is <code>None</code>.</p>', ], ], 'CompressionTypes' => [ 'base' => NULL, 'refs' => [ 'ChannelSpecification$SupportedCompressionTypes' => '<p>The allowed compression types, if data compression is used.</p>', ], ], 'ConditionOutcome' => [ 'base' => NULL, 'refs' => [ 'ConditionStepMetadata$Outcome' => '<p>The outcome of the Condition step evaluation.</p>', ], ], 'ConditionStepMetadata' => [ 'base' => '<p>Metadata for a Condition step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Condition' => '<p>The outcome of the condition evaluation that was run by this step execution.</p>', ], ], 'ConfigKey' => [ 'base' => NULL, 'refs' => [ 'CollectionParameters$key' => NULL, 'HookParameters$key' => NULL, 'ProfilingParameters$key' => NULL, 'RuleParameters$key' => NULL, ], ], 'ConfigValue' => [ 'base' => NULL, 'refs' => [ 'CollectionParameters$value' => NULL, 'HookParameters$value' => NULL, 'ProfilingParameters$value' => NULL, 'RuleParameters$value' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict when you attempted to modify a SageMaker entity such as an <code>Experiment</code> or <code>Artifact</code>.</p>', 'refs' => [], ], 'ContainerArgument' => [ 'base' => NULL, 'refs' => [ 'ContainerArguments$member' => NULL, 'MonitoringContainerArguments$member' => NULL, ], ], 'ContainerArguments' => [ 'base' => NULL, 'refs' => [ 'AppSpecification$ContainerArguments' => '<p>The arguments for a container used to run a processing job.</p>', ], ], 'ContainerDefinition' => [ 'base' => '<p>Describes the container, as part of model definition.</p>', 'refs' => [ 'ContainerDefinitionList$member' => NULL, 'CreateModelInput$PrimaryContainer' => '<p>The location of the primary docker image containing inference code, associated artifacts, and custom environment map that the inference code uses when the model is deployed for predictions. </p>', 'DescribeModelOutput$PrimaryContainer' => '<p>The location of the primary inference code, associated artifacts, and custom environment map that the inference code uses when it is deployed in production. </p>', ], ], 'ContainerDefinitionList' => [ 'base' => NULL, 'refs' => [ 'CreateModelInput$Containers' => '<p>Specifies the containers in the inference pipeline.</p>', 'DescribeModelOutput$Containers' => '<p>The containers in the inference pipeline.</p>', ], ], 'ContainerEntrypoint' => [ 'base' => NULL, 'refs' => [ 'AppSpecification$ContainerEntrypoint' => '<p>The entrypoint for a container used to run a processing job.</p>', 'DataQualityAppSpecification$ContainerEntrypoint' => '<p>The entrypoint for a container used to run a monitoring job.</p>', 'ModelQualityAppSpecification$ContainerEntrypoint' => '<p>Specifies the entrypoint for a container that the monitoring job runs.</p>', 'MonitoringAppSpecification$ContainerEntrypoint' => '<p>Specifies the entrypoint for a container used to run the monitoring job.</p>', ], ], 'ContainerEntrypointString' => [ 'base' => NULL, 'refs' => [ 'ContainerEntrypoint$member' => NULL, ], ], 'ContainerHostname' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$ContainerHostname' => '<p>This parameter is ignored for models that contain only a <code>PrimaryContainer</code>.</p> <p>When a <code>ContainerDefinition</code> is part of an inference pipeline, the value of the parameter uniquely identifies the container for the purposes of logging and metrics. For information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html">Use Logs and Metrics to Monitor an Inference Pipeline</a>. If you don\'t specify a value for this parameter for a <code>ContainerDefinition</code> that is part of an inference pipeline, a unique name is automatically assigned based on the position of the <code>ContainerDefinition</code> in the pipeline. If you specify a value for the <code>ContainerHostName</code> for any <code>ContainerDefinition</code> that is part of an inference pipeline, you must specify a value for the <code>ContainerHostName</code> parameter of every <code>ContainerDefinition</code> in that pipeline.</p>', 'ModelPackageContainerDefinition$ContainerHostname' => '<p>The DNS host name for the Docker container.</p>', ], ], 'ContainerImage' => [ 'base' => NULL, 'refs' => [ 'AutoMLContainerDefinition$Image' => '<p>The Amazon Elastic Container Registry (Amazon ECR) path of the container. For more information, see .</p>', 'ContainerDefinition$Image' => '<p>The path where inference code is stored. This can be either in Amazon EC2 Container Registry or in a Docker registry that is accessible from the same VPC that you configure for your endpoint. If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a> </p>', 'DeployedImage$SpecifiedImage' => '<p>The image path you specified when you created the model.</p>', 'DeployedImage$ResolvedImage' => '<p>The specific digest path of the image hosted in this <code>ProductionVariant</code>.</p>', 'ModelPackageContainerDefinition$Image' => '<p>The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p> <p>If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with Amazon SageMaker</a>.</p>', 'TrainingSpecification$TrainingImage' => '<p>The Amazon ECR registry path of the Docker image that contains the training algorithm.</p>', ], ], 'ContainerMode' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$Mode' => '<p>Whether the container hosts a single model or multiple models.</p>', ], ], 'ContentClassifier' => [ 'base' => NULL, 'refs' => [ 'ContentClassifiers$member' => NULL, ], ], 'ContentClassifiers' => [ 'base' => NULL, 'refs' => [ 'LabelingJobDataAttributes$ContentClassifiers' => '<p>Declares that your content is free of personally identifiable information or adult content. Amazon SageMaker may restrict the Amazon Mechanical Turk workers that can view your task based on this information.</p>', ], ], 'ContentDigest' => [ 'base' => NULL, 'refs' => [ 'FileSource$ContentDigest' => '<p>The digest of the file source.</p>', 'MetricsSource$ContentDigest' => '<p/>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'AutoMLChannel$ContentType' => '<p>The content type of the data from the input source. You can use <code>text/csv;header=present</code> or <code>x-application/vnd.amazon+parquet</code>. The default value is <code>text/csv;header=present</code>.</p>', 'Channel$ContentType' => '<p>The MIME type of the data.</p>', 'ContentTypes$member' => NULL, 'FileSource$ContentType' => '<p>The type of content stored in the file source.</p>', 'MetricsSource$ContentType' => '<p/>', 'TransformInput$ContentType' => '<p>The multipurpose internet mail extension (MIME) type of the data. Amazon SageMaker uses the MIME type with each http call to transfer data to the transform job.</p>', ], ], 'ContentTypes' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$SupportedContentTypes' => '<p>The supported MIME types for the input data.</p>', 'ChannelSpecification$SupportedContentTypes' => '<p>The supported MIME types for the data.</p>', 'InferenceSpecification$SupportedContentTypes' => '<p>The supported MIME types for the input data.</p>', ], ], 'ContextArn' => [ 'base' => NULL, 'refs' => [ 'ContextSummary$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', 'CreateContextResponse$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', 'DeleteContextResponse$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', 'DescribeContextResponse$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', 'UpdateContextResponse$ContextArn' => '<p>The Amazon Resource Name (ARN) of the context.</p>', ], ], 'ContextSource' => [ 'base' => '<p>A structure describing the source of a context.</p>', 'refs' => [ 'ContextSummary$Source' => '<p>The source of the context.</p>', 'CreateContextRequest$Source' => '<p>The source type, ID, and URI.</p>', 'DescribeContextResponse$Source' => '<p>The source of the context.</p>', ], ], 'ContextSummaries' => [ 'base' => NULL, 'refs' => [ 'ListContextsResponse$ContextSummaries' => '<p>A list of contexts and their properties.</p>', ], ], 'ContextSummary' => [ 'base' => '<p>Lists a summary of the properties of a context. A context provides a logical grouping of other entities.</p>', 'refs' => [ 'ContextSummaries$member' => NULL, ], ], 'ContinuousParameterRange' => [ 'base' => '<p>A list of continuous hyperparameters to tune.</p>', 'refs' => [ 'ContinuousParameterRanges$member' => NULL, ], ], 'ContinuousParameterRangeSpecification' => [ 'base' => '<p>Defines the possible values for a continuous hyperparameter.</p>', 'refs' => [ 'ParameterRange$ContinuousParameterRangeSpecification' => '<p>A <code>ContinuousParameterRangeSpecification</code> object that defines the possible values for a continuous hyperparameter.</p>', ], ], 'ContinuousParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$ContinuousParameterRanges' => '<p>The array of <a>ContinuousParameterRange</a> objects that specify ranges of continuous hyperparameters that a hyperparameter tuning job searches.</p>', ], ], 'CreateActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAlgorithmInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAlgorithmOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppImageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppImageConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateArtifactResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAutoMLJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCodeRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateCompilationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCompilationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateContextRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContextResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataQualityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeviceFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEdgePackagingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFeatureGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFeatureGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFlowDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHumanTaskUiRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHumanTaskUiResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHyperParameterTuningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateImageVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceRecommendationsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInferenceRecommendationsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLabelingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelBiasJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelBiasJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelExplainabilityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelExplainabilityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelQualityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitoringScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceLifecycleConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNotebookInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedDomainUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedDomainUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedNotebookInstanceUrlInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePresignedNotebookInstanceUrlOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProcessingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProcessingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioLifecycleConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioLifecycleConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrainingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrainingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransformJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransformJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationTime' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSummary$CreationTime' => '<p>A timestamp that shows when the algorithm was created.</p>', 'AppDetails$CreationTime' => '<p>The creation time.</p>', 'BatchDescribeModelPackageSummary$CreationTime' => '<p>The creation time of the mortgage package summary.</p>', 'CodeRepositorySummary$CreationTime' => '<p>The date and time that the Git repository was created.</p>', 'CompilationJobSummary$CreationTime' => '<p>The time when the model compilation job was created.</p>', 'DescribeAlgorithmOutput$CreationTime' => '<p>A timestamp specifying when the algorithm was created.</p>', 'DescribeAppResponse$CreationTime' => '<p>The creation time.</p>', 'DescribeCodeRepositoryOutput$CreationTime' => '<p>The date and time that the repository was created.</p>', 'DescribeCompilationJobResponse$CreationTime' => '<p>The time that the model compilation job was created.</p>', 'DescribeDomainResponse$CreationTime' => '<p>The creation time.</p>', 'DescribeFeatureGroupResponse$CreationTime' => '<p>A timestamp indicating when SageMaker created the <code>FeatureGroup</code>.</p>', 'DescribeInferenceRecommendationsJobResponse$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'DescribeModelPackageGroupOutput$CreationTime' => '<p>The time that the model group was created.</p>', 'DescribeModelPackageOutput$CreationTime' => '<p>A timestamp specifying when the model package was created.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$CreationTime' => '<p>A timestamp that tells when the lifecycle configuration was created.</p>', 'DescribeNotebookInstanceOutput$CreationTime' => '<p>A timestamp. Use this parameter to return the time when the notebook instance was created</p>', 'DescribeUserProfileResponse$CreationTime' => '<p>The creation time.</p>', 'DomainDetails$CreationTime' => '<p>The creation time.</p>', 'FeatureGroup$CreationTime' => '<p>The time a <code>FeatureGroup</code> was created.</p>', 'InferenceRecommendationsJob$CreationTime' => '<p>A timestamp that shows when the job was created.</p>', 'ListAlgorithmsInput$CreationTimeAfter' => '<p>A filter that returns only algorithms created after the specified time (timestamp).</p>', 'ListAlgorithmsInput$CreationTimeBefore' => '<p>A filter that returns only algorithms created before the specified time (timestamp).</p>', 'ListCodeRepositoriesInput$CreationTimeAfter' => '<p>A filter that returns only Git repositories that were created after the specified time.</p>', 'ListCodeRepositoriesInput$CreationTimeBefore' => '<p>A filter that returns only Git repositories that were created before the specified time.</p>', 'ListCompilationJobsRequest$CreationTimeAfter' => '<p>A filter that returns the model compilation jobs that were created after a specified time. </p>', 'ListCompilationJobsRequest$CreationTimeBefore' => '<p>A filter that returns the model compilation jobs that were created before a specified time.</p>', 'ListFeatureGroupsRequest$CreationTimeAfter' => '<p>Use this parameter to search for <code>FeatureGroups</code>s created after a specific date and time.</p>', 'ListFeatureGroupsRequest$CreationTimeBefore' => '<p>Use this parameter to search for <code>FeatureGroups</code>s created before a specific date and time.</p>', 'ListInferenceRecommendationsJobsRequest$CreationTimeAfter' => '<p>A filter that returns only jobs created after the specified time (timestamp).</p>', 'ListInferenceRecommendationsJobsRequest$CreationTimeBefore' => '<p>A filter that returns only jobs created before the specified time (timestamp).</p>', 'ListModelPackageGroupsInput$CreationTimeAfter' => '<p>A filter that returns only model groups created after the specified time.</p>', 'ListModelPackageGroupsInput$CreationTimeBefore' => '<p>A filter that returns only model groups created before the specified time.</p>', 'ListModelPackagesInput$CreationTimeAfter' => '<p>A filter that returns only model packages created after the specified time (timestamp).</p>', 'ListModelPackagesInput$CreationTimeBefore' => '<p>A filter that returns only model packages created before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$CreationTimeBefore' => '<p>A filter that returns only lifecycle configurations that were created before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$CreationTimeAfter' => '<p>A filter that returns only lifecycle configurations that were created after the specified time (timestamp).</p>', 'ListNotebookInstancesInput$CreationTimeBefore' => '<p>A filter that returns only notebook instances that were created before the specified time (timestamp). </p>', 'ListNotebookInstancesInput$CreationTimeAfter' => '<p>A filter that returns only notebook instances that were created after the specified time (timestamp).</p>', 'ModelPackage$CreationTime' => '<p>The time that the model package was created.</p>', 'ModelPackageGroup$CreationTime' => '<p>The time that the model group was created.</p>', 'ModelPackageGroupSummary$CreationTime' => '<p>The time that the model group was created.</p>', 'ModelPackageSummary$CreationTime' => '<p>A timestamp that shows when the model package was created.</p>', 'NotebookInstanceLifecycleConfigSummary$CreationTime' => '<p>A timestamp that tells when the lifecycle configuration was created.</p>', 'NotebookInstanceSummary$CreationTime' => '<p>A timestamp that shows when the notebook instance was created.</p>', 'UserProfileDetails$CreationTime' => '<p>The creation time.</p>', ], ], 'CsvContentType' => [ 'base' => NULL, 'refs' => [ 'CsvContentTypes$member' => NULL, ], ], 'CsvContentTypes' => [ 'base' => NULL, 'refs' => [ 'CaptureContentTypeHeader$CsvContentTypes' => '<p/>', ], ], 'CustomImage' => [ 'base' => '<p>A custom SageMaker image. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker image</a>.</p>', 'refs' => [ 'CustomImages$member' => NULL, ], ], 'CustomImages' => [ 'base' => NULL, 'refs' => [ 'KernelGatewayAppSettings$CustomImages' => '<p>A list of custom SageMaker images that are configured to run as a KernelGateway app.</p>', ], ], 'CustomerMetadataKey' => [ 'base' => NULL, 'refs' => [ 'CustomerMetadataKeyList$member' => NULL, 'CustomerMetadataMap$key' => NULL, ], ], 'CustomerMetadataKeyList' => [ 'base' => NULL, 'refs' => [ 'UpdateModelPackageInput$CustomerMetadataPropertiesToRemove' => '<p>The metadata properties associated with the model package versions to remove.</p>', ], ], 'CustomerMetadataMap' => [ 'base' => NULL, 'refs' => [ 'CreateModelPackageInput$CustomerMetadataProperties' => '<p>The metadata properties associated with the model package versions.</p>', 'DescribeModelPackageOutput$CustomerMetadataProperties' => '<p>The metadata properties associated with the model package versions.</p>', 'ModelPackage$CustomerMetadataProperties' => '<p>The metadata properties for the model package. </p>', 'UpdateModelPackageInput$CustomerMetadataProperties' => '<p>The metadata properties associated with the model package versions.</p>', ], ], 'CustomerMetadataValue' => [ 'base' => NULL, 'refs' => [ 'CustomerMetadataMap$value' => NULL, ], ], 'DataCaptureConfig' => [ 'base' => '<p/>', 'refs' => [ 'CreateEndpointConfigInput$DataCaptureConfig' => NULL, 'DescribeEndpointConfigOutput$DataCaptureConfig' => NULL, ], ], 'DataCaptureConfigSummary' => [ 'base' => '<p/>', 'refs' => [ 'DescribeEndpointOutput$DataCaptureConfig' => NULL, 'Endpoint$DataCaptureConfig' => NULL, ], ], 'DataCatalogConfig' => [ 'base' => '<p>The meta data of the Glue table which serves as data catalog for the <code>OfflineStore</code>. </p>', 'refs' => [ 'OfflineStoreConfig$DataCatalogConfig' => '<p>The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created. </p>', ], ], 'DataDistributionType' => [ 'base' => NULL, 'refs' => [ 'DatasetDefinition$DataDistributionType' => '<p>Whether the generated dataset is <code>FullyReplicated</code> or <code>ShardedByS3Key</code> (default).</p>', ], ], 'DataExplorationNotebookLocation' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobArtifacts$DataExplorationNotebookLocation' => '<p>The URL of the notebook location.</p>', ], ], 'DataInputConfig' => [ 'base' => NULL, 'refs' => [ 'InputConfig$DataInputConfig' => '<p>Specifies the name and shape of the expected data inputs for your trained model with a JSON dictionary form. The data inputs are <a>InputConfig$Framework</a> specific. </p> <ul> <li> <p> <code>TensorFlow</code>: You must specify the name and shape (NHWC format) of the expected data inputs using a dictionary format for your trained model. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{"input":[1,1024,1024,3]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input\\":[1,1024,1024,3]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{"data1": [1,28,28,1], "data2":[1,28,28,1]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"data1\\": [1,28,28,1], \\"data2\\":[1,28,28,1]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>KERAS</code>: You must specify the name and shape (NCHW format) of expected data inputs using a dictionary format for your trained model. Note that while Keras model artifacts should be uploaded in NHWC (channel-last) format, <code>DataInputConfig</code> should be specified in NCHW (channel-first) format. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{"input_1":[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input_1\\":[1,3,224,224]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{"input_1": [1,3,224,224], "input_2":[1,3,224,224]} </code> </p> </li> <li> <p>If using the CLI, <code>{\\"input_1\\": [1,3,224,224], \\"input_2\\":[1,3,224,224]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>MXNET/ONNX/DARKNET</code>: You must specify the name and shape (NCHW format) of the expected data inputs in order using a dictionary format for your trained model. The dictionary formats required for the console and CLI are different.</p> <ul> <li> <p>Examples for one input:</p> <ul> <li> <p>If using the console, <code>{"data":[1,3,1024,1024]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"data\\":[1,3,1024,1024]}</code> </p> </li> </ul> </li> <li> <p>Examples for two inputs:</p> <ul> <li> <p>If using the console, <code>{"var1": [1,1,28,28], "var2":[1,1,28,28]} </code> </p> </li> <li> <p>If using the CLI, <code>{\\"var1\\": [1,1,28,28], \\"var2\\":[1,1,28,28]}</code> </p> </li> </ul> </li> </ul> </li> <li> <p> <code>PyTorch</code>: You can either specify the name and shape (NCHW format) of expected data inputs in order using a dictionary format for your trained model or you can specify the shape only using a list format. The dictionary formats required for the console and CLI are different. The list formats for the console and CLI are the same.</p> <ul> <li> <p>Examples for one input in dictionary format:</p> <ul> <li> <p>If using the console, <code>{"input0":[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input0\\":[1,3,224,224]}</code> </p> </li> </ul> </li> <li> <p>Example for one input in list format: <code>[[1,3,224,224]]</code> </p> </li> <li> <p>Examples for two inputs in dictionary format:</p> <ul> <li> <p>If using the console, <code>{"input0":[1,3,224,224], "input1":[1,3,224,224]}</code> </p> </li> <li> <p>If using the CLI, <code>{\\"input0\\":[1,3,224,224], \\"input1\\":[1,3,224,224]} </code> </p> </li> </ul> </li> <li> <p>Example for two inputs in list format: <code>[[1,3,224,224], [1,3,224,224]]</code> </p> </li> </ul> </li> <li> <p> <code>XGBOOST</code>: input data name and shape are not needed.</p> </li> </ul> <p> <code>DataInputConfig</code> supports the following parameters for <code>CoreML</code> <a>OutputConfig$TargetDevice</a> (ML Model format):</p> <ul> <li> <p> <code>shape</code>: Input shape, for example <code>{"input_1": {"shape": [1,224,224,3]}}</code>. In addition to static input shapes, CoreML converter supports Flexible input shapes:</p> <ul> <li> <p>Range Dimension. You can use the Range Dimension feature if you know the input shape will be within some specific interval in that dimension, for example: <code>{"input_1": {"shape": ["1..10", 224, 224, 3]}}</code> </p> </li> <li> <p>Enumerated shapes. Sometimes, the models are trained to work only on a select set of inputs. You can enumerate all supported input shapes, for example: <code>{"input_1": {"shape": [[1, 224, 224, 3], [1, 160, 160, 3]]}}</code> </p> </li> </ul> </li> <li> <p> <code>default_shape</code>: Default input shape. You can set a default shape during conversion for both Range Dimension and Enumerated Shapes. For example <code>{"input_1": {"shape": ["1..10", 224, 224, 3], "default_shape": [1, 224, 224, 3]}}</code> </p> </li> <li> <p> <code>type</code>: Input type. Allowed values: <code>Image</code> and <code>Tensor</code>. By default, the converter generates an ML Model with inputs of type Tensor (MultiArray). User can set input type to be Image. Image input type requires additional input parameters such as <code>bias</code> and <code>scale</code>.</p> </li> <li> <p> <code>bias</code>: If the input type is an Image, you need to provide the bias vector.</p> </li> <li> <p> <code>scale</code>: If the input type is an Image, you need to provide a scale factor.</p> </li> </ul> <p>CoreML <code>ClassifierConfig</code> parameters can be specified using <a>OutputConfig$CompilerOptions</a>. CoreML converter supports Tensorflow and PyTorch models. CoreML conversion examples:</p> <ul> <li> <p>Tensor type input:</p> <ul> <li> <p> <code>"DataInputConfig": {"input_1": {"shape": [[1,224,224,3], [1,160,160,3]], "default_shape": [1,224,224,3]}}</code> </p> </li> </ul> </li> <li> <p>Tensor type input without input name (PyTorch):</p> <ul> <li> <p> <code>"DataInputConfig": [{"shape": [[1,3,224,224], [1,3,160,160]], "default_shape": [1,3,224,224]}]</code> </p> </li> </ul> </li> <li> <p>Image type input:</p> <ul> <li> <p> <code>"DataInputConfig": {"input_1": {"shape": [[1,224,224,3], [1,160,160,3]], "default_shape": [1,224,224,3], "type": "Image", "bias": [-1,-1,-1], "scale": 0.007843137255}}</code> </p> </li> <li> <p> <code>"CompilerOptions": {"class_labels": "imagenet_labels_1000.txt"}</code> </p> </li> </ul> </li> <li> <p>Image type input without input name (PyTorch):</p> <ul> <li> <p> <code>"DataInputConfig": [{"shape": [[1,3,224,224], [1,3,160,160]], "default_shape": [1,3,224,224], "type": "Image", "bias": [-1,-1,-1], "scale": 0.007843137255}]</code> </p> </li> <li> <p> <code>"CompilerOptions": {"class_labels": "imagenet_labels_1000.txt"}</code> </p> </li> </ul> </li> </ul> <p>Depending on the model format, <code>DataInputConfig</code> requires the following parameters for <code>ml_eia2</code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-TargetDevice">OutputConfig:TargetDevice</a>.</p> <ul> <li> <p>For TensorFlow models saved in the SavedModel format, specify the input names from <code>signature_def_key</code> and the input model shapes for <code>DataInputConfig</code>. Specify the <code>signature_def_key</code> in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-CompilerOptions"> <code>OutputConfig:CompilerOptions</code> </a> if the model does not use TensorFlow\'s default signature def key. For example:</p> <ul> <li> <p> <code>"DataInputConfig": {"inputs": [1, 224, 224, 3]}</code> </p> </li> <li> <p> <code>"CompilerOptions": {"signature_def_key": "serving_custom"}</code> </p> </li> </ul> </li> <li> <p>For TensorFlow models saved as a frozen graph, specify the input tensor names and shapes in <code>DataInputConfig</code> and the output tensor names for <code>output_names</code> in <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-CompilerOptions"> <code>OutputConfig:CompilerOptions</code> </a>. For example:</p> <ul> <li> <p> <code>"DataInputConfig": {"input_tensor:0": [1, 224, 224, 3]}</code> </p> </li> <li> <p> <code>"CompilerOptions": {"output_names": ["output_tensor:0"]}</code> </p> </li> </ul> </li> </ul>', 'ModelInput$DataInputConfig' => '<p>The input configuration object for the model.</p>', ], ], 'DataProcessing' => [ 'base' => '<p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>', 'refs' => [ 'CreateTransformJobRequest$DataProcessing' => '<p>The data structure used to specify the data to be used for inference in a batch transform job and to associate the data that is relevant to the prediction results in the output. The input filter provided allows you to exclude input data that is not needed for inference in a batch transform job. The output filter provided allows you to include input data relevant to interpreting the predictions in the output from the job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html">Associate Prediction Results with their Corresponding Input Records</a>.</p>', 'DescribeTransformJobResponse$DataProcessing' => NULL, 'TransformJob$DataProcessing' => NULL, ], ], 'DataQualityAppSpecification' => [ 'base' => '<p>Information about the container that a data quality monitoring job runs.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$DataQualityAppSpecification' => '<p>Specifies the container that runs the monitoring job.</p>', 'DescribeDataQualityJobDefinitionResponse$DataQualityAppSpecification' => '<p>Information about the container that runs the data quality monitoring job.</p>', ], ], 'DataQualityBaselineConfig' => [ 'base' => '<p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$DataQualityBaselineConfig' => '<p>Configures the constraints and baselines for the monitoring job.</p>', 'DescribeDataQualityJobDefinitionResponse$DataQualityBaselineConfig' => '<p>The constraints and baselines for the data quality monitoring job definition.</p>', ], ], 'DataQualityJobInput' => [ 'base' => '<p>The input for the data quality monitoring job. Currently endpoints are supported for input.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$DataQualityJobInput' => '<p>A list of inputs for the monitoring job. Currently endpoints are supported as monitoring inputs.</p>', 'DescribeDataQualityJobDefinitionResponse$DataQualityJobInput' => '<p>The list of inputs for the data quality monitoring job. Currently endpoints are supported.</p>', ], ], 'DataSource' => [ 'base' => '<p>Describes the location of the channel data.</p>', 'refs' => [ 'Channel$DataSource' => '<p>The location of the channel data.</p>', ], ], 'Database' => [ 'base' => NULL, 'refs' => [ 'DataCatalogConfig$Database' => '<p>The name of the Glue table database.</p>', ], ], 'DatasetDefinition' => [ 'base' => '<p>Configuration for Dataset Definition inputs. The Dataset Definition input must specify exactly one of either <code>AthenaDatasetDefinition</code> or <code>RedshiftDatasetDefinition</code> types.</p>', 'refs' => [ 'ProcessingInput$DatasetDefinition' => '<p>Configuration for a Dataset Definition input. </p>', ], ], 'DebugHookConfig' => [ 'base' => '<p>Configuration information for the Debugger hook parameters, metric and tensor collections, and storage paths. To learn more about how to configure the <code>DebugHookConfig</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>', 'refs' => [ 'CreateTrainingJobRequest$DebugHookConfig' => NULL, 'DescribeTrainingJobResponse$DebugHookConfig' => NULL, 'TrainingJob$DebugHookConfig' => NULL, ], ], 'DebugRuleConfiguration' => [ 'base' => '<p>Configuration information for SageMaker Debugger rules for debugging. To learn more about how to configure the <code>DebugRuleConfiguration</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>.</p>', 'refs' => [ 'DebugRuleConfigurations$member' => NULL, ], ], 'DebugRuleConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$DebugRuleConfigurations' => '<p>Configuration information for Debugger rules for debugging output tensors.</p>', 'DescribeTrainingJobResponse$DebugRuleConfigurations' => '<p>Configuration information for Debugger rules for debugging output tensors.</p>', 'TrainingJob$DebugRuleConfigurations' => '<p>Information about the debug rule configuration.</p>', ], ], 'DebugRuleEvaluationStatus' => [ 'base' => '<p>Information about the status of the rule evaluation.</p>', 'refs' => [ 'DebugRuleEvaluationStatuses$member' => NULL, ], ], 'DebugRuleEvaluationStatuses' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$DebugRuleEvaluationStatuses' => '<p>Evaluation status of Debugger rules for debugging on a training job.</p>', 'TrainingJob$DebugRuleEvaluationStatuses' => '<p>Information about the evaluation status of the rules for the training job.</p>', ], ], 'DefaultGid' => [ 'base' => NULL, 'refs' => [ 'FileSystemConfig$DefaultGid' => '<p>The default POSIX group ID (GID). If not specified, defaults to <code>100</code>.</p>', ], ], 'DefaultUid' => [ 'base' => NULL, 'refs' => [ 'FileSystemConfig$DefaultUid' => '<p>The default POSIX user ID (UID). If not specified, defaults to <code>1000</code>.</p>', ], ], 'DeleteActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAlgorithmInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppImageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteArtifactResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContextRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContextResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDeviceFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFeatureGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFlowDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHumanTaskUiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHumanTaskUiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImageVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelBiasJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelExplainabilityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelPackageGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelPackageGroupPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioLifecycleConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeployedImage' => [ 'base' => '<p>Gets the Amazon EC2 Container Registry path of the docker image of the model that is hosted in this <a>ProductionVariant</a>.</p> <p>If you used the <code>registry/repository[:tag]</code> form to specify the image path of the primary container when you created the model hosted in this <code>ProductionVariant</code>, the path resolves to a path of the form <code>registry/repository[@digest]</code>. A digest is a hash value that identifies a specific version of an image. For information about Amazon ECR paths, see <a href="https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html">Pulling an Image</a> in the <i>Amazon ECR User Guide</i>.</p>', 'refs' => [ 'DeployedImages$member' => NULL, ], ], 'DeployedImages' => [ 'base' => NULL, 'refs' => [ 'PendingProductionVariantSummary$DeployedImages' => '<p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the inference images deployed on instances of this <code>ProductionVariant</code>.</p>', 'ProductionVariantSummary$DeployedImages' => '<p>An array of <code>DeployedImage</code> objects that specify the Amazon EC2 Container Registry paths of the inference images deployed on instances of this <code>ProductionVariant</code>.</p>', ], ], 'DeploymentConfig' => [ 'base' => '<p>The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.</p>', 'refs' => [ 'CreateEndpointInput$DeploymentConfig' => NULL, 'DescribeEndpointOutput$LastDeploymentConfig' => '<p>The most recent deployment configuration for the endpoint.</p>', 'UpdateEndpointInput$DeploymentConfig' => '<p>The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.</p>', ], ], 'DeregisterDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlgorithmInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlgorithmOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppImageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppImageConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeArtifactResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAutoMLJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCodeRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCompilationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCompilationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContextRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContextResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataQualityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceFleetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDeviceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEdgePackagingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEdgePackagingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeatureGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeatureGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFlowDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHumanTaskUiRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHumanTaskUiResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHyperParameterTuningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImageVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceRecommendationsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInferenceRecommendationsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLabelingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLineageGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLineageGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelBiasJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelBiasJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelExplainabilityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelExplainabilityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelQualityJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeModelQualityJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMonitoringScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceLifecycleConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineDefinitionForExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineDefinitionForExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProcessingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProcessingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeProjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStudioLifecycleConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStudioLifecycleConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscribedWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubscribedWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrainingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrainingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransformJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTransformJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupRequest$Description' => '<p>A free-form description of a <code>FeatureGroup</code>.</p>', 'DescribeFeatureGroupResponse$Description' => '<p>A free form description of the feature group.</p>', 'FeatureGroup$Description' => '<p>A free form description of a <code>FeatureGroup</code>.</p>', ], ], 'DesiredWeightAndCapacity' => [ 'base' => '<p>Specifies weight and capacity values for a production variant.</p>', 'refs' => [ 'DesiredWeightAndCapacityList$member' => NULL, ], ], 'DesiredWeightAndCapacityList' => [ 'base' => NULL, 'refs' => [ 'UpdateEndpointWeightsAndCapacitiesInput$DesiredWeightsAndCapacities' => '<p>An object that provides new capacity and weight values for a variant.</p>', ], ], 'DestinationS3Uri' => [ 'base' => NULL, 'refs' => [ 'AsyncInferenceOutputConfig$S3OutputPath' => '<p>The Amazon S3 location to upload inference responses to.</p>', 'DataCaptureConfig$DestinationS3Uri' => '<p/>', 'DataCaptureConfigSummary$DestinationS3Uri' => '<p/>', 'ProductionVariantCoreDumpConfig$DestinationS3Uri' => '<p>The Amazon S3 bucket to send the core dump to.</p>', ], ], 'DetailedAlgorithmStatus' => [ 'base' => NULL, 'refs' => [ 'AlgorithmStatusItem$Status' => '<p>The current status.</p>', ], ], 'DetailedModelPackageStatus' => [ 'base' => NULL, 'refs' => [ 'ModelPackageStatusItem$Status' => '<p>The current status.</p>', ], ], 'Device' => [ 'base' => '<p>Information of a particular device.</p>', 'refs' => [ 'Devices$member' => NULL, ], ], 'DeviceArn' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$DeviceArn' => '<p>The Amazon Resource Name (ARN) of the device.</p>', 'DeviceSummary$DeviceArn' => '<p>Amazon Resource Name (ARN) of the device.</p>', ], ], 'DeviceDescription' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$Description' => '<p>A description of the device.</p>', 'Device$Description' => '<p>Description of the device.</p>', 'DeviceSummary$Description' => '<p>A description of the device.</p>', ], ], 'DeviceFleetArn' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceFleetResponse$DeviceFleetArn' => '<p>The The Amazon Resource Name (ARN) of the fleet.</p>', 'DeviceFleetSummary$DeviceFleetArn' => '<p>Amazon Resource Name (ARN) of the device fleet.</p>', 'GetDeviceFleetReportResponse$DeviceFleetArn' => '<p>The Amazon Resource Name (ARN) of the device.</p>', ], ], 'DeviceFleetDescription' => [ 'base' => NULL, 'refs' => [ 'CreateDeviceFleetRequest$Description' => '<p>A description of the fleet.</p>', 'DescribeDeviceFleetResponse$Description' => '<p>A description of the fleet.</p>', 'GetDeviceFleetReportResponse$Description' => '<p>Description of the fleet.</p>', 'UpdateDeviceFleetRequest$Description' => '<p>Description of the fleet.</p>', ], ], 'DeviceFleetSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDeviceFleetsResponse$DeviceFleetSummaries' => '<p>Summary of the device fleet.</p>', ], ], 'DeviceFleetSummary' => [ 'base' => '<p>Summary of the device fleet.</p>', 'refs' => [ 'DeviceFleetSummaries$member' => NULL, ], ], 'DeviceName' => [ 'base' => NULL, 'refs' => [ 'Device$DeviceName' => '<p>The name of the device.</p>', 'DeviceNames$member' => NULL, ], ], 'DeviceNames' => [ 'base' => NULL, 'refs' => [ 'DeregisterDevicesRequest$DeviceNames' => '<p>The unique IDs of the devices.</p>', ], ], 'DeviceStats' => [ 'base' => '<p>Status of devices.</p>', 'refs' => [ 'GetDeviceFleetReportResponse$DeviceStats' => '<p>Status of devices.</p>', ], ], 'DeviceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDevicesResponse$DeviceSummaries' => '<p>Summary of devices.</p>', ], ], 'DeviceSummary' => [ 'base' => '<p>Summary of the device.</p>', 'refs' => [ 'DeviceSummaries$member' => NULL, ], ], 'Devices' => [ 'base' => NULL, 'refs' => [ 'RegisterDevicesRequest$Devices' => '<p>A list of devices to register with SageMaker Edge Manager.</p>', 'UpdateDevicesRequest$Devices' => '<p>List of devices to register with Edge Manager agent.</p>', ], ], 'DirectInternetAccess' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$DirectInternetAccess' => '<p>Sets whether Amazon SageMaker provides internet access to the notebook instance. If you set this to <code>Disabled</code> this notebook instance is able to access resources only in your VPC, and is not be able to connect to Amazon SageMaker training and endpoint services unless you configure a NAT Gateway in your VPC.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>. You can set the value of this parameter to <code>Disabled</code> only if you set a value for the <code>SubnetId</code> parameter.</p>', 'DescribeNotebookInstanceOutput$DirectInternetAccess' => '<p>Describes whether Amazon SageMaker provides internet access to the notebook instance. If this value is set to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to Amazon SageMaker training and endpoint services.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access">Notebook Instances Are Internet-Enabled by Default</a>.</p>', ], ], 'Direction' => [ 'base' => NULL, 'refs' => [ 'QueryLineageRequest$Direction' => '<p>Associations between lineage entities are directed. This parameter determines the direction from the StartArn(s) the query will look.</p>', ], ], 'DirectoryPath' => [ 'base' => NULL, 'refs' => [ 'CheckpointConfig$LocalPath' => '<p>(Optional) The local directory where checkpoints are written. The default directory is <code>/opt/ml/checkpoints/</code>. </p>', 'DebugHookConfig$LocalPath' => '<p>Path to local storage location for metrics and tensors. Defaults to <code>/opt/ml/output/tensors/</code>.</p>', 'DebugRuleConfiguration$LocalPath' => '<p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>.</p>', 'FileSystemDataSource$DirectoryPath' => '<p>The full path to the directory to associate with the channel.</p>', 'ProfilerRuleConfiguration$LocalPath' => '<p>Path to local storage location for output of rules. Defaults to <code>/opt/ml/processing/output/rule/</code>. </p>', 'TensorBoardOutputConfig$LocalPath' => '<p>Path to local storage location for tensorBoard output. Defaults to <code>/opt/ml/output/tensorboard</code>.</p>', ], ], 'DisableProfiler' => [ 'base' => NULL, 'refs' => [ 'ProfilerConfigForUpdate$DisableProfiler' => '<p>To disable Debugger monitoring and profiling, set to <code>True</code>.</p>', ], ], 'DisableSagemakerServicecatalogPortfolioInput' => [ 'base' => NULL, 'refs' => [], ], 'DisableSagemakerServicecatalogPortfolioOutput' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateAdditionalCodeRepositories' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateAdditionalCodeRepositories' => '<p>A list of names or URLs of the default Git repositories to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateDefaultCodeRepository' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateDefaultCodeRepository' => '<p>The name or URL of the default Git repository to remove from this notebook instance. This operation is idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateNotebookInstanceAcceleratorTypes' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateAcceleratorTypes' => '<p>A list of the Elastic Inference (EI) instance types to remove from this notebook instance. This operation is idempotent. If you specify an accelerator type that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateNotebookInstanceLifecycleConfig' => [ 'base' => NULL, 'refs' => [ 'UpdateNotebookInstanceInput$DisassociateLifecycleConfig' => '<p>Set to <code>true</code> to remove the notebook instance lifecycle configuration currently associated with the notebook instance. This operation is idempotent. If you specify a lifecycle configuration that is not associated with the notebook instance when you call this method, it does not throw an error.</p>', ], ], 'DisassociateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'Dollars' => [ 'base' => NULL, 'refs' => [ 'USD$Dollars' => '<p>The whole number of dollars in the amount.</p>', ], ], 'DomainArn' => [ 'base' => NULL, 'refs' => [ 'CreateDomainResponse$DomainArn' => '<p>The Amazon Resource Name (ARN) of the created domain.</p>', 'DescribeDomainResponse$DomainArn' => '<p>The domain\'s Amazon Resource Name (ARN).</p>', 'DomainDetails$DomainArn' => '<p>The domain\'s Amazon Resource Name (ARN).</p>', 'UpdateDomainResponse$DomainArn' => '<p>The Amazon Resource Name (ARN) of the domain.</p>', ], ], 'DomainDetails' => [ 'base' => '<p>The domain\'s details.</p>', 'refs' => [ 'DomainList$member' => NULL, ], ], 'DomainId' => [ 'base' => NULL, 'refs' => [ 'AppDetails$DomainId' => '<p>The domain ID.</p>', 'CreateAppRequest$DomainId' => '<p>The domain ID.</p>', 'CreatePresignedDomainUrlRequest$DomainId' => '<p>The domain ID.</p>', 'CreateUserProfileRequest$DomainId' => '<p>The ID of the associated Domain.</p>', 'DeleteAppRequest$DomainId' => '<p>The domain ID.</p>', 'DeleteDomainRequest$DomainId' => '<p>The domain ID.</p>', 'DeleteUserProfileRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeAppRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeAppResponse$DomainId' => '<p>The domain ID.</p>', 'DescribeDomainRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeDomainResponse$DomainId' => '<p>The domain ID.</p>', 'DescribeUserProfileRequest$DomainId' => '<p>The domain ID.</p>', 'DescribeUserProfileResponse$DomainId' => '<p>The ID of the domain that contains the profile.</p>', 'DomainDetails$DomainId' => '<p>The domain ID.</p>', 'ListAppsRequest$DomainIdEquals' => '<p>A parameter to search for the domain ID.</p>', 'ListUserProfilesRequest$DomainIdEquals' => '<p>A parameter by which to filter the results.</p>', 'UpdateDomainRequest$DomainId' => '<p>The ID of the domain to be updated.</p>', 'UpdateUserProfileRequest$DomainId' => '<p>The domain ID.</p>', 'UserProfileDetails$DomainId' => '<p>The domain ID.</p>', ], ], 'DomainList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsResponse$Domains' => '<p>The list of domains.</p>', ], ], 'DomainName' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$DomainName' => '<p>A name for the domain.</p>', 'DescribeDomainResponse$DomainName' => '<p>The domain name.</p>', 'DomainDetails$DomainName' => '<p>The domain name.</p>', ], ], 'DomainSecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'DomainSettings$SecurityGroupIds' => '<p>The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication between Domain-level apps and user apps.</p>', ], ], 'DomainSettings' => [ 'base' => '<p>A collection of settings that apply to the <code>SageMaker Domain</code>. These settings are specified through the <code>CreateDomain</code> API call.</p>', 'refs' => [ 'CreateDomainRequest$DomainSettings' => '<p>A collection of <code>Domain</code> settings.</p>', 'DescribeDomainResponse$DomainSettings' => '<p>A collection of <code>Domain</code> settings.</p>', ], ], 'DomainSettingsForUpdate' => [ 'base' => '<p>A collection of <code>Domain</code> configuration settings to update.</p>', 'refs' => [ 'UpdateDomainRequest$DomainSettingsForUpdate' => '<p>A collection of <code>DomainSettings</code> configuration values to update.</p>', ], ], 'DomainStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainResponse$Status' => '<p>The status.</p>', 'DomainDetails$Status' => '<p>The status.</p>', ], ], 'DoubleParameterValue' => [ 'base' => NULL, 'refs' => [ 'TrialComponentParameterValue$NumberValue' => '<p>The numeric value of a numeric hyperparameter. If you specify a value for this parameter, you can\'t specify the <code>StringValue</code> parameter.</p>', ], ], 'DriftCheckBaselines' => [ 'base' => '<p>Represents the drift check baselines that can be used when the model monitor is set using the model package. </p>', 'refs' => [ 'CreateModelPackageInput$DriftCheckBaselines' => '<p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'DescribeModelPackageOutput$DriftCheckBaselines' => '<p>Represents the drift check baselines that can be used when the model monitor is set using the model package. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-quality-clarify-baseline-lifecycle.html#pipelines-quality-clarify-baseline-drift-detection">Drift Detection against Previous Baselines in SageMaker Pipelines</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'ModelPackage$DriftCheckBaselines' => '<p>Represents the drift check baselines that can be used when the model monitor is set using the model package.</p>', ], ], 'DriftCheckBias' => [ 'base' => '<p>Represents the drift check bias baselines that can be used when the model monitor is set using the model package.</p>', 'refs' => [ 'DriftCheckBaselines$Bias' => '<p>Represents the drift check bias baselines that can be used when the model monitor is set using the model package. </p>', ], ], 'DriftCheckExplainability' => [ 'base' => '<p>Represents the drift check explainability baselines that can be used when the model monitor is set using the model package. </p>', 'refs' => [ 'DriftCheckBaselines$Explainability' => '<p>Represents the drift check explainability baselines that can be used when the model monitor is set using the model package. </p>', ], ], 'DriftCheckModelDataQuality' => [ 'base' => '<p>Represents the drift check data quality baselines that can be used when the model monitor is set using the model package. </p>', 'refs' => [ 'DriftCheckBaselines$ModelDataQuality' => '<p>Represents the drift check model data quality baselines that can be used when the model monitor is set using the model package.</p>', ], ], 'DriftCheckModelQuality' => [ 'base' => '<p>Represents the drift check model quality baselines that can be used when the model monitor is set using the model package. </p>', 'refs' => [ 'DriftCheckBaselines$ModelQuality' => '<p>Represents the drift check model quality baselines that can be used when the model monitor is set using the model package.</p>', ], ], 'EMRStepMetadata' => [ 'base' => '<p>The configurations and outcomes of an Amazon EMR step execution.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$EMR' => '<p>The configurations and outcomes of an EMR step execution.</p>', ], ], 'Edge' => [ 'base' => '<p>A directed edge connecting two lineage entities.</p>', 'refs' => [ 'Edges$member' => NULL, ], ], 'EdgeModel' => [ 'base' => '<p>The model on the edge device.</p>', 'refs' => [ 'EdgeModels$member' => NULL, ], ], 'EdgeModelStat' => [ 'base' => '<p>Status of edge devices with this model.</p>', 'refs' => [ 'EdgeModelStats$member' => NULL, ], ], 'EdgeModelStats' => [ 'base' => NULL, 'refs' => [ 'GetDeviceFleetReportResponse$ModelStats' => '<p>Status of model on device.</p>', ], ], 'EdgeModelSummaries' => [ 'base' => NULL, 'refs' => [ 'DeviceSummary$Models' => '<p>Models on the device.</p>', ], ], 'EdgeModelSummary' => [ 'base' => '<p>Summary of model on edge device.</p>', 'refs' => [ 'EdgeModelSummaries$member' => NULL, ], ], 'EdgeModels' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$Models' => '<p>Models on the device.</p>', ], ], 'EdgeOutputConfig' => [ 'base' => '<p>The output configuration.</p>', 'refs' => [ 'CreateDeviceFleetRequest$OutputConfig' => '<p>The output configuration for storing sample data collected by the fleet.</p>', 'CreateEdgePackagingJobRequest$OutputConfig' => '<p>Provides information about the output location for the packaged model.</p>', 'DescribeDeviceFleetResponse$OutputConfig' => '<p>The output configuration for storing sampled data.</p>', 'DescribeEdgePackagingJobResponse$OutputConfig' => '<p>The output configuration for the edge packaging job.</p>', 'GetDeviceFleetReportResponse$OutputConfig' => '<p>The output configuration for storing sample data collected by the fleet.</p>', 'UpdateDeviceFleetRequest$OutputConfig' => '<p>Output configuration for storing sample data collected by the fleet.</p>', ], ], 'EdgePackagingJobArn' => [ 'base' => NULL, 'refs' => [ 'DescribeEdgePackagingJobResponse$EdgePackagingJobArn' => '<p>The Amazon Resource Name (ARN) of the edge packaging job.</p>', 'EdgePackagingJobSummary$EdgePackagingJobArn' => '<p>The Amazon Resource Name (ARN) of the edge packaging job.</p>', ], ], 'EdgePackagingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeEdgePackagingJobResponse$EdgePackagingJobStatus' => '<p>The current status of the packaging job.</p>', 'EdgePackagingJobSummary$EdgePackagingJobStatus' => '<p>The status of the edge packaging job.</p>', 'ListEdgePackagingJobsRequest$StatusEquals' => '<p>The job status to filter for.</p>', ], ], 'EdgePackagingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEdgePackagingJobsResponse$EdgePackagingJobSummaries' => '<p>Summaries of edge packaging jobs.</p>', ], ], 'EdgePackagingJobSummary' => [ 'base' => '<p>Summary of edge packaging job.</p>', 'refs' => [ 'EdgePackagingJobSummaries$member' => NULL, ], ], 'EdgePresetDeploymentArtifact' => [ 'base' => NULL, 'refs' => [ 'EdgePresetDeploymentOutput$Artifact' => '<p>The Amazon Resource Name (ARN) of the generated deployable resource.</p>', ], ], 'EdgePresetDeploymentOutput' => [ 'base' => '<p>The output of a SageMaker Edge Manager deployable resource.</p>', 'refs' => [ 'DescribeEdgePackagingJobResponse$PresetDeploymentOutput' => '<p>The output of a SageMaker Edge Manager deployable resource.</p>', ], ], 'EdgePresetDeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'EdgePresetDeploymentOutput$Status' => '<p>The status of the deployable resource.</p>', ], ], 'EdgePresetDeploymentType' => [ 'base' => NULL, 'refs' => [ 'EdgeOutputConfig$PresetDeploymentType' => '<p>The deployment type SageMaker Edge Manager will create. Currently only supports Amazon Web Services IoT Greengrass Version 2 components.</p>', 'EdgePresetDeploymentOutput$Type' => '<p>The deployment type created by SageMaker Edge Manager. Currently only supports Amazon Web Services IoT Greengrass Version 2 components.</p>', ], ], 'EdgeVersion' => [ 'base' => NULL, 'refs' => [ 'AgentVersion$Version' => '<p>Version of the agent.</p>', 'CreateEdgePackagingJobRequest$ModelVersion' => '<p>The version of the model.</p>', 'DescribeDeviceResponse$AgentVersion' => '<p>Edge Manager agent version.</p>', 'DescribeEdgePackagingJobResponse$ModelVersion' => '<p>The version of the model.</p>', 'DeviceSummary$AgentVersion' => '<p>Edge Manager agent version.</p>', 'EdgeModel$ModelVersion' => '<p>The model version.</p>', 'EdgeModelStat$ModelVersion' => '<p>The model version.</p>', 'EdgeModelSummary$ModelVersion' => '<p>The version model.</p>', 'EdgePackagingJobSummary$ModelVersion' => '<p>The version of the model.</p>', ], ], 'Edges' => [ 'base' => NULL, 'refs' => [ 'QueryLineageResponse$Edges' => '<p>A list of edges that connect vertices in the response.</p>', ], ], 'EfsUid' => [ 'base' => NULL, 'refs' => [ 'DescribeUserProfileResponse$HomeEfsFileSystemUid' => '<p>The ID of the user\'s profile in the Amazon Elastic File System (EFS) volume.</p>', ], ], 'EnableCapture' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfig$EnableCapture' => '<p/>', 'DataCaptureConfigSummary$EnableCapture' => '<p/>', ], ], 'EnableIotRoleAlias' => [ 'base' => NULL, 'refs' => [ 'CreateDeviceFleetRequest$EnableIotRoleAlias' => '<p>Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p> <p>For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".</p>', 'UpdateDeviceFleetRequest$EnableIotRoleAlias' => '<p>Whether to create an Amazon Web Services IoT Role Alias during device fleet creation. The name of the role alias generated will match this pattern: "SageMakerEdge-{DeviceFleetName}".</p> <p>For example, if your device fleet is called "demo-fleet", the name of the role alias will be "SageMakerEdge-demo-fleet".</p>', ], ], 'EnableSagemakerServicecatalogPortfolioInput' => [ 'base' => NULL, 'refs' => [], ], 'EnableSagemakerServicecatalogPortfolioOutput' => [ 'base' => NULL, 'refs' => [], ], 'Endpoint' => [ 'base' => '<p>A hosted endpoint for real-time inference.</p>', 'refs' => [ 'SearchRecord$Endpoint' => NULL, ], ], 'EndpointArn' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'DescribeEndpointOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'Endpoint$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'EndpointSummary$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'UpdateEndpointOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the endpoint.</p>', 'UpdateEndpointWeightsAndCapacitiesOutput$EndpointArn' => '<p>The Amazon Resource Name (ARN) of the updated endpoint.</p>', ], ], 'EndpointConfigArn' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointConfigOutput$EndpointConfigArn' => '<p>The Amazon Resource Name (ARN) of the endpoint configuration. </p>', 'DescribeEndpointConfigOutput$EndpointConfigArn' => '<p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>', 'EndpointConfigSummary$EndpointConfigArn' => '<p>The Amazon Resource Name (ARN) of the endpoint configuration.</p>', ], ], 'EndpointConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointConfigInput$EndpointConfigName' => '<p>The name of the endpoint configuration. You specify this name in a <a>CreateEndpoint</a> request. </p>', 'CreateEndpointInput$EndpointConfigName' => '<p>The name of an endpoint configuration. For more information, see <a>CreateEndpointConfig</a>. </p>', 'DeleteEndpointConfigInput$EndpointConfigName' => '<p>The name of the endpoint configuration that you want to delete.</p>', 'DescribeEndpointConfigInput$EndpointConfigName' => '<p>The name of the endpoint configuration.</p>', 'DescribeEndpointConfigOutput$EndpointConfigName' => '<p>Name of the Amazon SageMaker endpoint configuration.</p>', 'DescribeEndpointOutput$EndpointConfigName' => '<p>The name of the endpoint configuration associated with this endpoint.</p>', 'Endpoint$EndpointConfigName' => '<p>The endpoint configuration associated with the endpoint.</p>', 'EndpointConfigSummary$EndpointConfigName' => '<p>The name of the endpoint configuration.</p>', 'PendingDeploymentSummary$EndpointConfigName' => '<p>The name of the endpoint configuration used in the deployment. </p>', 'UpdateEndpointInput$EndpointConfigName' => '<p>The name of the new endpoint configuration.</p>', ], ], 'EndpointConfigNameContains' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$NameContains' => '<p>A string in the endpoint configuration name. This filter returns only endpoint configurations whose name contains the specified string. </p>', ], ], 'EndpointConfigSortKey' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'EndpointConfigSummary' => [ 'base' => '<p>Provides summary information for an endpoint configuration.</p>', 'refs' => [ 'EndpointConfigSummaryList$member' => NULL, ], ], 'EndpointConfigSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsOutput$EndpointConfigs' => '<p>An array of endpoint configurations.</p>', ], ], 'EndpointInput' => [ 'base' => '<p>Input object for the endpoint</p>', 'refs' => [ 'DataQualityJobInput$EndpointInput' => NULL, 'ModelBiasJobInput$EndpointInput' => NULL, 'ModelExplainabilityJobInput$EndpointInput' => NULL, 'ModelQualityJobInput$EndpointInput' => NULL, 'MonitoringInput$EndpointInput' => '<p>The endpoint for a monitoring job.</p>', ], ], 'EndpointInputConfiguration' => [ 'base' => '<p>The endpoint configuration for the load test.</p>', 'refs' => [ 'EndpointInputConfigurations$member' => NULL, ], ], 'EndpointInputConfigurations' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobInputConfig$EndpointConfigurations' => '<p>Specifies the endpoint configuration to use for a job.</p>', ], ], 'EndpointName' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointInput$EndpointName' => '<p>The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web Services account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is preserved and must be matched in .</p>', 'DeleteEndpointInput$EndpointName' => '<p>The name of the endpoint that you want to delete.</p>', 'DescribeEndpointInput$EndpointName' => '<p>The name of the endpoint.</p>', 'DescribeEndpointOutput$EndpointName' => '<p>Name of the endpoint.</p>', 'DescribeMonitoringScheduleResponse$EndpointName' => '<p> The name of the endpoint for the monitoring job.</p>', 'Endpoint$EndpointName' => '<p>The name of the endpoint.</p>', 'EndpointInput$EndpointName' => '<p>An endpoint in customer\'s account which has enabled <code>DataCaptureConfig</code> enabled.</p>', 'EndpointSummary$EndpointName' => '<p>The name of the endpoint.</p>', 'ListDataQualityJobDefinitionsRequest$EndpointName' => '<p>A filter that lists the data quality job definitions associated with the specified endpoint.</p>', 'ListModelBiasJobDefinitionsRequest$EndpointName' => '<p>Name of the endpoint to monitor for model bias.</p>', 'ListModelExplainabilityJobDefinitionsRequest$EndpointName' => '<p>Name of the endpoint to monitor for model explainability.</p>', 'ListModelQualityJobDefinitionsRequest$EndpointName' => '<p>A filter that returns only model quality monitoring job definitions that are associated with the specified endpoint.</p>', 'ListMonitoringExecutionsRequest$EndpointName' => '<p>Name of a specific endpoint to fetch jobs for.</p>', 'ListMonitoringSchedulesRequest$EndpointName' => '<p>Name of a specific endpoint to fetch schedules for.</p>', 'ModelDeployConfig$EndpointName' => '<p>Specifies the endpoint name to use for a one-click Autopilot model deployment if the endpoint name is not generated automatically.</p> <note> <p>Specify the <code>EndpointName</code> if and only if you set <code>AutoGenerateEndpointName</code> to <code>False</code>; otherwise a 400 error is thrown.</p> </note>', 'ModelDeployResult$EndpointName' => '<p>The name of the endpoint to which the model has been deployed.</p> <note> <p>If model deployment fails, this field is omitted from the response.</p> </note>', 'MonitoringExecutionSummary$EndpointName' => '<p>The name of the endpoint used to run the monitoring job.</p>', 'MonitoringJobDefinitionSummary$EndpointName' => '<p>The name of the endpoint that the job monitors.</p>', 'MonitoringSchedule$EndpointName' => '<p>The endpoint that hosts the model being monitored.</p>', 'MonitoringScheduleSummary$EndpointName' => '<p>The name of the endpoint using the monitoring schedule.</p>', 'UpdateEndpointInput$EndpointName' => '<p>The name of the endpoint whose configuration you want to update.</p>', 'UpdateEndpointWeightsAndCapacitiesInput$EndpointName' => '<p>The name of an existing Amazon SageMaker endpoint.</p>', ], ], 'EndpointNameContains' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsInput$NameContains' => '<p>A string in endpoint names. This filter returns only endpoints whose name contains the specified string.</p>', ], ], 'EndpointOutputConfiguration' => [ 'base' => '<p>The endpoint configuration made by Inference Recommender during a recommendation job.</p>', 'refs' => [ 'InferenceRecommendation$EndpointConfiguration' => '<p>Defines the endpoint configuration parameters.</p>', ], ], 'EndpointSortKey' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsInput$SortBy' => '<p>Sorts the list of results. The default is <code>CreationTime</code>.</p>', ], ], 'EndpointStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointOutput$EndpointStatus' => '<p>The status of the endpoint.</p> <ul> <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li> <li> <p> <code>Creating</code>: <a>CreateEndpoint</a> is executing.</p> </li> <li> <p> <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.</p> </li> <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li> <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.</p> </li> <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li> <li> <p> <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.</p> </li> <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the only operation that can be performed on a failed endpoint.</p> </li> </ul>', 'Endpoint$EndpointStatus' => '<p>The status of the endpoint.</p>', 'EndpointSummary$EndpointStatus' => '<p>The status of the endpoint.</p> <ul> <li> <p> <code>OutOfService</code>: Endpoint is not available to take incoming requests.</p> </li> <li> <p> <code>Creating</code>: <a>CreateEndpoint</a> is executing.</p> </li> <li> <p> <code>Updating</code>: <a>UpdateEndpoint</a> or <a>UpdateEndpointWeightsAndCapacities</a> is executing.</p> </li> <li> <p> <code>SystemUpdating</code>: Endpoint is undergoing maintenance and cannot be updated or deleted or re-scaled until it has completed. This maintenance operation does not change any customer-specified values such as VPC config, KMS encryption, model, instance type, or instance count.</p> </li> <li> <p> <code>RollingBack</code>: Endpoint fails to scale up or down or change its variant weight and is in the process of rolling back to its previous configuration. Once the rollback completes, endpoint returns to an <code>InService</code> status. This transitional status only applies to an endpoint that has autoscaling enabled and is undergoing variant weight or capacity changes as part of an <a>UpdateEndpointWeightsAndCapacities</a> call or when the <a>UpdateEndpointWeightsAndCapacities</a> operation is called explicitly.</p> </li> <li> <p> <code>InService</code>: Endpoint is available to process incoming requests.</p> </li> <li> <p> <code>Deleting</code>: <a>DeleteEndpoint</a> is executing.</p> </li> <li> <p> <code>Failed</code>: Endpoint could not be created, updated, or re-scaled. Use <a>DescribeEndpointOutput$FailureReason</a> for information about the failure. <a>DeleteEndpoint</a> is the only operation that can be performed on a failed endpoint.</p> </li> </ul> <p>To get a list of endpoints with a specified status, use the <a>ListEndpointsInput$StatusEquals</a> filter.</p>', 'ListEndpointsInput$StatusEquals' => '<p> A filter that returns only endpoints with the specified status.</p>', ], ], 'EndpointSummary' => [ 'base' => '<p>Provides summary information for an endpoint.</p>', 'refs' => [ 'EndpointSummaryList$member' => NULL, ], ], 'EndpointSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEndpointsOutput$Endpoints' => '<p> An array or endpoint objects. </p>', ], ], 'EntityDescription' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$Description' => '<p>A description of the additional Inference specification</p>', 'AlgorithmSummary$AlgorithmDescription' => '<p>A brief description of the algorithm.</p>', 'BatchDescribeModelPackageSummary$ModelPackageDescription' => '<p>The description of the model package.</p>', 'ChannelSpecification$Description' => '<p>A brief description of the channel.</p>', 'CreateAlgorithmInput$AlgorithmDescription' => '<p>A description of the algorithm.</p>', 'CreateModelPackageGroupInput$ModelPackageGroupDescription' => '<p>A description for the model group.</p>', 'CreateModelPackageInput$ModelPackageDescription' => '<p>A description of the model package.</p>', 'CreateProjectInput$ProjectDescription' => '<p>A description for the project.</p>', 'DescribeAlgorithmOutput$AlgorithmDescription' => '<p>A brief summary about the algorithm.</p>', 'DescribeModelPackageGroupOutput$ModelPackageGroupDescription' => '<p>A description of the model group.</p>', 'DescribeModelPackageOutput$ModelPackageDescription' => '<p>A brief summary of the model package.</p>', 'DescribeProjectOutput$ProjectDescription' => '<p>The description of the project.</p>', 'HyperParameterSpecification$Description' => '<p>A brief description of the hyperparameter.</p>', 'ModelPackage$ModelPackageDescription' => '<p>The description of the model package.</p>', 'ModelPackageGroup$ModelPackageGroupDescription' => '<p>The description for the model group.</p>', 'ModelPackageGroupSummary$ModelPackageGroupDescription' => '<p>A description of the model group.</p>', 'ModelPackageSummary$ModelPackageDescription' => '<p>A brief description of the model package.</p>', 'Project$ProjectDescription' => '<p>The description of the project.</p>', 'ProjectSummary$ProjectDescription' => '<p>The description of the project.</p>', 'UpdateProjectInput$ProjectDescription' => '<p>The description for the project.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$Name' => '<p>A unique name to identify the additional inference specification. The name must be unique within the list of your additional inference specifications for a particular model package.</p>', 'AlgorithmStatusItem$Name' => '<p>The name of the algorithm for which the overall status is being reported.</p>', 'AlgorithmSummary$AlgorithmName' => '<p>The name of the algorithm that is described by the summary.</p>', 'AlgorithmValidationProfile$ProfileName' => '<p>The name of the profile for the algorithm. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', 'BatchDescribeModelPackageSummary$ModelPackageGroupName' => '<p>The group name for the model package</p>', 'CodeRepositorySummary$CodeRepositoryName' => '<p>The name of the Git repository.</p>', 'CompilationJobSummary$CompilationJobName' => '<p>The name of the model compilation job that you want a summary for.</p>', 'CreateAlgorithmInput$AlgorithmName' => '<p>The name of the algorithm.</p>', 'CreateCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', 'CreateCompilationJobRequest$CompilationJobName' => '<p>A name for the model compilation job. The name must be unique within the Amazon Web Services Region and within your Amazon Web Services account. </p>', 'CreateDeviceFleetRequest$DeviceFleetName' => '<p>The name of the fleet that the device belongs to.</p>', 'CreateEdgePackagingJobRequest$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'CreateEdgePackagingJobRequest$CompilationJobName' => '<p>The name of the SageMaker Neo compilation job that will be used to locate model artifacts for packaging.</p>', 'CreateEdgePackagingJobRequest$ModelName' => '<p>The name of the model.</p>', 'CreateModelPackageGroupInput$ModelPackageGroupName' => '<p>The name of the model group.</p>', 'CreateModelPackageInput$ModelPackageName' => '<p>The name of the model package. The name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p> <p>This parameter is required for unversioned models. It is not applicable to versioned models.</p>', 'DeleteAlgorithmInput$AlgorithmName' => '<p>The name of the algorithm to delete.</p>', 'DeleteCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository to delete.</p>', 'DeleteDeviceFleetRequest$DeviceFleetName' => '<p>The name of the fleet to delete.</p>', 'DeleteModelPackageGroupPolicyInput$ModelPackageGroupName' => '<p>The name of the model group for which to delete the policy.</p>', 'DeregisterDevicesRequest$DeviceFleetName' => '<p>The name of the fleet the devices belong to.</p>', 'DescribeAlgorithmOutput$AlgorithmName' => '<p>The name of the algorithm being described.</p>', 'DescribeCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository to describe.</p>', 'DescribeCodeRepositoryOutput$CodeRepositoryName' => '<p>The name of the Git repository.</p>', 'DescribeCompilationJobRequest$CompilationJobName' => '<p>The name of the model compilation job that you want information about.</p>', 'DescribeCompilationJobResponse$CompilationJobName' => '<p>The name of the model compilation job.</p>', 'DescribeDeviceFleetRequest$DeviceFleetName' => '<p>The name of the fleet.</p>', 'DescribeDeviceFleetResponse$DeviceFleetName' => '<p>The name of the fleet.</p>', 'DescribeDeviceRequest$DeviceName' => '<p>The unique ID of the device.</p>', 'DescribeDeviceRequest$DeviceFleetName' => '<p>The name of the fleet the devices belong to.</p>', 'DescribeDeviceResponse$DeviceName' => '<p>The unique identifier of the device.</p>', 'DescribeDeviceResponse$DeviceFleetName' => '<p>The name of the fleet the device belongs to.</p>', 'DescribeEdgePackagingJobRequest$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'DescribeEdgePackagingJobResponse$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'DescribeEdgePackagingJobResponse$CompilationJobName' => '<p>The name of the SageMaker Neo compilation job that is used to locate model artifacts that are being packaged.</p>', 'DescribeEdgePackagingJobResponse$ModelName' => '<p>The name of the model.</p>', 'DescribeModelPackageGroupOutput$ModelPackageGroupName' => '<p>The name of the model group.</p>', 'DescribeModelPackageOutput$ModelPackageName' => '<p>The name of the model package being described.</p>', 'DescribeModelPackageOutput$ModelPackageGroupName' => '<p>If the model is a versioned model, the name of the model group that the versioned model belongs to.</p>', 'DeviceFleetSummary$DeviceFleetName' => '<p>Name of the device fleet.</p>', 'DeviceSummary$DeviceName' => '<p>The unique identifier of the device.</p>', 'DeviceSummary$DeviceFleetName' => '<p>The name of the fleet the device belongs to.</p>', 'EdgeModel$ModelName' => '<p>The name of the model.</p>', 'EdgeModelStat$ModelName' => '<p>The name of the model.</p>', 'EdgeModelSummary$ModelName' => '<p>The name of the model.</p>', 'EdgePackagingJobSummary$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'EdgePackagingJobSummary$CompilationJobName' => '<p>The name of the SageMaker Neo compilation job.</p>', 'EdgePackagingJobSummary$ModelName' => '<p>The name of the model.</p>', 'GetDeviceFleetReportRequest$DeviceFleetName' => '<p>The name of the fleet.</p>', 'GetDeviceFleetReportResponse$DeviceFleetName' => '<p>The name of the fleet.</p>', 'GetModelPackageGroupPolicyInput$ModelPackageGroupName' => '<p>The name of the model group for which to get the resource policy.</p>', 'ListDevicesRequest$ModelName' => '<p>A filter that searches devices that contains this name in any of their models.</p>', 'ListDevicesRequest$DeviceFleetName' => '<p>Filter for fleets containing this name in their device fleet name.</p>', 'ModelPackage$ModelPackageName' => '<p>The name of the model.</p>', 'ModelPackage$ModelPackageGroupName' => '<p>The model group to which the model belongs.</p>', 'ModelPackageGroup$ModelPackageGroupName' => '<p>The name of the model group.</p>', 'ModelPackageGroupSummary$ModelPackageGroupName' => '<p>The name of the model group.</p>', 'ModelPackageStatusItem$Name' => '<p>The name of the model package for which the overall status is being reported.</p>', 'ModelPackageSummary$ModelPackageName' => '<p>The name of the model package.</p>', 'ModelPackageSummary$ModelPackageGroupName' => '<p>If the model package is a versioned model, the model group that the versioned model belongs to.</p>', 'ModelPackageValidationProfile$ProfileName' => '<p>The name of the profile for the model package.</p>', 'PutModelPackageGroupPolicyInput$ModelPackageGroupName' => '<p>The name of the model group to add a resource policy to.</p>', 'RegisterDevicesRequest$DeviceFleetName' => '<p>The name of the fleet.</p>', 'StopCompilationJobRequest$CompilationJobName' => '<p>The name of the model compilation job to stop.</p>', 'StopEdgePackagingJobRequest$EdgePackagingJobName' => '<p>The name of the edge packaging job.</p>', 'UpdateCodeRepositoryInput$CodeRepositoryName' => '<p>The name of the Git repository to update.</p>', 'UpdateDeviceFleetRequest$DeviceFleetName' => '<p>The name of the fleet.</p>', 'UpdateDevicesRequest$DeviceFleetName' => '<p>The name of the fleet the devices belong to.</p>', ], ], 'EnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'EnvironmentMap$key' => NULL, ], ], 'EnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'AutoMLContainerDefinition$Environment' => '<p>The environment variables to set in the container. For more information, see .</p>', 'ContainerDefinition$Environment' => '<p>The environment variables to set in the Docker container. Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map. </p>', 'ModelPackageContainerDefinition$Environment' => '<p>The environment variables to set in the Docker container. Each key and value in the <code>Environment</code> string to string map can have length of up to 1024. We support up to 16 entries in the map.</p>', ], ], 'EnvironmentParameter' => [ 'base' => '<p>A list of environment parameters suggested by the Amazon SageMaker Inference Recommender.</p>', 'refs' => [ 'EnvironmentParameters$member' => NULL, ], ], 'EnvironmentParameterRanges' => [ 'base' => '<p>Specifies the range of environment parameters</p>', 'refs' => [ 'EndpointInputConfiguration$EnvironmentParameterRanges' => '<p> The parameter you want to benchmark against.</p>', ], ], 'EnvironmentParameters' => [ 'base' => NULL, 'refs' => [ 'ModelConfiguration$EnvironmentParameters' => '<p>Defines the environment parameters that includes key, value types, and values.</p>', ], ], 'EnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'EnvironmentMap$value' => NULL, ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringExecutionsRequest$StatusEquals' => '<p>A filter that retrieves only jobs with a specific status.</p>', 'MonitoringExecutionSummary$MonitoringExecutionStatus' => '<p>The status of the monitoring job.</p>', ], ], 'ExitMessage' => [ 'base' => NULL, 'refs' => [ 'DescribeProcessingJobResponse$ExitMessage' => '<p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>', 'ProcessingJob$ExitMessage' => '<p>A string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>', 'ProcessingJobSummary$ExitMessage' => '<p>An optional string, up to one KB in size, that contains metadata from the processing container when the processing job exits.</p>', ], ], 'Experiment' => [ 'base' => '<p>The properties of an experiment as returned by the <a>Search</a> API.</p>', 'refs' => [ 'SearchRecord$Experiment' => '<p>The properties of an experiment.</p>', ], ], 'ExperimentArn' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'DeleteExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment that is being deleted.</p>', 'DescribeExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'Experiment$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'ExperimentSummary$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'UpdateExperimentResponse$ExperimentArn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', ], ], 'ExperimentConfig' => [ 'base' => '<p>Associates a SageMaker job as a trial component with an experiment and trial. Specified when you call the following APIs:</p> <ul> <li> <p> <a>CreateProcessingJob</a> </p> </li> <li> <p> <a>CreateTrainingJob</a> </p> </li> <li> <p> <a>CreateTransformJob</a> </p> </li> </ul>', 'refs' => [ 'CreateProcessingJobRequest$ExperimentConfig' => NULL, 'CreateTrainingJobRequest$ExperimentConfig' => NULL, 'CreateTransformJobRequest$ExperimentConfig' => NULL, 'DescribeProcessingJobResponse$ExperimentConfig' => '<p>The configuration information used to create an experiment.</p>', 'DescribeTrainingJobResponse$ExperimentConfig' => NULL, 'DescribeTransformJobResponse$ExperimentConfig' => NULL, 'ProcessingJob$ExperimentConfig' => NULL, 'TrainingJob$ExperimentConfig' => NULL, 'TransformJob$ExperimentConfig' => NULL, ], ], 'ExperimentDescription' => [ 'base' => NULL, 'refs' => [ 'CreateActionRequest$Description' => '<p>The description of the action.</p>', 'CreateContextRequest$Description' => '<p>The description of the context.</p>', 'CreateExperimentRequest$Description' => '<p>The description of the experiment.</p>', 'DescribeActionResponse$Description' => '<p>The description of the action.</p>', 'DescribeContextResponse$Description' => '<p>The description of the context.</p>', 'DescribeExperimentResponse$Description' => '<p>The description of the experiment.</p>', 'DescribeLineageGroupResponse$Description' => '<p>The description of the lineage group.</p>', 'Experiment$Description' => '<p>The description of the experiment.</p>', 'UpdateActionRequest$Description' => '<p>The new description for the action.</p>', 'UpdateContextRequest$Description' => '<p>The new description for the context.</p>', 'UpdateExperimentRequest$Description' => '<p>The description of the experiment.</p>', ], ], 'ExperimentEntityName' => [ 'base' => NULL, 'refs' => [ 'ActionSummary$ActionName' => '<p>The name of the action.</p>', 'ArtifactSummary$ArtifactName' => '<p>The name of the artifact.</p>', 'AssociateTrialComponentRequest$TrialComponentName' => '<p>The name of the component to associated with the trial.</p>', 'AssociateTrialComponentRequest$TrialName' => '<p>The name of the trial to associate with.</p>', 'AssociationSummary$SourceName' => '<p>The name of the source.</p>', 'AssociationSummary$DestinationName' => '<p>The name of the destination.</p>', 'ContextSummary$ContextName' => '<p>The name of the context.</p>', 'CreateActionRequest$ActionName' => '<p>The name of the action. Must be unique to your account in an Amazon Web Services Region.</p>', 'CreateArtifactRequest$ArtifactName' => '<p>The name of the artifact. Must be unique to your account in an Amazon Web Services Region.</p>', 'CreateContextRequest$ContextName' => '<p>The name of the context. Must be unique to your account in an Amazon Web Services Region.</p>', 'CreateExperimentRequest$ExperimentName' => '<p>The name of the experiment. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>', 'CreateExperimentRequest$DisplayName' => '<p>The name of the experiment as displayed. The name doesn\'t need to be unique. If you don\'t specify <code>DisplayName</code>, the value in <code>ExperimentName</code> is displayed.</p>', 'CreateTrialComponentRequest$TrialComponentName' => '<p>The name of the component. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>', 'CreateTrialComponentRequest$DisplayName' => '<p>The name of the component as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'CreateTrialRequest$TrialName' => '<p>The name of the trial. The name must be unique in your Amazon Web Services account and is not case-sensitive.</p>', 'CreateTrialRequest$DisplayName' => '<p>The name of the trial as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'CreateTrialRequest$ExperimentName' => '<p>The name of the experiment to associate the trial with.</p>', 'DeleteActionRequest$ActionName' => '<p>The name of the action to delete.</p>', 'DeleteContextRequest$ContextName' => '<p>The name of the context to delete.</p>', 'DeleteExperimentRequest$ExperimentName' => '<p>The name of the experiment to delete.</p>', 'DeleteTrialComponentRequest$TrialComponentName' => '<p>The name of the component to delete.</p>', 'DeleteTrialRequest$TrialName' => '<p>The name of the trial to delete.</p>', 'DescribeActionRequest$ActionName' => '<p>The name of the action to describe.</p>', 'DescribeContextResponse$ContextName' => '<p>The name of the context.</p>', 'DescribeExperimentRequest$ExperimentName' => '<p>The name of the experiment to describe.</p>', 'DescribeExperimentResponse$ExperimentName' => '<p>The name of the experiment.</p>', 'DescribeExperimentResponse$DisplayName' => '<p>The name of the experiment as displayed. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'DescribeLineageGroupRequest$LineageGroupName' => '<p>The name of the lineage group.</p>', 'DescribeLineageGroupResponse$LineageGroupName' => '<p>The name of the lineage group.</p>', 'DescribeLineageGroupResponse$DisplayName' => '<p>The display name of the lineage group.</p>', 'DescribeTrialComponentResponse$TrialComponentName' => '<p>The name of the trial component.</p>', 'DescribeTrialComponentResponse$DisplayName' => '<p>The name of the component as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'DescribeTrialRequest$TrialName' => '<p>The name of the trial to describe.</p>', 'DescribeTrialResponse$TrialName' => '<p>The name of the trial.</p>', 'DescribeTrialResponse$DisplayName' => '<p>The name of the trial as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'DescribeTrialResponse$ExperimentName' => '<p>The name of the experiment the trial is part of.</p>', 'DisassociateTrialComponentRequest$TrialComponentName' => '<p>The name of the component to disassociate from the trial.</p>', 'DisassociateTrialComponentRequest$TrialName' => '<p>The name of the trial to disassociate from.</p>', 'Experiment$ExperimentName' => '<p>The name of the experiment.</p>', 'Experiment$DisplayName' => '<p>The name of the experiment as displayed. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'ExperimentConfig$ExperimentName' => '<p>The name of an existing experiment to associate the trial component with.</p>', 'ExperimentConfig$TrialName' => '<p>The name of an existing trial to associate the trial component with. If not specified, a new trial is created.</p>', 'ExperimentConfig$TrialComponentDisplayName' => '<p>The display name for the trial component. If this key isn\'t specified, the display name is the trial component name.</p>', 'ExperimentSummary$ExperimentName' => '<p>The name of the experiment.</p>', 'ExperimentSummary$DisplayName' => '<p>The name of the experiment as displayed. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'LineageGroupSummary$LineageGroupName' => '<p>The name or Amazon Resource Name (ARN) of the lineage group.</p>', 'LineageGroupSummary$DisplayName' => '<p>The display name of the lineage group summary.</p>', 'ListTrialComponentsRequest$ExperimentName' => '<p>A filter that returns only components that are part of the specified experiment. If you specify <code>ExperimentName</code>, you can\'t filter by <code>SourceArn</code> or <code>TrialName</code>.</p>', 'ListTrialComponentsRequest$TrialName' => '<p>A filter that returns only components that are part of the specified trial. If you specify <code>TrialName</code>, you can\'t filter by <code>ExperimentName</code> or <code>SourceArn</code>.</p>', 'ListTrialsRequest$ExperimentName' => '<p>A filter that returns only trials that are part of the specified experiment.</p>', 'ListTrialsRequest$TrialComponentName' => '<p>A filter that returns only trials that are associated with the specified trial component.</p>', 'Parent$TrialName' => '<p>The name of the trial.</p>', 'Parent$ExperimentName' => '<p>The name of the experiment.</p>', 'PipelineExperimentConfig$ExperimentName' => '<p>The name of the experiment.</p>', 'PipelineExperimentConfig$TrialName' => '<p>The name of the trial.</p>', 'Trial$TrialName' => '<p>The name of the trial.</p>', 'Trial$DisplayName' => '<p>The name of the trial as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'Trial$ExperimentName' => '<p>The name of the experiment the trial is part of.</p>', 'TrialComponent$TrialComponentName' => '<p>The name of the trial component.</p>', 'TrialComponent$DisplayName' => '<p>The name of the component as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'TrialComponentSimpleSummary$TrialComponentName' => '<p>The name of the trial component.</p>', 'TrialComponentSummary$TrialComponentName' => '<p>The name of the trial component.</p>', 'TrialComponentSummary$DisplayName' => '<p>The name of the component as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'TrialSummary$TrialName' => '<p>The name of the trial.</p>', 'TrialSummary$DisplayName' => '<p>The name of the trial as displayed. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', 'UpdateActionRequest$ActionName' => '<p>The name of the action to update.</p>', 'UpdateArtifactRequest$ArtifactName' => '<p>The new name for the artifact.</p>', 'UpdateContextRequest$ContextName' => '<p>The name of the context to update.</p>', 'UpdateExperimentRequest$ExperimentName' => '<p>The name of the experiment to update.</p>', 'UpdateExperimentRequest$DisplayName' => '<p>The name of the experiment as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>ExperimentName</code> is displayed.</p>', 'UpdateTrialComponentRequest$TrialComponentName' => '<p>The name of the component to update.</p>', 'UpdateTrialComponentRequest$DisplayName' => '<p>The name of the component as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialComponentName</code> is displayed.</p>', 'UpdateTrialRequest$TrialName' => '<p>The name of the trial to update.</p>', 'UpdateTrialRequest$DisplayName' => '<p>The name of the trial as displayed. The name doesn\'t need to be unique. If <code>DisplayName</code> isn\'t specified, <code>TrialName</code> is displayed.</p>', ], ], 'ExperimentEntityNameOrArn' => [ 'base' => NULL, 'refs' => [ 'DescribeActionResponse$ActionName' => '<p>The name of the action.</p>', 'DescribeArtifactResponse$ArtifactName' => '<p>The name of the artifact.</p>', 'DescribeContextRequest$ContextName' => '<p>The name of the context to describe.</p>', 'DescribeTrialComponentRequest$TrialComponentName' => '<p>The name of the trial component to describe.</p>', ], ], 'ExperimentSource' => [ 'base' => '<p>The source of the experiment.</p>', 'refs' => [ 'DescribeExperimentResponse$Source' => '<p>The ARN of the source and, optionally, the type.</p>', 'Experiment$Source' => NULL, 'ExperimentSummary$ExperimentSource' => NULL, ], ], 'ExperimentSourceArn' => [ 'base' => NULL, 'refs' => [ 'ExperimentSource$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source.</p>', ], ], 'ExperimentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsResponse$ExperimentSummaries' => '<p>A list of the summaries of your experiments.</p>', ], ], 'ExperimentSummary' => [ 'base' => '<p>A summary of the properties of an experiment. To get the complete set of properties, call the <a>DescribeExperiment</a> API and provide the <code>ExperimentName</code>.</p>', 'refs' => [ 'ExperimentSummaries$member' => NULL, ], ], 'ExpiresInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedDomainUrlRequest$ExpiresInSeconds' => '<p>The number of seconds until the pre-signed URL expires. This value defaults to 300.</p>', ], ], 'Explainability' => [ 'base' => '<p>Contains explainability metrics for a model.</p>', 'refs' => [ 'ModelMetrics$Explainability' => '<p>Metrics that help explain a model.</p>', ], ], 'ExplainabilityLocation' => [ 'base' => NULL, 'refs' => [ 'CandidateArtifactLocations$Explainability' => '<p>The Amazon S3 prefix to the explainability artifacts generated for the AutoML candidate.</p>', ], ], 'FailStepMetadata' => [ 'base' => '<p>The container for the metadata for Fail step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Fail' => '<p>The configurations and outcomes of a Fail step execution.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, 'DescribeAppResponse$FailureReason' => '<p>The failure reason.</p>', 'DescribeCompilationJobResponse$FailureReason' => '<p>If a model compilation job failed, the reason it failed. </p>', 'DescribeDomainResponse$FailureReason' => '<p>The failure reason.</p>', 'DescribeEndpointOutput$FailureReason' => '<p>If the status of the endpoint is <code>Failed</code>, the reason why it failed. </p>', 'DescribeFeatureGroupResponse$FailureReason' => '<p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure can occur because:</p> <ul> <li> <p>The <code>FeatureGroup</code> could not be created in the <code>OfflineStore</code>.</p> </li> <li> <p>The <code>FeatureGroup</code> could not be deleted from the <code>OfflineStore</code>.</p> </li> </ul>', 'DescribeFlowDefinitionResponse$FailureReason' => '<p>The reason your flow definition failed.</p>', 'DescribeHyperParameterTuningJobResponse$FailureReason' => '<p>If the tuning job failed, the reason it failed.</p>', 'DescribeImageResponse$FailureReason' => '<p>When a create, update, or delete operation fails, the reason for the failure.</p>', 'DescribeImageVersionResponse$FailureReason' => '<p>When a create or delete operation fails, the reason for the failure.</p>', 'DescribeInferenceRecommendationsJobResponse$FailureReason' => '<p>If the job fails, provides information why the job failed.</p>', 'DescribeLabelingJobResponse$FailureReason' => '<p>If the job failed, the reason that it failed. </p>', 'DescribeMonitoringScheduleResponse$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.</p>', 'DescribeNotebookInstanceOutput$FailureReason' => '<p>If status is <code>Failed</code>, the reason it failed.</p>', 'DescribeProcessingJobResponse$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>', 'DescribeTrainingJobResponse$FailureReason' => '<p>If the training job failed, the reason it failed. </p>', 'DescribeTransformJobResponse$FailureReason' => '<p>If the transform job failed, <code>FailureReason</code> describes why it failed. A transform job creates a log file, which includes error messages, and stores it as an Amazon S3 object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/logging-cloudwatch.html">Log Amazon SageMaker Events with Amazon CloudWatch</a>.</p>', 'DescribeUserProfileResponse$FailureReason' => '<p>The failure reason.</p>', 'Endpoint$FailureReason' => '<p>If the endpoint failed, the reason it failed.</p>', 'FeatureGroup$FailureReason' => '<p>The reason that the <code>FeatureGroup</code> failed to be replicated in the <code>OfflineStore</code>. This is failure may be due to a failure to create a <code>FeatureGroup</code> in or delete a <code>FeatureGroup</code> from the <code>OfflineStore</code>.</p>', 'FlowDefinitionSummary$FailureReason' => '<p>The reason why the flow definition creation failed. A failure reason is returned only when the flow definition status is <code>Failed</code>.</p>', 'HyperParameterTrainingJobSummary$FailureReason' => '<p>The reason that the training job failed. </p>', 'Image$FailureReason' => '<p>When a create, update, or delete operation fails, the reason for the failure.</p>', 'ImageVersion$FailureReason' => '<p>When a create or delete operation fails, the reason for the failure.</p>', 'InferenceRecommendationsJob$FailureReason' => '<p>If the job fails, provides information why the job failed.</p>', 'LabelingJobSummary$FailureReason' => '<p>If the <code>LabelingJobStatus</code> field is <code>Failed</code>, this field contains a description of the error.</p>', 'MonitoringExecutionSummary$FailureReason' => '<p>Contains the reason a monitoring job failed, if it failed.</p>', 'MonitoringSchedule$FailureReason' => '<p>If the monitoring schedule failed, the reason it failed.</p>', 'PipelineExecutionStep$FailureReason' => '<p>The reason why the step failed execution. This is only returned if the step failed its execution.</p>', 'ProcessingJob$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>', 'ProcessingJobSummary$FailureReason' => '<p>A string, up to one KB in size, that contains the reason a processing job failed, if it failed.</p>', 'ResourceInUse$Message' => NULL, 'ResourceLimitExceeded$Message' => NULL, 'ResourceNotFound$Message' => NULL, 'TrainingJob$FailureReason' => '<p>If the training job failed, the reason it failed.</p>', 'TransformJob$FailureReason' => '<p>If the transform job failed, the reason it failed.</p>', 'TransformJobSummary$FailureReason' => '<p>If the transform job failed, the reason it failed.</p>', ], ], 'FeatureDefinition' => [ 'base' => '<p>A list of features. You must include <code>FeatureName</code> and <code>FeatureType</code>. Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>. </p>', 'refs' => [ 'FeatureDefinitions$member' => NULL, ], ], 'FeatureDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupRequest$FeatureDefinitions' => '<p>A list of <code>Feature</code> names and types. <code>Name</code> and <code>Type</code> is compulsory per <code>Feature</code>. </p> <p>Valid feature <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>.</p> <p> <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code> </p> <p>You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.</p>', 'DescribeFeatureGroupResponse$FeatureDefinitions' => '<p>A list of the <code>Features</code> in the <code>FeatureGroup</code>. Each feature is defined by a <code>FeatureName</code> and <code>FeatureType</code>.</p>', 'FeatureGroup$FeatureDefinitions' => '<p>A list of <code>Feature</code>s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code>. </p> <p>Valid <code>FeatureType</code>s are <code>Integral</code>, <code>Fractional</code> and <code>String</code>. </p> <p> <code>FeatureName</code>s cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.</p> <p>You can create up to 2,500 <code>FeatureDefinition</code>s per <code>FeatureGroup</code>.</p>', ], ], 'FeatureGroup' => [ 'base' => '<p>Amazon SageMaker Feature Store stores features in a collection called Feature Group. A Feature Group can be visualized as a table which has rows, with a unique identifier for each row where each column in the table is a feature. In principle, a Feature Group is composed of features and values per features.</p>', 'refs' => [ 'SearchRecord$FeatureGroup' => NULL, ], ], 'FeatureGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupResponse$FeatureGroupArn' => '<p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. This is a unique identifier for the feature group. </p>', 'DescribeFeatureGroupResponse$FeatureGroupArn' => '<p>The Amazon Resource Name (ARN) of the <code>FeatureGroup</code>. </p>', 'FeatureGroup$FeatureGroupArn' => '<p>The Amazon Resource Name (ARN) of a <code>FeatureGroup</code>.</p>', 'FeatureGroupSummary$FeatureGroupArn' => '<p>Unique identifier for the <code>FeatureGroup</code>.</p>', ], ], 'FeatureGroupMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$MaxResults' => '<p>The maximum number of results returned by <code>ListFeatureGroups</code>.</p>', ], ], 'FeatureGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupRequest$FeatureGroupName' => '<p>The name of the <code>FeatureGroup</code>. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. The name:</p> <ul> <li> <p>Must start and end with an alphanumeric character.</p> </li> <li> <p>Can only contain alphanumeric character and hyphens. Spaces are not allowed. </p> </li> </ul>', 'DeleteFeatureGroupRequest$FeatureGroupName' => '<p>The name of the <code>FeatureGroup</code> you want to delete. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>', 'DescribeFeatureGroupRequest$FeatureGroupName' => '<p>The name of the <code>FeatureGroup</code> you want described. </p>', 'DescribeFeatureGroupResponse$FeatureGroupName' => '<p>he name of the <code>FeatureGroup</code>.</p>', 'FeatureGroup$FeatureGroupName' => '<p>The name of the <code>FeatureGroup</code>.</p>', 'FeatureGroupSummary$FeatureGroupName' => '<p>The name of <code>FeatureGroup</code>.</p>', 'ProcessingFeatureStoreOutput$FeatureGroupName' => '<p>The name of the Amazon SageMaker FeatureGroup to use as the destination for processing job output. Note that your processing script is responsible for putting records into your Feature Store.</p>', ], ], 'FeatureGroupNameContains' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$NameContains' => '<p>A string that partially matches one or more <code>FeatureGroup</code>s names. Filters <code>FeatureGroup</code>s by name. </p>', ], ], 'FeatureGroupSortBy' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$SortBy' => '<p>The value on which the feature group list is sorted.</p>', ], ], 'FeatureGroupSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$SortOrder' => '<p>The order in which feature groups are listed.</p>', ], ], 'FeatureGroupStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeFeatureGroupResponse$FeatureGroupStatus' => '<p>The status of the feature group.</p>', 'FeatureGroup$FeatureGroupStatus' => '<p>A <code>FeatureGroup</code> status.</p>', 'FeatureGroupSummary$FeatureGroupStatus' => '<p>The status of a FeatureGroup. The status can be any of the following: <code>Creating</code>, <code>Created</code>, <code>CreateFail</code>, <code>Deleting</code> or <code>DetailFail</code>. </p>', 'ListFeatureGroupsRequest$FeatureGroupStatusEquals' => '<p>A <code>FeatureGroup</code> status. Filters by <code>FeatureGroup</code> status. </p>', ], ], 'FeatureGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsResponse$FeatureGroupSummaries' => '<p>A summary of feature groups.</p>', ], ], 'FeatureGroupSummary' => [ 'base' => '<p>The name, Arn, <code>CreationTime</code>, <code>FeatureGroup</code> values, <code>LastUpdatedTime</code> and <code>EnableOnlineStorage</code> status of a <code>FeatureGroup</code>.</p>', 'refs' => [ 'FeatureGroupSummaries$member' => NULL, ], ], 'FeatureName' => [ 'base' => NULL, 'refs' => [ 'CreateFeatureGroupRequest$RecordIdentifierFeatureName' => '<p>The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureStore</code>. Only the latest record per identifier value will be stored in the <code>OnlineStore</code>. <code>RecordIdentifierFeatureName</code> must be one of feature definitions\' names.</p> <p>You use the <code>RecordIdentifierFeatureName</code> to access data in a <code>FeatureStore</code>.</p> <p>This name:</p> <ul> <li> <p>Must start and end with an alphanumeric character.</p> </li> <li> <p>Can only contains alphanumeric characters, hyphens, underscores. Spaces are not allowed. </p> </li> </ul>', 'CreateFeatureGroupRequest$EventTimeFeatureName' => '<p>The name of the feature that stores the <code>EventTime</code> of a <code>Record</code> in a <code>FeatureGroup</code>.</p> <p>An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.</p> <p>An <code>EventTime</code> can be a <code>String</code> or <code>Fractional</code>. </p> <ul> <li> <p> <code>Fractional</code>: <code>EventTime</code> feature values must be a Unix timestamp in seconds.</p> </li> <li> <p> <code>String</code>: <code>EventTime</code> feature values must be an ISO-8601 string in the format. The following formats are supported <code>yyyy-MM-dd\'T\'HH:mm:ssZ</code> and <code>yyyy-MM-dd\'T\'HH:mm:ss.SSSZ</code> where <code>yyyy</code>, <code>MM</code>, and <code>dd</code> represent the year, month, and day respectively and <code>HH</code>, <code>mm</code>, <code>ss</code>, and if applicable, <code>SSS</code> represent the hour, month, second and milliseconds respsectively. <code>\'T\'</code> and <code>Z</code> are constants.</p> </li> </ul>', 'DescribeFeatureGroupResponse$RecordIdentifierFeatureName' => '<p>The name of the <code>Feature</code> used for <code>RecordIdentifier</code>, whose value uniquely identifies a record stored in the feature store.</p>', 'DescribeFeatureGroupResponse$EventTimeFeatureName' => '<p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p> <p> An <code>EventTime</code> is a point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in a <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> have a corresponding <code>EventTime</code>.</p>', 'FeatureDefinition$FeatureName' => '<p>The name of a feature. The type must be a string. <code>FeatureName</code> cannot be any of the following: <code>is_deleted</code>, <code>write_time</code>, <code>api_invocation_time</code>.</p>', 'FeatureGroup$RecordIdentifierFeatureName' => '<p>The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureGroup</code> <code>FeatureDefinitions</code>.</p>', 'FeatureGroup$EventTimeFeatureName' => '<p>The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code>.</p> <p>A <code>EventTime</code> is point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in <code>FeatureGroup</code>. All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code>.</p>', ], ], 'FeatureType' => [ 'base' => NULL, 'refs' => [ 'FeatureDefinition$FeatureType' => '<p>The value type of a feature. Valid values are Integral, Fractional, or String.</p>', ], ], 'FileSource' => [ 'base' => '<p>Contains details regarding the file source.</p>', 'refs' => [ 'DriftCheckBias$ConfigFile' => '<p>The bias config file for a model.</p>', 'DriftCheckExplainability$ConfigFile' => '<p>The explainability config file for the model.</p>', ], ], 'FileSystemAccessMode' => [ 'base' => NULL, 'refs' => [ 'FileSystemDataSource$FileSystemAccessMode' => '<p>The access mode of the mount of the directory associated with the channel. A directory can be mounted either in <code>ro</code> (read-only) or <code>rw</code> (read-write) mode.</p>', ], ], 'FileSystemConfig' => [ 'base' => '<p>The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.</p>', 'refs' => [ 'KernelGatewayImageConfig$FileSystemConfig' => '<p>The Amazon Elastic File System (EFS) storage configuration for a SageMaker image.</p>', ], ], 'FileSystemDataSource' => [ 'base' => '<p>Specifies a file system data source for a channel.</p>', 'refs' => [ 'DataSource$FileSystemDataSource' => '<p>The file system that is associated with a channel.</p>', ], ], 'FileSystemId' => [ 'base' => NULL, 'refs' => [ 'FileSystemDataSource$FileSystemId' => '<p>The file system id.</p>', ], ], 'FileSystemType' => [ 'base' => NULL, 'refs' => [ 'FileSystemDataSource$FileSystemType' => '<p>The file system type. </p>', ], ], 'Filter' => [ 'base' => '<p>A conditional statement for a search expression that includes a resource property, a Boolean operator, and a value. Resources that match the statement are returned in the results from the <a>Search</a> API.</p> <p>If you specify a <code>Value</code>, but not an <code>Operator</code>, Amazon SageMaker uses the equals operator.</p> <p>In search, there are several property types:</p> <dl> <dt>Metrics</dt> <dd> <p>To define a metric filter, enter a value using the form <code>"Metrics.&lt;name&gt;"</code>, where <code>&lt;name&gt;</code> is a metric name. For example, the following filter searches for training jobs with an <code>"accuracy"</code> metric greater than <code>"0.9"</code>:</p> <p> <code>{</code> </p> <p> <code>"Name": "Metrics.accuracy",</code> </p> <p> <code>"Operator": "GreaterThan",</code> </p> <p> <code>"Value": "0.9"</code> </p> <p> <code>}</code> </p> </dd> <dt>HyperParameters</dt> <dd> <p>To define a hyperparameter filter, enter a value with the form <code>"HyperParameters.&lt;name&gt;"</code>. Decimal hyperparameter values are treated as a decimal in a comparison if the specified <code>Value</code> is also a decimal value. If the specified <code>Value</code> is an integer, the decimal hyperparameter values are treated as integers. For example, the following filter is satisfied by training jobs with a <code>"learning_rate"</code> hyperparameter that is less than <code>"0.5"</code>:</p> <p> <code> {</code> </p> <p> <code> "Name": "HyperParameters.learning_rate",</code> </p> <p> <code> "Operator": "LessThan",</code> </p> <p> <code> "Value": "0.5"</code> </p> <p> <code> }</code> </p> </dd> <dt>Tags</dt> <dd> <p>To define a tag filter, enter a value with the form <code>Tags.&lt;key&gt;</code>.</p> </dd> </dl>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'NestedFilters$Filters' => '<p>A list of filters. Each filter acts on a property. Filters must contain at least one <code>Filters</code> value. For example, a <code>NestedFilters</code> call might include a filter on the <code>PropertyName</code> parameter of the <code>InputDataConfig</code> property: <code>InputDataConfig.DataSource.S3DataSource.S3Uri</code>.</p>', 'SearchExpression$Filters' => '<p>A list of filter objects.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'Filter$Value' => '<p>A value used with <code>Name</code> and <code>Operator</code> to determine which resources satisfy the filter\'s condition. For numerical properties, <code>Value</code> must be an integer or floating-point decimal. For timestamp properties, <code>Value</code> must be an ISO 8601 date-time string of the following format: <code>YYYY-mm-dd\'T\'HH:MM:SS</code>.</p>', ], ], 'FinalAutoMLJobObjectiveMetric' => [ 'base' => '<p>The best candidate result from an AutoML training job.</p>', 'refs' => [ 'AutoMLCandidate$FinalAutoMLJobObjectiveMetric' => NULL, ], ], 'FinalHyperParameterTuningJobObjectiveMetric' => [ 'base' => '<p>Shows the final value for the objective metric for a training job that was launched by a hyperparameter tuning job. You define the objective metric in the <code>HyperParameterTuningJobObjective</code> parameter of <a>HyperParameterTuningJobConfig</a>.</p>', 'refs' => [ 'HyperParameterTrainingJobSummary$FinalHyperParameterTuningJobObjectiveMetric' => '<p>The <a>FinalHyperParameterTuningJobObjectiveMetric</a> object that specifies the value of the objective metric of the tuning job that launched this training job.</p>', ], ], 'FinalMetricDataList' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$FinalMetricDataList' => '<p>A collection of <code>MetricData</code> objects that specify the names, values, and dates and times that the training algorithm emitted to Amazon CloudWatch.</p>', 'TrainingJob$FinalMetricDataList' => '<p>A list of final metric values that are set when the training job completes. Used only if the training job was configured to use metrics.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'MetricData$Value' => '<p>The value of the metric.</p>', 'MetricDatum$Value' => '<p>The value of the metric.</p>', 'RecommendationMetrics$CostPerHour' => '<p>Defines the cost per hour for the instance. </p>', 'RecommendationMetrics$CostPerInference' => '<p>Defines the cost per inference for the instance .</p>', ], ], 'FlowDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'CreateFlowDefinitionResponse$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow definition you create.</p>', 'DescribeFlowDefinitionResponse$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow defintion.</p>', 'FlowDefinitionSummary$FlowDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the flow definition.</p>', ], ], 'FlowDefinitionName' => [ 'base' => NULL, 'refs' => [ 'CreateFlowDefinitionRequest$FlowDefinitionName' => '<p>The name of your flow definition.</p>', 'DeleteFlowDefinitionRequest$FlowDefinitionName' => '<p>The name of the flow definition you are deleting.</p>', 'DescribeFlowDefinitionRequest$FlowDefinitionName' => '<p>The name of the flow definition.</p>', 'DescribeFlowDefinitionResponse$FlowDefinitionName' => '<p>The Amazon Resource Name (ARN) of the flow definition.</p>', 'FlowDefinitionSummary$FlowDefinitionName' => '<p>The name of the flow definition.</p>', ], ], 'FlowDefinitionOutputConfig' => [ 'base' => '<p>Contains information about where human output will be stored.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$OutputConfig' => '<p>An object containing information about where the human review results will be uploaded.</p>', 'DescribeFlowDefinitionResponse$OutputConfig' => '<p>An object containing information about the output file.</p>', ], ], 'FlowDefinitionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeFlowDefinitionResponse$FlowDefinitionStatus' => '<p>The status of the flow definition. Valid values are listed below.</p>', 'FlowDefinitionSummary$FlowDefinitionStatus' => '<p>The status of the flow definition. Valid values:</p>', ], ], 'FlowDefinitionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListFlowDefinitionsResponse$FlowDefinitionSummaries' => '<p>An array of objects describing the flow definitions.</p>', ], ], 'FlowDefinitionSummary' => [ 'base' => '<p>Contains summary information about the flow definition.</p>', 'refs' => [ 'FlowDefinitionSummaries$member' => NULL, ], ], 'FlowDefinitionTaskAvailabilityLifetimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskAvailabilityLifetimeInSeconds' => '<p>The length of time that a task remains available for review by human workers.</p>', ], ], 'FlowDefinitionTaskCount' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskCount' => '<p>The number of distinct workers who will perform the same task on each object. For example, if <code>TaskCount</code> is set to <code>3</code> for an image classification labeling job, three workers will classify each input image. Increasing <code>TaskCount</code> can improve label accuracy.</p>', ], ], 'FlowDefinitionTaskDescription' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskDescription' => '<p>A description for the human worker task.</p>', ], ], 'FlowDefinitionTaskKeyword' => [ 'base' => NULL, 'refs' => [ 'FlowDefinitionTaskKeywords$member' => NULL, ], ], 'FlowDefinitionTaskKeywords' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskKeywords' => '<p>Keywords used to describe the task so that workers can discover the task.</p>', ], ], 'FlowDefinitionTaskTimeLimitInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskTimeLimitInSeconds' => '<p>The amount of time that a worker has to complete a task. The default value is 3,600 seconds (1 hour).</p>', ], ], 'FlowDefinitionTaskTitle' => [ 'base' => NULL, 'refs' => [ 'HumanLoopConfig$TaskTitle' => '<p>A title for the human worker task.</p>', ], ], 'Framework' => [ 'base' => NULL, 'refs' => [ 'InputConfig$Framework' => '<p>Identifies the framework in which the model was trained. For example: TENSORFLOW.</p>', ], ], 'FrameworkVersion' => [ 'base' => NULL, 'refs' => [ 'InputConfig$FrameworkVersion' => '<p>Specifies the framework version to use. This API field is only supported for the PyTorch and TensorFlow frameworks.</p> <p>For information about framework versions supported for cloud targets and edge devices, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-supported-cloud.html">Cloud Supported Instance Types and Frameworks</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-supported-devices-edge-frameworks.html">Edge Supported Frameworks</a>.</p>', 'ModelPackageContainerDefinition$FrameworkVersion' => '<p>The framework version of the Model Package Container Image.</p>', ], ], 'GenerateCandidateDefinitionsOnly' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobRequest$GenerateCandidateDefinitionsOnly' => '<p>Generates possible candidates without training the models. A candidate is a combination of data preprocessors, algorithms, and algorithm parameter settings.</p>', 'DescribeAutoMLJobResponse$GenerateCandidateDefinitionsOnly' => '<p>Indicates whether the output for an AutoML job generates candidate definitions only.</p>', ], ], 'GetDeviceFleetReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeviceFleetReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLineageGroupPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLineageGroupPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetModelPackageGroupPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetModelPackageGroupPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSagemakerServicecatalogPortfolioStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSagemakerServicecatalogPortfolioStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSearchSuggestionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSearchSuggestionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GitConfig' => [ 'base' => '<p>Specifies configuration details for a Git repository in your Amazon Web Services account.</p>', 'refs' => [ 'CodeRepositorySummary$GitConfig' => '<p>Configuration details for the Git repository, including the URL where it is located and the ARN of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p>', 'CreateCodeRepositoryInput$GitConfig' => '<p>Specifies details about the repository, including the URL where the repository is located, the default branch, and credentials to use to access the repository.</p>', 'DescribeCodeRepositoryOutput$GitConfig' => '<p>Configuration details about the repository, including the URL where the repository is located, the default branch, and the Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository.</p>', ], ], 'GitConfigForUpdate' => [ 'base' => '<p>Specifies configuration details for a Git repository when the repository is updated.</p>', 'refs' => [ 'UpdateCodeRepositoryInput$GitConfig' => '<p>The configuration of the git repository, including the URL and the Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>', ], ], 'GitConfigUrl' => [ 'base' => NULL, 'refs' => [ 'GitConfig$RepositoryUrl' => '<p>The URL where the Git repository is located.</p>', ], ], 'Group' => [ 'base' => NULL, 'refs' => [ 'Groups$member' => NULL, ], ], 'Groups' => [ 'base' => NULL, 'refs' => [ 'OidcMemberDefinition$Groups' => '<p>A list of comma seperated strings that identifies user groups in your OIDC IdP. Each user group is made up of a group of private workers.</p>', ], ], 'HookParameters' => [ 'base' => NULL, 'refs' => [ 'DebugHookConfig$HookParameters' => '<p>Configuration information for the Debugger hook parameters.</p>', ], ], 'HumanLoopActivationConditions' => [ 'base' => NULL, 'refs' => [ 'HumanLoopActivationConditionsConfig$HumanLoopActivationConditions' => '<p>JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. The set of conditions is different for Rekognition and Textract. For more information about how to structure the JSON, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html">JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI</a> in the <i>Amazon SageMaker Developer Guide</i>.</p>', ], ], 'HumanLoopActivationConditionsConfig' => [ 'base' => '<p>Defines under what conditions SageMaker creates a human loop. Used within . See for the required format of activation conditions.</p>', 'refs' => [ 'HumanLoopActivationConfig$HumanLoopActivationConditionsConfig' => '<p>Container structure for defining under what conditions SageMaker creates a human loop.</p>', ], ], 'HumanLoopActivationConfig' => [ 'base' => '<p>Provides information about how and under what conditions SageMaker creates a human loop. If <code>HumanLoopActivationConfig</code> is not given, then all requests go to humans.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$HumanLoopActivationConfig' => '<p>An object containing information about the events that trigger a human workflow.</p>', 'DescribeFlowDefinitionResponse$HumanLoopActivationConfig' => '<p>An object containing information about what triggers a human review workflow.</p>', ], ], 'HumanLoopConfig' => [ 'base' => '<p>Describes the work to be performed by human workers.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$HumanLoopConfig' => '<p>An object containing information about the tasks the human reviewers will perform.</p>', 'DescribeFlowDefinitionResponse$HumanLoopConfig' => '<p>An object containing information about who works on the task, the workforce task price, and other task details.</p>', ], ], 'HumanLoopRequestSource' => [ 'base' => '<p>Container for configuring the source of human task requests.</p>', 'refs' => [ 'CreateFlowDefinitionRequest$HumanLoopRequestSource' => '<p>Container for configuring the source of human task requests. Use to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>', 'DescribeFlowDefinitionResponse$HumanLoopRequestSource' => '<p>Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon Textract is used as an integration source.</p>', ], ], 'HumanTaskConfig' => [ 'base' => '<p>Information required for human workers to complete a labeling task.</p>', 'refs' => [ 'CreateLabelingJobRequest$HumanTaskConfig' => '<p>Configures the labeling task and how it is presented to workers; including, but not limited to price, keywords, and batch size (task count).</p>', 'DescribeLabelingJobResponse$HumanTaskConfig' => '<p>Configuration information required for human workers to complete a labeling task.</p>', ], ], 'HumanTaskUiArn' => [ 'base' => NULL, 'refs' => [ 'CreateHumanTaskUiResponse$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human review workflow user interface you create.</p>', 'DescribeHumanTaskUiResponse$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human task user interface (worker task template).</p>', 'HumanLoopConfig$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human task user interface.</p> <p>You can use standard HTML and Crowd HTML Elements to create a custom worker task template. You use this template to create a human task UI.</p> <p>To learn how to create a custom HTML template, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-custom-templates.html">Create Custom Worker Task Template</a>.</p> <p>To learn how to create a human task UI, which is a worker task template that can be used in a flow definition, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-worker-template-console.html">Create and Delete a Worker Task Templates</a>.</p>', 'HumanTaskUiSummary$HumanTaskUiArn' => '<p>The Amazon Resource Name (ARN) of the human task user interface.</p>', 'RenderUiTemplateRequest$HumanTaskUiArn' => '<p>The <code>HumanTaskUiArn</code> of the worker UI that you want to render. Do not provide a <code>HumanTaskUiArn</code> if you use the <code>UiTemplate</code> parameter.</p> <p>See a list of available Human Ui Amazon Resource Names (ARNs) in <a>UiConfig</a>.</p>', 'UiConfig$HumanTaskUiArn' => '<p>The ARN of the worker task template used to render the worker UI and tools for labeling job tasks.</p> <p>Use this parameter when you are creating a labeling job for named entity recognition, 3D point cloud and video frame labeling jobs. Use your labeling job task type to select one of the following ARNs and use it with this parameter when you create a labeling job. Replace <code>aws-region</code> with the Amazon Web Services Region you are creating your labeling job in. For example, replace <code>aws-region</code> with <code>us-west-1</code> if you create a labeling job in US West (N. California).</p> <p> <b>Named Entity Recognition</b> </p> <p>Use the following <code>HumanTaskUiArn</code> for named entity recognition labeling jobs:</p> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/NamedEntityRecognition</code> </p> <p> <b>3D Point Cloud HumanTaskUiArns</b> </p> <p>Use this <code>HumanTaskUiArn</code> for 3D point cloud object detection and 3D point cloud object detection adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for 3D point cloud object tracking and 3D point cloud object tracking adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for 3D point cloud semantic segmentation and 3D point cloud semantic segmentation adjustment labeling jobs.</p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Video Frame HumanTaskUiArns</b> </p> <p>Use this <code>HumanTaskUiArn</code> for video frame object detection and video frame object detection adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection</code> </p> </li> </ul> <p> Use this <code>HumanTaskUiArn</code> for video frame object tracking and video frame object tracking adjustment labeling jobs. </p> <ul> <li> <p> <code>arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking</code> </p> </li> </ul>', ], ], 'HumanTaskUiName' => [ 'base' => NULL, 'refs' => [ 'CreateHumanTaskUiRequest$HumanTaskUiName' => '<p>The name of the user interface you are creating.</p>', 'DeleteHumanTaskUiRequest$HumanTaskUiName' => '<p>The name of the human task user interface (work task template) you want to delete.</p>', 'DescribeHumanTaskUiRequest$HumanTaskUiName' => '<p>The name of the human task user interface (worker task template) you want information about.</p>', 'DescribeHumanTaskUiResponse$HumanTaskUiName' => '<p>The name of the human task user interface (worker task template).</p>', 'HumanTaskUiSummary$HumanTaskUiName' => '<p>The name of the human task user interface.</p>', ], ], 'HumanTaskUiStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeHumanTaskUiResponse$HumanTaskUiStatus' => '<p>The status of the human task user interface (worker task template). Valid values are listed below.</p>', ], ], 'HumanTaskUiSummaries' => [ 'base' => NULL, 'refs' => [ 'ListHumanTaskUisResponse$HumanTaskUiSummaries' => '<p>An array of objects describing the human task user interfaces.</p>', ], ], 'HumanTaskUiSummary' => [ 'base' => '<p>Container for human task user interface information.</p>', 'refs' => [ 'HumanTaskUiSummaries$member' => NULL, ], ], 'HyperParameterAlgorithmSpecification' => [ 'base' => '<p>Specifies which training algorithm to use for training jobs that a hyperparameter tuning job launches and the metrics to monitor.</p>', 'refs' => [ 'HyperParameterTrainingJobDefinition$AlgorithmSpecification' => '<p>The <a>HyperParameterAlgorithmSpecification</a> object that specifies the resource algorithm to use for the training jobs that the tuning job launches.</p>', ], ], 'HyperParameterKey' => [ 'base' => NULL, 'refs' => [ 'HyperParameters$key' => NULL, ], ], 'HyperParameterScalingType' => [ 'base' => NULL, 'refs' => [ 'ContinuousParameterRange$ScalingType' => '<p>The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p> <dl> <dt>Auto</dt> <dd> <p>Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have only values greater than 0.</p> </dd> <dt>ReverseLogarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a reverse logarithmic scale.</p> <p>Reverse logarithmic scaling works only for ranges that are entirely within the range 0&lt;=x&lt;1.0.</p> </dd> </dl>', 'IntegerParameterRange$ScalingType' => '<p>The scale that hyperparameter tuning uses to search the hyperparameter range. For information about choosing a hyperparameter scale, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type">Hyperparameter Scaling</a>. One of the following values:</p> <dl> <dt>Auto</dt> <dd> <p>Amazon SageMaker hyperparameter tuning chooses the best scale for the hyperparameter.</p> </dd> <dt>Linear</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a linear scale.</p> </dd> <dt>Logarithmic</dt> <dd> <p>Hyperparameter tuning searches the values in the hyperparameter range by using a logarithmic scale.</p> <p>Logarithmic scaling works only for ranges that have only values greater than 0.</p> </dd> </dl>', ], ], 'HyperParameterSpecification' => [ 'base' => '<p>Defines a hyperparameter to be used by an algorithm.</p>', 'refs' => [ 'HyperParameterSpecifications$member' => NULL, ], ], 'HyperParameterSpecifications' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$SupportedHyperParameters' => '<p>A list of the <code>HyperParameterSpecification</code> objects, that define the supported hyperparameters. This is required if the algorithm supports automatic model tuning.&gt;</p>', ], ], 'HyperParameterTrainingJobDefinition' => [ 'base' => '<p>Defines the training jobs launched by a hyperparameter tuning job.</p>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$TrainingJobDefinition' => '<p>The <a>HyperParameterTrainingJobDefinition</a> object that describes the training jobs that this tuning job launches, including static hyperparameters, input data configuration, output data configuration, resource configuration, and stopping condition.</p>', 'DescribeHyperParameterTuningJobResponse$TrainingJobDefinition' => '<p>The <a>HyperParameterTrainingJobDefinition</a> object that specifies the definition of the training jobs that this tuning job launches.</p>', 'HyperParameterTrainingJobDefinitions$member' => NULL, ], ], 'HyperParameterTrainingJobDefinitionName' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTrainingJobDefinition$DefinitionName' => '<p>The job definition name.</p>', 'HyperParameterTrainingJobSummary$TrainingJobDefinitionName' => '<p>The training job definition name.</p>', ], ], 'HyperParameterTrainingJobDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateHyperParameterTuningJobRequest$TrainingJobDefinitions' => '<p>A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.</p>', 'DescribeHyperParameterTuningJobResponse$TrainingJobDefinitions' => '<p>A list of the <a>HyperParameterTrainingJobDefinition</a> objects launched for this tuning job.</p>', ], ], 'HyperParameterTrainingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrainingJobsForHyperParameterTuningJobResponse$TrainingJobSummaries' => '<p>A list of <a>TrainingJobSummary</a> objects that describe the training jobs that the <code>ListTrainingJobsForHyperParameterTuningJob</code> request returned.</p>', ], ], 'HyperParameterTrainingJobSummary' => [ 'base' => '<p>Specifies summary information about a training job.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$BestTrainingJob' => '<p>A <a>TrainingJobSummary</a> object that describes the training job that completed with the best current <a>HyperParameterTuningJobObjective</a>.</p>', 'DescribeHyperParameterTuningJobResponse$OverallBestTrainingJob' => '<p>If the hyperparameter tuning job is an warm start tuning job with a <code>WarmStartType</code> of <code>IDENTICAL_DATA_AND_ALGORITHM</code>, this is the <a>TrainingJobSummary</a> for the training job with the best objective metric value of all training jobs launched by this tuning job and all parent jobs specified for the warm start tuning job.</p>', 'HyperParameterTrainingJobSummaries$member' => NULL, ], ], 'HyperParameterTuningJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateHyperParameterTuningJobResponse$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of the tuning job. Amazon SageMaker assigns an ARN to a hyperparameter tuning job when you create it.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of the tuning job.</p>', 'DescribeTrainingJobResponse$TuningJobArn' => '<p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningJobArn' => '<p>The Amazon Resource Name (ARN) of the tuning job.</p>', 'TrainingJob$TuningJobArn' => '<p>The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if the training job was launched by a hyperparameter tuning job.</p>', 'TuningJobStepMetaData$Arn' => '<p>The Amazon Resource Name (ARN) of the tuning job that was run by this step execution.</p>', ], ], 'HyperParameterTuningJobConfig' => [ 'base' => '<p>Configures a hyperparameter tuning job.</p>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$HyperParameterTuningJobConfig' => '<p>The <a>HyperParameterTuningJobConfig</a> object that describes the tuning job, including the search strategy, the objective metric used to evaluate training jobs, ranges of parameters to search, and resource limits for the tuning job. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobConfig' => '<p>The <a>HyperParameterTuningJobConfig</a> object that specifies the configuration of the tuning job.</p>', ], ], 'HyperParameterTuningJobName' => [ 'base' => NULL, 'refs' => [ 'CreateHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job. This name is the prefix for the names of all training jobs that this tuning job launches. The name must be unique within the same Amazon Web Services account and Amazon Web Services Region. The name must have 1 to 32 characters. Valid characters are a-z, A-Z, 0-9, and : + = @ _ % - (hyphen). The name is not case sensitive.</p>', 'DescribeHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobName' => '<p>The name of the tuning job.</p>', 'HyperParameterTrainingJobSummary$TuningJobName' => '<p>The HyperParameter tuning job that launched the training job.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningJobName' => '<p>The name of the tuning job.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job whose training jobs you want to list.</p>', 'ParentHyperParameterTuningJob$HyperParameterTuningJobName' => '<p>The name of the hyperparameter tuning job to be used as a starting point for a new hyperparameter tuning job.</p>', 'StopHyperParameterTuningJobRequest$HyperParameterTuningJobName' => '<p>The name of the tuning job to stop.</p>', ], ], 'HyperParameterTuningJobObjective' => [ 'base' => '<p>Defines the objective metric for a hyperparameter tuning job. Hyperparameter tuning uses the value of this metric to evaluate the training jobs it launches, and returns the training job that results in either the highest or lowest value for this metric, depending on the value you specify for the <code>Type</code> parameter.</p>', 'refs' => [ 'HyperParameterTrainingJobDefinition$TuningObjective' => NULL, 'HyperParameterTuningJobConfig$HyperParameterTuningJobObjective' => '<p>The <a>HyperParameterTuningJobObjective</a> object that specifies the objective metric for this tuning job.</p>', 'HyperParameterTuningJobObjectives$member' => NULL, ], ], 'HyperParameterTuningJobObjectiveType' => [ 'base' => NULL, 'refs' => [ 'FinalHyperParameterTuningJobObjectiveMetric$Type' => '<p>Whether to minimize or maximize the objective metric. Valid values are Minimize and Maximize.</p>', 'HyperParameterTuningJobObjective$Type' => '<p>Whether to minimize or maximize the objective metric.</p>', ], ], 'HyperParameterTuningJobObjectives' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$SupportedTuningJobObjectiveMetrics' => '<p>A list of the metrics that the algorithm emits that can be used as the objective metric in a hyperparameter tuning job.</p>', ], ], 'HyperParameterTuningJobSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListHyperParameterTuningJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p>', ], ], 'HyperParameterTuningJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningJobStatus' => '<p>The status of the tuning job: InProgress, Completed, Failed, Stopping, or Stopped.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningJobStatus' => '<p>The status of the tuning job.</p>', 'ListHyperParameterTuningJobsRequest$StatusEquals' => '<p>A filter that returns only tuning jobs with the specified status.</p>', ], ], 'HyperParameterTuningJobStrategyType' => [ 'base' => '<p>The strategy hyperparameter tuning uses to find the best combination of hyperparameters for your model. Currently, the only supported value is <code>Bayesian</code>.</p>', 'refs' => [ 'HyperParameterTuningJobConfig$Strategy' => '<p>Specifies how hyperparameter tuning chooses the combinations of hyperparameter values to use for the training job it launches. To use the Bayesian search strategy, set this to <code>Bayesian</code>. To randomly search, set it to <code>Random</code>. For information about search strategies, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter Tuning Works</a>.</p>', 'HyperParameterTuningJobSummary$Strategy' => '<p>Specifies the search strategy hyperparameter tuning uses to choose which hyperparameters to use for each iteration. Currently, the only valid value is Bayesian.</p>', ], ], 'HyperParameterTuningJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListHyperParameterTuningJobsResponse$HyperParameterTuningJobSummaries' => '<p>A list of <a>HyperParameterTuningJobSummary</a> objects that describe the tuning jobs that the <code>ListHyperParameterTuningJobs</code> request returned.</p>', ], ], 'HyperParameterTuningJobSummary' => [ 'base' => '<p>Provides summary information about a hyperparameter tuning job.</p>', 'refs' => [ 'HyperParameterTuningJobSummaries$member' => NULL, ], ], 'HyperParameterTuningJobWarmStartConfig' => [ 'base' => '<p>Specifies the configuration for a hyperparameter tuning job that uses one or more previous hyperparameter tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p> <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric, and the training job that performs the best is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note> <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p> </note>', 'refs' => [ 'CreateHyperParameterTuningJobRequest$WarmStartConfig' => '<p>Specifies the configuration for starting the hyperparameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p> <p>All training jobs launched by the new hyperparameter tuning job are evaluated by using the objective metric. If you specify <code>IDENTICAL_DATA_AND_ALGORITHM</code> as the <code>WarmStartType</code> value for the warm start configuration, the training job that performs the best in the new tuning job is compared to the best training jobs from the parent tuning jobs. From these, the training job that performs the best as measured by the objective metric is returned as the overall best training job.</p> <note> <p>All training jobs launched by parent hyperparameter tuning jobs and the new hyperparameter tuning jobs count against the limit of training jobs for the tuning job.</p> </note>', 'DescribeHyperParameterTuningJobResponse$WarmStartConfig' => '<p>The configuration for starting the hyperparameter parameter tuning job using one or more previous tuning jobs as a starting point. The results of previous tuning jobs are used to inform which combinations of hyperparameters to search over in the new tuning job.</p>', ], ], 'HyperParameterTuningJobWarmStartType' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningJobWarmStartConfig$WarmStartType' => '<p>Specifies one of the following:</p> <dl> <dt>IDENTICAL_DATA_AND_ALGORITHM</dt> <dd> <p>The new hyperparameter tuning job uses the same input data and training image as the parent tuning jobs. You can change the hyperparameter ranges to search and the maximum number of training jobs that the hyperparameter tuning job launches. You cannot use a new version of the training algorithm, unless the changes in the new version do not affect the algorithm itself. For example, changes that improve logging or adding support for a different data format are allowed. You can also change hyperparameters from tunable to static, and from static to tunable, but the total number of static plus tunable hyperparameters must remain the same as it is in all parent jobs. The objective metric for the new tuning job must be the same as for all parent jobs.</p> </dd> <dt>TRANSFER_LEARNING</dt> <dd> <p>The new hyperparameter tuning job can include input data, hyperparameter ranges, maximum number of concurrent training jobs, and maximum number of training jobs that are different than those of its parent hyperparameter tuning jobs. The training image can also be a different version from the version used in the parent hyperparameter tuning job. You can also change hyperparameters from tunable to static, and from static to tunable, but the total number of static plus tunable hyperparameters must remain the same as it is in all parent jobs. The objective metric for the new tuning job must be the same as for all parent jobs.</p> </dd> </dl>', ], ], 'HyperParameterValue' => [ 'base' => NULL, 'refs' => [ 'HyperParameterSpecification$DefaultValue' => '<p>The default value for this hyperparameter. If a default value is specified, a hyperparameter cannot be required.</p>', 'HyperParameters$value' => NULL, ], ], 'HyperParameters' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$HyperParameters' => '<p>Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start the learning process. For a list of hyperparameters for each training algorithm provided by Amazon SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p> <p>You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value is limited to 256 characters, as specified by the <code>Length Constraint</code>. </p>', 'DescribeTrainingJobResponse$HyperParameters' => '<p>Algorithm-specific parameters. </p>', 'HyperParameterTrainingJobDefinition$StaticHyperParameters' => '<p>Specifies the values of hyperparameters that do not change for the tuning job.</p>', 'HyperParameterTrainingJobSummary$TunedHyperParameters' => '<p>A list of the hyperparameters for which you specified ranges to search.</p>', 'TrainingJob$HyperParameters' => '<p>Algorithm-specific parameters.</p>', 'TrainingJobDefinition$HyperParameters' => '<p>The hyperparameters used for the training job.</p>', ], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>', 'DeletePipelineRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>', 'RetryPipelineExecutionRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once.</p>', 'SendPipelineExecutionStepFailureRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>', 'SendPipelineExecutionStepSuccessRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time.</p>', 'StartPipelineExecutionRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once.</p>', 'StopPipelineExecutionRequest$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once.</p>', ], ], 'Image' => [ 'base' => '<p>A SageMaker image. A SageMaker image represents a set of container images that are derived from a common base container image. Each of these container images is represented by a SageMaker <code>ImageVersion</code>.</p>', 'refs' => [ 'Images$member' => NULL, ], ], 'ImageArn' => [ 'base' => NULL, 'refs' => [ 'CreateImageResponse$ImageArn' => '<p>The Amazon Resource Name (ARN) of the image.</p>', 'DescribeImageResponse$ImageArn' => '<p>The Amazon Resource Name (ARN) of the image.</p>', 'DescribeImageVersionResponse$ImageArn' => '<p>The Amazon Resource Name (ARN) of the image the version is based on.</p>', 'Image$ImageArn' => '<p>The Amazon Resource Name (ARN) of the image.</p>', 'ImageVersion$ImageArn' => '<p>The Amazon Resource Name (ARN) of the image the version is based on.</p>', 'ResourceSpec$SageMakerImageArn' => '<p>The ARN of the SageMaker image that the image version belongs to.</p>', 'UpdateImageResponse$ImageArn' => '<p>The Amazon Resource Name (ARN) of the image.</p>', ], ], 'ImageBaseImage' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionRequest$BaseImage' => '<p>The registry path of the container image to use as the starting point for this version. The path is an Amazon Container Registry (ECR) URI in the following format:</p> <p> <code>&lt;acct-id&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com/&lt;repo-name[:tag] or [@digest]&gt;</code> </p>', 'DescribeImageVersionResponse$BaseImage' => '<p>The registry path of the container image on which this image version is based.</p>', ], ], 'ImageConfig' => [ 'base' => '<p>Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC).</p>', 'refs' => [ 'ContainerDefinition$ImageConfig' => '<p>Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For information about storing containers in a private Docker registry, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html">Use a Private Docker Registry for Real-Time Inference Containers</a> </p>', ], ], 'ImageContainerImage' => [ 'base' => NULL, 'refs' => [ 'DescribeImageVersionResponse$ContainerImage' => '<p>The registry path of the container image that contains this image version.</p>', ], ], 'ImageDeleteProperty' => [ 'base' => NULL, 'refs' => [ 'ImageDeletePropertyList$member' => NULL, ], ], 'ImageDeletePropertyList' => [ 'base' => NULL, 'refs' => [ 'UpdateImageRequest$DeleteProperties' => '<p>A list of properties to delete. Only the <code>Description</code> and <code>DisplayName</code> properties can be deleted.</p>', ], ], 'ImageDescription' => [ 'base' => NULL, 'refs' => [ 'CreateImageRequest$Description' => '<p>The description of the image.</p>', 'DescribeImageResponse$Description' => '<p>The description of the image.</p>', 'Image$Description' => '<p>The description of the image.</p>', 'UpdateImageRequest$Description' => '<p>The new description for the image.</p>', ], ], 'ImageDigest' => [ 'base' => NULL, 'refs' => [ 'ModelPackageContainerDefinition$ImageDigest' => '<p>An MD5 hash of the training algorithm that identifies the Docker image used for training.</p>', 'TrainingSpecification$TrainingImageDigest' => '<p>An MD5 hash of the training algorithm that identifies the Docker image used for training.</p>', ], ], 'ImageDisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateImageRequest$DisplayName' => '<p>The display name of the image. If not provided, <code>ImageName</code> is displayed.</p>', 'DescribeImageResponse$DisplayName' => '<p>The name of the image as displayed.</p>', 'Image$DisplayName' => '<p>The name of the image as displayed.</p>', 'UpdateImageRequest$DisplayName' => '<p>The new display name for the image.</p>', ], ], 'ImageName' => [ 'base' => NULL, 'refs' => [ 'CreateImageRequest$ImageName' => '<p>The name of the image. Must be unique to your account.</p>', 'CreateImageVersionRequest$ImageName' => '<p>The <code>ImageName</code> of the <code>Image</code> to create a version of.</p>', 'CustomImage$ImageName' => '<p>The name of the CustomImage. Must be unique to your account.</p>', 'DeleteImageRequest$ImageName' => '<p>The name of the image to delete.</p>', 'DeleteImageVersionRequest$ImageName' => '<p>The name of the image.</p>', 'DescribeImageRequest$ImageName' => '<p>The name of the image to describe.</p>', 'DescribeImageResponse$ImageName' => '<p>The name of the image.</p>', 'DescribeImageVersionRequest$ImageName' => '<p>The name of the image.</p>', 'Image$ImageName' => '<p>The name of the image.</p>', 'ListImageVersionsRequest$ImageName' => '<p>The name of the image to list the versions of.</p>', 'UpdateImageRequest$ImageName' => '<p>The name of the image to update.</p>', ], ], 'ImageNameContains' => [ 'base' => NULL, 'refs' => [ 'ListImagesRequest$NameContains' => '<p>A filter that returns only images whose name contains the specified string.</p>', ], ], 'ImageSortBy' => [ 'base' => NULL, 'refs' => [ 'ListImagesRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CREATION_TIME</code>.</p>', ], ], 'ImageSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListImagesRequest$SortOrder' => '<p>The sort order. The default value is <code>DESCENDING</code>.</p>', ], ], 'ImageStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeImageResponse$ImageStatus' => '<p>The status of the image.</p>', 'Image$ImageStatus' => '<p>The status of the image.</p>', ], ], 'ImageUri' => [ 'base' => NULL, 'refs' => [ 'AppSpecification$ImageUri' => '<p>The container image to be run by the processing job.</p>', 'DataQualityAppSpecification$ImageUri' => '<p>The container image that the data quality monitoring job runs.</p>', 'ModelBiasAppSpecification$ImageUri' => '<p>The container image to be run by the model bias job.</p>', 'ModelExplainabilityAppSpecification$ImageUri' => '<p>The container image to be run by the model explainability job.</p>', 'ModelQualityAppSpecification$ImageUri' => '<p>The address of the container image that the monitoring job runs.</p>', 'MonitoringAppSpecification$ImageUri' => '<p>The container image to be run by the monitoring job.</p>', ], ], 'ImageVersion' => [ 'base' => '<p>A version of a SageMaker <code>Image</code>. A version represents an existing container image.</p>', 'refs' => [ 'ImageVersions$member' => NULL, ], ], 'ImageVersionArn' => [ 'base' => NULL, 'refs' => [ 'CreateImageVersionResponse$ImageVersionArn' => '<p>The Amazon Resource Name (ARN) of the image version.</p>', 'DescribeImageVersionResponse$ImageVersionArn' => '<p>The ARN of the version.</p>', 'ImageVersion$ImageVersionArn' => '<p>The ARN of the version.</p>', 'ResourceSpec$SageMakerImageVersionArn' => '<p>The ARN of the image version created on the instance.</p>', ], ], 'ImageVersionNumber' => [ 'base' => NULL, 'refs' => [ 'CustomImage$ImageVersionNumber' => '<p>The version number of the CustomImage.</p>', 'DeleteImageVersionRequest$Version' => '<p>The version to delete.</p>', 'DescribeImageVersionRequest$Version' => '<p>The version of the image. If not specified, the latest version is described.</p>', 'DescribeImageVersionResponse$Version' => '<p>The version number.</p>', 'ImageVersion$Version' => '<p>The version number.</p>', ], ], 'ImageVersionSortBy' => [ 'base' => NULL, 'refs' => [ 'ListImageVersionsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CREATION_TIME</code>.</p>', ], ], 'ImageVersionSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListImageVersionsRequest$SortOrder' => '<p>The sort order. The default value is <code>DESCENDING</code>.</p>', ], ], 'ImageVersionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeImageVersionResponse$ImageVersionStatus' => '<p>The status of the version.</p>', 'ImageVersion$ImageVersionStatus' => '<p>The status of the version.</p>', ], ], 'ImageVersions' => [ 'base' => NULL, 'refs' => [ 'ListImageVersionsResponse$ImageVersions' => '<p>A list of versions and their properties.</p>', ], ], 'Images' => [ 'base' => NULL, 'refs' => [ 'ListImagesResponse$Images' => '<p>A list of images and their properties.</p>', ], ], 'InferenceExecutionConfig' => [ 'base' => '<p>Specifies details about how containers in a multi-container endpoint are run.</p>', 'refs' => [ 'CreateModelInput$InferenceExecutionConfig' => '<p>Specifies details of how containers in a multi-container endpoint are called.</p>', 'DescribeModelOutput$InferenceExecutionConfig' => '<p>Specifies details of how containers in a multi-container endpoint are called.</p>', ], ], 'InferenceExecutionMode' => [ 'base' => NULL, 'refs' => [ 'InferenceExecutionConfig$Mode' => '<p>How containers in a multi-container are run. The following values are valid.</p> <ul> <li> <p> <code>SERIAL</code> - Containers run as a serial pipeline.</p> </li> <li> <p> <code>DIRECT</code> - Only the individual container that you specify is run.</p> </li> </ul>', ], ], 'InferenceImage' => [ 'base' => NULL, 'refs' => [ 'DescribeCompilationJobResponse$InferenceImage' => '<p>The inference image to use when compiling a model. Specify an image only if the target device is a cloud instance.</p>', ], ], 'InferenceRecommendation' => [ 'base' => '<p>A list of recommendations made by Amazon SageMaker Inference Recommender.</p>', 'refs' => [ 'InferenceRecommendations$member' => NULL, ], ], 'InferenceRecommendations' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceRecommendationsJobResponse$InferenceRecommendations' => '<p>The recommendations made by Inference Recommender.</p>', ], ], 'InferenceRecommendationsJob' => [ 'base' => '<p>A structure that contains a list of recommendation jobs.</p>', 'refs' => [ 'InferenceRecommendationsJobs$member' => NULL, ], ], 'InferenceRecommendationsJobs' => [ 'base' => NULL, 'refs' => [ 'ListInferenceRecommendationsJobsResponse$InferenceRecommendationsJobs' => '<p>The recommendations created from the Amazon SageMaker Inference Recommender job.</p>', ], ], 'InferenceSpecification' => [ 'base' => '<p>Defines how to perform inference generation after a training job is run.</p>', 'refs' => [ 'BatchDescribeModelPackageSummary$InferenceSpecification' => NULL, 'CreateAlgorithmInput$InferenceSpecification' => '<p>Specifies details about inference jobs that the algorithm runs, including the following:</p> <ul> <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li> <li> <p>The instance types that the algorithm supports for transform jobs and real-time endpoints used for inference.</p> </li> <li> <p>The input and output content formats that the algorithm supports for inference.</p> </li> </ul>', 'CreateModelPackageInput$InferenceSpecification' => '<p>Specifies details about inference jobs that can be run with models based on this model package, including the following:</p> <ul> <li> <p>The Amazon ECR paths of containers that contain the inference code and model artifacts.</p> </li> <li> <p>The instance types that the model package supports for transform jobs and real-time endpoints used for inference.</p> </li> <li> <p>The input and output content formats that the model package supports for inference.</p> </li> </ul>', 'DescribeAlgorithmOutput$InferenceSpecification' => '<p>Details about inference jobs that the algorithm runs.</p>', 'DescribeModelPackageOutput$InferenceSpecification' => '<p>Details about inference jobs that can be run with models based on this model package.</p>', 'ModelPackage$InferenceSpecification' => NULL, ], ], 'InferenceSpecificationName' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$InferenceSpecificationName' => '<p>The inference specification name in the model package version.</p>', 'EndpointInputConfiguration$InferenceSpecificationName' => '<p>The inference specification name in the model package version.</p>', 'ModelConfiguration$InferenceSpecificationName' => '<p>The inference specification name in the model package version.</p>', ], ], 'InitialNumberOfUsers' => [ 'base' => NULL, 'refs' => [ 'Phase$InitialNumberOfUsers' => '<p>Specifies how many concurrent users to start with.</p>', ], ], 'InitialTaskCount' => [ 'base' => NULL, 'refs' => [ 'ProductionVariant$InitialInstanceCount' => '<p>Number of instances to launch initially.</p>', ], ], 'InputConfig' => [ 'base' => '<p>Contains information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>', 'refs' => [ 'CreateCompilationJobRequest$InputConfig' => '<p>Provides information about the location of input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>', 'DescribeCompilationJobResponse$InputConfig' => '<p>Information about the location in Amazon S3 of the input model artifacts, the name and shape of the expected data inputs, and the framework in which the model was trained.</p>', ], ], 'InputDataConfig' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$InputDataConfig' => '<p>An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code> describes the input data and its location. </p> <p>Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels of input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format. </p> <p>Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files from an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For example, if you specify an EFS location, input data files will be made available as input streams. They do not need to be downloaded.</p>', 'DescribeTrainingJobResponse$InputDataConfig' => '<p>An array of <code>Channel</code> objects that describes each data input channel. </p>', 'HyperParameterTrainingJobDefinition$InputDataConfig' => '<p>An array of <a>Channel</a> objects that specify the input for the training jobs that the tuning job launches.</p>', 'TrainingJob$InputDataConfig' => '<p>An array of <code>Channel</code> objects that describes each data input channel.</p>', 'TrainingJobDefinition$InputDataConfig' => '<p>An array of <code>Channel</code> objects, each of which specifies an input source.</p>', ], ], 'InputMode' => [ 'base' => NULL, 'refs' => [ 'DatasetDefinition$InputMode' => '<p>Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> (default) mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.</p>', ], ], 'InputModes' => [ 'base' => NULL, 'refs' => [ 'ChannelSpecification$SupportedInputModes' => '<p>The allowed input mode, either FILE or PIPE.</p> <p>In FILE mode, Amazon SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before starting your training algorithm. This is the most commonly used input mode.</p> <p>In PIPE mode, Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$InstanceType' => '<p>The type of ML compute instance to launch for the notebook instance.</p>', 'DescribeNotebookInstanceOutput$InstanceType' => '<p>The type of ML compute instance running on the notebook instance.</p>', 'NotebookInstanceSummary$InstanceType' => '<p>The type of ML compute instance that the notebook instance is running on.</p>', 'UpdateNotebookInstanceInput$InstanceType' => '<p>The Amazon ML compute instance type.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$MaxModels' => '<p>The maximum number of models.</p>', 'EndpointOutputConfiguration$InitialInstanceCount' => '<p>The number of instances recommended to launch initially.</p>', 'ModelLatencyThreshold$ValueInMilliseconds' => '<p>The model latency percentile value in milliseconds.</p>', 'RecommendationJobStoppingConditions$MaxInvocations' => '<p>The maximum number of requests per minute expected for the endpoint.</p>', 'RecommendationMetrics$MaxInvocations' => '<p>The expected maximum number of requests per minute for the instance.</p>', 'RecommendationMetrics$ModelLatency' => '<p>The expected model latency at maximum invocation per minute for the instance.</p>', ], ], 'IntegerParameterRange' => [ 'base' => '<p>For a hyperparameter of the integer type, specifies the range that a hyperparameter tuning job searches.</p>', 'refs' => [ 'IntegerParameterRanges$member' => NULL, ], ], 'IntegerParameterRangeSpecification' => [ 'base' => '<p>Defines the possible values for an integer hyperparameter.</p>', 'refs' => [ 'ParameterRange$IntegerParameterRangeSpecification' => '<p>A <code>IntegerParameterRangeSpecification</code> object that defines the possible values for an integer hyperparameter.</p>', ], ], 'IntegerParameterRanges' => [ 'base' => NULL, 'refs' => [ 'ParameterRanges$IntegerParameterRanges' => '<p>The array of <a>IntegerParameterRange</a> objects that specify ranges of integer hyperparameters that a hyperparameter tuning job searches.</p>', ], ], 'IntegerValue' => [ 'base' => NULL, 'refs' => [ 'PipelineExecutionStep$AttemptCount' => '<p>The current attempt of the execution step. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-retry-policy.html">Retry Policy for SageMaker Pipelines steps</a>.</p>', ], ], 'InvocationsMaxRetries' => [ 'base' => NULL, 'refs' => [ 'ModelClientConfig$InvocationsMaxRetries' => '<p>The maximum number of retries when invocation requests are failing.</p>', ], ], 'InvocationsTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'ModelClientConfig$InvocationsTimeoutInSeconds' => '<p>The timeout value in seconds for an invocation request.</p>', ], ], 'IotRoleAlias' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceFleetResponse$IotRoleAlias' => '<p>The Amazon Resource Name (ARN) alias created in Amazon Web Services Internet of Things (IoT).</p>', ], ], 'JobDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobInputConfig$JobDurationInSeconds' => '<p>Specifies the maximum duration of the job, in seconds.&gt;</p>', ], ], 'JobReferenceCode' => [ 'base' => NULL, 'refs' => [ 'DescribeLabelingJobResponse$JobReferenceCode' => '<p>A unique identifier for work done as part of a labeling job.</p>', 'LabelingJobForWorkteamSummary$JobReferenceCode' => '<p>A unique identifier for a labeling job. You can use this to refer to a specific labeling job.</p>', ], ], 'JobReferenceCodeContains' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsForWorkteamRequest$JobReferenceCodeContains' => '<p>A filter the limits jobs to only the ones whose job reference code contains the specified string.</p>', ], ], 'JoinSource' => [ 'base' => NULL, 'refs' => [ 'DataProcessing$JoinSource' => '<p>Specifies the source of the data to join with the transformed data. The valid values are <code>None</code> and <code>Input</code>. The default value is <code>None</code>, which specifies not to join the input with the transformed data. If you want the batch transform job to join the original input data with the transformed data, set <code>JoinSource</code> to <code>Input</code>. You can specify <code>OutputFilter</code> as an additional filter to select a portion of the joined dataset and store it in the output file.</p> <p>For JSON or JSONLines objects, such as a JSON array, SageMaker adds the transformed data to the input JSON object in an attribute called <code>SageMakerOutput</code>. The joined result for JSON must be a key-value pair object. If the input is not a key-value pair object, SageMaker creates a new JSON file. In the new JSON file, and the input data is stored under the <code>SageMakerInput</code> key and the results are stored in <code>SageMakerOutput</code>.</p> <p>For CSV data, SageMaker takes each row as a JSON array and joins the transformed data with the input by appending each transformed row to the end of the input. The joined data has the original input data followed by the transformed data and the output is a CSV file.</p> <p>For information on how joining in applied, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow">Workflow for Associating Inferences with Input Records</a>.</p>', ], ], 'JsonContentType' => [ 'base' => NULL, 'refs' => [ 'JsonContentTypes$member' => NULL, ], ], 'JsonContentTypes' => [ 'base' => NULL, 'refs' => [ 'CaptureContentTypeHeader$JsonContentTypes' => '<p/>', ], ], 'JsonPath' => [ 'base' => NULL, 'refs' => [ 'DataProcessing$InputFilter' => '<p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators">JSONPath</a> expression used to select a portion of the input data to pass to the algorithm. Use the <code>InputFilter</code> parameter to exclude fields, such as an ID column, from the input. If you want Amazon SageMaker to pass the entire input dataset to the algorithm, accept the default value <code>$</code>.</p> <p>Examples: <code>"$"</code>, <code>"$[1:]"</code>, <code>"$.features"</code> </p>', 'DataProcessing$OutputFilter' => '<p>A <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators">JSONPath</a> expression used to select a portion of the joined dataset to save in the output file for a batch transform job. If you want Amazon SageMaker to store the entire input dataset in the output file, leave the default value, <code>$</code>. If you specify indexes that aren\'t within the dimension size of the joined dataset, you get an error.</p> <p>Examples: <code>"$"</code>, <code>"$[0,5:]"</code>, <code>"$[\'id\',\'SageMakerOutput\']"</code> </p>', ], ], 'JupyterServerAppSettings' => [ 'base' => '<p>The JupyterServer app settings.</p>', 'refs' => [ 'UserSettings$JupyterServerAppSettings' => '<p>The Jupyter server\'s app settings.</p>', ], ], 'KernelDisplayName' => [ 'base' => NULL, 'refs' => [ 'KernelSpec$DisplayName' => '<p>The display name of the kernel.</p>', ], ], 'KernelGatewayAppSettings' => [ 'base' => '<p>The KernelGateway app settings.</p>', 'refs' => [ 'UserSettings$KernelGatewayAppSettings' => '<p>The kernel gateway app settings.</p>', ], ], 'KernelGatewayImageConfig' => [ 'base' => '<p>The configuration for the file system and kernels in a SageMaker image running as a KernelGateway app.</p>', 'refs' => [ 'AppImageConfigDetails$KernelGatewayImageConfig' => '<p>The configuration for the file system and kernels in the SageMaker image.</p>', 'CreateAppImageConfigRequest$KernelGatewayImageConfig' => '<p>The KernelGatewayImageConfig.</p>', 'DescribeAppImageConfigResponse$KernelGatewayImageConfig' => '<p>The configuration of a KernelGateway app.</p>', 'UpdateAppImageConfigRequest$KernelGatewayImageConfig' => '<p>The new KernelGateway app to run on the image.</p>', ], ], 'KernelName' => [ 'base' => NULL, 'refs' => [ 'KernelSpec$Name' => '<p>The name of the Jupyter kernel in the image. This value is case sensitive.</p>', ], ], 'KernelSpec' => [ 'base' => '<p>The specification of a Jupyter kernel.</p>', 'refs' => [ 'KernelSpecs$member' => NULL, ], ], 'KernelSpecs' => [ 'base' => NULL, 'refs' => [ 'KernelGatewayImageConfig$KernelSpecs' => '<p>The specification of the Jupyter kernels in the image.</p>', ], ], 'Key' => [ 'base' => NULL, 'refs' => [ 'PipelineDefinitionS3Location$ObjectKey' => '<p>The object key (or key name) uniquely identifies the object in an S3 bucket. </p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'AsyncInferenceOutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the asynchronous inference output in Amazon S3.</p> <p/>', 'AthenaDatasetDefinition$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data generated from an Athena query execution.</p>', 'AutoMLOutputDataConfig$KmsKeyId' => '<p>The Amazon Web Services KMS encryption key ID.</p>', 'AutoMLSecurityConfig$VolumeKmsKeyId' => '<p>The key used to encrypt stored data.</p>', 'CreateDomainRequest$HomeEfsFileSystemKmsKeyId' => '<p>Use <code>KmsKeyId</code>.</p>', 'CreateDomainRequest$KmsKeyId' => '<p>SageMaker uses Amazon Web Services KMS to encrypt the EFS volume attached to the domain with an Amazon Web Services managed key by default. For more control, specify a customer managed key.</p>', 'CreateEdgePackagingJobRequest$ResourceKey' => '<p>The Amazon Web Services KMS key to use when encrypting the EBS volume the edge packaging job runs on.</p>', 'CreateEndpointConfigInput$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.</p> <p>The KmsKeyId can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code>, <code>UpdateEndpoint</code> requests. For more information, refer to the Amazon Web Services Key Management Service section<a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html"> Using Key Policies in Amazon Web Services KMS </a> </p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>KmsKeyId</code> when using an instance type with local storage. If any of the models that you specify in the <code>ProductionVariants</code> parameter use nitro-based instances with local storage, do not specify a value for the <code>KmsKeyId</code> parameter. If you specify a value for <code>KmsKeyId</code> when using any nitro-based instances with local storage, the call to <code>CreateEndpointConfig</code> fails.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note>', 'CreateNotebookInstanceInput$KmsKeyId' => '<p>The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service key that Amazon SageMaker uses to encrypt data on the storage volume attached to your notebook instance. The KMS key you provide must be enabled. For information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html">Enabling and Disabling Keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', 'DataCaptureConfig$KmsKeyId' => '<p/>', 'DataCaptureConfigSummary$KmsKeyId' => '<p/>', 'DescribeDomainResponse$HomeEfsFileSystemKmsKeyId' => '<p>Use <code>KmsKeyId</code>.</p>', 'DescribeDomainResponse$KmsKeyId' => '<p>The Amazon Web Services KMS customer managed key used to encrypt the EFS volume attached to the domain.</p>', 'DescribeEdgePackagingJobResponse$ResourceKey' => '<p>The Amazon Web Services KMS key to use when encrypting the EBS volume the job run on.</p>', 'DescribeEndpointConfigOutput$KmsKeyId' => '<p>Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance.</p>', 'DescribeNotebookInstanceOutput$KmsKeyId' => '<p>The Amazon Web Services KMS key ID Amazon SageMaker uses to encrypt data when storing it on the ML storage volume attached to the instance. </p>', 'EdgeOutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account.</p>', 'FlowDefinitionOutputConfig$KmsKeyId' => '<p>The Amazon Key Management Service (KMS) key ID for server-side encryption.</p>', 'LabelingJobOutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service ID of the key used to encrypt the output data, if any.</p> <p>If you provide your own KMS key ID, you must add the required permissions to your KMS key described in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions">Encrypt Output Data and Storage Volume with Amazon Web Services KMS</a>.</p> <p>If you don\'t provide a KMS key ID, Amazon SageMaker uses the default Amazon Web Services KMS key for Amazon S3 for your role\'s account to encrypt your output data.</p> <p>If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p>', 'LabelingJobResourceConfig$VolumeKmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training and inference jobs used for automated data labeling. </p> <p>You can only specify a <code>VolumeKmsKeyId</code> when you create a labeling job with automated data labeling enabled using the API operation <code>CreateLabelingJob</code>. You cannot specify an Amazon Web Services KMS key to encrypt the storage volume used for automated data labeling model training and inference when you create a labeling job using the console. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security.html">Output Data and Storage Volume Encryption</a>.</p> <p>The <code>VolumeKmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'MonitoringClusterConfig$VolumeKmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.</p>', 'MonitoringOutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.</p>', 'OnlineStoreSecurityConfig$KmsKeyId' => '<p>The ID of the Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.</p> <p>The caller (either IAM user or IAM role) of <code>CreateFeatureGroup</code> must have below permissions to the <code>OnlineStore</code> <code>KmsKeyId</code>:</p> <ul> <li> <p> <code>"kms:Encrypt"</code> </p> </li> <li> <p> <code>"kms:Decrypt"</code> </p> </li> <li> <p> <code>"kms:DescribeKey"</code> </p> </li> <li> <p> <code>"kms:CreateGrant"</code> </p> </li> <li> <p> <code>"kms:RetireGrant"</code> </p> </li> <li> <p> <code>"kms:ReEncryptFrom"</code> </p> </li> <li> <p> <code>"kms:ReEncryptTo"</code> </p> </li> <li> <p> <code>"kms:GenerateDataKey"</code> </p> </li> <li> <p> <code>"kms:ListAliases"</code> </p> </li> <li> <p> <code>"kms:ListGrants"</code> </p> </li> <li> <p> <code>"kms:RevokeGrant"</code> </p> </li> </ul> <p>The caller (either IAM user or IAM role) to all DataPlane operations (<code>PutRecord</code>, <code>GetRecord</code>, <code>DeleteRecord</code>) must have the following permissions to the <code>KmsKeyId</code>:</p> <ul> <li> <p> <code>"kms:Decrypt"</code> </p> </li> </ul>', 'OutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service key (Amazon Web Services KMS) that Amazon SageMaker uses to encrypt your output models with Amazon S3 server-side encryption after compilation job. If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KmsKeyId can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', 'OutputDataConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// KMS Key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key Alias</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul> <p>If you use a KMS key ID or an alias of your KMS key, the Amazon SageMaker execution role must include permissions to call <code>kms:Encrypt</code>. If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. Amazon SageMaker uses server-side encryption with KMS-managed keys for <code>OutputDataConfig</code>. If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateTrainingJob</code>, <code>CreateTransformJob</code>, or <code>CreateHyperParameterTuningJob</code> requests. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', 'ProcessingClusterConfig$VolumeKmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the processing job. </p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note>', 'ProcessingOutputConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the processing job output. <code>KmsKeyId</code> can be an ID of a KMS key, ARN of a KMS key, alias of a KMS key, or alias of a KMS key. The <code>KmsKeyId</code> is applied to all outputs.</p>', 'ProductionVariantCoreDumpConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the core dump data at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// KMS Key Alias</p> <p> <code>"alias/ExampleAlias"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key Alias</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"</code> </p> </li> </ul> <p>If you use a KMS key ID or an alias of your KMS key, the Amazon SageMaker execution role must include permissions to call <code>kms:Encrypt</code>. If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. Amazon SageMaker uses server-side encryption with KMS-managed keys for <code>OutputDataConfig</code>. If you use a bucket policy with an <code>s3:PutObject</code> permission that only allows objects with server-side encryption, set the condition key of <code>s3:x-amz-server-side-encryption</code> to <code>"aws:kms"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <code>CreateEndpoint</code> and <code>UpdateEndpoint</code> requests. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', 'RedshiftDatasetDefinition$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data from a Redshift execution.</p>', 'ResourceConfig$VolumeKmsKeyId' => '<p>The Amazon Web Services KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the training job.</p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note> <p>The <code>VolumeKmsKeyId</code> can be in any of the following formats:</p> <ul> <li> <p>// KMS Key ID</p> <p> <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> <li> <p>// Amazon Resource Name (ARN) of a KMS Key</p> <p> <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code> </p> </li> </ul>', 'S3StorageConfig$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (KMS) key ID of the key used to encrypt any objects written into the <code>OfflineStore</code> S3 location.</p> <p>The IAM <code>roleARN</code> that is passed as a parameter to <code>CreateFeatureGroup</code> must have below permissions to the <code>KmsKeyId</code>:</p> <ul> <li> <p> <code>"kms:GenerateDataKey"</code> </p> </li> </ul>', 'SharingSettings$S3KmsKeyId' => '<p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon Web Services Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.</p>', 'TransformOutput$KmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption. The <code>KmsKeyId</code> can be any of the following formats: </p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul> <p>If you don\'t provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role\'s account. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KMS-Managed Encryption Keys</a> in the <i>Amazon Simple Storage Service Developer Guide.</i> </p> <p>The KMS key policy must grant permission to the IAM role that you specify in your <a>CreateModel</a> request. For more information, see <a href="http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Using Key Policies in Amazon Web Services KMS</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>', 'TransformResources$VolumeKmsKeyId' => '<p>The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt model data on the storage volume attached to the ML compute instance(s) that run the batch transform job.</p> <note> <p>Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are encrypted using a hardware module on the instance. You can\'t request a <code>VolumeKmsKeyId</code> when using an instance type with local storage.</p> <p>For a list of instance types that support local instance storage, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> <p>For more information about local instance storage encryption, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store Volumes</a>.</p> </note> <p> The <code>VolumeKmsKeyId</code> can be any of the following formats:</p> <ul> <li> <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Key ARN: <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> <li> <p>Alias name: <code>alias/ExampleAlias</code> </p> </li> <li> <p>Alias name ARN: <code>arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias</code> </p> </li> </ul>', ], ], 'LabelAttributeName' => [ 'base' => NULL, 'refs' => [ 'CreateLabelingJobRequest$LabelAttributeName' => '<p>The attribute name to use for the label in the output manifest file. This is the key for the key/value pair formed with the label that a worker assigns to the object. The <code>LabelAttributeName</code> must meet the following requirements.</p> <ul> <li> <p>The name can\'t end with "-metadata". </p> </li> <li> <p>If you are using one of the following <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, the attribute name <i>must</i> end with "-ref". If the task type you are using is not listed below, the attribute name <i>must not</i> end with "-ref".</p> <ul> <li> <p>Image semantic segmentation (<code>SemanticSegmentation)</code>, and adjustment (<code>AdjustmentSemanticSegmentation</code>) and verification (<code>VerificationSemanticSegmentation</code>) labeling jobs for this task type.</p> </li> <li> <p>Video frame object detection (<code>VideoObjectDetection</code>), and adjustment and verification (<code>AdjustmentVideoObjectDetection</code>) labeling jobs for this task type.</p> </li> <li> <p>Video frame object tracking (<code>VideoObjectTracking</code>), and adjustment and verification (<code>AdjustmentVideoObjectTracking</code>) labeling jobs for this task type.</p> </li> <li> <p>3D point cloud semantic segmentation (<code>3DPointCloudSemanticSegmentation</code>), and adjustment and verification (<code>Adjustment3DPointCloudSemanticSegmentation</code>) labeling jobs for this task type. </p> </li> <li> <p>3D point cloud object tracking (<code>3DPointCloudObjectTracking</code>), and adjustment and verification (<code>Adjustment3DPointCloudObjectTracking</code>) labeling jobs for this task type. </p> </li> </ul> </li> </ul> <p/> <important> <p>If you are creating an adjustment or verification labeling job, you must use a <i>different</i> <code>LabelAttributeName</code> than the one used in the original labeling job. The original labeling job is the Ground Truth labeling job that produced the labels that you want verified or adjusted. To learn more about adjustment and verification labeling jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels</a>.</p> </important>', 'DescribeLabelingJobResponse$LabelAttributeName' => '<p>The attribute used as the label in the output manifest file.</p>', ], ], 'LabelCounter' => [ 'base' => NULL, 'refs' => [ 'LabelCounters$TotalLabeled' => '<p>The total number of objects labeled.</p>', 'LabelCounters$HumanLabeled' => '<p>The total number of objects labeled by a human worker.</p>', 'LabelCounters$MachineLabeled' => '<p>The total number of objects labeled by automated data labeling.</p>', 'LabelCounters$FailedNonRetryableError' => '<p>The total number of objects that could not be labeled due to an error.</p>', 'LabelCounters$Unlabeled' => '<p>The total number of objects not yet labeled.</p>', 'LabelCountersForWorkteam$HumanLabeled' => '<p>The total number of data objects labeled by a human worker.</p>', 'LabelCountersForWorkteam$PendingHuman' => '<p>The total number of data objects that need to be labeled by a human worker.</p>', 'LabelCountersForWorkteam$Total' => '<p>The total number of tasks in the labeling job.</p>', ], ], 'LabelCounters' => [ 'base' => '<p>Provides a breakdown of the number of objects labeled.</p>', 'refs' => [ 'DescribeLabelingJobResponse$LabelCounters' => '<p>Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine, the number of objects than couldn\'t be labeled, and the total number of objects labeled. </p>', 'LabelingJobSummary$LabelCounters' => '<p>Counts showing the progress of the labeling job.</p>', ], ], 'LabelCountersForWorkteam' => [ 'base' => '<p>Provides counts for human-labeled tasks in the labeling job.</p>', 'refs' => [ 'LabelingJobForWorkteamSummary$LabelCounters' => '<p>Provides information about the progress of a labeling job.</p>', ], ], 'LabelingJobAlgorithmSpecificationArn' => [ 'base' => NULL, 'refs' => [ 'LabelingJobAlgorithmsConfig$LabelingJobAlgorithmSpecificationArn' => '<p>Specifies the Amazon Resource Name (ARN) of the algorithm used for auto-labeling. You must select one of the following ARNs:</p> <ul> <li> <p> <i>Image classification</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/image-classification</code> </p> </li> <li> <p> <i>Text classification</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/text-classification</code> </p> </li> <li> <p> <i>Object detection</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/object-detection</code> </p> </li> <li> <p> <i>Semantic Segmentation</i> </p> <p> <code>arn:aws:sagemaker:<i>region</i>:027400017018:labeling-job-algorithm-specification/semantic-segmentation</code> </p> </li> </ul>', ], ], 'LabelingJobAlgorithmsConfig' => [ 'base' => '<p>Provides configuration information for auto-labeling of your data objects. A <code>LabelingJobAlgorithmsConfig</code> object must be supplied in order to use auto-labeling.</p>', 'refs' => [ 'CreateLabelingJobRequest$LabelingJobAlgorithmsConfig' => '<p>Configures the information required to perform automated data labeling.</p>', 'DescribeLabelingJobResponse$LabelingJobAlgorithmsConfig' => '<p>Configuration information for automated data labeling.</p>', ], ], 'LabelingJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateLabelingJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job. You use this ARN to identify the labeling job.</p>', 'DescribeLabelingJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job.</p>', 'DescribeTrainingJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>', 'DescribeTransformJobResponse$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SageMaker Ground Truth labeling job that created the transform or training job.</p>', 'LabelingJobSummary$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) assigned to the labeling job when it was created.</p>', 'TrainingJob$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job.</p>', 'TransformJob$LabelingJobArn' => '<p>The Amazon Resource Name (ARN) of the labeling job that created the transform job.</p>', ], ], 'LabelingJobDataAttributes' => [ 'base' => '<p>Attributes of the data specified by the customer. Use these to describe the data to be labeled.</p>', 'refs' => [ 'LabelingJobInputConfig$DataAttributes' => '<p>Attributes of the data specified by the customer.</p>', ], ], 'LabelingJobDataSource' => [ 'base' => '<p>Provides information about the location of input data.</p> <p>You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>.</p> <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job.</p> <p>Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a streaming labeling job.</p>', 'refs' => [ 'LabelingJobInputConfig$DataSource' => '<p>The location of the input data.</p>', ], ], 'LabelingJobForWorkteamSummary' => [ 'base' => '<p>Provides summary information for a work team.</p>', 'refs' => [ 'LabelingJobForWorkteamSummaryList$member' => NULL, ], ], 'LabelingJobForWorkteamSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsForWorkteamResponse$LabelingJobSummaryList' => '<p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>', ], ], 'LabelingJobInputConfig' => [ 'base' => '<p>Input configuration information for a labeling job.</p>', 'refs' => [ 'CreateLabelingJobRequest$InputConfig' => '<p>Input data for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p> <p>You must specify at least one of the following: <code>S3DataSource</code> or <code>SnsDataSource</code>. </p> <ul> <li> <p>Use <code>SnsDataSource</code> to specify an SNS input topic for a streaming labeling job. If you do not specify and SNS input topic ARN, Ground Truth will create a one-time labeling job that stops after all data objects in the input manifest file have been labeled.</p> </li> <li> <p>Use <code>S3DataSource</code> to specify an input manifest file for both streaming and one-time labeling jobs. Adding an <code>S3DataSource</code> is optional if you use <code>SnsDataSource</code> to create a streaming labeling job.</p> </li> </ul> <p>If you use the Amazon Mechanical Turk workforce, your input data should not include confidential information, personal information or protected health information. Use <code>ContentClassifiers</code> to specify that your data is free of personally identifiable information and adult content.</p>', 'DescribeLabelingJobResponse$InputConfig' => '<p>Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the location of the manifest file that describes the data objects.</p>', 'LabelingJobSummary$InputConfig' => '<p>Input configuration for the labeling job.</p>', ], ], 'LabelingJobName' => [ 'base' => NULL, 'refs' => [ 'CreateLabelingJobRequest$LabelingJobName' => '<p>The name of the labeling job. This name is used to identify the job in a list of labeling jobs. Labeling job names must be unique within an Amazon Web Services account and region. <code>LabelingJobName</code> is not case sensitive. For example, Example-job and example-job are considered the same labeling job name by Ground Truth.</p>', 'DescribeLabelingJobRequest$LabelingJobName' => '<p>The name of the labeling job to return information for.</p>', 'DescribeLabelingJobResponse$LabelingJobName' => '<p>The name assigned to the labeling job when it was created.</p>', 'LabelingJobForWorkteamSummary$LabelingJobName' => '<p>The name of the labeling job that the work team is assigned to.</p>', 'LabelingJobSummary$LabelingJobName' => '<p>The name of the labeling job.</p>', 'StopLabelingJobRequest$LabelingJobName' => '<p>The name of the labeling job to stop.</p>', ], ], 'LabelingJobOutput' => [ 'base' => '<p>Specifies the location of the output produced by the labeling job. </p>', 'refs' => [ 'DescribeLabelingJobResponse$LabelingJobOutput' => '<p>The location of the output produced by the labeling job.</p>', 'LabelingJobSummary$LabelingJobOutput' => '<p>The location of the output produced by the labeling job.</p>', ], ], 'LabelingJobOutputConfig' => [ 'base' => '<p>Output configuration information for a labeling job.</p>', 'refs' => [ 'CreateLabelingJobRequest$OutputConfig' => '<p>The location of the output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>', 'DescribeLabelingJobResponse$OutputConfig' => '<p>The location of the job\'s output data and the Amazon Web Services Key Management Service key ID for the key used to encrypt the output data, if any.</p>', ], ], 'LabelingJobResourceConfig' => [ 'base' => '<p>Configure encryption on the storage volume attached to the ML compute instance used to run automated data labeling model training and inference. </p>', 'refs' => [ 'LabelingJobAlgorithmsConfig$LabelingJobResourceConfig' => '<p>Provides configuration information for a labeling job.</p>', ], ], 'LabelingJobS3DataSource' => [ 'base' => '<p>The Amazon S3 location of the input data objects.</p>', 'refs' => [ 'LabelingJobDataSource$S3DataSource' => '<p>The Amazon S3 location of the input data objects.</p>', ], ], 'LabelingJobSnsDataSource' => [ 'base' => '<p>An Amazon SNS data source used for streaming labeling jobs.</p>', 'refs' => [ 'LabelingJobDataSource$SnsDataSource' => '<p>An Amazon SNS data source used for streaming labeling jobs. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-send-data">Send Data to a Streaming Labeling Job</a>. </p>', ], ], 'LabelingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeLabelingJobResponse$LabelingJobStatus' => '<p>The processing status of the labeling job. </p>', 'LabelingJobSummary$LabelingJobStatus' => '<p>The current status of the labeling job. </p>', 'ListLabelingJobsRequest$StatusEquals' => '<p>A filter that retrieves only labeling jobs with a specific status.</p>', ], ], 'LabelingJobStoppingConditions' => [ 'base' => '<p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p> <note> <p>Labeling jobs fail after 30 days with an appropriate client error message.</p> </note>', 'refs' => [ 'CreateLabelingJobRequest$StoppingConditions' => '<p>A set of conditions for stopping the labeling job. If any of the conditions are met, the job is automatically stopped. You can use these conditions to control the cost of data labeling.</p>', 'DescribeLabelingJobResponse$StoppingConditions' => '<p>A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically stopped.</p>', ], ], 'LabelingJobSummary' => [ 'base' => '<p>Provides summary information about a labeling job.</p>', 'refs' => [ 'LabelingJobSummaryList$member' => NULL, ], ], 'LabelingJobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsResponse$LabelingJobSummaryList' => '<p>An array of <code>LabelingJobSummary</code> objects, each describing a labeling job.</p>', ], ], 'LambdaFunctionArn' => [ 'base' => NULL, 'refs' => [ 'AnnotationConsolidationConfig$AnnotationConsolidationLambdaArn' => '<p>The Amazon Resource Name (ARN) of a Lambda function implements the logic for <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">annotation consolidation</a> and to process output data.</p> <p>This parameter is required for all labeling jobs. For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for <code>AnnotationConsolidationLambdaArn</code>. For custom labeling workflows, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda">Post-annotation Lambda</a>. </p> <p> <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox</code> </p> </li> </ul> <p> <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass</code> </p> </li> </ul> <p> <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation</code> </p> </li> </ul> <p> <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass</code> </p> </li> </ul> <p> <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition</code> </p> </li> </ul> <p> <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoMultiClass</code> </p> </li> </ul> <p> <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Use the following ARNs for Label Verification and Adjustment Jobs</b> </p> <p>Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels </a>.</p> <p> <b>Semantic Segmentation Adjustment</b> - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation</code> </p> </li> </ul> <p> <b>Semantic Segmentation Verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation</code> </p> </li> </ul> <p> <b>Bounding Box Adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox</code> </p> </li> </ul> <p> <b>Bounding Box Verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox</code> </p> </li> </ul> <p> <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Detection Adjustment</b> - Use this task type when you want workers to adjust 3D cuboids around objects in a 3D point cloud. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking Adjustment</b> - Use this task type when you want workers to adjust 3D cuboids around objects that appear in a sequence of 3D point cloud frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation Adjustment</b> - Use this task type when you want workers to adjust a point-level semantic segmentation masks using a paint tool.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> </ul>', 'HumanTaskConfig$PreHumanTaskLambdaArn' => '<p>The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human worker. Use this function to provide input to a custom labeling job.</p> <p>For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for <code>PreHumanTaskLambdaArn</code>. For custom labeling workflows, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda">Pre-annotation Lambda</a>. </p> <p> <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the boxes.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code> </p> </li> </ul> <p> <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code> </p> </li> </ul> <p> <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of an image based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code> </p> </li> </ul> <p> <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code> </p> </li> </ul> <p> <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true classes of text based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel</code> </p> </li> </ul> <p> <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to most-assigned label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code> </p> </li> </ul> <p> <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined labels that you specify. Workers are shown videos and are asked to choose one label for each video.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass</code> </p> </li> </ul> <p> <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Modalities</b> </p> <p>Use the following pre-annotation lambdas for 3D point cloud labeling modality tasks. See <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html">3D Point Cloud Task types </a> to learn more. </p> <p> <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask workers to track the movement of vehicles across multiple point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is assigned to one of the classes you specify.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation</code> </p> </li> </ul> <p> <b>Use the following ARNs for Label Verification and Adjustment Jobs</b> </p> <p>Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels </a>.</p> <p> <b>Bounding box verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgement for bounding box labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationBoundingBox</code> </p> </li> </ul> <p> <b>Bounding box adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard index of the adjusted annotations.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox</code> </p> </li> </ul> <p> <b>Semantic segmentation verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class of verification judgment for semantic segmentation labels based on annotations from individual workers.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation</code> </p> </li> </ul> <p> <b>Semantic segmentation adjustment</b> - Treats each pixel in an image as a multi-class classification and treats pixel adjusted annotations from workers as "votes" for the correct label.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation</code> </p> </li> </ul> <p> <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection</code> </p> </li> </ul> <p> <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding boxes that workers have added to video frames to track object movement across a sequence of video frames.</p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud object detection adjustment</b> - Adjust 3D cuboids in a point cloud frame. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection</code> </p> </li> </ul> <p> <b>3D point cloud object tracking adjustment</b> - Adjust 3D cuboids across a sequence of point cloud frames. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking</code> </p> </li> </ul> <p> <b>3D point cloud semantic segmentation adjustment</b> - Adjust semantic segmentation masks in a 3D point cloud. </p> <ul> <li> <p> <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> <li> <p> <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code> </p> </li> </ul>', 'LabelingJobSummary$PreHumanTaskLambdaArn' => '<p>The Amazon Resource Name (ARN) of a Lambda function. The function is run before each data object is sent to a worker.</p>', 'LabelingJobSummary$AnnotationConsolidationLambdaArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function used to consolidate the annotations from individual workers into a label for a data object. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html">Annotation Consolidation</a>.</p>', ], ], 'LambdaStepMetadata' => [ 'base' => '<p>Metadata for a Lambda step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Lambda' => '<p>The Amazon Resource Name (ARN) of the Lambda function that was run by this step execution and a list of output parameters.</p>', ], ], 'LastModifiedTime' => [ 'base' => NULL, 'refs' => [ 'CodeRepositorySummary$LastModifiedTime' => '<p>The date and time that the Git repository was last modified.</p>', 'CompilationJobSummary$LastModifiedTime' => '<p>The time when the model compilation job was last modified.</p>', 'DescribeCodeRepositoryOutput$LastModifiedTime' => '<p>The date and time that the repository was last changed.</p>', 'DescribeCompilationJobResponse$LastModifiedTime' => '<p>The time that the status of the model compilation job was last modified.</p>', 'DescribeDomainResponse$LastModifiedTime' => '<p>The last modified time.</p>', 'DescribeInferenceRecommendationsJobResponse$LastModifiedTime' => '<p>A timestamp that shows when the job was last modified.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$LastModifiedTime' => '<p>A timestamp that tells when the lifecycle configuration was last modified.</p>', 'DescribeNotebookInstanceOutput$LastModifiedTime' => '<p>A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified. </p>', 'DescribeUserProfileResponse$LastModifiedTime' => '<p>The last modified time.</p>', 'DomainDetails$LastModifiedTime' => '<p>The last modified time.</p>', 'InferenceRecommendationsJob$LastModifiedTime' => '<p>A timestamp that shows when the job was last modified.</p>', 'ListCompilationJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns the model compilation jobs that were modified after a specified time.</p>', 'ListCompilationJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns the model compilation jobs that were modified before a specified time.</p>', 'ListInferenceRecommendationsJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only jobs that were last modified after the specified time (timestamp).</p>', 'ListInferenceRecommendationsJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only jobs that were last modified before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$LastModifiedTimeBefore' => '<p>A filter that returns only lifecycle configurations that were modified before the specified time (timestamp).</p>', 'ListNotebookInstanceLifecycleConfigsInput$LastModifiedTimeAfter' => '<p>A filter that returns only lifecycle configurations that were modified after the specified time (timestamp).</p>', 'ListNotebookInstancesInput$LastModifiedTimeBefore' => '<p>A filter that returns only notebook instances that were modified before the specified time (timestamp).</p>', 'ListNotebookInstancesInput$LastModifiedTimeAfter' => '<p>A filter that returns only notebook instances that were modified after the specified time (timestamp).</p>', 'NotebookInstanceLifecycleConfigSummary$LastModifiedTime' => '<p>A timestamp that tells when the lifecycle configuration was last modified.</p>', 'NotebookInstanceSummary$LastModifiedTime' => '<p>A timestamp that shows when the notebook instance was last modified.</p>', 'UserProfileDetails$LastModifiedTime' => '<p>The last modified time.</p>', ], ], 'LifecycleConfigArns' => [ 'base' => NULL, 'refs' => [ 'JupyterServerAppSettings$LifecycleConfigArns' => '<p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the JupyterServerApp.</p>', 'KernelGatewayAppSettings$LifecycleConfigArns' => '<p> The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the the user profile or domain.</p>', ], ], 'LineageEntityParameters' => [ 'base' => NULL, 'refs' => [ 'CreateActionRequest$Properties' => '<p>A list of properties to add to the action.</p>', 'CreateArtifactRequest$Properties' => '<p>A list of properties to add to the artifact.</p>', 'CreateContextRequest$Properties' => '<p>A list of properties to add to the context.</p>', 'DescribeActionResponse$Properties' => '<p>A list of the action\'s properties.</p>', 'DescribeArtifactResponse$Properties' => '<p>A list of the artifact\'s properties.</p>', 'DescribeContextResponse$Properties' => '<p>A list of the context\'s properties.</p>', 'UpdateActionRequest$Properties' => '<p>The new list of properties. Overwrites the current property list.</p>', 'UpdateArtifactRequest$Properties' => '<p>The new list of properties. Overwrites the current property list.</p>', 'UpdateContextRequest$Properties' => '<p>The new list of properties. Overwrites the current property list.</p>', ], ], 'LineageGroupArn' => [ 'base' => NULL, 'refs' => [ 'DescribeActionResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'DescribeArtifactResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'DescribeContextResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'DescribeLineageGroupResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'DescribeTrialComponentResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'GetLineageGroupPolicyResponse$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group.</p>', 'LineageGroupSummary$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group resource.</p>', 'TrialComponent$LineageGroupArn' => '<p>The Amazon Resource Name (ARN) of the lineage group resource.</p>', ], ], 'LineageGroupNameOrArn' => [ 'base' => NULL, 'refs' => [ 'GetLineageGroupPolicyRequest$LineageGroupName' => '<p>The name or Amazon Resource Name (ARN) of the lineage group.</p>', ], ], 'LineageGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'ListLineageGroupsResponse$LineageGroupSummaries' => '<p>A list of lineage groups and their properties.</p>', ], ], 'LineageGroupSummary' => [ 'base' => '<p>Lists a summary of the properties of a lineage group. A lineage group provides a group of shareable lineage entity resources.</p>', 'refs' => [ 'LineageGroupSummaries$member' => NULL, ], ], 'LineageType' => [ 'base' => NULL, 'refs' => [ 'QueryLineageTypes$member' => NULL, 'Vertex$LineageType' => '<p>The type of resource of the lineage entity.</p>', ], ], 'ListActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAlgorithmsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAlgorithmsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListAppImageConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppImageConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListArtifactsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListArtifactsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAutoMLJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAutoMLJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCandidatesForAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCandidatesForAutoMLJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCodeRepositoriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListCodeRepositoriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListCompilationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCompilationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCompilationJobsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListCompilationJobsRequest$SortBy' => '<p>The field by which to sort results. The default is <code>CreationTime</code>.</p>', ], ], 'ListContextsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContextsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataQualityJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataQualityJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceFleetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceFleetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDeviceFleetsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListDeviceFleetsRequest$SortBy' => '<p>The column to sort by.</p>', ], ], 'ListDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDevicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDomainsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEdgePackagingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEdgePackagingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEdgePackagingJobsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListEdgePackagingJobsRequest$SortBy' => '<p>Use to specify what column to sort by.</p>', ], ], 'ListEndpointConfigsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointConfigsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFeatureGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFeatureGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHumanTaskUisRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHumanTaskUisResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHyperParameterTuningJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHyperParameterTuningJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImageVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImageVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceRecommendationsJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceRecommendationsJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceRecommendationsJobsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListInferenceRecommendationsJobsRequest$SortBy' => '<p>The parameter by which to sort the results.</p>', ], ], 'ListLabelingJobsForWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsForWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsForWorkteamSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsForWorkteamRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'ListLabelingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLabelingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLineageEntityParameterKey' => [ 'base' => NULL, 'refs' => [ 'UpdateActionRequest$PropertiesToRemove' => '<p>A list of properties to remove.</p>', 'UpdateArtifactRequest$PropertiesToRemove' => '<p>A list of properties to remove.</p>', 'UpdateContextRequest$PropertiesToRemove' => '<p>A list of properties to remove.</p>', ], ], 'ListLineageGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLineageGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListDeviceFleetsRequest$MaxResults' => '<p>The maximum number of results to select.</p>', 'ListDevicesRequest$MaxResults' => '<p>Maximum number of results to select.</p>', 'ListEdgePackagingJobsRequest$MaxResults' => '<p>Maximum number of results to select.</p>', ], ], 'ListModelBiasJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelBiasJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelExplainabilityJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelExplainabilityJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackageGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackageGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackagesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelPackagesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelQualityJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelQualityJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListModelsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringSchedulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitoringSchedulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstanceLifecycleConfigsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstanceLifecycleConfigsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineExecutionStepsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineExecutionStepsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineParametersForExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelineParametersForExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelinesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipelinesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProcessingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProcessingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioLifecycleConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioLifecycleConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscribedWorkteamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSubscribedWorkteamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTagsInput$MaxResults' => '<p>Maximum number of tags to return.</p>', ], ], 'ListTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsForHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsForHyperParameterTuningJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrainingJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTransformJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTransformJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialComponentKey256' => [ 'base' => NULL, 'refs' => [ 'UpdateTrialComponentRequest$ParametersToRemove' => '<p>The hyperparameters to remove from the component.</p>', 'UpdateTrialComponentRequest$InputArtifactsToRemove' => '<p>The input artifacts to remove from the component.</p>', 'UpdateTrialComponentRequest$OutputArtifactsToRemove' => '<p>The output artifacts to remove from the component.</p>', ], ], 'ListTrialComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkforcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkforcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkforcesSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListWorkforcesRequest$SortBy' => '<p>Sort workforces using the workforce name or creation date.</p>', ], ], 'ListWorkteamsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkteamsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkteamsSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListWorkteamsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AgentVersion$AgentCount' => '<p>The number of Edge Manager agents.</p>', 'DeviceStats$ConnectedDeviceCount' => '<p>The number of devices connected with a heartbeat.</p>', 'DeviceStats$RegisteredDeviceCount' => '<p>The number of registered devices.</p>', 'EdgeModelStat$OfflineDeviceCount' => '<p>The number of devices that have this model version and do not have a heart beat.</p>', 'EdgeModelStat$ConnectedDeviceCount' => '<p>The number of devices that have this model version and have a heart beat. </p>', 'EdgeModelStat$ActiveDeviceCount' => '<p>The number of devices that have this model version, a heart beat, and are currently running.</p>', 'EdgeModelStat$SamplingDeviceCount' => '<p>The number of devices with this model version and are producing sample data.</p>', ], ], 'MaxAutoMLJobRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobCompletionCriteria$MaxAutoMLJobRuntimeInSeconds' => '<p>The maximum runtime, in seconds, an AutoML job has to complete.</p> <p>If an AutoML job exceeds the maximum runtime, the job is stopped automatically and its processing is ended gracefully. The AutoML job identifies the best model whose training was completed and marks it as the best-performing model. Any unfinished steps of the job, such as automatic one-click Autopilot model deployment, will not be completed. </p>', ], ], 'MaxCandidates' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobCompletionCriteria$MaxCandidates' => '<p>The maximum number of times a training job is allowed to run.</p>', ], ], 'MaxConcurrentInvocationsPerInstance' => [ 'base' => NULL, 'refs' => [ 'AsyncInferenceClientConfig$MaxConcurrentInvocationsPerInstance' => '<p>The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is provided, Amazon SageMaker will choose an optimal value for you.</p>', ], ], 'MaxConcurrentTaskCount' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$MaxConcurrentTaskCount' => '<p>Defines the maximum number of data objects that can be labeled by human workers at the same time. Also referred to as batch size. Each object may have more than one worker at one time. The default value is 1000 objects.</p>', ], ], 'MaxConcurrentTransforms' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to <code>0</code> or left unset, Amazon SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is <code>1</code>. For more information on execution-parameters, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests">How Containers Serve Requests</a>. For built-in algorithms, you don\'t need to set a value for <code>MaxConcurrentTransforms</code>.</p>', 'DescribeTransformJobResponse$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests on each instance node that can be launched in a transform job. The default value is 1.</p>', 'TransformJob$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests that can be sent to each instance in a transform job. If <code>MaxConcurrentTransforms</code> is set to 0 or left unset, SageMaker checks the optional execution-parameters to determine the settings for your chosen algorithm. If the execution-parameters endpoint is not enabled, the default value is 1. For built-in algorithms, you don\'t need to set a value for <code>MaxConcurrentTransforms</code>.</p>', 'TransformJobDefinition$MaxConcurrentTransforms' => '<p>The maximum number of parallel requests that can be sent to each instance in a transform job. The default value is 1.</p>', ], ], 'MaxHumanLabeledObjectCount' => [ 'base' => NULL, 'refs' => [ 'LabelingJobStoppingConditions$MaxHumanLabeledObjectCount' => '<p>The maximum number of objects that can be labeled by human workers.</p>', ], ], 'MaxNumberOfTests' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobResourceLimit$MaxNumberOfTests' => '<p>Defines the maximum number of load tests.</p>', ], ], 'MaxNumberOfTrainingJobs' => [ 'base' => NULL, 'refs' => [ 'ResourceLimits$MaxNumberOfTrainingJobs' => '<p>The maximum number of training jobs that a hyperparameter tuning job can launch.</p>', ], ], 'MaxParallelExecutionSteps' => [ 'base' => NULL, 'refs' => [ 'ParallelismConfiguration$MaxParallelExecutionSteps' => '<p>The max number of steps that can be executed in parallel. </p>', ], ], 'MaxParallelOfTests' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobResourceLimit$MaxParallelOfTests' => '<p>Defines the maximum number of parallel load tests.</p>', ], ], 'MaxParallelTrainingJobs' => [ 'base' => NULL, 'refs' => [ 'ResourceLimits$MaxParallelTrainingJobs' => '<p>The maximum number of concurrent training jobs that a hyperparameter tuning job can launch.</p>', ], ], 'MaxPayloadInMB' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$MaxPayloadInMB' => '<p>The maximum allowed size of the payload, in MB. A <i>payload</i> is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is <code>6</code> MB. </p> <p>For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to <code>0</code>. This feature works only in supported algorithms. Currently, Amazon SageMaker built-in algorithms do not support HTTP chunked encoding.</p>', 'DescribeTransformJobResponse$MaxPayloadInMB' => '<p>The maximum payload size, in MB, used in the transform job.</p>', 'TransformJob$MaxPayloadInMB' => '<p>The maximum allowed size of the payload, in MB. A payload is the data portion of a record (without metadata). The value in <code>MaxPayloadInMB</code> must be greater than, or equal to, the size of a single record. To estimate the size of a record in MB, divide the size of your dataset by the number of records. To ensure that the records fit within the maximum payload size, we recommend using a slightly larger value. The default value is 6 MB. For cases where the payload might be arbitrarily large and is transmitted using HTTP chunked encoding, set the value to 0. This feature works only in supported algorithms. Currently, SageMaker built-in algorithms do not support HTTP chunked encoding.</p>', 'TransformJobDefinition$MaxPayloadInMB' => '<p>The maximum payload size allowed, in MB. A payload is the data portion of a record (without metadata).</p>', ], ], 'MaxPercentageOfInputDatasetLabeled' => [ 'base' => NULL, 'refs' => [ 'LabelingJobStoppingConditions$MaxPercentageOfInputDatasetLabeled' => '<p>The maximum number of input data objects that should be labeled.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$MaxResults' => '<p>The maximum number of actions to return in the response. The default value is 10.</p>', 'ListAlgorithmsInput$MaxResults' => '<p>The maximum number of algorithms to return in the response.</p>', 'ListAppImageConfigsRequest$MaxResults' => '<p>The maximum number of AppImageConfigs to return in the response. The default value is 10. </p>', 'ListAppsRequest$MaxResults' => '<p>Returns a list up to a specified limit.</p>', 'ListArtifactsRequest$MaxResults' => '<p>The maximum number of artifacts to return in the response. The default value is 10.</p>', 'ListAssociationsRequest$MaxResults' => '<p>The maximum number of associations to return in the response. The default value is 10.</p>', 'ListCodeRepositoriesInput$MaxResults' => '<p>The maximum number of Git repositories to return in the response.</p>', 'ListCompilationJobsRequest$MaxResults' => '<p>The maximum number of model compilation jobs to return in the response.</p>', 'ListContextsRequest$MaxResults' => '<p>The maximum number of contexts to return in the response. The default value is 10.</p>', 'ListDataQualityJobDefinitionsRequest$MaxResults' => '<p>The maximum number of data quality monitoring job definitions to return in the response.</p>', 'ListDomainsRequest$MaxResults' => '<p>Returns a list up to a specified limit.</p>', 'ListEndpointConfigsInput$MaxResults' => '<p>The maximum number of training jobs to return in the response.</p>', 'ListEndpointsInput$MaxResults' => '<p>The maximum number of endpoints to return in the response. This value defaults to 10.</p>', 'ListExperimentsRequest$MaxResults' => '<p>The maximum number of experiments to return in the response. The default value is 10.</p>', 'ListFlowDefinitionsRequest$MaxResults' => '<p>The total number of items to return. If the total number of available items is more than the value specified in <code>MaxResults</code>, then a <code>NextToken</code> will be provided in the output that you can use to resume pagination.</p>', 'ListHumanTaskUisRequest$MaxResults' => '<p>The total number of items to return. If the total number of available items is more than the value specified in <code>MaxResults</code>, then a <code>NextToken</code> will be provided in the output that you can use to resume pagination.</p>', 'ListHyperParameterTuningJobsRequest$MaxResults' => '<p>The maximum number of tuning jobs to return. The default value is 10.</p>', 'ListImageVersionsRequest$MaxResults' => '<p>The maximum number of versions to return in the response. The default value is 10. </p>', 'ListImagesRequest$MaxResults' => '<p>The maximum number of images to return in the response. The default value is 10. </p>', 'ListInferenceRecommendationsJobsRequest$MaxResults' => '<p>The maximum number of recommendations to return in the response.</p>', 'ListLabelingJobsForWorkteamRequest$MaxResults' => '<p>The maximum number of labeling jobs to return in each page of the response.</p>', 'ListLabelingJobsRequest$MaxResults' => '<p>The maximum number of labeling jobs to return in each page of the response.</p>', 'ListLineageGroupsRequest$MaxResults' => '<p>The maximum number of endpoints to return in the response. This value defaults to 10.</p>', 'ListModelBiasJobDefinitionsRequest$MaxResults' => '<p>The maximum number of model bias jobs to return in the response. The default value is 10.</p>', 'ListModelExplainabilityJobDefinitionsRequest$MaxResults' => '<p>The maximum number of jobs to return in the response. The default value is 10.</p>', 'ListModelMetadataRequest$MaxResults' => '<p>The maximum number of models to return in the response.</p>', 'ListModelPackageGroupsInput$MaxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListModelPackagesInput$MaxResults' => '<p>The maximum number of model packages to return in the response.</p>', 'ListModelQualityJobDefinitionsRequest$MaxResults' => '<p>The maximum number of results to return in a call to <code>ListModelQualityJobDefinitions</code>.</p>', 'ListModelsInput$MaxResults' => '<p>The maximum number of models to return in the response.</p>', 'ListMonitoringExecutionsRequest$MaxResults' => '<p>The maximum number of jobs to return in the response. The default value is 10.</p>', 'ListMonitoringSchedulesRequest$MaxResults' => '<p>The maximum number of jobs to return in the response. The default value is 10.</p>', 'ListNotebookInstanceLifecycleConfigsInput$MaxResults' => '<p>The maximum number of lifecycle configurations to return in the response.</p>', 'ListNotebookInstancesInput$MaxResults' => '<p>The maximum number of notebook instances to return.</p>', 'ListPipelineExecutionStepsRequest$MaxResults' => '<p>The maximum number of pipeline execution steps to return in the response.</p>', 'ListPipelineExecutionsRequest$MaxResults' => '<p>The maximum number of pipeline executions to return in the response.</p>', 'ListPipelineParametersForExecutionRequest$MaxResults' => '<p>The maximum number of parameters to return in the response.</p>', 'ListPipelinesRequest$MaxResults' => '<p>The maximum number of pipelines to return in the response.</p>', 'ListProcessingJobsRequest$MaxResults' => '<p>The maximum number of processing jobs to return in the response.</p>', 'ListProjectsInput$MaxResults' => '<p>The maximum number of projects to return in the response.</p>', 'ListStudioLifecycleConfigsRequest$MaxResults' => '<p>The maximum number of Studio Lifecycle Configurations to return in the response. The default value is 10.</p>', 'ListSubscribedWorkteamsRequest$MaxResults' => '<p>The maximum number of work teams to return in each page of the response.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$MaxResults' => '<p>The maximum number of training jobs to return. The default value is 10.</p>', 'ListTrainingJobsRequest$MaxResults' => '<p>The maximum number of training jobs to return in the response.</p>', 'ListTransformJobsRequest$MaxResults' => '<p>The maximum number of transform jobs to return in the response. The default value is <code>10</code>.</p>', 'ListTrialComponentsRequest$MaxResults' => '<p>The maximum number of components to return in the response. The default value is 10.</p>', 'ListTrialsRequest$MaxResults' => '<p>The maximum number of trials to return in the response. The default value is 10.</p>', 'ListUserProfilesRequest$MaxResults' => '<p>Returns a list up to a specified limit.</p>', 'ListWorkforcesRequest$MaxResults' => '<p>The maximum number of workforces returned in the response.</p>', 'ListWorkteamsRequest$MaxResults' => '<p>The maximum number of work teams to return in each page of the response.</p>', 'SearchRequest$MaxResults' => '<p>The maximum number of results to return.</p>', ], ], 'MaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'StoppingCondition$MaxRuntimeInSeconds' => '<p>The maximum length of time, in seconds, that a training or compilation job can run.</p> <p>For compilation jobs, if the job does not complete during this time, you will receive a <code>TimeOut</code> error. We recommend starting with 900 seconds and increase as necessary based on your model.</p> <p>For all other jobs, if the job does not complete during this time, Amazon SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.</p>', ], ], 'MaxRuntimePerTrainingJobInSeconds' => [ 'base' => NULL, 'refs' => [ 'AutoMLJobCompletionCriteria$MaxRuntimePerTrainingJobInSeconds' => '<p>The maximum time, in seconds, that each training job is allowed to run as part of a hyperparameter tuning job. For more information, see the used by the action.</p>', ], ], 'MaxWaitTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'StoppingCondition$MaxWaitTimeInSeconds' => '<p>The maximum length of time, in seconds, that a managed Spot training job has to complete. It is the amount of time spent waiting for Spot capacity plus the amount of time the job can run. It must be equal to or greater than <code>MaxRuntimeInSeconds</code>. If the job does not complete during this time, Amazon SageMaker ends the job.</p> <p>When <code>RetryStrategy</code> is specified in the job request, <code>MaxWaitTimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt.</p>', ], ], 'MaximumExecutionTimeoutInSeconds' => [ 'base' => NULL, 'refs' => [ 'BlueGreenUpdatePolicy$MaximumExecutionTimeoutInSeconds' => '<p>Maximum execution timeout for the deployment. Note that the timeout value should be larger than the total waiting time specified in <code>TerminationWaitInSeconds</code> and <code>WaitIntervalInSeconds</code>.</p>', ], ], 'MaximumRetryAttempts' => [ 'base' => NULL, 'refs' => [ 'RetryStrategy$MaximumRetryAttempts' => '<p>The number of times to retry the job. When the job is retried, it\'s <code>SecondaryStatus</code> is changed to <code>STARTING</code>.</p>', ], ], 'MediaType' => [ 'base' => NULL, 'refs' => [ 'TrialComponentArtifact$MediaType' => '<p>The media type of the artifact, which indicates the type of data in the artifact file. The media type consists of a <i>type</i> and a <i>subtype</i> concatenated with a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The type specifies the category of the media. The subtype specifies the kind of data.</p>', ], ], 'MemberDefinition' => [ 'base' => '<p>Defines an Amazon Cognito or your own OIDC IdP user group that is part of a work team.</p>', 'refs' => [ 'MemberDefinitions$member' => NULL, ], ], 'MemberDefinitions' => [ 'base' => NULL, 'refs' => [ 'CreateWorkteamRequest$MemberDefinitions' => '<p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p> <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. Do not provide input for both of these parameters in a single request.</p> <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User Pool</a>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a>.</p> <p>For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>.</p>', 'UpdateWorkteamRequest$MemberDefinitions' => '<p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p> <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>. You should not provide input for both of these parameters in a single request.</p> <p>For workforces created using Amazon Cognito, private work teams correspond to Amazon Cognito <i>user groups</i> within the user pool used to create a workforce. All of the <code>CognitoMemberDefinition</code> objects that make up the member definition must have the same <code>ClientId</code> and <code>UserPool</code> values. To add a Amazon Cognito user group to an existing worker pool, see <a href="">Adding groups to a User Pool</a>. For more information about user pools, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">Amazon Cognito User Pools</a>.</p> <p>For workforces created using your own OIDC IdP, specify the user groups that you want to include in your private work team in <code>OidcMemberDefinition</code> by listing those groups in <code>Groups</code>. Be aware that user groups that are already in the work team must also be listed in <code>Groups</code> when you make this request to remain on the work team. If you do not include these user groups, they will no longer be associated with the work team you update. </p>', 'Workteam$MemberDefinitions' => '<p>A list of <code>MemberDefinition</code> objects that contains objects that identify the workers that make up the work team. </p> <p>Workforces can be created using Amazon Cognito or your own OIDC Identity Provider (IdP). For private workforces created using Amazon Cognito use <code>CognitoMemberDefinition</code>. For workforces created using your own OIDC identity provider (IdP) use <code>OidcMemberDefinition</code>.</p>', ], ], 'MetadataProperties' => [ 'base' => '<p>Metadata properties of the tracking entity, trial, or trial component.</p>', 'refs' => [ 'CreateActionRequest$MetadataProperties' => NULL, 'CreateArtifactRequest$MetadataProperties' => NULL, 'CreateModelPackageInput$MetadataProperties' => NULL, 'CreateTrialComponentRequest$MetadataProperties' => NULL, 'CreateTrialRequest$MetadataProperties' => NULL, 'DescribeActionResponse$MetadataProperties' => NULL, 'DescribeArtifactResponse$MetadataProperties' => NULL, 'DescribeModelPackageOutput$MetadataProperties' => NULL, 'DescribeTrialComponentResponse$MetadataProperties' => NULL, 'DescribeTrialResponse$MetadataProperties' => NULL, 'ModelPackage$MetadataProperties' => NULL, 'Trial$MetadataProperties' => NULL, 'TrialComponent$MetadataProperties' => NULL, ], ], 'MetadataPropertyValue' => [ 'base' => NULL, 'refs' => [ 'MetadataProperties$CommitId' => '<p>The commit ID.</p>', 'MetadataProperties$Repository' => '<p>The repository.</p>', 'MetadataProperties$GeneratedBy' => '<p>The entity this entity was generated by.</p>', 'MetadataProperties$ProjectId' => '<p>The project ID.</p>', ], ], 'MetricData' => [ 'base' => '<p>The name, value, and date and time of a metric that was emitted to Amazon CloudWatch.</p>', 'refs' => [ 'FinalMetricDataList$member' => NULL, ], ], 'MetricDataList' => [ 'base' => NULL, 'refs' => [ 'CandidateProperties$CandidateMetrics' => '<p>Information about the candidate metrics for an AutoML job.</p>', ], ], 'MetricDatum' => [ 'base' => '<p>Information about the metric for a candidate produced by an AutoML job.</p>', 'refs' => [ 'MetricDataList$member' => NULL, ], ], 'MetricDefinition' => [ 'base' => '<p>Specifies a metric that the training algorithm writes to <code>stderr</code> or <code>stdout</code>. Amazon SageMakerhyperparameter tuning captures all defined metrics. You specify one metric that a hyperparameter tuning job uses as its objective metric to choose the best training job.</p>', 'refs' => [ 'MetricDefinitionList$member' => NULL, ], ], 'MetricDefinitionList' => [ 'base' => NULL, 'refs' => [ 'AlgorithmSpecification$MetricDefinitions' => '<p>A list of metric definition objects. Each object specifies the metric name and regular expressions used to parse algorithm logs. Amazon SageMaker publishes each metric to Amazon CloudWatch.</p>', 'HyperParameterAlgorithmSpecification$MetricDefinitions' => '<p>An array of <a>MetricDefinition</a> objects that specify the metrics that the algorithm emits.</p>', 'TrainingSpecification$MetricDefinitions' => '<p>A list of <code>MetricDefinition</code> objects, which are used for parsing metrics generated by the algorithm.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'FinalHyperParameterTuningJobObjectiveMetric$MetricName' => '<p>The name of the objective metric.</p>', 'HyperParameterTuningJobObjective$MetricName' => '<p>The name of the metric to use for the objective metric.</p>', 'MetricData$MetricName' => '<p>The name of the metric.</p>', 'MetricDefinition$Name' => '<p>The name of the metric.</p>', 'TrialComponentMetricSummary$MetricName' => '<p>The name of the metric.</p>', ], ], 'MetricRegex' => [ 'base' => NULL, 'refs' => [ 'MetricDefinition$Regex' => '<p>A regular expression that searches the output of a training job and gets the value of the metric. For more information about using regular expressions to define metrics, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics.html">Defining Objective Metrics</a>.</p>', ], ], 'MetricSetSource' => [ 'base' => NULL, 'refs' => [ 'MetricDatum$Set' => '<p>The dataset split from which the AutoML job produced the metric.</p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'FinalAutoMLJobObjectiveMetric$Value' => '<p>The value of the metric with the best result.</p>', 'FinalHyperParameterTuningJobObjectiveMetric$Value' => '<p>The value of the objective metric.</p>', ], ], 'MetricsSource' => [ 'base' => '<p/>', 'refs' => [ 'Bias$Report' => '<p>The bias report for a model</p>', 'Bias$PreTrainingReport' => NULL, 'Bias$PostTrainingReport' => NULL, 'DriftCheckBias$PreTrainingConstraints' => NULL, 'DriftCheckBias$PostTrainingConstraints' => NULL, 'DriftCheckExplainability$Constraints' => NULL, 'DriftCheckModelDataQuality$Statistics' => NULL, 'DriftCheckModelDataQuality$Constraints' => NULL, 'DriftCheckModelQuality$Statistics' => NULL, 'DriftCheckModelQuality$Constraints' => NULL, 'Explainability$Report' => '<p>The explainability report for a model.</p>', 'ModelDataQuality$Statistics' => '<p>Data quality statistics for a model.</p>', 'ModelDataQuality$Constraints' => '<p>Data quality constraints for a model.</p>', 'ModelQuality$Statistics' => '<p>Model quality statistics.</p>', 'ModelQuality$Constraints' => '<p>Model quality constraints.</p>', ], ], 'ModelApprovalStatus' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageSummary$ModelApprovalStatus' => '<p>The approval status of the model.</p>', 'CreateModelPackageInput$ModelApprovalStatus' => '<p>Whether the model is approved for deployment.</p> <p>This parameter is optional for versioned models, and does not apply to unversioned models.</p> <p>For versioned models, the value of this parameter must be set to <code>Approved</code> to deploy the model.</p>', 'DescribeModelPackageOutput$ModelApprovalStatus' => '<p>The approval status of the model package.</p>', 'ListModelPackagesInput$ModelApprovalStatus' => '<p>A filter that returns only the model packages with the specified approval status.</p>', 'ModelPackage$ModelApprovalStatus' => '<p>The approval status of the model. This can be one of the following values.</p> <ul> <li> <p> <code>APPROVED</code> - The model is approved</p> </li> <li> <p> <code>REJECTED</code> - The model is rejected.</p> </li> <li> <p> <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.</p> </li> </ul>', 'ModelPackageSummary$ModelApprovalStatus' => '<p>The approval status of the model. This can be one of the following values.</p> <ul> <li> <p> <code>APPROVED</code> - The model is approved</p> </li> <li> <p> <code>REJECTED</code> - The model is rejected.</p> </li> <li> <p> <code>PENDING_MANUAL_APPROVAL</code> - The model is waiting for manual approval.</p> </li> </ul>', 'UpdateModelPackageInput$ModelApprovalStatus' => '<p>The approval status of the model.</p>', ], ], 'ModelArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelOutput$ModelArn' => '<p>The ARN of the model created in Amazon SageMaker.</p>', 'DescribeModelOutput$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', 'LabelingJobAlgorithmsConfig$InitialActiveLearningModelArn' => '<p>At the end of an auto-label job Ground Truth sends the Amazon Resource Name (ARN) of the final model used for auto-labeling. You can use this model as the starting point for subsequent similar jobs by providing the ARN of the model here. </p>', 'LabelingJobOutput$FinalActiveLearningModelArn' => '<p>The Amazon Resource Name (ARN) for the most recent Amazon SageMaker model trained as part of automated data labeling. </p>', 'ModelSummary$ModelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', ], ], 'ModelArtifacts' => [ 'base' => '<p>Provides information about the location that is configured for storing model artifacts. </p> <p>Model artifacts are the output that results from training a model, and typically consist of trained parameters, a model definition that describes how to compute inferences, and other metadata.</p>', 'refs' => [ 'DescribeCompilationJobResponse$ModelArtifacts' => '<p>Information about the location in Amazon S3 that has been configured for storing the model artifacts used in the compilation job.</p>', 'DescribeTrainingJobResponse$ModelArtifacts' => '<p>Information about the Amazon S3 location that is configured for storing model artifacts. </p>', 'TrainingJob$ModelArtifacts' => '<p>Information about the Amazon S3 location that is configured for storing model artifacts.</p>', ], ], 'ModelBiasAppSpecification' => [ 'base' => '<p>Docker container image configuration object for the model bias job.</p>', 'refs' => [ 'CreateModelBiasJobDefinitionRequest$ModelBiasAppSpecification' => '<p>Configures the model bias job to run a specified Docker container image.</p>', 'DescribeModelBiasJobDefinitionResponse$ModelBiasAppSpecification' => '<p>Configures the model bias job to run a specified Docker container image.</p>', ], ], 'ModelBiasBaselineConfig' => [ 'base' => '<p>The configuration for a baseline model bias job.</p>', 'refs' => [ 'CreateModelBiasJobDefinitionRequest$ModelBiasBaselineConfig' => '<p>The baseline configuration for a model bias job.</p>', 'DescribeModelBiasJobDefinitionResponse$ModelBiasBaselineConfig' => '<p>The baseline configuration for a model bias job.</p>', ], ], 'ModelBiasJobInput' => [ 'base' => '<p>Inputs for the model bias job.</p>', 'refs' => [ 'CreateModelBiasJobDefinitionRequest$ModelBiasJobInput' => '<p>Inputs for the model bias job.</p>', 'DescribeModelBiasJobDefinitionResponse$ModelBiasJobInput' => '<p>Inputs for the model bias job.</p>', ], ], 'ModelCacheSetting' => [ 'base' => NULL, 'refs' => [ 'MultiModelConfig$ModelCacheSetting' => '<p>Whether to cache models for a multi-model endpoint. By default, multi-model endpoints cache models so that a model does not have to be loaded into memory each time it is invoked. Some use cases do not benefit from model caching. For example, if an endpoint hosts a large number of models that are each invoked infrequently, the endpoint might perform better if you disable model caching. To disable model caching, set the value of this parameter to <code>Disabled</code>.</p>', ], ], 'ModelClientConfig' => [ 'base' => '<p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>', 'refs' => [ 'CreateTransformJobRequest$ModelClientConfig' => '<p>Configures the timeout and maximum number of retries for processing a transform job invocation.</p>', 'DescribeTransformJobResponse$ModelClientConfig' => '<p>The timeout and maximum number of retries for processing a transform job invocation.</p>', 'TransformJob$ModelClientConfig' => NULL, ], ], 'ModelConfiguration' => [ 'base' => '<p>Defines the model configuration. Includes the specification name and environment parameters.</p>', 'refs' => [ 'InferenceRecommendation$ModelConfiguration' => '<p>Defines the model configuration.</p>', ], ], 'ModelDataQuality' => [ 'base' => '<p>Data quality constraints and statistics for a model.</p>', 'refs' => [ 'ModelMetrics$ModelDataQuality' => '<p>Metrics that measure the quality of the input data for a model.</p>', ], ], 'ModelDeployConfig' => [ 'base' => '<p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.</p>', 'refs' => [ 'CreateAutoMLJobRequest$ModelDeployConfig' => '<p>Specifies how to generate the endpoint name for an automatic one-click Autopilot model deployment.</p>', 'DescribeAutoMLJobResponse$ModelDeployConfig' => '<p>Indicates whether the model was deployed automatically to an endpoint and the name of that endpoint if deployed automatically.</p>', ], ], 'ModelDeployResult' => [ 'base' => '<p>Provides information about the endpoint of the model deployment.</p>', 'refs' => [ 'DescribeAutoMLJobResponse$ModelDeployResult' => '<p>Provides information about endpoint for the model deployment.</p>', ], ], 'ModelDigests' => [ 'base' => '<p>Provides information to verify the integrity of stored model artifacts. </p>', 'refs' => [ 'DescribeCompilationJobResponse$ModelDigests' => '<p>Provides a BLAKE2 hash value that identifies the compiled model artifacts in Amazon S3.</p>', ], ], 'ModelExplainabilityAppSpecification' => [ 'base' => '<p>Docker container image configuration object for the model explainability job.</p>', 'refs' => [ 'CreateModelExplainabilityJobDefinitionRequest$ModelExplainabilityAppSpecification' => '<p>Configures the model explainability job to run a specified Docker container image.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$ModelExplainabilityAppSpecification' => '<p>Configures the model explainability job to run a specified Docker container image.</p>', ], ], 'ModelExplainabilityBaselineConfig' => [ 'base' => '<p>The configuration for a baseline model explainability job.</p>', 'refs' => [ 'CreateModelExplainabilityJobDefinitionRequest$ModelExplainabilityBaselineConfig' => '<p>The baseline configuration for a model explainability job.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$ModelExplainabilityBaselineConfig' => '<p>The baseline configuration for a model explainability job.</p>', ], ], 'ModelExplainabilityJobInput' => [ 'base' => '<p>Inputs for the model explainability job.</p>', 'refs' => [ 'CreateModelExplainabilityJobDefinitionRequest$ModelExplainabilityJobInput' => '<p>Inputs for the model explainability job.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$ModelExplainabilityJobInput' => '<p>Inputs for the model explainability job.</p>', ], ], 'ModelInput' => [ 'base' => '<p>Input object for the model.</p>', 'refs' => [ 'ModelPackageContainerDefinition$ModelInput' => '<p>A structure with Model Input details.</p>', ], ], 'ModelInsightsLocation' => [ 'base' => NULL, 'refs' => [ 'CandidateArtifactLocations$ModelInsights' => '<p>The Amazon S3 prefix to the model insight artifacts generated for the AutoML candidate.</p>', ], ], 'ModelLatencyThreshold' => [ 'base' => '<p>The model latency threshold.</p>', 'refs' => [ 'ModelLatencyThresholds$member' => NULL, ], ], 'ModelLatencyThresholds' => [ 'base' => NULL, 'refs' => [ 'RecommendationJobStoppingConditions$ModelLatencyThresholds' => '<p>The interval of time taken by a model to respond as viewed from SageMaker. The interval includes the local communication time taken to send the request and to fetch the response from the container of a model and the time taken to complete the inference in the container.</p>', ], ], 'ModelMetadataFilter' => [ 'base' => '<p>Part of the search expression. You can specify the name and value (domain, task, framework, framework version, task, and model).</p>', 'refs' => [ 'ModelMetadataFilters$member' => NULL, ], ], 'ModelMetadataFilterType' => [ 'base' => NULL, 'refs' => [ 'ModelMetadataFilter$Name' => '<p>The name of the of the model to filter by.</p>', ], ], 'ModelMetadataFilters' => [ 'base' => NULL, 'refs' => [ 'ModelMetadataSearchExpression$Filters' => '<p>A list of filter objects.</p>', ], ], 'ModelMetadataSearchExpression' => [ 'base' => '<p>One or more filters that searches for the specified resource or resources in a search. All resource objects that satisfy the expression\'s condition are included in the search results</p>', 'refs' => [ 'ListModelMetadataRequest$SearchExpression' => '<p>One or more filters that searches for the specified resource or resources in a search. All resource objects that satisfy the expression\'s condition are included in the search results. Specify the Framework, FrameworkVersion, Domain or Task to filter supported. Filter names and values are case-sensitive.</p>', ], ], 'ModelMetadataSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelMetadataResponse$ModelMetadataSummaries' => '<p>A structure that holds model metadata.</p>', ], ], 'ModelMetadataSummary' => [ 'base' => '<p>A summary of the model metadata.</p>', 'refs' => [ 'ModelMetadataSummaries$member' => NULL, ], ], 'ModelMetrics' => [ 'base' => '<p>Contains metrics captured from a model.</p>', 'refs' => [ 'CreateModelPackageInput$ModelMetrics' => '<p>A structure that contains model metrics reports.</p>', 'DescribeModelPackageOutput$ModelMetrics' => '<p>Metrics for the model.</p>', 'ModelPackage$ModelMetrics' => '<p>Metrics for the model.</p>', ], ], 'ModelName' => [ 'base' => NULL, 'refs' => [ 'CreateModelInput$ModelName' => '<p>The name of the new model.</p>', 'CreateTransformJobRequest$ModelName' => '<p>The name of the model that you want to use for the transform job. <code>ModelName</code> must be the name of an existing Amazon SageMaker model within an Amazon Web Services Region in an Amazon Web Services account.</p>', 'DeleteModelInput$ModelName' => '<p>The name of the model to delete.</p>', 'DescribeModelInput$ModelName' => '<p>The name of the model.</p>', 'DescribeModelOutput$ModelName' => '<p>Name of the Amazon SageMaker model.</p>', 'DescribeTransformJobResponse$ModelName' => '<p>The name of the model used in the transform job.</p>', 'ModelSummary$ModelName' => '<p>The name of the model that you want a summary for.</p>', 'ProductionVariant$ModelName' => '<p>The name of the model that you want to host. This is the name that you specified when creating the model.</p>', 'TransformJob$ModelName' => '<p>The name of the model associated with the transform job.</p>', ], ], 'ModelNameContains' => [ 'base' => NULL, 'refs' => [ 'ListModelsInput$NameContains' => '<p>A string in the model name. This filter returns only models whose name contains the specified string.</p>', ], ], 'ModelPackage' => [ 'base' => '<p>A versioned model that can be deployed for SageMaker inference.</p>', 'refs' => [ 'SearchRecord$ModelPackage' => NULL, ], ], 'ModelPackageArn' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageErrorMap$key' => NULL, 'BatchDescribeModelPackageSummary$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'CreateCompilationJobRequest$ModelPackageVersionArn' => '<p>The Amazon Resource Name (ARN) of a versioned model package. Provide either a <code>ModelPackageVersionArn</code> or an <code>InputConfig</code> object in the request syntax. The presence of both objects in the <code>CreateCompilationJob</code> request will return an exception.</p>', 'CreateModelPackageOutput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the new model package.</p>', 'DescribeCompilationJobResponse$ModelPackageVersionArn' => '<p>The Amazon Resource Name (ARN) of the versioned model package that was provided to SageMaker Neo when you initiated a compilation job.</p>', 'DescribeModelPackageOutput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'ModelPackage$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'ModelPackageArnList$member' => NULL, 'ModelPackageSummaries$key' => NULL, 'ModelPackageSummary$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'RecommendationJobInputConfig$ModelPackageVersionArn' => '<p>The Amazon Resource Name (ARN) of a versioned model package.</p>', 'UpdateModelPackageInput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'UpdateModelPackageOutput$ModelPackageArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', ], ], 'ModelPackageArnList' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageInput$ModelPackageArnList' => '<p>The list of Amazon Resource Name (ARN) of the model package groups.</p>', ], ], 'ModelPackageContainerDefinition' => [ 'base' => '<p>Describes the Docker container for the model package.</p>', 'refs' => [ 'ModelPackageContainerDefinitionList$member' => NULL, ], ], 'ModelPackageContainerDefinitionList' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$Containers' => '<p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>', 'InferenceSpecification$Containers' => '<p>The Amazon ECR registry path of the Docker image that contains the inference code.</p>', ], ], 'ModelPackageGroup' => [ 'base' => '<p>A group of versioned models in the model registry.</p>', 'refs' => [ 'SearchRecord$ModelPackageGroup' => NULL, ], ], 'ModelPackageGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelPackageGroupOutput$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model group.</p>', 'DescribeModelPackageGroupOutput$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model group.</p>', 'ModelPackageGroup$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model group.</p>', 'ModelPackageGroupSummary$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model group.</p>', 'PutModelPackageGroupPolicyOutput$ModelPackageGroupArn' => '<p>The Amazon Resource Name (ARN) of the model package group.</p>', ], ], 'ModelPackageGroupSortBy' => [ 'base' => NULL, 'refs' => [ 'ListModelPackageGroupsInput$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'ModelPackageGroupStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeModelPackageGroupOutput$ModelPackageGroupStatus' => '<p>The status of the model group.</p>', 'ModelPackageGroup$ModelPackageGroupStatus' => '<p>The status of the model group. This can be one of the following values.</p> <ul> <li> <p> <code>PENDING</code> - The model group is pending being created.</p> </li> <li> <p> <code>IN_PROGRESS</code> - The model group is in the process of being created.</p> </li> <li> <p> <code>COMPLETED</code> - The model group was successfully created.</p> </li> <li> <p> <code>FAILED</code> - The model group failed.</p> </li> <li> <p> <code>DELETING</code> - The model group is in the process of being deleted.</p> </li> <li> <p> <code>DELETE_FAILED</code> - SageMaker failed to delete the model group.</p> </li> </ul>', 'ModelPackageGroupSummary$ModelPackageGroupStatus' => '<p>The status of the model group.</p>', ], ], 'ModelPackageGroupSummary' => [ 'base' => '<p>Summary information about a model group.</p>', 'refs' => [ 'ModelPackageGroupSummaryList$member' => NULL, ], ], 'ModelPackageGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelPackageGroupsOutput$ModelPackageGroupSummaryList' => '<p>A list of summaries of the model groups in your Amazon Web Services account.</p>', ], ], 'ModelPackageSortBy' => [ 'base' => NULL, 'refs' => [ 'ListModelPackagesInput$SortBy' => '<p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>', ], ], 'ModelPackageStatus' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageSummary$ModelPackageStatus' => '<p>The status of the mortgage package.</p>', 'DescribeModelPackageOutput$ModelPackageStatus' => '<p>The current status of the model package.</p>', 'ModelPackage$ModelPackageStatus' => '<p>The status of the model package. This can be one of the following values.</p> <ul> <li> <p> <code>PENDING</code> - The model package is pending being created.</p> </li> <li> <p> <code>IN_PROGRESS</code> - The model package is in the process of being created.</p> </li> <li> <p> <code>COMPLETED</code> - The model package was successfully created.</p> </li> <li> <p> <code>FAILED</code> - The model package failed.</p> </li> <li> <p> <code>DELETING</code> - The model package is in the process of being deleted.</p> </li> </ul>', 'ModelPackageSummary$ModelPackageStatus' => '<p>The overall status of the model package.</p>', ], ], 'ModelPackageStatusDetails' => [ 'base' => '<p>Specifies the validation and image scan statuses of the model package.</p>', 'refs' => [ 'DescribeModelPackageOutput$ModelPackageStatusDetails' => '<p>Details about the current status of the model package.</p>', 'ModelPackage$ModelPackageStatusDetails' => NULL, ], ], 'ModelPackageStatusItem' => [ 'base' => '<p>Represents the overall status of a model package.</p>', 'refs' => [ 'ModelPackageStatusItemList$member' => NULL, ], ], 'ModelPackageStatusItemList' => [ 'base' => NULL, 'refs' => [ 'ModelPackageStatusDetails$ValidationStatuses' => '<p>The validation status of the model package.</p>', 'ModelPackageStatusDetails$ImageScanStatuses' => '<p>The status of the scan of the Docker image container for the model package.</p>', ], ], 'ModelPackageSummaries' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageOutput$ModelPackageSummaries' => '<p>The summaries for the model package versions</p>', ], ], 'ModelPackageSummary' => [ 'base' => '<p>Provides summary information about a model package.</p>', 'refs' => [ 'ModelPackageSummaryList$member' => NULL, ], ], 'ModelPackageSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelPackagesOutput$ModelPackageSummaryList' => '<p>An array of <code>ModelPackageSummary</code> objects, each of which lists a model package.</p>', ], ], 'ModelPackageType' => [ 'base' => NULL, 'refs' => [ 'ListModelPackagesInput$ModelPackageType' => '<p>A filter that returns only the model packages of the specified type. This can be one of the following values.</p> <ul> <li> <p> <code>UNVERSIONED</code> - List only unversioined models. This is the default value if no <code>ModelPackageType</code> is specified.</p> </li> <li> <p> <code>VERSIONED</code> - List only versioned models.</p> </li> <li> <p> <code>BOTH</code> - List both versioned and unversioned models.</p> </li> </ul>', ], ], 'ModelPackageValidationProfile' => [ 'base' => '<p>Contains data, such as the inputs and targeted instance types that are used in the process of validating the model package.</p> <p>The data provided in the validation profile is made available to your buyers on Amazon Web Services Marketplace.</p>', 'refs' => [ 'ModelPackageValidationProfiles$member' => NULL, ], ], 'ModelPackageValidationProfiles' => [ 'base' => NULL, 'refs' => [ 'ModelPackageValidationSpecification$ValidationProfiles' => '<p>An array of <code>ModelPackageValidationProfile</code> objects, each of which specifies a batch transform job that Amazon SageMaker runs to validate your model package.</p>', ], ], 'ModelPackageValidationSpecification' => [ 'base' => '<p>Specifies batch transform jobs that Amazon SageMaker runs to validate your model package.</p>', 'refs' => [ 'CreateModelPackageInput$ValidationSpecification' => '<p>Specifies configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.</p>', 'DescribeModelPackageOutput$ValidationSpecification' => '<p>Configurations for one or more transform jobs that SageMaker runs to test the model package.</p>', 'ModelPackage$ValidationSpecification' => NULL, ], ], 'ModelPackageVersion' => [ 'base' => NULL, 'refs' => [ 'BatchDescribeModelPackageSummary$ModelPackageVersion' => '<p>The version number of a versioned model.</p>', 'DescribeModelPackageOutput$ModelPackageVersion' => '<p>The version of the model package.</p>', 'ModelPackage$ModelPackageVersion' => '<p>The version number of a versioned model.</p>', 'ModelPackageSummary$ModelPackageVersion' => '<p>If the model package is a versioned model, the version of the model.</p>', ], ], 'ModelQuality' => [ 'base' => '<p>Model quality statistics and constraints.</p>', 'refs' => [ 'ModelMetrics$ModelQuality' => '<p>Metrics that measure the quality of a model.</p>', ], ], 'ModelQualityAppSpecification' => [ 'base' => '<p>Container image configuration object for the monitoring job.</p>', 'refs' => [ 'CreateModelQualityJobDefinitionRequest$ModelQualityAppSpecification' => '<p>The container that runs the monitoring job.</p>', 'DescribeModelQualityJobDefinitionResponse$ModelQualityAppSpecification' => '<p>Configures the model quality job to run a specified Docker container image.</p>', ], ], 'ModelQualityBaselineConfig' => [ 'base' => '<p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>', 'refs' => [ 'CreateModelQualityJobDefinitionRequest$ModelQualityBaselineConfig' => '<p>Specifies the constraints and baselines for the monitoring job.</p>', 'DescribeModelQualityJobDefinitionResponse$ModelQualityBaselineConfig' => '<p>The baseline configuration for a model quality job.</p>', ], ], 'ModelQualityJobInput' => [ 'base' => '<p>The input for the model quality monitoring job. Currently endponts are supported for input for model quality monitoring jobs.</p>', 'refs' => [ 'CreateModelQualityJobDefinitionRequest$ModelQualityJobInput' => '<p>A list of the inputs that are monitored. Currently endpoints are supported.</p>', 'DescribeModelQualityJobDefinitionResponse$ModelQualityJobInput' => '<p>Inputs for the model quality job.</p>', ], ], 'ModelSortKey' => [ 'base' => NULL, 'refs' => [ 'ListModelsInput$SortBy' => '<p>Sorts the list of results. The default is <code>CreationTime</code>.</p>', ], ], 'ModelStepMetadata' => [ 'base' => '<p>Metadata for Model steps.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$Model' => '<p>The Amazon Resource Name (ARN) of the model that was created by this step execution.</p>', ], ], 'ModelSummary' => [ 'base' => '<p>Provides summary information about a model.</p>', 'refs' => [ 'ModelSummaryList$member' => NULL, ], ], 'ModelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListModelsOutput$Models' => '<p>An array of <code>ModelSummary</code> objects, each of which lists a model.</p>', ], ], 'MonitoringAppSpecification' => [ 'base' => '<p>Container image configuration object for the monitoring job.</p>', 'refs' => [ 'MonitoringJobDefinition$MonitoringAppSpecification' => '<p>Configures the monitoring job to run a specified Docker container image.</p>', ], ], 'MonitoringBaselineConfig' => [ 'base' => '<p>Configuration for monitoring constraints and monitoring statistics. These baseline resources are compared against the results of the current job from the series of jobs scheduled to collect data periodically.</p>', 'refs' => [ 'MonitoringJobDefinition$BaselineConfig' => '<p>Baseline configuration used to validate that the data conforms to the specified constraints and statistics</p>', ], ], 'MonitoringClusterConfig' => [ 'base' => '<p>Configuration for the cluster used to run model monitoring jobs.</p>', 'refs' => [ 'MonitoringResources$ClusterConfig' => '<p>The configuration for the cluster resources used to run the processing job.</p>', ], ], 'MonitoringConstraintsResource' => [ 'base' => '<p>The constraints resource for a monitoring job.</p>', 'refs' => [ 'DataQualityBaselineConfig$ConstraintsResource' => NULL, 'ModelBiasBaselineConfig$ConstraintsResource' => NULL, 'ModelExplainabilityBaselineConfig$ConstraintsResource' => NULL, 'ModelQualityBaselineConfig$ConstraintsResource' => NULL, 'MonitoringBaselineConfig$ConstraintsResource' => '<p>The baseline constraint file in Amazon S3 that the current monitoring job should validated against.</p>', ], ], 'MonitoringContainerArguments' => [ 'base' => NULL, 'refs' => [ 'DataQualityAppSpecification$ContainerArguments' => '<p>The arguments to send to the container that the monitoring job runs.</p>', 'ModelQualityAppSpecification$ContainerArguments' => '<p>An array of arguments for the container used to run the monitoring job.</p>', 'MonitoringAppSpecification$ContainerArguments' => '<p>An array of arguments for the container used to run the monitoring job.</p>', ], ], 'MonitoringEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'DataQualityAppSpecification$Environment' => '<p>Sets the environment variables in the container that the monitoring job runs.</p>', 'ModelBiasAppSpecification$Environment' => '<p>Sets the environment variables in the Docker container.</p>', 'ModelExplainabilityAppSpecification$Environment' => '<p>Sets the environment variables in the Docker container.</p>', 'ModelQualityAppSpecification$Environment' => '<p>Sets the environment variables in the container that the monitoring job runs.</p>', 'MonitoringJobDefinition$Environment' => '<p>Sets the environment variables in the Docker container.</p>', ], ], 'MonitoringExecutionSortKey' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringExecutionsRequest$SortBy' => '<p>Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.</p>', ], ], 'MonitoringExecutionSummary' => [ 'base' => '<p>Summary of information about the last monitoring job to run.</p>', 'refs' => [ 'DescribeMonitoringScheduleResponse$LastMonitoringExecutionSummary' => '<p>Describes metadata on the last execution to run, if there was one.</p>', 'MonitoringExecutionSummaryList$member' => NULL, 'MonitoringSchedule$LastMonitoringExecutionSummary' => NULL, ], ], 'MonitoringExecutionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringExecutionsResponse$MonitoringExecutionSummaries' => '<p>A JSON array in which each element is a summary for a monitoring execution.</p>', ], ], 'MonitoringGroundTruthS3Input' => [ 'base' => '<p>The ground truth labels for the dataset used for the monitoring job.</p>', 'refs' => [ 'ModelBiasJobInput$GroundTruthS3Input' => '<p>Location of ground truth labels to use in model bias job.</p>', 'ModelQualityJobInput$GroundTruthS3Input' => '<p>The ground truth label provided for the model.</p>', ], ], 'MonitoringInput' => [ 'base' => '<p>The inputs for a monitoring job.</p>', 'refs' => [ 'MonitoringInputs$member' => NULL, ], ], 'MonitoringInputs' => [ 'base' => NULL, 'refs' => [ 'MonitoringJobDefinition$MonitoringInputs' => '<p>The array of inputs for the monitoring job. Currently we support monitoring an Amazon SageMaker Endpoint.</p>', ], ], 'MonitoringJobDefinition' => [ 'base' => '<p>Defines the monitoring job.</p>', 'refs' => [ 'MonitoringScheduleConfig$MonitoringJobDefinition' => '<p>Defines the monitoring job.</p>', ], ], 'MonitoringJobDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'CreateDataQualityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the job definition.</p>', 'CreateModelBiasJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model bias job.</p>', 'CreateModelExplainabilityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model explainability job.</p>', 'CreateModelQualityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model quality monitoring job.</p>', 'DescribeDataQualityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the data quality monitoring job definition.</p>', 'DescribeModelBiasJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model bias job.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model explainability job.</p>', 'DescribeModelQualityJobDefinitionResponse$JobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the model quality job.</p>', 'MonitoringJobDefinitionSummary$MonitoringJobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the monitoring job.</p>', ], ], 'MonitoringJobDefinitionName' => [ 'base' => NULL, 'refs' => [ 'CreateDataQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name for the monitoring job definition.</p>', 'CreateModelBiasJobDefinitionRequest$JobDefinitionName' => '<p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'CreateModelExplainabilityJobDefinitionRequest$JobDefinitionName' => '<p> The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'CreateModelQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the monitoring job definition.</p>', 'DeleteDataQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the data quality monitoring job definition to delete.</p>', 'DeleteModelBiasJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model bias job definition to delete.</p>', 'DeleteModelExplainabilityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model explainability job definition to delete.</p>', 'DeleteModelQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model quality monitoring job definition to delete.</p>', 'DescribeDataQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the data quality monitoring job definition to describe.</p>', 'DescribeDataQualityJobDefinitionResponse$JobDefinitionName' => '<p>The name of the data quality monitoring job definition.</p>', 'DescribeModelBiasJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelBiasJobDefinitionResponse$JobDefinitionName' => '<p>The name of the bias job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelExplainabilityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$JobDefinitionName' => '<p>The name of the explainability job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelQualityJobDefinitionRequest$JobDefinitionName' => '<p>The name of the model quality job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeModelQualityJobDefinitionResponse$JobDefinitionName' => '<p>The name of the quality job definition. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'ListMonitoringExecutionsRequest$MonitoringJobDefinitionName' => '<p>Gets a list of the monitoring job runs of the specified monitoring job definitions.</p>', 'ListMonitoringSchedulesRequest$MonitoringJobDefinitionName' => '<p>Gets a list of the monitoring schedules for the specified monitoring job definition.</p>', 'MonitoringExecutionSummary$MonitoringJobDefinitionName' => '<p>The name of the monitoring job.</p>', 'MonitoringJobDefinitionSummary$MonitoringJobDefinitionName' => '<p>The name of the monitoring job.</p>', 'MonitoringScheduleConfig$MonitoringJobDefinitionName' => '<p>The name of the monitoring job definition to schedule.</p>', 'MonitoringScheduleSummary$MonitoringJobDefinitionName' => '<p>The name of the monitoring job definition that the schedule is for.</p>', ], ], 'MonitoringJobDefinitionSortKey' => [ 'base' => NULL, 'refs' => [ 'ListDataQualityJobDefinitionsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', 'ListModelBiasJobDefinitionsRequest$SortBy' => '<p>Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is <code>CreationTime</code>.</p>', 'ListModelExplainabilityJobDefinitionsRequest$SortBy' => '<p>Whether to sort results by the <code>Name</code> or <code>CreationTime</code> field. The default is <code>CreationTime</code>.</p>', 'ListModelQualityJobDefinitionsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'MonitoringJobDefinitionSummary' => [ 'base' => '<p>Summary information about a monitoring job.</p>', 'refs' => [ 'MonitoringJobDefinitionSummaryList$member' => NULL, ], ], 'MonitoringJobDefinitionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataQualityJobDefinitionsResponse$JobDefinitionSummaries' => '<p>A list of data quality monitoring job definitions.</p>', 'ListModelBiasJobDefinitionsResponse$JobDefinitionSummaries' => '<p>A JSON array in which each element is a summary for a model bias jobs.</p>', 'ListModelExplainabilityJobDefinitionsResponse$JobDefinitionSummaries' => '<p>A JSON array in which each element is a summary for a explainability bias jobs.</p>', 'ListModelQualityJobDefinitionsResponse$JobDefinitionSummaries' => '<p>A list of summaries of model quality monitoring job definitions.</p>', ], ], 'MonitoringMaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'MonitoringStoppingCondition$MaxRuntimeInSeconds' => '<p>The maximum runtime allowed in seconds.</p> <note> <p>The <code>MaxRuntimeInSeconds</code> cannot exceed the frequency of the job. For data quality and model explainability, this can be up to 3600 seconds for an hourly schedule. For model bias and model quality hourly schedules, this can be up to 1800 seconds.</p> </note>', ], ], 'MonitoringNetworkConfig' => [ 'base' => '<p>The networking configuration for the monitoring job.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$NetworkConfig' => '<p>Specifies networking configuration for the monitoring job.</p>', 'CreateModelBiasJobDefinitionRequest$NetworkConfig' => '<p>Networking options for a model bias job.</p>', 'CreateModelExplainabilityJobDefinitionRequest$NetworkConfig' => '<p>Networking options for a model explainability job.</p>', 'CreateModelQualityJobDefinitionRequest$NetworkConfig' => '<p>Specifies the network configuration for the monitoring job.</p>', 'DescribeDataQualityJobDefinitionResponse$NetworkConfig' => '<p>The networking configuration for the data quality monitoring job.</p>', 'DescribeModelBiasJobDefinitionResponse$NetworkConfig' => '<p>Networking options for a model bias job.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$NetworkConfig' => '<p>Networking options for a model explainability job.</p>', 'DescribeModelQualityJobDefinitionResponse$NetworkConfig' => '<p>Networking options for a model quality job.</p>', ], ], 'MonitoringOutput' => [ 'base' => '<p>The output object for a monitoring job.</p>', 'refs' => [ 'MonitoringOutputs$member' => NULL, ], ], 'MonitoringOutputConfig' => [ 'base' => '<p>The output configuration for monitoring jobs.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$DataQualityJobOutputConfig' => NULL, 'CreateModelBiasJobDefinitionRequest$ModelBiasJobOutputConfig' => NULL, 'CreateModelExplainabilityJobDefinitionRequest$ModelExplainabilityJobOutputConfig' => NULL, 'CreateModelQualityJobDefinitionRequest$ModelQualityJobOutputConfig' => NULL, 'DescribeDataQualityJobDefinitionResponse$DataQualityJobOutputConfig' => NULL, 'DescribeModelBiasJobDefinitionResponse$ModelBiasJobOutputConfig' => NULL, 'DescribeModelExplainabilityJobDefinitionResponse$ModelExplainabilityJobOutputConfig' => NULL, 'DescribeModelQualityJobDefinitionResponse$ModelQualityJobOutputConfig' => NULL, 'MonitoringJobDefinition$MonitoringOutputConfig' => '<p>The array of outputs from the monitoring job to be uploaded to Amazon Simple Storage Service (Amazon S3).</p>', ], ], 'MonitoringOutputs' => [ 'base' => NULL, 'refs' => [ 'MonitoringOutputConfig$MonitoringOutputs' => '<p>Monitoring outputs for monitoring jobs. This is where the output of the periodic monitoring jobs is uploaded.</p>', ], ], 'MonitoringProblemType' => [ 'base' => NULL, 'refs' => [ 'ModelQualityAppSpecification$ProblemType' => '<p>The machine learning problem type of the model that the monitoring job monitors.</p>', ], ], 'MonitoringResources' => [ 'base' => '<p>Identifies the resources to deploy for a monitoring job.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$JobResources' => NULL, 'CreateModelBiasJobDefinitionRequest$JobResources' => NULL, 'CreateModelExplainabilityJobDefinitionRequest$JobResources' => NULL, 'CreateModelQualityJobDefinitionRequest$JobResources' => NULL, 'DescribeDataQualityJobDefinitionResponse$JobResources' => NULL, 'DescribeModelBiasJobDefinitionResponse$JobResources' => NULL, 'DescribeModelExplainabilityJobDefinitionResponse$JobResources' => NULL, 'DescribeModelQualityJobDefinitionResponse$JobResources' => NULL, 'MonitoringJobDefinition$MonitoringResources' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. In distributed processing, you specify more than one instance.</p>', ], ], 'MonitoringS3Output' => [ 'base' => '<p>Information about where and how you want to store the results of a monitoring job.</p>', 'refs' => [ 'MonitoringOutput$S3Output' => '<p>The Amazon S3 storage location where the results of a monitoring job are saved.</p>', ], ], 'MonitoringS3Uri' => [ 'base' => NULL, 'refs' => [ 'MonitoringGroundTruthS3Input$S3Uri' => '<p>The address of the Amazon S3 location of the ground truth labels.</p>', 'MonitoringS3Output$S3Uri' => '<p>A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.</p>', ], ], 'MonitoringSchedule' => [ 'base' => '<p>A schedule for a model monitoring job. For information about model monitor, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>', 'refs' => [ 'MonitoringScheduleList$member' => NULL, ], ], 'MonitoringScheduleArn' => [ 'base' => NULL, 'refs' => [ 'CreateMonitoringScheduleResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'DescribeMonitoringScheduleResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'DescribeProcessingJobResponse$MonitoringScheduleArn' => '<p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>', 'MonitoringSchedule$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'MonitoringScheduleSummary$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', 'ProcessingJob$MonitoringScheduleArn' => '<p>The ARN of a monitoring schedule for an endpoint associated with this processing job.</p>', 'UpdateMonitoringScheduleResponse$MonitoringScheduleArn' => '<p>The Amazon Resource Name (ARN) of the monitoring schedule.</p>', ], ], 'MonitoringScheduleConfig' => [ 'base' => '<p>Configures the monitoring schedule and defines the monitoring job.</p>', 'refs' => [ 'CreateMonitoringScheduleRequest$MonitoringScheduleConfig' => '<p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>', 'DescribeMonitoringScheduleResponse$MonitoringScheduleConfig' => '<p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>', 'MonitoringSchedule$MonitoringScheduleConfig' => NULL, 'UpdateMonitoringScheduleRequest$MonitoringScheduleConfig' => '<p>The configuration object that specifies the monitoring schedule and defines the monitoring job.</p>', ], ], 'MonitoringScheduleList' => [ 'base' => NULL, 'refs' => [ 'Endpoint$MonitoringSchedules' => '<p>A list of monitoring schedules for the endpoint. For information about model monitoring, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker Model Monitor</a>.</p>', ], ], 'MonitoringScheduleName' => [ 'base' => NULL, 'refs' => [ 'CreateMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an Amazon Web Services account.</p>', 'DeleteMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the monitoring schedule to delete.</p>', 'DescribeMonitoringScheduleRequest$MonitoringScheduleName' => '<p>Name of a previously created monitoring schedule.</p>', 'DescribeMonitoringScheduleResponse$MonitoringScheduleName' => '<p>Name of the monitoring schedule.</p>', 'ListMonitoringExecutionsRequest$MonitoringScheduleName' => '<p>Name of a specific schedule to fetch jobs for.</p>', 'MonitoringExecutionSummary$MonitoringScheduleName' => '<p>The name of the monitoring schedule.</p>', 'MonitoringSchedule$MonitoringScheduleName' => '<p>The name of the monitoring schedule.</p>', 'MonitoringScheduleSummary$MonitoringScheduleName' => '<p>The name of the monitoring schedule.</p>', 'StartMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the schedule to start.</p>', 'StopMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the schedule to stop.</p>', 'UpdateMonitoringScheduleRequest$MonitoringScheduleName' => '<p>The name of the monitoring schedule. The name must be unique within an Amazon Web Services Region within an Amazon Web Services account.</p>', ], ], 'MonitoringScheduleSortKey' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringSchedulesRequest$SortBy' => '<p>Whether to sort results by <code>Status</code>, <code>CreationTime</code>, <code>ScheduledTime</code> field. The default is <code>CreationTime</code>.</p>', ], ], 'MonitoringScheduleSummary' => [ 'base' => '<p>Summarizes the monitoring schedule.</p>', 'refs' => [ 'MonitoringScheduleSummaryList$member' => NULL, ], ], 'MonitoringScheduleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMonitoringSchedulesResponse$MonitoringScheduleSummaries' => '<p>A JSON array in which each element is a summary for a monitoring schedule.</p>', ], ], 'MonitoringStatisticsResource' => [ 'base' => '<p>The statistics resource for a monitoring job.</p>', 'refs' => [ 'DataQualityBaselineConfig$StatisticsResource' => NULL, 'MonitoringBaselineConfig$StatisticsResource' => '<p>The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.</p>', ], ], 'MonitoringStoppingCondition' => [ 'base' => '<p>A time limit for how long the monitoring job is allowed to run before stopping.</p>', 'refs' => [ 'CreateDataQualityJobDefinitionRequest$StoppingCondition' => NULL, 'CreateModelBiasJobDefinitionRequest$StoppingCondition' => NULL, 'CreateModelExplainabilityJobDefinitionRequest$StoppingCondition' => NULL, 'CreateModelQualityJobDefinitionRequest$StoppingCondition' => NULL, 'DescribeDataQualityJobDefinitionResponse$StoppingCondition' => NULL, 'DescribeModelBiasJobDefinitionResponse$StoppingCondition' => NULL, 'DescribeModelExplainabilityJobDefinitionResponse$StoppingCondition' => NULL, 'DescribeModelQualityJobDefinitionResponse$StoppingCondition' => NULL, 'MonitoringJobDefinition$StoppingCondition' => '<p>Specifies a time limit for how long the monitoring job is allowed to run.</p>', ], ], 'MonitoringTimeOffsetString' => [ 'base' => NULL, 'refs' => [ 'EndpointInput$StartTimeOffset' => '<p>If specified, monitoring jobs substract this time from the start time. For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a>.</p>', 'EndpointInput$EndTimeOffset' => '<p>If specified, monitoring jobs substract this time from the end time. For information about using offsets for scheduling monitoring jobs, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html">Schedule Model Quality Monitoring Jobs</a>.</p>', ], ], 'MonitoringType' => [ 'base' => NULL, 'refs' => [ 'DescribeMonitoringScheduleResponse$MonitoringType' => '<p>The type of the monitoring job that this schedule runs. This is one of the following values.</p> <ul> <li> <p> <code>DATA_QUALITY</code> - The schedule is for a data quality monitoring job.</p> </li> <li> <p> <code>MODEL_QUALITY</code> - The schedule is for a model quality monitoring job.</p> </li> <li> <p> <code>MODEL_BIAS</code> - The schedule is for a bias monitoring job.</p> </li> <li> <p> <code>MODEL_EXPLAINABILITY</code> - The schedule is for an explainability monitoring job.</p> </li> </ul>', 'ListMonitoringExecutionsRequest$MonitoringTypeEquals' => '<p>A filter that returns only the monitoring job runs of the specified monitoring type.</p>', 'ListMonitoringSchedulesRequest$MonitoringTypeEquals' => '<p>A filter that returns only the monitoring schedules for the specified monitoring type.</p>', 'MonitoringExecutionSummary$MonitoringType' => '<p>The type of the monitoring job.</p>', 'MonitoringSchedule$MonitoringType' => '<p>The type of the monitoring job definition to schedule.</p>', 'MonitoringScheduleConfig$MonitoringType' => '<p>The type of the monitoring job definition to schedule.</p>', 'MonitoringScheduleSummary$MonitoringType' => '<p>The type of the monitoring job definition that the schedule is for.</p>', ], ], 'MountPath' => [ 'base' => NULL, 'refs' => [ 'FileSystemConfig$MountPath' => '<p>The path within the image to mount the user\'s EFS home directory. The directory should be empty. If not specified, defaults to <i>/home/sagemaker-user</i>.</p>', ], ], 'MultiModelConfig' => [ 'base' => '<p>Specifies additional configuration for hosting multi-model endpoints.</p>', 'refs' => [ 'ContainerDefinition$MultiModelConfig' => '<p>Specifies additional configuration for multi-model endpoints.</p>', ], ], 'NameContains' => [ 'base' => NULL, 'refs' => [ 'ListAlgorithmsInput$NameContains' => '<p>A string in the algorithm name. This filter returns only algorithms whose name contains the specified string.</p>', 'ListCompilationJobsRequest$NameContains' => '<p>A filter that returns the model compilation jobs whose name contains a specified string.</p>', 'ListDataQualityJobDefinitionsRequest$NameContains' => '<p>A string in the data quality monitoring job definition name. This filter returns only data quality monitoring job definitions whose name contains the specified string.</p>', 'ListDeviceFleetsRequest$NameContains' => '<p>Filter for fleets containing this name in their fleet device name.</p>', 'ListEdgePackagingJobsRequest$NameContains' => '<p>Filter for jobs containing this name in their packaging job name.</p>', 'ListEdgePackagingJobsRequest$ModelNameContains' => '<p>Filter for jobs where the model name contains this string.</p>', 'ListHyperParameterTuningJobsRequest$NameContains' => '<p>A string in the tuning job name. This filter returns only tuning jobs whose name contains the specified string.</p>', 'ListInferenceRecommendationsJobsRequest$NameContains' => '<p>A string in the job name. This filter returns only recommendations whose name contains the specified string.</p>', 'ListLabelingJobsRequest$NameContains' => '<p>A string in the labeling job name. This filter returns only labeling jobs whose name contains the specified string.</p>', 'ListModelBiasJobDefinitionsRequest$NameContains' => '<p>Filter for model bias jobs whose name contains a specified string.</p>', 'ListModelExplainabilityJobDefinitionsRequest$NameContains' => '<p>Filter for model explainability jobs whose name contains a specified string.</p>', 'ListModelPackageGroupsInput$NameContains' => '<p>A string in the model group name. This filter returns only model groups whose name contains the specified string.</p>', 'ListModelPackagesInput$NameContains' => '<p>A string in the model package name. This filter returns only model packages whose name contains the specified string.</p>', 'ListModelQualityJobDefinitionsRequest$NameContains' => '<p>A string in the transform job name. This filter returns only model quality monitoring job definitions whose name contains the specified string.</p>', 'ListMonitoringSchedulesRequest$NameContains' => '<p>Filter for monitoring schedules whose name contains a specified string.</p>', 'ListTrainingJobsRequest$NameContains' => '<p>A string in the training job name. This filter returns only training jobs whose name contains the specified string.</p>', 'ListTransformJobsRequest$NameContains' => '<p>A string in the transform job name. This filter returns only transform jobs whose name contains the specified string.</p>', ], ], 'NeoVpcConfig' => [ 'base' => '<p>The <a>VpcConfig</a> configuration object that specifies the VPC that you want the compilation jobs to connect to. For more information on controlling access to your Amazon S3 buckets used for compilation job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Give Amazon SageMaker Compilation Jobs Access to Resources in Your Amazon VPC</a>.</p>', 'refs' => [ 'CreateCompilationJobRequest$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'DescribeCompilationJobResponse$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that you want your compilation job to connect to. Control access to your models by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', ], ], 'NeoVpcSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'NeoVpcSecurityGroupIds$member' => NULL, ], ], 'NeoVpcSecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'NeoVpcConfig$SecurityGroupIds' => '<p>The VPC security group IDs. IDs have the form of <code>sg-xxxxxxxx</code>. Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.</p>', ], ], 'NeoVpcSubnetId' => [ 'base' => NULL, 'refs' => [ 'NeoVpcSubnets$member' => NULL, ], ], 'NeoVpcSubnets' => [ 'base' => NULL, 'refs' => [ 'NeoVpcConfig$Subnets' => '<p>The ID of the subnets in the VPC that you want to connect the compilation job to for accessing the model in Amazon S3.</p>', ], ], 'NestedFilters' => [ 'base' => '<p>A list of nested <a>Filter</a> objects. A resource must satisfy the conditions of all filters to be included in the results returned from the <a>Search</a> API.</p> <p>For example, to filter on a training job\'s <code>InputDataConfig</code> property with a specific channel name and <code>S3Uri</code> prefix, define the following filters:</p> <ul> <li> <p> <code>\'{Name:"InputDataConfig.ChannelName", "Operator":"Equals", "Value":"train"}\',</code> </p> </li> <li> <p> <code>\'{Name:"InputDataConfig.DataSource.S3DataSource.S3Uri", "Operator":"Contains", "Value":"mybucket/catdata"}\'</code> </p> </li> </ul>', 'refs' => [ 'NestedFiltersList$member' => NULL, ], ], 'NestedFiltersList' => [ 'base' => NULL, 'refs' => [ 'SearchExpression$NestedFilters' => '<p>A list of nested filter objects.</p>', ], ], 'NetworkConfig' => [ 'base' => '<p>Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.</p>', 'refs' => [ 'CreateProcessingJobRequest$NetworkConfig' => '<p>Networking options for a processing job, such as whether to allow inbound and outbound network calls to and from processing containers, and the VPC subnets and security groups to use for VPC-enabled processing jobs.</p>', 'DescribeProcessingJobResponse$NetworkConfig' => '<p>Networking options for a processing job.</p>', 'MonitoringJobDefinition$NetworkConfig' => '<p>Specifies networking options for an monitoring job.</p>', 'ProcessingJob$NetworkConfig' => NULL, ], ], 'NetworkInterfaceId' => [ 'base' => NULL, 'refs' => [ 'DescribeNotebookInstanceOutput$NetworkInterfaceId' => '<p>The network interface IDs that Amazon SageMaker created at the time of creating the instance. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceRequest$NextToken' => '<p>Next token of device description.</p>', 'DescribeDeviceResponse$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'DescribeFeatureGroupRequest$NextToken' => '<p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>). 2,500 <code>Features</code> are returned by default.</p>', 'DescribeFeatureGroupResponse$NextToken' => '<p>A token to resume pagination of the list of <code>Features</code> (<code>FeatureDefinitions</code>).</p>', 'ListActionsRequest$NextToken' => '<p>If the previous call to <code>ListActions</code> didn\'t return the full set of actions, the call returns a token for getting the next set of actions.</p>', 'ListActionsResponse$NextToken' => '<p>A token for getting the next set of actions, if there are any.</p>', 'ListAlgorithmsInput$NextToken' => '<p>If the response to a previous <code>ListAlgorithms</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of algorithms, use the token in the next request.</p>', 'ListAlgorithmsOutput$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>', 'ListAppImageConfigsRequest$NextToken' => '<p>If the previous call to <code>ListImages</code> didn\'t return the full set of AppImageConfigs, the call returns a token for getting the next set of AppImageConfigs.</p>', 'ListAppImageConfigsResponse$NextToken' => '<p>A token for getting the next set of AppImageConfigs, if there are any.</p>', 'ListAppsRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListAppsResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListArtifactsRequest$NextToken' => '<p>If the previous call to <code>ListArtifacts</code> didn\'t return the full set of artifacts, the call returns a token for getting the next set of artifacts.</p>', 'ListArtifactsResponse$NextToken' => '<p>A token for getting the next set of artifacts, if there are any.</p>', 'ListAssociationsRequest$NextToken' => '<p>If the previous call to <code>ListAssociations</code> didn\'t return the full set of associations, the call returns a token for getting the next set of associations.</p>', 'ListAssociationsResponse$NextToken' => '<p>A token for getting the next set of associations, if there are any.</p>', 'ListAutoMLJobsRequest$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListAutoMLJobsResponse$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListCandidatesForAutoMLJobRequest$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListCandidatesForAutoMLJobResponse$NextToken' => '<p>If the previous response was truncated, you receive this token. Use it in your next request to receive the next set of results.</p>', 'ListCodeRepositoriesInput$NextToken' => '<p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>', 'ListCodeRepositoriesOutput$NextToken' => '<p>If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.</p>', 'ListCompilationJobsRequest$NextToken' => '<p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>', 'ListCompilationJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this <code>NextToken</code>. To retrieve the next set of model compilation jobs, use this token in the next request.</p>', 'ListContextsRequest$NextToken' => '<p>If the previous call to <code>ListContexts</code> didn\'t return the full set of contexts, the call returns a token for getting the next set of contexts.</p>', 'ListContextsResponse$NextToken' => '<p>A token for getting the next set of contexts, if there are any.</p>', 'ListDataQualityJobDefinitionsRequest$NextToken' => '<p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of transform jobs, use the token in the next request.&gt;</p>', 'ListDataQualityJobDefinitionsResponse$NextToken' => '<p>If the result of the previous <code>ListDataQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of data quality monitoring job definitions, use the token in the next request.</p>', 'ListDeviceFleetsRequest$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListDeviceFleetsResponse$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListDevicesRequest$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListDevicesResponse$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListDomainsRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListDomainsResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListEdgePackagingJobsRequest$NextToken' => '<p>The response from the last list when returning a list large enough to need tokening.</p>', 'ListEdgePackagingJobsResponse$NextToken' => '<p>Token to use when calling the next page of results.</p>', 'ListExperimentsRequest$NextToken' => '<p>If the previous call to <code>ListExperiments</code> didn\'t return the full set of experiments, the call returns a token for getting the next set of experiments.</p>', 'ListExperimentsResponse$NextToken' => '<p>A token for getting the next set of experiments, if there are any.</p>', 'ListFeatureGroupsRequest$NextToken' => '<p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>', 'ListFeatureGroupsResponse$NextToken' => '<p>A token to resume pagination of <code>ListFeatureGroups</code> results.</p>', 'ListFlowDefinitionsRequest$NextToken' => '<p>A token to resume pagination.</p>', 'ListFlowDefinitionsResponse$NextToken' => '<p>A token to resume pagination.</p>', 'ListHumanTaskUisRequest$NextToken' => '<p>A token to resume pagination.</p>', 'ListHumanTaskUisResponse$NextToken' => '<p>A token to resume pagination.</p>', 'ListHyperParameterTuningJobsRequest$NextToken' => '<p>If the result of the previous <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>', 'ListHyperParameterTuningJobsResponse$NextToken' => '<p>If the result of this <code>ListHyperParameterTuningJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of tuning jobs, use the token in the next request.</p>', 'ListImageVersionsRequest$NextToken' => '<p>If the previous call to <code>ListImageVersions</code> didn\'t return the full set of versions, the call returns a token for getting the next set of versions.</p>', 'ListImageVersionsResponse$NextToken' => '<p>A token for getting the next set of versions, if there are any.</p>', 'ListImagesRequest$NextToken' => '<p>If the previous call to <code>ListImages</code> didn\'t return the full set of images, the call returns a token for getting the next set of images.</p>', 'ListImagesResponse$NextToken' => '<p>A token for getting the next set of images, if there are any.</p>', 'ListInferenceRecommendationsJobsRequest$NextToken' => '<p>If the response to a previous <code>ListInferenceRecommendationsJobsRequest</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of recommendations, use the token in the next request.</p>', 'ListInferenceRecommendationsJobsResponse$NextToken' => '<p>A token for getting the next set of recommendations, if there are any.</p>', 'ListLabelingJobsForWorkteamRequest$NextToken' => '<p>If the result of the previous <code>ListLabelingJobsForWorkteam</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListLabelingJobsForWorkteamResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>', 'ListLabelingJobsRequest$NextToken' => '<p>If the result of the previous <code>ListLabelingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListLabelingJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of labeling jobs, use it in the subsequent request.</p>', 'ListLineageGroupsRequest$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>', 'ListLineageGroupsResponse$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of algorithms, use it in the subsequent request.</p>', 'ListModelBiasJobDefinitionsRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListModelBiasJobDefinitionsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>', 'ListModelExplainabilityJobDefinitionsRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListModelExplainabilityJobDefinitionsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>', 'ListModelMetadataRequest$NextToken' => '<p>If the response to a previous <code>ListModelMetadataResponse</code> request was truncated, the response includes a NextToken. To retrieve the next set of model metadata, use the token in the next request.</p>', 'ListModelMetadataResponse$NextToken' => '<p>A token for getting the next set of recommendations, if there are any.</p>', 'ListModelPackageGroupsInput$NextToken' => '<p>If the result of the previous <code>ListModelPackageGroups</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model groups, use the token in the next request.</p>', 'ListModelPackageGroupsOutput$NextToken' => '<p>If the response is truncated, SageMaker returns this token. To retrieve the next set of model groups, use it in the subsequent request.</p>', 'ListModelPackagesInput$NextToken' => '<p>If the response to a previous <code>ListModelPackages</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model packages, use the token in the next request.</p>', 'ListModelPackagesOutput$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model packages, use it in the subsequent request.</p>', 'ListModelQualityJobDefinitionsRequest$NextToken' => '<p>If the result of the previous <code>ListModelQualityJobDefinitions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model quality monitoring job definitions, use the token in the next request.</p>', 'ListModelQualityJobDefinitionsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of model quality monitoring job definitions, use it in the next request.</p>', 'ListMonitoringExecutionsRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListMonitoringExecutionsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent reques</p>', 'ListMonitoringSchedulesRequest$NextToken' => '<p>The token returned if the response is truncated. To retrieve the next set of job executions, use it in the next request.</p>', 'ListMonitoringSchedulesResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in the subsequent request.</p>', 'ListNotebookInstanceLifecycleConfigsInput$NextToken' => '<p>If the result of a <code>ListNotebookInstanceLifecycleConfigs</code> request was truncated, the response includes a <code>NextToken</code>. To get the next set of lifecycle configurations, use the token in the next request.</p>', 'ListNotebookInstanceLifecycleConfigsOutput$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle configurations, use it in the next request. </p>', 'ListNotebookInstancesInput$NextToken' => '<p> If the previous call to the <code>ListNotebookInstances</code> is truncated, the response includes a <code>NextToken</code>. You can use this token in your subsequent <code>ListNotebookInstances</code> request to fetch the next set of notebook instances. </p> <note> <p>You might specify a filter or a sort order in your request. When response is truncated, you must use the same values for the filer and sort order in the next request. </p> </note>', 'ListNotebookInstancesOutput$NextToken' => '<p>If the response to the previous <code>ListNotebookInstances</code> request was truncated, Amazon SageMaker returns this token. To retrieve the next set of notebook instances, use the token in the next request.</p>', 'ListPipelineExecutionStepsRequest$NextToken' => '<p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>', 'ListPipelineExecutionStepsResponse$NextToken' => '<p>If the result of the previous <code>ListPipelineExecutionSteps</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline execution steps, use the token in the next request.</p>', 'ListPipelineExecutionsRequest$NextToken' => '<p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>', 'ListPipelineExecutionsResponse$NextToken' => '<p>If the result of the previous <code>ListPipelineExecutions</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipeline executions, use the token in the next request.</p>', 'ListPipelineParametersForExecutionRequest$NextToken' => '<p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>', 'ListPipelineParametersForExecutionResponse$NextToken' => '<p>If the result of the previous <code>ListPipelineParametersForExecution</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of parameters, use the token in the next request.</p>', 'ListPipelinesRequest$NextToken' => '<p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>', 'ListPipelinesResponse$NextToken' => '<p>If the result of the previous <code>ListPipelines</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of pipelines, use the token in the next request.</p>', 'ListProcessingJobsRequest$NextToken' => '<p>If the result of the previous <code>ListProcessingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of processing jobs, use the token in the next request.</p>', 'ListProcessingJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of processing jobs, use it in the subsequent request.</p>', 'ListProjectsInput$NextToken' => '<p>If the result of the previous <code>ListProjects</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of projects, use the token in the next request.</p>', 'ListProjectsOutput$NextToken' => '<p>If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.</p>', 'ListStudioLifecycleConfigsRequest$NextToken' => '<p>If the previous call to ListStudioLifecycleConfigs didn\'t return the full set of Lifecycle Configurations, the call returns a token for getting the next set of Lifecycle Configurations.</p>', 'ListStudioLifecycleConfigsResponse$NextToken' => '<p>A token for getting the next set of actions, if there are any.</p>', 'ListSubscribedWorkteamsRequest$NextToken' => '<p>If the result of the previous <code>ListSubscribedWorkteams</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListSubscribedWorkteamsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>', 'ListTagsInput$NextToken' => '<p> If the response to the previous <code>ListTags</code> request is truncated, Amazon SageMaker returns this token. To retrieve the next set of tags, use it in the subsequent request. </p>', 'ListTagsOutput$NextToken' => '<p> If response is truncated, Amazon SageMaker includes a token in the response. You can use this token in your subsequent request to fetch next set of tokens. </p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$NextToken' => '<p>If the result of the previous <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>', 'ListTrainingJobsForHyperParameterTuningJobResponse$NextToken' => '<p>If the result of this <code>ListTrainingJobsForHyperParameterTuningJob</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request.</p>', 'ListTrainingJobsRequest$NextToken' => '<p>If the result of the previous <code>ListTrainingJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of training jobs, use the token in the next request. </p>', 'ListTrainingJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request.</p>', 'ListTransformJobsRequest$NextToken' => '<p>If the result of the previous <code>ListTransformJobs</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of transform jobs, use the token in the next request.</p>', 'ListTransformJobsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of transform jobs, use it in the next request.</p>', 'ListTrialComponentsRequest$NextToken' => '<p>If the previous call to <code>ListTrialComponents</code> didn\'t return the full set of components, the call returns a token for getting the next set of components.</p>', 'ListTrialComponentsResponse$NextToken' => '<p>A token for getting the next set of components, if there are any.</p>', 'ListTrialsRequest$NextToken' => '<p>If the previous call to <code>ListTrials</code> didn\'t return the full set of trials, the call returns a token for getting the next set of trials.</p>', 'ListTrialsResponse$NextToken' => '<p>A token for getting the next set of trials, if there are any.</p>', 'ListUserProfilesRequest$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListUserProfilesResponse$NextToken' => '<p>If the previous response was truncated, you will receive this token. Use it in your next request to receive the next set of results.</p>', 'ListWorkforcesRequest$NextToken' => '<p>A token to resume pagination.</p>', 'ListWorkforcesResponse$NextToken' => '<p>A token to resume pagination.</p>', 'ListWorkteamsRequest$NextToken' => '<p>If the result of the previous <code>ListWorkteams</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.</p>', 'ListWorkteamsResponse$NextToken' => '<p>If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of work teams, use it in the subsequent request.</p>', 'SearchRequest$NextToken' => '<p>If more than <code>MaxResults</code> resources match the specified <code>SearchExpression</code>, the response includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to the next <code>SearchRequest</code> to continue retrieving results.</p>', 'SearchResponse$NextToken' => '<p>If the result of the previous <code>Search</code> request was truncated, the response includes a NextToken. To retrieve the next set of results, use the token in the next request.</p>', ], ], 'NotebookInstanceAcceleratorType' => [ 'base' => NULL, 'refs' => [ 'NotebookInstanceAcceleratorTypes$member' => NULL, ], ], 'NotebookInstanceAcceleratorTypes' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$AcceleratorTypes' => '<p>A list of Elastic Inference (EI) instance types to associate with this notebook instance. Currently, only one instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', 'DescribeNotebookInstanceOutput$AcceleratorTypes' => '<p>A list of the Elastic Inference (EI) instance types associated with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', 'UpdateNotebookInstanceInput$AcceleratorTypes' => '<p>A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only one EI instance type can be associated with a notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', ], ], 'NotebookInstanceArn' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceOutput$NotebookInstanceArn' => '<p>The Amazon Resource Name (ARN) of the notebook instance. </p>', 'DescribeNotebookInstanceOutput$NotebookInstanceArn' => '<p>The Amazon Resource Name (ARN) of the notebook instance.</p>', 'NotebookInstanceSummary$NotebookInstanceArn' => '<p>The Amazon Resource Name (ARN) of the notebook instance.</p>', ], ], 'NotebookInstanceLifecycleConfigArn' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceLifecycleConfigOutput$NotebookInstanceLifecycleConfigArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$NotebookInstanceLifecycleConfigArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>', 'NotebookInstanceLifecycleConfigSummary$NotebookInstanceLifecycleConfigArn' => '<p>The Amazon Resource Name (ARN) of the lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleConfigContent' => [ 'base' => NULL, 'refs' => [ 'NotebookInstanceLifecycleHook$Content' => '<p>A base64-encoded string that contains a shell script for a notebook instance lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceLifecycleConfigInput$OnCreate' => '<p>A shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>', 'CreateNotebookInstanceLifecycleConfigInput$OnStart' => '<p>A shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$OnCreate' => '<p>The shell script that runs only once, when you create a notebook instance.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$OnStart' => '<p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance.</p>', 'UpdateNotebookInstanceLifecycleConfigInput$OnCreate' => '<p>The shell script that runs only once, when you create a notebook instance. The shell script must be a base64-encoded string.</p>', 'UpdateNotebookInstanceLifecycleConfigInput$OnStart' => '<p>The shell script that runs every time you start a notebook instance, including when you create the notebook instance. The shell script must be a base64-encoded string.</p>', ], ], 'NotebookInstanceLifecycleConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$LifecycleConfigName' => '<p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'CreateNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', 'DeleteNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration to delete.</p>', 'DescribeNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration to describe.</p>', 'DescribeNotebookInstanceLifecycleConfigOutput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', 'DescribeNotebookInstanceOutput$NotebookInstanceLifecycleConfigName' => '<p>Returns the name of a notebook instance lifecycle configuration.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a> </p>', 'ListNotebookInstancesInput$NotebookInstanceLifecycleConfigNameContains' => '<p>A string in the name of a notebook instances lifecycle configuration associated with this notebook instance. This filter returns only notebook instances associated with a lifecycle configuration with a name that contains the specified string.</p>', 'NotebookInstanceLifecycleConfigSummary$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', 'NotebookInstanceSummary$NotebookInstanceLifecycleConfigName' => '<p>The name of a notebook instance lifecycle configuration associated with this notebook instance.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'UpdateNotebookInstanceInput$LifecycleConfigName' => '<p>The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'UpdateNotebookInstanceLifecycleConfigInput$NotebookInstanceLifecycleConfigName' => '<p>The name of the lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleConfigNameContains' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsInput$NameContains' => '<p>A string in the lifecycle configuration name. This filter returns only lifecycle configurations whose name contains the specified string.</p>', ], ], 'NotebookInstanceLifecycleConfigSortKey' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsInput$SortBy' => '<p>Sorts the list of results. The default is <code>CreationTime</code>.</p>', ], ], 'NotebookInstanceLifecycleConfigSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsInput$SortOrder' => '<p>The sort order for results.</p>', ], ], 'NotebookInstanceLifecycleConfigSummary' => [ 'base' => '<p>Provides a summary of a notebook instance lifecycle configuration.</p>', 'refs' => [ 'NotebookInstanceLifecycleConfigSummaryList$member' => NULL, ], ], 'NotebookInstanceLifecycleConfigSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstanceLifecycleConfigsOutput$NotebookInstanceLifecycleConfigs' => '<p>An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.</p>', ], ], 'NotebookInstanceLifecycleHook' => [ 'base' => '<p>Contains the notebook instance lifecycle configuration script.</p> <p>Each lifecycle configuration script has a limit of 16384 characters.</p> <p>The value of the <code>$PATH</code> environment variable that is available to both scripts is <code>/sbin:bin:/usr/sbin:/usr/bin</code>.</p> <p>View CloudWatch Logs for notebook instance lifecycle configurations in log group <code>/aws/sagemaker/NotebookInstances</code> in log stream <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.</p> <p>Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes, it fails and the notebook instance is not created or started.</p> <p>For information about notebook instance lifestyle configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional) Customize a Notebook Instance</a>.</p>', 'refs' => [ 'NotebookInstanceLifecycleConfigList$member' => NULL, ], ], 'NotebookInstanceName' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the new notebook instance.</p>', 'CreatePresignedNotebookInstanceUrlInput$NotebookInstanceName' => '<p>The name of the notebook instance.</p>', 'DeleteNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the Amazon SageMaker notebook instance to delete.</p>', 'DescribeNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance that you want information about.</p>', 'DescribeNotebookInstanceOutput$NotebookInstanceName' => '<p>The name of the Amazon SageMaker notebook instance. </p>', 'NotebookInstanceSummary$NotebookInstanceName' => '<p>The name of the notebook instance that you want a summary for.</p>', 'StartNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance to start.</p>', 'StopNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance to terminate.</p>', 'UpdateNotebookInstanceInput$NotebookInstanceName' => '<p>The name of the notebook instance to update.</p>', ], ], 'NotebookInstanceNameContains' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$NameContains' => '<p>A string in the notebook instances\' name. This filter returns only notebook instances whose name contains the specified string.</p>', ], ], 'NotebookInstanceSortKey' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p>', ], ], 'NotebookInstanceSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesInput$SortOrder' => '<p>The sort order for results. </p>', ], ], 'NotebookInstanceStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeNotebookInstanceOutput$NotebookInstanceStatus' => '<p>The status of the notebook instance.</p>', 'ListNotebookInstancesInput$StatusEquals' => '<p>A filter that returns only notebook instances with the specified status.</p>', 'NotebookInstanceSummary$NotebookInstanceStatus' => '<p>The status of the notebook instance.</p>', ], ], 'NotebookInstanceSummary' => [ 'base' => '<p>Provides summary information for an Amazon SageMaker notebook instance.</p>', 'refs' => [ 'NotebookInstanceSummaryList$member' => NULL, ], ], 'NotebookInstanceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListNotebookInstancesOutput$NotebookInstances' => '<p>An array of <code>NotebookInstanceSummary</code> objects, one for each notebook instance.</p>', ], ], 'NotebookInstanceUrl' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedNotebookInstanceUrlOutput$AuthorizedUrl' => '<p>A JSON object that contains the URL string. </p>', 'DescribeNotebookInstanceOutput$Url' => '<p>The URL that you use to connect to the Jupyter notebook that is running in your notebook instance. </p>', 'NotebookInstanceSummary$Url' => '<p>The URL that you use to connect to the Jupyter instance running in your notebook instance. </p>', ], ], 'NotebookInstanceVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.</p>', 'DescribeNotebookInstanceOutput$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume attached to the notebook instance.</p>', 'UpdateNotebookInstanceInput$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB. ML storage volumes are encrypted, so Amazon SageMaker can\'t determine the amount of available free space on the volume. Because of this, you can increase the volume size when you update a notebook instance, but you can\'t decrease the volume size. If you want to decrease the size of the ML storage volume in use, create a new notebook instance with the desired size.</p>', ], ], 'NotebookOutputOption' => [ 'base' => NULL, 'refs' => [ 'SharingSettings$NotebookOutputOption' => '<p>Whether to include the notebook cell output when sharing the notebook. The default is <code>Disabled</code>.</p>', ], ], 'NotificationConfiguration' => [ 'base' => '<p>Configures Amazon SNS notifications of available or expiring work items for work teams.</p>', 'refs' => [ 'CreateWorkteamRequest$NotificationConfiguration' => '<p>Configures notification of workers regarding available or expiring work items.</p>', 'UpdateWorkteamRequest$NotificationConfiguration' => '<p>Configures SNS topic notifications for available or expiring work items</p>', 'Workteam$NotificationConfiguration' => '<p>Configures SNS notifications of available or expiring work items for work teams.</p>', ], ], 'NotificationTopicArn' => [ 'base' => NULL, 'refs' => [ 'NotificationConfiguration$NotificationTopicArn' => '<p>The ARN for the Amazon SNS topic to which notifications should be published.</p>', ], ], 'NumberOfHumanWorkersPerDataObject' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$NumberOfHumanWorkersPerDataObject' => '<p>The number of human workers that will label an object. </p>', 'LabelingJobForWorkteamSummary$NumberOfHumanWorkersPerDataObject' => '<p>The configured number of workers per data object.</p>', ], ], 'ObjectiveStatus' => [ 'base' => NULL, 'refs' => [ 'AutoMLCandidate$ObjectiveStatus' => '<p>The objective\'s status.</p>', 'HyperParameterTrainingJobSummary$ObjectiveStatus' => '<p>The status of the objective metric for the training job:</p> <ul> <li> <p>Succeeded: The final objective metric for the training job was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.</p> </li> </ul> <ul> <li> <p>Pending: The training job is in progress and evaluation of its final objective metric is pending.</p> </li> </ul> <ul> <li> <p>Failed: The final objective metric for the training job was not evaluated, and was not used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.</p> </li> </ul>', ], ], 'ObjectiveStatusCounter' => [ 'base' => NULL, 'refs' => [ 'ObjectiveStatusCounters$Succeeded' => '<p>The number of training jobs whose final objective metric was evaluated by the hyperparameter tuning job and used in the hyperparameter tuning process.</p>', 'ObjectiveStatusCounters$Pending' => '<p>The number of training jobs that are in progress and pending evaluation of their final objective metric.</p>', 'ObjectiveStatusCounters$Failed' => '<p>The number of training jobs whose final objective metric was not evaluated and used in the hyperparameter tuning process. This typically occurs when the training job failed or did not emit an objective metric.</p>', ], ], 'ObjectiveStatusCounters' => [ 'base' => '<p>Specifies the number of training jobs that this hyperparameter tuning job launched, categorized by the status of their objective metric. The objective metric status shows whether the final objective metric for the training job has been evaluated by the tuning job and used in the hyperparameter tuning process.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$ObjectiveStatusCounters' => '<p>The <a>ObjectiveStatusCounters</a> object that specifies the number of training jobs, categorized by the status of their final objective metric, that this tuning job launched.</p>', 'HyperParameterTuningJobSummary$ObjectiveStatusCounters' => '<p>The <a>ObjectiveStatusCounters</a> object that specifies the numbers of training jobs, categorized by objective metric status, that this tuning job launched.</p>', ], ], 'OfflineStoreConfig' => [ 'base' => '<p>The configuration of an <code>OfflineStore</code>.</p> <p>Provide an <code>OfflineStoreConfig</code> in a request to <code>CreateFeatureGroup</code> to create an <code>OfflineStore</code>.</p> <p>To encrypt an <code>OfflineStore</code> using at rest data encryption, specify Amazon Web Services Key Management Service (KMS) key ID, or <code>KMSKeyId</code>, in <code>S3StorageConfig</code>.</p>', 'refs' => [ 'CreateFeatureGroupRequest$OfflineStoreConfig' => '<p>Use this to configure an <code>OfflineFeatureStore</code>. This parameter allows you to specify:</p> <ul> <li> <p>The Amazon Simple Storage Service (Amazon S3) location of an <code>OfflineStore</code>.</p> </li> <li> <p>A configuration for an Amazon Web Services Glue or Amazon Web Services Hive data catalog. </p> </li> <li> <p>An KMS encryption key to encrypt the Amazon S3 location used for <code>OfflineStore</code>. If KMS encryption key is not specified, by default we encrypt all data at rest using Amazon Web Services KMS key. By defining your <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-key.html">bucket-level key</a> for SSE, you can reduce Amazon Web Services KMS requests costs by up to 99 percent.</p> </li> </ul> <p>To learn more about this parameter, see <a>OfflineStoreConfig</a>.</p>', 'DescribeFeatureGroupResponse$OfflineStoreConfig' => '<p>The configuration of the <code>OfflineStore</code>, inducing the S3 location of the <code>OfflineStore</code>, Amazon Web Services Glue or Amazon Web Services Hive data catalogue configurations, and the security configuration.</p>', 'FeatureGroup$OfflineStoreConfig' => NULL, ], ], 'OfflineStoreStatus' => [ 'base' => '<p>The status of <code>OfflineStore</code>.</p>', 'refs' => [ 'DescribeFeatureGroupResponse$OfflineStoreStatus' => '<p>The status of the <code>OfflineStore</code>. Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code> </p>', 'FeatureGroup$OfflineStoreStatus' => NULL, 'FeatureGroupSummary$OfflineStoreStatus' => '<p>Notifies you if replicating data into the <code>OfflineStore</code> has failed. Returns either: <code>Active</code> or <code>Blocked</code>.</p>', ], ], 'OfflineStoreStatusValue' => [ 'base' => NULL, 'refs' => [ 'ListFeatureGroupsRequest$OfflineStoreStatusEquals' => '<p>An <code>OfflineStore</code> status. Filters by <code>OfflineStore</code> status. </p>', 'OfflineStoreStatus$Status' => '<p>An <code>OfflineStore</code> status.</p>', ], ], 'OidcConfig' => [ 'base' => '<p>Use this parameter to configure your OIDC Identity Provider (IdP).</p>', 'refs' => [ 'CreateWorkforceRequest$OidcConfig' => '<p>Use this parameter to configure a private workforce using your own OIDC Identity Provider.</p> <p>Do not use <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.</p>', 'UpdateWorkforceRequest$OidcConfig' => '<p>Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made using your own IdP.</p>', ], ], 'OidcConfigForResponse' => [ 'base' => '<p>Your OIDC IdP workforce configuration.</p>', 'refs' => [ 'Workforce$OidcConfig' => '<p>The configuration of an OIDC Identity Provider (IdP) private workforce.</p>', ], ], 'OidcEndpoint' => [ 'base' => NULL, 'refs' => [ 'OidcConfig$Issuer' => '<p>The OIDC IdP issuer used to configure your private workforce.</p>', 'OidcConfig$AuthorizationEndpoint' => '<p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>', 'OidcConfig$TokenEndpoint' => '<p>The OIDC IdP token endpoint used to configure your private workforce.</p>', 'OidcConfig$UserInfoEndpoint' => '<p>The OIDC IdP user information endpoint used to configure your private workforce.</p>', 'OidcConfig$LogoutEndpoint' => '<p>The OIDC IdP logout endpoint used to configure your private workforce.</p>', 'OidcConfig$JwksUri' => '<p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>', 'OidcConfigForResponse$Issuer' => '<p>The OIDC IdP issuer used to configure your private workforce.</p>', 'OidcConfigForResponse$AuthorizationEndpoint' => '<p>The OIDC IdP authorization endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$TokenEndpoint' => '<p>The OIDC IdP token endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$UserInfoEndpoint' => '<p>The OIDC IdP user information endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$LogoutEndpoint' => '<p>The OIDC IdP logout endpoint used to configure your private workforce.</p>', 'OidcConfigForResponse$JwksUri' => '<p>The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.</p>', ], ], 'OidcMemberDefinition' => [ 'base' => '<p>A list of user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more private work teams. If you add a user group to a private work team, all workers in that user group are added to the work team.</p>', 'refs' => [ 'MemberDefinition$OidcMemberDefinition' => '<p>A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user group to one or more private work teams. If you add a user group to a private work team, all workers in that user group are added to the work team.</p>', ], ], 'OnlineStoreConfig' => [ 'base' => '<p>Use this to specify the Amazon Web Services Key Management Service (KMS) Key ID, or <code>KMSKeyId</code>, for at rest data encryption. You can turn <code>OnlineStore</code> on or off by specifying the <code>EnableOnlineStore</code> flag at General Assembly; the default value is <code>False</code>.</p>', 'refs' => [ 'CreateFeatureGroupRequest$OnlineStoreConfig' => '<p>You can turn the <code>OnlineStore</code> on or off by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag in <code>OnlineStoreConfig</code>; the default value is <code>False</code>.</p> <p>You can also include an Amazon Web Services KMS key ID (<code>KMSKeyId</code>) for at-rest encryption of the <code>OnlineStore</code>.</p>', 'DescribeFeatureGroupResponse$OnlineStoreConfig' => '<p>The configuration for the <code>OnlineStore</code>.</p>', 'FeatureGroup$OnlineStoreConfig' => NULL, ], ], 'OnlineStoreSecurityConfig' => [ 'base' => '<p>The security configuration for <code>OnlineStore</code>.</p>', 'refs' => [ 'OnlineStoreConfig$SecurityConfig' => '<p>Use to specify KMS Key ID (<code>KMSKeyId</code>) for at-rest encryption of your <code>OnlineStore</code>.</p>', ], ], 'Operator' => [ 'base' => NULL, 'refs' => [ 'Filter$Operator' => '<p>A Boolean binary operator that is used to evaluate the filter. The operator field contains one of the following values:</p> <dl> <dt>Equals</dt> <dd> <p>The value of <code>Name</code> equals <code>Value</code>.</p> </dd> <dt>NotEquals</dt> <dd> <p>The value of <code>Name</code> doesn\'t equal <code>Value</code>.</p> </dd> <dt>Exists</dt> <dd> <p>The <code>Name</code> property exists.</p> </dd> <dt>NotExists</dt> <dd> <p>The <code>Name</code> property does not exist.</p> </dd> <dt>GreaterThan</dt> <dd> <p>The value of <code>Name</code> is greater than <code>Value</code>. Not supported for text properties.</p> </dd> <dt>GreaterThanOrEqualTo</dt> <dd> <p>The value of <code>Name</code> is greater than or equal to <code>Value</code>. Not supported for text properties.</p> </dd> <dt>LessThan</dt> <dd> <p>The value of <code>Name</code> is less than <code>Value</code>. Not supported for text properties.</p> </dd> <dt>LessThanOrEqualTo</dt> <dd> <p>The value of <code>Name</code> is less than or equal to <code>Value</code>. Not supported for text properties.</p> </dd> <dt>In</dt> <dd> <p>The value of <code>Name</code> is one of the comma delimited strings in <code>Value</code>. Only supported for text properties.</p> </dd> <dt>Contains</dt> <dd> <p>The value of <code>Name</code> contains the string <code>Value</code>. Only supported for text properties.</p> <p>A <code>SearchExpression</code> can include the <code>Contains</code> operator multiple times when the value of <code>Name</code> is one of the following:</p> <ul> <li> <p> <code>Experiment.DisplayName</code> </p> </li> <li> <p> <code>Experiment.ExperimentName</code> </p> </li> <li> <p> <code>Experiment.Tags</code> </p> </li> <li> <p> <code>Trial.DisplayName</code> </p> </li> <li> <p> <code>Trial.TrialName</code> </p> </li> <li> <p> <code>Trial.Tags</code> </p> </li> <li> <p> <code>TrialComponent.DisplayName</code> </p> </li> <li> <p> <code>TrialComponent.TrialComponentName</code> </p> </li> <li> <p> <code>TrialComponent.Tags</code> </p> </li> <li> <p> <code>TrialComponent.InputArtifacts</code> </p> </li> <li> <p> <code>TrialComponent.OutputArtifacts</code> </p> </li> </ul> <p>A <code>SearchExpression</code> can include only one <code>Contains</code> operator for all other values of <code>Name</code>. In these cases, if you include multiple <code>Contains</code> operators in the <code>SearchExpression</code>, the result is the following error message: "<code>\'CONTAINS\' operator usage limit of 1 exceeded.</code>"</p> </dd> </dl>', ], ], 'OptionalDouble' => [ 'base' => NULL, 'refs' => [ 'TrialComponentMetricSummary$Max' => '<p>The maximum value of the metric.</p>', 'TrialComponentMetricSummary$Min' => '<p>The minimum value of the metric.</p>', 'TrialComponentMetricSummary$Last' => '<p>The most recent value of the metric.</p>', 'TrialComponentMetricSummary$Avg' => '<p>The average value of the metric.</p>', 'TrialComponentMetricSummary$StdDev' => '<p>The standard deviation of the metric.</p>', ], ], 'OptionalInteger' => [ 'base' => NULL, 'refs' => [ 'TrialComponentMetricSummary$Count' => '<p>The number of samples used to generate the metric.</p>', ], ], 'OptionalVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume attached to the processing instance.</p>', 'ProfilerRuleConfiguration$VolumeSizeInGB' => '<p>The size, in GB, of the ML storage volume attached to the processing instance.</p>', ], ], 'OrderKey' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListEndpointsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListModelsInput$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', ], ], 'OutputConfig' => [ 'base' => '<p>Contains information about the output location for the compiled model and the target device that the model runs on. <code>TargetDevice</code> and <code>TargetPlatform</code> are mutually exclusive, so you need to choose one between the two to specify your target device or platform. If you cannot find your device you want to use from the <code>TargetDevice</code> list, use <code>TargetPlatform</code> to describe the platform of your edge device and <code>CompilerOptions</code> if there are specific settings that are required or recommended to use for particular TargetPlatform.</p>', 'refs' => [ 'CreateCompilationJobRequest$OutputConfig' => '<p>Provides information about the output location for the compiled model and the target device the model runs on.</p>', 'DescribeCompilationJobResponse$OutputConfig' => '<p>Information about the output location for the compiled model and the target device that the model runs on.</p>', ], ], 'OutputDataConfig' => [ 'base' => '<p>Provides information about how to store model training results (model artifacts).</p>', 'refs' => [ 'CreateTrainingJobRequest$OutputDataConfig' => '<p>Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker creates subfolders for the artifacts. </p>', 'DescribeTrainingJobResponse$OutputDataConfig' => '<p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts. </p>', 'HyperParameterTrainingJobDefinition$OutputDataConfig' => '<p>Specifies the path to the Amazon S3 bucket where you store model artifacts from the training jobs that the tuning job launches.</p>', 'TrainingJob$OutputDataConfig' => '<p>The S3 path where model artifacts that you configured when creating the job are stored. Amazon SageMaker creates subfolders for model artifacts.</p>', 'TrainingJobDefinition$OutputDataConfig' => '<p>the path to the S3 bucket where you want to store model artifacts. Amazon SageMaker creates subfolders for the artifacts.</p>', ], ], 'OutputParameter' => [ 'base' => '<p>An output parameter of a pipeline step.</p>', 'refs' => [ 'OutputParameterList$member' => NULL, ], ], 'OutputParameterList' => [ 'base' => NULL, 'refs' => [ 'CallbackStepMetadata$OutputParameters' => '<p>A list of the output parameters of the callback step.</p>', 'LambdaStepMetadata$OutputParameters' => '<p>A list of the output parameters of the Lambda step.</p>', 'SendPipelineExecutionStepSuccessRequest$OutputParameters' => '<p>A list of the output parameters of the callback step.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListEndpointConfigsInput$NextToken' => '<p>If the result of the previous <code>ListEndpointConfig</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of endpoint configurations, use the token in the next request. </p>', 'ListEndpointConfigsOutput$NextToken' => '<p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of endpoint configurations, use it in the subsequent request </p>', 'ListEndpointsInput$NextToken' => '<p>If the result of a <code>ListEndpoints</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of endpoints, use the token in the next request.</p>', 'ListEndpointsOutput$NextToken' => '<p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of training jobs, use it in the subsequent request. </p>', 'ListModelsInput$NextToken' => '<p>If the response to a previous <code>ListModels</code> request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of models, use the token in the next request.</p>', 'ListModelsOutput$NextToken' => '<p> If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of models, use it in the subsequent request. </p>', ], ], 'ParallelismConfiguration' => [ 'base' => '<p>Configuration that controls the parallelism of the pipeline. By default, the parallelism configuration specified applies to all executions of the pipeline unless overridden.</p>', 'refs' => [ 'CreatePipelineRequest$ParallelismConfiguration' => '<p>This is the configuration that controls the parallelism of the pipeline. If specified, it applies to all runs of this pipeline by default.</p>', 'DescribePipelineExecutionResponse$ParallelismConfiguration' => '<p>The parallelism configuration applied to the pipeline.</p>', 'DescribePipelineResponse$ParallelismConfiguration' => '<p>Lists the parallelism configuration applied to the pipeline.</p>', 'Pipeline$ParallelismConfiguration' => '<p>The parallelism configuration applied to the pipeline.</p>', 'PipelineExecution$ParallelismConfiguration' => '<p>The parallelism configuration applied to the pipeline execution.</p>', 'RetryPipelineExecutionRequest$ParallelismConfiguration' => '<p>This configuration, if specified, overrides the parallelism configuration of the parent pipeline.</p>', 'StartPipelineExecutionRequest$ParallelismConfiguration' => '<p>This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this specific run.</p>', 'UpdatePipelineExecutionRequest$ParallelismConfiguration' => '<p>This configuration, if specified, overrides the parallelism configuration of the parent pipeline for this specific run.</p>', 'UpdatePipelineRequest$ParallelismConfiguration' => '<p>If specified, it applies to all executions of this pipeline by default.</p>', ], ], 'Parameter' => [ 'base' => '<p>Assigns a value to a named Pipeline parameter.</p>', 'refs' => [ 'ParameterList$member' => NULL, ], ], 'ParameterKey' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameterRange$Name' => '<p>The name of the categorical hyperparameter to tune.</p>', 'ContinuousParameterRange$Name' => '<p>The name of the continuous hyperparameter to tune.</p>', 'IntegerParameterRange$Name' => '<p>The name of the hyperparameter to search.</p>', ], ], 'ParameterList' => [ 'base' => NULL, 'refs' => [ 'ListPipelineParametersForExecutionResponse$PipelineParameters' => '<p>Contains a list of pipeline parameters. This list can be empty. </p>', 'PipelineExecution$PipelineParameters' => '<p>Contains a list of pipeline parameters. This list can be empty. </p>', 'StartPipelineExecutionRequest$PipelineParameters' => '<p>Contains a list of pipeline parameters. This list can be empty. </p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'HyperParameterSpecification$Name' => '<p>The name of this hyperparameter. The name must be unique.</p>', ], ], 'ParameterRange' => [ 'base' => '<p>Defines the possible values for categorical, continuous, and integer hyperparameters to be used by an algorithm.</p>', 'refs' => [ 'HyperParameterSpecification$Range' => '<p>The allowed range for this hyperparameter.</p>', ], ], 'ParameterRanges' => [ 'base' => '<p>Specifies ranges of integer, continuous, and categorical hyperparameters that a hyperparameter tuning job searches. The hyperparameter tuning job launches training jobs with hyperparameter values within these ranges to find the combination of values that result in the training job with the best performance as measured by the objective metric of the hyperparameter tuning job.</p> <note> <p>You can specify a maximum of 20 hyperparameters that a hyperparameter tuning job can search over. Every possible value of a categorical parameter range counts against this limit.</p> </note>', 'refs' => [ 'HyperParameterTrainingJobDefinition$HyperParameterRanges' => NULL, 'HyperParameterTuningJobConfig$ParameterRanges' => '<p>The <a>ParameterRanges</a> object that specifies the ranges of hyperparameters that this tuning job searches.</p>', ], ], 'ParameterType' => [ 'base' => NULL, 'refs' => [ 'HyperParameterSpecification$Type' => '<p>The type of this hyperparameter. The valid types are <code>Integer</code>, <code>Continuous</code>, <code>Categorical</code>, and <code>FreeText</code>.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ContinuousParameterRange$MinValue' => '<p>The minimum value for the hyperparameter. The tuning job uses floating-point values between this value and <code>MaxValue</code>for tuning.</p>', 'ContinuousParameterRange$MaxValue' => '<p>The maximum value for the hyperparameter. The tuning job uses floating-point values between <code>MinValue</code> value and this value for tuning.</p>', 'ContinuousParameterRangeSpecification$MinValue' => '<p>The minimum floating-point value allowed.</p>', 'ContinuousParameterRangeSpecification$MaxValue' => '<p>The maximum floating-point value allowed.</p>', 'IntegerParameterRange$MinValue' => '<p>The minimum value of the hyperparameter to search.</p>', 'IntegerParameterRange$MaxValue' => '<p>The maximum value of the hyperparameter to search.</p>', 'IntegerParameterRangeSpecification$MinValue' => '<p>The minimum integer value allowed.</p>', 'IntegerParameterRangeSpecification$MaxValue' => '<p>The maximum integer value allowed.</p>', 'ParameterValues$member' => NULL, ], ], 'ParameterValues' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameterRange$Values' => '<p>A list of the categories for the hyperparameter.</p>', 'CategoricalParameterRangeSpecification$Values' => '<p>The allowed categories for the hyperparameter.</p>', ], ], 'Parent' => [ 'base' => '<p>The trial that a trial component is associated with and the experiment the trial is part of. A component might not be associated with a trial. A component can be associated with multiple trials.</p>', 'refs' => [ 'Parents$member' => NULL, ], ], 'ParentHyperParameterTuningJob' => [ 'base' => '<p>A previously completed or stopped hyperparameter tuning job to be used as a starting point for a new hyperparameter tuning job.</p>', 'refs' => [ 'ParentHyperParameterTuningJobs$member' => NULL, ], ], 'ParentHyperParameterTuningJobs' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningJobWarmStartConfig$ParentHyperParameterTuningJobs' => '<p>An array of hyperparameter tuning jobs that are used as the starting point for the new hyperparameter tuning job. For more information about warm starting a hyperparameter tuning job, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-warm-start.html">Using a Previous Hyperparameter Tuning Job as a Starting Point</a>.</p> <p>Hyperparameter tuning jobs created before October 1, 2018 cannot be used as parent jobs for warm start tuning jobs.</p>', ], ], 'Parents' => [ 'base' => NULL, 'refs' => [ 'TrialComponent$Parents' => '<p>An array of the parents of the component. A parent is a trial the component is associated with and the experiment the trial is part of. A component might not have any parents.</p>', ], ], 'PendingDeploymentSummary' => [ 'base' => '<p>The summary of an in-progress deployment when an endpoint is creating or updating with a new endpoint configuration.</p>', 'refs' => [ 'DescribeEndpointOutput$PendingDeploymentSummary' => '<p>Returns the summary of an in-progress deployment. This field is only returned when the endpoint is creating or updating with a new endpoint configuration.</p>', ], ], 'PendingProductionVariantSummary' => [ 'base' => '<p>The production variant summary for a deployment when an endpoint is creating or updating with the <code> <a>CreateEndpoint</a> </code> or <code> <a>UpdateEndpoint</a> </code> operations. Describes the <code>VariantStatus </code>, weight and capacity for a production variant associated with an endpoint. </p>', 'refs' => [ 'PendingProductionVariantSummaryList$member' => NULL, ], ], 'PendingProductionVariantSummaryList' => [ 'base' => NULL, 'refs' => [ 'PendingDeploymentSummary$ProductionVariants' => '<p>List of <code>PendingProductionVariantSummary</code> objects.</p>', ], ], 'Phase' => [ 'base' => '<p>Defines the traffic pattern.</p>', 'refs' => [ 'Phases$member' => NULL, ], ], 'Phases' => [ 'base' => NULL, 'refs' => [ 'TrafficPattern$Phases' => '<p>Defines the phases traffic specification.</p>', ], ], 'Pipeline' => [ 'base' => '<p>A SageMaker Model Building Pipeline instance.</p>', 'refs' => [ 'SearchRecord$Pipeline' => NULL, ], ], 'PipelineArn' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the created pipeline.</p>', 'DeletePipelineResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline to delete.</p>', 'DescribePipelineExecutionResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline.</p>', 'DescribePipelineResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline.</p>', 'Pipeline$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline.</p>', 'PipelineExecution$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the pipeline that was executed.</p>', 'PipelineSummary$PipelineArn' => '<p> The Amazon Resource Name (ARN) of the pipeline.</p>', 'UpdatePipelineResponse$PipelineArn' => '<p>The Amazon Resource Name (ARN) of the updated pipeline.</p>', ], ], 'PipelineDefinition' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineRequest$PipelineDefinition' => '<p>The JSON pipeline definition of the pipeline.</p>', 'DescribePipelineDefinitionForExecutionResponse$PipelineDefinition' => '<p>The JSON pipeline definition.</p>', 'DescribePipelineResponse$PipelineDefinition' => '<p>The JSON pipeline definition.</p>', 'UpdatePipelineRequest$PipelineDefinition' => '<p>The JSON pipeline definition.</p>', ], ], 'PipelineDefinitionS3Location' => [ 'base' => '<p>The location of the pipeline definition stored in Amazon S3.</p>', 'refs' => [ 'CreatePipelineRequest$PipelineDefinitionS3Location' => '<p>The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location.</p>', 'UpdatePipelineRequest$PipelineDefinitionS3Location' => '<p>The location of the pipeline definition stored in Amazon S3. If specified, SageMaker will retrieve the pipeline definition from this location.</p>', ], ], 'PipelineDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineRequest$PipelineDescription' => '<p>A description of the pipeline.</p>', 'DescribePipelineResponse$PipelineDescription' => '<p>The description of the pipeline.</p>', 'Pipeline$PipelineDescription' => '<p>The description of the pipeline.</p>', 'PipelineSummary$PipelineDescription' => '<p>The description of the pipeline.</p>', 'UpdatePipelineRequest$PipelineDescription' => '<p>The description of the pipeline.</p>', ], ], 'PipelineExecution' => [ 'base' => '<p>An execution of a pipeline.</p>', 'refs' => [ 'SearchRecord$PipelineExecution' => NULL, ], ], 'PipelineExecutionArn' => [ 'base' => NULL, 'refs' => [ 'CacheHitResult$SourcePipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'DescribePipelineDefinitionForExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'DescribePipelineExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'DescribePipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'ListPipelineExecutionStepsRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'ListPipelineParametersForExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'PipelineExecution$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'PipelineExecutionSummary$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'RetryPipelineExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'RetryPipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'SendPipelineExecutionStepFailureResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'SendPipelineExecutionStepSuccessResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'StartPipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'StopPipelineExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'StopPipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'UpdatePipelineExecutionRequest$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the pipeline execution.</p>', 'UpdatePipelineExecutionResponse$PipelineExecutionArn' => '<p>The Amazon Resource Name (ARN) of the updated pipeline execution.</p>', ], ], 'PipelineExecutionDescription' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineExecutionResponse$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', 'PipelineExecution$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', 'PipelineExecutionSummary$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', 'StartPipelineExecutionRequest$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', 'UpdatePipelineExecutionRequest$PipelineExecutionDescription' => '<p>The description of the pipeline execution.</p>', ], ], 'PipelineExecutionFailureReason' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineExecutionResponse$FailureReason' => '<p>If the execution failed, a message describing why.</p>', 'PipelineExecution$FailureReason' => '<p>If the execution failed, a message describing why.</p>', ], ], 'PipelineExecutionName' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineExecutionResponse$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', 'PipelineExecution$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', 'PipelineExecutionSummary$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', 'StartPipelineExecutionRequest$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', 'UpdatePipelineExecutionRequest$PipelineExecutionDisplayName' => '<p>The display name of the pipeline execution.</p>', ], ], 'PipelineExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineExecutionResponse$PipelineExecutionStatus' => '<p>The status of the pipeline execution.</p>', 'PipelineExecution$PipelineExecutionStatus' => '<p>The status of the pipeline status.</p>', 'PipelineExecutionSummary$PipelineExecutionStatus' => '<p>The status of the pipeline execution.</p>', ], ], 'PipelineExecutionStep' => [ 'base' => '<p>An execution of a step in a pipeline.</p>', 'refs' => [ 'PipelineExecutionStepList$member' => NULL, ], ], 'PipelineExecutionStepList' => [ 'base' => NULL, 'refs' => [ 'ListPipelineExecutionStepsResponse$PipelineExecutionSteps' => '<p>A list of <code>PipeLineExecutionStep</code> objects. Each <code>PipeLineExecutionStep</code> consists of StepName, StartTime, EndTime, StepStatus, and Metadata. Metadata is an object with properties for each job that contains relevant information about the job created by the step.</p>', ], ], 'PipelineExecutionStepMetadata' => [ 'base' => '<p>Metadata for a step execution.</p>', 'refs' => [ 'PipelineExecutionStep$Metadata' => '<p>Metadata for the step execution.</p>', ], ], 'PipelineExecutionSummary' => [ 'base' => '<p>A pipeline execution summary.</p>', 'refs' => [ 'PipelineExecutionSummaryList$member' => NULL, ], ], 'PipelineExecutionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPipelineExecutionsResponse$PipelineExecutionSummaries' => '<p>Contains a sorted list of pipeline execution summary objects matching the specified filters. Each run summary includes the Amazon Resource Name (ARN) of the pipeline execution, the run date, and the status. This list can be empty. </p>', ], ], 'PipelineExperimentConfig' => [ 'base' => '<p>Specifies the names of the experiment and trial created by a pipeline.</p>', 'refs' => [ 'DescribePipelineExecutionResponse$PipelineExperimentConfig' => NULL, 'PipelineExecution$PipelineExperimentConfig' => NULL, ], ], 'PipelineName' => [ 'base' => NULL, 'refs' => [ 'CreatePipelineRequest$PipelineName' => '<p>The name of the pipeline.</p>', 'CreatePipelineRequest$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', 'DeletePipelineRequest$PipelineName' => '<p>The name of the pipeline to delete.</p>', 'DescribePipelineRequest$PipelineName' => '<p>The name of the pipeline to describe.</p>', 'DescribePipelineResponse$PipelineName' => '<p>The name of the pipeline.</p>', 'DescribePipelineResponse$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', 'ListPipelineExecutionsRequest$PipelineName' => '<p>The name of the pipeline.</p>', 'ListPipelinesRequest$PipelineNamePrefix' => '<p>The prefix of the pipeline name.</p>', 'Pipeline$PipelineName' => '<p>The name of the pipeline.</p>', 'Pipeline$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', 'PipelineSummary$PipelineName' => '<p>The name of the pipeline.</p>', 'PipelineSummary$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', 'StartPipelineExecutionRequest$PipelineName' => '<p>The name of the pipeline.</p>', 'UpdatePipelineRequest$PipelineName' => '<p>The name of the pipeline to update.</p>', 'UpdatePipelineRequest$PipelineDisplayName' => '<p>The display name of the pipeline.</p>', ], ], 'PipelineParameterName' => [ 'base' => NULL, 'refs' => [ 'Parameter$Name' => '<p>The name of the parameter to assign a value to. This parameter name must match a named parameter in the pipeline definition.</p>', ], ], 'PipelineStatus' => [ 'base' => NULL, 'refs' => [ 'DescribePipelineResponse$PipelineStatus' => '<p>The status of the pipeline execution.</p>', 'Pipeline$PipelineStatus' => '<p>The status of the pipeline.</p>', ], ], 'PipelineSummary' => [ 'base' => '<p>A summary of a pipeline.</p>', 'refs' => [ 'PipelineSummaryList$member' => NULL, ], ], 'PipelineSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPipelinesResponse$PipelineSummaries' => '<p>Contains a sorted list of <code>PipelineSummary</code> objects matching the specified filters. Each <code>PipelineSummary</code> consists of PipelineArn, PipelineName, ExperimentName, PipelineDescription, CreationTime, LastModifiedTime, LastRunTime, and RoleArn. This list can be empty. </p>', ], ], 'PlatformIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$PlatformIdentifier' => '<p>The platform identifier of the notebook instance runtime environment.</p>', 'DescribeNotebookInstanceOutput$PlatformIdentifier' => '<p>The platform identifier of the notebook instance runtime environment.</p>', ], ], 'PolicyString' => [ 'base' => NULL, 'refs' => [ 'GetModelPackageGroupPolicyOutput$ResourcePolicy' => '<p>The resource policy for the model group.</p>', 'PutModelPackageGroupPolicyInput$ResourcePolicy' => '<p>The resource policy for the model group.</p>', ], ], 'PresignedDomainUrl' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedDomainUrlResponse$AuthorizedUrl' => '<p>The presigned URL.</p>', ], ], 'ProbabilityThresholdAttribute' => [ 'base' => NULL, 'refs' => [ 'EndpointInput$ProbabilityThresholdAttribute' => '<p>The threshold for the class probability to be evaluated as a positive result.</p>', ], ], 'ProblemType' => [ 'base' => NULL, 'refs' => [ 'CreateAutoMLJobRequest$ProblemType' => '<p>Defines the type of supervised learning available for the candidates. Options include: <code>BinaryClassification</code>, <code>MulticlassClassification</code>, and <code>Regression</code>. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-problem-types.html"> Amazon SageMaker Autopilot problem types and algorithm support</a>.</p>', 'DescribeAutoMLJobResponse$ProblemType' => '<p>Returns the job\'s problem type.</p>', 'ResolvedAttributes$ProblemType' => '<p>The problem type.</p>', ], ], 'ProcessingClusterConfig' => [ 'base' => '<p>Configuration for the cluster used to run a processing job.</p>', 'refs' => [ 'ProcessingResources$ClusterConfig' => '<p>The configuration for the resources in a cluster used to run the processing job.</p>', ], ], 'ProcessingEnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'MonitoringEnvironmentMap$key' => NULL, 'ProcessingEnvironmentMap$key' => NULL, ], ], 'ProcessingEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobRequest$Environment' => '<p>The environment variables to set in the Docker container. Up to 100 key and values entries in the map are supported.</p>', 'DescribeProcessingJobResponse$Environment' => '<p>The environment variables set in the Docker container.</p>', 'ProcessingJob$Environment' => '<p>Sets the environment variables in the Docker container.</p>', ], ], 'ProcessingEnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'MonitoringEnvironmentMap$value' => NULL, 'ProcessingEnvironmentMap$value' => NULL, ], ], 'ProcessingFeatureStoreOutput' => [ 'base' => '<p>Configuration for processing job outputs in Amazon SageMaker Feature Store.</p>', 'refs' => [ 'ProcessingOutput$FeatureStoreOutput' => '<p>Configuration for processing job outputs in Amazon SageMaker Feature Store. This processing output type is only supported when <code>AppManaged</code> is specified. </p>', ], ], 'ProcessingInput' => [ 'base' => '<p>The inputs for a processing job. The processing input must specify exactly one of either <code>S3Input</code> or <code>DatasetDefinition</code> types.</p>', 'refs' => [ 'ProcessingInputs$member' => NULL, ], ], 'ProcessingInputs' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobRequest$ProcessingInputs' => '<p>An array of inputs configuring the data to download into the processing container.</p>', 'DescribeProcessingJobResponse$ProcessingInputs' => '<p>The inputs for a processing job.</p>', 'ProcessingJob$ProcessingInputs' => '<p>List of input configurations for the processing job.</p>', ], ], 'ProcessingInstanceCount' => [ 'base' => NULL, 'refs' => [ 'MonitoringClusterConfig$InstanceCount' => '<p>The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1. The default value is 1.</p>', 'ProcessingClusterConfig$InstanceCount' => '<p>The number of ML compute instances to use in the processing job. For distributed processing jobs, specify a value greater than 1. The default value is 1.</p>', ], ], 'ProcessingInstanceType' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$InstanceType' => '<p>The instance type to deploy a Debugger custom rule for debugging a training job.</p>', 'MonitoringClusterConfig$InstanceType' => '<p>The ML compute instance type for the processing job.</p>', 'ProcessingClusterConfig$InstanceType' => '<p>The ML compute instance type for the processing job.</p>', 'ProfilerRuleConfiguration$InstanceType' => '<p>The instance type to deploy a Debugger custom rule for profiling a training job.</p>', ], ], 'ProcessingJob' => [ 'base' => '<p>An Amazon SageMaker processing job that is used to analyze data and evaluate models. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html">Process Data and Evaluate Models</a>.</p>', 'refs' => [ 'TrialComponentSourceDetail$ProcessingJob' => '<p>Information about a processing job that\'s the source of a trial component.</p>', ], ], 'ProcessingJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobResponse$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the processing job.</p>', 'DebugRuleEvaluationStatus$RuleEvaluationJobArn' => '<p>The Amazon Resource Name (ARN) of the rule evaluation job.</p>', 'DescribeProcessingJobResponse$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the processing job.</p>', 'MonitoringExecutionSummary$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the monitoring job.</p>', 'ProcessingJob$ProcessingJobArn' => '<p>The ARN of the processing job.</p>', 'ProcessingJobStepMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the processing job.</p>', 'ProcessingJobSummary$ProcessingJobArn' => '<p>The Amazon Resource Name (ARN) of the processing job..</p>', 'ProfilerRuleEvaluationStatus$RuleEvaluationJobArn' => '<p>The Amazon Resource Name (ARN) of the rule evaluation job.</p>', ], ], 'ProcessingJobName' => [ 'base' => NULL, 'refs' => [ 'CreateProcessingJobRequest$ProcessingJobName' => '<p> The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DataQualityBaselineConfig$BaseliningJobName' => '<p>The name of the job that performs baselining for the data quality monitoring job.</p>', 'DescribeProcessingJobRequest$ProcessingJobName' => '<p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeProcessingJobResponse$ProcessingJobName' => '<p>The name of the processing job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'ModelBiasBaselineConfig$BaseliningJobName' => '<p>The name of the baseline model bias job.</p>', 'ModelExplainabilityBaselineConfig$BaseliningJobName' => '<p>The name of the baseline model explainability job.</p>', 'ModelQualityBaselineConfig$BaseliningJobName' => '<p>The name of the job that performs baselining for the monitoring job.</p>', 'MonitoringBaselineConfig$BaseliningJobName' => '<p>The name of the job that performs baselining for the monitoring job.</p>', 'ProcessingJob$ProcessingJobName' => '<p>The name of the processing job.</p>', 'ProcessingJobSummary$ProcessingJobName' => '<p>The name of the processing job.</p>', 'StopProcessingJobRequest$ProcessingJobName' => '<p>The name of the processing job to stop.</p>', ], ], 'ProcessingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeProcessingJobResponse$ProcessingJobStatus' => '<p>Provides the status of a processing job.</p>', 'ListProcessingJobsRequest$StatusEquals' => '<p>A filter that retrieves only processing jobs with a specific status.</p>', 'ProcessingJob$ProcessingJobStatus' => '<p>The status of the processing job.</p>', 'ProcessingJobSummary$ProcessingJobStatus' => '<p>The status of the processing job.</p>', ], ], 'ProcessingJobStepMetadata' => [ 'base' => '<p>Metadata for a processing job step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$ProcessingJob' => '<p>The Amazon Resource Name (ARN) of the processing job that was run by this step execution.</p>', ], ], 'ProcessingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProcessingJobsResponse$ProcessingJobSummaries' => '<p>An array of <code>ProcessingJobSummary</code> objects, each listing a processing job.</p>', ], ], 'ProcessingJobSummary' => [ 'base' => '<p>Summary of information about a processing job.</p>', 'refs' => [ 'ProcessingJobSummaries$member' => NULL, ], ], 'ProcessingLocalPath' => [ 'base' => NULL, 'refs' => [ 'DatasetDefinition$LocalPath' => '<p>The local path where you want Amazon SageMaker to download the Dataset Definition inputs to run a processing job. <code>LocalPath</code> is an absolute path to the input data. This is a required parameter when <code>AppManaged</code> is <code>False</code> (default).</p>', 'EndpointInput$LocalPath' => '<p>Path to the filesystem where the endpoint data is available to the container.</p>', 'MonitoringS3Output$LocalPath' => '<p>The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job. LocalPath is an absolute path for the output data.</p>', 'ProcessingS3Input$LocalPath' => '<p>The local path in your container where you want Amazon SageMaker to write input data to. <code>LocalPath</code> is an absolute path to the input data and must begin with <code>/opt/ml/processing/</code>. <code>LocalPath</code> is a required parameter when <code>AppManaged</code> is <code>False</code> (default).</p>', 'ProcessingS3Output$LocalPath' => '<p>The local path of a directory where you want Amazon SageMaker to upload its contents to Amazon S3. <code>LocalPath</code> is an absolute path to a directory containing output files. This directory will be created by the platform and exist when your container\'s entrypoint is invoked.</p>', ], ], 'ProcessingMaxRuntimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'ProcessingStoppingCondition$MaxRuntimeInSeconds' => '<p>Specifies the maximum runtime in seconds.</p>', ], ], 'ProcessingOutput' => [ 'base' => '<p>Describes the results of a processing job. The processing output must specify exactly one of either <code>S3Output</code> or <code>FeatureStoreOutput</code> types.</p>', 'refs' => [ 'ProcessingOutputs$member' => NULL, ], ], 'ProcessingOutputConfig' => [ 'base' => '<p>Configuration for uploading output from the processing container.</p>', 'refs' => [ 'CreateProcessingJobRequest$ProcessingOutputConfig' => '<p>Output configuration for the processing job.</p>', 'DescribeProcessingJobResponse$ProcessingOutputConfig' => '<p>Output configuration for the processing job.</p>', 'ProcessingJob$ProcessingOutputConfig' => NULL, ], ], 'ProcessingOutputs' => [ 'base' => NULL, 'refs' => [ 'ProcessingOutputConfig$Outputs' => '<p>An array of outputs configuring the data to upload from the processing container.</p>', ], ], 'ProcessingResources' => [ 'base' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>', 'refs' => [ 'CreateProcessingJobRequest$ProcessingResources' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>', 'DescribeProcessingJobResponse$ProcessingResources' => '<p>Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In distributed training, you specify more than one instance.</p>', 'ProcessingJob$ProcessingResources' => NULL, ], ], 'ProcessingS3CompressionType' => [ 'base' => NULL, 'refs' => [ 'ProcessingS3Input$S3CompressionType' => '<p>Whether to GZIP-decompress the data in Amazon S3 as it is streamed into the processing container. <code>Gzip</code> can only be used when <code>Pipe</code> mode is specified as the <code>S3InputMode</code>. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your container without using the EBS volume.</p>', ], ], 'ProcessingS3DataDistributionType' => [ 'base' => NULL, 'refs' => [ 'EndpointInput$S3DataDistributionType' => '<p>Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to <code>FullyReplicated</code> </p>', 'ProcessingS3Input$S3DataDistributionType' => '<p>Whether to distribute the data from Amazon S3 to all processing instances with <code>FullyReplicated</code>, or whether the data from Amazon S3 is shared by Amazon S3 key, downloading one shard of data to each processing instance.</p>', ], ], 'ProcessingS3DataType' => [ 'base' => NULL, 'refs' => [ 'ProcessingS3Input$S3DataType' => '<p>Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for the processing job.</p>', ], ], 'ProcessingS3Input' => [ 'base' => '<p>Configuration for downloading input data from Amazon S3 into the processing container.</p>', 'refs' => [ 'ProcessingInput$S3Input' => '<p>Configuration for downloading input data from Amazon S3 into the processing container.</p>', ], ], 'ProcessingS3InputMode' => [ 'base' => NULL, 'refs' => [ 'EndpointInput$S3InputMode' => '<p>Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job. <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code>.</p>', 'ProcessingS3Input$S3InputMode' => '<p>Whether to use <code>File</code> or <code>Pipe</code> input mode. In File mode, Amazon SageMaker copies the data from the input source onto the local ML storage volume before starting your processing container. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your processing container into named pipes without using the ML storage volume.</p>', ], ], 'ProcessingS3Output' => [ 'base' => '<p>Configuration for uploading output data to Amazon S3 from the processing container.</p>', 'refs' => [ 'ProcessingOutput$S3Output' => '<p>Configuration for processing job outputs in Amazon S3.</p>', ], ], 'ProcessingS3UploadMode' => [ 'base' => NULL, 'refs' => [ 'MonitoringS3Output$S3UploadMode' => '<p>Whether to upload the results of the monitoring job continuously or after the job completes.</p>', 'ProcessingS3Output$S3UploadMode' => '<p>Whether to upload the results of the processing job continuously or after the job completes.</p>', ], ], 'ProcessingStoppingCondition' => [ 'base' => '<p>Configures conditions under which the processing job should be stopped, such as how long the processing job has been running. After the condition is met, the processing job is stopped.</p>', 'refs' => [ 'CreateProcessingJobRequest$StoppingCondition' => '<p>The time limit for how long the processing job is allowed to run.</p>', 'DescribeProcessingJobResponse$StoppingCondition' => '<p>The time limit for how long the processing job is allowed to run.</p>', 'ProcessingJob$StoppingCondition' => NULL, ], ], 'ProcessingVolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'MonitoringClusterConfig$VolumeSizeInGB' => '<p>The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.</p>', 'ProcessingClusterConfig$VolumeSizeInGB' => '<p>The size of the ML storage volume in gigabytes that you want to provision. You must specify sufficient ML storage for your scenario.</p> <note> <p>Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type. When using these instances for processing, Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2 storage. You can\'t request a <code>VolumeSizeInGB</code> greater than the total size of the local instance storage.</p> <p>For a list of instance types that support local instance storage, including the total size per instance type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> </note>', ], ], 'ProductId' => [ 'base' => NULL, 'refs' => [ 'DescribeAlgorithmOutput$ProductId' => '<p>The product identifier of the algorithm.</p>', 'ModelPackageContainerDefinition$ProductId' => '<p>The Amazon Web Services Marketplace product ID of the model package.</p>', ], ], 'ProductListings' => [ 'base' => NULL, 'refs' => [ 'Workteam$ProductListingIds' => '<p>The Amazon Marketplace identifier for a vendor\'s work team.</p>', ], ], 'ProductionVariant' => [ 'base' => '<p>Identifies a model that you want to host and the resources chosen to deploy for hosting it. If you are deploying multiple models, tell Amazon SageMaker how to distribute traffic among the models by specifying variant weights. </p>', 'refs' => [ 'ProductionVariantList$member' => NULL, ], ], 'ProductionVariantAcceleratorType' => [ 'base' => NULL, 'refs' => [ 'PendingProductionVariantSummary$AcceleratorType' => '<p>The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', 'ProductionVariant$AcceleratorType' => '<p>The size of the Elastic Inference (EI) instance to use for the production variant. EI instances provide on-demand GPU computing for inference. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.</p>', ], ], 'ProductionVariantCoreDumpConfig' => [ 'base' => '<p>Specifies configuration for a core dump from the model container when the process crashes.</p>', 'refs' => [ 'ProductionVariant$CoreDumpConfig' => '<p>Specifies configuration for a core dump from the model container when the process crashes.</p>', ], ], 'ProductionVariantInstanceType' => [ 'base' => NULL, 'refs' => [ 'EndpointInputConfiguration$InstanceType' => '<p>The instance types to use for the load test.</p>', 'EndpointOutputConfiguration$InstanceType' => '<p>The instance type recommended by Amazon SageMaker Inference Recommender.</p>', 'PendingProductionVariantSummary$InstanceType' => '<p>The type of instances associated with the variant.</p>', 'ProductionVariant$InstanceType' => '<p>The ML compute instance type.</p>', 'RealtimeInferenceInstanceTypes$member' => NULL, ], ], 'ProductionVariantList' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointConfigInput$ProductionVariants' => '<p>An list of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>', 'DescribeEndpointConfigOutput$ProductionVariants' => '<p>An array of <code>ProductionVariant</code> objects, one for each model that you want to host at this endpoint.</p>', ], ], 'ProductionVariantServerlessConfig' => [ 'base' => '<important> <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p> </important> <p>Specifies the serverless configuration for an endpoint variant.</p>', 'refs' => [ 'PendingProductionVariantSummary$CurrentServerlessConfig' => '<p>The serverless configuration for the endpoint.</p> <note> <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p> </note>', 'PendingProductionVariantSummary$DesiredServerlessConfig' => '<p>The serverless configuration requested for this deployment, as specified in the endpoint configuration for the endpoint.</p> <note> <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p> </note>', 'ProductionVariant$ServerlessConfig' => '<p>The serverless configuration for an endpoint. Specifies a serverless endpoint configuration instead of an instance-based endpoint configuration.</p> <note> <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p> </note>', 'ProductionVariantSummary$CurrentServerlessConfig' => '<p>The serverless configuration for the endpoint.</p> <note> <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p> </note>', 'ProductionVariantSummary$DesiredServerlessConfig' => '<p>The serverless configuration requested for the endpoint update.</p> <note> <p>Serverless Inference is in preview release for Amazon SageMaker and is subject to change. We do not recommend using this feature in production environments.</p> </note>', ], ], 'ProductionVariantStatus' => [ 'base' => '<p>Describes the status of the production variant.</p>', 'refs' => [ 'ProductionVariantStatusList$member' => NULL, ], ], 'ProductionVariantStatusList' => [ 'base' => NULL, 'refs' => [ 'PendingProductionVariantSummary$VariantStatus' => '<p>The endpoint variant status which describes the current deployment stage status or operational status.</p>', 'ProductionVariantSummary$VariantStatus' => '<p>The endpoint variant status which describes the current deployment stage status or operational status.</p>', ], ], 'ProductionVariantSummary' => [ 'base' => '<p>Describes weight and capacities for a production variant associated with an endpoint. If you sent a request to the <code>UpdateEndpointWeightsAndCapacities</code> API and the endpoint status is <code>Updating</code>, you get different desired and current values. </p>', 'refs' => [ 'ProductionVariantSummaryList$member' => NULL, ], ], 'ProductionVariantSummaryList' => [ 'base' => NULL, 'refs' => [ 'DescribeEndpointOutput$ProductionVariants' => '<p> An array of <a>ProductionVariantSummary</a> objects, one for each model hosted behind this endpoint. </p>', 'Endpoint$ProductionVariants' => '<p>A list of the production variants hosted on the endpoint. Each production variant is a model.</p>', ], ], 'ProfilerConfig' => [ 'base' => '<p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>', 'refs' => [ 'CreateTrainingJobRequest$ProfilerConfig' => NULL, 'DescribeTrainingJobResponse$ProfilerConfig' => NULL, ], ], 'ProfilerConfigForUpdate' => [ 'base' => '<p>Configuration information for updating the Debugger profile parameters, system and framework metrics configurations, and storage paths.</p>', 'refs' => [ 'UpdateTrainingJobRequest$ProfilerConfig' => '<p>Configuration information for Debugger system monitoring, framework profiling, and storage paths.</p>', ], ], 'ProfilerRuleConfiguration' => [ 'base' => '<p>Configuration information for profiling rules.</p>', 'refs' => [ 'ProfilerRuleConfigurations$member' => NULL, ], ], 'ProfilerRuleConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$ProfilerRuleConfigurations' => '<p>Configuration information for Debugger rules for profiling system and framework metrics.</p>', 'DescribeTrainingJobResponse$ProfilerRuleConfigurations' => '<p>Configuration information for Debugger rules for profiling system and framework metrics.</p>', 'UpdateTrainingJobRequest$ProfilerRuleConfigurations' => '<p>Configuration information for Debugger rules for profiling system and framework metrics.</p>', ], ], 'ProfilerRuleEvaluationStatus' => [ 'base' => '<p>Information about the status of the rule evaluation.</p>', 'refs' => [ 'ProfilerRuleEvaluationStatuses$member' => NULL, ], ], 'ProfilerRuleEvaluationStatuses' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$ProfilerRuleEvaluationStatuses' => '<p>Evaluation status of Debugger rules for profiling on a training job.</p>', ], ], 'ProfilingIntervalInMilliseconds' => [ 'base' => NULL, 'refs' => [ 'ProfilerConfig$ProfilingIntervalInMilliseconds' => '<p>A time interval for capturing system metrics in milliseconds. Available values are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>', 'ProfilerConfigForUpdate$ProfilingIntervalInMilliseconds' => '<p>A time interval for capturing system metrics in milliseconds. Available values are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute) milliseconds. The default value is 500 milliseconds.</p>', ], ], 'ProfilingParameters' => [ 'base' => NULL, 'refs' => [ 'ProfilerConfig$ProfilingParameters' => '<p>Configuration information for capturing framework metrics. Available key strings for different profiling options are <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>. The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about how to configure the <code>ProfilingParameters</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>. </p>', 'ProfilerConfigForUpdate$ProfilingParameters' => '<p>Configuration information for capturing framework metrics. Available key strings for different profiling options are <code>DetailedProfilingConfig</code>, <code>PythonProfilingConfig</code>, and <code>DataLoaderProfilingConfig</code>. The following codes are configuration structures for the <code>ProfilingParameters</code> parameter. To learn more about how to configure the <code>ProfilingParameters</code> parameter, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html">Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job</a>. </p>', ], ], 'ProfilingStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$ProfilingStatus' => '<p>Profiling status of a training job.</p>', ], ], 'Project' => [ 'base' => '<p>The properties of a project as returned by the Search API.</p>', 'refs' => [ 'SearchRecord$Project' => '<p>The properties of a project.</p>', ], ], 'ProjectArn' => [ 'base' => NULL, 'refs' => [ 'CreateProjectOutput$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'DescribeProjectOutput$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'Project$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'ProjectSummary$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', 'UpdateProjectOutput$ProjectArn' => '<p>The Amazon Resource Name (ARN) of the project.</p>', ], ], 'ProjectEntityName' => [ 'base' => NULL, 'refs' => [ 'CreateProjectInput$ProjectName' => '<p>The name of the project.</p>', 'DeleteProjectInput$ProjectName' => '<p>The name of the project to delete.</p>', 'DescribeProjectInput$ProjectName' => '<p>The name of the project to describe.</p>', 'DescribeProjectOutput$ProjectName' => '<p>The name of the project.</p>', 'ListProjectsInput$NameContains' => '<p>A filter that returns the projects whose name contains a specified string.</p>', 'Project$ProjectName' => '<p>The name of the project.</p>', 'ProjectSummary$ProjectName' => '<p>The name of the project.</p>', 'UpdateProjectInput$ProjectName' => '<p>The name of the project.</p>', ], ], 'ProjectId' => [ 'base' => NULL, 'refs' => [ 'CreateProjectOutput$ProjectId' => '<p>The ID of the new project.</p>', 'DescribeProjectOutput$ProjectId' => '<p>The ID of the project.</p>', 'Project$ProjectId' => '<p>The ID of the project.</p>', 'ProjectSummary$ProjectId' => '<p>The ID of the project.</p>', ], ], 'ProjectSortBy' => [ 'base' => NULL, 'refs' => [ 'ListProjectsInput$SortBy' => '<p>The field by which to sort results. The default is <code>CreationTime</code>.</p>', ], ], 'ProjectSortOrder' => [ 'base' => NULL, 'refs' => [ 'ListProjectsInput$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', ], ], 'ProjectStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeProjectOutput$ProjectStatus' => '<p>The status of the project.</p>', 'Project$ProjectStatus' => '<p>The status of the project.</p>', 'ProjectSummary$ProjectStatus' => '<p>The status of the project.</p>', ], ], 'ProjectSummary' => [ 'base' => '<p>Information about a project.</p>', 'refs' => [ 'ProjectSummaryList$member' => NULL, ], ], 'ProjectSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListProjectsOutput$ProjectSummaryList' => '<p>A list of summaries of projects.</p>', ], ], 'PropertyNameHint' => [ 'base' => NULL, 'refs' => [ 'PropertyNameQuery$PropertyNameHint' => '<p>Text that begins a property\'s name.</p>', ], ], 'PropertyNameQuery' => [ 'base' => '<p>Part of the <code>SuggestionQuery</code> type. Specifies a hint for retrieving property names that begin with the specified text.</p>', 'refs' => [ 'SuggestionQuery$PropertyNameQuery' => '<p>Defines a property name hint. Only property names that begin with the specified hint are included in the response.</p>', ], ], 'PropertyNameSuggestion' => [ 'base' => '<p>A property name returned from a <code>GetSearchSuggestions</code> call that specifies a value in the <code>PropertyNameQuery</code> field.</p>', 'refs' => [ 'PropertyNameSuggestionList$member' => NULL, ], ], 'PropertyNameSuggestionList' => [ 'base' => NULL, 'refs' => [ 'GetSearchSuggestionsResponse$PropertyNameSuggestions' => '<p>A list of property names for a <code>Resource</code> that match a <code>SuggestionQuery</code>.</p>', ], ], 'ProvisionedProductStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ServiceCatalogProvisionedProductDetails$ProvisionedProductStatusMessage' => '<p>The current status of the product.</p> <ul> <li> <p> <code>AVAILABLE</code> - Stable state, ready to perform any operation. The most recent operation succeeded and completed.</p> </li> <li> <p> <code>UNDER_CHANGE</code> - Transitive state. Operations performed might not have valid results. Wait for an AVAILABLE status before performing operations.</p> </li> <li> <p> <code>TAINTED</code> - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.</p> </li> <li> <p> <code>ERROR</code> - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.</p> </li> <li> <p> <code>PLAN_IN_PROGRESS</code> - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an AVAILABLE status before performing operations.</p> </li> </ul>', ], ], 'ProvisioningParameter' => [ 'base' => '<p>A key value pair used when you provision a project as a service catalog product. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>', 'refs' => [ 'ProvisioningParameters$member' => NULL, ], ], 'ProvisioningParameterKey' => [ 'base' => NULL, 'refs' => [ 'ProvisioningParameter$Key' => '<p>The key that identifies a provisioning parameter.</p>', ], ], 'ProvisioningParameterValue' => [ 'base' => NULL, 'refs' => [ 'ProvisioningParameter$Value' => '<p>The value of the provisioning parameter.</p>', ], ], 'ProvisioningParameters' => [ 'base' => NULL, 'refs' => [ 'ServiceCatalogProvisioningDetails$ProvisioningParameters' => '<p>A list of key value pairs that you specify when you provision a product.</p>', 'ServiceCatalogProvisioningUpdateDetails$ProvisioningParameters' => '<p>A list of key value pairs that you specify when you provision a product.</p>', ], ], 'PublicWorkforceTaskPrice' => [ 'base' => '<p>Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed. </p> <p>Use one of the following prices for bounding box tasks. Prices are in US dollars and should be based on the complexity of the task; the longer it takes in your initial testing, the more you should offer.</p> <ul> <li> <p>0.036</p> </li> <li> <p>0.048</p> </li> <li> <p>0.060</p> </li> <li> <p>0.072</p> </li> <li> <p>0.120</p> </li> <li> <p>0.240</p> </li> <li> <p>0.360</p> </li> <li> <p>0.480</p> </li> <li> <p>0.600</p> </li> <li> <p>0.720</p> </li> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for image classification, text classification, and custom tasks. Prices are in US dollars.</p> <ul> <li> <p>0.012</p> </li> <li> <p>0.024</p> </li> <li> <p>0.036</p> </li> <li> <p>0.048</p> </li> <li> <p>0.060</p> </li> <li> <p>0.072</p> </li> <li> <p>0.120</p> </li> <li> <p>0.240</p> </li> <li> <p>0.360</p> </li> <li> <p>0.480</p> </li> <li> <p>0.600</p> </li> <li> <p>0.720</p> </li> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for semantic segmentation tasks. Prices are in US dollars.</p> <ul> <li> <p>0.840</p> </li> <li> <p>0.960</p> </li> <li> <p>1.080</p> </li> <li> <p>1.200</p> </li> </ul> <p>Use one of the following prices for Textract AnalyzeDocument Important Form Key Amazon Augmented AI review tasks. Prices are in US dollars.</p> <ul> <li> <p>2.400 </p> </li> <li> <p>2.280 </p> </li> <li> <p>2.160 </p> </li> <li> <p>2.040 </p> </li> <li> <p>1.920 </p> </li> <li> <p>1.800 </p> </li> <li> <p>1.680 </p> </li> <li> <p>1.560 </p> </li> <li> <p>1.440 </p> </li> <li> <p>1.320 </p> </li> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul> <p>Use one of the following prices for Rekognition DetectModerationLabels Amazon Augmented AI review tasks. Prices are in US dollars.</p> <ul> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul> <p>Use one of the following prices for Amazon Augmented AI custom human review tasks. Prices are in US dollars.</p> <ul> <li> <p>1.200 </p> </li> <li> <p>1.080 </p> </li> <li> <p>0.960 </p> </li> <li> <p>0.840 </p> </li> <li> <p>0.720 </p> </li> <li> <p>0.600 </p> </li> <li> <p>0.480 </p> </li> <li> <p>0.360 </p> </li> <li> <p>0.240 </p> </li> <li> <p>0.120 </p> </li> <li> <p>0.072 </p> </li> <li> <p>0.060 </p> </li> <li> <p>0.048 </p> </li> <li> <p>0.036 </p> </li> <li> <p>0.024 </p> </li> <li> <p>0.012 </p> </li> </ul>', 'refs' => [ 'HumanLoopConfig$PublicWorkforceTaskPrice' => NULL, 'HumanTaskConfig$PublicWorkforceTaskPrice' => '<p>The price that you pay for each task performed by an Amazon Mechanical Turk worker.</p>', ], ], 'PutModelPackageGroupPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutModelPackageGroupPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'QualityCheckStepMetadata' => [ 'base' => '<p>Container for the metadata for a Quality check step. For more information, see the topic on <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/build-and-manage-steps.html#step-type-quality-check">QualityCheck step</a> in the <i>Amazon SageMaker Developer Guide</i>. </p>', 'refs' => [ 'PipelineExecutionStepMetadata$QualityCheck' => '<p>The configurations and outcomes of the check step execution. This includes: </p> <ul> <li> <p>The type of the check conducted,</p> </li> <li> <p>The Amazon S3 URIs of baseline constraints and statistics files to be used for the drift check.</p> </li> <li> <p>The Amazon S3 URIs of newly calculated baseline constraints and statistics.</p> </li> <li> <p>The model package group name provided.</p> </li> <li> <p>The Amazon S3 URI of the violation report if violations detected.</p> </li> <li> <p>The Amazon Resource Name (ARN) of check processing job initiated by the step execution.</p> </li> <li> <p>The boolean flags indicating if the drift check is skipped.</p> </li> <li> <p>If step property <code>BaselineUsedForDriftCheck</code> is set the same as <code>CalculatedBaseline</code>.</p> </li> </ul>', ], ], 'QueryFilters' => [ 'base' => '<p>A set of filters to narrow the set of lineage entities connected to the <code>StartArn</code>(s) returned by the <code>QueryLineage</code> API action.</p>', 'refs' => [ 'QueryLineageRequest$Filters' => '<p>A set of filtering parameters that allow you to specify which entities should be returned.</p> <ul> <li> <p>Properties - Key-value pairs to match on the lineage entities\' properties.</p> </li> <li> <p>LineageTypes - A set of lineage entity types to match on. For example: <code>TrialComponent</code>, <code>Artifact</code>, or <code>Context</code>.</p> </li> <li> <p>CreatedBefore - Filter entities created before this date.</p> </li> <li> <p>ModifiedBefore - Filter entities modified before this date.</p> </li> <li> <p>ModifiedAfter - Filter entities modified after this date.</p> </li> </ul>', ], ], 'QueryLineageMaxDepth' => [ 'base' => NULL, 'refs' => [ 'QueryLineageRequest$MaxDepth' => '<p>The maximum depth in lineage relationships from the <code>StartArns</code> that will be traversed. Depth is a measure of the number of <code>Associations</code> from the <code>StartArn</code> entity to the matched results.</p>', ], ], 'QueryLineageMaxResults' => [ 'base' => NULL, 'refs' => [ 'QueryLineageRequest$MaxResults' => '<p>Limits the number of vertices in the results. Use the <code>NextToken</code> in a response to to retrieve the next page of results.</p>', ], ], 'QueryLineageRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueryLineageResponse' => [ 'base' => NULL, 'refs' => [], ], 'QueryLineageStartArns' => [ 'base' => NULL, 'refs' => [ 'QueryLineageRequest$StartArns' => '<p>A list of resource Amazon Resource Name (ARN) that represent the starting point for your lineage query.</p>', ], ], 'QueryLineageTypes' => [ 'base' => NULL, 'refs' => [ 'QueryFilters$LineageTypes' => '<p>Filter the lineage entities connected to the <code>StartArn</code>(s) by the type of the lineage entity.</p>', ], ], 'QueryProperties' => [ 'base' => NULL, 'refs' => [ 'QueryFilters$Properties' => '<p>Filter the lineage entities connected to the <code>StartArn</code>(s) by a set if property key value pairs. If multiple pairs are provided, an entity will be included in the results if it matches any of the provided pairs.</p>', ], ], 'QueryTypes' => [ 'base' => NULL, 'refs' => [ 'QueryFilters$Types' => '<p>Filter the lineage entities connected to the <code>StartArn</code> by type. For example: <code>DataSet</code>, <code>Model</code>, <code>Endpoint</code>, or <code>ModelDeployment</code>.</p>', ], ], 'RSessionAppSettings' => [ 'base' => '<p>A collection of settings that apply to an <code>RSessionGateway</code> app.</p>', 'refs' => [ 'UserSettings$RSessionAppSettings' => '<p>A collection of settings that configure the <code>RSessionGateway</code> app.</p>', ], ], 'RStudioServerProAccessStatus' => [ 'base' => NULL, 'refs' => [ 'RStudioServerProAppSettings$AccessStatus' => '<p>Indicates whether the current user has access to the <code>RStudioServerPro</code> app.</p>', ], ], 'RStudioServerProAppSettings' => [ 'base' => '<p>A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app. <code>RStudioServerProAppSettings</code> cannot be updated. The <code>RStudioServerPro</code> app must be deleted and a new one created to make any changes.</p>', 'refs' => [ 'UserSettings$RStudioServerProAppSettings' => '<p>A collection of settings that configure user interaction with the <code>RStudioServerPro</code> app.</p>', ], ], 'RStudioServerProDomainSettings' => [ 'base' => '<p>A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.</p>', 'refs' => [ 'DomainSettings$RStudioServerProDomainSettings' => '<p>A collection of settings that configure the <code>RStudioServerPro</code> Domain-level app.</p>', ], ], 'RStudioServerProDomainSettingsForUpdate' => [ 'base' => '<p>A collection of settings that update the current configuration for the <code>RStudioServerPro</code> Domain-level app.</p>', 'refs' => [ 'DomainSettingsForUpdate$RStudioServerProDomainSettingsForUpdate' => '<p>A collection of <code>RStudioServerPro</code> Domain-level app settings to update.</p>', ], ], 'RStudioServerProUserGroup' => [ 'base' => NULL, 'refs' => [ 'RStudioServerProAppSettings$UserGroup' => '<p>The level of permissions that the user has within the <code>RStudioServerPro</code> app. This value defaults to `User`. The `Admin` value allows the user access to the RStudio Administrative Dashboard.</p>', ], ], 'RealtimeInferenceInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$SupportedRealtimeInferenceInstanceTypes' => '<p>A list of the instance types that are used to generate inferences in real-time.</p>', 'InferenceSpecification$SupportedRealtimeInferenceInstanceTypes' => '<p>A list of the instance types that are used to generate inferences in real-time.</p> <p>This parameter is required for unversioned models, and optional for versioned models.</p>', ], ], 'RecommendationJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceRecommendationsJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the recommendation job.</p>', 'DescribeInferenceRecommendationsJobResponse$JobArn' => '<p>The Amazon Resource Name (ARN) of the job.</p>', 'InferenceRecommendationsJob$JobArn' => '<p>The Amazon Resource Name (ARN) of the recommendation job.</p>', ], ], 'RecommendationJobDescription' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceRecommendationsJobRequest$JobDescription' => '<p>Description of the recommendation job.</p>', 'DescribeInferenceRecommendationsJobResponse$JobDescription' => '<p>The job description that you provided when you initiated the job.</p>', 'InferenceRecommendationsJob$JobDescription' => '<p>The job description.</p>', ], ], 'RecommendationJobInputConfig' => [ 'base' => '<p>The input configuration of the recommendation job.</p>', 'refs' => [ 'CreateInferenceRecommendationsJobRequest$InputConfig' => '<p>Provides information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations.</p>', 'DescribeInferenceRecommendationsJobResponse$InputConfig' => '<p>Returns information about the versioned model package Amazon Resource Name (ARN), the traffic pattern, and endpoint configurations you provided when you initiated the job.</p>', ], ], 'RecommendationJobName' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceRecommendationsJobRequest$JobName' => '<p>A name for the recommendation job. The name must be unique within the Amazon Web Services Region and within your Amazon Web Services account.</p>', 'DescribeInferenceRecommendationsJobRequest$JobName' => '<p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'DescribeInferenceRecommendationsJobResponse$JobName' => '<p>The name of the job. The name must be unique within an Amazon Web Services Region in the Amazon Web Services account.</p>', 'InferenceRecommendationsJob$JobName' => '<p>The name of the job.</p>', 'StopInferenceRecommendationsJobRequest$JobName' => '<p>The name of the job you want to stop.</p>', ], ], 'RecommendationJobResourceLimit' => [ 'base' => '<p>Specifies the maximum number of jobs that can run in parallel and the maximum number of jobs that can run.</p>', 'refs' => [ 'RecommendationJobInputConfig$ResourceLimit' => '<p>Defines the resource limit of the job.</p>', ], ], 'RecommendationJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeInferenceRecommendationsJobResponse$Status' => '<p>The status of the job.</p>', 'InferenceRecommendationsJob$Status' => '<p>The status of the job.</p>', 'ListInferenceRecommendationsJobsRequest$StatusEquals' => '<p>A filter that retrieves only inference recommendations jobs with a specific status.</p>', ], ], 'RecommendationJobStoppingConditions' => [ 'base' => '<p>Specifies conditions for stopping a job. When a job reaches a stopping condition limit, SageMaker ends the job.</p>', 'refs' => [ 'CreateInferenceRecommendationsJobRequest$StoppingConditions' => '<p>A set of conditions for stopping a recommendation job. If any of the conditions are met, the job is automatically stopped.</p>', 'DescribeInferenceRecommendationsJobResponse$StoppingConditions' => '<p>The stopping conditions that you provided when you initiated the job.</p>', ], ], 'RecommendationJobType' => [ 'base' => NULL, 'refs' => [ 'CreateInferenceRecommendationsJobRequest$JobType' => '<p>Defines the type of recommendation job. Specify <code>Default</code> to initiate an instance recommendation and <code>Advanced</code> to initiate a load test. If left unspecified, Amazon SageMaker Inference Recommender will run an instance recommendation (<code>DEFAULT</code>) job.</p>', 'DescribeInferenceRecommendationsJobResponse$JobType' => '<p>The job type that you provided when you initiated the job.</p>', 'InferenceRecommendationsJob$JobType' => '<p>The recommendation job type.</p>', ], ], 'RecommendationMetrics' => [ 'base' => '<p>The metrics of recommendations.</p>', 'refs' => [ 'InferenceRecommendation$Metrics' => '<p>The metrics used to decide what recommendation to make.</p>', ], ], 'RecordWrapper' => [ 'base' => NULL, 'refs' => [ 'Channel$RecordWrapperType' => '<p/> <p>Specify RecordIO as the value when input data is in raw format but the training algorithm requires the RecordIO format. In this case, Amazon SageMaker wraps each individual S3 object in a RecordIO record. If the input data is already in RecordIO format, you don\'t need to set this attribute. For more information, see <a href="https://mxnet.apache.org/api/architecture/note_data_loading#data-format">Create a Dataset Using RecordIO</a>. </p> <p>In File mode, leave this field unset or set it to None.</p>', ], ], 'RedshiftClusterId' => [ 'base' => '<p>The Redshift cluster Identifier.</p>', 'refs' => [ 'RedshiftDatasetDefinition$ClusterId' => NULL, ], ], 'RedshiftDatabase' => [ 'base' => '<p>The name of the Redshift database used in Redshift query execution.</p>', 'refs' => [ 'RedshiftDatasetDefinition$Database' => NULL, ], ], 'RedshiftDatasetDefinition' => [ 'base' => '<p>Configuration for Redshift Dataset Definition input.</p>', 'refs' => [ 'DatasetDefinition$RedshiftDatasetDefinition' => NULL, ], ], 'RedshiftQueryString' => [ 'base' => '<p>The SQL query statements to be executed.</p>', 'refs' => [ 'RedshiftDatasetDefinition$QueryString' => NULL, ], ], 'RedshiftResultCompressionType' => [ 'base' => '<p>The compression used for Redshift query results.</p>', 'refs' => [ 'RedshiftDatasetDefinition$OutputCompression' => NULL, ], ], 'RedshiftResultFormat' => [ 'base' => '<p>The data storage format for Redshift query results.</p>', 'refs' => [ 'RedshiftDatasetDefinition$OutputFormat' => NULL, ], ], 'RedshiftUserName' => [ 'base' => '<p>The database user name used in Redshift query execution.</p>', 'refs' => [ 'RedshiftDatasetDefinition$DbUser' => NULL, ], ], 'RegisterDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'RegisterModelStepMetadata' => [ 'base' => '<p>Metadata for a register model job step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$RegisterModel' => '<p>The Amazon Resource Name (ARN) of the model package the model was registered to by this step execution.</p>', ], ], 'RenderUiTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'RenderUiTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'RenderableTask' => [ 'base' => '<p>Contains input values for a task.</p>', 'refs' => [ 'RenderUiTemplateRequest$Task' => '<p>A <code>RenderableTask</code> object containing a representative task to render.</p>', ], ], 'RenderingError' => [ 'base' => '<p>A description of an error that occurred while rendering the template.</p>', 'refs' => [ 'RenderingErrorList$member' => NULL, ], ], 'RenderingErrorList' => [ 'base' => NULL, 'refs' => [ 'RenderUiTemplateResponse$Errors' => '<p>A list of one or more <code>RenderingError</code> objects if any were encountered while rendering the template. If there were no errors, the list is empty.</p>', ], ], 'RepositoryAccessMode' => [ 'base' => NULL, 'refs' => [ 'ImageConfig$RepositoryAccessMode' => '<p>Set this to one of the following values:</p> <ul> <li> <p> <code>Platform</code> - The model image is hosted in Amazon ECR.</p> </li> <li> <p> <code>Vpc</code> - The model image is hosted in a private Docker registry in your VPC.</p> </li> </ul>', ], ], 'RepositoryAuthConfig' => [ 'base' => '<p>Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value for the <code>RepositoryAccessMode</code> field of the <code>ImageConfig</code> object that you passed to a call to <code>CreateModel</code> and the private Docker registry where the model image is hosted requires authentication.</p>', 'refs' => [ 'ImageConfig$RepositoryAuthConfig' => '<p>(Optional) Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified <code>Vpc</code> as the value for the <code>RepositoryAccessMode</code> field, and the private Docker registry where the model image is hosted requires authentication.</p>', ], ], 'RepositoryCredentialsProviderArn' => [ 'base' => NULL, 'refs' => [ 'RepositoryAuthConfig$RepositoryCredentialsProviderArn' => '<p>The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted. For information about how to create an Amazon Web Services Lambda function, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html">Create a Lambda function with the console</a> in the <i>Amazon Web Services Lambda Developer Guide</i>.</p>', ], ], 'ResolvedAttributes' => [ 'base' => '<p>The resolved attributes.</p>', 'refs' => [ 'DescribeAutoMLJobResponse$ResolvedAttributes' => '<p>This contains <code>ProblemType</code>, <code>AutoMLJobObjective</code>, and <code>CompletionCriteria</code>. If you do not provide these values, they are auto-inferred. If you do provide them, the values used are the ones you provide.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that you want to tag.</p>', 'DeleteTagsInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose tags you want to delete.</p>', 'ListTagsInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource whose tags you want to retrieve.</p>', ], ], 'ResourceConfig' => [ 'base' => '<p>Describes the resources, including ML compute instances and ML storage volumes, to use for model training. </p>', 'refs' => [ 'CreateTrainingJobRequest$ResourceConfig' => '<p>The resources, including the ML compute instances and ML storage volumes, to use for model training. </p> <p>ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML storage volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store the training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.</p>', 'DescribeTrainingJobResponse$ResourceConfig' => '<p>Resources, including ML compute instances and ML storage volumes, that are configured for model training. </p>', 'HyperParameterTrainingJobDefinition$ResourceConfig' => '<p>The resources, including the compute instances and storage volumes, to use for the training jobs that the tuning job launches.</p> <p>Storage volumes store model artifacts and incremental states. Training algorithms might also use storage volumes for scratch space. If you want Amazon SageMaker to use the storage volume to store the training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed training algorithms, specify an instance count greater than 1.</p>', 'TrainingJob$ResourceConfig' => '<p>Resources, including ML compute instances and ML storage volumes, that are configured for model training.</p>', 'TrainingJobDefinition$ResourceConfig' => '<p>The resources, including the ML compute instances and ML storage volumes, to use for model training.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainResponse$HomeEfsFileSystemId' => '<p>The ID of the Amazon Elastic File System (EFS) managed by this Domain.</p>', ], ], 'ResourceInUse' => [ 'base' => '<p>Resource being accessed is in use.</p>', 'refs' => [], ], 'ResourceLimitExceeded' => [ 'base' => '<p> You have exceeded an Amazon SageMaker resource limit. For example, you might have too many training jobs created. </p>', 'refs' => [], ], 'ResourceLimits' => [ 'base' => '<p>Specifies the maximum number of training jobs and parallel training jobs that a hyperparameter tuning job can launch.</p>', 'refs' => [ 'HyperParameterTuningJobConfig$ResourceLimits' => '<p>The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training jobs for this tuning job.</p>', 'HyperParameterTuningJobSummary$ResourceLimits' => '<p>The <a>ResourceLimits</a> object that specifies the maximum number of training jobs and parallel training jobs allowed for this tuning job.</p>', ], ], 'ResourceNotFound' => [ 'base' => '<p>Resource being access is not found.</p>', 'refs' => [], ], 'ResourcePolicyString' => [ 'base' => NULL, 'refs' => [ 'GetLineageGroupPolicyResponse$ResourcePolicy' => '<p>The resource policy that gives access to the lineage group in another account.</p>', ], ], 'ResourcePropertyName' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p>A resource property name. For example, <code>TrainingJobName</code>. For valid property names, see <a>SearchRecord</a>. You must specify a valid property for the resource.</p>', 'NestedFilters$NestedPropertyName' => '<p>The name of the property to use in the nested filters. The value must match a listed property name, such as <code>InputDataConfig</code>.</p>', 'PropertyNameSuggestion$PropertyName' => '<p>A suggested property name based on what you entered in the search textbox in the Amazon SageMaker console.</p>', 'SearchRequest$SortBy' => '<p>The name of the resource property used to sort the <code>SearchResults</code>. The default is <code>LastModifiedTime</code>.</p>', ], ], 'ResourceSpec' => [ 'base' => '<p>Specifies the ARN\'s of a SageMaker image and SageMaker image version, and the instance type that the version runs on.</p>', 'refs' => [ 'CreateAppRequest$ResourceSpec' => '<p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>', 'DescribeAppResponse$ResourceSpec' => '<p>The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>', 'JupyterServerAppSettings$DefaultResourceSpec' => '<p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the JupyterServer app.</p>', 'KernelGatewayAppSettings$DefaultResourceSpec' => '<p>The default instance type and the Amazon Resource Name (ARN) of the default SageMaker image used by the KernelGateway app.</p>', 'RStudioServerProDomainSettings$DefaultResourceSpec' => NULL, 'RStudioServerProDomainSettingsForUpdate$DefaultResourceSpec' => NULL, 'TensorBoardAppSettings$DefaultResourceSpec' => '<p>The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'GetSearchSuggestionsRequest$Resource' => '<p>The name of the Amazon SageMaker resource to search for.</p>', 'SearchRequest$Resource' => '<p>The name of the Amazon SageMaker resource to search for.</p>', ], ], 'ResponseMIMEType' => [ 'base' => NULL, 'refs' => [ 'ResponseMIMETypes$member' => NULL, ], ], 'ResponseMIMETypes' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$SupportedResponseMIMETypes' => '<p>The supported MIME types for the output data.</p>', 'InferenceSpecification$SupportedResponseMIMETypes' => '<p>The supported MIME types for the output data.</p>', ], ], 'RetentionPolicy' => [ 'base' => '<p>The retention policy for data stored on an Amazon Elastic File System (EFS) volume.</p>', 'refs' => [ 'DeleteDomainRequest$RetentionPolicy' => '<p>The retention policy for this domain, which specifies whether resources will be retained after the Domain is deleted. By default, all resources are retained (not automatically deleted). </p>', ], ], 'RetentionType' => [ 'base' => NULL, 'refs' => [ 'RetentionPolicy$HomeEfsFileSystem' => '<p>The default is <code>Retain</code>, which specifies to keep the data stored on the EFS volume.</p> <p>Specify <code>Delete</code> to delete the data stored on the EFS volume.</p>', ], ], 'RetryPipelineExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'RetryPipelineExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'RetryStrategy' => [ 'base' => '<p>The retry strategy to use when a training job fails due to an <code>InternalServerError</code>. <code>RetryStrategy</code> is specified as part of the <code>CreateTrainingJob</code> and <code>CreateHyperParameterTuningJob</code> requests. You can add the <code>StoppingCondition</code> parameter to the request to limit the training time for the complete job.</p>', 'refs' => [ 'CreateTrainingJobRequest$RetryStrategy' => '<p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>', 'DescribeTrainingJobResponse$RetryStrategy' => '<p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>', 'HyperParameterTrainingJobDefinition$RetryStrategy' => '<p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>', 'TrainingJob$RetryStrategy' => '<p>The number of times to retry the job when the job fails due to an <code>InternalServerError</code>.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'AlgorithmValidationSpecification$ValidationRole' => '<p>The IAM roles that Amazon SageMaker uses to run the training jobs.</p>', 'CreateAutoMLJobRequest$RoleArn' => '<p>The ARN of the role that is used to access the data.</p>', 'CreateCompilationJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf. </p> <p>During model compilation, Amazon SageMaker needs your permission to:</p> <ul> <li> <p>Read input data from an S3 bucket</p> </li> <li> <p>Write model artifacts to an S3 bucket</p> </li> <li> <p>Write logs to Amazon CloudWatch Logs</p> </li> <li> <p>Publish metrics to Amazon CloudWatch</p> </li> </ul> <p>You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles.</a> </p>', 'CreateDataQualityJobDefinitionRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'CreateDeviceFleetRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).</p>', 'CreateEdgePackagingJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact SageMaker Neo.</p>', 'CreateFeatureGroupRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>', 'CreateFlowDefinitionRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role needed to call other services on your behalf. For example, <code>arn:aws:iam::1234567890:role/service-role/AmazonSageMaker-ExecutionRole-20180111T151298</code>.</p>', 'CreateImageRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>', 'CreateInferenceRecommendationsJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>', 'CreateLabelingJobRequest$RoleArn' => '<p>The Amazon Resource Number (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling. You must grant this role the necessary permissions so that Amazon SageMaker can successfully complete data labeling.</p>', 'CreateModelBiasJobDefinitionRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'CreateModelExplainabilityJobDefinitionRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'CreateModelInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access model artifacts and docker image for deployment on ML compute instances or for batch transform jobs. Deploying on ML compute instances is part of model hosting. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note>', 'CreateModelQualityJobDefinitionRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'CreateNotebookInstanceInput$RoleArn' => '<p> When you send any requests to Amazon Web Services resources from the notebook instance, Amazon SageMaker assumes this role to perform tasks on your behalf. You must grant this role necessary permissions so Amazon SageMaker can perform these tasks. The policy must allow the Amazon SageMaker service principal (sagemaker.amazonaws.com) permissions to assume this role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note>', 'CreatePipelineRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role used by the pipeline to access and create resources.</p>', 'CreateProcessingJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'CreateTrainingJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf. </p> <p>During model training, Amazon SageMaker needs your permission to read input data from an S3 bucket, download a Docker image that contains training code, write model artifacts to an S3 bucket, write logs to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these tasks to an IAM role. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note>', 'DescribeAutoMLJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>', 'DescribeCompilationJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker assumes to perform the model compilation job.</p>', 'DescribeDataQualityJobDefinitionResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'DescribeDeviceFleetResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) that has access to Amazon Web Services Internet of Things (IoT).</p>', 'DescribeEdgePackagingJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to download and upload the model, and to contact Neo.</p>', 'DescribeFeatureGroupResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM execution role used to persist data into the <code>OfflineStore</code> if an <code>OfflineStoreConfig</code> is provided.</p>', 'DescribeFlowDefinitionResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) execution role for the flow definition.</p>', 'DescribeImageResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>', 'DescribeInferenceRecommendationsJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role you provided when you initiated the job.</p>', 'DescribeLabelingJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data labeling.</p>', 'DescribeModelBiasJobDefinitionResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that has read permission to the input data location and write permission to the output data location in Amazon S3.</p>', 'DescribeModelOutput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that you specified for the model.</p>', 'DescribeModelQualityJobDefinitionResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'DescribeNotebookInstanceOutput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role associated with the instance. </p>', 'DescribePipelineResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) that the pipeline uses to execute.</p>', 'DescribeProcessingJobResponse$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'DescribeTrainingJobResponse$RoleArn' => '<p>The Amazon Web Services Identity and Access Management (IAM) role configured for the training job. </p>', 'FeatureGroup$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.</p>', 'HyperParameterTrainingJobDefinition$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role associated with the training jobs that the tuning job launches.</p>', 'InferenceRecommendationsJob$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>', 'ModelPackageValidationSpecification$ValidationRole' => '<p>The IAM roles to be used for the validation of the model package.</p>', 'MonitoringJobDefinition$RoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.</p>', 'Pipeline$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role that created the pipeline.</p>', 'PipelineSummary$RoleArn' => '<p>The Amazon Resource Name (ARN) that the pipeline used to execute.</p>', 'ProcessingJob$RoleArn' => '<p>The ARN of the role used to create the processing job.</p>', 'RStudioServerProDomainSettings$DomainExecutionRoleArn' => '<p>The ARN of the execution role for the <code>RStudioServerPro</code> Domain-level app.</p>', 'RStudioServerProDomainSettingsForUpdate$DomainExecutionRoleArn' => '<p>The execution role for the <code>RStudioServerPro</code> Domain-level app.</p>', 'RedshiftDatasetDefinition$ClusterRoleArn' => '<p>The IAM role attached to your Redshift cluster that Amazon SageMaker uses to generate datasets.</p>', 'RenderUiTemplateRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) that has access to the S3 objects that are used by the template.</p>', 'TrainingJob$RoleArn' => '<p>The Amazon Web Services Identity and Access Management (IAM) role configured for the training job.</p>', 'UpdateDeviceFleetRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the device.</p>', 'UpdateImageRequest$RoleArn' => '<p>The new Amazon Resource Name (ARN) for the IAM role that enables Amazon SageMaker to perform tasks on your behalf.</p>', 'UpdateNotebookInstanceInput$RoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the notebook instance. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>. </p> <note> <p>To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code> permission.</p> </note>', 'UpdatePipelineRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) that the pipeline uses to execute.</p>', 'UserSettings$ExecutionRole' => '<p>The execution role for the user.</p>', ], ], 'RootAccess' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$RootAccess' => '<p>Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code>.</p> <note> <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p> </note>', 'DescribeNotebookInstanceOutput$RootAccess' => '<p>Whether root access is enabled or disabled for users of the notebook instance.</p> <note> <p>Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle configurations associated with a notebook instance always run with root access even if you disable root access for users.</p> </note>', 'UpdateNotebookInstanceInput$RootAccess' => '<p>Whether root access is enabled or disabled for users of the notebook instance. The default value is <code>Enabled</code>.</p> <note> <p>If you set this to <code>Disabled</code>, users don\'t have root access on the notebook instance, but lifecycle configuration scripts still run with root permissions.</p> </note>', ], ], 'RuleConfigurationName' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$RuleConfigurationName' => '<p>The name of the rule configuration. It must be unique relative to other rule configuration names.</p>', 'DebugRuleEvaluationStatus$RuleConfigurationName' => '<p>The name of the rule configuration.</p>', 'ProfilerRuleConfiguration$RuleConfigurationName' => '<p>The name of the rule configuration. It must be unique relative to other rule configuration names.</p>', 'ProfilerRuleEvaluationStatus$RuleConfigurationName' => '<p>The name of the rule configuration.</p>', ], ], 'RuleEvaluationStatus' => [ 'base' => NULL, 'refs' => [ 'DebugRuleEvaluationStatus$RuleEvaluationStatus' => '<p>Status of the rule evaluation.</p>', 'ProfilerRuleEvaluationStatus$RuleEvaluationStatus' => '<p>Status of the rule evaluation.</p>', ], ], 'RuleParameters' => [ 'base' => NULL, 'refs' => [ 'DebugRuleConfiguration$RuleParameters' => '<p>Runtime configuration for rule container.</p>', 'ProfilerRuleConfiguration$RuleParameters' => '<p>Runtime configuration for rule container.</p>', ], ], 'S3DataDistribution' => [ 'base' => NULL, 'refs' => [ 'S3DataSource$S3DataDistributionType' => '<p>If you want Amazon SageMaker to replicate the entire dataset on each ML compute instance that is launched for model training, specify <code>FullyReplicated</code>. </p> <p>If you want Amazon SageMaker to replicate a subset of data on each ML compute instance that is launched for model training, specify <code>ShardedByS3Key</code>. If there are <i>n</i> ML compute instances launched for a training job, each instance gets approximately 1/<i>n</i> of the number of S3 objects. In this case, model training on each machine uses only the subset of training data. </p> <p>Don\'t choose more ML compute instances for training than available S3 objects. If you do, some nodes won\'t get any data and you will pay for nodes that aren\'t getting any training data. This applies in both File and Pipe modes. Keep this in mind when developing algorithms. </p> <p>In distributed training, where you use multiple ML compute EC2 instances, you might choose <code>ShardedByS3Key</code>. If the algorithm requires copying training data to the ML storage volume (when <code>TrainingInputMode</code> is set to <code>File</code>), this copies 1/<i>n</i> of the number of objects. </p>', ], ], 'S3DataSource' => [ 'base' => '<p>Describes the S3 data source.</p>', 'refs' => [ 'DataSource$S3DataSource' => '<p>The S3 location of the data source that is associated with a channel.</p>', ], ], 'S3DataType' => [ 'base' => NULL, 'refs' => [ 'S3DataSource$S3DataType' => '<p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects that match the specified key name prefix for model training. </p> <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for model training. </p> <p>If you choose <code>AugmentedManifestFile</code>, S3Uri identifies an object that is an augmented manifest file in JSON lines format. This file contains the data you want to use for model training. <code>AugmentedManifestFile</code> can only be used if the Channel\'s input mode is <code>Pipe</code>.</p>', 'TransformS3DataSource$S3DataType' => '<p>If you choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with the specified key name prefix for batch transform. </p> <p>If you choose <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to use for batch transform. </p> <p>The following values are compatible: <code>ManifestFile</code>, <code>S3Prefix</code> </p> <p>The following value is not compatible: <code>AugmentedManifestFile</code> </p>', ], ], 'S3StorageConfig' => [ 'base' => '<p>The Amazon Simple Storage (Amazon S3) location and and security configuration for <code>OfflineStore</code>.</p>', 'refs' => [ 'OfflineStoreConfig$S3StorageConfig' => '<p>The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code>.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'AthenaDatasetDefinition$OutputS3Uri' => '<p>The location in Amazon S3 where Athena query results are stored.</p>', 'AutoMLOutputDataConfig$S3OutputPath' => '<p>The Amazon S3 output path. Must be 128 characters or less.</p>', 'AutoMLS3DataSource$S3Uri' => '<p>The URL to the Amazon S3 data source.</p>', 'CheckpointConfig$S3Uri' => '<p>Identifies the S3 path where you want Amazon SageMaker to store checkpoints. For example, <code>s3://bucket-name/key-name-prefix</code>.</p>', 'CreateLabelingJobRequest$LabelCategoryConfigS3Uri' => '<p>The S3 URI of the file, referred to as a <i>label category configuration file</i>, that defines the categories used to label the data objects.</p> <p>For 3D point cloud and video frame task types, you can add label category attributes and frame attributes to your label category configuration file. To learn how, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html">Create a Labeling Category Configuration File for 3D Point Cloud Labeling Jobs</a>. </p> <p>For named entity recognition jobs, in addition to <code>"labels"</code>, you must provide worker instructions in the label category configuration file using the <code>"instructions"</code> parameter: <code>"instructions": {"shortInstruction":"&lt;h1&gt;Add header&lt;/h1&gt;&lt;p&gt;Add Instructions&lt;/p&gt;", "fullInstruction":"&lt;p&gt;Add additional instructions.&lt;/p&gt;"}</code>. For details and an example, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-named-entity-recg.html#sms-creating-ner-api">Create a Named Entity Recognition Labeling Job (API) </a>.</p> <p>For all other <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html">custom tasks</a>, your label category configuration file must be a JSON file in the following format. Identify the labels you want to use by replacing <code>label_1</code>, <code>label_2</code>,<code>...</code>,<code>label_n</code> with your label categories.</p> <p> <code>{ </code> </p> <p> <code>"document-version": "2018-11-28",</code> </p> <p> <code>"labels": [{"label": "label_1"},{"label": "label_2"},...{"label": "label_n"}]</code> </p> <p> <code>}</code> </p> <p>Note the following about the label category configuration file:</p> <ul> <li> <p>For image classification and text classification (single and multi-label) you must specify at least two label categories. For all other task types, the minimum number of label categories required is one. </p> </li> <li> <p>Each label category must be unique, you cannot specify duplicate label categories.</p> </li> <li> <p>If you create a 3D point cloud or video frame adjustment or verification labeling job, you must include <code>auditLabelAttributeName</code> in the label category configuration. Use this parameter to enter the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateLabelingJob.html#sagemaker-CreateLabelingJob-request-LabelAttributeName"> <code>LabelAttributeName</code> </a> of the labeling job you want to adjust or verify annotations of.</p> </li> </ul>', 'CreateModelPackageInput$SamplePayloadUrl' => '<p>The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).</p>', 'DataQualityAppSpecification$RecordPreprocessorSourceUri' => '<p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.</p>', 'DataQualityAppSpecification$PostAnalyticsProcessorSourceUri' => '<p>An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.</p>', 'DebugHookConfig$S3OutputPath' => '<p>Path to Amazon S3 storage location for metrics and tensors.</p>', 'DebugRuleConfiguration$S3OutputPath' => '<p>Path to Amazon S3 storage location for rules.</p>', 'DescribeEdgePackagingJobResponse$ModelArtifact' => '<p>The Amazon Simple Storage (S3) URI where model artifacts ares stored.</p>', 'DescribeLabelingJobResponse$LabelCategoryConfigS3Uri' => '<p>The S3 location of the JSON file that defines the categories used to label data objects. Please note the following label-category limits:</p> <ul> <li> <p>Semantic segmentation labeling jobs using automated labeling: 20 labels</p> </li> <li> <p>Box bounding labeling jobs (all): 10 labels</p> </li> </ul> <p>The file is a JSON structure in the following format:</p> <p> <code>{</code> </p> <p> <code> "document-version": "2018-11-28"</code> </p> <p> <code> "labels": [</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label 1</i>"</code> </p> <p> <code> },</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label 2</i>"</code> </p> <p> <code> },</code> </p> <p> <code> ...</code> </p> <p> <code> {</code> </p> <p> <code> "label": "<i>label n</i>"</code> </p> <p> <code> }</code> </p> <p> <code> ]</code> </p> <p> <code>}</code> </p>', 'EdgeOutputConfig$S3OutputLocation' => '<p>The Amazon Simple Storage (S3) bucker URI.</p>', 'FileSource$S3Uri' => '<p>The Amazon S3 URI for the file source.</p>', 'FlowDefinitionOutputConfig$S3OutputPath' => '<p>The Amazon S3 path where the object containing human output will be made available.</p> <p>To learn more about the format of Amazon A2I output data, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-output-data.html">Amazon A2I Output Data</a>.</p>', 'InputConfig$S3Uri' => '<p>The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).</p>', 'LabelingJobOutput$OutputDatasetS3Uri' => '<p>The Amazon S3 bucket location of the manifest file for labeled data. </p>', 'LabelingJobOutputConfig$S3OutputPath' => '<p>The Amazon S3 location to write output data.</p>', 'LabelingJobS3DataSource$ManifestS3Uri' => '<p>The Amazon S3 location of the manifest file that describes the input data objects. </p> <p>The input manifest file referenced in <code>ManifestS3Uri</code> must contain one of the following keys: <code>source-ref</code> or <code>source</code>. The value of the keys are interpreted as follows:</p> <ul> <li> <p> <code>source-ref</code>: The source of the object is the Amazon S3 object specified in the value. Use this value when the object is a binary object, such as an image.</p> </li> <li> <p> <code>source</code>: The source of the object is the value. Use this value when the object is a text value.</p> </li> </ul> <p>If you are a new user of Ground Truth, it is recommended you review <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-input-data-input-manifest.html">Use an Input Manifest File </a> in the Amazon SageMaker Developer Guide to learn how to create an input manifest file.</p>', 'MetricsSource$S3Uri' => '<p/>', 'ModelArtifacts$S3ModelArtifacts' => '<p>The path of the S3 object that contains the model artifacts. For example, <code>s3://bucket-name/keynameprefix/model.tar.gz</code>.</p>', 'ModelBiasAppSpecification$ConfigUri' => '<p>JSON formatted S3 file that defines bias parameters. For more information on this JSON configuration file, see <a href="https://docs.aws.amazon.com/sagemaker/latest/json-bias-parameter-config.html">Configure bias parameters</a>.</p>', 'ModelExplainabilityAppSpecification$ConfigUri' => '<p>JSON formatted S3 file that defines explainability parameters. For more information on this JSON configuration file, see <a href="https://docs.aws.amazon.com/sagemaker/latest/json-model-explainability-parameter-config.html">Configure model explainability parameters</a>.</p>', 'ModelQualityAppSpecification$RecordPreprocessorSourceUri' => '<p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.</p>', 'ModelQualityAppSpecification$PostAnalyticsProcessorSourceUri' => '<p>An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.</p>', 'MonitoringAppSpecification$RecordPreprocessorSourceUri' => '<p>An Amazon S3 URI to a script that is called per row prior to running analysis. It can base64 decode the payload and convert it into a flatted json so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.</p>', 'MonitoringAppSpecification$PostAnalyticsProcessorSourceUri' => '<p>An Amazon S3 URI to a script that is called after analysis has been performed. Applicable only for the built-in (first party) containers.</p>', 'MonitoringConstraintsResource$S3Uri' => '<p>The Amazon S3 URI for the constraints resource.</p>', 'MonitoringStatisticsResource$S3Uri' => '<p>The Amazon S3 URI for the statistics resource.</p>', 'OutputConfig$S3OutputLocation' => '<p>Identifies the S3 bucket where you want Amazon SageMaker to store the model artifacts. For example, <code>s3://bucket-name/key-name-prefix</code>.</p>', 'OutputDataConfig$S3OutputPath' => '<p>Identifies the S3 path where you want Amazon SageMaker to store the model artifacts. For example, <code>s3://bucket-name/key-name-prefix</code>. </p>', 'ProcessingS3Input$S3Uri' => '<p>The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run a processing job.</p>', 'ProcessingS3Output$S3Uri' => '<p>A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker to save the results of a processing job.</p>', 'ProfilerConfig$S3OutputPath' => '<p>Path to Amazon S3 storage location for system and framework metrics.</p>', 'ProfilerConfigForUpdate$S3OutputPath' => '<p>Path to Amazon S3 storage location for system and framework metrics.</p>', 'ProfilerRuleConfiguration$S3OutputPath' => '<p>Path to Amazon S3 storage location for rules.</p>', 'RedshiftDatasetDefinition$OutputS3Uri' => '<p>The location in Amazon S3 where the Redshift query results are stored.</p>', 'S3DataSource$S3Uri' => '<p>Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix or a manifest. For example: </p> <ul> <li> <p> A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code> </p> </li> <li> <p> A manifest might look like this: <code>s3://bucketname/example.manifest</code> </p> <p> A manifest is an S3 object which is a JSON file consisting of an array of elements. The first element is a prefix which is followed by one or more suffixes. SageMaker appends the suffix elements to the prefix to get a full set of <code>S3Uri</code>. Note that the prefix must be a valid non-empty <code>S3Uri</code> that precludes users from specifying a manifest whose individual <code>S3Uri</code> is sourced from different S3 buckets.</p> <p> The following code example shows a valid manifest format: </p> <p> <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code> </p> <p> <code> "relative/path/to/custdata-1",</code> </p> <p> <code> "relative/path/custdata-2",</code> </p> <p> <code> ...</code> </p> <p> <code> "relative/path/custdata-N"</code> </p> <p> <code>]</code> </p> <p> This JSON is equivalent to the following <code>S3Uri</code> list:</p> <p> <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code> </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code> </p> <p> <code>...</code> </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code> </p> <p>The complete set of <code>S3Uri</code> in this manifest is the input data for the channel for this data source. The object that each <code>S3Uri</code> points to must be readable by the IAM role that Amazon SageMaker uses to perform tasks on your behalf. </p> </li> </ul>', 'S3StorageConfig$S3Uri' => '<p>The S3 URI, or location in Amazon S3, of <code>OfflineStore</code>.</p> <p>S3 URIs have a format similar to the following: <code>s3://example-bucket/prefix/</code>.</p>', 'S3StorageConfig$ResolvedOutputS3Uri' => '<p>The S3 path where offline records are written.</p>', 'SharingSettings$S3OutputPath' => '<p>When <code>NotebookOutputOption</code> is <code>Allowed</code>, the Amazon S3 bucket used to store the shared notebook snapshots.</p>', 'TensorBoardOutputConfig$S3OutputPath' => '<p>Path to Amazon S3 storage location for TensorBoard output.</p>', 'TransformOutput$S3OutputPath' => '<p>The Amazon S3 path where you want Amazon SageMaker to store the results of the transform job. For example, <code>s3://bucket-name/key-name-prefix</code>.</p> <p>For every S3 object used as input for the transform job, batch transform stores the transformed data with an .<code>out</code> suffix in a corresponding subfolder in the location in the output prefix. For example, for the input data stored at <code>s3://bucket-name/input-name-prefix/dataset01/data.csv</code>, batch transform stores the transformed data at <code>s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out</code>. Batch transform doesn\'t upload partially processed objects. For an input S3 object that contains multiple records, it creates an .<code>out</code> file only if the transform job succeeds on the entire file. When the input contains multiple S3 objects, the batch transform job processes the listed S3 objects and uploads only the output for successfully processed objects. If any object fails in the transform job batch transform marks the job as failed to prompt investigation.</p>', 'TransformS3DataSource$S3Uri' => '<p>Depending on the value specified for the <code>S3DataType</code>, identifies either a key name prefix or a manifest. For example:</p> <ul> <li> <p> A key name prefix might look like this: <code>s3://bucketname/exampleprefix</code>. </p> </li> <li> <p> A manifest might look like this: <code>s3://bucketname/example.manifest</code> </p> <p> The manifest is an S3 object which is a JSON file with the following format: </p> <p> <code>[ {"prefix": "s3://customer_bucket/some/prefix/"},</code> </p> <p> <code>"relative/path/to/custdata-1",</code> </p> <p> <code>"relative/path/custdata-2",</code> </p> <p> <code>...</code> </p> <p> <code>"relative/path/custdata-N"</code> </p> <p> <code>]</code> </p> <p> The preceding JSON matches the following <code>S3Uris</code>: </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/to/custdata-1</code> </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/custdata-2</code> </p> <p> <code>...</code> </p> <p> <code>s3://customer_bucket/some/prefix/relative/path/custdata-N</code> </p> <p> The complete set of <code>S3Uris</code> in this manifest constitutes the input data for the channel for this datasource. The object that each <code>S3Uris</code> points to must be readable by the IAM role that Amazon SageMaker uses to perform tasks on your behalf.</p> </li> </ul>', 'UiConfig$UiTemplateS3Uri' => '<p>The Amazon S3 bucket location of the UI template, or worker task template. This is the template used to render the worker UI and tools for labeling job tasks. For more information about the contents of a UI template, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html"> Creating Your Custom Labeling Task Template</a>.</p>', ], ], 'SagemakerServicecatalogStatus' => [ 'base' => NULL, 'refs' => [ 'GetSagemakerServicecatalogPortfolioStatusOutput$Status' => '<p>Whether Service Catalog is enabled or disabled in SageMaker.</p>', ], ], 'SamplingPercentage' => [ 'base' => NULL, 'refs' => [ 'DataCaptureConfig$InitialSamplingPercentage' => '<p/>', 'DataCaptureConfigSummary$CurrentSamplingPercentage' => '<p/>', ], ], 'ScheduleConfig' => [ 'base' => '<p>Configuration details about the monitoring schedule.</p>', 'refs' => [ 'MonitoringScheduleConfig$ScheduleConfig' => '<p>Configures the monitoring schedule.</p>', ], ], 'ScheduleExpression' => [ 'base' => NULL, 'refs' => [ 'ScheduleConfig$ScheduleExpression' => '<p>A cron expression that describes details about the monitoring schedule.</p> <p>Currently the only supported cron expressions are:</p> <ul> <li> <p>If you want to set the job to start every hour, please use the following:</p> <p> <code>Hourly: cron(0 * ? * * *)</code> </p> </li> <li> <p>If you want to start the job daily:</p> <p> <code>cron(0 [00-23] ? * * *)</code> </p> </li> </ul> <p>For example, the following are valid cron expressions:</p> <ul> <li> <p>Daily at noon UTC: <code>cron(0 12 ? * * *)</code> </p> </li> <li> <p>Daily at midnight UTC: <code>cron(0 0 ? * * *)</code> </p> </li> </ul> <p>To support running every 6, 12 hours, the following are also supported:</p> <p> <code>cron(0 [00-23]/[01-24] ? * * *)</code> </p> <p>For example, the following are valid cron expressions:</p> <ul> <li> <p>Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code> </p> </li> <li> <p>Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code> </p> </li> </ul> <note> <ul> <li> <p>Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20 minutes from the actual requested time to run the execution. </p> </li> <li> <p>We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker will pick a time for running every day.</p> </li> </ul> </note>', ], ], 'ScheduleStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeMonitoringScheduleResponse$MonitoringScheduleStatus' => '<p>The status of an monitoring job.</p>', 'ListMonitoringSchedulesRequest$StatusEquals' => '<p>A filter that returns only monitoring schedules modified before a specified time.</p>', 'MonitoringSchedule$MonitoringScheduleStatus' => '<p>The status of the monitoring schedule. This can be one of the following values.</p> <ul> <li> <p> <code>PENDING</code> - The schedule is pending being created.</p> </li> <li> <p> <code>FAILED</code> - The schedule failed.</p> </li> <li> <p> <code>SCHEDULED</code> - The schedule was successfully created.</p> </li> <li> <p> <code>STOPPED</code> - The schedule was stopped.</p> </li> </ul>', 'MonitoringScheduleSummary$MonitoringScheduleStatus' => '<p>The status of the monitoring schedule.</p>', ], ], 'SearchExpression' => [ 'base' => '<p>A multi-expression that searches for the specified resource or resources in a search. All resource objects that satisfy the expression\'s condition are included in the search results. You must specify at least one subexpression, filter, or nested filter. A <code>SearchExpression</code> can contain up to twenty elements.</p> <p>A <code>SearchExpression</code> contains the following components:</p> <ul> <li> <p>A list of <code>Filter</code> objects. Each filter defines a simple Boolean expression comprised of a resource property name, Boolean operator, and value.</p> </li> <li> <p>A list of <code>NestedFilter</code> objects. Each nested filter defines a list of Boolean expressions using a list of resource properties. A nested filter is satisfied if a single object in the list satisfies all Boolean expressions.</p> </li> <li> <p>A list of <code>SearchExpression</code> objects. A search expression object can be nested in a list of search expression objects.</p> </li> <li> <p>A Boolean operator: <code>And</code> or <code>Or</code>.</p> </li> </ul>', 'refs' => [ 'SearchExpressionList$member' => NULL, 'SearchRequest$SearchExpression' => '<p>A Boolean conditional statement. Resources must satisfy this condition to be included in search results. You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be included in a <code>SearchExpression</code> object is 50.</p>', ], ], 'SearchExpressionList' => [ 'base' => NULL, 'refs' => [ 'SearchExpression$SubExpressions' => '<p>A list of search expression objects.</p>', ], ], 'SearchRecord' => [ 'base' => '<p>A single resource returned as part of the <a>Search</a> API response.</p>', 'refs' => [ 'SearchResultsList$member' => NULL, ], ], 'SearchRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchResultsList' => [ 'base' => NULL, 'refs' => [ 'SearchResponse$Results' => '<p>A list of <code>SearchRecord</code> objects.</p>', ], ], 'SearchSortOrder' => [ 'base' => NULL, 'refs' => [ 'SearchRequest$SortOrder' => '<p>How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or <code>Descending</code>. The default is <code>Descending</code>.</p>', ], ], 'SecondaryStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$SecondaryStatus' => '<p> Provides detailed information about the state of the training job. For detailed information on the secondary status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.</p> <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p> <dl> <dt>InProgress</dt> <dd> <ul> <li> <p> <code>Starting</code> - Starting the training job.</p> </li> <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li> <li> <p> <code>Training</code> - Training is in progress.</p> </li> <li> <p> <code>Interrupted</code> - The job stopped because the managed spot training instances were interrupted. </p> </li> <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li> </ul> </dd> <dt>Completed</dt> <dd> <ul> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> </ul> </dd> <dt>Failed</dt> <dd> <ul> <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li> </ul> </dd> <dt>Stopped</dt> <dd> <ul> <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li> <li> <p> <code>MaxWaitTimeExceeded</code> - The job stopped because it exceeded the maximum allowed wait time.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> </dd> <dt>Stopping</dt> <dd> <ul> <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li> </ul> </dd> </dl> <important> <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p> </important> <p>We no longer support the following secondary statuses:</p> <ul> <li> <p> <code>LaunchingMLInstances</code> </p> </li> <li> <p> <code>PreparingTraining</code> </p> </li> <li> <p> <code>DownloadingTrainingImage</code> </p> </li> </ul>', 'SecondaryStatusTransition$Status' => '<p>Contains a secondary status information from a training job.</p> <p>Status might be one of the following secondary statuses:</p> <dl> <dt>InProgress</dt> <dd> <ul> <li> <p> <code>Starting</code> - Starting the training job.</p> </li> <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li> <li> <p> <code>Training</code> - Training is in progress.</p> </li> <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li> </ul> </dd> <dt>Completed</dt> <dd> <ul> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> </ul> </dd> <dt>Failed</dt> <dd> <ul> <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li> </ul> </dd> <dt>Stopped</dt> <dd> <ul> <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> </dd> <dt>Stopping</dt> <dd> <ul> <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li> </ul> </dd> </dl> <p>We no longer support the following secondary statuses:</p> <ul> <li> <p> <code>LaunchingMLInstances</code> </p> </li> <li> <p> <code>PreparingTrainingStack</code> </p> </li> <li> <p> <code>DownloadingTrainingImage</code> </p> </li> </ul>', 'TrainingJob$SecondaryStatus' => '<p> Provides detailed information about the state of the training job. For detailed information about the secondary status of the training job, see <code>StatusMessage</code> under <a>SecondaryStatusTransition</a>.</p> <p>Amazon SageMaker provides primary statuses and secondary statuses that apply to each of them:</p> <dl> <dt>InProgress</dt> <dd> <ul> <li> <p> <code>Starting</code> - Starting the training job.</p> </li> <li> <p> <code>Downloading</code> - An optional stage for algorithms that support <code>File</code> training input mode. It indicates that data is being downloaded to the ML storage volumes.</p> </li> <li> <p> <code>Training</code> - Training is in progress.</p> </li> <li> <p> <code>Uploading</code> - Training is complete and the model artifacts are being uploaded to the S3 location.</p> </li> </ul> </dd> <dt>Completed</dt> <dd> <ul> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> </ul> </dd> <dt>Failed</dt> <dd> <ul> <li> <p> <code>Failed</code> - The training job has failed. The reason for the failure is returned in the <code>FailureReason</code> field of <code>DescribeTrainingJobResponse</code>.</p> </li> </ul> </dd> <dt>Stopped</dt> <dd> <ul> <li> <p> <code>MaxRuntimeExceeded</code> - The job stopped because it exceeded the maximum allowed runtime.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> </dd> <dt>Stopping</dt> <dd> <ul> <li> <p> <code>Stopping</code> - Stopping the training job.</p> </li> </ul> </dd> </dl> <important> <p>Valid values for <code>SecondaryStatus</code> are subject to change. </p> </important> <p>We no longer support the following secondary statuses:</p> <ul> <li> <p> <code>LaunchingMLInstances</code> </p> </li> <li> <p> <code>PreparingTrainingStack</code> </p> </li> <li> <p> <code>DownloadingTrainingImage</code> </p> </li> </ul>', ], ], 'SecondaryStatusTransition' => [ 'base' => '<p>An array element of <a>DescribeTrainingJobResponse$SecondaryStatusTransitions</a>. It provides additional details about a status that the training job has transitioned through. A training job can be in one of several states, for example, starting, downloading, training, or uploading. Within each state, there are a number of intermediate states. For example, within the starting state, Amazon SageMaker could be starting the training job or launching the ML instances. These transitional states are referred to as the job\'s secondary status. </p> <p/>', 'refs' => [ 'SecondaryStatusTransitions$member' => NULL, ], ], 'SecondaryStatusTransitions' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$SecondaryStatusTransitions' => '<p>A history of all of the secondary statuses that the training job has transitioned through.</p>', 'TrainingJob$SecondaryStatusTransitions' => '<p>A history of all of the secondary statuses that the training job has transitioned through.</p>', ], ], 'SecretArn' => [ 'base' => NULL, 'refs' => [ 'GitConfig$SecretArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>', 'GitConfigForUpdate$SecretArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that contains the credentials used to access the git repository. The secret must have a staging label of <code>AWSCURRENT</code> and must be in the following format:</p> <p> <code>{"username": <i>UserName</i>, "password": <i>Password</i>}</code> </p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainResponse$SecurityGroupIdForDomainBoundary' => '<p>The ID of the security group that authorizes traffic between the <code>RSessionGateway</code> apps and the <code>RStudioServerPro</code> app.</p>', 'DomainSecurityGroupIds$member' => NULL, 'SecurityGroupIds$member' => NULL, 'VpcSecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$SecurityGroupIds' => '<p>The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must be for the same VPC as specified in the subnet. </p>', 'DescribeNotebookInstanceOutput$SecurityGroups' => '<p>The IDs of the VPC security groups.</p>', 'UserSettings$SecurityGroups' => '<p>The security groups for the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p> <p>Optional when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>PublicInternetOnly</code>.</p> <p>Required when the <code>CreateDomain.AppNetworkAccessType</code> parameter is set to <code>VpcOnly</code>.</p> <p>Amazon SageMaker adds a security group to allow NFS traffic from SageMaker Studio. Therefore, the number of security groups that you can specify is one less than the maximum number shown.</p>', ], ], 'Seed' => [ 'base' => NULL, 'refs' => [ 'ShuffleConfig$Seed' => '<p>Determines the shuffling order in <code>ShuffleConfig</code> value.</p>', ], ], 'SendPipelineExecutionStepFailureRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendPipelineExecutionStepFailureResponse' => [ 'base' => NULL, 'refs' => [], ], 'SendPipelineExecutionStepSuccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendPipelineExecutionStepSuccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServerlessMaxConcurrency' => [ 'base' => NULL, 'refs' => [ 'ProductionVariantServerlessConfig$MaxConcurrency' => '<p>The maximum number of concurrent invocations your serverless endpoint can process.</p>', ], ], 'ServerlessMemorySizeInMB' => [ 'base' => NULL, 'refs' => [ 'ProductionVariantServerlessConfig$MemorySizeInMB' => '<p>The memory size of your serverless endpoint. Valid values are in 1 GB increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.</p>', ], ], 'ServiceCatalogEntityId' => [ 'base' => NULL, 'refs' => [ 'ServiceCatalogProvisionedProductDetails$ProvisionedProductId' => '<p>The ID of the provisioned product.</p>', 'ServiceCatalogProvisioningDetails$ProductId' => '<p>The ID of the product to provision.</p>', 'ServiceCatalogProvisioningDetails$ProvisioningArtifactId' => '<p>The ID of the provisioning artifact.</p>', 'ServiceCatalogProvisioningDetails$PathId' => '<p>The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. </p>', 'ServiceCatalogProvisioningUpdateDetails$ProvisioningArtifactId' => '<p>The ID of the provisioning artifact.</p>', ], ], 'ServiceCatalogProvisionedProductDetails' => [ 'base' => '<p>Details of a provisioned service catalog product. For information about service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>', 'refs' => [ 'DescribeProjectOutput$ServiceCatalogProvisionedProductDetails' => '<p>Information about a provisioned service catalog product.</p>', 'Project$ServiceCatalogProvisionedProductDetails' => NULL, ], ], 'ServiceCatalogProvisioningDetails' => [ 'base' => '<p>Details that you specify to provision a service catalog product. For information about service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>', 'refs' => [ 'CreateProjectInput$ServiceCatalogProvisioningDetails' => '<p>The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will default to the latest provisioning artifact ID of the product, if you don\'t provide the provisioning artifact ID. For more information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>', 'DescribeProjectOutput$ServiceCatalogProvisioningDetails' => '<p>Information used to provision a service catalog product. For information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>.</p>', 'Project$ServiceCatalogProvisioningDetails' => NULL, ], ], 'ServiceCatalogProvisioningUpdateDetails' => [ 'base' => '<p>Details that you specify to provision a service catalog product. For information about service catalog, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>. </p>', 'refs' => [ 'UpdateProjectInput$ServiceCatalogProvisioningUpdateDetails' => '<p>The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will default to the latest provisioning artifact ID of the product, if you don\'t provide the provisioning artifact ID. For more information, see <a href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services Service Catalog</a>. </p>', ], ], 'SessionExpirationDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'CreatePresignedDomainUrlRequest$SessionExpirationDurationInSeconds' => '<p>The session expiration duration in seconds. This value defaults to 43200.</p>', 'CreatePresignedNotebookInstanceUrlInput$SessionExpirationDurationInSeconds' => '<p>The duration of the session, in seconds. The default is 12 hours.</p>', ], ], 'SharingSettings' => [ 'base' => '<p>Specifies options for sharing SageMaker Studio notebooks. These settings are specified as part of <code>DefaultUserSettings</code> when the <code>CreateDomain</code> API is called, and as part of <code>UserSettings</code> when the <code>CreateUserProfile</code> API is called. When <code>SharingSettings</code> is not specified, notebook sharing isn\'t allowed.</p>', 'refs' => [ 'UserSettings$SharingSettings' => '<p>Specifies options for sharing SageMaker Studio notebooks.</p>', ], ], 'ShuffleConfig' => [ 'base' => '<p>A configuration for a shuffle option for input data in a channel. If you use <code>S3Prefix</code> for <code>S3DataType</code>, the results of the S3 key prefix matches are shuffled. If you use <code>ManifestFile</code>, the order of the S3 object references in the <code>ManifestFile</code> is shuffled. If you use <code>AugmentedManifestFile</code>, the order of the JSON lines in the <code>AugmentedManifestFile</code> is shuffled. The shuffling order is determined using the <code>Seed</code> value.</p> <p>For Pipe input mode, when <code>ShuffleConfig</code> is specified shuffling is done at the start of every epoch. With large datasets, this ensures that the order of the training data is different for each epoch, and it helps reduce bias and possible overfitting. In a multi-node training job when <code>ShuffleConfig</code> is combined with <code>S3DataDistributionType</code> of <code>ShardedByS3Key</code>, the data is shuffled across nodes so that the content sent to a particular node on the first epoch might be sent to a different node on the second epoch.</p>', 'refs' => [ 'Channel$ShuffleConfig' => '<p>A configuration for a shuffle option for input data in a channel. If you use <code>S3Prefix</code> for <code>S3DataType</code>, this shuffles the results of the S3 key prefix matches. If you use <code>ManifestFile</code>, the order of the S3 object references in the <code>ManifestFile</code> is shuffled. If you use <code>AugmentedManifestFile</code>, the order of the JSON lines in the <code>AugmentedManifestFile</code> is shuffled. The shuffling order is determined using the <code>Seed</code> value.</p> <p>For Pipe input mode, shuffling is done at the start of every epoch. With large datasets this ensures that the order of the training data is different for each epoch, it helps reduce bias and possible overfitting. In a multi-node training job when ShuffleConfig is combined with <code>S3DataDistributionType</code> of <code>ShardedByS3Key</code>, the data is shuffled across nodes so that the content sent to a particular node on the first epoch might be sent to a different node on the second epoch.</p>', ], ], 'SingleSignOnUserIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileRequest$SingleSignOnUserIdentifier' => '<p>A specifier for the type of value specified in SingleSignOnUserValue. Currently, the only supported value is "UserName". If the Domain\'s AuthMode is SSO, this field is required. If the Domain\'s AuthMode is not SSO, this field cannot be specified. </p>', 'DescribeUserProfileResponse$SingleSignOnUserIdentifier' => '<p>The SSO user identifier.</p>', ], ], 'SnsTopicArn' => [ 'base' => NULL, 'refs' => [ 'AsyncInferenceNotificationConfig$SuccessTopic' => '<p>Amazon SNS topic to post a notification to when inference completes successfully. If no topic is provided, no notification is sent on success.</p>', 'AsyncInferenceNotificationConfig$ErrorTopic' => '<p>Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification is sent on failure.</p>', 'LabelingJobOutputConfig$SnsTopicArn' => '<p>An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a <code>SnsTopicArn</code> if you want to do real time chaining to another streaming job and receive an Amazon SNS notifications each time a data object is submitted by a worker.</p> <p>If you provide an <code>SnsTopicArn</code> in <code>OutputConfig</code>, when workers complete labeling tasks, Ground Truth will send labeling task output data to the SNS output topic you specify here. </p> <p>To learn more, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data">Receive Output Data from a Streaming Labeling Job</a>. </p>', 'LabelingJobSnsDataSource$SnsTopicArn' => '<p>The Amazon SNS input topic Amazon Resource Name (ARN). Specify the ARN of the input topic you will use to send new data objects to a streaming labeling job.</p>', ], ], 'SortActionsBy' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SortArtifactsBy' => [ 'base' => NULL, 'refs' => [ 'ListArtifactsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SortAssociationsBy' => [ 'base' => NULL, 'refs' => [ 'ListAssociationsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SortBy' => [ 'base' => NULL, 'refs' => [ 'ListLabelingJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', 'ListProcessingJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', 'ListTrainingJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', 'ListTransformJobsRequest$SortBy' => '<p>The field to sort results by. The default is <code>CreationTime</code>.</p>', ], ], 'SortContextsBy' => [ 'base' => NULL, 'refs' => [ 'ListContextsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SortExperimentsBy' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SortLineageGroupsBy' => [ 'base' => NULL, 'refs' => [ 'ListLineageGroupsRequest$SortBy' => '<p>The parameter by which to sort the results. The default is <code>CreationTime</code>.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListAlgorithmsInput$SortOrder' => '<p>The sort order for the results. The default is <code>Ascending</code>.</p>', 'ListAppImageConfigsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListAppsRequest$SortOrder' => '<p>The sort order for the results. The default is Ascending.</p>', 'ListArtifactsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListAssociationsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListCompilationJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListContextsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListDataQualityJobDefinitionsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListDeviceFleetsRequest$SortOrder' => '<p>What direction to sort in.</p>', 'ListEdgePackagingJobsRequest$SortOrder' => '<p>What direction to sort by.</p>', 'ListExperimentsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListFlowDefinitionsRequest$SortOrder' => '<p>An optional value that specifies whether you want the results sorted in <code>Ascending</code> or <code>Descending</code> order.</p>', 'ListHumanTaskUisRequest$SortOrder' => '<p>An optional value that specifies whether you want the results sorted in <code>Ascending</code> or <code>Descending</code> order.</p>', 'ListHyperParameterTuningJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListInferenceRecommendationsJobsRequest$SortOrder' => '<p>The sort order for the results.</p>', 'ListLabelingJobsForWorkteamRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListLabelingJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListLineageGroupsRequest$SortOrder' => '<p>The sort order for the results. The default is <code>Ascending</code>.</p>', 'ListModelBiasJobDefinitionsRequest$SortOrder' => '<p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>', 'ListModelExplainabilityJobDefinitionsRequest$SortOrder' => '<p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>', 'ListModelPackageGroupsInput$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListModelPackagesInput$SortOrder' => '<p>The sort order for the results. The default is <code>Ascending</code>.</p>', 'ListModelQualityJobDefinitionsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListMonitoringExecutionsRequest$SortOrder' => '<p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>', 'ListMonitoringSchedulesRequest$SortOrder' => '<p>Whether to sort the results in <code>Ascending</code> or <code>Descending</code> order. The default is <code>Descending</code>.</p>', 'ListPipelineExecutionStepsRequest$SortOrder' => '<p>The field by which to sort results. The default is <code>CreatedTime</code>.</p>', 'ListPipelineExecutionsRequest$SortOrder' => '<p>The sort order for results.</p>', 'ListPipelinesRequest$SortOrder' => '<p>The sort order for results.</p>', 'ListProcessingJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListStudioLifecycleConfigsRequest$SortOrder' => '<p>The sort order. The default value is Descending.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListTrainingJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', 'ListTransformJobsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Descending</code>.</p>', 'ListTrialComponentsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListTrialsRequest$SortOrder' => '<p>The sort order. The default value is <code>Descending</code>.</p>', 'ListUserProfilesRequest$SortOrder' => '<p>The sort order for the results. The default is Ascending.</p>', 'ListWorkforcesRequest$SortOrder' => '<p>Sort workforces in ascending or descending order.</p>', 'ListWorkteamsRequest$SortOrder' => '<p>The sort order for results. The default is <code>Ascending</code>.</p>', ], ], 'SortPipelineExecutionsBy' => [ 'base' => NULL, 'refs' => [ 'ListPipelineExecutionsRequest$SortBy' => '<p>The field by which to sort results. The default is <code>CreatedTime</code>.</p>', ], ], 'SortPipelinesBy' => [ 'base' => NULL, 'refs' => [ 'ListPipelinesRequest$SortBy' => '<p>The field by which to sort results. The default is <code>CreatedTime</code>.</p>', ], ], 'SortTrialComponentsBy' => [ 'base' => NULL, 'refs' => [ 'ListTrialComponentsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SortTrialsBy' => [ 'base' => NULL, 'refs' => [ 'ListTrialsRequest$SortBy' => '<p>The property used to sort results. The default value is <code>CreationTime</code>.</p>', ], ], 'SourceAlgorithm' => [ 'base' => '<p>Specifies an algorithm that was used to create the model package. The algorithm must be either an algorithm resource in your Amazon SageMaker account or an algorithm in Amazon Web Services Marketplace that you are subscribed to.</p>', 'refs' => [ 'SourceAlgorithmList$member' => NULL, ], ], 'SourceAlgorithmList' => [ 'base' => NULL, 'refs' => [ 'SourceAlgorithmSpecification$SourceAlgorithms' => '<p>A list of the algorithms that were used to create a model package.</p>', ], ], 'SourceAlgorithmSpecification' => [ 'base' => '<p>A list of algorithms that were used to create a model package.</p>', 'refs' => [ 'CreateModelPackageInput$SourceAlgorithmSpecification' => '<p>Details about the algorithm that was used to create the model package.</p>', 'DescribeModelPackageOutput$SourceAlgorithmSpecification' => '<p>Details about the algorithm that was used to create the model package.</p>', 'ModelPackage$SourceAlgorithmSpecification' => NULL, ], ], 'SourceIpConfig' => [ 'base' => '<p>A list of IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Used to create an allow list of IP addresses for a private workforce. Workers will only be able to login to their worker portal from an IP address within this range. By default, a workforce isn\'t restricted to specific IP addresses.</p>', 'refs' => [ 'CreateWorkforceRequest$SourceIpConfig' => NULL, 'UpdateWorkforceRequest$SourceIpConfig' => '<p>A list of one to ten worker IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) that can be used to access tasks assigned to this workforce.</p> <p>Maximum: Ten CIDR values</p>', 'Workforce$SourceIpConfig' => '<p>A list of one to ten IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to be added to the workforce allow list. By default, a workforce isn\'t restricted to specific IP addresses.</p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'ExperimentSource$SourceType' => '<p>The source type.</p>', 'TrialComponentSource$SourceType' => '<p>The source job type.</p>', 'TrialSource$SourceType' => '<p>The source job type.</p>', ], ], 'SourceUri' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$SourceUri' => '<p>A filter that returns only actions with the specified source URI.</p>', 'ListArtifactsRequest$SourceUri' => '<p>A filter that returns only artifacts with the specified source URI.</p>', 'ListContextsRequest$SourceUri' => '<p>A filter that returns only contexts with the specified source URI.</p>', ], ], 'SpawnRate' => [ 'base' => NULL, 'refs' => [ 'Phase$SpawnRate' => '<p>Specified how many new users to spawn in a minute.</p>', ], ], 'SplitType' => [ 'base' => NULL, 'refs' => [ 'TransformInput$SplitType' => '<p>The method to use to split the transform job\'s data files into smaller batches. Splitting is necessary when the total size of each object is too large to fit in a single request. You can also use data splitting to improve performance by processing multiple concurrent mini-batches. The default value for <code>SplitType</code> is <code>None</code>, which indicates that input data files are not split, and request payloads contain the entire contents of an input object. Set the value of this parameter to <code>Line</code> to split records on a newline character boundary. <code>SplitType</code> also supports a number of record-oriented binary data formats. Currently, the supported record formats are:</p> <ul> <li> <p>RecordIO</p> </li> <li> <p>TFRecord</p> </li> </ul> <p>When splitting is enabled, the size of a mini-batch depends on the values of the <code>BatchStrategy</code> and <code>MaxPayloadInMB</code> parameters. When the value of <code>BatchStrategy</code> is <code>MultiRecord</code>, Amazon SageMaker sends the maximum number of records in each request, up to the <code>MaxPayloadInMB</code> limit. If the value of <code>BatchStrategy</code> is <code>SingleRecord</code>, Amazon SageMaker sends individual records in each request.</p> <note> <p>Some data formats represent a record as a binary payload wrapped with extra padding bytes. When splitting is applied to a binary data format, padding is removed if the value of <code>BatchStrategy</code> is set to <code>SingleRecord</code>. Padding is not removed if the value of <code>BatchStrategy</code> is set to <code>MultiRecord</code>.</p> <p>For more information about <code>RecordIO</code>, see <a href="https://mxnet.apache.org/api/faq/recordio">Create a Dataset Using RecordIO</a> in the MXNet documentation. For more information about <code>TFRecord</code>, see <a href="https://www.tensorflow.org/guide/data#consuming_tfrecord_data">Consuming TFRecord data</a> in the TensorFlow documentation.</p> </note>', ], ], 'StartMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'StartPipelineExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartPipelineExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatusDetails' => [ 'base' => NULL, 'refs' => [ 'DebugRuleEvaluationStatus$StatusDetails' => '<p>Details from the rule evaluation.</p>', 'ProfilerRuleEvaluationStatus$StatusDetails' => '<p>Details from the rule evaluation.</p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'SecondaryStatusTransition$StatusMessage' => '<p>A detailed description of the progress within a secondary status. </p> <p>Amazon SageMaker provides secondary statuses and status messages that apply to each of them:</p> <dl> <dt>Starting</dt> <dd> <ul> <li> <p>Starting the training job.</p> </li> <li> <p>Launching requested ML instances.</p> </li> <li> <p>Insufficient capacity error from EC2 while launching instances, retrying!</p> </li> <li> <p>Launched instance was unhealthy, replacing it!</p> </li> <li> <p>Preparing the instances for training.</p> </li> </ul> </dd> <dt>Training</dt> <dd> <ul> <li> <p>Downloading the training image.</p> </li> <li> <p>Training image download completed. Training in progress.</p> </li> </ul> </dd> </dl> <important> <p>Status messages are subject to change. Therefore, we recommend not including them in code that programmatically initiates actions. For examples, don\'t use status messages in if statements.</p> </important> <p>To have an overview of your training job\'s progress, view <code>TrainingJobStatus</code> and <code>SecondaryStatus</code> in <a>DescribeTrainingJob</a>, and <code>StatusMessage</code> together. For example, at the start of a training job, you might see the following:</p> <ul> <li> <p> <code>TrainingJobStatus</code> - InProgress</p> </li> <li> <p> <code>SecondaryStatus</code> - Training</p> </li> <li> <p> <code>StatusMessage</code> - Downloading the training image</p> </li> </ul>', ], ], 'StepDescription' => [ 'base' => NULL, 'refs' => [ 'PipelineExecutionStep$StepDescription' => '<p>The description of the step.</p>', ], ], 'StepDisplayName' => [ 'base' => NULL, 'refs' => [ 'PipelineExecutionStep$StepDisplayName' => '<p>The display name of the step.</p>', ], ], 'StepName' => [ 'base' => NULL, 'refs' => [ 'PipelineExecutionStep$StepName' => '<p>The name of the step that is executed.</p>', ], ], 'StepStatus' => [ 'base' => NULL, 'refs' => [ 'PipelineExecutionStep$StepStatus' => '<p>The status of the step execution.</p>', ], ], 'StopAutoMLJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopCompilationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopEdgePackagingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopHyperParameterTuningJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopInferenceRecommendationsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopLabelingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'StopPipelineExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopPipelineExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopProcessingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTrainingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopTransformJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StoppingCondition' => [ 'base' => '<p>Specifies a limit to how long a model training job or model compilation job can run. It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training or compilation job. Use this API to cap model training costs.</p> <p>To stop a training job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p> <p>The training algorithms provided by Amazon SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with <code>CreateModel</code>.</p> <note> <p>The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.</p> </note>', 'refs' => [ 'CreateCompilationJobRequest$StoppingCondition' => '<p>Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training costs.</p>', 'CreateTrainingJobRequest$StoppingCondition' => '<p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>', 'DescribeCompilationJobResponse$StoppingCondition' => '<p>Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon SageMaker ends the compilation job. Use this API to cap model training costs.</p>', 'DescribeTrainingJobResponse$StoppingCondition' => '<p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>', 'HyperParameterTrainingJobDefinition$StoppingCondition' => '<p>Specifies a limit to how long a model hyperparameter training job can run. It also specifies how long a managed spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>', 'TrainingJob$StoppingCondition' => '<p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost. </p>', 'TrainingJobDefinition$StoppingCondition' => '<p>Specifies a limit to how long a model training job can run. It also specifies how long a managed Spot training job has to complete. When the job reaches the time limit, Amazon SageMaker ends the training job. Use this API to cap model training costs.</p> <p>To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AlgorithmStatusItem$FailureReason' => '<p>if the overall status is <code>Failed</code>, the reason for the failure.</p>', 'BatchDescribeModelPackageError$ErrorCode' => '<p/>', 'BatchDescribeModelPackageError$ErrorResponse' => '<p/>', 'CreateModelPackageInput$Domain' => '<p>The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.</p>', 'CreateModelPackageInput$Task' => '<p>The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.</p>', 'DescribeEdgePackagingJobResponse$EdgePackagingJobStatusMessage' => '<p>Returns a message describing the job status and error messages.</p>', 'DescribeEdgePackagingJobResponse$ModelSignature' => '<p>The signature document of files in the model artifact.</p>', 'DescribeModelPackageOutput$Domain' => '<p>The machine learning domain of the model package you specified. Common machine learning domains include computer vision and natural language processing.</p>', 'DescribeModelPackageOutput$Task' => '<p>The machine learning task you specified that your model package accomplishes. Common machine learning tasks include object detection and image classification.</p>', 'DescribeModelPackageOutput$SamplePayloadUrl' => '<p>The Amazon Simple Storage Service (Amazon S3) path where the sample payload are stored. This path points to a single gzip compressed tar archive (.tar.gz suffix).</p>', 'EdgeOutputConfig$PresetDeploymentConfig' => '<p>The configuration used to create deployment artifacts. Specify configuration options with a JSON string. The available configuration options for each type are:</p> <ul> <li> <p> <code>ComponentName</code> (optional) - Name of the GreenGrass V2 component. If not specified, the default name generated consists of "SagemakerEdgeManager" and the name of your SageMaker Edge Manager packaging job.</p> </li> <li> <p> <code>ComponentDescription</code> (optional) - Description of the component.</p> </li> <li> <p> <code>ComponentVersion</code> (optional) - The version of the component.</p> <note> <p>Amazon Web Services IoT Greengrass uses semantic versions for components. Semantic versions follow a<i> major.minor.patch</i> number system. For example, version 1.0.0 represents the first major release for a component. For more information, see the <a href="https://semver.org/">semantic version specification</a>.</p> </note> </li> <li> <p> <code>PlatformOS</code> (optional) - The name of the operating system for the platform. Supported platforms include Windows and Linux.</p> </li> <li> <p> <code>PlatformArchitecture</code> (optional) - The processor architecture for the platform. </p> <p>Supported architectures Windows include: Windows32_x86, Windows64_x64.</p> <p>Supported architectures for Linux include: Linux x86_64, Linux ARMV8.</p> </li> </ul>', 'EdgePresetDeploymentOutput$StatusMessage' => '<p>Returns a message describing the status of the deployed resource.</p>', 'EndpointInput$FeaturesAttribute' => '<p>The attributes of the input data that are the input features.</p>', 'EndpointInput$InferenceAttribute' => '<p>The attribute of the input data that represents the ground truth label.</p>', 'EndpointInput$ProbabilityAttribute' => '<p>In a classification problem, the attribute that represents the class probability.</p>', 'EndpointOutputConfiguration$EndpointName' => '<p>The name of the endpoint made during a recommendation job.</p>', 'EndpointOutputConfiguration$VariantName' => '<p>The name of the production variant (deployed model) made during a recommendation job.</p>', 'EnvironmentParameter$Key' => '<p>The environment key suggested by the Amazon SageMaker Inference Recommender.</p>', 'EnvironmentParameter$ValueType' => '<p>The value type suggested by the Amazon SageMaker Inference Recommender.</p>', 'EnvironmentParameter$Value' => '<p>The value suggested by the Amazon SageMaker Inference Recommender.</p>', 'ListProcessingJobsRequest$NameContains' => '<p>A string in the processing job name. This filter returns only processing jobs whose name contains the specified string.</p>', 'ModelMetadataSummary$Domain' => '<p>The machine learning domain of the model.</p>', 'ModelMetadataSummary$Framework' => '<p>The machine learning framework of the model.</p>', 'ModelMetadataSummary$Task' => '<p>The machine learning task of the model.</p>', 'ModelMetadataSummary$Model' => '<p>The name of the model.</p>', 'ModelMetadataSummary$FrameworkVersion' => '<p>The framework version of the model.</p>', 'ModelPackage$Domain' => '<p>The machine learning domain of your model package and its components. Common machine learning domains include computer vision and natural language processing.</p>', 'ModelPackage$Task' => '<p>The machine learning task your model package accomplishes. Common machine learning tasks include object detection and image classification.</p>', 'ModelPackage$SamplePayloadUrl' => '<p>The Amazon Simple Storage Service path where the sample payload are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix).</p>', 'ModelPackageContainerDefinition$Framework' => '<p>The machine learning framework of the model package container image.</p>', 'ModelPackageContainerDefinition$NearestModelName' => '<p>The name of a pre-trained machine learning benchmarked by Amazon SageMaker Inference Recommender model that matches your model. You can find a list of benchmarked models by calling <code>ListModelMetadata</code>.</p>', 'ModelPackageStatusItem$FailureReason' => '<p>if the overall status is <code>Failed</code>, the reason for the failure.</p>', 'ProcessingInput$InputName' => '<p>The name for the processing job input.</p>', 'ProcessingOutput$OutputName' => '<p>The name for the processing job output.</p>', 'ProductListings$member' => NULL, 'RStudioServerProDomainSettings$RStudioConnectUrl' => '<p>A URL pointing to an RStudio Connect server.</p>', 'RStudioServerProDomainSettings$RStudioPackageManagerUrl' => '<p>A URL pointing to an RStudio Package Manager server.</p>', 'RenderUiTemplateResponse$RenderedContent' => '<p>A Liquid template that renders the HTML for the worker UI.</p>', 'RenderingError$Code' => '<p>A unique identifier for a specific class of errors.</p>', 'RenderingError$Message' => '<p>A human-readable message describing the error.</p>', 'SubscribedWorkteam$SellerName' => '<p>The name of the vendor in the Amazon Marketplace.</p>', 'SubscribedWorkteam$ListingId' => '<p>Marketplace product listing ID.</p>', 'UserContext$UserProfileArn' => '<p>The Amazon Resource Name (ARN) of the user\'s profile.</p>', 'UserContext$UserProfileName' => '<p>The name of the user\'s profile.</p>', 'UserContext$DomainId' => '<p>The domain associated with the user.</p>', 'Workforce$SubDomain' => '<p>The subdomain for your OIDC Identity Provider.</p>', 'Workteam$SubDomain' => '<p>The URI of the labeling job\'s user interface. Workers open this URI to start labeling your data objects.</p>', ], ], 'String1024' => [ 'base' => NULL, 'refs' => [ 'ClarifyCheckStepMetadata$BaselineUsedForDriftCheckConstraints' => '<p>The Amazon S3 URI of baseline constraints file to be used for the drift check.</p>', 'ClarifyCheckStepMetadata$CalculatedBaselineConstraints' => '<p>The Amazon S3 URI of the newly calculated baseline constraints file.</p>', 'ClarifyCheckStepMetadata$ViolationReport' => '<p>The Amazon S3 URI of the violation report if violations are detected.</p>', 'CreateDomainResponse$Url' => '<p>The URL to the created domain.</p>', 'DescribeDomainResponse$Url' => '<p>The domain\'s URL.</p>', 'DomainDetails$Url' => '<p>The domain\'s URL.</p>', 'EMRStepMetadata$LogFilePath' => '<p>The path to the log file where the cluster step\'s failure root cause is recorded.</p>', 'OutputParameter$Value' => '<p>The value of the output parameter.</p>', 'Parameter$Value' => '<p>The literal value for the parameter.</p>', 'QualityCheckStepMetadata$BaselineUsedForDriftCheckStatistics' => '<p>The Amazon S3 URI of the baseline statistics file used for the drift check.</p>', 'QualityCheckStepMetadata$BaselineUsedForDriftCheckConstraints' => '<p>The Amazon S3 URI of the baseline constraints file used for the drift check.</p>', 'QualityCheckStepMetadata$CalculatedBaselineStatistics' => '<p>The Amazon S3 URI of the newly calculated baseline statistics file.</p>', 'QualityCheckStepMetadata$CalculatedBaselineConstraints' => '<p>The Amazon S3 URI of the newly calculated baseline constraints file.</p>', 'QualityCheckStepMetadata$ViolationReport' => '<p>The Amazon S3 URI of violation report if violations are detected.</p>', ], ], 'String128' => [ 'base' => NULL, 'refs' => [ 'CategoricalParameterRangeValues$member' => NULL, ], ], 'String200' => [ 'base' => NULL, 'refs' => [ 'CreateWorkteamRequest$Description' => '<p>A description of the work team.</p>', 'SubscribedWorkteam$MarketplaceTitle' => '<p>The title of the service provided by the vendor in the Amazon Marketplace.</p>', 'SubscribedWorkteam$MarketplaceDescription' => '<p>The description of the vendor from the Amazon Marketplace.</p>', 'UpdateWorkteamRequest$Description' => '<p>An updated description for the work team.</p>', 'Workteam$Description' => '<p>A description of the work team.</p>', ], ], 'String2048' => [ 'base' => NULL, 'refs' => [ 'ActionSource$SourceUri' => '<p>The URI of the source.</p>', 'ArtifactSource$SourceUri' => '<p>The URI of the source.</p>', 'ContextSource$SourceUri' => '<p>The URI of the source.</p>', ], ], 'String256' => [ 'base' => NULL, 'refs' => [ 'ActionSource$SourceType' => '<p>The type of the source.</p>', 'ActionSource$SourceId' => '<p>The ID of the source.</p>', 'ArtifactSourceType$Value' => '<p>The ID.</p>', 'ArtifactSummary$ArtifactType' => '<p>The type of the artifact.</p>', 'AssociationSummary$SourceType' => '<p>The source type.</p>', 'AssociationSummary$DestinationType' => '<p>The destination type.</p>', 'CallbackStepMetadata$SqsQueueUrl' => '<p>The URL of the Amazon Simple Queue Service (Amazon SQS) queue used by the callback step.</p>', 'ClarifyCheckStepMetadata$CheckType' => '<p>The type of the Clarify Check step</p>', 'ClarifyCheckStepMetadata$ModelPackageGroupName' => '<p>The model package group name.</p>', 'ClarifyCheckStepMetadata$CheckJobArn' => '<p>The Amazon Resource Name (ARN) of the check processing job that was run by this step\'s execution.</p>', 'ContextSource$SourceType' => '<p>The type of the source.</p>', 'ContextSource$SourceId' => '<p>The ID of the source.</p>', 'ContextSummary$ContextType' => '<p>The type of the context.</p>', 'CreateActionRequest$ActionType' => '<p>The action type.</p>', 'CreateArtifactRequest$ArtifactType' => '<p>The artifact type.</p>', 'CreateContextRequest$ContextType' => '<p>The context type.</p>', 'CreateUserProfileRequest$SingleSignOnUserValue' => '<p>The username of the associated Amazon Web Services Single Sign-On User for this UserProfile. If the Domain\'s AuthMode is SSO, this field is required, and must match a valid username of a user in your directory. If the Domain\'s AuthMode is not SSO, this field cannot be specified. </p>', 'DescribeActionResponse$ActionType' => '<p>The type of the action.</p>', 'DescribeArtifactResponse$ArtifactType' => '<p>The type of the artifact.</p>', 'DescribeContextResponse$ContextType' => '<p>The type of the context.</p>', 'DescribeDomainResponse$SingleSignOnManagedApplicationInstanceId' => '<p>The SSO managed application instance ID.</p>', 'DescribeUserProfileResponse$SingleSignOnUserValue' => '<p>The SSO user value.</p>', 'EMRStepMetadata$ClusterId' => '<p>The identifier of the EMR cluster.</p>', 'EMRStepMetadata$StepId' => '<p>The identifier of the EMR cluster step.</p>', 'EMRStepMetadata$StepName' => '<p>The name of the EMR cluster step.</p>', 'LambdaStepMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the Lambda function that was run by this step execution.</p>', 'ListActionsRequest$ActionType' => '<p>A filter that returns only actions of the specified type.</p>', 'ListArtifactsRequest$ArtifactType' => '<p>A filter that returns only artifacts of the specified type.</p>', 'ListAssociationsRequest$SourceType' => '<p>A filter that returns only associations with the specified source type.</p>', 'ListAssociationsRequest$DestinationType' => '<p>A filter that returns only associations with the specified destination type.</p>', 'ListContextsRequest$ContextType' => '<p>A filter that returns only contexts of the specified type.</p>', 'ListTrialComponentsRequest$SourceArn' => '<p>A filter that returns only components that have the specified source Amazon Resource Name (ARN). If you specify <code>SourceArn</code>, you can\'t filter by <code>ExperimentName</code> or <code>TrialName</code>.</p>', 'ModelMetadataFilter$Value' => '<p>The value to filter the model metadata.</p>', 'ModelStepMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the created model.</p>', 'OutputParameter$Name' => '<p>The name of the output parameter.</p>', 'QualityCheckStepMetadata$CheckType' => '<p>The type of the Quality check step.</p>', 'QualityCheckStepMetadata$ModelPackageGroupName' => '<p>The model package group name.</p>', 'QualityCheckStepMetadata$CheckJobArn' => '<p>The Amazon Resource Name (ARN) of the Quality check processing job that was run by this step execution.</p>', 'QueryProperties$key' => NULL, 'QueryProperties$value' => NULL, 'RegisterModelStepMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the model package.</p>', 'SendPipelineExecutionStepFailureRequest$FailureReason' => '<p>A message describing why the step failed.</p>', ], ], 'String3072' => [ 'base' => NULL, 'refs' => [ 'FailStepMetadata$ErrorMessage' => '<p>A message that you define and then is processed and rendered by the Fail step when the error occurs.</p>', 'PipelineExecutionSummary$PipelineExecutionFailureReason' => '<p>A message generated by SageMaker Pipelines describing why the pipeline execution failed.</p>', ], ], 'String40' => [ 'base' => NULL, 'refs' => [ 'QueryTypes$member' => NULL, 'Vertex$Type' => '<p>The type of the lineage entity resource. For example: <code>DataSet</code>, <code>Model</code>, <code>Endpoint</code>, etc...</p>', ], ], 'String64' => [ 'base' => NULL, 'refs' => [ 'ActionSummary$ActionType' => '<p>The type of the action.</p>', 'CategoricalParameter$Name' => '<p>The Name of the environment variable.</p>', 'ModelLatencyThreshold$Percentile' => '<p>The model latency percentile threshold.</p>', ], ], 'String8192' => [ 'base' => NULL, 'refs' => [ 'QueryLineageRequest$NextToken' => '<p>Limits the number of vertices in the request. Use the <code>NextToken</code> in a response to to retrieve the next page of results.</p>', 'QueryLineageResponse$NextToken' => '<p>Limits the number of vertices in the response. Use the <code>NextToken</code> in a response to to retrieve the next page of results.</p>', ], ], 'StringParameterValue' => [ 'base' => NULL, 'refs' => [ 'LineageEntityParameters$key' => NULL, 'LineageEntityParameters$value' => NULL, 'ListLineageEntityParameterKey$member' => NULL, 'TrialComponentParameterValue$StringValue' => '<p>The string value of a categorical hyperparameter. If you specify a value for this parameter, you can\'t specify the <code>NumberValue</code> parameter.</p>', ], ], 'StudioLifecycleConfigAppType' => [ 'base' => NULL, 'refs' => [ 'CreateStudioLifecycleConfigRequest$StudioLifecycleConfigAppType' => '<p>The App type that the Lifecycle Configuration is attached to.</p>', 'DescribeStudioLifecycleConfigResponse$StudioLifecycleConfigAppType' => '<p>The App type that the Lifecycle Configuration is attached to.</p>', 'ListStudioLifecycleConfigsRequest$AppTypeEquals' => '<p>A parameter to search for the App Type to which the Lifecycle Configuration is attached.</p>', 'StudioLifecycleConfigDetails$StudioLifecycleConfigAppType' => '<p>The App type to which the Lifecycle Configuration is attached.</p>', ], ], 'StudioLifecycleConfigArn' => [ 'base' => NULL, 'refs' => [ 'CreateStudioLifecycleConfigResponse$StudioLifecycleConfigArn' => '<p>The ARN of your created Lifecycle Configuration.</p>', 'DescribeStudioLifecycleConfigResponse$StudioLifecycleConfigArn' => '<p>The ARN of the Lifecycle Configuration to describe.</p>', 'LifecycleConfigArns$member' => NULL, 'ResourceSpec$LifecycleConfigArn' => '<p> The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.</p>', 'StudioLifecycleConfigDetails$StudioLifecycleConfigArn' => '<p> The Amazon Resource Name (ARN) of the Lifecycle Configuration.</p>', ], ], 'StudioLifecycleConfigContent' => [ 'base' => NULL, 'refs' => [ 'CreateStudioLifecycleConfigRequest$StudioLifecycleConfigContent' => '<p>The content of your Studio Lifecycle Configuration script. This content must be base64 encoded.</p>', 'DescribeStudioLifecycleConfigResponse$StudioLifecycleConfigContent' => '<p>The content of your Studio Lifecycle Configuration script.</p>', ], ], 'StudioLifecycleConfigDetails' => [ 'base' => '<p>Details of the Studio Lifecycle Configuration.</p>', 'refs' => [ 'StudioLifecycleConfigsList$member' => NULL, ], ], 'StudioLifecycleConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateStudioLifecycleConfigRequest$StudioLifecycleConfigName' => '<p>The name of the Studio Lifecycle Configuration to create.</p>', 'DeleteStudioLifecycleConfigRequest$StudioLifecycleConfigName' => '<p>The name of the Studio Lifecycle Configuration to delete.</p>', 'DescribeStudioLifecycleConfigRequest$StudioLifecycleConfigName' => '<p>The name of the Studio Lifecycle Configuration to describe.</p>', 'DescribeStudioLifecycleConfigResponse$StudioLifecycleConfigName' => '<p>The name of the Studio Lifecycle Configuration that is described.</p>', 'ListStudioLifecycleConfigsRequest$NameContains' => '<p>A string in the Lifecycle Configuration name. This filter returns only Lifecycle Configurations whose name contains the specified string.</p>', 'StudioLifecycleConfigDetails$StudioLifecycleConfigName' => '<p>The name of the Studio Lifecycle Configuration.</p>', ], ], 'StudioLifecycleConfigSortKey' => [ 'base' => NULL, 'refs' => [ 'ListStudioLifecycleConfigsRequest$SortBy' => '<p>The property used to sort results. The default value is CreationTime.</p>', ], ], 'StudioLifecycleConfigsList' => [ 'base' => NULL, 'refs' => [ 'ListStudioLifecycleConfigsResponse$StudioLifecycleConfigs' => '<p>A list of Lifecycle Configurations and their properties.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'CreateNotebookInstanceInput$SubnetId' => '<p>The ID of the subnet in a VPC to which you would like to have a connectivity from your ML compute instance. </p>', 'DescribeNotebookInstanceOutput$SubnetId' => '<p>The ID of the VPC subnet.</p>', 'Subnets$member' => NULL, ], ], 'Subnets' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$SubnetIds' => '<p>The VPC subnets that Studio uses for communication.</p>', 'DescribeDomainResponse$SubnetIds' => '<p>The VPC subnets that Studio uses for communication.</p>', 'VpcConfig$Subnets' => '<p>The ID of the subnets in the VPC to which you want to connect your training job or model. For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a>.</p>', ], ], 'SubscribedWorkteam' => [ 'base' => '<p>Describes a work team of a vendor that does the a labelling job.</p>', 'refs' => [ 'DescribeSubscribedWorkteamResponse$SubscribedWorkteam' => '<p>A <code>Workteam</code> instance that contains information about the work team.</p>', 'SubscribedWorkteams$member' => NULL, ], ], 'SubscribedWorkteams' => [ 'base' => NULL, 'refs' => [ 'ListSubscribedWorkteamsResponse$SubscribedWorkteams' => '<p>An array of <code>Workteam</code> objects, each describing a work team.</p>', ], ], 'Success' => [ 'base' => NULL, 'refs' => [ 'DeleteWorkteamResponse$Success' => '<p>Returns <code>true</code> if the work team was successfully deleted; otherwise, returns <code>false</code>.</p>', ], ], 'SuggestionQuery' => [ 'base' => '<p>Specified in the <a>GetSearchSuggestions</a> request. Limits the property names that are included in the response.</p>', 'refs' => [ 'GetSearchSuggestionsRequest$SuggestionQuery' => '<p>Limits the property names that are included in the response.</p>', ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'DataCatalogConfig$TableName' => '<p>The name of the Glue table.</p>', ], ], 'Tag' => [ 'base' => '<p>A tag object that consists of a key and an optional value, used to manage metadata for SageMaker Amazon Web Services resources.</p> <p>You can add tags to notebook instances, training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint configurations, and endpoints. For more information on adding tags to SageMaker resources, see <a>AddTags</a>.</p> <p>For more information on adding metadata to your Amazon Web Services resources with tagging, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>. For advice on best practices for managing Amazon Web Services resources with tagging, see <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging Best Practices: Implement an Effective Amazon Web Services Resource Tagging Strategy</a>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The tag key. Tag keys must be unique per resource.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'DeleteTagsInput$TagKeys' => '<p>An array or one or more tag keys to delete.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'AddTagsOutput$Tags' => '<p>A list of tags associated with the Amazon SageMaker resource.</p>', 'CreateActionRequest$Tags' => '<p>A list of tags to apply to the action.</p>', 'CreateAlgorithmInput$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'CreateAppImageConfigRequest$Tags' => '<p>A list of tags to apply to the AppImageConfig.</p>', 'CreateAppRequest$Tags' => '<p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>', 'CreateArtifactRequest$Tags' => '<p>A list of tags to apply to the artifact.</p>', 'CreateAutoMLJobRequest$Tags' => '<p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p>', 'CreateCodeRepositoryInput$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'CreateCompilationJobRequest$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'CreateContextRequest$Tags' => '<p>A list of tags to apply to the context.</p>', 'CreateDataQualityJobDefinitionRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'CreateDeviceFleetRequest$Tags' => '<p>Creates tags for the specified fleet.</p>', 'CreateDomainRequest$Tags' => '<p>Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the <code>Search</code> API.</p> <p>Tags that you specify for the Domain are also added to all Apps that the Domain launches.</p>', 'CreateEdgePackagingJobRequest$Tags' => '<p>Creates tags for the packaging job.</p>', 'CreateEndpointConfigInput$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'CreateEndpointInput$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'CreateExperimentRequest$Tags' => '<p>A list of tags to associate with the experiment. You can use <a>Search</a> API to search on the tags.</p>', 'CreateFeatureGroupRequest$Tags' => '<p>Tags used to identify <code>Features</code> in each <code>FeatureGroup</code>.</p>', 'CreateFlowDefinitionRequest$Tags' => '<p>An array of key-value pairs that contain metadata to help you categorize and organize a flow definition. Each tag consists of a key and a value, both of which you define.</p>', 'CreateHumanTaskUiRequest$Tags' => '<p>An array of key-value pairs that contain metadata to help you categorize and organize a human review workflow user interface. Each tag consists of a key and a value, both of which you define.</p>', 'CreateHyperParameterTuningJobRequest$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p> <p>Tags that you specify for the tuning job are also added to all training jobs that the tuning job launches.</p>', 'CreateImageRequest$Tags' => '<p>A list of tags to apply to the image.</p>', 'CreateInferenceRecommendationsJobRequest$Tags' => '<p>The metadata that you apply to Amazon Web Services resources to help you categorize and organize them. Each tag consists of a key and a value, both of which you define. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in the Amazon Web Services General Reference.</p>', 'CreateLabelingJobRequest$Tags' => '<p>An array of key/value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'CreateModelBiasJobDefinitionRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'CreateModelExplainabilityJobDefinitionRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'CreateModelInput$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'CreateModelPackageGroupInput$Tags' => '<p>A list of key value pairs associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>', 'CreateModelPackageInput$Tags' => '<p>A list of key value pairs associated with the model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>', 'CreateModelQualityJobDefinitionRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'CreateMonitoringScheduleRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href=" https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'CreateNotebookInstanceInput$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'CreatePipelineRequest$Tags' => '<p>A list of tags to apply to the created pipeline.</p>', 'CreateProcessingJobRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'CreateProjectInput$Tags' => '<p>An array of key-value pairs that you want to use to organize and track your Amazon Web Services resource costs. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>', 'CreateStudioLifecycleConfigRequest$Tags' => '<p>Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API. </p>', 'CreateTrainingJobRequest$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'CreateTransformJobRequest$Tags' => '<p>(Optional) An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'CreateTrialComponentRequest$Tags' => '<p>A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.</p>', 'CreateTrialRequest$Tags' => '<p>A list of tags to associate with the trial. You can use <a>Search</a> API to search on the tags.</p>', 'CreateUserProfileRequest$Tags' => '<p>Each tag consists of a key and an optional value. Tag keys must be unique per resource.</p> <p>Tags that you specify for the User Profile are also added to all Apps that the User Profile launches.</p>', 'CreateWorkforceRequest$Tags' => '<p>An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag consists of a key and a value, both of which you define.</p>', 'CreateWorkteamRequest$Tags' => '<p>An array of key-value pairs.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Resource Tag</a> and <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using Cost Allocation Tags</a> in the <i> Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'DescribeLabelingJobResponse$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'Endpoint$Tags' => '<p>A list of the tags associated with the endpoint. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>', 'Experiment$Tags' => '<p>The list of tags that are associated with the experiment. You can use <a>Search</a> API to search on the tags.</p>', 'FeatureGroup$Tags' => '<p>Tags used to define a <code>FeatureGroup</code>.</p>', 'ListTagsOutput$Tags' => '<p>An array of <code>Tag</code> objects, each with a tag key and a value.</p>', 'ModelPackage$Tags' => '<p>A list of the tags associated with the model package. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>', 'ModelPackageGroup$Tags' => '<p>A list of the tags associated with the model group. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>', 'MonitoringSchedule$Tags' => '<p>A list of the tags associated with the monitoring schedlue. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>', 'Pipeline$Tags' => '<p>A list of tags that apply to the pipeline.</p>', 'ProcessingJob$Tags' => '<p>An array of key-value pairs. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using Cost Allocation Tags</a> in the <i>Amazon Web Services Billing and Cost Management User Guide</i>.</p>', 'Project$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'RegisterDevicesRequest$Tags' => '<p>The tags associated with devices.</p>', 'TrainingJob$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', 'TransformJob$Tags' => '<p>A list of tags associated with the transform job.</p>', 'Trial$Tags' => '<p>The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the tags.</p>', 'TrialComponent$Tags' => '<p>The list of tags that are associated with the component. You can use <a>Search</a> API to search on the tags.</p>', 'UpdateProjectInput$Tags' => '<p>An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.</p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The tag value.</p>', ], ], 'TargetAttributeName' => [ 'base' => NULL, 'refs' => [ 'AutoMLChannel$TargetAttributeName' => '<p>The name of the target variable in supervised learning, usually represented by \'y\'.</p>', ], ], 'TargetDevice' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationTargetDevice' => '<p>The type of device that the model will run on after the compilation job has completed.</p>', 'OutputConfig$TargetDevice' => '<p>Identifies the target device or the machine learning instance that you want to run your model on after the compilation has completed. Alternatively, you can specify OS, architecture, and accelerator using <a>TargetPlatform</a> fields. It can be used instead of <code>TargetPlatform</code>.</p>', ], ], 'TargetObjectiveMetricValue' => [ 'base' => NULL, 'refs' => [ 'TuningJobCompletionCriteria$TargetObjectiveMetricValue' => '<p>The value of the objective metric.</p>', ], ], 'TargetPlatform' => [ 'base' => '<p>Contains information about a target platform that you want your model to run on, such as OS, architecture, and accelerators. It is an alternative of <code>TargetDevice</code>.</p>', 'refs' => [ 'OutputConfig$TargetPlatform' => '<p>Contains information about a target platform that you want your model to run on, such as OS, architecture, and accelerators. It is an alternative of <code>TargetDevice</code>.</p> <p>The following examples show how to configure the <code>TargetPlatform</code> and <code>CompilerOptions</code> JSON strings for popular target platforms: </p> <ul> <li> <p>Raspberry Pi 3 Model B+</p> <p> <code>"TargetPlatform": {"Os": "LINUX", "Arch": "ARM_EABIHF"},</code> </p> <p> <code> "CompilerOptions": {\'mattr\': [\'+neon\']}</code> </p> </li> <li> <p>Jetson TX2</p> <p> <code>"TargetPlatform": {"Os": "LINUX", "Arch": "ARM64", "Accelerator": "NVIDIA"},</code> </p> <p> <code> "CompilerOptions": {\'gpu-code\': \'sm_62\', \'trt-ver\': \'6.0.1\', \'cuda-ver\': \'10.0\'}</code> </p> </li> <li> <p>EC2 m5.2xlarge instance OS</p> <p> <code>"TargetPlatform": {"Os": "LINUX", "Arch": "X86_64", "Accelerator": "NVIDIA"},</code> </p> <p> <code> "CompilerOptions": {\'mcpu\': \'skylake-avx512\'}</code> </p> </li> <li> <p>RK3399</p> <p> <code>"TargetPlatform": {"Os": "LINUX", "Arch": "ARM64", "Accelerator": "MALI"}</code> </p> </li> <li> <p>ARMv7 phone (CPU)</p> <p> <code>"TargetPlatform": {"Os": "ANDROID", "Arch": "ARM_EABI"},</code> </p> <p> <code> "CompilerOptions": {\'ANDROID_PLATFORM\': 25, \'mattr\': [\'+neon\']}</code> </p> </li> <li> <p>ARMv8 phone (CPU)</p> <p> <code>"TargetPlatform": {"Os": "ANDROID", "Arch": "ARM64"},</code> </p> <p> <code> "CompilerOptions": {\'ANDROID_PLATFORM\': 29}</code> </p> </li> </ul>', ], ], 'TargetPlatformAccelerator' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationTargetPlatformAccelerator' => '<p>The type of accelerator that the model will run on after the compilation job has completed.</p>', 'TargetPlatform$Accelerator' => '<p>Specifies a target platform accelerator (optional).</p> <ul> <li> <p> <code>NVIDIA</code>: Nvidia graphics processing unit. It also requires <code>gpu-code</code>, <code>trt-ver</code>, <code>cuda-ver</code> compiler options</p> </li> <li> <p> <code>MALI</code>: ARM Mali graphics processor</p> </li> <li> <p> <code>INTEL_GRAPHICS</code>: Integrated Intel graphics</p> </li> </ul>', ], ], 'TargetPlatformArch' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationTargetPlatformArch' => '<p>The type of architecture that the model will run on after the compilation job has completed.</p>', 'TargetPlatform$Arch' => '<p>Specifies a target platform architecture.</p> <ul> <li> <p> <code>X86_64</code>: 64-bit version of the x86 instruction set.</p> </li> <li> <p> <code>X86</code>: 32-bit version of the x86 instruction set.</p> </li> <li> <p> <code>ARM64</code>: ARMv8 64-bit CPU.</p> </li> <li> <p> <code>ARM_EABIHF</code>: ARMv7 32-bit, Hard Float.</p> </li> <li> <p> <code>ARM_EABI</code>: ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.</p> </li> </ul>', ], ], 'TargetPlatformOs' => [ 'base' => NULL, 'refs' => [ 'CompilationJobSummary$CompilationTargetPlatformOs' => '<p>The type of OS that the model will run on after the compilation job has completed.</p>', 'TargetPlatform$Os' => '<p>Specifies a target platform OS.</p> <ul> <li> <p> <code>LINUX</code>: Linux-based operating systems.</p> </li> <li> <p> <code>ANDROID</code>: Android operating systems. Android API level can be specified using the <code>ANDROID_PLATFORM</code> compiler option. For example, <code>"CompilerOptions": {\'ANDROID_PLATFORM\': 28}</code> </p> </li> </ul>', ], ], 'TaskAvailabilityLifetimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskAvailabilityLifetimeInSeconds' => '<p>The length of time that a task remains available for labeling by human workers. The default and maximum values for this parameter depend on the type of workforce you use.</p> <ul> <li> <p>If you choose the Amazon Mechanical Turk workforce, the maximum is 12 hours (43,200 seconds). The default is 6 hours (21,600 seconds).</p> </li> <li> <p>If you choose a private or vendor workforce, the default value is 30 days (2592,000 seconds) for non-AL mode. For most users, the maximum is also 30 days.</p> </li> </ul>', ], ], 'TaskCount' => [ 'base' => NULL, 'refs' => [ 'DesiredWeightAndCapacity$DesiredInstanceCount' => '<p>The variant\'s capacity.</p>', 'PendingProductionVariantSummary$CurrentInstanceCount' => '<p>The number of instances associated with the variant.</p>', 'PendingProductionVariantSummary$DesiredInstanceCount' => '<p>The number of instances requested in this deployment, as specified in the endpoint configuration for the endpoint. The value is taken from the request to the <code> <a>CreateEndpointConfig</a> </code> operation.</p>', 'ProductionVariantSummary$CurrentInstanceCount' => '<p>The number of instances associated with the variant.</p>', 'ProductionVariantSummary$DesiredInstanceCount' => '<p>The number of instances requested in the <code>UpdateEndpointWeightsAndCapacities</code> request. </p>', ], ], 'TaskDescription' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskDescription' => '<p>A description of the task for your human workers.</p>', ], ], 'TaskInput' => [ 'base' => NULL, 'refs' => [ 'RenderableTask$Input' => '<p>A JSON object that contains values for the variables defined in the template. It is made available to the template under the substitution variable <code>task.input</code>. For example, if you define a variable <code>task.input.text</code> in your template, you can supply the variable in the JSON object as <code>"text": "sample text"</code>.</p>', ], ], 'TaskKeyword' => [ 'base' => NULL, 'refs' => [ 'TaskKeywords$member' => NULL, ], ], 'TaskKeywords' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskKeywords' => '<p>Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.</p>', ], ], 'TaskTimeLimitInSeconds' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskTimeLimitInSeconds' => '<p>The amount of time that a worker has to complete a task. </p> <p>If you create a custom labeling job, the maximum value for this parameter is 8 hours (28,800 seconds).</p> <p>If you create a labeling job using a <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task type</a> the maximum for this parameter depends on the task type you use:</p> <ul> <li> <p>For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-images.html">image</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-text.html">text</a> labeling jobs, the maximum is 8 hours (28,800 seconds).</p> </li> <li> <p>For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud.html">3D point cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-video.html">video frame</a> labeling jobs, the maximum is 30 days (2952,000 seconds) for non-AL mode. For most users, the maximum is also 30 days.</p> </li> </ul>', ], ], 'TaskTitle' => [ 'base' => NULL, 'refs' => [ 'HumanTaskConfig$TaskTitle' => '<p>A title for the task for your human workers.</p>', ], ], 'TemplateContent' => [ 'base' => NULL, 'refs' => [ 'UiTemplate$Content' => '<p>The content of the Liquid template for the worker user interface.</p>', ], ], 'TemplateContentSha256' => [ 'base' => NULL, 'refs' => [ 'UiTemplateInfo$ContentSha256' => '<p>The SHA-256 digest of the contents of the template.</p>', ], ], 'TemplateUrl' => [ 'base' => NULL, 'refs' => [ 'UiTemplateInfo$Url' => '<p>The URL for the user interface template.</p>', ], ], 'TensorBoardAppSettings' => [ 'base' => '<p>The TensorBoard app settings.</p>', 'refs' => [ 'UserSettings$TensorBoardAppSettings' => '<p>The TensorBoard app settings.</p>', ], ], 'TensorBoardOutputConfig' => [ 'base' => '<p>Configuration of storage locations for the Debugger TensorBoard output data.</p>', 'refs' => [ 'CreateTrainingJobRequest$TensorBoardOutputConfig' => NULL, 'DescribeTrainingJobResponse$TensorBoardOutputConfig' => NULL, 'TrainingJob$TensorBoardOutputConfig' => NULL, ], ], 'TenthFractionsOfACent' => [ 'base' => NULL, 'refs' => [ 'USD$TenthFractionsOfACent' => '<p>Fractions of a cent, in tenths.</p>', ], ], 'TerminationWaitInSeconds' => [ 'base' => NULL, 'refs' => [ 'BlueGreenUpdatePolicy$TerminationWaitInSeconds' => '<p>Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is 0.</p>', ], ], 'ThingName' => [ 'base' => NULL, 'refs' => [ 'DescribeDeviceResponse$IotThingName' => '<p>The Amazon Web Services Internet of Things (IoT) object thing name associated with the device.</p>', 'Device$IotThingName' => '<p>Amazon Web Services Internet of Things (IoT) object name.</p>', 'DeviceSummary$IotThingName' => '<p>The Amazon Web Services Internet of Things (IoT) object thing name associated with the device..</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ActionSummary$CreationTime' => '<p>When the action was created.</p>', 'ActionSummary$LastModifiedTime' => '<p>When the action was last modified.</p>', 'AppImageConfigDetails$CreationTime' => '<p>When the AppImageConfig was created.</p>', 'AppImageConfigDetails$LastModifiedTime' => '<p>When the AppImageConfig was last modified.</p>', 'ArtifactSummary$CreationTime' => '<p>When the artifact was created.</p>', 'ArtifactSummary$LastModifiedTime' => '<p>When the artifact was last modified.</p>', 'AssociationSummary$CreationTime' => '<p>When the association was created.</p>', 'AutoMLCandidate$CreationTime' => '<p>The creation time.</p>', 'AutoMLCandidate$EndTime' => '<p>The end time.</p>', 'AutoMLCandidate$LastModifiedTime' => '<p>The last modified time.</p>', 'AutoMLJobSummary$CreationTime' => '<p>When the AutoML job was created.</p>', 'AutoMLJobSummary$EndTime' => '<p>The end time of an AutoML job.</p>', 'AutoMLJobSummary$LastModifiedTime' => '<p>When the AutoML job was last modified.</p>', 'CompilationJobSummary$CompilationStartTime' => '<p>The time when the model compilation job started.</p>', 'CompilationJobSummary$CompilationEndTime' => '<p>The time when the model compilation job completed.</p>', 'ContextSummary$CreationTime' => '<p>When the context was created.</p>', 'ContextSummary$LastModifiedTime' => '<p>When the context was last modified.</p>', 'CreateTrialComponentRequest$StartTime' => '<p>When the component started.</p>', 'CreateTrialComponentRequest$EndTime' => '<p>When the component ended.</p>', 'DebugRuleEvaluationStatus$LastModifiedTime' => '<p>Timestamp when the rule evaluation status was last modified.</p>', 'DeployedImage$ResolutionTime' => '<p>The date and time when the image path for the model resolved to the <code>ResolvedImage</code> </p>', 'DescribeActionResponse$CreationTime' => '<p>When the action was created.</p>', 'DescribeActionResponse$LastModifiedTime' => '<p>When the action was last modified.</p>', 'DescribeAppImageConfigResponse$CreationTime' => '<p>When the AppImageConfig was created.</p>', 'DescribeAppImageConfigResponse$LastModifiedTime' => '<p>When the AppImageConfig was last modified.</p>', 'DescribeAppResponse$LastHealthCheckTimestamp' => '<p>The timestamp of the last health check.</p>', 'DescribeAppResponse$LastUserActivityTimestamp' => '<p>The timestamp of the last user\'s activity. <code>LastUserActivityTimestamp</code> is also updated when SageMaker performs health checks without user activity. As a result, this value is set to the same value as <code>LastHealthCheckTimestamp</code>.</p>', 'DescribeArtifactResponse$CreationTime' => '<p>When the artifact was created.</p>', 'DescribeArtifactResponse$LastModifiedTime' => '<p>When the artifact was last modified.</p>', 'DescribeAutoMLJobResponse$CreationTime' => '<p>Returns the creation time of the AutoML job.</p>', 'DescribeAutoMLJobResponse$EndTime' => '<p>Returns the end time of the AutoML job.</p>', 'DescribeAutoMLJobResponse$LastModifiedTime' => '<p>Returns the job\'s last modified time.</p>', 'DescribeCompilationJobResponse$CompilationStartTime' => '<p>The time when the model compilation job started the <code>CompilationJob</code> instances. </p> <p>You are billed for the time between this timestamp and the timestamp in the <a>DescribeCompilationJobResponse$CompilationEndTime</a> field. In Amazon CloudWatch Logs, the start time might be later than this time. That\'s because it takes time to download the compilation job, which depends on the size of the compilation job container. </p>', 'DescribeCompilationJobResponse$CompilationEndTime' => '<p>The time when the model compilation job on a compilation job instance ended. For a successful or stopped job, this is when the job\'s model artifacts have finished uploading. For a failed job, this is when Amazon SageMaker detected that the job failed. </p>', 'DescribeContextResponse$CreationTime' => '<p>When the context was created.</p>', 'DescribeContextResponse$LastModifiedTime' => '<p>When the context was last modified.</p>', 'DescribeDataQualityJobDefinitionResponse$CreationTime' => '<p>The time that the data quality monitoring job definition was created.</p>', 'DescribeDeviceFleetResponse$CreationTime' => '<p>Timestamp of when the device fleet was created.</p>', 'DescribeDeviceFleetResponse$LastModifiedTime' => '<p>Timestamp of when the device fleet was last updated.</p>', 'DescribeDeviceResponse$RegistrationTime' => '<p>The timestamp of the last registration or de-reregistration.</p>', 'DescribeDeviceResponse$LatestHeartbeat' => '<p>The last heartbeat received from the device.</p>', 'DescribeEdgePackagingJobResponse$CreationTime' => '<p>The timestamp of when the packaging job was created.</p>', 'DescribeEdgePackagingJobResponse$LastModifiedTime' => '<p>The timestamp of when the job was last updated.</p>', 'DescribeEndpointConfigOutput$CreationTime' => '<p>A timestamp that shows when the endpoint configuration was created.</p>', 'DescribeEndpointOutput$CreationTime' => '<p>A timestamp that shows when the endpoint was created.</p>', 'DescribeEndpointOutput$LastModifiedTime' => '<p>A timestamp that shows when the endpoint was last modified.</p>', 'DescribeExperimentResponse$CreationTime' => '<p>When the experiment was created.</p>', 'DescribeExperimentResponse$LastModifiedTime' => '<p>When the experiment was last modified.</p>', 'DescribeFlowDefinitionResponse$CreationTime' => '<p>The timestamp when the flow definition was created.</p>', 'DescribeHumanTaskUiResponse$CreationTime' => '<p>The timestamp when the human task user interface was created.</p>', 'DescribeHyperParameterTuningJobResponse$CreationTime' => '<p>The date and time that the tuning job started.</p>', 'DescribeHyperParameterTuningJobResponse$HyperParameterTuningEndTime' => '<p>The date and time that the tuning job ended.</p>', 'DescribeHyperParameterTuningJobResponse$LastModifiedTime' => '<p>The date and time that the status of the tuning job was modified. </p>', 'DescribeImageResponse$CreationTime' => '<p>When the image was created.</p>', 'DescribeImageResponse$LastModifiedTime' => '<p>When the image was last modified.</p>', 'DescribeImageVersionResponse$CreationTime' => '<p>When the version was created.</p>', 'DescribeImageVersionResponse$LastModifiedTime' => '<p>When the version was last modified.</p>', 'DescribeInferenceRecommendationsJobResponse$CompletionTime' => '<p>A timestamp that shows when the job completed.</p>', 'DescribeLabelingJobResponse$CreationTime' => '<p>The date and time that the labeling job was created.</p>', 'DescribeLabelingJobResponse$LastModifiedTime' => '<p>The date and time that the labeling job was last updated.</p>', 'DescribeLineageGroupResponse$CreationTime' => '<p>The creation time of lineage group.</p>', 'DescribeLineageGroupResponse$LastModifiedTime' => '<p>The last modified time of the lineage group.</p>', 'DescribeModelBiasJobDefinitionResponse$CreationTime' => '<p>The time at which the model bias job was created.</p>', 'DescribeModelExplainabilityJobDefinitionResponse$CreationTime' => '<p>The time at which the model explainability job was created.</p>', 'DescribeModelOutput$CreationTime' => '<p>A timestamp that shows when the model was created.</p>', 'DescribeModelPackageOutput$LastModifiedTime' => '<p>The last time the model package was modified.</p>', 'DescribeModelQualityJobDefinitionResponse$CreationTime' => '<p>The time at which the model quality job was created.</p>', 'DescribeMonitoringScheduleResponse$CreationTime' => '<p>The time at which the monitoring job was created.</p>', 'DescribeMonitoringScheduleResponse$LastModifiedTime' => '<p>The time at which the monitoring job was last modified.</p>', 'DescribePipelineDefinitionForExecutionResponse$CreationTime' => '<p>The time when the pipeline was created.</p>', 'DescribePipelineExecutionResponse$CreationTime' => '<p>The time when the pipeline execution was created.</p>', 'DescribePipelineExecutionResponse$LastModifiedTime' => '<p>The time when the pipeline execution was modified last.</p>', 'DescribePipelineResponse$CreationTime' => '<p>The time when the pipeline was created.</p>', 'DescribePipelineResponse$LastModifiedTime' => '<p>The time when the pipeline was last modified.</p>', 'DescribePipelineResponse$LastRunTime' => '<p>The time when the pipeline was last run.</p>', 'DescribeProcessingJobResponse$ProcessingEndTime' => '<p>The time at which the processing job completed.</p>', 'DescribeProcessingJobResponse$ProcessingStartTime' => '<p>The time at which the processing job started.</p>', 'DescribeProcessingJobResponse$LastModifiedTime' => '<p>The time at which the processing job was last modified.</p>', 'DescribeProcessingJobResponse$CreationTime' => '<p>The time at which the processing job was created.</p>', 'DescribeProjectOutput$CreationTime' => '<p>The time when the project was created.</p>', 'DescribeProjectOutput$LastModifiedTime' => '<p>The timestamp when project was last modified.</p>', 'DescribeStudioLifecycleConfigResponse$CreationTime' => '<p>The creation time of the Studio Lifecycle Configuration.</p>', 'DescribeStudioLifecycleConfigResponse$LastModifiedTime' => '<p>This value is equivalent to CreationTime because Studio Lifecycle Configurations are immutable.</p>', 'DescribeTrainingJobResponse$CreationTime' => '<p>A timestamp that indicates when the training job was created.</p>', 'DescribeTrainingJobResponse$TrainingStartTime' => '<p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>', 'DescribeTrainingJobResponse$TrainingEndTime' => '<p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>', 'DescribeTrainingJobResponse$LastModifiedTime' => '<p>A timestamp that indicates when the status of the training job was last modified.</p>', 'DescribeTransformJobResponse$CreationTime' => '<p>A timestamp that shows when the transform Job was created.</p>', 'DescribeTransformJobResponse$TransformStartTime' => '<p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>', 'DescribeTransformJobResponse$TransformEndTime' => '<p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>', 'DescribeTrialComponentResponse$StartTime' => '<p>When the component started.</p>', 'DescribeTrialComponentResponse$EndTime' => '<p>When the component ended.</p>', 'DescribeTrialComponentResponse$CreationTime' => '<p>When the component was created.</p>', 'DescribeTrialComponentResponse$LastModifiedTime' => '<p>When the component was last modified.</p>', 'DescribeTrialResponse$CreationTime' => '<p>When the trial was created.</p>', 'DescribeTrialResponse$LastModifiedTime' => '<p>When the trial was last modified.</p>', 'DeviceFleetSummary$CreationTime' => '<p>Timestamp of when the device fleet was created.</p>', 'DeviceFleetSummary$LastModifiedTime' => '<p>Timestamp of when the device fleet was last updated.</p>', 'DeviceSummary$RegistrationTime' => '<p>The timestamp of the last registration or de-reregistration.</p>', 'DeviceSummary$LatestHeartbeat' => '<p>The last heartbeat received from the device.</p>', 'EdgeModel$LatestSampleTime' => '<p>The timestamp of the last data sample taken.</p>', 'EdgeModel$LatestInference' => '<p>The timestamp of the last inference that was made.</p>', 'EdgePackagingJobSummary$CreationTime' => '<p>The timestamp of when the job was created.</p>', 'EdgePackagingJobSummary$LastModifiedTime' => '<p>The timestamp of when the edge packaging job was last updated.</p>', 'Endpoint$CreationTime' => '<p>The time that the endpoint was created.</p>', 'Endpoint$LastModifiedTime' => '<p>The last time the endpoint was modified.</p>', 'EndpointConfigSummary$CreationTime' => '<p>A timestamp that shows when the endpoint configuration was created.</p>', 'EndpointSummary$CreationTime' => '<p>A timestamp that shows when the endpoint was created.</p>', 'EndpointSummary$LastModifiedTime' => '<p>A timestamp that shows when the endpoint was last modified.</p>', 'Experiment$CreationTime' => '<p>When the experiment was created.</p>', 'Experiment$LastModifiedTime' => '<p>When the experiment was last modified.</p>', 'ExperimentSummary$CreationTime' => '<p>When the experiment was created.</p>', 'ExperimentSummary$LastModifiedTime' => '<p>When the experiment was last modified.</p>', 'FeatureGroupSummary$CreationTime' => '<p>A timestamp indicating the time of creation time of the <code>FeatureGroup</code>.</p>', 'FlowDefinitionSummary$CreationTime' => '<p>The timestamp when SageMaker created the flow definition.</p>', 'GetDeviceFleetReportResponse$ReportGenerated' => '<p>Timestamp of when the report was generated.</p>', 'HumanTaskUiSummary$CreationTime' => '<p>A timestamp when SageMaker created the human task user interface.</p>', 'HyperParameterTrainingJobSummary$CreationTime' => '<p>The date and time that the training job was created.</p>', 'HyperParameterTrainingJobSummary$TrainingStartTime' => '<p>The date and time that the training job started.</p>', 'HyperParameterTrainingJobSummary$TrainingEndTime' => '<p>Specifies the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>', 'HyperParameterTuningJobSummary$CreationTime' => '<p>The date and time that the tuning job was created.</p>', 'HyperParameterTuningJobSummary$HyperParameterTuningEndTime' => '<p>The date and time that the tuning job ended.</p>', 'HyperParameterTuningJobSummary$LastModifiedTime' => '<p>The date and time that the tuning job was modified.</p>', 'Image$CreationTime' => '<p>When the image was created.</p>', 'Image$LastModifiedTime' => '<p>When the image was last modified.</p>', 'ImageVersion$CreationTime' => '<p>When the version was created.</p>', 'ImageVersion$LastModifiedTime' => '<p>When the version was last modified.</p>', 'InferenceRecommendationsJob$CompletionTime' => '<p>A timestamp that shows when the job completed.</p>', 'LabelingJobForWorkteamSummary$CreationTime' => '<p>The date and time that the labeling job was created.</p>', 'LabelingJobSummary$CreationTime' => '<p>The date and time that the job was created (timestamp).</p>', 'LabelingJobSummary$LastModifiedTime' => '<p>The date and time that the job was last modified (timestamp).</p>', 'LineageGroupSummary$CreationTime' => '<p>The creation time of the lineage group summary.</p>', 'LineageGroupSummary$LastModifiedTime' => '<p>The last modified time of the lineage group summary.</p>', 'ListActionsRequest$CreatedAfter' => '<p>A filter that returns only actions created on or after the specified time.</p>', 'ListActionsRequest$CreatedBefore' => '<p>A filter that returns only actions created on or before the specified time.</p>', 'ListAppImageConfigsRequest$CreationTimeBefore' => '<p>A filter that returns only AppImageConfigs created on or before the specified time.</p>', 'ListAppImageConfigsRequest$CreationTimeAfter' => '<p>A filter that returns only AppImageConfigs created on or after the specified time.</p>', 'ListAppImageConfigsRequest$ModifiedTimeBefore' => '<p>A filter that returns only AppImageConfigs modified on or before the specified time.</p>', 'ListAppImageConfigsRequest$ModifiedTimeAfter' => '<p>A filter that returns only AppImageConfigs modified on or after the specified time.</p>', 'ListArtifactsRequest$CreatedAfter' => '<p>A filter that returns only artifacts created on or after the specified time.</p>', 'ListArtifactsRequest$CreatedBefore' => '<p>A filter that returns only artifacts created on or before the specified time.</p>', 'ListAssociationsRequest$CreatedAfter' => '<p>A filter that returns only associations created on or after the specified time.</p>', 'ListAssociationsRequest$CreatedBefore' => '<p>A filter that returns only associations created on or before the specified time.</p>', 'ListAutoMLJobsRequest$CreationTimeAfter' => '<p>Request a list of jobs, using a filter for time.</p>', 'ListAutoMLJobsRequest$CreationTimeBefore' => '<p>Request a list of jobs, using a filter for time.</p>', 'ListAutoMLJobsRequest$LastModifiedTimeAfter' => '<p>Request a list of jobs, using a filter for time.</p>', 'ListAutoMLJobsRequest$LastModifiedTimeBefore' => '<p>Request a list of jobs, using a filter for time.</p>', 'ListCodeRepositoriesInput$LastModifiedTimeAfter' => '<p>A filter that returns only Git repositories that were last modified after the specified time.</p>', 'ListCodeRepositoriesInput$LastModifiedTimeBefore' => '<p>A filter that returns only Git repositories that were last modified before the specified time.</p>', 'ListContextsRequest$CreatedAfter' => '<p>A filter that returns only contexts created on or after the specified time.</p>', 'ListContextsRequest$CreatedBefore' => '<p>A filter that returns only contexts created on or before the specified time.</p>', 'ListDataQualityJobDefinitionsRequest$CreationTimeBefore' => '<p>A filter that returns only data quality monitoring job definitions created before the specified time.</p>', 'ListDataQualityJobDefinitionsRequest$CreationTimeAfter' => '<p>A filter that returns only data quality monitoring job definitions created after the specified time.</p>', 'ListDeviceFleetsRequest$CreationTimeAfter' => '<p>Filter fleets where packaging job was created after specified time.</p>', 'ListDeviceFleetsRequest$CreationTimeBefore' => '<p>Filter fleets where the edge packaging job was created before specified time.</p>', 'ListDeviceFleetsRequest$LastModifiedTimeAfter' => '<p>Select fleets where the job was updated after X</p>', 'ListDeviceFleetsRequest$LastModifiedTimeBefore' => '<p>Select fleets where the job was updated before X</p>', 'ListDevicesRequest$LatestHeartbeatAfter' => '<p>Select fleets where the job was updated after X</p>', 'ListEdgePackagingJobsRequest$CreationTimeAfter' => '<p>Select jobs where the job was created after specified time.</p>', 'ListEdgePackagingJobsRequest$CreationTimeBefore' => '<p>Select jobs where the job was created before specified time.</p>', 'ListEdgePackagingJobsRequest$LastModifiedTimeAfter' => '<p>Select jobs where the job was updated after specified time.</p>', 'ListEdgePackagingJobsRequest$LastModifiedTimeBefore' => '<p>Select jobs where the job was updated before specified time.</p>', 'ListEndpointConfigsInput$CreationTimeBefore' => '<p>A filter that returns only endpoint configurations created before the specified time (timestamp).</p>', 'ListEndpointConfigsInput$CreationTimeAfter' => '<p>A filter that returns only endpoint configurations with a creation time greater than or equal to the specified time (timestamp).</p>', 'ListEndpointsInput$CreationTimeBefore' => '<p>A filter that returns only endpoints that were created before the specified time (timestamp).</p>', 'ListEndpointsInput$CreationTimeAfter' => '<p>A filter that returns only endpoints with a creation time greater than or equal to the specified time (timestamp).</p>', 'ListEndpointsInput$LastModifiedTimeBefore' => '<p> A filter that returns only endpoints that were modified before the specified timestamp. </p>', 'ListEndpointsInput$LastModifiedTimeAfter' => '<p> A filter that returns only endpoints that were modified after the specified timestamp. </p>', 'ListExperimentsRequest$CreatedAfter' => '<p>A filter that returns only experiments created after the specified time.</p>', 'ListExperimentsRequest$CreatedBefore' => '<p>A filter that returns only experiments created before the specified time.</p>', 'ListFlowDefinitionsRequest$CreationTimeAfter' => '<p>A filter that returns only flow definitions with a creation time greater than or equal to the specified timestamp.</p>', 'ListFlowDefinitionsRequest$CreationTimeBefore' => '<p>A filter that returns only flow definitions that were created before the specified timestamp.</p>', 'ListHumanTaskUisRequest$CreationTimeAfter' => '<p>A filter that returns only human task user interfaces with a creation time greater than or equal to the specified timestamp.</p>', 'ListHumanTaskUisRequest$CreationTimeBefore' => '<p>A filter that returns only human task user interfaces that were created before the specified timestamp.</p>', 'ListHyperParameterTuningJobsRequest$CreationTimeAfter' => '<p>A filter that returns only tuning jobs that were created after the specified time.</p>', 'ListHyperParameterTuningJobsRequest$CreationTimeBefore' => '<p>A filter that returns only tuning jobs that were created before the specified time.</p>', 'ListHyperParameterTuningJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only tuning jobs that were modified after the specified time.</p>', 'ListHyperParameterTuningJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only tuning jobs that were modified before the specified time.</p>', 'ListImageVersionsRequest$CreationTimeAfter' => '<p>A filter that returns only versions created on or after the specified time.</p>', 'ListImageVersionsRequest$CreationTimeBefore' => '<p>A filter that returns only versions created on or before the specified time.</p>', 'ListImageVersionsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only versions modified on or after the specified time.</p>', 'ListImageVersionsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only versions modified on or before the specified time.</p>', 'ListImagesRequest$CreationTimeAfter' => '<p>A filter that returns only images created on or after the specified time.</p>', 'ListImagesRequest$CreationTimeBefore' => '<p>A filter that returns only images created on or before the specified time.</p>', 'ListImagesRequest$LastModifiedTimeAfter' => '<p>A filter that returns only images modified on or after the specified time.</p>', 'ListImagesRequest$LastModifiedTimeBefore' => '<p>A filter that returns only images modified on or before the specified time.</p>', 'ListLabelingJobsForWorkteamRequest$CreationTimeAfter' => '<p>A filter that returns only labeling jobs created after the specified time (timestamp).</p>', 'ListLabelingJobsForWorkteamRequest$CreationTimeBefore' => '<p>A filter that returns only labeling jobs created before the specified time (timestamp).</p>', 'ListLabelingJobsRequest$CreationTimeAfter' => '<p>A filter that returns only labeling jobs created after the specified time (timestamp).</p>', 'ListLabelingJobsRequest$CreationTimeBefore' => '<p>A filter that returns only labeling jobs created before the specified time (timestamp).</p>', 'ListLabelingJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only labeling jobs modified after the specified time (timestamp).</p>', 'ListLabelingJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only labeling jobs modified before the specified time (timestamp).</p>', 'ListLineageGroupsRequest$CreatedAfter' => '<p>A timestamp to filter against lineage groups created after a certain point in time.</p>', 'ListLineageGroupsRequest$CreatedBefore' => '<p>A timestamp to filter against lineage groups created before a certain point in time.</p>', 'ListModelBiasJobDefinitionsRequest$CreationTimeBefore' => '<p>A filter that returns only model bias jobs created before a specified time.</p>', 'ListModelBiasJobDefinitionsRequest$CreationTimeAfter' => '<p>A filter that returns only model bias jobs created after a specified time.</p>', 'ListModelExplainabilityJobDefinitionsRequest$CreationTimeBefore' => '<p>A filter that returns only model explainability jobs created before a specified time.</p>', 'ListModelExplainabilityJobDefinitionsRequest$CreationTimeAfter' => '<p>A filter that returns only model explainability jobs created after a specified time.</p>', 'ListModelQualityJobDefinitionsRequest$CreationTimeBefore' => '<p>A filter that returns only model quality monitoring job definitions created before the specified time.</p>', 'ListModelQualityJobDefinitionsRequest$CreationTimeAfter' => '<p>A filter that returns only model quality monitoring job definitions created after the specified time.</p>', 'ListModelsInput$CreationTimeBefore' => '<p>A filter that returns only models created before the specified time (timestamp).</p>', 'ListModelsInput$CreationTimeAfter' => '<p>A filter that returns only models with a creation time greater than or equal to the specified time (timestamp).</p>', 'ListMonitoringExecutionsRequest$ScheduledTimeBefore' => '<p>Filter for jobs scheduled before a specified time.</p>', 'ListMonitoringExecutionsRequest$ScheduledTimeAfter' => '<p>Filter for jobs scheduled after a specified time.</p>', 'ListMonitoringExecutionsRequest$CreationTimeBefore' => '<p>A filter that returns only jobs created before a specified time.</p>', 'ListMonitoringExecutionsRequest$CreationTimeAfter' => '<p>A filter that returns only jobs created after a specified time.</p>', 'ListMonitoringExecutionsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only jobs modified after a specified time.</p>', 'ListMonitoringExecutionsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only jobs modified before a specified time.</p>', 'ListMonitoringSchedulesRequest$CreationTimeBefore' => '<p>A filter that returns only monitoring schedules created before a specified time.</p>', 'ListMonitoringSchedulesRequest$CreationTimeAfter' => '<p>A filter that returns only monitoring schedules created after a specified time.</p>', 'ListMonitoringSchedulesRequest$LastModifiedTimeBefore' => '<p>A filter that returns only monitoring schedules modified before a specified time.</p>', 'ListMonitoringSchedulesRequest$LastModifiedTimeAfter' => '<p>A filter that returns only monitoring schedules modified after a specified time.</p>', 'ListPipelineExecutionsRequest$CreatedAfter' => '<p>A filter that returns the pipeline executions that were created after a specified time.</p>', 'ListPipelineExecutionsRequest$CreatedBefore' => '<p>A filter that returns the pipeline executions that were created before a specified time.</p>', 'ListPipelinesRequest$CreatedAfter' => '<p>A filter that returns the pipelines that were created after a specified time.</p>', 'ListPipelinesRequest$CreatedBefore' => '<p>A filter that returns the pipelines that were created before a specified time.</p>', 'ListProcessingJobsRequest$CreationTimeAfter' => '<p>A filter that returns only processing jobs created after the specified time.</p>', 'ListProcessingJobsRequest$CreationTimeBefore' => '<p>A filter that returns only processing jobs created after the specified time.</p>', 'ListProcessingJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only processing jobs modified after the specified time.</p>', 'ListProcessingJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only processing jobs modified before the specified time.</p>', 'ListProjectsInput$CreationTimeAfter' => '<p>A filter that returns the projects that were created after a specified time.</p>', 'ListProjectsInput$CreationTimeBefore' => '<p>A filter that returns the projects that were created before a specified time.</p>', 'ListStudioLifecycleConfigsRequest$CreationTimeBefore' => '<p>A filter that returns only Lifecycle Configurations created on or before the specified time.</p>', 'ListStudioLifecycleConfigsRequest$CreationTimeAfter' => '<p>A filter that returns only Lifecycle Configurations created on or after the specified time.</p>', 'ListStudioLifecycleConfigsRequest$ModifiedTimeBefore' => '<p>A filter that returns only Lifecycle Configurations modified before the specified time.</p>', 'ListStudioLifecycleConfigsRequest$ModifiedTimeAfter' => '<p>A filter that returns only Lifecycle Configurations modified after the specified time.</p>', 'ListTrainingJobsRequest$CreationTimeAfter' => '<p>A filter that returns only training jobs created after the specified time (timestamp).</p>', 'ListTrainingJobsRequest$CreationTimeBefore' => '<p>A filter that returns only training jobs created before the specified time (timestamp).</p>', 'ListTrainingJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only training jobs modified after the specified time (timestamp).</p>', 'ListTrainingJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only training jobs modified before the specified time (timestamp).</p>', 'ListTransformJobsRequest$CreationTimeAfter' => '<p>A filter that returns only transform jobs created after the specified time.</p>', 'ListTransformJobsRequest$CreationTimeBefore' => '<p>A filter that returns only transform jobs created before the specified time.</p>', 'ListTransformJobsRequest$LastModifiedTimeAfter' => '<p>A filter that returns only transform jobs modified after the specified time.</p>', 'ListTransformJobsRequest$LastModifiedTimeBefore' => '<p>A filter that returns only transform jobs modified before the specified time.</p>', 'ListTrialComponentsRequest$CreatedAfter' => '<p>A filter that returns only components created after the specified time.</p>', 'ListTrialComponentsRequest$CreatedBefore' => '<p>A filter that returns only components created before the specified time.</p>', 'ListTrialsRequest$CreatedAfter' => '<p>A filter that returns only trials created after the specified time.</p>', 'ListTrialsRequest$CreatedBefore' => '<p>A filter that returns only trials created before the specified time.</p>', 'MetricData$Timestamp' => '<p>The date and time that the algorithm emitted the metric.</p>', 'ModelPackage$LastModifiedTime' => '<p>The last time the model package was modified.</p>', 'ModelSummary$CreationTime' => '<p>A timestamp that indicates when the model was created.</p>', 'MonitoringExecutionSummary$ScheduledTime' => '<p>The time the monitoring job was scheduled.</p>', 'MonitoringExecutionSummary$CreationTime' => '<p>The time at which the monitoring job was created.</p>', 'MonitoringExecutionSummary$LastModifiedTime' => '<p>A timestamp that indicates the last time the monitoring job was modified.</p>', 'MonitoringJobDefinitionSummary$CreationTime' => '<p>The time that the monitoring job was created.</p>', 'MonitoringSchedule$CreationTime' => '<p>The time that the monitoring schedule was created.</p>', 'MonitoringSchedule$LastModifiedTime' => '<p>The last time the monitoring schedule was changed.</p>', 'MonitoringScheduleSummary$CreationTime' => '<p>The creation time of the monitoring schedule.</p>', 'MonitoringScheduleSummary$LastModifiedTime' => '<p>The last time the monitoring schedule was modified.</p>', 'PendingDeploymentSummary$StartTime' => '<p>The start time of the deployment.</p>', 'Pipeline$CreationTime' => '<p>The creation time of the pipeline.</p>', 'Pipeline$LastModifiedTime' => '<p>The time that the pipeline was last modified.</p>', 'Pipeline$LastRunTime' => '<p>The time when the pipeline was last run.</p>', 'PipelineExecution$CreationTime' => '<p>The creation time of the pipeline execution.</p>', 'PipelineExecution$LastModifiedTime' => '<p>The time that the pipeline execution was last modified.</p>', 'PipelineExecutionStep$StartTime' => '<p>The time that the step started executing.</p>', 'PipelineExecutionStep$EndTime' => '<p>The time that the step stopped executing.</p>', 'PipelineExecutionSummary$StartTime' => '<p>The start time of the pipeline execution.</p>', 'PipelineSummary$CreationTime' => '<p>The creation time of the pipeline.</p>', 'PipelineSummary$LastModifiedTime' => '<p>The time that the pipeline was last modified.</p>', 'PipelineSummary$LastExecutionTime' => '<p>The last time that a pipeline execution began.</p>', 'ProcessingJob$ProcessingEndTime' => '<p>The time that the processing job ended.</p>', 'ProcessingJob$ProcessingStartTime' => '<p>The time that the processing job started.</p>', 'ProcessingJob$LastModifiedTime' => '<p>The time the processing job was last modified.</p>', 'ProcessingJob$CreationTime' => '<p>The time the processing job was created.</p>', 'ProcessingJobSummary$CreationTime' => '<p>The time at which the processing job was created.</p>', 'ProcessingJobSummary$ProcessingEndTime' => '<p>The time at which the processing job completed.</p>', 'ProcessingJobSummary$LastModifiedTime' => '<p>A timestamp that indicates the last time the processing job was modified.</p>', 'ProductionVariantStatus$StartTime' => '<p>The start time of the current status change.</p>', 'ProfilerRuleEvaluationStatus$LastModifiedTime' => '<p>Timestamp when the rule evaluation status was last modified.</p>', 'Project$CreationTime' => '<p>A timestamp specifying when the project was created.</p>', 'Project$LastModifiedTime' => '<p>A timestamp container for when the project was last modified.</p>', 'ProjectSummary$CreationTime' => '<p>The time that the project was created.</p>', 'QueryFilters$CreatedBefore' => '<p>Filter the lineage entities connected to the <code>StartArn</code>(s) by created date.</p>', 'QueryFilters$CreatedAfter' => '<p>Filter the lineage entities connected to the <code>StartArn</code>(s) after the create date.</p>', 'QueryFilters$ModifiedBefore' => '<p>Filter the lineage entities connected to the <code>StartArn</code>(s) before the last modified date.</p>', 'QueryFilters$ModifiedAfter' => '<p>Filter the lineage entities connected to the <code>StartArn</code>(s) after the last modified date.</p>', 'SecondaryStatusTransition$StartTime' => '<p>A timestamp that shows when the training job transitioned to the current secondary status state.</p>', 'SecondaryStatusTransition$EndTime' => '<p>A timestamp that shows when the training job transitioned out of this secondary status state into another secondary status state or when the training job has ended.</p>', 'StudioLifecycleConfigDetails$CreationTime' => '<p>The creation time of the Studio Lifecycle Configuration.</p>', 'StudioLifecycleConfigDetails$LastModifiedTime' => '<p>This value is equivalent to CreationTime because Studio Lifecycle Configurations are immutable.</p>', 'TrainingJob$CreationTime' => '<p>A timestamp that indicates when the training job was created.</p>', 'TrainingJob$TrainingStartTime' => '<p>Indicates the time when the training job starts on training instances. You are billed for the time interval between this time and the value of <code>TrainingEndTime</code>. The start time in CloudWatch Logs might be later than this time. The difference is due to the time it takes to download the training data and to the size of the training container.</p>', 'TrainingJob$TrainingEndTime' => '<p>Indicates the time when the training job ends on training instances. You are billed for the time interval between the value of <code>TrainingStartTime</code> and this time. For successful jobs and stopped jobs, this is the time after model artifacts are uploaded. For failed jobs, this is the time when Amazon SageMaker detects a job failure.</p>', 'TrainingJob$LastModifiedTime' => '<p>A timestamp that indicates when the status of the training job was last modified.</p>', 'TrainingJobSummary$CreationTime' => '<p>A timestamp that shows when the training job was created.</p>', 'TrainingJobSummary$TrainingEndTime' => '<p>A timestamp that shows when the training job ended. This field is set only if the training job has one of the terminal statuses (<code>Completed</code>, <code>Failed</code>, or <code>Stopped</code>). </p>', 'TrainingJobSummary$LastModifiedTime' => '<p> Timestamp when the training job was last modified. </p>', 'TransformJob$CreationTime' => '<p>A timestamp that shows when the transform Job was created.</p>', 'TransformJob$TransformStartTime' => '<p>Indicates when the transform job starts on ML instances. You are billed for the time interval between this time and the value of <code>TransformEndTime</code>.</p>', 'TransformJob$TransformEndTime' => '<p>Indicates when the transform job has been completed, or has stopped or failed. You are billed for the time interval between this time and the value of <code>TransformStartTime</code>.</p>', 'TransformJobSummary$CreationTime' => '<p>A timestamp that shows when the transform Job was created.</p>', 'TransformJobSummary$TransformEndTime' => '<p>Indicates when the transform job ends on compute instances. For successful jobs and stopped jobs, this is the exact time recorded after the results are uploaded. For failed jobs, this is when Amazon SageMaker detected that the job failed.</p>', 'TransformJobSummary$LastModifiedTime' => '<p>Indicates when the transform job was last modified.</p>', 'Trial$CreationTime' => '<p>When the trial was created.</p>', 'Trial$LastModifiedTime' => '<p>Who last modified the trial.</p>', 'TrialComponent$StartTime' => '<p>When the component started.</p>', 'TrialComponent$EndTime' => '<p>When the component ended.</p>', 'TrialComponent$CreationTime' => '<p>When the component was created.</p>', 'TrialComponent$LastModifiedTime' => '<p>When the component was last modified.</p>', 'TrialComponentMetricSummary$TimeStamp' => '<p>When the metric was last updated.</p>', 'TrialComponentSimpleSummary$CreationTime' => '<p>When the component was created.</p>', 'TrialComponentSummary$StartTime' => '<p>When the component started.</p>', 'TrialComponentSummary$EndTime' => '<p>When the component ended.</p>', 'TrialComponentSummary$CreationTime' => '<p>When the component was created.</p>', 'TrialComponentSummary$LastModifiedTime' => '<p>When the component was last modified.</p>', 'TrialSummary$CreationTime' => '<p>When the trial was created.</p>', 'TrialSummary$LastModifiedTime' => '<p>When the trial was last modified.</p>', 'UpdateTrialComponentRequest$StartTime' => '<p>When the component started.</p>', 'UpdateTrialComponentRequest$EndTime' => '<p>When the component ended.</p>', 'Workforce$LastUpdatedDate' => '<p>The most recent date that was used to successfully add one or more IP address ranges (<a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) to a private workforce\'s allow list.</p>', 'Workforce$CreateDate' => '<p>The date that the workforce is created.</p>', 'Workteam$CreateDate' => '<p>The date and time that the work team was created (timestamp).</p>', 'Workteam$LastUpdatedDate' => '<p>The date and time that the work team was last updated (timestamp).</p>', ], ], 'TrafficDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'Phase$DurationInSeconds' => '<p>Specifies how long traffic phase should be.</p>', ], ], 'TrafficPattern' => [ 'base' => '<p>Defines the traffic pattern of the load test.</p>', 'refs' => [ 'RecommendationJobInputConfig$TrafficPattern' => '<p>Specifies the traffic pattern of the job.</p>', ], ], 'TrafficRoutingConfig' => [ 'base' => '<p>Defines the traffic routing strategy during an endpoint deployment to shift traffic from the old fleet to the new fleet.</p>', 'refs' => [ 'BlueGreenUpdatePolicy$TrafficRoutingConfiguration' => '<p>Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment.</p>', ], ], 'TrafficRoutingConfigType' => [ 'base' => NULL, 'refs' => [ 'TrafficRoutingConfig$Type' => '<p>Traffic routing strategy type.</p> <ul> <li> <p> <code>ALL_AT_ONCE</code>: Endpoint traffic shifts to the new fleet in a single step. </p> </li> <li> <p> <code>CANARY</code>: Endpoint traffic shifts to the new fleet in two steps. The first step is the canary, which is a small portion of the traffic. The second step is the remainder of the traffic. </p> </li> <li> <p> <code>LINEAR</code>: Endpoint traffic shifts to the new fleet in n steps of a configurable size. </p> </li> </ul>', ], ], 'TrafficType' => [ 'base' => NULL, 'refs' => [ 'TrafficPattern$TrafficType' => '<p>Defines the traffic patterns.</p>', ], ], 'TrainingEnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'TrainingEnvironmentMap$key' => NULL, ], ], 'TrainingEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$Environment' => '<p>The environment variables to set in the Docker container.</p>', 'DescribeTrainingJobResponse$Environment' => '<p>The environment variables to set in the Docker container.</p>', 'TrainingJob$Environment' => '<p>The environment variables to set in the Docker container.</p>', ], ], 'TrainingEnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'TrainingEnvironmentMap$value' => NULL, ], ], 'TrainingInputMode' => [ 'base' => '<p>The training input mode that the algorithm supports. For more information about input modes, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.</p> <p> <b>Pipe mode</b> </p> <p>If an algorithm supports <code>Pipe</code> mode, Amazon SageMaker streams data directly from Amazon S3 to the container.</p> <p> <b>File mode</b> </p> <p>If an algorithm supports <code>File</code> mode, SageMaker downloads the training data from S3 to the provisioned ML storage volume, and mounts the directory to the Docker volume for the training container.</p> <p>You must provision the ML storage volume with sufficient capacity to accommodate the data downloaded from S3. In addition to the training data, the ML storage volume also stores the output model. The algorithm container uses the ML storage volume to also store intermediate information, if any.</p> <p>For distributed algorithms, training data is distributed uniformly. Your training duration is predictable if the input data objects sizes are approximately the same. SageMaker does not split the files any further for model training. If the object sizes are skewed, training won\'t be optimal as the data distribution is also skewed when one host in a training cluster is overloaded, thus becoming a bottleneck in training.</p> <p> <b>FastFile mode</b> </p> <p>If an algorithm supports <code>FastFile</code> mode, SageMaker streams data directly from S3 to the container with no code changes, and provides file system access to the data. Users can author their training script to interact with these files as if they were stored on disk.</p> <p> <code>FastFile</code> mode works best when the data is read sequentially. Augmented manifest files aren\'t supported. The startup time is lower when there are fewer files in the S3 bucket provided.</p>', 'refs' => [ 'AlgorithmSpecification$TrainingInputMode' => NULL, 'Channel$InputMode' => '<p>(Optional) The input mode to use for the data channel in a training job. If you don\'t set a value for <code>InputMode</code>, Amazon SageMaker uses the value set for <code>TrainingInputMode</code>. Use this parameter to override the <code>TrainingInputMode</code> setting in a <a>AlgorithmSpecification</a> request when you have a channel that needs a different input mode from the training job\'s general setting. To download the data from Amazon Simple Storage Service (Amazon S3) to the provisioned ML storage volume, and mount the directory to a Docker volume, use <code>File</code> input mode. To stream data directly from Amazon S3 to the container, choose <code>Pipe</code> input mode.</p> <p>To use a model for incremental training, choose <code>File</code> input model.</p>', 'HyperParameterAlgorithmSpecification$TrainingInputMode' => NULL, 'InputModes$member' => NULL, 'TrainingJobDefinition$TrainingInputMode' => NULL, ], ], 'TrainingInstanceCount' => [ 'base' => NULL, 'refs' => [ 'ResourceConfig$InstanceCount' => '<p>The number of ML compute instances to use. For distributed training, provide a value greater than 1. </p>', ], ], 'TrainingInstanceType' => [ 'base' => NULL, 'refs' => [ 'ResourceConfig$InstanceType' => '<p>The ML compute instance type. </p>', 'TrainingInstanceTypes$member' => NULL, ], ], 'TrainingInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'TrainingSpecification$SupportedTrainingInstanceTypes' => '<p>A list of the instance types that this algorithm can use for training.</p>', ], ], 'TrainingJob' => [ 'base' => '<p>Contains information about a training job.</p>', 'refs' => [ 'SearchRecord$TrainingJob' => '<p>The properties of a training job.</p>', 'TrialComponentSourceDetail$TrainingJob' => '<p>Information about a training job that\'s the source of a trial component.</p>', ], ], 'TrainingJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobResponse$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', 'DescribeProcessingJobResponse$TrainingJobArn' => '<p>The ARN of a training job associated with this processing job.</p>', 'DescribeTrainingJobResponse$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', 'HyperParameterTrainingJobSummary$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', 'ProcessingJob$TrainingJobArn' => '<p>The ARN of the training job associated with this processing job.</p>', 'TrainingJob$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', 'TrainingJobStepMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the training job that was run by this step execution.</p>', 'TrainingJobSummary$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', 'UpdateTrainingJobResponse$TrainingJobArn' => '<p>The Amazon Resource Name (ARN) of the training job.</p>', ], ], 'TrainingJobDefinition' => [ 'base' => '<p>Defines the input needed to run a training job using the algorithm.</p>', 'refs' => [ 'AlgorithmValidationProfile$TrainingJobDefinition' => '<p>The <code>TrainingJobDefinition</code> object that describes the training job that Amazon SageMaker runs to validate your algorithm.</p>', ], ], 'TrainingJobEarlyStoppingType' => [ 'base' => NULL, 'refs' => [ 'HyperParameterTuningJobConfig$TrainingJobEarlyStoppingType' => '<p>Specifies whether to use early stopping for training jobs launched by the hyperparameter tuning job. This can be one of the following values (the default value is <code>OFF</code>):</p> <dl> <dt>OFF</dt> <dd> <p>Training jobs launched by the hyperparameter tuning job do not use early stopping.</p> </dd> <dt>AUTO</dt> <dd> <p>Amazon SageMaker stops training jobs launched by the hyperparameter tuning job when they are unlikely to perform better than previously completed training jobs. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html">Stop Training Jobs Early</a>.</p> </dd> </dl>', ], ], 'TrainingJobName' => [ 'base' => NULL, 'refs' => [ 'CreateTrainingJobRequest$TrainingJobName' => '<p>The name of the training job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>', 'DescribeTrainingJobRequest$TrainingJobName' => '<p>The name of the training job.</p>', 'DescribeTrainingJobResponse$TrainingJobName' => '<p> Name of the model training job. </p>', 'HyperParameterTrainingJobSummary$TrainingJobName' => '<p>The name of the training job.</p>', 'StopTrainingJobRequest$TrainingJobName' => '<p>The name of the training job to stop.</p>', 'TrainingJob$TrainingJobName' => '<p>The name of the training job.</p>', 'TrainingJobSummary$TrainingJobName' => '<p>The name of the training job that you want a summary for.</p>', 'UpdateTrainingJobRequest$TrainingJobName' => '<p>The name of a training job to update the Debugger profiling configuration.</p>', ], ], 'TrainingJobSortByOptions' => [ 'base' => NULL, 'refs' => [ 'ListTrainingJobsForHyperParameterTuningJobRequest$SortBy' => '<p>The field to sort results by. The default is <code>Name</code>.</p> <p>If the value of this field is <code>FinalObjectiveMetricValue</code>, any training jobs that did not return an objective metric are not listed.</p>', ], ], 'TrainingJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$TrainingJobStatus' => '<p>The status of the training job.</p> <p>Amazon SageMaker provides the following training job statuses:</p> <ul> <li> <p> <code>InProgress</code> - The training is in progress.</p> </li> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li> <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> <p>For more detailed information, see <code>SecondaryStatus</code>. </p>', 'HyperParameterTrainingJobSummary$TrainingJobStatus' => '<p>The status of the training job.</p>', 'ListTrainingJobsForHyperParameterTuningJobRequest$StatusEquals' => '<p>A filter that returns only training jobs with the specified status.</p>', 'ListTrainingJobsRequest$StatusEquals' => '<p>A filter that retrieves only training jobs with a specific status.</p>', 'TrainingJob$TrainingJobStatus' => '<p>The status of the training job.</p> <p>Training job statuses are:</p> <ul> <li> <p> <code>InProgress</code> - The training is in progress.</p> </li> <li> <p> <code>Completed</code> - The training job has completed.</p> </li> <li> <p> <code>Failed</code> - The training job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTrainingJobResponse</code> call.</p> </li> <li> <p> <code>Stopping</code> - The training job is stopping.</p> </li> <li> <p> <code>Stopped</code> - The training job has stopped.</p> </li> </ul> <p>For more detailed information, see <code>SecondaryStatus</code>. </p>', 'TrainingJobSummary$TrainingJobStatus' => '<p>The status of the training job.</p>', ], ], 'TrainingJobStatusCounter' => [ 'base' => NULL, 'refs' => [ 'TrainingJobStatusCounters$Completed' => '<p>The number of completed training jobs launched by the hyperparameter tuning job.</p>', 'TrainingJobStatusCounters$InProgress' => '<p>The number of in-progress training jobs launched by a hyperparameter tuning job.</p>', 'TrainingJobStatusCounters$RetryableError' => '<p>The number of training jobs that failed, but can be retried. A failed training job can be retried only if it failed because an internal service error occurred.</p>', 'TrainingJobStatusCounters$NonRetryableError' => '<p>The number of training jobs that failed and can\'t be retried. A failed training job can\'t be retried if it failed because a client error occurred.</p>', 'TrainingJobStatusCounters$Stopped' => '<p>The number of training jobs launched by a hyperparameter tuning job that were manually stopped.</p>', ], ], 'TrainingJobStatusCounters' => [ 'base' => '<p>The numbers of training jobs launched by a hyperparameter tuning job, categorized by status.</p>', 'refs' => [ 'DescribeHyperParameterTuningJobResponse$TrainingJobStatusCounters' => '<p>The <a>TrainingJobStatusCounters</a> object that specifies the number of training jobs, categorized by status, that this tuning job launched.</p>', 'HyperParameterTuningJobSummary$TrainingJobStatusCounters' => '<p>The <a>TrainingJobStatusCounters</a> object that specifies the numbers of training jobs, categorized by status, that this tuning job launched.</p>', ], ], 'TrainingJobStepMetadata' => [ 'base' => '<p>Metadata for a training job step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$TrainingJob' => '<p>The Amazon Resource Name (ARN) of the training job that was run by this step execution.</p>', ], ], 'TrainingJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrainingJobsResponse$TrainingJobSummaries' => '<p>An array of <code>TrainingJobSummary</code> objects, each listing a training job.</p>', ], ], 'TrainingJobSummary' => [ 'base' => '<p>Provides summary information about a training job.</p>', 'refs' => [ 'TrainingJobSummaries$member' => NULL, ], ], 'TrainingSpecification' => [ 'base' => '<p>Defines how the algorithm is used for a training job.</p>', 'refs' => [ 'CreateAlgorithmInput$TrainingSpecification' => '<p>Specifies details about training jobs run by this algorithm, including the following:</p> <ul> <li> <p>The Amazon ECR path of the container and the version digest of the algorithm.</p> </li> <li> <p>The hyperparameters that the algorithm supports.</p> </li> <li> <p>The instance types that the algorithm supports for training.</p> </li> <li> <p>Whether the algorithm supports distributed training.</p> </li> <li> <p>The metrics that the algorithm emits to Amazon CloudWatch.</p> </li> <li> <p>Which metrics that the algorithm emits can be used as the objective metric for hyperparameter tuning jobs.</p> </li> <li> <p>The input channels that the algorithm supports for training data. For example, an algorithm might support <code>train</code>, <code>validation</code>, and <code>test</code> channels.</p> </li> </ul>', 'DescribeAlgorithmOutput$TrainingSpecification' => '<p>Details about training jobs run by this algorithm.</p>', ], ], 'TrainingTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'DescribeTrainingJobResponse$TrainingTimeInSeconds' => '<p>The training time in seconds.</p>', 'TrainingJob$TrainingTimeInSeconds' => '<p>The training time in seconds.</p>', ], ], 'TransformDataSource' => [ 'base' => '<p>Describes the location of the channel data.</p>', 'refs' => [ 'TransformInput$DataSource' => '<p>Describes the location of the channel data, which is, the S3 location of the input data that the model can consume.</p>', ], ], 'TransformEnvironmentKey' => [ 'base' => NULL, 'refs' => [ 'TransformEnvironmentMap$key' => NULL, ], ], 'TransformEnvironmentMap' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$Environment' => '<p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>', 'DescribeTransformJobResponse$Environment' => '<p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>', 'TransformJob$Environment' => '<p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>', 'TransformJobDefinition$Environment' => '<p>The environment variables to set in the Docker container. We support up to 16 key and values entries in the map.</p>', ], ], 'TransformEnvironmentValue' => [ 'base' => NULL, 'refs' => [ 'TransformEnvironmentMap$value' => NULL, ], ], 'TransformInput' => [ 'base' => '<p>Describes the input source of a transform job and the way the transform job consumes it.</p>', 'refs' => [ 'CreateTransformJobRequest$TransformInput' => '<p>Describes the input source and the way the transform job consumes it.</p>', 'DescribeTransformJobResponse$TransformInput' => '<p>Describes the dataset to be transformed and the Amazon S3 location where it is stored.</p>', 'TransformJob$TransformInput' => NULL, 'TransformJobDefinition$TransformInput' => '<p>A description of the input source and the way the transform job consumes it.</p>', ], ], 'TransformInstanceCount' => [ 'base' => NULL, 'refs' => [ 'TransformResources$InstanceCount' => '<p>The number of ML compute instances to use in the transform job. For distributed transform jobs, specify a value greater than 1. The default value is <code>1</code>.</p>', ], ], 'TransformInstanceType' => [ 'base' => NULL, 'refs' => [ 'TransformInstanceTypes$member' => NULL, 'TransformResources$InstanceType' => '<p>The ML compute instance type for the transform job. If you are using built-in algorithms to transform moderately sized datasets, we recommend using ml.m4.xlarge or <code>ml.m5.large</code>instance types.</p>', ], ], 'TransformInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'AdditionalInferenceSpecificationDefinition$SupportedTransformInstanceTypes' => '<p>A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.</p>', 'InferenceSpecification$SupportedTransformInstanceTypes' => '<p>A list of the instance types on which a transformation job can be run or on which an endpoint can be deployed.</p> <p>This parameter is required for unversioned models, and optional for versioned models.</p>', ], ], 'TransformJob' => [ 'base' => '<p>A batch transform job. For information about SageMaker batch transform, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Use Batch Transform</a>.</p>', 'refs' => [ 'TrialComponentSourceDetail$TransformJob' => '<p>Information about a transform job that\'s the source of a trial component.</p>', ], ], 'TransformJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobResponse$TransformJobArn' => '<p>The Amazon Resource Name (ARN) of the transform job.</p>', 'DescribeTransformJobResponse$TransformJobArn' => '<p>The Amazon Resource Name (ARN) of the transform job.</p>', 'TransformJob$TransformJobArn' => '<p>The Amazon Resource Name (ARN) of the transform job.</p>', 'TransformJobStepMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the transform job that was run by this step execution.</p>', 'TransformJobSummary$TransformJobArn' => '<p>The Amazon Resource Name (ARN) of the transform job.</p>', ], ], 'TransformJobDefinition' => [ 'base' => '<p>Defines the input needed to run a transform job using the inference specification specified in the algorithm.</p>', 'refs' => [ 'AlgorithmValidationProfile$TransformJobDefinition' => '<p>The <code>TransformJobDefinition</code> object that describes the transform job that Amazon SageMaker runs to validate your algorithm.</p>', 'ModelPackageValidationProfile$TransformJobDefinition' => '<p>The <code>TransformJobDefinition</code> object that describes the transform job used for the validation of the model package.</p>', ], ], 'TransformJobName' => [ 'base' => NULL, 'refs' => [ 'CreateTransformJobRequest$TransformJobName' => '<p>The name of the transform job. The name must be unique within an Amazon Web Services Region in an Amazon Web Services account. </p>', 'DescribeTransformJobRequest$TransformJobName' => '<p>The name of the transform job that you want to view details of.</p>', 'DescribeTransformJobResponse$TransformJobName' => '<p>The name of the transform job.</p>', 'StopTransformJobRequest$TransformJobName' => '<p>The name of the batch transform job to stop.</p>', 'TransformJob$TransformJobName' => '<p>The name of the transform job.</p>', 'TransformJobSummary$TransformJobName' => '<p>The name of the transform job.</p>', ], ], 'TransformJobStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeTransformJobResponse$TransformJobStatus' => '<p>The status of the transform job. If the transform job failed, the reason is returned in the <code>FailureReason</code> field.</p>', 'ListTransformJobsRequest$StatusEquals' => '<p>A filter that retrieves only transform jobs with a specific status.</p>', 'TransformJob$TransformJobStatus' => '<p>The status of the transform job.</p> <p>Transform job statuses are:</p> <ul> <li> <p> <code>InProgress</code> - The job is in progress.</p> </li> <li> <p> <code>Completed</code> - The job has completed.</p> </li> <li> <p> <code>Failed</code> - The transform job has failed. To see the reason for the failure, see the <code>FailureReason</code> field in the response to a <code>DescribeTransformJob</code> call.</p> </li> <li> <p> <code>Stopping</code> - The transform job is stopping.</p> </li> <li> <p> <code>Stopped</code> - The transform job has stopped.</p> </li> </ul>', 'TransformJobSummary$TransformJobStatus' => '<p>The status of the transform job.</p>', ], ], 'TransformJobStepMetadata' => [ 'base' => '<p>Metadata for a transform job step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$TransformJob' => '<p>The Amazon Resource Name (ARN) of the transform job that was run by this step execution.</p>', ], ], 'TransformJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTransformJobsResponse$TransformJobSummaries' => '<p>An array of <code>TransformJobSummary</code> objects.</p>', ], ], 'TransformJobSummary' => [ 'base' => '<p>Provides a summary of a transform job. Multiple <code>TransformJobSummary</code> objects are returned as a list after in response to a <a>ListTransformJobs</a> call.</p>', 'refs' => [ 'TransformJobSummaries$member' => NULL, ], ], 'TransformOutput' => [ 'base' => '<p>Describes the results of a transform job.</p>', 'refs' => [ 'CreateTransformJobRequest$TransformOutput' => '<p>Describes the results of the transform job.</p>', 'DescribeTransformJobResponse$TransformOutput' => '<p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>', 'TransformJob$TransformOutput' => NULL, 'TransformJobDefinition$TransformOutput' => '<p>Identifies the Amazon S3 location where you want Amazon SageMaker to save the results from the transform job.</p>', ], ], 'TransformResources' => [ 'base' => '<p>Describes the resources, including ML instance types and ML instance count, to use for transform job.</p>', 'refs' => [ 'CreateTransformJobRequest$TransformResources' => '<p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>', 'DescribeTransformJobResponse$TransformResources' => '<p>Describes the resources, including ML instance types and ML instance count, to use for the transform job.</p>', 'TransformJob$TransformResources' => NULL, 'TransformJobDefinition$TransformResources' => '<p>Identifies the ML compute instances for the transform job.</p>', ], ], 'TransformS3DataSource' => [ 'base' => '<p>Describes the S3 data source.</p>', 'refs' => [ 'TransformDataSource$S3DataSource' => '<p>The S3 location of the data source that is associated with a channel.</p>', ], ], 'Trial' => [ 'base' => '<p>The properties of a trial as returned by the <a>Search</a> API.</p>', 'refs' => [ 'SearchRecord$Trial' => '<p>The properties of a trial.</p>', ], ], 'TrialArn' => [ 'base' => NULL, 'refs' => [ 'AssociateTrialComponentResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'CreateTrialResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'DeleteTrialResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial that is being deleted.</p>', 'DescribeTrialResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'DisassociateTrialComponentResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'Trial$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'TrialSummary$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', 'UpdateTrialResponse$TrialArn' => '<p>The Amazon Resource Name (ARN) of the trial.</p>', ], ], 'TrialComponent' => [ 'base' => '<p>The properties of a trial component as returned by the <a>Search</a> API.</p>', 'refs' => [ 'SearchRecord$TrialComponent' => '<p>The properties of a trial component.</p>', ], ], 'TrialComponentArn' => [ 'base' => NULL, 'refs' => [ 'AssociateTrialComponentResponse$TrialComponentArn' => '<p>The ARN of the trial component.</p>', 'CreateTrialComponentResponse$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', 'DeleteTrialComponentResponse$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the component is being deleted.</p>', 'DescribeTrialComponentResponse$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', 'DisassociateTrialComponentResponse$TrialComponentArn' => '<p>The ARN of the trial component.</p>', 'TrialComponent$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', 'TrialComponentSimpleSummary$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', 'TrialComponentSummary$TrialComponentArn' => '<p>The ARN of the trial component.</p>', 'UpdateTrialComponentResponse$TrialComponentArn' => '<p>The Amazon Resource Name (ARN) of the trial component.</p>', ], ], 'TrialComponentArtifact' => [ 'base' => '<p>Represents an input or output artifact of a trial component. You specify <code>TrialComponentArtifact</code> as part of the <code>InputArtifacts</code> and <code>OutputArtifacts</code> parameters in the <a>CreateTrialComponent</a> request.</p> <p>Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types. Examples of output artifacts are metrics, snapshots, logs, and images.</p>', 'refs' => [ 'TrialComponentArtifacts$value' => NULL, ], ], 'TrialComponentArtifactValue' => [ 'base' => NULL, 'refs' => [ 'TrialComponentArtifact$Value' => '<p>The location of the artifact.</p>', ], ], 'TrialComponentArtifacts' => [ 'base' => NULL, 'refs' => [ 'CreateTrialComponentRequest$InputArtifacts' => '<p>The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters, source code, and instance types.</p>', 'CreateTrialComponentRequest$OutputArtifacts' => '<p>The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images.</p>', 'DescribeTrialComponentResponse$InputArtifacts' => '<p>The input artifacts of the component.</p>', 'DescribeTrialComponentResponse$OutputArtifacts' => '<p>The output artifacts of the component.</p>', 'TrialComponent$InputArtifacts' => '<p>The input artifacts of the component.</p>', 'TrialComponent$OutputArtifacts' => '<p>The output artifacts of the component.</p>', 'UpdateTrialComponentRequest$InputArtifacts' => '<p>Replaces all of the component\'s input artifacts with the specified artifacts.</p>', 'UpdateTrialComponentRequest$OutputArtifacts' => '<p>Replaces all of the component\'s output artifacts with the specified artifacts.</p>', ], ], 'TrialComponentKey256' => [ 'base' => NULL, 'refs' => [ 'ListTrialComponentKey256$member' => NULL, 'TrialComponentParameters$key' => NULL, ], ], 'TrialComponentKey64' => [ 'base' => NULL, 'refs' => [ 'TrialComponentArtifacts$key' => NULL, ], ], 'TrialComponentMetricSummaries' => [ 'base' => NULL, 'refs' => [ 'DescribeTrialComponentResponse$Metrics' => '<p>The metrics for the component.</p>', 'TrialComponent$Metrics' => '<p>The metrics for the component.</p>', ], ], 'TrialComponentMetricSummary' => [ 'base' => '<p>A summary of the metrics of a trial component.</p>', 'refs' => [ 'TrialComponentMetricSummaries$member' => NULL, ], ], 'TrialComponentParameterValue' => [ 'base' => '<p>The value of a hyperparameter. Only one of <code>NumberValue</code> or <code>StringValue</code> can be specified.</p> <p>This object is specified in the <a>CreateTrialComponent</a> request.</p>', 'refs' => [ 'TrialComponentParameters$value' => NULL, ], ], 'TrialComponentParameters' => [ 'base' => NULL, 'refs' => [ 'CreateTrialComponentRequest$Parameters' => '<p>The hyperparameters for the component.</p>', 'DescribeTrialComponentResponse$Parameters' => '<p>The hyperparameters of the component.</p>', 'TrialComponent$Parameters' => '<p>The hyperparameters of the component.</p>', 'UpdateTrialComponentRequest$Parameters' => '<p>Replaces all of the component\'s hyperparameters with the specified hyperparameters.</p>', ], ], 'TrialComponentPrimaryStatus' => [ 'base' => NULL, 'refs' => [ 'TrialComponentStatus$PrimaryStatus' => '<p>The status of the trial component.</p>', ], ], 'TrialComponentSimpleSummaries' => [ 'base' => NULL, 'refs' => [ 'Trial$TrialComponentSummaries' => '<p>A list of the components associated with the trial. For each component, a summary of the component\'s properties is included.</p>', ], ], 'TrialComponentSimpleSummary' => [ 'base' => '<p>A short summary of a trial component.</p>', 'refs' => [ 'TrialComponentSimpleSummaries$member' => NULL, ], ], 'TrialComponentSource' => [ 'base' => '<p>The Amazon Resource Name (ARN) and job type of the source of a trial component.</p>', 'refs' => [ 'DescribeTrialComponentResponse$Source' => '<p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>', 'TrialComponent$Source' => '<p>The Amazon Resource Name (ARN) and job type of the source of the component.</p>', 'TrialComponentSimpleSummary$TrialComponentSource' => NULL, 'TrialComponentSummary$TrialComponentSource' => NULL, ], ], 'TrialComponentSourceArn' => [ 'base' => NULL, 'refs' => [ 'TrialComponentMetricSummary$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source.</p>', 'TrialComponentSource$SourceArn' => '<p>The source ARN.</p>', 'TrialComponentSourceDetail$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source.</p>', ], ], 'TrialComponentSourceDetail' => [ 'base' => '<p>Detailed information about the source of a trial component. Either <code>ProcessingJob</code> or <code>TrainingJob</code> is returned.</p>', 'refs' => [ 'TrialComponent$SourceDetail' => '<p>Details of the source of the component.</p>', ], ], 'TrialComponentStatus' => [ 'base' => '<p>The status of the trial component.</p>', 'refs' => [ 'CreateTrialComponentRequest$Status' => '<p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p> </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul>', 'DescribeTrialComponentResponse$Status' => '<p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p> </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul>', 'TrialComponent$Status' => NULL, 'TrialComponentSummary$Status' => '<p>The status of the component. States include:</p> <ul> <li> <p>InProgress</p> </li> <li> <p>Completed</p> </li> <li> <p>Failed</p> </li> </ul>', 'UpdateTrialComponentRequest$Status' => '<p>The new status of the component.</p>', ], ], 'TrialComponentStatusMessage' => [ 'base' => NULL, 'refs' => [ 'TrialComponentStatus$Message' => '<p>If the component failed, a message describing why.</p>', ], ], 'TrialComponentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrialComponentsResponse$TrialComponentSummaries' => '<p>A list of the summaries of your trial components.</p>', ], ], 'TrialComponentSummary' => [ 'base' => '<p>A summary of the properties of a trial component. To get all the properties, call the <a>DescribeTrialComponent</a> API and provide the <code>TrialComponentName</code>.</p>', 'refs' => [ 'TrialComponentSummaries$member' => NULL, ], ], 'TrialSource' => [ 'base' => '<p>The source of the trial.</p>', 'refs' => [ 'DescribeTrialResponse$Source' => '<p>The Amazon Resource Name (ARN) of the source and, optionally, the job type.</p>', 'Trial$Source' => NULL, 'TrialSummary$TrialSource' => NULL, ], ], 'TrialSourceArn' => [ 'base' => NULL, 'refs' => [ 'TrialSource$SourceArn' => '<p>The Amazon Resource Name (ARN) of the source.</p>', ], ], 'TrialSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTrialsResponse$TrialSummaries' => '<p>A list of the summaries of your trials.</p>', ], ], 'TrialSummary' => [ 'base' => '<p>A summary of the properties of a trial. To get the complete set of properties, call the <a>DescribeTrial</a> API and provide the <code>TrialName</code>.</p>', 'refs' => [ 'TrialSummaries$member' => NULL, ], ], 'TuningJobCompletionCriteria' => [ 'base' => '<p>The job completion criteria.</p>', 'refs' => [ 'HyperParameterTuningJobConfig$TuningJobCompletionCriteria' => '<p>The tuning job\'s completion criteria.</p>', ], ], 'TuningJobStepMetaData' => [ 'base' => '<p>Metadata for a tuning step.</p>', 'refs' => [ 'PipelineExecutionStepMetadata$TuningJob' => '<p>The Amazon Resource Name (ARN) of the tuning job that was run by this step execution.</p>', ], ], 'USD' => [ 'base' => '<p>Represents an amount of money in United States dollars.</p>', 'refs' => [ 'PublicWorkforceTaskPrice$AmountInUsd' => '<p>Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars.</p>', ], ], 'UiConfig' => [ 'base' => '<p>Provided configuration information for the worker UI for a labeling job. Provide either <code>HumanTaskUiArn</code> or <code>UiTemplateS3Uri</code>.</p> <p>For named entity recognition, 3D point cloud and video frame labeling jobs, use <code>HumanTaskUiArn</code>.</p> <p>For all other Ground Truth built-in task types and custom task types, use <code>UiTemplateS3Uri</code> to specify the location of a worker task template in Amazon S3.</p>', 'refs' => [ 'HumanTaskConfig$UiConfig' => '<p>Information about the user interface that workers use to complete the labeling task.</p>', ], ], 'UiTemplate' => [ 'base' => '<p>The Liquid template for the worker user interface.</p>', 'refs' => [ 'CreateHumanTaskUiRequest$UiTemplate' => NULL, 'RenderUiTemplateRequest$UiTemplate' => '<p>A <code>Template</code> object containing the worker UI template to render.</p>', ], ], 'UiTemplateInfo' => [ 'base' => '<p>Container for user interface template information.</p>', 'refs' => [ 'DescribeHumanTaskUiResponse$UiTemplate' => NULL, ], ], 'UpdateActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppImageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppImageConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateArtifactRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateArtifactResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCodeRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCodeRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContextRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContextResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDeviceFleetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDevicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointWeightsAndCapacitiesInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointWeightsAndCapacitiesOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImageRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateImageResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelPackageInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateModelPackageOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitoringScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitoringScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookInstanceLifecycleConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookInstanceLifecycleConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNotebookInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePipelineExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePipelineExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePipelineRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePipelineResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrainingJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrainingJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrialComponentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrialComponentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrialRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrialResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkforceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkforceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkteamRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkteamResponse' => [ 'base' => NULL, 'refs' => [], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'AutoMLContainerDefinition$ModelDataUrl' => '<p>The location of the model artifacts. For more information, see .</p>', 'ContainerDefinition$ModelDataUrl' => '<p>The S3 path where the model artifacts, which result from model training, are stored. This path must point to a single gzip compressed tar archive (.tar.gz suffix). The S3 path is required for Amazon SageMaker built-in algorithms, but not if you use your own algorithms. For more information on built-in algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html">Common Parameters</a>. </p> <note> <p>The model artifacts must be in an S3 bucket that is in the same region as the model or endpoint you are creating.</p> </note> <p>If you provide a value for this parameter, Amazon SageMaker uses Amazon Web Services Security Token Service to download model artifacts from the S3 path you provide. Amazon Web Services STS is activated in your IAM user account by default. If you previously deactivated Amazon Web Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services Identity and Access Management User Guide</i>.</p> <important> <p>If you use a built-in algorithm to create a model, Amazon SageMaker requires that you provide a S3 path to the model artifacts in <code>ModelDataUrl</code>.</p> </important>', 'ModelPackageContainerDefinition$ModelDataUrl' => '<p>The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).</p> <note> <p>The model artifacts must be in an S3 bucket that is in the same region as the model package.</p> </note>', 'SourceAlgorithm$ModelDataUrl' => '<p>The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).</p> <note> <p>The model artifacts must be in an S3 bucket that is in the same region as the algorithm.</p> </note>', ], ], 'UserContext' => [ 'base' => '<p>Information about the user who created or modified an experiment, trial, trial component, lineage group, or project.</p>', 'refs' => [ 'AssociationSummary$CreatedBy' => NULL, 'DescribeActionResponse$CreatedBy' => NULL, 'DescribeActionResponse$LastModifiedBy' => NULL, 'DescribeArtifactResponse$CreatedBy' => NULL, 'DescribeArtifactResponse$LastModifiedBy' => NULL, 'DescribeContextResponse$CreatedBy' => NULL, 'DescribeContextResponse$LastModifiedBy' => NULL, 'DescribeExperimentResponse$CreatedBy' => '<p>Who created the experiment.</p>', 'DescribeExperimentResponse$LastModifiedBy' => '<p>Who last modified the experiment.</p>', 'DescribeLineageGroupResponse$CreatedBy' => NULL, 'DescribeLineageGroupResponse$LastModifiedBy' => NULL, 'DescribeModelPackageGroupOutput$CreatedBy' => NULL, 'DescribeModelPackageOutput$CreatedBy' => NULL, 'DescribeModelPackageOutput$LastModifiedBy' => NULL, 'DescribePipelineExecutionResponse$CreatedBy' => NULL, 'DescribePipelineExecutionResponse$LastModifiedBy' => NULL, 'DescribePipelineResponse$CreatedBy' => NULL, 'DescribePipelineResponse$LastModifiedBy' => NULL, 'DescribeProjectOutput$CreatedBy' => NULL, 'DescribeProjectOutput$LastModifiedBy' => NULL, 'DescribeTrialComponentResponse$CreatedBy' => '<p>Who created the trial component.</p>', 'DescribeTrialComponentResponse$LastModifiedBy' => '<p>Who last modified the component.</p>', 'DescribeTrialResponse$CreatedBy' => '<p>Who created the trial.</p>', 'DescribeTrialResponse$LastModifiedBy' => '<p>Who last modified the trial.</p>', 'Experiment$CreatedBy' => '<p>Who created the experiment.</p>', 'Experiment$LastModifiedBy' => NULL, 'ModelPackage$CreatedBy' => NULL, 'ModelPackage$LastModifiedBy' => NULL, 'ModelPackageGroup$CreatedBy' => NULL, 'Pipeline$CreatedBy' => NULL, 'Pipeline$LastModifiedBy' => NULL, 'PipelineExecution$CreatedBy' => NULL, 'PipelineExecution$LastModifiedBy' => NULL, 'Project$CreatedBy' => '<p>Who created the project.</p>', 'Project$LastModifiedBy' => NULL, 'Trial$CreatedBy' => '<p>Who created the trial.</p>', 'Trial$LastModifiedBy' => NULL, 'TrialComponent$CreatedBy' => '<p>Who created the trial component.</p>', 'TrialComponent$LastModifiedBy' => NULL, 'TrialComponentSimpleSummary$CreatedBy' => NULL, 'TrialComponentSummary$CreatedBy' => '<p>Who created the trial component.</p>', 'TrialComponentSummary$LastModifiedBy' => '<p>Who last modified the component.</p>', ], ], 'UserProfileArn' => [ 'base' => NULL, 'refs' => [ 'CreateUserProfileResponse$UserProfileArn' => '<p>The user profile Amazon Resource Name (ARN).</p>', 'DescribeUserProfileResponse$UserProfileArn' => '<p>The user profile Amazon Resource Name (ARN).</p>', 'UpdateUserProfileResponse$UserProfileArn' => '<p>The user profile Amazon Resource Name (ARN).</p>', ], ], 'UserProfileDetails' => [ 'base' => '<p>The user profile details.</p>', 'refs' => [ 'UserProfileList$member' => NULL, ], ], 'UserProfileList' => [ 'base' => NULL, 'refs' => [ 'ListUserProfilesResponse$UserProfiles' => '<p>The list of user profiles.</p>', ], ], 'UserProfileName' => [ 'base' => NULL, 'refs' => [ 'AppDetails$UserProfileName' => '<p>The user profile name.</p>', 'CreateAppRequest$UserProfileName' => '<p>The user profile name.</p>', 'CreatePresignedDomainUrlRequest$UserProfileName' => '<p>The name of the UserProfile to sign-in as.</p>', 'CreateUserProfileRequest$UserProfileName' => '<p>A name for the UserProfile. This value is not case sensitive.</p>', 'DeleteAppRequest$UserProfileName' => '<p>The user profile name.</p>', 'DeleteUserProfileRequest$UserProfileName' => '<p>The user profile name.</p>', 'DescribeAppRequest$UserProfileName' => '<p>The user profile name.</p>', 'DescribeAppResponse$UserProfileName' => '<p>The user profile name.</p>', 'DescribeUserProfileRequest$UserProfileName' => '<p>The user profile name. This value is not case sensitive.</p>', 'DescribeUserProfileResponse$UserProfileName' => '<p>The user profile name.</p>', 'ListAppsRequest$UserProfileNameEquals' => '<p>A parameter to search by user profile name.</p>', 'ListUserProfilesRequest$UserProfileNameContains' => '<p>A parameter by which to filter the results.</p>', 'UpdateUserProfileRequest$UserProfileName' => '<p>The user profile name.</p>', 'UserProfileDetails$UserProfileName' => '<p>The user profile name.</p>', ], ], 'UserProfileSortKey' => [ 'base' => NULL, 'refs' => [ 'ListUserProfilesRequest$SortBy' => '<p>The parameter by which to sort the results. The default is CreationTime.</p>', ], ], 'UserProfileStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeUserProfileResponse$Status' => '<p>The status.</p>', 'UserProfileDetails$Status' => '<p>The status.</p>', ], ], 'UserSettings' => [ 'base' => '<p>A collection of settings that apply to users of Amazon SageMaker Studio. These settings are specified when the <code>CreateUserProfile</code> API is called, and as <code>DefaultUserSettings</code> when the <code>CreateDomain</code> API is called.</p> <p> <code>SecurityGroups</code> is aggregated when specified in both calls. For all other settings in <code>UserSettings</code>, the values specified in <code>CreateUserProfile</code> take precedence over those specified in <code>CreateDomain</code>.</p>', 'refs' => [ 'CreateDomainRequest$DefaultUserSettings' => '<p>The default settings to use to create a user profile when <code>UserSettings</code> isn\'t specified in the call to the <code>CreateUserProfile</code> API.</p> <p> <code>SecurityGroups</code> is aggregated when specified in both calls. For all other settings in <code>UserSettings</code>, the values specified in <code>CreateUserProfile</code> take precedence over those specified in <code>CreateDomain</code>.</p>', 'CreateUserProfileRequest$UserSettings' => '<p>A collection of settings.</p>', 'DescribeDomainResponse$DefaultUserSettings' => '<p>Settings which are applied to UserProfiles in this domain if settings are not explicitly specified in a given UserProfile. </p>', 'DescribeUserProfileResponse$UserSettings' => '<p>A collection of settings.</p>', 'UpdateDomainRequest$DefaultUserSettings' => '<p>A collection of settings.</p>', 'UpdateUserProfileRequest$UserSettings' => '<p>A collection of settings.</p>', ], ], 'VariantName' => [ 'base' => NULL, 'refs' => [ 'DesiredWeightAndCapacity$VariantName' => '<p>The name of the variant to update.</p>', 'PendingProductionVariantSummary$VariantName' => '<p>The name of the variant.</p>', 'ProductionVariant$VariantName' => '<p>The name of the production variant.</p>', 'ProductionVariantSummary$VariantName' => '<p>The name of the variant.</p>', ], ], 'VariantProperty' => [ 'base' => '<p>Specifies a production variant property type for an Endpoint.</p> <p>If you are updating an endpoint with the <a>UpdateEndpointInput$RetainAllVariantProperties</a> option set to <code>true</code>, the <code>VariantProperty</code> objects listed in <a>UpdateEndpointInput$ExcludeRetainedVariantProperties</a> override the existing variant properties of the endpoint.</p>', 'refs' => [ 'VariantPropertyList$member' => NULL, ], ], 'VariantPropertyList' => [ 'base' => NULL, 'refs' => [ 'UpdateEndpointInput$ExcludeRetainedVariantProperties' => '<p>When you are updating endpoint resources with <a>UpdateEndpointInput$RetainAllVariantProperties</a>, whose value is set to <code>true</code>, <code>ExcludeRetainedVariantProperties</code> specifies the list of type <a>VariantProperty</a> to override with the values provided by <code>EndpointConfig</code>. If you don\'t specify a value for <code>ExcludeAllVariantProperties</code>, no variant properties are overridden. </p>', ], ], 'VariantPropertyType' => [ 'base' => NULL, 'refs' => [ 'VariantProperty$VariantPropertyType' => '<p>The type of variant property. The supported values are:</p> <ul> <li> <p> <code>DesiredInstanceCount</code>: Overrides the existing variant instance counts using the <a>ProductionVariant$InitialInstanceCount</a> values in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p> </li> <li> <p> <code>DesiredWeight</code>: Overrides the existing variant weights using the <a>ProductionVariant$InitialVariantWeight</a> values in the <a>CreateEndpointConfigInput$ProductionVariants</a>.</p> </li> <li> <p> <code>DataCaptureConfig</code>: (Not currently supported.)</p> </li> </ul>', ], ], 'VariantStatus' => [ 'base' => NULL, 'refs' => [ 'ProductionVariantStatus$Status' => '<p>The endpoint variant status which describes the current deployment stage status or operational status.</p> <ul> <li> <p> <code>Creating</code>: Creating inference resources for the production variant.</p> </li> <li> <p> <code>Deleting</code>: Terminating inference resources for the production variant.</p> </li> <li> <p> <code>Updating</code>: Updating capacity for the production variant.</p> </li> <li> <p> <code>ActivatingTraffic</code>: Turning on traffic for the production variant.</p> </li> <li> <p> <code>Baking</code>: Waiting period to monitor the CloudWatch alarms in the automatic rollback configuration.</p> </li> </ul>', ], ], 'VariantStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ProductionVariantStatus$StatusMessage' => '<p>A message that describes the status of the production variant.</p>', ], ], 'VariantWeight' => [ 'base' => NULL, 'refs' => [ 'DesiredWeightAndCapacity$DesiredWeight' => '<p>The variant\'s weight.</p>', 'PendingProductionVariantSummary$CurrentWeight' => '<p>The weight associated with the variant.</p>', 'PendingProductionVariantSummary$DesiredWeight' => '<p>The requested weight for the variant in this deployment, as specified in the endpoint configuration for the endpoint. The value is taken from the request to the <code> <a>CreateEndpointConfig</a> </code> operation.</p>', 'ProductionVariant$InitialVariantWeight' => '<p>Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. The traffic to a production variant is determined by the ratio of the <code>VariantWeight</code> to the sum of all <code>VariantWeight</code> values across all ProductionVariants. If unspecified, it defaults to 1.0. </p>', 'ProductionVariantSummary$CurrentWeight' => '<p>The weight associated with the variant.</p>', 'ProductionVariantSummary$DesiredWeight' => '<p>The requested weight, as specified in the <code>UpdateEndpointWeightsAndCapacities</code> request. </p>', ], ], 'VersionId' => [ 'base' => NULL, 'refs' => [ 'PipelineDefinitionS3Location$VersionId' => '<p>Version Id of the pipeline definition file. If not specified, Amazon SageMaker will retrieve the latest version.</p>', ], ], 'VersionedArnOrName' => [ 'base' => NULL, 'refs' => [ 'ContainerDefinition$ModelPackageName' => '<p>The name or Amazon Resource Name (ARN) of the model package to use to create the model.</p>', 'DeleteModelPackageInput$ModelPackageName' => '<p>The name or Amazon Resource Name (ARN) of the model package to delete.</p> <p>When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', 'DescribeModelPackageInput$ModelPackageName' => '<p>The name or Amazon Resource Name (ARN) of the model package to describe.</p> <p>When you specify a name, the name must have 1 to 63 characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).</p>', ], ], 'Vertex' => [ 'base' => '<p>A lineage entity connected to the starting entity(ies).</p>', 'refs' => [ 'Vertices$member' => NULL, ], ], 'Vertices' => [ 'base' => NULL, 'refs' => [ 'QueryLineageResponse$Vertices' => '<p>A list of vertices connected to the start entity(ies) in the lineage graph.</p>', ], ], 'VolumeSizeInGB' => [ 'base' => NULL, 'refs' => [ 'ResourceConfig$VolumeSizeInGB' => '<p>The size of the ML storage volume that you want to provision. </p> <p>ML storage volumes store model artifacts and incremental states. Training algorithms might also use the ML storage volume for scratch space. If you want to store the training data in the ML storage volume, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. </p> <p>You must specify sufficient ML storage for your scenario. </p> <note> <p> Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume type. </p> </note> <note> <p>Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type. When using these instances for training, Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2 storage. You can\'t request a <code>VolumeSizeInGB</code> greater than the total size of the local instance storage.</p> <p>For a list of instance types that support local instance storage, including the total size per instance type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance Store Volumes</a>.</p> </note>', ], ], 'VpcConfig' => [ 'base' => '<p>Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>. </p>', 'refs' => [ 'AutoMLSecurityConfig$VpcConfig' => '<p>The VPC configuration.</p>', 'CreateModelInput$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that you want your model to connect to. Control access to and from your model container by configuring the VPC. <code>VpcConfig</code> is used in hosting services and in batch transform. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html">Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'CreateTrainingJobRequest$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that you want your training job to connect to. Control access to and from your training container by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'DescribeModelOutput$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that this model has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> </p>', 'DescribeTrainingJobResponse$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'HyperParameterTrainingJobDefinition$VpcConfig' => '<p>The <a>VpcConfig</a> object that specifies the VPC that you want the training jobs that this hyperparameter tuning job launches to connect to. Control access to and from your training container by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', 'MonitoringNetworkConfig$VpcConfig' => NULL, 'NetworkConfig$VpcConfig' => NULL, 'TrainingJob$VpcConfig' => '<p>A <a>VpcConfig</a> object that specifies the VPC that this training job has access to. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a>.</p>', ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$VpcId' => '<p>The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>', 'DescribeDomainResponse$VpcId' => '<p>The ID of the Amazon Virtual Private Cloud (VPC) that Studio uses for communication.</p>', ], ], 'VpcSecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$SecurityGroupIds' => '<p>The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.</p>', ], ], 'WaitIntervalInSeconds' => [ 'base' => NULL, 'refs' => [ 'TrafficRoutingConfig$WaitIntervalInSeconds' => '<p>The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet.</p>', ], ], 'Workforce' => [ 'base' => '<p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>', 'refs' => [ 'DescribeWorkforceResponse$Workforce' => '<p>A single private workforce, which is automatically created when you create your first private work team. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>', 'UpdateWorkforceResponse$Workforce' => '<p>A single private workforce. You can create one private work force in each Amazon Web Services Region. By default, any workforce-related API operation used in a specific region will apply to the workforce created in that region. To learn how to create a private workforce, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html">Create a Private Workforce</a>.</p>', 'Workforces$member' => NULL, ], ], 'WorkforceArn' => [ 'base' => NULL, 'refs' => [ 'CreateWorkforceResponse$WorkforceArn' => '<p>The Amazon Resource Name (ARN) of the workforce.</p>', 'Workforce$WorkforceArn' => '<p>The Amazon Resource Name (ARN) of the private workforce.</p>', 'Workteam$WorkforceArn' => '<p>The Amazon Resource Name (ARN) of the workforce.</p>', ], ], 'WorkforceName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkforceRequest$WorkforceName' => '<p>The name of the private workforce.</p>', 'CreateWorkteamRequest$WorkforceName' => '<p>The name of the workforce.</p>', 'DeleteWorkforceRequest$WorkforceName' => '<p>The name of the workforce.</p>', 'DescribeWorkforceRequest$WorkforceName' => '<p>The name of the private workforce whose access you want to restrict. <code>WorkforceName</code> is automatically set to <code>default</code> when a workforce is created and cannot be modified. </p>', 'ListWorkforcesRequest$NameContains' => '<p>A filter you can use to search for workforces using part of the workforce name.</p>', 'UpdateWorkforceRequest$WorkforceName' => '<p>The name of the private workforce that you want to update. You can find your workforce name by using the operation.</p>', 'Workforce$WorkforceName' => '<p>The name of the private workforce.</p>', ], ], 'Workforces' => [ 'base' => NULL, 'refs' => [ 'ListWorkforcesResponse$Workforces' => '<p>A list containing information about your workforce.</p>', ], ], 'Workteam' => [ 'base' => '<p>Provides details about a labeling work team.</p>', 'refs' => [ 'DescribeWorkteamResponse$Workteam' => '<p>A <code>Workteam</code> instance that contains information about the work team. </p>', 'UpdateWorkteamResponse$Workteam' => '<p>A <code>Workteam</code> object that describes the updated work team.</p>', 'Workteams$member' => NULL, ], ], 'WorkteamArn' => [ 'base' => NULL, 'refs' => [ 'CreateWorkteamResponse$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the work team. You can use this ARN to identify the work team.</p>', 'DescribeSubscribedWorkteamRequest$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the subscribed work team to describe.</p>', 'HumanLoopConfig$WorkteamArn' => '<p>Amazon Resource Name (ARN) of a team of workers. To learn more about the types of workforces and work teams you can create and use with Amazon A2I, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management.html">Create and Manage Workforces</a>.</p>', 'HumanTaskConfig$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.</p>', 'LabelingJobSummary$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the work team assigned to the job.</p>', 'ListLabelingJobsForWorkteamRequest$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the work team for which you want to see labeling jobs for.</p>', 'SubscribedWorkteam$WorkteamArn' => '<p>The Amazon Resource Name (ARN) of the vendor that you have subscribed.</p>', 'Workteam$WorkteamArn' => '<p>The Amazon Resource Name (ARN) that identifies the work team.</p>', ], ], 'WorkteamName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkteamRequest$WorkteamName' => '<p>The name of the work team. Use this name to identify the work team.</p>', 'DeleteWorkteamRequest$WorkteamName' => '<p>The name of the work team to delete.</p>', 'DescribeWorkteamRequest$WorkteamName' => '<p>The name of the work team to return a description of.</p>', 'ListSubscribedWorkteamsRequest$NameContains' => '<p>A string in the work team name. This filter returns only work teams whose name contains the specified string.</p>', 'ListWorkteamsRequest$NameContains' => '<p>A string in the work team\'s name. This filter returns only work teams whose name contains the specified string.</p>', 'UpdateWorkteamRequest$WorkteamName' => '<p>The name of the work team to update.</p>', 'Workteam$WorkteamName' => '<p>The name of the work team.</p>', ], ], 'Workteams' => [ 'base' => NULL, 'refs' => [ 'ListWorkteamsResponse$Workteams' => '<p>An array of <code>Workteam</code> objects, each describing a work team.</p>', ], ], ],];
