<?php
// This file was auto-generated from sdk-root/src/data/mediaconnect/2018-11-14/docs-2.json
return [ 'version' => '2.0', 'service' => 'API for AWS Elemental MediaConnect', 'operations' => [ 'AddFlowMediaStreams' => 'Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.', 'AddFlowOutputs' => 'Adds outputs to an existing flow. You can create up to 50 outputs per flow.', 'AddFlowSources' => 'Adds Sources to flow', 'AddFlowVpcInterfaces' => 'Adds VPC interfaces to flow', 'CreateFlow' => 'Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).', 'DeleteFlow' => 'Deletes a flow. Before you can delete a flow, you must stop the flow.', 'DescribeFlow' => 'Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.', 'DescribeOffering' => 'Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).', 'DescribeReservation' => 'Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).', 'GrantFlowEntitlements' => 'Grants entitlements to an existing flow.', 'ListEntitlements' => 'Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.', 'ListFlows' => 'Displays a list of flows that are associated with this account. This request returns a paginated result.', 'ListOfferings' => 'Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you\'ve purchased an offering that has already started and hasn\'t expired yet), your account isn\'t eligible for other offerings.', 'ListReservations' => 'Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).', 'ListTagsForResource' => 'List all tags on an AWS Elemental MediaConnect resource', 'PurchaseOffering' => 'Submits a request to purchase an offering. If you already have an active reservation, you can\'t purchase another offering.', 'RemoveFlowMediaStream' => 'Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.', 'RemoveFlowOutput' => 'Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.', 'RemoveFlowSource' => 'Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.', 'RemoveFlowVpcInterface' => 'Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.', 'RevokeFlowEntitlement' => 'Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.', 'StartFlow' => 'Starts a flow.', 'StopFlow' => 'Stops a flow.', 'TagResource' => 'Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.', 'UntagResource' => 'Deletes specified tags from a resource.', 'UpdateFlow' => 'Updates flow', 'UpdateFlowEntitlement' => 'You can change an entitlement\'s description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.', 'UpdateFlowMediaStream' => 'Updates an existing media stream.', 'UpdateFlowOutput' => 'Updates an existing flow output.', 'UpdateFlowSource' => 'Updates the source of a flow.', ], 'shapes' => [ 'AddFlowMediaStreamsRequest' => [ 'base' => 'Adds media streams to an existing flow.', 'refs' => [], ], 'AddFlowMediaStreamsResponse' => [ 'base' => 'The result of a successful AddFlowMediaStreamsRequest request. The response includes the details of the newly added media streams.', 'refs' => [], ], 'AddFlowOutputs420Exception' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'AddFlowOutputsRequest' => [ 'base' => 'Adds outputs to an existing flow. You can create up to 50 outputs per flow.', 'refs' => [], ], 'AddFlowOutputsResponse' => [ 'base' => 'The result of a successful AddOutput request. The response includes the details of the newly added outputs.', 'refs' => [], ], 'AddFlowSourcesRequest' => [ 'base' => 'Adds sources to an existing flow.', 'refs' => [], ], 'AddFlowSourcesResponse' => [ 'base' => 'The result of a successful AddFlowSources request. The response includes the details of the newly added sources.', 'refs' => [], ], 'AddFlowVpcInterfacesRequest' => [ 'base' => 'Adds VPC interfaces to an existing flow.', 'refs' => [], ], 'AddFlowVpcInterfacesResponse' => [ 'base' => 'The result of a successful AddFlowVpcInterfaces request. The response includes the details of the newly added VPC interfaces.', 'refs' => [], ], 'AddMediaStreamRequest' => [ 'base' => 'The media stream that you want to add to the flow.', 'refs' => [ '__listOfAddMediaStreamRequest$member' => NULL, ], ], 'AddOutputRequest' => [ 'base' => 'The output that you want to add to this flow.', 'refs' => [ '__listOfAddOutputRequest$member' => NULL, ], ], 'Algorithm' => [ 'base' => NULL, 'refs' => [ 'Encryption$Algorithm' => 'The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).', 'UpdateEncryption$Algorithm' => 'The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).', ], ], 'BadRequestException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'Colorimetry' => [ 'base' => NULL, 'refs' => [ 'Fmtp$Colorimetry' => 'The format that is used for the representation of color.', 'FmtpRequest$Colorimetry' => 'The format that is used for the representation of color.', ], ], 'CreateFlow420Exception' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'CreateFlowRequest' => [ 'base' => 'Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50.)', 'refs' => [], ], 'CreateFlowResponse' => [ 'base' => 'The result of a successful CreateFlow request.', 'refs' => [], ], 'DeleteFlowResponse' => [ 'base' => 'The result of a successful DeleteFlow request.', 'refs' => [], ], 'DescribeFlowResponse' => [ 'base' => 'The result of a successful DescribeFlow request.', 'refs' => [], ], 'DescribeOfferingResponse' => [ 'base' => 'The result of a successful DescribeOffering request.', 'refs' => [], ], 'DescribeReservationResponse' => [ 'base' => 'The result of a successful DescribeReservation request.', 'refs' => [], ], 'DestinationConfiguration' => [ 'base' => 'The transport parameters that are associated with an outbound media stream.', 'refs' => [ '__listOfDestinationConfiguration$member' => NULL, ], ], 'DestinationConfigurationRequest' => [ 'base' => 'The transport parameters that you want to associate with an outbound media stream.', 'refs' => [ '__listOfDestinationConfigurationRequest$member' => NULL, ], ], 'DurationUnits' => [ 'base' => NULL, 'refs' => [ 'Offering$DurationUnits' => 'The unit of measurement for the duration of the offering.', 'Reservation$DurationUnits' => 'The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.', ], ], 'EncoderProfile' => [ 'base' => NULL, 'refs' => [ 'EncodingParameters$EncoderProfile' => 'A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.', 'EncodingParametersRequest$EncoderProfile' => 'A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, if at least one source on the flow uses the CDI protocol.', ], ], 'EncodingName' => [ 'base' => NULL, 'refs' => [ 'MediaStreamOutputConfiguration$EncodingName' => 'The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.', 'MediaStreamOutputConfigurationRequest$EncodingName' => 'The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.', 'MediaStreamSourceConfiguration$EncodingName' => 'The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.', 'MediaStreamSourceConfigurationRequest$EncodingName' => 'The format you want to use to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.', ], ], 'EncodingParameters' => [ 'base' => 'A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.', 'refs' => [ 'MediaStreamOutputConfiguration$EncodingParameters' => 'Encoding parameters', ], ], 'EncodingParametersRequest' => [ 'base' => 'A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.', 'refs' => [ 'MediaStreamOutputConfigurationRequest$EncodingParameters' => 'A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.', ], ], 'Encryption' => [ 'base' => 'Information about the encryption of the flow.', 'refs' => [ 'AddOutputRequest$Encryption' => 'The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.', 'Entitlement$Encryption' => 'The type of encryption that will be used on the output that is associated with this entitlement.', 'GrantEntitlementRequest$Encryption' => 'The type of encryption that will be used on the output that is associated with this entitlement. Allowable encryption types: static-key, speke.', 'Output$Encryption' => 'The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).', 'SetSourceRequest$Decryption' => 'The type of encryption that is used on the content ingested from this source. Allowable encryption types: static-key.', 'Source$Decryption' => 'The type of encryption that is used on the content ingested from this source.', ], ], 'Entitlement' => [ 'base' => 'The settings for a flow entitlement.', 'refs' => [ 'UpdateFlowEntitlementResponse$Entitlement' => 'The new configuration of the entitlement that you updated.', '__listOfEntitlement$member' => NULL, ], ], 'EntitlementStatus' => [ 'base' => NULL, 'refs' => [ 'Entitlement$EntitlementStatus' => 'An indication of whether the entitlement is enabled.', 'GrantEntitlementRequest$EntitlementStatus' => 'An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.', 'UpdateFlowEntitlementRequest$EntitlementStatus' => 'An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.', ], ], 'FailoverConfig' => [ 'base' => 'The settings for source failover.', 'refs' => [ 'CreateFlowRequest$SourceFailoverConfig' => NULL, 'Flow$SourceFailoverConfig' => NULL, ], ], 'FailoverMode' => [ 'base' => NULL, 'refs' => [ 'FailoverConfig$FailoverMode' => 'The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.', 'UpdateFailoverConfig$FailoverMode' => 'The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.', ], ], 'Flow' => [ 'base' => 'The settings for a flow, including its source, outputs, and entitlements.', 'refs' => [ 'CreateFlowResponse$Flow' => NULL, 'DescribeFlowResponse$Flow' => NULL, 'UpdateFlowResponse$Flow' => NULL, ], ], 'Fmtp' => [ 'base' => 'FMTP', 'refs' => [ 'MediaStreamAttributes$Fmtp' => 'A set of parameters that define the media stream.', ], ], 'FmtpRequest' => [ 'base' => 'The settings that you want to use to define the media stream.', 'refs' => [ 'MediaStreamAttributesRequest$Fmtp' => 'The settings that you want to use to define the media stream.', ], ], 'ForbiddenException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'GrantEntitlementRequest' => [ 'base' => 'The entitlements that you want to grant on a flow.', 'refs' => [ '__listOfGrantEntitlementRequest$member' => NULL, ], ], 'GrantFlowEntitlements420Exception' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'GrantFlowEntitlementsRequest' => [ 'base' => 'Grants an entitlement on a flow.', 'refs' => [], ], 'GrantFlowEntitlementsResponse' => [ 'base' => 'The entitlements that were just granted.', 'refs' => [], ], 'InputConfiguration' => [ 'base' => 'The transport parameters that are associated with an incoming media stream.', 'refs' => [ '__listOfInputConfiguration$member' => NULL, ], ], 'InputConfigurationRequest' => [ 'base' => 'The transport parameters that you want to associate with an incoming media stream.', 'refs' => [ '__listOfInputConfigurationRequest$member' => NULL, ], ], 'Interface' => [ 'base' => 'The VPC interface that is used for the media stream associated with the source or output.', 'refs' => [ 'DestinationConfiguration$Interface' => 'The VPC interface that is used for the media stream associated with the output.', 'InputConfiguration$Interface' => 'The VPC interface where the media stream comes in from.', ], ], 'InterfaceRequest' => [ 'base' => 'The VPC interface that you want to designate where the media stream is coming from or going to.', 'refs' => [ 'DestinationConfigurationRequest$Interface' => 'The VPC interface that you want to use for the media stream associated with the output.', 'InputConfigurationRequest$Interface' => 'The VPC interface that you want to use for the incoming media stream.', ], ], 'InternalServerErrorException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'KeyType' => [ 'base' => NULL, 'refs' => [ 'Encryption$KeyType' => 'The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).', 'UpdateEncryption$KeyType' => 'The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).', ], ], 'ListEntitlementsResponse' => [ 'base' => 'The result of a successful ListEntitlements request. The response includes the ARN of each entitlement, the name of the associated flow, and the NextToken to use in a subsequent ListEntitlements request.', 'refs' => [], ], 'ListFlowsResponse' => [ 'base' => 'The result of a successful ListFlows request. The response includes flow summaries and the NextToken to use in a subsequent ListFlows request.', 'refs' => [], ], 'ListOfferingsResponse' => [ 'base' => 'The result of a successful ListOfferings request. The response includes the details of each offering that your account is eligible for. The response includes the following information for each offering: description, duration, outbound bandwidth, price, Amazon Resource Name (ARN), and the NextToken to use in a subsequent ListOfferings request.', 'refs' => [], ], 'ListReservationsResponse' => [ 'base' => 'The result of a successful ListReservations request. The response includes the details of each offering that your account is eligible for. The response includes the following information for each offering: description, duration, outbound bandwidth, price, Amazon Resource Name (ARN), and the NextToken to use in a subsequent ListOfferings request.', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => 'The tags for the resource.', 'refs' => [], ], 'ListedEntitlement' => [ 'base' => 'An entitlement that has been granted to you from other AWS accounts.', 'refs' => [ '__listOfListedEntitlement$member' => NULL, ], ], 'ListedFlow' => [ 'base' => 'Provides a summary of a flow, including its ARN, Availability Zone, and source type.', 'refs' => [ '__listOfListedFlow$member' => NULL, ], ], 'MediaStream' => [ 'base' => 'A single track or stream of media that contains video, audio, or ancillary data. After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.', 'refs' => [ 'UpdateFlowMediaStreamResponse$MediaStream' => 'The media stream that you updated.', '__listOfMediaStream$member' => NULL, ], ], 'MediaStreamAttributes' => [ 'base' => 'Attributes that are related to the media stream.', 'refs' => [ 'MediaStream$Attributes' => 'Attributes that are related to the media stream.', ], ], 'MediaStreamAttributesRequest' => [ 'base' => 'Attributes that are related to the media stream.', 'refs' => [ 'AddMediaStreamRequest$Attributes' => 'The attributes that you want to assign to the new media stream.', 'UpdateFlowMediaStreamRequest$Attributes' => 'The attributes that you want to assign to the media stream.', ], ], 'MediaStreamOutputConfiguration' => [ 'base' => 'The media stream that is associated with the output, and the parameters for that association.', 'refs' => [ '__listOfMediaStreamOutputConfiguration$member' => NULL, ], ], 'MediaStreamOutputConfigurationRequest' => [ 'base' => 'The media stream that you want to associate with the output, and the parameters for that association.', 'refs' => [ '__listOfMediaStreamOutputConfigurationRequest$member' => NULL, ], ], 'MediaStreamSourceConfiguration' => [ 'base' => 'The media stream that is associated with the source, and the parameters for that association.', 'refs' => [ '__listOfMediaStreamSourceConfiguration$member' => NULL, ], ], 'MediaStreamSourceConfigurationRequest' => [ 'base' => 'The definition of a media stream that you want to associate with the source.', 'refs' => [ '__listOfMediaStreamSourceConfigurationRequest$member' => NULL, ], ], 'MediaStreamType' => [ 'base' => NULL, 'refs' => [ 'AddMediaStreamRequest$MediaStreamType' => 'The type of media stream.', 'MediaStream$MediaStreamType' => 'The type of media stream.', 'UpdateFlowMediaStreamRequest$MediaStreamType' => 'The type of media stream.', ], ], 'Messages' => [ 'base' => 'Messages that provide the state of the flow.', 'refs' => [ 'DescribeFlowResponse$Messages' => NULL, ], ], 'NetworkInterfaceType' => [ 'base' => NULL, 'refs' => [ 'VpcInterface$NetworkInterfaceType' => 'The type of network interface.', 'VpcInterfaceRequest$NetworkInterfaceType' => 'The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.', ], ], 'NotFoundException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'Offering' => [ 'base' => 'A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.', 'refs' => [ 'DescribeOfferingResponse$Offering' => NULL, '__listOfOffering$member' => NULL, ], ], 'Output' => [ 'base' => 'The settings for an output.', 'refs' => [ 'UpdateFlowOutputResponse$Output' => 'The new settings of the output that you updated.', '__listOfOutput$member' => NULL, ], ], 'PriceUnits' => [ 'base' => NULL, 'refs' => [ 'Offering$PriceUnits' => 'The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.', 'Reservation$PriceUnits' => 'The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'AddOutputRequest$Protocol' => 'The protocol to use for the output.', 'SetSourceRequest$Protocol' => 'The protocol that is used by the source.', 'Transport$Protocol' => 'The protocol that is used by the source or output.', 'UpdateFlowOutputRequest$Protocol' => 'The protocol to use for the output.', 'UpdateFlowSourceRequest$Protocol' => 'The protocol that is used by the source.', ], ], 'PurchaseOfferingRequest' => [ 'base' => 'Submits a request to purchase an offering, which creates a reservation in your AWS account. If you already have an active reservation, you can\'t purchase another offering.', 'refs' => [], ], 'PurchaseOfferingResponse' => [ 'base' => 'The result of a successful PurchaseOffering request.', 'refs' => [], ], 'Range' => [ 'base' => NULL, 'refs' => [ 'Fmtp$Range' => 'The encoding range of the video.', 'FmtpRequest$Range' => 'The encoding range of the video.', ], ], 'RemoveFlowMediaStreamResponse' => [ 'base' => 'The result of a successful RemoveFlowMediaStream request.', 'refs' => [], ], 'RemoveFlowOutputResponse' => [ 'base' => 'The result of a successful RemoveFlowOutput request including the flow ARN and the output ARN that was removed.', 'refs' => [], ], 'RemoveFlowSourceResponse' => [ 'base' => 'The result of a successful RemoveFlowSource request including the flow ARN and the source ARN that was removed.', 'refs' => [], ], 'RemoveFlowVpcInterfaceResponse' => [ 'base' => 'The result of a successful RemoveFlowVpcInterface request including the flow ARN and the VPC interface name that was removed.', 'refs' => [], ], 'Reservation' => [ 'base' => 'A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.', 'refs' => [ 'DescribeReservationResponse$Reservation' => NULL, 'PurchaseOfferingResponse$Reservation' => NULL, '__listOfReservation$member' => NULL, ], ], 'ReservationState' => [ 'base' => NULL, 'refs' => [ 'Reservation$ReservationState' => 'The status of your reservation.', ], ], 'ResourceSpecification' => [ 'base' => 'A definition of what is being billed for, including the type and amount.', 'refs' => [ 'Offering$ResourceSpecification' => 'A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.', 'Reservation$ResourceSpecification' => 'A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceSpecification$ResourceType' => 'The type of resource and the unit that is being billed for.', ], ], 'ResponseError' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'RevokeFlowEntitlementResponse' => [ 'base' => 'The result of a successful RevokeFlowEntitlement request. The response includes the ARN of the flow that was updated and the ARN of the entitlement that was revoked.', 'refs' => [], ], 'ScanMode' => [ 'base' => NULL, 'refs' => [ 'Fmtp$ScanMode' => 'The type of compression that was used to smooth the video’s appearance', 'FmtpRequest$ScanMode' => 'The type of compression that was used to smooth the video’s appearance.', ], ], 'ServiceUnavailableException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'SetSourceRequest' => [ 'base' => 'The settings for the source of the flow.', 'refs' => [ 'CreateFlowRequest$Source' => NULL, '__listOfSetSourceRequest$member' => NULL, ], ], 'Source' => [ 'base' => 'The settings for the source of the flow.', 'refs' => [ 'Flow$Source' => NULL, 'UpdateFlowSourceResponse$Source' => 'The settings for the source of the flow.', '__listOfSource$member' => NULL, ], ], 'SourcePriority' => [ 'base' => 'The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.', 'refs' => [ 'FailoverConfig$SourcePriority' => 'The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.', 'UpdateFailoverConfig$SourcePriority' => 'The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'ListedFlow$SourceType' => 'The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another AWS account).', ], ], 'StartFlowResponse' => [ 'base' => 'The result of a successful StartFlow request.', 'refs' => [], ], 'State' => [ 'base' => NULL, 'refs' => [ 'FailoverConfig$State' => NULL, 'UpdateFailoverConfig$State' => NULL, ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'DeleteFlowResponse$Status' => 'The status of the flow when the DeleteFlow process begins.', 'Flow$Status' => 'The current status of the flow.', 'ListedFlow$Status' => 'The current status of the flow.', 'StartFlowResponse$Status' => 'The status of the flow when the StartFlow process begins.', 'StopFlowResponse$Status' => 'The status of the flow when the StopFlow process begins.', ], ], 'StopFlowResponse' => [ 'base' => 'The result of a successful StopFlow request.', 'refs' => [], ], 'TagResourceRequest' => [ 'base' => 'The tags to add to the resource. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.', 'refs' => [], ], 'Tcs' => [ 'base' => NULL, 'refs' => [ 'Fmtp$Tcs' => 'The transfer characteristic system (TCS) that is used in the video.', 'FmtpRequest$Tcs' => 'The transfer characteristic system (TCS) that is used in the video.', ], ], 'TooManyRequestsException' => [ 'base' => 'Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.', 'refs' => [], ], 'Transport' => [ 'base' => 'Attributes related to the transport stream that are used in a source or output.', 'refs' => [ 'Output$Transport' => 'Attributes related to the transport stream that are used in the output.', 'Source$Transport' => 'Attributes related to the transport stream that are used in the source.', ], ], 'UpdateEncryption' => [ 'base' => 'Information about the encryption of the flow.', 'refs' => [ 'UpdateFlowEntitlementRequest$Encryption' => 'The type of encryption that will be used on the output associated with this entitlement. Allowable encryption types: static-key, speke.', 'UpdateFlowOutputRequest$Encryption' => 'The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key). Allowable encryption types: static-key.', 'UpdateFlowSourceRequest$Decryption' => 'The type of encryption used on the content ingested from this source. Allowable encryption types: static-key.', ], ], 'UpdateFailoverConfig' => [ 'base' => 'The settings for source failover.', 'refs' => [ 'UpdateFlowRequest$SourceFailoverConfig' => NULL, ], ], 'UpdateFlowEntitlementRequest' => [ 'base' => 'The updates that you want to make to a specific entitlement.', 'refs' => [], ], 'UpdateFlowEntitlementResponse' => [ 'base' => 'The result of a successful UpdateFlowEntitlement request. The response includes the ARN of the flow that was updated and the updated entitlement configuration.', 'refs' => [], ], 'UpdateFlowMediaStreamRequest' => [ 'base' => 'Update a media stream on a flow.', 'refs' => [], ], 'UpdateFlowMediaStreamResponse' => [ 'base' => 'Update response', 'refs' => [], ], 'UpdateFlowOutputRequest' => [ 'base' => 'The updates that you want to make to an existing output of an existing flow.', 'refs' => [], ], 'UpdateFlowOutputResponse' => [ 'base' => 'The result of a successful UpdateFlowOutput request including the flow ARN and the updated output.', 'refs' => [], ], 'UpdateFlowRequest' => [ 'base' => 'Updates an existing flow.', 'refs' => [], ], 'UpdateFlowResponse' => [ 'base' => 'Updates an existing flow.', 'refs' => [], ], 'UpdateFlowSourceRequest' => [ 'base' => 'The updates that you want to make to an existing source of an existing flow.', 'refs' => [], ], 'UpdateFlowSourceResponse' => [ 'base' => 'The result of a successful UpdateFlowSource request. The response includes the ARN of the flow that was updated and the updated source configuration.', 'refs' => [], ], 'VpcInterface' => [ 'base' => 'The settings for a VPC Source.', 'refs' => [ '__listOfVpcInterface$member' => NULL, ], ], 'VpcInterfaceAttachment' => [ 'base' => 'The settings for attaching a VPC interface to an output.', 'refs' => [ 'AddOutputRequest$VpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this output.', 'Output$VpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this output.', 'UpdateFlowOutputRequest$VpcInterfaceAttachment' => 'The name of the VPC interface attachment to use for this output.', ], ], 'VpcInterfaceRequest' => [ 'base' => 'Desired VPC Interface for a Flow', 'refs' => [ '__listOfVpcInterfaceRequest$member' => NULL, ], ], '__double' => [ 'base' => NULL, 'refs' => [ 'EncodingParameters$CompressionFactor' => 'A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.', 'EncodingParametersRequest$CompressionFactor' => 'A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.', ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'AddMediaStreamRequest$ClockRate' => 'The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.', 'AddMediaStreamRequest$MediaStreamId' => 'A unique identifier for the media stream.', 'AddOutputRequest$Port' => 'The port to use when content is distributed to this output.', 'AddOutputRequest$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'DestinationConfiguration$DestinationPort' => 'The port to use when the content of the media stream is distributed to the output.', 'DestinationConfigurationRequest$DestinationPort' => 'The port that you want MediaConnect to use when it distributes the media stream to the output.', 'Entitlement$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'FailoverConfig$RecoveryWindow' => 'Search window time to look for dash-7 packets', 'GrantEntitlementRequest$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'InputConfiguration$InputPort' => 'The port that the flow listens on for an incoming media stream.', 'InputConfigurationRequest$InputPort' => 'The port that you want the flow to listen on for an incoming media stream.', 'ListedEntitlement$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'MediaStream$ClockRate' => 'The sample rate for the stream. This value is measured in Hz.', 'MediaStream$Fmt' => 'The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.', 'MediaStream$MediaStreamId' => 'A unique identifier for the media stream.', 'Offering$Duration' => 'The length of time that your reservation would be active.', 'Output$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'Output$Port' => 'The port to use when content is distributed to this output.', 'Reservation$Duration' => 'The length of time that this reservation is active. MediaConnect defines this value in the offering.', 'ResourceSpecification$ReservedBitrate' => 'The amount of outbound bandwidth that is discounted in the offering.', 'SetSourceRequest$IngestPort' => 'The port that the flow will be listening on for incoming content.', 'SetSourceRequest$MaxSyncBuffer' => 'The size of the buffer (in milliseconds) to use to sync incoming source data.', 'SetSourceRequest$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'Source$DataTransferSubscriberFeePercent' => 'Percentage from 0-100 of the data transfer cost to be billed to the subscriber.', 'Source$IngestPort' => 'The port that the flow will be listening on for incoming content.', 'Source$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'Transport$MaxSyncBuffer' => 'The size of the buffer (in milliseconds) to use to sync incoming source data.', 'Transport$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'UpdateFailoverConfig$RecoveryWindow' => 'Recovery window time to look for dash-7 packets', 'UpdateFlowMediaStreamRequest$ClockRate' => 'The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.', 'UpdateFlowOutputRequest$Port' => 'The port to use when content is distributed to this output.', 'UpdateFlowOutputRequest$SenderControlPort' => 'The port that the flow uses to send outbound requests to initiate connection with the sender.', 'UpdateFlowSourceRequest$IngestPort' => 'The port that the flow will be listening on for incoming content.', 'UpdateFlowSourceRequest$MaxSyncBuffer' => 'The size of the buffer (in milliseconds) to use to sync incoming source data.', 'AddOutputRequest$MaxLatency' => 'The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.', 'AddOutputRequest$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', 'AddOutputRequest$SmoothingLatency' => 'The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.', 'SetSourceRequest$MaxBitrate' => 'The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.', 'SetSourceRequest$MaxLatency' => 'The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.', 'SetSourceRequest$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', 'Transport$MaxBitrate' => 'The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.', 'Transport$MaxLatency' => 'The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.', 'Transport$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', 'Transport$SmoothingLatency' => 'The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.', 'UpdateFlowOutputRequest$MaxLatency' => 'The maximum latency in milliseconds for Zixi-based streams.', 'UpdateFlowOutputRequest$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', 'UpdateFlowOutputRequest$SmoothingLatency' => 'The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.', 'UpdateFlowSourceRequest$MaxBitrate' => 'The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.', 'UpdateFlowSourceRequest$MaxLatency' => 'The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.', 'UpdateFlowSourceRequest$MinLatency' => 'The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.', '__listOf__integer$member' => NULL, ], ], '__listOfAddMediaStreamRequest' => [ 'base' => NULL, 'refs' => [ 'AddFlowMediaStreamsRequest$MediaStreams' => 'The media streams that you want to add to the flow.', 'CreateFlowRequest$MediaStreams' => 'The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.', ], ], '__listOfAddOutputRequest' => [ 'base' => NULL, 'refs' => [ 'AddFlowOutputsRequest$Outputs' => 'A list of outputs that you want to add.', 'CreateFlowRequest$Outputs' => 'The outputs that you want to add to this flow.', ], ], '__listOfDestinationConfiguration' => [ 'base' => NULL, 'refs' => [ 'MediaStreamOutputConfiguration$DestinationConfigurations' => 'The transport parameters that are associated with each outbound media stream.', ], ], '__listOfDestinationConfigurationRequest' => [ 'base' => NULL, 'refs' => [ 'MediaStreamOutputConfigurationRequest$DestinationConfigurations' => 'The transport parameters that you want to associate with the media stream.', ], ], '__listOfEntitlement' => [ 'base' => NULL, 'refs' => [ 'Flow$Entitlements' => 'The entitlements in this flow.', 'GrantFlowEntitlementsResponse$Entitlements' => 'The entitlements that were just granted.', ], ], '__listOfGrantEntitlementRequest' => [ 'base' => NULL, 'refs' => [ 'CreateFlowRequest$Entitlements' => 'The entitlements that you want to grant on a flow.', 'GrantFlowEntitlementsRequest$Entitlements' => 'The list of entitlements that you want to grant.', ], ], '__listOfInputConfiguration' => [ 'base' => NULL, 'refs' => [ 'MediaStreamSourceConfiguration$InputConfigurations' => 'The transport parameters that are associated with an incoming media stream.', ], ], '__listOfInputConfigurationRequest' => [ 'base' => NULL, 'refs' => [ 'MediaStreamSourceConfigurationRequest$InputConfigurations' => 'The transport parameters that you want to associate with the media stream.', ], ], '__listOfListedEntitlement' => [ 'base' => NULL, 'refs' => [ 'ListEntitlementsResponse$Entitlements' => 'A list of entitlements that have been granted to you from other AWS accounts.', ], ], '__listOfListedFlow' => [ 'base' => NULL, 'refs' => [ 'ListFlowsResponse$Flows' => 'A list of flow summaries.', ], ], '__listOfMediaStream' => [ 'base' => NULL, 'refs' => [ 'AddFlowMediaStreamsResponse$MediaStreams' => 'The media streams that you added to the flow.', 'Flow$MediaStreams' => 'The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.', ], ], '__listOfMediaStreamOutputConfiguration' => [ 'base' => NULL, 'refs' => [ 'Output$MediaStreamOutputConfigurations' => 'The configuration for each media stream that is associated with the output.', ], ], '__listOfMediaStreamOutputConfigurationRequest' => [ 'base' => NULL, 'refs' => [ 'AddOutputRequest$MediaStreamOutputConfigurations' => 'The media streams that are associated with the output, and the parameters for those associations.', 'UpdateFlowOutputRequest$MediaStreamOutputConfigurations' => 'The media streams that are associated with the output, and the parameters for those associations.', ], ], '__listOfMediaStreamSourceConfiguration' => [ 'base' => NULL, 'refs' => [ 'Source$MediaStreamSourceConfigurations' => 'The media streams that are associated with the source, and the parameters for those associations.', ], ], '__listOfMediaStreamSourceConfigurationRequest' => [ 'base' => NULL, 'refs' => [ 'SetSourceRequest$MediaStreamSourceConfigurations' => 'The media streams that are associated with the source, and the parameters for those associations.', 'UpdateFlowSourceRequest$MediaStreamSourceConfigurations' => 'The media streams that are associated with the source, and the parameters for those associations.', ], ], '__listOfOffering' => [ 'base' => NULL, 'refs' => [ 'ListOfferingsResponse$Offerings' => 'A list of offerings that are available to this account in the current AWS Region.', ], ], '__listOfOutput' => [ 'base' => NULL, 'refs' => [ 'AddFlowOutputsResponse$Outputs' => 'The details of the newly added outputs.', 'Flow$Outputs' => 'The outputs in this flow.', ], ], '__listOfReservation' => [ 'base' => NULL, 'refs' => [ 'ListReservationsResponse$Reservations' => 'A list of all reservations that have been purchased by this account in the current AWS Region.', ], ], '__listOfSetSourceRequest' => [ 'base' => NULL, 'refs' => [ 'AddFlowSourcesRequest$Sources' => 'A list of sources that you want to add.', 'CreateFlowRequest$Sources' => NULL, ], ], '__listOfSource' => [ 'base' => NULL, 'refs' => [ 'AddFlowSourcesResponse$Sources' => 'The details of the newly added sources.', 'Flow$Sources' => NULL, ], ], '__listOfVpcInterface' => [ 'base' => NULL, 'refs' => [ 'AddFlowVpcInterfacesResponse$VpcInterfaces' => 'The details of the newly added VPC interfaces.', 'Flow$VpcInterfaces' => 'The VPC Interfaces for this flow.', ], ], '__listOfVpcInterfaceRequest' => [ 'base' => NULL, 'refs' => [ 'AddFlowVpcInterfacesRequest$VpcInterfaces' => 'A list of VPC interfaces that you want to add.', 'CreateFlowRequest$VpcInterfaces' => 'The VPC interfaces you want on the flow.', ], ], '__listOf__integer' => [ 'base' => NULL, 'refs' => [], ], '__listOf__string' => [ 'base' => NULL, 'refs' => [ 'AddOutputRequest$CidrAllowList' => 'The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'Entitlement$Subscribers' => 'The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.', 'GrantEntitlementRequest$Subscribers' => 'The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flows using your content as the source.', 'Messages$Errors' => 'A list of errors that might have been generated from processes on this flow.', 'RemoveFlowVpcInterfaceResponse$NonDeletedNetworkInterfaceIds' => 'IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.', 'Transport$CidrAllowList' => 'The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'UpdateFlowEntitlementRequest$Subscribers' => 'The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.', 'UpdateFlowOutputRequest$CidrAllowList' => 'The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'VpcInterface$NetworkInterfaceIds' => 'IDs of the network interfaces created in customer\'s account by MediaConnect.', 'VpcInterface$SecurityGroupIds' => 'Security Group IDs to be used on ENI.', 'VpcInterfaceRequest$SecurityGroupIds' => 'Security Group IDs to be used on ENI.', ], ], '__mapOf__string' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$Tags' => 'A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.', 'TagResourceRequest$Tags' => 'A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'AddFlowMediaStreamsResponse$FlowArn' => 'The ARN of the flow that you added media streams to.', 'AddFlowOutputsResponse$FlowArn' => 'The ARN of the flow that these outputs were added to.', 'AddFlowSourcesResponse$FlowArn' => 'The ARN of the flow that these sources were added to.', 'AddFlowVpcInterfacesResponse$FlowArn' => 'The ARN of the flow that these VPC interfaces were added to.', 'AddMediaStreamRequest$Description' => 'A description that can help you quickly identify what your media stream is used for.', 'AddMediaStreamRequest$MediaStreamName' => 'A name that helps you distinguish one media stream from another.', 'AddMediaStreamRequest$VideoFormat' => 'The resolution of the video.', 'AddOutputRequest$Description' => 'A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.', 'AddOutputRequest$Destination' => 'The IP address from which video will be sent to output destinations.', 'AddOutputRequest$Name' => 'The name of the output. This value must be unique within the current flow.', 'AddOutputRequest$RemoteId' => 'The remote ID for the Zixi-pull output stream.', 'AddOutputRequest$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.', 'CreateFlowRequest$AvailabilityZone' => 'The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.', 'CreateFlowRequest$Name' => 'The name of the flow.', 'DeleteFlowResponse$FlowArn' => 'The ARN of the flow that was deleted.', 'DestinationConfiguration$DestinationIp' => 'The IP address where contents of the media stream will be sent.', 'DestinationConfiguration$OutboundIp' => 'The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS protocol.', 'DestinationConfigurationRequest$DestinationIp' => 'The IP address where you want MediaConnect to send contents of the media stream.', 'Encryption$ConstantInitializationVector' => 'A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.', 'Encryption$DeviceId' => 'The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'Encryption$Region' => 'The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'Encryption$ResourceId' => 'An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'Encryption$RoleArn' => 'The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).', 'Encryption$SecretArn' => 'The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.', 'Encryption$Url' => 'The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'Entitlement$Description' => 'A description of the entitlement.', 'Entitlement$EntitlementArn' => 'The ARN of the entitlement.', 'Entitlement$Name' => 'The name of the entitlement.', 'Flow$AvailabilityZone' => 'The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.', 'Flow$Description' => 'A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.', 'Flow$EgressIp' => 'The IP address from which video will be sent to output destinations.', 'Flow$FlowArn' => 'The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.', 'Flow$Name' => 'The name of the flow.', 'Fmtp$ChannelOrder' => 'The format of the audio channel.', 'Fmtp$ExactFramerate' => 'The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.', 'Fmtp$Par' => 'The pixel aspect ratio (PAR) of the video.', 'FmtpRequest$ChannelOrder' => 'The format of the audio channel.', 'FmtpRequest$ExactFramerate' => 'The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.', 'FmtpRequest$Par' => 'The pixel aspect ratio (PAR) of the video.', 'GrantEntitlementRequest$Description' => 'A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.', 'GrantEntitlementRequest$Name' => 'The name of the entitlement. This value must be unique within the current flow.', 'GrantFlowEntitlementsResponse$FlowArn' => 'The ARN of the flow that these entitlements were granted to.', 'InputConfiguration$InputIp' => 'The IP address that the flow listens on for incoming content for a media stream.', 'Interface$Name' => 'The name of the VPC interface.', 'InterfaceRequest$Name' => 'The name of the VPC interface.', 'ListEntitlementsResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.', 'ListFlowsResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.', 'ListOfferingsResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.', 'ListReservationsResponse$NextToken' => 'The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListReservations request a second time and specify the NextToken value.', 'ListedEntitlement$EntitlementArn' => 'The ARN of the entitlement.', 'ListedEntitlement$EntitlementName' => 'The name of the entitlement.', 'ListedFlow$AvailabilityZone' => 'The Availability Zone that the flow was created in.', 'ListedFlow$Description' => 'A description of the flow.', 'ListedFlow$FlowArn' => 'The ARN of the flow.', 'ListedFlow$Name' => 'The name of the flow.', 'MediaStream$Description' => 'A description that can help you quickly identify what your media stream is used for.', 'MediaStream$MediaStreamName' => 'A name that helps you distinguish one media stream from another.', 'MediaStream$VideoFormat' => 'The resolution of the video.', 'MediaStreamAttributes$Lang' => 'The audio language, in a format that is recognized by the receiver.', 'MediaStreamAttributesRequest$Lang' => 'The audio language, in a format that is recognized by the receiver.', 'MediaStreamOutputConfiguration$MediaStreamName' => 'The name of the media stream.', 'MediaStreamOutputConfigurationRequest$MediaStreamName' => 'The name of the media stream that is associated with the output.', 'MediaStreamSourceConfiguration$MediaStreamName' => 'The name of the media stream.', 'MediaStreamSourceConfigurationRequest$MediaStreamName' => 'The name of the media stream.', 'Offering$CurrencyCode' => 'The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.', 'Offering$OfferingArn' => 'The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.', 'Offering$OfferingDescription' => 'A description of the offering.', 'Offering$PricePerUnit' => 'The cost of a single unit. This value, in combination with priceUnits, makes up the rate.', 'Output$Description' => 'A description of the output.', 'Output$Destination' => 'The address where you want to send the output.', 'Output$EntitlementArn' => 'The ARN of the entitlement on the originator\'\'s flow. This value is relevant only on entitled flows.', 'Output$ListenerAddress' => 'The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.', 'Output$MediaLiveInputArn' => 'The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.', 'Output$Name' => 'The name of the output. This value must be unique within the current flow.', 'Output$OutputArn' => 'The ARN of the output.', 'PurchaseOfferingRequest$ReservationName' => 'The name that you want to use for the reservation.', 'PurchaseOfferingRequest$Start' => 'The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today\'s date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.', 'RemoveFlowMediaStreamResponse$FlowArn' => 'The Amazon Resource Name (ARN) of the flow.', 'RemoveFlowMediaStreamResponse$MediaStreamName' => 'The name of the media stream that was removed.', 'RemoveFlowOutputResponse$FlowArn' => 'The ARN of the flow that is associated with the output you removed.', 'RemoveFlowOutputResponse$OutputArn' => 'The ARN of the output that was removed.', 'RemoveFlowSourceResponse$FlowArn' => 'The ARN of the flow that is associated with the source you removed.', 'RemoveFlowSourceResponse$SourceArn' => 'The ARN of the source that was removed.', 'RemoveFlowVpcInterfaceResponse$FlowArn' => 'The ARN of the flow that is associated with the VPC interface you removed.', 'RemoveFlowVpcInterfaceResponse$VpcInterfaceName' => 'The name of the VPC interface that was removed.', 'Reservation$CurrencyCode' => 'The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.', 'Reservation$End' => 'The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering\'s duration.', 'Reservation$OfferingArn' => 'The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.', 'Reservation$OfferingDescription' => 'A description of the offering. MediaConnect defines this value in the offering.', 'Reservation$PricePerUnit' => 'The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.', 'Reservation$ReservationArn' => 'The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.', 'Reservation$ReservationName' => 'The name that you assigned to the reservation when you purchased the offering.', 'Reservation$Start' => 'The day and time that the reservation becomes active. You set this value when you purchase the offering.', 'ResponseError$Message' => 'The error message returned by AWS Elemental MediaConnect.', 'RevokeFlowEntitlementResponse$EntitlementArn' => 'The ARN of the entitlement that was revoked.', 'RevokeFlowEntitlementResponse$FlowArn' => 'The ARN of the flow that the entitlement was revoked from.', 'SetSourceRequest$Description' => 'A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.', 'SetSourceRequest$EntitlementArn' => 'The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator\'s flow.', 'SetSourceRequest$Name' => 'The name of the source.', 'SetSourceRequest$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'SetSourceRequest$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.', 'SetSourceRequest$VpcInterfaceName' => 'The name of the VPC interface to use for this source.', 'SetSourceRequest$WhitelistCidr' => 'The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'Source$Description' => 'A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.', 'Source$EntitlementArn' => 'The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator\'s flow.', 'Source$IngestIp' => 'The IP address that the flow will be listening on for incoming content.', 'Source$Name' => 'The name of the source.', 'Source$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'Source$SourceArn' => 'The ARN of the source.', 'Source$VpcInterfaceName' => 'The name of the VPC interface that is used for this source.', 'Source$WhitelistCidr' => 'The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'SourcePriority$PrimarySource' => 'The name of the source you choose as the primary source for this flow.', 'StartFlowResponse$FlowArn' => 'The ARN of the flow that you started.', 'StopFlowResponse$FlowArn' => 'The ARN of the flow that you stopped.', 'Transport$RemoteId' => 'The remote ID for the Zixi-pull stream.', 'Transport$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'Transport$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.', 'UpdateEncryption$ConstantInitializationVector' => 'A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.', 'UpdateEncryption$DeviceId' => 'The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'UpdateEncryption$Region' => 'The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'UpdateEncryption$ResourceId' => 'An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'UpdateEncryption$RoleArn' => 'The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).', 'UpdateEncryption$SecretArn' => 'The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.', 'UpdateEncryption$Url' => 'The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.', 'UpdateFlowEntitlementRequest$Description' => 'A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.', 'UpdateFlowEntitlementResponse$FlowArn' => 'The ARN of the flow that this entitlement was granted on.', 'UpdateFlowMediaStreamRequest$Description' => 'Description', 'UpdateFlowMediaStreamRequest$VideoFormat' => 'The resolution of the video.', 'UpdateFlowMediaStreamResponse$FlowArn' => 'The ARN of the flow that is associated with the media stream that you updated.', 'UpdateFlowOutputRequest$Description' => 'A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.', 'UpdateFlowOutputRequest$Destination' => 'The IP address where you want to send the output.', 'UpdateFlowOutputRequest$RemoteId' => 'The remote ID for the Zixi-pull stream.', 'UpdateFlowOutputRequest$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'UpdateFlowOutputRequest$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.', 'UpdateFlowOutputResponse$FlowArn' => 'The ARN of the flow that is associated with the updated output.', 'UpdateFlowSourceRequest$Description' => 'A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.', 'UpdateFlowSourceRequest$EntitlementArn' => 'The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator\'s flow.', 'UpdateFlowSourceRequest$SenderIpAddress' => 'The IP address that the flow communicates with to initiate connection with the sender.', 'UpdateFlowSourceRequest$StreamId' => 'The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.', 'UpdateFlowSourceRequest$VpcInterfaceName' => 'The name of the VPC interface to use for this source.', 'UpdateFlowSourceRequest$WhitelistCidr' => 'The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.', 'UpdateFlowSourceResponse$FlowArn' => 'The ARN of the flow that you want to update.', 'VpcInterface$Name' => 'Immutable and has to be a unique against other VpcInterfaces in this Flow.', 'VpcInterface$RoleArn' => 'Role Arn MediaConnect can assumes to create ENIs in customer\'s account', 'VpcInterface$SubnetId' => 'Subnet must be in the AZ of the Flow', 'VpcInterfaceAttachment$VpcInterfaceName' => 'The name of the VPC interface to use for this output.', 'VpcInterfaceRequest$Name' => 'The name of the VPC Interface. This value must be unique within the current flow.', 'VpcInterfaceRequest$RoleArn' => 'Role Arn MediaConnect can assumes to create ENIs in customer\'s account', 'VpcInterfaceRequest$SubnetId' => 'Subnet must be in the AZ of the Flow', '__listOf__string$member' => NULL, '__mapOf__string$member' => NULL, ], ], ],];
