<?php
// This file was auto-generated from sdk-root/src/data/lookoutmetrics/2017-07-25/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the <i>Amazon Lookout for Metrics API Reference</i>. For an introduction to the service with tutorials for getting started, visit <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev">Amazon Lookout for Metrics Developer Guide</a>.</p>', 'operations' => [ 'ActivateAnomalyDetector' => '<p>Activates an anomaly detector.</p>', 'BackTestAnomalyDetector' => '<p>Runs a backtest for anomaly detection for the specified resource.</p>', 'CreateAlert' => '<p>Creates an alert for an anomaly detector.</p>', 'CreateAnomalyDetector' => '<p>Creates an anomaly detector.</p>', 'CreateMetricSet' => '<p>Creates a dataset.</p>', 'DeactivateAnomalyDetector' => '<p>Deactivates an anomaly detector.</p>', 'DeleteAlert' => '<p>Deletes an alert.</p>', 'DeleteAnomalyDetector' => '<p>Deletes a detector. Deleting an anomaly detector will delete all of its corresponding resources including any configured datasets and alerts.</p>', 'DescribeAlert' => '<p>Describes an alert.</p> <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>', 'DescribeAnomalyDetectionExecutions' => '<p>Returns information about the status of the specified anomaly detection jobs.</p>', 'DescribeAnomalyDetector' => '<p>Describes a detector.</p> <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>', 'DescribeMetricSet' => '<p>Describes a dataset.</p> <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>', 'GetAnomalyGroup' => '<p>Returns details about a group of anomalous metrics.</p>', 'GetFeedback' => '<p>Get feedback for an anomaly group.</p>', 'GetSampleData' => '<p>Returns a selection of sample records from an Amazon S3 datasource.</p>', 'ListAlerts' => '<p>Lists the alerts attached to a detector.</p> <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>', 'ListAnomalyDetectors' => '<p>Lists the detectors in the current AWS Region.</p> <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>', 'ListAnomalyGroupRelatedMetrics' => '<p>Returns a list of measures that are potential causes or effects of an anomaly group.</p>', 'ListAnomalyGroupSummaries' => '<p>Returns a list of anomaly groups.</p>', 'ListAnomalyGroupTimeSeries' => '<p>Gets a list of anomalous metrics for a measure in an anomaly group.</p>', 'ListMetricSets' => '<p>Lists the datasets in the current AWS Region.</p> <p>Amazon Lookout for Metrics API actions are eventually consistent. If you do a read operation on a resource immediately after creating or modifying it, use retries to allow time for the write operation to complete.</p>', 'ListTagsForResource' => '<p>Gets a list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> for a detector, dataset, or alert.</p>', 'PutFeedback' => '<p>Add feedback for an anomalous metric.</p>', 'TagResource' => '<p>Adds <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to a detector, dataset, or alert.</p>', 'UntagResource' => '<p>Removes <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> from a detector, dataset, or alert.</p>', 'UpdateAnomalyDetector' => '<p>Updates a detector. After activation, you can only change a detector\'s ingestion delay and description.</p>', 'UpdateMetricSet' => '<p>Updates a dataset.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient permissions to perform this action.</p>', 'refs' => [], ], 'Action' => [ 'base' => '<p>A configuration that specifies the action to perform when anomalies are detected.</p>', 'refs' => [ 'Alert$Action' => '<p>Action that will be triggered when there is an alert.</p>', 'CreateAlertRequest$Action' => '<p>Action that will be triggered when there is an alert.</p>', ], ], 'ActivateAnomalyDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'ActivateAnomalyDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'AggregationFunction' => [ 'base' => NULL, 'refs' => [ 'Metric$AggregationFunction' => '<p>The function with which the metric is calculated.</p>', ], ], 'Alert' => [ 'base' => '<p>A configuration for Amazon SNS-integrated notifications.</p>', 'refs' => [ 'DescribeAlertResponse$Alert' => '<p>Contains information about an alert.</p>', ], ], 'AlertDescription' => [ 'base' => NULL, 'refs' => [ 'Alert$AlertDescription' => '<p>A description of the alert.</p>', 'CreateAlertRequest$AlertDescription' => '<p>A description of the alert.</p>', ], ], 'AlertName' => [ 'base' => NULL, 'refs' => [ 'Alert$AlertName' => '<p>The name of the alert.</p>', 'AlertSummary$AlertName' => '<p>The name of the alert.</p>', 'CreateAlertRequest$AlertName' => '<p>The name of the alert.</p>', ], ], 'AlertStatus' => [ 'base' => NULL, 'refs' => [ 'Alert$AlertStatus' => '<p>The status of the alert.</p>', 'AlertSummary$AlertStatus' => '<p>The status of the alert.</p>', ], ], 'AlertSummary' => [ 'base' => '<p>Provides a summary of an alert\'s configuration.</p>', 'refs' => [ 'AlertSummaryList$member' => NULL, ], ], 'AlertSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAlertsResponse$AlertSummaryList' => '<p>Contains information about an alert.</p>', ], ], 'AlertType' => [ 'base' => NULL, 'refs' => [ 'Alert$AlertType' => '<p>The type of the alert.</p>', 'AlertSummary$AlertType' => '<p>The type of the alert.</p>', ], ], 'AnomalyDetectionTaskStatus' => [ 'base' => NULL, 'refs' => [ 'ExecutionStatus$Status' => '<p>The run\'s status.</p>', ], ], 'AnomalyDetectionTaskStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ExecutionStatus$FailureReason' => '<p>The reason that the run failed, if applicable.</p>', ], ], 'AnomalyDetectorConfig' => [ 'base' => '<p>Contains information about a detector\'s configuration.</p>', 'refs' => [ 'CreateAnomalyDetectorRequest$AnomalyDetectorConfig' => '<p>Contains information about the configuration of the anomaly detector.</p>', 'UpdateAnomalyDetectorRequest$AnomalyDetectorConfig' => '<p>Contains information about the configuration to which the detector will be updated.</p>', ], ], 'AnomalyDetectorConfigSummary' => [ 'base' => '<p>Contains information about a detector\'s configuration.</p>', 'refs' => [ 'DescribeAnomalyDetectorResponse$AnomalyDetectorConfig' => '<p>Contains information about the detector\'s configuration.</p>', ], ], 'AnomalyDetectorDescription' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetectorSummary$AnomalyDetectorDescription' => '<p>A description of the detector.</p>', 'CreateAnomalyDetectorRequest$AnomalyDetectorDescription' => '<p>A description of the detector.</p>', 'DescribeAnomalyDetectorResponse$AnomalyDetectorDescription' => '<p>A description of the detector.</p>', 'UpdateAnomalyDetectorRequest$AnomalyDetectorDescription' => '<p>The updated detector description.</p>', ], ], 'AnomalyDetectorFailureType' => [ 'base' => NULL, 'refs' => [ 'DescribeAnomalyDetectorResponse$FailureType' => '<p>The process that caused the detector to fail.</p>', ], ], 'AnomalyDetectorName' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetectorSummary$AnomalyDetectorName' => '<p>The name of the detector.</p>', 'CreateAnomalyDetectorRequest$AnomalyDetectorName' => '<p>The name of the detector.</p>', 'DescribeAnomalyDetectorResponse$AnomalyDetectorName' => '<p>The name of the detector.</p>', ], ], 'AnomalyDetectorStatus' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetectorSummary$Status' => '<p>The status of detector.</p>', 'DescribeAnomalyDetectorResponse$Status' => '<p>The status of the detector.</p>', ], ], 'AnomalyDetectorSummary' => [ 'base' => '<p>Contains information about an an anomaly detector.</p>', 'refs' => [ 'AnomalyDetectorSummaryList$member' => NULL, ], ], 'AnomalyDetectorSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAnomalyDetectorsResponse$AnomalyDetectorSummaryList' => '<p>A list of anomaly detectors in the account in the current region.</p>', ], ], 'AnomalyGroup' => [ 'base' => '<p>A group of anomalous metrics</p>', 'refs' => [ 'GetAnomalyGroupResponse$AnomalyGroup' => '<p>Details about the anomaly group.</p>', ], ], 'AnomalyGroupStatistics' => [ 'base' => '<p>Aggregated statistics for a group of anomalous metrics.</p>', 'refs' => [ 'ListAnomalyGroupSummariesResponse$AnomalyGroupStatistics' => '<p>Aggregated details about the anomaly groups.</p>', ], ], 'AnomalyGroupSummary' => [ 'base' => '<p>Details about a group of anomalous metrics.</p>', 'refs' => [ 'AnomalyGroupSummaryList$member' => NULL, ], ], 'AnomalyGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAnomalyGroupSummariesResponse$AnomalyGroupSummaryList' => '<p>A list of anomaly group summaries.</p>', ], ], 'AnomalyGroupTimeSeries' => [ 'base' => '<p>An anomalous metric in an anomaly group.</p>', 'refs' => [ 'GetFeedbackRequest$AnomalyGroupTimeSeriesFeedback' => '<p>The anomalous metric and group ID.</p>', ], ], 'AnomalyGroupTimeSeriesFeedback' => [ 'base' => '<p>Feedback for an anomalous metric.</p>', 'refs' => [ 'PutFeedbackRequest$AnomalyGroupTimeSeriesFeedback' => '<p>Feedback for an anomalous metric.</p>', ], ], 'AppFlowConfig' => [ 'base' => '<p>Details about an Amazon AppFlow flow datasource.</p>', 'refs' => [ 'MetricSource$AppFlowConfig' => '<p>An object containing information about the AppFlow configuration.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ActivateAnomalyDetectorRequest$AnomalyDetectorArn' => '<p>The ARN of the anomaly detector.</p>', 'Alert$AlertArn' => '<p>The ARN of the alert.</p>', 'Alert$AnomalyDetectorArn' => '<p>The ARN of the detector to which the alert is attached.</p>', 'AlertSummary$AlertArn' => '<p>The ARN of the alert.</p>', 'AlertSummary$AnomalyDetectorArn' => '<p>The ARN of the detector to which the alert is attached.</p>', 'AnomalyDetectorSummary$AnomalyDetectorArn' => '<p>The ARN of the detector.</p>', 'AppFlowConfig$RoleArn' => '<p>An IAM role that gives Amazon Lookout for Metrics permission to access the flow.</p>', 'BackTestAnomalyDetectorRequest$AnomalyDetectorArn' => '<p>The Amazon Resource Name (ARN) of the anomaly detector.</p>', 'CloudWatchConfig$RoleArn' => '<p>An IAM role that gives Amazon Lookout for Metrics permission to access data in Amazon CloudWatch.</p>', 'CreateAlertRequest$AnomalyDetectorArn' => '<p>The ARN of the detector to which the alert is attached.</p>', 'CreateAlertResponse$AlertArn' => '<p>The ARN of the alert.</p>', 'CreateAnomalyDetectorResponse$AnomalyDetectorArn' => '<p>The ARN of the detector.</p>', 'CreateMetricSetRequest$AnomalyDetectorArn' => '<p>The ARN of the anomaly detector that will use the dataset.</p>', 'CreateMetricSetResponse$MetricSetArn' => '<p>The ARN of the dataset.</p>', 'DeactivateAnomalyDetectorRequest$AnomalyDetectorArn' => '<p>The Amazon Resource Name (ARN) of the anomaly detector.</p>', 'DeleteAlertRequest$AlertArn' => '<p>The ARN of the alert to delete.</p>', 'DeleteAnomalyDetectorRequest$AnomalyDetectorArn' => '<p>The ARN of the detector to delete.</p>', 'DescribeAlertRequest$AlertArn' => '<p>The ARN of the alert to describe.</p>', 'DescribeAnomalyDetectionExecutionsRequest$AnomalyDetectorArn' => '<p>The Amazon Resource Name (ARN) of the anomaly detector.</p>', 'DescribeAnomalyDetectorRequest$AnomalyDetectorArn' => '<p>The ARN of the detector to describe.</p>', 'DescribeAnomalyDetectorResponse$AnomalyDetectorArn' => '<p>The ARN of the detector.</p>', 'DescribeMetricSetRequest$MetricSetArn' => '<p>The ARN of the dataset.</p>', 'DescribeMetricSetResponse$MetricSetArn' => '<p>The ARN of the dataset.</p>', 'DescribeMetricSetResponse$AnomalyDetectorArn' => '<p>The ARN of the detector that contains the dataset.</p>', 'GetAnomalyGroupRequest$AnomalyDetectorArn' => '<p>The Amazon Resource Name (ARN) of the anomaly detector.</p>', 'GetFeedbackRequest$AnomalyDetectorArn' => '<p>The Amazon Resource Name (ARN) of the anomaly detector.</p>', 'LambdaConfiguration$RoleArn' => '<p>The ARN of an IAM role that has permission to invoke the Lambda function.</p>', 'LambdaConfiguration$LambdaArn' => '<p>The ARN of the Lambda function.</p>', 'ListAlertsRequest$AnomalyDetectorArn' => '<p>The ARN of the alert\'s detector.</p>', 'ListAnomalyGroupRelatedMetricsRequest$AnomalyDetectorArn' => '<p>The Amazon Resource Name (ARN) of the anomaly detector.</p>', 'ListAnomalyGroupSummariesRequest$AnomalyDetectorArn' => '<p>The Amazon Resource Name (ARN) of the anomaly detector.</p>', 'ListAnomalyGroupTimeSeriesRequest$AnomalyDetectorArn' => '<p>The Amazon Resource Name (ARN) of the anomaly detector.</p>', 'ListMetricSetsRequest$AnomalyDetectorArn' => '<p>The ARN of the anomaly detector containing the metrics sets to list.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The resource\'s Amazon Resource Name (ARN).</p>', 'MetricSetSummary$MetricSetArn' => '<p>The ARN of the dataset.</p>', 'MetricSetSummary$AnomalyDetectorArn' => '<p>The ARN of the detector to which the dataset belongs.</p>', 'PutFeedbackRequest$AnomalyDetectorArn' => '<p>The Amazon Resource Name (ARN) of the anomaly detector.</p>', 'RDSSourceConfig$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role.</p>', 'RedshiftSourceConfig$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role providing access to the database.</p>', 'S3SourceConfig$RoleArn' => '<p>The ARN of an IAM role that has read and write access permissions to the source S3 bucket.</p>', 'SNSConfiguration$RoleArn' => '<p>The ARN of the IAM role that has access to the target SNS topic.</p>', 'SNSConfiguration$SnsTopicArn' => '<p>The ARN of the target SNS topic.</p>', 'SampleDataS3SourceConfig$RoleArn' => '<p>The Amazon Resource Name (ARN) of the role.</p>', 'TagResourceRequest$ResourceArn' => '<p>The resource\'s Amazon Resource Name (ARN).</p>', 'UntagResourceRequest$ResourceArn' => '<p>The resource\'s Amazon Resource Name (ARN).</p>', 'UpdateAnomalyDetectorRequest$AnomalyDetectorArn' => '<p>The ARN of the detector to update.</p>', 'UpdateAnomalyDetectorResponse$AnomalyDetectorArn' => '<p>The ARN of the updated detector.</p>', 'UpdateMetricSetRequest$MetricSetArn' => '<p>The ARN of the dataset to update.</p>', 'UpdateMetricSetResponse$MetricSetArn' => '<p>The ARN of the dataset.</p>', ], ], 'BackTestAnomalyDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'BackTestAnomalyDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AnomalyGroupTimeSeriesFeedback$IsAnomaly' => '<p>Feedback on whether the metric is a legitimate anomaly.</p>', 'CsvFormatDescriptor$ContainsHeader' => '<p>Whether or not the source CSV file contains a header.</p>', 'TimeSeriesFeedback$IsAnomaly' => '<p>Feedback on whether the metric is a legitimate anomaly.</p>', ], ], 'CSVFileCompression' => [ 'base' => NULL, 'refs' => [ 'CsvFormatDescriptor$FileCompression' => '<p>The level of compression of the source CSV file.</p>', ], ], 'Charset' => [ 'base' => NULL, 'refs' => [ 'CsvFormatDescriptor$Charset' => '<p>The character set in which the source CSV file is written.</p>', 'JsonFormatDescriptor$Charset' => '<p>The character set in which the source JSON file is written.</p>', ], ], 'CloudWatchConfig' => [ 'base' => '<p>Details about an Amazon CloudWatch datasource.</p>', 'refs' => [ 'MetricSource$CloudWatchConfig' => '<p>An object containing information about the Amazon CloudWatch monitoring configuration.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'DimensionContribution$DimensionName' => '<p>The name of the dimension.</p>', 'DimensionList$member' => NULL, 'DimensionNameValue$DimensionName' => '<p>The name of the dimension.</p>', 'HeaderList$member' => NULL, 'ItemizedMetricStats$MetricName' => '<p>The name of the measure.</p>', 'Metric$MetricName' => '<p>The name of the metric.</p>', 'TimestampColumn$ColumnName' => '<p>The name of the timestamp column.</p>', ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict processing the request. Try your request again.</p>', 'refs' => [], ], 'ContributionMatrix' => [ 'base' => '<p>Details about dimensions that contributed to an anomaly.</p>', 'refs' => [ 'MetricLevelImpact$ContributionMatrix' => '<p>Details about the dimensions that contributed to the anomaly.</p>', ], ], 'CreateAlertRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAlertResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnomalyDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAnomalyDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMetricSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMetricSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CsvFormatDescriptor' => [ 'base' => '<p>Contains information about how a source CSV data file should be analyzed.</p>', 'refs' => [ 'FileFormatDescriptor$CsvFormatDescriptor' => '<p>Contains information about how a source CSV data file should be analyzed.</p>', ], ], 'DataItem' => [ 'base' => NULL, 'refs' => [ 'SampleRow$member' => NULL, ], ], 'DatabaseHost' => [ 'base' => NULL, 'refs' => [ 'RDSSourceConfig$DatabaseHost' => '<p>The host name of the database.</p>', 'RedshiftSourceConfig$DatabaseHost' => '<p>The name of the database host.</p>', ], ], 'DatabasePort' => [ 'base' => NULL, 'refs' => [ 'RDSSourceConfig$DatabasePort' => '<p>The port number where the database can be accessed.</p>', 'RedshiftSourceConfig$DatabasePort' => '<p>The port number where the database can be accessed.</p>', ], ], 'DateTimeFormat' => [ 'base' => NULL, 'refs' => [ 'TimestampColumn$ColumnFormat' => '<p>The format of the timestamp column.</p>', ], ], 'DeactivateAnomalyDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeactivateAnomalyDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAlertRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAlertResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnomalyDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAnomalyDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'Delimiter' => [ 'base' => NULL, 'refs' => [ 'CsvFormatDescriptor$Delimiter' => '<p>The character used to delimit the source CSV file.</p>', ], ], 'DescribeAlertRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlertResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyDetectionExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyDetectionExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMetricSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMetricSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DimensionContribution' => [ 'base' => '<p>Details about a dimension that contributed to an anomaly.</p>', 'refs' => [ 'DimensionContributionList$member' => NULL, ], ], 'DimensionContributionList' => [ 'base' => NULL, 'refs' => [ 'ContributionMatrix$DimensionContributionList' => '<p>A list of contributing dimensions.</p>', ], ], 'DimensionList' => [ 'base' => NULL, 'refs' => [ 'CreateMetricSetRequest$DimensionList' => '<p>A list of the fields you want to treat as dimensions.</p>', 'DescribeMetricSetResponse$DimensionList' => '<p>A list of the dimensions chosen for analysis.</p>', 'UpdateMetricSetRequest$DimensionList' => '<p>The dimension list.</p>', ], ], 'DimensionNameValue' => [ 'base' => '<p>A dimension name and value.</p>', 'refs' => [ 'DimensionNameValueList$member' => NULL, ], ], 'DimensionNameValueList' => [ 'base' => NULL, 'refs' => [ 'TimeSeries$DimensionList' => '<p>The dimensions of the metric.</p>', ], ], 'DimensionValue' => [ 'base' => NULL, 'refs' => [ 'DimensionNameValue$DimensionValue' => '<p>The value of the dimension.</p>', 'DimensionValueContribution$DimensionValue' => '<p>The value of the dimension.</p>', ], ], 'DimensionValueContribution' => [ 'base' => '<p>The severity of a value of a dimension that contributed to an anomaly.</p>', 'refs' => [ 'DimensionValueContributionList$member' => NULL, ], ], 'DimensionValueContributionList' => [ 'base' => NULL, 'refs' => [ 'DimensionContribution$DimensionValueContributionList' => '<p>A list of dimension values that contributed to the anomaly.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'DescribeAnomalyDetectorResponse$FailureReason' => '<p>The reason that the detector failed.</p>', ], ], 'ExecutionList' => [ 'base' => NULL, 'refs' => [ 'DescribeAnomalyDetectionExecutionsResponse$ExecutionList' => '<p>A list of detection jobs.</p>', ], ], 'ExecutionStatus' => [ 'base' => '<p>The status of an anomaly detector run.</p>', 'refs' => [ 'ExecutionList$member' => NULL, ], ], 'FieldName' => [ 'base' => NULL, 'refs' => [ 'ValidationExceptionField$Name' => '<p>The name of the field.</p>', ], ], 'FileFormatDescriptor' => [ 'base' => '<p>Contains information about a source file\'s formatting.</p>', 'refs' => [ 'S3SourceConfig$FileFormatDescriptor' => '<p>Contains information about a source file\'s formatting.</p>', 'SampleDataS3SourceConfig$FileFormatDescriptor' => NULL, ], ], 'FlowName' => [ 'base' => NULL, 'refs' => [ 'AppFlowConfig$FlowName' => '<p> name of the flow.</p>', ], ], 'Frequency' => [ 'base' => NULL, 'refs' => [ 'AnomalyDetectorConfig$AnomalyDetectorFrequency' => '<p>The frequency at which the detector analyzes its source data.</p>', 'AnomalyDetectorConfigSummary$AnomalyDetectorFrequency' => '<p>The interval at which the detector analyzes its source data.</p>', 'CreateMetricSetRequest$MetricSetFrequency' => '<p>The frequency with which the source data will be analyzed for anomalies.</p>', 'DescribeMetricSetResponse$MetricSetFrequency' => '<p>The interval at which the data will be analyzed for anomalies.</p>', 'UpdateMetricSetRequest$MetricSetFrequency' => '<p>The dataset\'s interval.</p>', ], ], 'GetAnomalyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAnomalyGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSampleDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSampleDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'HeaderList' => [ 'base' => NULL, 'refs' => [ 'CsvFormatDescriptor$HeaderList' => '<p>A list of the source CSV file\'s headers, if any.</p>', ], ], 'HeaderValue' => [ 'base' => NULL, 'refs' => [ 'HeaderValueList$member' => NULL, ], ], 'HeaderValueList' => [ 'base' => NULL, 'refs' => [ 'GetSampleDataResponse$HeaderValues' => '<p>A list of header labels for the records.</p>', ], ], 'HistoricalDataPath' => [ 'base' => NULL, 'refs' => [ 'HistoricalDataPathList$member' => NULL, ], ], 'HistoricalDataPathList' => [ 'base' => NULL, 'refs' => [ 'S3SourceConfig$HistoricalDataPathList' => '<p>A list of paths to the historical data files.</p>', 'SampleDataS3SourceConfig$HistoricalDataPathList' => '<p>An array of strings containing the historical set of data paths.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AnomalyGroupStatistics$TotalCount' => '<p>The number of groups found.</p>', 'ItemizedMetricStats$OccurrenceCount' => '<p>The number of times that the measure appears.</p>', 'MetricLevelImpact$NumTimeSeries' => '<p>The number of anomalous metrics for the measure.</p>', ], ], 'InterMetricImpactDetails' => [ 'base' => '<p>Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by the anomaly group.</p> <p/>', 'refs' => [ 'InterMetricImpactList$member' => NULL, ], ], 'InterMetricImpactList' => [ 'base' => NULL, 'refs' => [ 'ListAnomalyGroupRelatedMetricsResponse$InterMetricImpactList' => '<p>Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by the anomaly group.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception, or failure.</p>', 'refs' => [], ], 'ItemizedMetricStats' => [ 'base' => '<p>Aggregated statistics about a measure affected by an anomaly.</p>', 'refs' => [ 'ItemizedMetricStatsList$member' => NULL, ], ], 'ItemizedMetricStatsList' => [ 'base' => NULL, 'refs' => [ 'AnomalyGroupStatistics$ItemizedMetricStatsList' => '<p>Statistics for individual metrics within the group.</p>', ], ], 'JsonFileCompression' => [ 'base' => NULL, 'refs' => [ 'JsonFormatDescriptor$FileCompression' => '<p>The level of compression of the source CSV file.</p>', ], ], 'JsonFormatDescriptor' => [ 'base' => '<p>Contains information about how a source JSON data file should be analyzed.</p>', 'refs' => [ 'FileFormatDescriptor$JsonFormatDescriptor' => '<p>Contains information about how a source JSON data file should be analyzed.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateAnomalyDetectorRequest$KmsKeyArn' => '<p>The ARN of the KMS key to use to encrypt your data.</p>', 'DescribeAnomalyDetectorResponse$KmsKeyArn' => '<p>The ARN of the KMS key to use to encrypt your data.</p>', 'UpdateAnomalyDetectorRequest$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of an AWS KMS encryption key.</p>', ], ], 'LambdaConfiguration' => [ 'base' => '<p>Contains information about a Lambda configuration.</p>', 'refs' => [ 'Action$LambdaConfiguration' => '<p>A configuration for an AWS Lambda channel.</p>', ], ], 'ListAlertsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAlertsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomalyDetectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomalyDetectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomalyGroupRelatedMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomalyGroupRelatedMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomalyGroupSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomalyGroupSummariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomalyGroupTimeSeriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomalyGroupTimeSeriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeAnomalyDetectionExecutionsRequest$MaxResults' => '<p>The number of items to return in the response.</p>', 'GetFeedbackRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListAlertsRequest$MaxResults' => '<p>The maximum number of results that will be displayed by the request.</p>', 'ListAnomalyDetectorsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListAnomalyGroupRelatedMetricsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListAnomalyGroupSummariesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListAnomalyGroupTimeSeriesRequest$MaxResults' => '<p>The maximum number of results to return.</p>', 'ListMetricSetsRequest$MaxResults' => '<p>The maximum number of results to return.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'ValidationException$Message' => NULL, 'ValidationExceptionField$Message' => '<p>The message with more information about the validation exception.</p>', ], ], 'Metric' => [ 'base' => '<p>A calculation made by contrasting a measure and a dimension from your source data.</p>', 'refs' => [ 'MetricList$member' => NULL, ], ], 'MetricChangePercentage' => [ 'base' => NULL, 'refs' => [ 'InterMetricImpactDetails$ContributionPercentage' => '<p>For potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), the percentage contribution the measure has in causing the anomalies.</p>', ], ], 'MetricLevelImpact' => [ 'base' => '<p>Details about a measure affected by an anomaly.</p>', 'refs' => [ 'MetricLevelImpactList$member' => NULL, ], ], 'MetricLevelImpactList' => [ 'base' => NULL, 'refs' => [ 'AnomalyGroup$MetricLevelImpactList' => '<p>A list of measures affected by the anomaly.</p>', ], ], 'MetricList' => [ 'base' => NULL, 'refs' => [ 'CreateMetricSetRequest$MetricList' => '<p>A list of metrics that the dataset will contain.</p>', 'DescribeMetricSetResponse$MetricList' => '<p>A list of the metrics defined by the dataset.</p>', 'UpdateMetricSetRequest$MetricList' => '<p>The metric list.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'AnomalyGroup$PrimaryMetricName' => '<p>The name of the primary affected measure for the group.</p>', 'AnomalyGroupSummary$PrimaryMetricName' => '<p>The name of the primary affected measure for the group.</p>', 'InterMetricImpactDetails$MetricName' => '<p>The name of the measure.</p>', 'ListAnomalyGroupTimeSeriesRequest$MetricName' => '<p>The name of the measure field.</p>', 'ListAnomalyGroupTimeSeriesResponse$MetricName' => '<p>The name of the measure field.</p>', 'MetricLevelImpact$MetricName' => '<p>The name of the measure.</p>', ], ], 'MetricSetDescription' => [ 'base' => NULL, 'refs' => [ 'CreateMetricSetRequest$MetricSetDescription' => '<p>A description of the dataset you are creating.</p>', 'DescribeMetricSetResponse$MetricSetDescription' => '<p>The dataset\'s description.</p>', 'MetricSetSummary$MetricSetDescription' => '<p>The description of the dataset.</p>', 'UpdateMetricSetRequest$MetricSetDescription' => '<p>The dataset\'s description.</p>', ], ], 'MetricSetName' => [ 'base' => NULL, 'refs' => [ 'CreateMetricSetRequest$MetricSetName' => '<p>The name of the dataset.</p>', 'DescribeMetricSetResponse$MetricSetName' => '<p>The name of the dataset.</p>', 'MetricSetSummary$MetricSetName' => '<p>The name of the dataset.</p>', ], ], 'MetricSetSummary' => [ 'base' => '<p>Contains information about a dataset.</p>', 'refs' => [ 'MetricSetSummaryList$member' => NULL, ], ], 'MetricSetSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMetricSetsResponse$MetricSetSummaryList' => '<p>A list of the datasets in the AWS Region, with configuration details for each.</p>', ], ], 'MetricSource' => [ 'base' => '<p>Contains information about source data used to generate a metric.</p>', 'refs' => [ 'CreateMetricSetRequest$MetricSource' => '<p>Contains information about how the source data should be interpreted.</p>', 'DescribeMetricSetResponse$MetricSource' => '<p>Contains information about the dataset\'s source data.</p>', 'UpdateMetricSetRequest$MetricSource' => NULL, ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'MetricValueList$member' => NULL, ], ], 'MetricValueList' => [ 'base' => NULL, 'refs' => [ 'TimeSeries$MetricValueList' => '<p>The values for the metric.</p>', ], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'Metric$Namespace' => '<p>The namespace for the metric.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAnomalyDetectionExecutionsRequest$NextToken' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'DescribeAnomalyDetectionExecutionsResponse$NextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'GetFeedbackRequest$NextToken' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'GetFeedbackResponse$NextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListAlertsRequest$NextToken' => '<p>If the result of the previous request is truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', 'ListAlertsResponse$NextToken' => '<p>If the response is truncated, the service returns this token. To retrieve the next set of results, use this token in the next request.</p>', 'ListAnomalyDetectorsRequest$NextToken' => '<p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', 'ListAnomalyDetectorsResponse$NextToken' => '<p>If the response is truncated, the service returns this token. To retrieve the next set of results, use the token in the next request.</p>', 'ListAnomalyGroupRelatedMetricsRequest$NextToken' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListAnomalyGroupRelatedMetricsResponse$NextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListAnomalyGroupSummariesRequest$NextToken' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListAnomalyGroupSummariesResponse$NextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListAnomalyGroupTimeSeriesRequest$NextToken' => '<p>Specify the pagination token that\'s returned by a previous request to retrieve the next page of results.</p>', 'ListAnomalyGroupTimeSeriesResponse$NextToken' => '<p>The pagination token that\'s included if more results are available.</p>', 'ListMetricSetsRequest$NextToken' => '<p>If the result of the previous request was truncated, the response includes a <code>NextToken</code>. To retrieve the next set of results, use the token in the next request. Tokens expire after 24 hours.</p>', 'ListMetricSetsResponse$NextToken' => '<p>If the response is truncated, the list call returns this token. To retrieve the next set of results, use the token in the next list request. </p>', ], ], 'Offset' => [ 'base' => NULL, 'refs' => [ 'CreateMetricSetRequest$Offset' => '<p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>', 'DescribeMetricSetResponse$Offset' => '<p>The offset in seconds. Only supported for S3 and Redshift datasources.</p>', 'UpdateMetricSetRequest$Offset' => '<p>After an interval ends, the amount of seconds that the detector waits before importing data. Offset is only supported for S3 and Redshift datasources.</p>', ], ], 'PoirotSecretManagerArn' => [ 'base' => NULL, 'refs' => [ 'RDSSourceConfig$SecretManagerArn' => '<p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>', 'RedshiftSourceConfig$SecretManagerArn' => '<p>The Amazon Resource Name (ARN) of the AWS Secrets Manager role.</p>', ], ], 'PutFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'QuotaCode' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$QuotaCode' => '<p>The quota code.</p>', ], ], 'QuoteSymbol' => [ 'base' => NULL, 'refs' => [ 'CsvFormatDescriptor$QuoteSymbol' => '<p>The character used as a quote character.</p>', ], ], 'RDSDatabaseIdentifier' => [ 'base' => NULL, 'refs' => [ 'RDSSourceConfig$DBInstanceIdentifier' => '<p>A string identifying the database instance.</p>', ], ], 'RDSDatabaseName' => [ 'base' => NULL, 'refs' => [ 'RDSSourceConfig$DatabaseName' => '<p>The name of the RDS database.</p>', ], ], 'RDSSourceConfig' => [ 'base' => '<p>Contains information about the Amazon Relational Database Service (RDS) configuration.</p>', 'refs' => [ 'MetricSource$RDSSourceConfig' => '<p>An object containing information about the Amazon Relational Database Service (RDS) configuration.</p>', ], ], 'RedshiftClusterIdentifier' => [ 'base' => NULL, 'refs' => [ 'RedshiftSourceConfig$ClusterIdentifier' => '<p>A string identifying the Redshift cluster.</p>', ], ], 'RedshiftDatabaseName' => [ 'base' => NULL, 'refs' => [ 'RedshiftSourceConfig$DatabaseName' => '<p>The Redshift database name.</p>', ], ], 'RedshiftSourceConfig' => [ 'base' => '<p>Provides information about the Amazon Redshift database configuration.</p>', 'refs' => [ 'MetricSource$RedshiftSourceConfig' => '<p>An object containing information about the Amazon Redshift database configuration.</p>', ], ], 'RelationshipType' => [ 'base' => NULL, 'refs' => [ 'InterMetricImpactDetails$RelationshipType' => '<p>Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), or whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).</p>', 'ListAnomalyGroupRelatedMetricsRequest$RelationshipTypeFilter' => '<p>Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceId' => '<p>The ID of the resource.</p>', 'ResourceNotFoundException$ResourceId' => '<p>The ID of the resource.</p>', 'ServiceQuotaExceededException$ResourceId' => '<p>The ID of the resource.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource cannot be found. Check the ARN of the resource and try again.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceType' => '<p>The type of the resource.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The type of the resource.</p>', 'ServiceQuotaExceededException$ResourceType' => '<p>The type of the resource.</p>', ], ], 'S3SourceConfig' => [ 'base' => '<p>Contains information about the configuration of the S3 bucket that contains source files.</p>', 'refs' => [ 'MetricSource$S3SourceConfig' => NULL, ], ], 'SNSConfiguration' => [ 'base' => '<p>Contains information about the SNS topic to which you want to send your alerts and the IAM role that has access to that topic.</p>', 'refs' => [ 'Action$SNSConfiguration' => '<p>A configuration for an Amazon SNS channel.</p>', ], ], 'SampleDataS3SourceConfig' => [ 'base' => '<p>Contains information about the source configuration in Amazon S3.</p>', 'refs' => [ 'GetSampleDataRequest$S3SourceConfig' => '<p>A datasource bucket in Amazon S3.</p>', ], ], 'SampleRow' => [ 'base' => NULL, 'refs' => [ 'SampleRows$member' => NULL, ], ], 'SampleRows' => [ 'base' => NULL, 'refs' => [ 'GetSampleDataResponse$SampleRows' => '<p>A list of records.</p>', ], ], 'Score' => [ 'base' => NULL, 'refs' => [ 'AnomalyGroup$AnomalyGroupScore' => '<p>The severity score of the group.</p>', 'AnomalyGroupSummary$AnomalyGroupScore' => '<p>The severity score of the group.</p>', 'DimensionValueContribution$ContributionScore' => '<p>The severity score of the value.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$SecurityGroupIdList' => '<p>An array of strings containing the list of security groups.</p>', ], ], 'SensitivityThreshold' => [ 'base' => NULL, 'refs' => [ 'Alert$AlertSensitivityThreshold' => '<p>The minimum severity for an anomaly to trigger the alert.</p>', 'AlertSummary$AlertSensitivityThreshold' => '<p>The minimum severity for an anomaly to trigger the alert.</p>', 'CreateAlertRequest$AlertSensitivityThreshold' => '<p>An integer from 0 to 100 specifying the alert sensitivity threshold.</p>', 'ListAnomalyGroupSummariesRequest$SensitivityThreshold' => '<p>The minimum severity score for inclusion in the output.</p>', ], ], 'ServiceCode' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$ServiceCode' => '<p>The service code.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request exceeded the service\'s quotas. Check the service quotas and try again.</p>', 'refs' => [], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIdList$member' => NULL, ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$SubnetIdList' => '<p>An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.</p>', ], ], 'TableName' => [ 'base' => NULL, 'refs' => [ 'RDSSourceConfig$TableName' => '<p>The name of the table in the database.</p>', 'RedshiftSourceConfig$TableName' => '<p>The table name of the Redshift database.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Keys to remove from the resource\'s tags.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'AlertSummary$Tags' => '<p>The alert\'s <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>', 'AnomalyDetectorSummary$Tags' => '<p>The detector\'s <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>', 'CreateAlertRequest$Tags' => '<p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the alert.</p>', 'CreateAnomalyDetectorRequest$Tags' => '<p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the anomaly detector.</p>', 'CreateMetricSetRequest$Tags' => '<p>A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply to the dataset.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The resource\'s tags.</p>', 'MetricSetSummary$Tags' => '<p>The dataset\'s <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>.</p>', 'TagResourceRequest$Tags' => '<p>Tags to apply to the resource. Tag keys and values can contain letters, numbers, spaces, and the following symbols: <code>_.:/=+@-</code> </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TemplatedPath' => [ 'base' => NULL, 'refs' => [ 'TemplatedPathList$member' => NULL, ], ], 'TemplatedPathList' => [ 'base' => NULL, 'refs' => [ 'S3SourceConfig$TemplatedPathList' => '<p>A list of templated paths to the source files.</p>', 'SampleDataS3SourceConfig$TemplatedPathList' => '<p>An array of strings containing the list of templated paths.</p>', ], ], 'TimeSeries' => [ 'base' => '<p>Details about a metric. A metric is an aggregation of the values of a measure for a dimension value, such as <i>availability</i> in the <i>us-east-1</i> Region.</p>', 'refs' => [ 'TimeSeriesList$member' => NULL, ], ], 'TimeSeriesFeedback' => [ 'base' => '<p>Details about feedback submitted for an anomalous metric.</p>', 'refs' => [ 'TimeSeriesFeedbackList$member' => NULL, ], ], 'TimeSeriesFeedbackList' => [ 'base' => NULL, 'refs' => [ 'GetFeedbackResponse$AnomalyGroupTimeSeriesFeedback' => '<p>Feedback for an anomalous metric.</p>', ], ], 'TimeSeriesId' => [ 'base' => NULL, 'refs' => [ 'AnomalyGroupTimeSeries$TimeSeriesId' => '<p>The ID of the metric.</p>', 'AnomalyGroupTimeSeriesFeedback$TimeSeriesId' => '<p>The ID of the metric.</p>', 'TimeSeries$TimeSeriesId' => '<p>The ID of the metric.</p>', 'TimeSeriesFeedback$TimeSeriesId' => '<p>The ID of the metric.</p>', ], ], 'TimeSeriesList' => [ 'base' => NULL, 'refs' => [ 'ListAnomalyGroupTimeSeriesResponse$TimeSeriesList' => '<p>A list of anomalous metrics.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Alert$LastModificationTime' => '<p>The time at which the alert was last modified.</p>', 'Alert$CreationTime' => '<p>The time at which the alert was created.</p>', 'AlertSummary$LastModificationTime' => '<p>The time at which the alert was last modified.</p>', 'AlertSummary$CreationTime' => '<p>The time at which the alert was created.</p>', 'AnomalyDetectorSummary$CreationTime' => '<p>The time at which the detector was created.</p>', 'AnomalyDetectorSummary$LastModificationTime' => '<p>The time at which the detector was last modified.</p>', 'DescribeAnomalyDetectorResponse$CreationTime' => '<p>The time at which the detector was created.</p>', 'DescribeAnomalyDetectorResponse$LastModificationTime' => '<p>The time at which the detector was last modified.</p>', 'DescribeMetricSetResponse$CreationTime' => '<p>The time at which the dataset was created.</p>', 'DescribeMetricSetResponse$LastModificationTime' => '<p>The time at which the dataset was last modified.</p>', 'MetricSetSummary$CreationTime' => '<p>The time at which the dataset was created.</p>', 'MetricSetSummary$LastModificationTime' => '<p>The time at which the dataset was last modified.</p>', ], ], 'TimestampColumn' => [ 'base' => '<p>Contains information about the column used to track time in a source data file.</p>', 'refs' => [ 'CreateMetricSetRequest$TimestampColumn' => '<p>Contains information about the column used for tracking time in your source data.</p>', 'DescribeMetricSetResponse$TimestampColumn' => '<p>Contains information about the column used for tracking time in your source data.</p>', 'UpdateMetricSetRequest$TimestampColumn' => '<p>The timestamp column.</p>', ], ], 'TimestampList' => [ 'base' => NULL, 'refs' => [ 'ListAnomalyGroupTimeSeriesResponse$TimestampList' => '<p>Timestamps for the anomalous metrics.</p>', ], ], 'TimestampString' => [ 'base' => NULL, 'refs' => [ 'AnomalyGroup$StartTime' => '<p>The start time for the group.</p>', 'AnomalyGroup$EndTime' => '<p>The end time for the group.</p>', 'AnomalyGroupStatistics$EvaluationStartDate' => '<p>The start of the time range that was searched.</p>', 'AnomalyGroupSummary$StartTime' => '<p>The start time for the group.</p>', 'AnomalyGroupSummary$EndTime' => '<p>The end time for the group.</p>', 'DescribeAnomalyDetectionExecutionsRequest$Timestamp' => '<p>The timestamp of the anomaly detection job.</p>', 'ExecutionStatus$Timestamp' => '<p>The run\'s timestamp.</p>', 'TimestampList$member' => NULL, ], ], 'Timezone' => [ 'base' => NULL, 'refs' => [ 'CreateMetricSetRequest$Timezone' => '<p>The time zone in which your source data was recorded.</p>', 'DescribeMetricSetResponse$Timezone' => '<p>The time zone in which the dataset\'s data was recorded.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>The request was denied due to too many requests being submitted at the same time.</p>', 'refs' => [], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'AnomalyGroup$AnomalyGroupId' => '<p>The ID of the anomaly group.</p>', 'AnomalyGroupSummary$AnomalyGroupId' => '<p>The ID of the anomaly group.</p>', 'AnomalyGroupTimeSeries$AnomalyGroupId' => '<p>The ID of the anomaly group.</p>', 'AnomalyGroupTimeSeriesFeedback$AnomalyGroupId' => '<p>The ID of the anomaly group.</p>', 'GetAnomalyGroupRequest$AnomalyGroupId' => '<p>The ID of the anomaly group.</p>', 'InterMetricImpactDetails$AnomalyGroupId' => '<p>The ID of the anomaly group.</p>', 'ListAnomalyGroupRelatedMetricsRequest$AnomalyGroupId' => '<p>The ID of the anomaly group.</p>', 'ListAnomalyGroupTimeSeriesRequest$AnomalyGroupId' => '<p>The ID of the anomaly group.</p>', 'ListAnomalyGroupTimeSeriesResponse$AnomalyGroupId' => '<p>The ID of the anomaly group.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnomalyDetectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnomalyDetectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMetricSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMetricSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by the AWS service. Check your input values and try again.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Contains information about a a field in a validation exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Fields' => '<p>Fields that failed validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>The reason that validation failed.</p>', ], ], 'VpcConfiguration' => [ 'base' => '<p>Contains configuration information about the Amazon Virtual Private Cloud (VPC).</p>', 'refs' => [ 'RDSSourceConfig$VpcConfiguration' => '<p>An object containing information about the Amazon Virtual Private Cloud (VPC) configuration.</p>', 'RedshiftSourceConfig$VpcConfiguration' => '<p>Contains information about the Amazon Virtual Private Cloud (VPC) configuration.</p>', ], ], ],];
