<?php
// This file was auto-generated from sdk-root/src/data/kinesisvideo/2017-09-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p/>', 'operations' => [ 'CreateSignalingChannel' => '<p>Creates a signaling channel. </p> <p> <code>CreateSignalingChannel</code> is an asynchronous operation.</p>', 'CreateStream' => '<p>Creates a new Kinesis video stream. </p> <p>When you create a new stream, Kinesis Video Streams assigns it a version number. When you change the stream\'s metadata, Kinesis Video Streams updates the version. </p> <p> <code>CreateStream</code> is an asynchronous operation.</p> <p>For information about how the service works, see <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/how-it-works.html">How it Works</a>. </p> <p>You must have permissions for the <code>KinesisVideo:CreateStream</code> action.</p>', 'DeleteSignalingChannel' => '<p>Deletes a specified signaling channel. <code>DeleteSignalingChannel</code> is an asynchronous operation. If you don\'t specify the channel\'s current version, the most recent version is deleted.</p>', 'DeleteStream' => '<p>Deletes a Kinesis video stream and the data contained in the stream. </p> <p>This method marks the stream for deletion, and makes the data in the stream inaccessible immediately.</p> <p> </p> <p> To ensure that you have the latest version of the stream before deleting it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the <code>DescribeStream</code> API. </p> <p>This operation requires permission for the <code>KinesisVideo:DeleteStream</code> action.</p>', 'DescribeSignalingChannel' => '<p>Returns the most current information about the signaling channel. You must specify either the name or the Amazon Resource Name (ARN) of the channel that you want to describe.</p>', 'DescribeStream' => '<p>Returns the most current information about the specified stream. You must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p>', 'GetDataEndpoint' => '<p>Gets an endpoint for a specified stream for either reading or writing. Use this endpoint in your application to read from the specified stream (using the <code>GetMedia</code> or <code>GetMediaForFragmentList</code> operations) or write to it (using the <code>PutMedia</code> operation). </p> <note> <p>The returned endpoint does not have the API name appended. The client needs to add the API name to the returned endpoint.</p> </note> <p>In the request, specify the stream either by <code>StreamName</code> or <code>StreamARN</code>.</p>', 'GetSignalingChannelEndpoint' => '<p>Provides an endpoint for the specified signaling channel to send and receive messages. This API uses the <code>SingleMasterChannelEndpointConfiguration</code> input parameter, which consists of the <code>Protocols</code> and <code>Role</code> properties.</p> <p> <code>Protocols</code> is used to determine the communication mechanism. For example, if you specify <code>WSS</code> as the protocol, this API produces a secure websocket endpoint. If you specify <code>HTTPS</code> as the protocol, this API generates an HTTPS endpoint. </p> <p> <code>Role</code> determines the messaging permissions. A <code>MASTER</code> role results in this API generating an endpoint that a client can use to communicate with any of the viewers on the channel. A <code>VIEWER</code> role results in this API generating an endpoint that a client can use to communicate only with a <code>MASTER</code>. </p>', 'ListSignalingChannels' => '<p>Returns an array of <code>ChannelInfo</code> objects. Each object describes a signaling channel. To retrieve only those channels that satisfy a specific condition, you can specify a <code>ChannelNameCondition</code>.</p>', 'ListStreams' => '<p>Returns an array of <code>StreamInfo</code> objects. Each object describes a stream. To retrieve only streams that satisfy a specific condition, you can specify a <code>StreamNameCondition</code>. </p>', 'ListTagsForResource' => '<p>Returns a list of tags associated with the specified signaling channel.</p>', 'ListTagsForStream' => '<p>Returns a list of tags associated with the specified stream.</p> <p>In the request, you must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p>', 'TagResource' => '<p>Adds one or more tags to a signaling channel. A <i>tag</i> is a key-value pair (the value is optional) that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.</p>', 'TagStream' => '<p>Adds one or more tags to a stream. A <i>tag</i> is a key-value pair (the value is optional) that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>. </p> <p>You must provide either the <code>StreamName</code> or the <code>StreamARN</code>.</p> <p>This operation requires permission for the <code>KinesisVideo:TagStream</code> action.</p> <p>Kinesis video streams support up to 50 tags.</p>', 'UntagResource' => '<p>Removes one or more tags from a signaling channel. In the request, specify only a tag key or keys; don\'t specify the value. If you specify a tag key that does not exist, it\'s ignored.</p>', 'UntagStream' => '<p>Removes one or more tags from a stream. In the request, specify only a tag key or keys; don\'t specify the value. If you specify a tag key that does not exist, it\'s ignored.</p> <p>In the request, you must provide the <code>StreamName</code> or <code>StreamARN</code>.</p>', 'UpdateDataRetention' => '<p> Increases or decreases the stream\'s data retention period by the value that you specify. To indicate whether you want to increase or decrease the data retention period, specify the <code>Operation</code> parameter in the request body. In the request, you must specify either the <code>StreamName</code> or the <code>StreamARN</code>. </p> <note> <p>The retention period that you specify replaces the current value.</p> </note> <p>This operation requires permission for the <code>KinesisVideo:UpdateDataRetention</code> action.</p> <p>Changing the data retention period affects the data in the stream as follows:</p> <ul> <li> <p>If the data retention period is increased, existing data is retained for the new retention period. For example, if the data retention period is increased from one hour to seven hours, all existing data is retained for seven hours.</p> </li> <li> <p>If the data retention period is decreased, existing data is retained for the new retention period. For example, if the data retention period is decreased from seven hours to one hour, all existing data is retained for one hour, and any data older than one hour is deleted immediately.</p> </li> </ul>', 'UpdateSignalingChannel' => '<p>Updates the existing signaling channel. This is an asynchronous operation and takes time to complete. </p> <p>If the <code>MessageTtlSeconds</code> value is updated (either increased or reduced), it only applies to new messages sent via this channel after it\'s been updated. Existing messages are still expired as per the previous <code>MessageTtlSeconds</code> value.</p>', 'UpdateStream' => '<p>Updates stream metadata, such as the device name and media type.</p> <p>You must provide the stream name or the Amazon Resource Name (ARN) of the stream.</p> <p>To make sure that you have the latest version of the stream before updating it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the <code>DescribeStream</code> API. </p> <p> <code>UpdateStream</code> is an asynchronous operation, and takes time to complete.</p>', ], 'shapes' => [ 'APIName' => [ 'base' => NULL, 'refs' => [ 'GetDataEndpointInput$APIName' => '<p>The name of the API action for which to get an endpoint.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have required permissions to perform this operation.</p>', 'refs' => [], ], 'AccountChannelLimitExceededException' => [ 'base' => '<p>You have reached the maximum limit of active signaling channels for this AWS account in this region.</p>', 'refs' => [], ], 'AccountStreamLimitExceededException' => [ 'base' => '<p>The number of streams created for the account is too high.</p>', 'refs' => [], ], 'ChannelInfo' => [ 'base' => '<p>A structure that encapsulates a signaling channel\'s metadata and properties.</p>', 'refs' => [ 'ChannelInfoList$member' => NULL, 'DescribeSignalingChannelOutput$ChannelInfo' => '<p>A structure that encapsulates the specified signaling channel\'s metadata and properties.</p>', ], ], 'ChannelInfoList' => [ 'base' => NULL, 'refs' => [ 'ListSignalingChannelsOutput$ChannelInfoList' => '<p>An array of <code>ChannelInfo</code> objects.</p>', ], ], 'ChannelName' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$ChannelName' => '<p>The name of the signaling channel.</p>', 'ChannelNameCondition$ComparisonValue' => '<p>A value to compare.</p>', 'CreateSignalingChannelInput$ChannelName' => '<p>A name for the signaling channel that you are creating. It must be unique for each AWS account and AWS Region.</p>', 'DescribeSignalingChannelInput$ChannelName' => '<p>The name of the signaling channel that you want to describe.</p>', ], ], 'ChannelNameCondition' => [ 'base' => '<p>An optional input parameter for the <code>ListSignalingChannels</code> API. When this parameter is specified while invoking <code>ListSignalingChannels</code>, the API returns only the channels that satisfy a condition specified in <code>ChannelNameCondition</code>.</p>', 'refs' => [ 'ListSignalingChannelsInput$ChannelNameCondition' => '<p>Optional: Returns only the channels that satisfy a specific condition.</p>', ], ], 'ChannelProtocol' => [ 'base' => NULL, 'refs' => [ 'ListOfProtocols$member' => NULL, 'ResourceEndpointListItem$Protocol' => '<p>The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>', ], ], 'ChannelRole' => [ 'base' => NULL, 'refs' => [ 'SingleMasterChannelEndpointConfiguration$Role' => '<p>This property is used to determine messaging permissions in this <code>SINGLE_MASTER</code> signaling channel. If <code>MASTER</code> is specified, this API returns an endpoint that a client can use to receive offers from and send answers to any of the viewers on this signaling channel. If <code>VIEWER</code> is specified, this API returns an endpoint that a client can use only to send offers to another <code>MASTER</code> client on this signaling channel. </p>', ], ], 'ChannelType' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$ChannelType' => '<p>The type of the signaling channel.</p>', 'CreateSignalingChannelInput$ChannelType' => '<p>A type of the signaling channel that you are creating. Currently, <code>SINGLE_MASTER</code> is the only supported channel type. </p>', ], ], 'ClientLimitExceededException' => [ 'base' => '<p>Kinesis Video Streams has throttled the request because you have exceeded the limit of allowed client calls. Try making the call later.</p>', 'refs' => [], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'ChannelNameCondition$ComparisonOperator' => '<p>A comparison operator. Currently, you can only specify the <code>BEGINS_WITH</code> operator, which finds signaling channels whose names begin with a given prefix.</p>', 'StreamNameCondition$ComparisonOperator' => '<p>A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.</p>', ], ], 'CreateSignalingChannelInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSignalingChannelOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'DataEndpoint' => [ 'base' => NULL, 'refs' => [ 'GetDataEndpointOutput$DataEndpoint' => '<p>The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your application.</p>', ], ], 'DataRetentionChangeInHours' => [ 'base' => NULL, 'refs' => [ 'UpdateDataRetentionInput$DataRetentionChangeInHours' => '<p>The retention period, in hours. The value you specify replaces the current value. The maximum value for this parameter is 87600 (ten years).</p>', ], ], 'DataRetentionInHours' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$DataRetentionInHours' => '<p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p> <p>The default value is 0, indicating that the stream does not persist data.</p> <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p>', 'StreamInfo$DataRetentionInHours' => '<p>How long the stream retains data, in hours.</p>', ], ], 'DeleteSignalingChannelInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSignalingChannelOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSignalingChannelInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSignalingChannelOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeviceName' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$DeviceName' => '<p>The name of the device that is writing to the stream. </p> <note> <p>In the current implementation, Kinesis Video Streams does not use this name.</p> </note>', 'StreamInfo$DeviceName' => '<p>The name of the device that is associated with the stream.</p>', 'UpdateStreamInput$DeviceName' => '<p>The name of the device that is writing to the stream. </p> <note> <p> In the current implementation, Kinesis Video Streams does not use this name. </p> </note>', ], ], 'DeviceStreamLimitExceededException' => [ 'base' => '<p>Not implemented. </p>', 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'AccountChannelLimitExceededException$Message' => NULL, 'AccountStreamLimitExceededException$Message' => NULL, 'ClientLimitExceededException$Message' => NULL, 'DeviceStreamLimitExceededException$Message' => NULL, 'InvalidArgumentException$Message' => NULL, 'InvalidDeviceException$Message' => NULL, 'InvalidResourceFormatException$Message' => NULL, 'NotAuthorizedException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'TagsPerResourceExceededLimitException$Message' => NULL, 'VersionMismatchException$Message' => NULL, ], ], 'GetDataEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'GetDataEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSignalingChannelEndpointInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSignalingChannelEndpointOutput' => [ 'base' => NULL, 'refs' => [], ], 'InvalidArgumentException' => [ 'base' => '<p>The value for this input parameter is invalid.</p>', 'refs' => [], ], 'InvalidDeviceException' => [ 'base' => '<p>Not implemented.</p>', 'refs' => [], ], 'InvalidResourceFormatException' => [ 'base' => '<p>The format of the <code>StreamARN</code> is invalid.</p>', 'refs' => [], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$KmsKeyId' => '<p>The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p> <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is used.</p> <p> For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>. </p>', 'StreamInfo$KmsKeyId' => '<p>The ID of the AWS Key Management Service (AWS KMS) key that Kinesis Video Streams uses to encrypt data on the stream.</p>', ], ], 'ListOfProtocols' => [ 'base' => NULL, 'refs' => [ 'SingleMasterChannelEndpointConfiguration$Protocols' => '<p>This property is used to determine the nature of communication over this <code>SINGLE_MASTER</code> signaling channel. If <code>WSS</code> is specified, this API returns a websocket endpoint. If <code>HTTPS</code> is specified, this API returns an <code>HTTPS</code> endpoint.</p>', ], ], 'ListSignalingChannelsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSignalingChannelsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStreamsInputLimit' => [ 'base' => NULL, 'refs' => [ 'ListSignalingChannelsInput$MaxResults' => '<p>The maximum number of channels to return in the response. The default is 500.</p>', 'ListStreamsInput$MaxResults' => '<p>The maximum number of streams to return in the response. The default is 10,000.</p>', ], ], 'ListStreamsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'MediaType' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$MediaType' => '<p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p> <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p> <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p>', 'StreamInfo$MediaType' => '<p>The <code>MediaType</code> of the stream. </p>', 'UpdateStreamInput$MediaType' => '<p>The stream\'s media type. Use <code>MediaType</code> to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>.</p> <p>To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify <code>video/h264</code> as the <code>MediaType</code>.</p>', ], ], 'MessageTtlSeconds' => [ 'base' => NULL, 'refs' => [ 'SingleMasterConfiguration$MessageTtlSeconds' => '<p>The period of time a signaling channel retains underlivered messages before they are discarded.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListSignalingChannelsInput$NextToken' => '<p>If you specify this parameter, when the result of a <code>ListSignalingChannels</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of channels, provide this token in your next request.</p>', 'ListSignalingChannelsOutput$NextToken' => '<p>If the response is truncated, the call returns this element with a token. To get the next batch of streams, use this token in your next request.</p>', 'ListStreamsInput$NextToken' => '<p>If you specify this parameter, when the result of a <code>ListStreams</code> operation is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of streams, provide this token in your next request.</p>', 'ListStreamsOutput$NextToken' => '<p>If the response is truncated, the call returns this element with a token. To get the next batch of streams, use this token in your next request. </p>', 'ListTagsForResourceInput$NextToken' => '<p>If you specify this parameter and the result of a <code>ListTagsForResource</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags. </p>', 'ListTagsForResourceOutput$NextToken' => '<p>If you specify this parameter and the result of a <code>ListTagsForResource</code> call is truncated, the response includes a token that you can use in the next request to fetch the next set of tags. </p>', 'ListTagsForStreamInput$NextToken' => '<p>If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the response includes a token that you can use in the next request to fetch the next batch of tags.</p>', 'ListTagsForStreamOutput$NextToken' => '<p>If you specify this parameter and the result of a <code>ListTags</code> call is truncated, the response includes a token that you can use in the next request to fetch the next set of tags.</p>', ], ], 'NotAuthorizedException' => [ 'base' => '<p>The caller is not authorized to perform this operation.</p>', 'refs' => [], ], 'ResourceARN' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel.</p>', 'CreateSignalingChannelOutput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the created channel.</p>', 'CreateStreamOutput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'DeleteSignalingChannelInput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel that you want to delete.</p>', 'DeleteStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream that you want to delete. </p>', 'DescribeSignalingChannelInput$ChannelARN' => '<p>The ARN of the signaling channel that you want to describe.</p>', 'DescribeStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'GetDataEndpointInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamName</code> in the request. </p>', 'GetSignalingChannelEndpointInput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the signalling channel for which you want to get an endpoint.</p>', 'ListTagsForResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel for which you want to list tags.</p>', 'ListTagsForStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream that you want to list tags for.</p>', 'StreamInfo$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream.</p>', 'TagResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel to which you want to add tags.</p>', 'TagStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the resource that you want to add the tag or tags to.</p>', 'UntagResourceInput$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel from which you want to remove tags.</p>', 'UntagStreamInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream that you want to remove tags from.</p>', 'UpdateDataRetentionInput$StreamARN' => '<p>The Amazon Resource Name (ARN) of the stream whose retention period you want to change.</p>', 'UpdateSignalingChannelInput$ChannelARN' => '<p>The Amazon Resource Name (ARN) of the signaling channel that you want to update.</p>', 'UpdateStreamInput$StreamARN' => '<p>The ARN of the stream whose metadata you want to update.</p>', ], ], 'ResourceEndpoint' => [ 'base' => NULL, 'refs' => [ 'ResourceEndpointListItem$ResourceEndpoint' => '<p>The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>', ], ], 'ResourceEndpointList' => [ 'base' => NULL, 'refs' => [ 'GetSignalingChannelEndpointOutput$ResourceEndpointList' => '<p>A list of endpoints for the specified signaling channel.</p>', ], ], 'ResourceEndpointListItem' => [ 'base' => '<p>An object that describes the endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.</p>', 'refs' => [ 'ResourceEndpointList$member' => NULL, ], ], 'ResourceInUseException' => [ 'base' => '<p>The signaling channel is currently not available for this operation.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Amazon Kinesis Video Streams can\'t find the stream that you specified.</p>', 'refs' => [], ], 'ResourceTags' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$Tags' => '<p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>', 'ListTagsForResourceOutput$Tags' => '<p>A map of tag keys and values associated with the specified signaling channel.</p>', 'ListTagsForStreamOutput$Tags' => '<p>A map of tag keys and values associated with the specified stream.</p>', 'TagStreamInput$Tags' => '<p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p>', ], ], 'SingleMasterChannelEndpointConfiguration' => [ 'base' => '<p>An object that contains the endpoint configuration for the <code>SINGLE_MASTER</code> channel type. </p>', 'refs' => [ 'GetSignalingChannelEndpointInput$SingleMasterChannelEndpointConfiguration' => '<p>A structure containing the endpoint configuration for the <code>SINGLE_MASTER</code> channel type.</p>', ], ], 'SingleMasterConfiguration' => [ 'base' => '<p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.</p>', 'refs' => [ 'ChannelInfo$SingleMasterConfiguration' => '<p>A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.</p>', 'CreateSignalingChannelInput$SingleMasterConfiguration' => '<p>A structure containing the configuration for the <code>SINGLE_MASTER</code> channel type. </p>', 'UpdateSignalingChannelInput$SingleMasterConfiguration' => '<p>The structure containing the configuration for the <code>SINGLE_MASTER</code> type of the signaling channel that you want to update. </p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$ChannelStatus' => '<p>Current status of the signaling channel.</p>', 'StreamInfo$Status' => '<p>The status of the stream.</p>', ], ], 'StreamInfo' => [ 'base' => '<p>An object describing a Kinesis video stream.</p>', 'refs' => [ 'DescribeStreamOutput$StreamInfo' => '<p>An object that describes the stream.</p>', 'StreamInfoList$member' => NULL, ], ], 'StreamInfoList' => [ 'base' => NULL, 'refs' => [ 'ListStreamsOutput$StreamInfoList' => '<p>An array of <code>StreamInfo</code> objects.</p>', ], ], 'StreamName' => [ 'base' => NULL, 'refs' => [ 'CreateStreamInput$StreamName' => '<p>A name for the stream that you are creating.</p> <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>', 'DescribeStreamInput$StreamName' => '<p>The name of the stream.</p>', 'GetDataEndpointInput$StreamName' => '<p>The name of the stream that you want to get the endpoint for. You must specify either this parameter or a <code>StreamARN</code> in the request.</p>', 'ListTagsForStreamInput$StreamName' => '<p>The name of the stream that you want to list tags for.</p>', 'StreamInfo$StreamName' => '<p>The name of the stream.</p>', 'StreamNameCondition$ComparisonValue' => '<p>A value to compare.</p>', 'TagStreamInput$StreamName' => '<p>The name of the stream that you want to add the tag or tags to.</p>', 'UntagStreamInput$StreamName' => '<p>The name of the stream that you want to remove tags from.</p>', 'UpdateDataRetentionInput$StreamName' => '<p>The name of the stream whose retention period you want to change.</p>', 'UpdateStreamInput$StreamName' => '<p>The name of the stream whose metadata you want to update.</p> <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p>', ], ], 'StreamNameCondition' => [ 'base' => '<p>Specifies the condition that streams must satisfy to be returned when you list streams (see the <code>ListStreams</code> API). A condition has a comparison operation and a value. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix. </p>', 'refs' => [ 'ListStreamsInput$StreamNameCondition' => '<p>Optional: Returns only streams that satisfy a specific condition. Currently, you can specify only the prefix of a stream name as a condition. </p>', ], ], 'Tag' => [ 'base' => '<p>A key and value pair that is associated with the specified signaling channel.</p>', 'refs' => [ 'TagList$member' => NULL, 'TagOnCreateList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'ResourceTags$key' => NULL, 'Tag$Key' => '<p>The key of the tag that is associated with the specified signaling channel.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeyList' => '<p>A list of the keys of the tags that you want to remove.</p>', 'UntagStreamInput$TagKeyList' => '<p>A list of the keys of the tags that you want to remove.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'TagResourceInput$Tags' => '<p>A list of tags to associate with the specified signaling channel. Each tag is a key-value pair.</p>', ], ], 'TagOnCreateList' => [ 'base' => NULL, 'refs' => [ 'CreateSignalingChannelInput$Tags' => '<p>A set of tags (key-value pairs) that you want to associate with this channel.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'TagStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'ResourceTags$value' => NULL, 'Tag$Value' => '<p>The value of the tag that is associated with the specified signaling channel.</p>', ], ], 'TagsPerResourceExceededLimitException' => [ 'base' => '<p>You have exceeded the limit of tags that you can associate with the resource. Kinesis video streams support up to 50 tags. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$CreationTime' => '<p>The time at which the signaling channel was created.</p>', 'StreamInfo$CreationTime' => '<p>A time stamp that indicates when the stream was created.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UntagStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataRetentionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataRetentionOperation' => [ 'base' => NULL, 'refs' => [ 'UpdateDataRetentionInput$Operation' => '<p>Indicates whether you want to increase or decrease the retention period.</p>', ], ], 'UpdateDataRetentionOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSignalingChannelInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSignalingChannelOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStreamInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStreamOutput' => [ 'base' => NULL, 'refs' => [], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'ChannelInfo$Version' => '<p>The current version of the signaling channel.</p>', 'DeleteSignalingChannelInput$CurrentVersion' => '<p>The current version of the signaling channel that you want to delete. You can obtain the current version by invoking the <code>DescribeSignalingChannel</code> or <code>ListSignalingChannels</code> API operations.</p>', 'DeleteStreamInput$CurrentVersion' => '<p>Optional: The version of the stream that you want to delete. </p> <p>Specify the version as a safeguard to ensure that your are deleting the correct stream. To get the stream version, use the <code>DescribeStream</code> API.</p> <p>If not specified, only the <code>CreationTime</code> is checked before deleting the stream.</p>', 'StreamInfo$Version' => '<p>The version of the stream.</p>', 'UpdateDataRetentionInput$CurrentVersion' => '<p>The version of the stream whose retention period you want to change. To get the version, call either the <code>DescribeStream</code> or the <code>ListStreams</code> API.</p>', 'UpdateSignalingChannelInput$CurrentVersion' => '<p>The current version of the signaling channel that you want to update.</p>', 'UpdateStreamInput$CurrentVersion' => '<p>The version of the stream whose metadata you want to update.</p>', ], ], 'VersionMismatchException' => [ 'base' => '<p>The stream version that you specified is not the latest version. To get the latest version, use the <a href="https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html">DescribeStream</a> API.</p>', 'refs' => [], ], ],];
