<?php
// This file was auto-generated from sdk-root/src/data/iotevents/2018-07-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS IoT Events monitors your equipment or device fleets for failures or changes in operation, and triggers actions when such events occur. You can use AWS IoT Events API operations to create, read, update, and delete inputs and detector models, and to list their versions.</p>', 'operations' => [ 'CreateAlarmModel' => '<p>Creates an alarm model to monitor an AWS IoT Events input attribute. You can use the alarm to get notified when the value is outside a specified range. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/create-alarms.html">Create an alarm model</a> in the <i>AWS IoT Events Developer Guide</i>.</p>', 'CreateDetectorModel' => '<p>Creates a detector model.</p>', 'CreateInput' => '<p>Creates an input.</p>', 'DeleteAlarmModel' => '<p>Deletes an alarm model. Any alarm instances that were created based on this alarm model are also deleted. This action can\'t be undone.</p>', 'DeleteDetectorModel' => '<p>Deletes a detector model. Any active instances of the detector model are also deleted.</p>', 'DeleteInput' => '<p>Deletes an input.</p>', 'DescribeAlarmModel' => '<p>Retrieves information about an alarm model. If you don\'t specify a value for the <code>alarmModelVersion</code> parameter, the latest version is returned.</p>', 'DescribeDetectorModel' => '<p>Describes a detector model. If the <code>version</code> parameter is not specified, information about the latest version is returned.</p>', 'DescribeDetectorModelAnalysis' => '<p>Retrieves runtime information about a detector model analysis.</p> <note> <p>After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.</p> </note>', 'DescribeInput' => '<p>Describes an input.</p>', 'DescribeLoggingOptions' => '<p>Retrieves the current settings of the AWS IoT Events logging options.</p>', 'GetDetectorModelAnalysisResults' => '<p>Retrieves one or more analysis results of the detector model.</p> <note> <p>After AWS IoT Events starts analyzing your detector model, you have up to 24 hours to retrieve the analysis results.</p> </note>', 'ListAlarmModelVersions' => '<p>Lists all the versions of an alarm model. The operation returns only the metadata associated with each alarm model version.</p>', 'ListAlarmModels' => '<p>Lists the alarm models that you created. The operation returns only the metadata associated with each alarm model.</p>', 'ListDetectorModelVersions' => '<p>Lists all the versions of a detector model. Only the metadata associated with each detector model version is returned.</p>', 'ListDetectorModels' => '<p>Lists the detector models you have created. Only the metadata associated with each detector model is returned.</p>', 'ListInputRoutings' => '<p> Lists one or more input routings. </p>', 'ListInputs' => '<p>Lists the inputs you have created.</p>', 'ListTagsForResource' => '<p>Lists the tags (metadata) you have assigned to the resource.</p>', 'PutLoggingOptions' => '<p>Sets or updates the AWS IoT Events logging options.</p> <p>If you update the value of any <code>loggingOptions</code> field, it takes up to one minute for the change to take effect. If you change the policy attached to the role you specified in the <code>roleArn</code> field (for example, to correct an invalid policy), it takes up to five minutes for that change to take effect.</p>', 'StartDetectorModelAnalysis' => '<p>Performs an analysis of your detector model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Troubleshooting a detector model</a> in the <i>AWS IoT Events Developer Guide</i>.</p>', 'TagResource' => '<p>Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.</p>', 'UntagResource' => '<p>Removes the given tags (metadata) from the resource.</p>', 'UpdateAlarmModel' => '<p>Updates an alarm model. Any alarms that were created based on the previous version are deleted and then created again as new data arrives.</p>', 'UpdateDetectorModel' => '<p>Updates a detector model. Detectors (instances) spawned by the previous version are deleted and then re-created as new inputs arrive.</p>', 'UpdateInput' => '<p>Updates an input.</p>', ], 'shapes' => [ 'AcknowledgeFlow' => [ 'base' => '<p>Specifies whether to get notified for alarm state changes.</p>', 'refs' => [ 'AlarmCapabilities$acknowledgeFlow' => '<p>Specifies whether to get notified for alarm state changes.</p>', ], ], 'AcknowledgeFlowEnabled' => [ 'base' => NULL, 'refs' => [ 'AcknowledgeFlow$enabled' => '<p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>TRUE</code>, you receive a notification when the alarm state changes. You must choose to acknowledge the notification before the alarm state can return to <code>NORMAL</code>. If <code>FALSE</code>, you won\'t receive notifications. The alarm automatically changes to the <code>NORMAL</code> state when the input property value returns to the specified range.</p>', ], ], 'Action' => [ 'base' => '<p>An action to be performed when the <code>condition</code> is TRUE.</p>', 'refs' => [ 'Actions$member' => NULL, ], ], 'Actions' => [ 'base' => NULL, 'refs' => [ 'Event$actions' => '<p>The actions to be performed.</p>', 'TransitionEvent$actions' => '<p>The actions to be performed.</p>', ], ], 'AlarmAction' => [ 'base' => '<p>Specifies one of the following actions to receive notifications when the alarm state changes.</p>', 'refs' => [ 'AlarmActions$member' => NULL, ], ], 'AlarmActions' => [ 'base' => NULL, 'refs' => [ 'AlarmEventActions$alarmActions' => '<p>Specifies one or more supported actions to receive notifications when the alarm state changes.</p>', ], ], 'AlarmCapabilities' => [ 'base' => '<p>Contains the configuration information of alarm state changes.</p>', 'refs' => [ 'CreateAlarmModelRequest$alarmCapabilities' => '<p>Contains the configuration information of alarm state changes.</p>', 'DescribeAlarmModelResponse$alarmCapabilities' => '<p>Contains the configuration information of alarm state changes.</p>', 'UpdateAlarmModelRequest$alarmCapabilities' => '<p>Contains the configuration information of alarm state changes.</p>', ], ], 'AlarmEventActions' => [ 'base' => '<p>Contains information about one or more alarm actions.</p>', 'refs' => [ 'CreateAlarmModelRequest$alarmEventActions' => '<p>Contains information about one or more alarm actions.</p>', 'DescribeAlarmModelResponse$alarmEventActions' => '<p>Contains information about one or more alarm actions.</p>', 'UpdateAlarmModelRequest$alarmEventActions' => '<p>Contains information about one or more alarm actions.</p>', ], ], 'AlarmModelArn' => [ 'base' => NULL, 'refs' => [ 'AlarmModelVersionSummary$alarmModelArn' => '<p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'CreateAlarmModelResponse$alarmModelArn' => '<p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeAlarmModelResponse$alarmModelArn' => '<p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'UpdateAlarmModelResponse$alarmModelArn' => '<p>The ARN of the alarm model. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', ], ], 'AlarmModelDescription' => [ 'base' => NULL, 'refs' => [ 'AlarmModelSummary$alarmModelDescription' => '<p>The description of the alarm model.</p>', 'CreateAlarmModelRequest$alarmModelDescription' => '<p>A description that tells you what the alarm model detects.</p>', 'DescribeAlarmModelResponse$alarmModelDescription' => '<p>The description of the alarm model.</p>', 'UpdateAlarmModelRequest$alarmModelDescription' => '<p>The description of the alarm model.</p>', ], ], 'AlarmModelName' => [ 'base' => NULL, 'refs' => [ 'AlarmModelSummary$alarmModelName' => '<p>The name of the alarm model.</p>', 'AlarmModelVersionSummary$alarmModelName' => '<p>The name of the alarm model.</p>', 'CreateAlarmModelRequest$alarmModelName' => '<p>A unique name that helps you identify the alarm model. You can\'t change this name after you create the alarm model.</p>', 'DeleteAlarmModelRequest$alarmModelName' => '<p>The name of the alarm model.</p>', 'DescribeAlarmModelRequest$alarmModelName' => '<p>The name of the alarm model.</p>', 'DescribeAlarmModelResponse$alarmModelName' => '<p>The name of the alarm model.</p>', 'ListAlarmModelVersionsRequest$alarmModelName' => '<p>The name of the alarm model.</p>', 'UpdateAlarmModelRequest$alarmModelName' => '<p>The name of the alarm model.</p>', ], ], 'AlarmModelSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAlarmModelsResponse$alarmModelSummaries' => '<p>A list that summarizes each alarm model.</p>', ], ], 'AlarmModelSummary' => [ 'base' => '<p>Contains a summary of an alarm model.</p>', 'refs' => [ 'AlarmModelSummaries$member' => NULL, ], ], 'AlarmModelVersion' => [ 'base' => NULL, 'refs' => [ 'AlarmModelVersionSummary$alarmModelVersion' => '<p>The version of the alarm model.</p>', 'CreateAlarmModelResponse$alarmModelVersion' => '<p>The version of the alarm model.</p>', 'DescribeAlarmModelRequest$alarmModelVersion' => '<p>The version of the alarm model.</p>', 'DescribeAlarmModelResponse$alarmModelVersion' => '<p>The version of the alarm model.</p>', 'UpdateAlarmModelResponse$alarmModelVersion' => '<p>The version of the alarm model.</p>', ], ], 'AlarmModelVersionStatus' => [ 'base' => NULL, 'refs' => [ 'AlarmModelVersionSummary$status' => '<p>The status of the alarm model. The status can be one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - The alarm model is active and it\'s ready to evaluate data.</p> </li> <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li> <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn\'t ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li> <li> <p> <code>FAILED</code> - You couldn\'t create or update the alarm model. Check your alarm model information and try again.</p> </li> </ul>', 'CreateAlarmModelResponse$status' => '<p>The status of the alarm model. The status can be one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - The alarm model is active and it\'s ready to evaluate data.</p> </li> <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li> <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn\'t ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li> <li> <p> <code>FAILED</code> - You couldn\'t create or update the alarm model. Check your alarm model information and try again.</p> </li> </ul>', 'DescribeAlarmModelResponse$status' => '<p>The status of the alarm model. The status can be one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - The alarm model is active and it\'s ready to evaluate data.</p> </li> <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li> <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn\'t ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li> <li> <p> <code>FAILED</code> - You couldn\'t create or update the alarm model. Check your alarm model information and try again.</p> </li> </ul>', 'UpdateAlarmModelResponse$status' => '<p>The status of the alarm model. The status can be one of the following values:</p> <ul> <li> <p> <code>ACTIVE</code> - The alarm model is active and it\'s ready to evaluate data.</p> </li> <li> <p> <code>ACTIVATING</code> - AWS IoT Events is activating your alarm model. Activating an alarm model can take up to a few minutes.</p> </li> <li> <p> <code>INACTIVE</code> - The alarm model is inactive, so it isn\'t ready to evaluate data. Check your alarm model information and update the alarm model.</p> </li> <li> <p> <code>FAILED</code> - You couldn\'t create or update the alarm model. Check your alarm model information and try again.</p> </li> </ul>', ], ], 'AlarmModelVersionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAlarmModelVersionsResponse$alarmModelVersionSummaries' => '<p>A list that summarizes each alarm model version.</p>', ], ], 'AlarmModelVersionSummary' => [ 'base' => '<p>Contains a summary of an alarm model version.</p>', 'refs' => [ 'AlarmModelVersionSummaries$member' => NULL, ], ], 'AlarmNotification' => [ 'base' => '<p>Contains information about one or more notification actions.</p>', 'refs' => [ 'CreateAlarmModelRequest$alarmNotification' => '<p>Contains information about one or more notification actions.</p>', 'DescribeAlarmModelResponse$alarmNotification' => '<p>Contains information about one or more notification actions.</p>', 'UpdateAlarmModelRequest$alarmNotification' => '<p>Contains information about one or more notification actions.</p>', ], ], 'AlarmRule' => [ 'base' => '<p>Defines when your alarm is invoked.</p>', 'refs' => [ 'CreateAlarmModelRequest$alarmRule' => '<p>Defines when your alarm is invoked.</p>', 'DescribeAlarmModelResponse$alarmRule' => '<p>Defines when your alarm is invoked.</p>', 'UpdateAlarmModelRequest$alarmRule' => '<p>Defines when your alarm is invoked.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'AlarmModelVersionSummary$roleArn' => '<p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'CreateAlarmModelRequest$roleArn' => '<p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'CreateDetectorModelRequest$roleArn' => '<p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>', 'DescribeAlarmModelResponse$roleArn' => '<p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DetectorModelConfiguration$roleArn' => '<p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>', 'DetectorModelVersionSummary$roleArn' => '<p>The ARN of the role that grants the detector model permission to perform its tasks.</p>', 'LambdaAction$functionArn' => '<p>The ARN of the Lambda function that is executed.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'LoggingOptions$roleArn' => '<p>The ARN of the role that grants permission to AWS IoT Events to perform logging.</p>', 'RoutedResource$arn' => '<p> The ARN of the routed resource. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>. </p>', 'SNSTopicPublishAction$targetArn' => '<p>The ARN of the Amazon SNS target where the message is sent.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'UpdateAlarmModelRequest$roleArn' => '<p>The ARN of the IAM role that allows the alarm to perform actions and access AWS resources. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'UpdateDetectorModelRequest$roleArn' => '<p>The ARN of the role that grants permission to AWS IoT Events to perform its operations.</p>', ], ], 'AnalysisId' => [ 'base' => NULL, 'refs' => [ 'DescribeDetectorModelAnalysisRequest$analysisId' => '<p>The ID of the analysis result that you want to retrieve.</p>', 'GetDetectorModelAnalysisResultsRequest$analysisId' => '<p>The ID of the analysis result that you want to retrieve.</p>', 'StartDetectorModelAnalysisResponse$analysisId' => '<p>The ID that you can use to retrieve the analysis result.</p>', ], ], 'AnalysisMessage' => [ 'base' => NULL, 'refs' => [ 'AnalysisResult$message' => '<p>Contains additional information about the analysis result.</p>', ], ], 'AnalysisResult' => [ 'base' => '<p>Contains the result of the analysis.</p>', 'refs' => [ 'AnalysisResults$member' => NULL, ], ], 'AnalysisResultLevel' => [ 'base' => NULL, 'refs' => [ 'AnalysisResult$level' => '<p>The severity level of the analysis result. Based on the severity level, analysis results fall into three general categories:</p> <ul> <li> <p> <code>INFO</code> - An information result tells you about a significant field in your detector model. This type of result usually doesn\'t require immediate action.</p> </li> <li> <p> <code>WARNING</code> - A warning result draws special attention to fields that might cause issues for your detector model. We recommend that you review warnings and take necessary actions before you use your detector model in production environments. Otherwise, the detector model might not work as expected.</p> </li> <li> <p> <code>ERROR</code> - An error result notifies you about a problem found in your detector model. You must fix all errors before you can publish your detector model.</p> </li> </ul>', ], ], 'AnalysisResultLocation' => [ 'base' => '<p>Contains information that you can use to locate the field in your detector model that the analysis result references.</p>', 'refs' => [ 'AnalysisResultLocations$member' => NULL, ], ], 'AnalysisResultLocationPath' => [ 'base' => NULL, 'refs' => [ 'AnalysisResultLocation$path' => '<p>A <a href="https://github.com/json-path/JsonPath">JsonPath</a> expression that identifies the error field in your detector model.</p>', ], ], 'AnalysisResultLocations' => [ 'base' => NULL, 'refs' => [ 'AnalysisResult$locations' => '<p>Contains one or more locations that you can use to locate the fields in your detector model that the analysis result references.</p>', ], ], 'AnalysisResults' => [ 'base' => NULL, 'refs' => [ 'GetDetectorModelAnalysisResultsResponse$analysisResults' => '<p>Contains information about one or more analysis results.</p>', ], ], 'AnalysisStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDetectorModelAnalysisResponse$status' => '<p>The status of the analysis activity. The status can be one of the following values:</p> <ul> <li> <p> <code>RUNNING</code> - AWS IoT Events is analyzing your detector model. This process can take several minutes to complete.</p> </li> <li> <p> <code>COMPLETE</code> - AWS IoT Events finished analyzing your detector model.</p> </li> <li> <p> <code>FAILED</code> - AWS IoT Events couldn\'t analyze your detector model. Try again later.</p> </li> </ul>', ], ], 'AnalysisType' => [ 'base' => NULL, 'refs' => [ 'AnalysisResult$type' => '<p>The type of the analysis result. Analyses fall into the following types based on the validators used to generate the analysis result:</p> <ul> <li> <p> <code>supported-actions</code> - You must specify AWS IoT Events supported actions that work with other AWS services in a supported AWS Region.</p> </li> <li> <p> <code>service-limits</code> - Resources or API operations can\'t exceed service quotas (also known as limits). Update your detector model or request a quota increase.</p> </li> <li> <p> <code>structure</code> - The detector model must follow a structure that AWS IoT Events supports. </p> </li> <li> <p> <code>expression-syntax</code> - Your expression must follow the required syntax.</p> </li> <li> <p> <code>data-type</code> - Data types referenced in the detector model must be compatible.</p> </li> <li> <p> <code>referenced-data</code> - You must define the data referenced in your detector model before you can use the data.</p> </li> <li> <p> <code>referenced-resource</code> - Resources that the detector model uses must be available.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-analyze-api.html">Running detector model analyses</a> in the <i>AWS IoT Events Developer Guide</i>.</p>', ], ], 'AssetId' => [ 'base' => NULL, 'refs' => [ 'IotSiteWiseAction$assetId' => '<p>The ID of the asset that has the specified property.</p>', ], ], 'AssetModelId' => [ 'base' => NULL, 'refs' => [ 'IotSiteWiseAssetModelPropertyIdentifier$assetModelId' => '<p> The ID of the AWS IoT SiteWise asset model. </p>', ], ], 'AssetPropertyAlias' => [ 'base' => NULL, 'refs' => [ 'IotSiteWiseAction$propertyAlias' => '<p>The alias of the asset property.</p>', ], ], 'AssetPropertyBooleanValue' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyVariant$booleanValue' => '<p>The asset property value is a Boolean value that must be <code>\'TRUE\'</code> or <code>\'FALSE\'</code>. You must use an expression, and the evaluated result should be a Boolean value.</p>', ], ], 'AssetPropertyDoubleValue' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyVariant$doubleValue' => '<p>The asset property value is a double. You must use an expression, and the evaluated result should be a double.</p>', ], ], 'AssetPropertyEntryId' => [ 'base' => NULL, 'refs' => [ 'IotSiteWiseAction$entryId' => '<p>A unique identifier for this entry. You can use the entry ID to track which data entry causes an error in case of failure. The default is a new unique identifier.</p>', ], ], 'AssetPropertyId' => [ 'base' => NULL, 'refs' => [ 'IotSiteWiseAction$propertyId' => '<p>The ID of the asset property.</p>', 'IotSiteWiseAssetModelPropertyIdentifier$propertyId' => '<p> The ID of the AWS IoT SiteWise asset property. </p>', ], ], 'AssetPropertyIntegerValue' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyVariant$integerValue' => '<p>The asset property value is an integer. You must use an expression, and the evaluated result should be an integer.</p>', ], ], 'AssetPropertyOffsetInNanos' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyTimestamp$offsetInNanos' => '<p>The nanosecond offset converted from <code>timeInSeconds</code>. The valid range is between 0-999999999.</p>', ], ], 'AssetPropertyQuality' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyValue$quality' => '<p>The quality of the asset property value. The value must be <code>\'GOOD\'</code>, <code>\'BAD\'</code>, or <code>\'UNCERTAIN\'</code>.</p>', ], ], 'AssetPropertyStringValue' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyVariant$stringValue' => '<p>The asset property value is a string. You must use an expression, and the evaluated result should be a string.</p>', ], ], 'AssetPropertyTimeInSeconds' => [ 'base' => NULL, 'refs' => [ 'AssetPropertyTimestamp$timeInSeconds' => '<p>The timestamp, in seconds, in the Unix epoch format. The valid range is between 1-31556889864403199.</p>', ], ], 'AssetPropertyTimestamp' => [ 'base' => '<p>A structure that contains timestamp information. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_TimeInNanos.html">TimeInNanos</a> in the <i>AWS IoT SiteWise API Reference</i>.</p> <p>You must use expressions for all parameters in <code>AssetPropertyTimestamp</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p> <p class="title"> <b>Examples</b> </p> <ul> <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>timeInSeconds</code> parameter can be <code>\'1586400675\'</code>.</p> </li> <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>offsetInNanos</code> parameter can be <code>$variable.time</code>.</p> </li> <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>timeInSeconds</code> parameter uses a substitution template.</p> <p> <code>\'${$input.TemperatureInput.sensorData.timestamp / 1000}\'</code> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>', 'refs' => [ 'AssetPropertyValue$timestamp' => '<p>The timestamp associated with the asset property value. The default is the current event time.</p>', ], ], 'AssetPropertyValue' => [ 'base' => '<p>A structure that contains value information. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetPropertyValue.html">AssetPropertyValue</a> in the <i>AWS IoT SiteWise API Reference</i>.</p> <p>You must use expressions for all parameters in <code>AssetPropertyValue</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p> <p class="title"> <b>Examples</b> </p> <ul> <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>quality</code> parameter can be <code>\'GOOD\'</code>.</p> </li> <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>quality</code> parameter can be <code>$input.TemperatureInput.sensorData.quality</code>.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>', 'refs' => [ 'IotSiteWiseAction$propertyValue' => '<p>The value to send to the asset property. This value contains timestamp, quality, and value (TQV) information. </p>', ], ], 'AssetPropertyVariant' => [ 'base' => '<p>A structure that contains an asset property value. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_Variant.html">Variant</a> in the <i>AWS IoT SiteWise API Reference</i>.</p> <p>You must use expressions for all parameters in <code>AssetPropertyVariant</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p> <p class="title"> <b>Examples</b> </p> <ul> <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>integerValue</code> parameter can be <code>\'100\'</code>.</p> </li> <li> <p>For references, you must specify either variables or parameters. For example, the value for the <code>booleanValue</code> parameter can be <code>$variable.offline</code>.</p> </li> <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates. </p> <p>In the following example, the value for the <code>doubleValue</code> parameter uses a substitution template. </p> <p> <code>\'${$input.TemperatureInput.sensorData.temperature * 6 / 5 + 32}\'</code> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p> <p>You must specify one of the following value types, depending on the <code>dataType</code> of the specified asset property. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_AssetProperty.html">AssetProperty</a> in the <i>AWS IoT SiteWise API Reference</i>.</p>', 'refs' => [ 'AssetPropertyValue$value' => '<p>The value to send to an asset property.</p>', ], ], 'Attribute' => [ 'base' => '<p>The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code>. Each such message contains a JSON payload. Those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors. </p>', 'refs' => [ 'Attributes$member' => NULL, ], ], 'AttributeJsonPath' => [ 'base' => NULL, 'refs' => [ 'Attribute$jsonPath' => '<p>An expression that specifies an attribute-value pair in a JSON structure. Use this to specify an attribute from the JSON payload that is made available by the input. Inputs are derived from messages sent to AWS IoT Events (<code>BatchPutMessage</code>). Each such message contains a JSON payload. The attribute (and its paired value) specified here are available for use in the <code>condition</code> expressions used by detectors. </p> <p>Syntax: <code>&lt;field-name&gt;.&lt;field-name&gt;...</code> </p>', 'CreateAlarmModelRequest$key' => '<p>An input attribute used as a key to create an alarm. AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this key to the alarm.</p>', 'CreateDetectorModelRequest$key' => '<p>The input attribute key used to identify a device or system to create a detector (an instance of the detector model) and then to route each input received to the appropriate detector (instance). This parameter uses a JSON-path expression in the message payload of each input to specify the attribute-value pair that is used to identify the device associated with the input.</p>', 'DescribeAlarmModelResponse$key' => '<p>An input attribute used as a key to create an alarm. AWS IoT Events routes <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Input.html">inputs</a> associated with this key to the alarm.</p>', 'DetectorModelConfiguration$key' => '<p>The value used to identify a detector instance. When a device or system sends input, a new detector instance with a unique key value is created. AWS IoT Events can continue to route input to its corresponding detector instance based on this identifying information. </p> <p>This parameter uses a JSON-path expression to select the attribute-value pair in the message payload that is used for identification. To route the message to the correct detector instance, the device must send a message payload that contains the same attribute-value.</p>', ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'InputDefinition$attributes' => '<p>The attributes from the JSON payload that are made available by the input. Inputs are derived from messages sent to the AWS IoT Events system using <code>BatchPutMessage</code>. Each such message contains a JSON payload, and those attributes (and their paired values) specified here are available for use in the <code>condition</code> expressions used by detectors that monitor this input. </p>', ], ], 'ClearTimerAction' => [ 'base' => '<p>Information needed to clear the timer.</p>', 'refs' => [ 'Action$clearTimer' => '<p>Information needed to clear the timer.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'SimpleRule$comparisonOperator' => '<p>The comparison operator.</p>', ], ], 'Condition' => [ 'base' => NULL, 'refs' => [ 'Event$condition' => '<p>Optional. The Boolean expression that, when TRUE, causes the <code>actions</code> to be performed. If not present, the actions are performed (=TRUE). If the expression result is not a Boolean value, the actions are not performed (=FALSE).</p>', 'TransitionEvent$condition' => '<p>Required. A Boolean expression that when TRUE causes the actions to be performed and the <code>nextState</code> to be entered.</p>', ], ], 'ContentExpression' => [ 'base' => NULL, 'refs' => [ 'Payload$contentExpression' => '<p>The content of the payload. You can use a string expression that includes quoted strings (<code>\'&lt;string&gt;\'</code>), variables (<code>$variable.&lt;variable-name&gt;</code>), input values (<code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>), string concatenations, and quoted strings that contain <code>${}</code> as the content. The recommended maximum size of a content expression is 1 KB.</p>', ], ], 'CreateAlarmModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAlarmModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDetectorModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDetectorModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInputRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInputResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAlarmModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAlarmModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDetectorModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDetectorModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInputRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInputResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeliveryStreamName' => [ 'base' => NULL, 'refs' => [ 'FirehoseAction$deliveryStreamName' => '<p>The name of the Kinesis Data Firehose delivery stream where the data is written.</p>', ], ], 'DescribeAlarmModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlarmModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDetectorModelAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDetectorModelAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDetectorModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDetectorModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInputRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInputResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLoggingOptionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectorDebugOption' => [ 'base' => '<p>The detector model and the specific detectors (instances) for which the logging level is given.</p>', 'refs' => [ 'DetectorDebugOptions$member' => NULL, ], ], 'DetectorDebugOptions' => [ 'base' => NULL, 'refs' => [ 'LoggingOptions$detectorDebugOptions' => '<p>Information that identifies those detector models and their detectors (instances) for which the logging level is given.</p>', ], ], 'DetectorModel' => [ 'base' => '<p>Information about the detector model.</p>', 'refs' => [ 'DescribeDetectorModelResponse$detectorModel' => '<p>Information about the detector model.</p>', ], ], 'DetectorModelArn' => [ 'base' => NULL, 'refs' => [ 'DetectorModelConfiguration$detectorModelArn' => '<p>The ARN of the detector model.</p>', 'DetectorModelVersionSummary$detectorModelArn' => '<p>The ARN of the detector model version.</p>', ], ], 'DetectorModelConfiguration' => [ 'base' => '<p>Information about how the detector model is configured.</p>', 'refs' => [ 'CreateDetectorModelResponse$detectorModelConfiguration' => '<p>Information about how the detector model is configured.</p>', 'DetectorModel$detectorModelConfiguration' => '<p>Information about how the detector is configured.</p>', 'UpdateDetectorModelResponse$detectorModelConfiguration' => '<p>Information about how the detector model is configured.</p>', ], ], 'DetectorModelDefinition' => [ 'base' => '<p>Information that defines how a detector operates.</p>', 'refs' => [ 'CreateDetectorModelRequest$detectorModelDefinition' => '<p>Information that defines how the detectors operate.</p>', 'DetectorModel$detectorModelDefinition' => '<p>Information that defines how a detector operates.</p>', 'StartDetectorModelAnalysisRequest$detectorModelDefinition' => NULL, 'UpdateDetectorModelRequest$detectorModelDefinition' => '<p>Information that defines how a detector operates.</p>', ], ], 'DetectorModelDescription' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorModelRequest$detectorModelDescription' => '<p>A brief description of the detector model.</p>', 'DetectorModelConfiguration$detectorModelDescription' => '<p>A brief description of the detector model.</p>', 'DetectorModelSummary$detectorModelDescription' => '<p>A brief description of the detector model.</p>', 'UpdateDetectorModelRequest$detectorModelDescription' => '<p>A brief description of the detector model.</p>', ], ], 'DetectorModelName' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorModelRequest$detectorModelName' => '<p>The name of the detector model.</p>', 'DeleteDetectorModelRequest$detectorModelName' => '<p>The name of the detector model to be deleted.</p>', 'DescribeDetectorModelRequest$detectorModelName' => '<p>The name of the detector model.</p>', 'DetectorDebugOption$detectorModelName' => '<p>The name of the detector model.</p>', 'DetectorModelConfiguration$detectorModelName' => '<p>The name of the detector model.</p>', 'DetectorModelSummary$detectorModelName' => '<p>The name of the detector model.</p>', 'DetectorModelVersionSummary$detectorModelName' => '<p>The name of the detector model.</p>', 'ListDetectorModelVersionsRequest$detectorModelName' => '<p>The name of the detector model whose versions are returned.</p>', 'UpdateDetectorModelRequest$detectorModelName' => '<p>The name of the detector model that is updated.</p>', ], ], 'DetectorModelSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDetectorModelsResponse$detectorModelSummaries' => '<p>Summary information about the detector models.</p>', ], ], 'DetectorModelSummary' => [ 'base' => '<p>Information about the detector model.</p>', 'refs' => [ 'DetectorModelSummaries$member' => NULL, ], ], 'DetectorModelVersion' => [ 'base' => NULL, 'refs' => [ 'DescribeDetectorModelRequest$detectorModelVersion' => '<p>The version of the detector model.</p>', 'DetectorModelConfiguration$detectorModelVersion' => '<p>The version of the detector model.</p>', 'DetectorModelVersionSummary$detectorModelVersion' => '<p>The ID of the detector model version.</p>', ], ], 'DetectorModelVersionStatus' => [ 'base' => NULL, 'refs' => [ 'DetectorModelConfiguration$status' => '<p>The status of the detector model.</p>', 'DetectorModelVersionSummary$status' => '<p>The status of the detector model version.</p>', ], ], 'DetectorModelVersionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListDetectorModelVersionsResponse$detectorModelVersionSummaries' => '<p>Summary information about the detector model versions.</p>', ], ], 'DetectorModelVersionSummary' => [ 'base' => '<p>Information about the detector model version.</p>', 'refs' => [ 'DetectorModelVersionSummaries$member' => NULL, ], ], 'DisabledOnInitialization' => [ 'base' => NULL, 'refs' => [ 'InitializationConfiguration$disabledOnInitialization' => '<p>The value must be <code>TRUE</code> or <code>FALSE</code>. If <code>FALSE</code>, all alarm instances created based on the alarm model are activated. The default value is <code>TRUE</code>.</p>', ], ], 'DynamoDBAction' => [ 'base' => '<p>Defines an action to write to the Amazon DynamoDB table that you created. The standard action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify.</p> <p>You must use expressions for all parameters in <code>DynamoDBAction</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p> <p class="title"> <b>Examples</b> </p> <ul> <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>hashKeyType</code> parameter can be <code>\'STRING\'</code>.</p> </li> <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>hashKeyField</code> parameter can be <code>$input.GreenhouseInput.name</code>.</p> </li> <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>hashKeyValue</code> parameter uses a substitution template. </p> <p> <code>\'${$input.GreenhouseInput.temperature * 6 / 5 + 32} in Fahrenheit\'</code> </p> </li> <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>\'GreenhouseTemperatureTable \' + $input.GreenhouseInput.date</code> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p> <p>If the defined payload type is a string, <code>DynamoDBAction</code> writes non-JSON data to the DynamoDB table as binary data. The DynamoDB console displays the data as Base64-encoded text. The value for the <code>payloadField</code> parameter is <code>&lt;payload-field&gt;_raw</code>.</p>', 'refs' => [ 'Action$dynamoDB' => '<p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. One column of the DynamoDB table receives all attribute-value pairs in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>', 'AlarmAction$dynamoDB' => NULL, ], ], 'DynamoDBv2Action' => [ 'base' => '<p>Defines an action to write to the Amazon DynamoDB table that you created. The default action payload contains all the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify.</p> <p>You must use expressions for all parameters in <code>DynamoDBv2Action</code>. The expressions accept literals, operators, functions, references, and substitution templates.</p> <p class="title"> <b>Examples</b> </p> <ul> <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>tableName</code> parameter can be <code>\'GreenhouseTemperatureTable\'</code>.</p> </li> <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>tableName</code> parameter can be <code>$variable.ddbtableName</code>.</p> </li> <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>contentExpression</code> parameter in <code>Payload</code> uses a substitution template. </p> <p> <code>\'{\\"sensorID\\": \\"${$input.GreenhouseInput.sensor_id}\\", \\"temperature\\": \\"${$input.GreenhouseInput.temperature * 9 / 5 + 32}\\"}\'</code> </p> </li> <li> <p>For a string concatenation, you must use <code>+</code>. A string concatenation can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>tableName</code> parameter uses a string concatenation. </p> <p> <code>\'GreenhouseTemperatureTable \' + $input.GreenhouseInput.date</code> </p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p> <p>The value for the <code>type</code> parameter in <code>Payload</code> must be <code>JSON</code>.</p>', 'refs' => [ 'Action$dynamoDBv2' => '<p>Writes to the DynamoDB table that you created. The default action payload contains all attribute-value pairs that have the information about the detector model instance and the event that triggered the action. You can customize the <a href="https://docs.aws.amazon.com/iotevents/latest/apireference/API_Payload.html">payload</a>. A separate column of the DynamoDB table receives one attribute-value pair in the payload that you specify. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-event-actions.html">Actions</a> in <i>AWS IoT Events Developer Guide</i>.</p>', 'AlarmAction$dynamoDBv2' => NULL, ], ], 'DynamoKeyField' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$hashKeyField' => '<p>The name of the hash key (also called the partition key). The <code>hashKeyField</code> value must match the partition key of the target DynamoDB table.</p>', 'DynamoDBAction$rangeKeyField' => '<p>The name of the range key (also called the sort key). The <code>rangeKeyField</code> value must match the sort key of the target DynamoDB table. </p>', 'DynamoDBAction$payloadField' => '<p>The name of the DynamoDB column that receives the action payload.</p> <p>If you don\'t specify this parameter, the name of the DynamoDB column is <code>payload</code>.</p>', ], ], 'DynamoKeyType' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$hashKeyType' => '<p>The data type for the hash key (also called the partition key). You can specify the following values:</p> <ul> <li> <p> <code>\'STRING\'</code> - The hash key is a string.</p> </li> <li> <p> <code>\'NUMBER\'</code> - The hash key is a number.</p> </li> </ul> <p>If you don\'t specify <code>hashKeyType</code>, the default value is <code>\'STRING\'</code>.</p>', 'DynamoDBAction$rangeKeyType' => '<p>The data type for the range key (also called the sort key), You can specify the following values:</p> <ul> <li> <p> <code>\'STRING\'</code> - The range key is a string.</p> </li> <li> <p> <code>\'NUMBER\'</code> - The range key is number.</p> </li> </ul> <p>If you don\'t specify <code>rangeKeyField</code>, the default value is <code>\'STRING\'</code>.</p>', ], ], 'DynamoKeyValue' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$hashKeyValue' => '<p>The value of the hash key (also called the partition key).</p>', 'DynamoDBAction$rangeKeyValue' => '<p>The value of the range key (also called the sort key).</p>', ], ], 'DynamoOperation' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$operation' => '<p>The type of operation to perform. You can specify the following values: </p> <ul> <li> <p> <code>\'INSERT\'</code> - Insert data as a new item into the DynamoDB table. This item uses the specified hash key as a partition key. If you specified a range key, the item uses the range key as a sort key.</p> </li> <li> <p> <code>\'UPDATE\'</code> - Update an existing item of the DynamoDB table with new data. This item\'s partition key must match the specified hash key. If you specified a range key, the range key must match the item\'s sort key.</p> </li> <li> <p> <code>\'DELETE\'</code> - Delete an existing item of the DynamoDB table. This item\'s partition key must match the specified hash key. If you specified a range key, the range key must match the item\'s sort key.</p> </li> </ul> <p>If you don\'t specify this parameter, AWS IoT Events triggers the <code>\'INSERT\'</code> operation.</p>', ], ], 'DynamoTableName' => [ 'base' => NULL, 'refs' => [ 'DynamoDBAction$tableName' => '<p>The name of the DynamoDB table. The <code>tableName</code> value must match the table name of the target DynamoDB table. </p>', 'DynamoDBv2Action$tableName' => '<p>The name of the DynamoDB table.</p>', ], ], 'EmailConfiguration' => [ 'base' => '<p>Contains the configuration information of email notifications.</p>', 'refs' => [ 'EmailConfigurations$member' => NULL, ], ], 'EmailConfigurations' => [ 'base' => NULL, 'refs' => [ 'NotificationAction$emailConfigurations' => '<p>Contains the configuration information of email notifications.</p>', ], ], 'EmailContent' => [ 'base' => '<p>Contains the subject and message of an email.</p>', 'refs' => [ 'EmailConfiguration$content' => '<p>Contains the subject and message of an email.</p>', ], ], 'EmailRecipients' => [ 'base' => '<p>Contains the information of one or more recipients who receive the emails.</p> <important> <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive emails to your AWS SSO store</a>.</p> </important>', 'refs' => [ 'EmailConfiguration$recipients' => '<p>Contains the information of one or more recipients who receive the emails.</p> <important> <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive emails to your AWS SSO store</a>.</p> </important>', ], ], 'EmailSubject' => [ 'base' => NULL, 'refs' => [ 'EmailContent$subject' => '<p>The subject of the email.</p>', ], ], 'EvaluationMethod' => [ 'base' => NULL, 'refs' => [ 'CreateDetectorModelRequest$evaluationMethod' => '<p>Information about the order in which events are evaluated and how actions are executed. </p>', 'DetectorModelConfiguration$evaluationMethod' => '<p>Information about the order in which events are evaluated and how actions are executed. </p>', 'DetectorModelVersionSummary$evaluationMethod' => '<p>Information about the order in which events are evaluated and how actions are executed. </p>', 'UpdateDetectorModelRequest$evaluationMethod' => '<p>Information about the order in which events are evaluated and how actions are executed. </p>', ], ], 'Event' => [ 'base' => '<p>Specifies the <code>actions</code> to be performed when the <code>condition</code> evaluates to TRUE.</p>', 'refs' => [ 'Events$member' => NULL, ], ], 'EventName' => [ 'base' => NULL, 'refs' => [ 'Event$eventName' => '<p>The name of the event.</p>', 'TransitionEvent$eventName' => '<p>The name of the transition event.</p>', ], ], 'Events' => [ 'base' => NULL, 'refs' => [ 'OnEnterLifecycle$events' => '<p>Specifies the actions that are performed when the state is entered and the <code>condition</code> is <code>TRUE</code>.</p>', 'OnExitLifecycle$events' => '<p>Specifies the <code>actions</code> that are performed when the state is exited and the <code>condition</code> is <code>TRUE</code>.</p>', 'OnInputLifecycle$events' => '<p>Specifies the actions performed when the <code>condition</code> evaluates to TRUE.</p>', ], ], 'FirehoseAction' => [ 'base' => '<p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>', 'refs' => [ 'Action$firehose' => '<p>Sends information about the detector model instance and the event that triggered the action to an Amazon Kinesis Data Firehose delivery stream.</p>', 'AlarmAction$firehose' => NULL, ], ], 'FirehoseSeparator' => [ 'base' => NULL, 'refs' => [ 'FirehoseAction$separator' => '<p>A character separator that is used to separate records written to the Kinesis Data Firehose delivery stream. Valid values are: \'\\n\' (newline), \'\\t\' (tab), \'\\r\\n\' (Windows newline), \',\' (comma).</p>', ], ], 'FromEmail' => [ 'base' => NULL, 'refs' => [ 'EmailConfiguration$from' => '<p>The email address that sends emails.</p> <important> <p>If you use the AWS IoT Events managed AWS Lambda function to manage your emails, you must <a href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.html">verify the email address that sends emails in Amazon SES</a>.</p> </important>', ], ], 'GetDetectorModelAnalysisResultsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDetectorModelAnalysisResultsResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdentityStoreId' => [ 'base' => NULL, 'refs' => [ 'SSOIdentity$identityStoreId' => '<p>The ID of the AWS SSO identity store.</p>', ], ], 'InitializationConfiguration' => [ 'base' => '<p>Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.</p>', 'refs' => [ 'AlarmCapabilities$initializationConfiguration' => '<p>Specifies the default alarm state. The configuration applies to all alarms that were created based on this alarm model.</p>', ], ], 'Input' => [ 'base' => '<p>Information about the input.</p>', 'refs' => [ 'DescribeInputResponse$input' => '<p>Information about the input.</p>', ], ], 'InputArn' => [ 'base' => NULL, 'refs' => [ 'InputConfiguration$inputArn' => '<p>The ARN of the input.</p>', 'InputSummary$inputArn' => '<p>The ARN of the input.</p>', ], ], 'InputConfiguration' => [ 'base' => '<p>Information about the configuration of an input.</p>', 'refs' => [ 'CreateInputResponse$inputConfiguration' => '<p>Information about the configuration of the input.</p>', 'Input$inputConfiguration' => '<p>Information about the configuration of an input.</p>', 'UpdateInputResponse$inputConfiguration' => '<p>Information about the configuration of the input.</p>', ], ], 'InputDefinition' => [ 'base' => '<p>The definition of the input.</p>', 'refs' => [ 'CreateInputRequest$inputDefinition' => '<p>The definition of the input.</p>', 'Input$inputDefinition' => '<p>The definition of the input.</p>', 'UpdateInputRequest$inputDefinition' => '<p>The definition of the input.</p>', ], ], 'InputDescription' => [ 'base' => NULL, 'refs' => [ 'CreateInputRequest$inputDescription' => '<p>A brief description of the input.</p>', 'InputConfiguration$inputDescription' => '<p>A brief description of the input.</p>', 'InputSummary$inputDescription' => '<p>A brief description of the input.</p>', 'UpdateInputRequest$inputDescription' => '<p>A brief description of the input.</p>', ], ], 'InputIdentifier' => [ 'base' => '<p> The identifer of the input. </p>', 'refs' => [ 'ListInputRoutingsRequest$inputIdentifier' => '<p> The identifer of the routed input. </p>', ], ], 'InputName' => [ 'base' => NULL, 'refs' => [ 'CreateInputRequest$inputName' => '<p>The name you want to give to the input.</p>', 'DeleteInputRequest$inputName' => '<p>The name of the input to delete.</p>', 'DescribeInputRequest$inputName' => '<p>The name of the input.</p>', 'InputConfiguration$inputName' => '<p>The name of the input.</p>', 'InputSummary$inputName' => '<p>The name of the input.</p>', 'IotEventsAction$inputName' => '<p>The name of the AWS IoT Events input where the data is sent.</p>', 'IotEventsInputIdentifier$inputName' => '<p> The name of the input routed to AWS IoT Events. </p>', 'UpdateInputRequest$inputName' => '<p>The name of the input you want to update.</p>', ], ], 'InputProperty' => [ 'base' => NULL, 'refs' => [ 'SimpleRule$inputProperty' => '<p>The value on the left side of the comparison operator. You can specify an AWS IoT Events input attribute as an input property.</p>', ], ], 'InputStatus' => [ 'base' => NULL, 'refs' => [ 'InputConfiguration$status' => '<p>The status of the input.</p>', 'InputSummary$status' => '<p>The status of the input.</p>', ], ], 'InputSummaries' => [ 'base' => NULL, 'refs' => [ 'ListInputsResponse$inputSummaries' => '<p>Summary information about the inputs.</p>', ], ], 'InputSummary' => [ 'base' => '<p>Information about the input.</p>', 'refs' => [ 'InputSummaries$member' => NULL, ], ], 'InternalFailureException' => [ 'base' => '<p>An internal failure occurred.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request was invalid.</p>', 'refs' => [], ], 'IotEventsAction' => [ 'base' => '<p>Sends an AWS IoT Events input, passing in information about the detector model instance and the event that triggered the action.</p>', 'refs' => [ 'Action$iotEvents' => '<p>Sends AWS IoT Events input, which passes information about the detector model instance and the event that triggered the action.</p>', 'AlarmAction$iotEvents' => NULL, ], ], 'IotEventsInputIdentifier' => [ 'base' => '<p> The identifier of the input routed to AWS IoT Events. </p>', 'refs' => [ 'InputIdentifier$iotEventsInputIdentifier' => '<p> The identifier of the input routed to AWS IoT Events. </p>', ], ], 'IotSiteWiseAction' => [ 'base' => '<p>Sends information about the detector model instance and the event that triggered the action to a specified asset property in AWS IoT SiteWise.</p> <p>You must use expressions for all parameters in <code>IotSiteWiseAction</code>. The expressions accept literals, operators, functions, references, and substitutions templates.</p> <p class="title"> <b>Examples</b> </p> <ul> <li> <p>For literal values, the expressions must contain single quotes. For example, the value for the <code>propertyAlias</code> parameter can be <code>\'/company/windfarm/3/turbine/7/temperature\'</code>.</p> </li> <li> <p>For references, you must specify either variables or input values. For example, the value for the <code>assetId</code> parameter can be <code>$input.TurbineInput.assetId1</code>.</p> </li> <li> <p>For a substitution template, you must use <code>${}</code>, and the template must be in single quotes. A substitution template can also contain a combination of literals, operators, functions, references, and substitution templates.</p> <p>In the following example, the value for the <code>propertyAlias</code> parameter uses a substitution template. </p> <p> <code>\'company/windfarm/${$input.TemperatureInput.sensorData.windfarmID}/turbine/ ${$input.TemperatureInput.sensorData.turbineID}/temperature\'</code> </p> </li> </ul> <p>You must specify either <code>propertyAlias</code> or both <code>assetId</code> and <code>propertyId</code> to identify the target asset property in AWS IoT SiteWise.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html">Expressions</a> in the <i>AWS IoT Events Developer Guide</i>.</p>', 'refs' => [ 'Action$iotSiteWise' => '<p>Sends information about the detector model instance and the event that triggered the action to an asset property in AWS IoT SiteWise .</p>', 'AlarmAction$iotSiteWise' => NULL, ], ], 'IotSiteWiseAssetModelPropertyIdentifier' => [ 'base' => '<p> The asset model property identifer of the input routed from AWS IoT SiteWise. </p>', 'refs' => [ 'IotSiteWiseInputIdentifier$iotSiteWiseAssetModelPropertyIdentifier' => '<p> The identifier of the AWS IoT SiteWise asset model property. </p>', ], ], 'IotSiteWiseInputIdentifier' => [ 'base' => '<p> The identifer of the input routed from AWS IoT SiteWise. </p>', 'refs' => [ 'InputIdentifier$iotSiteWiseInputIdentifier' => '<p> The identifer of the input routed from AWS IoT SiteWise. </p>', ], ], 'IotTopicPublishAction' => [ 'base' => '<p>Information required to publish the MQTT message through the AWS IoT message broker.</p>', 'refs' => [ 'Action$iotTopicPublish' => '<p>Publishes an MQTT message with the given topic to the AWS IoT message broker.</p>', 'AlarmAction$iotTopicPublish' => NULL, ], ], 'KeyValue' => [ 'base' => NULL, 'refs' => [ 'DetectorDebugOption$keyValue' => '<p>The value of the input attribute key used to create the detector (the instance of the detector model).</p>', ], ], 'LambdaAction' => [ 'base' => '<p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>', 'refs' => [ 'Action$lambda' => '<p>Calls a Lambda function, passing in information about the detector model instance and the event that triggered the action.</p>', 'AlarmAction$lambda' => NULL, 'NotificationTargetActions$lambdaAction' => NULL, ], ], 'LimitExceededException' => [ 'base' => '<p>A limit was exceeded.</p>', 'refs' => [], ], 'ListAlarmModelVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAlarmModelVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAlarmModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAlarmModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDetectorModelVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDetectorModelVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDetectorModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDetectorModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInputRoutingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInputRoutingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInputsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInputsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LoggingEnabled' => [ 'base' => NULL, 'refs' => [ 'LoggingOptions$enabled' => '<p>If TRUE, logging is enabled for AWS IoT Events.</p>', ], ], 'LoggingLevel' => [ 'base' => NULL, 'refs' => [ 'LoggingOptions$level' => '<p>The logging level.</p>', ], ], 'LoggingOptions' => [ 'base' => '<p>The values of the AWS IoT Events logging options.</p>', 'refs' => [ 'DescribeLoggingOptionsResponse$loggingOptions' => '<p>The current settings of the AWS IoT Events logging options.</p>', 'PutLoggingOptionsRequest$loggingOptions' => '<p>The new values of the AWS IoT Events logging options.</p>', ], ], 'MQTTTopic' => [ 'base' => NULL, 'refs' => [ 'IotTopicPublishAction$mqttTopic' => '<p>The MQTT topic of the message. You can use a string expression that includes variables (<code>$variable.&lt;variable-name&gt;</code>) and input values (<code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>) as the topic string.</p>', ], ], 'MaxAnalysisResults' => [ 'base' => NULL, 'refs' => [ 'GetDetectorModelAnalysisResultsRequest$maxResults' => '<p>The maximum number of results to be returned per request.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAlarmModelVersionsRequest$maxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListAlarmModelsRequest$maxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDetectorModelVersionsRequest$maxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListDetectorModelsRequest$maxResults' => '<p>The maximum number of results to be returned per request.</p>', 'ListInputRoutingsRequest$maxResults' => '<p> The maximum number of results to be returned per request. </p>', 'ListInputsRequest$maxResults' => '<p>The maximum number of results to be returned per request.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetDetectorModelAnalysisResultsRequest$nextToken' => '<p>The token that you can use to return the next set of results.</p>', 'GetDetectorModelAnalysisResultsResponse$nextToken' => '<p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>', 'ListAlarmModelVersionsRequest$nextToken' => '<p>The token that you can use to return the next set of results.</p>', 'ListAlarmModelVersionsResponse$nextToken' => '<p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>', 'ListAlarmModelsRequest$nextToken' => '<p>The token that you can use to return the next set of results.</p>', 'ListAlarmModelsResponse$nextToken' => '<p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>', 'ListDetectorModelVersionsRequest$nextToken' => '<p>The token that you can use to return the next set of results.</p>', 'ListDetectorModelVersionsResponse$nextToken' => '<p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>', 'ListDetectorModelsRequest$nextToken' => '<p>The token that you can use to return the next set of results.</p>', 'ListDetectorModelsResponse$nextToken' => '<p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>', 'ListInputRoutingsRequest$nextToken' => '<p> The token that you can use to return the next set of results. </p>', 'ListInputRoutingsResponse$nextToken' => '<p> The token that you can use to return the next set of results, or <code>null</code> if there are no more results. </p>', 'ListInputsRequest$nextToken' => '<p>The token that you can use to return the next set of results.</p>', 'ListInputsResponse$nextToken' => '<p>The token that you can use to return the next set of results, or <code>null</code> if there are no more results.</p>', ], ], 'NotificationAction' => [ 'base' => '<p>Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on this alarm model.</p>', 'refs' => [ 'NotificationActions$member' => NULL, ], ], 'NotificationActions' => [ 'base' => NULL, 'refs' => [ 'AlarmNotification$notificationActions' => '<p>Contains the notification settings of an alarm model. The settings apply to all alarms that were created based on this alarm model.</p>', ], ], 'NotificationAdditionalMessage' => [ 'base' => NULL, 'refs' => [ 'EmailContent$additionalMessage' => '<p>The message that you want to send. The message can be up to 200 characters.</p>', 'SMSConfiguration$additionalMessage' => '<p>The message that you want to send. The message can be up to 200 characters.</p>', ], ], 'NotificationTargetActions' => [ 'base' => '<p>Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function provided by AWS IoT Events</a>.</p>', 'refs' => [ 'NotificationAction$action' => '<p>Specifies an AWS Lambda function to manage alarm notifications. You can create one or use the <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/lambda-support.html">AWS Lambda function provided by AWS IoT Events</a>.</p>', ], ], 'OnEnterLifecycle' => [ 'base' => '<p>When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.</p>', 'refs' => [ 'State$onEnter' => '<p>When entering this state, perform these <code>actions</code> if the <code>condition</code> is TRUE.</p>', ], ], 'OnExitLifecycle' => [ 'base' => '<p>When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code>.</p>', 'refs' => [ 'State$onExit' => '<p>When exiting this state, perform these <code>actions</code> if the specified <code>condition</code> is <code>TRUE</code>.</p>', ], ], 'OnInputLifecycle' => [ 'base' => '<p>Specifies the actions performed when the <code>condition</code> evaluates to TRUE.</p>', 'refs' => [ 'State$onInput' => '<p>When an input is received and the <code>condition</code> is TRUE, perform the specified <code>actions</code>.</p>', ], ], 'Payload' => [ 'base' => '<p>Information needed to configure the payload.</p> <p>By default, AWS IoT Events generates a standard payload in JSON for any action. This action payload contains all attribute-value pairs that have the information about the detector model instance and the event triggered the action. To configure the action payload, you can use <code>contentExpression</code>.</p>', 'refs' => [ 'DynamoDBAction$payload' => NULL, 'DynamoDBv2Action$payload' => NULL, 'FirehoseAction$payload' => '<p>You can configure the action payload when you send a message to an Amazon Kinesis Data Firehose delivery stream.</p>', 'IotEventsAction$payload' => '<p>You can configure the action payload when you send a message to an AWS IoT Events input.</p>', 'IotTopicPublishAction$payload' => '<p>You can configure the action payload when you publish a message to an AWS IoT Core topic.</p>', 'LambdaAction$payload' => '<p>You can configure the action payload when you send a message to a Lambda function.</p>', 'SNSTopicPublishAction$payload' => '<p>You can configure the action payload when you send a message as an Amazon SNS push notification.</p>', 'SqsAction$payload' => '<p>You can configure the action payload when you send a message to an Amazon SQS queue.</p>', ], ], 'PayloadType' => [ 'base' => NULL, 'refs' => [ 'Payload$type' => '<p>The value of the payload type can be either <code>STRING</code> or <code>JSON</code>.</p>', ], ], 'PutLoggingOptionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'QueueUrl' => [ 'base' => NULL, 'refs' => [ 'SqsAction$queueUrl' => '<p>The URL of the SQS queue where the data is written.</p>', ], ], 'RecipientDetail' => [ 'base' => '<p>The information that identifies the recipient.</p>', 'refs' => [ 'RecipientDetails$member' => NULL, ], ], 'RecipientDetails' => [ 'base' => NULL, 'refs' => [ 'EmailRecipients$to' => '<p>Specifies one or more recipients who receive the email.</p>', 'SMSConfiguration$recipients' => '<p>Specifies one or more recipients who receive the message.</p> <important> <p>You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that receive SMS messages to your AWS SSO store</a>.</p> </important>', ], ], 'ResetTimerAction' => [ 'base' => '<p>Information required to reset the timer. The timer is reset to the previously evaluated result of the duration. The duration expression isn\'t reevaluated when you reset the timer.</p>', 'refs' => [ 'Action$resetTimer' => '<p>Information needed to reset the timer.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The resource already exists.</p>', 'refs' => [], ], 'ResourceInUseException' => [ 'base' => '<p>The resource is in use.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'RoutedResource$name' => '<p> The name of the routed resource. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource was not found.</p>', 'refs' => [], ], 'RoutedResource' => [ 'base' => '<p> Contains information about the routed resource. </p>', 'refs' => [ 'RoutedResources$member' => NULL, ], ], 'RoutedResources' => [ 'base' => NULL, 'refs' => [ 'ListInputRoutingsResponse$routedResources' => '<p> Summary information about the routed resources. </p>', ], ], 'SMSConfiguration' => [ 'base' => '<p>Contains the configuration information of SMS notifications.</p>', 'refs' => [ 'SMSConfigurations$member' => NULL, ], ], 'SMSConfigurations' => [ 'base' => NULL, 'refs' => [ 'NotificationAction$smsConfigurations' => '<p>Contains the configuration information of SMS notifications.</p>', ], ], 'SMSSenderId' => [ 'base' => NULL, 'refs' => [ 'SMSConfiguration$senderId' => '<p>The sender ID.</p>', ], ], 'SNSTopicPublishAction' => [ 'base' => '<p>Information required to publish the Amazon SNS message.</p>', 'refs' => [ 'Action$sns' => '<p>Sends an Amazon SNS message.</p>', 'AlarmAction$sns' => NULL, ], ], 'SSOIdentity' => [ 'base' => '<p>Contains information about your identity source in AWS Single Sign-On. For more information, see the <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">AWS Single Sign-On User Guide</a>.</p>', 'refs' => [ 'RecipientDetail$ssoIdentity' => '<p>The AWS Single Sign-On (AWS SSO) authentication information.</p>', ], ], 'SSOReferenceId' => [ 'base' => NULL, 'refs' => [ 'SSOIdentity$userId' => '<p>The user ID.</p>', ], ], 'Seconds' => [ 'base' => NULL, 'refs' => [ 'SetTimerAction$seconds' => '<p>The number of seconds until the timer expires. The minimum value is 60 seconds to ensure accuracy. The maximum value is 31622400 seconds. </p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is currently unavailable.</p>', 'refs' => [], ], 'SetTimerAction' => [ 'base' => '<p>Information needed to set the timer.</p>', 'refs' => [ 'Action$setTimer' => '<p>Information needed to set the timer.</p>', ], ], 'SetVariableAction' => [ 'base' => '<p>Information about the variable and its new value.</p>', 'refs' => [ 'Action$setVariable' => '<p>Sets a variable to a specified value.</p>', ], ], 'Severity' => [ 'base' => NULL, 'refs' => [ 'CreateAlarmModelRequest$severity' => '<p>A non-negative integer that reflects the severity level of the alarm.</p>', 'DescribeAlarmModelResponse$severity' => '<p>A non-negative integer that reflects the severity level of the alarm.</p>', 'UpdateAlarmModelRequest$severity' => '<p>A non-negative integer that reflects the severity level of the alarm.</p>', ], ], 'SimpleRule' => [ 'base' => '<p>A rule that compares an input property value to a threshold value with a comparison operator.</p>', 'refs' => [ 'AlarmRule$simpleRule' => '<p>A rule that compares an input property value to a threshold value with a comparison operator.</p>', ], ], 'SqsAction' => [ 'base' => '<p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>', 'refs' => [ 'Action$sqs' => '<p>Sends information about the detector model instance and the event that triggered the action to an Amazon SQS queue.</p>', 'AlarmAction$sqs' => NULL, ], ], 'StartDetectorModelAnalysisRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDetectorModelAnalysisResponse' => [ 'base' => NULL, 'refs' => [], ], 'State' => [ 'base' => '<p>Information that defines a state of a detector.</p>', 'refs' => [ 'States$member' => NULL, ], ], 'StateName' => [ 'base' => NULL, 'refs' => [ 'DetectorModelDefinition$initialStateName' => '<p>The state that is entered at the creation of each detector (instance).</p>', 'State$stateName' => '<p>The name of the state.</p>', 'TransitionEvent$nextState' => '<p>The next state to enter.</p>', ], ], 'States' => [ 'base' => NULL, 'refs' => [ 'DetectorModelDefinition$states' => '<p>Information about the states of the detector.</p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'AlarmModelVersionSummary$statusMessage' => '<p> Contains information about the status of the alarm model version. </p>', 'DescribeAlarmModelResponse$statusMessage' => '<p> Contains information about the status of the alarm model. </p>', ], ], 'Tag' => [ 'base' => '<p>Metadata that can be used to manage the resource.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The tag\'s key.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of the keys of the tags to be removed from the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The tag\'s value.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateAlarmModelRequest$tags' => '<p>A list of key-value pairs that contain metadata for the alarm model. The tags help you manage the alarm model. For more information, see <a href="https://docs.aws.amazon.com/iotevents/latest/developerguide/tagging-iotevents.html">Tagging your AWS IoT Events resources</a> in the <i>AWS IoT Events Developer Guide</i>.</p> <p>You can create up to 50 tags for one alarm model.</p>', 'CreateDetectorModelRequest$tags' => '<p>Metadata that can be used to manage the detector model.</p>', 'CreateInputRequest$tags' => '<p>Metadata that can be used to manage the input.</p>', 'ListTagsForResourceResponse$tags' => '<p>The list of tags assigned to the resource.</p>', 'TagResourceRequest$tags' => '<p>The new or modified tags for the resource.</p>', ], ], 'Threshold' => [ 'base' => NULL, 'refs' => [ 'SimpleRule$threshold' => '<p>The value on the right side of the comparison operator. You can enter a number or specify an AWS IoT Events input attribute.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request could not be completed due to throttling.</p>', 'refs' => [], ], 'TimerName' => [ 'base' => NULL, 'refs' => [ 'ClearTimerAction$timerName' => '<p>The name of the timer to clear.</p>', 'ResetTimerAction$timerName' => '<p>The name of the timer to reset.</p>', 'SetTimerAction$timerName' => '<p>The name of the timer.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AlarmModelSummary$creationTime' => '<p>The time the alarm model was created, in the Unix epoch format.</p>', 'AlarmModelVersionSummary$creationTime' => '<p>The time the alarm model was created, in the Unix epoch format.</p>', 'AlarmModelVersionSummary$lastUpdateTime' => '<p>The time the alarm model was last updated, in the Unix epoch format.</p>', 'CreateAlarmModelResponse$creationTime' => '<p>The time the alarm model was created, in the Unix epoch format.</p>', 'CreateAlarmModelResponse$lastUpdateTime' => '<p>The time the alarm model was last updated, in the Unix epoch format.</p>', 'DescribeAlarmModelResponse$creationTime' => '<p>The time the alarm model was created, in the Unix epoch format.</p>', 'DescribeAlarmModelResponse$lastUpdateTime' => '<p>The time the alarm model was last updated, in the Unix epoch format.</p>', 'DetectorModelConfiguration$creationTime' => '<p>The time the detector model was created.</p>', 'DetectorModelConfiguration$lastUpdateTime' => '<p>The time the detector model was last updated.</p>', 'DetectorModelSummary$creationTime' => '<p>The time the detector model was created.</p>', 'DetectorModelVersionSummary$creationTime' => '<p>The time the detector model version was created.</p>', 'DetectorModelVersionSummary$lastUpdateTime' => '<p>The last time the detector model version was updated.</p>', 'InputConfiguration$creationTime' => '<p>The time the input was created.</p>', 'InputConfiguration$lastUpdateTime' => '<p>The last time the input was updated.</p>', 'InputSummary$creationTime' => '<p>The time the input was created.</p>', 'InputSummary$lastUpdateTime' => '<p>The last time the input was updated.</p>', 'UpdateAlarmModelResponse$creationTime' => '<p>The time the alarm model was created, in the Unix epoch format.</p>', 'UpdateAlarmModelResponse$lastUpdateTime' => '<p>The time the alarm model was last updated, in the Unix epoch format.</p>', ], ], 'TransitionEvent' => [ 'base' => '<p>Specifies the actions performed and the next state entered when a <code>condition</code> evaluates to TRUE.</p>', 'refs' => [ 'TransitionEvents$member' => NULL, ], ], 'TransitionEvents' => [ 'base' => NULL, 'refs' => [ 'OnInputLifecycle$transitionEvents' => '<p>Specifies the actions performed, and the next state entered, when a <code>condition</code> evaluates to TRUE.</p>', ], ], 'UnsupportedOperationException' => [ 'base' => '<p>The requested operation is not supported.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAlarmModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAlarmModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDetectorModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInputRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInputResponse' => [ 'base' => NULL, 'refs' => [], ], 'UseBase64' => [ 'base' => NULL, 'refs' => [ 'SqsAction$useBase64' => '<p>Set this to TRUE if you want the data to be base-64 encoded before it is written to the queue. Otherwise, set this to FALSE.</p>', ], ], 'VariableName' => [ 'base' => NULL, 'refs' => [ 'SetVariableAction$variableName' => '<p>The name of the variable.</p>', ], ], 'VariableValue' => [ 'base' => NULL, 'refs' => [ 'SetTimerAction$durationExpression' => '<p>The duration of the timer, in seconds. You can use a string expression that includes numbers, variables (<code>$variable.&lt;variable-name&gt;</code>), and input values (<code>$input.&lt;input-name&gt;.&lt;path-to-datum&gt;</code>) as the duration. The range of the duration is 1-31622400 seconds. To ensure accuracy, the minimum duration is 60 seconds. The evaluated result of the duration is rounded down to the nearest whole number. </p>', 'SetVariableAction$value' => '<p>The new value of the variable.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalFailureException$message' => '<p>The message for the exception.</p>', 'InvalidRequestException$message' => '<p>The message for the exception.</p>', 'LimitExceededException$message' => '<p>The message for the exception.</p>', 'ResourceAlreadyExistsException$message' => '<p>The message for the exception.</p>', 'ResourceInUseException$message' => '<p>The message for the exception.</p>', 'ResourceNotFoundException$message' => '<p>The message for the exception.</p>', 'ServiceUnavailableException$message' => '<p>The message for the exception.</p>', 'ThrottlingException$message' => '<p>The message for the exception.</p>', 'UnsupportedOperationException$message' => '<p>The message for the exception.</p>', ], ], 'resourceArn' => [ 'base' => NULL, 'refs' => [ 'ResourceAlreadyExistsException$resourceArn' => '<p>The ARN of the resource.</p>', ], ], 'resourceId' => [ 'base' => NULL, 'refs' => [ 'ResourceAlreadyExistsException$resourceId' => '<p>The ID of the resource.</p>', ], ], ],];
