<?php
// This file was auto-generated from sdk-root/src/data/devops-guru/2020-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> Amazon DevOps Guru is a fully managed service that helps you identify anomalous behavior in business critical operational applications. You specify the Amazon Web Services resources that you want DevOps Guru to cover, then the Amazon CloudWatch metrics and Amazon Web Services CloudTrail events related to those resources are analyzed. When anomalous behavior is detected, DevOps Guru creates an <i>insight</i> that includes recommendations, related events, and related metrics that can help you improve your operational applications. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html">What is Amazon DevOps Guru</a>. </p> <p> You can specify 1 or 2 Amazon Simple Notification Service topics so you are notified every time a new insight is created. You can also enable DevOps Guru to generate an OpsItem in Amazon Web Services Systems Manager for each insight to help you manage and track your work addressing insights. </p> <p> To learn about the DevOps Guru workflow, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/welcome.html#how-it-works">How DevOps Guru works</a>. To learn about DevOps Guru concepts, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/concepts.html">Concepts in DevOps Guru</a>. </p>', 'operations' => [ 'AddNotificationChannel' => '<p> Adds a notification channel to DevOps Guru. A notification channel is used to notify you about important DevOps Guru events, such as when an insight is generated. </p> <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p> <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>', 'DescribeAccountHealth' => '<p> Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account. </p>', 'DescribeAccountOverview' => '<p> For the time range passed in, returns the number of open reactive insight that were created, the number of open proactive insights that were created, and the Mean Time to Recover (MTTR) for all closed reactive insights. </p>', 'DescribeAnomaly' => '<p> Returns details about an anomaly that you specify using its ID. </p>', 'DescribeFeedback' => '<p> Returns the most recent feedback submitted in the current Amazon Web Services account and Region. </p>', 'DescribeInsight' => '<p> Returns details about an insight that you specify using its ID. </p>', 'DescribeOrganizationHealth' => '<p>Returns active insights, predictive insights, and resource hours analyzed in last hour.</p>', 'DescribeOrganizationOverview' => '<p>Returns an overview of your organization\'s history based on the specified time range. The overview includes the total reactive and proactive insights.</p>', 'DescribeOrganizationResourceCollectionHealth' => '<p>Provides an overview of your system\'s health. If additional member accounts are part of your organization, you can filter those accounts using the <code>AccountIds</code> field.</p>', 'DescribeResourceCollectionHealth' => '<p> Returns the number of open proactive insights, open reactive insights, and the Mean Time to Recover (MTTR) for all closed insights in resource collections in your account. You specify the type of Amazon Web Services resources collection. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', 'DescribeServiceIntegration' => '<p> Returns the integration status of services that are integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight. </p>', 'GetCostEstimation' => '<p>Returns an estimate of the monthly cost for DevOps Guru to analyze your Amazon Web Services resources. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>', 'GetResourceCollection' => '<p> Returns lists Amazon Web Services resources that are of the specified resource collection type. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', 'ListAnomaliesForInsight' => '<p> Returns a list of the anomalies that belong to an insight that you specify using its ID. </p>', 'ListEvents' => '<p> Returns a list of the events emitted by the resources that are evaluated by DevOps Guru. You can use filters to specify which events are returned. </p>', 'ListInsights' => '<p> Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time and status (<code>ONGOING</code>, <code>CLOSED</code>, or <code>ANY</code>). </p>', 'ListNotificationChannels' => '<p> Returns a list of notification channels configured for DevOps Guru. Each notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>', 'ListOrganizationInsights' => '<p>Returns a list of insights associated with the account or OU Id.</p>', 'ListRecommendations' => '<p> Returns a list of a specified insight\'s recommendations. Each recommendation includes a list of related metrics and a list of related events. </p>', 'PutFeedback' => '<p> Collects customer feedback about the specified insight. </p>', 'RemoveNotificationChannel' => '<p> Removes a notification channel from DevOps Guru. A notification channel is used to notify you when DevOps Guru generates an insight that contains information about how to improve your operations. </p>', 'SearchInsights' => '<p> Returns a list of insights in your Amazon Web Services account. You can specify which insights are returned by their start time, one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p> <p> Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search. </p>', 'SearchOrganizationInsights' => '<p> Returns a list of insights in your organization. You can specify which insights are returned by their start time, one or more statuses (<code>ONGOING</code>, <code>CLOSED</code>, and <code>CLOSED</code>), one or more severities (<code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>), and type (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p> <p> Use the <code>Filters</code> parameter to specify status and severity search parameters. Use the <code>Type</code> parameter to specify <code>REACTIVE</code> or <code>PROACTIVE</code> in your search. </p>', 'StartCostEstimation' => '<p>Starts the creation of an estimate of the monthly cost to analyze your Amazon Web Services resources.</p>', 'UpdateResourceCollection' => '<p> Updates the collection of resources that DevOps Guru analyzes. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. This method also creates the IAM role required for you to use DevOps Guru. </p>', 'UpdateServiceIntegration' => '<p> Enables or disables integration with a service that can be integrated with DevOps Guru. The one service that can be integrated with DevOps Guru is Amazon Web Services Systems Manager, which can be used to create an OpsItem for each generated insight. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p> You don\'t have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User Guide</i>. </p>', 'refs' => [], ], 'AccountHealth' => [ 'base' => '<p> Returns the number of open reactive insights, the number of open proactive insights, and the number of metrics analyzed in your Amazon Web Services account. Use these numbers to gauge the health of operations in your Amazon Web Services account. </p>', 'refs' => [ 'AccountHealths$member' => NULL, ], ], 'AccountHealths' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResourceCollectionHealthResponse$Account' => '<p>The name of the organization\'s account.</p>', ], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationHealthRequest$AccountIds' => '<p>The ID of the Amazon Web Services account.</p>', 'DescribeOrganizationOverviewRequest$AccountIds' => '<p>The ID of the Amazon Web Services account.</p>', 'DescribeOrganizationResourceCollectionHealthRequest$AccountIds' => '<p>The ID of the Amazon Web Services account.</p>', ], ], 'AccountInsightHealth' => [ 'base' => '<p> Information about the number of open reactive and proactive insights that can be used to gauge the health of your system. </p>', 'refs' => [ 'AccountHealth$Insight' => '<p> Information about the health of the Amazon Web Services resources in your account, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>', ], ], 'AddNotificationChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddNotificationChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'AnomalyDescription' => [ 'base' => NULL, 'refs' => [ 'ReactiveAnomaly$Description' => '<p>A description of the reactive anomaly.</p>', 'ReactiveAnomalySummary$Description' => '<p>A description of the reactive anomaly.</p>', ], ], 'AnomalyId' => [ 'base' => NULL, 'refs' => [ 'DescribeAnomalyRequest$Id' => '<p> The ID of the anomaly. </p>', 'ProactiveAnomaly$Id' => '<p> The ID of a proactive anomaly. </p>', 'ProactiveAnomalySummary$Id' => '<p>The ID of the anomaly.</p>', 'ReactiveAnomaly$Id' => '<p>The ID of the reactive anomaly. </p>', 'ReactiveAnomaly$CausalAnomalyId' => '<p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>', 'ReactiveAnomalySummary$Id' => '<p> The ID of the reactive anomaly. </p>', 'ReactiveAnomalySummary$CausalAnomalyId' => '<p>The ID of the causal anomaly that is associated with this reactive anomaly. The ID of a `CAUSAL` anomaly is always `NULL`.</p>', 'RecommendationRelatedAnomaly$AnomalyId' => '<p>The ID of an anomaly that generated the insight with this recommendation.</p>', ], ], 'AnomalyLimit' => [ 'base' => NULL, 'refs' => [ 'ProactiveAnomaly$Limit' => '<p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>', 'ProactiveAnomalySummary$Limit' => '<p> A threshold that was exceeded by behavior in analyzed resources. Exceeding this threshold is related to the anomalous behavior that generated this anomaly. </p>', ], ], 'AnomalyName' => [ 'base' => NULL, 'refs' => [ 'ReactiveAnomaly$Name' => '<p>The name of the reactive anomaly.</p>', 'ReactiveAnomalySummary$Name' => '<p>The name of the reactive anomaly.</p>', ], ], 'AnomalyReportedTimeRange' => [ 'base' => '<p> A time range that specifies when DevOps Guru opens and then closes an anomaly. This is different from <code>AnomalyTimeRange</code>, which specifies the time range when DevOps Guru actually observes the anomalous behavior. </p>', 'refs' => [ 'ProactiveAnomaly$AnomalyReportedTimeRange' => '<p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>', 'ProactiveAnomalySummary$AnomalyReportedTimeRange' => '<p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>', 'ReactiveAnomaly$AnomalyReportedTimeRange' => '<p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>', 'ReactiveAnomalySummary$AnomalyReportedTimeRange' => '<p> An <code>AnomalyReportedTimeRange</code> object that specifies the time range between when the anomaly is opened and the time when it is closed. </p>', ], ], 'AnomalyResource' => [ 'base' => '<p>The Amazon Web Services resources in which DevOps Guru detected unusual behavior that resulted in the generation of an anomaly. When DevOps Guru detects multiple related anomalies, it creates and insight with details about the anomalous behavior and suggestions about how to correct the problem.</p>', 'refs' => [ 'AnomalyResources$member' => NULL, ], ], 'AnomalyResources' => [ 'base' => NULL, 'refs' => [ 'ReactiveAnomaly$AnomalyResources' => '<p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>', 'ReactiveAnomalySummary$AnomalyResources' => '<p>The Amazon Web Services resources in which anomalous behavior was detected by DevOps Guru.</p>', ], ], 'AnomalySeverity' => [ 'base' => NULL, 'refs' => [ 'ProactiveAnomaly$Severity' => '<p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight\'s severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', 'ProactiveAnomalySummary$Severity' => '<p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight\'s severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', 'ReactiveAnomaly$Severity' => '<p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight\'s severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', 'ReactiveAnomalySummary$Severity' => '<p>The severity of the anomaly. The severity of anomalies that generate an insight determine that insight\'s severity. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', ], ], 'AnomalySourceDetails' => [ 'base' => '<p> Details about the source of the anomalous operational data that triggered the anomaly.</p>', 'refs' => [ 'ProactiveAnomaly$SourceDetails' => '<p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>', 'ProactiveAnomalySummary$SourceDetails' => '<p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>', 'ReactiveAnomaly$SourceDetails' => '<p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>', 'ReactiveAnomalySummary$SourceDetails' => '<p> Details about the source of the analyzed operational data that triggered the anomaly. The one supported source is Amazon CloudWatch metrics. </p>', ], ], 'AnomalyStatus' => [ 'base' => NULL, 'refs' => [ 'ProactiveAnomaly$Status' => '<p> The status of a proactive anomaly. </p>', 'ProactiveAnomalySummary$Status' => '<p>The status of the anomaly.</p>', 'ReactiveAnomaly$Status' => '<p> The status of the anomaly. </p>', 'ReactiveAnomalySummary$Status' => '<p> The status of the reactive anomaly. </p>', ], ], 'AnomalyTimeRange' => [ 'base' => '<p> A time range that specifies when the observed unusual behavior in an anomaly started and ended. This is different from <code>AnomalyReportedTimeRange</code>, which specifies the time range when DevOps Guru opens and then closes an anomaly. </p>', 'refs' => [ 'ProactiveAnomaly$AnomalyTimeRange' => NULL, 'ProactiveAnomalySummary$AnomalyTimeRange' => NULL, 'ReactiveAnomaly$AnomalyTimeRange' => NULL, 'ReactiveAnomalySummary$AnomalyTimeRange' => NULL, ], ], 'AnomalyType' => [ 'base' => NULL, 'refs' => [ 'ReactiveAnomaly$Type' => '<p>The type of the reactive anomaly. It can be one of the following types.</p> <ul> <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li> <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li> </ul>', 'ReactiveAnomalySummary$Type' => '<p>The type of the reactive anomaly. It can be one of the following types.</p> <ul> <li> <p> <code>CAUSAL</code> - the anomaly can cause a new insight.</p> </li> <li> <p> <code>CONTEXTUAL</code> - the anomaly contains additional information about an insight or its causal anomaly.</p> </li> </ul>', ], ], 'AppBoundaryKey' => [ 'base' => NULL, 'refs' => [ 'TagCollection$AppBoundaryKey' => '<p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', 'TagCollectionFilter$AppBoundaryKey' => '<p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', 'TagCostEstimationResourceCollectionFilter$AppBoundaryKey' => '<p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', 'TagHealth$AppBoundaryKey' => '<p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', 'UpdateTagCollectionFilter$AppBoundaryKey' => '<p>An Amazon Web Services tag <i>key</i> that is used to identify the Amazon Web Services resources that DevOps Guru analyzes. All Amazon Web Services resources in your account and Region tagged with this <i>key</i> make up your DevOps Guru application and analysis boundary.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', ], ], 'AssociatedResourceArns' => [ 'base' => NULL, 'refs' => [ 'ProactiveInsightSummary$AssociatedResourceArns' => '<p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>', 'ReactiveInsightSummary$AssociatedResourceArns' => '<p>The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'AccountHealth$AccountId' => '<p>The ID of the Amazon Web Services account. </p>', 'AccountIdList$member' => NULL, 'DescribeAnomalyRequest$AccountId' => '<p>The ID of the member account.</p>', 'DescribeInsightRequest$AccountId' => '<p>The ID of the member account in the organization.</p>', 'ListAnomaliesForInsightRequest$AccountId' => '<p>The ID of the Amazon Web Services account. </p>', 'ListEventsRequest$AccountId' => '<p>The ID of the Amazon Web Services account. </p>', 'ListInsightsAccountIdList$member' => NULL, 'ListRecommendationsRequest$AccountId' => '<p>The ID of the Amazon Web Services account. </p>', 'ProactiveOrganizationInsightSummary$AccountId' => '<p>The ID of the Amazon Web Services account.</p>', 'ReactiveOrganizationInsightSummary$AccountId' => '<p>The ID of the Amazon Web Services account. </p>', 'SearchInsightsAccountIdList$member' => NULL, ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'ListNotificationChannelsResponse$Channels' => '<p> An array that contains the requested notification channels. </p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'StartCostEstimationRequest$ClientToken' => '<p>The idempotency token used to identify each cost estimate request.</p>', ], ], 'CloudFormationCollection' => [ 'base' => '<p> Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>. </p>', 'refs' => [ 'ResourceCollection$CloudFormation' => '<p> An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web Services resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', ], ], 'CloudFormationCollectionFilter' => [ 'base' => '<p> Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>. </p>', 'refs' => [ 'ResourceCollectionFilter$CloudFormation' => '<p> Information about Amazon Web Services CloudFormation stacks. You can use up to 500 stacks to specify which Amazon Web Services resources in your account to analyze. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>. </p>', ], ], 'CloudFormationCostEstimationResourceCollectionFilter' => [ 'base' => '<p>Information about an Amazon Web Services CloudFormation stack used to create a monthly cost estimate for DevOps Guru to analyze Amazon Web Services resources. The maximum number of stacks you can specify for a cost estimate is one. The estimate created is for the cost to analyze the Amazon Web Services resources defined by the stack. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>.</p>', 'refs' => [ 'CostEstimationResourceCollectionFilter$CloudFormation' => '<p>An object that specifies the CloudFormation stack that defines the Amazon Web Services resources used to create a monthly estimate for DevOps Guru.</p>', ], ], 'CloudFormationHealth' => [ 'base' => '<p> Information about the health of Amazon Web Services resources in your account that are specified by an Amazon Web Services CloudFormation stack. </p>', 'refs' => [ 'CloudFormationHealths$member' => NULL, ], ], 'CloudFormationHealths' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResourceCollectionHealthResponse$CloudFormation' => '<p>The returned <code>CloudFormationHealthOverview</code> object that contains an <code>InsightHealthOverview</code> object with the requested system health information.</p>', 'DescribeResourceCollectionHealthResponse$CloudFormation' => '<p> The returned <code>CloudFormationHealthOverview</code> object that contains an <code>InsightHealthOverview</code> object with the requested system health information. </p>', ], ], 'CloudWatchMetricDataStatusCode' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDataSummary$StatusCode' => '<p>This is an enum of the status showing whether the metric value pair list has partial or complete data, or if there was an error.</p>', ], ], 'CloudWatchMetricsDataSummary' => [ 'base' => '<p>Contains information about the analyzed metrics that displayed anomalous behavior. </p>', 'refs' => [ 'CloudWatchMetricsDetail$MetricDataSummary' => '<p>This object returns anomaly metric data.</p>', ], ], 'CloudWatchMetricsDetail' => [ 'base' => '<p> Information about an Amazon CloudWatch metric. </p>', 'refs' => [ 'CloudWatchMetricsDetails$member' => NULL, ], ], 'CloudWatchMetricsDetails' => [ 'base' => NULL, 'refs' => [ 'AnomalySourceDetails$CloudWatchMetrics' => '<p>An array of <code>CloudWatchMetricsDetail</code> objects that contain information about analyzed CloudWatch metrics that show anomalous behavior. </p>', ], ], 'CloudWatchMetricsDimension' => [ 'base' => '<p> The dimension of am Amazon CloudWatch metric that is used when DevOps Guru analyzes the resources in your account for operational problems and anomalous behavior. A dimension is a name/value pair that is part of the identity of a metric. A metric can have up to 10 dimensions. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Dimension">Dimensions</a> in the <i>Amazon CloudWatch User Guide</i>. </p>', 'refs' => [ 'CloudWatchMetricsDimensions$member' => NULL, ], ], 'CloudWatchMetricsDimensionName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDimension$Name' => '<p> The name of the CloudWatch dimension. </p>', ], ], 'CloudWatchMetricsDimensionValue' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDimension$Value' => '<p> The value of the CloudWatch dimension. </p>', ], ], 'CloudWatchMetricsDimensions' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Dimensions' => '<p> An array of CloudWatch dimensions associated with </p>', ], ], 'CloudWatchMetricsMetricName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$MetricName' => '<p> The name of the CloudWatch metric. </p>', ], ], 'CloudWatchMetricsNamespace' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Namespace' => '<p> The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics. </p>', ], ], 'CloudWatchMetricsPeriod' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Period' => '<p> The length of time associated with the CloudWatch metric in number of seconds. </p>', ], ], 'CloudWatchMetricsStat' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Stat' => '<p> The type of statistic associated with the CloudWatch metric. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic">Statistics</a> in the <i>Amazon CloudWatch User Guide</i>. </p>', ], ], 'CloudWatchMetricsUnit' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDetail$Unit' => '<p> The unit of measure used for the CloudWatch metric. For example, <code>Bytes</code>, <code>Seconds</code>, <code>Count</code>, and <code>Percent</code>. </p>', ], ], 'ConflictException' => [ 'base' => '<p> An exception that is thrown when a conflict occurs. </p>', 'refs' => [], ], 'Cost' => [ 'base' => NULL, 'refs' => [ 'GetCostEstimationResponse$TotalCost' => '<p>The estimated monthly cost to analyze the Amazon Web Services resources. This value is the sum of the estimated costs to analyze each resource in the <code>Costs</code> object in this response.</p>', 'ServiceResourceCost$UnitCost' => '<p>The price per hour to analyze the resources in the service. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>', 'ServiceResourceCost$Cost' => '<p>The total estimated monthly cost to analyze the active resources for this resource.</p>', ], ], 'CostEstimationResourceCollectionFilter' => [ 'base' => '<p>Information about a filter used to specify which Amazon Web Services resources are analyzed to create a monthly DevOps Guru cost estimate. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>. </p>', 'refs' => [ 'GetCostEstimationResponse$ResourceCollection' => '<p>The collection of the Amazon Web Services resources used to create your monthly DevOps Guru cost estimate.</p>', 'StartCostEstimationRequest$ResourceCollection' => '<p>The collection of Amazon Web Services resources used to create a monthly DevOps Guru cost estimate.</p>', ], ], 'CostEstimationServiceResourceCount' => [ 'base' => NULL, 'refs' => [ 'ServiceResourceCost$Count' => '<p>The number of active resources analyzed for this service to create a monthly cost estimate.</p>', ], ], 'CostEstimationServiceResourceState' => [ 'base' => NULL, 'refs' => [ 'ServiceResourceCost$State' => '<p>The state of the resource. The resource is <code>ACTIVE</code> if it produces metrics, events, or logs within an hour, otherwise it is <code>INACTIVE</code>. You pay for the number of active Amazon Web Services resource hours analyzed for each resource. Inactive resources are not charged. </p>', ], ], 'CostEstimationStackNames' => [ 'base' => NULL, 'refs' => [ 'CloudFormationCostEstimationResourceCollectionFilter$StackNames' => '<p>An array of CloudFormation stack names. Its size is fixed at 1 item.</p>', ], ], 'CostEstimationStatus' => [ 'base' => NULL, 'refs' => [ 'GetCostEstimationResponse$Status' => '<p>The status of creating this cost estimate. If it\'s still in progress, the status <code>ONGOING</code> is returned. If it is finished, the status <code>COMPLETED</code> is returned.</p>', ], ], 'CostEstimationTagValues' => [ 'base' => NULL, 'refs' => [ 'TagCostEstimationResourceCollectionFilter$TagValues' => '<p>The values in an Amazon Web Services tag collection.</p> <p>The tag\'s <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag\'s <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>', ], ], 'CostEstimationTimeRange' => [ 'base' => '<p>The time range of a cost estimation.</p>', 'refs' => [ 'GetCostEstimationResponse$TimeRange' => '<p>The start and end time of the cost estimation.</p>', ], ], 'DescribeAccountHealthRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountHealthResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountOverviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountOverviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAnomalyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationHealthRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationHealthResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationOverviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationOverviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationResourceCollectionHealthRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeOrganizationResourceCollectionHealthResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceCollectionHealthRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResourceCollectionHealthResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceIntegrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceIntegrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'EndTimeRange' => [ 'base' => '<p> A range of time that specifies when anomalous behavior in an anomaly or insight ended. </p>', 'refs' => [ 'ListInsightsClosedStatusFilter$EndTimeRange' => '<p> A time range used to specify when the behavior of the filtered insights ended. </p>', ], ], 'ErrorMessageString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => '<p> A message that describes the validation exception. </p>', 'ValidationExceptionField$Message' => '<p> The message associated with the validation exception with information to help determine its cause. </p>', ], ], 'ErrorNameString' => [ 'base' => NULL, 'refs' => [ 'ValidationExceptionField$Name' => '<p> The name of the field. </p>', ], ], 'ErrorQuotaCodeString' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$QuotaCode' => '<p> The code of the quota that was exceeded, causing the throttling exception. </p>', ], ], 'ErrorServiceCodeString' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$ServiceCode' => '<p> The code of the service that caused the throttling exception. </p>', ], ], 'Event' => [ 'base' => '<p> An Amazon Web Services resource event. Amazon Web Services resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions. </p>', 'refs' => [ 'Events$member' => NULL, ], ], 'EventClass' => [ 'base' => NULL, 'refs' => [ 'Event$EventClass' => '<p> The class of the event. The class specifies what the event is related to, such as an infrastructure change, a deployment, or a schema change. </p>', 'ListEventsFilters$EventClass' => '<p> The class of the events you want to filter for, such as an infrastructure change, a deployment, or a schema change. </p>', ], ], 'EventDataSource' => [ 'base' => NULL, 'refs' => [ 'Event$DataSource' => '<p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, where DevOps Guru analysis found the event. </p>', 'ListEventsFilters$DataSource' => '<p> The source, <code>AWS_CLOUD_TRAIL</code> or <code>AWS_CODE_DEPLOY</code>, of the events you want returned. </p>', ], ], 'EventId' => [ 'base' => NULL, 'refs' => [ 'Event$Id' => '<p> The ID of the event. </p>', ], ], 'EventName' => [ 'base' => NULL, 'refs' => [ 'Event$Name' => '<p> The name of the event. </p>', ], ], 'EventResource' => [ 'base' => '<p> The Amazon Web Services resource that emitted an event. Amazon Web Services resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions. </p>', 'refs' => [ 'EventResources$member' => NULL, ], ], 'EventResourceArn' => [ 'base' => NULL, 'refs' => [ 'EventResource$Arn' => '<p> The Amazon Resource Name (ARN) of the resource that emitted an event. </p>', ], ], 'EventResourceName' => [ 'base' => NULL, 'refs' => [ 'EventResource$Name' => '<p> The name of the resource that emitted an event. </p>', ], ], 'EventResourceType' => [ 'base' => NULL, 'refs' => [ 'EventResource$Type' => '<p> The type of resource that emitted an event. </p>', ], ], 'EventResources' => [ 'base' => NULL, 'refs' => [ 'Event$Resources' => '<p> An <code>EventResource</code> object that contains information about the resource that emitted the event. </p>', ], ], 'EventSource' => [ 'base' => NULL, 'refs' => [ 'Event$EventSource' => '<p> The Amazon Web Services source that emitted the event. </p>', 'ListEventsFilters$EventSource' => '<p> The Amazon Web Services source that emitted the events you want to filter for. </p>', ], ], 'EventTimeRange' => [ 'base' => '<p> The time range during which an Amazon Web Services event occurred. Amazon Web Services resource events and metrics are analyzed by DevOps Guru to find anomalous behavior and provide recommendations to improve your operational solutions. </p>', 'refs' => [ 'ListEventsFilters$EventTimeRange' => '<p> A time range during which you want the filtered events to have occurred. </p>', ], ], 'Events' => [ 'base' => NULL, 'refs' => [ 'ListEventsResponse$Events' => '<p> A list of the requested events. </p>', ], ], 'GetCostEstimationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCostEstimationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'InsightFeedback' => [ 'base' => '<p> Information about insight feedback received from a customer. </p>', 'refs' => [ 'DescribeFeedbackResponse$InsightFeedback' => NULL, 'PutFeedbackRequest$InsightFeedback' => '<p> The feedback from customers is about the recommendations in this insight. </p>', ], ], 'InsightFeedbackOption' => [ 'base' => NULL, 'refs' => [ 'InsightFeedback$Feedback' => '<p> The feedback provided by the customer. </p>', ], ], 'InsightHealth' => [ 'base' => '<p> Information about the number of open reactive and proactive insights that can be used to gauge the health of your system. </p>', 'refs' => [ 'CloudFormationHealth$Insight' => '<p> Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services CloudFormation stack, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>', 'TagHealth$Insight' => '<p>Information about the health of the Amazon Web Services resources in your account that are specified by an Amazon Web Services tag, including the number of open proactive, open reactive insights, and the Mean Time to Recover (MTTR) of closed insights. </p>', ], ], 'InsightId' => [ 'base' => NULL, 'refs' => [ 'DescribeFeedbackRequest$InsightId' => '<p> The ID of the insight for which the feedback was provided. </p>', 'DescribeInsightRequest$Id' => '<p> The ID of the insight. </p>', 'InsightFeedback$Id' => '<p> The insight feedback ID. </p>', 'ListAnomaliesForInsightRequest$InsightId' => '<p> The ID of the insight. The returned anomalies belong to this insight. </p>', 'ListEventsFilters$InsightId' => '<p> An ID of an insight that is related to the events you want to filter for. </p>', 'ListRecommendationsRequest$InsightId' => '<p> The ID of the requested insight. </p>', 'ProactiveAnomaly$AssociatedInsightId' => '<p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>', 'ProactiveAnomalySummary$AssociatedInsightId' => '<p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>', 'ProactiveInsight$Id' => '<p>The ID of the proactive insight. </p>', 'ProactiveInsightSummary$Id' => '<p>The ID of the proactive insight. </p>', 'ProactiveOrganizationInsightSummary$Id' => '<p>The ID of the insight summary.</p>', 'ReactiveAnomaly$AssociatedInsightId' => '<p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>', 'ReactiveAnomalySummary$AssociatedInsightId' => '<p> The ID of the insight that contains this anomaly. An insight is composed of related anomalies. </p>', 'ReactiveInsight$Id' => '<p> The ID of a reactive insight. </p>', 'ReactiveInsightSummary$Id' => '<p> The ID of a reactive summary. </p>', 'ReactiveOrganizationInsightSummary$Id' => '<p>The ID of the insight summary.</p>', ], ], 'InsightName' => [ 'base' => NULL, 'refs' => [ 'ProactiveInsight$Name' => '<p>The name of the proactive insight. </p>', 'ProactiveInsightSummary$Name' => '<p>The name of the proactive insight. </p>', 'ProactiveOrganizationInsightSummary$Name' => '<p>The name of the insight summary.</p>', 'ReactiveInsight$Name' => '<p> The name of a reactive insight. </p>', 'ReactiveInsightSummary$Name' => '<p> The name of a reactive insight. </p>', 'ReactiveOrganizationInsightSummary$Name' => '<p>The name of the insight summary.</p>', ], ], 'InsightSeverities' => [ 'base' => NULL, 'refs' => [ 'SearchInsightsFilters$Severities' => '<p> An array of severity values used to search for insights. </p>', 'SearchOrganizationInsightsFilters$Severities' => '<p> An array of severity values used to search for insights. </p>', ], ], 'InsightSeverity' => [ 'base' => NULL, 'refs' => [ 'InsightSeverities$member' => NULL, 'ProactiveInsight$Severity' => '<p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', 'ProactiveInsightSummary$Severity' => '<p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', 'ProactiveOrganizationInsightSummary$Severity' => '<p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', 'ReactiveInsight$Severity' => '<p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', 'ReactiveInsightSummary$Severity' => '<p>The severity of the insight. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', 'ReactiveOrganizationInsightSummary$Severity' => '<p> An array of severity values used to search for insights. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities">Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.</p>', ], ], 'InsightStatus' => [ 'base' => NULL, 'refs' => [ 'InsightStatuses$member' => NULL, 'ProactiveInsight$Status' => '<p>The status of the proactive insight. </p>', 'ProactiveInsightSummary$Status' => '<p>The status of the proactive insight. </p>', 'ProactiveOrganizationInsightSummary$Status' => '<p> An array of status values used to search for insights. </p>', 'ReactiveInsight$Status' => '<p> The status of a reactive insight. </p>', 'ReactiveInsightSummary$Status' => '<p> The status of a reactive insight. </p>', 'ReactiveOrganizationInsightSummary$Status' => '<p> An array of status values used to search for insights. </p>', ], ], 'InsightStatuses' => [ 'base' => NULL, 'refs' => [ 'SearchInsightsFilters$Statuses' => '<p> An array of status values used to search for insights. </p>', 'SearchOrganizationInsightsFilters$Statuses' => '<p> An array of status values used to search for insights. </p>', ], ], 'InsightTimeRange' => [ 'base' => '<p> A time ranged that specifies when the observed behavior in an insight started and ended. </p>', 'refs' => [ 'ProactiveInsight$InsightTimeRange' => NULL, 'ProactiveInsightSummary$InsightTimeRange' => NULL, 'ProactiveOrganizationInsightSummary$InsightTimeRange' => NULL, 'ReactiveInsight$InsightTimeRange' => NULL, 'ReactiveInsightSummary$InsightTimeRange' => NULL, 'ReactiveOrganizationInsightSummary$InsightTimeRange' => NULL, ], ], 'InsightType' => [ 'base' => NULL, 'refs' => [ 'ListInsightsAnyStatusFilter$Type' => '<p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>', 'ListInsightsClosedStatusFilter$Type' => '<p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>', 'ListInsightsOngoingStatusFilter$Type' => '<p> Use to filter for either <code>REACTIVE</code> or <code>PROACTIVE</code> insights. </p>', 'SearchInsightsRequest$Type' => '<p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>', 'SearchOrganizationInsightsRequest$Type' => '<p> The type of insights you are searching for (<code>REACTIVE</code> or <code>PROACTIVE</code>). </p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal failure in an Amazon service occurred.</p>', 'refs' => [], ], 'ListAnomaliesForInsightMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAnomaliesForInsightRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListAnomaliesForInsightRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnomaliesForInsightResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventsFilters' => [ 'base' => '<p> Filters you can use to specify which events are returned when <code>ListEvents</code> is called. </p>', 'refs' => [ 'ListEventsRequest$Filters' => '<p> A <code>ListEventsFilters</code> object used to specify which events to return. </p>', ], ], 'ListEventsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListEventsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsAccountIdList' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationInsightsRequest$AccountIds' => '<p>The ID of the Amazon Web Services account. </p>', ], ], 'ListInsightsAnyStatusFilter' => [ 'base' => '<p> Used to filter for insights that have any status. </p>', 'refs' => [ 'ListInsightsStatusFilter$Any' => '<p> A <code>ListInsightsAnyStatusFilter</code> that specifies insights of any status that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>', ], ], 'ListInsightsClosedStatusFilter' => [ 'base' => '<p> Used to filter for insights that have the status <code>CLOSED</code>. </p>', 'refs' => [ 'ListInsightsStatusFilter$Closed' => '<p> A <code>ListInsightsClosedStatusFilter</code> that specifies closed insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>', ], ], 'ListInsightsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListInsightsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', 'ListOrganizationInsightsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListInsightsOngoingStatusFilter' => [ 'base' => '<p> Used to filter for insights that have the status <code>ONGOING</code>. </p>', 'refs' => [ 'ListInsightsStatusFilter$Ongoing' => '<p> A <code>ListInsightsAnyStatusFilter</code> that specifies ongoing insights that are either <code>REACTIVE</code> or <code>PROACTIVE</code>. </p>', ], ], 'ListInsightsOrganizationalUnitIdList' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationInsightsRequest$OrganizationalUnitIds' => '<p>The ID of the organizational unit.</p>', ], ], 'ListInsightsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInsightsStatusFilter' => [ 'base' => '<p> A filter used by <code>ListInsights</code> to specify which insights to return. </p>', 'refs' => [ 'ListInsightsRequest$StatusFilter' => '<p> A filter used to filter the returned insights by their status. You can specify one status filter. </p>', 'ListOrganizationInsightsRequest$StatusFilter' => NULL, ], ], 'ListNotificationChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNotificationChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationInsightsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListOrganizationInsightsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Locale' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationsRequest$Locale' => '<p>A locale that specifies the language to use for recommendations.</p>', ], ], 'MeanTimeToRecoverInMilliseconds' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountOverviewResponse$MeanTimeToRecoverInMilliseconds' => '<p> The Mean Time to Recover (MTTR) for all closed insights that were created during the time range passed in. </p>', 'InsightHealth$MeanTimeToRecoverInMilliseconds' => '<p> The Meant Time to Recover (MTTR) for the insight. </p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'TimestampMetricValuePair$MetricValue' => '<p>Value of the anomalous metric data point at respective Timestamp.</p>', ], ], 'NotificationChannel' => [ 'base' => '<p> Information about a notification channel. A notification channel is used to notify you when DevOps Guru creates an insight. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p> <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p> <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>', 'refs' => [ 'Channels$member' => NULL, ], ], 'NotificationChannelConfig' => [ 'base' => '<p> Information about notification channels you have configured with DevOps Guru. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS).</p>', 'refs' => [ 'AddNotificationChannelRequest$Config' => '<p> A <code>NotificationChannelConfig</code> object that specifies what type of notification channel to add. The one supported notification channel is Amazon Simple Notification Service (Amazon SNS). </p>', 'NotificationChannel$Config' => '<p> A <code>NotificationChannelConfig</code> object that contains information about configured notification channels. </p>', ], ], 'NotificationChannelId' => [ 'base' => NULL, 'refs' => [ 'AddNotificationChannelResponse$Id' => '<p> The ID of the added notification channel. </p>', 'NotificationChannel$Id' => '<p> The ID of a notification channel. </p>', 'RemoveNotificationChannelRequest$Id' => '<p> The ID of the notification channel to be removed. </p>', ], ], 'NumMetricsAnalyzed' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountHealthResponse$MetricsAnalyzed' => '<p> An integer that specifies the number of metrics that have been analyzed in your Amazon Web Services account. </p>', 'DescribeOrganizationHealthResponse$MetricsAnalyzed' => '<p>An integer that specifies the number of metrics that have been analyzed in your organization.</p>', ], ], 'NumOpenProactiveInsights' => [ 'base' => NULL, 'refs' => [ 'AccountInsightHealth$OpenProactiveInsights' => '<p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>', 'DescribeAccountHealthResponse$OpenProactiveInsights' => '<p> An integer that specifies the number of open proactive insights in your Amazon Web Services account. </p>', 'DescribeOrganizationHealthResponse$OpenProactiveInsights' => '<p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>', 'InsightHealth$OpenProactiveInsights' => '<p> The number of open proactive insights. </p>', 'ServiceInsightHealth$OpenProactiveInsights' => '<p>The number of open proactive insights in the Amazon Web Services service</p>', ], ], 'NumOpenReactiveInsights' => [ 'base' => NULL, 'refs' => [ 'AccountInsightHealth$OpenReactiveInsights' => '<p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>', 'DescribeAccountHealthResponse$OpenReactiveInsights' => '<p> An integer that specifies the number of open reactive insights in your Amazon Web Services account. </p>', 'DescribeOrganizationHealthResponse$OpenReactiveInsights' => '<p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>', 'InsightHealth$OpenReactiveInsights' => '<p> The number of open reactive insights. </p>', 'ServiceInsightHealth$OpenReactiveInsights' => '<p>The number of open reactive insights in the Amazon Web Services service</p>', ], ], 'NumProactiveInsights' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountOverviewResponse$ProactiveInsights' => '<p> An integer that specifies the number of open proactive insights in your Amazon Web Services account that were created during the time range passed in. </p>', 'DescribeOrganizationOverviewResponse$ProactiveInsights' => '<p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>', ], ], 'NumReactiveInsights' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountOverviewResponse$ReactiveInsights' => '<p> An integer that specifies the number of open reactive insights in your Amazon Web Services account that were created during the time range passed in. </p>', 'DescribeOrganizationOverviewResponse$ReactiveInsights' => '<p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>', ], ], 'OpsCenterIntegration' => [ 'base' => '<p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>', 'refs' => [ 'ServiceIntegrationConfig$OpsCenter' => '<p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>', ], ], 'OpsCenterIntegrationConfig' => [ 'base' => '<p> Information about whether DevOps Guru is configured to create an OpsItem in Amazon Web Services Systems Manager OpsCenter for each created insight. </p>', 'refs' => [ 'UpdateServiceIntegrationConfig$OpsCenter' => NULL, ], ], 'OptInStatus' => [ 'base' => '<p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>', 'refs' => [ 'OpsCenterIntegration$OptInStatus' => '<p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>', 'OpsCenterIntegrationConfig$OptInStatus' => '<p> Specifies if DevOps Guru is enabled to create an Amazon Web Services Systems Manager OpsItem for each created insight. </p>', ], ], 'OrganizationResourceCollectionMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResourceCollectionHealthRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'OrganizationResourceCollectionType' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResourceCollectionHealthRequest$OrganizationResourceCollectionType' => '<p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', ], ], 'OrganizationalUnitId' => [ 'base' => NULL, 'refs' => [ 'ListInsightsOrganizationalUnitIdList$member' => NULL, 'OrganizationalUnitIdList$member' => NULL, 'ProactiveOrganizationInsightSummary$OrganizationalUnitId' => '<p>The ID of the organizational unit.</p>', 'ReactiveOrganizationInsightSummary$OrganizationalUnitId' => '<p>The ID of the organizational unit.</p>', ], ], 'OrganizationalUnitIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationHealthRequest$OrganizationalUnitIds' => '<p>The ID of the organizational unit.</p>', 'DescribeOrganizationOverviewRequest$OrganizationalUnitIds' => '<p>The ID of the organizational unit.</p>', 'DescribeOrganizationResourceCollectionHealthRequest$OrganizationalUnitIds' => '<p>The ID of the organizational unit.</p>', ], ], 'PerformanceInsightsMetricDimension' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricDimensions$member' => NULL, ], ], 'PerformanceInsightsMetricDimensionGroup' => [ 'base' => '<p>A logical grouping of Performance Insights metrics for a related subject area. For example, the <code>db.sql</code> dimension group consists of the following dimensions: <code>db.sql.id</code>, <code>db.sql.db_id</code>, <code>db.sql.statement</code>, and <code>db.sql.tokenized_id</code>.</p> <note> <p>Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.</p> </note> <p>Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host. </p> <ul> <li> <p>To learn more about Performance Insights and Amazon Aurora DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html"> Amazon Aurora User Guide</a>. </p> </li> <li> <p>To learn more about Performance Insights and Amazon RDS DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Amazon RDS User Guide</a>. </p> </li> </ul>', 'refs' => [ 'PerformanceInsightsMetricQuery$GroupBy' => '<p>The specification for how to aggregate the data points from a Performance Insights <code>GetResourceMetrics</code> API query. The Performance Insights query returns all of the dimensions within that group, unless you provide the names of specific dimensions within that group. You can also request that Performance Insights return a limited number of values for a dimension.</p>', ], ], 'PerformanceInsightsMetricDimensions' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricDimensionGroup$Dimensions' => '<p>A list of specific dimensions from a dimension group. If this parameter is not present, then it signifies that all of the dimensions in the group were requested or are present in the response.</p> <p>Valid values for elements in the <code>Dimensions</code> array are:</p> <ul> <li> <p> <code>db.application.name</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li> <li> <p> <code>db.host.id</code> - The host ID of the connected client (all engines)</p> </li> <li> <p> <code>db.host.name</code> - The host name of the connected client (all engines)</p> </li> <li> <p> <code>db.name</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li> <li> <p> <code>db.session_type.name</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li> <li> <p> <code>db.sql.id</code> - The SQL ID generated by Performance Insights (all engines)</p> </li> <li> <p> <code>db.sql.db_id</code> - The SQL ID generated by the database (all engines)</p> </li> <li> <p> <code>db.sql.statement</code> - The SQL text that is being executed (all engines)</p> </li> <li> <p> <code>db.sql.tokenized_id</code> </p> </li> <li> <p> <code>db.sql_tokenized.id</code> - The SQL digest ID generated by Performance Insights (all engines)</p> </li> <li> <p> <code>db.sql_tokenized.db_id</code> - SQL digest ID generated by the database (all engines)</p> </li> <li> <p> <code>db.sql_tokenized.statement</code> - The SQL digest text (all engines)</p> </li> <li> <p> <code>db.user.id</code> - The ID of the user logged in to the database (all engines)</p> </li> <li> <p> <code>db.user.name</code> - The name of the user logged in to the database (all engines)</p> </li> <li> <p> <code>db.wait_event.name</code> - The event for which the backend is waiting (all engines)</p> </li> <li> <p> <code>db.wait_event.type</code> - The type of event for which the backend is waiting (all engines)</p> </li> <li> <p> <code>db.wait_event_type.name</code> - The name of the event type for which the backend is waiting (all engines)</p> </li> </ul>', ], ], 'PerformanceInsightsMetricDisplayName' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricsDetail$MetricDisplayName' => '<p>The name used for a specific Performance Insights metric.</p>', ], ], 'PerformanceInsightsMetricFilterKey' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricFilterMap$key' => NULL, ], ], 'PerformanceInsightsMetricFilterMap' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricQuery$Filter' => '<p>One or more filters to apply to a Performance Insights <code>GetResourceMetrics</code> API query. Restrictions:</p> <ul> <li> <p>Any number of filters by the same dimension, as specified in the <code>GroupBy</code> parameter.</p> </li> <li> <p>A single filter for any other dimension in this dimension group.</p> </li> </ul>', ], ], 'PerformanceInsightsMetricFilterValue' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricFilterMap$value' => NULL, ], ], 'PerformanceInsightsMetricGroup' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricDimensionGroup$Group' => '<p>The name of the dimension group. Its valid values are:</p> <ul> <li> <p> <code>db</code> - The name of the database to which the client is connected (only Aurora PostgreSQL, Amazon RDS PostgreSQL, Aurora MySQL, Amazon RDS MySQL, and MariaDB)</p> </li> <li> <p> <code>db.application</code> - The name of the application that is connected to the database (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li> <li> <p> <code>db.host</code> - The host name of the connected client (all engines)</p> </li> <li> <p> <code>db.session_type</code> - The type of the current session (only Aurora PostgreSQL and RDS PostgreSQL)</p> </li> <li> <p> <code>db.sql</code> - The SQL that is currently executing (all engines)</p> </li> <li> <p> <code>db.sql_tokenized</code> - The SQL digest (all engines)</p> </li> <li> <p> <code>db.wait_event</code> - The event for which the database backend is waiting (all engines)</p> </li> <li> <p> <code>db.wait_event_type</code> - The type of event for which the database backend is waiting (all engines)</p> </li> <li> <p> <code>db.user</code> - The user logged in to the database (all engines)</p> </li> </ul>', ], ], 'PerformanceInsightsMetricLimitInteger' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricDimensionGroup$Limit' => '<p>The maximum number of items to fetch for this dimension group.</p>', ], ], 'PerformanceInsightsMetricName' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricQuery$Metric' => '<p>The name of the meteric used used when querying an Performance Insights <code>GetResourceMetrics</code> API for anomaly metrics.</p> <p>Valid values for <code>Metric</code> are:</p> <ul> <li> <p> <code>db.load.avg</code> - a scaled representation of the number of active sessions for the database engine.</p> </li> <li> <p> <code>db.sampledload.avg</code> - the raw number of active sessions for the database engine.</p> </li> </ul> <p>If the number of active sessions is less than an internal Performance Insights threshold, <code>db.load.avg</code> and <code>db.sampledload.avg</code> are the same value. If the number of active sessions is greater than the internal threshold, Performance Insights samples the active sessions, with <code>db.load.avg</code> showing the scaled values, <code>db.sampledload.avg</code> showing the raw values, and <code>db.sampledload.avg</code> less than <code>db.load.avg</code>. For most use cases, you can query <code>db.load.avg</code> only. </p>', ], ], 'PerformanceInsightsMetricQuery' => [ 'base' => '<p>A single query to be processed. Use these parameters to query the Performance Insights <code>GetResourceMetrics</code> API to retrieve the metrics for an anomaly. For more information, see <code> <a href="https://docs.aws.amazon.com/performance-insights/latest/APIReference/API_GetResourceMetrics.html">GetResourceMetrics</a> </code> in the <i>Amazon RDS Performance Insights API Reference</i>.</p> <p>Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host. </p> <ul> <li> <p>To learn more about Performance Insights and Amazon Aurora DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html"> Amazon Aurora User Guide</a>. </p> </li> <li> <p>To learn more about Performance Insights and Amazon RDS DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Amazon RDS User Guide</a>. </p> </li> </ul>', 'refs' => [ 'PerformanceInsightsMetricsDetail$MetricQuery' => '<p>A single query to be processed for the metric. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsMetricQuery.html">PerformanceInsightsMetricQuery</a> </code>.</p>', 'PerformanceInsightsReferenceMetric$MetricQuery' => '<p>A query to be processed on the metric.</p>', ], ], 'PerformanceInsightsMetricUnit' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricsDetail$Unit' => '<p>The unit of measure for a metric. For example, a session or a process.</p>', ], ], 'PerformanceInsightsMetricsDetail' => [ 'base' => '<p>Details about Performance Insights metrics.</p> <p>Amazon RDS Performance Insights enables you to monitor and explore different dimensions of database load based on data captured from a running DB instance. DB load is measured as average active sessions. Performance Insights provides the data to API consumers as a two-dimensional time-series dataset. The time dimension provides DB load data for each time point in the queried time range. Each time point decomposes overall load in relation to the requested dimensions, measured at that time point. Examples include SQL, Wait event, User, and Host. </p> <ul> <li> <p>To learn more about Performance Insights and Amazon Aurora DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html"> Amazon Aurora User Guide</a>. </p> </li> <li> <p>To learn more about Performance Insights and Amazon RDS DB instances, go to the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Amazon RDS User Guide</a>. </p> </li> </ul>', 'refs' => [ 'PerformanceInsightsMetricsDetails$member' => NULL, ], ], 'PerformanceInsightsMetricsDetails' => [ 'base' => NULL, 'refs' => [ 'AnomalySourceDetails$PerformanceInsightsMetrics' => '<p>An array of <code>PerformanceInsightsMetricsDetail</code> objects that contain information about analyzed Performance Insights metrics that show anomalous behavior.</p>', ], ], 'PerformanceInsightsReferenceComparisonValues' => [ 'base' => '<p>Reference scalar values and other metrics that DevOps Guru displays on a graph in its console along with the actual metrics it analyzed. Compare these reference values to your actual metrics to help you understand anomalous behavior that DevOps Guru detected.</p>', 'refs' => [ 'PerformanceInsightsReferenceData$ComparisonValues' => '<p>The specific reference values used to evaluate the Performance Insights. For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceComparisonValues.html">PerformanceInsightsReferenceComparisonValues</a> </code>. </p>', ], ], 'PerformanceInsightsReferenceData' => [ 'base' => '<p>Reference data used to evaluate Performance Insights to determine if its performance is anomalous or not.</p>', 'refs' => [ 'PerformanceInsightsReferenceDataList$member' => NULL, ], ], 'PerformanceInsightsReferenceDataList' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricsDetail$ReferenceData' => '<p> For more information, see <code> <a href="https://docs.aws.amazon.com/devops-guru/latest/APIReference/API_PerformanceInsightsReferenceData.html">PerformanceInsightsReferenceData</a> </code>. </p>', ], ], 'PerformanceInsightsReferenceMetric' => [ 'base' => '<p>Information about a reference metric used to evaluate Performance Insights.</p>', 'refs' => [ 'PerformanceInsightsReferenceComparisonValues$ReferenceMetric' => '<p>A metric that DevOps Guru compares to actual metric values. This reference metric is used to determine if an actual metric should be considered anomalous.</p>', ], ], 'PerformanceInsightsReferenceName' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsReferenceData$Name' => '<p>The name of the reference data.</p>', ], ], 'PerformanceInsightsReferenceScalar' => [ 'base' => '<p>A reference value to compare Performance Insights metrics against to determine if the metrics demonstrate anomalous behavior.</p>', 'refs' => [ 'PerformanceInsightsReferenceComparisonValues$ReferenceScalar' => '<p>A scalar value DevOps Guru for a metric that DevOps Guru compares to actual metric values. This reference value is used to determine if an actual metric value should be considered anomalous.</p>', ], ], 'PerformanceInsightsStat' => [ 'base' => '<p>A statistic in a Performance Insights collection.</p>', 'refs' => [ 'PerformanceInsightsStats$member' => NULL, ], ], 'PerformanceInsightsStatType' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsStat$Type' => '<p>The statistic type.</p>', ], ], 'PerformanceInsightsStats' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsMetricsDetail$StatsAtAnomaly' => '<p>The metric statistics during the anomalous period detected by DevOps Guru;</p>', 'PerformanceInsightsMetricsDetail$StatsAtBaseline' => '<p>Typical metric statistics that are not considered anomalous. When DevOps Guru analyzes metrics, it compares them to <code>StatsAtBaseline</code> to help determine if they are anomalous.</p>', ], ], 'PerformanceInsightsValueDouble' => [ 'base' => NULL, 'refs' => [ 'PerformanceInsightsReferenceScalar$Value' => '<p>The reference value.</p>', 'PerformanceInsightsStat$Value' => '<p>The value of the statistic.</p>', ], ], 'PredictionTimeRange' => [ 'base' => '<p> The time range during which anomalous behavior in a proactive anomaly or an insight is expected to occur. </p>', 'refs' => [ 'ProactiveAnomaly$PredictionTimeRange' => NULL, 'ProactiveAnomalySummary$PredictionTimeRange' => NULL, 'ProactiveInsight$PredictionTimeRange' => NULL, 'ProactiveInsightSummary$PredictionTimeRange' => NULL, 'ProactiveOrganizationInsightSummary$PredictionTimeRange' => NULL, ], ], 'ProactiveAnomalies' => [ 'base' => NULL, 'refs' => [ 'ListAnomaliesForInsightResponse$ProactiveAnomalies' => '<p> An array of <code>ProactiveAnomalySummary</code> objects that represent the requested anomalies </p>', ], ], 'ProactiveAnomaly' => [ 'base' => '<p>Information about an anomaly. This object is returned by <code>ListAnomalies</code>.</p>', 'refs' => [ 'DescribeAnomalyResponse$ProactiveAnomaly' => '<p> A <code>ProactiveAnomaly</code> object that represents the requested anomaly. </p>', ], ], 'ProactiveAnomalySummary' => [ 'base' => '<p>Details about a proactive anomaly. This object is returned by <code>DescribeAnomaly.</code> </p>', 'refs' => [ 'ProactiveAnomalies$member' => NULL, ], ], 'ProactiveInsight' => [ 'base' => '<p>Details about a proactive insight. This object is returned by <code>ListInsights</code>.</p>', 'refs' => [ 'DescribeInsightResponse$ProactiveInsight' => '<p> A <code>ProactiveInsight</code> object that represents the requested insight. </p>', ], ], 'ProactiveInsightSummary' => [ 'base' => '<p>Details about a proactive insight. This object is returned by <code>DescribeInsight.</code> </p>', 'refs' => [ 'ProactiveInsights$member' => NULL, ], ], 'ProactiveInsights' => [ 'base' => NULL, 'refs' => [ 'ListInsightsResponse$ProactiveInsights' => '<p> The returned list of proactive insights. </p>', 'SearchInsightsResponse$ProactiveInsights' => '<p> The returned proactive insights. </p>', 'SearchOrganizationInsightsResponse$ProactiveInsights' => '<p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>', ], ], 'ProactiveOrganizationInsightSummary' => [ 'base' => '<p>Details about a proactive insight. This object is returned by <code>DescribeInsight</code>.</p>', 'refs' => [ 'ProactiveOrganizationInsights$member' => NULL, ], ], 'ProactiveOrganizationInsights' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationInsightsResponse$ProactiveInsights' => '<p>An integer that specifies the number of open proactive insights in your Amazon Web Services account.</p>', ], ], 'PutFeedbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutFeedbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReactiveAnomalies' => [ 'base' => NULL, 'refs' => [ 'ListAnomaliesForInsightResponse$ReactiveAnomalies' => '<p> An array of <code>ReactiveAnomalySummary</code> objects that represent the requested anomalies </p>', ], ], 'ReactiveAnomaly' => [ 'base' => '<p>Details about a reactive anomaly. This object is returned by <code>ListAnomalies</code>.</p>', 'refs' => [ 'DescribeAnomalyResponse$ReactiveAnomaly' => '<p> A <code>ReactiveAnomaly</code> object that represents the requested anomaly. </p>', ], ], 'ReactiveAnomalySummary' => [ 'base' => '<p>Details about a reactive anomaly. This object is returned by <code>DescribeAnomaly.</code> </p>', 'refs' => [ 'ReactiveAnomalies$member' => NULL, ], ], 'ReactiveInsight' => [ 'base' => '<p> Information about a reactive insight. This object is returned by <code>ListInsights</code>. </p>', 'refs' => [ 'DescribeInsightResponse$ReactiveInsight' => '<p> A <code>ReactiveInsight</code> object that represents the requested insight. </p>', ], ], 'ReactiveInsightSummary' => [ 'base' => '<p> Information about a reactive insight. This object is returned by <code>DescribeInsight.</code> </p>', 'refs' => [ 'ReactiveInsights$member' => NULL, ], ], 'ReactiveInsights' => [ 'base' => NULL, 'refs' => [ 'ListInsightsResponse$ReactiveInsights' => '<p> The returned list of reactive insights. </p>', 'SearchInsightsResponse$ReactiveInsights' => '<p> The returned reactive insights. </p>', 'SearchOrganizationInsightsResponse$ReactiveInsights' => '<p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>', ], ], 'ReactiveOrganizationInsightSummary' => [ 'base' => '<p>Information about a reactive insight. This object is returned by <code>DescribeInsight</code>.</p>', 'refs' => [ 'ReactiveOrganizationInsights$member' => NULL, ], ], 'ReactiveOrganizationInsights' => [ 'base' => NULL, 'refs' => [ 'ListOrganizationInsightsResponse$ReactiveInsights' => '<p>An integer that specifies the number of open reactive insights in your Amazon Web Services account.</p>', ], ], 'Recommendation' => [ 'base' => '<p> Recommendation information to help you remediate detected anomalous behavior that generated an insight. </p>', 'refs' => [ 'Recommendations$member' => NULL, ], ], 'RecommendationDescription' => [ 'base' => NULL, 'refs' => [ 'Recommendation$Description' => '<p> A description of the problem. </p>', ], ], 'RecommendationLink' => [ 'base' => NULL, 'refs' => [ 'Recommendation$Link' => '<p> A hyperlink to information to help you address the problem. </p>', ], ], 'RecommendationName' => [ 'base' => NULL, 'refs' => [ 'Recommendation$Name' => '<p> The name of the recommendation. </p>', ], ], 'RecommendationReason' => [ 'base' => NULL, 'refs' => [ 'Recommendation$Reason' => '<p> The reason DevOps Guru flagged the anomalous behavior as a problem. </p>', ], ], 'RecommendationRelatedAnomalies' => [ 'base' => NULL, 'refs' => [ 'Recommendation$RelatedAnomalies' => '<p> Anomalies that are related to the problem. Use these Anomalies to learn more about what\'s happening and to help address the issue. </p>', ], ], 'RecommendationRelatedAnomaly' => [ 'base' => '<p> Information about an anomaly that is related to a recommendation. </p>', 'refs' => [ 'RecommendationRelatedAnomalies$member' => NULL, ], ], 'RecommendationRelatedAnomalyResource' => [ 'base' => '<p> Information about a resource in which DevOps Guru detected anomalous behavior. </p>', 'refs' => [ 'RecommendationRelatedAnomalyResources$member' => NULL, ], ], 'RecommendationRelatedAnomalyResourceName' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomalyResource$Name' => '<p> The name of the resource. </p>', ], ], 'RecommendationRelatedAnomalyResourceType' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomalyResource$Type' => '<p> The type of the resource. Resource types take the same form that is used by Amazon Web Services CloudFormation resource type identifiers, <code>service-provider::service-name::data-type-name</code>. For example, <code>AWS::RDS::DBCluster</code>. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html">Amazon Web Services resource and property types reference</a> in the <i>Amazon Web Services CloudFormation User Guide</i>.</p>', ], ], 'RecommendationRelatedAnomalyResources' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomaly$Resources' => '<p> An array of objects that represent resources in which DevOps Guru detected anomalous behavior. Each object contains the name and type of the resource. </p>', ], ], 'RecommendationRelatedAnomalySourceDetail' => [ 'base' => '<p> Contains an array of <code>RecommendationRelatedCloudWatchMetricsSourceDetail</code> objects that contain the name and namespace of an Amazon CloudWatch metric. </p>', 'refs' => [ 'RelatedAnomalySourceDetails$member' => NULL, ], ], 'RecommendationRelatedCloudWatchMetricsSourceDetail' => [ 'base' => '<p> Information about an Amazon CloudWatch metric that is analyzed by DevOps Guru. It is one of many analyzed metrics that are used to generate insights. </p>', 'refs' => [ 'RecommendationRelatedCloudWatchMetricsSourceDetails$member' => NULL, ], ], 'RecommendationRelatedCloudWatchMetricsSourceDetails' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomalySourceDetail$CloudWatchMetrics' => '<p> An array of <code>CloudWatchMetricsDetail</code> objects that contains information about the analyzed metrics that displayed anomalous behavior. </p>', ], ], 'RecommendationRelatedCloudWatchMetricsSourceMetricName' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedCloudWatchMetricsSourceDetail$MetricName' => '<p>The name of the CloudWatch metric.</p>', ], ], 'RecommendationRelatedCloudWatchMetricsSourceNamespace' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedCloudWatchMetricsSourceDetail$Namespace' => '<p>The namespace of the CloudWatch metric. A namespace is a container for CloudWatch metrics.</p>', ], ], 'RecommendationRelatedEvent' => [ 'base' => '<p> Information about an event that is related to a recommendation. </p>', 'refs' => [ 'RecommendationRelatedEvents$member' => NULL, ], ], 'RecommendationRelatedEventName' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedEvent$Name' => '<p> The name of the event. This corresponds to the <code>Name</code> field in an <code>Event</code> object. </p>', ], ], 'RecommendationRelatedEventResource' => [ 'base' => '<p> Information about an Amazon Web Services resource that emitted and event that is related to a recommendation in an insight. </p>', 'refs' => [ 'RecommendationRelatedEventResources$member' => NULL, ], ], 'RecommendationRelatedEventResourceName' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedEventResource$Name' => '<p> The name of the resource that emitted the event. This corresponds to the <code>Name</code> field in an <code>EventResource</code> object. </p>', ], ], 'RecommendationRelatedEventResourceType' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedEventResource$Type' => '<p> The type of the resource that emitted the event. This corresponds to the <code>Type</code> field in an <code>EventResource</code> object. </p>', ], ], 'RecommendationRelatedEventResources' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedEvent$Resources' => '<p> A <code>ResourceCollection</code> object that contains arrays of the names of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', ], ], 'RecommendationRelatedEvents' => [ 'base' => NULL, 'refs' => [ 'Recommendation$RelatedEvents' => '<p> Events that are related to the problem. Use these events to learn more about what\'s happening and to help address the issue. </p>', ], ], 'Recommendations' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationsResponse$Recommendations' => '<p> An array of the requested recommendations. </p>', ], ], 'RelatedAnomalySourceDetails' => [ 'base' => NULL, 'refs' => [ 'RecommendationRelatedAnomaly$SourceDetails' => '<p> Information about where the anomalous behavior related the recommendation was found. For example, details in Amazon CloudWatch metrics. </p>', ], ], 'RemoveNotificationChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveNotificationChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'AssociatedResourceArns$member' => NULL, ], ], 'ResourceCollection' => [ 'base' => '<p> A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', 'refs' => [ 'Event$ResourceCollection' => NULL, 'ListEventsFilters$ResourceCollection' => NULL, 'ProactiveAnomaly$ResourceCollection' => NULL, 'ProactiveAnomalySummary$ResourceCollection' => NULL, 'ProactiveInsight$ResourceCollection' => NULL, 'ProactiveInsightSummary$ResourceCollection' => NULL, 'ProactiveOrganizationInsightSummary$ResourceCollection' => NULL, 'ReactiveAnomaly$ResourceCollection' => NULL, 'ReactiveAnomalySummary$ResourceCollection' => NULL, 'ReactiveInsight$ResourceCollection' => NULL, 'ReactiveInsightSummary$ResourceCollection' => NULL, 'ReactiveOrganizationInsightSummary$ResourceCollection' => NULL, 'SearchInsightsFilters$ResourceCollection' => NULL, 'SearchOrganizationInsightsFilters$ResourceCollection' => NULL, ], ], 'ResourceCollectionFilter' => [ 'base' => '<p> Information about a filter used to specify which Amazon Web Services resources are analyzed for anomalous behavior by DevOps Guru. </p>', 'refs' => [ 'GetResourceCollectionResponse$ResourceCollection' => '<p> The requested list of Amazon Web Services resource collections. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', ], ], 'ResourceCollectionType' => [ 'base' => NULL, 'refs' => [ 'DescribeResourceCollectionHealthRequest$ResourceCollectionType' => '<p> An Amazon Web Services resource collection type. This type specifies how analyzed Amazon Web Services resources are defined. The two types of Amazon Web Services resource collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', 'GetResourceCollectionRequest$ResourceCollectionType' => '<p> The type of Amazon Web Services resource collections to return. The one valid value is <code>CLOUD_FORMATION</code> for Amazon Web Services CloudFormation stacks. </p>', ], ], 'ResourceHours' => [ 'base' => NULL, 'refs' => [ 'DescribeAccountHealthResponse$ResourceHours' => '<p>The number of Amazon DevOps Guru resource analysis hours billed to the current Amazon Web Services account in the last hour. </p>', 'DescribeOrganizationHealthResponse$ResourceHours' => '<p>The number of Amazon DevOps Guru resource analysis hours billed to the current Amazon Web Services account in the last hour. </p>', ], ], 'ResourceIdString' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceId' => '<p> The ID of the Amazon Web Services resource in which a conflict occurred. </p>', 'ResourceNotFoundException$ResourceId' => '<p> The ID of the Amazon Web Services resource that could not be found. </p>', ], ], 'ResourceIdType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$ResourceType' => '<p> The type of the Amazon Web Services resource in which a conflict occurred. </p>', 'ResourceNotFoundException$ResourceType' => '<p> The type of the Amazon Web Services resource that could not be found. </p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'AnomalyResource$Name' => '<p>The name of the Amazon Web Services resource.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A requested resource could not be found</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'AnomalyResource$Type' => '<p>The type of the Amazon Web Services resource.</p>', 'ServiceResourceCost$Type' => '<p>The type of the Amazon Web Services resource.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$RetryAfterSeconds' => '<p> The number of seconds after which the action that caused the internal server exception can be retried. </p>', 'ThrottlingException$RetryAfterSeconds' => '<p> The number of seconds after which the action that caused the throttling exception can be retried. </p>', ], ], 'SearchInsightsAccountIdList' => [ 'base' => NULL, 'refs' => [ 'SearchOrganizationInsightsRequest$AccountIds' => '<p>The ID of the Amazon Web Services account. </p>', ], ], 'SearchInsightsFilters' => [ 'base' => '<p> Specifies one or more severity values and one or more status values that are used to search for insights. </p>', 'refs' => [ 'SearchInsightsRequest$Filters' => '<p> A <code>SearchInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>', ], ], 'SearchInsightsMaxResults' => [ 'base' => NULL, 'refs' => [ 'SearchInsightsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'SearchInsightsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchInsightsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchOrganizationInsightsFilters' => [ 'base' => '<p> Filters you can use to specify which events are returned when <code>ListEvents</code> is called. </p>', 'refs' => [ 'SearchOrganizationInsightsRequest$Filters' => '<p> A <code>SearchOrganizationInsightsFilters</code> object that is used to set the severity and status filters on your insight search. </p>', ], ], 'SearchOrganizationInsightsMaxResults' => [ 'base' => NULL, 'refs' => [ 'SearchOrganizationInsightsRequest$MaxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'SearchOrganizationInsightsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchOrganizationInsightsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServiceCollection' => [ 'base' => '<p>A collection of the names of Amazon Web Services services.</p>', 'refs' => [ 'ProactiveInsightSummary$ServiceCollection' => '<p>A collection of the names of Amazon Web Services services.</p>', 'ProactiveOrganizationInsightSummary$ServiceCollection' => NULL, 'ReactiveInsightSummary$ServiceCollection' => '<p>A collection of the names of Amazon Web Services services.</p>', 'ReactiveOrganizationInsightSummary$ServiceCollection' => NULL, 'SearchInsightsFilters$ServiceCollection' => '<p>A collection of the names of Amazon Web Services services.</p>', 'SearchOrganizationInsightsFilters$ServiceCollection' => NULL, ], ], 'ServiceHealth' => [ 'base' => '<p>Represents the health of an Amazon Web Services service.</p>', 'refs' => [ 'ServiceHealths$member' => NULL, ], ], 'ServiceHealths' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResourceCollectionHealthResponse$Service' => '<p>An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services services associated with the resources in the collection.</p>', 'DescribeResourceCollectionHealthResponse$Service' => '<p>An array of <code>ServiceHealth</code> objects that describes the health of the Amazon Web Services services associated with the resources in the collection.</p>', ], ], 'ServiceInsightHealth' => [ 'base' => '<p>Contains the number of open proactive and reactive insights in an analyzed Amazon Web Services service.</p>', 'refs' => [ 'ServiceHealth$Insight' => '<p>Represents the health of an Amazon Web Services service. This is a <code>ServiceInsightHealth</code> that contains the number of open proactive and reactive insights for this service.</p>', ], ], 'ServiceIntegrationConfig' => [ 'base' => '<p> Information about the integration of DevOps Guru with another Amazon Web Services service, such as Amazon Web Services Systems Manager. </p>', 'refs' => [ 'DescribeServiceIntegrationResponse$ServiceIntegration' => NULL, ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [ 'ServiceHealth$ServiceName' => '<p>The name of the Amazon Web Services service.</p>', 'ServiceNames$member' => NULL, ], ], 'ServiceNames' => [ 'base' => NULL, 'refs' => [ 'ServiceCollection$ServiceNames' => '<p>An array of strings that each specifies the name of an Amazon Web Services service.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request contains a value that exceeds a maximum quota.</p>', 'refs' => [], ], 'ServiceResourceCost' => [ 'base' => '<p>An object that contains information about the estimated monthly cost to analyze an Amazon Web Services resource. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/cost-estimate.html">Estimate your Amazon DevOps Guru costs</a> and <a href="http://aws.amazon.com/devops-guru/pricing/">Amazon DevOps Guru pricing</a>.</p>', 'refs' => [ 'ServiceResourceCosts$member' => NULL, ], ], 'ServiceResourceCosts' => [ 'base' => NULL, 'refs' => [ 'GetCostEstimationResponse$Costs' => '<p>An array of <code>ResourceCost</code> objects that each contains details about the monthly cost estimate to analyze one of your Amazon Web Services resources.</p>', ], ], 'SnsChannelConfig' => [ 'base' => '<p> Contains the Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p> <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p> <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>', 'refs' => [ 'NotificationChannelConfig$Sns' => '<p> Information about a notification channel configured in DevOps Guru to send notifications when insights are created. </p> <p>If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html">Permissions for cross account Amazon SNS topics</a>.</p> <p>If you use an Amazon SNS topic that is encrypted by an Amazon Web Services Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see <a href="https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html">Permissions for Amazon Web Services KMS–encrypted Amazon SNS topics</a>.</p>', ], ], 'SsmOpsItemId' => [ 'base' => NULL, 'refs' => [ 'ProactiveInsight$SsmOpsItemId' => '<p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>', 'ReactiveInsight$SsmOpsItemId' => '<p> The ID of the Amazon Web Services System Manager OpsItem created for this insight. You must enable the creation of OpstItems insights before they are created for each insight. </p>', ], ], 'StackName' => [ 'base' => NULL, 'refs' => [ 'CloudFormationHealth$StackName' => '<p> The name of the CloudFormation stack. </p>', 'CostEstimationStackNames$member' => NULL, 'StackNames$member' => NULL, 'UpdateStackNames$member' => NULL, ], ], 'StackNames' => [ 'base' => NULL, 'refs' => [ 'CloudFormationCollection$StackNames' => '<p> An array of CloudFormation stack names. </p>', 'CloudFormationCollectionFilter$StackNames' => '<p> An array of CloudFormation stack names. </p>', ], ], 'StartCostEstimationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCostEstimationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTimeRange' => [ 'base' => '<p> A time range used to specify when the behavior of an insight or anomaly started. </p>', 'refs' => [ 'ListAnomaliesForInsightRequest$StartTimeRange' => '<p> A time range used to specify when the requested anomalies started. All returned anomalies started during this time range. </p>', 'ListInsightsAnyStatusFilter$StartTimeRange' => '<p> A time range used to specify when the behavior of the filtered insights started. </p>', 'SearchInsightsRequest$StartTimeRange' => '<p> The start of the time range passed in. Returned insights occurred after this time. </p>', 'SearchOrganizationInsightsRequest$StartTimeRange' => NULL, ], ], 'TagCollection' => [ 'base' => '<p>A collection of Amazon Web Services stags.</p> <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p> <p>Each Amazon Web Services tag has two parts. </p> <ul> <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li> <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li> </ul> <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', 'refs' => [ 'TagCollections$member' => NULL, ], ], 'TagCollectionFilter' => [ 'base' => '<p>A collection of Amazon Web Services tags used to filter insights. This is used to return insights generated from only resources that contain the tags in the tag collection.</p>', 'refs' => [ 'TagCollectionFilters$member' => NULL, ], ], 'TagCollectionFilters' => [ 'base' => NULL, 'refs' => [ 'ResourceCollectionFilter$Tags' => '<p>The Amazon Web Services tags used to filter the resources in the resource collection.</p> <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p> <p>Each Amazon Web Services tag has two parts. </p> <ul> <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li> <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li> </ul> <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', ], ], 'TagCollections' => [ 'base' => NULL, 'refs' => [ 'ResourceCollection$Tags' => '<p>The Amazon Web Services tags that are used by resources in the resource collection.</p> <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p> <p>Each Amazon Web Services tag has two parts. </p> <ul> <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li> <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li> </ul> <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', ], ], 'TagCostEstimationResourceCollectionFilter' => [ 'base' => '<p>Information about a collection of Amazon Web Services resources that are identified by an Amazon Web Services tag. This collection of resources is used to create a monthly cost estimate for DevOps Guru to analyze Amazon Web Services resources. The maximum number of tags you can specify for a cost estimate is one. The estimate created is for the cost to analyze the Amazon Web Services resources defined by the tag. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html">Stacks</a> in the <i>Amazon Web Services CloudFormation User Guide</i>.</p>', 'refs' => [ 'TagCostEstimationResourceCollectionFilters$member' => NULL, ], ], 'TagCostEstimationResourceCollectionFilters' => [ 'base' => NULL, 'refs' => [ 'CostEstimationResourceCollectionFilter$Tags' => '<p>The Amazon Web Services tags used to filter the resource collection that is used for a cost estimate.</p> <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p> <p>Each Amazon Web Services tag has two parts. </p> <ul> <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li> <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li> </ul> <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', ], ], 'TagHealth' => [ 'base' => '<p> Information about the health of Amazon Web Services resources in your account that are specified by an Amazon Web Services tag <i>key</i>. </p>', 'refs' => [ 'TagHealths$member' => NULL, ], ], 'TagHealths' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResourceCollectionHealthResponse$Tags' => '<p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p> <p>Each Amazon Web Services tag has two parts. </p> <ul> <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li> <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li> </ul> <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', 'DescribeResourceCollectionHealthResponse$Tags' => '<p>The Amazon Web Services tags that are used by resources in the resource collection.</p> <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p> <p>Each Amazon Web Services tag has two parts. </p> <ul> <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li> <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li> </ul> <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'CostEstimationTagValues$member' => NULL, 'TagHealth$TagValue' => '<p>The value in an Amazon Web Services tag.</p> <p>The tag\'s <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag\'s <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>', 'TagValues$member' => NULL, 'UpdateTagValues$member' => NULL, ], ], 'TagValues' => [ 'base' => NULL, 'refs' => [ 'TagCollection$TagValues' => '<p>The values in an Amazon Web Services tag collection.</p> <p>The tag\'s <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag\'s <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>', 'TagCollectionFilter$TagValues' => '<p>The values in an Amazon Web Services tag collection.</p> <p>The tag\'s <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag\'s <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to a request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AnomalyReportedTimeRange$OpenTime' => '<p> The time when an anomaly is opened. </p>', 'AnomalyReportedTimeRange$CloseTime' => '<p> The time when an anomaly is closed. </p>', 'AnomalyTimeRange$StartTime' => '<p> The time when the anomalous behavior started. </p>', 'AnomalyTimeRange$EndTime' => '<p> The time when the anomalous behavior ended. </p>', 'CostEstimationTimeRange$StartTime' => '<p>The start time of the cost estimation.</p>', 'CostEstimationTimeRange$EndTime' => '<p>The end time of the cost estimation.</p>', 'DescribeAccountOverviewRequest$FromTime' => '<p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>', 'DescribeAccountOverviewRequest$ToTime' => '<p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>', 'DescribeOrganizationOverviewRequest$FromTime' => '<p> The start of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred after this day. </p>', 'DescribeOrganizationOverviewRequest$ToTime' => '<p> The end of the time range passed in. The start time granularity is at the day level. The floor of the start time is used. Returned information occurred before this day. If this is not specified, then the current day is used. </p>', 'EndTimeRange$FromTime' => '<p> The earliest end time in the time range. </p>', 'EndTimeRange$ToTime' => '<p> The latest end time in the time range. </p>', 'Event$Time' => '<p> A <code>Timestamp</code> that specifies the time the event occurred. </p>', 'EventTimeRange$FromTime' => '<p> The time when the event started. </p>', 'EventTimeRange$ToTime' => '<p> The time when the event ended. </p>', 'InsightTimeRange$StartTime' => '<p> The time when the behavior described in an insight started. </p>', 'InsightTimeRange$EndTime' => '<p> The time when the behavior described in an insight ended. </p>', 'PredictionTimeRange$StartTime' => '<p> The time range during which a metric limit is expected to be exceeded. This applies to proactive insights only. </p>', 'PredictionTimeRange$EndTime' => '<p> The time when the behavior in a proactive insight is expected to end. </p>', 'ProactiveAnomaly$UpdateTime' => '<p> The time of the anomaly\'s most recent update. </p>', 'ProactiveAnomalySummary$UpdateTime' => '<p> The time of the anomaly\'s most recent update. </p>', 'StartTimeRange$FromTime' => '<p> The start time of the time range. </p>', 'StartTimeRange$ToTime' => '<p> The end time of the time range. </p>', 'TimestampMetricValuePair$Timestamp' => '<p>A <code>Timestamp</code> that specifies the time the event occurred. </p>', ], ], 'TimestampMetricValuePair' => [ 'base' => '<p>A pair that contains metric values at the respective timestamp.</p>', 'refs' => [ 'TimestampMetricValuePairList$member' => NULL, ], ], 'TimestampMetricValuePairList' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMetricsDataSummary$TimestampMetricValuePairList' => '<p>This is a list of Amazon CloudWatch metric values at given timestamp.</p>', ], ], 'TopicArn' => [ 'base' => NULL, 'refs' => [ 'SnsChannelConfig$TopicArn' => '<p> The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic. </p>', ], ], 'UpdateCloudFormationCollectionFilter' => [ 'base' => '<p> Contains the names of Amazon Web Services CloudFormation stacks used to update a collection of stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks.</p>', 'refs' => [ 'UpdateResourceCollectionFilter$CloudFormation' => '<p> A collection of Amazon Web Services CloudFormation stacks. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', ], ], 'UpdateResourceCollectionAction' => [ 'base' => NULL, 'refs' => [ 'UpdateResourceCollectionRequest$Action' => '<p> Specifies if the resource collection in the request is added or deleted to the resource collection. </p>', ], ], 'UpdateResourceCollectionFilter' => [ 'base' => '<p> Contains information used to update a collection of Amazon Web Services resources. </p>', 'refs' => [ 'UpdateResourceCollectionRequest$ResourceCollection' => NULL, ], ], 'UpdateResourceCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceIntegrationConfig' => [ 'base' => '<p> Information about updating the integration status of an Amazon Web Services service, such as Amazon Web Services Systems Manager, with DevOps Guru. </p>', 'refs' => [ 'UpdateServiceIntegrationRequest$ServiceIntegration' => '<p> An <code>IntegratedServiceConfig</code> object used to specify the integrated service you want to update, and whether you want to update it to enabled or disabled. </p>', ], ], 'UpdateServiceIntegrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceIntegrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStackNames' => [ 'base' => NULL, 'refs' => [ 'UpdateCloudFormationCollectionFilter$StackNames' => '<p> An array of the names of the Amazon Web Services CloudFormation stacks to update. You can specify up to 500 Amazon Web Services CloudFormation stacks. </p>', ], ], 'UpdateTagCollectionFilter' => [ 'base' => '<p>A new collection of Amazon Web Services resources that are defined by an Amazon Web Services tag or tag <i>key</i>/<i>value</i> pair.</p>', 'refs' => [ 'UpdateTagCollectionFilters$member' => NULL, ], ], 'UpdateTagCollectionFilters' => [ 'base' => NULL, 'refs' => [ 'UpdateResourceCollectionFilter$Tags' => '<p>The updated Amazon Web Services tags used to filter the resources in the resource collection.</p> <p>Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an Lambda function. For more information about using tags, see the <a href="https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf">Tagging best practices</a> whitepaper. </p> <p>Each Amazon Web Services tag has two parts. </p> <ul> <li> <p>A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.</p> </li> <li> <p>An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.</p> </li> </ul> <p>Together these are known as <i>key</i>-<i>value</i> pairs.</p> <important> <p>The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>Devops-guru-deployment-application</code> or <code>Devops-guru-rds-application</code>. While <i>keys</i> are case-sensitive, the case of <i>key</i> characters don\'t matter to DevOps Guru. For example, DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>. Possible <i>key</i>/<i>value</i> pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>.</p> </important>', ], ], 'UpdateTagValues' => [ 'base' => NULL, 'refs' => [ 'UpdateTagCollectionFilter$TagValues' => '<p>The values in an Amazon Web Services tag collection.</p> <p>The tag\'s <i>value</i> is an optional field used to associate a string with the tag <i>key</i> (for example, <code>111122223333</code>, <code>Production</code>, or a team name). The <i>key</i> and <i>value</i> are the tag\'s <i>key</i> pair. Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive. You can specify a maximum of 256 characters for a tag value.</p>', ], ], 'UuidNextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeOrganizationResourceCollectionHealthRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeOrganizationResourceCollectionHealthResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'DescribeResourceCollectionHealthRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'DescribeResourceCollectionHealthResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'GetCostEstimationRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'GetCostEstimationResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'GetResourceCollectionRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'GetResourceCollectionResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListAnomaliesForInsightRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListAnomaliesForInsightResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListEventsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListEventsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListInsightsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListInsightsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListNotificationChannelsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListNotificationChannelsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListOrganizationInsightsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListOrganizationInsightsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'ListRecommendationsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'ListRecommendationsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'SearchInsightsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'SearchInsightsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', 'SearchOrganizationInsightsRequest$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If this value is null, it retrieves the first page.</p>', 'SearchOrganizationInsightsResponse$NextToken' => '<p>The pagination token to use to retrieve the next page of results for this operation. If there are no more pages, this value is null.</p>', ], ], 'ValidationException' => [ 'base' => '<p> Contains information about data passed in to a field during a request that is not valid. </p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p> The field associated with the validation exception. </p>', 'refs' => [ 'ValidationExceptionFields$member' => NULL, ], ], 'ValidationExceptionFields' => [ 'base' => '<p> An array of fields that are associated with the validation exception. </p>', 'refs' => [ 'ValidationException$Fields' => NULL, ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p> The reason the validation exception was thrown. </p>', ], ], ],];
