<?php
// This file was auto-generated from sdk-root/src/data/wellarchitected/2020-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Well-Architected Tool</fullname> <p>This is the <i>Well-Architected Tool API Reference</i>. The WA Tool API provides programmatic access to the <a href="http://aws.amazon.com/well-architected-tool">Well-Architected Tool</a> in the <a href="https://console.aws.amazon.com/wellarchitected">Amazon Web Services Management Console</a>. For information about the Well-Architected Tool, see the <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/intro.html">Well-Architected Tool User Guide</a>.</p>', 'operations' => [ 'AssociateLenses' => '<p>Associate a lens to a workload.</p> <p>Up to 10 lenses can be associated with a workload in a single API operation. A maximum of 20 lenses can be associated with a workload.</p> <note> <p> <b>Disclaimer</b> </p> <p>By accessing and/or applying custom lenses created by another Amazon Web Services user or account, you acknowledge that custom lenses created by other users and shared with you are Third Party Content as defined in the Amazon Web Services Customer Agreement. </p> </note>', 'CreateLensShare' => '<p>Create a lens share.</p> <p>The owner of a lens can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a lens is not removed until the lens invitation is deleted.</p> <note> <p> <b>Disclaimer</b> </p> <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p> </note>', 'CreateLensVersion' => '<p>Create a new lens version.</p> <p>A lens can have up to 100 versions.</p> <p>After a lens has been imported, create a new lens version to publish it. The owner of a lens can share the lens with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a lens can delete it. </p>', 'CreateMilestone' => '<p>Create a milestone for an existing workload.</p>', 'CreateWorkload' => '<p>Create a new workload.</p> <p>The owner of a workload can share the workload with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Only the owner of a workload can delete it.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/define-workload.html">Defining a Workload</a> in the <i>Well-Architected Tool User Guide</i>.</p>', 'CreateWorkloadShare' => '<p>Create a workload share.</p> <p>The owner of a workload can share it with other Amazon Web Services accounts and IAM users in the same Amazon Web Services Region. Shared access to a workload is not removed until the workload invitation is deleted.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/workloads-sharing.html">Sharing a Workload</a> in the <i>Well-Architected Tool User Guide</i>.</p>', 'DeleteLens' => '<p>Delete an existing lens.</p> <p>Only the owner of a lens can delete it. After the lens is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads. </p> <note> <p> <b>Disclaimer</b> </p> <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p> </note>', 'DeleteLensShare' => '<p>Delete a lens share.</p> <p>After the lens share is deleted, Amazon Web Services accounts and IAM users that you shared the lens with can continue to use it, but they will no longer be able to apply it to new workloads.</p> <note> <p> <b>Disclaimer</b> </p> <p>By sharing your custom lenses with other Amazon Web Services accounts, you acknowledge that Amazon Web Services will make your custom lenses available to those other accounts. Those other accounts may continue to access and use your shared custom lenses even if you delete the custom lenses from your own Amazon Web Services account or terminate your Amazon Web Services account.</p> </note>', 'DeleteWorkload' => '<p>Delete an existing workload.</p>', 'DeleteWorkloadShare' => '<p>Delete a workload share.</p>', 'DisassociateLenses' => '<p>Disassociate a lens from a workload.</p> <p>Up to 10 lenses can be disassociated from a workload in a single API operation.</p> <note> <p>The Amazon Web Services Well-Architected Framework lens (<code>wellarchitected</code>) cannot be removed from a workload.</p> </note>', 'ExportLens' => '<p>Export an existing lens.</p> <p>Lenses are defined in JSON. For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format specification</a> in the <i>Well-Architected Tool User Guide</i>. Only the owner of a lens can export it. </p> <note> <p> <b>Disclaimer</b> </p> <p>Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.</p> </note>', 'GetAnswer' => '<p>Get the answer to a specific question in a workload review.</p>', 'GetLens' => '<p>Get an existing lens.</p>', 'GetLensReview' => '<p>Get lens review.</p>', 'GetLensReviewReport' => '<p>Get lens review report.</p>', 'GetLensVersionDifference' => '<p>Get lens version differences.</p>', 'GetMilestone' => '<p>Get a milestone for an existing workload.</p>', 'GetWorkload' => '<p>Get an existing workload.</p>', 'ImportLens' => '<p>Import a new lens.</p> <p>The lens cannot be applied to workloads or shared with other Amazon Web Services accounts until it\'s published with <a>CreateLensVersion</a> </p> <p>Lenses are defined in JSON. For more information, see <a href="https://docs.aws.amazon.com/wellarchitected/latest/userguide/lenses-format-specification.html">JSON format specification</a> in the <i>Well-Architected Tool User Guide</i>.</p> <p>A custom lens cannot exceed 500 KB in size.</p> <note> <p> <b>Disclaimer</b> </p> <p>Do not include or gather personal identifiable information (PII) of end users or other identifiable individuals in or via your custom lenses. If your custom lens or those shared with you and used in your account do include or collect PII you are responsible for: ensuring that the included PII is processed in accordance with applicable law, providing adequate privacy notices, and obtaining necessary consents for processing such data.</p> </note>', 'ListAnswers' => '<p>List of answers.</p>', 'ListLensReviewImprovements' => '<p>List lens review improvements.</p>', 'ListLensReviews' => '<p>List lens reviews.</p>', 'ListLensShares' => '<p>List the lens shares associated with the lens.</p>', 'ListLenses' => '<p>List the available lenses.</p>', 'ListMilestones' => '<p>List all milestones for an existing workload.</p>', 'ListNotifications' => '<p>List lens notifications.</p>', 'ListShareInvitations' => '<p>List the workload invitations.</p>', 'ListTagsForResource' => '<p>List the tags for a resource.</p> <note> <p>The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.</p> </note>', 'ListWorkloadShares' => '<p>List the workload shares associated with the workload.</p>', 'ListWorkloads' => '<p>List workloads. Paginated.</p>', 'TagResource' => '<p>Adds one or more tags to the specified resource.</p> <note> <p>The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.</p> </note>', 'UntagResource' => '<p>Deletes specified tags from a resource.</p> <note> <p>The WorkloadArn parameter can be either a workload ARN or a custom lens ARN.</p> </note> <p>To specify multiple tags, use separate <b>tagKeys</b> parameters, for example:</p> <p> <code>DELETE /tags/WorkloadArn?tagKeys=key1&amp;tagKeys=key2</code> </p>', 'UpdateAnswer' => '<p>Update the answer to a specific question in a workload review.</p>', 'UpdateGlobalSettings' => '<p>Updates whether the Amazon Web Services account is opted into organization sharing features.</p>', 'UpdateLensReview' => '<p>Update lens review.</p>', 'UpdateShareInvitation' => '<p>Update a workload invitation.</p>', 'UpdateWorkload' => '<p>Update an existing workload.</p>', 'UpdateWorkloadShare' => '<p>Update a workload share.</p>', 'UpgradeLensReview' => '<p>Upgrade lens review.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>User does not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AdditionalResourceType' => [ 'base' => NULL, 'refs' => [ 'AdditionalResources$Type' => '<p>Type of additional resource.</p>', ], ], 'AdditionalResources' => [ 'base' => '<p>The choice level additional resources.</p>', 'refs' => [ 'AdditionalResourcesList$member' => NULL, ], ], 'AdditionalResourcesList' => [ 'base' => NULL, 'refs' => [ 'Choice$AdditionalResources' => '<p>The additional resources for a choice. A choice can have up to two additional resources: one of type <code>HELPFUL_RESOURCE</code>, one of type <code>IMPROVEMENT_PLAN</code>, or both.</p>', ], ], 'Answer' => [ 'base' => '<p>An answer of the question.</p>', 'refs' => [ 'GetAnswerOutput$Answer' => NULL, 'UpdateAnswerOutput$Answer' => NULL, ], ], 'AnswerReason' => [ 'base' => NULL, 'refs' => [ 'Answer$Reason' => '<p>The reason why the question is not applicable to your workload.</p>', 'AnswerSummary$Reason' => '<p>The reason why a choice is non-applicable to a question in your workload.</p>', 'UpdateAnswerInput$Reason' => '<p>The reason why a question is not applicable to your workload.</p>', ], ], 'AnswerSummaries' => [ 'base' => '<p>List of answer summaries of lens review in a workload.</p>', 'refs' => [ 'ListAnswersOutput$AnswerSummaries' => NULL, ], ], 'AnswerSummary' => [ 'base' => '<p>An answer summary of a lens review in a workload.</p>', 'refs' => [ 'AnswerSummaries$member' => NULL, ], ], 'AssociateLensesInput' => [ 'base' => '<p>Input to associate lens reviews.</p>', 'refs' => [], ], 'AwsAccountId' => [ 'base' => '<p>An Amazon Web Services account ID.</p>', 'refs' => [ 'LensSummary$Owner' => NULL, 'ShareInvitationSummary$SharedBy' => NULL, 'Workload$Owner' => NULL, 'WorkloadAccountIds$member' => NULL, 'WorkloadShare$SharedBy' => NULL, 'WorkloadSummary$Owner' => NULL, ], ], 'AwsRegion' => [ 'base' => '<p>An Amazon Web Services Region, for example, <code>us-west-2</code> or <code>ap-northeast-1</code>.</p>', 'refs' => [ 'WorkloadAwsRegions$member' => NULL, ], ], 'Base64String' => [ 'base' => '<p>The Base64-encoded string representation of a lens review report.</p> <p>This data can be used to create a PDF file.</p>', 'refs' => [ 'LensReviewReport$Base64String' => NULL, ], ], 'Choice' => [ 'base' => '<p>A choice available to answer question.</p>', 'refs' => [ 'Choices$member' => NULL, ], ], 'ChoiceAnswer' => [ 'base' => '<p>A choice that has been answered on a question in your workload.</p>', 'refs' => [ 'ChoiceAnswers$member' => NULL, ], ], 'ChoiceAnswerSummaries' => [ 'base' => NULL, 'refs' => [ 'AnswerSummary$ChoiceAnswerSummaries' => '<p>A list of selected choices to a question in your workload.</p>', ], ], 'ChoiceAnswerSummary' => [ 'base' => '<p>A choice summary that has been answered on a question in your workload.</p>', 'refs' => [ 'ChoiceAnswerSummaries$member' => NULL, ], ], 'ChoiceAnswers' => [ 'base' => NULL, 'refs' => [ 'Answer$ChoiceAnswers' => '<p>A list of selected choices to a question in your workload.</p>', ], ], 'ChoiceContent' => [ 'base' => '<p>The choice content.</p>', 'refs' => [ 'Choice$HelpfulResource' => '<p>The choice level helpful resource.</p>', 'Choice$ImprovementPlan' => '<p>The choice level improvement plan.</p>', 'Urls$member' => NULL, ], ], 'ChoiceContentDisplayText' => [ 'base' => NULL, 'refs' => [ 'ChoiceContent$DisplayText' => '<p>The display text for the choice content.</p>', ], ], 'ChoiceContentUrl' => [ 'base' => NULL, 'refs' => [ 'ChoiceContent$Url' => '<p>The URL for the choice content.</p>', ], ], 'ChoiceDescription' => [ 'base' => '<p>The description of a choice.</p>', 'refs' => [ 'Choice$Description' => NULL, ], ], 'ChoiceId' => [ 'base' => '<p>The ID of a choice.</p>', 'refs' => [ 'Choice$ChoiceId' => NULL, 'ChoiceAnswer$ChoiceId' => NULL, 'ChoiceAnswerSummary$ChoiceId' => NULL, 'ChoiceImprovementPlan$ChoiceId' => NULL, 'ChoiceUpdates$key' => NULL, 'SelectedChoices$member' => NULL, ], ], 'ChoiceImprovementPlan' => [ 'base' => '<p>The choice level improvement plan.</p>', 'refs' => [ 'ChoiceImprovementPlans$member' => NULL, ], ], 'ChoiceImprovementPlans' => [ 'base' => NULL, 'refs' => [ 'ImprovementSummary$ImprovementPlans' => '<p>The improvement plan details.</p>', ], ], 'ChoiceNotes' => [ 'base' => NULL, 'refs' => [ 'ChoiceAnswer$Notes' => '<p>The notes associated with a choice.</p>', 'ChoiceUpdate$Notes' => '<p>The notes associated with a choice.</p>', ], ], 'ChoiceReason' => [ 'base' => NULL, 'refs' => [ 'ChoiceAnswer$Reason' => '<p>The reason why a choice is non-applicable to a question in your workload.</p>', 'ChoiceAnswerSummary$Reason' => '<p>The reason why a choice is non-applicable to a question in your workload.</p>', 'ChoiceUpdate$Reason' => '<p>The reason why a choice is non-applicable to a question in your workload.</p>', ], ], 'ChoiceStatus' => [ 'base' => NULL, 'refs' => [ 'ChoiceAnswer$Status' => '<p>The status of a choice.</p>', 'ChoiceAnswerSummary$Status' => '<p>The status of a choice.</p>', 'ChoiceUpdate$Status' => '<p>The status of a choice.</p>', ], ], 'ChoiceTitle' => [ 'base' => '<p>The title of a choice.</p>', 'refs' => [ 'Choice$Title' => NULL, ], ], 'ChoiceUpdate' => [ 'base' => '<p>A list of choices to be updated.</p>', 'refs' => [ 'ChoiceUpdates$value' => NULL, ], ], 'ChoiceUpdates' => [ 'base' => NULL, 'refs' => [ 'UpdateAnswerInput$ChoiceUpdates' => '<p>A list of choices to update on a question in your workload. The String key corresponds to the choice ID to be updated.</p>', ], ], 'Choices' => [ 'base' => '<p>List of choices available for a question.</p>', 'refs' => [ 'Answer$Choices' => NULL, 'AnswerSummary$Choices' => NULL, ], ], 'ClientRequestToken' => [ 'base' => '<p>A unique case-sensitive string used to ensure that this request is idempotent (executes only once).</p> <p>You should not reuse the same token for other requests. If you retry a request with the same client request token and the same parameters after it has completed successfully, the result of the original request is returned. </p> <important> <p>This token is listed as required, however, if you do not specify it, the Amazon Web Services SDKs automatically generate one for you. If you are not using the Amazon Web Services SDK or the CLI, you must provide this token or the request will fail.</p> </important>', 'refs' => [ 'CreateLensShareInput$ClientRequestToken' => NULL, 'CreateLensVersionInput$ClientRequestToken' => NULL, 'CreateMilestoneInput$ClientRequestToken' => NULL, 'CreateWorkloadInput$ClientRequestToken' => NULL, 'CreateWorkloadShareInput$ClientRequestToken' => NULL, 'DeleteLensInput$ClientRequestToken' => NULL, 'DeleteLensShareInput$ClientRequestToken' => NULL, 'DeleteWorkloadInput$ClientRequestToken' => NULL, 'DeleteWorkloadShareInput$ClientRequestToken' => NULL, 'ImportLensInput$ClientRequestToken' => NULL, 'UpgradeLensReviewInput$ClientRequestToken' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>The resource already exists.</p>', 'refs' => [], ], 'Count' => [ 'base' => '<p>A non-negative integer that denotes how many.</p>', 'refs' => [ 'RiskCounts$value' => NULL, ], ], 'CreateLensShareInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLensShareOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLensVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateLensVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMilestoneInput' => [ 'base' => '<p>Input for milestone creation.</p>', 'refs' => [], ], 'CreateMilestoneOutput' => [ 'base' => '<p>Output of a create milestone call.</p>', 'refs' => [], ], 'CreateWorkloadInput' => [ 'base' => '<p>Input for workload creation.</p>', 'refs' => [], ], 'CreateWorkloadOutput' => [ 'base' => '<p>Output of a create workload call.</p>', 'refs' => [], ], 'CreateWorkloadShareInput' => [ 'base' => '<p>Input for Create Workload Share</p>', 'refs' => [], ], 'CreateWorkloadShareOutput' => [ 'base' => '<p>Input for Create Workload Share</p>', 'refs' => [], ], 'DeleteLensInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLensShareInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkloadInput' => [ 'base' => '<p>Input for workload deletion.</p>', 'refs' => [], ], 'DeleteWorkloadShareInput' => [ 'base' => '<p>Input for Delete Workload Share</p>', 'refs' => [], ], 'DifferenceStatus' => [ 'base' => NULL, 'refs' => [ 'PillarDifference$DifferenceStatus' => '<p>Indicates the type of change to the pillar.</p>', 'QuestionDifference$DifferenceStatus' => '<p>Indicates the type of change to the question.</p>', ], ], 'DisassociateLensesInput' => [ 'base' => '<p>Input to disassociate lens reviews.</p>', 'refs' => [], ], 'DisplayText' => [ 'base' => NULL, 'refs' => [ 'Answer$HelpfulResourceDisplayText' => '<p>The helpful resource text to be displayed.</p>', 'ChoiceImprovementPlan$DisplayText' => '<p>The display text for the improvement plan.</p>', ], ], 'ExceptionMessage' => [ 'base' => '<p>Description of the error.</p>', 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, 'ValidationExceptionField$Message' => NULL, ], ], 'ExceptionResourceId' => [ 'base' => '<p>Identifier of the resource affected.</p>', 'refs' => [ 'ConflictException$ResourceId' => NULL, 'ResourceNotFoundException$ResourceId' => NULL, 'ServiceQuotaExceededException$ResourceId' => NULL, ], ], 'ExceptionResourceType' => [ 'base' => '<p>Type of the resource affected.</p>', 'refs' => [ 'ConflictException$ResourceType' => NULL, 'ResourceNotFoundException$ResourceType' => NULL, 'ServiceQuotaExceededException$ResourceType' => NULL, ], ], 'ExportLensInput' => [ 'base' => NULL, 'refs' => [], ], 'ExportLensOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetAnswerInput' => [ 'base' => '<p>Input to get answer.</p>', 'refs' => [], ], 'GetAnswerOutput' => [ 'base' => '<p>Output of a get answer call.</p>', 'refs' => [], ], 'GetLensInput' => [ 'base' => NULL, 'refs' => [], ], 'GetLensOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetLensReviewInput' => [ 'base' => '<p>Input to get lens review.</p>', 'refs' => [], ], 'GetLensReviewOutput' => [ 'base' => '<p>Output of a get lens review call.</p>', 'refs' => [], ], 'GetLensReviewReportInput' => [ 'base' => '<p>Input to get lens review report.</p>', 'refs' => [], ], 'GetLensReviewReportOutput' => [ 'base' => '<p>Output of a get lens review report call.</p>', 'refs' => [], ], 'GetLensVersionDifferenceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetLensVersionDifferenceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMilestoneInput' => [ 'base' => '<p>Input to get a milestone.</p>', 'refs' => [], ], 'GetMilestoneOutput' => [ 'base' => '<p>Output of a get milestone call.</p>', 'refs' => [], ], 'GetWorkloadInput' => [ 'base' => '<p>Input to get a workload.</p>', 'refs' => [], ], 'GetWorkloadOutput' => [ 'base' => '<p>Output of a get workload call.</p>', 'refs' => [], ], 'HelpfulResourceUrl' => [ 'base' => '<p>The helpful resource URL for a question.</p>', 'refs' => [ 'Answer$HelpfulResourceUrl' => NULL, ], ], 'ImportLensInput' => [ 'base' => NULL, 'refs' => [], ], 'ImportLensOutput' => [ 'base' => NULL, 'refs' => [], ], 'ImportLensStatus' => [ 'base' => NULL, 'refs' => [ 'ImportLensOutput$Status' => '<p>The status of the imported lens.</p>', ], ], 'ImprovementPlanUrl' => [ 'base' => '<p>The improvement plan URL for a question.</p> <p>This value is only available if the question has been answered.</p>', 'refs' => [ 'Answer$ImprovementPlanUrl' => NULL, 'ChoiceImprovementPlan$ImprovementPlanUrl' => NULL, 'ImprovementSummary$ImprovementPlanUrl' => NULL, ], ], 'ImprovementSummaries' => [ 'base' => '<p>List of improvement summaries of lens review in a workload.</p>', 'refs' => [ 'ListLensReviewImprovementsOutput$ImprovementSummaries' => NULL, ], ], 'ImprovementSummary' => [ 'base' => '<p>An improvement summary of a lens review in a workload.</p>', 'refs' => [ 'ImprovementSummaries$member' => NULL, ], ], 'InternalServerException' => [ 'base' => '<p>There is a problem with the Well-Architected Tool API service.</p>', 'refs' => [], ], 'IsApplicable' => [ 'base' => '<p>Defines whether this question is applicable to a lens review.</p>', 'refs' => [ 'Answer$IsApplicable' => NULL, 'AnswerSummary$IsApplicable' => NULL, 'UpdateAnswerInput$IsApplicable' => NULL, ], ], 'IsMajorVersion' => [ 'base' => NULL, 'refs' => [ 'CreateLensVersionInput$IsMajorVersion' => '<p>Set to true if this new major lens version.</p>', ], ], 'IsReviewOwnerUpdateAcknowledged' => [ 'base' => NULL, 'refs' => [ 'UpdateWorkloadInput$IsReviewOwnerUpdateAcknowledged' => '<p>Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.</p> <p>If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.</p>', 'Workload$IsReviewOwnerUpdateAcknowledged' => '<p>Flag indicating whether the workload owner has acknowledged that the <i>Review owner</i> field is required.</p> <p>If a <b>Review owner</b> is not added to the workload within 60 days of acknowledgement, access to the workload is restricted until an owner is added.</p>', ], ], 'Lens' => [ 'base' => '<p>A lens return object.</p>', 'refs' => [ 'GetLensOutput$Lens' => '<p>A lens return object.</p>', ], ], 'LensAlias' => [ 'base' => '<p>The alias of the lens.</p> <p>For Amazon Web Services official lenses, this is either the lens alias, such as <code>serverless</code>, or the lens ARN, such as <code>arn:aws:wellarchitected:us-west-2::lens/serverless</code>.</p> <p>For custom lenses, this is the lens ARN, such as <code>arn:aws:wellarchitected:us-east-1:123456789012:lens/my-lens</code>. </p> <p>Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>', 'refs' => [ 'CreateLensShareInput$LensAlias' => NULL, 'CreateLensVersionInput$LensAlias' => NULL, 'DeleteLensInput$LensAlias' => NULL, 'DeleteLensShareInput$LensAlias' => NULL, 'ExportLensInput$LensAlias' => NULL, 'GetAnswerInput$LensAlias' => NULL, 'GetAnswerOutput$LensAlias' => NULL, 'GetLensInput$LensAlias' => NULL, 'GetLensReviewInput$LensAlias' => NULL, 'GetLensReviewReportInput$LensAlias' => NULL, 'GetLensVersionDifferenceInput$LensAlias' => NULL, 'GetLensVersionDifferenceOutput$LensAlias' => NULL, 'ImportLensInput$LensAlias' => NULL, 'LensAliases$member' => NULL, 'LensReview$LensAlias' => NULL, 'LensReviewReport$LensAlias' => NULL, 'LensReviewSummary$LensAlias' => NULL, 'LensSummary$LensAlias' => NULL, 'LensUpgradeSummary$LensAlias' => NULL, 'ListAnswersInput$LensAlias' => NULL, 'ListAnswersOutput$LensAlias' => NULL, 'ListLensReviewImprovementsInput$LensAlias' => NULL, 'ListLensReviewImprovementsOutput$LensAlias' => NULL, 'ListLensSharesInput$LensAlias' => NULL, 'ShareInvitation$LensAlias' => NULL, 'UpdateAnswerInput$LensAlias' => NULL, 'UpdateAnswerOutput$LensAlias' => NULL, 'UpdateLensReviewInput$LensAlias' => NULL, 'UpgradeLensReviewInput$LensAlias' => NULL, 'WorkloadLenses$member' => NULL, ], ], 'LensAliases' => [ 'base' => '<p>List of lens aliases to associate or disassociate with a workload. Up to 10 lenses can be specified.</p> <p>Identify a lens using its <a>LensSummary$LensAlias</a>.</p>', 'refs' => [ 'AssociateLensesInput$LensAliases' => NULL, 'DisassociateLensesInput$LensAliases' => NULL, ], ], 'LensArn' => [ 'base' => NULL, 'refs' => [ 'CreateLensVersionOutput$LensArn' => '<p>The ARN for the lens.</p>', 'GetAnswerOutput$LensArn' => '<p>The ARN for the lens.</p>', 'GetLensVersionDifferenceOutput$LensArn' => '<p>The ARN for the lens.</p>', 'ImportLensOutput$LensArn' => '<p>The ARN for the lens.</p>', 'Lens$LensArn' => '<p>The ARN of a lens.</p>', 'LensReview$LensArn' => '<p>The ARN for the lens.</p>', 'LensReviewReport$LensArn' => '<p>The ARN for the lens.</p>', 'LensReviewSummary$LensArn' => '<p>The ARN for the lens.</p>', 'LensSummary$LensArn' => '<p>The ARN of the lens.</p>', 'LensUpgradeSummary$LensArn' => '<p>The ARN for the lens.</p>', 'ListAnswersOutput$LensArn' => '<p>The ARN for the lens.</p>', 'ListLensReviewImprovementsOutput$LensArn' => '<p>The ARN for the lens.</p>', 'ShareInvitation$LensArn' => '<p>The ARN for the lens.</p>', 'ShareInvitationSummary$LensArn' => '<p>The ARN for the lens.</p>', 'UpdateAnswerOutput$LensArn' => '<p>The ARN for the lens.</p>', ], ], 'LensDescription' => [ 'base' => '<p>The description of the lens.</p>', 'refs' => [ 'Lens$Description' => NULL, 'LensSummary$Description' => NULL, ], ], 'LensJSON' => [ 'base' => NULL, 'refs' => [ 'ExportLensOutput$LensJSON' => '<p>The JSON for the lens.</p>', 'ImportLensInput$JSONString' => '<p>The JSON representation of a lens.</p>', ], ], 'LensName' => [ 'base' => '<p>The full name of the lens.</p>', 'refs' => [ 'Lens$Name' => NULL, 'LensReview$LensName' => NULL, 'LensReviewSummary$LensName' => NULL, 'LensSummary$LensName' => NULL, 'ListLensesInput$LensName' => NULL, 'ShareInvitationSummary$LensName' => NULL, ], ], 'LensNamePrefix' => [ 'base' => NULL, 'refs' => [ 'ListShareInvitationsInput$LensNamePrefix' => '<p>An optional string added to the beginning of each lens name returned in the results.</p>', ], ], 'LensOwner' => [ 'base' => NULL, 'refs' => [ 'Lens$Owner' => '<p>The Amazon Web Services account ID that owns the lens.</p>', ], ], 'LensReview' => [ 'base' => '<p>A lens review of a question.</p>', 'refs' => [ 'GetLensReviewOutput$LensReview' => NULL, 'UpdateLensReviewOutput$LensReview' => NULL, ], ], 'LensReviewReport' => [ 'base' => '<p>A report of a lens review.</p>', 'refs' => [ 'GetLensReviewReportOutput$LensReviewReport' => NULL, ], ], 'LensReviewSummaries' => [ 'base' => '<p>List of lens summaries of lens reviews of a workload.</p>', 'refs' => [ 'ListLensReviewsOutput$LensReviewSummaries' => NULL, ], ], 'LensReviewSummary' => [ 'base' => '<p>A lens review summary of a workload.</p>', 'refs' => [ 'LensReviewSummaries$member' => NULL, ], ], 'LensShareSummaries' => [ 'base' => NULL, 'refs' => [ 'ListLensSharesOutput$LensShareSummaries' => '<p>A list of lens share summaries.</p>', ], ], 'LensShareSummary' => [ 'base' => '<p>A lens share summary return object.</p>', 'refs' => [ 'LensShareSummaries$member' => NULL, ], ], 'LensStatus' => [ 'base' => NULL, 'refs' => [ 'LensReview$LensStatus' => '<p>The status of the lens.</p>', 'LensReviewSummary$LensStatus' => '<p>The status of the lens.</p>', 'LensSummary$LensStatus' => '<p>The status of the lens.</p>', ], ], 'LensStatusType' => [ 'base' => NULL, 'refs' => [ 'DeleteLensInput$LensStatus' => '<p>The status of the lens to be deleted.</p>', 'ListLensesInput$LensStatus' => '<p>The status of lenses to be returned.</p>', ], ], 'LensSummaries' => [ 'base' => '<p>List of lens summaries of available lenses.</p>', 'refs' => [ 'ListLensesOutput$LensSummaries' => NULL, ], ], 'LensSummary' => [ 'base' => '<p>A lens summary of a lens.</p>', 'refs' => [ 'LensSummaries$member' => NULL, ], ], 'LensType' => [ 'base' => NULL, 'refs' => [ 'LensSummary$LensType' => '<p>The type of the lens.</p>', 'ListLensesInput$LensType' => '<p>The type of lenses to be returned.</p>', ], ], 'LensUpgradeSummary' => [ 'base' => '<p>Lens upgrade summary return object.</p>', 'refs' => [ 'NotificationSummary$LensUpgradeSummary' => '<p>Summary of lens upgrade.</p>', ], ], 'LensVersion' => [ 'base' => NULL, 'refs' => [ 'CreateLensVersionInput$LensVersion' => '<p>The version of the lens being created.</p>', 'CreateLensVersionOutput$LensVersion' => '<p>The version of the lens.</p>', 'ExportLensInput$LensVersion' => '<p>The lens version to be exported.</p>', 'GetLensInput$LensVersion' => '<p>The lens version to be retrieved.</p>', 'GetLensVersionDifferenceInput$BaseLensVersion' => '<p>The base version of the lens.</p>', 'GetLensVersionDifferenceInput$TargetLensVersion' => '<p>The lens version to target a difference for.</p>', 'GetLensVersionDifferenceOutput$BaseLensVersion' => '<p>The base version of the lens.</p>', 'GetLensVersionDifferenceOutput$TargetLensVersion' => '<p>The target lens version for the lens.</p>', 'GetLensVersionDifferenceOutput$LatestLensVersion' => '<p>The latest version of the lens.</p>', 'Lens$LensVersion' => '<p>The version of a lens.</p>', 'LensReview$LensVersion' => '<p>The version of the lens.</p>', 'LensReviewSummary$LensVersion' => '<p>The version of the lens.</p>', 'LensSummary$LensVersion' => '<p>The version of the lens.</p>', 'LensUpgradeSummary$CurrentLensVersion' => '<p>The current version of the lens.</p>', 'LensUpgradeSummary$LatestLensVersion' => '<p>The latest version of the lens.</p>', ], ], 'ListAnswersInput' => [ 'base' => '<p>Input to list answers.</p>', 'refs' => [], ], 'ListAnswersMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAnswersInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListAnswersOutput' => [ 'base' => '<p>Output of a list answers call.</p>', 'refs' => [], ], 'ListLensReviewImprovementsInput' => [ 'base' => '<p>Input to list lens review improvements.</p>', 'refs' => [], ], 'ListLensReviewImprovementsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListLensReviewImprovementsInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListLensReviewImprovementsOutput' => [ 'base' => '<p>Output of a list lens review improvements call.</p>', 'refs' => [], ], 'ListLensReviewsInput' => [ 'base' => '<p>Input to list lens reviews.</p>', 'refs' => [], ], 'ListLensReviewsOutput' => [ 'base' => '<p>Output of a list lens reviews call.</p>', 'refs' => [], ], 'ListLensSharesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListLensSharesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListLensesInput' => [ 'base' => '<p>Input to list lenses.</p>', 'refs' => [], ], 'ListLensesOutput' => [ 'base' => '<p>Output of a list lenses call.</p>', 'refs' => [], ], 'ListMilestonesInput' => [ 'base' => '<p>Input to list all milestones for a workload.</p>', 'refs' => [], ], 'ListMilestonesOutput' => [ 'base' => '<p>Output of a list milestones call.</p>', 'refs' => [], ], 'ListNotificationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotificationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListNotificationsInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListNotificationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListShareInvitationsInput' => [ 'base' => '<p>Input for List Share Invitations</p>', 'refs' => [], ], 'ListShareInvitationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListShareInvitationsInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListShareInvitationsOutput' => [ 'base' => '<p>Input for List Share Invitations</p>', 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkloadSharesInput' => [ 'base' => '<p>Input for List Workload Share</p>', 'refs' => [], ], 'ListWorkloadSharesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListLensSharesInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', 'ListWorkloadSharesInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListWorkloadSharesOutput' => [ 'base' => '<p>Input for List Workload Share</p>', 'refs' => [], ], 'ListWorkloadsInput' => [ 'base' => '<p>Input to list all workloads.</p>', 'refs' => [], ], 'ListWorkloadsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListWorkloadsInput$MaxResults' => '<p>The maximum number of results to return for this request.</p>', ], ], 'ListWorkloadsOutput' => [ 'base' => '<p>Output of a list workloads call.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => '<p>The maximum number of results to return for this request.</p>', 'refs' => [ 'ListLensReviewsInput$MaxResults' => NULL, 'ListLensesInput$MaxResults' => NULL, 'ListMilestonesInput$MaxResults' => NULL, ], ], 'Milestone' => [ 'base' => '<p>A milestone return object.</p>', 'refs' => [ 'GetMilestoneOutput$Milestone' => NULL, ], ], 'MilestoneName' => [ 'base' => '<p>The name of the milestone in a workload.</p> <p>Milestone names must be unique within a workload.</p>', 'refs' => [ 'CreateMilestoneInput$MilestoneName' => NULL, 'Milestone$MilestoneName' => NULL, 'MilestoneSummary$MilestoneName' => NULL, 'UpgradeLensReviewInput$MilestoneName' => NULL, ], ], 'MilestoneNumber' => [ 'base' => '<p>The milestone number.</p> <p>A workload can have a maximum of 100 milestones.</p>', 'refs' => [ 'CreateMilestoneOutput$MilestoneNumber' => NULL, 'GetAnswerInput$MilestoneNumber' => NULL, 'GetAnswerOutput$MilestoneNumber' => NULL, 'GetLensReviewInput$MilestoneNumber' => NULL, 'GetLensReviewOutput$MilestoneNumber' => NULL, 'GetLensReviewReportInput$MilestoneNumber' => NULL, 'GetLensReviewReportOutput$MilestoneNumber' => NULL, 'GetMilestoneInput$MilestoneNumber' => NULL, 'ListAnswersInput$MilestoneNumber' => NULL, 'ListAnswersOutput$MilestoneNumber' => NULL, 'ListLensReviewImprovementsInput$MilestoneNumber' => NULL, 'ListLensReviewImprovementsOutput$MilestoneNumber' => NULL, 'ListLensReviewsInput$MilestoneNumber' => NULL, 'ListLensReviewsOutput$MilestoneNumber' => NULL, 'Milestone$MilestoneNumber' => NULL, 'MilestoneSummary$MilestoneNumber' => NULL, ], ], 'MilestoneSummaries' => [ 'base' => '<p>A list of milestone summaries.</p>', 'refs' => [ 'ListMilestonesOutput$MilestoneSummaries' => NULL, ], ], 'MilestoneSummary' => [ 'base' => '<p>A milestone summary return object.</p>', 'refs' => [ 'MilestoneSummaries$member' => NULL, ], ], 'NextToken' => [ 'base' => '<p>The token to use to retrieve the next set of results.</p>', 'refs' => [ 'LensReview$NextToken' => NULL, 'ListAnswersInput$NextToken' => NULL, 'ListAnswersOutput$NextToken' => NULL, 'ListLensReviewImprovementsInput$NextToken' => NULL, 'ListLensReviewImprovementsOutput$NextToken' => NULL, 'ListLensReviewsInput$NextToken' => NULL, 'ListLensReviewsOutput$NextToken' => NULL, 'ListLensSharesInput$NextToken' => NULL, 'ListLensSharesOutput$NextToken' => NULL, 'ListLensesInput$NextToken' => NULL, 'ListLensesOutput$NextToken' => NULL, 'ListMilestonesInput$NextToken' => NULL, 'ListMilestonesOutput$NextToken' => NULL, 'ListNotificationsInput$NextToken' => NULL, 'ListNotificationsOutput$NextToken' => NULL, 'ListShareInvitationsInput$NextToken' => NULL, 'ListShareInvitationsOutput$NextToken' => NULL, 'ListWorkloadSharesInput$NextToken' => NULL, 'ListWorkloadSharesOutput$NextToken' => NULL, 'ListWorkloadsInput$NextToken' => NULL, 'ListWorkloadsOutput$NextToken' => NULL, ], ], 'Notes' => [ 'base' => '<p>The notes associated with the workload.</p>', 'refs' => [ 'Answer$Notes' => NULL, 'CreateWorkloadInput$Notes' => NULL, 'LensReview$Notes' => NULL, 'PillarNotes$value' => NULL, 'PillarReviewSummary$Notes' => NULL, 'UpdateAnswerInput$Notes' => NULL, 'UpdateLensReviewInput$LensNotes' => NULL, 'UpdateWorkloadInput$Notes' => NULL, 'Workload$Notes' => NULL, ], ], 'NotificationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListNotificationsOutput$NotificationSummaries' => '<p>List of lens notification summaries in a workload.</p>', ], ], 'NotificationSummary' => [ 'base' => '<p>A notification summary return object.</p>', 'refs' => [ 'NotificationSummaries$member' => NULL, ], ], 'NotificationType' => [ 'base' => NULL, 'refs' => [ 'NotificationSummary$Type' => '<p>The type of notification.</p>', ], ], 'OrganizationSharingStatus' => [ 'base' => NULL, 'refs' => [ 'UpdateGlobalSettingsInput$OrganizationSharingStatus' => '<p>The status of organization sharing settings.</p>', ], ], 'PermissionType' => [ 'base' => '<p>Permission granted on a workload share.</p>', 'refs' => [ 'CreateWorkloadShareInput$PermissionType' => NULL, 'ShareInvitationSummary$PermissionType' => NULL, 'UpdateWorkloadShareInput$PermissionType' => NULL, 'WorkloadShare$PermissionType' => NULL, 'WorkloadShareSummary$PermissionType' => NULL, ], ], 'PillarDifference' => [ 'base' => '<p>A pillar difference return object.</p>', 'refs' => [ 'PillarDifferences$member' => NULL, ], ], 'PillarDifferences' => [ 'base' => NULL, 'refs' => [ 'VersionDifferences$PillarDifferences' => '<p>The differences between the base and latest versions of the lens.</p>', ], ], 'PillarId' => [ 'base' => '<p>The ID used to identify a pillar, for example, <code>security</code>.</p> <p>A pillar is identified by its <a>PillarReviewSummary$PillarId</a>.</p>', 'refs' => [ 'Answer$PillarId' => NULL, 'AnswerSummary$PillarId' => NULL, 'ImprovementSummary$PillarId' => NULL, 'ListAnswersInput$PillarId' => NULL, 'ListLensReviewImprovementsInput$PillarId' => NULL, 'PillarDifference$PillarId' => NULL, 'PillarNotes$key' => NULL, 'PillarReviewSummary$PillarId' => NULL, 'WorkloadPillarPriorities$member' => NULL, ], ], 'PillarName' => [ 'base' => '<p>The name of the pillar.</p>', 'refs' => [ 'PillarDifference$PillarName' => NULL, 'PillarReviewSummary$PillarName' => NULL, ], ], 'PillarNotes' => [ 'base' => '<p>List of pillar notes of a lens review in a workload.</p>', 'refs' => [ 'UpdateLensReviewInput$PillarNotes' => NULL, ], ], 'PillarReviewSummaries' => [ 'base' => '<p>List of pillar review summaries of lens review in a workload.</p>', 'refs' => [ 'LensReview$PillarReviewSummaries' => NULL, ], ], 'PillarReviewSummary' => [ 'base' => '<p>A pillar review summary of a lens review.</p>', 'refs' => [ 'PillarReviewSummaries$member' => NULL, ], ], 'QuestionDescription' => [ 'base' => '<p>The description of the question.</p>', 'refs' => [ 'Answer$QuestionDescription' => NULL, ], ], 'QuestionDifference' => [ 'base' => '<p>A question difference return object.</p>', 'refs' => [ 'QuestionDifferences$member' => NULL, ], ], 'QuestionDifferences' => [ 'base' => NULL, 'refs' => [ 'PillarDifference$QuestionDifferences' => '<p>List of question differences.</p>', ], ], 'QuestionId' => [ 'base' => '<p>The ID of the question.</p>', 'refs' => [ 'Answer$QuestionId' => NULL, 'AnswerSummary$QuestionId' => NULL, 'GetAnswerInput$QuestionId' => NULL, 'ImprovementSummary$QuestionId' => NULL, 'QuestionDifference$QuestionId' => NULL, 'UpdateAnswerInput$QuestionId' => NULL, ], ], 'QuestionTitle' => [ 'base' => '<p>The title of the question.</p>', 'refs' => [ 'Answer$QuestionTitle' => NULL, 'AnswerSummary$QuestionTitle' => NULL, 'ImprovementSummary$QuestionTitle' => NULL, 'QuestionDifference$QuestionTitle' => NULL, ], ], 'QuotaCode' => [ 'base' => '<p>Service Quotas requirement to identify originating quota.</p>', 'refs' => [ 'ServiceQuotaExceededException$QuotaCode' => NULL, 'ThrottlingException$QuotaCode' => NULL, ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource was not found.</p>', 'refs' => [], ], 'Risk' => [ 'base' => '<p>The risk for a given workload, lens review, pillar, or question.</p>', 'refs' => [ 'Answer$Risk' => NULL, 'AnswerSummary$Risk' => NULL, 'ImprovementSummary$Risk' => NULL, 'RiskCounts$key' => NULL, ], ], 'RiskCounts' => [ 'base' => '<p>A map from risk names to the count of how questions have that rating.</p>', 'refs' => [ 'LensReview$RiskCounts' => NULL, 'LensReviewSummary$RiskCounts' => NULL, 'PillarReviewSummary$RiskCounts' => NULL, 'Workload$RiskCounts' => NULL, 'WorkloadSummary$RiskCounts' => NULL, ], ], 'SelectedChoices' => [ 'base' => '<p>List of selected choice IDs in a question answer.</p> <p>The values entered replace the previously selected choices.</p>', 'refs' => [ 'Answer$SelectedChoices' => NULL, 'AnswerSummary$SelectedChoices' => NULL, 'UpdateAnswerInput$SelectedChoices' => NULL, ], ], 'ServiceCode' => [ 'base' => '<p>Service Quotas requirement to identify originating service.</p>', 'refs' => [ 'ServiceQuotaExceededException$ServiceCode' => NULL, 'ThrottlingException$ServiceCode' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The user has reached their resource quota.</p>', 'refs' => [], ], 'ShareId' => [ 'base' => '<p>The ID associated with the workload share.</p>', 'refs' => [ 'CreateLensShareOutput$ShareId' => NULL, 'CreateWorkloadShareOutput$ShareId' => NULL, 'DeleteLensShareInput$ShareId' => NULL, 'DeleteWorkloadShareInput$ShareId' => NULL, 'LensShareSummary$ShareId' => NULL, 'UpdateWorkloadShareInput$ShareId' => NULL, 'WorkloadShare$ShareId' => NULL, 'WorkloadShareSummary$ShareId' => NULL, ], ], 'ShareInvitation' => [ 'base' => '<p>The share invitation.</p>', 'refs' => [ 'UpdateShareInvitationOutput$ShareInvitation' => '<p>The updated workload share invitation.</p>', ], ], 'ShareInvitationAction' => [ 'base' => '<p>Share invitation action taken by contributor.</p>', 'refs' => [ 'UpdateShareInvitationInput$ShareInvitationAction' => NULL, ], ], 'ShareInvitationId' => [ 'base' => NULL, 'refs' => [ 'Lens$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', 'ShareInvitation$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', 'ShareInvitationSummary$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', 'UpdateShareInvitationInput$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', 'Workload$ShareInvitationId' => '<p>The ID assigned to the share invitation.</p>', ], ], 'ShareInvitationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListShareInvitationsOutput$ShareInvitationSummaries' => '<p>List of share invitation summaries in a workload.</p>', ], ], 'ShareInvitationSummary' => [ 'base' => '<p>A share invitation summary return object.</p>', 'refs' => [ 'ShareInvitationSummaries$member' => NULL, ], ], 'ShareResourceType' => [ 'base' => NULL, 'refs' => [ 'ListShareInvitationsInput$ShareResourceType' => '<p>The type of share invitations to be returned.</p>', 'ShareInvitation$ShareResourceType' => '<p>The resource type of the share invitation.</p>', 'ShareInvitationSummary$ShareResourceType' => '<p>The resource type of the share invitation.</p>', ], ], 'ShareStatus' => [ 'base' => '<p>The status of a workload share.</p>', 'refs' => [ 'LensShareSummary$Status' => NULL, 'ListLensSharesInput$Status' => NULL, 'ListWorkloadSharesInput$Status' => NULL, 'WorkloadShare$Status' => NULL, 'WorkloadShareSummary$Status' => NULL, ], ], 'SharedWith' => [ 'base' => '<p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>', 'refs' => [ 'CreateLensShareInput$SharedWith' => NULL, 'CreateWorkloadShareInput$SharedWith' => NULL, 'LensShareSummary$SharedWith' => NULL, 'ShareInvitationSummary$SharedWith' => NULL, 'WorkloadShare$SharedWith' => NULL, 'WorkloadShareSummary$SharedWith' => NULL, ], ], 'SharedWithPrefix' => [ 'base' => NULL, 'refs' => [ 'ListLensSharesInput$SharedWithPrefix' => '<p>The Amazon Web Services account ID or IAM role with which the lens is shared.</p>', 'ListWorkloadSharesInput$SharedWithPrefix' => '<p>The Amazon Web Services account ID or IAM role with which the workload is shared.</p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'LensShareSummary$StatusMessage' => '<p>Optional message to compliment the Status field.</p>', 'WorkloadShareSummary$StatusMessage' => '<p>Optional message to compliment the Status field.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>A list of tag keys. Existing tags of the resource whose keys are members of this list are removed from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateWorkloadInput$Tags' => '<p>The tags to be associated with the workload.</p>', 'ImportLensInput$Tags' => '<p>Tags to associate to a lens.</p>', 'Lens$Tags' => '<p>The tags assigned to the lens.</p>', 'ListTagsForResourceOutput$Tags' => '<p>The tags for the resource.</p>', 'TagResourceInput$Tags' => '<p>The tags for the resource.</p>', 'Workload$Tags' => '<p>The tags associated with the workload.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>Request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => '<p>The date and time recorded.</p>', 'refs' => [ 'LensReview$UpdatedAt' => NULL, 'LensReviewSummary$UpdatedAt' => NULL, 'LensSummary$CreatedAt' => NULL, 'LensSummary$UpdatedAt' => NULL, 'Milestone$RecordedAt' => NULL, 'MilestoneSummary$RecordedAt' => NULL, 'Workload$UpdatedAt' => NULL, 'Workload$ReviewRestrictionDate' => NULL, 'WorkloadSummary$UpdatedAt' => NULL, ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAnswerInput' => [ 'base' => '<p>Input to update answer.</p>', 'refs' => [], ], 'UpdateAnswerOutput' => [ 'base' => '<p>Output of a update answer call.</p>', 'refs' => [], ], 'UpdateGlobalSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLensReviewInput' => [ 'base' => '<p>Input for update lens review.</p>', 'refs' => [], ], 'UpdateLensReviewOutput' => [ 'base' => '<p>Output of a update lens review call.</p>', 'refs' => [], ], 'UpdateShareInvitationInput' => [ 'base' => '<p>Input for Update Share Invitation</p>', 'refs' => [], ], 'UpdateShareInvitationOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkloadInput' => [ 'base' => '<p>Input to update a workload.</p>', 'refs' => [], ], 'UpdateWorkloadOutput' => [ 'base' => '<p>Output of an update workload call.</p>', 'refs' => [], ], 'UpdateWorkloadShareInput' => [ 'base' => '<p>Input for Update Workload Share</p>', 'refs' => [], ], 'UpdateWorkloadShareOutput' => [ 'base' => '<p>Input for Update Workload Share</p>', 'refs' => [], ], 'UpgradeLensReviewInput' => [ 'base' => NULL, 'refs' => [], ], 'Urls' => [ 'base' => NULL, 'refs' => [ 'AdditionalResources$Content' => '<p>The URLs for additional resources, either helpful resources or improvement plans. Up to five additional URLs can be specified.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The user input is not valid.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Stores information about a field passed inside a request that resulted in an exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => '<p>The fields that caused the error, if applicable.</p>', 'refs' => [ 'ValidationException$Fields' => NULL, ], ], 'ValidationExceptionFieldName' => [ 'base' => '<p>The field name for which validation failed.</p>', 'refs' => [ 'ValidationExceptionField$Name' => NULL, ], ], 'ValidationExceptionReason' => [ 'base' => '<p>The reason why the request failed validation.</p>', 'refs' => [ 'ValidationException$Reason' => NULL, ], ], 'VersionDifferences' => [ 'base' => '<p>The differences between the base and latest versions of the lens.</p>', 'refs' => [ 'GetLensVersionDifferenceOutput$VersionDifferences' => NULL, ], ], 'Workload' => [ 'base' => '<p>A workload return object.</p>', 'refs' => [ 'GetWorkloadOutput$Workload' => NULL, 'Milestone$Workload' => NULL, 'UpdateWorkloadOutput$Workload' => NULL, ], ], 'WorkloadAccountIds' => [ 'base' => '<p>The list of Amazon Web Services account IDs associated with the workload.</p>', 'refs' => [ 'CreateWorkloadInput$AccountIds' => NULL, 'UpdateWorkloadInput$AccountIds' => NULL, 'Workload$AccountIds' => NULL, ], ], 'WorkloadArchitecturalDesign' => [ 'base' => '<p>The URL of the architectural design for the workload.</p>', 'refs' => [ 'CreateWorkloadInput$ArchitecturalDesign' => NULL, 'UpdateWorkloadInput$ArchitecturalDesign' => NULL, 'Workload$ArchitecturalDesign' => NULL, ], ], 'WorkloadArn' => [ 'base' => '<p>The ARN for the workload.</p>', 'refs' => [ 'CreateWorkloadOutput$WorkloadArn' => NULL, 'ListTagsForResourceInput$WorkloadArn' => NULL, 'TagResourceInput$WorkloadArn' => NULL, 'UntagResourceInput$WorkloadArn' => NULL, 'Workload$WorkloadArn' => NULL, 'WorkloadSummary$WorkloadArn' => NULL, ], ], 'WorkloadAwsRegions' => [ 'base' => '<p>The list of Amazon Web Services Regions associated with the workload, for example, <code>us-east-2</code>, or <code>ca-central-1</code>.</p>', 'refs' => [ 'CreateWorkloadInput$AwsRegions' => NULL, 'UpdateWorkloadInput$AwsRegions' => NULL, 'Workload$AwsRegions' => NULL, ], ], 'WorkloadDescription' => [ 'base' => '<p>The description for the workload.</p>', 'refs' => [ 'CreateWorkloadInput$Description' => NULL, 'UpdateWorkloadInput$Description' => NULL, 'Workload$Description' => NULL, ], ], 'WorkloadEnvironment' => [ 'base' => '<p>The environment for the workload.</p>', 'refs' => [ 'CreateWorkloadInput$Environment' => NULL, 'UpdateWorkloadInput$Environment' => NULL, 'Workload$Environment' => NULL, ], ], 'WorkloadId' => [ 'base' => '<p>The ID assigned to the workload. This ID is unique within an Amazon Web Services Region.</p>', 'refs' => [ 'AssociateLensesInput$WorkloadId' => NULL, 'CreateMilestoneInput$WorkloadId' => NULL, 'CreateMilestoneOutput$WorkloadId' => NULL, 'CreateWorkloadOutput$WorkloadId' => NULL, 'CreateWorkloadShareInput$WorkloadId' => NULL, 'CreateWorkloadShareOutput$WorkloadId' => NULL, 'DeleteWorkloadInput$WorkloadId' => NULL, 'DeleteWorkloadShareInput$WorkloadId' => NULL, 'DisassociateLensesInput$WorkloadId' => NULL, 'GetAnswerInput$WorkloadId' => NULL, 'GetAnswerOutput$WorkloadId' => NULL, 'GetLensReviewInput$WorkloadId' => NULL, 'GetLensReviewOutput$WorkloadId' => NULL, 'GetLensReviewReportInput$WorkloadId' => NULL, 'GetLensReviewReportOutput$WorkloadId' => NULL, 'GetMilestoneInput$WorkloadId' => NULL, 'GetMilestoneOutput$WorkloadId' => NULL, 'GetWorkloadInput$WorkloadId' => NULL, 'LensUpgradeSummary$WorkloadId' => NULL, 'ListAnswersInput$WorkloadId' => NULL, 'ListAnswersOutput$WorkloadId' => NULL, 'ListLensReviewImprovementsInput$WorkloadId' => NULL, 'ListLensReviewImprovementsOutput$WorkloadId' => NULL, 'ListLensReviewsInput$WorkloadId' => NULL, 'ListLensReviewsOutput$WorkloadId' => NULL, 'ListMilestonesInput$WorkloadId' => NULL, 'ListMilestonesOutput$WorkloadId' => NULL, 'ListNotificationsInput$WorkloadId' => NULL, 'ListWorkloadSharesInput$WorkloadId' => NULL, 'ListWorkloadSharesOutput$WorkloadId' => NULL, 'ShareInvitation$WorkloadId' => NULL, 'ShareInvitationSummary$WorkloadId' => NULL, 'UpdateAnswerInput$WorkloadId' => NULL, 'UpdateAnswerOutput$WorkloadId' => NULL, 'UpdateLensReviewInput$WorkloadId' => NULL, 'UpdateLensReviewOutput$WorkloadId' => NULL, 'UpdateWorkloadInput$WorkloadId' => NULL, 'UpdateWorkloadShareInput$WorkloadId' => NULL, 'UpdateWorkloadShareOutput$WorkloadId' => NULL, 'UpgradeLensReviewInput$WorkloadId' => NULL, 'Workload$WorkloadId' => NULL, 'WorkloadShare$WorkloadId' => NULL, 'WorkloadSummary$WorkloadId' => NULL, ], ], 'WorkloadImprovementStatus' => [ 'base' => '<p>The improvement status for a workload.</p>', 'refs' => [ 'UpdateWorkloadInput$ImprovementStatus' => NULL, 'Workload$ImprovementStatus' => NULL, 'WorkloadSummary$ImprovementStatus' => NULL, ], ], 'WorkloadIndustry' => [ 'base' => '<p>The industry for the workload.</p>', 'refs' => [ 'CreateWorkloadInput$Industry' => NULL, 'UpdateWorkloadInput$Industry' => NULL, 'Workload$Industry' => NULL, ], ], 'WorkloadIndustryType' => [ 'base' => '<p>The industry type for the workload.</p> <p>If specified, must be one of the following:</p> <ul> <li> <p> <code>Agriculture</code> </p> </li> <li> <p> <code>Automobile</code> </p> </li> <li> <p> <code>Defense</code> </p> </li> <li> <p> <code>Design and Engineering</code> </p> </li> <li> <p> <code>Digital Advertising</code> </p> </li> <li> <p> <code>Education</code> </p> </li> <li> <p> <code>Environmental Protection</code> </p> </li> <li> <p> <code>Financial Services</code> </p> </li> <li> <p> <code>Gaming</code> </p> </li> <li> <p> <code>General Public Services</code> </p> </li> <li> <p> <code>Healthcare</code> </p> </li> <li> <p> <code>Hospitality</code> </p> </li> <li> <p> <code>InfoTech</code> </p> </li> <li> <p> <code>Justice and Public Safety</code> </p> </li> <li> <p> <code>Life Sciences</code> </p> </li> <li> <p> <code>Manufacturing</code> </p> </li> <li> <p> <code>Media &amp; Entertainment</code> </p> </li> <li> <p> <code>Mining &amp; Resources</code> </p> </li> <li> <p> <code>Oil &amp; Gas</code> </p> </li> <li> <p> <code>Power &amp; Utilities</code> </p> </li> <li> <p> <code>Professional Services</code> </p> </li> <li> <p> <code>Real Estate &amp; Construction</code> </p> </li> <li> <p> <code>Retail &amp; Wholesale</code> </p> </li> <li> <p> <code>Social Protection</code> </p> </li> <li> <p> <code>Telecommunications</code> </p> </li> <li> <p> <code>Travel, Transportation &amp; Logistics</code> </p> </li> <li> <p> <code>Other</code> </p> </li> </ul>', 'refs' => [ 'CreateWorkloadInput$IndustryType' => NULL, 'UpdateWorkloadInput$IndustryType' => NULL, 'Workload$IndustryType' => NULL, ], ], 'WorkloadLenses' => [ 'base' => '<p>The list of lenses associated with the workload. Each lens is identified by its <a>LensSummary$LensAlias</a>.</p>', 'refs' => [ 'CreateWorkloadInput$Lenses' => NULL, 'Workload$Lenses' => NULL, 'WorkloadSummary$Lenses' => NULL, ], ], 'WorkloadName' => [ 'base' => '<p>The name of the workload.</p> <p>The name must be unique within an account within an Amazon Web Services Region. Spaces and capitalization are ignored when checking for uniqueness.</p>', 'refs' => [ 'CreateWorkloadInput$WorkloadName' => NULL, 'LensUpgradeSummary$WorkloadName' => NULL, 'ShareInvitationSummary$WorkloadName' => NULL, 'UpdateWorkloadInput$WorkloadName' => NULL, 'Workload$WorkloadName' => NULL, 'WorkloadShare$WorkloadName' => NULL, 'WorkloadSummary$WorkloadName' => NULL, ], ], 'WorkloadNamePrefix' => [ 'base' => '<p>An optional string added to the beginning of each workload name returned in the results.</p>', 'refs' => [ 'ListShareInvitationsInput$WorkloadNamePrefix' => NULL, 'ListWorkloadsInput$WorkloadNamePrefix' => NULL, ], ], 'WorkloadNonAwsRegion' => [ 'base' => NULL, 'refs' => [ 'WorkloadNonAwsRegions$member' => NULL, ], ], 'WorkloadNonAwsRegions' => [ 'base' => '<p> The list of non-Amazon Web Services Regions associated with the workload.</p>', 'refs' => [ 'CreateWorkloadInput$NonAwsRegions' => NULL, 'UpdateWorkloadInput$NonAwsRegions' => NULL, 'Workload$NonAwsRegions' => NULL, ], ], 'WorkloadPillarPriorities' => [ 'base' => '<p>The priorities of the pillars, which are used to order items in the improvement plan. Each pillar is represented by its <a>PillarReviewSummary$PillarId</a>.</p>', 'refs' => [ 'CreateWorkloadInput$PillarPriorities' => NULL, 'UpdateWorkloadInput$PillarPriorities' => NULL, 'Workload$PillarPriorities' => NULL, ], ], 'WorkloadReviewOwner' => [ 'base' => '<p>The review owner of the workload. The name, email address, or identifier for the primary group or individual that owns the workload review process.</p>', 'refs' => [ 'CreateWorkloadInput$ReviewOwner' => NULL, 'UpdateWorkloadInput$ReviewOwner' => NULL, 'Workload$ReviewOwner' => NULL, ], ], 'WorkloadShare' => [ 'base' => '<p>A workload share return object.</p>', 'refs' => [ 'UpdateWorkloadShareOutput$WorkloadShare' => NULL, ], ], 'WorkloadShareSummaries' => [ 'base' => '<p>A list of workload share summaries.</p>', 'refs' => [ 'ListWorkloadSharesOutput$WorkloadShareSummaries' => NULL, ], ], 'WorkloadShareSummary' => [ 'base' => '<p>A workload share summary return object.</p>', 'refs' => [ 'WorkloadShareSummaries$member' => NULL, ], ], 'WorkloadSummaries' => [ 'base' => '<p>A list of workload summaries.</p>', 'refs' => [ 'ListWorkloadsOutput$WorkloadSummaries' => NULL, ], ], 'WorkloadSummary' => [ 'base' => '<p>A workload summary return object.</p>', 'refs' => [ 'MilestoneSummary$WorkloadSummary' => NULL, 'WorkloadSummaries$member' => NULL, ], ], ],];
