<?php
// This file was auto-generated from sdk-root/src/data/resource-groups/2017-11-27/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>AWS Resource Groups</fullname> <p>AWS Resource Groups lets you organize AWS resources such as Amazon EC2 instances, Amazon Relational Database Service databases, and Amazon S3 buckets into groups using criteria that you define as tags. A resource group is a collection of resources that match the resource types specified in a query, and share one or more tags or portions of tags. You can create a group of resources based on their roles in your cloud infrastructure, lifecycle stages, regions, application layers, or virtually any criteria. Resource Groups enable you to automate management tasks, such as those in AWS Systems Manager Automation documents, on tag-related resources in AWS Systems Manager. Groups of tagged resources also let you quickly view a custom console in AWS Systems Manager that shows AWS Config compliance and other monitoring data about member resources.</p> <p>To create a resource group, build a resource query, and specify tags that identify the criteria that members of the group have in common. Tags are key-value pairs.</p> <p>For more information about Resource Groups, see the <a href="https://docs.aws.amazon.com/ARG/latest/userguide/welcome.html">AWS Resource Groups User Guide</a>.</p> <p>AWS Resource Groups uses a REST-compliant API that you can use to perform the following types of operations.</p> <ul> <li> <p>Create, Read, Update, and Delete (CRUD) operations on resource groups and resource query entities</p> </li> <li> <p>Applying, editing, and removing tags from resource groups</p> </li> <li> <p>Resolving resource group member ARNs so they can be returned as search results</p> </li> <li> <p>Getting data about resources that are members of a group</p> </li> <li> <p>Searching AWS resources based on a resource query</p> </li> </ul>', 'operations' => [ 'CreateGroup' => '<p>Creates a resource group with the specified name and description. You can optionally include a resource query, or a service configuration. For more information about constructing a resource query, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>. For more information about service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:CreateGroup</code> </p> </li> </ul>', 'DeleteGroup' => '<p>Deletes the specified resource group. Deleting a resource group does not delete any resources that are members of the group; it only deletes the group structure.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:DeleteGroup</code> </p> </li> </ul>', 'GetGroup' => '<p>Returns information about a specified resource group.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:GetGroup</code> </p> </li> </ul>', 'GetGroupConfiguration' => '<p>Returns the service configuration associated with the specified resource group. For details about the service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:GetGroupConfiguration</code> </p> </li> </ul>', 'GetGroupQuery' => '<p>Retrieves the resource query associated with the specified resource group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:GetGroupQuery</code> </p> </li> </ul>', 'GetTags' => '<p>Returns a list of tags that are associated with a resource group, specified by an ARN.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:GetTags</code> </p> </li> </ul>', 'GroupResources' => '<p>Adds the specified resources to the specified group.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:GroupResources</code> </p> </li> </ul>', 'ListGroupResources' => '<p>Returns a list of ARNs of the resources that are members of a specified resource group.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:ListGroupResources</code> </p> </li> <li> <p> <code>cloudformation:DescribeStacks</code> </p> </li> <li> <p> <code>cloudformation:ListStackResources</code> </p> </li> <li> <p> <code>tag:GetResources</code> </p> </li> </ul>', 'ListGroups' => '<p>Returns a list of existing resource groups in your account.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:ListGroups</code> </p> </li> </ul>', 'PutGroupConfiguration' => '<p>Attaches a service configuration to the specified group. This occurs asynchronously, and can take time to complete. You can use <a>GetGroupConfiguration</a> to check the status of the update.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:PutGroupConfiguration</code> </p> </li> </ul>', 'SearchResources' => '<p>Returns a list of AWS resource identifiers that matches the specified query. The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery operation.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:SearchResources</code> </p> </li> <li> <p> <code>cloudformation:DescribeStacks</code> </p> </li> <li> <p> <code>cloudformation:ListStackResources</code> </p> </li> <li> <p> <code>tag:GetResources</code> </p> </li> </ul>', 'Tag' => '<p>Adds tags to a resource group with the specified ARN. Existing tags on a resource group are not changed if they are not specified in the request parameters.</p> <important> <p>Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.</p> </important> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:Tag</code> </p> </li> </ul>', 'UngroupResources' => '<p>Removes the specified resources from the specified group.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:UngroupResources</code> </p> </li> </ul>', 'Untag' => '<p>Deletes tags from a specified resource group.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:Untag</code> </p> </li> </ul>', 'UpdateGroup' => '<p>Updates the description for an existing group. You cannot update the name of a resource group.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:UpdateGroup</code> </p> </li> </ul>', 'UpdateGroupQuery' => '<p>Updates the resource query of a group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>.</p> <p> <b>Minimum permissions</b> </p> <p>To run this command, you must have the following permissions:</p> <ul> <li> <p> <code>resource-groups:UpdateGroupQuery</code> </p> </li> </ul>', ], 'shapes' => [ 'BadRequestException' => [ 'base' => '<p>The request includes one or more parameters that violate validation rules.</p>', 'refs' => [], ], 'CreateGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateGroupInput$Description' => '<p>The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores, periods, and spaces.</p>', 'Group$Description' => '<p>The description of the resource group.</p>', 'UpdateGroupInput$Description' => '<p>The new description that you want to update the resource group with. Descriptions can contain letters, numbers, hyphens, underscores, periods, and spaces.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'FailedResource$ErrorCode' => '<p>The error code associated with the failure.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'FailedResource$ErrorMessage' => '<p>The error message text associated with the failure.</p>', 'ForbiddenException$Message' => NULL, 'InternalServerErrorException$Message' => NULL, 'MethodNotAllowedException$Message' => NULL, 'NotFoundException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'UnauthorizedException$Message' => NULL, ], ], 'FailedResource' => [ 'base' => '<p>A resource that failed to be added to or removed from a group.</p>', 'refs' => [ 'FailedResourceList$member' => NULL, ], ], 'FailedResourceList' => [ 'base' => NULL, 'refs' => [ 'GroupResourcesOutput$Failed' => '<p>A list of ARNs of any resources that failed to be added to the group by this operation.</p>', 'UngroupResourcesOutput$Failed' => '<p>A list of any resources that failed to be removed from the group by this operation.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>The caller isn\'t authorized to make the request. Check permissions.</p>', 'refs' => [], ], 'GetGroupConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTagsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTagsOutput' => [ 'base' => NULL, 'refs' => [], ], 'Group' => [ 'base' => '<p>A resource group that contains AWS resources. You can assign resources to the group by associating either of the following elements with the group:</p> <ul> <li> <p> <a>ResourceQuery</a> - Use a resource query to specify a set of tag keys and values. All resources in the same AWS Region and AWS account that have those keys with the same values are included in the group. You can add a resource query when you create the group, or later by using the <a>PutGroupConfiguration</a> operation.</p> </li> <li> <p> <a>GroupConfiguration</a> - Use a service configuration to associate the group with an AWS service. The configuration specifies which resource types can be included in the group.</p> </li> </ul>', 'refs' => [ 'CreateGroupOutput$Group' => '<p>The description of the resource group.</p>', 'DeleteGroupOutput$Group' => '<p>A full description of the deleted resource group.</p>', 'GetGroupOutput$Group' => '<p>A full description of the resource group.</p>', 'GroupList$member' => NULL, 'UpdateGroupOutput$Group' => '<p>The update description of the resource group.</p>', ], ], 'GroupArn' => [ 'base' => NULL, 'refs' => [ 'GetTagsInput$Arn' => '<p>The ARN of the resource group whose tags you want to retrieve.</p>', 'GetTagsOutput$Arn' => '<p>The ARN of the tagged resource group.</p>', 'Group$GroupArn' => '<p>The ARN of the resource group.</p>', 'GroupIdentifier$GroupArn' => '<p>The ARN of the resource group.</p>', 'TagInput$Arn' => '<p>The ARN of the resource group to which to add tags.</p>', 'TagOutput$Arn' => '<p>The ARN of the tagged resource.</p>', 'UntagInput$Arn' => '<p>The ARN of the resource group from which to remove tags. The command removed both the specified keys and any values associated with those keys.</p>', 'UntagOutput$Arn' => '<p>The ARN of the resource group from which tags have been removed.</p>', ], ], 'GroupConfiguration' => [ 'base' => '<p>A service configuration associated with a resource group. The configuration options are determined by the AWS service that defines the <code>Type</code>, and specifies which resources can be included in the group. You can add a service configuration when you create the group by using <a>CreateGroup</a>, or later by using the <a>PutGroupConfiguration</a> operation. For details about group service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p>', 'refs' => [ 'CreateGroupOutput$GroupConfiguration' => '<p>The service configuration associated with the resource group. For details about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p>', 'GetGroupConfigurationOutput$GroupConfiguration' => '<p>The service configuration associated with the specified group. For details about the service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p>', ], ], 'GroupConfigurationFailureReason' => [ 'base' => NULL, 'refs' => [ 'GroupConfiguration$FailureReason' => '<p>If present, the reason why a request to update the group configuration failed.</p>', ], ], 'GroupConfigurationItem' => [ 'base' => '<p>An item in a group configuration. A group service configuration can have one or more items. For details about group service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p>', 'refs' => [ 'GroupConfigurationList$member' => NULL, ], ], 'GroupConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateGroupInput$Configuration' => '<p>A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements. For details about the syntax of service configurations, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <note> <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p> </note>', 'GroupConfiguration$Configuration' => '<p>The configuration currently associated with the group and in effect.</p>', 'GroupConfiguration$ProposedConfiguration' => '<p>If present, the new configuration that is in the process of being applied to the group.</p>', 'PutGroupConfigurationInput$Configuration' => '<p>The new configuration to associate with the specified group. A configuration associates the resource group with an AWS service and specifies how the service can interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.</p> <p>For information about the syntax of a service configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p> <note> <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p> </note>', ], ], 'GroupConfigurationParameter' => [ 'base' => '<p>A parameter for a group configuration item. For details about group service configuration syntax, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource groups</a>.</p>', 'refs' => [ 'GroupParameterList$member' => NULL, ], ], 'GroupConfigurationParameterName' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationParameter$Name' => '<p>The name of the group configuration parameter. For the list of parameters that you can use with each configuration item type, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a>.</p>', ], ], 'GroupConfigurationParameterValue' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationParameterValueList$member' => NULL, ], ], 'GroupConfigurationParameterValueList' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationParameter$Values' => '<p>The value or values to be used for the specified parameter. For the list of values you can use with each parameter, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a>.</p>', ], ], 'GroupConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'GroupConfiguration$Status' => '<p>The current status of an attempt to update the group configuration.</p>', ], ], 'GroupConfigurationType' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationItem$Type' => '<p>Specifies the type of group configuration item. Each item must have a unique value for <code>type</code>. For the list of types that you can specify for a configuration item, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a>.</p>', ], ], 'GroupFilter' => [ 'base' => '<p>A filter collection that you can use to restrict the results from a <code>List</code> operation to only those you want to include.</p>', 'refs' => [ 'GroupFilterList$member' => NULL, ], ], 'GroupFilterList' => [ 'base' => NULL, 'refs' => [ 'ListGroupsInput$Filters' => '<p>Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to a <code>ListGroups</code> operation.</p> <ul> <li> <p> <code>resource-type</code> - Filter the results to include only those of the specified resource types. Specify up to five resource types in the format <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.</p> </li> <li> <p> <code>configuration-type</code> - Filter the results to include only those groups that have the specified configuration types attached. The current supported values are:</p> <ul> <li> <p> <code>AWS:EC2::CapacityReservationPool</code> </p> </li> <li> <p> <code>AWS:EC2::HostManagement</code> </p> </li> </ul> </li> </ul>', ], ], 'GroupFilterName' => [ 'base' => NULL, 'refs' => [ 'GroupFilter$Name' => '<p>The name of the filter. Filter names are case-sensitive.</p>', ], ], 'GroupFilterValue' => [ 'base' => NULL, 'refs' => [ 'GroupFilterValues$member' => NULL, ], ], 'GroupFilterValues' => [ 'base' => NULL, 'refs' => [ 'GroupFilter$Values' => '<p>One or more filter values. Allowed filter values vary by group filter name, and are case-sensitive.</p>', ], ], 'GroupIdentifier' => [ 'base' => '<p>The unique identifiers for a resource group.</p>', 'refs' => [ 'GroupIdentifierList$member' => NULL, ], ], 'GroupIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListGroupsOutput$GroupIdentifiers' => '<p>A list of <a>GroupIdentifier</a> objects. Each identifier is an object that contains both the <code>Name</code> and the <code>GroupArn</code>.</p>', ], ], 'GroupList' => [ 'base' => NULL, 'refs' => [ 'ListGroupsOutput$Groups' => '<important> <p> <i> <b>Deprecated - don\'t use this field. Use the <code>GroupIdentifiers</code> response field instead.</b> </i> </p> </important>', ], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupInput$Name' => '<p>The name of the group, which is the identifier of the group in other operations. You can\'t change the name of a resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and underscores. The name cannot start with <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name must be unique within each AWS Region in your AWS account.</p>', 'DeleteGroupInput$GroupName' => '<p>Deprecated - don\'t use this parameter. Use <code>Group</code> instead.</p>', 'GetGroupInput$GroupName' => '<p>Deprecated - don\'t use this parameter. Use <code>Group</code> instead.</p>', 'GetGroupQueryInput$GroupName' => '<p>Don\'t use this parameter. Use <code>Group</code> instead.</p>', 'Group$Name' => '<p>The name of the resource group.</p>', 'GroupIdentifier$GroupName' => '<p>The name of the resource group.</p>', 'GroupQuery$GroupName' => '<p>The name of the resource group that is associated with the specified resource query.</p>', 'ListGroupResourcesInput$GroupName' => '<important> <p> <i> <b>Deprecated - don\'t use this parameter. Use the <code>Group</code> request field instead.</b> </i> </p> </important>', 'UpdateGroupInput$GroupName' => '<p>Don\'t use this parameter. Use <code>Group</code> instead.</p>', 'UpdateGroupQueryInput$GroupName' => '<p>Don\'t use this parameter. Use <code>Group</code> instead.</p>', ], ], 'GroupParameterList' => [ 'base' => NULL, 'refs' => [ 'GroupConfigurationItem$Parameters' => '<p>A collection of parameters for this group configuration item. For the list of parameters that you can use with each configuration item type, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html#about-slg-types">Supported resource types and parameters</a>.</p>', ], ], 'GroupQuery' => [ 'base' => '<p>A mapping of a query attached to a resource group that determines the AWS resources that are members of the group.</p>', 'refs' => [ 'GetGroupQueryOutput$GroupQuery' => '<p>The resource query associated with the specified group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>.</p>', 'UpdateGroupQueryOutput$GroupQuery' => '<p>The updated resource query associated with the resource group after the update.</p>', ], ], 'GroupResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'GroupResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'GroupString' => [ 'base' => NULL, 'refs' => [ 'DeleteGroupInput$Group' => '<p>The name or the ARN of the resource group to delete.</p>', 'GetGroupConfigurationInput$Group' => '<p>The name or the ARN of the resource group.</p>', 'GetGroupInput$Group' => '<p>The name or the ARN of the resource group to retrieve.</p>', 'GetGroupQueryInput$Group' => '<p>The name or the ARN of the resource group to query.</p>', 'GroupResourcesInput$Group' => '<p>The name or the ARN of the resource group to add resources to.</p>', 'ListGroupResourcesInput$Group' => '<p>The name or the ARN of the resource group</p>', 'PutGroupConfigurationInput$Group' => '<p>The name or ARN of the resource group with the configuration that you want to update.</p>', 'UngroupResourcesInput$Group' => '<p>The name or the ARN of the resource group from which to remove the resources.</p>', 'UpdateGroupInput$Group' => '<p>The name or the ARN of the resource group to modify.</p>', 'UpdateGroupQueryInput$Group' => '<p>The name or the ARN of the resource group to query.</p>', ], ], 'InternalServerErrorException' => [ 'base' => '<p>An internal error occurred while processing the request. Try again later.</p>', 'refs' => [], ], 'ListGroupResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupResourcesItem' => [ 'base' => '<p>A structure returned by the <a>ListGroupResources</a> operation that contains identity and group membership status information for one of the resources in the group.</p>', 'refs' => [ 'ListGroupResourcesItemList$member' => NULL, ], ], 'ListGroupResourcesItemList' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesOutput$Resources' => '<p>An array of resources from which you can determine each resource\'s identity, type, and group membership status.</p>', ], ], 'ListGroupResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesInput$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListGroupsInput$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'SearchResourcesInput$MaxResults' => '<p>The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', ], ], 'MethodNotAllowedException' => [ 'base' => '<p>The request uses an HTTP method that isn\'t allowed for the specified resource.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesInput$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListGroupResourcesOutput$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListGroupsInput$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListGroupsOutput$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'SearchResourcesInput$NextToken' => '<p>The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value provided by a previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'SearchResourcesOutput$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>One or more of the specified resources don\'t exist.</p>', 'refs' => [], ], 'PendingResource' => [ 'base' => '<p>A structure that identifies a resource that is currently pending addition to the group as a member. Adding a resource to a resource group happens asynchronously as a background task and this one isn\'t completed yet.</p>', 'refs' => [ 'PendingResourceList$member' => NULL, ], ], 'PendingResourceList' => [ 'base' => NULL, 'refs' => [ 'GroupResourcesOutput$Pending' => '<p>A list of ARNs of any resources that are still in the process of being added to the group by this operation. These pending additions continue asynchronously. You can check the status of pending additions by using the <code> <a>ListGroupResources</a> </code> operation, and checking the <code>Resources</code> array in the response and the <code>Status</code> field of each object in that array. </p>', 'UngroupResourcesOutput$Pending' => '<p>A list of any resources that are still in the process of being removed from the group by this operation. These pending removals continue asynchronously. You can check the status of pending removals by using the <code> <a>ListGroupResources</a> </code> operation. After the resource is successfully removed, it no longer appears in the response.</p>', ], ], 'PutGroupConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'PutGroupConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'Query' => [ 'base' => NULL, 'refs' => [ 'ResourceQuery$Query' => '<p>The query that defines a group or a search.</p>', ], ], 'QueryError' => [ 'base' => '<p>A two-part error structure that can occur in <code>ListGroupResources</code> or <code>SearchResources</code> operations on CloudFormation stack-based queries. The error occurs if the CloudFormation stack on which the query is based either does not exist, or has a status that renders the stack inactive. A <code>QueryError</code> occurrence does not necessarily mean that AWS Resource Groups could not complete the operation, but the resulting group might have no member resources.</p>', 'refs' => [ 'QueryErrorList$member' => NULL, ], ], 'QueryErrorCode' => [ 'base' => NULL, 'refs' => [ 'QueryError$ErrorCode' => '<p>Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>', ], ], 'QueryErrorList' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesOutput$QueryErrors' => '<p>A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and <code>Message</code> structures. Possible values for <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>', 'SearchResourcesOutput$QueryErrors' => '<p>A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and <code>Message</code> structures. Possible values for <code>ErrorCode</code> are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.</p>', ], ], 'QueryErrorMessage' => [ 'base' => NULL, 'refs' => [ 'QueryError$Message' => '<p>A message that explains the <code>ErrorCode</code> value. Messages might state that the specified CloudFormation stack does not exist (or no longer exists). For <code>CLOUDFORMATION_STACK_INACTIVE</code>, the message typically states that the CloudFormation stack has a status that is not (or no longer) active, such as <code>CREATE_FAILED</code>.</p>', ], ], 'QueryType' => [ 'base' => NULL, 'refs' => [ 'ResourceQuery$Type' => '<p>The type of the query. You can use the following values:</p> <ul> <li> <p> <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i>Specifies that the <code>Query</code> contains an ARN for a CloudFormation stack.</p> </li> <li> <p> <i> <code>TAG_FILTERS_1_0:</code> </i>Specifies that the <code>Query</code> parameter contains a JSON string that represents a collection of simple tag filters for resource types and tags. The JSON string uses a syntax similar to the <code> <a href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html">GetResources</a> </code> operation, but uses only the <code> <a href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html#resourcegrouptagging-GetResources-request-ResourceTypeFilters"> ResourceTypeFilters</a> </code> and <code> <a href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html#resourcegrouptagging-GetResources-request-TagFiltersTagFilters">TagFilters</a> </code> fields. If you specify more than one tag key, only resources that match all tag keys, and at least one value of each specified tag key, are returned in your query. If you specify more than one value for a tag key, a resource matches the filter if it has a tag key value that matches <i>any</i> of the specified values.</p> <p>For example, consider the following sample query for resources that have two tags, <code>Stage</code> and <code>Version</code>, with two values each:</p> <p> <code>[{"Stage":["Test","Deploy"]},{"Version":["1","2"]}]</code> </p> <p>The results of this query could include the following.</p> <ul> <li> <p>An EC2 instance that has the following two tags: <code>{"Stage":"Deploy"}</code>, and <code>{"Version":"2"}</code> </p> </li> <li> <p>An S3 bucket that has the following two tags: <code>{"Stage":"Test"}</code>, and <code>{"Version":"1"}</code> </p> </li> </ul> <p>The query would not include the following items in the results, however. </p> <ul> <li> <p>An EC2 instance that has only the following tag: <code>{"Stage":"Deploy"}</code>.</p> <p>The instance does not have <b>all</b> of the tag keys specified in the filter, so it is excluded from the results.</p> </li> <li> <p>An RDS database that has the following two tags: <code>{"Stage":"Archived"}</code> and <code>{"Version":"4"}</code> </p> <p>The database has all of the tag keys, but none of those keys has an associated value that matches at least one of the specified values in the filter.</p> </li> </ul> </li> </ul>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'FailedResource$ResourceArn' => '<p>The ARN of the resource that failed to be added or removed.</p>', 'PendingResource$ResourceArn' => '<p>The Amazon resource name (ARN) of the resource that\'s in a pending state.</p>', 'ResourceArnList$member' => NULL, 'ResourceIdentifier$ResourceArn' => '<p>The ARN of a resource.</p>', ], ], 'ResourceArnList' => [ 'base' => NULL, 'refs' => [ 'GroupResourcesInput$ResourceArns' => '<p>The list of ARNs for resources to be added to the group. </p>', 'GroupResourcesOutput$Succeeded' => '<p>A list of ARNs of resources that were successfully added to the group by this operation.</p>', 'UngroupResourcesInput$ResourceArns' => '<p>The ARNs of the resources to be removed from the group.</p>', 'UngroupResourcesOutput$Succeeded' => '<p>A list of resources that were successfully removed from the group by this operation.</p>', ], ], 'ResourceFilter' => [ 'base' => '<p>A filter name and value pair that is used to obtain more specific results from a list of resources.</p>', 'refs' => [ 'ResourceFilterList$member' => NULL, ], ], 'ResourceFilterList' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesInput$Filters' => '<p>Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply to a <code>ListGroupResources</code> operation. Filters the results to include only those of the specified resource types.</p> <ul> <li> <p> <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>. </p> </li> </ul> <p>When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource Groups validates your filter resource types against the types that are defined in the query associated with the group. For example, if a group contains only S3 buckets because its query specifies only that resource type, but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups does not filter for EC2 instances. In this case, a <code>ListGroupResources</code> request returns a <code>BadRequestException</code> error with a message similar to the following:</p> <p> <code>The resource types specified as filters in the request are not valid.</code> </p> <p>The error includes a list of resource types that failed the validation because they are not part of the query associated with the group. This validation doesn\'t occur when the group query specifies <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed resource types for the query type (tag-based or AWS CloudFormation stack-based queries).</p>', ], ], 'ResourceFilterName' => [ 'base' => NULL, 'refs' => [ 'ResourceFilter$Name' => '<p>The name of the filter. Filter names are case-sensitive.</p>', ], ], 'ResourceFilterValue' => [ 'base' => NULL, 'refs' => [ 'ResourceFilterValues$member' => NULL, ], ], 'ResourceFilterValues' => [ 'base' => NULL, 'refs' => [ 'ResourceFilter$Values' => '<p>One or more filter values. Allowed filter values vary by resource filter name, and are case-sensitive.</p>', ], ], 'ResourceIdentifier' => [ 'base' => '<p>A structure that contains the ARN of a resource and its resource type.</p>', 'refs' => [ 'ListGroupResourcesItem$Identifier' => NULL, 'ResourceIdentifierList$member' => NULL, ], ], 'ResourceIdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListGroupResourcesOutput$ResourceIdentifiers' => '<important> <p> <b> <i>Deprecated - don\'t use this parameter. Use the <code>Resources</code> response field instead.</i> </b> </p> </important>', 'SearchResourcesOutput$ResourceIdentifiers' => '<p>The ARNs and resource types of resources that are members of the group that you specified.</p>', ], ], 'ResourceQuery' => [ 'base' => '<p>The query that is used to define a resource group or a search for resources. A query specifies both a query type and a query string as a JSON object. See the examples section for example JSON strings.</p> <p>The examples that follow are shown as standard JSON strings. If you include such a string as a parameter to the AWS CLI or an SDK API, you might need to \'escape\' the string into a single line. For example, see the <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-quoting-strings.html">Quoting strings</a> in the <i>AWS CLI User Guide</i>.</p> <p> <b>Example 1</b> </p> <p>The following generic example shows a resource query JSON string that includes only resources that meet the following criteria:</p> <ul> <li> <p>The resource type must be either <code>resource_type1</code> or <code>resource_type2</code>.</p> </li> <li> <p>The resource must have a tag <code>Key1</code> with a value of either <code>ValueA</code> or <code>ValueB</code>.</p> </li> <li> <p>The resource must have a tag <code>Key2</code> with a value of either <code>ValueC</code> or <code>ValueD</code>.</p> </li> </ul> <p> <code>{ "Type": "TAG_FILTERS_1_0", "Query": { "ResourceTypeFilters": [ "resource_type1", "resource_type2"], "TagFilters": [ { "Key": "Key1", "Values": ["ValueA","ValueB"] }, { "Key":"Key2", "Values":["ValueC","ValueD"] } ] } }</code> </p> <p>This has the equivalent "shortcut" syntax of the following:</p> <p> <code>{ "Type": "TAG_FILTERS_1_0", "Query": { "ResourceTypeFilters": [ "resource_type1", "resource_type2"], "TagFilters": [ { "Key1": ["ValueA","ValueB"] }, { "Key2": ["ValueC","ValueD"] } ] } }</code> </p> <p> <b>Example 2</b> </p> <p>The following example shows a resource query JSON string that includes only Amazon EC2 instances that are tagged <code>Stage</code> with a value of <code>Test</code>.</p> <p> <code>{ "Type": "TAG_FILTERS_1_0", "Query": "{ "ResourceTypeFilters": "AWS::EC2::Instance", "TagFilters": { "Stage": "Test" } } }</code> </p> <p> <b>Example 3</b> </p> <p>The following example shows a resource query JSON string that includes resource of any supported type as long as it is tagged <code>Stage</code> with a value of <code>Prod</code>.</p> <p> <code>{ "Type": "TAG_FILTERS_1_0", "Query": { "ResourceTypeFilters": "AWS::AllSupported", "TagFilters": { "Stage": "Prod" } } }</code> </p> <p> <b>Example 4</b> </p> <p>The following example shows a resource query JSON string that includes only Amazon EC2 instances and Amazon S3 buckets that are part of the specified AWS CloudFormation stack.</p> <p> <code>{ "Type": "CLOUDFORMATION_STACK_1_0", "Query": { "ResourceTypeFilters": [ "AWS::EC2::Instance", "AWS::S3::Bucket" ], "StackIdentifier": "arn:aws:cloudformation:us-west-2:123456789012:stack/AWStestuseraccount/fb0d5000-aba8-00e8-aa9e-50d5cEXAMPLE" } }</code> </p>', 'refs' => [ 'CreateGroupInput$ResourceQuery' => '<p>The resource query that determines which AWS resources are members of this group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>. </p> <note> <p>A resource group can contain either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.</p> </note>', 'CreateGroupOutput$ResourceQuery' => '<p>The resource query associated with the group. For more information about resource queries, see <a href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag">Create a tag-based group in Resource Groups</a>. </p>', 'GroupQuery$ResourceQuery' => '<p>The resource query that determines which AWS resources are members of the associated resource group.</p>', 'SearchResourcesInput$ResourceQuery' => '<p>The search query, using the same formats that are supported for resource group definition. For more information, see <a>CreateGroup</a>.</p>', 'UpdateGroupQueryInput$ResourceQuery' => '<p>The resource query to determine which AWS resources are members of this resource group.</p> <note> <p>A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.</p> </note>', ], ], 'ResourceStatus' => [ 'base' => '<p>A structure that identifies the current group membership status for a resource. Adding a resource to a resource group is performed asynchronously as a background task. A <code>PENDING</code> status indicates, for this resource, that the process isn\'t completed yet.</p>', 'refs' => [ 'ListGroupResourcesItem$Status' => '<p>A structure that contains the status of this resource\'s membership in the group.</p> <note> <p>This field is present in the response only if the group is of type <code>AWS::EC2::HostManagement</code>.</p> </note>', ], ], 'ResourceStatusValue' => [ 'base' => NULL, 'refs' => [ 'ResourceStatus$Name' => '<p>The current status.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceIdentifier$ResourceType' => '<p>The resource type of a resource, such as <code>AWS::EC2::Instance</code>.</p>', ], ], 'SearchResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'SearchResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagInput' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'Tags$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagInput$Keys' => '<p>The keys of the tags to be removed.</p>', 'UntagOutput$Keys' => '<p>The keys of the tags that were removed.</p>', ], ], 'TagOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tags$value' => NULL, ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateGroupInput$Tags' => '<p>The tags to add to the group. A tag is key-value pair string.</p>', 'CreateGroupOutput$Tags' => '<p>The tags associated with the group.</p>', 'GetTagsOutput$Tags' => '<p>The tags associated with the specified resource group.</p>', 'TagInput$Tags' => '<p>The tags to add to the specified resource group. A tag is a string-to-string map of key-value pairs.</p>', 'TagOutput$Tags' => '<p>The tags that have been added to the specified resource group.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>You\'ve exceeded throttling limits by making too many requests in a period of time.</p>', 'refs' => [], ], 'UnauthorizedException' => [ 'base' => '<p>The request was rejected because it doesn\'t have valid credentials for the target resource.</p>', 'refs' => [], ], 'UngroupResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'UngroupResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'UntagInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupQueryOutput' => [ 'base' => NULL, 'refs' => [], ], ],];
