<?php
// This file was auto-generated from sdk-root/src/data/resiliencehub/2020-04-30/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AWS Resilience Hub helps you proactively prepare and protect your Amazon Web Services applications from disruptions. Resilience Hub offers continuous resiliency assessment and validation that integrates into your software development lifecycle. This enables you to uncover resiliency weaknesses, ensure recovery time objective (RTO) and recovery point objective (RPO) targets for your applications are met, and resolve issues before they are released into production. </p>', 'operations' => [ 'AddDraftAppVersionResourceMappings' => '<p>Adds the resource mapping for the draft application version.</p>', 'CreateApp' => '<p>Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks, and an appropriate resiliency policy.</p> <pre><code> &lt;p&gt;After you create a Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).&lt;/p&gt; </code></pre>', 'CreateRecommendationTemplate' => '<p>Creates a new recommendation template.</p>', 'CreateResiliencyPolicy' => '<p>Creates a resiliency policy for an application.</p>', 'DeleteApp' => '<p>Deletes an AWS Resilience Hub application. This is a destructive action that can\'t be undone.</p>', 'DeleteAppAssessment' => '<p>Deletes an AWS Resilience Hub application assessment. This is a destructive action that can\'t be undone.</p>', 'DeleteRecommendationTemplate' => '<p>Deletes a recommendation template. This is a destructive action that can\'t be undone.</p>', 'DeleteResiliencyPolicy' => '<p>Deletes a resiliency policy. This is a destructive action that can\'t be undone.</p>', 'DescribeApp' => '<p>Describes an AWS Resilience Hub application.</p>', 'DescribeAppAssessment' => '<p>Describes an assessment for an AWS Resilience Hub application.</p>', 'DescribeAppVersionResourcesResolutionStatus' => '<p>Returns the resolution status for the specified resolution identifier for an application version. If <code>resolutionId</code> is not specified, the current resolution status is returned.</p>', 'DescribeAppVersionTemplate' => '<p>Describes details about an AWS Resilience Hub </p>', 'DescribeDraftAppVersionResourcesImportStatus' => '<p>Describes the status of importing resources to an application version.</p>', 'DescribeResiliencyPolicy' => '<p>Describes a specified resiliency policy for an AWS Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.</p>', 'ImportResourcesToDraftAppVersion' => '<p>Imports resources from sources such as a CloudFormation stack, resource-groups, or application registry app to a draft application version.</p>', 'ListAlarmRecommendations' => '<p>Lists the alarm recommendations for a AWS Resilience Hub application.</p>', 'ListAppAssessments' => '<p>Lists the assessments for an AWS Resilience Hub application. You can use request parameters to refine the results for the response object.</p>', 'ListAppComponentCompliances' => '<p>Lists the compliances for an AWS Resilience Hub component.</p>', 'ListAppComponentRecommendations' => '<p>Lists the recommendations for an AWS Resilience Hub component.</p>', 'ListAppVersionResourceMappings' => '<p>Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.</p>', 'ListAppVersionResources' => '<p>Lists all the resources in an application version.</p>', 'ListAppVersions' => '<p>Lists the different versions for the Resilience Hub applications.</p>', 'ListApps' => '<p>Lists your Resilience Hub applications.</p>', 'ListRecommendationTemplates' => '<p>Lists the recommendation templates for the Resilience Hub applications.</p>', 'ListResiliencyPolicies' => '<p>Lists the resiliency policies for the Resilience Hub applications.</p>', 'ListSopRecommendations' => '<p>Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.</p>', 'ListSuggestedResiliencyPolicies' => '<p>Lists the suggested resiliency policies for the Resilience Hub applications.</p>', 'ListTagsForResource' => '<p>Lists the tags for your resources in your Resilience Hub applications.</p>', 'ListTestRecommendations' => '<p>Lists the test recommendations for the Resilience Hub application.</p>', 'ListUnsupportedAppVersionResources' => '<p>Lists the resources that are not currently supported in AWS Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.</p>', 'PublishAppVersion' => '<p>Publishes a new version of a specific Resilience Hub application.</p>', 'PutDraftAppVersionTemplate' => '<p>Adds or updates the app template for a draft version of a Resilience Hub app.</p>', 'RemoveDraftAppVersionResourceMappings' => '<p>Removes resource mappings from a draft application version.</p>', 'ResolveAppVersionResources' => '<p>Resolves the resources for an application version.</p>', 'StartAppAssessment' => '<p>Creates a new application assessment for an application.</p>', 'TagResource' => '<p>Applies one or more tags to a resource.</p>', 'UntagResource' => '<p>Removes one or more tags from a resource.</p>', 'UpdateApp' => '<p>Updates an application.</p>', 'UpdateResiliencyPolicy' => '<p>Updates a resiliency policy.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have permissions to perform the requested operation. The user or role that is making the request must have at least one IAM permissions policy attached that grants the required permissions.</p>', 'refs' => [], ], 'AddDraftAppVersionResourceMappingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AddDraftAppVersionResourceMappingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'AlarmRecommendation' => [ 'base' => '<p>Defines a recommendation for a CloudWatch alarm.</p>', 'refs' => [ 'AlarmRecommendationList$member' => NULL, ], ], 'AlarmRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListAlarmRecommendationsResponse$alarmRecommendations' => '<p>The alarm recommendations for an AWS Resilience Hub application, returned as an object. This object includes application component names, descriptions, information about whether a recommendation has already been implemented or not, prerequisites, and more.</p>', ], ], 'AlarmReferenceIdList' => [ 'base' => NULL, 'refs' => [ 'TestRecommendation$dependsOnAlarms' => '<p> A list of recommended alarms that are used in the test and must be exported before or with the test. </p>', ], ], 'AlarmType' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$type' => '<p>The type of alarm recommendation.</p>', ], ], 'App' => [ 'base' => '<p>Defines a Resilience Hub application.</p>', 'refs' => [ 'CreateAppResponse$app' => '<p>The created application returned as an object with details including compliance status, creation time, description, resiliency score, and more.</p>', 'DescribeAppResponse$app' => '<p>The specified application, returned as an object with details including compliance status, creation time, description, resiliency score, and more.</p>', 'UpdateAppResponse$app' => '<p>The specified application, returned as an object with details including compliance status, creation time, description, resiliency score, and more.</p>', ], ], 'AppAssessment' => [ 'base' => '<p>Defines an application assessment.</p>', 'refs' => [ 'DescribeAppAssessmentResponse$assessment' => '<p>The assessment for an AWS Resilience Hub application, returned as an object. This object includes Amazon Resource Names (ARNs), compliance information, compliance status, cost, messages, resiliency scores, and more.</p>', 'StartAppAssessmentResponse$assessment' => '<p>The assessment created.</p>', ], ], 'AppAssessmentScheduleType' => [ 'base' => NULL, 'refs' => [ 'App$assessmentSchedule' => '<p> Assessment execution schedule with \'Daily\' or \'Disabled\' values. </p>', 'AppSummary$assessmentSchedule' => '<p> Assessment execution schedule with \'Daily\' or \'Disabled\' values. </p>', 'CreateAppRequest$assessmentSchedule' => '<p> Assessment execution schedule with \'Daily\' or \'Disabled\' values. </p>', 'UpdateAppRequest$assessmentSchedule' => '<p> Assessment execution schedule with \'Daily\' or \'Disabled\' values. </p>', ], ], 'AppAssessmentSummary' => [ 'base' => '<p>Defines an application assessment summary.</p>', 'refs' => [ 'AppAssessmentSummaryList$member' => NULL, ], ], 'AppAssessmentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAppAssessmentsResponse$assessmentSummaries' => '<p>The summaries for the specified assessments, returned as an object. This object includes application versions, associated Amazon Resource Numbers (ARNs), cost, messages, resiliency scores, and more.</p>', ], ], 'AppComplianceStatusType' => [ 'base' => NULL, 'refs' => [ 'App$complianceStatus' => '<p>The current status of compliance for the resiliency policy.</p>', 'AppSummary$complianceStatus' => '<p>The current status of compliance for the resiliency policy.</p>', ], ], 'AppComponent' => [ 'base' => '<p>Defines an application component.</p>', 'refs' => [ 'AppComponentList$member' => NULL, ], ], 'AppComponentCompliance' => [ 'base' => '<p>Defines the compliance of an application component against the resiliency policy.</p>', 'refs' => [ 'ComponentCompliancesList$member' => NULL, ], ], 'AppComponentList' => [ 'base' => NULL, 'refs' => [ 'PhysicalResource$appComponents' => '<p>The application components that belong to this resource.</p>', ], ], 'AppStatusType' => [ 'base' => NULL, 'refs' => [ 'App$status' => '<p>The status of the action.</p>', ], ], 'AppSummary' => [ 'base' => '<p>Defines an application summary.</p>', 'refs' => [ 'AppSummaryList$member' => NULL, ], ], 'AppSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAppsResponse$appSummaries' => '<p>Summaries for the Resilience Hub application.</p>', ], ], 'AppTemplateBody' => [ 'base' => NULL, 'refs' => [ 'DescribeAppVersionTemplateResponse$appTemplateBody' => '<p>The body of the template.</p>', 'PutDraftAppVersionTemplateRequest$appTemplateBody' => '<p>A JSON string that contains the body of the app template.</p>', ], ], 'AppVersionList' => [ 'base' => NULL, 'refs' => [ 'ListAppVersionsResponse$appVersions' => '<p>The version of the application.</p>', ], ], 'AppVersionSummary' => [ 'base' => '<p>The version of the application.</p>', 'refs' => [ 'AppVersionList$member' => NULL, ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'AddDraftAppVersionResourceMappingsRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'AddDraftAppVersionResourceMappingsResponse$appArn' => '<p> The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'App$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'App$policyArn' => '<p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'AppAssessment$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'AppAssessment$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'AppAssessmentSummary$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'AppAssessmentSummary$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'AppSummary$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ArnList$member' => NULL, 'CreateAppRequest$policyArn' => '<p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'CreateRecommendationTemplateRequest$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DeleteAppAssessmentRequest$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DeleteAppAssessmentResponse$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DeleteAppRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DeleteAppResponse$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DeleteRecommendationTemplateRequest$recommendationTemplateArn' => '<p>The Amazon Resource Name (ARN) for a recommendation template.</p>', 'DeleteRecommendationTemplateResponse$recommendationTemplateArn' => '<p>The Amazon Resource Name (ARN) for a recommendation template.</p>', 'DeleteResiliencyPolicyRequest$policyArn' => '<p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DeleteResiliencyPolicyResponse$policyArn' => '<p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeAppAssessmentRequest$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeAppRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeAppVersionResourcesResolutionStatusRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeAppVersionResourcesResolutionStatusResponse$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeAppVersionTemplateRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeAppVersionTemplateResponse$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeDraftAppVersionResourcesImportStatusRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeDraftAppVersionResourcesImportStatusResponse$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'DescribeResiliencyPolicyRequest$policyArn' => '<p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ImportResourcesToDraftAppVersionRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ImportResourcesToDraftAppVersionResponse$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListAlarmRecommendationsRequest$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListAppAssessmentsRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListAppComponentCompliancesRequest$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListAppComponentRecommendationsRequest$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListAppVersionResourceMappingsRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListAppVersionResourcesRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListAppVersionsRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListAppsRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListRecommendationTemplatesRequest$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListRecommendationTemplatesRequest$recommendationTemplateArn' => '<p>The Amazon Resource Name (ARN) for a recommendation template.</p>', 'ListSopRecommendationsRequest$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) for a specific resource in your Resilience Hub application.</p>', 'ListTestRecommendationsRequest$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ListUnsupportedAppVersionResourcesRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'PublishAppVersionRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'PublishAppVersionResponse$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'PutDraftAppVersionTemplateRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'PutDraftAppVersionTemplateResponse$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'RecommendationTemplate$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'RecommendationTemplate$assessmentArn' => '<p>The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'RecommendationTemplate$recommendationTemplateArn' => '<p>The Amazon Resource Name (ARN) for the recommendation template.</p>', 'RemoveDraftAppVersionResourceMappingsRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'RemoveDraftAppVersionResourceMappingsResponse$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ResiliencyPolicy$policyArn' => '<p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ResolveAppVersionResourcesRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'ResolveAppVersionResourcesResponse$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'StartAppAssessmentRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. </p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. </p>', 'UpdateAppRequest$appArn' => '<p>The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'UpdateAppRequest$policyArn' => '<p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', 'UpdateResiliencyPolicyRequest$policyArn' => '<p>The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'ImportResourcesToDraftAppVersionRequest$sourceArns' => '<p>The Amazon Resource Names (ARNs) for the resources that you want to import.</p>', 'ImportResourcesToDraftAppVersionResponse$sourceArns' => '<p>The Amazon Resource Names (ARNs) for the resources that you imported.</p>', ], ], 'AssessmentCompliance' => [ 'base' => NULL, 'refs' => [ 'AppAssessment$compliance' => '<p>The application compliance against the resiliency policy.</p>', 'AppComponentCompliance$compliance' => '<p>The compliance of the application component against the resiliency policy.</p>', 'ConfigRecommendation$compliance' => '<p>The current compliance against the resiliency policy before applying the configuration change.</p>', ], ], 'AssessmentInvoker' => [ 'base' => NULL, 'refs' => [ 'AppAssessment$invoker' => '<p>The entity that invoked the assessment.</p>', 'AppAssessmentSummary$invoker' => '<p>The entity that invoked the assessment.</p>', 'ListAppAssessmentsRequest$invoker' => '<p>Specifies the entity that invoked a specific assessment, either a <code>User</code> or the <code>System</code>.</p>', ], ], 'AssessmentStatus' => [ 'base' => NULL, 'refs' => [ 'AppAssessment$assessmentStatus' => '<p>The current status of the assessment for the resiliency policy.</p>', 'AppAssessmentSummary$assessmentStatus' => '<p>The current status of the assessment for the resiliency policy.</p>', 'AssessmentStatusList$member' => NULL, 'DeleteAppAssessmentResponse$assessmentStatus' => '<p>The current status of the assessment for the resiliency policy.</p>', ], ], 'AssessmentStatusList' => [ 'base' => NULL, 'refs' => [ 'ListAppAssessmentsRequest$assessmentStatus' => '<p>The current status of the assessment for the resiliency policy.</p>', ], ], 'AwsRegion' => [ 'base' => NULL, 'refs' => [ 'PhysicalResourceId$awsRegion' => '<p>The Amazon Web Services Region that the physical resource is located in.</p>', 'RecommendationItem$targetRegion' => '<p>The target region.</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'DeleteAppRequest$forceDelete' => '<p>A boolean option to force the deletion of a Resilience Hub application. </p>', 'ListAppAssessmentsRequest$reverseOrder' => '<p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>', 'ListRecommendationTemplatesRequest$reverseOrder' => '<p>The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to <code>true</code>.</p>', 'RecommendationItem$alreadyImplemented' => '<p>Specifies if the recommendation has already been implemented.</p>', 'RecommendationTemplate$needsReplacements' => '<p>Indicates if replacements are needed.</p>', 'ResourceErrorsDetails$hasMoreErrors' => '<p> This indicates if there are more errors not listed in the resourceErrors list. </p>', 'UpdateAppRequest$clearResiliencyPolicyArn' => '<p>Specifies if the resiliency policy ARN should be cleared.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateAppRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'CreateRecommendationTemplateRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'CreateResiliencyPolicyRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteAppAssessmentRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteAppRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteRecommendationTemplateRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'DeleteResiliencyPolicyRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', 'StartAppAssessmentRequest$clientToken' => '<p>Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.</p>', ], ], 'ComplianceStatus' => [ 'base' => NULL, 'refs' => [ 'AppAssessment$complianceStatus' => '<p>The current status of the compliance for the resiliency policy.</p>', 'AppAssessmentSummary$complianceStatus' => '<p>The current status of compliance for the resiliency policy.</p>', 'AppComponentCompliance$status' => '<p>The status of the action.</p>', 'DisruptionCompliance$complianceStatus' => '<p>The current status of compliance for the resiliency policy.</p>', 'ListAppAssessmentsRequest$complianceStatus' => '<p>The current status of compliance for the resiliency policy.</p>', 'RecommendationDisruptionCompliance$expectedComplianceStatus' => '<p>The expected compliance status after applying the recommended configuration change.</p>', ], ], 'ComponentCompliancesList' => [ 'base' => NULL, 'refs' => [ 'ListAppComponentCompliancesResponse$componentCompliances' => '<p>The compliances for an AWS Resilience Hub application component, returned as an object. This object contains component names, compliances, costs, resiliency scores, outage scores, and more.</p>', ], ], 'ComponentRecommendation' => [ 'base' => '<p>Defines recommendations for a Resilience Hub application component, returned as an object. This object contains component names, configuration recommendations, and recommendation statuses.</p>', 'refs' => [ 'ComponentRecommendationList$member' => NULL, ], ], 'ComponentRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListAppComponentRecommendationsResponse$componentRecommendations' => '<p>The recommendations for an Resilience Hub application component, returned as an object. This object contains component names, configuration recommendations, and recommendation statuses.</p>', ], ], 'ConfigRecommendation' => [ 'base' => '<p>Defines a configuration recommendation.</p>', 'refs' => [ 'ConfigRecommendationList$member' => NULL, ], ], 'ConfigRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ComponentRecommendation$configRecommendations' => '<p>The list of recommendations.</p>', ], ], 'ConfigRecommendationOptimizationType' => [ 'base' => NULL, 'refs' => [ 'ConfigRecommendation$optimizationType' => '<p>The type of optimization.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Occurs when a conflict with a previous successful write is detected. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>', 'refs' => [], ], 'Cost' => [ 'base' => '<p>Defines a cost object.</p>', 'refs' => [ 'AppAssessment$cost' => '<p>The cost for the application.</p>', 'AppAssessmentSummary$cost' => '<p>The cost for the application.</p>', 'AppComponentCompliance$cost' => '<p>The cost for the application.</p>', 'ConfigRecommendation$cost' => '<p>The cost for the application.</p>', ], ], 'CostFrequency' => [ 'base' => NULL, 'refs' => [ 'Cost$frequency' => '<p>The cost frequency.</p>', ], ], 'CreateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecommendationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecommendationTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateResiliencyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResiliencyPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CurrencyCode' => [ 'base' => NULL, 'refs' => [ 'Cost$currency' => '<p>The cost currency, for example <code>USD</code>.</p>', ], ], 'CustomerId' => [ 'base' => NULL, 'refs' => [ 'PhysicalResourceId$awsAccountId' => '<p>The Amazon Web Services account that owns the physical resource.</p>', 'RecommendationItem$targetAccountId' => '<p>The target account identifier.</p>', ], ], 'DataLocationConstraint' => [ 'base' => NULL, 'refs' => [ 'CreateResiliencyPolicyRequest$dataLocationConstraint' => '<p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>', 'ResiliencyPolicy$dataLocationConstraint' => '<p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>', 'UpdateResiliencyPolicyRequest$dataLocationConstraint' => '<p>Specifies a high-level geographical location constraint for where your resilience policy data can be stored.</p>', ], ], 'DeleteAppAssessmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppAssessmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecommendationTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecommendationTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResiliencyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResiliencyPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppAssessmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppAssessmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionResourcesResolutionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionResourcesResolutionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAppVersionTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDraftAppVersionResourcesImportStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDraftAppVersionResourcesImportStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResiliencyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeResiliencyPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisruptionCompliance' => [ 'base' => '<p>Defines the compliance against the resiliency policy for a disruption.</p>', 'refs' => [ 'AssessmentCompliance$value' => NULL, ], ], 'DisruptionPolicy' => [ 'base' => NULL, 'refs' => [ 'CreateResiliencyPolicyRequest$policy' => '<p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>', 'ResiliencyPolicy$policy' => '<p>The resiliency policy.</p>', 'UpdateResiliencyPolicyRequest$policy' => '<p>The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>', ], ], 'DisruptionResiliencyScore' => [ 'base' => NULL, 'refs' => [ 'ResiliencyScore$disruptionScore' => '<p>The disruption score for a valid key.</p>', ], ], 'DisruptionType' => [ 'base' => NULL, 'refs' => [ 'AssessmentCompliance$key' => NULL, 'DisruptionPolicy$key' => NULL, 'DisruptionResiliencyScore$key' => NULL, 'RecommendationCompliance$key' => NULL, ], ], 'DocumentName' => [ 'base' => NULL, 'refs' => [ 'SopRecommendation$name' => '<p>The name of the SOP recommendation.</p>', 'TestRecommendation$name' => '<p>The name of the test recommendation.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'App$resiliencyScore' => '<p>The current resiliency score for the application.</p>', 'AppAssessmentSummary$resiliencyScore' => '<p>The current resiliency score for the application.</p>', 'AppSummary$resiliencyScore' => '<p>The current resiliency score for the application.</p>', 'Cost$amount' => '<p>The cost amount.</p>', 'DisruptionResiliencyScore$value' => NULL, 'ResiliencyScore$score' => '<p>The outage score for a valid key.</p>', ], ], 'EntityDescription' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$description' => '<p>The description of the recommendation.</p>', 'App$description' => '<p>The optional description for an app.</p>', 'AppSummary$description' => '<p>The optional description for an app.</p>', 'ConfigRecommendation$description' => '<p>The optional description for an app.</p>', 'CreateAppRequest$description' => '<p>The optional description for an app.</p>', 'CreateResiliencyPolicyRequest$policyDescription' => '<p>The description for the policy.</p>', 'ResiliencyPolicy$policyDescription' => '<p>The description for the policy.</p>', 'SuggestedChangesList$member' => NULL, 'TestRecommendation$intent' => '<p>The intent of the test recommendation.</p>', 'UpdateAppRequest$description' => '<p>The optional description for an app.</p>', 'UpdateResiliencyPolicyRequest$policyDescription' => '<p>The description for the policy.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$appComponentName' => '<p>The application component for the CloudWatch alarm recommendation.</p>', 'AppComponentCompliance$appComponentName' => '<p>The name of the application component.</p>', 'ComponentRecommendation$appComponentName' => '<p>The name of the application component.</p>', 'ConfigRecommendation$appComponentName' => '<p>The application component name.</p>', 'SopRecommendation$appComponentName' => '<p>The application component name.</p>', 'TestRecommendation$appComponentName' => '<p>The name of the application component.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'App$name' => '<p>The name for the application.</p>', 'AppAssessment$assessmentName' => '<p>The name of the assessment.</p>', 'AppAssessmentSummary$assessmentName' => '<p>The name of the assessment.</p>', 'AppSummary$name' => '<p>The name of the application.</p>', 'ConfigRecommendation$name' => '<p>The name of the recommendation configuration.</p>', 'CreateAppRequest$name' => '<p>The name for the application.</p>', 'CreateRecommendationTemplateRequest$bucketName' => '<p>The name of the Amazon S3 bucket that will contain the recommendation template.</p>', 'CreateRecommendationTemplateRequest$name' => '<p>The name for the recommendation template.</p>', 'CreateResiliencyPolicyRequest$policyName' => '<p>The name of the policy</p>', 'EntityNameList$member' => NULL, 'ListAppAssessmentsRequest$assessmentName' => '<p>The name for the assessment.</p>', 'ListAppsRequest$name' => '<p>The name for the one of the listed applications.</p>', 'ListRecommendationTemplatesRequest$name' => '<p>The name for one of the listed recommendation templates.</p>', 'ListResiliencyPoliciesRequest$policyName' => '<p>The name of the policy</p>', 'LogicalResourceId$resourceGroupName' => '<p>The name of the resource group that this resource belongs to.</p>', 'PhysicalResource$resourceName' => '<p>The name of the resource.</p>', 'RecommendationTemplate$name' => '<p>The name for the recommendation template.</p>', 'ResiliencyPolicy$policyName' => '<p>The name of the policy</p>', 'ResourceMapping$appRegistryAppName' => '<p>The name of the application this resource is mapped to.</p>', 'ResourceMapping$resourceGroupName' => '<p>The name of the resource group this resource is mapped to.</p>', 'ResourceMapping$resourceName' => '<p>The name of the resource this resource is mapped to.</p>', 'StartAppAssessmentRequest$assessmentName' => '<p>The name for the assessment.</p>', 'UpdateResiliencyPolicyRequest$policyName' => '<p>The name of the policy</p>', ], ], 'EntityNameList' => [ 'base' => NULL, 'refs' => [ 'RemoveDraftAppVersionResourceMappingsRequest$appRegistryAppNames' => '<p>The names of the registered applications to remove from the resource mappings.</p>', 'RemoveDraftAppVersionResourceMappingsRequest$resourceGroupNames' => '<p>The names of the resource groups to remove from the resource mappings.</p>', 'RemoveDraftAppVersionResourceMappingsRequest$resourceNames' => '<p>The names of the resources to remove from the resource mappings.</p>', ], ], 'EntityVersion' => [ 'base' => NULL, 'refs' => [ 'AddDraftAppVersionResourceMappingsResponse$appVersion' => '<p>The version of the application.</p>', 'AppAssessment$appVersion' => '<p>The version of the application.</p>', 'AppAssessmentSummary$appVersion' => '<p>The version of the application.</p>', 'AppVersionSummary$appVersion' => '<p>The version of the application.</p>', 'DescribeAppVersionResourcesResolutionStatusRequest$appVersion' => '<p>The version of the application.</p>', 'DescribeAppVersionResourcesResolutionStatusResponse$appVersion' => '<p>The version of the application.</p>', 'DescribeAppVersionTemplateRequest$appVersion' => '<p>The version of the application.</p>', 'DescribeAppVersionTemplateResponse$appVersion' => '<p>The version of the application.</p>', 'DescribeDraftAppVersionResourcesImportStatusResponse$appVersion' => '<p>The version of the application.</p>', 'ImportResourcesToDraftAppVersionResponse$appVersion' => '<p>The version of the application.</p>', 'ListAppVersionResourceMappingsRequest$appVersion' => '<p>The version of the application.</p>', 'ListAppVersionResourcesRequest$appVersion' => '<p>The version of the application.</p>', 'ListUnsupportedAppVersionResourcesRequest$appVersion' => '<p>The version of the application.</p>', 'PublishAppVersionResponse$appVersion' => '<p>The version of the application.</p>', 'PutDraftAppVersionTemplateResponse$appVersion' => '<p>The version of the application.</p>', 'RemoveDraftAppVersionResourceMappingsResponse$appVersion' => '<p>The version of the application.</p>', 'ResolveAppVersionResourcesRequest$appVersion' => '<p>The version of the application.</p>', 'ResolveAppVersionResourcesResponse$appVersion' => '<p>The version of the application.</p>', 'StartAppAssessmentRequest$appVersion' => '<p>The version of the application.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ResourceError$reason' => '<p> This is the error message. </p>', ], ], 'EstimatedCostTier' => [ 'base' => NULL, 'refs' => [ 'ResiliencyPolicy$estimatedCostTier' => '<p>Specifies the estimated cost tier of the resiliency policy.</p>', ], ], 'FailurePolicy' => [ 'base' => '<p>Defines a failure policy.</p>', 'refs' => [ 'DisruptionPolicy$value' => NULL, ], ], 'HaArchitecture' => [ 'base' => NULL, 'refs' => [ 'ConfigRecommendation$haArchitecture' => '<p>The architecture type.</p>', ], ], 'ImportResourcesToDraftAppVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportResourcesToDraftAppVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>This exception occurs when there is an internal failure in the AWS Resilience Hub service.</p>', 'refs' => [], ], 'ListAlarmRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAlarmRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppAssessmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppAssessmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppComponentCompliancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppComponentCompliancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppComponentRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppComponentRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionResourceMappingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionResourceMappingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAppsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendationTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResiliencyPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResiliencyPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSopRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSopRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSuggestedResiliencyPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSuggestedResiliencyPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTestRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUnsupportedAppVersionResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUnsupportedAppVersionResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogicalResourceId' => [ 'base' => '<p>Defines a logical resource identifier.</p>', 'refs' => [ 'PhysicalResource$logicalResourceId' => '<p>The logical identifier of the resource.</p>', 'UnsupportedResource$logicalResourceId' => '<p>The logical resource identifier for the unsupported resource.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAlarmRecommendationsRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppAssessmentsRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppComponentCompliancesRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppComponentRecommendationsRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppVersionResourceMappingsRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppVersionResourcesRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppVersionsRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListAppsRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListRecommendationTemplatesRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListResiliencyPoliciesRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListSopRecommendationsRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListSuggestedResiliencyPoliciesRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListTestRecommendationsRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', 'ListUnsupportedAppVersionResourcesRequest$maxResults' => '<p>The maximum number of results to include in the response. If more results exist than the specified <code>MaxResults</code> value, a token is included in the response so that the remaining results can be retrieved.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAlarmRecommendationsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAlarmRecommendationsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAppAssessmentsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppAssessmentsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAppComponentCompliancesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppComponentCompliancesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAppComponentRecommendationsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppComponentRecommendationsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAppVersionResourceMappingsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppVersionResourceMappingsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAppVersionResourcesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppVersionResourcesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAppVersionsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppVersionsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListAppsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListAppsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListRecommendationTemplatesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListRecommendationTemplatesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListResiliencyPoliciesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListResiliencyPoliciesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListSopRecommendationsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListSopRecommendationsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListSuggestedResiliencyPoliciesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListSuggestedResiliencyPoliciesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListTestRecommendationsRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListTestRecommendationsResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', 'ListUnsupportedAppVersionResourcesRequest$nextToken' => '<p>Null, or the token from a previous call to get the next set of results.</p>', 'ListUnsupportedAppVersionResourcesResponse$nextToken' => '<p>The token for the next set of results, or null if there are no more results.</p>', ], ], 'PhysicalIdentifierType' => [ 'base' => NULL, 'refs' => [ 'PhysicalResourceId$type' => '<p>Specifies the type of physical resource identifier.</p> <dl> <dt>Arn</dt> <dd> <p>The resource identifier is an Amazon Resource Name (ARN) .</p> </dd> <dt>Native</dt> <dd> <p>The resource identifier is a Resilience Hub-native identifier.</p> </dd> </dl>', ], ], 'PhysicalResource' => [ 'base' => '<p>Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier. </p>', 'refs' => [ 'PhysicalResourceList$member' => NULL, ], ], 'PhysicalResourceId' => [ 'base' => '<p>Defines a physical resource identifier.</p>', 'refs' => [ 'PhysicalResource$physicalResourceId' => '<p>The physical identifier of the resource.</p>', 'ResourceMapping$physicalResourceId' => '<p>The identifier of this resource.</p>', 'UnsupportedResource$physicalResourceId' => '<p>The physical resource identifier for the unsupported resource.</p>', ], ], 'PhysicalResourceList' => [ 'base' => NULL, 'refs' => [ 'ListAppVersionResourcesResponse$physicalResources' => '<p>The physical resources in the application version.</p>', ], ], 'PublishAppVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'PublishAppVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutDraftAppVersionTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutDraftAppVersionTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'RecommendationCompliance' => [ 'base' => NULL, 'refs' => [ 'ConfigRecommendation$recommendationCompliance' => '<p>The expected compliance against the resiliency policy after applying the configuration change.</p>', ], ], 'RecommendationComplianceStatus' => [ 'base' => NULL, 'refs' => [ 'ComponentRecommendation$recommendationStatus' => '<p>The recommendation status.</p>', ], ], 'RecommendationDisruptionCompliance' => [ 'base' => '<p>Defines a disruption compliance recommendation.</p>', 'refs' => [ 'RecommendationCompliance$value' => NULL, ], ], 'RecommendationIdList' => [ 'base' => NULL, 'refs' => [ 'CreateRecommendationTemplateRequest$recommendationIds' => '<p>Identifiers for the recommendations used to create a recommendation template.</p>', 'RecommendationTemplate$recommendationIds' => '<p>Identifiers for the recommendations used in the recommendation template.</p>', ], ], 'RecommendationItem' => [ 'base' => '<p>Defines a recommendation.</p>', 'refs' => [ 'RecommendationItemList$member' => NULL, ], ], 'RecommendationItemList' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$items' => '<p>The list of CloudWatch alarm recommendations.</p>', 'SopRecommendation$items' => '<p>The recommendation items.</p>', 'TestRecommendation$items' => '<p>The test recommendation items.</p>', ], ], 'RecommendationTemplate' => [ 'base' => '<p>Defines a recommendation template created with the <a>CreateRecommendationTemplate</a> action.</p>', 'refs' => [ 'CreateRecommendationTemplateResponse$recommendationTemplate' => '<p>The newly created recommendation template, returned as an object. This object includes the template\'s name, format, status, tags, Amazon S3 bucket location, and more.</p>', 'RecommendationTemplateList$member' => NULL, ], ], 'RecommendationTemplateList' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationTemplatesResponse$recommendationTemplates' => '<p>The recommendation templates for the Resilience Hub applications.</p>', ], ], 'RecommendationTemplateStatus' => [ 'base' => NULL, 'refs' => [ 'DeleteRecommendationTemplateResponse$status' => '<p>The status of the action.</p>', 'RecommendationTemplate$status' => '<p>The status of the action.</p>', 'RecommendationTemplateStatusList$member' => NULL, ], ], 'RecommendationTemplateStatusList' => [ 'base' => NULL, 'refs' => [ 'ListRecommendationTemplatesRequest$status' => '<p>The status of the action.</p>', ], ], 'RemoveDraftAppVersionResourceMappingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'RemoveDraftAppVersionResourceMappingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'RenderRecommendationType' => [ 'base' => NULL, 'refs' => [ 'RenderRecommendationTypeList$member' => NULL, ], ], 'RenderRecommendationTypeList' => [ 'base' => NULL, 'refs' => [ 'CreateRecommendationTemplateRequest$recommendationTypes' => '<p>An array of strings that specify the recommendation template type or types.</p> <dl> <dt>Alarm</dt> <dd> <p>The template is an <a>AlarmRecommendation</a> template.</p> </dd> <dt>Sop</dt> <dd> <p>The template is a <a>SopRecommendation</a> template.</p> </dd> <dt>Test</dt> <dd> <p>The template is a <a>TestRecommendation</a> template.</p> </dd> </dl>', 'RecommendationTemplate$recommendationTypes' => '<p>An array of strings that specify the recommendation template type or types.</p> <dl> <dt>Alarm</dt> <dd> <p>The template is an <a>AlarmRecommendation</a> template.</p> </dd> <dt>Sop</dt> <dd> <p>The template is a <a>SopRecommendation</a> template.</p> </dd> <dt>Test</dt> <dd> <p>The template is a <a>TestRecommendation</a> template.</p> </dd> </dl>', ], ], 'ResiliencyPolicies' => [ 'base' => NULL, 'refs' => [ 'ListResiliencyPoliciesResponse$resiliencyPolicies' => '<p>The resiliency policies for the Resilience Hub applications.</p>', 'ListSuggestedResiliencyPoliciesResponse$resiliencyPolicies' => '<p>The suggested resiliency policies for the Resilience Hub applications.</p>', ], ], 'ResiliencyPolicy' => [ 'base' => '<p>Defines a resiliency policy.</p>', 'refs' => [ 'AppAssessment$policy' => '<p>The resiliency policy.</p>', 'CreateResiliencyPolicyResponse$policy' => '<p>The type of resiliency policy that was created, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>', 'DescribeResiliencyPolicyResponse$policy' => '<p>Information about the specific resiliency policy, returned as an object. This object includes creation time, data location constraints, its name, description, tags, the recovery time objective (RTO) and recovery point objective (RPO) in seconds, and more.</p>', 'ResiliencyPolicies$member' => NULL, 'UpdateResiliencyPolicyResponse$policy' => '<p>The type of resiliency policy that was updated, including the recovery time objective (RTO) and recovery point objective (RPO) in seconds.</p>', ], ], 'ResiliencyPolicyTier' => [ 'base' => NULL, 'refs' => [ 'CreateResiliencyPolicyRequest$tier' => '<p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>', 'ResiliencyPolicy$tier' => '<p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>', 'UpdateResiliencyPolicyRequest$tier' => '<p>The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (<code>NonCritical</code>).</p>', ], ], 'ResiliencyScore' => [ 'base' => '<p>The overall resiliency score, returned as an object that includes the disruption score and outage score.</p>', 'refs' => [ 'AppAssessment$resiliencyScore' => '<p>The current resiliency score for the application.</p>', 'AppComponentCompliance$resiliencyScore' => '<p>The current resiliency score for the application.</p>', ], ], 'ResolveAppVersionResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResolveAppVersionResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceError' => [ 'base' => '<p> Defines application resource errors. </p>', 'refs' => [ 'ResourceErrorList$member' => NULL, ], ], 'ResourceErrorList' => [ 'base' => NULL, 'refs' => [ 'ResourceErrorsDetails$resourceErrors' => '<p> A list of errors retrieving an application\'s resources. </p>', ], ], 'ResourceErrorsDetails' => [ 'base' => '<p> A list of errors retrieving an application\'s resources. </p>', 'refs' => [ 'AppAssessment$resourceErrorsDetails' => '<p> A resource error object containing a list of errors retrieving an application\'s resources. </p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceId' => '<p>The identifier of the resource that the exception applies to.</p>', 'ResourceNotFoundException$resourceId' => '<p>The identifier of the resource that the exception applies to.</p>', ], ], 'ResourceImportStatusType' => [ 'base' => NULL, 'refs' => [ 'DescribeDraftAppVersionResourcesImportStatusResponse$status' => '<p>The status of the action.</p>', 'ImportResourcesToDraftAppVersionResponse$status' => '<p>The status of the action.</p>', ], ], 'ResourceMapping' => [ 'base' => '<p>Defines a resource mapping.</p>', 'refs' => [ 'ResourceMappingList$member' => NULL, ], ], 'ResourceMappingList' => [ 'base' => NULL, 'refs' => [ 'AddDraftAppVersionResourceMappingsRequest$resourceMappings' => '<p> Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>', 'AddDraftAppVersionResourceMappingsResponse$resourceMappings' => '<p>Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>', 'ListAppVersionResourceMappingsResponse$resourceMappings' => '<p>Mappings used to map logical resources from the template to physical resources. You can use the mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.</p>', ], ], 'ResourceMappingType' => [ 'base' => NULL, 'refs' => [ 'ResourceMapping$mappingType' => '<p>Specifies the type of resource mapping.</p> <dl> <dt>AppRegistryApp</dt> <dd> <p>The resource is mapped to another application. The name of the application is contained in the <code>appRegistryAppName</code> property.</p> </dd> <dt>CfnStack</dt> <dd> <p>The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the <code>logicalStackName</code> property.</p> </dd> <dt>Resource</dt> <dd> <p>The resource is mapped to another resource. The name of the resource is contained in the <code>resourceName</code> property.</p> </dd> <dt>ResourceGroup</dt> <dd> <p>The resource is mapped to a resource group. The name of the resource group is contained in the <code>resourceGroupName</code> property.</p> </dd> </dl>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource could not be found.</p>', 'refs' => [], ], 'ResourceResolutionStatusType' => [ 'base' => NULL, 'refs' => [ 'DescribeAppVersionResourcesResolutionStatusResponse$status' => '<p>The status of the action.</p>', 'ResolveAppVersionResourcesResponse$status' => '<p>The status of the action.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ConflictException$resourceType' => '<p>The type of the resource that the exception applies to.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the resource that the exception applies to.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the operation.</p>', ], ], 'S3Location' => [ 'base' => '<p>The location of the Amazon S3 bucket.</p>', 'refs' => [ 'RecommendationTemplate$templatesLocation' => '<p>The file location of the template.</p>', ], ], 'S3Url' => [ 'base' => NULL, 'refs' => [ 'TerraformSource$s3StateFileUrl' => '<p> The Terraform s3 state file you need to import. </p>', ], ], 'Seconds' => [ 'base' => NULL, 'refs' => [ 'DisruptionCompliance$achievableRpoInSecs' => '<p>The Recovery Point Objective (RPO) that is achievable, in seconds.</p>', 'DisruptionCompliance$achievableRtoInSecs' => '<p>The Recovery Time Objective (RTO) that is achievable, in seconds</p>', 'DisruptionCompliance$currentRpoInSecs' => '<p>The current RPO, in seconds.</p>', 'DisruptionCompliance$currentRtoInSecs' => '<p>The current RTO, in seconds.</p>', 'FailurePolicy$rpoInSecs' => '<p>The Recovery Point Objective (RPO), in seconds.</p>', 'FailurePolicy$rtoInSecs' => '<p>The Recovery Time Objective (RTO), in seconds.</p>', 'RecommendationDisruptionCompliance$expectedRpoInSecs' => '<p>The expected RPO after applying the recommended configuration change.</p>', 'RecommendationDisruptionCompliance$expectedRtoInSecs' => '<p>The expected RTO after applying the recommended configuration change.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>', 'refs' => [], ], 'SopRecommendation' => [ 'base' => '<p>Defines a standard operating procedure (SOP) recommendation.</p>', 'refs' => [ 'SopRecommendationList$member' => NULL, ], ], 'SopRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListSopRecommendationsResponse$sopRecommendations' => '<p>The standard operating procedure (SOP) recommendations for the Resilience Hub applications.</p>', ], ], 'SopServiceType' => [ 'base' => NULL, 'refs' => [ 'SopRecommendation$serviceType' => '<p>The service type.</p>', ], ], 'SpecReferenceId' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$referenceId' => '<p>The reference identifier of the alarm recommendation.</p>', 'ConfigRecommendation$referenceId' => '<p>The reference identifier for the recommendation configuration.</p>', 'SopRecommendation$referenceId' => '<p>The reference identifier for the SOP recommendation.</p>', 'TestRecommendation$referenceId' => '<p>The reference identifier for the test recommendation.</p>', ], ], 'StartAppAssessmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAppAssessmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'String255' => [ 'base' => NULL, 'refs' => [ 'AppComponent$name' => '<p>The name of the application component.</p>', 'AppComponent$type' => '<p>The type of application component.</p>', 'DescribeAppVersionResourcesResolutionStatusRequest$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'DescribeAppVersionResourcesResolutionStatusResponse$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'ListAppVersionResourcesRequest$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'ListAppVersionResourcesResponse$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'ListUnsupportedAppVersionResourcesRequest$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'ListUnsupportedAppVersionResourcesResponse$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'LogicalResourceId$identifier' => '<p>The identifier of the resource.</p>', 'LogicalResourceId$logicalStackName' => '<p>The name of the CloudFormation stack this resource belongs to.</p>', 'LogicalResourceId$terraformSourceName' => '<p> The name of the Terraform S3 state file this resource belongs to. </p>', 'PhysicalResource$resourceType' => '<p>The type of resource.</p>', 'PhysicalResourceId$identifier' => '<p>The identifier of the physical resource.</p>', 'ResolveAppVersionResourcesResponse$resolutionId' => '<p>The identifier for a specific resolution.</p>', 'ResourceError$logicalResourceId' => '<p> This is the identifier of the resource. </p>', 'ResourceError$physicalResourceId' => '<p> This is the identifier of the physical resource. </p>', 'ResourceMapping$logicalStackName' => '<p>The name of the CloudFormation stack this resource is mapped to.</p>', 'ResourceMapping$terraformSourceName' => '<p> The short name of the Terraform source. </p>', 'String255List$member' => NULL, 'UnsupportedResource$resourceType' => '<p>The type of resource.</p>', ], ], 'String255List' => [ 'base' => NULL, 'refs' => [ 'RemoveDraftAppVersionResourceMappingsRequest$logicalStackNames' => '<p>The names of the CloudFormation stacks to remove from the resource mappings.</p>', 'RemoveDraftAppVersionResourceMappingsRequest$terraformSourceNames' => '<p> <pre><code>&lt;/p&gt; </code></pre>', ], ], 'String500' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AlarmRecommendation$name' => '<p>The name of the alarm recommendation.</p>', 'AlarmRecommendation$prerequisite' => '<p>The prerequisite for the alarm recommendation.</p>', 'AlarmReferenceIdList$member' => NULL, 'AppAssessment$message' => '<p>Error or warning message from the assessment execution</p>', 'AppAssessmentSummary$message' => '<p>The message from the assessment run.</p>', 'AppComponentCompliance$message' => '<p>The compliance message.</p>', 'ConflictException$message' => NULL, 'DescribeAppVersionResourcesResolutionStatusResponse$errorMessage' => '<p>The returned error message for the request.</p>', 'DescribeDraftAppVersionResourcesImportStatusResponse$errorMessage' => '<p>The returned error message for the request.</p>', 'DisruptionCompliance$message' => '<p>The disruption compliance message.</p>', 'DisruptionCompliance$rpoDescription' => '<p>The RPO description.</p>', 'DisruptionCompliance$rpoReferenceId' => '<p>The RPO reference identifier.</p>', 'DisruptionCompliance$rtoDescription' => '<p>The RTO description.</p>', 'DisruptionCompliance$rtoReferenceId' => '<p>The RTO reference identifier.</p>', 'InternalServerException$message' => NULL, 'RecommendationDisruptionCompliance$expectedRpoDescription' => '<p>The expected Recovery Point Objective (RPO) description after applying the recommended configuration change.</p>', 'RecommendationDisruptionCompliance$expectedRtoDescription' => '<p>The expected Recovery Time Objective (RTO) description after applying the recommended configuration change.</p>', 'RecommendationItem$resourceId' => '<p>The resource identifier.</p>', 'RecommendationTemplate$message' => '<p>The message for the recommendation template.</p>', 'ResourceNotFoundException$message' => NULL, 'S3Location$bucket' => '<p>The name of the Amazon S3 bucket.</p>', 'S3Location$prefix' => '<p>The prefix for the Amazon S3 bucket.</p>', 'ServiceQuotaExceededException$message' => NULL, 'SopRecommendation$description' => '<p>The description of the SOP recommendation.</p>', 'SopRecommendation$prerequisite' => '<p>The prerequisite for the SOP recommendation.</p>', 'TestRecommendation$description' => '<p>The description for the test recommendation.</p>', 'TestRecommendation$prerequisite' => '<p>The prerequisite of the test recommendation.</p>', 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'SuggestedChangesList' => [ 'base' => NULL, 'refs' => [ 'ConfigRecommendation$suggestedChanges' => '<p>List of the suggested configuration changes.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to remove.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'App$tags' => '<p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'AppAssessment$tags' => '<p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'CreateAppRequest$tags' => '<p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'CreateRecommendationTemplateRequest$tags' => '<p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'CreateResiliencyPolicyRequest$tags' => '<p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'RecommendationTemplate$tags' => '<p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'ResiliencyPolicy$tags' => '<p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'StartAppAssessmentRequest$tags' => '<p>The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.</p>', 'TagResourceRequest$tags' => '<p>The tags to assign to the resource. Each tag consists of a key/value pair.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TemplateFormat' => [ 'base' => NULL, 'refs' => [ 'CreateRecommendationTemplateRequest$format' => '<p>The format for the recommendation template.</p> <dl> <dt>CfnJson</dt> <dd> <p>The template is CloudFormation JSON.</p> </dd> <dt>CfnYaml</dt> <dd> <p>The template is CloudFormation YAML.</p> </dd> </dl>', 'RecommendationTemplate$format' => '<p>The format of the recommendation template.</p> <dl> <dt>CfnJson</dt> <dd> <p>The template is CloudFormation JSON.</p> </dd> <dt>CfnYaml</dt> <dd> <p>The template is CloudFormation YAML.</p> </dd> </dl>', ], ], 'TerraformSource' => [ 'base' => '<p> The Terraform s3 state file you need to import. </p>', 'refs' => [ 'TerraformSourceList$member' => NULL, ], ], 'TerraformSourceList' => [ 'base' => NULL, 'refs' => [ 'ImportResourcesToDraftAppVersionRequest$terraformSources' => '<p> A list of terraform file s3 URLs you need to import. </p>', 'ImportResourcesToDraftAppVersionResponse$terraformSources' => '<p> A list of terraform file s3 URLs you need to import. </p>', ], ], 'TestRecommendation' => [ 'base' => '<p>Defines a test recommendation.</p>', 'refs' => [ 'TestRecommendationList$member' => NULL, ], ], 'TestRecommendationList' => [ 'base' => NULL, 'refs' => [ 'ListTestRecommendationsResponse$testRecommendations' => '<p>The test recommendations for the Resilience Hub application.</p>', ], ], 'TestRisk' => [ 'base' => NULL, 'refs' => [ 'TestRecommendation$risk' => '<p>The level of risk for this test recommendation.</p>', ], ], 'TestType' => [ 'base' => NULL, 'refs' => [ 'TestRecommendation$type' => '<p>The type of test recommendation.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The limit on the number of requests per second was exceeded.</p>', 'refs' => [], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'App$creationTime' => '<p>The timestamp for when the app was created.</p>', 'App$lastAppComplianceEvaluationTime' => '<p>The timestamp for the most recent compliance evaluation.</p>', 'App$lastResiliencyScoreEvaluationTime' => '<p>The timestamp for the most recent resiliency score evaluation.</p>', 'AppAssessment$endTime' => '<p>The end time for the action.</p>', 'AppAssessment$startTime' => '<p>The starting time for the action.</p>', 'AppAssessmentSummary$endTime' => '<p>The end time for the action.</p>', 'AppAssessmentSummary$startTime' => '<p>The starting time for the action.</p>', 'AppSummary$creationTime' => '<p>The timestamp for when the app was created.</p>', 'DescribeDraftAppVersionResourcesImportStatusResponse$statusChangeTime' => '<p>The timestamp for when the status last changed.</p>', 'RecommendationTemplate$endTime' => '<p>The end time for the action.</p>', 'RecommendationTemplate$startTime' => '<p>The start time for the action.</p>', 'ResiliencyPolicy$creationTime' => '<p>The timestamp for when the resiliency policy was created.</p>', ], ], 'UnsupportedResource' => [ 'base' => '<p>Defines a resource that is not supported by Resilience Hub.</p>', 'refs' => [ 'UnsupportedResourceList$member' => NULL, ], ], 'UnsupportedResourceList' => [ 'base' => NULL, 'refs' => [ 'ListUnsupportedAppVersionResourcesResponse$unsupportedResources' => '<p>The unsupported resources for the application.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAppResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResiliencyPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResiliencyPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'AlarmRecommendation$recommendationId' => '<p>The identifier of the alarm recommendation.</p>', 'RecommendationIdList$member' => NULL, 'SopRecommendation$recommendationId' => '<p>Identifier for the SOP recommendation.</p>', 'TestRecommendation$recommendationId' => '<p>Identifier for the test recommendation.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Indicates that a request was not valid.</p>', 'refs' => [], ], ],];
