<?php
// This file was auto-generated from sdk-root/src/data/redshift-serverless/2021-04-21/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is an interface reference for Amazon Redshift Serverless. It contains documentation for one of the programming or command line interfaces you can use to manage Amazon Redshift Serverless. </p> <p>Amazon Redshift Serverless automatically provisions data warehouse capacity and intelligently scales the underlying resources based on workload demands. Amazon Redshift Serverless adjusts capacity in seconds to deliver consistently high performance and simplified operations for even the most demanding and volatile workloads. Amazon Redshift Serverless lets you focus on using your data to acquire new insights for your business and customers. </p> <p> To learn more about Amazon Redshift Serverless, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-whatis.html">What is Amazon Redshift Serverless</a>. </p>', 'operations' => [ 'ConvertRecoveryPointToSnapshot' => '<p>Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html">Working with snapshots and recovery points</a>.</p>', 'CreateEndpointAccess' => '<p>Creates an Amazon Redshift Serverless managed VPC endpoint.</p>', 'CreateNamespace' => '<p>Creates a namespace in Amazon Redshift Serverless.</p>', 'CreateSnapshot' => '<p>Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html"> Working with snapshots and recovery points</a>.</p>', 'CreateUsageLimit' => '<p>Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier. </p>', 'CreateWorkgroup' => '<p>Creates an workgroup in Amazon Redshift Serverless.</p>', 'DeleteEndpointAccess' => '<p>Deletes an Amazon Redshift Serverless managed VPC endpoint.</p>', 'DeleteNamespace' => '<p>Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.</p>', 'DeleteResourcePolicy' => '<p>Deletes the specified resource policy.</p>', 'DeleteSnapshot' => '<p>Deletes a snapshot from Amazon Redshift Serverless.</p>', 'DeleteUsageLimit' => '<p>Deletes a usage limit from Amazon Redshift Serverless.</p>', 'DeleteWorkgroup' => '<p>Deletes a workgroup.</p>', 'GetCredentials' => '<p>Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.</p> <p>By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes).</p> <pre><code> &lt;p&gt; The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources. &lt;/p&gt; &lt;p&gt; If the &lt;code&gt;DbName&lt;/code&gt; parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.&lt;/p&gt; </code></pre>', 'GetEndpointAccess' => '<p>Returns information, such as the name, about a VPC endpoint.</p>', 'GetNamespace' => '<p>Returns information about a namespace in Amazon Redshift Serverless.</p>', 'GetRecoveryPoint' => '<p>Returns information about a recovery point.</p>', 'GetResourcePolicy' => '<p>Returns a resource policy.</p>', 'GetSnapshot' => '<p>Returns information about a specific snapshot.</p>', 'GetUsageLimit' => '<p>Returns information about a usage limit.</p>', 'GetWorkgroup' => '<p>Returns information about a specific workgroup.</p>', 'ListEndpointAccess' => '<p>Returns an array of <code>EndpointAccess</code> objects and relevant information.</p>', 'ListNamespaces' => '<p>Returns information about a list of specified namespaces.</p>', 'ListRecoveryPoints' => '<p>Returns an array of recovery points.</p>', 'ListSnapshots' => '<p>Returns a list of snapshots.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned to a resource.</p>', 'ListUsageLimits' => '<p>Lists all usage limits within Amazon Redshift Serverless.</p>', 'ListWorkgroups' => '<p>Returns information about a list of specified workgroups.</p>', 'PutResourcePolicy' => '<p>Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.</p>', 'RestoreFromRecoveryPoint' => '<p>Restore the data from a recovery point.</p>', 'RestoreFromSnapshot' => '<p>Restores a namespace from a snapshot.</p>', 'TagResource' => '<p>Assigns one or more tags to a resource.</p>', 'UntagResource' => '<p>Removes a tag or set of tags from a resource.</p>', 'UpdateEndpointAccess' => '<p>Updates an Amazon Redshift Serverless managed endpoint.</p>', 'UpdateNamespace' => '<p>Updates a namespace with the specified settings.</p>', 'UpdateSnapshot' => '<p>Updates a snapshot.</p>', 'UpdateUsageLimit' => '<p>Update a usage limit in Amazon Redshift Serverless. You can\'t update the usage type or period of a usage limit.</p>', 'UpdateWorkgroup' => '<p>Updates a workgroup with the specified configuration settings.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'Snapshot$accountsWithProvisionedRestoreAccess' => '<p>All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.</p>', 'Snapshot$accountsWithRestoreAccess' => '<p>All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to list tags for.</p>', 'ResourceNotFoundException$resourceName' => '<p>The name of the resource that could not be found.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to tag.</p>', 'TooManyTagsException$resourceName' => '<p>The name of the resource that exceeded the number of tags allowed for a resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to remove tags from.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateWorkgroupRequest$enhancedVpcRouting' => '<p>The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.</p>', 'CreateWorkgroupRequest$publiclyAccessible' => '<p>A value that specifies whether the workgroup can be accessed from a public network.</p>', 'UpdateWorkgroupRequest$enhancedVpcRouting' => '<p>The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.</p>', 'UpdateWorkgroupRequest$publiclyAccessible' => '<p>A value that specifies whether the workgroup can be accessible from a public network.</p>', 'Workgroup$enhancedVpcRouting' => '<p>The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.</p>', 'Workgroup$publiclyAccessible' => '<p>A value that specifies whether the workgroup can be accessible from a public network</p>', ], ], 'ConfigParameter' => [ 'base' => '<p>An array of key-value pairs to set for advanced control over Amazon Redshift Serverless.</p>', 'refs' => [ 'ConfigParameterList$member' => NULL, ], ], 'ConfigParameterList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkgroupRequest$configParameters' => '<p>An array of parameters to set for more control over a serverless database. The options are <code>datestyle</code>, <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, and <code>max_query_execution_time</code>.</p>', 'UpdateWorkgroupRequest$configParameters' => '<p>An array of parameters to set for advanced control over a database. The options are <code>datestyle</code>, <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, and <code>max_query_execution_time</code>.</p>', 'Workgroup$configParameters' => '<p>An array of parameters to set for finer control over a database. The options are <code>datestyle</code>, <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, and <code>max_query_execution_time</code>.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The submitted action has conflicts.</p>', 'refs' => [], ], 'ConvertRecoveryPointToSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConvertRecoveryPointToSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUsageLimitRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUsageLimitResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkgroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkgroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DbName' => [ 'base' => NULL, 'refs' => [ 'GetCredentialsRequest$dbName' => '<p>The name of the database to get temporary authorization to log on to.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 64 alphanumeric characters or hyphens.</p> </li> <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Must not contain a colon ( : ) or slash ( / ).</p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words </a> in the Amazon Redshift Database Developer Guide</p> </li> </ul>', ], ], 'DbPassword' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$adminUserPassword' => '<p>The password of the administrator for the first database created in the namespace.</p>', 'GetCredentialsResponse$dbPassword' => '<p>A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database <code>DbName</code>.</p>', 'UpdateNamespaceRequest$adminUserPassword' => '<p>The password of the administrator for the first database created in the namespace.</p>', ], ], 'DbUser' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$adminUsername' => '<p>The username of the administrator for the first database created in the namespace.</p>', 'GetCredentialsResponse$dbUser' => '<p>A database user name that is authorized to log on to the database <code>DbName</code> using the password <code>DbPassword</code>. If the specified <code>DbUser</code> exists in the database, the new user name has the same database privileges as the the user named in <code>DbUser</code>. By default, the user is added to PUBLIC.</p>', 'Namespace$adminUsername' => '<p>The username of the administrator for the first database created in the namespace.</p>', 'UpdateNamespaceRequest$adminUsername' => '<p>The username of the administrator for the first database created in the namespace.</p>', ], ], 'DeleteEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUsageLimitRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUsageLimitResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkgroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkgroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RecoveryPoint$totalSizeInMegaBytes' => '<p>The total size of the data in the recovery point in megabytes.</p>', 'Snapshot$actualIncrementalBackupSizeInMegaBytes' => '<p>The size of the incremental backup in megabytes.</p>', 'Snapshot$backupProgressInMegaBytes' => '<p>The size in megabytes of the data that has been backed up to a snapshot.</p>', 'Snapshot$currentBackupRateInMegaBytesPerSecond' => '<p>The rate at which data is backed up into a snapshot in megabytes per second.</p>', 'Snapshot$totalBackupSizeInMegaBytes' => '<p>The total size, in megabytes, of how big the snapshot is.</p>', ], ], 'Endpoint' => [ 'base' => '<p>The VPC endpoint object.</p>', 'refs' => [ 'Workgroup$endpoint' => '<p>The endpoint that is created from the workgroup.</p>', ], ], 'EndpointAccess' => [ 'base' => '<p>Information about an Amazon Redshift Serverless VPC endpoint.</p>', 'refs' => [ 'CreateEndpointAccessResponse$endpoint' => '<p>The created VPC endpoint.</p>', 'DeleteEndpointAccessResponse$endpoint' => '<p>The deleted VPC endpoint.</p>', 'EndpointAccessList$member' => NULL, 'GetEndpointAccessResponse$endpoint' => '<p>The returned VPC endpoint.</p>', 'UpdateEndpointAccessResponse$endpoint' => '<p>The updated VPC endpoint.</p>', ], ], 'EndpointAccessList' => [ 'base' => NULL, 'refs' => [ 'ListEndpointAccessResponse$endpoints' => '<p>The returned VPC endpoints.</p>', ], ], 'GetCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCredentialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecoveryPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecoveryPointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUsageLimitRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUsageLimitResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkgroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkgroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'IamRoleArnList$member' => NULL, ], ], 'IamRoleArnList' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$iamRoles' => '<p>A list of IAM roles to associate with the namespace.</p>', 'Namespace$iamRoles' => '<p>A list of IAM roles to associate with the namespace.</p>', 'UpdateNamespaceRequest$iamRoles' => '<p>A list of IAM roles to associate with the namespace.</p>', ], ], 'InsufficientCapacityException' => [ 'base' => '<p>There is an insufficient capacity to perform the action.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ConvertRecoveryPointToSnapshotRequest$retentionPeriod' => '<p>How long to retain the snapshot.</p>', 'CreateSnapshotRequest$retentionPeriod' => '<p>How long to retain the created snapshot.</p>', 'CreateWorkgroupRequest$baseCapacity' => '<p>The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).</p>', 'DeleteNamespaceRequest$finalSnapshotRetentionPeriod' => '<p>How long to retain the final snapshot.</p>', 'Endpoint$port' => '<p>The port that Amazon Redshift Serverless listens on.</p>', 'EndpointAccess$port' => '<p>The port number on which Amazon Redshift Serverless accepts incoming connections.</p>', 'GetCredentialsRequest$durationSeconds' => '<p>The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum is 3600 seconds.</p>', 'Snapshot$snapshotRemainingDays' => '<p>The amount of days until the snapshot is deleted.</p>', 'Snapshot$snapshotRetentionPeriod' => '<p>The period of time, in days, of how long the snapshot is retained.</p>', 'UpdateSnapshotRequest$retentionPeriod' => '<p>The new retention period of the snapshot.</p>', 'UpdateWorkgroupRequest$baseCapacity' => '<p>The new base data warehouse capacity in Redshift Processing Units (RPUs).</p>', 'Workgroup$baseCapacity' => '<p>The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'InvalidPaginationException' => [ 'base' => '<p>The provided pagination token is invalid.</p>', 'refs' => [], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'Snapshot$kmsKeyId' => '<p>The unique identifier of the KMS key used to encrypt the snapshot.</p>', ], ], 'ListEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointAccessRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListEndpointAccessRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', ], ], 'ListEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListNamespacesRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', ], ], 'ListNamespacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRecoveryPointsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', ], ], 'ListRecoveryPointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSnapshotsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSnapshotsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', ], ], 'ListSnapshotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageLimitsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageLimitsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListUsageLimitsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results. The default is 100.</p>', ], ], 'ListUsageLimitsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkgroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkgroupsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListWorkgroupsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', ], ], 'ListWorkgroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogExport' => [ 'base' => NULL, 'refs' => [ 'LogExportList$member' => NULL, ], ], 'LogExportList' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$logExports' => '<p>The types of logs the namespace can export. Available export types are <code>userlog</code>, <code>connectionlog</code>, and <code>useractivitylog</code>.</p>', 'Namespace$logExports' => '<p>The types of logs the namespace can export. Available export types are User log, Connection log, and User activity log.</p>', 'UpdateNamespaceRequest$logExports' => '<p>The types of logs the namespace can export. The export types are <code>userlog</code>, <code>connectionlog</code>, and <code>useractivitylog</code>.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitRequest$amount' => '<p>The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.</p>', 'Snapshot$elapsedTimeInSeconds' => '<p>The amount of time it took to back up data into a snapshot.</p>', 'Snapshot$estimatedSecondsToCompletion' => '<p>The estimated amount of seconds until the snapshot completes backup.</p>', 'UpdateUsageLimitRequest$amount' => '<p>The new limit amount. For more information about this parameter.</p>', 'UsageLimit$amount' => '<p>The limit amount. If time-based, this amount is in RPUs consumed per hour. If data-based, this amount is in terabytes (TB). The value must be a positive number.</p>', ], ], 'Namespace' => [ 'base' => '<p>A collection of database objects and users.</p>', 'refs' => [ 'CreateNamespaceResponse$namespace' => '<p>The created namespace object.</p>', 'DeleteNamespaceResponse$namespace' => '<p>The deleted namespace object.</p>', 'GetNamespaceResponse$namespace' => '<p>The returned namespace object.</p>', 'NamespaceList$member' => NULL, 'RestoreFromRecoveryPointResponse$namespace' => '<p>The namespace that data was restored into.</p>', 'RestoreFromSnapshotResponse$namespace' => NULL, 'UpdateNamespaceResponse$namespace' => '<p>A list of tag instances.</p>', ], ], 'NamespaceList' => [ 'base' => NULL, 'refs' => [ 'ListNamespacesResponse$namespaces' => '<p>The list of returned namespaces.</p>', ], ], 'NamespaceName' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$namespaceName' => '<p>The name of the namespace.</p>', 'CreateWorkgroupRequest$namespaceName' => '<p>The name of the namespace to associate with the workgroup.</p>', 'DeleteNamespaceRequest$namespaceName' => '<p>The name of the namespace to delete.</p>', 'GetNamespaceRequest$namespaceName' => '<p>The name of the namespace to retrieve information for.</p>', 'ListRecoveryPointsRequest$namespaceName' => '<p>The name of the namespace to list recovery points for.</p>', 'Namespace$namespaceName' => '<p>The name of the namespace. Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p>', 'RecoveryPoint$namespaceName' => '<p>The name of the namespace the recovery point is associated with.</p>', 'RestoreFromRecoveryPointRequest$namespaceName' => '<p>The name of the namespace to restore data into.</p>', 'RestoreFromSnapshotRequest$namespaceName' => '<p>The name of the namespace to restore the snapshot to.</p>', 'UpdateNamespaceRequest$namespaceName' => '<p>The name of the namespace.</p>', ], ], 'NamespaceStatus' => [ 'base' => NULL, 'refs' => [ 'Namespace$status' => '<p>The status of the namespace.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Contains information about a network interface in an Amazon Redshift Serverless managed VPC endpoint. </p>', 'refs' => [ 'NetworkInterfaceList$member' => NULL, ], ], 'NetworkInterfaceList' => [ 'base' => NULL, 'refs' => [ 'VpcEndpoint$networkInterfaces' => '<p>One or more network interfaces of the endpoint. Also known as an interface endpoint.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListUsageLimitsRequest$nextToken' => '<p>If your initial <code>ListUsageLimits</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListUsageLimits</code> operations, which returns results in the next page. </p>', 'ListUsageLimitsResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', ], ], 'ParameterKey' => [ 'base' => NULL, 'refs' => [ 'ConfigParameter$parameterKey' => '<p>The key of the parameter. The options are <code>datestyle</code>, <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, and <code>max_query_execution_time</code>.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ConfigParameter$parameterValue' => '<p>The value of the parameter to set.</p>', ], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RecoveryPoint' => [ 'base' => '<p>The automatically created recovery point of a namespace. Recovery points are created every 30 minutes and kept for 24 hours.</p>', 'refs' => [ 'GetRecoveryPointResponse$recoveryPoint' => '<p>The returned recovery point object.</p>', 'RecoveryPointList$member' => NULL, ], ], 'RecoveryPointList' => [ 'base' => NULL, 'refs' => [ 'ListRecoveryPointsResponse$recoveryPoints' => '<p>The returned recovery point objects.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource could not be found.</p>', 'refs' => [], ], 'ResourcePolicy' => [ 'base' => '<p>The resource policy object. Currently, you can use policies to share snapshots across Amazon Web Services accounts.</p>', 'refs' => [ 'GetResourcePolicyResponse$resourcePolicy' => '<p>The returned resource policy.</p>', 'PutResourcePolicyResponse$resourcePolicy' => '<p>The policy that was created or updated.</p>', ], ], 'RestoreFromRecoveryPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreFromRecoveryPointResponse' => [ 'base' => NULL, 'refs' => [], ], 'RestoreFromSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreFromSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkgroupRequest$securityGroupIds' => '<p>An array of security group IDs to associate with the workgroup.</p>', 'UpdateWorkgroupRequest$securityGroupIds' => '<p>An array of security group IDs to associate with the workgroup.</p>', 'Workgroup$securityGroupIds' => '<p>An array of security group IDs to associate with the workgroup.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service limit was exceeded.</p>', 'refs' => [], ], 'Snapshot' => [ 'base' => '<p>A snapshot object that contains databases.</p>', 'refs' => [ 'ConvertRecoveryPointToSnapshotResponse$snapshot' => '<p>The snapshot converted from the recovery point.</p>', 'CreateSnapshotResponse$snapshot' => '<p>The created snapshot object.</p>', 'DeleteSnapshotResponse$snapshot' => '<p>The deleted snapshot object.</p>', 'GetSnapshotResponse$snapshot' => '<p>The returned snapshot object.</p>', 'SnapshotList$member' => NULL, 'UpdateSnapshotResponse$snapshot' => '<p>The updated snapshot object.</p>', ], ], 'SnapshotList' => [ 'base' => NULL, 'refs' => [ 'ListSnapshotsResponse$snapshots' => '<p>All of the returned snapshot objects.</p>', ], ], 'SnapshotStatus' => [ 'base' => NULL, 'refs' => [ 'Snapshot$status' => '<p>The status of the snapshot.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$code' => NULL, 'AccessDeniedException$message' => NULL, 'AccountIdList$member' => NULL, 'ConflictException$message' => NULL, 'ConvertRecoveryPointToSnapshotRequest$recoveryPointId' => '<p>The unique identifier of the recovery point.</p>', 'ConvertRecoveryPointToSnapshotRequest$snapshotName' => '<p>The name of the snapshot.</p>', 'CreateEndpointAccessRequest$endpointName' => '<p>The name of the VPC endpoint. An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can\'t contain two consecutive hyphens or end with a hyphen.</p>', 'CreateEndpointAccessRequest$workgroupName' => '<p>The name of the workgroup to associate with the VPC endpoint.</p>', 'CreateNamespaceRequest$dbName' => '<p>The name of the first database created in the namespace.</p>', 'CreateNamespaceRequest$defaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.</p>', 'CreateNamespaceRequest$kmsKeyId' => '<p>The ID of the Amazon Web Services Key Management Service key used to encrypt your data.</p>', 'CreateSnapshotRequest$namespaceName' => '<p>The namespace to create a snapshot for.</p>', 'CreateSnapshotRequest$snapshotName' => '<p>The name of the snapshot.</p>', 'CreateUsageLimitRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.</p>', 'DeleteEndpointAccessRequest$endpointName' => '<p>The name of the VPC endpoint to delete.</p>', 'DeleteNamespaceRequest$finalSnapshotName' => '<p>The name of the snapshot to be created before the namespace is deleted.</p>', 'DeleteResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the policy to delete.</p>', 'DeleteSnapshotRequest$snapshotName' => '<p>The name of the snapshot to be deleted.</p>', 'DeleteUsageLimitRequest$usageLimitId' => '<p>The unique identifier of the usage limit to delete.</p>', 'Endpoint$address' => '<p>The DNS address of the VPC endpoint.</p>', 'EndpointAccess$address' => '<p>The DNS address of the endpoint.</p>', 'EndpointAccess$endpointArn' => '<p>The Amazon Resource Name (ARN) of the VPC endpoint.</p>', 'EndpointAccess$endpointName' => '<p>The name of the VPC endpoint.</p>', 'EndpointAccess$endpointStatus' => '<p>The status of the VPC endpoint.</p>', 'EndpointAccess$workgroupName' => '<p>The name of the workgroup associated with the endpoint.</p>', 'GetEndpointAccessRequest$endpointName' => '<p>The name of the VPC endpoint to return information for.</p>', 'GetRecoveryPointRequest$recoveryPointId' => '<p>The unique identifier of the recovery point to return information for.</p>', 'GetResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to return.</p>', 'GetSnapshotRequest$ownerAccount' => '<p>The owner Amazon Web Services account of a snapshot shared with another user.</p>', 'GetSnapshotRequest$snapshotArn' => '<p>The Amazon Resource Name (ARN) of the snapshot to return.</p>', 'GetSnapshotRequest$snapshotName' => '<p>The name of the snapshot to return.</p>', 'GetUsageLimitRequest$usageLimitId' => '<p>The unique identifier of the usage limit to return information for.</p>', 'InsufficientCapacityException$message' => NULL, 'InternalServerException$message' => NULL, 'InvalidPaginationException$message' => NULL, 'ListEndpointAccessRequest$nextToken' => '<p>If your initial <code>ListEndpointAccess</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListEndpointAccess</code> operations, which returns results in the next page.</p>', 'ListEndpointAccessRequest$vpcId' => '<p>The unique identifier of the virtual private cloud with access to Amazon Redshift Serverless.</p>', 'ListEndpointAccessRequest$workgroupName' => '<p>The name of the workgroup associated with the VPC endpoint to return.</p>', 'ListEndpointAccessResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListNamespacesRequest$nextToken' => '<p>If your initial <code>ListNamespaces</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListNamespaces</code> operations, which returns results in the next page.</p>', 'ListNamespacesResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListRecoveryPointsRequest$nextToken' => '<p>If your initial <code>ListRecoveryPoints</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListRecoveryPoints</code> operations, which returns results in the next page.</p>', 'ListRecoveryPointsResponse$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListSnapshotsRequest$namespaceArn' => '<p>The Amazon Resource Name (ARN) of the namespace from which to list all snapshots.</p>', 'ListSnapshotsRequest$namespaceName' => '<p>The namespace from which to list all snapshots.</p>', 'ListSnapshotsRequest$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListSnapshotsRequest$ownerAccount' => '<p>The owner Amazon Web Services account of the snapshot.</p>', 'ListSnapshotsResponse$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListUsageLimitsRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) associated with the resource whose usage limits you want to list.</p>', 'ListWorkgroupsRequest$nextToken' => '<p>If your initial ListWorkgroups operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent ListNamespaces operations, which returns results in the next page.</p>', 'ListWorkgroupsResponse$nextToken' => '<p> If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, make the call again using the returned token.</p>', 'Namespace$dbName' => '<p>The name of the first database created in the namespace.</p>', 'Namespace$defaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.</p>', 'Namespace$kmsKeyId' => '<p>The ID of the Amazon Web Services Key Management Service key used to encrypt your data.</p>', 'Namespace$namespaceArn' => '<p>The Amazon Resource Name (ARN) associated with a namespace.</p>', 'Namespace$namespaceId' => '<p>The unique identifier of a namespace.</p>', 'NetworkInterface$availabilityZone' => '<p>The availability Zone.</p>', 'NetworkInterface$networkInterfaceId' => '<p>The unique identifier of the network interface.</p>', 'NetworkInterface$privateIpAddress' => '<p>The IPv4 address of the network interface within the subnet.</p>', 'NetworkInterface$subnetId' => '<p>The unique identifier of the subnet.</p>', 'PutResourcePolicyRequest$policy' => '<p>The policy to create or update. For example, the following policy grants a user authorization to restore a snapshot.</p> <p> <code>"{\\"Version\\": \\"2012-10-17\\", \\"Statement\\" : [{ \\"Sid\\": \\"AllowUserRestoreFromSnapshot\\", \\"Principal\\":{\\"AWS\\": [\\"739247239426\\"]}, \\"Action\\": [\\"redshift-serverless:RestoreFromSnapshot\\"] , \\"Effect\\": \\"Allow\\" }]}"</code> </p>', 'PutResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the account to create or update a resource policy for.</p>', 'RecoveryPoint$recoveryPointId' => '<p>The unique identifier of the recovery point.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourcePolicy$policy' => '<p>The resource policy.</p>', 'ResourcePolicy$resourceArn' => '<p>The Amazon Resource Name (ARN) of the policy.</p>', 'RestoreFromRecoveryPointRequest$recoveryPointId' => '<p>The unique identifier of the recovery point to restore from.</p>', 'RestoreFromRecoveryPointResponse$recoveryPointId' => '<p>The unique identifier of the recovery point used for the restore.</p>', 'RestoreFromSnapshotRequest$ownerAccount' => '<p>The Amazon Web Services account that owns the snapshot.</p>', 'RestoreFromSnapshotRequest$snapshotArn' => '<p>The Amazon Resource Name (ARN) of the snapshot to restore from.</p>', 'RestoreFromSnapshotRequest$snapshotName' => '<p>The name of the snapshot to restore from.</p>', 'RestoreFromSnapshotResponse$ownerAccount' => '<p>The owner Amazon Web Services; account of the snapshot that was restored.</p>', 'RestoreFromSnapshotResponse$snapshotName' => '<p>The name of the snapshot used to restore the namespace.</p>', 'ServiceQuotaExceededException$message' => NULL, 'Snapshot$adminUsername' => '<p>The username of the database within a snapshot.</p>', 'Snapshot$namespaceArn' => '<p>The Amazon Resource Name (ARN) of the namespace the snapshot was created from.</p>', 'Snapshot$namespaceName' => '<p>The name of the namepsace.</p>', 'Snapshot$ownerAccount' => '<p>The owner Amazon Web Services; account of the snapshot.</p>', 'Snapshot$snapshotArn' => '<p>The Amazon Resource Name (ARN) of the snapshot.</p>', 'Snapshot$snapshotName' => '<p>The name of the snapshot.</p>', 'ThrottlingException$code' => NULL, 'ThrottlingException$message' => NULL, 'TooManyTagsException$message' => NULL, 'UpdateEndpointAccessRequest$endpointName' => '<p>The name of the VPC endpoint to update.</p>', 'UpdateNamespaceRequest$defaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.</p>', 'UpdateNamespaceRequest$kmsKeyId' => '<p>The ID of the Amazon Web Services Key Management Service key used to encrypt your data.</p>', 'UpdateSnapshotRequest$snapshotName' => '<p>The name of the snapshot.</p>', 'UpdateUsageLimitRequest$usageLimitId' => '<p>The identifier of the usage limit to update.</p>', 'UsageLimit$resourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the Amazon Redshift Serverless resource.</p>', 'UsageLimit$usageLimitArn' => '<p>The Amazon Resource Name (ARN) of the resource associated with the usage limit.</p>', 'UsageLimit$usageLimitId' => '<p>The identifier of the usage limit.</p>', 'ValidationException$message' => NULL, 'VpcEndpoint$vpcEndpointId' => '<p>The connection endpoint ID for connecting to Amazon Redshift Serverless.</p>', 'VpcEndpoint$vpcId' => '<p>The VPC identifier that the endpoint is associated with.</p>', 'VpcSecurityGroupMembership$status' => '<p>The status of the VPC security group.</p>', 'Workgroup$namespaceName' => '<p>The namespace the workgroup is associated with.</p>', 'Workgroup$workgroupArn' => '<p>The Amazon Resource Name (ARN) that links to the workgroup.</p>', 'Workgroup$workgroupId' => '<p>The unique identifier of the workgroup.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIdList$member' => NULL, ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointAccessRequest$subnetIds' => '<p>The unique identifers of subnets from which Amazon Redshift Serverless chooses one to deploy a VPC endpoint.</p>', 'CreateWorkgroupRequest$subnetIds' => '<p>An array of VPC subnet IDs to associate with the workgroup.</p>', 'EndpointAccess$subnetIds' => '<p>The unique identifier of subnets where Amazon Redshift Serverless choose to deploy the VPC endpoint.</p>', 'UpdateWorkgroupRequest$subnetIds' => '<p>An array of VPC subnet IDs to associate with the workgroup.</p>', 'Workgroup$subnetIds' => '<p>An array of subnet IDs the workgroup is associated with.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'EndpointAccess$endpointCreateTime' => '<p>The time that the endpoint was created.</p>', 'Namespace$creationDate' => '<p>The date of when the namespace was created.</p>', 'RecoveryPoint$recoveryPointCreateTime' => '<p>The time the recovery point is created.</p>', 'Snapshot$snapshotCreateTime' => '<p>The timestamp of when the snapshot was created.</p>', 'Snapshot$snapshotRetentionStartTime' => '<p>The timestamp of when data within the snapshot started getting retained.</p>', 'Workgroup$creationDate' => '<p>The creation date of the workgroup.</p>', ], ], 'Tag' => [ 'base' => '<p>A map of key-value pairs.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key to use in the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag or set of tags to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$tags' => '<p>A list of tag instances.</p>', 'CreateWorkgroupRequest$tags' => '<p>A array of tag instances.</p>', 'ListTagsForResourceResponse$tags' => '<p>A map of the key-value pairs assigned to the resource.</p>', 'TagResourceRequest$tags' => '<p>The map of the key-value pairs used to tag the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value of the tag.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetCredentialsResponse$expiration' => '<p>The date and time the password in <code>DbPassword</code> expires.</p>', 'GetCredentialsResponse$nextRefreshTime' => '<p>The date and time of when the <code>DbUser</code> and <code>DbPassword</code> authorization refreshes.</p>', 'ListRecoveryPointsRequest$endTime' => '<p>The time when creation of the recovery point finished.</p>', 'ListRecoveryPointsRequest$startTime' => '<p>The time when the recovery point\'s creation was initiated.</p>', 'ListSnapshotsRequest$endTime' => '<p>The timestamp showing when the snapshot creation finished.</p>', 'ListSnapshotsRequest$startTime' => '<p>The time when the creation of the snapshot was initiated.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The request exceeded the number of tags allowed for a resource.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUsageLimitRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUsageLimitResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkgroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkgroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UsageLimit' => [ 'base' => '<p>The usage limit object.</p>', 'refs' => [ 'CreateUsageLimitResponse$usageLimit' => '<p>The returned usage limit object.</p>', 'DeleteUsageLimitResponse$usageLimit' => '<p>The deleted usage limit object.</p>', 'GetUsageLimitResponse$usageLimit' => '<p>The returned usage limit object.</p>', 'UpdateUsageLimitResponse$usageLimit' => '<p>The updated usage limit object.</p>', 'UsageLimits$member' => NULL, ], ], 'UsageLimitBreachAction' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitRequest$breachAction' => '<p>The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.</p>', 'UpdateUsageLimitRequest$breachAction' => '<p>The new action that Amazon Redshift Serverless takes when the limit is reached.</p>', 'UsageLimit$breachAction' => '<p>The action that Amazon Redshift Serverless takes when the limit is reached.</p>', ], ], 'UsageLimitPeriod' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitRequest$period' => '<p>The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.</p>', 'UsageLimit$period' => '<p>The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.</p>', ], ], 'UsageLimitUsageType' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitRequest$usageType' => '<p>The type of Amazon Redshift Serverless usage to create a usage limit for.</p>', 'ListUsageLimitsRequest$usageType' => '<p>The Amazon Redshift Serverless feature whose limits you want to see.</p>', 'UsageLimit$usageType' => '<p>The Amazon Redshift Serverless feature to limit.</p>', ], ], 'UsageLimits' => [ 'base' => NULL, 'refs' => [ 'ListUsageLimitsResponse$usageLimits' => '<p>An array of returned usage limit objects.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input failed to satisfy the constraints specified by an AWS service.</p>', 'refs' => [], ], 'VpcEndpoint' => [ 'base' => '<p>The connection endpoint for connecting to Amazon Redshift Serverless through the proxy.</p>', 'refs' => [ 'EndpointAccess$vpcEndpoint' => '<p>The connection endpoint for connecting to Amazon Redshift Serverless.</p>', 'VpcEndpointList$member' => NULL, ], ], 'VpcEndpointList' => [ 'base' => NULL, 'refs' => [ 'Endpoint$vpcEndpoints' => '<p>An array of <code>VpcEndpoint</code> objects.</p>', ], ], 'VpcSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'VpcSecurityGroupIdList$member' => NULL, 'VpcSecurityGroupMembership$vpcSecurityGroupId' => '<p>The unique identifier of the VPC security group.</p>', ], ], 'VpcSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointAccessRequest$vpcSecurityGroupIds' => '<p>The unique identifiers of the security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>', 'UpdateEndpointAccessRequest$vpcSecurityGroupIds' => '<p>The list of VPC security groups associated with the endpoint after the endpoint is modified.</p>', ], ], 'VpcSecurityGroupMembership' => [ 'base' => '<p>Describes the members of a VPC security group.</p>', 'refs' => [ 'VpcSecurityGroupMembershipList$member' => NULL, ], ], 'VpcSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'EndpointAccess$vpcSecurityGroups' => '<p>The security groups associated with the endpoint.</p>', ], ], 'Workgroup' => [ 'base' => '<p>The collection of computing resources from which an endpoint is created.</p>', 'refs' => [ 'CreateWorkgroupResponse$workgroup' => '<p>The created workgroup object.</p>', 'DeleteWorkgroupResponse$workgroup' => '<p>The deleted workgroup object.</p>', 'GetWorkgroupResponse$workgroup' => '<p>The returned workgroup object.</p>', 'UpdateWorkgroupResponse$workgroup' => '<p>The updated workgroup object.</p>', 'WorkgroupList$member' => NULL, ], ], 'WorkgroupList' => [ 'base' => NULL, 'refs' => [ 'ListWorkgroupsResponse$workgroups' => '<p>The returned array of workgroups.</p>', ], ], 'WorkgroupName' => [ 'base' => NULL, 'refs' => [ 'CreateWorkgroupRequest$workgroupName' => '<p>The name of the created workgroup.</p>', 'DeleteWorkgroupRequest$workgroupName' => '<p>The name of the workgroup to be deleted.</p>', 'GetCredentialsRequest$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'GetWorkgroupRequest$workgroupName' => '<p>The name of the workgroup to return information for.</p>', 'RecoveryPoint$workgroupName' => '<p>The name of the workgroup the recovery point is associated with.</p>', 'RestoreFromRecoveryPointRequest$workgroupName' => '<p>The name of the workgroup used to restore data.</p>', 'RestoreFromSnapshotRequest$workgroupName' => '<p>The name of the workgroup used to restore the snapshot.</p>', 'UpdateWorkgroupRequest$workgroupName' => '<p>The name of the workgroup to update.</p>', 'Workgroup$workgroupName' => '<p>The name of the workgroup.</p>', ], ], 'WorkgroupStatus' => [ 'base' => NULL, 'refs' => [ 'Workgroup$status' => '<p>The status of the workgroup.</p>', ], ], ],];
