<?php
// This file was auto-generated from sdk-root/src/data/ram/2018-01-04/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the <i>Resource Access Manager API Reference</i>. This documentation provides descriptions and syntax for each of the actions and data types in RAM. RAM is a service that helps you securely share your Amazon Web Services resources across Amazon Web Services accounts. If you have multiple Amazon Web Services accounts, you can use RAM to share those resources with other accounts. If you use Organizations to manage your accounts, then you share your resources with your organization or organizational units (OUs). For supported resource types, you can also share resources with individual Identity and Access Management (IAM) roles an users. </p> <p>To learn more about RAM, see the following resources:</p> <ul> <li> <p> <a href="http://aws.amazon.com/ram">Resource Access Manager product page</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/ram/latest/userguide/">Resource Access Manager User Guide</a> </p> </li> </ul>', 'operations' => [ 'AcceptResourceShareInvitation' => '<p>Accepts an invitation to a resource share from another Amazon Web Services account. After you accept the invitation, the resources included in the resource share are available to interact with in the relevant Amazon Web Services Management Consoles and tools.</p>', 'AssociateResourceShare' => '<p>Adds the specified list of principals and list of resources to a resource share. Principals that already have access to this resource share immediately receive access to the added resources. Newly added principals immediately receive access to the resources shared in this resource share. </p>', 'AssociateResourceSharePermission' => '<p>Adds or replaces the RAM permission for a resource type included in a resource share. You can have exactly one permission associated with each resource type in the resource share. You can add a new RAM permission only if there are currently no resources of that resource type currently in the resource share.</p>', 'CreateResourceShare' => '<p>Creates a resource share. You can provide a list of the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> for the resources that you want to share, a list of principals you want to share the resources with, and the permissions to grant those principals.</p> <note> <p>Sharing a resource makes it available for use by principals outside of the Amazon Web Services account that created the resource. Sharing doesn\'t change any permissions or quotas that apply to the resource in the account that created it.</p> </note>', 'DeleteResourceShare' => '<p>Deletes the specified resource share. This doesn\'t delete any of the resources that were associated with the resource share; it only stops the sharing of those resources outside of the Amazon Web Services account that created them.</p>', 'DisassociateResourceShare' => '<p>Disassociates the specified principals or resources from the specified resource share.</p>', 'DisassociateResourceSharePermission' => '<p>Disassociates an RAM permission from a resource share. Permission changes take effect immediately. You can remove a RAM permission from a resource share only if there are currently no resources of the relevant resource type currently attached to the resource share.</p>', 'EnableSharingWithAwsOrganization' => '<p>Enables resource sharing within your organization in Organizations. Calling this operation enables RAM to retrieve information about the organization and its structure. This lets you share resources with all of the accounts in an organization by specifying the organization\'s ID, or all of the accounts in an organizational unit (OU) by specifying the OU\'s ID. Until you enable sharing within the organization, you can specify only individual Amazon Web Services accounts, or for supported resource types, IAM users and roles.</p> <p>You must call this operation from an IAM user or role in the organization\'s management account.</p>', 'GetPermission' => '<p>Gets the contents of an RAM permission in JSON format.</p>', 'GetResourcePolicies' => '<p>Retrieves the resource policies for the specified resources that you own and have shared.</p>', 'GetResourceShareAssociations' => '<p>Retrieves the resource and principal associations for resource shares that you own.</p>', 'GetResourceShareInvitations' => '<p>Retrieves details about invitations that you have received for resource shares.</p>', 'GetResourceShares' => '<p>Retrieves details about the resource shares that you own or that are shared with you.</p>', 'ListPendingInvitationResources' => '<p>Lists the resources in a resource share that is shared with you but for which the invitation is still <code>PENDING</code>. That means that you haven\'t accepted or rejected the invitation and the invitation hasn\'t expired.</p>', 'ListPermissionVersions' => '<p>Lists the available versions of the specified RAM permission.</p>', 'ListPermissions' => '<p>Retrieves a list of available RAM permissions that you can use for the supported resource types. </p>', 'ListPrincipals' => '<p>Lists the principals that you are sharing resources with or that are sharing resources with you.</p>', 'ListResourceSharePermissions' => '<p>Lists the RAM permissions that are associated with a resource share.</p>', 'ListResourceTypes' => '<p>Lists the resource types that can be shared by RAM.</p>', 'ListResources' => '<p>Lists the resources that you added to a resource share or the resources that are shared with you.</p>', 'PromoteResourceShareCreatedFromPolicy' => '<p>When you attach a resource-based permission policy to a resource, it automatically creates a resource share. However, resource shares created this way are visible only to the resource share owner, and the resource share can\'t be modified in RAM.</p> <p>You can use this operation to promote the resource share to a full RAM resource share. When you promote a resource share, you can then manage the resource share in RAM and it becomes visible to all of the principals you shared it with.</p>', 'RejectResourceShareInvitation' => '<p>Rejects an invitation to a resource share from another Amazon Web Services account.</p>', 'TagResource' => '<p>Adds the specified tag keys and values to the specified resource share. The tags are attached only to the resource share, not to the resources that are in the resource share.</p>', 'UntagResource' => '<p>Removes the specified tag key and value pairs from the specified resource share.</p>', 'UpdateResourceShare' => '<p>Modifies some of the properties of the specified resource share.</p>', ], 'shapes' => [ 'AcceptResourceShareInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AcceptResourceShareInvitationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResourceSharePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResourceSharePermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResourceShareRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateResourceShareResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceSharePermissionRequest$replace' => '<p>Specifies whether the specified permission should replace or add to the existing permission associated with the resource share. Use <code>true</code> to replace the current permissions. Use <code>false</code> to add the permission to the current permission. The default value is <code>false</code>.</p> <note> <p>A resource share can have only one permission per resource type. If a resource share already has a permission for the specified resource type and you don\'t set <code>replace</code> to <code>true</code> then the operation returns an error. This helps prevent accidental overwriting of a permission.</p> </note>', 'AssociateResourceSharePermissionResponse$returnValue' => '<p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>', 'CreateResourceShareRequest$allowExternalPrincipals' => '<p>Specifies whether principals outside your organization in Organizations can be associated with a resource share. A value of <code>true</code> lets you share with individual Amazon Web Services accounts that are <i>not</i> in your organization. A value of <code>false</code> only has meaning if your account is a member of an Amazon Web Services Organization. The default value is <code>true</code>.</p>', 'DeleteResourceShareResponse$returnValue' => '<p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>', 'DisassociateResourceSharePermissionResponse$returnValue' => '<p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>', 'EnableSharingWithAwsOrganizationResponse$returnValue' => '<p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>', 'Principal$external' => '<p>Indicates whether the principal belongs to the same organization in Organizations as the Amazon Web Services account that owns the resource share.</p>', 'PromoteResourceShareCreatedFromPolicyResponse$returnValue' => '<p>A return value of <code>true</code> indicates that the request succeeded. A value of <code>false</code> indicates that the request failed.</p>', 'ResourceShare$allowExternalPrincipals' => '<p>Indicates whether principals outside your organization in Organizations can be associated with a resource share.</p>', 'ResourceShareAssociation$external' => '<p>Indicates whether the principal belongs to the same organization in Organizations as the Amazon Web Services account that owns the resource share.</p>', 'ResourceSharePermissionDetail$defaultVersion' => '<p>Specifies whether the version of the permission represented in this structure is the default version for this permission.</p>', 'ResourceSharePermissionDetail$isResourceTypeDefault' => '<p>Specifies whether the version of the permission represented in this structure is the default version for all resources of this resource type.</p>', 'ResourceSharePermissionSummary$defaultVersion' => '<p>Specifies whether the version of the permission represented in this structure is the default version for this permission.</p>', 'ResourceSharePermissionSummary$isResourceTypeDefault' => '<p>Specifies whether the version of the permission represented in this structure is the default version for all resources of this resource type.</p>', 'UpdateResourceShareRequest$allowExternalPrincipals' => '<p>Specifies whether principals outside your organization in Organizations can be associated with a resource share.</p>', ], ], 'CreateResourceShareRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateResourceShareResponse' => [ 'base' => NULL, 'refs' => [], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'Principal$creationTime' => '<p>The date and time when the principal was associated with the resource share.</p>', 'Principal$lastUpdatedTime' => '<p>The date and time when the association was last updated.</p>', 'Resource$creationTime' => '<p>The date and time when the resource was associated with the resource share.</p>', 'Resource$lastUpdatedTime' => '<p>The date an time when the association was last updated.</p>', 'ResourceShare$creationTime' => '<p>The date and time when the resource share was created.</p>', 'ResourceShare$lastUpdatedTime' => '<p>The date and time when the resource share was last updated.</p>', 'ResourceShareAssociation$creationTime' => '<p>The date and time when the association was created.</p>', 'ResourceShareAssociation$lastUpdatedTime' => '<p>The date and time when the association was last updated.</p>', 'ResourceShareInvitation$invitationTimestamp' => '<p>The date and time when the invitation was sent.</p>', 'ResourceSharePermissionDetail$creationTime' => '<p>The date and time when the permission was created.</p>', 'ResourceSharePermissionDetail$lastUpdatedTime' => '<p>The date and time when the permission was last updated.</p>', 'ResourceSharePermissionSummary$creationTime' => '<p>The date and time when the permission was created.</p>', 'ResourceSharePermissionSummary$lastUpdatedTime' => '<p>The date and time when the permission was last updated.</p>', ], ], 'DeleteResourceShareRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourceShareResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResourceSharePermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResourceSharePermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResourceShareRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateResourceShareResponse' => [ 'base' => NULL, 'refs' => [], ], 'EnableSharingWithAwsOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'EnableSharingWithAwsOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceShareAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceShareAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceShareInvitationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceShareInvitationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceSharesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourceSharesResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdempotentParameterMismatchException' => [ 'base' => '<p>The client token input parameter was matched one used with a previous call to the operation, but at least one of the other input parameters is different from the previous call.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceSharePermissionRequest$permissionVersion' => '<p>Specifies the version of the RAM permission to associate with the resource share. If you don\'t specify this parameter, the operation uses the version designated as the default. You can use the <a>ListPermissionVersions</a> operation to discover the available versions of a permission.</p>', 'GetPermissionRequest$permissionVersion' => '<p>Specifies identifier for the version of the RAM permission to retrieve. If you don\'t specify this parameter, the operation retrieves the default version.</p>', ], ], 'InvalidClientTokenException' => [ 'base' => '<p>The client token is not valid.</p>', 'refs' => [], ], 'InvalidMaxResultsException' => [ 'base' => '<p>The specified value for <code>MaxResults</code> is not valid.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The specified value for <code>NextToken</code> is not valid.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>A parameter is not valid.</p>', 'refs' => [], ], 'InvalidResourceTypeException' => [ 'base' => '<p>The specified resource type is not valid.</p>', 'refs' => [], ], 'InvalidStateTransitionException' => [ 'base' => '<p>The requested state transition is not valid.</p>', 'refs' => [], ], 'ListPendingInvitationResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPendingInvitationResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPrincipalsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPrincipalsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceSharePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceSharePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourceTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MalformedArnException' => [ 'base' => '<p>The format of an Amazon Resource Name (ARN) is not valid.</p>', 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetResourcePoliciesRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'GetResourceShareAssociationsRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'GetResourceShareInvitationsRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'GetResourceSharesRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListPendingInvitationResourcesRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListPermissionVersionsRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListPermissionsRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListPrincipalsRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListResourceSharePermissionsRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListResourceTypesRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', 'ListResourcesRequest$maxResults' => '<p>Specifies the total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the number you specify, the <code>NextToken</code> response element is returned with a value (not null). Include the specified value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p>', ], ], 'MissingRequiredParameterException' => [ 'base' => '<p>A required input parameter is missing.</p>', 'refs' => [], ], 'OperationNotPermittedException' => [ 'base' => '<p>The requested operation is not permitted.</p>', 'refs' => [], ], 'PermissionArnList' => [ 'base' => NULL, 'refs' => [ 'CreateResourceShareRequest$permissionArns' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.</p>', ], ], 'Policy' => [ 'base' => NULL, 'refs' => [ 'PolicyList$member' => NULL, ], ], 'PolicyList' => [ 'base' => NULL, 'refs' => [ 'GetResourcePoliciesResponse$policies' => '<p>An array of resource policy documents in JSON format.</p>', ], ], 'Principal' => [ 'base' => '<p>Describes a principal for use with Resource Access Manager.</p>', 'refs' => [ 'PrincipalList$member' => NULL, ], ], 'PrincipalArnOrIdList' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceShareRequest$principals' => '<p>Specifies a list of principals to whom you want to the resource share. This can be <code>null</code> if you want to add only resources.</p> <p>What the principals can do with the resources in the share is determined by the RAM permissions that you associate with the resource share. See <a>AssociateResourceSharePermission</a>.</p> <p>You can include the following values:</p> <ul> <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li> <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li> <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li> <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li> <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li> </ul> <note> <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p> </note>', 'CreateResourceShareRequest$principals' => '<p>Specifies a list of one or more principals to associate with the resource share.</p> <p>You can include the following values:</p> <ul> <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li> <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li> <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li> <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li> <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li> </ul> <note> <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p> </note>', 'DisassociateResourceShareRequest$principals' => '<p>Specifies a list of one or more principals that no longer are to have access to the resources in this resource share.</p> <p>You can include the following values:</p> <ul> <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li> <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li> <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li> <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li> <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li> </ul> <note> <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p> </note>', 'ListPrincipalsRequest$principals' => '<p>Specifies that you want to list information for only the listed principals.</p> <p>You can include the following values:</p> <ul> <li> <p>An Amazon Web Services account ID, for example: <code>123456789012</code> </p> </li> <li> <p>An <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations, for example: <code>organizations::123456789012:organization/o-exampleorgid</code> </p> </li> <li> <p>An ARN of an organizational unit (OU) in Organizations, for example: <code>organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123</code> </p> </li> <li> <p>An ARN of an IAM role, for example: <code>iam::123456789012:role/rolename</code> </p> </li> <li> <p>An ARN of an IAM user, for example: <code>iam::123456789012user/username</code> </p> </li> </ul> <note> <p>Not all resource types can be shared with IAM roles and users. For more information, see <a href="https://docs.aws.amazon.com/ram/latest/userguide/permissions.html#permissions-rbp-supported-resource-types">Sharing with IAM roles and users</a> in the <i>Resource Access Manager User Guide</i>.</p> </note>', ], ], 'PrincipalList' => [ 'base' => NULL, 'refs' => [ 'ListPrincipalsResponse$principals' => '<p>An array of objects that contain the details about the principals.</p>', ], ], 'PromoteResourceShareCreatedFromPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PromoteResourceShareCreatedFromPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RejectResourceShareInvitationRequest' => [ 'base' => NULL, 'refs' => [], ], 'RejectResourceShareInvitationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Resource' => [ 'base' => '<p>Describes a resource associated with a resource share in RAM.</p>', 'refs' => [ 'ResourceList$member' => NULL, ], ], 'ResourceArnList' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceShareRequest$resourceArns' => '<p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resources that you want to share. This can be <code>null</code> if you want to add only principals.</p>', 'CreateResourceShareRequest$resourceArns' => '<p>Specifies a list of one or more ARNs of the resources to associate with the resource share.</p>', 'DisassociateResourceShareRequest$resourceArns' => '<p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> for one or more resources that you want to remove from the resource share. After the operation runs, these resources are no longer shared with principals outside of the Amazon Web Services account that created the resources.</p>', 'GetResourcePoliciesRequest$resourceArns' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resources whose policies you want to retrieve.</p>', 'ListResourcesRequest$resourceArns' => '<p>Specifies that you want to list only the resource shares that include resources with the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', ], ], 'ResourceArnNotFoundException' => [ 'base' => '<p>The specified Amazon Resource Name (ARN) was not found.</p>', 'refs' => [], ], 'ResourceList' => [ 'base' => NULL, 'refs' => [ 'ListPendingInvitationResourcesResponse$resources' => '<p>An array of objects that contain the information about the resources included the specified resource share.</p>', 'ListResourcesResponse$resources' => '<p>An array of objects that contain information about the resources.</p>', ], ], 'ResourceOwner' => [ 'base' => NULL, 'refs' => [ 'GetResourceSharesRequest$resourceOwner' => '<p>Specifies that you want to retrieve details of only those resource shares that match the following:</p> <ul> <li> <p> <b> <code>SELF</code> </b> – resource shares that your account shares with other accounts</p> </li> <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resource shares that other accounts share with your account</p> </li> </ul>', 'ListPrincipalsRequest$resourceOwner' => '<p>Specifies that you want to list information for only resource shares that match the following:</p> <ul> <li> <p> <b> <code>SELF</code> </b> – principals that your account is sharing resources with</p> </li> <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – principals that are sharing resources with your account</p> </li> </ul>', 'ListResourcesRequest$resourceOwner' => '<p>Specifies that you want to list only the resource shares that match the following:</p> <ul> <li> <p> <b> <code>SELF</code> </b> – resources that your account shares with other accounts</p> </li> <li> <p> <b> <code>OTHER-ACCOUNTS</code> </b> – resources that other accounts share with your account</p> </li> </ul>', ], ], 'ResourceRegionScope' => [ 'base' => NULL, 'refs' => [ 'Resource$resourceRegionScope' => '<p>Specifies the scope of visibility of this resource:</p> <ul> <li> <p> <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web Services Region in which the resource exists.</p> </li> <li> <p> <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.</p> </li> </ul>', 'ServiceNameAndResourceType$resourceRegionScope' => '<p>Specifies the scope of visibility of resources of this type:</p> <ul> <li> <p> <b>REGIONAL</b> – The resource can be accessed only by using requests that target the Amazon Web Services Region in which the resource exists.</p> </li> <li> <p> <b>GLOBAL</b> – The resource can be accessed from any Amazon Web Services Region.</p> </li> </ul>', ], ], 'ResourceRegionScopeFilter' => [ 'base' => NULL, 'refs' => [ 'ListPendingInvitationResourcesRequest$resourceRegionScope' => '<p>Specifies that you want the results to include only resources that have the specified scope.</p> <ul> <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li> <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li> <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li> </ul> <p>The default value is <code>ALL</code>.</p>', 'ListResourceTypesRequest$resourceRegionScope' => '<p>Specifies that you want the results to include only resources that have the specified scope.</p> <ul> <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li> <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li> <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li> </ul> <p>The default value is <code>ALL</code>.</p>', 'ListResourcesRequest$resourceRegionScope' => '<p>Specifies that you want the results to include only resources that have the specified scope.</p> <ul> <li> <p> <code>ALL</code> – the results include both global and regional resources or resource types.</p> </li> <li> <p> <code>GLOBAL</code> – the results include only global resources or resource types.</p> </li> <li> <p> <code>REGIONAL</code> – the results include only regional resources or resource types.</p> </li> </ul> <p>The default value is <code>ALL</code>.</p>', ], ], 'ResourceShare' => [ 'base' => '<p>Describes a resource share in RAM.</p>', 'refs' => [ 'CreateResourceShareResponse$resourceShare' => '<p>An object with information about the new resource share.</p>', 'ResourceShareList$member' => NULL, 'UpdateResourceShareResponse$resourceShare' => '<p>Information about the resource share.</p>', ], ], 'ResourceShareArnList' => [ 'base' => NULL, 'refs' => [ 'GetResourceShareAssociationsRequest$resourceShareArns' => '<p>Specifies a list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resource share whose associations you want to retrieve.</p>', 'GetResourceShareInvitationsRequest$resourceShareArns' => '<p>Specifies that you want details about invitations only for the resource shares described by this list of <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> </p>', 'GetResourceSharesRequest$resourceShareArns' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of individual resource shares that you want information about.</p>', 'ListPrincipalsRequest$resourceShareArns' => '<p>Specifies that you want to list information for only principals associated with the resource shares specified by a list the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', 'ListResourcesRequest$resourceShareArns' => '<p>Specifies that you want to list only resources in the resource shares identified by the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a>.</p>', ], ], 'ResourceShareAssociation' => [ 'base' => '<p>Describes an association with a resource share and either a principal or a resource.</p>', 'refs' => [ 'ResourceShareAssociationList$member' => NULL, ], ], 'ResourceShareAssociationList' => [ 'base' => NULL, 'refs' => [ 'AssociateResourceShareResponse$resourceShareAssociations' => '<p>An array of objects that contain information about the associations.</p>', 'DisassociateResourceShareResponse$resourceShareAssociations' => '<p>An array of objects that contain information about the updated associations for this resource share.</p>', 'GetResourceShareAssociationsResponse$resourceShareAssociations' => '<p>An array of objects that contain the details about the associations.</p>', 'ResourceShareInvitation$resourceShareAssociations' => '<p>To view the resources associated with a pending resource share invitation, use <a>ListPendingInvitationResources</a>.</p>', ], ], 'ResourceShareAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'GetResourceShareAssociationsRequest$associationStatus' => '<p>Specifies that you want to retrieve only associations with this status.</p>', 'ResourceShareAssociation$status' => '<p>The current status of the association.</p>', ], ], 'ResourceShareAssociationType' => [ 'base' => NULL, 'refs' => [ 'GetResourceShareAssociationsRequest$associationType' => '<p>Specifies whether you want to retrieve the associations that involve a specified resource or principal.</p> <ul> <li> <p> <code>PRINCIPAL</code> – list the principals that are associated with the specified resource share.</p> </li> <li> <p> <code>RESOURCE</code> – list the resources that are associated with the specified resource share.</p> </li> </ul>', 'ResourceShareAssociation$associationType' => '<p>The type of entity included in this association.</p>', ], ], 'ResourceShareFeatureSet' => [ 'base' => NULL, 'refs' => [ 'ResourceShare$featureSet' => '<p>Indicates how the resource share was created. Possible values include:</p> <ul> <li> <p> <code>CREATED_FROM_POLICY</code> - Indicates that the resource share was created from an Identity and Access Management (IAM) resource-based permission policy attached to the resource. This type of resource share is visible only to the Amazon Web Services account that created it. You can\'t modify it in RAM unless you promote it. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.</p> </li> <li> <p> <code>PROMOTING_TO_STANDARD</code> - The resource share is in the process of being promoted. For more information, see <a>PromoteResourceShareCreatedFromPolicy</a>.</p> </li> <li> <p> <code>STANDARD</code> - Indicates that the resource share was created in RAM using the console or APIs. These resource shares are visible to all principals you share the resource share with. You can modify these resource shares in RAM using the console or APIs.</p> </li> </ul>', ], ], 'ResourceShareInvitation' => [ 'base' => '<p>Describes an invitation for an Amazon Web Services account to join a resource share.</p>', 'refs' => [ 'AcceptResourceShareInvitationResponse$resourceShareInvitation' => '<p>An object that contains information about the specified invitation.</p>', 'RejectResourceShareInvitationResponse$resourceShareInvitation' => '<p>An object that contains the details about the rejected invitation.</p>', 'ResourceShareInvitationList$member' => NULL, ], ], 'ResourceShareInvitationAlreadyAcceptedException' => [ 'base' => '<p>The specified invitation was already accepted.</p>', 'refs' => [], ], 'ResourceShareInvitationAlreadyRejectedException' => [ 'base' => '<p>The specified invitation was already rejected.</p>', 'refs' => [], ], 'ResourceShareInvitationArnList' => [ 'base' => NULL, 'refs' => [ 'GetResourceShareInvitationsRequest$resourceShareInvitationArns' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> of the resource share invitations you want information about.</p>', ], ], 'ResourceShareInvitationArnNotFoundException' => [ 'base' => '<p>The specified Amazon Resource Name (ARN) for an invitation was not found.</p>', 'refs' => [], ], 'ResourceShareInvitationExpiredException' => [ 'base' => '<p>The specified invitation is expired.</p>', 'refs' => [], ], 'ResourceShareInvitationList' => [ 'base' => NULL, 'refs' => [ 'GetResourceShareInvitationsResponse$resourceShareInvitations' => '<p>An array of objects that contain the details about the invitations.</p>', ], ], 'ResourceShareInvitationStatus' => [ 'base' => NULL, 'refs' => [ 'ResourceShareInvitation$status' => '<p>The current status of the invitation.</p>', ], ], 'ResourceShareLimitExceededException' => [ 'base' => '<p>This request would exceed the limit for resource shares for your account.</p>', 'refs' => [], ], 'ResourceShareList' => [ 'base' => NULL, 'refs' => [ 'GetResourceSharesResponse$resourceShares' => '<p>An array of objects that contain the information about the resource shares.</p>', ], ], 'ResourceSharePermissionDetail' => [ 'base' => '<p>Information about an RAM permission.</p>', 'refs' => [ 'GetPermissionResponse$permission' => '<p>An object that contains information about the permission.</p>', ], ], 'ResourceSharePermissionList' => [ 'base' => NULL, 'refs' => [ 'ListPermissionVersionsResponse$permissions' => '<p>An array of objects that contain details for each of the available versions.</p>', 'ListPermissionsResponse$permissions' => '<p>An array of objects with information about the permissions.</p>', 'ListResourceSharePermissionsResponse$permissions' => '<p>An array of objects that describe the permissions associated with the resource share.</p>', ], ], 'ResourceSharePermissionSummary' => [ 'base' => '<p>Information about an RAM permission that is associated with a resource share and any of its resources of a specified type.</p>', 'refs' => [ 'ResourceSharePermissionList$member' => NULL, ], ], 'ResourceShareStatus' => [ 'base' => NULL, 'refs' => [ 'GetResourceSharesRequest$resourceShareStatus' => '<p>Specifies that you want to retrieve details of only those resource shares that have this status.</p>', 'ResourceShare$status' => '<p>The current status of the resource share.</p>', ], ], 'ResourceStatus' => [ 'base' => NULL, 'refs' => [ 'Resource$status' => '<p>The current status of the resource.</p>', ], ], 'ServerInternalException' => [ 'base' => '<p>The service could not respond to the request due to an internal problem.</p>', 'refs' => [], ], 'ServiceNameAndResourceType' => [ 'base' => '<p>Information about a shareable resource type and the Amazon Web Services service to which resources of that type belong.</p>', 'refs' => [ 'ServiceNameAndResourceTypeList$member' => NULL, ], ], 'ServiceNameAndResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'ListResourceTypesResponse$resourceTypes' => '<p>An array of objects that contain information about the resource types that can be shared using RAM.</p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is not available.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AcceptResourceShareInvitationRequest$resourceShareInvitationArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation that you want to accept.</p>', 'AcceptResourceShareInvitationRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p>', 'AcceptResourceShareInvitationResponse$clientToken' => '<p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>', 'AssociateResourceSharePermissionRequest$resourceShareArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to which you want to add or replace permissions.</p>', 'AssociateResourceSharePermissionRequest$permissionArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the RAM permission to associate with the resource share. To find the ARN for a permission, use either the <a>ListPermissions</a> operation or go to the <a href="https://console.aws.amazon.com/ram/home#Permissions:">Permissions library</a> page in the RAM console and then choose the name of the permission. The ARN is displayed on the detail page.</p>', 'AssociateResourceSharePermissionRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p>', 'AssociateResourceSharePermissionResponse$clientToken' => '<p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>', 'AssociateResourceShareRequest$resourceShareArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to add principals or resources to.</p>', 'AssociateResourceShareRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p>', 'AssociateResourceShareResponse$clientToken' => '<p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>', 'CreateResourceShareRequest$name' => '<p>Specifies the name of the resource share.</p>', 'CreateResourceShareRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p>', 'CreateResourceShareResponse$clientToken' => '<p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>', 'DeleteResourceShareRequest$resourceShareArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to delete.</p>', 'DeleteResourceShareRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p>', 'DeleteResourceShareResponse$clientToken' => '<p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>', 'DisassociateResourceSharePermissionRequest$resourceShareArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share from which you want to disassociate a permission.</p>', 'DisassociateResourceSharePermissionRequest$permissionArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the permission to disassociate from the resource share. Changes to permissions take effect immediately.</p>', 'DisassociateResourceSharePermissionRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p>', 'DisassociateResourceSharePermissionResponse$clientToken' => '<p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>', 'DisassociateResourceShareRequest$resourceShareArn' => '<p>Specifies <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to remove resources from.</p>', 'DisassociateResourceShareRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p>', 'DisassociateResourceShareResponse$clientToken' => '<p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>', 'GetPermissionRequest$permissionArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the permission whose contents you want to retrieve. To find the ARN for a permission, use either the <a>ListPermissions</a> operation or go to the <a href="https://console.aws.amazon.com/ram/home#Permissions:">Permissions library</a> page in the RAM console and then choose the name of the permission. The ARN is displayed on the detail page.</p>', 'GetResourcePoliciesRequest$principal' => '<p>Specifies the principal.</p>', 'GetResourcePoliciesRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'GetResourcePoliciesResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'GetResourceShareAssociationsRequest$resourceArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource whose resource shares you want to retrieve.</p> <p>You cannot specify this parameter if the association type is <code>PRINCIPAL</code>.</p>', 'GetResourceShareAssociationsRequest$principal' => '<p>Specifies the ID of the principal whose resource shares you want to retrieve. This can be an Amazon Web Services account ID, an organization ID, an organizational unit ID, or the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an individual IAM user or role.</p> <p>You cannot specify this parameter if the association type is <code>RESOURCE</code>.</p>', 'GetResourceShareAssociationsRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'GetResourceShareAssociationsResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'GetResourceShareInvitationsRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'GetResourceShareInvitationsResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'GetResourceSharesRequest$name' => '<p>Specifies the name of an individual resource share that you want to retrieve details about.</p>', 'GetResourceSharesRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'GetResourceSharesRequest$permissionArn' => '<p>Specifies that you want to retrieve details of only those resource shares that use the RAM permission with this <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a>.</p>', 'GetResourceSharesResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'IdempotentParameterMismatchException$message' => NULL, 'InvalidClientTokenException$message' => NULL, 'InvalidMaxResultsException$message' => NULL, 'InvalidNextTokenException$message' => NULL, 'InvalidParameterException$message' => NULL, 'InvalidResourceTypeException$message' => NULL, 'InvalidStateTransitionException$message' => NULL, 'ListPendingInvitationResourcesRequest$resourceShareInvitationArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation. You can use <a>GetResourceShareInvitations</a> to find the ARN of the invitation.</p>', 'ListPendingInvitationResourcesRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListPendingInvitationResourcesResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListPermissionVersionsRequest$permissionArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the RAM permission whose versions you want to list. You can use the <code>permissionVersion</code> parameter on the <a>AssociateResourceSharePermission</a> operation to specify a non-default version to attach.</p>', 'ListPermissionVersionsRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListPermissionVersionsResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListPermissionsRequest$resourceType' => '<p>Specifies that you want to list permissions for only the specified resource type. For example, to list only permissions that apply to EC2 subnets, specify <code>ec2:Subnet</code>. You can use the <a>ListResourceTypes</a> operation to get the specific string required.</p>', 'ListPermissionsRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListPermissionsResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListPrincipalsRequest$resourceArn' => '<p>Specifies that you want to list principal information for the resource share with the specified <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a>.</p>', 'ListPrincipalsRequest$resourceType' => '<p>Specifies that you want to list information for only principals associated with resource shares that include the specified resource type.</p> <p>For a list of valid values, query the <a>ListResourceTypes</a> operation.</p>', 'ListPrincipalsRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListPrincipalsResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListResourceSharePermissionsRequest$resourceShareArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share for which you want to retrieve the associated permissions.</p>', 'ListResourceSharePermissionsRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListResourceSharePermissionsResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListResourceTypesRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListResourceTypesResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'ListResourcesRequest$principal' => '<p>Specifies that you want to list only the resource shares that are associated with the specified principal.</p>', 'ListResourcesRequest$resourceType' => '<p>Specifies that you want to list only the resource shares that include resources of the specified resource type.</p> <p>For valid values, query the <a>ListResourceTypes</a> operation.</p>', 'ListResourcesRequest$nextToken' => '<p>Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code> response in the previous request. If you did, it indicates that more output is available. Set this parameter to the value provided by the previous call\'s <code>NextToken</code> response to request the next page of results.</p>', 'ListResourcesResponse$nextToken' => '<p>If present, this value indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>. This indicates that this is the last page of results.</p>', 'MalformedArnException$message' => NULL, 'MissingRequiredParameterException$message' => NULL, 'OperationNotPermittedException$message' => NULL, 'PermissionArnList$member' => NULL, 'Principal$id' => '<p>The ID of the principal.</p>', 'Principal$resourceShareArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of a resource share the principal is associated with.</p>', 'PrincipalArnOrIdList$member' => NULL, 'PromoteResourceShareCreatedFromPolicyRequest$resourceShareArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share to promote.</p>', 'RejectResourceShareInvitationRequest$resourceShareInvitationArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation that you want to reject.</p>', 'RejectResourceShareInvitationRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p>', 'RejectResourceShareInvitationResponse$clientToken' => '<p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>', 'Resource$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource.</p>', 'Resource$type' => '<p>The resource type. This takes the form of: <code>service-code</code>:<code>resource-code</code> </p>', 'Resource$resourceShareArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share this resource is associated with.</p>', 'Resource$resourceGroupArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource group. This value is available only if the resource is part of a resource group.</p>', 'Resource$statusMessage' => '<p>A message about the status of the resource.</p>', 'ResourceArnList$member' => NULL, 'ResourceArnNotFoundException$message' => NULL, 'ResourceShare$resourceShareArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share</p>', 'ResourceShare$name' => '<p>The name of the resource share.</p>', 'ResourceShare$owningAccountId' => '<p>The ID of the Amazon Web Services account that owns the resource share.</p>', 'ResourceShare$statusMessage' => '<p>A message about the status of the resource share.</p>', 'ResourceShareArnList$member' => NULL, 'ResourceShareAssociation$resourceShareArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share.</p>', 'ResourceShareAssociation$resourceShareName' => '<p>The name of the resource share.</p>', 'ResourceShareAssociation$associatedEntity' => '<p>The associated entity. This can be either of the following:</p> <ul> <li> <p>For a resource association, this is the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource.</p> </li> <li> <p>For principal associations, this is one of the following:</p> <ul> <li> <p>The ID of an Amazon Web Services account</p> </li> <li> <p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of an organization in Organizations</p> </li> <li> <p>The ARN of an organizational unit (OU) in Organizations</p> </li> <li> <p>The ARN of an IAM role</p> </li> <li> <p>The ARN of an IAM user</p> </li> </ul> </li> </ul>', 'ResourceShareAssociation$statusMessage' => '<p>A message about the status of the association.</p>', 'ResourceShareInvitation$resourceShareInvitationArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the invitation.</p>', 'ResourceShareInvitation$resourceShareName' => '<p>The name of the resource share.</p>', 'ResourceShareInvitation$resourceShareArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share</p>', 'ResourceShareInvitation$senderAccountId' => '<p>The ID of the Amazon Web Services account that sent the invitation.</p>', 'ResourceShareInvitation$receiverAccountId' => '<p>The ID of the Amazon Web Services account that received the invitation.</p>', 'ResourceShareInvitation$receiverArn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the IAM user or role that received the invitation.</p>', 'ResourceShareInvitationAlreadyAcceptedException$message' => NULL, 'ResourceShareInvitationAlreadyRejectedException$message' => NULL, 'ResourceShareInvitationArnList$member' => NULL, 'ResourceShareInvitationArnNotFoundException$message' => NULL, 'ResourceShareInvitationExpiredException$message' => NULL, 'ResourceShareLimitExceededException$message' => NULL, 'ResourceSharePermissionDetail$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of this RAM permission.</p>', 'ResourceSharePermissionDetail$version' => '<p>The version of the permission represented in this structure.</p>', 'ResourceSharePermissionDetail$name' => '<p>The name of this permission.</p>', 'ResourceSharePermissionDetail$resourceType' => '<p>The resource type to which this permission applies.</p>', 'ResourceSharePermissionDetail$permission' => '<p>The permission\'s effect and actions in JSON format. The <code>effect</code> indicates whether the specified actions are allowed or denied. The <code>actions</code> list the operations to which the principal is granted or denied access.</p>', 'ResourceSharePermissionSummary$arn' => '<p>The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the permission you want information about.</p>', 'ResourceSharePermissionSummary$version' => '<p>The version of the permission represented in this structure.</p>', 'ResourceSharePermissionSummary$name' => '<p>The name of this permission.</p>', 'ResourceSharePermissionSummary$resourceType' => '<p>The type of resource to which this permission applies.</p>', 'ResourceSharePermissionSummary$status' => '<p>The current status of the permission.</p>', 'ServerInternalException$message' => NULL, 'ServiceNameAndResourceType$resourceType' => '<p>The type of the resource.</p>', 'ServiceNameAndResourceType$serviceName' => '<p>The name of the Amazon Web Services service to which resources of this type belong.</p>', 'ServiceUnavailableException$message' => NULL, 'TagLimitExceededException$message' => NULL, 'TagPolicyViolationException$message' => NULL, 'TagResourceRequest$resourceShareArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to add tags to.</p>', 'ThrottlingException$message' => NULL, 'UnknownResourceException$message' => NULL, 'UntagResourceRequest$resourceShareArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to remove tags from. The tags are removed from the resource share, not the resources in the resource share.</p>', 'UpdateResourceShareRequest$resourceShareArn' => '<p>Specifies the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resoure Name (ARN)</a> of the resource share that you want to modify.</p>', 'UpdateResourceShareRequest$name' => '<p>If specified, the new name that you want to attach to the resource share.</p>', 'UpdateResourceShareRequest$clientToken' => '<p>Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p> <p>If you don\'t provide this value, then Amazon Web Services generates a random one for you.</p>', 'UpdateResourceShareResponse$clientToken' => '<p>The idempotency identifier associated with this request. If you want to repeat the same operation in an idempotent manner then you must include this value in the <code>clientToken</code> request parameter of that later call. All other parameters must also have the same values that you used in the first call.</p>', ], ], 'Tag' => [ 'base' => '<p>A structure containing a tag. A tag is metadata that you can attach to your resources to help organize and categorize them. You can also use them to help you secure your resources. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web Services resources using tags</a>.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagFilter' => [ 'base' => '<p>A tag key and optional list of possible values that you can use to filter results for tagged resources.</p>', 'refs' => [ 'TagFilters$member' => NULL, ], ], 'TagFilters' => [ 'base' => NULL, 'refs' => [ 'GetResourceSharesRequest$tagFilters' => '<p>Specifies that you want to retrieve details of only those resource shares that match the specified tag keys and values.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key, or name, attached to the tag. Every tag must have a key. Key names are case sensitive.</p>', 'TagFilter$tagKey' => '<p>The tag key. This must have a valid string value and can\'t be empty.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Specifies a list of one or more tag keys that you want to remove.</p>', ], ], 'TagLimitExceededException' => [ 'base' => '<p>This request would exceed the limit for tags for your account.</p>', 'refs' => [], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateResourceShareRequest$tags' => '<p>Specifies one or more tags to attach to the resource share itself. It doesn\'t attach the tags to the resources associated with the resource share.</p>', 'ResourceShare$tags' => '<p>The tag key and value pairs attached to the resource share.</p>', 'TagResourceRequest$tags' => '<p>A list of one or more tag key and value pairs. The tag key must be present and not be an empty string. The tag value must be present but can be an empty string.</p>', ], ], 'TagPolicyViolationException' => [ 'base' => '<p>The specified tag key is a reserved word and can\'t be used.</p>', 'refs' => [], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The string value attached to the tag. The value can be an empty string. Key values are case sensitive.</p>', 'TagValueList$member' => NULL, ], ], 'TagValueList' => [ 'base' => NULL, 'refs' => [ 'TagFilter$tagValues' => '<p>A list of zero or more tag values. If no values are provided, then the filter matches any tag with the specified key, regardless of its value.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>You exceeded the rate at which you are allowed to perform this operation. Please try again later.</p>', 'refs' => [], ], 'UnknownResourceException' => [ 'base' => '<p>A specified resource was not found.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceShareRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateResourceShareResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
