<?php
// This file was auto-generated from sdk-root/src/data/proton/2020-07-20/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the Proton Service API Reference. It provides descriptions, syntax and usage examples for each of the <a href="https://docs.aws.amazon.com/proton/latest/APIReference/API_Operations.html">actions</a> and <a href="https://docs.aws.amazon.com/proton/latest/APIReference/API_Types.html">data types</a> for the Proton service.</p> <p>The documentation for each action shows the Query API request parameters and the XML response.</p> <p>Alternatively, you can use the Amazon Web Services CLI to access an API. For more information, see the <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-welcome.html">Amazon Web Services Command Line Interface User Guide</a>.</p> <p>The Proton service is a two-pronged automation framework. Administrators create service templates to provide standardized infrastructure and deployment tooling for serverless and container based applications. Developers, in turn, select from the available service templates to automate their application or service deployments.</p> <p>Because administrators define the infrastructure and tooling that Proton deploys and manages, they need permissions to use all of the listed API operations.</p> <p>When developers select a specific infrastructure and tooling set, Proton deploys their applications. To monitor their applications that are running on Proton, developers need permissions to the service <i>create</i>, <i>list</i>, <i>update</i> and <i>delete</i> API operations and the service instance <i>list</i> and <i>update</i> API operations.</p> <p>To learn more about Proton administration, see the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/Welcome.html">Proton Administrator Guide</a>.</p> <p>To learn more about deploying serverless and containerized applications on Proton, see the <a href="https://docs.aws.amazon.com/proton/latest/userguide/Welcome.html">Proton User Guide</a>.</p> <p> <b>Ensuring Idempotency</b> </p> <p>When you make a mutating API request, the request typically returns a result before the asynchronous workflows of the operation are complete. Operations might also time out or encounter other server issues before they\'re complete, even if the request already returned a result. This might make it difficult to determine whether the request succeeded. Moreover, you might need to retry the request multiple times to ensure that the operation completes successfully. However, if the original request and the subsequent retries are successful, the operation occurs multiple times. This means that you might create more resources than you intended.</p> <p> <i>Idempotency</i> ensures that an API request action completes no more than one time. With an idempotent request, if the original request action completes successfully, any subsequent retries complete successfully without performing any further actions. However, the result might contain updated information, such as the current creation status.</p> <p>The following lists of APIs are grouped according to methods that ensure idempotency.</p> <p> <b>Idempotent create APIs with a client token</b> </p> <p>The API actions in this list support idempotency with the use of a <i>client token</i>. The corresponding Amazon Web Services CLI commands also support idempotency using a client token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. To make an idempotent API request using one of these actions, specify a client token in the request. We recommend that you <i>don\'t</i> reuse the same client token for other API requests. If you don’t provide a client token for these APIs, a default client token is automatically provided by SDKs.</p> <p>Given a request action that has succeeded:</p> <p>If you retry the request using the same client token and the same parameters, the retry succeeds without performing any further actions other than returning the original resource detail data in the response.</p> <p>If you retry the request using the same client token, but one or more of the parameters are different, the retry throws a <code>ValidationException</code> with an <code>IdempotentParameterMismatch</code> error.</p> <p>Client tokens expire eight hours after a request is made. If you retry the request with the expired token, a new resource is created.</p> <p>If the original resource is deleted and you retry the request, a new resource is created.</p> <p>Idempotent create APIs with a client token:</p> <ul> <li> <p>CreateEnvironmentTemplateVersion</p> </li> <li> <p>CreateServiceTemplateVersion</p> </li> <li> <p>CreateEnvironmentAccountConnection</p> </li> </ul> <p> <b>Idempotent create APIs</b> </p> <p>Given a request action that has succeeded:</p> <p>If you retry the request with an API from this group, and the original resource <i>hasn\'t</i> been modified, the retry succeeds without performing any further actions other than returning the original resource detail data in the response.</p> <p>If the original resource has been modified, the retry throws a <code>ConflictException</code>.</p> <p>If you retry with different input parameters, the retry throws a <code>ValidationException</code> with an <code>IdempotentParameterMismatch</code> error.</p> <p>Idempotent create APIs:</p> <ul> <li> <p>CreateEnvironmentTemplate</p> </li> <li> <p>CreateServiceTemplate</p> </li> <li> <p>CreateEnvironment</p> </li> <li> <p>CreateService</p> </li> </ul> <p> <b>Idempotent delete APIs</b> </p> <p>Given a request action that has succeeded:</p> <p>When you retry the request with an API from this group and the resource was deleted, its metadata is returned in the response.</p> <p>If you retry and the resource doesn\'t exist, the response is empty.</p> <p>In both cases, the retry succeeds.</p> <p>Idempotent delete APIs:</p> <ul> <li> <p>DeleteEnvironmentTemplate</p> </li> <li> <p>DeleteEnvironmentTemplateVersion</p> </li> <li> <p>DeleteServiceTemplate</p> </li> <li> <p>DeleteServiceTemplateVersion</p> </li> <li> <p>DeleteEnvironmentAccountConnection</p> </li> </ul> <p> <b>Asynchronous idempotent delete APIs</b> </p> <p>Given a request action that has succeeded:</p> <p>If you retry the request with an API from this group, if the original request delete operation status is <code>DELETE_IN_PROGRESS</code>, the retry returns the resource detail data in the response without performing any further actions.</p> <p>If the original request delete operation is complete, a retry returns an empty response.</p> <p>Asynchronous idempotent delete APIs:</p> <ul> <li> <p>DeleteEnvironment</p> </li> <li> <p>DeleteService</p> </li> </ul>', 'operations' => [ 'AcceptEnvironmentAccountConnection' => '<p>In a management account, an environment account connection request is accepted. When the environment account connection request is accepted, Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator guide</i>.</p>', 'CancelComponentDeployment' => '<p>Attempts to cancel a component deployment (for a component that is in the <code>IN_PROGRESS</code> deployment status).</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'CancelEnvironmentDeployment' => '<p>Attempts to cancel an environment deployment on an <a>UpdateEnvironment</a> action, if the deployment is <code>IN_PROGRESS</code>. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-update.html">Update an environment</a> in the <i>Proton Administrator guide</i>.</p> <p>The following list includes potential cancellation scenarios.</p> <ul> <li> <p>If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.</p> </li> <li> <p>If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.</p> </li> <li> <p>If the current <a>UpdateEnvironment</a> action succeeds before the cancellation attempt starts, the resulting deployment state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.</p> </li> </ul>', 'CancelServiceInstanceDeployment' => '<p>Attempts to cancel a service instance deployment on an <a>UpdateServiceInstance</a> action, if the deployment is <code>IN_PROGRESS</code>. For more information, see <i>Update a service instance</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-instance-update.html">Proton Administrator guide</a> or the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-instance-update.html">Proton User guide</a>.</p> <p>The following list includes potential cancellation scenarios.</p> <ul> <li> <p>If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.</p> </li> <li> <p>If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.</p> </li> <li> <p>If the current <a>UpdateServiceInstance</a> action succeeds before the cancellation attempt starts, the resulting deployment state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.</p> </li> </ul>', 'CancelServicePipelineDeployment' => '<p>Attempts to cancel a service pipeline deployment on an <a>UpdateServicePipeline</a> action, if the deployment is <code>IN_PROGRESS</code>. For more information, see <i>Update a service pipeline</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-pipeline-update.html">Proton Administrator guide</a> or the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-pipeline-update.html">Proton User guide</a>.</p> <p>The following list includes potential cancellation scenarios.</p> <ul> <li> <p>If the cancellation attempt succeeds, the resulting deployment state is <code>CANCELLED</code>.</p> </li> <li> <p>If the cancellation attempt fails, the resulting deployment state is <code>FAILED</code>.</p> </li> <li> <p>If the current <a>UpdateServicePipeline</a> action succeeds before the cancellation attempt starts, the resulting deployment state is <code>SUCCEEDED</code> and the cancellation attempt has no effect.</p> </li> </ul>', 'CreateComponent' => '<p>Create an Proton component. A component is an infrastructure extension for a service instance.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateEnvironment' => '<p>Deploy a new environment. An Proton environment is created from an environment template that defines infrastructure and resources that can be shared across services.</p> <p class="title"> <b>You can provision environments using the following methods:</b> </p> <ul> <li> <p>Amazon Web Services-managed provisioning: Proton makes direct calls to provision your resources.</p> </li> <li> <p>Self-managed provisioning: Proton makes pull requests on your repository to provide compiled infrastructure as code (IaC) files that your IaC engine uses to provision resources.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html">Environments</a> and <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html">Provisioning methods</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateEnvironmentAccountConnection' => '<p>Create an environment account connection in an environment account so that environment infrastructure resources can be provisioned in the environment account from a management account.</p> <p>An environment account connection is a secure bi-directional connection between a <i>management account</i> and an <i>environment account</i> that maintains authorization and permissions. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator guide</i>.</p>', 'CreateEnvironmentTemplate' => '<p>Create an environment template for Proton. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html">Environment Templates</a> in the <i>Proton Administrator Guide</i>.</p> <p>You can create an environment template in one of the two following ways:</p> <ul> <li> <p>Register and publish a <i>standard</i> environment template that instructs Proton to deploy and manage environment infrastructure.</p> </li> <li> <p>Register and publish a <i>customer managed</i> environment template that connects Proton to your existing provisioned infrastructure that you manage. Proton <i>doesn\'t</i> manage your existing provisioned infrastructure. To create an environment template for customer provisioned and managed infrastructure, include the <code>provisioning</code> parameter and set the value to <code>CUSTOMER_MANAGED</code>. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/template-create.html">Register and publish an environment template</a> in the <i>Proton Administrator Guide</i>.</p> </li> </ul>', 'CreateEnvironmentTemplateVersion' => '<p>Create a new major or minor version of an environment template. A major version of an environment template is a version that <i>isn\'t</i> backwards compatible. A minor version of an environment template is a version that\'s backwards compatible within its major version.</p>', 'CreateRepository' => '<p>Create and register a link to a repository that can be used with self-managed provisioning (infrastructure or pipelines) or for template sync configurations. When you create a repository link, Proton creates a <a href="https://docs.aws.amazon.com/proton/latest/adminguide/using-service-linked-roles.html">service-linked role</a> for you.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self">Self-managed provisioning</a>, <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html">Template bundles</a>, and <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html">Template sync configurations</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateService' => '<p>Create an Proton service. An Proton service is an instantiation of a service template and often includes several service instances and pipeline. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-services.html">Services</a> in the <i>Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-service.html">Services</a> in the <i>Proton User Guide</i>.</p>', 'CreateServiceTemplate' => '<p>Create a service template. The administrator creates a service template to define standardized infrastructure and an optional CI/CD service pipeline. Developers, in turn, select the service template from Proton. If the selected service template includes a service pipeline definition, they provide a link to their source code repository. Proton then deploys and manages the infrastructure defined by the selected service template. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/managing-svc-templates.html">Service Templates</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateServiceTemplateVersion' => '<p>Create a new major or minor version of a service template. A major version of a service template is a version that <i>isn\'t</i> backward compatible. A minor version of a service template is a version that\'s backward compatible within its major version.</p>', 'CreateTemplateSyncConfig' => '<p>Set up a template to create new template versions automatically. When a commit is pushed to your registered <a href="https://docs.aws.amazon.com/proton/latest/APIReference/API_Repository.html">repository</a>, Proton checks for changes to your repository template bundles. If it detects a template bundle change, a new major or minor version of its template is created, if the version doesn’t already exist. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-sync-configs.html">Template sync configurations</a> in the <i>Proton Administrator Guide</i>.</p>', 'DeleteComponent' => '<p>Delete an Proton component resource.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'DeleteEnvironment' => '<p>Delete an environment.</p>', 'DeleteEnvironmentAccountConnection' => '<p>In an environment account, delete an environment account connection.</p> <p>After you delete an environment account connection that’s in use by an Proton environment, Proton <i>can’t</i> manage the environment infrastructure resources until a new environment account connection is accepted for the environment account and associated environment. You\'re responsible for cleaning up provisioned resources that remain without an environment connection.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator guide</i>.</p>', 'DeleteEnvironmentTemplate' => '<p>If no other major or minor versions of an environment template exist, delete the environment template.</p>', 'DeleteEnvironmentTemplateVersion' => '<p>If no other minor versions of an environment template exist, delete a major version of the environment template if it\'s not the <code>Recommended</code> version. Delete the <code>Recommended</code> version of the environment template if no other major versions or minor versions of the environment template exist. A major version of an environment template is a version that\'s not backward compatible.</p> <p>Delete a minor version of an environment template if it <i>isn\'t</i> the <code>Recommended</code> version. Delete a <code>Recommended</code> minor version of the environment template if no other minor versions of the environment template exist. A minor version of an environment template is a version that\'s backward compatible.</p>', 'DeleteRepository' => '<p>De-register and unlink your repository.</p>', 'DeleteService' => '<p>Delete a service, with its instances and pipeline.</p> <note> <p>You can\'t delete a service if it has any service instances that have components attached to them.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p> </note>', 'DeleteServiceTemplate' => '<p>If no other major or minor versions of the service template exist, delete the service template.</p>', 'DeleteServiceTemplateVersion' => '<p>If no other minor versions of a service template exist, delete a major version of the service template if it\'s not the <code>Recommended</code> version. Delete the <code>Recommended</code> version of the service template if no other major versions or minor versions of the service template exist. A major version of a service template is a version that <i>isn\'t</i> backwards compatible.</p> <p>Delete a minor version of a service template if it\'s not the <code>Recommended</code> version. Delete a <code>Recommended</code> minor version of the service template if no other minor versions of the service template exist. A minor version of a service template is a version that\'s backwards compatible.</p>', 'DeleteTemplateSyncConfig' => '<p>Delete a template sync configuration.</p>', 'GetAccountSettings' => '<p>Get detail data for the Proton pipeline service role.</p>', 'GetComponent' => '<p>Get detailed data for a component.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'GetEnvironment' => '<p>Get detailed data for an environment.</p>', 'GetEnvironmentAccountConnection' => '<p>In an environment account, get the detailed data for an environment account connection.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator guide</i>.</p>', 'GetEnvironmentTemplate' => '<p>Get detailed data for an environment template.</p>', 'GetEnvironmentTemplateVersion' => '<p>Get detailed data for a major or minor version of an environment template.</p>', 'GetRepository' => '<p>Get detail data for a repository.</p>', 'GetRepositorySyncStatus' => '<p>Get the sync status of a repository used for Proton template sync. For more information about template sync, see .</p> <note> <p>A repository sync status isn\'t tied to the Proton Repository resource (or any other Proton resource). Therefore, tags on an Proton Repository resource have no effect on this action. Specifically, you can\'t use these tags to control access to this action using Attribute-based access control (ABAC).</p> <p>For more information about ABAC, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/security_iam_service-with-iam.html#security_iam_service-with-iam-tags">ABAC</a> in the <i>Proton Administrator Guide</i>.</p> </note>', 'GetService' => '<p>Get detailed data for a service.</p>', 'GetServiceInstance' => '<p>Get detailed data for a service instance. A service instance is an instantiation of service template and it runs in a specific environment.</p>', 'GetServiceTemplate' => '<p>Get detailed data for a service template.</p>', 'GetServiceTemplateVersion' => '<p>Get detailed data for a major or minor version of a service template.</p>', 'GetTemplateSyncConfig' => '<p>Get detail data for a template sync configuration.</p>', 'GetTemplateSyncStatus' => '<p>Get the status of a template sync.</p>', 'ListComponentOutputs' => '<p>Get a list of component Infrastructure as Code (IaC) outputs.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'ListComponentProvisionedResources' => '<p>List provisioned resources for a component with details.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'ListComponents' => '<p>List components with summary data. You can filter the result list by environment, service, or a single service instance.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'ListEnvironmentAccountConnections' => '<p>View a list of environment account connections.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator guide</i>.</p>', 'ListEnvironmentOutputs' => '<p>List the infrastructure as code outputs for your environment.</p>', 'ListEnvironmentProvisionedResources' => '<p>List the provisioned resources for your environment.</p>', 'ListEnvironmentTemplateVersions' => '<p>List major or minor versions of an environment template with detail data.</p>', 'ListEnvironmentTemplates' => '<p>List environment templates.</p>', 'ListEnvironments' => '<p>List environments with detail data summaries.</p>', 'ListRepositories' => '<p>List repositories with detail data.</p>', 'ListRepositorySyncDefinitions' => '<p>List repository sync definitions with detail data.</p>', 'ListServiceInstanceOutputs' => '<p>Get a list service of instance Infrastructure as Code (IaC) outputs.</p>', 'ListServiceInstanceProvisionedResources' => '<p>List provisioned resources for a service instance with details.</p>', 'ListServiceInstances' => '<p>List service instances with summary data.</p>', 'ListServicePipelineOutputs' => '<p>Get a list of service pipeline Infrastructure as Code (IaC) outputs.</p>', 'ListServicePipelineProvisionedResources' => '<p>List provisioned resources for a service and pipeline with details.</p>', 'ListServiceTemplateVersions' => '<p>List major or minor versions of a service template with detail data.</p>', 'ListServiceTemplates' => '<p>List service templates with detail data.</p>', 'ListServices' => '<p>List services with summaries of detail data.</p>', 'ListTagsForResource' => '<p>List tags for a resource. For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'NotifyResourceDeploymentStatusChange' => '<p>Notify Proton of status changes to a provisioned resource when you use self-managed provisioning.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self">Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.</p>', 'RejectEnvironmentAccountConnection' => '<p>In a management account, reject an environment account connection from another environment account.</p> <p>After you reject an environment account connection request, you <i>can\'t</i> accept or use the rejected environment account connection.</p> <p>You <i>can’t</i> reject an environment account connection that\'s connected to an environment.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator guide</i>.</p>', 'TagResource' => '<p>Tag a resource. A tag is a key-value pair of metadata that you associate with an Proton resource.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'UntagResource' => '<p>Remove a customer tag from a resource. A tag is a key-value pair of metadata associated with an Proton resource.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'UpdateAccountSettings' => '<p>Update the Proton service pipeline role or repository settings.</p>', 'UpdateComponent' => '<p>Update a component.</p> <p>There are a few modes for updating a component. The <code>deploymentType</code> field defines the mode.</p> <note> <p>You can\'t update a component while its deployment status, or the deployment status of a service instance attached to it, is <code>IN_PROGRESS</code>.</p> </note> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'UpdateEnvironment' => '<p>Update an environment.</p> <p>If the environment is associated with an environment account connection, <i>don\'t</i> update or include the <code>protonServiceRoleArn</code> and <code>provisioningRepository</code> parameter to update or connect to an environment account connection.</p> <p>You can only update to a new environment account connection if that connection was created in the same environment account that the current environment account connection was created in. The account connection must also be associated with the current environment.</p> <p>If the environment <i>isn\'t</i> associated with an environment account connection, <i>don\'t</i> update or include the <code>environmentAccountConnectionId</code> parameter. You <i>can\'t</i> update or connect the environment to an environment account connection if it <i>isn\'t</i> already associated with an environment connection.</p> <p>You can update either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and value. You can’t update both.</p> <p>If the environment was configured for Amazon Web Services-managed provisioning, omit the <code>provisioningRepository</code> parameter.</p> <p>If the environment was configured for self-managed provisioning, specify the <code>provisioningRepository</code> parameter and omit the <code>protonServiceRoleArn</code> and <code>environmentAccountConnectionId</code> parameters.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html">Environments</a> and <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html">Provisioning methods</a> in the <i>Proton Administrator Guide</i>.</p> <p>There are four modes for updating an environment. The <code>deploymentType</code> field defines the mode.</p> <dl> <dt/> <dd> <p> <code>NONE</code> </p> <p>In this mode, a deployment <i>doesn\'t</i> occur. Only the requested metadata parameters are updated.</p> </dd> <dt/> <dd> <p> <code>CURRENT_VERSION</code> </p> <p>In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated. <i>Don’t</i> include minor or major version parameters when you use this <code>deployment-type</code>.</p> </dd> <dt/> <dd> <p> <code>MINOR_VERSION</code> </p> <p>In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.</p> </dd> <dt/> <dd> <p> <code>MAJOR_VERSION</code> </p> <p>In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that\'s higher than the major version in use and a minor version.</p> </dd> </dl>', 'UpdateEnvironmentAccountConnection' => '<p>In an environment account, update an environment account connection to use a new IAM role.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator guide</i>.</p>', 'UpdateEnvironmentTemplate' => '<p>Update an environment template.</p>', 'UpdateEnvironmentTemplateVersion' => '<p>Update a major or minor version of an environment template.</p>', 'UpdateService' => '<p>Edit a service description or use a spec to add and delete service instances.</p> <note> <p>Existing service instances and the service pipeline <i>can\'t</i> be edited using this API. They can only be deleted.</p> </note> <p>Use the <code>description</code> parameter to modify the description.</p> <p>Edit the <code>spec</code> parameter to add or delete instances.</p> <note> <p>You can\'t delete a service instance (remove it from the spec) if it has an attached component.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p> </note>', 'UpdateServiceInstance' => '<p>Update a service instance.</p> <p>There are a few modes for updating a service instance. The <code>deploymentType</code> field defines the mode.</p> <note> <p>You can\'t update a service instance while its deployment status, or the deployment status of a component attached to it, is <code>IN_PROGRESS</code>.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p> </note>', 'UpdateServicePipeline' => '<p>Update the service pipeline.</p> <p>There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the mode.</p> <dl> <dt/> <dd> <p> <code>NONE</code> </p> <p>In this mode, a deployment <i>doesn\'t</i> occur. Only the requested metadata parameters are updated.</p> </dd> <dt/> <dd> <p> <code>CURRENT_VERSION</code> </p> <p>In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this <code>deployment-type</code>.</p> </dd> <dt/> <dd> <p> <code>MINOR_VERSION</code> </p> <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can specify a different minor version of the current major version in use.</p> </dd> <dt/> <dd> <p> <code>MAJOR_VERSION</code> </p> <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current template by default. You can specify a different major version that\'s higher than the major version in use and a minor version.</p> </dd> </dl>', 'UpdateServiceTemplate' => '<p>Update a service template.</p>', 'UpdateServiceTemplateVersion' => '<p>Update a major or minor version of a service template.</p>', 'UpdateTemplateSyncConfig' => '<p>Update template sync configuration parameters, except for the <code>templateName</code> and <code>templateType</code>.</p>', ], 'shapes' => [ 'AcceptEnvironmentAccountConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'AcceptEnvironmentAccountConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>There <i>isn\'t</i> sufficient access for performing this action.</p>', 'refs' => [], ], 'AccountSettings' => [ 'base' => '<p>The Proton pipeline service role and repository data shared across the Amazon Web Services account.</p>', 'refs' => [ 'GetAccountSettingsOutput$accountSettings' => '<p>The Proton pipeline service role detail data that\'s returned by Proton.</p>', 'UpdateAccountSettingsOutput$accountSettings' => '<p>The Proton pipeline service role and repository data shared across the Amazon Web Services account.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentAccountConnectionInput$componentRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.</p> <p>You must specify <code>componentRoleArn</code> to allow directly defined components to be associated with any environments running in this account.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateEnvironmentAccountConnectionInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that\'s created in the environment account. Proton uses this role to provision infrastructure resources in the associated environment account.</p>', 'CreateEnvironmentInput$componentRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.</p> <p>You must specify <code>componentRoleArn</code> to allow directly defined components to be associated with this environment.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateEnvironmentInput$protonServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p> <p>To use Amazon Web Services-managed provisioning for the environment, specify either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit the <code>provisioningRepository</code> parameter.</p>', 'CreateEnvironmentTemplateInput$encryptionKey' => '<p>A customer provided encryption key that Proton uses to encrypt data.</p>', 'CreateRepositoryInput$connectionArn' => '<p>The Amazon Resource Name (ARN) of your Amazon Web Services CodeStar connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html">Setting up for Proton</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateRepositoryInput$encryptionKey' => '<p>The ARN of your customer Amazon Web Services Key Management Service (Amazon Web Services KMS) key.</p>', 'CreateServiceInput$repositoryConnectionArn' => '<p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up repository connection</a> in the <i>Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up with Proton</a> in the <i>Proton User Guide</i>. <i>Don\'t</i> include this parameter if your service template <i>doesn\'t</i> include a service pipeline.</p>', 'CreateServiceTemplateInput$encryptionKey' => '<p>A customer provided encryption key that\'s used to encrypt data.</p>', 'Environment$componentRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.</p> <p>The environment must have a <code>componentRoleArn</code> to allow directly defined components to be associated with the environment.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'Environment$protonServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>', 'EnvironmentAccountConnection$componentRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.</p> <p>The environment account connection must have a <code>componentRoleArn</code> to allow directly defined components to be associated with any environments running in the account.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'EnvironmentAccountConnection$roleArn' => '<p>The IAM service role that\'s associated with the environment account connection.</p>', 'EnvironmentAccountConnectionSummary$componentRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.</p> <p>The environment account connection must have a <code>componentRoleArn</code> to allow directly defined components to be associated with any environments running in the account.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'EnvironmentAccountConnectionSummary$roleArn' => '<p>The IAM service role that\'s associated with the environment account connection.</p>', 'EnvironmentSummary$componentRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.</p> <p>The environment must have a <code>componentRoleArn</code> to allow directly defined components to be associated with the environment.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'EnvironmentSummary$protonServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make calls to other services on your behalf.</p>', 'EnvironmentTemplate$encryptionKey' => '<p>The customer provided encryption key for the environment template.</p>', 'ListTagsForResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for the listed tags.</p>', 'NotifyResourceDeploymentStatusChangeInput$resourceArn' => '<p>The provisioned resource Amazon Resource Name (ARN).</p>', 'Repository$connectionArn' => '<p>The repository Amazon Web Services CodeStar connection that connects Proton to your repository.</p>', 'Repository$encryptionKey' => '<p>Your customer Amazon Web Services KMS encryption key.</p>', 'Service$repositoryConnectionArn' => '<p>The Amazon Resource Name (ARN) of the repository connection. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/setting-up-for-service.html#setting-up-vcontrol">Set up a repository connection</a> in the <i>Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/proton-setup.html#setup-repo-connection">Setting up with Proton</a> in the <i>Proton User Guide</i>.</p>', 'ServicePipeline$arn' => '<p>The Amazon Resource Name (ARN) of the service pipeline.</p>', 'ServiceTemplate$encryptionKey' => '<p>The customer provided service template encryption key that\'s used to encrypt data.</p>', 'TagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the Proton resource to apply customer tags to.</p>', 'UntagResourceInput$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to remove customer tags from.</p>', 'UpdateEnvironmentAccountConnectionInput$componentRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in the associated environment account. It determines the scope of infrastructure that a component can provision in the account.</p> <p>The environment account connection must have a <code>componentRoleArn</code> to allow directly defined components to be associated with any environments running in the account.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'UpdateEnvironmentAccountConnectionInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that\'s associated with the environment account connection to update.</p>', 'UpdateEnvironmentInput$componentRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined components in this environment. It determines the scope of infrastructure that a component can provision.</p> <p>The environment must have a <code>componentRoleArn</code> to allow directly defined components to be associated with the environment.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'UpdateEnvironmentInput$protonServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the Proton service role that allows Proton to make API calls to other services your behalf.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentAccountConnectionInput$managementAccountId' => '<p>The ID of the management account that accepts or rejects the environment account connection. You create and manage the Proton environment in this account. If the management account accepts the environment account connection, Proton can use the associated IAM role to provision environment infrastructure resources in the associated environment account.</p>', 'Environment$environmentAccountId' => '<p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>', 'EnvironmentAccountConnection$environmentAccountId' => '<p>The environment account that\'s connected to the environment account connection.</p>', 'EnvironmentAccountConnection$managementAccountId' => '<p>The ID of the management account that\'s connected to the environment account connection.</p>', 'EnvironmentAccountConnectionSummary$environmentAccountId' => '<p>The ID of the environment account that\'s connected to the environment account connection.</p>', 'EnvironmentAccountConnectionSummary$managementAccountId' => '<p>The ID of the management account that\'s connected to the environment account connection.</p>', 'EnvironmentSummary$environmentAccountId' => '<p>The ID of the environment account that the environment infrastructure resources are provisioned in.</p>', ], ], 'CancelComponentDeploymentInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelComponentDeploymentOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelEnvironmentDeploymentInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelEnvironmentDeploymentOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelServiceInstanceDeploymentInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelServiceInstanceDeploymentOutput' => [ 'base' => NULL, 'refs' => [], ], 'CancelServicePipelineDeploymentInput' => [ 'base' => NULL, 'refs' => [], ], 'CancelServicePipelineDeploymentOutput' => [ 'base' => NULL, 'refs' => [], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentAccountConnectionInput$clientToken' => '<p>When included, if two identical requests are made with the same client token, Proton returns the environment account connection that the first request created.</p>', 'CreateEnvironmentTemplateVersionInput$clientToken' => '<p>When included, if two identical requests are made with the same client token, Proton returns the environment template version that the first request created.</p>', 'CreateServiceTemplateVersionInput$clientToken' => '<p>When included, if two identical requests are made with the same client token, Proton returns the service template version that the first request created.</p>', ], ], 'CompatibleEnvironmentTemplate' => [ 'base' => '<p>Compatible environment template data.</p>', 'refs' => [ 'CompatibleEnvironmentTemplateList$member' => NULL, ], ], 'CompatibleEnvironmentTemplateInput' => [ 'base' => '<p>Compatible environment template data.</p>', 'refs' => [ 'CompatibleEnvironmentTemplateInputList$member' => NULL, ], ], 'CompatibleEnvironmentTemplateInputList' => [ 'base' => NULL, 'refs' => [ 'CreateServiceTemplateVersionInput$compatibleEnvironmentTemplates' => '<p>An array of environment template objects that are compatible with the new service template version. A service instance based on this service template version can run in environments based on compatible templates.</p>', 'UpdateServiceTemplateVersionInput$compatibleEnvironmentTemplates' => '<p>An array of environment template objects that are compatible with this service template version. A service instance based on this service template version can run in environments based on compatible templates.</p>', ], ], 'CompatibleEnvironmentTemplateList' => [ 'base' => NULL, 'refs' => [ 'ServiceTemplateVersion$compatibleEnvironmentTemplates' => '<p>An array of compatible environment template names for the major version of a service template.</p>', ], ], 'Component' => [ 'base' => '<p>Detailed data of an Proton component resource.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'refs' => [ 'CancelComponentDeploymentOutput$component' => '<p>The detailed data of the component with the deployment that is being canceled.</p>', 'CreateComponentOutput$component' => '<p>The detailed data of the created component.</p>', 'DeleteComponentOutput$component' => '<p>The detailed data of the component being deleted.</p>', 'GetComponentOutput$component' => '<p>The detailed data of the requested component.</p>', 'UpdateComponentOutput$component' => '<p>The detailed data of the updated component.</p>', ], ], 'ComponentArn' => [ 'base' => NULL, 'refs' => [ 'Component$arn' => '<p>The Amazon Resource Name (ARN) of the component.</p>', 'ComponentSummary$arn' => '<p>The Amazon Resource Name (ARN) of the component.</p>', ], ], 'ComponentDeploymentUpdateType' => [ 'base' => NULL, 'refs' => [ 'UpdateComponentInput$deploymentType' => '<p>The deployment type. It defines the mode for updating a component, as follows:</p> <dl> <dt/> <dd> <p> <code>NONE</code> </p> <p>In this mode, a deployment <i>doesn\'t</i> occur. Only the requested metadata parameters are updated. You can only specify <code>description</code> in this mode.</p> </dd> <dt/> <dd> <p> <code>CURRENT_VERSION</code> </p> <p>In this mode, the component is deployed and updated with the new <code>serviceSpec</code>, <code>templateSource</code>, and/or <code>type</code> that you provide. Only requested parameters are updated.</p> </dd> </dl>', ], ], 'ComponentSummary' => [ 'base' => '<p>Summary data of an Proton component resource.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'refs' => [ 'ComponentSummaryList$member' => NULL, ], ], 'ComponentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListComponentsOutput$components' => '<p>An array of components with summary data.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request <i>couldn\'t</i> be made due to a conflicting operation or resource.</p>', 'refs' => [], ], 'CreateComponentInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateComponentOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentAccountConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentAccountConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentTemplateVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentTemplateVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceTemplateVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateServiceTemplateVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateSyncConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateSyncConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComponentInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComponentOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentAccountConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentAccountConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentTemplateVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentTemplateVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceTemplateVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceTemplateVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateSyncConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateSyncConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeploymentId' => [ 'base' => NULL, 'refs' => [ 'NotifyResourceDeploymentStatusChangeInput$deploymentId' => '<p>The deployment ID for your provisioned resource.</p>', ], ], 'DeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'Component$deploymentStatus' => '<p>The component deployment status.</p>', 'ComponentSummary$deploymentStatus' => '<p>The component deployment status.</p>', 'Environment$deploymentStatus' => '<p>The environment deployment status.</p>', 'EnvironmentSummary$deploymentStatus' => '<p>The environment deployment status.</p>', 'ServiceInstance$deploymentStatus' => '<p>The service instance deployment status.</p>', 'ServiceInstanceSummary$deploymentStatus' => '<p>The service instance deployment status.</p>', 'ServicePipeline$deploymentStatus' => '<p>The deployment status of the service pipeline.</p>', ], ], 'DeploymentUpdateType' => [ 'base' => NULL, 'refs' => [ 'UpdateEnvironmentInput$deploymentType' => '<p>There are four modes for updating an environment. The <code>deploymentType</code> field defines the mode.</p> <dl> <dt/> <dd> <p> <code>NONE</code> </p> <p>In this mode, a deployment <i>doesn\'t</i> occur. Only the requested metadata parameters are updated.</p> </dd> <dt/> <dd> <p> <code>CURRENT_VERSION</code> </p> <p>In this mode, the environment is deployed and updated with the new spec that you provide. Only requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this <code>deployment-type</code>.</p> </dd> <dt/> <dd> <p> <code>MINOR_VERSION</code> </p> <p>In this mode, the environment is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.</p> </dd> <dt/> <dd> <p> <code>MAJOR_VERSION</code> </p> <p>In this mode, the environment is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can also specify a different major version that is higher than the major version in use and a minor version (optional).</p> </dd> </dl>', 'UpdateServiceInstanceInput$deploymentType' => '<p>The deployment type. It defines the mode for updating a service instance, as follows:</p> <dl> <dt/> <dd> <p> <code>NONE</code> </p> <p>In this mode, a deployment <i>doesn\'t</i> occur. Only the requested metadata parameters are updated.</p> </dd> <dt/> <dd> <p> <code>CURRENT_VERSION</code> </p> <p>In this mode, the service instance is deployed and updated with the new spec that you provide. Only requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this deployment type.</p> </dd> <dt/> <dd> <p> <code>MINOR_VERSION</code> </p> <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can also specify a different minor version of the current major version in use.</p> </dd> <dt/> <dd> <p> <code>MAJOR_VERSION</code> </p> <p>In this mode, the service instance is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can specify a different major version that\'s higher than the major version in use and a minor version.</p> </dd> </dl>', 'UpdateServicePipelineInput$deploymentType' => '<p>The deployment type.</p> <p>There are four modes for updating a service pipeline. The <code>deploymentType</code> field defines the mode.</p> <dl> <dt/> <dd> <p> <code>NONE</code> </p> <p>In this mode, a deployment <i>doesn\'t</i> occur. Only the requested metadata parameters are updated.</p> </dd> <dt/> <dd> <p> <code>CURRENT_VERSION</code> </p> <p>In this mode, the service pipeline is deployed and updated with the new spec that you provide. Only requested parameters are updated. <i>Don’t</i> include major or minor version parameters when you use this <code>deployment-type</code>.</p> </dd> <dt/> <dd> <p> <code>MINOR_VERSION</code> </p> <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) minor version of the current major version in use, by default. You can specify a different minor version of the current major version in use.</p> </dd> <dt/> <dd> <p> <code>MAJOR_VERSION</code> </p> <p>In this mode, the service pipeline is deployed and updated with the published, recommended (latest) major and minor version of the current template, by default. You can specify a different major version that\'s higher than the major version in use and a minor version.</p> </dd> </dl>', ], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'Component$description' => '<p>A description of the component.</p>', 'CreateComponentInput$description' => '<p>An optional customer-provided description of the component.</p>', 'CreateEnvironmentInput$description' => '<p>A description of the environment that\'s being created and deployed.</p>', 'CreateEnvironmentTemplateInput$description' => '<p>A description of the environment template.</p>', 'CreateEnvironmentTemplateVersionInput$description' => '<p>A description of the new version of an environment template.</p>', 'CreateServiceInput$description' => '<p>A description of the Proton service.</p>', 'CreateServiceTemplateInput$description' => '<p>A description of the service template.</p>', 'CreateServiceTemplateVersionInput$description' => '<p>A description of the new version of a service template.</p>', 'Environment$description' => '<p>The description of the environment.</p>', 'EnvironmentSummary$description' => '<p>The description of the environment.</p>', 'EnvironmentTemplate$description' => '<p>A description of the environment template.</p>', 'EnvironmentTemplateSummary$description' => '<p>A description of the environment template.</p>', 'EnvironmentTemplateVersion$description' => '<p>A description of the minor version of an environment template.</p>', 'EnvironmentTemplateVersionSummary$description' => '<p>A description of the version of an environment template.</p>', 'Service$description' => '<p>A description of the service.</p>', 'ServiceSummary$description' => '<p>A description of the service.</p>', 'ServiceTemplate$description' => '<p>A description of the service template.</p>', 'ServiceTemplateSummary$description' => '<p>A description of the service template.</p>', 'ServiceTemplateVersion$description' => '<p>A description of the version of a service template.</p>', 'ServiceTemplateVersionSummary$description' => '<p>A description of the version of a service template.</p>', 'UpdateComponentInput$description' => '<p>An optional customer-provided description of the component.</p>', 'UpdateEnvironmentInput$description' => '<p>A description of the environment update.</p>', 'UpdateEnvironmentTemplateInput$description' => '<p>A description of the environment template update.</p>', 'UpdateEnvironmentTemplateVersionInput$description' => '<p>A description of environment template version to update.</p>', 'UpdateServiceInput$description' => '<p>The edited service description.</p>', 'UpdateServiceTemplateInput$description' => '<p>A description of the service template update.</p>', 'UpdateServiceTemplateVersionInput$description' => '<p>A description of a service template version to update.</p>', ], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentTemplateInput$displayName' => '<p>The environment template name as displayed in the developer interface.</p>', 'CreateServiceTemplateInput$displayName' => '<p>The name of the service template as displayed in the developer interface.</p>', 'EnvironmentTemplate$displayName' => '<p>The name of the environment template as displayed in the developer interface.</p>', 'EnvironmentTemplateSummary$displayName' => '<p>The name of the environment template as displayed in the developer interface.</p>', 'ServiceTemplate$displayName' => '<p>The service template name as displayed in the developer interface.</p>', 'ServiceTemplateSummary$displayName' => '<p>The service template name as displayed in the developer interface.</p>', 'UpdateEnvironmentTemplateInput$displayName' => '<p>The name of the environment template to update as displayed in the developer interface.</p>', 'UpdateServiceTemplateInput$displayName' => '<p>The name of the service template to update that\'s displayed in the developer interface.</p>', ], ], 'EmptyNextToken' => [ 'base' => NULL, 'refs' => [ 'ListComponentOutputsInput$nextToken' => '<p>A token that indicates the location of the next output in the array of outputs, after the list of outputs that was previously requested.</p>', 'ListComponentOutputsOutput$nextToken' => '<p>A token that indicates the location of the next output in the array of outputs, after the list of outputs that was previously requested.</p>', 'ListComponentProvisionedResourcesInput$nextToken' => '<p>A token that indicates the location of the next provisioned resource in the array of provisioned resources, after the list of provisioned resources that was previously requested.</p>', 'ListComponentProvisionedResourcesOutput$nextToken' => '<p>A token that indicates the location of the next provisioned resource in the array of provisioned resources, after the current requested list of provisioned resources.</p>', 'ListEnvironmentOutputsInput$nextToken' => '<p>A token that indicates the location of the next environment output in the array of environment outputs, after the list of environment outputs that was previously requested.</p>', 'ListEnvironmentOutputsOutput$nextToken' => '<p>A token that indicates the location of the next environment output in the array of environment outputs, after the current requested list of environment outputs.</p>', 'ListEnvironmentProvisionedResourcesInput$nextToken' => '<p>A token that indicates the location of the next environment provisioned resource in the array of environment provisioned resources, after the list of environment provisioned resources that was previously requested.</p>', 'ListEnvironmentProvisionedResourcesOutput$nextToken' => '<p>A token that indicates the location of the next environment provisioned resource in the array of provisioned resources, after the current requested list of environment provisioned resources.</p>', 'ListRepositorySyncDefinitionsInput$nextToken' => '<p>A token that indicates the location of the next repository sync definition in the array of repository sync definitions, after the list of repository sync definitions previously requested.</p>', 'ListRepositorySyncDefinitionsOutput$nextToken' => '<p>A token that indicates the location of the next repository sync definition in the array of repository sync definitions, after the current requested list of repository sync definitions.</p>', 'ListServiceInstanceOutputsInput$nextToken' => '<p>A token that indicates the location of the next output in the array of outputs, after the list of outputs that was previously requested.</p>', 'ListServiceInstanceOutputsOutput$nextToken' => '<p>A token that indicates the location of the next output in the array of outputs, after the current requested list of outputs.</p>', 'ListServiceInstanceProvisionedResourcesInput$nextToken' => '<p>A token that indicates the location of the next provisioned resource in the array of provisioned resources, after the list of provisioned resources that was previously requested.</p>', 'ListServiceInstanceProvisionedResourcesOutput$nextToken' => '<p>A token that indicates the location of the next provisioned resource in the array of provisioned resources, after the current requested list of provisioned resources.</p>', 'ListServicePipelineOutputsInput$nextToken' => '<p>A token that indicates the location of the next output in the array of outputs, after the list of outputs that was previously requested.</p>', 'ListServicePipelineOutputsOutput$nextToken' => '<p>A token that indicates the location of the next output in the array of outputs, after the current requested list of outputs.</p>', 'ListServicePipelineProvisionedResourcesInput$nextToken' => '<p>A token that indicates the location of the next provisioned resource in the array of provisioned resources, after the list of provisioned resources that was previously requested.</p>', 'ListServicePipelineProvisionedResourcesOutput$nextToken' => '<p>A token that indicates the location of the next provisioned resource in the array of provisioned resources, after the current requested list of provisioned resources.</p>', ], ], 'Environment' => [ 'base' => '<p>Detailed data of an Proton environment resource. An Proton environment is a set of resources shared across Proton services.</p>', 'refs' => [ 'CancelEnvironmentDeploymentOutput$environment' => '<p>The environment summary data that\'s returned by Proton.</p>', 'CreateEnvironmentOutput$environment' => '<p>The environment detail data that\'s returned by Proton.</p>', 'DeleteEnvironmentOutput$environment' => '<p>The detailed data of the environment being deleted.</p>', 'GetEnvironmentOutput$environment' => '<p>The detailed data of the requested environment.</p>', 'UpdateEnvironmentOutput$environment' => '<p>The environment detail data that\'s returned by Proton.</p>', ], ], 'EnvironmentAccountConnection' => [ 'base' => '<p>Detailed data of an Proton environment account connection resource.</p>', 'refs' => [ 'AcceptEnvironmentAccountConnectionOutput$environmentAccountConnection' => '<p>The environment account connection data that\'s returned by Proton.</p>', 'CreateEnvironmentAccountConnectionOutput$environmentAccountConnection' => '<p>The environment account connection detail data that\'s returned by Proton.</p>', 'DeleteEnvironmentAccountConnectionOutput$environmentAccountConnection' => '<p>The detailed data of the environment account connection being deleted.</p>', 'GetEnvironmentAccountConnectionOutput$environmentAccountConnection' => '<p>The detailed data of the requested environment account connection.</p>', 'RejectEnvironmentAccountConnectionOutput$environmentAccountConnection' => '<p>The environment connection account detail data that\'s returned by Proton.</p>', 'UpdateEnvironmentAccountConnectionOutput$environmentAccountConnection' => '<p>The environment account connection detail data that\'s returned by Proton.</p>', ], ], 'EnvironmentAccountConnectionArn' => [ 'base' => NULL, 'refs' => [ 'EnvironmentAccountConnection$arn' => '<p>The Amazon Resource Name (ARN) of the environment account connection.</p>', 'EnvironmentAccountConnectionSummary$arn' => '<p>The Amazon Resource Name (ARN) of the environment account connection.</p>', ], ], 'EnvironmentAccountConnectionId' => [ 'base' => NULL, 'refs' => [ 'AcceptEnvironmentAccountConnectionInput$id' => '<p>The ID of the environment account connection.</p>', 'CreateEnvironmentInput$environmentAccountConnectionId' => '<p>The ID of the environment account connection that you provide if you\'re provisioning your environment infrastructure resources to an environment account. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html">Environment account connections</a> in the <i>Proton Administrator guide</i>.</p> <p>To use Amazon Web Services-managed provisioning for the environment, specify either the <code>environmentAccountConnectionId</code> or <code>protonServiceRoleArn</code> parameter and omit the <code>provisioningRepository</code> parameter.</p>', 'DeleteEnvironmentAccountConnectionInput$id' => '<p>The ID of the environment account connection to delete.</p>', 'Environment$environmentAccountConnectionId' => '<p>The ID of the environment account connection that\'s used to provision infrastructure resources in an environment account.</p>', 'EnvironmentAccountConnection$id' => '<p>The ID of the environment account connection.</p>', 'EnvironmentAccountConnectionSummary$id' => '<p>The ID of the environment account connection.</p>', 'EnvironmentSummary$environmentAccountConnectionId' => '<p>The ID of the environment account connection that the environment is associated with.</p>', 'GetEnvironmentAccountConnectionInput$id' => '<p>The ID of the environment account connection that you want to get the detailed data for.</p>', 'RejectEnvironmentAccountConnectionInput$id' => '<p>The ID of the environment account connection to reject.</p>', 'UpdateEnvironmentAccountConnectionInput$id' => '<p>The ID of the environment account connection to update.</p>', 'UpdateEnvironmentInput$environmentAccountConnectionId' => '<p>The ID of the environment account connection.</p> <p>You can only update to a new environment account connection if it was created in the same environment account that the current environment account connection was created in and is associated with the current environment.</p>', ], ], 'EnvironmentAccountConnectionRequesterAccountType' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentAccountConnectionsInput$requestedBy' => '<p>The type of account making the <code>ListEnvironmentAccountConnections</code> request.</p>', ], ], 'EnvironmentAccountConnectionStatus' => [ 'base' => NULL, 'refs' => [ 'EnvironmentAccountConnection$status' => '<p>The status of the environment account connection.</p>', 'EnvironmentAccountConnectionStatusList$member' => NULL, 'EnvironmentAccountConnectionSummary$status' => '<p>The status of the environment account connection.</p>', ], ], 'EnvironmentAccountConnectionStatusList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentAccountConnectionsInput$statuses' => '<p>The status details for each listed environment account connection.</p>', ], ], 'EnvironmentAccountConnectionSummary' => [ 'base' => '<p>Summary data of an Proton environment account connection resource.</p>', 'refs' => [ 'EnvironmentAccountConnectionSummaryList$member' => NULL, ], ], 'EnvironmentAccountConnectionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentAccountConnectionsOutput$environmentAccountConnections' => '<p>An array of environment account connections with details that\'s returned by Proton. </p>', ], ], 'EnvironmentArn' => [ 'base' => NULL, 'refs' => [ 'Environment$arn' => '<p>The Amazon Resource Name (ARN) of the environment.</p>', 'EnvironmentSummary$arn' => '<p>The Amazon Resource Name (ARN) of the environment.</p>', ], ], 'EnvironmentSummary' => [ 'base' => '<p>Summary data of an Proton environment resource. An Proton environment is a set of resources shared across Proton services.</p>', 'refs' => [ 'EnvironmentSummaryList$member' => NULL, ], ], 'EnvironmentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsOutput$environments' => '<p>An array of environment detail data summaries.</p>', ], ], 'EnvironmentTemplate' => [ 'base' => '<p>The environment template data.</p>', 'refs' => [ 'CreateEnvironmentTemplateOutput$environmentTemplate' => '<p>The environment template detail data that\'s returned by Proton.</p>', 'DeleteEnvironmentTemplateOutput$environmentTemplate' => '<p>The detailed data of the environment template being deleted.</p>', 'GetEnvironmentTemplateOutput$environmentTemplate' => '<p>The detailed data of the requested environment template.</p>', 'UpdateEnvironmentTemplateOutput$environmentTemplate' => '<p>The environment template detail data that\'s returned by Proton.</p>', ], ], 'EnvironmentTemplateArn' => [ 'base' => NULL, 'refs' => [ 'EnvironmentTemplate$arn' => '<p>The Amazon Resource Name (ARN) of the environment template.</p>', 'EnvironmentTemplateSummary$arn' => '<p>The Amazon Resource Name (ARN) of the environment template.</p>', ], ], 'EnvironmentTemplateFilter' => [ 'base' => '<p>A search filter for environment templates.</p>', 'refs' => [ 'EnvironmentTemplateFilterList$member' => NULL, ], ], 'EnvironmentTemplateFilterList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsInput$environmentTemplates' => '<p>An array of the versions of the environment template.</p>', ], ], 'EnvironmentTemplateSummary' => [ 'base' => '<p>The environment template data.</p>', 'refs' => [ 'EnvironmentTemplateSummaryList$member' => NULL, ], ], 'EnvironmentTemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentTemplatesOutput$templates' => '<p>An array of environment templates with detail data.</p>', ], ], 'EnvironmentTemplateVersion' => [ 'base' => '<p>The environment template version data.</p>', 'refs' => [ 'CreateEnvironmentTemplateVersionOutput$environmentTemplateVersion' => '<p>The environment template detail data that\'s returned by Proton.</p>', 'DeleteEnvironmentTemplateVersionOutput$environmentTemplateVersion' => '<p>The detailed data of the environment template version being deleted.</p>', 'GetEnvironmentTemplateVersionOutput$environmentTemplateVersion' => '<p>The detailed data of the requested environment template version.</p>', 'UpdateEnvironmentTemplateVersionOutput$environmentTemplateVersion' => '<p>The environment template version detail data that\'s returned by Proton.</p>', ], ], 'EnvironmentTemplateVersionArn' => [ 'base' => NULL, 'refs' => [ 'EnvironmentTemplateVersion$arn' => '<p>The Amazon Resource Name (ARN) of the version of an environment template.</p>', 'EnvironmentTemplateVersionSummary$arn' => '<p>The Amazon Resource Name (ARN) of the version of an environment template.</p>', ], ], 'EnvironmentTemplateVersionSummary' => [ 'base' => '<p>A summary of the version of an environment template detail data.</p>', 'refs' => [ 'EnvironmentTemplateVersionSummaryList$member' => NULL, ], ], 'EnvironmentTemplateVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentTemplateVersionsOutput$templateVersions' => '<p>An array of major or minor versions of an environment template detail data.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'FullTemplateVersionNumber' => [ 'base' => NULL, 'refs' => [ 'EnvironmentTemplate$recommendedVersion' => '<p>The ID of the recommended version of the environment template.</p>', 'EnvironmentTemplateSummary$recommendedVersion' => '<p>The recommended version of the environment template.</p>', 'ServiceTemplate$recommendedVersion' => '<p>The recommended version of the service template.</p>', 'ServiceTemplateSummary$recommendedVersion' => '<p>The recommended version of the service template.</p>', ], ], 'GetAccountSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentAccountConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentAccountConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentTemplateVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentTemplateVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositoryOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositorySyncStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetRepositorySyncStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceTemplateVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceTemplateVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateSyncConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateSyncConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateSyncStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateSyncStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'GitBranchName' => [ 'base' => NULL, 'refs' => [ 'CreateServiceInput$branchName' => '<p>The name of the code repository branch that holds the code that\'s deployed in Proton. <i>Don\'t</i> include this parameter if your service template <i>doesn\'t</i> include a service pipeline.</p>', 'CreateTemplateSyncConfigInput$branch' => '<p>The branch of the registered repository for your template.</p>', 'GetRepositorySyncStatusInput$branch' => '<p>The repository branch.</p>', 'RepositoryBranch$branch' => '<p>The repository branch.</p>', 'RepositoryBranchInput$branch' => '<p>The repository branch.</p>', 'RepositorySyncDefinition$branch' => '<p>The repository branch.</p>', 'Revision$branch' => '<p>The repository branch.</p>', 'Service$branchName' => '<p>The name of the code repository branch that holds the code that\'s deployed in Proton.</p>', 'TemplateSyncConfig$branch' => '<p>The repository branch.</p>', 'UpdateTemplateSyncConfigInput$branch' => '<p>The repository branch.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request failed to register with the service.</p>', 'refs' => [], ], 'ListComponentOutputsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentOutputsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentProvisionedResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentProvisionedResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentAccountConnectionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentAccountConnectionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentOutputsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentOutputsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentProvisionedResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentProvisionedResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentTemplateVersionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentTemplateVersionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoriesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositoriesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositorySyncDefinitionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListRepositorySyncDefinitionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceInstanceOutputsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceInstanceOutputsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceInstanceProvisionedResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceInstanceProvisionedResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceInstancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceInstancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServicePipelineOutputsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServicePipelineOutputsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServicePipelineProvisionedResourcesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServicePipelineProvisionedResourcesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceTemplateVersionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceTemplateVersionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceTemplatesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceTemplatesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxPageResults' => [ 'base' => NULL, 'refs' => [ 'ListComponentsInput$maxResults' => '<p>The maximum number of components to list.</p>', 'ListEnvironmentAccountConnectionsInput$maxResults' => '<p>The maximum number of environment account connections to list.</p>', 'ListEnvironmentTemplateVersionsInput$maxResults' => '<p>The maximum number of major or minor versions of an environment template to list.</p>', 'ListEnvironmentTemplatesInput$maxResults' => '<p>The maximum number of environment templates to list.</p>', 'ListEnvironmentsInput$maxResults' => '<p>The maximum number of environments to list.</p>', 'ListRepositoriesInput$maxResults' => '<p>The maximum number of repositories to list.</p>', 'ListServiceInstancesInput$maxResults' => '<p>The maximum number of service instances to list.</p>', 'ListServiceTemplateVersionsInput$maxResults' => '<p>The maximum number of major or minor versions of a service template to list.</p>', 'ListServiceTemplatesInput$maxResults' => '<p>The maximum number of service templates to list.</p>', 'ListServicesInput$maxResults' => '<p>The maximum number of services to list.</p>', 'ListTagsForResourceInput$maxResults' => '<p>The maximum number of tags to list.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListComponentsInput$nextToken' => '<p>A token that indicates the location of the next component in the array of components, after the list of components that was previously requested.</p>', 'ListComponentsOutput$nextToken' => '<p>A token that indicates the location of the next component in the array of components, after the current requested list of components.</p>', 'ListEnvironmentAccountConnectionsInput$nextToken' => '<p>A token that indicates the location of the next environment account connection in the array of environment account connections, after the list of environment account connections that was previously requested.</p>', 'ListEnvironmentAccountConnectionsOutput$nextToken' => '<p>A token that indicates the location of the next environment account connection in the array of environment account connections, after the current requested list of environment account connections.</p>', 'ListEnvironmentTemplateVersionsInput$nextToken' => '<p>A token that indicates the location of the next major or minor version in the array of major or minor versions of an environment template, after the list of major or minor versions that was previously requested.</p>', 'ListEnvironmentTemplateVersionsOutput$nextToken' => '<p>A token that indicates the location of the next major or minor version in the array of major or minor versions of an environment template, after the list of major or minor versions that was previously requested.</p>', 'ListEnvironmentTemplatesInput$nextToken' => '<p>A token that indicates the location of the next environment template in the array of environment templates, after the list of environment templates that was previously requested.</p>', 'ListEnvironmentTemplatesOutput$nextToken' => '<p>A token that indicates the location of the next environment template in the array of environment templates, after the current requested list of environment templates.</p>', 'ListEnvironmentsInput$nextToken' => '<p>A token that indicates the location of the next environment in the array of environments, after the list of environments that was previously requested.</p>', 'ListEnvironmentsOutput$nextToken' => '<p>A token that indicates the location of the next environment in the array of environments, after the current requested list of environments.</p>', 'ListRepositoriesInput$nextToken' => '<p>A token that indicates the location of the next repository in the array of repositories, after the list of repositories previously requested.</p>', 'ListRepositoriesOutput$nextToken' => '<p>A token that indicates the location of the next repository in the array of repositories, after the current requested list of repositories. </p>', 'ListServiceInstancesInput$nextToken' => '<p>A token that indicates the location of the next service in the array of service instances, after the list of service instances that was previously requested.</p>', 'ListServiceInstancesOutput$nextToken' => '<p>A token that indicates the location of the next service instance in the array of service instances, after the current requested list of service instances.</p>', 'ListServiceTemplateVersionsInput$nextToken' => '<p>A token that indicates the location of the next major or minor version in the array of major or minor versions of a service template, after the list of major or minor versions that was previously requested.</p>', 'ListServiceTemplateVersionsOutput$nextToken' => '<p>A token that indicates the location of the next major or minor version in the array of major or minor versions of a service template, after the current requested list of service major or minor versions.</p>', 'ListServiceTemplatesInput$nextToken' => '<p>A token that indicates the location of the next service template in the array of service templates, after the list of service templates previously requested.</p>', 'ListServiceTemplatesOutput$nextToken' => '<p>A token that indicates the location of the next service template in the array of service templates, after the current requested list of service templates.</p>', 'ListServicesInput$nextToken' => '<p>A token that indicates the location of the next service in the array of services, after the list of services that was previously requested.</p>', 'ListServicesOutput$nextToken' => '<p>A token that indicates the location of the next service in the array of services, after the current requested list of services.</p>', ], ], 'NotifyResourceDeploymentStatusChangeInput' => [ 'base' => NULL, 'refs' => [], ], 'NotifyResourceDeploymentStatusChangeInputOutputsList' => [ 'base' => NULL, 'refs' => [ 'NotifyResourceDeploymentStatusChangeInput$outputs' => '<p>The provisioned resource state change detail data that\'s returned by Proton.</p>', ], ], 'NotifyResourceDeploymentStatusChangeInputStatusMessageString' => [ 'base' => NULL, 'refs' => [ 'NotifyResourceDeploymentStatusChangeInput$statusMessage' => '<p>The deployment status message for your provisioned resource.</p>', ], ], 'NotifyResourceDeploymentStatusChangeOutput' => [ 'base' => NULL, 'refs' => [], ], 'Output' => [ 'base' => '<p>An infrastructure as code defined resource output.</p>', 'refs' => [ 'NotifyResourceDeploymentStatusChangeInputOutputsList$member' => NULL, 'OutputsList$member' => NULL, ], ], 'OutputKey' => [ 'base' => NULL, 'refs' => [ 'Output$key' => '<p>The output key.</p>', ], ], 'OutputValueString' => [ 'base' => NULL, 'refs' => [ 'Output$valueString' => '<p>The output value.</p>', ], ], 'OutputsList' => [ 'base' => NULL, 'refs' => [ 'ListComponentOutputsOutput$outputs' => '<p>An array of component Infrastructure as Code (IaC) outputs.</p>', 'ListEnvironmentOutputsOutput$outputs' => '<p>An array of environment outputs with detail data.</p>', 'ListServiceInstanceOutputsOutput$outputs' => '<p>An array of service instance Infrastructure as Code (IaC) outputs.</p>', 'ListServicePipelineOutputsOutput$outputs' => '<p>An array of service pipeline Infrastructure as Code (IaC) outputs.</p>', ], ], 'PipelineRoleArn' => [ 'base' => NULL, 'refs' => [ 'AccountSettings$pipelineServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role you want to use for provisioning pipelines. Assumed by Proton for Amazon Web Services-managed provisioning, and by customer-owned automation for self-managed provisioning.</p>', 'UpdateAccountSettingsInput$pipelineServiceRoleArn' => '<p>The Amazon Resource Name (ARN) of the service role you want to use for provisioning pipelines. Assumed by Proton for Amazon Web Services-managed provisioning, and by customer-owned automation for self-managed provisioning.</p>', ], ], 'ProvisionedResource' => [ 'base' => '<p>Detail data for a provisioned resource.</p>', 'refs' => [ 'ProvisionedResourceList$member' => NULL, ], ], 'ProvisionedResourceEngine' => [ 'base' => '<p>List of provisioning engines</p>', 'refs' => [ 'ProvisionedResource$provisioningEngine' => '<p>The resource provisioning engine. At this time, <code>CLOUDFORMATION</code> can be used for Amazon Web Services-managed provisioning, and <code>TERRAFORM</code> can be used for self-managed provisioning.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-works-prov-methods.html#ag-works-prov-methods-self">Self-managed provisioning</a> in the <i>Proton Administrator Guide</i>.</p>', ], ], 'ProvisionedResourceIdentifier' => [ 'base' => NULL, 'refs' => [ 'ProvisionedResource$identifier' => '<p>The provisioned resource identifier.</p>', ], ], 'ProvisionedResourceList' => [ 'base' => NULL, 'refs' => [ 'ListComponentProvisionedResourcesOutput$provisionedResources' => '<p>An array of provisioned resources for a component.</p>', 'ListEnvironmentProvisionedResourcesOutput$provisionedResources' => '<p>An array of environment provisioned resources.</p>', 'ListServiceInstanceProvisionedResourcesOutput$provisionedResources' => '<p>An array of provisioned resources for a service instance.</p>', 'ListServicePipelineProvisionedResourcesOutput$provisionedResources' => '<p>An array of provisioned resources for a service and pipeline.</p>', ], ], 'ProvisionedResourceName' => [ 'base' => NULL, 'refs' => [ 'ProvisionedResource$name' => '<p>The provisioned resource name.</p>', ], ], 'Provisioning' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentTemplateInput$provisioning' => '<p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>', 'CreateServiceTemplateInput$pipelineProvisioning' => '<p>By default, Proton provides a service pipeline for your service. When this parameter is included, it indicates that an Proton service pipeline <i>isn\'t</i> provided for your service. After it\'s included, it <i>can\'t</i> be changed. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-template-bundles.html">Service template bundles</a> in the <i>Proton Administrator Guide</i>.</p>', 'Environment$provisioning' => '<p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>', 'EnvironmentSummary$provisioning' => '<p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>', 'EnvironmentTemplate$provisioning' => '<p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>', 'EnvironmentTemplateSummary$provisioning' => '<p>When included, indicates that the environment template is for customer provisioned and managed infrastructure.</p>', 'ServiceTemplate$pipelineProvisioning' => '<p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template. Otherwise, a service pipeline <i>isn\'t</i> included in the service template.</p>', 'ServiceTemplateSummary$pipelineProvisioning' => '<p>If <code>pipelineProvisioning</code> is <code>true</code>, a service pipeline is included in the service template, otherwise a service pipeline <i>isn\'t</i> included in the service template.</p>', ], ], 'RejectEnvironmentAccountConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'RejectEnvironmentAccountConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'Repository' => [ 'base' => '<p>Detailed data of a repository that has been registered with Proton.</p>', 'refs' => [ 'CreateRepositoryOutput$repository' => '<p>The repository detail data that\'s returned by Proton.</p>', 'DeleteRepositoryOutput$repository' => '<p>The repository detail data that\'s returned by Proton.</p>', 'GetRepositoryOutput$repository' => '<p>The repository detail data that\'s returned by Proton.</p>', ], ], 'RepositoryArn' => [ 'base' => NULL, 'refs' => [ 'Repository$arn' => '<p>The repository Amazon Resource Name (ARN).</p>', 'RepositoryBranch$arn' => '<p>The Amazon Resource Name (ARN) of the repository branch.</p>', 'RepositorySummary$arn' => '<p>The Amazon Resource Name (ARN) for a repository.</p>', ], ], 'RepositoryBranch' => [ 'base' => '<p>Detail data for a repository branch.</p>', 'refs' => [ 'AccountSettings$pipelineProvisioningRepository' => '<p>The repository configured in the Amazon Web Services account for pipeline provisioning. Required it if you have environments configured for self-managed provisioning with services that include pipelines.</p>', 'Environment$provisioningRepository' => '<p>The infrastructure repository that you use to host your rendered infrastructure templates for self-managed provisioning.</p>', ], ], 'RepositoryBranchInput' => [ 'base' => '<p>Detail input data for a repository branch.</p>', 'refs' => [ 'CreateEnvironmentInput$provisioningRepository' => '<p>The infrastructure repository that you use to host your rendered infrastructure templates for self-managed provisioning.</p> <p>To use self-managed provisioning for the environment, specify this parameter and omit the <code>environmentAccountConnectionId</code> and <code>protonServiceRoleArn</code> parameters.</p>', 'UpdateAccountSettingsInput$pipelineProvisioningRepository' => '<p>A repository for pipeline provisioning. Specify it if you have environments configured for self-managed provisioning with services that include pipelines.</p>', 'UpdateEnvironmentInput$provisioningRepository' => '<p>The infrastructure repository that you use to host your rendered infrastructure templates for self-managed provisioning.</p>', ], ], 'RepositoryId' => [ 'base' => NULL, 'refs' => [ 'CreateServiceInput$repositoryId' => '<p>The ID of the code repository. <i>Don\'t</i> include this parameter if your service template <i>doesn\'t</i> include a service pipeline.</p>', 'Service$repositoryId' => '<p>The ID of the source code repository.</p>', ], ], 'RepositoryName' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryInput$name' => '<p>The repository name (for example, <code>myrepos/myrepo</code>).</p>', 'CreateTemplateSyncConfigInput$repositoryName' => '<p>The name of your repository (for example, <code>myrepos/myrepo</code>).</p>', 'DeleteRepositoryInput$name' => '<p>The name of the repository.</p>', 'GetRepositoryInput$name' => '<p>The repository name, for example <code>myrepos/myrepo</code>.</p>', 'GetRepositorySyncStatusInput$repositoryName' => '<p>The repository name.</p>', 'ListRepositorySyncDefinitionsInput$repositoryName' => '<p>The repository name.</p>', 'Repository$name' => '<p>The repository name.</p>', 'RepositoryBranch$name' => '<p>The repository name.</p>', 'RepositoryBranchInput$name' => '<p>The repository name.</p>', 'RepositorySummary$name' => '<p>The repository name.</p>', 'Revision$repositoryName' => '<p>The repository name.</p>', 'TemplateSyncConfig$repositoryName' => '<p>The name of the repository, for example <code>myrepos/myrepo</code>.</p>', 'UpdateTemplateSyncConfigInput$repositoryName' => '<p>The name of the repository (for example, <code>myrepos/myrepo</code>).</p>', ], ], 'RepositoryProvider' => [ 'base' => NULL, 'refs' => [ 'CreateRepositoryInput$provider' => '<p>The repository provider.</p>', 'CreateTemplateSyncConfigInput$repositoryProvider' => '<p>The provider type for your repository.</p>', 'DeleteRepositoryInput$provider' => '<p>The repository provider.</p>', 'GetRepositoryInput$provider' => '<p>The repository provider.</p>', 'GetRepositorySyncStatusInput$repositoryProvider' => '<p>The repository provider.</p>', 'ListRepositorySyncDefinitionsInput$repositoryProvider' => '<p>The repository provider.</p>', 'Repository$provider' => '<p>The repository provider.</p>', 'RepositoryBranch$provider' => '<p>The repository provider.</p>', 'RepositoryBranchInput$provider' => '<p>The repository provider.</p>', 'RepositorySummary$provider' => '<p>The repository provider.</p>', 'Revision$repositoryProvider' => '<p>The repository provider.</p>', 'TemplateSyncConfig$repositoryProvider' => '<p>The repository provider.</p>', 'UpdateTemplateSyncConfigInput$repositoryProvider' => '<p>The repository provider.</p>', ], ], 'RepositorySummary' => [ 'base' => '<p>Summary data of a repository that has been registered with Proton.</p>', 'refs' => [ 'RepositorySummaryList$member' => NULL, ], ], 'RepositorySummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRepositoriesOutput$repositories' => '<p>An array of repositories.</p>', ], ], 'RepositorySyncAttempt' => [ 'base' => '<p>Detail data for a repository sync attempt activated by a push to a repository.</p>', 'refs' => [ 'GetRepositorySyncStatusOutput$latestSync' => '<p>The repository sync status detail data that\'s returned by Proton.</p>', ], ], 'RepositorySyncDefinition' => [ 'base' => '<p>The repository sync definition.</p>', 'refs' => [ 'RepositorySyncDefinitionList$member' => NULL, ], ], 'RepositorySyncDefinitionList' => [ 'base' => NULL, 'refs' => [ 'ListRepositorySyncDefinitionsOutput$syncDefinitions' => '<p>An array of repository sync definitions.</p>', ], ], 'RepositorySyncEvent' => [ 'base' => '<p>Repository sync event detail data for a sync attempt.</p>', 'refs' => [ 'RepositorySyncEvents$member' => NULL, ], ], 'RepositorySyncEvents' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncAttempt$events' => '<p>Detail data for sync attempt events.</p>', ], ], 'RepositorySyncStatus' => [ 'base' => NULL, 'refs' => [ 'RepositorySyncAttempt$status' => '<p>The sync attempt status.</p>', ], ], 'ResourceDeploymentStatus' => [ 'base' => '<p>The state that a PR-based deployment can be updated to.</p>', 'refs' => [ 'NotifyResourceDeploymentStatusChangeInput$status' => '<p>The status of your provisioned resource.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CancelComponentDeploymentInput$componentName' => '<p>The name of the component with the deployment to cancel.</p>', 'CancelEnvironmentDeploymentInput$environmentName' => '<p>The name of the environment with the deployment to cancel.</p>', 'CancelServiceInstanceDeploymentInput$serviceInstanceName' => '<p>The name of the service instance with the deployment to cancel.</p>', 'CancelServiceInstanceDeploymentInput$serviceName' => '<p>The name of the service with the service instance deployment to cancel.</p>', 'CancelServicePipelineDeploymentInput$serviceName' => '<p>The name of the service with the service pipeline deployment to cancel.</p>', 'CompatibleEnvironmentTemplate$templateName' => '<p>The compatible environment template name.</p>', 'CompatibleEnvironmentTemplateInput$templateName' => '<p>The compatible environment template name.</p>', 'Component$environmentName' => '<p>The name of the Proton environment that this component is associated with.</p>', 'Component$name' => '<p>The name of the component.</p>', 'Component$serviceInstanceName' => '<p>The name of the service instance that this component is attached to. Provided when a component is attached to a service instance.</p>', 'Component$serviceName' => '<p>The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a component is attached to a service instance.</p>', 'ComponentSummary$environmentName' => '<p>The name of the Proton environment that this component is associated with.</p>', 'ComponentSummary$name' => '<p>The name of the component.</p>', 'ComponentSummary$serviceInstanceName' => '<p>The name of the service instance that this component is attached to. Provided when a component is attached to a service instance.</p>', 'ComponentSummary$serviceName' => '<p>The name of the service that <code>serviceInstanceName</code> is associated with. Provided when a component is attached to a service instance.</p>', 'CreateComponentInput$environmentName' => '<p>The name of the Proton environment that you want to associate this component with. You must specify this when you don\'t specify <code>serviceInstanceName</code> and <code>serviceName</code>.</p>', 'CreateComponentInput$name' => '<p>The customer-provided name of the component.</p>', 'CreateComponentInput$serviceInstanceName' => '<p>The name of the service instance that you want to attach this component to. If you don\'t specify this, the component isn\'t attached to any service instance. Specify both <code>serviceInstanceName</code> and <code>serviceName</code> or neither of them.</p>', 'CreateComponentInput$serviceName' => '<p>The name of the service that <code>serviceInstanceName</code> is associated with. If you don\'t specify this, the component isn\'t attached to any service instance. Specify both <code>serviceInstanceName</code> and <code>serviceName</code> or neither of them.</p>', 'CreateEnvironmentAccountConnectionInput$environmentName' => '<p>The name of the Proton environment that\'s created in the associated management account.</p>', 'CreateEnvironmentInput$name' => '<p>The name of the environment.</p>', 'CreateEnvironmentInput$templateName' => '<p>The name of the environment template. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html">Environment Templates</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateEnvironmentTemplateInput$name' => '<p>The name of the environment template.</p>', 'CreateEnvironmentTemplateVersionInput$templateName' => '<p>The name of the environment template.</p>', 'CreateServiceInput$name' => '<p>The service name.</p>', 'CreateServiceInput$templateName' => '<p>The name of the service template that\'s used to create the service.</p>', 'CreateServiceTemplateInput$name' => '<p>The name of the service template.</p>', 'CreateServiceTemplateVersionInput$templateName' => '<p>The name of the service template.</p>', 'CreateTemplateSyncConfigInput$templateName' => '<p>The name of your registered template.</p>', 'DeleteComponentInput$name' => '<p>The name of the component to delete.</p>', 'DeleteEnvironmentInput$name' => '<p>The name of the environment to delete.</p>', 'DeleteEnvironmentTemplateInput$name' => '<p>The name of the environment template to delete.</p>', 'DeleteEnvironmentTemplateVersionInput$templateName' => '<p>The name of the environment template.</p>', 'DeleteServiceInput$name' => '<p>The name of the service to delete.</p>', 'DeleteServiceTemplateInput$name' => '<p>The name of the service template to delete.</p>', 'DeleteServiceTemplateVersionInput$templateName' => '<p>The name of the service template.</p>', 'DeleteTemplateSyncConfigInput$templateName' => '<p>The template name.</p>', 'Environment$name' => '<p>The name of the environment.</p>', 'Environment$templateName' => '<p>The Amazon Resource Name (ARN) of the environment template.</p>', 'EnvironmentAccountConnection$environmentName' => '<p>The name of the environment that\'s associated with the environment account connection.</p>', 'EnvironmentAccountConnectionSummary$environmentName' => '<p>The name of the environment that\'s associated with the environment account connection.</p>', 'EnvironmentSummary$name' => '<p>The name of the environment.</p>', 'EnvironmentSummary$templateName' => '<p>The name of the environment template.</p>', 'EnvironmentTemplate$name' => '<p>The name of the environment template.</p>', 'EnvironmentTemplateFilter$templateName' => '<p>Include <code>templateName</code> to filter search for a template name.</p>', 'EnvironmentTemplateSummary$name' => '<p>The name of the environment template.</p>', 'EnvironmentTemplateVersion$templateName' => '<p>The name of the version of an environment template.</p>', 'EnvironmentTemplateVersionSummary$templateName' => '<p>The name of the environment template.</p>', 'GetComponentInput$name' => '<p>The name of the component that you want to get the detailed data for.</p>', 'GetEnvironmentInput$name' => '<p>The name of the environment that you want to get the detailed data for.</p>', 'GetEnvironmentTemplateInput$name' => '<p>The name of the environment template that you want to get the detailed data for.</p>', 'GetEnvironmentTemplateVersionInput$templateName' => '<p>The name of the environment template a version of which you want to get detailed data for..</p>', 'GetServiceInput$name' => '<p>The name of the service that you want to get the detailed data for.</p>', 'GetServiceInstanceInput$name' => '<p>The name of a service instance that you want to get the detailed data for.</p>', 'GetServiceInstanceInput$serviceName' => '<p>The name of the service that the service instance belongs to.</p>', 'GetServiceTemplateInput$name' => '<p>The name of the service template that you want to get detailed data for.</p>', 'GetServiceTemplateVersionInput$templateName' => '<p>The name of the service template a version of which you want to get detailed data for.</p>', 'GetTemplateSyncConfigInput$templateName' => '<p>The template name.</p>', 'GetTemplateSyncStatusInput$templateName' => '<p>The template name.</p>', 'ListComponentOutputsInput$componentName' => '<p>The name of the component whose outputs you want.</p>', 'ListComponentProvisionedResourcesInput$componentName' => '<p>The name of the component whose provisioned resources you want.</p>', 'ListComponentsInput$environmentName' => '<p>The name of an environment for result list filtering. Proton returns components associated with the environment or attached to service instances running in it.</p>', 'ListComponentsInput$serviceInstanceName' => '<p>The name of a service instance for result list filtering. Proton returns the component attached to the service instance, if any.</p>', 'ListComponentsInput$serviceName' => '<p>The name of a service for result list filtering. Proton returns components attached to service instances of the service.</p>', 'ListEnvironmentAccountConnectionsInput$environmentName' => '<p>The environment name that\'s associated with each listed environment account connection.</p>', 'ListEnvironmentOutputsInput$environmentName' => '<p>The environment name.</p>', 'ListEnvironmentProvisionedResourcesInput$environmentName' => '<p>The environment name.</p>', 'ListEnvironmentTemplateVersionsInput$templateName' => '<p>The name of the environment template.</p>', 'ListServiceInstanceOutputsInput$serviceInstanceName' => '<p>The name of the service instance whose outputs you want.</p>', 'ListServiceInstanceOutputsInput$serviceName' => '<p>The name of the service that <code>serviceInstanceName</code> is associated to.</p>', 'ListServiceInstanceProvisionedResourcesInput$serviceInstanceName' => '<p>The name of the service instance whose provisioned resources you want.</p>', 'ListServiceInstanceProvisionedResourcesInput$serviceName' => '<p>The name of the service that <code>serviceInstanceName</code> is associated to.</p>', 'ListServiceInstancesInput$serviceName' => '<p>The name of the service that the service instance belongs to.</p>', 'ListServicePipelineOutputsInput$serviceName' => '<p>The name of the service whose pipeline\'s outputs you want.</p>', 'ListServicePipelineProvisionedResourcesInput$serviceName' => '<p>The name of the service whose pipeline\'s provisioned resources you want.</p>', 'ListServiceTemplateVersionsInput$templateName' => '<p>The name of the service template.</p>', 'Service$name' => '<p>The name of the service.</p>', 'Service$templateName' => '<p>The name of the service template.</p>', 'ServiceInstance$environmentName' => '<p>The name of the environment that the service instance was deployed into.</p>', 'ServiceInstance$name' => '<p>The name of the service instance.</p>', 'ServiceInstance$serviceName' => '<p>The name of the service that the service instance belongs to.</p>', 'ServiceInstance$templateName' => '<p>The name of the service template that was used to create the service instance.</p>', 'ServiceInstanceSummary$environmentName' => '<p>The name of the environment that the service instance was deployed into.</p>', 'ServiceInstanceSummary$name' => '<p>The name of the service instance.</p>', 'ServiceInstanceSummary$serviceName' => '<p>The name of the service that the service instance belongs to.</p>', 'ServiceInstanceSummary$templateName' => '<p>The name of the service template.</p>', 'ServicePipeline$templateName' => '<p>The name of the service template that was used to create the service pipeline.</p>', 'ServiceSummary$name' => '<p>The name of the service.</p>', 'ServiceSummary$templateName' => '<p>The name of the service template.</p>', 'ServiceTemplate$name' => '<p>The name of the service template.</p>', 'ServiceTemplateSummary$name' => '<p>The name of the service template.</p>', 'ServiceTemplateVersion$templateName' => '<p>The name of the version of a service template.</p>', 'ServiceTemplateVersionSummary$templateName' => '<p>The name of the service template.</p>', 'TemplateSyncConfig$templateName' => '<p>The template name.</p>', 'UpdateComponentInput$name' => '<p>The name of the component to update.</p>', 'UpdateEnvironmentInput$name' => '<p>The name of the environment to update.</p>', 'UpdateEnvironmentTemplateInput$name' => '<p>The name of the environment template to update.</p>', 'UpdateEnvironmentTemplateVersionInput$templateName' => '<p>The name of the environment template.</p>', 'UpdateServiceInput$name' => '<p>The name of the service to edit.</p>', 'UpdateServiceInstanceInput$name' => '<p>The name of the service instance to update.</p>', 'UpdateServiceInstanceInput$serviceName' => '<p>The name of the service that the service instance belongs to.</p>', 'UpdateServicePipelineInput$serviceName' => '<p>The name of the service to that the pipeline is associated with.</p>', 'UpdateServiceTemplateInput$name' => '<p>The name of the service template to update.</p>', 'UpdateServiceTemplateVersionInput$templateName' => '<p>The name of the service template.</p>', 'UpdateTemplateSyncConfigInput$templateName' => '<p>The synced template name.</p>', ], ], 'ResourceNameOrEmpty' => [ 'base' => NULL, 'refs' => [ 'UpdateComponentInput$serviceInstanceName' => '<p>The name of the service instance that you want to attach this component to. Don\'t specify to keep the component\'s current service instance attachment. Specify an empty string to detach the component from the service instance it\'s attached to. Specify non-empty values for both <code>serviceInstanceName</code> and <code>serviceName</code> or for neither of them.</p>', 'UpdateComponentInput$serviceName' => '<p>The name of the service that <code>serviceInstanceName</code> is associated with. Don\'t specify to keep the component\'s current service instance attachment. Specify an empty string to detach the component from the service instance it\'s attached to. Specify non-empty values for both <code>serviceInstanceName</code> and <code>serviceName</code> or for neither of them.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource <i>wasn\'t</i> found.</p>', 'refs' => [], ], 'ResourceSyncAttempt' => [ 'base' => '<p>Detail data for a resource sync attempt activated by a push to a repository.</p>', 'refs' => [ 'GetTemplateSyncStatusOutput$latestSuccessfulSync' => '<p>The details of the last successful sync that\'s returned by Proton.</p>', 'GetTemplateSyncStatusOutput$latestSync' => '<p>The details of the last sync that\'s returned by Proton.</p>', ], ], 'ResourceSyncEvent' => [ 'base' => '<p>Detail data for a resource sync event.</p>', 'refs' => [ 'ResourceSyncEvents$member' => NULL, ], ], 'ResourceSyncEvents' => [ 'base' => NULL, 'refs' => [ 'ResourceSyncAttempt$events' => '<p>An array of events with detail data.</p>', ], ], 'ResourceSyncStatus' => [ 'base' => NULL, 'refs' => [ 'ResourceSyncAttempt$status' => '<p>The status of the sync attempt.</p>', ], ], 'Revision' => [ 'base' => '<p>Revision detail data for a commit and push that activates a sync attempt</p>', 'refs' => [ 'GetTemplateSyncStatusOutput$desiredState' => '<p>The template sync desired state that\'s returned by Proton.</p>', 'ResourceSyncAttempt$initialRevision' => '<p>Detail data for the initial repository commit, path and push.</p>', 'ResourceSyncAttempt$targetRevision' => '<p>Detail data for the target revision.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'S3ObjectSource$bucket' => '<p>The name of the S3 bucket that contains a template bundle.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'S3ObjectSource$key' => '<p>The path to the S3 bucket that contains a template bundle.</p>', ], ], 'S3ObjectSource' => [ 'base' => '<p>Template bundle S3 bucket data.</p>', 'refs' => [ 'TemplateVersionSourceInput$s3' => '<p>An S3 source object that includes the template bundle S3 path and name for a template minor version.</p>', ], ], 'SHA' => [ 'base' => NULL, 'refs' => [ 'Revision$sha' => '<p>The secure hash algorithm (SHA) hash for the revision.</p>', ], ], 'Service' => [ 'base' => '<p>Detailed data of an Proton service resource.</p>', 'refs' => [ 'CreateServiceOutput$service' => '<p>The service detail data that\'s returned by Proton.</p>', 'DeleteServiceOutput$service' => '<p>The detailed data of the service being deleted.</p>', 'GetServiceOutput$service' => '<p>The detailed data of the requested service.</p>', 'UpdateServiceOutput$service' => '<p>The service detail data that\'s returned by Proton.</p>', ], ], 'ServiceArn' => [ 'base' => NULL, 'refs' => [ 'Service$arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', 'ServiceSummary$arn' => '<p>The Amazon Resource Name (ARN) of the service.</p>', ], ], 'ServiceInstance' => [ 'base' => '<p>Detailed data of an Proton service instance resource.</p>', 'refs' => [ 'CancelServiceInstanceDeploymentOutput$serviceInstance' => '<p>The service instance summary data that\'s returned by Proton.</p>', 'GetServiceInstanceOutput$serviceInstance' => '<p>The detailed data of the requested service instance.</p>', 'UpdateServiceInstanceOutput$serviceInstance' => '<p>The service instance summary data that\'s returned by Proton.</p>', ], ], 'ServiceInstanceArn' => [ 'base' => NULL, 'refs' => [ 'ServiceInstance$arn' => '<p>The Amazon Resource Name (ARN) of the service instance.</p>', 'ServiceInstanceSummary$arn' => '<p>The Amazon Resource Name (ARN) of the service instance.</p>', ], ], 'ServiceInstanceSummary' => [ 'base' => '<p>Summary data of an Proton service instance resource.</p>', 'refs' => [ 'ServiceInstanceSummaryList$member' => NULL, ], ], 'ServiceInstanceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListServiceInstancesOutput$serviceInstances' => '<p>An array of service instances with summary data.</p>', ], ], 'ServicePipeline' => [ 'base' => '<p>Detailed data of an Proton service instance pipeline resource.</p>', 'refs' => [ 'CancelServicePipelineDeploymentOutput$pipeline' => '<p>The service pipeline detail data that\'s returned by Proton.</p>', 'Service$pipeline' => '<p>The service pipeline detail data.</p>', 'UpdateServicePipelineOutput$pipeline' => '<p>The pipeline details that are returned by Proton.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>A quota was exceeded. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-limits.html">Proton Quotas</a> in the <i>Proton Administrator Guide</i>.</p>', 'refs' => [], ], 'ServiceStatus' => [ 'base' => NULL, 'refs' => [ 'Service$status' => '<p>The status of the service.</p>', 'ServiceSummary$status' => '<p>The status of the service.</p>', ], ], 'ServiceSummary' => [ 'base' => '<p>Summary data of an Proton service resource.</p>', 'refs' => [ 'ServiceSummaryList$member' => NULL, ], ], 'ServiceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListServicesOutput$services' => '<p>An array of services with summaries of detail data.</p>', ], ], 'ServiceTemplate' => [ 'base' => '<p>Detailed data of an Proton service template resource.</p>', 'refs' => [ 'CreateServiceTemplateOutput$serviceTemplate' => '<p>The service template detail data that\'s returned by Proton.</p>', 'DeleteServiceTemplateOutput$serviceTemplate' => '<p>The detailed data of the service template being deleted.</p>', 'GetServiceTemplateOutput$serviceTemplate' => '<p>The detailed data of the requested service template.</p>', 'UpdateServiceTemplateOutput$serviceTemplate' => '<p>The service template detail data that\'s returned by Proton.</p>', ], ], 'ServiceTemplateArn' => [ 'base' => NULL, 'refs' => [ 'ServiceTemplate$arn' => '<p>The Amazon Resource Name (ARN) of the service template.</p>', 'ServiceTemplateSummary$arn' => '<p>The Amazon Resource Name (ARN) of the service template.</p>', ], ], 'ServiceTemplateSummary' => [ 'base' => '<p>Summary data of an Proton service template resource.</p>', 'refs' => [ 'ServiceTemplateSummaryList$member' => NULL, ], ], 'ServiceTemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListServiceTemplatesOutput$templates' => '<p>An array of service templates with detail data.</p>', ], ], 'ServiceTemplateSupportedComponentSourceInputList' => [ 'base' => NULL, 'refs' => [ 'CreateServiceTemplateVersionInput$supportedComponentSources' => '<p>An array of supported component sources. Components with supported sources can be attached to service instances based on this service template version.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'ServiceTemplateVersion$supportedComponentSources' => '<p>An array of supported component sources. Components with supported sources can be attached to service instances based on this service template version.</p> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', 'UpdateServiceTemplateVersionInput$supportedComponentSources' => '<p>An array of supported component sources. Components with supported sources can be attached to service instances based on this service template version.</p> <note> <p>A change to <code>supportedComponentSources</code> doesn\'t impact existing component attachments to instances based on this template version. A change only affects later associations.</p> </note> <p>For more information about components, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-components.html">Proton components</a> in the <i>Proton Administrator Guide</i>.</p>', ], ], 'ServiceTemplateSupportedComponentSourceType' => [ 'base' => NULL, 'refs' => [ 'ServiceTemplateSupportedComponentSourceInputList$member' => NULL, ], ], 'ServiceTemplateVersion' => [ 'base' => '<p>Detailed data of an Proton service template version resource.</p>', 'refs' => [ 'CreateServiceTemplateVersionOutput$serviceTemplateVersion' => '<p>The service template version summary of detail data that\'s returned by Proton.</p>', 'DeleteServiceTemplateVersionOutput$serviceTemplateVersion' => '<p>The detailed data of the service template version being deleted.</p>', 'GetServiceTemplateVersionOutput$serviceTemplateVersion' => '<p>The detailed data of the requested service template version.</p>', 'UpdateServiceTemplateVersionOutput$serviceTemplateVersion' => '<p>The service template version detail data that\'s returned by Proton.</p>', ], ], 'ServiceTemplateVersionArn' => [ 'base' => NULL, 'refs' => [ 'ServiceTemplateVersion$arn' => '<p>The Amazon Resource Name (ARN) of the version of a service template.</p>', 'ServiceTemplateVersionSummary$arn' => '<p>The Amazon Resource Name (ARN) of the version of a service template.</p>', ], ], 'ServiceTemplateVersionSummary' => [ 'base' => '<p>Summary data of an Proton service template version resource.</p>', 'refs' => [ 'ServiceTemplateVersionSummaryList$member' => NULL, ], ], 'ServiceTemplateVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListServiceTemplateVersionsOutput$templateVersions' => '<p>An array of major or minor versions of a service template with detail data.</p>', ], ], 'SpecContents' => [ 'base' => NULL, 'refs' => [ 'Component$serviceSpec' => '<p>The service spec that the component uses to access service inputs. Provided when a component is attached to a service instance.</p>', 'CreateComponentInput$serviceSpec' => '<p>The service spec that you want the component to use to access service inputs. Set this only when you attach the component to a service instance.</p>', 'CreateEnvironmentInput$spec' => '<p>A YAML formatted string that provides inputs as defined in the environment template bundle schema file. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html">Environments</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateServiceInput$spec' => '<p>A link to a spec file that provides inputs as defined in the service template bundle schema file. The spec file is in YAML format. <i>Don’t</i> include pipeline inputs in the spec if your service template <i>doesn’t</i> include a service pipeline. For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-create-svc.html.html">Create a service</a> in the <i>Proton Administrator Guide</i> and <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-create.html">Create a service</a> in the <i>Proton User Guide</i>.</p>', 'Environment$spec' => '<p>The environment spec.</p>', 'Service$spec' => '<p>The formatted specification that defines the service.</p>', 'ServiceInstance$spec' => '<p>The service spec that was used to create the service instance.</p>', 'ServicePipeline$spec' => '<p>The service spec that was used to create the service pipeline.</p>', 'UpdateComponentInput$serviceSpec' => '<p>The service spec that you want the component to use to access service inputs. Set this only when the component is attached to a service instance.</p>', 'UpdateEnvironmentInput$spec' => '<p>The formatted specification that defines the update.</p>', 'UpdateServiceInput$spec' => '<p>Lists the service instances to add and the existing service instances to remain. Omit the existing service instances to delete from the list. <i>Don\'t</i> include edits to the existing service instances or pipeline. For more information, see <i>Edit a service</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/ag-svc-update.html">Proton Administrator Guide</a> or the <a href="https://docs.aws.amazon.com/proton/latest/userguide/ug-svc-update.html">Proton User Guide</a>.</p>', 'UpdateServiceInstanceInput$spec' => '<p>The formatted specification that defines the service instance update.</p>', 'UpdateServicePipelineInput$spec' => '<p>The spec for the service pipeline to update.</p>', ], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'Component$deploymentStatusMessage' => '<p>The message associated with the component deployment status.</p>', 'ComponentSummary$deploymentStatusMessage' => '<p>The message associated with the component deployment status.</p>', 'Environment$deploymentStatusMessage' => '<p>An environment deployment status message.</p>', 'EnvironmentSummary$deploymentStatusMessage' => '<p>An environment deployment status message.</p>', 'EnvironmentTemplateVersion$statusMessage' => '<p>The status message of the version of an environment template.</p>', 'EnvironmentTemplateVersionSummary$statusMessage' => '<p>The status message of the version of an environment template.</p>', 'Service$statusMessage' => '<p>A service status message.</p>', 'ServiceInstance$deploymentStatusMessage' => '<p>The message associated with the service instance deployment status.</p>', 'ServiceInstanceSummary$deploymentStatusMessage' => '<p>A service instance deployment status message.</p>', 'ServicePipeline$deploymentStatusMessage' => '<p>A service pipeline deployment status message.</p>', 'ServiceSummary$statusMessage' => '<p>A service status message.</p>', 'ServiceTemplateVersion$statusMessage' => '<p>A service template version status message.</p>', 'ServiceTemplateVersionSummary$statusMessage' => '<p>A service template minor version status message.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceInput$nextToken' => '<p>A token that indicates the location of the next resource tag in the array of resource tags, after the list of resource tags that was previously requested.</p>', 'ListTagsForResourceOutput$nextToken' => '<p>A token that indicates the location of the next resource tag in the array of resource tags, after the current requested list of resource tags.</p>', 'RepositorySyncDefinition$directory' => '<p>The directory in the repository.</p>', 'RepositorySyncDefinition$parent' => '<p>The resource that is synced from.</p>', 'RepositorySyncDefinition$target' => '<p>The resource that is synced to.</p>', 'RepositorySyncEvent$event' => '<p>Event detail for a repository sync attempt.</p>', 'RepositorySyncEvent$externalId' => '<p>The external ID of the sync event.</p>', 'RepositorySyncEvent$type' => '<p>The type of event.</p>', 'ResourceSyncAttempt$target' => '<p>The resource that is synced to.</p>', 'ResourceSyncEvent$event' => '<p>A resource sync event.</p>', 'ResourceSyncEvent$externalId' => '<p>The external ID for the event.</p>', 'ResourceSyncEvent$type' => '<p>The type of event.</p>', 'Revision$directory' => '<p>The repository directory changed by a commit and push that activated the sync attempt.</p>', ], ], 'Subdirectory' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateSyncConfigInput$subdirectory' => '<p>A repository subdirectory path to your template bundle directory. When included, Proton limits the template bundle search to this repository directory.</p>', 'TemplateSyncConfig$subdirectory' => '<p>A subdirectory path to your template bundle version.</p>', 'UpdateTemplateSyncConfigInput$subdirectory' => '<p>A subdirectory path to your template bundle version. When included, limits the template bundle search to this repository directory.</p>', ], ], 'SyncType' => [ 'base' => NULL, 'refs' => [ 'GetRepositorySyncStatusInput$syncType' => '<p>The repository sync type.</p>', 'ListRepositorySyncDefinitionsInput$syncType' => '<p>The sync type. The only supported value is <code>TEMPLATE_SYNC</code>.</p>', ], ], 'Tag' => [ 'base' => '<p>A description of a resource tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key of the resource tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>A list of customer tag keys that indicate the customer tags to be removed from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateComponentInput$tags' => '<p>An optional list of metadata items that you can associate with the Proton component. A tag is a key-value pair.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'CreateEnvironmentAccountConnectionInput$tags' => '<p>An optional list of metadata items that you can associate with the Proton environment account connection. A tag is a key-value pair.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton resources and tagging</a> in the <i>Proton Administrator Guide</i>.</p>', 'CreateEnvironmentInput$tags' => '<p>An optional list of metadata items that you can associate with the Proton environment. A tag is a key-value pair.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'CreateEnvironmentTemplateInput$tags' => '<p>An optional list of metadata items that you can associate with the Proton environment template. A tag is a key-value pair.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'CreateEnvironmentTemplateVersionInput$tags' => '<p>An optional list of metadata items that you can associate with the Proton environment template version. A tag is a key-value pair.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'CreateRepositoryInput$tags' => '<p>An optional list of metadata items that you can associate with the Proton repository. A tag is a key-value pair.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'CreateServiceInput$tags' => '<p>An optional list of metadata items that you can associate with the Proton service. A tag is a key-value pair.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'CreateServiceTemplateInput$tags' => '<p>An optional list of metadata items that you can associate with the Proton service template. A tag is a key-value pair.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'CreateServiceTemplateVersionInput$tags' => '<p>An optional list of metadata items that you can associate with the Proton service template version. A tag is a key-value pair.</p> <p>For more information, see <i>Proton resources and tagging</i> in the <a href="https://docs.aws.amazon.com/proton/latest/adminguide/resources.html">Proton Administrator Guide</a> or <a href="https://docs.aws.amazon.com/proton/latest/userguide/resources.html">Proton User Guide</a>.</p>', 'ListTagsForResourceOutput$tags' => '<p>A list of resource tags with detail data.</p>', 'TagResourceInput$tags' => '<p>A list of customer tags to apply to the Proton resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value of the resource tag.</p>', ], ], 'TemplateFileContents' => [ 'base' => NULL, 'refs' => [ 'CreateComponentInput$templateFile' => '<p>A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component provisions.</p> <note> <p>Components support a single IaC file, even if you use Terraform as your template language.</p> </note>', 'UpdateComponentInput$templateFile' => '<p>A path to the Infrastructure as Code (IaC) file describing infrastructure that a custom component provisions.</p> <note> <p>Components support a single IaC file, even if you use Terraform as your template language.</p> </note>', ], ], 'TemplateManifestContents' => [ 'base' => NULL, 'refs' => [ 'CreateComponentInput$manifest' => '<p>A path to a manifest file that lists the Infrastructure as Code (IaC) file, template language, and rendering engine for infrastructure that a custom component provisions.</p>', ], ], 'TemplateSchema' => [ 'base' => NULL, 'refs' => [ 'EnvironmentTemplateVersion$schema' => '<p>The schema of the version of an environment template.</p>', 'ServiceTemplateVersion$schema' => '<p>The schema of the version of a service template.</p>', ], ], 'TemplateSyncConfig' => [ 'base' => '<p>The detail data for a template sync configuration.</p>', 'refs' => [ 'CreateTemplateSyncConfigOutput$templateSyncConfig' => '<p>The template sync configuration detail data that\'s returned by Proton.</p>', 'DeleteTemplateSyncConfigOutput$templateSyncConfig' => '<p>The template sync configuration detail data that\'s returned by Proton.</p>', 'GetTemplateSyncConfigOutput$templateSyncConfig' => '<p>The template sync configuration detail data that\'s returned by Proton.</p>', 'UpdateTemplateSyncConfigOutput$templateSyncConfig' => '<p>The template sync configuration detail data that\'s returned by Proton.</p>', ], ], 'TemplateType' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateSyncConfigInput$templateType' => '<p>The type of the registered template.</p>', 'DeleteTemplateSyncConfigInput$templateType' => '<p>The template type.</p>', 'GetTemplateSyncConfigInput$templateType' => '<p>The template type.</p>', 'GetTemplateSyncStatusInput$templateType' => '<p>The template type.</p>', 'TemplateSyncConfig$templateType' => '<p>The template type.</p>', 'UpdateTemplateSyncConfigInput$templateType' => '<p>The synced template type.</p>', ], ], 'TemplateVersionPart' => [ 'base' => NULL, 'refs' => [ 'CompatibleEnvironmentTemplate$majorVersion' => '<p>The major version of the compatible environment template.</p>', 'CompatibleEnvironmentTemplateInput$majorVersion' => '<p>The major version of the compatible environment template.</p>', 'CreateEnvironmentInput$templateMajorVersion' => '<p>The major version of the environment template.</p>', 'CreateEnvironmentInput$templateMinorVersion' => '<p>The minor version of the environment template.</p>', 'CreateEnvironmentTemplateVersionInput$majorVersion' => '<p>To create a new minor version of the environment template, include <code>major Version</code>.</p> <p>To create a new major and minor version of the environment template, exclude <code>major Version</code>.</p>', 'CreateServiceInput$templateMajorVersion' => '<p>The major version of the service template that was used to create the service.</p>', 'CreateServiceInput$templateMinorVersion' => '<p>The minor version of the service template that was used to create the service.</p>', 'CreateServiceTemplateVersionInput$majorVersion' => '<p>To create a new minor version of the service template, include a <code>major Version</code>.</p> <p>To create a new major and minor version of the service template, <i>exclude</i> <code>major Version</code>.</p>', 'DeleteEnvironmentTemplateVersionInput$majorVersion' => '<p>The environment template major version to delete.</p>', 'DeleteEnvironmentTemplateVersionInput$minorVersion' => '<p>The environment template minor version to delete.</p>', 'DeleteServiceTemplateVersionInput$majorVersion' => '<p>The service template major version to delete.</p>', 'DeleteServiceTemplateVersionInput$minorVersion' => '<p>The service template minor version to delete.</p>', 'Environment$templateMajorVersion' => '<p>The major version of the environment template.</p>', 'Environment$templateMinorVersion' => '<p>The minor version of the environment template.</p>', 'EnvironmentSummary$templateMajorVersion' => '<p>The major version of the environment template.</p>', 'EnvironmentSummary$templateMinorVersion' => '<p>The minor version of the environment template.</p>', 'EnvironmentTemplateFilter$majorVersion' => '<p>Include <code>majorVersion</code> to filter search for a major version.</p>', 'EnvironmentTemplateVersion$majorVersion' => '<p>The latest major version that\'s associated with the version of an environment template.</p>', 'EnvironmentTemplateVersion$minorVersion' => '<p>The minor version of an environment template.</p>', 'EnvironmentTemplateVersion$recommendedMinorVersion' => '<p>The recommended minor version of the environment template.</p>', 'EnvironmentTemplateVersionSummary$majorVersion' => '<p>The latest major version that\'s associated with the version of an environment template.</p>', 'EnvironmentTemplateVersionSummary$minorVersion' => '<p>The version of an environment template.</p>', 'EnvironmentTemplateVersionSummary$recommendedMinorVersion' => '<p>The recommended minor version of the environment template.</p>', 'GetEnvironmentTemplateVersionInput$majorVersion' => '<p>To get environment template major version detail data, include <code>major Version</code>.</p>', 'GetEnvironmentTemplateVersionInput$minorVersion' => '<p>To get environment template minor version detail data, include <code>minorVersion</code>.</p>', 'GetServiceTemplateVersionInput$majorVersion' => '<p>To get service template major version detail data, include <code>major Version</code>.</p>', 'GetServiceTemplateVersionInput$minorVersion' => '<p>To get service template minor version detail data, include <code>minorVersion</code>.</p>', 'GetTemplateSyncStatusInput$templateVersion' => '<p>The template major version.</p>', 'ListEnvironmentTemplateVersionsInput$majorVersion' => '<p>To view a list of minor of versions under a major version of an environment template, include <code>major Version</code>.</p> <p>To view a list of major versions of an environment template, <i>exclude</i> <code>major Version</code>.</p>', 'ListServiceTemplateVersionsInput$majorVersion' => '<p>To view a list of minor of versions under a major version of a service template, include <code>major Version</code>.</p> <p>To view a list of major versions of a service template, <i>exclude</i> <code>major Version</code>.</p>', 'ServiceInstance$templateMajorVersion' => '<p>The major version of the service template that was used to create the service instance.</p>', 'ServiceInstance$templateMinorVersion' => '<p>The minor version of the service template that was used to create the service instance.</p>', 'ServiceInstanceSummary$templateMajorVersion' => '<p>The service instance template major version.</p>', 'ServiceInstanceSummary$templateMinorVersion' => '<p>The service instance template minor version.</p>', 'ServicePipeline$templateMajorVersion' => '<p>The major version of the service template that was used to create the service pipeline.</p>', 'ServicePipeline$templateMinorVersion' => '<p>The minor version of the service template that was used to create the service pipeline.</p>', 'ServiceTemplateVersion$majorVersion' => '<p>The latest major version that\'s associated with the version of a service template.</p>', 'ServiceTemplateVersion$minorVersion' => '<p>The minor version of a service template.</p>', 'ServiceTemplateVersion$recommendedMinorVersion' => '<p>The recommended minor version of the service template.</p>', 'ServiceTemplateVersionSummary$majorVersion' => '<p>The latest major version that\'s associated with the version of a service template.</p>', 'ServiceTemplateVersionSummary$minorVersion' => '<p>The minor version of a service template.</p>', 'ServiceTemplateVersionSummary$recommendedMinorVersion' => '<p>The recommended minor version of the service template.</p>', 'UpdateEnvironmentInput$templateMajorVersion' => '<p>The major version of the environment to update.</p>', 'UpdateEnvironmentInput$templateMinorVersion' => '<p>The minor version of the environment to update.</p>', 'UpdateEnvironmentTemplateVersionInput$majorVersion' => '<p>To update a major version of an environment template, include <code>major Version</code>.</p>', 'UpdateEnvironmentTemplateVersionInput$minorVersion' => '<p>To update a minor version of an environment template, include <code>minorVersion</code>.</p>', 'UpdateServiceInstanceInput$templateMajorVersion' => '<p>The major version of the service template to update.</p>', 'UpdateServiceInstanceInput$templateMinorVersion' => '<p>The minor version of the service template to update.</p>', 'UpdateServicePipelineInput$templateMajorVersion' => '<p>The major version of the service template that was used to create the service that the pipeline is associated with.</p>', 'UpdateServicePipelineInput$templateMinorVersion' => '<p>The minor version of the service template that was used to create the service that the pipeline is associated with.</p>', 'UpdateServiceTemplateVersionInput$majorVersion' => '<p>To update a major version of a service template, include <code>major Version</code>.</p>', 'UpdateServiceTemplateVersionInput$minorVersion' => '<p>To update a minor version of a service template, include <code>minorVersion</code>.</p>', ], ], 'TemplateVersionSourceInput' => [ 'base' => '<p>Template version source data.</p>', 'refs' => [ 'CreateEnvironmentTemplateVersionInput$source' => '<p>An object that includes the template bundle S3 bucket path and name for the new version of an template.</p>', 'CreateServiceTemplateVersionInput$source' => '<p>An object that includes the template bundle S3 bucket path and name for the new version of a service template.</p>', ], ], 'TemplateVersionStatus' => [ 'base' => NULL, 'refs' => [ 'EnvironmentTemplateVersion$status' => '<p>The status of the version of an environment template.</p>', 'EnvironmentTemplateVersionSummary$status' => '<p>The status of the version of an environment template.</p>', 'ServiceTemplateVersion$status' => '<p>The service template version status.</p>', 'ServiceTemplateVersionSummary$status' => '<p>The service template minor version status.</p>', 'UpdateEnvironmentTemplateVersionInput$status' => '<p>The status of the environment template minor version to update.</p>', 'UpdateServiceTemplateVersionInput$status' => '<p>The status of the service template minor version to update.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Component$createdAt' => '<p>The time when the component was created.</p>', 'Component$lastDeploymentAttemptedAt' => '<p>The time when a deployment of the component was last attempted.</p>', 'Component$lastDeploymentSucceededAt' => '<p>The time when the component was last deployed successfully.</p>', 'Component$lastModifiedAt' => '<p>The time when the component was last modified.</p>', 'ComponentSummary$createdAt' => '<p>The time when the component was created.</p>', 'ComponentSummary$lastDeploymentAttemptedAt' => '<p>The time when a deployment of the component was last attempted.</p>', 'ComponentSummary$lastDeploymentSucceededAt' => '<p>The time when the component was last deployed successfully.</p>', 'ComponentSummary$lastModifiedAt' => '<p>The time when the component was last modified.</p>', 'Environment$createdAt' => '<p>The time when the environment was created.</p>', 'Environment$lastDeploymentAttemptedAt' => '<p>The time when a deployment of the environment was last attempted.</p>', 'Environment$lastDeploymentSucceededAt' => '<p>The time when the environment was last deployed successfully.</p>', 'EnvironmentAccountConnection$lastModifiedAt' => '<p>The time when the environment account connection was last modified.</p>', 'EnvironmentAccountConnection$requestedAt' => '<p>The time when the environment account connection request was made.</p>', 'EnvironmentAccountConnectionSummary$lastModifiedAt' => '<p>The time when the environment account connection was last modified.</p>', 'EnvironmentAccountConnectionSummary$requestedAt' => '<p>The time when the environment account connection request was made.</p>', 'EnvironmentSummary$createdAt' => '<p>The time when the environment was created.</p>', 'EnvironmentSummary$lastDeploymentAttemptedAt' => '<p>The time when a deployment of the environment was last attempted.</p>', 'EnvironmentSummary$lastDeploymentSucceededAt' => '<p>The time when the environment was last deployed successfully.</p>', 'EnvironmentTemplate$createdAt' => '<p>The time when the environment template was created.</p>', 'EnvironmentTemplate$lastModifiedAt' => '<p>The time when the environment template was last modified.</p>', 'EnvironmentTemplateSummary$createdAt' => '<p>The time when the environment template was created.</p>', 'EnvironmentTemplateSummary$lastModifiedAt' => '<p>The time when the environment template was last modified.</p>', 'EnvironmentTemplateVersion$createdAt' => '<p>The time when the version of an environment template was created.</p>', 'EnvironmentTemplateVersion$lastModifiedAt' => '<p>The time when the version of an environment template was last modified.</p>', 'EnvironmentTemplateVersionSummary$createdAt' => '<p>The time when the version of an environment template was created.</p>', 'EnvironmentTemplateVersionSummary$lastModifiedAt' => '<p>The time when the version of an environment template was last modified.</p>', 'RepositorySyncAttempt$startedAt' => '<p>The time when the sync attempt started.</p>', 'RepositorySyncEvent$time' => '<p>The time that the sync event occurred.</p>', 'ResourceSyncAttempt$startedAt' => '<p>The time when the sync attempt started.</p>', 'ResourceSyncEvent$time' => '<p>The time when the event occurred.</p>', 'Service$createdAt' => '<p>The time when the service was created.</p>', 'Service$lastModifiedAt' => '<p>The time when the service was last modified.</p>', 'ServiceInstance$createdAt' => '<p>The time when the service instance was created.</p>', 'ServiceInstance$lastDeploymentAttemptedAt' => '<p>The time when a deployment of the service instance was last attempted.</p>', 'ServiceInstance$lastDeploymentSucceededAt' => '<p>The time when the service instance was last deployed successfully.</p>', 'ServiceInstanceSummary$createdAt' => '<p>The time when the service instance was created.</p>', 'ServiceInstanceSummary$lastDeploymentAttemptedAt' => '<p>The time when a deployment of the service was last attempted.</p>', 'ServiceInstanceSummary$lastDeploymentSucceededAt' => '<p>The time when the service was last deployed successfully.</p>', 'ServicePipeline$createdAt' => '<p>The time when the service pipeline was created.</p>', 'ServicePipeline$lastDeploymentAttemptedAt' => '<p>The time when a deployment of the service pipeline was last attempted.</p>', 'ServicePipeline$lastDeploymentSucceededAt' => '<p>The time when the service pipeline was last deployed successfully.</p>', 'ServiceSummary$createdAt' => '<p>The time when the service was created.</p>', 'ServiceSummary$lastModifiedAt' => '<p>The time when the service was last modified.</p>', 'ServiceTemplate$createdAt' => '<p>The time when the service template was created.</p>', 'ServiceTemplate$lastModifiedAt' => '<p>The time when the service template was last modified.</p>', 'ServiceTemplateSummary$createdAt' => '<p>The time when the service template was created.</p>', 'ServiceTemplateSummary$lastModifiedAt' => '<p>The time when the service template was last modified.</p>', 'ServiceTemplateVersion$createdAt' => '<p>The time when the version of a service template was created.</p>', 'ServiceTemplateVersion$lastModifiedAt' => '<p>The time when the version of a service template was last modified.</p>', 'ServiceTemplateVersionSummary$createdAt' => '<p>The time when the version of a service template was created.</p>', 'ServiceTemplateVersionSummary$lastModifiedAt' => '<p>The time when the version of a service template was last modified.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentAccountConnectionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentAccountConnectionOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentTemplateVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentTemplateVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceInstanceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceInstanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServicePipelineInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServicePipelineOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceTemplateInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceTemplateOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceTemplateVersionInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServiceTemplateVersionOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateSyncConfigInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateSyncConfigOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input is invalid or an out-of-range value was supplied for the input parameter.</p>', 'refs' => [], ], ],];
