<?php
// This file was auto-generated from sdk-root/src/data/medialive/2017-10-14/docs-2.json
return [ 'version' => '2.0', 'service' => 'API for AWS Elemental MediaLive', 'operations' => [ 'AcceptInputDeviceTransfer' => 'Accept an incoming input device transfer. The ownership of the device will transfer to your AWS account.', 'BatchDelete' => 'Starts delete of resources.', 'BatchStart' => 'Starts existing resources', 'BatchStop' => 'Stops running resources', 'BatchUpdateSchedule' => 'Update a channel schedule', 'CancelInputDeviceTransfer' => 'Cancel an input device transfer that you have requested.', 'ClaimDevice' => 'Send a request to claim an AWS Elemental device that you have purchased from a third-party vendor. After the request succeeds, you will own the device.', 'CreateChannel' => 'Creates a new channel', 'CreateInput' => 'Create an input', 'CreateInputSecurityGroup' => 'Creates a Input Security Group', 'CreateMultiplex' => 'Create a new multiplex.', 'CreateMultiplexProgram' => 'Create a new program in the multiplex.', 'CreatePartnerInput' => 'Create a partner input', 'CreateTags' => 'Create tags for a resource', 'DeleteChannel' => 'Starts deletion of channel. The associated outputs are also deleted.', 'DeleteInput' => 'Deletes the input end point', 'DeleteInputSecurityGroup' => 'Deletes an Input Security Group', 'DeleteMultiplex' => 'Delete a multiplex. The multiplex must be idle.', 'DeleteMultiplexProgram' => 'Delete a program from a multiplex.', 'DeleteReservation' => 'Delete an expired reservation.', 'DeleteSchedule' => 'Delete all schedule actions on a channel.', 'DeleteTags' => 'Removes tags for a resource', 'DescribeChannel' => 'Gets details about a channel', 'DescribeInput' => 'Produces details about an input', 'DescribeInputDevice' => 'Gets the details for the input device', 'DescribeInputDeviceThumbnail' => 'Get the latest thumbnail data for the input device.', 'DescribeInputSecurityGroup' => 'Produces a summary of an Input Security Group', 'DescribeMultiplex' => 'Gets details about a multiplex.', 'DescribeMultiplexProgram' => 'Get the details for a program in a multiplex.', 'DescribeOffering' => 'Get details for an offering.', 'DescribeReservation' => 'Get details for a reservation.', 'DescribeSchedule' => 'Get a channel schedule', 'ListChannels' => 'Produces list of channels that have been created', 'ListInputDeviceTransfers' => 'List input devices that are currently being transferred. List input devices that you are transferring from your AWS account or input devices that another AWS account is transferring to you.', 'ListInputDevices' => 'List input devices', 'ListInputSecurityGroups' => 'Produces a list of Input Security Groups for an account', 'ListInputs' => 'Produces list of inputs that have been created', 'ListMultiplexPrograms' => 'List the programs that currently exist for a specific multiplex.', 'ListMultiplexes' => 'Retrieve a list of the existing multiplexes.', 'ListOfferings' => 'List offerings available for purchase.', 'ListReservations' => 'List purchased reservations.', 'ListTagsForResource' => 'Produces list of tags that have been created for a resource', 'PurchaseOffering' => 'Purchase an offering and create a reservation.', 'RebootInputDevice' => 'Send a reboot command to the specified input device. The device will begin rebooting within a few seconds of sending the command. When the reboot is complete, the device’s connection status will change to connected.', 'RejectInputDeviceTransfer' => 'Reject the transfer of the specified input device to your AWS account.', 'StartChannel' => 'Starts an existing channel', 'StartInputDeviceMaintenanceWindow' => 'Start a maintenance window for the specified input device. Starting a maintenance window will give the device up to two hours to install software. If the device was streaming prior to the maintenance, it will resume streaming when the software is fully installed. Devices automatically install updates while they are powered on and their MediaLive channels are stopped. A maintenance window allows you to update a device without having to stop MediaLive channels that use the device. The device must remain powered on and connected to the internet for the duration of the maintenance.', 'StartMultiplex' => 'Start (run) the multiplex. Starting the multiplex does not start the channels. You must explicitly start each channel.', 'StopChannel' => 'Stops a running channel', 'StopMultiplex' => 'Stops a running multiplex. If the multiplex isn\'t running, this action has no effect.', 'TransferInputDevice' => 'Start an input device transfer to another AWS account. After you make the request, the other account must accept or reject the transfer.', 'UpdateChannel' => 'Updates a channel.', 'UpdateChannelClass' => 'Changes the class of the channel.', 'UpdateInput' => 'Updates an input.', 'UpdateInputDevice' => 'Updates the parameters for the input device.', 'UpdateInputSecurityGroup' => 'Update an Input Security Group\'s Whilelists.', 'UpdateMultiplex' => 'Updates a multiplex.', 'UpdateMultiplexProgram' => 'Update a program in a multiplex.', 'UpdateReservation' => 'Update reservation.', ], 'shapes' => [ 'AacCodingMode' => [ 'base' => 'Aac Coding Mode', 'refs' => [ 'AacSettings$CodingMode' => 'Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. The adReceiverMix setting receives a stereo description plus control track and emits a mono AAC encode of the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.', ], ], 'AacInputType' => [ 'base' => 'Aac Input Type', 'refs' => [ 'AacSettings$InputType' => 'Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair. The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored when set to broadcasterMixedAd.Leave set to "normal" when input does not contain pre-mixed audio + AD.', ], ], 'AacProfile' => [ 'base' => 'Aac Profile', 'refs' => [ 'AacSettings$Profile' => 'AAC Profile.', ], ], 'AacRateControlMode' => [ 'base' => 'Aac Rate Control Mode', 'refs' => [ 'AacSettings$RateControlMode' => 'Rate Control Mode.', ], ], 'AacRawFormat' => [ 'base' => 'Aac Raw Format', 'refs' => [ 'AacSettings$RawFormat' => 'Sets LATM / LOAS AAC output for raw containers.', ], ], 'AacSettings' => [ 'base' => 'Aac Settings', 'refs' => [ 'AudioCodecSettings$AacSettings' => NULL, ], ], 'AacSpec' => [ 'base' => 'Aac Spec', 'refs' => [ 'AacSettings$Spec' => 'Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.', ], ], 'AacVbrQuality' => [ 'base' => 'Aac Vbr Quality', 'refs' => [ 'AacSettings$VbrQuality' => 'VBR Quality Level - Only used if rateControlMode is VBR.', ], ], 'Ac3BitstreamMode' => [ 'base' => 'Ac3 Bitstream Mode', 'refs' => [ 'Ac3Settings$BitstreamMode' => 'Specifies the bitstream mode (bsmod) for the emitted AC-3 stream. See ATSC A/52-2012 for background on these values.', ], ], 'Ac3CodingMode' => [ 'base' => 'Ac3 Coding Mode', 'refs' => [ 'Ac3Settings$CodingMode' => 'Dolby Digital coding mode. Determines number of channels.', ], ], 'Ac3DrcProfile' => [ 'base' => 'Ac3 Drc Profile', 'refs' => [ 'Ac3Settings$DrcProfile' => 'If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.', ], ], 'Ac3LfeFilter' => [ 'base' => 'Ac3 Lfe Filter', 'refs' => [ 'Ac3Settings$LfeFilter' => 'When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid in codingMode32Lfe mode.', ], ], 'Ac3MetadataControl' => [ 'base' => 'Ac3 Metadata Control', 'refs' => [ 'Ac3Settings$MetadataControl' => 'When set to "followInput", encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.', ], ], 'Ac3Settings' => [ 'base' => 'Ac3 Settings', 'refs' => [ 'AudioCodecSettings$Ac3Settings' => NULL, ], ], 'AccessDenied' => [ 'base' => NULL, 'refs' => [], ], 'AccessibilityType' => [ 'base' => 'Accessibility Type', 'refs' => [ 'CaptionDescription$Accessibility' => 'Indicates whether the caption track implements accessibility features such as written descriptions of spoken dialog, music, and sounds.', ], ], 'AfdSignaling' => [ 'base' => 'Afd Signaling', 'refs' => [ 'H264Settings$AfdSignaling' => 'Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.', 'H265Settings$AfdSignaling' => 'Indicates that AFD values will be written into the output stream. If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.', 'Mpeg2Settings$AfdSignaling' => 'Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose AUTO.AUTO: MediaLive will try to preserve the input AFD value (in cases where multiple AFD values are valid).FIXED: MediaLive will use the value you specify in fixedAFD.', ], ], 'AncillarySourceSettings' => [ 'base' => 'Ancillary Source Settings', 'refs' => [ 'CaptionSelectorSettings$AncillarySourceSettings' => NULL, ], ], 'ArchiveCdnSettings' => [ 'base' => 'Archive Cdn Settings', 'refs' => [ 'ArchiveGroupSettings$ArchiveCdnSettings' => 'Parameters that control interactions with the CDN.', ], ], 'ArchiveContainerSettings' => [ 'base' => 'Archive Container Settings', 'refs' => [ 'ArchiveOutputSettings$ContainerSettings' => 'Settings specific to the container type of the file.', ], ], 'ArchiveGroupSettings' => [ 'base' => 'Archive Group Settings', 'refs' => [ 'OutputGroupSettings$ArchiveGroupSettings' => NULL, ], ], 'ArchiveOutputSettings' => [ 'base' => 'Archive Output Settings', 'refs' => [ 'OutputSettings$ArchiveOutputSettings' => NULL, ], ], 'ArchiveS3LogUploads' => [ 'base' => 'Archive S3 Log Uploads', 'refs' => [ 'ArchiveS3Settings$LogUploads' => 'When set to enabled, each upload to CDN or server will be logged.', ], ], 'ArchiveS3Settings' => [ 'base' => 'Archive S3 Settings', 'refs' => [ 'ArchiveCdnSettings$ArchiveS3Settings' => NULL, ], ], 'AribDestinationSettings' => [ 'base' => 'Arib Destination Settings', 'refs' => [ 'CaptionDestinationSettings$AribDestinationSettings' => NULL, ], ], 'AribSourceSettings' => [ 'base' => 'Arib Source Settings', 'refs' => [ 'CaptionSelectorSettings$AribSourceSettings' => NULL, ], ], 'AudioChannelMapping' => [ 'base' => 'Audio Channel Mapping', 'refs' => [ '__listOfAudioChannelMapping$member' => NULL, ], ], 'AudioCodecSettings' => [ 'base' => 'Audio Codec Settings', 'refs' => [ 'AudioDescription$CodecSettings' => 'Audio codec settings.', ], ], 'AudioDescription' => [ 'base' => 'Audio Description', 'refs' => [ '__listOfAudioDescription$member' => NULL, ], ], 'AudioDescriptionAudioTypeControl' => [ 'base' => 'Audio Description Audio Type Control', 'refs' => [ 'AudioDescription$AudioTypeControl' => 'Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then that value is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is included in the output. useConfigured: The value in Audio Type is included in the output.Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.', ], ], 'AudioDescriptionLanguageCodeControl' => [ 'base' => 'Audio Description Language Code Control', 'refs' => [ 'AudioDescription$LanguageCodeControl' => 'Choosing followInput will cause the ISO 639 language code of the output to follow the ISO 639 language code of the input. The languageCode will be used when useConfigured is set, or when followInput is selected but there is no ISO 639 language code specified by the input.', ], ], 'AudioHlsRenditionSelection' => [ 'base' => 'Audio Hls Rendition Selection', 'refs' => [ 'AudioSelectorSettings$AudioHlsRenditionSelection' => NULL, ], ], 'AudioLanguageSelection' => [ 'base' => 'Audio Language Selection', 'refs' => [ 'AudioSelectorSettings$AudioLanguageSelection' => NULL, ], ], 'AudioLanguageSelectionPolicy' => [ 'base' => 'Audio Language Selection Policy', 'refs' => [ 'AudioLanguageSelection$LanguageSelectionPolicy' => 'When set to "strict", the transport stream demux strictly identifies audio streams by their language descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no longer present then mute will be encoded until the language returns. If "loose", then on a PMT update the demux will choose another audio stream in the program with the same stream type if it can\'t find one with the same language.', ], ], 'AudioNormalizationAlgorithm' => [ 'base' => 'Audio Normalization Algorithm', 'refs' => [ 'AudioNormalizationSettings$Algorithm' => 'Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification, itu17702 conforms to the EBU R-128 specification.', ], ], 'AudioNormalizationAlgorithmControl' => [ 'base' => 'Audio Normalization Algorithm Control', 'refs' => [ 'AudioNormalizationSettings$AlgorithmControl' => 'When set to correctAudio the output audio is corrected using the chosen algorithm. If set to measureOnly, the audio will be measured but not adjusted.', ], ], 'AudioNormalizationSettings' => [ 'base' => 'Audio Normalization Settings', 'refs' => [ 'AudioDescription$AudioNormalizationSettings' => 'Advanced audio normalization settings.', ], ], 'AudioOnlyHlsSegmentType' => [ 'base' => 'Audio Only Hls Segment Type', 'refs' => [ 'AudioOnlyHlsSettings$SegmentType' => 'Specifies the segment type.', ], ], 'AudioOnlyHlsSettings' => [ 'base' => 'Audio Only Hls Settings', 'refs' => [ 'HlsSettings$AudioOnlyHlsSettings' => NULL, ], ], 'AudioOnlyHlsTrackType' => [ 'base' => 'Audio Only Hls Track Type', 'refs' => [ 'AudioOnlyHlsSettings$AudioTrackType' => 'Four types of audio-only tracks are supported:Audio-Only Variant StreamThe client can play back this audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.Alternate Audio, Auto Select, DefaultAlternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YESAlternate Audio, Auto Select, Not DefaultAlternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YESAlternate Audio, not Auto SelectAlternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO', ], ], 'AudioPidSelection' => [ 'base' => 'Audio Pid Selection', 'refs' => [ 'AudioSelectorSettings$AudioPidSelection' => NULL, ], ], 'AudioSelector' => [ 'base' => 'Audio Selector', 'refs' => [ '__listOfAudioSelector$member' => NULL, ], ], 'AudioSelectorSettings' => [ 'base' => 'Audio Selector Settings', 'refs' => [ 'AudioSelector$SelectorSettings' => 'The audio selector settings.', ], ], 'AudioSilenceFailoverSettings' => [ 'base' => NULL, 'refs' => [ 'FailoverConditionSettings$AudioSilenceSettings' => 'MediaLive will perform a failover if the specified audio selector is silent for the specified period.', ], ], 'AudioTrack' => [ 'base' => 'Audio Track', 'refs' => [ '__listOfAudioTrack$member' => NULL, ], ], 'AudioTrackSelection' => [ 'base' => 'Audio Track Selection', 'refs' => [ 'AudioSelectorSettings$AudioTrackSelection' => NULL, ], ], 'AudioType' => [ 'base' => 'Audio Type', 'refs' => [ 'AudioDescription$AudioType' => 'Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.', ], ], 'AudioWatermarkSettings' => [ 'base' => 'Audio Watermark Settings', 'refs' => [ 'AudioDescription$AudioWatermarkingSettings' => 'Settings to configure one or more solutions that insert audio watermarks in the audio encode', ], ], 'AuthenticationScheme' => [ 'base' => 'Authentication Scheme', 'refs' => [ 'RtmpGroupSettings$AuthenticationScheme' => 'Authentication scheme to use when connecting with CDN', ], ], 'AutomaticInputFailoverSettings' => [ 'base' => 'The settings for Automatic Input Failover.', 'refs' => [ 'InputAttachment$AutomaticInputFailoverSettings' => 'User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over to a different input.', ], ], 'AvailBlanking' => [ 'base' => 'Avail Blanking', 'refs' => [ 'EncoderSettings$AvailBlanking' => 'Settings for ad avail blanking.', ], ], 'AvailBlankingState' => [ 'base' => 'Avail Blanking State', 'refs' => [ 'AvailBlanking$State' => 'When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.', ], ], 'AvailConfiguration' => [ 'base' => 'Avail Configuration', 'refs' => [ 'EncoderSettings$AvailConfiguration' => 'Event-wide configuration settings for ad avail insertion.', ], ], 'AvailSettings' => [ 'base' => 'Avail Settings', 'refs' => [ 'AvailConfiguration$AvailSettings' => 'Ad avail settings.', ], ], 'BadGatewayException' => [ 'base' => NULL, 'refs' => [], ], 'BadRequestException' => [ 'base' => NULL, 'refs' => [], ], 'BatchDelete' => [ 'base' => 'Batch delete resource request', 'refs' => [], ], 'BatchDeleteResultModel' => [ 'base' => 'Batch delete resource results', 'refs' => [], ], 'BatchFailedResultModel' => [ 'base' => 'Details from a failed operation', 'refs' => [ '__listOfBatchFailedResultModel$member' => NULL, ], ], 'BatchScheduleActionCreateRequest' => [ 'base' => 'A list of schedule actions to create (in a request) or that have been created (in a response).', 'refs' => [ 'BatchUpdateScheduleRequest$Creates' => 'Schedule actions to create in the schedule.', ], ], 'BatchScheduleActionCreateResult' => [ 'base' => 'List of actions that have been created in the schedule.', 'refs' => [ 'BatchUpdateScheduleResult$Creates' => 'Schedule actions created in the schedule.', ], ], 'BatchScheduleActionDeleteRequest' => [ 'base' => 'A list of schedule actions to delete.', 'refs' => [ 'BatchUpdateScheduleRequest$Deletes' => 'Schedule actions to delete from the schedule.', ], ], 'BatchScheduleActionDeleteResult' => [ 'base' => 'List of actions that have been deleted from the schedule.', 'refs' => [ 'BatchUpdateScheduleResult$Deletes' => 'Schedule actions deleted from the schedule.', ], ], 'BatchStart' => [ 'base' => 'Batch start resource request', 'refs' => [], ], 'BatchStartResultModel' => [ 'base' => 'Batch start resource results', 'refs' => [], ], 'BatchStop' => [ 'base' => 'Batch stop resource request', 'refs' => [], ], 'BatchStopResultModel' => [ 'base' => 'Batch stop resource results', 'refs' => [], ], 'BatchSuccessfulResultModel' => [ 'base' => 'Details from a successful operation', 'refs' => [ '__listOfBatchSuccessfulResultModel$member' => NULL, ], ], 'BatchUpdateScheduleRequest' => [ 'base' => 'A request to create actions (add actions to the schedule), delete actions (remove actions from the schedule), or both create and delete actions.', 'refs' => [], ], 'BatchUpdateScheduleResult' => [ 'base' => 'Results of a batch schedule update.', 'refs' => [], ], 'BlackoutSlate' => [ 'base' => 'Blackout Slate', 'refs' => [ 'EncoderSettings$BlackoutSlate' => 'Settings for blackout slate.', ], ], 'BlackoutSlateNetworkEndBlackout' => [ 'base' => 'Blackout Slate Network End Blackout', 'refs' => [ 'BlackoutSlate$NetworkEndBlackout' => 'Setting to enabled causes the encoder to blackout the video, audio, and captions, and raise the "Network Blackout Image" slate when an SCTE104/35 Network End Segmentation Descriptor is encountered. The blackout will be lifted when the Network Start Segmentation Descriptor is encountered. The Network End and Network Start descriptors must contain a network ID that matches the value entered in "Network ID".', ], ], 'BlackoutSlateState' => [ 'base' => 'Blackout Slate State', 'refs' => [ 'BlackoutSlate$State' => 'When set to enabled, causes video, audio and captions to be blanked when indicated by program metadata.', ], ], 'BurnInAlignment' => [ 'base' => 'Burn In Alignment', 'refs' => [ 'BurnInDestinationSettings$Alignment' => 'If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. Selecting "smart" justification will left-justify live subtitles and center-justify pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.', ], ], 'BurnInBackgroundColor' => [ 'base' => 'Burn In Background Color', 'refs' => [ 'BurnInDestinationSettings$BackgroundColor' => 'Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.', ], ], 'BurnInDestinationSettings' => [ 'base' => 'Burn In Destination Settings', 'refs' => [ 'CaptionDestinationSettings$BurnInDestinationSettings' => NULL, ], ], 'BurnInFontColor' => [ 'base' => 'Burn In Font Color', 'refs' => [ 'BurnInDestinationSettings$FontColor' => 'Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'BurnInOutlineColor' => [ 'base' => 'Burn In Outline Color', 'refs' => [ 'BurnInDestinationSettings$OutlineColor' => 'Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'BurnInShadowColor' => [ 'base' => 'Burn In Shadow Color', 'refs' => [ 'BurnInDestinationSettings$ShadowColor' => 'Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.', ], ], 'BurnInTeletextGridControl' => [ 'base' => 'Burn In Teletext Grid Control', 'refs' => [ 'BurnInDestinationSettings$TeletextGridControl' => 'Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.', ], ], 'CaptionDescription' => [ 'base' => 'Caption Description', 'refs' => [ '__listOfCaptionDescription$member' => NULL, ], ], 'CaptionDestinationSettings' => [ 'base' => 'Caption Destination Settings', 'refs' => [ 'CaptionDescription$DestinationSettings' => 'Additional settings for captions destination that depend on the destination type.', ], ], 'CaptionLanguageMapping' => [ 'base' => 'Maps a caption channel to an ISO 693-2 language code (http://www.loc.gov/standards/iso639-2), with an optional description.', 'refs' => [ '__listOfCaptionLanguageMapping$member' => NULL, ], ], 'CaptionRectangle' => [ 'base' => 'Caption Rectangle', 'refs' => [ 'TeletextSourceSettings$OutputRectangle' => 'Optionally defines a region where TTML style captions will be displayed', ], ], 'CaptionSelector' => [ 'base' => 'Output groups for this Live Event. Output groups contain information about where streams should be distributed.', 'refs' => [ '__listOfCaptionSelector$member' => NULL, ], ], 'CaptionSelectorSettings' => [ 'base' => 'Caption Selector Settings', 'refs' => [ 'CaptionSelector$SelectorSettings' => 'Caption selector settings.', ], ], 'CdiInputResolution' => [ 'base' => 'Maximum CDI input resolution; SD is 480i and 576i up to 30 frames-per-second (fps), HD is 720p up to 60 fps / 1080i up to 30 fps, FHD is 1080p up to 60 fps, UHD is 2160p up to 60 fps', 'refs' => [ 'CdiInputSpecification$Resolution' => 'Maximum CDI input resolution', ], ], 'CdiInputSpecification' => [ 'base' => NULL, 'refs' => [ 'Channel$CdiInputSpecification' => 'Specification of CDI inputs for this channel', 'ChannelSummary$CdiInputSpecification' => 'Specification of CDI inputs for this channel', 'CreateChannel$CdiInputSpecification' => 'Specification of CDI inputs for this channel', 'UpdateChannel$CdiInputSpecification' => 'Specification of CDI inputs for this channel', ], ], 'Channel' => [ 'base' => NULL, 'refs' => [ 'CreateChannelResultModel$Channel' => NULL, 'UpdateChannelResultModel$Channel' => NULL, ], ], 'ChannelClass' => [ 'base' => 'A standard channel has two encoding pipelines and a single pipeline channel only has one.', 'refs' => [ 'Channel$ChannelClass' => 'The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.', 'ChannelSummary$ChannelClass' => 'The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.', 'CreateChannel$ChannelClass' => 'The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.', 'ReservationResourceSpecification$ChannelClass' => 'Channel class, e.g. \'STANDARD\'', 'UpdateChannelClass$ChannelClass' => 'The channel class that you wish to update this channel to use.', ], ], 'ChannelConfigurationValidationError' => [ 'base' => NULL, 'refs' => [], ], 'ChannelEgressEndpoint' => [ 'base' => NULL, 'refs' => [ '__listOfChannelEgressEndpoint$member' => NULL, ], ], 'ChannelState' => [ 'base' => NULL, 'refs' => [ 'Channel$State' => NULL, 'ChannelSummary$State' => NULL, ], ], 'ChannelSummary' => [ 'base' => NULL, 'refs' => [ '__listOfChannelSummary$member' => NULL, ], ], 'ClaimDeviceRequest' => [ 'base' => 'Request to claim an AWS Elemental device that you have purchased from a third-party vendor.', 'refs' => [], ], 'ColorSpacePassthroughSettings' => [ 'base' => 'Passthrough applies no color space conversion to the output', 'refs' => [ 'H264ColorSpaceSettings$ColorSpacePassthroughSettings' => NULL, 'H265ColorSpaceSettings$ColorSpacePassthroughSettings' => NULL, ], ], 'ConflictException' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannel' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResultModel' => [ 'base' => NULL, 'refs' => [], ], 'CreateInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateInputResultModel' => [ 'base' => NULL, 'refs' => [], ], 'CreateInputSecurityGroupResultModel' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultiplex' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultiplexProgram' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultiplexProgramResultModel' => [ 'base' => NULL, 'refs' => [], ], 'CreateMultiplexResultModel' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartnerInput' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartnerInputResultModel' => [ 'base' => NULL, 'refs' => [], ], 'DeviceSettingsSyncState' => [ 'base' => 'The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.', 'refs' => [ 'InputDevice$DeviceSettingsSyncState' => 'The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.', 'InputDeviceSummary$DeviceSettingsSyncState' => 'The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.', ], ], 'DeviceUpdateStatus' => [ 'base' => 'The status of software on the input device.', 'refs' => [ 'InputDevice$DeviceUpdateStatus' => 'The status of software on the input device.', 'InputDeviceSummary$DeviceUpdateStatus' => 'The status of software on the input device.', ], ], 'DvbNitSettings' => [ 'base' => 'DVB Network Information Table (NIT)', 'refs' => [ 'M2tsSettings$DvbNitSettings' => 'Inserts DVB Network Information Table (NIT) at the specified table repetition interval.', ], ], 'DvbSdtOutputSdt' => [ 'base' => 'Dvb Sdt Output Sdt', 'refs' => [ 'DvbSdtSettings$OutputSdt' => 'Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. The sdtManual setting means user will enter the SDT information. The sdtNone setting means output stream will not contain SDT information.', ], ], 'DvbSdtSettings' => [ 'base' => 'DVB Service Description Table (SDT)', 'refs' => [ 'M2tsSettings$DvbSdtSettings' => 'Inserts DVB Service Description Table (SDT) at the specified table repetition interval.', ], ], 'DvbSubDestinationAlignment' => [ 'base' => 'Dvb Sub Destination Alignment', 'refs' => [ 'DvbSubDestinationSettings$Alignment' => 'If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. Selecting "smart" justification will left-justify live subtitles and center-justify pre-recorded subtitles. This option is not valid for source captions that are STL or 608/embedded. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubDestinationBackgroundColor' => [ 'base' => 'Dvb Sub Destination Background Color', 'refs' => [ 'DvbSubDestinationSettings$BackgroundColor' => 'Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubDestinationFontColor' => [ 'base' => 'Dvb Sub Destination Font Color', 'refs' => [ 'DvbSubDestinationSettings$FontColor' => 'Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubDestinationOutlineColor' => [ 'base' => 'Dvb Sub Destination Outline Color', 'refs' => [ 'DvbSubDestinationSettings$OutlineColor' => 'Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubDestinationSettings' => [ 'base' => 'Dvb Sub Destination Settings', 'refs' => [ 'CaptionDestinationSettings$DvbSubDestinationSettings' => NULL, ], ], 'DvbSubDestinationShadowColor' => [ 'base' => 'Dvb Sub Destination Shadow Color', 'refs' => [ 'DvbSubDestinationSettings$ShadowColor' => 'Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.', ], ], 'DvbSubDestinationTeletextGridControl' => [ 'base' => 'Dvb Sub Destination Teletext Grid Control', 'refs' => [ 'DvbSubDestinationSettings$TeletextGridControl' => 'Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.', ], ], 'DvbSubOcrLanguage' => [ 'base' => 'Dvb Sub Ocr Language', 'refs' => [ 'DvbSubSourceSettings$OcrLanguage' => 'If you will configure a WebVTT caption description that references this caption selector, use this field toprovide the language to consider when translating the image-based source to text.', ], ], 'DvbSubSourceSettings' => [ 'base' => 'Dvb Sub Source Settings', 'refs' => [ 'CaptionSelectorSettings$DvbSubSourceSettings' => NULL, ], ], 'DvbTdtSettings' => [ 'base' => 'DVB Time and Date Table (SDT)', 'refs' => [ 'M2tsSettings$DvbTdtSettings' => 'Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.', ], ], 'Eac3AttenuationControl' => [ 'base' => 'Eac3 Attenuation Control', 'refs' => [ 'Eac3Settings$AttenuationControl' => 'When set to attenuate3Db, applies a 3 dB attenuation to the surround channels. Only used for 3/2 coding mode.', ], ], 'Eac3BitstreamMode' => [ 'base' => 'Eac3 Bitstream Mode', 'refs' => [ 'Eac3Settings$BitstreamMode' => 'Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC A/52-2012 (Annex E) for background on these values.', ], ], 'Eac3CodingMode' => [ 'base' => 'Eac3 Coding Mode', 'refs' => [ 'Eac3Settings$CodingMode' => 'Dolby Digital Plus coding mode. Determines number of channels.', ], ], 'Eac3DcFilter' => [ 'base' => 'Eac3 Dc Filter', 'refs' => [ 'Eac3Settings$DcFilter' => 'When set to enabled, activates a DC highpass filter for all input channels.', ], ], 'Eac3DrcLine' => [ 'base' => 'Eac3 Drc Line', 'refs' => [ 'Eac3Settings$DrcLine' => 'Sets the Dolby dynamic range compression profile.', ], ], 'Eac3DrcRf' => [ 'base' => 'Eac3 Drc Rf', 'refs' => [ 'Eac3Settings$DrcRf' => 'Sets the profile for heavy Dolby dynamic range compression, ensures that the instantaneous signal peaks do not exceed specified levels.', ], ], 'Eac3LfeControl' => [ 'base' => 'Eac3 Lfe Control', 'refs' => [ 'Eac3Settings$LfeControl' => 'When encoding 3/2 audio, setting to lfe enables the LFE channel', ], ], 'Eac3LfeFilter' => [ 'base' => 'Eac3 Lfe Filter', 'refs' => [ 'Eac3Settings$LfeFilter' => 'When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding. Only valid with codingMode32 coding mode.', ], ], 'Eac3MetadataControl' => [ 'base' => 'Eac3 Metadata Control', 'refs' => [ 'Eac3Settings$MetadataControl' => 'When set to followInput, encoder metadata will be sourced from the DD, DD+, or DolbyE decoder that supplied this audio data. If audio was not supplied from one of these streams, then the static metadata settings will be used.', ], ], 'Eac3PassthroughControl' => [ 'base' => 'Eac3 Passthrough Control', 'refs' => [ 'Eac3Settings$PassthroughControl' => 'When set to whenPossible, input DD+ audio will be passed through if it is present on the input. This detection is dynamic over the life of the transcode. Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+ output as the system alternates between passthrough and encoding.', ], ], 'Eac3PhaseControl' => [ 'base' => 'Eac3 Phase Control', 'refs' => [ 'Eac3Settings$PhaseControl' => 'When set to shift90Degrees, applies a 90-degree phase shift to the surround channels. Only used for 3/2 coding mode.', ], ], 'Eac3Settings' => [ 'base' => 'Eac3 Settings', 'refs' => [ 'AudioCodecSettings$Eac3Settings' => NULL, ], ], 'Eac3StereoDownmix' => [ 'base' => 'Eac3 Stereo Downmix', 'refs' => [ 'Eac3Settings$StereoDownmix' => 'Stereo downmix preference. Only used for 3/2 coding mode.', ], ], 'Eac3SurroundExMode' => [ 'base' => 'Eac3 Surround Ex Mode', 'refs' => [ 'Eac3Settings$SurroundExMode' => 'When encoding 3/2 audio, sets whether an extra center back surround channel is matrix encoded into the left and right surround channels.', ], ], 'Eac3SurroundMode' => [ 'base' => 'Eac3 Surround Mode', 'refs' => [ 'Eac3Settings$SurroundMode' => 'When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the two channels.', ], ], 'EbuTtDDestinationSettings' => [ 'base' => 'Ebu Tt DDestination Settings', 'refs' => [ 'CaptionDestinationSettings$EbuTtDDestinationSettings' => NULL, ], ], 'EbuTtDDestinationStyleControl' => [ 'base' => 'Ebu Tt DDestination Style Control', 'refs' => [ 'EbuTtDDestinationSettings$StyleControl' => 'Specifies the style information (font color, font position, and so on) to include in the font data that is attached to the EBU-TT captions.- include: Take the style information (font color, font position, and so on) from the source captions and include that information in the font data attached to the EBU-TT captions. This option is valid only if the source captions are Embedded or Teletext.- exclude: In the font data attached to the EBU-TT captions, set the font family to "monospaced". Do not include any other style information.', ], ], 'EbuTtDFillLineGapControl' => [ 'base' => 'Ebu Tt DFill Line Gap Control', 'refs' => [ 'EbuTtDDestinationSettings$FillLineGap' => 'Specifies how to handle the gap between the lines (in multi-line captions).- enabled: Fill with the captions background color (as specified in the input captions).- disabled: Leave the gap unfilled.', ], ], 'EmbeddedConvert608To708' => [ 'base' => 'Embedded Convert608 To708', 'refs' => [ 'EmbeddedSourceSettings$Convert608To708' => 'If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.', ], ], 'EmbeddedDestinationSettings' => [ 'base' => 'Embedded Destination Settings', 'refs' => [ 'CaptionDestinationSettings$EmbeddedDestinationSettings' => NULL, ], ], 'EmbeddedPlusScte20DestinationSettings' => [ 'base' => 'Embedded Plus Scte20 Destination Settings', 'refs' => [ 'CaptionDestinationSettings$EmbeddedPlusScte20DestinationSettings' => NULL, ], ], 'EmbeddedScte20Detection' => [ 'base' => 'Embedded Scte20 Detection', 'refs' => [ 'EmbeddedSourceSettings$Scte20Detection' => 'Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.', ], ], 'EmbeddedSourceSettings' => [ 'base' => 'Embedded Source Settings', 'refs' => [ 'CaptionSelectorSettings$EmbeddedSourceSettings' => NULL, ], ], 'Empty' => [ 'base' => NULL, 'refs' => [], ], 'EncoderSettings' => [ 'base' => 'Encoder Settings', 'refs' => [ 'Channel$EncoderSettings' => NULL, 'CreateChannel$EncoderSettings' => NULL, 'UpdateChannel$EncoderSettings' => 'The encoder settings for this channel.', ], ], 'FailoverCondition' => [ 'base' => 'Failover Condition settings. There can be multiple failover conditions inside AutomaticInputFailoverSettings.', 'refs' => [ '__listOfFailoverCondition$member' => NULL, ], ], 'FailoverConditionSettings' => [ 'base' => 'Settings for one failover condition.', 'refs' => [ 'FailoverCondition$FailoverConditionSettings' => 'Failover condition type-specific settings.', ], ], 'FeatureActivations' => [ 'base' => 'Feature Activations', 'refs' => [ 'EncoderSettings$FeatureActivations' => 'Feature Activations', ], ], 'FeatureActivationsInputPrepareScheduleActions' => [ 'base' => 'Feature Activations Input Prepare Schedule Actions', 'refs' => [ 'FeatureActivations$InputPrepareScheduleActions' => 'Enables the Input Prepare feature. You can create Input Prepare actions in the schedule only if this feature is enabled.If you disable the feature on an existing schedule, make sure that you first delete all input prepare actions from the schedule.', ], ], 'FecOutputIncludeFec' => [ 'base' => 'Fec Output Include Fec', 'refs' => [ 'FecOutputSettings$IncludeFec' => 'Enables column only or column and row based FEC', ], ], 'FecOutputSettings' => [ 'base' => 'Fec Output Settings', 'refs' => [ 'UdpOutputSettings$FecOutputSettings' => 'Settings for enabling and adjusting Forward Error Correction on UDP outputs.', ], ], 'FixedAfd' => [ 'base' => 'Fixed Afd', 'refs' => [ 'H264Settings$FixedAfd' => 'Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to \'Fixed\'.', 'H265Settings$FixedAfd' => 'Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to \'Fixed\'.', 'Mpeg2Settings$FixedAfd' => 'Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all frames of the video encode.', ], ], 'FixedModeScheduleActionStartSettings' => [ 'base' => 'Start time for the action.', 'refs' => [ 'ScheduleActionStartSettings$FixedModeScheduleActionStartSettings' => 'Option for specifying the start time for an action.', ], ], 'Fmp4HlsSettings' => [ 'base' => 'Fmp4 Hls Settings', 'refs' => [ 'HlsSettings$Fmp4HlsSettings' => NULL, ], ], 'Fmp4NielsenId3Behavior' => [ 'base' => 'Fmp4 Nielsen Id3 Behavior', 'refs' => [ 'Fmp4HlsSettings$NielsenId3Behavior' => 'If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.', ], ], 'Fmp4TimedMetadataBehavior' => [ 'base' => 'Fmp4 Timed Metadata Behavior', 'refs' => [ 'Fmp4HlsSettings$TimedMetadataBehavior' => 'When set to passthrough, timed metadata is passed through from input to output.', ], ], 'FollowModeScheduleActionStartSettings' => [ 'base' => 'Settings to specify if an action follows another.', 'refs' => [ 'ScheduleActionStartSettings$FollowModeScheduleActionStartSettings' => 'Option for specifying an action as relative to another action.', ], ], 'FollowPoint' => [ 'base' => 'Follow reference point.', 'refs' => [ 'FollowModeScheduleActionStartSettings$FollowPoint' => 'Identifies whether this action starts relative to the start or relative to the end of the reference action.', ], ], 'ForbiddenException' => [ 'base' => NULL, 'refs' => [], ], 'FrameCaptureCdnSettings' => [ 'base' => 'Frame Capture Cdn Settings', 'refs' => [ 'FrameCaptureGroupSettings$FrameCaptureCdnSettings' => 'Parameters that control interactions with the CDN.', ], ], 'FrameCaptureGroupSettings' => [ 'base' => 'Frame Capture Group Settings', 'refs' => [ 'OutputGroupSettings$FrameCaptureGroupSettings' => NULL, ], ], 'FrameCaptureHlsSettings' => [ 'base' => 'Frame Capture Hls Settings', 'refs' => [ 'HlsSettings$FrameCaptureHlsSettings' => NULL, ], ], 'FrameCaptureIntervalUnit' => [ 'base' => 'Frame Capture Interval Unit', 'refs' => [ 'FrameCaptureSettings$CaptureIntervalUnits' => 'Unit for the frame capture interval.', ], ], 'FrameCaptureOutputSettings' => [ 'base' => 'Frame Capture Output Settings', 'refs' => [ 'OutputSettings$FrameCaptureOutputSettings' => NULL, ], ], 'FrameCaptureS3LogUploads' => [ 'base' => 'Frame Capture S3 Log Uploads', 'refs' => [ 'FrameCaptureS3Settings$LogUploads' => 'When set to enabled, each upload to CDN or server will be logged.', ], ], 'FrameCaptureS3Settings' => [ 'base' => 'Frame Capture S3 Settings', 'refs' => [ 'FrameCaptureCdnSettings$FrameCaptureS3Settings' => NULL, ], ], 'FrameCaptureSettings' => [ 'base' => 'Frame Capture Settings', 'refs' => [ 'VideoCodecSettings$FrameCaptureSettings' => NULL, ], ], 'GatewayTimeoutException' => [ 'base' => NULL, 'refs' => [], ], 'GlobalConfiguration' => [ 'base' => 'Global Configuration', 'refs' => [ 'EncoderSettings$GlobalConfiguration' => 'Configuration settings that apply to the event as a whole.', ], ], 'GlobalConfigurationInputEndAction' => [ 'base' => 'Global Configuration Input End Action', 'refs' => [ 'GlobalConfiguration$InputEndAction' => 'Indicates the action to take when the current input completes (e.g. end-of-file). When switchAndLoopInputs is configured the encoder will restart at the beginning of the first input. When "none" is configured the encoder will transcode either black, a solid color, or a user specified slate images per the "Input Loss Behavior" configuration until the next input switch occurs (which is controlled through the Channel Schedule API).', ], ], 'GlobalConfigurationLowFramerateInputs' => [ 'base' => 'Global Configuration Low Framerate Inputs', 'refs' => [ 'GlobalConfiguration$SupportLowFramerateInputs' => 'Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled for music channels with less than one video frame per second.', ], ], 'GlobalConfigurationOutputLockingMode' => [ 'base' => 'Global Configuration Output Locking Mode', 'refs' => [ 'GlobalConfiguration$OutputLockingMode' => 'Indicates how MediaLive pipelines are synchronized.PIPELINE_LOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other.EPOCH_LOCKING - MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.', ], ], 'GlobalConfigurationOutputTimingSource' => [ 'base' => 'Global Configuration Output Timing Source', 'refs' => [ 'GlobalConfiguration$OutputTimingSource' => 'Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which optionally may be locked to another source via NTP) or should be locked to the clock of the source that is providing the input stream.', ], ], 'H264AdaptiveQuantization' => [ 'base' => 'H264 Adaptive Quantization', 'refs' => [ 'H264Settings$AdaptiveQuantization' => 'Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a frame-by-frame basis to produce more compression without losing quality. There are three types of adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a strength (a value other than Auto or Disable). This strength will apply to any of the AQ fields that you choose to enable. Set to Disabled to disable all types of adaptive quantization.', ], ], 'H264ColorMetadata' => [ 'base' => 'H264 Color Metadata', 'refs' => [ 'H264Settings$ColorMetadata' => 'Includes colorspace metadata in the output.', ], ], 'H264ColorSpaceSettings' => [ 'base' => 'H264 Color Space Settings', 'refs' => [ 'H264Settings$ColorSpaceSettings' => 'Color Space settings', ], ], 'H264EntropyEncoding' => [ 'base' => 'H264 Entropy Encoding', 'refs' => [ 'H264Settings$EntropyEncoding' => 'Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.', ], ], 'H264FilterSettings' => [ 'base' => 'H264 Filter Settings', 'refs' => [ 'H264Settings$FilterSettings' => 'Optional filters that you can apply to an encode.', ], ], 'H264FlickerAq' => [ 'base' => 'H264 Flicker Aq', 'refs' => [ 'H264Settings$FlickerAq' => 'Flicker AQ makes adjustments within each frame to reduce flicker or \'pop\' on I-frames. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the specified strength. Disabled: MediaLive won\'t apply flicker AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn\'t apply flicker AQ.', ], ], 'H264ForceFieldPictures' => [ 'base' => 'H264 Force Field Pictures', 'refs' => [ 'H264Settings$ForceFieldPictures' => 'This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.)enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately.disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.', ], ], 'H264FramerateControl' => [ 'base' => 'H264 Framerate Control', 'refs' => [ 'H264Settings$FramerateControl' => 'This field indicates how the output video frame rate is specified. If "specified" is selected then the output video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource" is selected then the output video frame rate will be set equal to the input video frame rate of the first input.', ], ], 'H264GopBReference' => [ 'base' => 'H264 Gop BReference', 'refs' => [ 'H264Settings$GopBReference' => 'If enabled, use reference B frames for GOP structures that have B frames > 1.', ], ], 'H264GopSizeUnits' => [ 'base' => 'H264 Gop Size Units', 'refs' => [ 'H264Settings$GopSizeUnits' => 'Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.', ], ], 'H264Level' => [ 'base' => 'H264 Level', 'refs' => [ 'H264Settings$Level' => 'H.264 Level.', ], ], 'H264LookAheadRateControl' => [ 'base' => 'H264 Look Ahead Rate Control', 'refs' => [ 'H264Settings$LookAheadRateControl' => 'Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.', ], ], 'H264ParControl' => [ 'base' => 'H264 Par Control', 'refs' => [ 'H264Settings$ParControl' => 'This field indicates how the output pixel aspect ratio is specified. If "specified" is selected then the output video pixel aspect ratio is determined by parNumerator and parDenominator, else if "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input video pixel aspect ratio of the first input.', ], ], 'H264Profile' => [ 'base' => 'H264 Profile', 'refs' => [ 'H264Settings$Profile' => 'H.264 Profile.', ], ], 'H264QualityLevel' => [ 'base' => 'H264 Quality Level', 'refs' => [ 'H264Settings$QualityLevel' => 'Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the channel).- ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value must be ENHANCED_QUALITY.- STANDARD_QUALITY: Valid for any Rate control mode.', ], ], 'H264RateControlMode' => [ 'base' => 'H264 Rate Control Mode', 'refs' => [ 'H264Settings$RateControlMode' => 'Rate control mode.QVBR: Quality will match the specified quality level except when it is constrained by themaximum bitrate. Recommended if you or your viewers pay for bandwidth.VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBRif you want to maintain a specific average bitrate over the duration of the channel.CBR: Quality varies, depending on the video complexity. Recommended only if you distributeyour assets to devices that cannot handle variable bitrates.Multiplex: This rate control mode is only supported (and is required) when the video is beingdelivered to a MediaLive Multiplex in which case the rate control configuration is controlledby the properties within the Multiplex Program.', ], ], 'H264ScanType' => [ 'base' => 'H264 Scan Type', 'refs' => [ 'H264Settings$ScanType' => 'Sets the scan type of the output to progressive or top-field-first interlaced.', ], ], 'H264SceneChangeDetect' => [ 'base' => 'H264 Scene Change Detect', 'refs' => [ 'H264Settings$SceneChangeDetect' => 'Scene change detection.- On: inserts I-frames when scene change is detected.- Off: does not force an I-frame when scene change is detected.', ], ], 'H264Settings' => [ 'base' => 'H264 Settings', 'refs' => [ 'VideoCodecSettings$H264Settings' => NULL, ], ], 'H264SpatialAq' => [ 'base' => 'H264 Spatial Aq', 'refs' => [ 'H264Settings$SpatialAq' => 'Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the specified strength. Disabled: MediaLive won\'t apply spatial AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn\'t apply spatial AQ.', ], ], 'H264SubGopLength' => [ 'base' => 'H264 Sub Gop Length', 'refs' => [ 'H264Settings$SubgopLength' => 'If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames used for each sub-GOP to improve visual quality.', ], ], 'H264Syntax' => [ 'base' => 'H264 Syntax', 'refs' => [ 'H264Settings$Syntax' => 'Produces a bitstream compliant with SMPTE RP-2027.', ], ], 'H264TemporalAq' => [ 'base' => 'H264 Temporal Aq', 'refs' => [ 'H264Settings$TemporalAq' => 'Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using the specified strength. Disabled: MediaLive won\'t apply temporal AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn\'t apply temporal AQ.', ], ], 'H264TimecodeInsertionBehavior' => [ 'base' => 'H264 Timecode Insertion Behavior', 'refs' => [ 'H264Settings$TimecodeInsertion' => 'Determines how timecodes should be inserted into the video elementary stream.- \'disabled\': Do not include timecodes- \'picTimingSei\': Pass through picture timing SEI messages from the source specified in Timecode Config', ], ], 'H265AdaptiveQuantization' => [ 'base' => 'H265 Adaptive Quantization', 'refs' => [ 'H265Settings$AdaptiveQuantization' => 'Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.', ], ], 'H265AlternativeTransferFunction' => [ 'base' => 'H265 Alternative Transfer Function', 'refs' => [ 'H265Settings$AlternativeTransferFunction' => 'Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards compatibility with non-HDR decoders and displays.', ], ], 'H265ColorMetadata' => [ 'base' => 'H265 Color Metadata', 'refs' => [ 'H265Settings$ColorMetadata' => 'Includes colorspace metadata in the output.', ], ], 'H265ColorSpaceSettings' => [ 'base' => 'H265 Color Space Settings', 'refs' => [ 'H265Settings$ColorSpaceSettings' => 'Color Space settings', ], ], 'H265FilterSettings' => [ 'base' => 'H265 Filter Settings', 'refs' => [ 'H265Settings$FilterSettings' => 'Optional filters that you can apply to an encode.', ], ], 'H265FlickerAq' => [ 'base' => 'H265 Flicker Aq', 'refs' => [ 'H265Settings$FlickerAq' => 'If set to enabled, adjust quantization within each frame to reduce flicker or \'pop\' on I-frames.', ], ], 'H265GopSizeUnits' => [ 'base' => 'H265 Gop Size Units', 'refs' => [ 'H265Settings$GopSizeUnits' => 'Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.', ], ], 'H265Level' => [ 'base' => 'H265 Level', 'refs' => [ 'H265Settings$Level' => 'H.265 Level.', ], ], 'H265LookAheadRateControl' => [ 'base' => 'H265 Look Ahead Rate Control', 'refs' => [ 'H265Settings$LookAheadRateControl' => 'Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.', ], ], 'H265Profile' => [ 'base' => 'H265 Profile', 'refs' => [ 'H265Settings$Profile' => 'H.265 Profile.', ], ], 'H265RateControlMode' => [ 'base' => 'H265 Rate Control Mode', 'refs' => [ 'H265Settings$RateControlMode' => 'Rate control mode.QVBR: Quality will match the specified quality level except when it is constrained by themaximum bitrate. Recommended if you or your viewers pay for bandwidth.CBR: Quality varies, depending on the video complexity. Recommended only if you distributeyour assets to devices that cannot handle variable bitrates.Multiplex: This rate control mode is only supported (and is required) when the video is beingdelivered to a MediaLive Multiplex in which case the rate control configuration is controlledby the properties within the Multiplex Program.', ], ], 'H265ScanType' => [ 'base' => 'H265 Scan Type', 'refs' => [ 'H265Settings$ScanType' => 'Sets the scan type of the output to progressive or top-field-first interlaced.', ], ], 'H265SceneChangeDetect' => [ 'base' => 'H265 Scene Change Detect', 'refs' => [ 'H265Settings$SceneChangeDetect' => 'Scene change detection.', ], ], 'H265Settings' => [ 'base' => 'H265 Settings', 'refs' => [ 'VideoCodecSettings$H265Settings' => NULL, ], ], 'H265Tier' => [ 'base' => 'H265 Tier', 'refs' => [ 'H265Settings$Tier' => 'H.265 Tier.', ], ], 'H265TimecodeInsertionBehavior' => [ 'base' => 'H265 Timecode Insertion Behavior', 'refs' => [ 'H265Settings$TimecodeInsertion' => 'Determines how timecodes should be inserted into the video elementary stream.- \'disabled\': Do not include timecodes- \'picTimingSei\': Pass through picture timing SEI messages from the source specified in Timecode Config', ], ], 'Hdr10Settings' => [ 'base' => 'Hdr10 Settings', 'refs' => [ 'H265ColorSpaceSettings$Hdr10Settings' => NULL, 'VideoSelectorColorSpaceSettings$Hdr10Settings' => NULL, ], ], 'HlsAdMarkers' => [ 'base' => 'Hls Ad Markers', 'refs' => [ '__listOfHlsAdMarkers$member' => NULL, ], ], 'HlsAkamaiHttpTransferMode' => [ 'base' => 'Hls Akamai Http Transfer Mode', 'refs' => [ 'HlsAkamaiSettings$HttpTransferMode' => 'Specify whether or not to use chunked transfer encoding to Akamai. User should contact Akamai to enable this feature.', ], ], 'HlsAkamaiSettings' => [ 'base' => 'Hls Akamai Settings', 'refs' => [ 'HlsCdnSettings$HlsAkamaiSettings' => NULL, ], ], 'HlsBasicPutSettings' => [ 'base' => 'Hls Basic Put Settings', 'refs' => [ 'HlsCdnSettings$HlsBasicPutSettings' => NULL, ], ], 'HlsCaptionLanguageSetting' => [ 'base' => 'Hls Caption Language Setting', 'refs' => [ 'HlsGroupSettings$CaptionLanguageSetting' => 'Applies only to 608 Embedded output captions.insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you specify. Make sure to specify the languages in the order in which they appear in the original source (if the source is embedded format) or the order of the caption selectors (if the source is other than embedded). Otherwise, languages in the manifest will not match up properly with the output captions.none: Include CLOSED-CAPTIONS=NONE line in the manifest.omit: Omit any CLOSED-CAPTIONS line from the manifest.', ], ], 'HlsCdnSettings' => [ 'base' => 'Hls Cdn Settings', 'refs' => [ 'HlsGroupSettings$HlsCdnSettings' => 'Parameters that control interactions with the CDN.', ], ], 'HlsClientCache' => [ 'base' => 'Hls Client Cache', 'refs' => [ 'HlsGroupSettings$ClientCache' => 'When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest, which prevents clients from saving media segments for later replay.', ], ], 'HlsCodecSpecification' => [ 'base' => 'Hls Codec Specification', 'refs' => [ 'HlsGroupSettings$CodecSpecification' => 'Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.', ], ], 'HlsDirectoryStructure' => [ 'base' => 'Hls Directory Structure', 'refs' => [ 'HlsGroupSettings$DirectoryStructure' => 'Place segments in subdirectories.', ], ], 'HlsDiscontinuityTags' => [ 'base' => 'Hls Discontinuity Tags', 'refs' => [ 'HlsGroupSettings$DiscontinuityTags' => 'Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests for this output group.Typically, choose Insert because these tags are required in the manifest (according to the HLS specification) and serve an important purpose.Choose Never Insert only if the downstream system is doing real-time failover (without using the MediaLive automatic failover feature) and only if that downstream system has advised you to exclude the tags.', ], ], 'HlsEncryptionType' => [ 'base' => 'Hls Encryption Type', 'refs' => [ 'HlsGroupSettings$EncryptionType' => 'Encrypts the segments with the given encryption scheme. Exclude this parameter if no encryption is desired.', ], ], 'HlsGroupSettings' => [ 'base' => 'Hls Group Settings', 'refs' => [ 'OutputGroupSettings$HlsGroupSettings' => NULL, ], ], 'HlsH265PackagingType' => [ 'base' => 'Hls H265 Packaging Type', 'refs' => [ 'HlsOutputSettings$H265PackagingType' => 'Only applicable when this output is referencing an H.265 video description.Specifies whether MP4 segments should be packaged as HEV1 or HVC1.', ], ], 'HlsId3SegmentTaggingScheduleActionSettings' => [ 'base' => 'Settings for the action to insert a user-defined ID3 tag in each HLS segment', 'refs' => [ 'ScheduleActionSettings$HlsId3SegmentTaggingSettings' => 'Action to insert HLS ID3 segment tagging', ], ], 'HlsId3SegmentTaggingState' => [ 'base' => 'State of HLS ID3 Segment Tagging', 'refs' => [ 'HlsGroupSettings$HlsId3SegmentTagging' => 'State of HLS ID3 Segment Tagging', ], ], 'HlsIncompleteSegmentBehavior' => [ 'base' => 'Hls Incomplete Segment Behavior', 'refs' => [ 'HlsGroupSettings$IncompleteSegmentBehavior' => 'Specifies whether to include the final (incomplete) segment in the media output when the pipeline stops producing output because of a channel stop, a channel pause or a loss of input to the pipeline.Auto means that MediaLive decides whether to include the final segment, depending on the channel class and the types of output groups.Suppress means to never include the incomplete segment. We recommend you choose Auto and let MediaLive control the behavior.', ], ], 'HlsInputSettings' => [ 'base' => 'Hls Input Settings', 'refs' => [ 'NetworkInputSettings$HlsInputSettings' => 'Specifies HLS input settings when the uri is for a HLS manifest.', ], ], 'HlsIvInManifest' => [ 'base' => 'Hls Iv In Manifest', 'refs' => [ 'HlsGroupSettings$IvInManifest' => 'For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If set to "include", IV is listed in the manifest, otherwise the IV is not in the manifest.', ], ], 'HlsIvSource' => [ 'base' => 'Hls Iv Source', 'refs' => [ 'HlsGroupSettings$IvSource' => 'For use with encryptionType. The IV (Initialization Vector) is a 128-bit number used in conjunction with the key for encrypting blocks. If this setting is "followsSegmentNumber", it will cause the IV to change every segment (to match the segment number). If this is set to "explicit", you must enter a constantIv value.', ], ], 'HlsManifestCompression' => [ 'base' => 'Hls Manifest Compression', 'refs' => [ 'HlsGroupSettings$ManifestCompression' => 'When set to gzip, compresses HLS playlist.', ], ], 'HlsManifestDurationFormat' => [ 'base' => 'Hls Manifest Duration Format', 'refs' => [ 'HlsGroupSettings$ManifestDurationFormat' => 'Indicates whether the output manifest should use floating point or integer values for segment duration.', ], ], 'HlsMediaStoreSettings' => [ 'base' => 'Hls Media Store Settings', 'refs' => [ 'HlsCdnSettings$HlsMediaStoreSettings' => NULL, ], ], 'HlsMediaStoreStorageClass' => [ 'base' => 'Hls Media Store Storage Class', 'refs' => [ 'HlsMediaStoreSettings$MediaStoreStorageClass' => 'When set to temporal, output files are stored in non-persistent memory for faster reading and writing.', ], ], 'HlsMode' => [ 'base' => 'Hls Mode', 'refs' => [ 'HlsGroupSettings$Mode' => 'If "vod", all segments are indexed and kept permanently in the destination and manifest. If "live", only the number segments specified in keepSegments and indexNSegments are kept; newer segments replace older segments, which may prevent players from rewinding all the way to the beginning of the event.VOD mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running, converting it to a "VOD" type manifest on completion of the stream.', ], ], 'HlsOutputSelection' => [ 'base' => 'Hls Output Selection', 'refs' => [ 'HlsGroupSettings$OutputSelection' => 'MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and media manifests) for this output group.VARIANT_MANIFESTS_AND_SEGMENTS: Generates media manifests for this output group, but not a master manifest.SEGMENTS_ONLY: Does not generate any manifests for this output group.', ], ], 'HlsOutputSettings' => [ 'base' => 'Hls Output Settings', 'refs' => [ 'OutputSettings$HlsOutputSettings' => NULL, ], ], 'HlsProgramDateTime' => [ 'base' => 'Hls Program Date Time', 'refs' => [ 'HlsGroupSettings$ProgramDateTime' => 'Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated using the program date time clock.', ], ], 'HlsProgramDateTimeClock' => [ 'base' => 'Hls Program Date Time Clock', 'refs' => [ 'HlsGroupSettings$ProgramDateTimeClock' => 'Specifies the algorithm used to drive the HLS EXT-X-PROGRAM-DATE-TIME clock. Options include:INITIALIZE_FROM_OUTPUT_TIMECODE: The PDT clock is initialized as a function of the first output timecode, then incremented by the EXTINF duration of each encoded segment.SYSTEM_CLOCK: The PDT clock is initialized as a function of the UTC wall clock, then incremented by the EXTINF duration of each encoded segment. If the PDT clock diverges from the wall clock by more than 500ms, it is resynchronized to the wall clock.', ], ], 'HlsRedundantManifest' => [ 'base' => 'Hls Redundant Manifest', 'refs' => [ 'HlsGroupSettings$RedundantManifest' => 'ENABLED: The master manifest (.m3u8 file) for each pipeline includes information about both pipelines: first its own media files, then the media files of the other pipeline. This feature allows playout device that support stale manifest detection to switch from one manifest to the other, when the current manifest seems to be stale. There are still two destinations and two master manifests, but both master manifests reference the media files from both pipelines.DISABLED: The master manifest (.m3u8 file) for each pipeline includes information about its own pipeline only.For an HLS output group with MediaPackage as the destination, the DISABLED behavior is always followed. MediaPackage regenerates the manifests it serves to players so a redundant manifest from MediaLive is irrelevant.', ], ], 'HlsS3LogUploads' => [ 'base' => 'Hls S3 Log Uploads', 'refs' => [ 'HlsS3Settings$LogUploads' => 'When set to enabled, each fragment upload to CDN or server will be logged.', ], ], 'HlsS3Settings' => [ 'base' => 'Hls S3 Settings', 'refs' => [ 'HlsCdnSettings$HlsS3Settings' => NULL, ], ], 'HlsScte35SourceType' => [ 'base' => 'Hls Scte35 Source Type', 'refs' => [ 'HlsInputSettings$Scte35Source' => 'Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information in the source that is not selected.', ], ], 'HlsSegmentationMode' => [ 'base' => 'Hls Segmentation Mode', 'refs' => [ 'HlsGroupSettings$SegmentationMode' => 'useInputSegmentation has been deprecated. The configured segment size is always used.', ], ], 'HlsSettings' => [ 'base' => 'Hls Settings', 'refs' => [ 'HlsOutputSettings$HlsSettings' => 'Settings regarding the underlying stream. These settings are different for audio-only outputs.', ], ], 'HlsStreamInfResolution' => [ 'base' => 'Hls Stream Inf Resolution', 'refs' => [ 'HlsGroupSettings$StreamInfResolution' => 'Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.', ], ], 'HlsTimedMetadataId3Frame' => [ 'base' => 'Hls Timed Metadata Id3 Frame', 'refs' => [ 'HlsGroupSettings$TimedMetadataId3Frame' => 'Indicates ID3 frame that has the timecode.', ], ], 'HlsTimedMetadataScheduleActionSettings' => [ 'base' => 'Settings for the action to emit HLS metadata', 'refs' => [ 'ScheduleActionSettings$HlsTimedMetadataSettings' => 'Action to insert HLS metadata', ], ], 'HlsTsFileMode' => [ 'base' => 'Hls Ts File Mode', 'refs' => [ 'HlsGroupSettings$TsFileMode' => 'SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts media file. The media manifest includes #EXT-X-BYTERANGE tags to index segments for playback. A typical use for this value is when sending the output to AWS Elemental MediaConvert, which can accept only a single media file. Playback while the channel is running is not guaranteed due to HTTP server caching.', ], ], 'HlsWebdavHttpTransferMode' => [ 'base' => 'Hls Webdav Http Transfer Mode', 'refs' => [ 'HlsWebdavSettings$HttpTransferMode' => 'Specify whether or not to use chunked transfer encoding to WebDAV.', ], ], 'HlsWebdavSettings' => [ 'base' => 'Hls Webdav Settings', 'refs' => [ 'HlsCdnSettings$HlsWebdavSettings' => NULL, ], ], 'HtmlMotionGraphicsSettings' => [ 'base' => 'Html Motion Graphics Settings', 'refs' => [ 'MotionGraphicsSettings$HtmlMotionGraphicsSettings' => NULL, ], ], 'IFrameOnlyPlaylistType' => [ 'base' => 'When set to "standard", an I-Frame only playlist will be written out for each video output in the output group. This I-Frame only playlist will contain byte range offsets pointing to the I-frame(s) in each segment.', 'refs' => [ 'HlsGroupSettings$IFrameOnlyPlaylists' => 'DISABLED: Do not create an I-frame-only manifest, but do create the master and media manifests (according to the Output Selection field).STANDARD: Create an I-frame-only manifest for each output that contains video, as well as the other manifests (according to the Output Selection field). The I-frame manifest contains a #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only, and one or more #EXT-X-BYTERANGE entries identifying the I-frame position. For example, #EXT-X-BYTERANGE:160364@1461888"', ], ], 'ImmediateModeScheduleActionStartSettings' => [ 'base' => 'Settings to configure an action so that it occurs as soon as possible.', 'refs' => [ 'ScheduleActionStartSettings$ImmediateModeScheduleActionStartSettings' => 'Option for specifying an action that should be applied immediately.', ], ], 'Input' => [ 'base' => NULL, 'refs' => [ 'CreateInputResultModel$Input' => NULL, 'CreatePartnerInputResultModel$Input' => NULL, 'UpdateInputResultModel$Input' => NULL, '__listOfInput$member' => NULL, ], ], 'InputAttachment' => [ 'base' => NULL, 'refs' => [ '__listOfInputAttachment$member' => NULL, ], ], 'InputChannelLevel' => [ 'base' => 'Input Channel Level', 'refs' => [ '__listOfInputChannelLevel$member' => NULL, ], ], 'InputClass' => [ 'base' => 'A standard input has two sources and a single pipeline input only has one.', 'refs' => [ 'Input$InputClass' => 'STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails.SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.', ], ], 'InputClippingSettings' => [ 'base' => 'Settings to let you create a clip of the file input, in order to set up the input to ingest only a portion of the file.', 'refs' => [ 'InputPrepareScheduleActionSettings$InputClippingSettings' => 'Settings to let you create a clip of the file input, in order to set up the input to ingest only a portion of the file.', 'InputSwitchScheduleActionSettings$InputClippingSettings' => 'Settings to let you create a clip of the file input, in order to set up the input to ingest only a portion of the file.', ], ], 'InputCodec' => [ 'base' => 'codec in increasing order of complexity', 'refs' => [ 'InputSpecification$Codec' => 'Input codec', ], ], 'InputDeblockFilter' => [ 'base' => 'Input Deblock Filter', 'refs' => [ 'InputSettings$DeblockFilter' => 'Enable or disable the deblock filter when filtering.', ], ], 'InputDenoiseFilter' => [ 'base' => 'Input Denoise Filter', 'refs' => [ 'InputSettings$DenoiseFilter' => 'Enable or disable the denoise filter when filtering.', ], ], 'InputDestination' => [ 'base' => 'The settings for a PUSH type input.', 'refs' => [ '__listOfInputDestination$member' => NULL, ], ], 'InputDestinationRequest' => [ 'base' => 'Endpoint settings for a PUSH type input.', 'refs' => [ '__listOfInputDestinationRequest$member' => NULL, ], ], 'InputDestinationVpc' => [ 'base' => 'The properties for a VPC type input destination.', 'refs' => [ 'InputDestination$Vpc' => NULL, ], ], 'InputDevice' => [ 'base' => 'An input device.', 'refs' => [], ], 'InputDeviceActiveInput' => [ 'base' => 'The source at the input device that is currently active.', 'refs' => [ 'InputDeviceHdSettings$ActiveInput' => 'If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).', 'InputDeviceUhdSettings$ActiveInput' => 'If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).', ], ], 'InputDeviceConfigurableSettings' => [ 'base' => 'Configurable settings for the input device.', 'refs' => [ 'UpdateInputDevice$HdDeviceSettings' => 'The settings that you want to apply to the HD input device.', 'UpdateInputDevice$UhdDeviceSettings' => 'The settings that you want to apply to the UHD input device.', ], ], 'InputDeviceConfigurationValidationError' => [ 'base' => NULL, 'refs' => [], ], 'InputDeviceConfiguredInput' => [ 'base' => 'The source to activate (use) from the input device.', 'refs' => [ 'InputDeviceConfigurableSettings$ConfiguredInput' => 'The input source that you want to use. If the device has a source connected to only one of its input ports, or if you don\'t care which source the device sends, specify Auto. If the device has sources connected to both its input ports, and you want to use a specific source, specify the source.', 'InputDeviceHdSettings$ConfiguredInput' => 'The source at the input device that is currently active. You can specify this source.', 'InputDeviceUhdSettings$ConfiguredInput' => 'The source at the input device that is currently active. You can specify this source.', ], ], 'InputDeviceConnectionState' => [ 'base' => 'The state of the connection between the input device and AWS.', 'refs' => [ 'InputDevice$ConnectionState' => 'The state of the connection between the input device and AWS.', 'InputDeviceSummary$ConnectionState' => 'The state of the connection between the input device and AWS.', ], ], 'InputDeviceHdSettings' => [ 'base' => 'Settings that describe the active source from the input device, and the video characteristics of that source.', 'refs' => [ 'InputDevice$HdDeviceSettings' => 'Settings that describe an input device that is type HD.', 'InputDeviceSummary$HdDeviceSettings' => 'Settings that describe an input device that is type HD.', ], ], 'InputDeviceIpScheme' => [ 'base' => 'Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address assignment (DHCP) or a static IP address.', 'refs' => [ 'InputDeviceNetworkSettings$IpScheme' => 'Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address assignment (DHCP) or a static IP address.', ], ], 'InputDeviceNetworkSettings' => [ 'base' => 'The network settings for the input device.', 'refs' => [ 'InputDevice$NetworkSettings' => 'The network settings for the input device.', 'InputDeviceSummary$NetworkSettings' => 'Network settings for the input device.', ], ], 'InputDeviceRequest' => [ 'base' => 'Settings for an input device.', 'refs' => [ '__listOfInputDeviceRequest$member' => NULL, ], ], 'InputDeviceScanType' => [ 'base' => 'The scan type of the video source.', 'refs' => [ 'InputDeviceHdSettings$ScanType' => 'The scan type of the video source.', 'InputDeviceUhdSettings$ScanType' => 'The scan type of the video source.', ], ], 'InputDeviceSettings' => [ 'base' => 'Settings for an input device.', 'refs' => [ '__listOfInputDeviceSettings$member' => NULL, ], ], 'InputDeviceState' => [ 'base' => 'The state of the input device.', 'refs' => [ 'InputDeviceHdSettings$DeviceState' => 'The state of the input device.', 'InputDeviceUhdSettings$DeviceState' => 'The state of the input device.', ], ], 'InputDeviceSummary' => [ 'base' => 'Details of the input device.', 'refs' => [ '__listOfInputDeviceSummary$member' => NULL, ], ], 'InputDeviceTransferType' => [ 'base' => 'The type of device transfer. INCOMING for an input device that is being transferred to you, OUTGOING for an input device that you are transferring to another AWS account.', 'refs' => [ 'TransferringInputDeviceSummary$TransferType' => 'The type (direction) of the input device transfer.', ], ], 'InputDeviceType' => [ 'base' => 'The type of the input device. For an AWS Elemental Link device that outputs resolutions up to 1080, choose "HD".', 'refs' => [ 'InputDevice$Type' => 'The type of the input device.', 'InputDeviceSummary$Type' => 'The type of the input device.', ], ], 'InputDeviceUhdSettings' => [ 'base' => 'Settings that describe the active source from the input device, and the video characteristics of that source.', 'refs' => [ 'InputDevice$UhdDeviceSettings' => 'Settings that describe an input device that is type UHD.', 'InputDeviceSummary$UhdDeviceSettings' => 'Settings that describe an input device that is type UHD.', ], ], 'InputFilter' => [ 'base' => 'Input Filter', 'refs' => [ 'InputSettings$InputFilter' => 'Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default.1) auto - filtering will be applied depending on input type/quality2) disabled - no filtering will be applied to the input3) forced - filtering will be applied regardless of input type', ], ], 'InputLocation' => [ 'base' => 'Input Location', 'refs' => [ 'AudioOnlyHlsSettings$AudioOnlyImage' => 'Optional. Specifies the .jpg or .png image to use as the cover art for an audio-only output. We recommend a low bit-size file because the image increases the output audio bandwidth.The image is attached to the audio as an ID3 tag, frame type APIC, picture type 0x10, as per the "ID3 tag version 2.4.0 - Native Frames" standard.', 'AvailBlanking$AvailBlankingImage' => 'Blanking image to be used. Leave empty for solid black. Only bmp and png images are supported.', 'BlackoutSlate$BlackoutSlateImage' => 'Blackout slate image to be used. Leave empty for solid black. Only bmp and png images are supported.', 'BlackoutSlate$NetworkEndBlackoutImage' => 'Path to local file to use as Network End Blackout image. Image will be scaled to fill the entire output raster.', 'BurnInDestinationSettings$Font' => 'External font file used for caption burn-in. File extension must be \'ttf\' or \'tte\'. Although the user can select output fonts for many different types of input captions, embedded, STL and teletext sources use a strict grid system. Using external fonts with these caption sources could cause unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$Font' => 'External font file used for caption burn-in. File extension must be \'ttf\' or \'tte\'. Although the user can select output fonts for many different types of input captions, embedded, STL and teletext sources use a strict grid system. Using external fonts with these caption sources could cause unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match.', 'InputLossBehavior$InputLossImageSlate' => 'When input loss image type is "slate" these fields specify the parameters for accessing the slate.', 'StaticImageActivateScheduleActionSettings$Image' => 'The location and filename of the image file to overlay on the video. The file must be a 32-bit BMP, PNG, or TGA file, and must not be larger (in pixels) than the input video.', 'StaticKeySettings$KeyProviderServer' => 'The URL of the license server used for protecting content.', ], ], 'InputLossActionForHlsOut' => [ 'base' => 'Input Loss Action For Hls Out', 'refs' => [ 'HlsGroupSettings$InputLossAction' => 'Parameter that control output group behavior on input loss.', ], ], 'InputLossActionForMsSmoothOut' => [ 'base' => 'Input Loss Action For Ms Smooth Out', 'refs' => [ 'MsSmoothGroupSettings$InputLossAction' => 'Parameter that control output group behavior on input loss.', ], ], 'InputLossActionForRtmpOut' => [ 'base' => 'Input Loss Action For Rtmp Out', 'refs' => [ 'RtmpGroupSettings$InputLossAction' => 'Controls the behavior of this RTMP group if input becomes unavailable.- emitOutput: Emit a slate until input returns.- pauseOutput: Stop transmitting data until input returns. This does not close the underlying RTMP connection.', ], ], 'InputLossActionForUdpOut' => [ 'base' => 'Input Loss Action For Udp Out', 'refs' => [ 'UdpGroupSettings$InputLossAction' => 'Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When dropTs is selected the entire transport stream will stop being emitted. When dropProgram is selected the program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate requirement). Or, when emitProgram is chosen the transport stream will continue to be produced normally with repeat frames, black frames, or slate frames substituted for the absent input video.', ], ], 'InputLossBehavior' => [ 'base' => 'Input Loss Behavior', 'refs' => [ 'GlobalConfiguration$InputLossBehavior' => 'Settings for system actions when input is lost.', ], ], 'InputLossFailoverSettings' => [ 'base' => 'MediaLive will perform a failover if content is not detected in this input for the specified period.', 'refs' => [ 'FailoverConditionSettings$InputLossSettings' => 'MediaLive will perform a failover if content is not detected in this input for the specified period.', ], ], 'InputLossImageType' => [ 'base' => 'Input Loss Image Type', 'refs' => [ 'InputLossBehavior$InputLossImageType' => 'Indicates whether to substitute a solid color or a slate into the output after input loss exceeds blackFrameMsec.', ], ], 'InputMaximumBitrate' => [ 'base' => 'Maximum input bitrate in megabits per second. Bitrates up to 50 Mbps are supported currently.', 'refs' => [ 'InputSpecification$MaximumBitrate' => 'Maximum input bitrate, categorized coarsely', ], ], 'InputPreference' => [ 'base' => 'Input preference when deciding which input to make active when a previously failed input has recovered.If \\"EQUAL_INPUT_PREFERENCE\\", then the active input will stay active as long as it is healthy.If \\"PRIMARY_INPUT_PREFERRED\\", then always switch back to the primary input when it is healthy.', 'refs' => [ 'AutomaticInputFailoverSettings$InputPreference' => 'Input preference when deciding which input to make active when a previously failed input has recovered.', ], ], 'InputPrepareScheduleActionSettings' => [ 'base' => 'Action to prepare an input for a future immediate input switch.', 'refs' => [ 'ScheduleActionSettings$InputPrepareSettings' => 'Action to prepare an input for a future immediate input switch', ], ], 'InputResolution' => [ 'base' => 'Input resolution based on lines of vertical resolution in the input; SD is less than 720 lines, HD is 720 to 1080 lines, UHD is greater than 1080 lines', 'refs' => [ 'InputSpecification$Resolution' => 'Input resolution, categorized coarsely', ], ], 'InputSecurityGroup' => [ 'base' => 'An Input Security Group', 'refs' => [ 'CreateInputSecurityGroupResultModel$SecurityGroup' => NULL, 'UpdateInputSecurityGroupResultModel$SecurityGroup' => NULL, '__listOfInputSecurityGroup$member' => NULL, ], ], 'InputSecurityGroupState' => [ 'base' => NULL, 'refs' => [ 'InputSecurityGroup$State' => 'The current state of the Input Security Group.', ], ], 'InputSecurityGroupWhitelistRequest' => [ 'base' => 'Request of IPv4 CIDR addresses to whitelist in a security group.', 'refs' => [], ], 'InputSettings' => [ 'base' => 'Live Event input parameters. There can be multiple inputs in a single Live Event.', 'refs' => [ 'InputAttachment$InputSettings' => 'Settings of an input (caption selector, etc.)', ], ], 'InputSource' => [ 'base' => 'The settings for a PULL type input.', 'refs' => [ '__listOfInputSource$member' => NULL, ], ], 'InputSourceEndBehavior' => [ 'base' => 'Input Source End Behavior', 'refs' => [ 'InputSettings$SourceEndBehavior' => 'Loop input if it is a file. This allows a file input to be streamed indefinitely.', ], ], 'InputSourceRequest' => [ 'base' => 'Settings for for a PULL type input.', 'refs' => [ '__listOfInputSourceRequest$member' => NULL, ], ], 'InputSourceType' => [ 'base' => 'There are two types of input sources, static and dynamic. If an input source is dynamic you canchange the source url of the input dynamically using an input switch action. Currently, two input typessupport a dynamic url at this time, MP4_FILE and TS_FILE. By default all input sources are static.', 'refs' => [ 'Input$InputSourceType' => 'Certain pull input sources can be dynamic, meaning that they can have their URL\'s dynamically changesduring input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.', ], ], 'InputSpecification' => [ 'base' => NULL, 'refs' => [ 'Channel$InputSpecification' => 'Specification of network and file inputs for this channel', 'ChannelSummary$InputSpecification' => 'Specification of network and file inputs for this channel', 'CreateChannel$InputSpecification' => 'Specification of network and file inputs for this channel', 'UpdateChannel$InputSpecification' => 'Specification of network and file inputs for this channel', ], ], 'InputState' => [ 'base' => NULL, 'refs' => [ 'Input$State' => NULL, ], ], 'InputSwitchScheduleActionSettings' => [ 'base' => 'Settings for the "switch input" action: to switch from ingesting one input to ingesting another input.', 'refs' => [ 'ScheduleActionSettings$InputSwitchSettings' => 'Action to switch the input', ], ], 'InputTimecodeSource' => [ 'base' => 'To clip the file, you must specify the timecode for the start and end of the clip. <br>Specify EMBEDDED to use the timecode embedded in the source content. The embedded timecode must exist in the source content, otherwise MediaLive will output black frames until it reaches the end of the source. <br>Specify ZEROBASED to use a timecode that assumes that the first frame in the file has the timestamp 00:00:00.00. <br> There is no default for this field, you must specify a value.', 'refs' => [ 'InputClippingSettings$InputTimecodeSource' => 'The source of the timecodes in the source being clipped.', ], ], 'InputType' => [ 'base' => 'The different types of inputs that AWS Elemental MediaLive supports.', 'refs' => [ 'CreateInput$Type' => NULL, 'Input$Type' => NULL, ], ], 'InputVpcRequest' => [ 'base' => 'Settings for a private VPC Input.When this property is specified, the input destination addresses will be created in a VPC rather than with public Internet addresses.This property requires setting the roleArn property on Input creation.Not compatible with the inputSecurityGroups property.', 'refs' => [ 'CreateInput$Vpc' => NULL, ], ], 'InputWhitelistRule' => [ 'base' => 'Whitelist rule', 'refs' => [ '__listOfInputWhitelistRule$member' => NULL, ], ], 'InputWhitelistRuleCidr' => [ 'base' => 'An IPv4 CIDR to whitelist.', 'refs' => [ '__listOfInputWhitelistRuleCidr$member' => NULL, ], ], 'InternalServerErrorException' => [ 'base' => NULL, 'refs' => [], ], 'InternalServiceError' => [ 'base' => NULL, 'refs' => [], ], 'InvalidRequest' => [ 'base' => NULL, 'refs' => [], ], 'KeyProviderSettings' => [ 'base' => 'Key Provider Settings', 'refs' => [ 'HlsGroupSettings$KeyProviderSettings' => 'The key provider settings.', ], ], 'LastFrameClippingBehavior' => [ 'base' => 'If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the clip to exclude (the default) or include the frame specified by the timecode.', 'refs' => [ 'StopTimecode$LastFrameClippingBehavior' => 'If you specify a StopTimecode in an input (in order to clip the file), you can specify if you want the clip to exclude (the default) or include the frame specified by the timecode.', ], ], 'LimitExceeded' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResultModel' => [ 'base' => NULL, 'refs' => [], ], 'ListInputDeviceTransfersResultModel' => [ 'base' => 'The list of input devices in the transferred state. The recipient hasn\'t yet accepted or rejected the transfer.', 'refs' => [], ], 'ListInputDevicesResultModel' => [ 'base' => 'The list of input devices owned by the AWS account.', 'refs' => [], ], 'ListInputSecurityGroupsResultModel' => [ 'base' => 'Result of input security group list request', 'refs' => [], ], 'ListInputsResultModel' => [ 'base' => NULL, 'refs' => [], ], 'ListMultiplexProgramsResultModel' => [ 'base' => NULL, 'refs' => [], ], 'ListMultiplexesResultModel' => [ 'base' => NULL, 'refs' => [], ], 'ListOfferingsResultModel' => [ 'base' => 'ListOfferings response', 'refs' => [], ], 'ListReservationsResultModel' => [ 'base' => 'ListReservations response', 'refs' => [], ], 'LogLevel' => [ 'base' => 'The log level the user wants for their channel.', 'refs' => [ 'Channel$LogLevel' => 'The log level being written to CloudWatch Logs.', 'ChannelSummary$LogLevel' => 'The log level being written to CloudWatch Logs.', 'CreateChannel$LogLevel' => 'The log level to write to CloudWatch Logs.', 'UpdateChannel$LogLevel' => 'The log level to write to CloudWatch Logs.', ], ], 'M2tsAbsentInputAudioBehavior' => [ 'base' => 'M2ts Absent Input Audio Behavior', 'refs' => [ 'M2tsSettings$AbsentInputAudioBehavior' => 'When set to drop, output audio streams will be removed from the program if the selected input audio stream is removed from the input. This allows the output audio configuration to dynamically change based on input configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not connected to an active input stream.', ], ], 'M2tsArib' => [ 'base' => 'M2ts Arib', 'refs' => [ 'M2tsSettings$Arib' => 'When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.', ], ], 'M2tsAribCaptionsPidControl' => [ 'base' => 'M2ts Arib Captions Pid Control', 'refs' => [ 'M2tsSettings$AribCaptionsPidControl' => 'If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids. If set to useConfigured, ARIB Captions will be on the configured pid number.', ], ], 'M2tsAudioBufferModel' => [ 'base' => 'M2ts Audio Buffer Model', 'refs' => [ 'M2tsSettings$AudioBufferModel' => 'When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to atsc, the ATSC model is used.', ], ], 'M2tsAudioInterval' => [ 'base' => 'M2ts Audio Interval', 'refs' => [ 'M2tsSettings$EbpAudioInterval' => 'When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The interval between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval. Only available when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2 will always follow the video interval.', ], ], 'M2tsAudioStreamType' => [ 'base' => 'M2ts Audio Stream Type', 'refs' => [ 'M2tsSettings$AudioStreamType' => 'When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses stream type = 0x06.', ], ], 'M2tsBufferModel' => [ 'base' => 'M2ts Buffer Model', 'refs' => [ 'M2tsSettings$BufferModel' => 'Controls the timing accuracy for output network traffic. Leave as MULTIPLEX to ensure accurate network packet timing. Or set to NONE, which might result in lower latency but will result in more variability in output network packet timing. This variability might cause interruptions, jitter, or bursty behavior in your playback or receiving devices.', ], ], 'M2tsCcDescriptor' => [ 'base' => 'M2ts Cc Descriptor', 'refs' => [ 'M2tsSettings$CcDescriptor' => 'When set to enabled, generates captionServiceDescriptor in PMT.', ], ], 'M2tsEbifControl' => [ 'base' => 'M2ts Ebif Control', 'refs' => [ 'M2tsSettings$Ebif' => 'If set to passthrough, passes any EBIF data from the input source to this output.', ], ], 'M2tsEbpPlacement' => [ 'base' => 'M2ts Ebp Placement', 'refs' => [ 'M2tsSettings$EbpPlacement' => 'Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the video PID and all audio PIDs. If set to videoPid, EBP markers will be placed on only the video PID.', ], ], 'M2tsEsRateInPes' => [ 'base' => 'M2ts Es Rate In Pes', 'refs' => [ 'M2tsSettings$EsRateInPes' => 'Include or exclude the ES Rate field in the PES header.', ], ], 'M2tsKlv' => [ 'base' => 'M2ts Klv', 'refs' => [ 'M2tsSettings$Klv' => 'If set to passthrough, passes any KLV data from the input source to this output.', ], ], 'M2tsNielsenId3Behavior' => [ 'base' => 'M2ts Nielsen Id3 Behavior', 'refs' => [ 'M2tsSettings$NielsenId3Behavior' => 'If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.', ], ], 'M2tsPcrControl' => [ 'base' => 'M2ts Pcr Control', 'refs' => [ 'M2tsSettings$PcrControl' => 'When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.', ], ], 'M2tsRateMode' => [ 'base' => 'M2ts Rate Mode', 'refs' => [ 'M2tsSettings$RateMode' => 'When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate setting acts as the maximum bitrate when vbr is set.', ], ], 'M2tsScte35Control' => [ 'base' => 'M2ts Scte35 Control', 'refs' => [ 'M2tsSettings$Scte35Control' => 'Optionally pass SCTE-35 signals from the input source to this output.', ], ], 'M2tsSegmentationMarkers' => [ 'base' => 'M2ts Segmentation Markers', 'refs' => [ 'M2tsSettings$SegmentationMarkers' => 'Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.', ], ], 'M2tsSegmentationStyle' => [ 'base' => 'M2ts Segmentation Style', 'refs' => [ 'M2tsSettings$SegmentationStyle' => 'The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With avails, it is possible that segments may be truncated, which can influence where future segmentation markers are inserted.When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime seconds.When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead is a slight exception to this rule.', ], ], 'M2tsSettings' => [ 'base' => 'M2ts Settings', 'refs' => [ 'ArchiveContainerSettings$M2tsSettings' => NULL, 'UdpContainerSettings$M2tsSettings' => NULL, ], ], 'M2tsTimedMetadataBehavior' => [ 'base' => 'M2ts Timed Metadata Behavior', 'refs' => [ 'M2tsSettings$TimedMetadataBehavior' => 'When set to passthrough, timed metadata will be passed through from input to output.', ], ], 'M3u8NielsenId3Behavior' => [ 'base' => 'M3u8 Nielsen Id3 Behavior', 'refs' => [ 'M3u8Settings$NielsenId3Behavior' => 'If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.', ], ], 'M3u8PcrControl' => [ 'base' => 'M3u8 Pcr Control', 'refs' => [ 'M3u8Settings$PcrControl' => 'When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.', ], ], 'M3u8Scte35Behavior' => [ 'base' => 'M3u8 Scte35 Behavior', 'refs' => [ 'M3u8Settings$Scte35Behavior' => 'If set to passthrough, passes any SCTE-35 signals from the input source to this output.', ], ], 'M3u8Settings' => [ 'base' => 'Settings information for the .m3u8 container', 'refs' => [ 'StandardHlsSettings$M3u8Settings' => NULL, ], ], 'M3u8TimedMetadataBehavior' => [ 'base' => 'M3u8 Timed Metadata Behavior', 'refs' => [ 'M3u8Settings$TimedMetadataBehavior' => 'When set to passthrough, timed metadata is passed through from input to output.', ], ], 'MaintenanceCreateSettings' => [ 'base' => NULL, 'refs' => [ 'CreateChannel$Maintenance' => 'Maintenance settings for this channel.', ], ], 'MaintenanceDay' => [ 'base' => 'The currently selected maintenance day.', 'refs' => [ 'MaintenanceCreateSettings$MaintenanceDay' => 'Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.', 'MaintenanceStatus$MaintenanceDay' => 'The currently selected maintenance day.', 'MaintenanceUpdateSettings$MaintenanceDay' => 'Choose one day of the week for maintenance. The chosen day is used for all future maintenance windows.', ], ], 'MaintenanceStatus' => [ 'base' => NULL, 'refs' => [ 'Channel$Maintenance' => 'Maintenance settings for this channel.', 'ChannelSummary$Maintenance' => 'Maintenance settings for this channel.', ], ], 'MaintenanceUpdateSettings' => [ 'base' => NULL, 'refs' => [ 'UpdateChannel$Maintenance' => 'Maintenance settings for this channel.', ], ], 'MediaConnectFlow' => [ 'base' => 'The settings for a MediaConnect Flow.', 'refs' => [ '__listOfMediaConnectFlow$member' => NULL, ], ], 'MediaConnectFlowRequest' => [ 'base' => 'The settings for a MediaConnect Flow.', 'refs' => [ '__listOfMediaConnectFlowRequest$member' => NULL, ], ], 'MediaPackageGroupSettings' => [ 'base' => 'Media Package Group Settings', 'refs' => [ 'OutputGroupSettings$MediaPackageGroupSettings' => NULL, ], ], 'MediaPackageOutputDestinationSettings' => [ 'base' => 'MediaPackage Output Destination Settings', 'refs' => [ '__listOfMediaPackageOutputDestinationSettings$member' => NULL, ], ], 'MediaPackageOutputSettings' => [ 'base' => 'Media Package Output Settings', 'refs' => [ 'OutputSettings$MediaPackageOutputSettings' => NULL, ], ], 'MotionGraphicsActivateScheduleActionSettings' => [ 'base' => 'Settings to specify the rendering of motion graphics into the video stream.', 'refs' => [ 'ScheduleActionSettings$MotionGraphicsImageActivateSettings' => 'Action to activate a motion graphics image overlay', ], ], 'MotionGraphicsConfiguration' => [ 'base' => 'Motion Graphics Configuration', 'refs' => [ 'EncoderSettings$MotionGraphicsConfiguration' => 'Settings for motion graphics.', ], ], 'MotionGraphicsDeactivateScheduleActionSettings' => [ 'base' => 'Settings to specify the ending of rendering motion graphics into the video stream.', 'refs' => [ 'ScheduleActionSettings$MotionGraphicsImageDeactivateSettings' => 'Action to deactivate a motion graphics image overlay', ], ], 'MotionGraphicsInsertion' => [ 'base' => 'Motion Graphics Insertion', 'refs' => [ 'MotionGraphicsConfiguration$MotionGraphicsInsertion' => NULL, ], ], 'MotionGraphicsSettings' => [ 'base' => 'Motion Graphics Settings', 'refs' => [ 'MotionGraphicsConfiguration$MotionGraphicsSettings' => 'Motion Graphics Settings', ], ], 'Mp2CodingMode' => [ 'base' => 'Mp2 Coding Mode', 'refs' => [ 'Mp2Settings$CodingMode' => 'The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or codingMode20 (for stereo).', ], ], 'Mp2Settings' => [ 'base' => 'Mp2 Settings', 'refs' => [ 'AudioCodecSettings$Mp2Settings' => NULL, ], ], 'Mpeg2AdaptiveQuantization' => [ 'base' => 'Mpeg2 Adaptive Quantization', 'refs' => [ 'Mpeg2Settings$AdaptiveQuantization' => 'Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows intra-frame quantizers to vary, which might improve visual quality.', ], ], 'Mpeg2ColorMetadata' => [ 'base' => 'Mpeg2 Color Metadata', 'refs' => [ 'Mpeg2Settings$ColorMetadata' => 'Specifies whether to include the color space metadata. The metadata describes the color space that applies to the video (the colorSpace field). We recommend that you insert the metadata.', ], ], 'Mpeg2ColorSpace' => [ 'base' => 'Mpeg2 Color Space', 'refs' => [ 'Mpeg2Settings$ColorSpace' => 'Choose the type of color space conversion to apply to the output. For detailed information on setting up both the input and the output to obtain the desired color space in the output, see the section on \\"MediaLive Features - Video - color space\\" in the MediaLive User Guide.PASSTHROUGH: Keep the color space of the input content - do not convert it.AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.', ], ], 'Mpeg2DisplayRatio' => [ 'base' => 'Mpeg2 Display Ratio', 'refs' => [ 'Mpeg2Settings$DisplayAspectRatio' => 'Sets the pixel aspect ratio for the encode.', ], ], 'Mpeg2FilterSettings' => [ 'base' => 'Mpeg2 Filter Settings', 'refs' => [ 'Mpeg2Settings$FilterSettings' => 'Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not choose a filter, no filter will be applied.TEMPORAL: This filter is useful for both source content that is noisy (when it has excessive digital artifacts) and source content that is clean.When the content is noisy, the filter cleans up the source content before the encoding phase, with these two effects: First, it improves the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth because MediaLive does not waste bits on encoding noise.When the content is reasonably clean, the filter tends to decrease the bitrate.', ], ], 'Mpeg2GopSizeUnits' => [ 'base' => 'Mpeg2 Gop Size Units', 'refs' => [ 'Mpeg2Settings$GopSizeUnits' => 'Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the gop size to a frame count.', ], ], 'Mpeg2ScanType' => [ 'base' => 'Mpeg2 Scan Type', 'refs' => [ 'Mpeg2Settings$ScanType' => 'Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).', ], ], 'Mpeg2Settings' => [ 'base' => 'Mpeg2 Settings', 'refs' => [ 'VideoCodecSettings$Mpeg2Settings' => NULL, ], ], 'Mpeg2SubGopLength' => [ 'base' => 'Mpeg2 Sub Gop Length', 'refs' => [ 'Mpeg2Settings$SubgopLength' => 'Relates to the GOP structure. If you do not know what GOP is, use the default.FIXED: Set the number of B-frames in each sub-GOP to the value in gopNumBFrames.DYNAMIC: Let MediaLive optimize the number of B-frames in each sub-GOP, to improve visual quality.', ], ], 'Mpeg2TimecodeInsertionBehavior' => [ 'base' => 'Mpeg2 Timecode Insertion Behavior', 'refs' => [ 'Mpeg2Settings$TimecodeInsertion' => 'Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the input and the output for a timecode, see the section on \\"MediaLive Features - Timecode configuration\\" in the MediaLive User Guide.DISABLED: do not include timecodes.GOP_TIMECODE: Include timecode metadata in the GOP header.', ], ], 'MsSmoothGroupSettings' => [ 'base' => 'Ms Smooth Group Settings', 'refs' => [ 'OutputGroupSettings$MsSmoothGroupSettings' => NULL, ], ], 'MsSmoothH265PackagingType' => [ 'base' => 'Ms Smooth H265 Packaging Type', 'refs' => [ 'MsSmoothOutputSettings$H265PackagingType' => 'Only applicable when this output is referencing an H.265 video description.Specifies whether MP4 segments should be packaged as HEV1 or HVC1.', ], ], 'MsSmoothOutputSettings' => [ 'base' => 'Ms Smooth Output Settings', 'refs' => [ 'OutputSettings$MsSmoothOutputSettings' => NULL, ], ], 'Multiplex' => [ 'base' => 'The multiplex object.', 'refs' => [ 'CreateMultiplexResultModel$Multiplex' => 'The newly created multiplex.', 'UpdateMultiplexResultModel$Multiplex' => 'The updated multiplex.', ], ], 'MultiplexConfigurationValidationError' => [ 'base' => NULL, 'refs' => [], ], 'MultiplexGroupSettings' => [ 'base' => 'Multiplex Group Settings', 'refs' => [ 'OutputGroupSettings$MultiplexGroupSettings' => NULL, ], ], 'MultiplexMediaConnectOutputDestinationSettings' => [ 'base' => 'Multiplex MediaConnect output destination settings.', 'refs' => [ 'MultiplexOutputDestination$MediaConnectSettings' => 'Multiplex MediaConnect output destination settings.', ], ], 'MultiplexOutputDestination' => [ 'base' => 'Multiplex output destination settings', 'refs' => [ '__listOfMultiplexOutputDestination$member' => NULL, ], ], 'MultiplexOutputSettings' => [ 'base' => 'Multiplex Output Settings', 'refs' => [ 'OutputSettings$MultiplexOutputSettings' => NULL, ], ], 'MultiplexProgram' => [ 'base' => 'The multiplex program object.', 'refs' => [ 'CreateMultiplexProgramResultModel$MultiplexProgram' => 'The newly created multiplex program.', 'UpdateMultiplexProgramResultModel$MultiplexProgram' => 'The updated multiplex program.', ], ], 'MultiplexProgramChannelDestinationSettings' => [ 'base' => 'Multiplex Program Input Destination Settings for outputting a Channel to a Multiplex', 'refs' => [ 'OutputDestination$MultiplexSettings' => 'Destination settings for a Multiplex output; one destination for both encoders.', ], ], 'MultiplexProgramPacketIdentifiersMap' => [ 'base' => 'Packet identifiers map for a given Multiplex program.', 'refs' => [ 'MultiplexProgram$PacketIdentifiersMap' => 'The packet identifier map for this multiplex program.', ], ], 'MultiplexProgramPipelineDetail' => [ 'base' => 'The current source for one of the pipelines in the multiplex.', 'refs' => [ '__listOfMultiplexProgramPipelineDetail$member' => NULL, ], ], 'MultiplexProgramServiceDescriptor' => [ 'base' => 'Transport stream service descriptor configuration for the Multiplex program.', 'refs' => [ 'MultiplexProgramSettings$ServiceDescriptor' => 'Transport stream service descriptor configuration for the Multiplex program.', ], ], 'MultiplexProgramSettings' => [ 'base' => 'Multiplex Program settings configuration.', 'refs' => [ 'CreateMultiplexProgram$MultiplexProgramSettings' => 'The settings for this multiplex program.', 'MultiplexProgram$MultiplexProgramSettings' => 'The settings for this multiplex program.', 'UpdateMultiplexProgram$MultiplexProgramSettings' => 'The new settings for a multiplex program.', ], ], 'MultiplexProgramSummary' => [ 'base' => NULL, 'refs' => [ '__listOfMultiplexProgramSummary$member' => NULL, ], ], 'MultiplexSettings' => [ 'base' => 'Contains configuration for a Multiplex event', 'refs' => [ 'CreateMultiplex$MultiplexSettings' => 'Configuration for a multiplex event.', 'Multiplex$MultiplexSettings' => 'Configuration for a multiplex event.', 'UpdateMultiplex$MultiplexSettings' => 'The new settings for a multiplex.', ], ], 'MultiplexSettingsSummary' => [ 'base' => 'Contains summary configuration for a Multiplex event.', 'refs' => [ 'MultiplexSummary$MultiplexSettings' => 'Configuration for a multiplex event.', ], ], 'MultiplexState' => [ 'base' => 'The current state of the multiplex.', 'refs' => [ 'Multiplex$State' => 'The current state of the multiplex.', 'MultiplexSummary$State' => 'The current state of the multiplex.', ], ], 'MultiplexStatmuxVideoSettings' => [ 'base' => 'Statmux rate control settings', 'refs' => [ 'MultiplexVideoSettings$StatmuxSettings' => 'Statmux rate control settings.When this field is defined, ConstantBitrate must be undefined.', ], ], 'MultiplexSummary' => [ 'base' => NULL, 'refs' => [ '__listOfMultiplexSummary$member' => NULL, ], ], 'MultiplexVideoSettings' => [ 'base' => 'The video configuration for each program in a multiplex.', 'refs' => [ 'MultiplexProgramSettings$VideoSettings' => 'Program video settings configuration.', ], ], 'NetworkInputServerValidation' => [ 'base' => 'Network Input Server Validation', 'refs' => [ 'NetworkInputSettings$ServerValidation' => 'Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will be checked, but not the server\'s name. Certain subdomains (notably S3 buckets that use dots in the bucket name) do not strictly match the corresponding certificate\'s wildcard pattern and would otherwise cause the event to error. This setting is ignored for protocols that do not use https.', ], ], 'NetworkInputSettings' => [ 'base' => 'Network source to transcode. Must be accessible to the Elemental Live node that is running the live event through a network connection.', 'refs' => [ 'InputSettings$NetworkInputSettings' => 'Input settings.', ], ], 'NielsenCBET' => [ 'base' => 'Nielsen CBET', 'refs' => [ 'NielsenWatermarksSettings$NielsenCbetSettings' => 'Complete these fields only if you want to insert watermarks of type Nielsen CBET', ], ], 'NielsenConfiguration' => [ 'base' => 'Nielsen Configuration', 'refs' => [ 'EncoderSettings$NielsenConfiguration' => 'Nielsen configuration settings.', ], ], 'NielsenNaesIiNw' => [ 'base' => 'Nielsen Naes Ii Nw', 'refs' => [ 'NielsenWatermarksSettings$NielsenNaesIiNwSettings' => 'Complete these fields only if you want to insert watermarks of type Nielsen NAES II (N2) and Nielsen NAES VI (NW).', ], ], 'NielsenPcmToId3TaggingState' => [ 'base' => 'State of Nielsen PCM to ID3 tagging', 'refs' => [ 'NielsenConfiguration$NielsenPcmToId3Tagging' => 'Enables Nielsen PCM to ID3 tagging', ], ], 'NielsenWatermarksCbetStepaside' => [ 'base' => 'Nielsen Watermarks Cbet Stepaside', 'refs' => [ 'NielsenCBET$CbetStepaside' => 'Determines the method of CBET insertion mode when prior encoding is detected on the same layer.', ], ], 'NielsenWatermarksDistributionTypes' => [ 'base' => 'Nielsen Watermarks Distribution Types', 'refs' => [ 'NielsenWatermarksSettings$NielsenDistributionType' => 'Choose the distribution types that you want to assign to the watermarks:- PROGRAM_CONTENT- FINAL_DISTRIBUTOR', ], ], 'NielsenWatermarksSettings' => [ 'base' => 'Nielsen Watermarks Settings', 'refs' => [ 'AudioWatermarkSettings$NielsenWatermarksSettings' => 'Settings to configure Nielsen Watermarks in the audio encode', ], ], 'NotFoundException' => [ 'base' => NULL, 'refs' => [], ], 'Offering' => [ 'base' => 'Reserved resources available for purchase', 'refs' => [ '__listOfOffering$member' => NULL, ], ], 'OfferingDurationUnits' => [ 'base' => 'Units for duration, e.g. \'MONTHS\'', 'refs' => [ 'Offering$DurationUnits' => 'Units for duration, e.g. \'MONTHS\'', 'Reservation$DurationUnits' => 'Units for duration, e.g. \'MONTHS\'', ], ], 'OfferingType' => [ 'base' => 'Offering type, e.g. \'NO_UPFRONT\'', 'refs' => [ 'Offering$OfferingType' => 'Offering type, e.g. \'NO_UPFRONT\'', 'Reservation$OfferingType' => 'Offering type, e.g. \'NO_UPFRONT\'', ], ], 'Output' => [ 'base' => 'Output settings. There can be multiple outputs within a group.', 'refs' => [ '__listOfOutput$member' => NULL, ], ], 'OutputDestination' => [ 'base' => NULL, 'refs' => [ '__listOfOutputDestination$member' => NULL, ], ], 'OutputDestinationSettings' => [ 'base' => NULL, 'refs' => [ '__listOfOutputDestinationSettings$member' => NULL, ], ], 'OutputGroup' => [ 'base' => 'Output groups for this Live Event. Output groups contain information about where streams should be distributed.', 'refs' => [ '__listOfOutputGroup$member' => NULL, ], ], 'OutputGroupSettings' => [ 'base' => 'Output Group Settings', 'refs' => [ 'OutputGroup$OutputGroupSettings' => 'Settings associated with the output group.', ], ], 'OutputLocationRef' => [ 'base' => 'Reference to an OutputDestination ID defined in the channel', 'refs' => [ 'ArchiveGroupSettings$Destination' => 'A directory and base filename where archive files should be written.', 'FrameCaptureGroupSettings$Destination' => 'The destination for the frame capture files. Either the URI for an Amazon S3 bucket and object, plus a file name prefix (for example, s3ssl://sportsDelivery/highlights/20180820/curling-) or the URI for a MediaStore container, plus a file name prefix (for example, mediastoressl://sportsDelivery/20180820/curling-). The final file names consist of the prefix from the destination field (for example, "curling-") + name modifier + the counter (5 digits, starting from 00001) + extension (which is always .jpg). For example, curling-low.00001.jpg', 'HlsGroupSettings$Destination' => 'A directory or HTTP destination for the HLS segments, manifest files, and encryption keys (if enabled).', 'MediaPackageGroupSettings$Destination' => 'MediaPackage channel destination.', 'MsSmoothGroupSettings$Destination' => 'Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push" encoder to IIS.', 'MultiplexOutputSettings$Destination' => 'Destination is a Multiplex.', 'RtmpOutputSettings$Destination' => 'The RTMP endpoint excluding the stream name (eg. rtmp://host/appname). For connection to Akamai, a username and password must be supplied. URI fields accept format identifiers.', 'UdpOutputSettings$Destination' => 'Destination address and port number for RTP or UDP packets. Can be unicast or multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).', ], ], 'OutputSettings' => [ 'base' => 'Output Settings', 'refs' => [ 'Output$OutputSettings' => 'Output type-specific settings.', ], ], 'PassThroughSettings' => [ 'base' => 'Pass Through Settings', 'refs' => [ 'AudioCodecSettings$PassThroughSettings' => NULL, ], ], 'PauseStateScheduleActionSettings' => [ 'base' => 'Settings for the action to set pause state of a channel.', 'refs' => [ 'ScheduleActionSettings$PauseStateSettings' => 'Action to pause or unpause one or both channel pipelines', ], ], 'PipelineDetail' => [ 'base' => 'Runtime details of a pipeline when a channel is running.', 'refs' => [ '__listOfPipelineDetail$member' => NULL, ], ], 'PipelineId' => [ 'base' => 'Pipeline ID', 'refs' => [ 'PipelinePauseStateSettings$PipelineId' => 'Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").', ], ], 'PipelinePauseStateSettings' => [ 'base' => 'Settings for pausing a pipeline.', 'refs' => [ '__listOfPipelinePauseStateSettings$member' => NULL, ], ], 'PreferredChannelPipeline' => [ 'base' => 'Indicates which pipeline is preferred by the multiplex for program ingest.If set to \\"PIPELINE_0\\" or \\"PIPELINE_1\\" and an unhealthy ingest causes the multiplex to switch to the non-preferred pipeline,it will switch back once that ingest is healthy again. If set to \\"CURRENTLY_ACTIVE\\",it will not switch back to the other pipeline based on it recovering to a healthy state,it will only switch if the active pipeline becomes unhealthy.', 'refs' => [ 'MultiplexProgramSettings$PreferredChannelPipeline' => 'Indicates which pipeline is preferred by the multiplex for program ingest.', ], ], 'PurchaseOffering' => [ 'base' => 'PurchaseOffering request', 'refs' => [], ], 'PurchaseOfferingResultModel' => [ 'base' => 'PurchaseOffering response', 'refs' => [], ], 'RawSettings' => [ 'base' => 'Raw Settings', 'refs' => [ 'ArchiveContainerSettings$RawSettings' => NULL, ], ], 'RebootInputDevice' => [ 'base' => NULL, 'refs' => [], ], 'RebootInputDeviceForce' => [ 'base' => 'Whether or not to force reboot the input device.', 'refs' => [ 'RebootInputDevice$Force' => 'Force a reboot of an input device. If the device is streaming, it will stop streaming and begin rebooting within a few seconds of sending the command. If the device was streaming prior to the reboot, the device will resume streaming when the reboot completes.', ], ], 'Rec601Settings' => [ 'base' => 'Rec601 Settings', 'refs' => [ 'H264ColorSpaceSettings$Rec601Settings' => NULL, 'H265ColorSpaceSettings$Rec601Settings' => NULL, ], ], 'Rec709Settings' => [ 'base' => 'Rec709 Settings', 'refs' => [ 'H264ColorSpaceSettings$Rec709Settings' => NULL, 'H265ColorSpaceSettings$Rec709Settings' => NULL, ], ], 'RemixSettings' => [ 'base' => 'Remix Settings', 'refs' => [ 'AudioDescription$RemixSettings' => 'Settings that control how input audio channels are remixed into the output audio channels.', ], ], 'RenewalSettings' => [ 'base' => 'The Renewal settings for Reservations', 'refs' => [ 'PurchaseOffering$RenewalSettings' => 'Renewal settings for the reservation', 'Reservation$RenewalSettings' => 'Renewal settings for the reservation', 'UpdateReservation$RenewalSettings' => 'Renewal settings for the reservation', ], ], 'Reservation' => [ 'base' => 'Reserved resources available to use', 'refs' => [ 'PurchaseOfferingResultModel$Reservation' => NULL, 'UpdateReservationResultModel$Reservation' => NULL, '__listOfReservation$member' => NULL, ], ], 'ReservationAutomaticRenewal' => [ 'base' => 'Automatic Renewal Status for Reservation', 'refs' => [ 'RenewalSettings$AutomaticRenewal' => 'Automatic renewal status for the reservation', ], ], 'ReservationCodec' => [ 'base' => 'Codec, \'MPEG2\', \'AVC\', \'HEVC\', or \'AUDIO\'', 'refs' => [ 'ReservationResourceSpecification$Codec' => 'Codec, e.g. \'AVC\'', ], ], 'ReservationMaximumBitrate' => [ 'base' => 'Maximum bitrate in megabits per second', 'refs' => [ 'ReservationResourceSpecification$MaximumBitrate' => 'Maximum bitrate, e.g. \'MAX_20_MBPS\'', ], ], 'ReservationMaximumFramerate' => [ 'base' => 'Maximum framerate in frames per second (Outputs only)', 'refs' => [ 'ReservationResourceSpecification$MaximumFramerate' => 'Maximum framerate, e.g. \'MAX_30_FPS\' (Outputs only)', ], ], 'ReservationResolution' => [ 'base' => 'Resolution based on lines of vertical resolution; SD is less than 720 lines, HD is 720 to 1080 lines, FHD is 1080 lines, UHD is greater than 1080 lines', 'refs' => [ 'ReservationResourceSpecification$Resolution' => 'Resolution, e.g. \'HD\'', ], ], 'ReservationResourceSpecification' => [ 'base' => 'Resource configuration (codec, resolution, bitrate, ...)', 'refs' => [ 'Offering$ResourceSpecification' => 'Resource configuration details', 'Reservation$ResourceSpecification' => 'Resource configuration details', ], ], 'ReservationResourceType' => [ 'base' => 'Resource type, \'INPUT\', \'OUTPUT\', \'MULTIPLEX\', or \'CHANNEL\'', 'refs' => [ 'ReservationResourceSpecification$ResourceType' => 'Resource type, \'INPUT\', \'OUTPUT\', \'MULTIPLEX\', or \'CHANNEL\'', ], ], 'ReservationSpecialFeature' => [ 'base' => 'Special features, \'ADVANCED_AUDIO\' \'AUDIO_NORMALIZATION\' \'MGHD\' or \'MGUHD\'', 'refs' => [ 'ReservationResourceSpecification$SpecialFeature' => 'Special feature, e.g. \'AUDIO_NORMALIZATION\' (Channels only)', ], ], 'ReservationState' => [ 'base' => 'Current reservation state', 'refs' => [ 'Reservation$State' => 'Current state of reservation, e.g. \'ACTIVE\'', ], ], 'ReservationVideoQuality' => [ 'base' => 'Video quality, e.g. \'STANDARD\' (Outputs only)', 'refs' => [ 'ReservationResourceSpecification$VideoQuality' => 'Video quality, e.g. \'STANDARD\' (Outputs only)', ], ], 'ResourceConflict' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFound' => [ 'base' => NULL, 'refs' => [], ], 'RtmpAdMarkers' => [ 'base' => 'Rtmp Ad Markers', 'refs' => [ '__listOfRtmpAdMarkers$member' => NULL, ], ], 'RtmpCacheFullBehavior' => [ 'base' => 'Rtmp Cache Full Behavior', 'refs' => [ 'RtmpGroupSettings$CacheFullBehavior' => 'Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and does not accept content fast enough the \'Media Cache\' will fill up. When the cache reaches the duration specified by cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the RTMP output will force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If set to waitForServer, the RTMP output will wait up to 5 minutes to allow the origin server to begin accepting data again.', ], ], 'RtmpCaptionData' => [ 'base' => 'Rtmp Caption Data', 'refs' => [ 'RtmpGroupSettings$CaptionData' => 'Controls the types of data that passes to onCaptionInfo outputs. If set to \'all\' then 608 and 708 carried DTVCC data will be passed. If set to \'field1AndField2608\' then DTVCC data will be stripped out, but 608 data from both fields will be passed. If set to \'field1608\' then only the data carried in 608 from field 1 video will be passed.', ], ], 'RtmpCaptionInfoDestinationSettings' => [ 'base' => 'Rtmp Caption Info Destination Settings', 'refs' => [ 'CaptionDestinationSettings$RtmpCaptionInfoDestinationSettings' => NULL, ], ], 'RtmpGroupSettings' => [ 'base' => 'Rtmp Group Settings', 'refs' => [ 'OutputGroupSettings$RtmpGroupSettings' => NULL, ], ], 'RtmpOutputCertificateMode' => [ 'base' => 'Rtmp Output Certificate Mode', 'refs' => [ 'RtmpOutputSettings$CertificateMode' => 'If set to verifyAuthenticity, verify the tls certificate chain to a trusted Certificate Authority (CA). This will cause rtmps outputs with self-signed certificates to fail.', ], ], 'RtmpOutputSettings' => [ 'base' => 'Rtmp Output Settings', 'refs' => [ 'OutputSettings$RtmpOutputSettings' => NULL, ], ], 'S3CannedAcl' => [ 'base' => 'S3 Canned Acl', 'refs' => [ 'ArchiveS3Settings$CannedAcl' => 'Specify the canned ACL to apply to each S3 request. Defaults to none.', 'FrameCaptureS3Settings$CannedAcl' => 'Specify the canned ACL to apply to each S3 request. Defaults to none.', 'HlsS3Settings$CannedAcl' => 'Specify the canned ACL to apply to each S3 request. Defaults to none.', ], ], 'ScheduleAction' => [ 'base' => 'Contains information on a single schedule action.', 'refs' => [ '__listOfScheduleAction$member' => NULL, ], ], 'ScheduleActionSettings' => [ 'base' => 'Holds the settings for a single schedule action.', 'refs' => [ 'ScheduleAction$ScheduleActionSettings' => 'Settings for this schedule action.', ], ], 'ScheduleActionStartSettings' => [ 'base' => 'Settings to specify when an action should occur. Only one of the options must be selected.', 'refs' => [ 'ScheduleAction$ScheduleActionStartSettings' => 'The time for the action to start in the channel.', ], ], 'ScheduleDeleteResultModel' => [ 'base' => 'Result of a schedule deletion.', 'refs' => [], ], 'ScheduleDescribeResultModel' => [ 'base' => 'Results of a schedule describe.', 'refs' => [], ], 'Scte20Convert608To708' => [ 'base' => 'Scte20 Convert608 To708', 'refs' => [ 'Scte20SourceSettings$Convert608To708' => 'If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.', ], ], 'Scte20PlusEmbeddedDestinationSettings' => [ 'base' => 'Scte20 Plus Embedded Destination Settings', 'refs' => [ 'CaptionDestinationSettings$Scte20PlusEmbeddedDestinationSettings' => NULL, ], ], 'Scte20SourceSettings' => [ 'base' => 'Scte20 Source Settings', 'refs' => [ 'CaptionSelectorSettings$Scte20SourceSettings' => NULL, ], ], 'Scte27DestinationSettings' => [ 'base' => 'Scte27 Destination Settings', 'refs' => [ 'CaptionDestinationSettings$Scte27DestinationSettings' => NULL, ], ], 'Scte27OcrLanguage' => [ 'base' => 'Scte27 Ocr Language', 'refs' => [ 'Scte27SourceSettings$OcrLanguage' => 'If you will configure a WebVTT caption description that references this caption selector, use this field toprovide the language to consider when translating the image-based source to text.', ], ], 'Scte27SourceSettings' => [ 'base' => 'Scte27 Source Settings', 'refs' => [ 'CaptionSelectorSettings$Scte27SourceSettings' => NULL, ], ], 'Scte35AposNoRegionalBlackoutBehavior' => [ 'base' => 'Scte35 Apos No Regional Blackout Behavior', 'refs' => [ 'Scte35TimeSignalApos$NoRegionalBlackoutFlag' => 'When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger blackouts or Ad Avail slates', ], ], 'Scte35AposWebDeliveryAllowedBehavior' => [ 'base' => 'Scte35 Apos Web Delivery Allowed Behavior', 'refs' => [ 'Scte35TimeSignalApos$WebDeliveryAllowedFlag' => 'When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger blackouts or Ad Avail slates', ], ], 'Scte35ArchiveAllowedFlag' => [ 'base' => 'Corresponds to the archive_allowed parameter. A value of ARCHIVE_NOT_ALLOWED corresponds to 0 (false) in the SCTE-35 specification. If you include one of the "restriction" flags then you must include all four of them.', 'refs' => [ 'Scte35DeliveryRestrictions$ArchiveAllowedFlag' => 'Corresponds to SCTE-35 archive_allowed_flag.', ], ], 'Scte35DeliveryRestrictions' => [ 'base' => 'Corresponds to SCTE-35 delivery_not_restricted_flag parameter. To declare delivery restrictions, include this element and its four "restriction" flags. To declare that there are no restrictions, omit this element.', 'refs' => [ 'Scte35SegmentationDescriptor$DeliveryRestrictions' => 'Holds the four SCTE-35 delivery restriction parameters.', ], ], 'Scte35Descriptor' => [ 'base' => 'Holds one set of SCTE-35 Descriptor Settings.', 'refs' => [ '__listOfScte35Descriptor$member' => NULL, ], ], 'Scte35DescriptorSettings' => [ 'base' => 'SCTE-35 Descriptor settings.', 'refs' => [ 'Scte35Descriptor$Scte35DescriptorSettings' => 'SCTE-35 Descriptor Settings.', ], ], 'Scte35DeviceRestrictions' => [ 'base' => 'Corresponds to the device_restrictions parameter in a segmentation_descriptor. If you include one of the "restriction" flags then you must include all four of them.', 'refs' => [ 'Scte35DeliveryRestrictions$DeviceRestrictions' => 'Corresponds to SCTE-35 device_restrictions parameter.', ], ], 'Scte35NoRegionalBlackoutFlag' => [ 'base' => 'Corresponds to the no_regional_blackout_flag parameter. A value of REGIONAL_BLACKOUT corresponds to 0 (false) in the SCTE-35 specification. If you include one of the "restriction" flags then you must include all four of them.', 'refs' => [ 'Scte35DeliveryRestrictions$NoRegionalBlackoutFlag' => 'Corresponds to SCTE-35 no_regional_blackout_flag parameter.', ], ], 'Scte35ReturnToNetworkScheduleActionSettings' => [ 'base' => 'Settings for a SCTE-35 return_to_network message.', 'refs' => [ 'ScheduleActionSettings$Scte35ReturnToNetworkSettings' => 'Action to insert SCTE-35 return_to_network message', ], ], 'Scte35SegmentationCancelIndicator' => [ 'base' => 'Corresponds to SCTE-35 segmentation_event_cancel_indicator. SEGMENTATION_EVENT_NOT_CANCELED corresponds to 0 in the SCTE-35 specification and indicates that this is an insertion request. SEGMENTATION_EVENT_CANCELED corresponds to 1 in the SCTE-35 specification and indicates that this is a cancelation request, in which case complete this field and the existing event ID to cancel.', 'refs' => [ 'Scte35SegmentationDescriptor$SegmentationCancelIndicator' => 'Corresponds to SCTE-35 segmentation_event_cancel_indicator.', ], ], 'Scte35SegmentationDescriptor' => [ 'base' => 'Corresponds to SCTE-35 segmentation_descriptor.', 'refs' => [ 'Scte35DescriptorSettings$SegmentationDescriptorScte35DescriptorSettings' => 'SCTE-35 Segmentation Descriptor.', ], ], 'Scte35SpliceInsert' => [ 'base' => 'Scte35 Splice Insert', 'refs' => [ 'AvailSettings$Scte35SpliceInsert' => NULL, ], ], 'Scte35SpliceInsertNoRegionalBlackoutBehavior' => [ 'base' => 'Scte35 Splice Insert No Regional Blackout Behavior', 'refs' => [ 'Scte35SpliceInsert$NoRegionalBlackoutFlag' => 'When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0 will no longer trigger blackouts or Ad Avail slates', ], ], 'Scte35SpliceInsertScheduleActionSettings' => [ 'base' => 'Settings for a SCTE-35 splice_insert message.', 'refs' => [ 'ScheduleActionSettings$Scte35SpliceInsertSettings' => 'Action to insert SCTE-35 splice_insert message', ], ], 'Scte35SpliceInsertWebDeliveryAllowedBehavior' => [ 'base' => 'Scte35 Splice Insert Web Delivery Allowed Behavior', 'refs' => [ 'Scte35SpliceInsert$WebDeliveryAllowedFlag' => 'When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0 will no longer trigger blackouts or Ad Avail slates', ], ], 'Scte35TimeSignalApos' => [ 'base' => 'Scte35 Time Signal Apos', 'refs' => [ 'AvailSettings$Scte35TimeSignalApos' => NULL, ], ], 'Scte35TimeSignalScheduleActionSettings' => [ 'base' => 'Settings for a SCTE-35 time_signal.', 'refs' => [ 'ScheduleActionSettings$Scte35TimeSignalSettings' => 'Action to insert SCTE-35 time_signal message', ], ], 'Scte35WebDeliveryAllowedFlag' => [ 'base' => 'Corresponds to the web_delivery_allowed_flag parameter. A value of WEB_DELIVERY_NOT_ALLOWED corresponds to 0 (false) in the SCTE-35 specification. If you include one of the "restriction" flags then you must include all four of them.', 'refs' => [ 'Scte35DeliveryRestrictions$WebDeliveryAllowedFlag' => 'Corresponds to SCTE-35 web_delivery_allowed_flag parameter.', ], ], 'SmoothGroupAudioOnlyTimecodeControl' => [ 'base' => 'Smooth Group Audio Only Timecode Control', 'refs' => [ 'MsSmoothGroupSettings$AudioOnlyTimecodeControl' => 'If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the current timecode. This option does not write timecodes to the audio elementary stream.', ], ], 'SmoothGroupCertificateMode' => [ 'base' => 'Smooth Group Certificate Mode', 'refs' => [ 'MsSmoothGroupSettings$CertificateMode' => 'If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA). This will cause https outputs to self-signed certificates to fail.', ], ], 'SmoothGroupEventIdMode' => [ 'base' => 'Smooth Group Event Id Mode', 'refs' => [ 'MsSmoothGroupSettings$EventIdMode' => 'Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live Event is used without changing the publishing point, clients might see cached video from the previous run.Options:- "useConfigured" - use the value provided in eventId- "useTimestamp" - generate and send an event ID based on the current timestamp- "noEventId" - do not send an event ID to the IIS server.', ], ], 'SmoothGroupEventStopBehavior' => [ 'base' => 'Smooth Group Event Stop Behavior', 'refs' => [ 'MsSmoothGroupSettings$EventStopBehavior' => 'When set to sendEos, send EOS signal to IIS server when stopping the event', ], ], 'SmoothGroupSegmentationMode' => [ 'base' => 'Smooth Group Segmentation Mode', 'refs' => [ 'MsSmoothGroupSettings$SegmentationMode' => 'useInputSegmentation has been deprecated. The configured segment size is always used.', ], ], 'SmoothGroupSparseTrackType' => [ 'base' => 'Smooth Group Sparse Track Type', 'refs' => [ 'MsSmoothGroupSettings$SparseTrackType' => 'Identifies the type of data to place in the sparse track:- SCTE35: Insert SCTE-35 messages from the source content. With each message, insert an IDR frame to start a new segment.- SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35 messages from the source content. With each message, insert an IDR frame but don\'t start a new segment.- NONE: Don\'t generate a sparse track for any outputs in this output group.', ], ], 'SmoothGroupStreamManifestBehavior' => [ 'base' => 'Smooth Group Stream Manifest Behavior', 'refs' => [ 'MsSmoothGroupSettings$StreamManifestBehavior' => 'When set to send, send stream manifest so publishing point doesn\'t start until all streams start.', ], ], 'SmoothGroupTimestampOffsetMode' => [ 'base' => 'Smooth Group Timestamp Offset Mode', 'refs' => [ 'MsSmoothGroupSettings$TimestampOffsetMode' => 'Type of timestamp date offset to use.- useEventStartDate: Use the date the event was started as the offset- useConfiguredOffset: Use an explicitly configured date as the offset', ], ], 'Smpte2038DataPreference' => [ 'base' => 'Smpte2038 Data Preference', 'refs' => [ 'InputSettings$Smpte2038DataPreference' => 'Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable data types are captions, timecode, AFD, and SCTE-104 messages.- PREFER: Extract from SMPTE-2038 if present in this input, otherwise extract from another source (if any).- IGNORE: Never extract any ancillary data from SMPTE-2038.', ], ], 'SmpteTtDestinationSettings' => [ 'base' => 'Smpte Tt Destination Settings', 'refs' => [ 'CaptionDestinationSettings$SmpteTtDestinationSettings' => NULL, ], ], 'StandardHlsSettings' => [ 'base' => 'Standard Hls Settings', 'refs' => [ 'HlsSettings$StandardHlsSettings' => NULL, ], ], 'StartTimecode' => [ 'base' => 'Settings to identify the start of the clip.', 'refs' => [ 'InputClippingSettings$StartTimecode' => 'Settings to identify the start of the clip.', ], ], 'StaticImageActivateScheduleActionSettings' => [ 'base' => 'Settings for the action to activate a static image.', 'refs' => [ 'ScheduleActionSettings$StaticImageActivateSettings' => 'Action to activate a static image overlay', ], ], 'StaticImageDeactivateScheduleActionSettings' => [ 'base' => 'Settings for the action to deactivate the image in a specific layer.', 'refs' => [ 'ScheduleActionSettings$StaticImageDeactivateSettings' => 'Action to deactivate a static image overlay', ], ], 'StaticKeySettings' => [ 'base' => 'Static Key Settings', 'refs' => [ 'KeyProviderSettings$StaticKeySettings' => NULL, ], ], 'StopTimecode' => [ 'base' => 'Settings to identify the end of the clip.', 'refs' => [ 'InputClippingSettings$StopTimecode' => 'Settings to identify the end of the clip.', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'Channel$Tags' => 'A collection of key-value pairs.', 'ChannelSummary$Tags' => 'A collection of key-value pairs.', 'CreateChannel$Tags' => 'A collection of key-value pairs.', 'CreateInput$Tags' => 'A collection of key-value pairs.', 'CreateMultiplex$Tags' => 'A collection of key-value pairs.', 'CreatePartnerInput$Tags' => 'A collection of key-value pairs.', 'Input$Tags' => 'A collection of key-value pairs.', 'InputSecurityGroup$Tags' => 'A collection of key-value pairs.', 'InputSecurityGroupWhitelistRequest$Tags' => 'A collection of key-value pairs.', 'Multiplex$Tags' => 'A collection of key-value pairs.', 'MultiplexSummary$Tags' => 'A collection of key-value pairs.', 'PurchaseOffering$Tags' => 'A collection of key-value pairs', 'Reservation$Tags' => 'A collection of key-value pairs', 'TagsModel$Tags' => NULL, ], ], 'TagsModel' => [ 'base' => NULL, 'refs' => [], ], 'TeletextDestinationSettings' => [ 'base' => 'Teletext Destination Settings', 'refs' => [ 'CaptionDestinationSettings$TeletextDestinationSettings' => NULL, ], ], 'TeletextSourceSettings' => [ 'base' => 'Teletext Source Settings', 'refs' => [ 'CaptionSelectorSettings$TeletextSourceSettings' => NULL, ], ], 'TemporalFilterPostFilterSharpening' => [ 'base' => 'Temporal Filter Post Filter Sharpening', 'refs' => [ 'TemporalFilterSettings$PostFilterSharpening' => 'If you enable this filter, the results are the following:- If the source content is noisy (it contains excessive digital artifacts), the filter cleans up the source.- If the source content is already clean, the filter tends to decrease the bitrate, especially when the rate control mode is QVBR.', ], ], 'TemporalFilterSettings' => [ 'base' => 'Temporal Filter Settings', 'refs' => [ 'H264FilterSettings$TemporalFilterSettings' => NULL, 'H265FilterSettings$TemporalFilterSettings' => NULL, 'Mpeg2FilterSettings$TemporalFilterSettings' => NULL, ], ], 'TemporalFilterStrength' => [ 'base' => 'Temporal Filter Strength', 'refs' => [ 'TemporalFilterSettings$Strength' => 'Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good information, resulting in an image that is overly soft.', ], ], 'ThumbnailData' => [ 'base' => 'The binary data for the thumbnail that the Link device has most recently sent to MediaLive.', 'refs' => [], ], 'TimecodeConfig' => [ 'base' => 'Timecode Config', 'refs' => [ 'EncoderSettings$TimecodeConfig' => 'Contains settings used to acquire and adjust timecode information from inputs.', ], ], 'TimecodeConfigSource' => [ 'base' => 'Timecode Config Source', 'refs' => [ 'TimecodeConfig$Source' => 'Identifies the source for the timecode that will be associated with the events outputs.-Embedded (embedded): Initialize the output timecode with timecode from the the source. If no embedded timecode is detected in the source, the system falls back to using "Start at 0" (zerobased).-System Clock (systemclock): Use the UTC time.-Start at 0 (zerobased): The time of the first frame of the event will be 00:00:00:00.', ], ], 'TooManyRequestsException' => [ 'base' => NULL, 'refs' => [], ], 'TransferInputDevice' => [ 'base' => 'The transfer details of the input device.', 'refs' => [], ], 'TransferringInputDeviceSummary' => [ 'base' => 'Details about the input device that is being transferred.', 'refs' => [ '__listOfTransferringInputDeviceSummary$member' => NULL, ], ], 'TtmlDestinationSettings' => [ 'base' => 'Ttml Destination Settings', 'refs' => [ 'CaptionDestinationSettings$TtmlDestinationSettings' => NULL, ], ], 'TtmlDestinationStyleControl' => [ 'base' => 'Ttml Destination Style Control', 'refs' => [ 'TtmlDestinationSettings$StyleControl' => 'This field is not currently supported and will not affect the output styling. Leave the default value.', ], ], 'UdpContainerSettings' => [ 'base' => 'Udp Container Settings', 'refs' => [ 'UdpOutputSettings$ContainerSettings' => NULL, ], ], 'UdpGroupSettings' => [ 'base' => 'Udp Group Settings', 'refs' => [ 'OutputGroupSettings$UdpGroupSettings' => NULL, ], ], 'UdpOutputSettings' => [ 'base' => 'Udp Output Settings', 'refs' => [ 'OutputSettings$UdpOutputSettings' => NULL, ], ], 'UdpTimedMetadataId3Frame' => [ 'base' => 'Udp Timed Metadata Id3 Frame', 'refs' => [ 'UdpGroupSettings$TimedMetadataId3Frame' => 'Indicates ID3 frame that has the timecode.', ], ], 'UnprocessableEntityException' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannel' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelClass' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResultModel' => [ 'base' => 'The updated channel\'s description.', 'refs' => [], ], 'UpdateInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInputDevice' => [ 'base' => 'Updates an input device.', 'refs' => [], ], 'UpdateInputResultModel' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInputSecurityGroupResultModel' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMultiplex' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMultiplexProgram' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMultiplexProgramResultModel' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMultiplexResultModel' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReservation' => [ 'base' => 'UpdateReservation request', 'refs' => [], ], 'UpdateReservationResultModel' => [ 'base' => 'UpdateReservation response', 'refs' => [], ], 'ValidationError' => [ 'base' => NULL, 'refs' => [ '__listOfValidationError$member' => NULL, ], ], 'VideoBlackFailoverSettings' => [ 'base' => NULL, 'refs' => [ 'FailoverConditionSettings$VideoBlackSettings' => 'MediaLive will perform a failover if content is considered black for the specified period.', ], ], 'VideoCodecSettings' => [ 'base' => 'Video Codec Settings', 'refs' => [ 'VideoDescription$CodecSettings' => 'Video codec settings.', ], ], 'VideoDescription' => [ 'base' => 'Video settings for this stream.', 'refs' => [ '__listOfVideoDescription$member' => NULL, ], ], 'VideoDescriptionRespondToAfd' => [ 'base' => 'Video Description Respond To Afd', 'refs' => [ 'VideoDescription$RespondToAfd' => 'Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH.RESPOND: MediaLive clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the input display aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in the output, unless the codec for this encode is FRAME_CAPTURE.PASSTHROUGH: MediaLive ignores the AFD values and does not clip the video. But MediaLive does include the values in the output.NONE: MediaLive does not clip the input video and does not include the AFD values in the output', ], ], 'VideoDescriptionScalingBehavior' => [ 'base' => 'Video Description Scaling Behavior', 'refs' => [ 'VideoDescription$ScalingBehavior' => 'STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar boxes or letter boxes) around the video to provide the specified output resolution.', ], ], 'VideoSelector' => [ 'base' => 'Specifies a particular video stream within an input source. An input may have only a single video selector.', 'refs' => [ 'InputSettings$VideoSelector' => 'Informs which video elementary stream to decode for input types that have multiple available.', ], ], 'VideoSelectorColorSpace' => [ 'base' => 'Video Selector Color Space', 'refs' => [ 'VideoSelector$ColorSpace' => 'Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video description\'s colorSpaceSettingsChoice to determine if any conversion will be performed.', ], ], 'VideoSelectorColorSpaceSettings' => [ 'base' => 'Video Selector Color Space Settings', 'refs' => [ 'VideoSelector$ColorSpaceSettings' => 'Color space settings', ], ], 'VideoSelectorColorSpaceUsage' => [ 'base' => 'Video Selector Color Space Usage', 'refs' => [ 'VideoSelector$ColorSpaceUsage' => 'Applies only if colorSpace is a value other than follow. This field controls how the value in the colorSpace field will be used. fallback means that when the input does include color space data, that data will be used, but when the input has no color space data, the value in colorSpace will be used. Choose fallback if your input is sometimes missing color space data, but when it does have color space data, that data is correct. force means to always use the value in colorSpace. Choose force if your input usually has no color space data or might have unreliable color space data.', ], ], 'VideoSelectorPid' => [ 'base' => 'Video Selector Pid', 'refs' => [ 'VideoSelectorSettings$VideoSelectorPid' => NULL, ], ], 'VideoSelectorProgramId' => [ 'base' => 'Video Selector Program Id', 'refs' => [ 'VideoSelectorSettings$VideoSelectorProgramId' => NULL, ], ], 'VideoSelectorSettings' => [ 'base' => 'Video Selector Settings', 'refs' => [ 'VideoSelector$SelectorSettings' => 'The video selector settings.', ], ], 'VpcOutputSettings' => [ 'base' => 'The properties for a private VPC OutputWhen this property is specified, the output egress addresses will be created in a user specified VPC', 'refs' => [ 'CreateChannel$Vpc' => 'Settings for the VPC outputs', ], ], 'VpcOutputSettingsDescription' => [ 'base' => 'The properties for a private VPC Output', 'refs' => [ 'Channel$Vpc' => 'Settings for VPC output', 'ChannelSummary$Vpc' => 'Settings for any VPC outputs.', ], ], 'WavCodingMode' => [ 'base' => 'Wav Coding Mode', 'refs' => [ 'WavSettings$CodingMode' => 'The audio coding mode for the WAV audio. The mode determines the number of channels in the audio.', ], ], 'WavSettings' => [ 'base' => 'Wav Settings', 'refs' => [ 'AudioCodecSettings$WavSettings' => NULL, ], ], 'WebvttDestinationSettings' => [ 'base' => 'Webvtt Destination Settings', 'refs' => [ 'CaptionDestinationSettings$WebvttDestinationSettings' => NULL, ], ], 'WebvttDestinationStyleControl' => [ 'base' => 'Webvtt Destination Style Control', 'refs' => [ 'WebvttDestinationSettings$StyleControl' => 'Controls whether the color and position of the source captions is passed through to the WebVTT output captions. PASSTHROUGH - Valid only if the source captions are EMBEDDED or TELETEXT. NO_STYLE_DATA - Don\'t pass through the style. The output captions will not contain any font styling information.', ], ], '__boolean' => [ 'base' => NULL, 'refs' => [], ], '__double' => [ 'base' => NULL, 'refs' => [ 'AacSettings$Bitrate' => 'Average bitrate in bits/second. Valid values depend on rate control mode and profile.', 'AacSettings$SampleRate' => 'Sample rate in Hz. Valid values depend on rate control mode and profile.', 'Ac3Settings$Bitrate' => 'Average bitrate in bits/second. Valid bitrates depend on the coding mode.', 'Eac3Settings$Bitrate' => 'Average bitrate in bits/second. Valid bitrates depend on the coding mode.', 'Eac3Settings$LoRoCenterMixLevel' => 'Left only/Right only center mix level. Only used for 3/2 coding mode.', 'Eac3Settings$LoRoSurroundMixLevel' => 'Left only/Right only surround mix level. Only used for 3/2 coding mode.', 'Eac3Settings$LtRtCenterMixLevel' => 'Left total/Right total center mix level. Only used for 3/2 coding mode.', 'Eac3Settings$LtRtSurroundMixLevel' => 'Left total/Right total surround mix level. Only used for 3/2 coding mode.', 'H264Settings$GopSize' => 'GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1.If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.', 'H265Settings$GopSize' => 'GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1.If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.', 'InputDeviceHdSettings$Framerate' => 'The frame rate of the video source.', 'InputDeviceUhdSettings$Framerate' => 'The frame rate of the video source.', 'Mp2Settings$Bitrate' => 'Average bitrate in bits/second.', 'Mp2Settings$SampleRate' => 'Sample rate in Hz.', 'Mpeg2Settings$GopSize' => 'Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you do not know what GOP is, use the default.If gopSizeUnits is frames, then the gopSize must be an integer and must be greater than or equal to 1.If gopSizeUnits is seconds, the gopSize must be greater than 0, but does not need to be an integer.', 'Offering$FixedPrice' => 'One-time charge for each reserved resource, e.g. \'0.0\' for a NO_UPFRONT offering', 'Offering$UsagePrice' => 'Recurring usage charge for each reserved resource, e.g. \'157.0\'', 'Reservation$FixedPrice' => 'One-time charge for each reserved resource, e.g. \'0.0\' for a NO_UPFRONT offering', 'Reservation$UsagePrice' => 'Recurring usage charge for each reserved resource, e.g. \'157.0\'', 'WavSettings$BitDepth' => 'Bits per sample.', 'WavSettings$SampleRate' => 'Sample rate in Hz.', ], ], '__doubleMin0' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$FragmentTime' => 'The length in seconds of each fragment. Only used with EBP markers.', 'M2tsSettings$NullPacketBitrate' => 'Value in bits per second of extra null packets to insert into the transport stream. This can be used if a downstream encryption system requires periodic null packets.', ], ], '__doubleMin0Max1' => [ 'base' => NULL, 'refs' => [ 'VideoBlackFailoverSettings$BlackDetectThreshold' => 'A value used in calculating the threshold below which MediaLive considers a pixel to be \'black\'. For the input to be considered black, every pixel in a frame must be below this threshold. The threshold is calculated as a percentage (expressed as a decimal) of white. Therefore .1 means 10% white (or 90% black). Note how the formula works for any color depth. For example, if you set this field to 0.1 in 10-bit color depth: (1023*0.1=102.3), which means a pixel value of 102 or less is \'black\'. If you set this field to .1 in an 8-bit color depth: (255*0.1=25.5), which means a pixel value of 25 or less is \'black\'. The range is 0.0 to 1.0, with any number of decimal places.', ], ], '__doubleMin0Max100' => [ 'base' => NULL, 'refs' => [ 'CaptionRectangle$Height' => 'See the description in leftOffset.For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, \\"80\\" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less.This field corresponds to tts:extent - Y in the TTML standard.', 'CaptionRectangle$LeftOffset' => 'Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. (Make sure to leave the default if you don\'t have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages.If you specify a value for one of these fields, you must specify a value for all of them.For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, \\"10\\" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame.This field corresponds to tts:origin - X in the TTML standard.', 'CaptionRectangle$TopOffset' => 'See the description in leftOffset.For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, \\"10\\" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame.This field corresponds to tts:origin - Y in the TTML standard.', 'CaptionRectangle$Width' => 'See the description in leftOffset.For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, \\"80\\" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less.This field corresponds to tts:extent - X in the TTML standard.', ], ], '__doubleMin1' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$SegmentationTime' => 'The length in seconds of each segment. Required unless markers is set to _none_.', ], ], '__doubleMin1Max65535' => [ 'base' => NULL, 'refs' => [ 'NielsenNaesIiNw$Sid' => 'Enter the Nielsen Source ID (SID) to include in the watermark', ], ], '__doubleMinNegative59Max0' => [ 'base' => NULL, 'refs' => [ 'AudioNormalizationSettings$TargetLkfs' => 'Target LKFS(loudness) to adjust volume to. If no value is entered, a default value will be used according to the chosen algorithm. The CALM Act (1770-1) recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends a target of -23 LKFS.', ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'BurnInDestinationSettings$ShadowXOffset' => 'Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.', 'BurnInDestinationSettings$ShadowYOffset' => 'Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.', 'Channel$PipelinesRunningCount' => 'The number of currently healthy pipelines.', 'ChannelSummary$PipelinesRunningCount' => 'The number of currently healthy pipelines.', 'DvbSubDestinationSettings$ShadowXOffset' => 'Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$ShadowYOffset' => 'Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.', 'InputDeviceConfigurableSettings$MaxBitrate' => 'The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.', 'InputDeviceHdSettings$Height' => 'The height of the video source, in pixels.', 'InputDeviceHdSettings$MaxBitrate' => 'The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.', 'InputDeviceHdSettings$Width' => 'The width of the video source, in pixels.', 'InputDeviceUhdSettings$Height' => 'The height of the video source, in pixels.', 'InputDeviceUhdSettings$MaxBitrate' => 'The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.', 'InputDeviceUhdSettings$Width' => 'The width of the video source, in pixels.', 'Multiplex$PipelinesRunningCount' => 'The number of currently healthy pipelines.', 'Multiplex$ProgramCount' => 'The number of programs in the multiplex.', 'MultiplexProgramPacketIdentifiersMap$DvbTeletextPid' => NULL, 'MultiplexProgramPacketIdentifiersMap$EtvPlatformPid' => NULL, 'MultiplexProgramPacketIdentifiersMap$EtvSignalPid' => NULL, 'MultiplexProgramPacketIdentifiersMap$PcrPid' => NULL, 'MultiplexProgramPacketIdentifiersMap$PmtPid' => NULL, 'MultiplexProgramPacketIdentifiersMap$PrivateMetadataPid' => NULL, 'MultiplexProgramPacketIdentifiersMap$Scte35Pid' => NULL, 'MultiplexProgramPacketIdentifiersMap$TimedMetadataPid' => NULL, 'MultiplexProgramPacketIdentifiersMap$VideoPid' => NULL, 'MultiplexSummary$PipelinesRunningCount' => 'The number of currently healthy pipelines.', 'MultiplexSummary$ProgramCount' => 'The number of programs in the multiplex.', 'Offering$Duration' => 'Lease duration, e.g. \'12\'', 'Reservation$Count' => 'Number of reserved resources', 'Reservation$Duration' => 'Lease duration, e.g. \'12\'', 'VideoDescription$Height' => 'Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and width blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.', 'VideoDescription$Width' => 'Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and height blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.', '__listOf__integer$member' => NULL, ], ], '__integerMin0' => [ 'base' => NULL, 'refs' => [ 'BurnInDestinationSettings$XPosition' => 'Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal caption position will be determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.', 'BurnInDestinationSettings$YPosition' => 'Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the caption will be positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$XPosition' => 'Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal caption position will be determined by the alignment parameter. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$YPosition' => 'Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the caption will be positioned towards the bottom of the output. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'H264Settings$BufSize' => 'Size of buffer (HRD buffer model) in bits.', 'H264Settings$GopClosedCadence' => 'Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.', 'H265Settings$GopClosedCadence' => 'Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.', 'HlsAkamaiSettings$ConnectionRetryInterval' => 'Number of seconds to wait before retrying connection to the CDN if the connection is lost.', 'HlsAkamaiSettings$NumRetries' => 'Number of retry attempts that will be made before the Live Event is put into an error state.', 'HlsBasicPutSettings$ConnectionRetryInterval' => 'Number of seconds to wait before retrying connection to the CDN if the connection is lost.', 'HlsBasicPutSettings$NumRetries' => 'Number of retry attempts that will be made before the Live Event is put into an error state.', 'HlsGroupSettings$MinSegmentLength' => 'When set, minimumSegmentLength is enforced by looking ahead and back within the specified range for a nearby avail and extending the segment size if needed.', 'HlsGroupSettings$TimedMetadataId3Period' => 'Timed Metadata interval in seconds.', 'HlsGroupSettings$TimestampDeltaMilliseconds' => 'Provides an extra millisecond delta offset to fine tune the timestamps.', 'HlsInputSettings$Bandwidth' => 'When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be chosen, otherwise the highest bandwidth stream in the m3u8 will be chosen. The bitrate is specified in bits per second, as in an HLS manifest.', 'HlsInputSettings$BufferSegments' => 'When specified, reading of the HLS input will begin this many buffer segments from the end (most recently written segment). When not specified, the HLS input will begin with the first segment specified in the m3u8.', 'HlsInputSettings$Retries' => 'The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.', 'HlsInputSettings$RetryInterval' => 'The number of seconds between retries when an attempt to read a manifest or segment fails.', 'HlsMediaStoreSettings$ConnectionRetryInterval' => 'Number of seconds to wait before retrying connection to the CDN if the connection is lost.', 'HlsMediaStoreSettings$NumRetries' => 'Number of retry attempts that will be made before the Live Event is put into an error state.', 'HlsWebdavSettings$ConnectionRetryInterval' => 'Number of seconds to wait before retrying connection to the CDN if the connection is lost.', 'HlsWebdavSettings$NumRetries' => 'Number of retry attempts that will be made before the Live Event is put into an error state.', 'M2tsSettings$AudioFramesPerPes' => 'The number of audio frames to insert for each PES packet.', 'M2tsSettings$Bitrate' => 'The output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically determine the appropriate bitrate.', 'M3u8Settings$AudioFramesPerPes' => 'The number of audio frames to insert for each PES packet.', 'Mpeg2Settings$GopClosedCadence' => 'MPEG2: default is open GOP.', 'MsSmoothGroupSettings$ConnectionRetryInterval' => 'Number of seconds to wait before retrying connection to the IIS server if the connection is lost. Content will be cached during this time and the cache will be be delivered to the IIS server once the connection is re-established.', 'MsSmoothGroupSettings$FilecacheDuration' => 'Size in seconds of file cache for streaming outputs.', 'MsSmoothGroupSettings$NumRetries' => 'Number of retry attempts.', 'MsSmoothGroupSettings$RestartDelay' => 'Number of seconds before initiating a restart due to output failure, due to exhausting the numRetries on one segment, or exceeding filecacheDuration.', 'RtmpGroupSettings$RestartDelay' => 'If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never restart.', 'RtmpOutputSettings$NumRetries' => 'Number of retry attempts.', 'StaticImageActivateScheduleActionSettings$Duration' => 'The duration in milliseconds for the image to remain on the video. If omitted or set to 0 the duration is unlimited and the image will remain until it is explicitly deactivated.', 'StaticImageActivateScheduleActionSettings$FadeIn' => 'The time in milliseconds for the image to fade in. The fade-in starts at the start time of the overlay. Default is 0 (no fade-in).', 'StaticImageActivateScheduleActionSettings$FadeOut' => 'Applies only if a duration is specified. The time in milliseconds for the image to fade out. The fade-out starts when the duration time is hit, so it effectively extends the duration. Default is 0 (no fade-out).', 'StaticImageActivateScheduleActionSettings$ImageX' => 'Placement of the left edge of the overlay relative to the left edge of the video frame, in pixels. 0 (the default) is the left edge of the frame. If the placement causes the overlay to extend beyond the right edge of the underlying video, then the overlay is cropped on the right.', 'StaticImageActivateScheduleActionSettings$ImageY' => 'Placement of the top edge of the overlay relative to the top edge of the video frame, in pixels. 0 (the default) is the top edge of the frame. If the placement causes the overlay to extend beyond the bottom edge of the underlying video, then the overlay is cropped on the bottom.', 'StaticImageDeactivateScheduleActionSettings$FadeOut' => 'The time in milliseconds for the image to fade out. Default is 0 (no fade-out).', 'UdpGroupSettings$TimedMetadataId3Period' => 'Timed Metadata interval in seconds.', ], ], '__integerMin0Max10' => [ 'base' => NULL, 'refs' => [ 'BurnInDestinationSettings$OutlineSize' => 'Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$OutlineSize' => 'Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.', ], ], '__integerMin0Max100' => [ 'base' => NULL, 'refs' => [ 'H264Settings$BufFillPct' => 'Percentage of the buffer that should initially be filled (HRD buffer model).', 'StaticImageActivateScheduleActionSettings$Opacity' => 'Opacity of image where 0 is transparent and 100 is fully opaque. Default is 100.', 'VideoDescription$Sharpness' => 'Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the sharpest. A setting of 50 is recommended for most content.', ], ], '__integerMin0Max1000' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$PatInterval' => 'The number of milliseconds between instances of this table in the output transport stream. Valid values are 0, 10..1000.', 'M2tsSettings$PmtInterval' => 'The number of milliseconds between instances of this table in the output transport stream. Valid values are 0, 10..1000.', 'M3u8Settings$PatInterval' => 'The number of milliseconds between instances of this table in the output transport stream. A value of \\"0\\" writes out the PMT once per segment file.', 'M3u8Settings$PmtInterval' => 'The number of milliseconds between instances of this table in the output transport stream. A value of \\"0\\" writes out the PMT once per segment file.', ], ], '__integerMin0Max10000' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$EbpLookaheadMs' => 'When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by looking ahead at input video. If another EBP is going to come in within the specified time interval, the current EBP is not emitted, and the segment is "stretched" to the next marker. The lookahead value does not add latency to the system. The Live Event must be configured elsewhere to create sufficient latency to make the lookahead accurate.', 'MsSmoothGroupSettings$SendDelayMs' => 'Number of milliseconds to delay the output from the second pipeline.', 'UdpOutputSettings$BufferMsec' => 'UDP output buffering in milliseconds. Larger values increase latency through the transcoder but simultaneously assist the transcoder in maintaining a constant, low-jitter UDP/RTP output while accommodating clock recovery, input switching, input disruptions, picture reordering, etc.', ], ], '__integerMin0Max1000000' => [ 'base' => NULL, 'refs' => [ 'InputLossBehavior$BlackFrameMsec' => 'On input loss, the number of milliseconds to substitute black into the output before switching to the frame specified by inputLossImageType. A value x, where 0 <= x <= 1,000,000 and a value of 1,000,000 will be interpreted as infinite.', 'InputLossBehavior$RepeatFrameMsec' => 'On input loss, the number of milliseconds to repeat the previous picture before substituting black into the output. A value x, where 0 <= x <= 1,000,000 and a value of 1,000,000 will be interpreted as infinite.', ], ], '__integerMin0Max100000000' => [ 'base' => NULL, 'refs' => [ 'MultiplexSettings$TransportStreamReservedBitrate' => 'Transport stream reserved bit rate.', ], ], '__integerMin0Max128' => [ 'base' => NULL, 'refs' => [ 'H264Settings$Softness' => 'Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image. If not set to zero, must be greater than 15.', ], ], '__integerMin0Max15' => [ 'base' => NULL, 'refs' => [ 'HlsAkamaiSettings$RestartDelay' => 'If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never restart.', 'HlsBasicPutSettings$RestartDelay' => 'If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never restart.', 'HlsMediaStoreSettings$RestartDelay' => 'If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never restart.', 'HlsWebdavSettings$RestartDelay' => 'If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never restart.', 'InputChannelLevel$InputChannel' => 'The index of the input channel used as a source.', ], ], '__integerMin0Max255' => [ 'base' => NULL, 'refs' => [ 'BurnInDestinationSettings$BackgroundOpacity' => 'Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.', 'BurnInDestinationSettings$FontOpacity' => 'Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.', 'BurnInDestinationSettings$ShadowOpacity' => 'Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$BackgroundOpacity' => 'Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$FontOpacity' => 'Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$ShadowOpacity' => 'Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter blank is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.', 'Scte35SegmentationDescriptor$SegmentNum' => 'Corresponds to SCTE-35 segment_num. A value that is valid for the specified segmentation_type_id.', 'Scte35SegmentationDescriptor$SegmentationTypeId' => 'Corresponds to SCTE-35 segmentation_type_id. One of the segmentation_type_id values listed in the SCTE-35 specification. On the console, enter the ID in decimal (for example, "52"). In the CLI, API, or an SDK, enter the ID in hex (for example, "0x34") or decimal (for example, "52").', 'Scte35SegmentationDescriptor$SegmentationUpidType' => 'Corresponds to SCTE-35 segmentation_upid_type. On the console, enter one of the types listed in the SCTE-35 specification, converted to a decimal. For example, "0x0C" hex from the specification is "12" in decimal. In the CLI, API, or an SDK, enter one of the types listed in the SCTE-35 specification, in either hex (for example, "0x0C" ) or in decimal (for example, "12").', 'Scte35SegmentationDescriptor$SegmentsExpected' => 'Corresponds to SCTE-35 segments_expected. A value that is valid for the specified segmentation_type_id.', 'Scte35SegmentationDescriptor$SubSegmentNum' => 'Corresponds to SCTE-35 sub_segment_num. A value that is valid for the specified segmentation_type_id.', 'Scte35SegmentationDescriptor$SubSegmentsExpected' => 'Corresponds to SCTE-35 sub_segments_expected. A value that is valid for the specified segmentation_type_id.', ], ], '__integerMin0Max30' => [ 'base' => NULL, 'refs' => [ 'H264Settings$MinIInterval' => 'Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used. Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1', 'H265Settings$MinIInterval' => 'Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if multiplex rate control is used. Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1', ], ], '__integerMin0Max32768' => [ 'base' => NULL, 'refs' => [ 'Hdr10Settings$MaxCll' => 'Maximum Content Light LevelAn integer metadata value defining the maximum light level, in nits,of any single pixel within an encoded HDR video stream or file.', 'Hdr10Settings$MaxFall' => 'Maximum Frame Average Light LevelAn integer metadata value defining the maximum average light level, in nits,for any single frame within an encoded HDR video stream or file.', ], ], '__integerMin0Max3600' => [ 'base' => NULL, 'refs' => [ 'HlsGroupSettings$ProgramDateTimePeriod' => 'Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.', ], ], '__integerMin0Max500' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$PcrPeriod' => 'Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.', 'M3u8Settings$PcrPeriod' => 'Maximum time in milliseconds between Program Clock References (PCRs) inserted into the transport stream.', ], ], '__integerMin0Max600' => [ 'base' => NULL, 'refs' => [ 'HlsAkamaiSettings$FilecacheDuration' => 'Size in seconds of file cache for streaming outputs.', 'HlsBasicPutSettings$FilecacheDuration' => 'Size in seconds of file cache for streaming outputs.', 'HlsMediaStoreSettings$FilecacheDuration' => 'Size in seconds of file cache for streaming outputs.', 'HlsWebdavSettings$FilecacheDuration' => 'Size in seconds of file cache for streaming outputs.', ], ], '__integerMin0Max65535' => [ 'base' => NULL, 'refs' => [ 'M2tsSettings$ProgramNum' => 'The value of the program number field in the Program Map Table.', 'M2tsSettings$TransportStreamId' => 'The value of the transport stream ID field in the Program Map Table.', 'M3u8Settings$ProgramNum' => 'The value of the program number field in the Program Map Table.', 'M3u8Settings$TransportStreamId' => 'The value of the transport stream ID field in the Program Map Table.', 'MultiplexProgramSettings$ProgramNumber' => 'Unique program number.', 'MultiplexSettings$TransportStreamId' => 'Transport stream ID.', ], ], '__integerMin0Max65536' => [ 'base' => NULL, 'refs' => [ 'DvbNitSettings$NetworkId' => 'The numeric value placed in the Network Information Table (NIT).', 'VideoSelectorProgramId$ProgramId' => 'Selects a specific program from within a multi-program transport stream. If the program doesn\'t exist, the first program within the transport stream will be selected by default.', ], ], '__integerMin0Max7' => [ 'base' => NULL, 'refs' => [ 'AudioChannelMapping$OutputChannel' => 'The index of the output channel being produced.', 'H264Settings$GopNumBFrames' => 'Number of B-frames between reference frames.', 'Mpeg2Settings$GopNumBFrames' => 'Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a B-frame is, use the default.', 'StaticImageActivateScheduleActionSettings$Layer' => 'The number of the layer, 0 to 7. There are 8 layers that can be overlaid on the video, each layer with a different image. The layers are in Z order, which means that overlays with higher values of layer are inserted on top of overlays with lower values of layer. Default is 0.', 'StaticImageDeactivateScheduleActionSettings$Layer' => 'The image overlay layer to deactivate, 0 to 7. Default is 0.', ], ], '__integerMin0Max8191' => [ 'base' => NULL, 'refs' => [ 'AudioPidSelection$Pid' => 'Selects a specific PID from within a source.', 'VideoSelectorPid$Pid' => 'Selects a specific PID from within a video source.', ], ], '__integerMin1' => [ 'base' => NULL, 'refs' => [ 'ArchiveGroupSettings$RolloverInterval' => 'Number of seconds to write to archive file before closing and starting a new one.', 'AudioTrack$Track' => '1-based integer value that maps to a specific audio track', 'AutomaticInputFailoverSettings$ErrorClearTimeMsec' => 'This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.', 'DvbSubSourceSettings$Pid' => 'When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.', 'H264Settings$FramerateDenominator' => 'Framerate denominator.', 'H264Settings$FramerateNumerator' => 'Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.', 'H264Settings$ParDenominator' => 'Pixel Aspect Ratio denominator.', 'H264Settings$ParNumerator' => 'Pixel Aspect Ratio numerator.', 'H265Settings$FramerateNumerator' => 'Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.', 'H265Settings$ParDenominator' => 'Pixel Aspect Ratio denominator.', 'H265Settings$ParNumerator' => 'Pixel Aspect Ratio numerator.', 'HlsGroupSettings$KeepSegments' => 'Applies only if Mode field is LIVE.Specifies the number of media segments to retain in the destination directory. This number should be bigger than indexNSegments (Num segments). We recommend (value = (2 x indexNsegments) + 1).If this "keep segments" number is too low, the following might happen: the player is still reading a media manifest file that lists this segment, but that segment has been removed from the destination directory (as directed by indexNSegments). This situation would result in a 404 HTTP error on the player.', 'HlsGroupSettings$SegmentLength' => 'Length of MPEG-2 Transport Stream segments to create (in seconds). Note that segments will end on the next keyframe after this number of seconds, so actual segment length may be longer.', 'HlsGroupSettings$SegmentsPerSubdirectory' => 'Number of segments to write to a subdirectory before starting a new one. directoryStructure must be subdirectoryPerStream for this setting to have an effect.', 'Mpeg2Settings$FramerateDenominator' => 'description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.', 'Mpeg2Settings$FramerateNumerator' => 'The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.', 'MsSmoothGroupSettings$FragmentLength' => 'Length of mp4 fragments to generate (in seconds). Fragment length must be compatible with GOP size and framerate.', 'PurchaseOffering$Count' => 'Number of resources', 'RenewalSettings$RenewalCount' => 'Count for the reservation renewal', 'RtmpOutputSettings$ConnectionRetryInterval' => 'Number of seconds to wait before retrying a connection to the Flash Media server if the connection is lost.', 'Scte27SourceSettings$Pid' => 'The pid field is used in conjunction with the caption selector languageCode field as follows: - Specify PID and Language: Extracts captions from that PID; the language is "informational". - Specify PID and omit Language: Extracts the specified PID. - Omit PID and specify Language: Extracts the specified language, whichever PID that happens to be. - Omit PID and omit Language: Valid only if source is DVB-Sub that is being passed through; all languages will be passed through.', 'StaticImageActivateScheduleActionSettings$Height' => 'The height of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the specified height. Leave blank to use the native height of the overlay.', 'StaticImageActivateScheduleActionSettings$Width' => 'The width of the image when inserted into the video, in pixels. The overlay will be scaled up or down to the specified width. Leave blank to use the native width of the overlay.', ], ], '__integerMin100' => [ 'base' => NULL, 'refs' => [ 'InputLossFailoverSettings$InputLossThresholdMsec' => 'The amount of time (in milliseconds) that no input is detected. After that time, an input failover will occur.', ], ], '__integerMin1000' => [ 'base' => NULL, 'refs' => [ 'AudioSilenceFailoverSettings$AudioSilenceThresholdMsec' => 'The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.', 'H264Settings$Bitrate' => 'Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.', 'H264Settings$MaxBitrate' => 'For QVBR: See the tooltip for Quality levelFor VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.', 'VideoBlackFailoverSettings$VideoBlackThresholdMsec' => 'The amount of time (in milliseconds) that the active input must be black before automatic input failover occurs.', ], ], '__integerMin1000000Max100000000' => [ 'base' => NULL, 'refs' => [ 'MultiplexSettings$TransportStreamBitrate' => 'Transport stream bit rate.', 'MultiplexSettingsSummary$TransportStreamBitrate' => 'Transport stream bit rate.', ], ], '__integerMin100000Max100000000' => [ 'base' => NULL, 'refs' => [ 'MultiplexStatmuxVideoSettings$MaximumBitrate' => 'Maximum statmux bitrate.', 'MultiplexStatmuxVideoSettings$MinimumBitrate' => 'Minimum statmux bitrate.', 'MultiplexVideoSettings$ConstantBitrate' => 'The constant bitrate configuration for the video encode.When this field is defined, StatmuxSettings must be undefined.', ], ], '__integerMin100000Max40000000' => [ 'base' => NULL, 'refs' => [ 'H265Settings$Bitrate' => 'Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.', 'H265Settings$MaxBitrate' => 'For QVBR: See the tooltip for Quality level', ], ], '__integerMin100000Max80000000' => [ 'base' => NULL, 'refs' => [ 'H265Settings$BufSize' => 'Size of buffer (HRD buffer model) in bits.', ], ], '__integerMin1000Max30000' => [ 'base' => NULL, 'refs' => [ 'DvbTdtSettings$RepInterval' => 'The number of milliseconds between instances of this table in the output transport stream.', ], ], '__integerMin1Max10' => [ 'base' => NULL, 'refs' => [ 'H264Settings$QvbrQualityLevel' => 'Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You can set a target quality or you can let MediaLive determine the best quality. To set a target quality, enter values in the QVBR quality level field and the Max bitrate field. Enter values that suit your most important viewing devices. Recommended values are:- Primary screen: Quality level: 8 to 10. Max bitrate: 4M- PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M- Smartphone: Quality level: 6. Max bitrate: 1M to 1.5MTo let MediaLive decide, leave the QVBR quality level field empty, and in Max bitrate enter the maximum rate you want in the video. For more information, see the section called "Video - rate control mode" in the MediaLive user guide', 'H265Settings$QvbrQualityLevel' => 'Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. Set values for the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended values are:- Primary screen: Quality level: 8 to 10. Max bitrate: 4M- PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M- Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M', ], ], '__integerMin1Max1000000' => [ 'base' => NULL, 'refs' => [ 'TimecodeConfig$SyncThreshold' => 'Threshold in frames beyond which output timecode is resynchronized to the input timecode. Discrepancies below this threshold are permitted to avoid unnecessary discontinuities in the output timecode. No timecode sync when this is not specified.', ], ], '__integerMin1Max16' => [ 'base' => NULL, 'refs' => [ 'H265Settings$Slices' => 'Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.', 'RemixSettings$ChannelsIn' => 'Number of input channels to be used.', ], ], '__integerMin1Max20' => [ 'base' => NULL, 'refs' => [ 'FecOutputSettings$RowLength' => 'Parameter L from SMPTE 2022-1. The width of the FEC protection matrix. Must be between 1 and 20, inclusive. If only Column FEC is used, then larger values increase robustness. If Row FEC is used, then this is the number of transport stream packets per row error correction packet, and the value must be between 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column, this value must be 1 to 20, inclusive.', ], ], '__integerMin1Max3003' => [ 'base' => NULL, 'refs' => [ 'H265Settings$FramerateDenominator' => 'Framerate denominator.', ], ], '__integerMin1Max31' => [ 'base' => NULL, 'refs' => [ 'Ac3Settings$Dialnorm' => 'Sets the dialnorm for the output. If excluded and input audio is Dolby Digital, dialnorm will be passed through.', 'Eac3Settings$Dialnorm' => 'Sets the dialnorm for the output. If blank and input audio is Dolby Digital Plus, dialnorm will be passed through.', ], ], '__integerMin1Max32' => [ 'base' => NULL, 'refs' => [ 'H264Settings$Slices' => 'Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.', ], ], '__integerMin1Max3600000' => [ 'base' => NULL, 'refs' => [ 'FrameCaptureSettings$CaptureInterval' => 'The frequency at which to capture frames for inclusion in the output. May be specified in either seconds or milliseconds, as specified by captureIntervalUnits.', ], ], '__integerMin1Max4' => [ 'base' => NULL, 'refs' => [ 'AncillarySourceSettings$SourceAncillaryChannelNumber' => 'Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions. If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.', 'CaptionLanguageMapping$CaptionChannel' => 'The closed caption channel being described by this CaptionLanguageMapping. Each channel mapping must have a unique channel number (maximum of 4)', 'EmbeddedSourceSettings$Source608ChannelNumber' => 'Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.', 'Scte20SourceSettings$Source608ChannelNumber' => 'Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.', ], ], '__integerMin1Max5' => [ 'base' => NULL, 'refs' => [ 'EmbeddedSourceSettings$Source608TrackNumber' => 'This field is unused and deprecated.', 'InputSettings$FilterStrength' => 'Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).', ], ], '__integerMin1Max6' => [ 'base' => NULL, 'refs' => [ 'H264Settings$NumRefFrames' => 'Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.', ], ], '__integerMin1Max8' => [ 'base' => NULL, 'refs' => [ 'RemixSettings$ChannelsOut' => 'Number of output channels to be produced.Valid values: 1, 2, 4, 6, 8', ], ], '__integerMin25Max10000' => [ 'base' => NULL, 'refs' => [ 'DvbNitSettings$RepInterval' => 'The number of milliseconds between instances of this table in the output transport stream.', ], ], '__integerMin25Max2000' => [ 'base' => NULL, 'refs' => [ 'DvbSdtSettings$RepInterval' => 'The number of milliseconds between instances of this table in the output transport stream.', ], ], '__integerMin3' => [ 'base' => NULL, 'refs' => [ 'HlsGroupSettings$IndexNSegments' => 'Applies only if Mode field is LIVE.Specifies the maximum number of segments in the media manifest file. After this maximum, older segments are removed from the media manifest. This number must be smaller than the number in the Keep Segments field.', ], ], '__integerMin30' => [ 'base' => NULL, 'refs' => [ 'RtmpGroupSettings$CacheLength' => 'Cache length, in seconds, is used to calculate buffer size.', ], ], '__integerMin32Max8191' => [ 'base' => NULL, 'refs' => [ 'InputSettings$Scte35Pid' => 'PID from which to read SCTE-35 messages. If left undefined, EML will select the first SCTE-35 PID found in the input.', ], ], '__integerMin4Max20' => [ 'base' => NULL, 'refs' => [ 'FecOutputSettings$ColumnDepth' => 'Parameter D from SMPTE 2022-1. The height of the FEC protection matrix. The number of transport stream packets per column error correction packet. Must be between 4 and 20, inclusive.', ], ], '__integerMin800Max3000' => [ 'base' => NULL, 'refs' => [ 'MultiplexSettings$MaximumVideoBufferDelayMilliseconds' => 'Maximum video buffer delay in milliseconds.', ], ], '__integerMin96Max600' => [ 'base' => NULL, 'refs' => [ 'BurnInDestinationSettings$FontResolution' => 'Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must match.', 'DvbSubDestinationSettings$FontResolution' => 'Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must match.', ], ], '__integerMinNegative1000Max1000' => [ 'base' => NULL, 'refs' => [ 'Scte35SpliceInsert$AdAvailOffset' => 'When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only applies to embedded SCTE 104/35 messages and does not apply to OOB messages.', 'Scte35TimeSignalApos$AdAvailOffset' => 'When specified, this offset (in milliseconds) is added to the input Ad Avail PTS time. This only applies to embedded SCTE 104/35 messages and does not apply to OOB messages.', ], ], '__integerMinNegative5Max5' => [ 'base' => NULL, 'refs' => [ 'MultiplexStatmuxVideoSettings$Priority' => 'The purpose of the priority is to use a combination of the\\nmultiplex rate control algorithm and the QVBR capability of the\\nencoder to prioritize the video quality of some channels in a\\nmultiplex over others. Channels that have a higher priority will\\nget higher video quality at the expense of the video quality of\\nother channels in the multiplex with lower priority.', ], ], '__integerMinNegative60Max6' => [ 'base' => NULL, 'refs' => [ 'InputChannelLevel$Gain' => 'Remixing value. Units are in dB and acceptable values are within the range from -60 (mute) and 6 dB.', ], ], '__integerMinNegative60Max60' => [ 'base' => NULL, 'refs' => [ 'GlobalConfiguration$InitialAudioGain' => 'Value to set the initial audio gain for the Live Event.', ], ], '__listOfAudioChannelMapping' => [ 'base' => NULL, 'refs' => [ 'RemixSettings$ChannelMappings' => 'Mapping of input channels to output channels, with appropriate gain adjustments.', ], ], '__listOfAudioDescription' => [ 'base' => NULL, 'refs' => [ 'EncoderSettings$AudioDescriptions' => NULL, ], ], '__listOfAudioSelector' => [ 'base' => NULL, 'refs' => [ 'InputSettings$AudioSelectors' => 'Used to select the audio stream to decode for inputs that have multiple available.', ], ], '__listOfAudioTrack' => [ 'base' => NULL, 'refs' => [ 'AudioTrackSelection$Tracks' => 'Selects one or more unique audio tracks from within a source.', ], ], '__listOfBatchFailedResultModel' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteResultModel$Failed' => 'List of failed operations', 'BatchStartResultModel$Failed' => 'List of failed operations', 'BatchStopResultModel$Failed' => 'List of failed operations', ], ], '__listOfBatchSuccessfulResultModel' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteResultModel$Successful' => 'List of successful operations', 'BatchStartResultModel$Successful' => 'List of successful operations', 'BatchStopResultModel$Successful' => 'List of successful operations', ], ], '__listOfCaptionDescription' => [ 'base' => NULL, 'refs' => [ 'EncoderSettings$CaptionDescriptions' => 'Settings for caption decriptions', ], ], '__listOfCaptionLanguageMapping' => [ 'base' => NULL, 'refs' => [ 'HlsGroupSettings$CaptionLanguageMappings' => 'Mapping of up to 4 caption channels to caption languages. Is only meaningful if captionLanguageSetting is set to "insert".', ], ], '__listOfCaptionSelector' => [ 'base' => NULL, 'refs' => [ 'InputSettings$CaptionSelectors' => 'Used to select the caption input to use for inputs that have multiple available.', ], ], '__listOfChannelEgressEndpoint' => [ 'base' => NULL, 'refs' => [ 'Channel$EgressEndpoints' => 'The endpoints where outgoing connections initiate from', 'ChannelSummary$EgressEndpoints' => 'The endpoints where outgoing connections initiate from', ], ], '__listOfChannelSummary' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResultModel$Channels' => NULL, ], ], '__listOfFailoverCondition' => [ 'base' => NULL, 'refs' => [ 'AutomaticInputFailoverSettings$FailoverConditions' => 'A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input.', ], ], '__listOfHlsAdMarkers' => [ 'base' => NULL, 'refs' => [ 'HlsGroupSettings$AdMarkers' => 'Choose one or more ad marker types to pass SCTE35 signals through to this group of Apple HLS outputs.', ], ], '__listOfInput' => [ 'base' => NULL, 'refs' => [ 'ListInputsResultModel$Inputs' => NULL, ], ], '__listOfInputAttachment' => [ 'base' => NULL, 'refs' => [ 'Channel$InputAttachments' => 'List of input attachments for channel.', 'ChannelSummary$InputAttachments' => 'List of input attachments for channel.', 'CreateChannel$InputAttachments' => 'List of input attachments for channel.', 'UpdateChannel$InputAttachments' => NULL, ], ], '__listOfInputChannelLevel' => [ 'base' => NULL, 'refs' => [ 'AudioChannelMapping$InputChannelLevels' => 'Indices and gain values for each input channel that should be remixed into this output channel.', ], ], '__listOfInputDestination' => [ 'base' => NULL, 'refs' => [ 'Input$Destinations' => 'A list of the destinations of the input (PUSH-type).', ], ], '__listOfInputDestinationRequest' => [ 'base' => NULL, 'refs' => [ 'CreateInput$Destinations' => 'Destination settings for PUSH type inputs.', 'UpdateInput$Destinations' => 'Destination settings for PUSH type inputs.', ], ], '__listOfInputDeviceRequest' => [ 'base' => NULL, 'refs' => [ 'UpdateInput$InputDevices' => 'Settings for the devices.', ], ], '__listOfInputDeviceSettings' => [ 'base' => NULL, 'refs' => [ 'CreateInput$InputDevices' => 'Settings for the devices.', 'Input$InputDevices' => 'Settings for the input devices.', ], ], '__listOfInputDeviceSummary' => [ 'base' => NULL, 'refs' => [ 'ListInputDevicesResultModel$InputDevices' => 'The list of input devices.', ], ], '__listOfInputSecurityGroup' => [ 'base' => NULL, 'refs' => [ 'ListInputSecurityGroupsResultModel$InputSecurityGroups' => 'List of input security groups', ], ], '__listOfInputSource' => [ 'base' => NULL, 'refs' => [ 'Input$Sources' => 'A list of the sources of the input (PULL-type).', ], ], '__listOfInputSourceRequest' => [ 'base' => NULL, 'refs' => [ 'CreateInput$Sources' => 'The source URLs for a PULL-type input. Every PULL type input needsexactly two source URLs for redundancy.Only specify sources for PULL type Inputs. Leave Destinations empty.', 'UpdateInput$Sources' => 'The source URLs for a PULL-type input. Every PULL type input needsexactly two source URLs for redundancy.Only specify sources for PULL type Inputs. Leave Destinations empty.', ], ], '__listOfInputWhitelistRule' => [ 'base' => NULL, 'refs' => [ 'InputSecurityGroup$WhitelistRules' => 'Whitelist rules and their sync status', ], ], '__listOfInputWhitelistRuleCidr' => [ 'base' => NULL, 'refs' => [ 'InputSecurityGroupWhitelistRequest$WhitelistRules' => 'List of IPv4 CIDR addresses to whitelist', ], ], '__listOfMediaConnectFlow' => [ 'base' => NULL, 'refs' => [ 'Input$MediaConnectFlows' => 'A list of MediaConnect Flows for this input.', ], ], '__listOfMediaConnectFlowRequest' => [ 'base' => NULL, 'refs' => [ 'CreateInput$MediaConnectFlows' => 'A list of the MediaConnect Flows that you want to use in this input. You can specify as few as oneFlow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in aseparate Availability Zone as this ensures your EML input is redundant to AZ issues.', 'UpdateInput$MediaConnectFlows' => 'A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as oneFlow and presently, as many as two. The only requirement is when you have more than one is that each Flow is in aseparate Availability Zone as this ensures your EML input is redundant to AZ issues.', ], ], '__listOfMediaPackageOutputDestinationSettings' => [ 'base' => NULL, 'refs' => [ 'OutputDestination$MediaPackageSettings' => 'Destination settings for a MediaPackage output; one destination for both encoders.', ], ], '__listOfMultiplexOutputDestination' => [ 'base' => NULL, 'refs' => [ 'Multiplex$Destinations' => 'A list of the multiplex output destinations.', ], ], '__listOfMultiplexProgramPipelineDetail' => [ 'base' => NULL, 'refs' => [ 'MultiplexProgram$PipelineDetails' => 'Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.', ], ], '__listOfMultiplexProgramSummary' => [ 'base' => NULL, 'refs' => [ 'ListMultiplexProgramsResultModel$MultiplexPrograms' => 'List of multiplex programs.', ], ], '__listOfMultiplexSummary' => [ 'base' => NULL, 'refs' => [ 'ListMultiplexesResultModel$Multiplexes' => 'List of multiplexes.', ], ], '__listOfOffering' => [ 'base' => NULL, 'refs' => [ 'ListOfferingsResultModel$Offerings' => 'List of offerings', ], ], '__listOfOutput' => [ 'base' => NULL, 'refs' => [ 'OutputGroup$Outputs' => NULL, ], ], '__listOfOutputDestination' => [ 'base' => NULL, 'refs' => [ 'Channel$Destinations' => 'A list of destinations of the channel. For UDP outputs, there is onedestination per output. For other types (HLS, for example), there isone destination per packager.', 'ChannelSummary$Destinations' => 'A list of destinations of the channel. For UDP outputs, there is onedestination per output. For other types (HLS, for example), there isone destination per packager.', 'CreateChannel$Destinations' => NULL, 'UpdateChannel$Destinations' => 'A list of output destinations for this channel.', 'UpdateChannelClass$Destinations' => 'A list of output destinations for this channel.', ], ], '__listOfOutputDestinationSettings' => [ 'base' => NULL, 'refs' => [ 'OutputDestination$Settings' => 'Destination settings for a standard output; one destination for each redundant encoder.', ], ], '__listOfOutputGroup' => [ 'base' => NULL, 'refs' => [ 'EncoderSettings$OutputGroups' => NULL, ], ], '__listOfPipelineDetail' => [ 'base' => NULL, 'refs' => [ 'Channel$PipelineDetails' => 'Runtime details for the pipelines of a running channel.', ], ], '__listOfPipelinePauseStateSettings' => [ 'base' => NULL, 'refs' => [ 'PauseStateScheduleActionSettings$Pipelines' => NULL, ], ], '__listOfReservation' => [ 'base' => NULL, 'refs' => [ 'ListReservationsResultModel$Reservations' => 'List of reservations', ], ], '__listOfRtmpAdMarkers' => [ 'base' => NULL, 'refs' => [ 'RtmpGroupSettings$AdMarkers' => 'Choose the ad marker type for this output group. MediaLive will create a message based on the content of each SCTE-35 message, format it for that marker type, and insert it in the datastream.', ], ], '__listOfScheduleAction' => [ 'base' => NULL, 'refs' => [ 'BatchScheduleActionCreateRequest$ScheduleActions' => 'A list of schedule actions to create.', 'BatchScheduleActionCreateResult$ScheduleActions' => 'List of actions that have been created in the schedule.', 'BatchScheduleActionDeleteResult$ScheduleActions' => 'List of actions that have been deleted from the schedule.', 'ScheduleDescribeResultModel$ScheduleActions' => 'The list of actions in the schedule.', ], ], '__listOfScte35Descriptor' => [ 'base' => NULL, 'refs' => [ 'Scte35TimeSignalScheduleActionSettings$Scte35Descriptors' => 'The list of SCTE-35 descriptors accompanying the SCTE-35 time_signal.', ], ], '__listOfTransferringInputDeviceSummary' => [ 'base' => NULL, 'refs' => [ 'ListInputDeviceTransfersResultModel$InputDeviceTransfers' => 'The list of devices that you are transferring or are being transferred to you.', ], ], '__listOfValidationError' => [ 'base' => NULL, 'refs' => [ 'ChannelConfigurationValidationError$ValidationErrors' => 'A collection of validation error responses.', 'InputDeviceConfigurationValidationError$ValidationErrors' => 'A collection of validation error responses.', 'MultiplexConfigurationValidationError$ValidationErrors' => 'A collection of validation error responses.', ], ], '__listOfVideoDescription' => [ 'base' => NULL, 'refs' => [ 'EncoderSettings$VideoDescriptions' => NULL, ], ], '__listOf__integer' => [ 'base' => NULL, 'refs' => [ 'MultiplexProgramPacketIdentifiersMap$AudioPids' => NULL, 'MultiplexProgramPacketIdentifiersMap$DvbSubPids' => NULL, 'MultiplexProgramPacketIdentifiersMap$KlvDataPids' => NULL, 'MultiplexProgramPacketIdentifiersMap$Scte27Pids' => NULL, ], ], '__listOf__string' => [ 'base' => NULL, 'refs' => [ 'BatchDelete$ChannelIds' => 'List of channel IDs', 'BatchDelete$InputIds' => 'List of input IDs', 'BatchDelete$InputSecurityGroupIds' => 'List of input security group IDs', 'BatchDelete$MultiplexIds' => 'List of multiplex IDs', 'BatchScheduleActionDeleteRequest$ActionNames' => 'A list of schedule actions to delete.', 'BatchStart$ChannelIds' => 'List of channel IDs', 'BatchStart$MultiplexIds' => 'List of multiplex IDs', 'BatchStop$ChannelIds' => 'List of channel IDs', 'BatchStop$MultiplexIds' => 'List of multiplex IDs', 'CreateInput$InputSecurityGroups' => 'A list of security groups referenced by IDs to attach to the input.', 'CreateMultiplex$AvailabilityZones' => 'A list of availability zones for the multiplex. You must specify exactly two.', 'Input$AttachedChannels' => 'A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).', 'Input$InputPartnerIds' => 'A list of IDs for all Inputs which are partners of this one.', 'Input$SecurityGroups' => 'A list of IDs for all the Input Security Groups attached to the input.', 'InputDeviceNetworkSettings$DnsAddresses' => 'The DNS addresses of the input device.', 'InputPrepareScheduleActionSettings$UrlPath' => 'The value for the variable portion of the URL for the dynamic input, for this instance of the input. Each time you use the same dynamic input in an input switch action, you can provide a different value, in order to connect the input to a different content source.', 'InputSecurityGroup$Inputs' => 'The list of inputs currently using this Input Security Group.', 'InputSwitchScheduleActionSettings$UrlPath' => 'The value for the variable portion of the URL for the dynamic input, for this instance of the input. Each time you use the same dynamic input in an input switch action, you can provide a different value, in order to connect the input to a different content source.', 'InputVpcRequest$SecurityGroupIds' => 'A list of up to 5 EC2 VPC security group IDs to attach to the Input VPC network interfaces.Requires subnetIds. If none are specified then the VPC default security group will be used.', 'InputVpcRequest$SubnetIds' => 'A list of 2 VPC subnet IDs from the same VPC.Subnet IDs must be mapped to two unique availability zones (AZ).', 'Multiplex$AvailabilityZones' => 'A list of availability zones for the multiplex.', 'MultiplexSummary$AvailabilityZones' => 'A list of availability zones for the multiplex.', 'Output$AudioDescriptionNames' => 'The names of the AudioDescriptions used as audio sources for this output.', 'Output$CaptionDescriptionNames' => 'The names of the CaptionDescriptions used as caption sources for this output.', 'UpdateInput$InputSecurityGroups' => 'A list of security groups referenced by IDs to attach to the input.', 'VpcOutputSettings$PublicAddressAllocationIds' => 'List of public address allocation ids to associate with ENIs that will be created in Output VPC.Must specify one for SINGLE_PIPELINE, two for STANDARD channels', 'VpcOutputSettings$SecurityGroupIds' => 'A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network interfaces.If none are specified then the VPC default security group will be used', 'VpcOutputSettings$SubnetIds' => 'A list of VPC subnet IDs from the same VPC.If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).', 'VpcOutputSettingsDescription$AvailabilityZones' => 'The Availability Zones where the vpc subnets are located.The first Availability Zone applies to the first subnet in the list of subnets.The second Availability Zone applies to the second subnet.', 'VpcOutputSettingsDescription$NetworkInterfaceIds' => 'A list of Elastic Network Interfaces created by MediaLive in the customer\'s VPC', 'VpcOutputSettingsDescription$SecurityGroupIds' => 'A list of up EC2 VPC security group IDs attached to the Output VPC network interfaces.', 'VpcOutputSettingsDescription$SubnetIds' => 'A list of VPC subnet IDs from the same VPC.If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).', ], ], '__longMin0Max1099511627775' => [ 'base' => NULL, 'refs' => [ 'Scte35SegmentationDescriptor$SegmentationDuration' => 'Corresponds to SCTE-35 segmentation_duration. Optional. The duration for the time_signal, in 90 KHz ticks. To convert seconds to ticks, multiple the seconds by 90,000. Enter time in 90 KHz clock ticks. If you do not enter a duration, the time_signal will continue until you insert a cancellation message.', ], ], '__longMin0Max4294967295' => [ 'base' => NULL, 'refs' => [ 'Scte35ReturnToNetworkScheduleActionSettings$SpliceEventId' => 'The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.', 'Scte35SegmentationDescriptor$SegmentationEventId' => 'Corresponds to SCTE-35 segmentation_event_id. ', 'Scte35SpliceInsertScheduleActionSettings$SpliceEventId' => 'The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.', ], ], '__longMin0Max8589934591' => [ 'base' => NULL, 'refs' => [ 'Scte35SpliceInsertScheduleActionSettings$Duration' => 'Optional, the duration for the splice_insert, in 90 KHz ticks. To convert seconds to ticks, multiple the seconds by 90,000. If you enter a duration, there is an expectation that the downstream system can read the duration and cue in at that time. If you do not enter a duration, the splice_insert will continue indefinitely and there is an expectation that you will enter a return_to_network to end the splice_insert at the appropriate time.', ], ], '__longMin0Max86400000' => [ 'base' => NULL, 'refs' => [ 'MotionGraphicsActivateScheduleActionSettings$Duration' => 'Duration (in milliseconds) that motion graphics should render on to the video stream. Leaving out this property or setting to 0 will result in rendering continuing until a deactivate action is processed.', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'AccessDenied$Message' => NULL, 'ArchiveOutputSettings$Extension' => 'Output file extension. If excluded, this will be auto-selected from the container type.', 'ArchiveOutputSettings$NameModifier' => 'String concatenated to the end of the destination filename. Required for multiple outputs of the same type.', 'AudioDescription$AudioSelectorName' => 'The name of the AudioSelector used as the source for this AudioDescription.', 'AudioDescription$StreamName' => 'Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by the player (eg. English, or Director Commentary).', 'AudioLanguageSelection$LanguageCode' => 'Selects a specific three-letter language code from within an audio source.', 'AudioOnlyHlsSettings$AudioGroupId' => 'Specifies the group to which the audio Rendition belongs.', 'AudioSilenceFailoverSettings$AudioSelectorName' => 'The name of the audio selector in the input that MediaLive should monitor to detect silence. Select your most important rendition. If you didn\'t create an audio selector in this input, leave blank.', 'AutomaticInputFailoverSettings$SecondaryInputId' => 'The input ID of the secondary input in the automatic input failover pair.', 'BadGatewayException$Message' => NULL, 'BatchFailedResultModel$Arn' => 'ARN of the resource', 'BatchFailedResultModel$Code' => 'Error code for the failed operation', 'BatchFailedResultModel$Id' => 'ID of the resource', 'BatchFailedResultModel$Message' => 'Error message for the failed operation', 'BatchSuccessfulResultModel$Arn' => 'ARN of the resource', 'BatchSuccessfulResultModel$Id' => 'ID of the resource', 'BatchSuccessfulResultModel$State' => 'Current state of the resource', 'BurnInDestinationSettings$FontSize' => 'When set to \'auto\' fontSize will scale depending on the size of the output. Giving a positive integer will specify the exact font size in points. All burn-in and DVB-Sub font settings must match.', 'CaptionDescription$CaptionSelectorName' => 'Specifies which input caption selector to use as a caption source when generating output captions. This field should match a captionSelector name.', 'CaptionDescription$LanguageCode' => 'ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/', 'CaptionDescription$LanguageDescription' => 'Human readable information to indicate captions available for players (eg. English, or Spanish).', 'CaptionDescription$Name' => 'Name of the caption description. Used to associate a caption description with an output. Names must be unique within an event.', 'CaptionSelector$LanguageCode' => 'When specified this field indicates the three letter language code of the caption track to extract from the source.', 'Channel$Arn' => 'The unique arn of the channel.', 'Channel$Id' => 'The unique id of the channel.', 'Channel$MaintenanceStatus' => 'The time in milliseconds by when the PVRE restart must occur.', 'Channel$Name' => 'The name of the channel. (user-mutable)', 'Channel$RoleArn' => 'The Amazon Resource Name (ARN) of the role assumed when running the Channel.', 'ChannelConfigurationValidationError$Message' => NULL, 'ChannelEgressEndpoint$SourceIp' => 'Public IP of where a channel\'s output comes from', 'ChannelSummary$Arn' => 'The unique arn of the channel.', 'ChannelSummary$Id' => 'The unique id of the channel.', 'ChannelSummary$MaintenanceStatus' => 'The time in milliseconds when the PVRE maintenance must occur by.', 'ChannelSummary$Name' => 'The name of the channel. (user-mutable)', 'ChannelSummary$RoleArn' => 'The Amazon Resource Name (ARN) of the role assumed when running the Channel.', 'ClaimDeviceRequest$Id' => 'The id of the device you want to claim.', 'CreateChannel$Name' => 'Name of channel.', 'CreateChannel$RequestId' => 'Unique request ID to be specified. This is needed to prevent retries fromcreating multiple resources.', 'CreateChannel$Reserved' => 'Deprecated field that\'s only usable by whitelisted customers.', 'CreateChannel$RoleArn' => 'An optional Amazon Resource Name (ARN) of the role to assume when running the Channel.', 'CreateInput$Name' => 'Name of the input.', 'CreateInput$RequestId' => 'Unique identifier of the request to ensure the request is handledexactly once in case of retries.', 'CreateInput$RoleArn' => 'The Amazon Resource Name (ARN) of the role this input assumes during and after creation.', 'CreateMultiplex$Name' => 'Name of multiplex.', 'CreateMultiplex$RequestId' => 'Unique request ID. This prevents retries from creating multipleresources.', 'CreateMultiplexProgram$ProgramName' => 'Name of multiplex program.', 'CreateMultiplexProgram$RequestId' => 'Unique request ID. This prevents retries from creating multipleresources.', 'CreatePartnerInput$RequestId' => 'Unique identifier of the request to ensure the request is handledexactly once in case of retries.', 'DescribeAnywhereSettings$ClusterName' => 'The name of the cluster that is the instance provider for the channel', 'DvbSubDestinationSettings$FontSize' => 'When set to auto fontSize will scale depending on the size of the output. Giving a positive integer will specify the exact font size in points. All burn-in and DVB-Sub font settings must match.', 'EbuTtDDestinationSettings$FontFamily' => 'Specifies the font family to include in the font data attached to the EBU-TT captions. Valid only if styleControl is set to include. If you leave this field empty, the font family is set to "monospaced". (If styleControl is set to exclude, the font family is always set to "monospaced".)You specify only the font family. All other style information (color, bold, position and so on) is copied from the input captions. The size is always set to 100% to allow the downstream player to choose the size.- Enter a list of font families, as a comma-separated list of font names, in order of preference. The name can be a font family (such as “Arial”), or a generic font family (such as “serif”), or “default” (to let the downstream player choose the font).- Leave blank to set the family to “monospace”.', 'FixedModeScheduleActionStartSettings$Time' => 'Start time for the action to start in the channel. (Not the time for the action to be added to the schedule: actions are always added to the schedule immediately.) UTC format: yyyy-mm-ddThh:mm:ss.nnnZ. All the letters are digits (for example, mm might be 01) except for the two constants "T" for time and "Z" for "UTC format".', 'Fmp4HlsSettings$AudioRenditionSets' => 'List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by \',\'.', 'FollowModeScheduleActionStartSettings$ReferenceActionName' => 'The action name of another action that this one refers to.', 'FrameCaptureOutputSettings$NameModifier' => 'Required if the output group contains more than one output. This modifier forms part of the output file name.', 'GatewayTimeoutException$Message' => NULL, 'HlsAkamaiSettings$Salt' => 'Salt for authenticated Akamai.', 'HlsAkamaiSettings$Token' => 'Token parameter for authenticated akamai. If not specified, _gda_ is used.', 'HlsGroupSettings$BaseUrlContent' => 'A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest is delivered from a different URL than the main .m3u8 file.', 'HlsGroupSettings$BaseUrlContent1' => 'Optional. One value per output group.This field is required only if you are completing Base URL content A, and the downstream system has notified you that the media files for pipeline 1 of all outputs are in a location different from the media files for pipeline 0.', 'HlsGroupSettings$BaseUrlManifest' => 'A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest is delivered from a different URL than the main .m3u8 file.', 'HlsGroupSettings$BaseUrlManifest1' => 'Optional. One value per output group.Complete this field only if you are completing Base URL manifest A, and the downstream system has notified you that the child manifest files for pipeline 1 of all outputs are in a location different from the child manifest files for pipeline 0.', 'HlsGroupSettings$KeyFormat' => 'The value specifies how the key is represented in the resource identified by the URI. If parameter is absent, an implicit value of "identity" is used. A reverse DNS string can also be given.', 'HlsGroupSettings$KeyFormatVersions' => 'Either a single positive integer version value or a slash delimited list of version values (1/2/3).', 'HlsId3SegmentTaggingScheduleActionSettings$Tag' => 'ID3 tag to insert into each segment. Supports special keyword identifiers to substitute in segment-related values.\\nSupported keyword identifiers: https://docs.aws.amazon.com/medialive/latest/ug/variable-data-identifiers.html', 'HlsOutputSettings$SegmentModifier' => 'String concatenated to end of segment filenames.', 'HlsTimedMetadataScheduleActionSettings$Id3' => 'Base64 string formatted according to the ID3 specification: http://id3.org/id3v2.4.0-structure', 'Input$Arn' => 'The Unique ARN of the input (generated, immutable).', 'Input$Id' => 'The generated ID of the input (unique for user account, immutable).', 'Input$Name' => 'The user-assigned name (This is a mutable value).', 'Input$RoleArn' => 'The Amazon Resource Name (ARN) of the role this input assumes during and after creation.', 'InputAttachment$InputAttachmentName' => 'User-specified name for the attachment. This is required if the user wants to use this input in an input switch action.', 'InputAttachment$InputId' => 'The ID of the input', 'InputDestination$Ip' => 'The system-generated static IP address of endpoint.It remains fixed for the lifetime of the input.', 'InputDestination$Port' => 'The port number for the input.', 'InputDestination$Url' => 'This represents the endpoint that the customer stream will bepushed to.', 'InputDestinationRequest$StreamName' => 'A unique name for the location the RTMP stream is being pushedto.', 'InputDestinationVpc$AvailabilityZone' => 'The availability zone of the Input destination.', 'InputDestinationVpc$NetworkInterfaceId' => 'The network interface ID of the Input destination in the VPC.', 'InputDevice$Arn' => 'The unique ARN of the input device.', 'InputDevice$Id' => 'The unique ID of the input device.', 'InputDevice$MacAddress' => 'The network MAC address of the input device.', 'InputDevice$Name' => 'A name that you specify for the input device.', 'InputDevice$SerialNumber' => 'The unique serial number of the input device.', 'InputDeviceConfigurationValidationError$Message' => 'The error message.', 'InputDeviceNetworkSettings$Gateway' => 'The network gateway IP address.', 'InputDeviceNetworkSettings$IpAddress' => 'The IP address of the input device.', 'InputDeviceNetworkSettings$SubnetMask' => 'The subnet mask of the input device.', 'InputDeviceRequest$Id' => 'The unique ID for the device.', 'InputDeviceSettings$Id' => 'The unique ID for the device.', 'InputDeviceSummary$Arn' => 'The unique ARN of the input device.', 'InputDeviceSummary$Id' => 'The unique ID of the input device.', 'InputDeviceSummary$MacAddress' => 'The network MAC address of the input device.', 'InputDeviceSummary$Name' => 'A name that you specify for the input device.', 'InputDeviceSummary$SerialNumber' => 'The unique serial number of the input device.', 'InputLocation$PasswordParam' => 'key used to extract the password from EC2 Parameter store', 'InputLocation$Uri' => 'Uniform Resource Identifier - This should be a path to a file accessible to the Live system (eg. a http:// URI) depending on the output type. For example, a RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".', 'InputLocation$Username' => 'Username if credentials are required to access a file or publishing point. This can be either a plaintext username, or a reference to an AWS parameter store name from which the username can be retrieved. AWS Parameter store format: "ssm://<parameter name>"', 'InputPrepareScheduleActionSettings$InputAttachmentNameReference' => 'The name of the input attachment that should be prepared by this action. If no name is provided, the action will stop the most recent prepare (if any) when activated.', 'InputSecurityGroup$Arn' => 'Unique ARN of Input Security Group', 'InputSecurityGroup$Id' => 'The Id of the Input Security Group', 'InputSource$PasswordParam' => 'The key used to extract the password from EC2 Parameter store.', 'InputSource$Url' => 'This represents the customer\'s source URL where stream ispulled from.', 'InputSource$Username' => 'The username for the input source.', 'InputSourceRequest$PasswordParam' => 'The key used to extract the password from EC2 Parameter store.', 'InputSourceRequest$Url' => 'This represents the customer\'s source URL where stream ispulled from.', 'InputSourceRequest$Username' => 'The username for the input source.', 'InputSwitchScheduleActionSettings$InputAttachmentNameReference' => 'The name of the input attachment (not the name of the input!) to switch to. The name is specified in the channel configuration.', 'InputWhitelistRule$Cidr' => 'The IPv4 CIDR that\'s whitelisted.', 'InputWhitelistRuleCidr$Cidr' => 'The IPv4 CIDR to whitelist.', 'InternalServiceError$Message' => NULL, 'InvalidRequest$Message' => NULL, 'LimitExceeded$Message' => NULL, 'ListChannelsResultModel$NextToken' => NULL, 'ListInputDeviceTransfersResultModel$NextToken' => 'A token to get additional list results.', 'ListInputDevicesResultModel$NextToken' => 'A token to get additional list results.', 'ListInputSecurityGroupsResultModel$NextToken' => NULL, 'ListInputsResultModel$NextToken' => NULL, 'ListMultiplexProgramsResultModel$NextToken' => 'Token for the next ListMultiplexProgram request.', 'ListMultiplexesResultModel$NextToken' => 'Token for the next ListMultiplexes request.', 'ListOfferingsResultModel$NextToken' => 'Token to retrieve the next page of results', 'ListReservationsResultModel$NextToken' => 'Token to retrieve the next page of results', 'M2tsSettings$AribCaptionsPid' => 'Packet Identifier (PID) for ARIB Captions in the transport stream. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$AudioPids' => 'Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$DvbSubPids' => 'Packet Identifier (PID) for input source DVB Subtitle data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$DvbTeletextPid' => 'Packet Identifier (PID) for input source DVB Teletext data to this output. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$EcmPid' => 'This field is unused and deprecated.', 'M2tsSettings$EtvPlatformPid' => 'Packet Identifier (PID) for input source ETV Platform data to this output. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$EtvSignalPid' => 'Packet Identifier (PID) for input source ETV Signal data to this output. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$KlvDataPids' => 'Packet Identifier (PID) for input source KLV data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$PcrPid' => 'Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$PmtPid' => 'Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$Scte27Pids' => 'Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$Scte35Pid' => 'Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$TimedMetadataPid' => 'Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M2tsSettings$VideoPid' => 'Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M3u8Settings$AudioPids' => 'Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.', 'M3u8Settings$EcmPid' => 'This parameter is unused and deprecated.', 'M3u8Settings$PcrPid' => 'Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.', 'M3u8Settings$PmtPid' => 'Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or hexadecimal value.', 'M3u8Settings$Scte35Pid' => 'Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal value.', 'M3u8Settings$TimedMetadataPid' => 'Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).', 'M3u8Settings$VideoPid' => 'Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or hexadecimal value.', 'MaintenanceStatus$MaintenanceDeadline' => 'Maintenance is required by the displayed date and time. Date and time is in ISO.', 'MaintenanceStatus$MaintenanceScheduledDate' => 'The currently scheduled maintenance date and time. Date and time is in ISO.', 'MaintenanceStatus$MaintenanceStartTime' => 'The currently selected maintenance start time. Time is in UTC.', 'MaintenanceUpdateSettings$MaintenanceScheduledDate' => 'Choose a specific date for maintenance to occur. The chosen date is used for the next maintenance window only.', 'MediaConnectFlow$FlowArn' => 'The unique ARN of the MediaConnect Flow being used as a source.', 'MediaConnectFlowRequest$FlowArn' => 'The ARN of the MediaConnect Flow that you want to use as a source.', 'MotionGraphicsActivateScheduleActionSettings$PasswordParam' => 'Key used to extract the password from EC2 Parameter store', 'MotionGraphicsActivateScheduleActionSettings$Url' => 'URI of the HTML5 content to be rendered into the live stream.', 'MotionGraphicsActivateScheduleActionSettings$Username' => 'Username if credentials are required to access a file. This must be a reference to an AWS parameter store name from which the password can be retrieved. AWS Parameter store format: \\"ssm://<parameter name>\\"', 'MsSmoothGroupSettings$AcquisitionPointId' => 'The ID to include in each message in the sparse track. Ignored if sparseTrackType is NONE.', 'MsSmoothGroupSettings$EventId' => 'MS Smooth event ID to be sent to the IIS server.Should only be specified if eventIdMode is set to useConfigured.', 'MsSmoothGroupSettings$TimestampOffset' => 'Timestamp offset for the event. Only used if timestampOffsetMode is set to useConfiguredOffset.', 'MsSmoothOutputSettings$NameModifier' => 'String concatenated to the end of the destination filename. Required for multiple outputs of the same type.', 'Multiplex$Arn' => 'The unique arn of the multiplex.', 'Multiplex$Id' => 'The unique id of the multiplex.', 'Multiplex$Name' => 'The name of the multiplex.', 'MultiplexConfigurationValidationError$Message' => 'The error message.', 'MultiplexProgram$ChannelId' => 'The MediaLive channel associated with the program.', 'MultiplexProgram$ProgramName' => 'The name of the multiplex program.', 'MultiplexProgramPipelineDetail$ActiveChannelPipeline' => 'Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the multiplex.', 'MultiplexProgramPipelineDetail$PipelineId' => 'Identifies a specific pipeline in the multiplex.', 'MultiplexProgramSummary$ChannelId' => 'The MediaLive Channel associated with the program.', 'MultiplexProgramSummary$ProgramName' => 'The name of the multiplex program.', 'MultiplexSummary$Arn' => 'The unique arn of the multiplex.', 'MultiplexSummary$Id' => 'The unique id of the multiplex.', 'MultiplexSummary$Name' => 'The name of the multiplex.', 'NielsenConfiguration$DistributorId' => 'Enter the Distributor ID assigned to your organization by Nielsen.', 'Offering$Arn' => 'Unique offering ARN, e.g. \'arn:aws:medialive:us-west-2:123456789012:offering:87654321\'', 'Offering$CurrencyCode' => 'Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. \'USD\'', 'Offering$OfferingDescription' => 'Offering description, e.g. \'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)\'', 'Offering$OfferingId' => 'Unique offering ID, e.g. \'87654321\'', 'Offering$Region' => 'AWS region, e.g. \'us-west-2\'', 'Output$VideoDescriptionName' => 'The name of the VideoDescription used as the source for this output.', 'OutputDestination$Id' => 'User-specified id. This is used in an output group or an output.', 'OutputDestinationSettings$PasswordParam' => 'key used to extract the password from EC2 Parameter store', 'OutputDestinationSettings$StreamName' => 'Stream name for RTMP destinations (URLs of type rtmp://)', 'OutputDestinationSettings$Url' => 'A URL specifying a destination', 'OutputDestinationSettings$Username' => 'username for destination', 'OutputLocationRef$DestinationRefId' => NULL, 'PipelineDetail$ActiveInputAttachmentName' => 'The name of the active input attachment currently being ingested by this pipeline.', 'PipelineDetail$ActiveInputSwitchActionName' => 'The name of the input switch schedule action that occurred most recently and that resulted in the switch to the current input attachment for this pipeline.', 'PipelineDetail$ActiveMotionGraphicsActionName' => 'The name of the motion graphics activate action that occurred most recently and that resulted in the current graphics URI for this pipeline.', 'PipelineDetail$ActiveMotionGraphicsUri' => 'The current URI being used for HTML5 motion graphics for this pipeline.', 'PipelineDetail$PipelineId' => 'Pipeline ID', 'PurchaseOffering$Name' => 'Name for the new reservation', 'PurchaseOffering$RequestId' => 'Unique request ID to be specified. This is needed to prevent retries from creating multiple resources.', 'PurchaseOffering$Start' => 'Requested reservation start time (UTC) in ISO-8601 format. The specified time must be between the first day of the current month and one year from now. If no value is given, the default is now.', 'Reservation$Arn' => 'Unique reservation ARN, e.g. \'arn:aws:medialive:us-west-2:123456789012:reservation:1234567\'', 'Reservation$CurrencyCode' => 'Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. \'USD\'', 'Reservation$End' => 'Reservation UTC end date and time in ISO-8601 format, e.g. \'2019-03-01T00:00:00\'', 'Reservation$Name' => 'User specified reservation name', 'Reservation$OfferingDescription' => 'Offering description, e.g. \'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)\'', 'Reservation$OfferingId' => 'Unique offering ID, e.g. \'87654321\'', 'Reservation$Region' => 'AWS region, e.g. \'us-west-2\'', 'Reservation$ReservationId' => 'Unique reservation ID, e.g. \'1234567\'', 'Reservation$Start' => 'Reservation UTC start date and time in ISO-8601 format, e.g. \'2018-03-01T00:00:00\'', 'ResourceConflict$Message' => NULL, 'ResourceNotFound$Message' => NULL, 'ScheduleAction$ActionName' => 'The name of the action, must be unique within the schedule. This name provides the main reference to an action once it is added to the schedule. A name is unique if it is no longer in the schedule. The schedule is automatically cleaned up to remove actions with a start time of more than 1 hour ago (approximately) so at that point a name can be reused.', 'ScheduleDescribeResultModel$NextToken' => 'The next token; for use in pagination.', 'Scte35SegmentationDescriptor$SegmentationUpid' => 'Corresponds to SCTE-35 segmentation_upid. Enter a string containing the hexadecimal representation of the characters that make up the SCTE-35 segmentation_upid value. Must contain an even number of hex characters. Do not include spaces between each hex pair. For example, the ASCII "ADS Information" becomes hex "41445320496e666f726d6174696f6e.', 'StandardHlsSettings$AudioRenditionSets' => 'List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by \',\'.', 'StartTimecode$Timecode' => 'The timecode for the frame where you want to start the clip. Optional; if not specified, the clip starts at first frame in the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.', 'StopTimecode$Timecode' => 'The timecode for the frame where you want to stop the clip. Optional; if not specified, the clip continues to the end of the file. Enter the timecode as HH:MM:SS:FF or HH:MM:SS;FF.', 'Tags$member' => NULL, 'TeletextSourceSettings$PageNumber' => 'Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no "0x" prefix.', 'ThumbnailData$Body' => 'The binary data for the thumbnail that the Link device has most recently sent to MediaLive.', 'TransferInputDevice$TargetCustomerId' => 'The AWS account ID (12 digits) for the recipient of the device transfer.', 'TransferInputDevice$TargetRegion' => 'The target AWS region to transfer the device.', 'TransferInputDevice$TransferMessage' => 'An optional message for the recipient. Maximum 280 characters.', 'TransferringInputDeviceSummary$Id' => 'The unique ID of the input device.', 'TransferringInputDeviceSummary$Message' => 'The optional message that the sender has attached to the transfer.', 'TransferringInputDeviceSummary$TargetCustomerId' => 'The AWS account ID for the recipient of the input device transfer.', 'UpdateChannel$Name' => 'The name of the channel.', 'UpdateChannel$RoleArn' => 'An optional Amazon Resource Name (ARN) of the role to assume when running the Channel. If you do not specify this on an update call but the role was previously set that role will be removed.', 'UpdateInput$Name' => 'Name of the input.', 'UpdateInput$RoleArn' => 'The Amazon Resource Name (ARN) of the role this input assumes during and after creation.', 'UpdateInputDevice$Name' => 'The name that you assigned to this input device (not the unique ID).', 'UpdateMultiplex$Name' => 'Name of the multiplex.', 'UpdateReservation$Name' => 'Name of the reservation', 'ValidationError$ElementPath' => 'Path to the source of the error.', 'ValidationError$ErrorMessage' => 'The error message.', 'VideoDescription$Name' => 'The name of this VideoDescription. Outputs will use this name to uniquely identify this Description. Description names should be unique within this Live Event.', '__listOf__string$member' => NULL, ], ], '__stringMax1000' => [ 'base' => NULL, 'refs' => [ 'EbuTtDDestinationSettings$CopyrightHolder' => 'Complete this field if you want to include the name of the copyright holder in the copyright tag in the captions metadata.', ], ], '__stringMax2048' => [ 'base' => NULL, 'refs' => [ 'InputLocation$Uri' => 'Uniform Resource Identifier - This should be a path to a file accessible to the Live system (eg. a http:// URI) depending on the output type. For example, a RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".', ], ], '__stringMax255' => [ 'base' => NULL, 'refs' => [ 'AudioDescription$Name' => 'The name of this AudioDescription. Outputs will use this name to uniquely identify this AudioDescription. Description names should be unique within this Live Event.', ], ], '__stringMax256' => [ 'base' => NULL, 'refs' => [ 'MultiplexProgramServiceDescriptor$ProviderName' => 'Name of the provider.', 'MultiplexProgramServiceDescriptor$ServiceName' => 'Name of the service.', ], ], '__stringMax32' => [ 'base' => NULL, 'refs' => [ 'OutputGroup$Name' => 'Custom output group name optionally defined by the user.', ], ], '__stringMin1' => [ 'base' => NULL, 'refs' => [ 'AudioHlsRenditionSelection$GroupId' => 'Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.', 'AudioHlsRenditionSelection$Name' => 'Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.', 'AudioSelector$Name' => 'The name of this AudioSelector. AudioDescriptions will use this name to uniquely identify this Selector. Selector names should be unique per input.', 'CaptionLanguageMapping$LanguageDescription' => 'Textual description of language', 'CaptionSelector$Name' => 'Name identifier for a caption selector. This name is used to associate this caption selector with one or more caption descriptions. Names must be unique within an event.', 'HlsOutputSettings$NameModifier' => 'String concatenated to the end of the destination filename. Accepts \\"Format Identifiers\\":#formatIdentifierParameters.', 'MediaPackageOutputDestinationSettings$ChannelId' => 'ID of the channel in MediaPackage that is the destination for this output group. You do not need to specify the individual inputs in MediaPackage; MediaLive will handle the connection of the two MediaLive pipelines to the two MediaPackage inputs. The MediaPackage channel and MediaLive channel must be in the same region.', 'MultiplexMediaConnectOutputDestinationSettings$EntitlementArn' => 'The MediaConnect entitlement ARN available as a Flow source.', 'MultiplexProgramChannelDestinationSettings$MultiplexId' => 'The ID of the Multiplex that the encoder is providing output to. You do not need to specify the individual inputs to the Multiplex; MediaLive will handle the connection of the two MediaLive pipelines to the two Multiplex instances.The Multiplex must be in the same region as the Channel.', 'MultiplexProgramChannelDestinationSettings$ProgramName' => 'The program name of the Multiplex program that the encoder is providing output to.', ], ], '__stringMin1Max255' => [ 'base' => NULL, 'refs' => [ 'Output$OutputName' => 'The name used to identify an output.', ], ], '__stringMin1Max256' => [ 'base' => NULL, 'refs' => [ 'DvbNitSettings$NetworkName' => 'The network name text placed in the networkNameDescriptor inside the Network Information Table. Maximum length is 256 characters.', 'DvbSdtSettings$ServiceName' => 'The service name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256 characters.', 'DvbSdtSettings$ServiceProviderName' => 'The service provider name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256 characters.', ], ], '__stringMin1Max35' => [ 'base' => NULL, 'refs' => [ 'AudioDescription$LanguageCode' => 'RFC 5646 language code representing the language of the audio output track. Only used if languageControlMode is useConfigured, or there is no ISO 639 language code specified in the input.', ], ], '__stringMin1Max7' => [ 'base' => NULL, 'refs' => [ 'NielsenCBET$Csid' => 'Enter the CBET Source ID (CSID) to use in the watermark', ], ], '__stringMin2Max2' => [ 'base' => NULL, 'refs' => [ 'NielsenCBET$CbetCheckDigitString' => 'Enter the CBET check digits to use in the watermark.', 'NielsenNaesIiNw$CheckDigitString' => 'Enter the check digit string for the watermark', ], ], '__stringMin32Max32' => [ 'base' => NULL, 'refs' => [ 'HlsGroupSettings$ConstantIv' => 'For use with encryptionType. This is a 128-bit, 16-byte hex value represented by a 32-character text string. If ivSource is set to "explicit" then this parameter is required and is used as the IV for encryption.', 'StaticKeySettings$StaticKeyValue' => 'Static key value as a 32 character hexadecimal string.', ], ], '__stringMin34Max34' => [ 'base' => NULL, 'refs' => [ 'BlackoutSlate$NetworkId' => 'Provides Network ID that matches EIDR ID format (e.g., "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").', ], ], '__stringMin3Max3' => [ 'base' => NULL, 'refs' => [ 'CaptionLanguageMapping$LanguageCode' => 'Three character ISO 639-2 language code (see http://www.loc.gov/standards/iso639-2)', ], ], '__stringMin6Max6' => [ 'base' => NULL, 'refs' => [ 'InputLossBehavior$InputLossImageColor' => 'When input loss image type is "color" this field specifies the color to use. Value: 6 hex characters representing the values of RGB.', ], ], '__stringPattern010920300' => [ 'base' => NULL, 'refs' => [ 'MaintenanceCreateSettings$MaintenanceStartTime' => 'Choose the hour that maintenance will start. The chosen time is used for all future maintenance windows.', 'MaintenanceUpdateSettings$MaintenanceStartTime' => 'Choose the hour that maintenance will start. The chosen time is used for all future maintenance windows.', ], ], ],];
