<?php
// This file was auto-generated from sdk-root/src/data/iotdeviceadvisor/2020-09-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services IoT Core Device Advisor is a cloud-based, fully managed test capability for validating IoT devices during device software development. Device Advisor provides pre-built tests that you can use to validate IoT devices for reliable and secure connectivity with Amazon Web Services IoT Core before deploying devices to production. By using Device Advisor, you can confirm that your devices can connect to Amazon Web Services IoT Core, follow security best practices and, if applicable, receive software updates from IoT Device Management. You can also download signed qualification reports to submit to the Amazon Web Services Partner Network to get your device qualified for the Amazon Web Services Partner Device Catalog without the need to send your device in and wait for it to be tested.</p>', 'operations' => [ 'CreateSuiteDefinition' => '<p>Creates a Device Advisor test suite.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateSuiteDefinition</a> action.</p>', 'DeleteSuiteDefinition' => '<p>Deletes a Device Advisor test suite.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeleteSuiteDefinition</a> action.</p>', 'GetEndpoint' => '<p>Gets information about an Device Advisor endpoint.</p>', 'GetSuiteDefinition' => '<p>Gets information about a Device Advisor test suite.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetSuiteDefinition</a> action.</p>', 'GetSuiteRun' => '<p>Gets information about a Device Advisor test suite run.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetSuiteRun</a> action.</p>', 'GetSuiteRunReport' => '<p>Gets a report download link for a successful Device Advisor qualifying test suite run.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">GetSuiteRunReport</a> action.</p>', 'ListSuiteDefinitions' => '<p>Lists the Device Advisor test suites you have created.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSuiteDefinitions</a> action.</p>', 'ListSuiteRuns' => '<p>Lists runs of the specified Device Advisor test suite. You can list all runs of the test suite, or the runs of a specific version of the test suite.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListSuiteRuns</a> action.</p>', 'ListTagsForResource' => '<p>Lists the tags attached to an IoT Device Advisor resource.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">ListTagsForResource</a> action.</p>', 'StartSuiteRun' => '<p>Starts a Device Advisor test suite run.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StartSuiteRun</a> action.</p>', 'StopSuiteRun' => '<p>Stops a Device Advisor test suite run that is currently running.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">StopSuiteRun</a> action.</p>', 'TagResource' => '<p>Adds to and modifies existing tags of an IoT Device Advisor resource.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">TagResource</a> action.</p>', 'UntagResource' => '<p>Removes tags from an IoT Device Advisor resource.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UntagResource</a> action.</p>', 'UpdateSuiteDefinition' => '<p>Updates a Device Advisor test suite.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">UpdateSuiteDefinition</a> action.</p>', ], 'shapes' => [ 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateSuiteDefinitionResponse$suiteDefinitionArn' => '<p>Creates a Device Advisor test suite with Amazon Resource Name (ARN).</p>', 'DeviceUnderTest$thingArn' => '<p>Lists devices thing ARN.</p>', 'DeviceUnderTest$certificateArn' => '<p>Lists devices certificate ARN.</p>', 'GetEndpointRequest$thingArn' => '<p>The thing ARN of the device. This is an optional parameter.</p>', 'GetEndpointRequest$certificateArn' => '<p>The certificate ARN of the device. This is an optional parameter.</p>', 'GetSuiteDefinitionResponse$suiteDefinitionArn' => '<p>The ARN of the suite definition.</p>', 'GetSuiteRunResponse$suiteRunArn' => '<p>The ARN of the suite run.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the IoT Device Advisor resource.</p>', 'StartSuiteRunResponse$suiteRunArn' => '<p>Amazon Resource Name (ARN) of the started suite run.</p>', 'SuiteDefinitionConfiguration$devicePermissionRoleArn' => '<p>Gets the device permission ARN.</p>', 'TagResourceRequest$resourceArn' => '<p>The resource ARN of an IoT Device Advisor resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The resource ARN of an IoT Device Advisor resource.</p>', 'UpdateSuiteDefinitionResponse$suiteDefinitionArn' => '<p>Amazon Resource Name (ARN) of the updated test suite.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Sends a Conflict Exception.</p>', 'refs' => [], ], 'CreateSuiteDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSuiteDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSuiteDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSuiteDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeviceUnderTest' => [ 'base' => '<p>Information of a test device. A thing ARN or a certificate ARN is required.</p>', 'refs' => [ 'DeviceUnderTestList$member' => NULL, 'SuiteRunConfiguration$primaryDevice' => '<p>Gets the primary device for suite run.</p>', ], ], 'DeviceUnderTestList' => [ 'base' => NULL, 'refs' => [ 'SuiteDefinitionConfiguration$devices' => '<p>Gets the devices configured.</p>', 'SuiteDefinitionInformation$defaultDevices' => '<p>Specifies the devices that are under test for the test suite.</p>', ], ], 'Endpoint' => [ 'base' => NULL, 'refs' => [ 'GetEndpointResponse$endpoint' => '<p>The response of an Device Advisor endpoint.</p>', ], ], 'ErrorReason' => [ 'base' => NULL, 'refs' => [ 'GetSuiteRunResponse$errorReason' => '<p>Error reason for any test suite run failure.</p>', ], ], 'Failure' => [ 'base' => NULL, 'refs' => [ 'TestCaseRun$failure' => '<p>Provides test case run failure result.</p>', 'TestCaseScenario$failure' => '<p>Provides test case scenario failure result.</p>', ], ], 'GetEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSuiteDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSuiteDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSuiteRunReportRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSuiteRunReportResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSuiteRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSuiteRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'GroupResult$groupName' => '<p>Group Result Name.</p>', ], ], 'GroupResult' => [ 'base' => '<p>Show Group Result.</p>', 'refs' => [ 'GroupResultList$member' => NULL, ], ], 'GroupResultList' => [ 'base' => '<p>Group Result list.</p>', 'refs' => [ 'TestResult$groups' => '<p>Show each group of test results.</p>', ], ], 'IntendedForQualificationBoolean' => [ 'base' => NULL, 'refs' => [ 'SuiteDefinitionConfiguration$intendedForQualification' => '<p>Gets the tests intended for qualification in a suite.</p>', 'SuiteDefinitionInformation$intendedForQualification' => '<p>Specifies if the test suite is intended for qualification.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Sends an Internal Failure exception.</p>', 'refs' => [], ], 'IsLongDurationTestBoolean' => [ 'base' => NULL, 'refs' => [ 'SuiteDefinitionConfiguration$isLongDurationTest' => '<p> Verifies if the test suite is a long duration test. </p>', 'SuiteDefinitionInformation$isLongDurationTest' => '<p> Verifies if the test suite is a long duration test. </p>', ], ], 'ListSuiteDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSuiteDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSuiteRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSuiteRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogUrl' => [ 'base' => NULL, 'refs' => [ 'TestCaseRun$logUrl' => '<p>Provides test case run log URL.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListSuiteDefinitionsRequest$maxResults' => '<p>The maximum number of results to return at once.</p>', 'ListSuiteRunsRequest$maxResults' => '<p>The maximum number of results to return at once.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'ConflictException$message' => '<p>Sends a Conflict Exception message.</p>', 'InternalServerException$message' => '<p>Sends an Internal Failure Exception message.</p>', 'ResourceNotFoundException$message' => '<p>Sends a Resource Not Found Exception message.</p>', 'ValidationException$message' => '<p>Sends a Validation Exception message.</p>', ], ], 'ParallelRun' => [ 'base' => NULL, 'refs' => [ 'SuiteRunConfiguration$parallelRun' => '<p>TRUE if multiple test suites run in parallel.</p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'SuiteDefinitionConfiguration$protocol' => '<p> Gets the MQTT protocol that is configured in the suite definition.</p>', 'SuiteDefinitionInformation$protocol' => '<p> Gets the MQTT protocol that is configured in the suite definition.</p>', ], ], 'QualificationReportDownloadUrl' => [ 'base' => NULL, 'refs' => [ 'GetSuiteRunReportResponse$qualificationReportDownloadUrl' => '<p>Download URL of the qualification report.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Sends a Resource Not Found exception.</p>', 'refs' => [], ], 'RootGroup' => [ 'base' => NULL, 'refs' => [ 'SuiteDefinitionConfiguration$rootGroup' => '<p>Gets test suite root group.</p>', ], ], 'SelectedTestList' => [ 'base' => NULL, 'refs' => [ 'SuiteRunConfiguration$selectedTestList' => '<p>Gets test case list.</p>', ], ], 'StartSuiteRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartSuiteRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'TestCaseRun$status' => '<p>Provides the test case run status. Status is one of the following:</p> <ul> <li> <p> <code>PASS</code>: Test passed.</p> </li> <li> <p> <code>FAIL</code>: Test failed.</p> </li> <li> <p> <code>PENDING</code>: Test has not started running but is scheduled.</p> </li> <li> <p> <code>RUNNING</code>: Test is running.</p> </li> <li> <p> <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite run.</p> </li> <li> <p> <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.</p> </li> <li> <p> <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.</p> </li> <li> <p> <code>ERORR</code>: Test faced an error when running due to an internal issue.</p> </li> </ul>', ], ], 'StopSuiteRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopSuiteRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'String128' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'String256' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'SuiteDefinitionConfiguration' => [ 'base' => '<p>Gets Suite Definition Configuration.</p>', 'refs' => [ 'CreateSuiteDefinitionRequest$suiteDefinitionConfiguration' => '<p>Creates a Device Advisor test suite with suite definition configuration.</p>', 'GetSuiteDefinitionResponse$suiteDefinitionConfiguration' => '<p>Suite configuration of the suite definition.</p>', 'UpdateSuiteDefinitionRequest$suiteDefinitionConfiguration' => '<p>Updates a Device Advisor test suite with suite definition configuration.</p>', ], ], 'SuiteDefinitionInformation' => [ 'base' => '<p>Information about the suite definition.</p>', 'refs' => [ 'SuiteDefinitionInformationList$member' => NULL, ], ], 'SuiteDefinitionInformationList' => [ 'base' => NULL, 'refs' => [ 'ListSuiteDefinitionsResponse$suiteDefinitionInformationList' => '<p>An array of objects that provide summaries of information about the suite definitions in the list.</p>', ], ], 'SuiteDefinitionName' => [ 'base' => NULL, 'refs' => [ 'CreateSuiteDefinitionResponse$suiteDefinitionName' => '<p>Creates a Device Advisor test suite with suite definition name.</p>', 'SuiteDefinitionConfiguration$suiteDefinitionName' => '<p>Gets Suite Definition Configuration name.</p>', 'SuiteDefinitionInformation$suiteDefinitionName' => '<p>Suite name of the test suite.</p>', 'SuiteRunInformation$suiteDefinitionName' => '<p>Suite definition name of the suite run.</p>', 'UpdateSuiteDefinitionResponse$suiteDefinitionName' => '<p>Suite definition name of the updated test suite.</p>', ], ], 'SuiteDefinitionVersion' => [ 'base' => NULL, 'refs' => [ 'GetSuiteDefinitionRequest$suiteDefinitionVersion' => '<p>Suite definition version of the test suite to get.</p>', 'GetSuiteDefinitionResponse$suiteDefinitionVersion' => '<p>Suite definition version of the suite definition.</p>', 'GetSuiteDefinitionResponse$latestVersion' => '<p>Latest suite definition version of the suite definition.</p>', 'GetSuiteRunResponse$suiteDefinitionVersion' => '<p>Suite definition version for the test suite run.</p>', 'ListSuiteRunsRequest$suiteDefinitionVersion' => '<p>Must be passed along with <code>suiteDefinitionId</code>. Lists the test suite runs of the specified test suite based on suite definition version.</p>', 'StartSuiteRunRequest$suiteDefinitionVersion' => '<p>Suite definition version of the test suite.</p>', 'SuiteRunInformation$suiteDefinitionVersion' => '<p>Suite definition version of the suite run.</p>', 'UpdateSuiteDefinitionResponse$suiteDefinitionVersion' => '<p>Suite definition version of the updated test suite.</p>', ], ], 'SuiteRunConfiguration' => [ 'base' => '<p>Gets suite run configuration.</p>', 'refs' => [ 'GetSuiteRunResponse$suiteRunConfiguration' => '<p>Suite run configuration for the test suite run.</p>', 'StartSuiteRunRequest$suiteRunConfiguration' => '<p>Suite run configuration.</p>', ], ], 'SuiteRunInformation' => [ 'base' => '<p>Information about the suite run.</p> <p>Requires permission to access the <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">SuiteRunInformation</a> action.</p>', 'refs' => [ 'SuiteRunsList$member' => NULL, ], ], 'SuiteRunResultCount' => [ 'base' => NULL, 'refs' => [ 'SuiteRunInformation$passed' => '<p>Number of test cases that passed in the suite run.</p>', 'SuiteRunInformation$failed' => '<p>Number of test cases that failed in the suite run.</p>', ], ], 'SuiteRunStatus' => [ 'base' => NULL, 'refs' => [ 'GetSuiteRunResponse$status' => '<p>Status for the test suite run.</p>', 'SuiteRunInformation$status' => '<p>Status of the suite run.</p>', ], ], 'SuiteRunsList' => [ 'base' => NULL, 'refs' => [ 'ListSuiteRunsResponse$suiteRunsList' => '<p>An array of objects that provide summaries of information about the suite runs in the list.</p>', ], ], 'SystemMessage' => [ 'base' => NULL, 'refs' => [ 'TestCaseScenario$systemMessage' => '<p> </p>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>List of tag keys to remove from the IoT Device Advisor resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateSuiteDefinitionRequest$tags' => '<p>The tags to be attached to the suite definition.</p>', 'GetSuiteDefinitionResponse$tags' => '<p>Tags attached to the suite definition.</p>', 'GetSuiteRunResponse$tags' => '<p>The tags attached to the suite run.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags attached to the IoT Device Advisor resource.</p>', 'StartSuiteRunRequest$tags' => '<p>The tags to be attached to the suite run.</p>', 'TagResourceRequest$tags' => '<p>The tags to be attached to the IoT Device Advisor resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TestCaseDefinitionName' => [ 'base' => NULL, 'refs' => [ 'TestCaseRun$testCaseDefinitionName' => '<p>Provides the test case run definition name.</p>', ], ], 'TestCaseRun' => [ 'base' => '<p>Provides the test case run.</p>', 'refs' => [ 'TestCaseRuns$member' => NULL, ], ], 'TestCaseRuns' => [ 'base' => '<p>Tests under each group result.</p>', 'refs' => [ 'GroupResult$tests' => '<p>Tests under Group Result.</p>', ], ], 'TestCaseScenario' => [ 'base' => '<p>Provides test case scenario.</p>', 'refs' => [ 'TestCaseScenariosList$member' => NULL, ], ], 'TestCaseScenarioId' => [ 'base' => NULL, 'refs' => [ 'TestCaseScenario$testCaseScenarioId' => '<p>Provides test case scenario ID.</p>', ], ], 'TestCaseScenarioStatus' => [ 'base' => NULL, 'refs' => [ 'TestCaseScenario$status' => '<p>Provides the test case scenario status. Status is one of the following:</p> <ul> <li> <p> <code>PASS</code>: Test passed.</p> </li> <li> <p> <code>FAIL</code>: Test failed.</p> </li> <li> <p> <code>PENDING</code>: Test has not started running but is scheduled.</p> </li> <li> <p> <code>RUNNING</code>: Test is running.</p> </li> <li> <p> <code>STOPPING</code>: Test is performing cleanup steps. You will see this status only if you stop a suite run.</p> </li> <li> <p> <code>STOPPED</code> Test is stopped. You will see this status only if you stop a suite run.</p> </li> <li> <p> <code>PASS_WITH_WARNINGS</code>: Test passed with warnings.</p> </li> <li> <p> <code>ERORR</code>: Test faced an error when running due to an internal issue.</p> </li> </ul>', ], ], 'TestCaseScenarioType' => [ 'base' => NULL, 'refs' => [ 'TestCaseScenario$testCaseScenarioType' => '<p>Provides test case scenario type. Type is one of the following:</p> <ul> <li> <p>Advanced</p> </li> <li> <p>Basic</p> </li> </ul>', ], ], 'TestCaseScenariosList' => [ 'base' => NULL, 'refs' => [ 'TestCaseRun$testScenarios' => '<p> Provides the test scenarios for the test case run. </p>', ], ], 'TestResult' => [ 'base' => '<p>Show each group result.</p>', 'refs' => [ 'GetSuiteRunResponse$testResult' => '<p>Test results for the test suite run.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateSuiteDefinitionResponse$createdAt' => '<p>Creates a Device Advisor test suite with TimeStamp of when it was created.</p>', 'GetSuiteDefinitionResponse$createdAt' => '<p>Date (in Unix epoch time) when the suite definition was created.</p>', 'GetSuiteDefinitionResponse$lastModifiedAt' => '<p>Date (in Unix epoch time) when the suite definition was last modified.</p>', 'GetSuiteRunResponse$startTime' => '<p>Date (in Unix epoch time) when the test suite run started.</p>', 'GetSuiteRunResponse$endTime' => '<p>Date (in Unix epoch time) when the test suite run ended.</p>', 'StartSuiteRunResponse$createdAt' => '<p>Starts a Device Advisor test suite run based on suite create time.</p>', 'SuiteDefinitionInformation$createdAt' => '<p>Date (in Unix epoch time) when the test suite was created.</p>', 'SuiteRunInformation$createdAt' => '<p>Date (in Unix epoch time) when the suite run was created.</p>', 'SuiteRunInformation$startedAt' => '<p>Date (in Unix epoch time) when the suite run was started.</p>', 'SuiteRunInformation$endAt' => '<p>Date (in Unix epoch time) when the suite run ended.</p>', 'TestCaseRun$startTime' => '<p>Provides test case run start time.</p>', 'TestCaseRun$endTime' => '<p>Provides test case run end time.</p>', 'UpdateSuiteDefinitionResponse$createdAt' => '<p>Timestamp of when the test suite was created.</p>', 'UpdateSuiteDefinitionResponse$lastUpdatedAt' => '<p>Timestamp of when the test suite was updated.</p>', ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListSuiteDefinitionsRequest$nextToken' => '<p>A token used to get the next set of results.</p>', 'ListSuiteDefinitionsResponse$nextToken' => '<p>A token used to get the next set of results.</p>', 'ListSuiteRunsRequest$nextToken' => '<p>A token to retrieve the next set of results.</p>', 'ListSuiteRunsResponse$nextToken' => '<p>A token to retrieve the next set of results.</p>', ], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'CreateSuiteDefinitionResponse$suiteDefinitionId' => '<p>Creates a Device Advisor test suite with suite UUID.</p>', 'DeleteSuiteDefinitionRequest$suiteDefinitionId' => '<p>Suite definition ID of the test suite to be deleted.</p>', 'GetSuiteDefinitionRequest$suiteDefinitionId' => '<p>Suite definition ID of the test suite to get.</p>', 'GetSuiteDefinitionResponse$suiteDefinitionId' => '<p>Suite definition ID of the suite definition.</p>', 'GetSuiteRunReportRequest$suiteDefinitionId' => '<p>Suite definition ID of the test suite.</p>', 'GetSuiteRunReportRequest$suiteRunId' => '<p>Suite run ID of the test suite run.</p>', 'GetSuiteRunRequest$suiteDefinitionId' => '<p>Suite definition ID for the test suite run.</p>', 'GetSuiteRunRequest$suiteRunId' => '<p>Suite run ID for the test suite run.</p>', 'GetSuiteRunResponse$suiteDefinitionId' => '<p>Suite definition ID for the test suite run.</p>', 'GetSuiteRunResponse$suiteRunId' => '<p>Suite run ID for the test suite run.</p>', 'GroupResult$groupId' => '<p>Group result ID.</p>', 'ListSuiteRunsRequest$suiteDefinitionId' => '<p>Lists the test suite runs of the specified test suite based on suite definition ID.</p>', 'SelectedTestList$member' => NULL, 'StartSuiteRunRequest$suiteDefinitionId' => '<p>Suite definition ID of the test suite.</p>', 'StartSuiteRunResponse$suiteRunId' => '<p>Suite Run ID of the started suite run.</p>', 'StopSuiteRunRequest$suiteDefinitionId' => '<p>Suite definition ID of the test suite run to be stopped.</p>', 'StopSuiteRunRequest$suiteRunId' => '<p>Suite run ID of the test suite run to be stopped.</p>', 'SuiteDefinitionInformation$suiteDefinitionId' => '<p>Suite definition ID of the test suite.</p>', 'SuiteRunInformation$suiteDefinitionId' => '<p>Suite definition ID of the suite run.</p>', 'SuiteRunInformation$suiteRunId' => '<p>Suite run ID of the suite run.</p>', 'TestCaseRun$testCaseRunId' => '<p>Provides the test case run ID.</p>', 'TestCaseRun$testCaseDefinitionId' => '<p>Provides the test case run definition ID.</p>', 'UpdateSuiteDefinitionRequest$suiteDefinitionId' => '<p>Suite definition ID of the test suite to be updated.</p>', 'UpdateSuiteDefinitionResponse$suiteDefinitionId' => '<p>Suite definition ID of the updated test suite.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSuiteDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSuiteDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Sends a validation exception.</p>', 'refs' => [], ], 'Warnings' => [ 'base' => NULL, 'refs' => [ 'TestCaseRun$warnings' => '<p>Provides test case run warnings.</p>', ], ], ],];
