<?php
// This file was auto-generated from sdk-root/src/data/elasticmapreduce/2009-03-31/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon EMR is a web service that makes it easier to process large amounts of data efficiently. Amazon EMR uses Hadoop processing combined with several Amazon Web Services services to do tasks such as web indexing, data mining, log file analysis, machine learning, scientific simulation, and data warehouse management.</p>', 'operations' => [ 'AddInstanceFleet' => '<p>Adds an instance fleet to a running cluster.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x.</p> </note>', 'AddInstanceGroups' => '<p>Adds one or more instance groups to a running cluster.</p>', 'AddJobFlowSteps' => '<p>AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed in each job flow.</p> <p>If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using SSH to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop. For more information on how to do this, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to a Cluster</a> in the <i>Amazon EMR Management Guide</i>.</p> <p>A step specifies the location of a JAR file stored either on the master node of the cluster or in Amazon S3. Each step is performed by the main function of the main class of the JAR file. The main class can be specified either in the manifest of the JAR or by using the MainFunction parameter of the step.</p> <p>Amazon EMR executes each step in the order listed. For a step to be considered complete, the main function must exit with a zero exit code and all Hadoop jobs started while the step was running must have completed and run successfully.</p> <p>You can only add steps to a cluster that is in one of the following states: STARTING, BOOTSTRAPPING, RUNNING, or WAITING.</p> <note> <p>The string values passed into <code>HadoopJarStep</code> object cannot exceed a total of 10240 characters.</p> </note>', 'AddTags' => '<p>Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>. </p>', 'CancelSteps' => '<p>Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a <code>PENDING</code> or <code>RUNNING</code> state. In earlier versions of Amazon EMR, you can only cancel steps that are in a <code>PENDING</code> state. </p>', 'CreateSecurityConfiguration' => '<p>Creates a security configuration, which is stored in the service and can be specified when a cluster is created.</p>', 'CreateStudio' => '<p>Creates a new Amazon EMR Studio.</p>', 'CreateStudioSessionMapping' => '<p>Maps a user or group to the Amazon EMR Studio specified by <code>StudioId</code>, and applies a session policy to refine Studio permissions for that user or group. Use <code>CreateStudioSessionMapping</code> to assign users to a Studio when you use Amazon Web Services SSO authentication. For instructions on how to assign users to a Studio when you use IAM authentication, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups">Assign a user or group to your EMR Studio</a>.</p>', 'DeleteSecurityConfiguration' => '<p>Deletes a security configuration.</p>', 'DeleteStudio' => '<p>Removes an Amazon EMR Studio from the Studio metadata store.</p>', 'DeleteStudioSessionMapping' => '<p>Removes a user or group from an Amazon EMR Studio.</p>', 'DescribeCluster' => '<p>Provides cluster-level details including status, hardware and software configuration, VPC settings, and so on.</p>', 'DescribeJobFlows' => '<p>This API is no longer supported and will eventually be removed. We recommend you use <a>ListClusters</a>, <a>DescribeCluster</a>, <a>ListSteps</a>, <a>ListInstanceGroups</a> and <a>ListBootstrapActions</a> instead.</p> <p>DescribeJobFlows returns a list of job flows that match all of the supplied parameters. The parameters can include a list of job flow IDs, job flow states, and restrictions on job flow creation date and time.</p> <p>Regardless of supplied parameters, only job flows created within the last two months are returned.</p> <p>If no parameters are supplied, then job flows matching either of the following criteria are returned:</p> <ul> <li> <p>Job flows created and completed in the last two weeks</p> </li> <li> <p> Job flows created within the last two months that are in one of the following states: <code>RUNNING</code>, <code>WAITING</code>, <code>SHUTTING_DOWN</code>, <code>STARTING</code> </p> </li> </ul> <p>Amazon EMR can return a maximum of 512 job flow descriptions.</p>', 'DescribeNotebookExecution' => '<p>Provides details of a notebook execution.</p>', 'DescribeReleaseLabel' => '<p>Provides EMR release label details, such as releases available the region where the API request is run, and the available applications for a specific EMR release label. Can also list EMR release versions that support a specified version of Spark.</p>', 'DescribeSecurityConfiguration' => '<p>Provides the details of a security configuration by returning the configuration JSON.</p>', 'DescribeStep' => '<p>Provides more detail about the cluster step.</p>', 'DescribeStudio' => '<p>Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.</p>', 'GetAutoTerminationPolicy' => '<p>Returns the auto-termination policy for an Amazon EMR cluster.</p>', 'GetBlockPublicAccessConfiguration' => '<p>Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.</p>', 'GetManagedScalingPolicy' => '<p>Fetches the attached managed scaling policy for an Amazon EMR cluster. </p>', 'GetStudioSessionMapping' => '<p>Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).</p>', 'ListBootstrapActions' => '<p>Provides information about the bootstrap actions associated with a cluster.</p>', 'ListClusters' => '<p>Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter the list of clusters based on certain criteria; for example, filtering by cluster creation date and time or by status. This call returns a maximum of 50 clusters in unsorted order per call, but returns a marker to track the paging of the cluster list across multiple ListClusters calls.</p>', 'ListInstanceFleets' => '<p>Lists all available details about the instance fleets in a cluster.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'ListInstanceGroups' => '<p>Provides all available details about the instance groups in a cluster.</p>', 'ListInstances' => '<p>Provides information for all active EC2 instances and EC2 instances terminated in the last 30 days, up to a maximum of 2,000. EC2 instances in any of the following states are considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.</p>', 'ListNotebookExecutions' => '<p>Provides summaries of all notebook executions. You can filter the list based on multiple criteria such as status, time range, and editor id. Returns a maximum of 50 notebook executions and a marker to track the paging of a longer notebook execution list across multiple <code>ListNotebookExecution</code> calls.</p>', 'ListReleaseLabels' => '<p>Retrieves release labels of EMR services in the region where the API is called.</p>', 'ListSecurityConfigurations' => '<p>Lists all the security configurations visible to this account, providing their creation dates and times, and their names. This call returns a maximum of 50 clusters per call, but returns a marker to track the paging of the cluster list across multiple ListSecurityConfigurations calls.</p>', 'ListSteps' => '<p>Provides a list of steps for the cluster in reverse order unless you specify <code>stepIds</code> with the request or filter by <code>StepStates</code>. You can specify a maximum of 10 <code>stepIDs</code>. The CLI automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the CLI, specify a <code>Marker</code>, which is a pagination token that indicates the next set of steps to retrieve.</p>', 'ListStudioSessionMappings' => '<p>Returns a list of all user or group session mappings for the Amazon EMR Studio specified by <code>StudioId</code>.</p>', 'ListStudios' => '<p>Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list includes details such as ID, Studio Access URL, and creation time for each Studio.</p>', 'ModifyCluster' => '<p>Modifies the number of steps that can be executed concurrently for the cluster specified using ClusterID.</p>', 'ModifyInstanceFleet' => '<p>Modifies the target On-Demand and target Spot capacities for the instance fleet with the specified InstanceFleetID within the cluster specified using ClusterID. The call either succeeds or fails atomically.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'ModifyInstanceGroups' => '<p>ModifyInstanceGroups modifies the number of nodes and configuration settings of an instance group. The input parameters include the new target instance count for the group and the instance group ID. The call will either succeed or fail atomically.</p>', 'PutAutoScalingPolicy' => '<p>Creates or updates an automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric.</p>', 'PutAutoTerminationPolicy' => '<note> <p>Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html">Using an auto-termination policy</a>.</p> </note> <p>Creates or updates an auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>', 'PutBlockPublicAccessConfiguration' => '<p>Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account in the current Region. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block Public Access for Amazon EMR</a> in the <i>Amazon EMR Management Guide</i>.</p>', 'PutManagedScalingPolicy' => '<p>Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed scaling policy defines the limits for resources, such as EC2 instances that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration. </p>', 'RemoveAutoScalingPolicy' => '<p>Removes an automatic scaling policy from a specified instance group within an EMR cluster.</p>', 'RemoveAutoTerminationPolicy' => '<p>Removes an auto-termination policy from an Amazon EMR cluster.</p>', 'RemoveManagedScalingPolicy' => '<p> Removes a managed scaling policy from a specified EMR cluster. </p>', 'RemoveTags' => '<p>Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to associate resources in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>. </p> <p>The following example removes the stack tag with value Prod from a cluster:</p>', 'RunJobFlow' => '<p>RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the steps specified. After the steps complete, the cluster stops and the HDFS partition is lost. To prevent loss of data, configure the last step of the job flow to store results in Amazon S3. If the <a>JobFlowInstancesConfig</a> <code>KeepJobFlowAliveWhenNoSteps</code> parameter is set to <code>TRUE</code>, the cluster transitions to the WAITING state rather than shutting down after the steps have completed. </p> <p>For additional protection, you can set the <a>JobFlowInstancesConfig</a> <code>TerminationProtected</code> parameter to <code>TRUE</code> to lock the cluster and prevent it from being terminated by API call, user intervention, or in the event of a job flow error.</p> <p>A maximum of 256 steps are allowed in each job flow.</p> <p>If your cluster is long-running (such as a Hive data warehouse) or complex, you may require more than 256 steps to process your data. You can bypass the 256-step limitation in various ways, including using the SSH shell to connect to the master node and submitting queries directly to the software running on the master node, such as Hive and Hadoop. For more information on how to do this, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to a Cluster</a> in the <i>Amazon EMR Management Guide</i>.</p> <p>For long running clusters, we recommend that you periodically store your results.</p> <note> <p>The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. The RunJobFlow request can contain InstanceFleets parameters or InstanceGroups parameters, but not both.</p> </note>', 'SetTerminationProtection' => '<p>SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful completion of the job flow. Calling <code>SetTerminationProtection</code> on a cluster is similar to calling the Amazon EC2 <code>DisableAPITermination</code> API on all EC2 instances in a cluster.</p> <p> <code>SetTerminationProtection</code> is used to prevent accidental termination of a cluster and to ensure that in the event of an error, the instances persist so that you can recover any data stored in their ephemeral instance storage.</p> <p> To terminate a cluster that has been locked by setting <code>SetTerminationProtection</code> to <code>true</code>, you must first unlock the job flow by a subsequent call to <code>SetTerminationProtection</code> in which you set the value to <code>false</code>. </p> <p> For more information, see<a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html">Managing Cluster Termination</a> in the <i>Amazon EMR Management Guide</i>. </p>', 'SetVisibleToAllUsers' => '<important> <p>The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your account. To restrict cluster access using an IAM policy, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html">Identity and Access Management for EMR</a>. </p> </important> <p>Sets the <a>Cluster$VisibleToAllUsers</a> value for an EMR cluster. When <code>true</code>, IAM principals in the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions on the cluster, regardless of IAM permissions policies attached to other IAM principals.</p> <p>This action works on running clusters. When you create a cluster, use the <a>RunJobFlowInput$VisibleToAllUsers</a> parameter.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>', 'StartNotebookExecution' => '<p>Starts a notebook execution.</p>', 'StopNotebookExecution' => '<p>Stops a notebook execution.</p>', 'TerminateJobFlows' => '<p>TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut down, any step not yet completed is canceled and the EC2 instances on which the cluster is running are stopped. Any log files not already saved are uploaded to Amazon S3 if a LogUri was specified when the cluster was created.</p> <p>The maximum number of clusters allowed is 10. The call to <code>TerminateJobFlows</code> is asynchronous. Depending on the configuration of the cluster, it may take up to 1-5 minutes for the cluster to completely terminate and release allocated resources, such as Amazon EC2 instances.</p>', 'UpdateStudio' => '<p>Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.</p>', 'UpdateStudioSessionMapping' => '<p>Updates the session policy attached to the user or group for the specified Amazon EMR Studio.</p>', ], 'shapes' => [ 'ActionOnFailure' => [ 'base' => NULL, 'refs' => [ 'Step$ActionOnFailure' => '<p>The action to take when the cluster step fails. Possible values are <code>TERMINATE_CLUSTER</code>, <code>CANCEL_AND_WAIT</code>, and <code>CONTINUE</code>. <code>TERMINATE_JOB_FLOW</code> is provided for backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.</p> <p>If a cluster\'s <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the <code>ActionOnFailure</code> setting is not valid.</p> <p>If you change a cluster\'s <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.</p>', 'StepConfig$ActionOnFailure' => '<p>The action to take when the step fails. Use one of the following values:</p> <ul> <li> <p> <code>TERMINATE_CLUSTER</code> - Shuts down the cluster.</p> </li> <li> <p> <code>CANCEL_AND_WAIT</code> - Cancels any pending steps and returns the cluster to the <code>WAITING</code> state.</p> </li> <li> <p> <code>CONTINUE</code> - Continues to the next step in the queue.</p> </li> <li> <p> <code>TERMINATE_JOB_FLOW</code> - Shuts down the cluster. <code>TERMINATE_JOB_FLOW</code> is provided for backward compatibility. We recommend using <code>TERMINATE_CLUSTER</code> instead.</p> </li> </ul> <p>If a cluster\'s <code>StepConcurrencyLevel</code> is greater than <code>1</code>, do not use <code>AddJobFlowSteps</code> to submit a step with this parameter set to <code>CANCEL_AND_WAIT</code> or <code>TERMINATE_CLUSTER</code>. The step is not submitted and the action fails with a message that the <code>ActionOnFailure</code> setting is not valid.</p> <p>If you change a cluster\'s <code>StepConcurrencyLevel</code> to be greater than 1 while a step is running, the <code>ActionOnFailure</code> parameter may not behave as you expect. In this case, for a step that fails with this parameter set to <code>CANCEL_AND_WAIT</code>, pending steps and the running step are not canceled; for a step that fails with this parameter set to <code>TERMINATE_CLUSTER</code>, the cluster does not terminate.</p>', 'StepSummary$ActionOnFailure' => '<p>The action to take when the cluster step fails. Possible values are TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE. TERMINATE_JOB_FLOW is available for backward compatibility.</p>', ], ], 'AddInstanceFleetInput' => [ 'base' => NULL, 'refs' => [], ], 'AddInstanceFleetOutput' => [ 'base' => NULL, 'refs' => [], ], 'AddInstanceGroupsInput' => [ 'base' => '<p>Input to an AddInstanceGroups call.</p>', 'refs' => [], ], 'AddInstanceGroupsOutput' => [ 'base' => '<p>Output from an AddInstanceGroups call.</p>', 'refs' => [], ], 'AddJobFlowStepsInput' => [ 'base' => '<p> The input argument to the <a>AddJobFlowSteps</a> operation. </p>', 'refs' => [], ], 'AddJobFlowStepsOutput' => [ 'base' => '<p> The output for the <a>AddJobFlowSteps</a> operation. </p>', 'refs' => [], ], 'AddTagsInput' => [ 'base' => '<p>This input identifies an Amazon EMR resource and a list of tags to attach.</p>', 'refs' => [], ], 'AddTagsOutput' => [ 'base' => '<p>This output indicates the result of adding tags to a resource.</p>', 'refs' => [], ], 'AdjustmentType' => [ 'base' => NULL, 'refs' => [ 'SimpleScalingPolicyConfiguration$AdjustmentType' => '<p>The way in which EC2 instances are added (if <code>ScalingAdjustment</code> is a positive number) or terminated (if <code>ScalingAdjustment</code> is a negative number) each time the scaling activity is triggered. <code>CHANGE_IN_CAPACITY</code> is the default. <code>CHANGE_IN_CAPACITY</code> indicates that the EC2 instance count increments or decrements by <code>ScalingAdjustment</code>, which should be expressed as an integer. <code>PERCENT_CHANGE_IN_CAPACITY</code> indicates the instance count increments or decrements by the percentage specified by <code>ScalingAdjustment</code>, which should be expressed as an integer. For example, 20 indicates an increase in 20% increments of cluster capacity. <code>EXACT_CAPACITY</code> indicates the scaling activity results in an instance group with the number of EC2 instances specified by <code>ScalingAdjustment</code>, which should be expressed as a positive integer.</p>', ], ], 'Application' => [ 'base' => '<p>With Amazon EMR release version 4.0 and later, the only accepted parameter is the application name. To pass arguments to applications, you use configuration classifications specified using configuration JSON objects. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring Applications</a>.</p> <p>With earlier Amazon EMR releases, the application is any Amazon or third-party software that you can add to the cluster. This structure contains a list of strings that indicates the software to use with the cluster and accepts a user argument list. Amazon EMR accepts and forwards the argument list to the corresponding installation script as bootstrap action argument.</p>', 'refs' => [ 'ApplicationList$member' => NULL, ], ], 'ApplicationList' => [ 'base' => NULL, 'refs' => [ 'Cluster$Applications' => '<p>The applications installed on this cluster.</p>', 'RunJobFlowInput$Applications' => '<p>Applies to Amazon EMR releases 4.0 and later. A case-insensitive list of applications for Amazon EMR to install and configure when launching the cluster. For a list of applications available for each Amazon EMR release version, see the <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">Amazon EMRRelease Guide</a>.</p>', ], ], 'ArnType' => [ 'base' => NULL, 'refs' => [ 'AddInstanceFleetOutput$ClusterArn' => '<p>The Amazon Resource Name of the cluster.</p>', 'AddInstanceGroupsOutput$ClusterArn' => '<p>The Amazon Resource Name of the cluster.</p>', 'AddJobFlowStepsInput$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the runtime role for a step on the cluster. The runtime role can be a cross-account IAM role. The runtime role ARN is a combination of account ID, role name, and role type using the following format: <code>arn:partition:service:region:account:resource</code>. </p> <p>For example, <code>arn:aws:iam::1234567890:role/ReadOnly</code> is a correctly formatted runtime role ARN.</p>', 'BlockPublicAccessConfigurationMetadata$CreatedByArn' => '<p>The Amazon Resource Name that created or last modified the configuration.</p>', 'Cluster$ClusterArn' => '<p>The Amazon Resource Name of the cluster.</p>', 'ClusterSummary$ClusterArn' => '<p>The Amazon Resource Name of the cluster.</p>', 'PutAutoScalingPolicyOutput$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'RunJobFlowOutput$ClusterArn' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', ], ], 'AuthMode' => [ 'base' => NULL, 'refs' => [ 'CreateStudioInput$AuthMode' => '<p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>', 'Studio$AuthMode' => '<p>Specifies whether the Amazon EMR Studio authenticates users using IAM or Amazon Web Services SSO.</p>', 'StudioSummary$AuthMode' => '<p>Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.</p>', ], ], 'AutoScalingPolicy' => [ 'base' => '<p>An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. An automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. See <a>PutAutoScalingPolicy</a>.</p>', 'refs' => [ 'InstanceGroupConfig$AutoScalingPolicy' => '<p>An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. See <a>PutAutoScalingPolicy</a>.</p>', 'PutAutoScalingPolicyInput$AutoScalingPolicy' => '<p>Specifies the definition of the automatic scaling policy.</p>', ], ], 'AutoScalingPolicyDescription' => [ 'base' => '<p>An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. See <a>PutAutoScalingPolicy</a>.</p>', 'refs' => [ 'InstanceGroup$AutoScalingPolicy' => '<p>An automatic scaling policy for a core instance group or task instance group in an Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically adds and terminates EC2 instances in response to the value of a CloudWatch metric. See PutAutoScalingPolicy.</p>', 'PutAutoScalingPolicyOutput$AutoScalingPolicy' => '<p>The automatic scaling policy definition.</p>', ], ], 'AutoScalingPolicyState' => [ 'base' => NULL, 'refs' => [ 'AutoScalingPolicyStatus$State' => '<p>Indicates the status of the automatic scaling policy.</p>', ], ], 'AutoScalingPolicyStateChangeReason' => [ 'base' => '<p>The reason for an <a>AutoScalingPolicyStatus</a> change.</p>', 'refs' => [ 'AutoScalingPolicyStatus$StateChangeReason' => '<p>The reason for a change in status.</p>', ], ], 'AutoScalingPolicyStateChangeReasonCode' => [ 'base' => NULL, 'refs' => [ 'AutoScalingPolicyStateChangeReason$Code' => '<p>The code indicating the reason for the change in status.<code>USER_REQUEST</code> indicates that the scaling policy status was changed by a user. <code>PROVISION_FAILURE</code> indicates that the status change was because the policy failed to provision. <code>CLEANUP_FAILURE</code> indicates an error.</p>', ], ], 'AutoScalingPolicyStatus' => [ 'base' => '<p>The status of an automatic scaling policy. </p>', 'refs' => [ 'AutoScalingPolicyDescription$Status' => '<p>The status of an automatic scaling policy. </p>', ], ], 'AutoTerminationPolicy' => [ 'base' => '<p>An auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination</a>.</p>', 'refs' => [ 'GetAutoTerminationPolicyOutput$AutoTerminationPolicy' => '<p>Specifies the auto-termination policy that is attached to an Amazon EMR cluster. </p>', 'PutAutoTerminationPolicyInput$AutoTerminationPolicy' => '<p>Specifies the auto-termination policy to attach to the cluster.</p>', 'RunJobFlowInput$AutoTerminationPolicy' => NULL, ], ], 'BlockPublicAccessConfiguration' => [ 'base' => '<p>A configuration for Amazon EMR block public access. When <code>BlockPublicSecurityGroupRules</code> is set to <code>true</code>, Amazon EMR prevents cluster creation if one of the cluster\'s security groups has a rule that allows inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using <code>PermittedPublicSecurityGroupRuleRanges</code>.</p>', 'refs' => [ 'GetBlockPublicAccessConfigurationOutput$BlockPublicAccessConfiguration' => '<p>A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your account for the current Region. The configuration specifies whether block public access is enabled. If block public access is enabled, security groups associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using <code>PermittedPublicSecurityGroupRuleRanges</code> in the <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by updating the block public access configuration to remove the exception.</p> <note> <p>For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by default in that Region. To use this feature, you must manually enable and configure it. For accounts that did not create an EMR cluster in a Region before this date, block public access is enabled by default in that Region.</p> </note>', 'PutBlockPublicAccessConfigurationInput$BlockPublicAccessConfiguration' => '<p>A configuration for Amazon EMR block public access. The configuration applies to all clusters created in your account for the current Region. The configuration specifies whether block public access is enabled. If block public access is enabled, security groups associated with the cluster cannot have rules that allow inbound traffic from 0.0.0.0/0 or ::/0 on a port, unless the port is specified as an exception using <code>PermittedPublicSecurityGroupRuleRanges</code> in the <code>BlockPublicAccessConfiguration</code>. By default, Port 22 (SSH) is an exception, and public access is allowed on this port. You can change this by updating <code>BlockPublicSecurityGroupRules</code> to remove the exception.</p> <note> <p>For accounts that created clusters in a Region before November 25, 2019, block public access is disabled by default in that Region. To use this feature, you must manually enable and configure it. For accounts that did not create an EMR cluster in a Region before this date, block public access is enabled by default in that Region.</p> </note>', ], ], 'BlockPublicAccessConfigurationMetadata' => [ 'base' => '<p>Properties that describe the Amazon Web Services principal that created the <code>BlockPublicAccessConfiguration</code> using the <code>PutBlockPublicAccessConfiguration</code> action as well as the date and time that the configuration was created. Each time a configuration for block public access is updated, Amazon EMR updates this metadata.</p>', 'refs' => [ 'GetBlockPublicAccessConfigurationOutput$BlockPublicAccessConfigurationMetadata' => '<p>Properties that describe the Amazon Web Services principal that created the <code>BlockPublicAccessConfiguration</code> using the <code>PutBlockPublicAccessConfiguration</code> action as well as the date and time that the configuration was created. Each time a configuration for block public access is updated, Amazon EMR updates this metadata.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'BlockPublicAccessConfiguration$BlockPublicSecurityGroupRules' => '<p>Indicates whether Amazon EMR block public access is enabled (<code>true</code>) or disabled (<code>false</code>). By default, the value is <code>false</code> for accounts that have created EMR clusters before July 2019. For accounts created after this, the default is <code>true</code>.</p>', 'Cluster$AutoTerminate' => '<p>Specifies whether the cluster should terminate after completing all steps.</p>', 'Cluster$TerminationProtected' => '<p>Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from being terminated by an API call or user intervention, or in the event of a cluster error.</p>', 'Cluster$VisibleToAllUsers' => '<p>Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated with the cluster. When <code>true</code>, IAM principals in the Amazon Web Services account can perform EMR cluster actions on the cluster that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.</p> <p>The default value is <code>true</code> if a value is not provided when creating a cluster using the EMR API <a>RunJobFlow</a> command, the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command, or the Amazon Web Services Management Console.</p>', 'JobFlowDetail$VisibleToAllUsers' => '<p>Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated with the cluster. When <code>true</code>, IAM principals in the Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.</p> <p>The default value is <code>true</code> if a value is not provided when creating a cluster using the EMR API <a>RunJobFlow</a> command, the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command, or the Amazon Web Services Management Console.</p>', 'JobFlowInstancesConfig$KeepJobFlowAliveWhenNoSteps' => '<p>Specifies whether the cluster should remain available after completing all steps. Defaults to <code>true</code>. For more information about configuring cluster termination, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control Cluster Termination</a> in the <i>EMR Management Guide</i>.</p>', 'JobFlowInstancesConfig$TerminationProtected' => '<p>Specifies whether to lock the cluster to prevent the Amazon EC2 instances from being terminated by API call, user intervention, or in the event of a job-flow error.</p>', 'JobFlowInstancesDetail$KeepJobFlowAliveWhenNoSteps' => '<p>Specifies whether the cluster should remain available after completing all steps.</p>', 'JobFlowInstancesDetail$TerminationProtected' => '<p>Specifies whether the Amazon EC2 instances in the cluster are protected from termination by API calls, user intervention, or in the event of a job-flow error.</p>', 'RunJobFlowInput$VisibleToAllUsers' => '<important> <p>The VisibleToAllUsers parameter is no longer supported. By default, the value is set to <code>true</code>. Setting it to <code>false</code> now has no effect.</p> </important> <p>Set this value to <code>true</code> so that IAM principals in the Amazon Web Services account associated with the cluster can perform EMR actions on the cluster that their IAM policies allow. This value defaults to <code>true</code> for clusters created using the EMR API or the CLI <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster</a> command.</p> <p>When set to <code>false</code>, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions for the cluster, regardless of the IAM permissions policies attached to other IAM principals. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting</a> in the <i>Amazon EMRManagement Guide</i>.</p>', 'SetTerminationProtectionInput$TerminationProtected' => '<p>A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2 instances in the cluster from shutting down due to API calls, user intervention, or job-flow error.</p>', 'SetVisibleToAllUsersInput$VisibleToAllUsers' => '<p>A value of <code>true</code> indicates that an IAM principal in the Amazon Web Services account can perform EMR actions on the cluster that the IAM policies attached to the principal allow. A value of <code>false</code> indicates that only the IAM principal that created the cluster and the Amazon Web Services root user can perform EMR actions on the cluster.</p>', ], ], 'BooleanObject' => [ 'base' => NULL, 'refs' => [ 'EbsConfiguration$EbsOptimized' => '<p>Indicates whether an Amazon EBS volume is EBS-optimized.</p>', 'InstanceGroup$EbsOptimized' => '<p>If the instance group is EBS-optimized. An Amazon EBS-optimized instance uses an optimized configuration stack and provides additional, dedicated capacity for Amazon EBS I/O.</p>', 'InstanceTypeSpecification$EbsOptimized' => '<p>Evaluates to <code>TRUE</code> when the specified <code>InstanceType</code> is EBS-optimized.</p>', ], ], 'BootstrapActionConfig' => [ 'base' => '<p>Configuration of a bootstrap action.</p>', 'refs' => [ 'BootstrapActionConfigList$member' => NULL, 'BootstrapActionDetail$BootstrapActionConfig' => '<p>A description of the bootstrap action.</p>', ], ], 'BootstrapActionConfigList' => [ 'base' => NULL, 'refs' => [ 'RunJobFlowInput$BootstrapActions' => '<p>A list of bootstrap actions to run before Hadoop starts on the cluster nodes.</p>', ], ], 'BootstrapActionDetail' => [ 'base' => '<p>Reports the configuration of a bootstrap action in a cluster (job flow).</p>', 'refs' => [ 'BootstrapActionDetailList$member' => NULL, ], ], 'BootstrapActionDetailList' => [ 'base' => NULL, 'refs' => [ 'JobFlowDetail$BootstrapActions' => '<p>A list of the bootstrap actions run by the job flow.</p>', ], ], 'CancelStepsInfo' => [ 'base' => '<p>Specification of the status of a CancelSteps request. Available only in Amazon EMR version 4.8.0 and later, excluding version 5.0.0.</p>', 'refs' => [ 'CancelStepsInfoList$member' => NULL, ], ], 'CancelStepsInfoList' => [ 'base' => NULL, 'refs' => [ 'CancelStepsOutput$CancelStepsInfoList' => '<p>A list of <a>CancelStepsInfo</a>, which shows the status of specified cancel requests for each <code>StepID</code> specified.</p>', ], ], 'CancelStepsInput' => [ 'base' => '<p>The input argument to the <a>CancelSteps</a> operation.</p>', 'refs' => [], ], 'CancelStepsOutput' => [ 'base' => '<p> The output for the <a>CancelSteps</a> operation. </p>', 'refs' => [], ], 'CancelStepsRequestStatus' => [ 'base' => NULL, 'refs' => [ 'CancelStepsInfo$Status' => '<p>The status of a CancelSteps Request. The value may be SUBMITTED or FAILED.</p>', ], ], 'CloudWatchAlarmDefinition' => [ 'base' => '<p>The definition of a CloudWatch metric alarm, which determines when an automatic scaling activity is triggered. When the defined alarm conditions are satisfied, scaling activity begins.</p>', 'refs' => [ 'ScalingTrigger$CloudWatchAlarmDefinition' => '<p>The definition of a CloudWatch metric alarm. When the defined alarm conditions are met along with other trigger parameters, scaling activity begins.</p>', ], ], 'Cluster' => [ 'base' => '<p>The detailed description of the cluster.</p>', 'refs' => [ 'DescribeClusterOutput$Cluster' => '<p>This output contains the details for the requested cluster.</p>', ], ], 'ClusterId' => [ 'base' => NULL, 'refs' => [ 'Cluster$Id' => '<p>The unique identifier for the cluster.</p>', 'ClusterSummary$Id' => '<p>The unique identifier for the cluster.</p>', 'DescribeClusterInput$ClusterId' => '<p>The identifier of the cluster to describe.</p>', 'DescribeStepInput$ClusterId' => '<p>The identifier of the cluster with steps to describe.</p>', 'GetAutoTerminationPolicyInput$ClusterId' => '<p>Specifies the ID of the Amazon EMR cluster for which the auto-termination policy will be fetched.</p>', 'GetManagedScalingPolicyInput$ClusterId' => '<p>Specifies the ID of the cluster for which the managed scaling policy will be fetched. </p>', 'ListBootstrapActionsInput$ClusterId' => '<p>The cluster identifier for the bootstrap actions to list.</p>', 'ListInstanceFleetsInput$ClusterId' => '<p>The unique identifier of the cluster.</p>', 'ListInstanceGroupsInput$ClusterId' => '<p>The identifier of the cluster for which to list the instance groups.</p>', 'ListInstancesInput$ClusterId' => '<p>The identifier of the cluster for which to list the instances.</p>', 'ListStepsInput$ClusterId' => '<p>The identifier of the cluster for which to list the steps.</p>', 'ModifyInstanceFleetInput$ClusterId' => '<p>The unique identifier of the cluster.</p>', 'ModifyInstanceGroupsInput$ClusterId' => '<p>The ID of the cluster to which the instance group belongs.</p>', 'PutAutoScalingPolicyInput$ClusterId' => '<p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>', 'PutAutoScalingPolicyOutput$ClusterId' => '<p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>', 'PutAutoTerminationPolicyInput$ClusterId' => '<p>Specifies the ID of the Amazon EMR cluster to which the auto-termination policy will be attached.</p>', 'PutManagedScalingPolicyInput$ClusterId' => '<p>Specifies the ID of an EMR cluster where the managed scaling policy is attached. </p>', 'RemoveAutoScalingPolicyInput$ClusterId' => '<p>Specifies the ID of a cluster. The instance group to which the automatic scaling policy is applied is within this cluster.</p>', 'RemoveAutoTerminationPolicyInput$ClusterId' => '<p>Specifies the ID of the Amazon EMR cluster from which the auto-termination policy will be removed.</p>', 'RemoveManagedScalingPolicyInput$ClusterId' => '<p> Specifies the ID of the cluster from which the managed scaling policy will be removed. </p>', ], ], 'ClusterState' => [ 'base' => NULL, 'refs' => [ 'ClusterStateList$member' => NULL, 'ClusterStatus$State' => '<p>The current state of the cluster.</p>', ], ], 'ClusterStateChangeReason' => [ 'base' => '<p>The reason that the cluster changed to its current state.</p>', 'refs' => [ 'ClusterStatus$StateChangeReason' => '<p>The reason for the cluster status change.</p>', ], ], 'ClusterStateChangeReasonCode' => [ 'base' => NULL, 'refs' => [ 'ClusterStateChangeReason$Code' => '<p>The programmatic code for the state change reason.</p>', ], ], 'ClusterStateList' => [ 'base' => NULL, 'refs' => [ 'ListClustersInput$ClusterStates' => '<p>The cluster state filters to apply when listing clusters. Clusters that change state while this action runs may be not be returned as expected in the list of clusters.</p>', ], ], 'ClusterStatus' => [ 'base' => '<p>The detailed status of the cluster.</p>', 'refs' => [ 'Cluster$Status' => '<p>The current status details about the cluster.</p>', 'ClusterSummary$Status' => '<p>The details about the current status of the cluster.</p>', ], ], 'ClusterSummary' => [ 'base' => '<p>The summary description of the cluster.</p>', 'refs' => [ 'ClusterSummaryList$member' => NULL, ], ], 'ClusterSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListClustersOutput$Clusters' => '<p>The list of clusters for the account based on the given filters.</p>', ], ], 'ClusterTimeline' => [ 'base' => '<p>Represents the timeline of the cluster\'s lifecycle.</p>', 'refs' => [ 'ClusterStatus$Timeline' => '<p>A timeline that represents the status of a cluster over the lifetime of the cluster.</p>', ], ], 'Command' => [ 'base' => '<p>An entity describing an executable that runs on a cluster.</p>', 'refs' => [ 'CommandList$member' => NULL, ], ], 'CommandList' => [ 'base' => NULL, 'refs' => [ 'ListBootstrapActionsOutput$BootstrapActions' => '<p>The bootstrap actions associated with the cluster.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmDefinition$ComparisonOperator' => '<p>Determines how the metric specified by <code>MetricName</code> is compared to the value specified by <code>Threshold</code>.</p>', ], ], 'ComputeLimits' => [ 'base' => '<p> The EC2 unit limits for a managed scaling policy. The managed scaling activity of a cluster can not be above or below these limits. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration. </p>', 'refs' => [ 'ManagedScalingPolicy$ComputeLimits' => '<p>The EC2 unit limits for a managed scaling policy. The managed scaling activity of a cluster is not allowed to go above or below these limits. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration.</p>', ], ], 'ComputeLimitsUnitType' => [ 'base' => NULL, 'refs' => [ 'ComputeLimits$UnitType' => '<p> The unit type used for specifying a managed scaling policy. </p>', ], ], 'Configuration' => [ 'base' => '<note> <p>Amazon EMR releases 4.x or later.</p> </note> <p>An optional configuration specification to be used when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring Applications</a>.</p>', 'refs' => [ 'ConfigurationList$member' => NULL, ], ], 'ConfigurationList' => [ 'base' => NULL, 'refs' => [ 'Cluster$Configurations' => '<p>Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied to the EMR cluster.</p>', 'Configuration$Configurations' => '<p>A list of additional configurations to apply within a configuration object.</p>', 'InstanceGroup$Configurations' => '<note> <p>Amazon EMR releases 4.x or later.</p> </note> <p>The list of configurations supplied for an Amazon EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).</p>', 'InstanceGroup$LastSuccessfullyAppliedConfigurations' => '<p>A list of configurations that were successfully applied for an instance group last time.</p>', 'InstanceGroupConfig$Configurations' => '<note> <p>Amazon EMR releases 4.x or later.</p> </note> <p>The list of configurations supplied for an EMR cluster instance group. You can specify a separate configuration for each instance group (master, core, and task).</p>', 'InstanceGroupModifyConfig$Configurations' => '<p>A list of new or modified configurations to apply for an instance group.</p>', 'InstanceTypeConfig$Configurations' => '<p>A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster.</p>', 'InstanceTypeSpecification$Configurations' => '<p>A configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR.</p>', 'RunJobFlowInput$Configurations' => '<p>For Amazon EMR releases 4.0 and later. The list of configurations supplied for the EMR cluster you are creating.</p>', ], ], 'CreateSecurityConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateStudioSessionMappingInput' => [ 'base' => NULL, 'refs' => [], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'BlockPublicAccessConfigurationMetadata$CreationDateTime' => '<p>The date and time that the configuration was created.</p>', 'ClusterTimeline$CreationDateTime' => '<p>The creation date and time of the cluster.</p>', 'ClusterTimeline$ReadyDateTime' => '<p>The date and time when the cluster was ready to run steps.</p>', 'ClusterTimeline$EndDateTime' => '<p>The date and time when the cluster was terminated.</p>', 'CreateSecurityConfigurationOutput$CreationDateTime' => '<p>The date and time the security configuration was created.</p>', 'DescribeJobFlowsInput$CreatedAfter' => '<p>Return only job flows created after this date and time.</p>', 'DescribeJobFlowsInput$CreatedBefore' => '<p>Return only job flows created before this date and time.</p>', 'DescribeSecurityConfigurationOutput$CreationDateTime' => '<p>The date and time the security configuration was created</p>', 'InstanceFleetTimeline$CreationDateTime' => '<p>The time and date the instance fleet was created.</p>', 'InstanceFleetTimeline$ReadyDateTime' => '<p>The time and date the instance fleet was ready to run jobs.</p>', 'InstanceFleetTimeline$EndDateTime' => '<p>The time and date the instance fleet terminated.</p>', 'InstanceGroupDetail$CreationDateTime' => '<p>The date/time the instance group was created.</p>', 'InstanceGroupDetail$StartDateTime' => '<p>The date/time the instance group was started.</p>', 'InstanceGroupDetail$ReadyDateTime' => '<p>The date/time the instance group was available to the cluster.</p>', 'InstanceGroupDetail$EndDateTime' => '<p>The date/time the instance group was terminated.</p>', 'InstanceGroupTimeline$CreationDateTime' => '<p>The creation date and time of the instance group.</p>', 'InstanceGroupTimeline$ReadyDateTime' => '<p>The date and time when the instance group became ready to perform tasks.</p>', 'InstanceGroupTimeline$EndDateTime' => '<p>The date and time when the instance group terminated.</p>', 'InstanceTimeline$CreationDateTime' => '<p>The creation date and time of the instance.</p>', 'InstanceTimeline$ReadyDateTime' => '<p>The date and time when the instance was ready to perform tasks.</p>', 'InstanceTimeline$EndDateTime' => '<p>The date and time when the instance was terminated.</p>', 'JobFlowExecutionStatusDetail$CreationDateTime' => '<p>The creation date and time of the job flow.</p>', 'JobFlowExecutionStatusDetail$StartDateTime' => '<p>The start date and time of the job flow.</p>', 'JobFlowExecutionStatusDetail$ReadyDateTime' => '<p>The date and time when the job flow was ready to start running bootstrap actions.</p>', 'JobFlowExecutionStatusDetail$EndDateTime' => '<p>The completion date and time of the job flow.</p>', 'ListClustersInput$CreatedAfter' => '<p>The creation date and time beginning value filter for listing clusters.</p>', 'ListClustersInput$CreatedBefore' => '<p>The creation date and time end value filter for listing clusters.</p>', 'ListNotebookExecutionsInput$From' => '<p>The beginning of time range filter for listing notebook executions. The default is the timestamp of 30 days ago.</p>', 'ListNotebookExecutionsInput$To' => '<p>The end of time range filter for listing notebook executions. The default is the current timestamp.</p>', 'NotebookExecution$StartTime' => '<p>The timestamp when notebook execution started.</p>', 'NotebookExecution$EndTime' => '<p>The timestamp when notebook execution ended.</p>', 'NotebookExecutionSummary$StartTime' => '<p>The timestamp when notebook execution started.</p>', 'NotebookExecutionSummary$EndTime' => '<p>The timestamp when notebook execution started.</p>', 'SecurityConfigurationSummary$CreationDateTime' => '<p>The date and time the security configuration was created.</p>', 'SessionMappingDetail$CreationTime' => '<p>The time the session mapping was created.</p>', 'SessionMappingDetail$LastModifiedTime' => '<p>The time the session mapping was last modified.</p>', 'SessionMappingSummary$CreationTime' => '<p>The time the session mapping was created.</p>', 'StepExecutionStatusDetail$CreationDateTime' => '<p>The creation date and time of the step.</p>', 'StepExecutionStatusDetail$StartDateTime' => '<p>The start date and time of the step.</p>', 'StepExecutionStatusDetail$EndDateTime' => '<p>The completion date and time of the step.</p>', 'StepTimeline$CreationDateTime' => '<p>The date and time when the cluster step was created.</p>', 'StepTimeline$StartDateTime' => '<p>The date and time when the cluster step execution started.</p>', 'StepTimeline$EndDateTime' => '<p>The date and time when the cluster step execution completed or failed.</p>', 'Studio$CreationTime' => '<p>The time the Amazon EMR Studio was created.</p>', 'StudioSummary$CreationTime' => '<p>The time when the Amazon EMR Studio was created.</p>', ], ], 'DeleteSecurityConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStudioSessionMappingInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClusterInput' => [ 'base' => '<p>This input determines which cluster to describe.</p>', 'refs' => [], ], 'DescribeClusterOutput' => [ 'base' => '<p>This output contains the description of the cluster.</p>', 'refs' => [], ], 'DescribeJobFlowsInput' => [ 'base' => '<p> The input for the <a>DescribeJobFlows</a> operation. </p>', 'refs' => [], ], 'DescribeJobFlowsOutput' => [ 'base' => '<p> The output for the <a>DescribeJobFlows</a> operation. </p>', 'refs' => [], ], 'DescribeNotebookExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeNotebookExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReleaseLabelInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReleaseLabelOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStepInput' => [ 'base' => '<p>This input determines which step to describe.</p>', 'refs' => [], ], 'DescribeStepOutput' => [ 'base' => '<p>This output contains the description of the cluster step.</p>', 'refs' => [], ], 'DescribeStudioInput' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStudioOutput' => [ 'base' => NULL, 'refs' => [], ], 'EC2InstanceIdsList' => [ 'base' => NULL, 'refs' => [ 'InstanceResizePolicy$InstancesToTerminate' => '<p>Specific list of instances to be terminated when shrinking an instance group.</p>', 'InstanceResizePolicy$InstancesToProtect' => '<p>Specific list of instances to be protected when shrinking an instance group.</p>', ], ], 'EC2InstanceIdsToTerminateList' => [ 'base' => NULL, 'refs' => [ 'InstanceGroupModifyConfig$EC2InstanceIdsToTerminate' => '<p>The EC2 InstanceIds to terminate. After you terminate the instances, the instance group will not return to its original requested size.</p>', ], ], 'EbsBlockDevice' => [ 'base' => '<p>Configuration of requested EBS block device associated with the instance group.</p>', 'refs' => [ 'EbsBlockDeviceList$member' => NULL, ], ], 'EbsBlockDeviceConfig' => [ 'base' => '<p>Configuration of requested EBS block device associated with the instance group with count of volumes that are associated to every instance.</p>', 'refs' => [ 'EbsBlockDeviceConfigList$member' => NULL, ], ], 'EbsBlockDeviceConfigList' => [ 'base' => NULL, 'refs' => [ 'EbsConfiguration$EbsBlockDeviceConfigs' => '<p>An array of Amazon EBS volume specifications attached to a cluster instance.</p>', ], ], 'EbsBlockDeviceList' => [ 'base' => NULL, 'refs' => [ 'InstanceGroup$EbsBlockDevices' => '<p>The EBS block devices that are mapped to this instance group.</p>', 'InstanceTypeSpecification$EbsBlockDevices' => '<p>The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by <code>InstanceType</code>.</p>', ], ], 'EbsConfiguration' => [ 'base' => '<p>The Amazon EBS configuration of a cluster instance.</p>', 'refs' => [ 'InstanceGroupConfig$EbsConfiguration' => '<p>EBS configurations that will be attached to each EC2 instance in the instance group.</p>', 'InstanceTypeConfig$EbsConfiguration' => '<p>The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by <code>InstanceType</code>. </p>', ], ], 'EbsVolume' => [ 'base' => '<p>EBS block device that\'s attached to an EC2 instance.</p>', 'refs' => [ 'EbsVolumeList$member' => NULL, ], ], 'EbsVolumeList' => [ 'base' => NULL, 'refs' => [ 'Instance$EbsVolumes' => '<p>The list of Amazon EBS volumes that are attached to this instance.</p>', ], ], 'Ec2InstanceAttributes' => [ 'base' => '<p>Provides information about the EC2 instances in a cluster grouped by category. For example, key name, subnet ID, IAM instance profile, and so on.</p>', 'refs' => [ 'Cluster$Ec2InstanceAttributes' => '<p>Provides information about the EC2 instances in a cluster grouped by category. For example, key name, subnet ID, IAM instance profile, and so on.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'InvalidRequestException$ErrorCode' => '<p>The error code associated with the exception.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Message' => '<p>The message associated with the exception.</p>', 'InvalidRequestException$Message' => '<p>The message associated with the exception.</p>', ], ], 'ExecutionEngineConfig' => [ 'base' => '<p>Specifies the execution engine (cluster) to run the notebook and perform the notebook execution, for example, an EMR cluster.</p>', 'refs' => [ 'NotebookExecution$ExecutionEngine' => '<p>The execution engine, such as an EMR cluster, used to run the EMR notebook and perform the notebook execution.</p>', 'StartNotebookExecutionInput$ExecutionEngine' => '<p>Specifies the execution engine (cluster) that runs the notebook execution.</p>', ], ], 'ExecutionEngineType' => [ 'base' => NULL, 'refs' => [ 'ExecutionEngineConfig$Type' => '<p>The type of execution engine. A value of <code>EMR</code> specifies an EMR cluster.</p>', ], ], 'FailureDetails' => [ 'base' => '<p>The details of the step failure. The service attempts to detect the root cause for many common failures.</p>', 'refs' => [ 'StepStatus$FailureDetails' => '<p>The details for the step failure including reason, message, and log file path where the root cause was identified.</p>', ], ], 'GetAutoTerminationPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetAutoTerminationPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetBlockPublicAccessConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'GetBlockPublicAccessConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedScalingPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedScalingPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioSessionMappingInput' => [ 'base' => NULL, 'refs' => [], ], 'GetStudioSessionMappingOutput' => [ 'base' => NULL, 'refs' => [], ], 'HadoopJarStepConfig' => [ 'base' => '<p>A job flow step consisting of a JAR file whose main function will be executed. The main function submits a job for Hadoop to execute and waits for the job to finish or fail.</p>', 'refs' => [ 'StepConfig$HadoopJarStep' => '<p>The JAR file used for the step.</p>', ], ], 'HadoopStepConfig' => [ 'base' => '<p>A cluster step consisting of a JAR file whose main function will be executed. The main function submits a job for Hadoop to execute and waits for the job to finish or fail.</p>', 'refs' => [ 'Step$Config' => '<p>The Hadoop job configuration of the cluster step.</p>', 'StepSummary$Config' => '<p>The Hadoop job configuration of the cluster step.</p>', ], ], 'IdentityType' => [ 'base' => NULL, 'refs' => [ 'CreateStudioSessionMappingInput$IdentityType' => '<p>Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.</p>', 'DeleteStudioSessionMappingInput$IdentityType' => '<p>Specifies whether the identity to delete from the Amazon EMR Studio is a user or a group.</p>', 'GetStudioSessionMappingInput$IdentityType' => '<p>Specifies whether the identity to fetch is a user or a group.</p>', 'ListStudioSessionMappingsInput$IdentityType' => '<p>Specifies whether to return session mappings for users or groups. If not specified, the results include session mapping details for both users and groups.</p>', 'SessionMappingDetail$IdentityType' => '<p>Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.</p>', 'SessionMappingSummary$IdentityType' => '<p>Specifies whether the identity mapped to the Amazon EMR Studio is a user or a group.</p>', 'UpdateStudioSessionMappingInput$IdentityType' => '<p>Specifies whether the identity to update is a user or a group.</p>', ], ], 'Instance' => [ 'base' => '<p>Represents an EC2 instance provisioned as part of cluster.</p>', 'refs' => [ 'InstanceList$member' => NULL, ], ], 'InstanceCollectionType' => [ 'base' => NULL, 'refs' => [ 'Cluster$InstanceCollectionType' => '<note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note> <p>The instance group configuration of the cluster. A value of <code>INSTANCE_GROUP</code> indicates a uniform instance group configuration. A value of <code>INSTANCE_FLEET</code> indicates an instance fleets configuration.</p>', ], ], 'InstanceFleet' => [ 'base' => '<p>Describes an instance fleet, which is a group of EC2 instances that host a particular node type (master, core, or task) in an Amazon EMR cluster. Instance fleets can consist of a mix of instance types and On-Demand and Spot Instances, which are provisioned to meet a defined target capacity. </p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'refs' => [ 'InstanceFleetList$member' => NULL, ], ], 'InstanceFleetConfig' => [ 'base' => '<p>The configuration that defines an instance fleet.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'refs' => [ 'AddInstanceFleetInput$InstanceFleet' => '<p>Specifies the configuration of the instance fleet.</p>', 'InstanceFleetConfigList$member' => NULL, ], ], 'InstanceFleetConfigList' => [ 'base' => NULL, 'refs' => [ 'JobFlowInstancesConfig$InstanceFleets' => '<note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note> <p>Describes the EC2 instances and instance configurations for clusters that use the instance fleet configuration.</p>', ], ], 'InstanceFleetId' => [ 'base' => NULL, 'refs' => [ 'AddInstanceFleetOutput$InstanceFleetId' => '<p>The unique identifier of the instance fleet.</p>', 'Instance$InstanceFleetId' => '<p>The unique identifier of the instance fleet to which an EC2 instance belongs.</p>', 'InstanceFleet$Id' => '<p>The unique identifier of the instance fleet.</p>', 'InstanceFleetModifyConfig$InstanceFleetId' => '<p>A unique identifier for the instance fleet.</p>', 'ListInstancesInput$InstanceFleetId' => '<p>The unique identifier of the instance fleet.</p>', ], ], 'InstanceFleetList' => [ 'base' => NULL, 'refs' => [ 'ListInstanceFleetsOutput$InstanceFleets' => '<p>The list of instance fleets for the cluster and given filters.</p>', ], ], 'InstanceFleetModifyConfig' => [ 'base' => '<p>Configuration parameters for an instance fleet modification request.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'refs' => [ 'ModifyInstanceFleetInput$InstanceFleet' => '<p>The configuration parameters of the instance fleet.</p>', ], ], 'InstanceFleetProvisioningSpecifications' => [ 'base' => '<p>The launch specification for Spot Instances in the fleet, which determines the defined duration, provisioning timeout behavior, and allocation strategy.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. On-Demand and Spot Instance allocation strategies are available in Amazon EMR version 5.12.1 and later.</p> </note>', 'refs' => [ 'InstanceFleet$LaunchSpecifications' => '<p>Describes the launch specification for an instance fleet. </p>', 'InstanceFleetConfig$LaunchSpecifications' => '<p>The launch specification for the instance fleet.</p>', ], ], 'InstanceFleetState' => [ 'base' => NULL, 'refs' => [ 'InstanceFleetStatus$State' => '<p>A code representing the instance fleet status.</p> <ul> <li> <p> <code>PROVISIONING</code>—The instance fleet is provisioning EC2 resources and is not yet ready to run jobs.</p> </li> <li> <p> <code>BOOTSTRAPPING</code>—EC2 instances and other resources have been provisioned and the bootstrap actions specified for the instances are underway.</p> </li> <li> <p> <code>RUNNING</code>—EC2 instances and other resources are running. They are either executing jobs or waiting to execute jobs.</p> </li> <li> <p> <code>RESIZING</code>—A resize operation is underway. EC2 instances are either being added or removed.</p> </li> <li> <p> <code>SUSPENDED</code>—A resize operation could not complete. Existing EC2 instances are running, but instances can\'t be added or removed.</p> </li> <li> <p> <code>TERMINATING</code>—The instance fleet is terminating EC2 instances.</p> </li> <li> <p> <code>TERMINATED</code>—The instance fleet is no longer active, and all EC2 instances have been terminated.</p> </li> </ul>', ], ], 'InstanceFleetStateChangeReason' => [ 'base' => '<p>Provides status change reason details for the instance fleet.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'refs' => [ 'InstanceFleetStatus$StateChangeReason' => '<p>Provides status change reason details for the instance fleet.</p>', ], ], 'InstanceFleetStateChangeReasonCode' => [ 'base' => NULL, 'refs' => [ 'InstanceFleetStateChangeReason$Code' => '<p>A code corresponding to the reason the state change occurred.</p>', ], ], 'InstanceFleetStatus' => [ 'base' => '<p>The status of the instance fleet.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'refs' => [ 'InstanceFleet$Status' => '<p>The current status of the instance fleet. </p>', ], ], 'InstanceFleetTimeline' => [ 'base' => '<p>Provides historical timestamps for the instance fleet, including the time of creation, the time it became ready to run jobs, and the time of termination.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'refs' => [ 'InstanceFleetStatus$Timeline' => '<p>Provides historical timestamps for the instance fleet, including the time of creation, the time it became ready to run jobs, and the time of termination.</p>', ], ], 'InstanceFleetType' => [ 'base' => NULL, 'refs' => [ 'InstanceFleet$InstanceFleetType' => '<p>The node type that the instance fleet hosts. Valid values are MASTER, CORE, or TASK. </p>', 'InstanceFleetConfig$InstanceFleetType' => '<p>The node type that the instance fleet hosts. Valid values are MASTER, CORE, and TASK.</p>', 'ListInstancesInput$InstanceFleetType' => '<p>The node type of the instance fleet. For example MASTER, CORE, or TASK.</p>', ], ], 'InstanceGroup' => [ 'base' => '<p>This entity represents an instance group, which is a group of instances that have common purpose. For example, CORE instance group is used for HDFS.</p>', 'refs' => [ 'InstanceGroupList$member' => NULL, ], ], 'InstanceGroupConfig' => [ 'base' => '<p>Configuration defining a new instance group.</p>', 'refs' => [ 'InstanceGroupConfigList$member' => NULL, ], ], 'InstanceGroupConfigList' => [ 'base' => NULL, 'refs' => [ 'AddInstanceGroupsInput$InstanceGroups' => '<p>Instance groups to add.</p>', 'JobFlowInstancesConfig$InstanceGroups' => '<p>Configuration for the instance groups in a cluster.</p>', ], ], 'InstanceGroupDetail' => [ 'base' => '<p>Detailed information about an instance group.</p>', 'refs' => [ 'InstanceGroupDetailList$member' => NULL, ], ], 'InstanceGroupDetailList' => [ 'base' => NULL, 'refs' => [ 'JobFlowInstancesDetail$InstanceGroups' => '<p>Details about the instance groups in a cluster.</p>', ], ], 'InstanceGroupId' => [ 'base' => NULL, 'refs' => [ 'InstanceGroup$Id' => '<p>The identifier of the instance group.</p>', 'ListInstancesInput$InstanceGroupId' => '<p>The identifier of the instance group for which to list the instances.</p>', 'PutAutoScalingPolicyInput$InstanceGroupId' => '<p>Specifies the ID of the instance group to which the automatic scaling policy is applied.</p>', 'PutAutoScalingPolicyOutput$InstanceGroupId' => '<p>Specifies the ID of the instance group to which the scaling policy is applied.</p>', 'RemoveAutoScalingPolicyInput$InstanceGroupId' => '<p>Specifies the ID of the instance group to which the scaling policy is applied.</p>', ], ], 'InstanceGroupIdsList' => [ 'base' => NULL, 'refs' => [ 'AddInstanceGroupsOutput$InstanceGroupIds' => '<p>Instance group IDs of the newly created instance groups.</p>', ], ], 'InstanceGroupList' => [ 'base' => NULL, 'refs' => [ 'ListInstanceGroupsOutput$InstanceGroups' => '<p>The list of instance groups for the cluster and given filters.</p>', ], ], 'InstanceGroupModifyConfig' => [ 'base' => '<p>Modify the size or configurations of an instance group.</p>', 'refs' => [ 'InstanceGroupModifyConfigList$member' => NULL, ], ], 'InstanceGroupModifyConfigList' => [ 'base' => NULL, 'refs' => [ 'ModifyInstanceGroupsInput$InstanceGroups' => '<p>Instance groups to change.</p>', ], ], 'InstanceGroupState' => [ 'base' => NULL, 'refs' => [ 'InstanceGroupDetail$State' => '<p>State of instance group. The following values are no longer supported: STARTING, TERMINATED, and FAILED.</p>', 'InstanceGroupStatus$State' => '<p>The current state of the instance group.</p>', ], ], 'InstanceGroupStateChangeReason' => [ 'base' => '<p>The status change reason details for the instance group.</p>', 'refs' => [ 'InstanceGroupStatus$StateChangeReason' => '<p>The status change reason details for the instance group.</p>', ], ], 'InstanceGroupStateChangeReasonCode' => [ 'base' => NULL, 'refs' => [ 'InstanceGroupStateChangeReason$Code' => '<p>The programmable code for the state change reason.</p>', ], ], 'InstanceGroupStatus' => [ 'base' => '<p>The details of the instance group status.</p>', 'refs' => [ 'InstanceGroup$Status' => '<p>The current status of the instance group.</p>', ], ], 'InstanceGroupTimeline' => [ 'base' => '<p>The timeline of the instance group lifecycle.</p>', 'refs' => [ 'InstanceGroupStatus$Timeline' => '<p>The timeline of the instance group status over time.</p>', ], ], 'InstanceGroupType' => [ 'base' => NULL, 'refs' => [ 'InstanceGroup$InstanceGroupType' => '<p>The type of the instance group. Valid values are MASTER, CORE or TASK.</p>', 'InstanceGroupTypeList$member' => NULL, ], ], 'InstanceGroupTypeList' => [ 'base' => NULL, 'refs' => [ 'ListInstancesInput$InstanceGroupTypes' => '<p>The type of instance group for which to list the instances.</p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'EC2InstanceIdsList$member' => NULL, 'EC2InstanceIdsToTerminateList$member' => NULL, 'Instance$Id' => '<p>The unique identifier for the instance in Amazon EMR.</p>', 'Instance$Ec2InstanceId' => '<p>The unique identifier of the instance in Amazon EC2.</p>', ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'ListInstancesOutput$Instances' => '<p>The list of instances for the cluster and given filters.</p>', ], ], 'InstanceResizePolicy' => [ 'base' => '<p>Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.</p>', 'refs' => [ 'ShrinkPolicy$InstanceResizePolicy' => '<p>Custom policy for requesting termination protection or termination of specific instances when shrinking an instance group.</p>', ], ], 'InstanceRoleType' => [ 'base' => NULL, 'refs' => [ 'InstanceGroupConfig$InstanceRole' => '<p>The role of the instance group in the cluster.</p>', 'InstanceGroupDetail$InstanceRole' => '<p>Instance group role in the cluster</p>', 'PlacementGroupConfig$InstanceRole' => '<p>Role of the instance in the cluster.</p> <p>Starting with Amazon EMR version 5.23.0, the only supported instance role is <code>MASTER</code>.</p>', ], ], 'InstanceState' => [ 'base' => NULL, 'refs' => [ 'InstanceStateList$member' => NULL, 'InstanceStatus$State' => '<p>The current state of the instance.</p>', ], ], 'InstanceStateChangeReason' => [ 'base' => '<p>The details of the status change reason for the instance.</p>', 'refs' => [ 'InstanceStatus$StateChangeReason' => '<p>The details of the status change reason for the instance.</p>', ], ], 'InstanceStateChangeReasonCode' => [ 'base' => NULL, 'refs' => [ 'InstanceStateChangeReason$Code' => '<p>The programmable code for the state change reason.</p>', ], ], 'InstanceStateList' => [ 'base' => NULL, 'refs' => [ 'ListInstancesInput$InstanceStates' => '<p>A list of instance states that will filter the instances returned with this request.</p>', ], ], 'InstanceStatus' => [ 'base' => '<p>The instance status details.</p>', 'refs' => [ 'Instance$Status' => '<p>The current status of the instance.</p>', ], ], 'InstanceTimeline' => [ 'base' => '<p>The timeline of the instance lifecycle.</p>', 'refs' => [ 'InstanceStatus$Timeline' => '<p>The timeline of the instance status over time.</p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'Instance$InstanceType' => '<p>The EC2 instance type, for example <code>m3.xlarge</code>.</p>', 'InstanceGroup$InstanceType' => '<p>The EC2 instance type for all instances in the instance group.</p>', 'InstanceGroupConfig$InstanceType' => '<p>The EC2 instance type for all instances in the instance group.</p>', 'InstanceGroupDetail$InstanceType' => '<p>EC2 instance type.</p>', 'InstanceTypeConfig$InstanceType' => '<p>An EC2 instance type, such as <code>m3.xlarge</code>. </p>', 'InstanceTypeSpecification$InstanceType' => '<p>The EC2 instance type, for example <code>m3.xlarge</code>.</p>', 'JobFlowInstancesConfig$MasterInstanceType' => '<p>The EC2 instance type of the master node.</p>', 'JobFlowInstancesConfig$SlaveInstanceType' => '<p>The EC2 instance type of the core and task nodes.</p>', 'JobFlowInstancesDetail$MasterInstanceType' => '<p>The Amazon EC2 master node instance type.</p>', 'JobFlowInstancesDetail$SlaveInstanceType' => '<p>The Amazon EC2 core and task node instance type.</p>', ], ], 'InstanceTypeConfig' => [ 'base' => '<p>An instance type configuration for each instance type in an instance fleet, which determines the EC2 instances Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities. When you use an allocation strategy, you can include a maximum of 30 instance type configurations for a fleet. For more information about how to use an allocation strategy, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-instance-fleet.html">Configure Instance Fleets</a>. Without an allocation strategy, you may specify a maximum of five instance type configurations for a fleet.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'refs' => [ 'InstanceTypeConfigList$member' => NULL, ], ], 'InstanceTypeConfigList' => [ 'base' => NULL, 'refs' => [ 'InstanceFleetConfig$InstanceTypeConfigs' => '<p>The instance type configurations that define the EC2 instances in the instance fleet.</p>', ], ], 'InstanceTypeSpecification' => [ 'base' => '<p>The configuration specification for each instance type in an instance fleet.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'refs' => [ 'InstanceTypeSpecificationList$member' => NULL, ], ], 'InstanceTypeSpecificationList' => [ 'base' => NULL, 'refs' => [ 'InstanceFleet$InstanceTypeSpecifications' => '<p>An array of specifications for the instance types that comprise an instance fleet.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmDefinition$EvaluationPeriods' => '<p>The number of periods, in five-minute increments, during which the alarm condition must exist before the alarm triggers automatic scaling activity. The default value is <code>1</code>.</p>', 'CloudWatchAlarmDefinition$Period' => '<p>The period, in seconds, over which the statistic is applied. EMR CloudWatch metrics are emitted every five minutes (300 seconds), so if an EMR CloudWatch metric is specified, specify <code>300</code>.</p>', 'Cluster$NormalizedInstanceHours' => '<p>An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one time for every hour an m1.small instance runs. Larger instances are weighted more, so an EC2 instance that is roughly four times more expensive would result in the normalized instance hours being incremented by four. This result is only an approximation and does not reflect the actual billing rate.</p>', 'Cluster$EbsRootVolumeSize' => '<p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.</p>', 'Cluster$StepConcurrencyLevel' => '<p>Specifies the number of steps that can be executed concurrently.</p>', 'ClusterSummary$NormalizedInstanceHours' => '<p>An approximation of the cost of the cluster, represented in m1.small/hours. This value is incremented one time for every hour an m1.small instance runs. Larger instances are weighted more, so an EC2 instance that is roughly four times more expensive would result in the normalized instance hours being incremented by four. This result is only an approximation and does not reflect the actual billing rate.</p>', 'ComputeLimits$MinimumCapacityUnits' => '<p> The lower boundary of EC2 units. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration. </p>', 'ComputeLimits$MaximumCapacityUnits' => '<p> The upper boundary of EC2 units. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. Managed scaling activities are not allowed beyond this boundary. The limit only applies to the core and task nodes. The master node cannot be scaled after initial configuration. </p>', 'ComputeLimits$MaximumOnDemandCapacityUnits' => '<p> The upper boundary of On-Demand EC2 units. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The On-Demand units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between On-Demand and Spot Instances. </p>', 'ComputeLimits$MaximumCoreCapacityUnits' => '<p> The upper boundary of EC2 units for core node type in a cluster. It is measured through vCPU cores or instances for instance groups and measured through units for instance fleets. The core units are not allowed to scale beyond this boundary. The parameter is used to split capacity allocation between core and task nodes. </p>', 'EbsBlockDeviceConfig$VolumesPerInstance' => '<p>Number of EBS volumes with a specific volume configuration that are associated with every instance in the instance group</p>', 'InstanceGroup$RequestedInstanceCount' => '<p>The target number of instances for the instance group.</p>', 'InstanceGroup$RunningInstanceCount' => '<p>The number of instances currently running in this instance group.</p>', 'InstanceGroupConfig$InstanceCount' => '<p>Target number of instances for the instance group.</p>', 'InstanceGroupDetail$InstanceRequestCount' => '<p>Target number of instances to run in the instance group.</p>', 'InstanceGroupDetail$InstanceRunningCount' => '<p>Actual count of running instances.</p>', 'InstanceGroupModifyConfig$InstanceCount' => '<p>Target size for the instance group.</p>', 'InstanceResizePolicy$InstanceTerminationTimeout' => '<p>Decommissioning timeout override for the specific list of instances to be terminated.</p>', 'JobFlowInstancesConfig$InstanceCount' => '<p>The number of EC2 instances in the cluster.</p>', 'JobFlowInstancesDetail$InstanceCount' => '<p>The number of Amazon EC2 instances in the cluster. If the value is 1, the same instance serves as both the master and core and task node. If the value is greater than 1, one instance is the master node and all others are core and task nodes.</p>', 'JobFlowInstancesDetail$NormalizedInstanceHours' => '<p>An approximation of the cost of the cluster, represented in m1.small/hours. This value is increased one time for every hour that an m1.small instance runs. Larger instances are weighted more heavily, so an Amazon EC2 instance that is roughly four times more expensive would result in the normalized instance hours being increased incrementally four times. This result is only an approximation and does not reflect the actual billing rate.</p>', 'ModifyClusterInput$StepConcurrencyLevel' => '<p>The number of steps that can be executed concurrently. You can specify a minimum of 1 step and a maximum of 256 steps. We recommend that you do not change this parameter while steps are running or the <code>ActionOnFailure</code> setting may not behave as expected. For more information see <a>Step$ActionOnFailure</a>.</p>', 'ModifyClusterOutput$StepConcurrencyLevel' => '<p>The number of steps that can be executed concurrently.</p>', 'RunJobFlowInput$EbsRootVolumeSize' => '<p>The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for each EC2 instance. Available in Amazon EMR version 4.x and later.</p>', 'RunJobFlowInput$StepConcurrencyLevel' => '<p>Specifies the number of steps that can be executed concurrently. The default value is <code>1</code>. The maximum value is <code>256</code>.</p>', 'ScalingConstraints$MinCapacity' => '<p>The lower boundary of EC2 instances in an instance group below which scaling activities are not allowed to shrink. Scale-in activities will not terminate instances below this boundary.</p>', 'ScalingConstraints$MaxCapacity' => '<p>The upper boundary of EC2 instances in an instance group beyond which scaling activities are not allowed to grow. Scale-out activities will not add instances beyond this boundary.</p>', 'ShrinkPolicy$DecommissionTimeout' => '<p>The desired timeout for decommissioning an instance. Overrides the default YARN decommissioning timeout.</p>', 'SimpleScalingPolicyConfiguration$ScalingAdjustment' => '<p>The amount by which to scale in or scale out, based on the specified <code>AdjustmentType</code>. A positive value adds to the instance group\'s EC2 instance count while a negative number removes instances. If <code>AdjustmentType</code> is set to <code>EXACT_CAPACITY</code>, the number should only be a positive integer. If <code>AdjustmentType</code> is set to <code>PERCENT_CHANGE_IN_CAPACITY</code>, the value should express the percentage as an integer. For example, -20 indicates a decrease in 20% increments of cluster capacity.</p>', 'SimpleScalingPolicyConfiguration$CoolDown' => '<p>The amount of time, in seconds, after a scaling activity completes before any further trigger-related scaling activities can start. The default value is 0.</p>', 'VolumeSpecification$Iops' => '<p>The number of I/O operations per second (IOPS) that the volume supports.</p>', 'VolumeSpecification$SizeInGB' => '<p>The volume size, in gibibytes (GiB). This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>Indicates that an error occurred while processing the request and that the request was not completed.</p>', 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>This exception occurs when there is an internal failure in the Amazon EMR service.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>This exception occurs when there is something wrong with user input.</p>', 'refs' => [], ], 'JobFlowDetail' => [ 'base' => '<p>A description of a cluster (job flow).</p>', 'refs' => [ 'JobFlowDetailList$member' => NULL, ], ], 'JobFlowDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobFlowsOutput$JobFlows' => '<p>A list of job flows matching the parameters supplied.</p>', ], ], 'JobFlowExecutionState' => [ 'base' => '<p>The type of instance.</p>', 'refs' => [ 'JobFlowExecutionStateList$member' => NULL, 'JobFlowExecutionStatusDetail$State' => '<p>The state of the job flow.</p>', ], ], 'JobFlowExecutionStateList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobFlowsInput$JobFlowStates' => '<p>Return only job flows whose state is contained in this list.</p>', ], ], 'JobFlowExecutionStatusDetail' => [ 'base' => '<p>Describes the status of the cluster (job flow).</p>', 'refs' => [ 'JobFlowDetail$ExecutionStatusDetail' => '<p>Describes the execution status of the job flow.</p>', ], ], 'JobFlowInstancesConfig' => [ 'base' => '<p>A description of the Amazon EC2 instance on which the cluster (job flow) runs. A valid JobFlowInstancesConfig must contain either InstanceGroups or InstanceFleets. They cannot be used together. You may also have MasterInstanceType, SlaveInstanceType, and InstanceCount (all three must be present), but we don\'t recommend this configuration.</p>', 'refs' => [ 'RunJobFlowInput$Instances' => '<p>A specification of the number and type of Amazon EC2 instances.</p>', ], ], 'JobFlowInstancesDetail' => [ 'base' => '<p>Specify the type of Amazon EC2 instances that the cluster (job flow) runs on.</p>', 'refs' => [ 'JobFlowDetail$Instances' => '<p>Describes the Amazon EC2 instances of the job flow.</p>', ], ], 'KerberosAttributes' => [ 'base' => '<p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <i>Amazon EMR Management Guide</i>.</p>', 'refs' => [ 'Cluster$KerberosAttributes' => '<p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <i>Amazon EMR Management Guide</i>.</p>', 'RunJobFlowInput$KerberosAttributes' => '<p>Attributes for Kerberos configuration when Kerberos authentication is enabled using a security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication</a> in the <i>Amazon EMR Management Guide</i>.</p>', ], ], 'KeyValue' => [ 'base' => '<p>A key-value pair.</p>', 'refs' => [ 'KeyValueList$member' => NULL, ], ], 'KeyValueList' => [ 'base' => NULL, 'refs' => [ 'HadoopJarStepConfig$Properties' => '<p>A list of Java properties that are set when the step runs. You can use these properties to pass key-value pairs to your main function.</p>', ], ], 'ListBootstrapActionsInput' => [ 'base' => '<p>This input determines which bootstrap actions to retrieve.</p>', 'refs' => [], ], 'ListBootstrapActionsOutput' => [ 'base' => '<p>This output contains the bootstrap actions detail.</p>', 'refs' => [], ], 'ListClustersInput' => [ 'base' => '<p>This input determines how the ListClusters action filters the list of clusters that it returns.</p>', 'refs' => [], ], 'ListClustersOutput' => [ 'base' => '<p>This contains a ClusterSummaryList with the cluster details; for example, the cluster IDs, names, and status.</p>', 'refs' => [], ], 'ListInstanceFleetsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceFleetsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceGroupsInput' => [ 'base' => '<p>This input determines which instance groups to retrieve.</p>', 'refs' => [], ], 'ListInstanceGroupsOutput' => [ 'base' => '<p>This input determines which instance groups to retrieve.</p>', 'refs' => [], ], 'ListInstancesInput' => [ 'base' => '<p>This input determines which instances to list.</p>', 'refs' => [], ], 'ListInstancesOutput' => [ 'base' => '<p>This output contains the list of instances.</p>', 'refs' => [], ], 'ListNotebookExecutionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNotebookExecutionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListReleaseLabelsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListReleaseLabelsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityConfigurationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityConfigurationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStepsInput' => [ 'base' => '<p>This input determines which steps to list.</p>', 'refs' => [], ], 'ListStepsOutput' => [ 'base' => '<p>This output contains the list of steps returned in reverse order. This means that the last step is the first element in the list.</p>', 'refs' => [], ], 'ListStudioSessionMappingsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStudioSessionMappingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListStudiosInput' => [ 'base' => NULL, 'refs' => [], ], 'ListStudiosOutput' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AutoTerminationPolicy$IdleTimeout' => '<p>Specifies the amount of idle time in seconds after which the cluster automatically terminates. You can specify a minimum of 60 seconds and a maximum of 604800 seconds (seven days).</p>', 'InstanceGroup$ConfigurationsVersion' => '<p>The version number of the requested configuration specification for this instance group.</p>', 'InstanceGroup$LastSuccessfullyAppliedConfigurationsVersion' => '<p>The version number of a configuration specification that was successfully applied for an instance group last time. </p>', ], ], 'ManagedScalingPolicy' => [ 'base' => '<p> Managed scaling policy for an Amazon EMR cluster. The policy specifies the limits for resources that can be added or terminated from a cluster. The policy only applies to the core and task nodes. The master node cannot be scaled after initial configuration. </p>', 'refs' => [ 'GetManagedScalingPolicyOutput$ManagedScalingPolicy' => '<p>Specifies the managed scaling policy that is attached to an Amazon EMR cluster. </p>', 'PutManagedScalingPolicyInput$ManagedScalingPolicy' => '<p>Specifies the constraints for the managed scaling policy. </p>', 'RunJobFlowInput$ManagedScalingPolicy' => '<p> The specified managed scaling policy for an Amazon EMR cluster. </p>', ], ], 'Marker' => [ 'base' => NULL, 'refs' => [ 'ListBootstrapActionsInput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListBootstrapActionsOutput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListClustersInput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListClustersOutput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListInstanceFleetsInput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListInstanceFleetsOutput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListInstanceGroupsInput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListInstanceGroupsOutput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListInstancesInput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListInstancesOutput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListNotebookExecutionsInput$Marker' => '<p>The pagination token, returned by a previous <code>ListNotebookExecutions</code> call, that indicates the start of the list for this <code>ListNotebookExecutions</code> call.</p>', 'ListNotebookExecutionsOutput$Marker' => '<p>A pagination token that a subsequent <code>ListNotebookExecutions</code> can use to determine the next set of results to retrieve.</p>', 'ListSecurityConfigurationsInput$Marker' => '<p>The pagination token that indicates the set of results to retrieve.</p>', 'ListSecurityConfigurationsOutput$Marker' => '<p>A pagination token that indicates the next set of results to retrieve. Include the marker in the next ListSecurityConfiguration call to retrieve the next page of results, if required.</p>', 'ListStepsInput$Marker' => '<p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>', 'ListStepsOutput$Marker' => '<p>The maximum number of steps that a single <code>ListSteps</code> action returns is 50. To return a longer list of steps, use multiple <code>ListSteps</code> actions along with the <code>Marker</code> parameter, which is a pagination token that indicates the next set of results to retrieve.</p>', 'ListStudioSessionMappingsInput$Marker' => '<p>The pagination token that indicates the set of results to retrieve.</p>', 'ListStudioSessionMappingsOutput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListStudiosInput$Marker' => '<p>The pagination token that indicates the set of results to retrieve.</p>', 'ListStudiosOutput$Marker' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', ], ], 'MarketType' => [ 'base' => NULL, 'refs' => [ 'Instance$Market' => '<p>The instance purchasing option. Valid values are <code>ON_DEMAND</code> or <code>SPOT</code>. </p>', 'InstanceGroup$Market' => '<p>The marketplace to provision instances for this group. Valid values are ON_DEMAND or SPOT.</p>', 'InstanceGroupConfig$Market' => '<p>Market type of the EC2 instances used to create a cluster node.</p>', 'InstanceGroupDetail$Market' => '<p>Market type of the EC2 instances used to create a cluster node.</p>', 'ScalingAction$Market' => '<p>Not available for instance groups. Instance groups use the market type specified for the group.</p>', ], ], 'MaxResultsNumber' => [ 'base' => NULL, 'refs' => [ 'DescribeReleaseLabelInput$MaxResults' => '<p>Reserved for future use. Currently set to null.</p>', 'ListReleaseLabelsInput$MaxResults' => '<p>Defines the maximum number of release labels to return in a single response. The default is <code>100</code>.</p>', ], ], 'MetricDimension' => [ 'base' => '<p>A CloudWatch dimension, which is specified using a <code>Key</code> (known as a <code>Name</code> in CloudWatch), <code>Value</code> pair. By default, Amazon EMR uses one dimension whose <code>Key</code> is <code>JobFlowID</code> and <code>Value</code> is a variable representing the cluster ID, which is <code>${emr.clusterId}</code>. This enables the rule to bootstrap when the cluster ID becomes available.</p>', 'refs' => [ 'MetricDimensionList$member' => NULL, ], ], 'MetricDimensionList' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmDefinition$Dimensions' => '<p>A CloudWatch metric dimension.</p>', ], ], 'ModifyClusterInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyClusterOutput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceFleetInput' => [ 'base' => NULL, 'refs' => [], ], 'ModifyInstanceGroupsInput' => [ 'base' => '<p>Change the size of some instance groups.</p>', 'refs' => [], ], 'NewSupportedProductsList' => [ 'base' => NULL, 'refs' => [ 'RunJobFlowInput$NewSupportedProducts' => '<note> <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.</p> </note> <p>A list of strings that indicates third-party software to use with the job flow that accepts a user argument list. EMR accepts and forwards the argument list to the corresponding installation script as bootstrap action arguments. For more information, see "Launch a Job Flow on the MapR Distribution for Hadoop" in the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Supported values are:</p> <ul> <li> <p>"mapr-m3" - launch the cluster using MapR M3 Edition.</p> </li> <li> <p>"mapr-m5" - launch the cluster using MapR M5 Edition.</p> </li> <li> <p>"mapr" with the user arguments specifying "--edition,m3" or "--edition,m5" - launch the job flow using MapR M3 or M5 Edition respectively.</p> </li> <li> <p>"mapr-m7" - launch the cluster using MapR M7 Edition.</p> </li> <li> <p>"hunk" - launch the cluster with the Hunk Big Data Analytics Platform.</p> </li> <li> <p>"hue"- launch the cluster with Hue installed.</p> </li> <li> <p>"spark" - launch the cluster with Apache Spark installed.</p> </li> <li> <p>"ganglia" - launch the cluster with the Ganglia Monitoring System installed.</p> </li> </ul>', ], ], 'NonNegativeDouble' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmDefinition$Threshold' => '<p>The value against which the specified statistic is compared.</p>', 'InstanceTypeConfig$BidPriceAsPercentageOfOnDemandPrice' => '<p>The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined by <code>InstanceType</code>. Expressed as a number (for example, 20 specifies 20%). If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.</p>', 'InstanceTypeSpecification$BidPriceAsPercentageOfOnDemandPrice' => '<p>The bid price, as a percentage of On-Demand price, for each EC2 Spot Instance as defined by <code>InstanceType</code>. Expressed as a number (for example, 20 specifies 20%).</p>', ], ], 'NotebookExecution' => [ 'base' => '<p>A notebook execution. An execution is a specific instance that an EMR Notebook is run using the <code>StartNotebookExecution</code> action.</p>', 'refs' => [ 'DescribeNotebookExecutionOutput$NotebookExecution' => '<p>Properties of the notebook execution.</p>', ], ], 'NotebookExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'ListNotebookExecutionsInput$Status' => '<p>The status filter for listing notebook executions.</p> <ul> <li> <p> <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not begun.</p> </li> <li> <p> <code>STARTING</code> indicates that the execution is starting on the cluster.</p> </li> <li> <p> <code>RUNNING</code> indicates that the execution is being processed by the cluster.</p> </li> <li> <p> <code>FINISHING</code> indicates that execution processing is in the final stages.</p> </li> <li> <p> <code>FINISHED</code> indicates that the execution has completed without error.</p> </li> <li> <p> <code>FAILING</code> indicates that the execution is failing and will not finish successfully.</p> </li> <li> <p> <code>FAILED</code> indicates that the execution failed.</p> </li> <li> <p> <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request and the stop is pending.</p> </li> <li> <p> <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a <code>StopNotebookExecution</code> request.</p> </li> <li> <p> <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code> request.</p> </li> </ul>', 'NotebookExecution$Status' => '<p>The status of the notebook execution.</p> <ul> <li> <p> <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not begun.</p> </li> <li> <p> <code>STARTING</code> indicates that the execution is starting on the cluster.</p> </li> <li> <p> <code>RUNNING</code> indicates that the execution is being processed by the cluster.</p> </li> <li> <p> <code>FINISHING</code> indicates that execution processing is in the final stages.</p> </li> <li> <p> <code>FINISHED</code> indicates that the execution has completed without error.</p> </li> <li> <p> <code>FAILING</code> indicates that the execution is failing and will not finish successfully.</p> </li> <li> <p> <code>FAILED</code> indicates that the execution failed.</p> </li> <li> <p> <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request and the stop is pending.</p> </li> <li> <p> <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a <code>StopNotebookExecution</code> request.</p> </li> <li> <p> <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code> request.</p> </li> </ul>', 'NotebookExecutionSummary$Status' => '<p>The status of the notebook execution.</p> <ul> <li> <p> <code>START_PENDING</code> indicates that the cluster has received the execution request but execution has not begun.</p> </li> <li> <p> <code>STARTING</code> indicates that the execution is starting on the cluster.</p> </li> <li> <p> <code>RUNNING</code> indicates that the execution is being processed by the cluster.</p> </li> <li> <p> <code>FINISHING</code> indicates that execution processing is in the final stages.</p> </li> <li> <p> <code>FINISHED</code> indicates that the execution has completed without error.</p> </li> <li> <p> <code>FAILING</code> indicates that the execution is failing and will not finish successfully.</p> </li> <li> <p> <code>FAILED</code> indicates that the execution failed.</p> </li> <li> <p> <code>STOP_PENDING</code> indicates that the cluster has received a <code>StopNotebookExecution</code> request and the stop is pending.</p> </li> <li> <p> <code>STOPPING</code> indicates that the cluster is in the process of stopping the execution as a result of a <code>StopNotebookExecution</code> request.</p> </li> <li> <p> <code>STOPPED</code> indicates that the execution stopped because of a <code>StopNotebookExecution</code> request.</p> </li> </ul>', ], ], 'NotebookExecutionSummary' => [ 'base' => '<p>Details for a notebook execution. The details include information such as the unique ID and status of the notebook execution.</p>', 'refs' => [ 'NotebookExecutionSummaryList$member' => NULL, ], ], 'NotebookExecutionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListNotebookExecutionsOutput$NotebookExecutions' => '<p>A list of notebook executions.</p>', ], ], 'OSRelease' => [ 'base' => '<p>The Amazon Linux release specified for a cluster in the RunJobFlow request.</p>', 'refs' => [ 'OSReleaseList$member' => NULL, ], ], 'OSReleaseList' => [ 'base' => NULL, 'refs' => [ 'DescribeReleaseLabelOutput$AvailableOSReleases' => '<p>The list of available Amazon Linux release versions for an Amazon EMR release. Contains a Label field that is formatted as shown in <a href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-al2.html"> <i>Amazon Linux 2 Release Notes</i> </a>. For example, <a href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html">2.0.20220218.1</a>.</p>', ], ], 'OnDemandCapacityReservationOptions' => [ 'base' => '<p>Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.</p>', 'refs' => [ 'OnDemandProvisioningSpecification$CapacityReservationOptions' => '<p>The launch specification for On-Demand instances in the instance fleet, which determines the allocation strategy.</p>', ], ], 'OnDemandCapacityReservationPreference' => [ 'base' => NULL, 'refs' => [ 'OnDemandCapacityReservationOptions$CapacityReservationPreference' => '<p>Indicates the instance\'s Capacity Reservation preferences. Possible preferences include:</p> <ul> <li> <p> <code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</p> </li> <li> <p> <code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</p> </li> </ul>', ], ], 'OnDemandCapacityReservationUsageStrategy' => [ 'base' => NULL, 'refs' => [ 'OnDemandCapacityReservationOptions$UsageStrategy' => '<p>Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.</p> <p>If you specify <code>use-capacity-reservations-first</code>, the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy (<code>lowest-price</code>) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy (<code>lowest-price</code>).</p> <p>If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand allocation strategy.</p>', ], ], 'OnDemandProvisioningAllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'OnDemandProvisioningSpecification$AllocationStrategy' => '<p>Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is <code>lowest-price</code> (the default), which launches the lowest price first.</p>', ], ], 'OnDemandProvisioningSpecification' => [ 'base' => '<p> The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy. </p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.</p> </note>', 'refs' => [ 'InstanceFleetProvisioningSpecifications$OnDemandSpecification' => '<p> The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy. </p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.</p> </note>', ], ], 'OptionalArnType' => [ 'base' => NULL, 'refs' => [ 'Cluster$OutpostArn' => '<p> The Amazon Resource Name (ARN) of the Outpost where the cluster is launched. </p>', 'ClusterSummary$OutpostArn' => '<p> The Amazon Resource Name (ARN) of the Outpost where the cluster is launched. </p>', 'Step$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the runtime role for a step on the cluster. The runtime role can be a cross-account IAM role. The runtime role ARN is a combination of account ID, role name, and role type using the following format: <code>arn:partition:service:region:account:resource</code>. </p> <p>For example, <code>arn:aws:iam::1234567890:role/ReadOnly</code> is a correctly formatted runtime role ARN.</p>', ], ], 'PlacementGroupConfig' => [ 'base' => '<p>Placement group configuration for an Amazon EMR cluster. The configuration specifies the placement strategy that can be applied to instance roles during cluster creation.</p> <p>To use this configuration, consider attaching managed policy AmazonElasticMapReducePlacementGroupPolicy to the EMR role.</p>', 'refs' => [ 'PlacementGroupConfigList$member' => NULL, ], ], 'PlacementGroupConfigList' => [ 'base' => NULL, 'refs' => [ 'Cluster$PlacementGroups' => '<p>Placement group configured for an Amazon EMR cluster.</p>', 'RunJobFlowInput$PlacementGroupConfigs' => '<p>The specified placement group configuration for an Amazon EMR cluster.</p>', ], ], 'PlacementGroupStrategy' => [ 'base' => NULL, 'refs' => [ 'PlacementGroupConfig$PlacementStrategy' => '<p>EC2 Placement Group strategy associated with instance role.</p> <p>Starting with Amazon EMR version 5.23.0, the only supported placement strategy is <code>SPREAD</code> for the <code>MASTER</code> instance role.</p>', ], ], 'PlacementType' => [ 'base' => '<p>The Amazon EC2 Availability Zone configuration of the cluster (job flow).</p>', 'refs' => [ 'JobFlowInstancesConfig$Placement' => '<p>The Availability Zone in which the cluster runs.</p>', 'JobFlowInstancesDetail$Placement' => '<p>The Amazon EC2 Availability Zone for the cluster.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'PortRange$MinRange' => '<p>The smallest port number in a specified range of port numbers.</p>', 'PortRange$MaxRange' => '<p>The smallest port number in a specified range of port numbers.</p>', ], ], 'PortRange' => [ 'base' => '<p>A list of port ranges that are permitted to allow inbound traffic from all public IP addresses. To specify a single port, use the same value for <code>MinRange</code> and <code>MaxRange</code>.</p>', 'refs' => [ 'PortRanges$member' => NULL, ], ], 'PortRanges' => [ 'base' => NULL, 'refs' => [ 'BlockPublicAccessConfiguration$PermittedPublicSecurityGroupRuleRanges' => '<p>Specifies ports and port ranges that are permitted to have security group rules that allow inbound traffic from all public sources. For example, if Port 23 (Telnet) is specified for <code>PermittedPublicSecurityGroupRuleRanges</code>, Amazon EMR allows cluster creation if a security group associated with the cluster has a rule that allows inbound traffic on Port 23 from IPv4 0.0.0.0/0 or IPv6 port ::/0 as the source.</p> <p>By default, Port 22, which is used for SSH access to the cluster EC2 instances, is in the list of <code>PermittedPublicSecurityGroupRuleRanges</code>.</p>', ], ], 'PutAutoScalingPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutAutoScalingPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutAutoTerminationPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutAutoTerminationPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutBlockPublicAccessConfigurationInput' => [ 'base' => NULL, 'refs' => [], ], 'PutBlockPublicAccessConfigurationOutput' => [ 'base' => NULL, 'refs' => [], ], 'PutManagedScalingPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutManagedScalingPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'ReconfigurationType' => [ 'base' => NULL, 'refs' => [ 'InstanceGroupModifyConfig$ReconfigurationType' => '<p>Type of reconfiguration requested. Valid values are MERGE and OVERWRITE.</p>', ], ], 'ReleaseLabelFilter' => [ 'base' => '<p>The release label filters by application or version prefix.</p>', 'refs' => [ 'ListReleaseLabelsInput$Filters' => '<p>Filters the results of the request. <code>Prefix</code> specifies the prefix of release labels to return. <code>Application</code> specifies the application (with/without version) of release labels to return.</p>', ], ], 'RemoveAutoScalingPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveAutoScalingPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveAutoTerminationPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveAutoTerminationPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveManagedScalingPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveManagedScalingPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveTagsInput' => [ 'base' => '<p>This input identifies an Amazon EMR resource and a list of tags to remove.</p>', 'refs' => [], ], 'RemoveTagsOutput' => [ 'base' => '<p>This output indicates the result of removing tags from the resource.</p>', 'refs' => [], ], 'RepoUpgradeOnBoot' => [ 'base' => NULL, 'refs' => [ 'Cluster$RepoUpgradeOnBoot' => '<p>Applies only when <code>CustomAmiID</code> is used. Specifies the type of updates that are applied from the Amazon Linux AMI package repositories when an instance boots using the AMI.</p>', 'RunJobFlowInput$RepoUpgradeOnBoot' => '<p>Applies only when <code>CustomAmiID</code> is used. Specifies which updates from the Amazon Linux AMI package repositories to apply automatically when the instance boots using the AMI. If omitted, the default is <code>SECURITY</code>, which indicates that only security updates are applied. If <code>NONE</code> is specified, no updates are applied, and all updates must be applied manually.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$ResourceId' => '<p>The Amazon EMR resource identifier to which tags will be added. For example, a cluster identifier or an Amazon EMR Studio ID.</p>', 'RemoveTagsInput$ResourceId' => '<p>The Amazon EMR resource identifier from which tags will be removed. For example, a cluster identifier or an Amazon EMR Studio ID.</p>', ], ], 'RunJobFlowInput' => [ 'base' => '<p> Input to the <a>RunJobFlow</a> operation. </p>', 'refs' => [], ], 'RunJobFlowOutput' => [ 'base' => '<p> The result of the <a>RunJobFlow</a> operation. </p>', 'refs' => [], ], 'ScaleDownBehavior' => [ 'base' => NULL, 'refs' => [ 'Cluster$ScaleDownBehavior' => '<p>The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> is available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>', 'JobFlowDetail$ScaleDownBehavior' => '<p>The way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>', 'RunJobFlowInput$ScaleDownBehavior' => '<p>Specifies the way that individual Amazon EC2 instances terminate when an automatic scale-in activity occurs or an instance group is resized. <code>TERMINATE_AT_INSTANCE_HOUR</code> indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of when the request to terminate the instance was submitted. This option is only available with Amazon EMR 5.1.0 and later and is the default for clusters created using that version. <code>TERMINATE_AT_TASK_COMPLETION</code> indicates that Amazon EMR adds nodes to a deny list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes first and blocks instance termination if it could lead to HDFS corruption. <code>TERMINATE_AT_TASK_COMPLETION</code> available only in Amazon EMR version 4.1.0 and later, and is the default for versions of Amazon EMR earlier than 5.1.0.</p>', ], ], 'ScalingAction' => [ 'base' => '<p>The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.</p>', 'refs' => [ 'ScalingRule$Action' => '<p>The conditions that trigger an automatic scaling activity.</p>', ], ], 'ScalingConstraints' => [ 'base' => '<p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic scaling activities triggered by automatic scaling rules will not cause an instance group to grow above or below these limits.</p>', 'refs' => [ 'AutoScalingPolicy$Constraints' => '<p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic scaling activity will not cause an instance group to grow above or below these limits.</p>', 'AutoScalingPolicyDescription$Constraints' => '<p>The upper and lower EC2 instance limits for an automatic scaling policy. Automatic scaling activity will not cause an instance group to grow above or below these limits.</p>', ], ], 'ScalingRule' => [ 'base' => '<p>A scale-in or scale-out rule that defines scaling activity, including the CloudWatch metric alarm that triggers activity, how EC2 instances are added or removed, and the periodicity of adjustments. The automatic scaling policy for an instance group can comprise one or more automatic scaling rules.</p>', 'refs' => [ 'ScalingRuleList$member' => NULL, ], ], 'ScalingRuleList' => [ 'base' => NULL, 'refs' => [ 'AutoScalingPolicy$Rules' => '<p>The scale-in and scale-out rules that comprise the automatic scaling policy.</p>', 'AutoScalingPolicyDescription$Rules' => '<p>The scale-in and scale-out rules that comprise the automatic scaling policy.</p>', ], ], 'ScalingTrigger' => [ 'base' => '<p>The conditions that trigger an automatic scaling activity.</p>', 'refs' => [ 'ScalingRule$Trigger' => '<p>The CloudWatch alarm definition that determines when automatic scaling activity is triggered.</p>', ], ], 'ScriptBootstrapActionConfig' => [ 'base' => '<p>Configuration of the script to run during a bootstrap action.</p>', 'refs' => [ 'BootstrapActionConfig$ScriptBootstrapAction' => '<p>The script run by the bootstrap action.</p>', ], ], 'SecurityConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListSecurityConfigurationsOutput$SecurityConfigurations' => '<p>The creation date and time, and name, of each security configuration.</p>', ], ], 'SecurityConfigurationSummary' => [ 'base' => '<p>The creation date and time, and name, of a security configuration.</p>', 'refs' => [ 'SecurityConfigurationList$member' => NULL, ], ], 'SecurityGroupsList' => [ 'base' => NULL, 'refs' => [ 'JobFlowInstancesConfig$AdditionalMasterSecurityGroups' => '<p>A list of additional Amazon EC2 security group IDs for the master node.</p>', 'JobFlowInstancesConfig$AdditionalSlaveSecurityGroups' => '<p>A list of additional Amazon EC2 security group IDs for the core and task nodes.</p>', ], ], 'SessionMappingDetail' => [ 'base' => '<p>Details for an Amazon EMR Studio session mapping including creation time, user or group ID, Studio ID, and so on.</p>', 'refs' => [ 'GetStudioSessionMappingOutput$SessionMapping' => '<p>The session mapping details for the specified Amazon EMR Studio and identity, including session policy ARN and creation time.</p>', ], ], 'SessionMappingSummary' => [ 'base' => '<p>Details for an Amazon EMR Studio session mapping. The details do not include the time the session mapping was last modified.</p>', 'refs' => [ 'SessionMappingSummaryList$member' => NULL, ], ], 'SessionMappingSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListStudioSessionMappingsOutput$SessionMappings' => '<p>A list of session mapping summary objects. Each object includes session mapping details such as creation time, identity type (user or group), and Amazon EMR Studio ID.</p>', ], ], 'SetTerminationProtectionInput' => [ 'base' => '<p> The input argument to the <a>TerminationProtection</a> operation. </p>', 'refs' => [], ], 'SetVisibleToAllUsersInput' => [ 'base' => '<p>The input to the SetVisibleToAllUsers action.</p>', 'refs' => [], ], 'ShrinkPolicy' => [ 'base' => '<p>Policy for customizing shrink operations. Allows configuration of decommissioning timeout and targeted instance shrinking.</p>', 'refs' => [ 'InstanceGroup$ShrinkPolicy' => '<p>Policy for customizing shrink operations.</p>', 'InstanceGroupModifyConfig$ShrinkPolicy' => '<p>Policy for customizing shrink operations.</p>', ], ], 'SimpleScalingPolicyConfiguration' => [ 'base' => '<p>An automatic scaling configuration, which describes how the policy adds or removes instances, the cooldown period, and the number of EC2 instances that will be added each time the CloudWatch metric alarm condition is satisfied.</p>', 'refs' => [ 'ScalingAction$SimpleScalingPolicyConfiguration' => '<p>The type of adjustment the automatic scaling activity makes when triggered, and the periodicity of the adjustment.</p>', ], ], 'SimplifiedApplication' => [ 'base' => '<p>The returned release label application names or versions.</p>', 'refs' => [ 'SimplifiedApplicationList$member' => NULL, ], ], 'SimplifiedApplicationList' => [ 'base' => NULL, 'refs' => [ 'DescribeReleaseLabelOutput$Applications' => '<p>The list of applications available for the target release label. <code>Name</code> is the name of the application. <code>Version</code> is the concise version of the application.</p>', ], ], 'SpotProvisioningAllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'SpotProvisioningSpecification$AllocationStrategy' => '<p> Specifies the strategy to use in launching Spot Instance fleets. Currently, the only option is capacity-optimized (the default), which launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. </p>', ], ], 'SpotProvisioningSpecification' => [ 'base' => '<p>The launch specification for Spot Instances in the instance fleet, which determines the defined duration, provisioning timeout behavior, and allocation strategy.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. Spot Instance allocation strategy is available in Amazon EMR version 5.12.1 and later.</p> </note> <note> <p>Spot Instances with a defined duration (also known as Spot blocks) are no longer available to new customers from July 1, 2021. For customers who have previously used the feature, we will continue to support Spot Instances with a defined duration until December 31, 2022. </p> </note>', 'refs' => [ 'InstanceFleetProvisioningSpecifications$SpotSpecification' => '<p>The launch specification for Spot Instances in the fleet, which determines the defined duration, provisioning timeout behavior, and allocation strategy.</p>', ], ], 'SpotProvisioningTimeoutAction' => [ 'base' => NULL, 'refs' => [ 'SpotProvisioningSpecification$TimeoutAction' => '<p>The action to take when <code>TargetSpotCapacity</code> has not been fulfilled when the <code>TimeoutDurationMinutes</code> has expired; that is, when all Spot Instances could not be provisioned within the Spot provisioning timeout. Valid values are <code>TERMINATE_CLUSTER</code> and <code>SWITCH_TO_ON_DEMAND</code>. SWITCH_TO_ON_DEMAND specifies that if no Spot Instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.</p>', ], ], 'StartNotebookExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'StartNotebookExecutionOutput' => [ 'base' => NULL, 'refs' => [], ], 'Statistic' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmDefinition$Statistic' => '<p>The statistic to apply to the metric associated with the alarm. The default is <code>AVERAGE</code>.</p>', ], ], 'Step' => [ 'base' => '<p>This represents a step in a cluster.</p>', 'refs' => [ 'DescribeStepOutput$Step' => '<p>The step details for the requested step identifier.</p>', ], ], 'StepCancellationOption' => [ 'base' => NULL, 'refs' => [ 'CancelStepsInput$StepCancellationOption' => '<p>The option to choose to cancel <code>RUNNING</code> steps. By default, the value is <code>SEND_INTERRUPT</code>.</p>', ], ], 'StepConfig' => [ 'base' => '<p>Specification for a cluster (job flow) step.</p>', 'refs' => [ 'StepConfigList$member' => NULL, 'StepDetail$StepConfig' => '<p>The step configuration.</p>', ], ], 'StepConfigList' => [ 'base' => NULL, 'refs' => [ 'AddJobFlowStepsInput$Steps' => '<p> A list of <a>StepConfig</a> to be executed by the job flow. </p>', 'RunJobFlowInput$Steps' => '<p>A list of steps to run.</p>', ], ], 'StepDetail' => [ 'base' => '<p>Combines the execution state and configuration of a step.</p>', 'refs' => [ 'StepDetailList$member' => NULL, ], ], 'StepDetailList' => [ 'base' => NULL, 'refs' => [ 'JobFlowDetail$Steps' => '<p>A list of steps run by the job flow.</p>', ], ], 'StepExecutionState' => [ 'base' => NULL, 'refs' => [ 'StepExecutionStatusDetail$State' => '<p>The state of the step.</p>', ], ], 'StepExecutionStatusDetail' => [ 'base' => '<p>The execution state of a step.</p>', 'refs' => [ 'StepDetail$ExecutionStatusDetail' => '<p>The description of the step status.</p>', ], ], 'StepId' => [ 'base' => NULL, 'refs' => [ 'CancelStepsInfo$StepId' => '<p>The encrypted StepId of a step.</p>', 'DescribeStepInput$StepId' => '<p>The identifier of the step to describe.</p>', 'Step$Id' => '<p>The identifier of the cluster step.</p>', 'StepSummary$Id' => '<p>The identifier of the cluster step.</p>', ], ], 'StepIdsList' => [ 'base' => NULL, 'refs' => [ 'AddJobFlowStepsOutput$StepIds' => '<p>The identifiers of the list of steps added to the job flow.</p>', 'CancelStepsInput$StepIds' => '<p>The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the specified cluster.</p>', ], ], 'StepState' => [ 'base' => NULL, 'refs' => [ 'StepStateList$member' => NULL, 'StepStatus$State' => '<p>The execution state of the cluster step.</p>', ], ], 'StepStateChangeReason' => [ 'base' => '<p>The details of the step state change reason.</p>', 'refs' => [ 'StepStatus$StateChangeReason' => '<p>The reason for the step execution status change.</p>', ], ], 'StepStateChangeReasonCode' => [ 'base' => NULL, 'refs' => [ 'StepStateChangeReason$Code' => '<p>The programmable code for the state change reason. Note: Currently, the service provides no code for the state change.</p>', ], ], 'StepStateList' => [ 'base' => NULL, 'refs' => [ 'ListStepsInput$StepStates' => '<p>The filter to limit the step list based on certain states.</p>', ], ], 'StepStatus' => [ 'base' => '<p>The execution status details of the cluster step.</p>', 'refs' => [ 'Step$Status' => '<p>The current execution status details of the cluster step.</p>', 'StepSummary$Status' => '<p>The current execution status details of the cluster step.</p>', ], ], 'StepSummary' => [ 'base' => '<p>The summary of the cluster step.</p>', 'refs' => [ 'StepSummaryList$member' => NULL, ], ], 'StepSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListStepsOutput$Steps' => '<p>The filtered list of steps for the cluster.</p>', ], ], 'StepTimeline' => [ 'base' => '<p>The timeline of the cluster step lifecycle.</p>', 'refs' => [ 'StepStatus$Timeline' => '<p>The timeline of the cluster step status over time.</p>', ], ], 'StopNotebookExecutionInput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'Application$Name' => '<p>The name of the application.</p>', 'Application$Version' => '<p>The version of the application.</p>', 'AutoScalingPolicyStateChangeReason$Message' => '<p>A friendly, more verbose message that accompanies an automatic scaling policy state change.</p>', 'CancelStepsInfo$Reason' => '<p>The reason for the failure if the CancelSteps request fails.</p>', 'CloudWatchAlarmDefinition$MetricName' => '<p>The name of the CloudWatch metric that is watched to determine an alarm condition.</p>', 'CloudWatchAlarmDefinition$Namespace' => '<p>The namespace for the CloudWatch metric. The default is <code>AWS/ElasticMapReduce</code>.</p>', 'Cluster$Name' => '<p>The name of the cluster.</p>', 'Cluster$LogUri' => '<p>The path to the Amazon S3 location where logs for this cluster are stored.</p>', 'Cluster$LogEncryptionKmsKeyId' => '<p> The KMS key used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0. </p>', 'Cluster$RequestedAmiVersion' => '<p>The AMI version requested for this cluster.</p>', 'Cluster$RunningAmiVersion' => '<p>The AMI version running on this cluster.</p>', 'Cluster$ReleaseLabel' => '<p>The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code>.</p>', 'Cluster$ServiceRole' => '<p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf.</p>', 'Cluster$MasterPublicDnsName' => '<p>The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.</p>', 'Cluster$OSReleaseLabel' => '<p>The Amazon Linux release specified in a cluster launch RunJobFlow request. If no Amazon Linux release was specified, the default Amazon Linux release is shown in the response.</p>', 'ClusterStateChangeReason$Message' => '<p>The descriptive message for the state change reason.</p>', 'ClusterSummary$Name' => '<p>The name of the cluster.</p>', 'Command$Name' => '<p>The name of the command.</p>', 'Command$ScriptPath' => '<p>The Amazon S3 location of the command script.</p>', 'Configuration$Classification' => '<p>The classification within a configuration.</p>', 'CreateSecurityConfigurationInput$SecurityConfiguration' => '<p>The security configuration details in JSON format. For JSON parameters and examples, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-security-configurations.html">Use Security Configurations to Set Up Cluster Security</a> in the <i>Amazon EMR Management Guide</i>.</p>', 'DescribeReleaseLabelInput$ReleaseLabel' => '<p>The target release label to be described.</p>', 'DescribeReleaseLabelInput$NextToken' => '<p>The pagination token. Reserved for future use. Currently set to null.</p>', 'DescribeReleaseLabelOutput$ReleaseLabel' => '<p>The target release label described in the response.</p>', 'DescribeReleaseLabelOutput$NextToken' => '<p>The pagination token. Reserved for future use. Currently set to null.</p>', 'DescribeSecurityConfigurationOutput$SecurityConfiguration' => '<p>The security configuration details in JSON format.</p>', 'EbsBlockDevice$Device' => '<p>The device name that is exposed to the instance, such as /dev/sdh.</p>', 'EbsVolume$Device' => '<p>The device name that is exposed to the instance, such as /dev/sdh.</p>', 'EbsVolume$VolumeId' => '<p>The volume identifier of the EBS volume.</p>', 'Ec2InstanceAttributes$Ec2KeyName' => '<p>The name of the Amazon EC2 key pair to use when connecting with SSH into the master node as a user named "hadoop".</p>', 'Ec2InstanceAttributes$Ec2SubnetId' => '<p>Set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch. If you do not specify this value, and your account supports EC2-Classic, the cluster launches in EC2-Classic.</p>', 'Ec2InstanceAttributes$Ec2AvailabilityZone' => '<p>The Availability Zone in which the cluster will run. </p>', 'Ec2InstanceAttributes$IamInstanceProfile' => '<p>The IAM role that was specified when the cluster was launched. The EC2 instances of the cluster assume this role.</p>', 'Ec2InstanceAttributes$EmrManagedMasterSecurityGroup' => '<p>The identifier of the Amazon EC2 security group for the master node.</p>', 'Ec2InstanceAttributes$EmrManagedSlaveSecurityGroup' => '<p>The identifier of the Amazon EC2 security group for the core and task nodes.</p>', 'Ec2InstanceAttributes$ServiceAccessSecurityGroup' => '<p>The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.</p>', 'FailureDetails$Reason' => '<p>The reason for the step failure. In the case where the service cannot successfully determine the root cause of the failure, it returns "Unknown Error" as a reason.</p>', 'FailureDetails$Message' => '<p>The descriptive message including the error the Amazon EMR service has identified as the cause of step failure. This is text from an error log that describes the root cause of the failure.</p>', 'FailureDetails$LogFile' => '<p>The path to the log file where the step failure root cause was originally recorded.</p>', 'HadoopStepConfig$Jar' => '<p>The path to the JAR file that runs during the step.</p>', 'HadoopStepConfig$MainClass' => '<p>The name of the main class in the specified Java file. If not specified, the JAR file should specify a main class in its manifest file.</p>', 'Instance$PublicDnsName' => '<p>The public DNS name of the instance.</p>', 'Instance$PublicIpAddress' => '<p>The public IP address of the instance.</p>', 'Instance$PrivateDnsName' => '<p>The private DNS name of the instance.</p>', 'Instance$PrivateIpAddress' => '<p>The private IP address of the instance.</p>', 'Instance$InstanceGroupId' => '<p>The identifier of the instance group to which this instance belongs.</p>', 'InstanceFleetStateChangeReason$Message' => '<p>An explanatory message.</p>', 'InstanceGroup$Name' => '<p>The name of the instance group.</p>', 'InstanceGroup$BidPrice' => '<p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>', 'InstanceGroupStateChangeReason$Message' => '<p>The status change reason description.</p>', 'InstanceStateChangeReason$Message' => '<p>The status change reason description.</p>', 'ListReleaseLabelsInput$NextToken' => '<p>Specifies the next page of results. If <code>NextToken</code> is not specified, which is usually the case for the first request of ListReleaseLabels, the first page of results are determined by other filtering parameters or by the latest version. The <code>ListReleaseLabels</code> request fails if the identity (Amazon Web Services account ID) and all filtering parameters are different from the original request, or if the <code>NextToken</code> is expired or tampered with.</p>', 'ListReleaseLabelsOutput$NextToken' => '<p>Used to paginate the next page of results if specified in the next <code>ListReleaseLabels</code> request.</p>', 'MetricDimension$Key' => '<p>The dimension name.</p>', 'MetricDimension$Value' => '<p>The dimension value.</p>', 'ModifyClusterInput$ClusterId' => '<p>The unique identifier of the cluster.</p>', 'OSRelease$Label' => '<p>The Amazon Linux release specified for a cluster in the RunJobFlow request. The format is as shown in <a href="https://docs.aws.amazon.com/AL2/latest/relnotes/relnotes-20220218.html"> <i>Amazon Linux 2 Release Notes</i> </a>. For example, 2.0.20220218.1.</p>', 'ReleaseLabelFilter$Prefix' => '<p>Optional release label version prefix filter. For example, <code>emr-5</code>.</p>', 'ReleaseLabelFilter$Application' => '<p>Optional release label application filter. For example, <code>spark@2.1.0</code>.</p>', 'ScalingRule$Name' => '<p>The name used to identify an automatic scaling rule. Rule names must be unique within a scaling policy.</p>', 'ScalingRule$Description' => '<p>A friendly, more verbose description of the automatic scaling rule.</p>', 'SimplifiedApplication$Name' => '<p>The returned release label application name. For example, <code>hadoop</code>.</p>', 'SimplifiedApplication$Version' => '<p>The returned release label application version. For example, <code>3.2.1</code>.</p>', 'Step$Name' => '<p>The name of the cluster step.</p>', 'StepStateChangeReason$Message' => '<p>The descriptive message for the state change reason.</p>', 'StepSummary$Name' => '<p>The name of the cluster step.</p>', 'StringList$member' => NULL, 'StringMap$key' => NULL, 'StringMap$value' => NULL, 'SubnetIdList$member' => NULL, 'Tag$Key' => '<p>A user-defined key, which is the minimum required information for a valid tag. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag</a>. </p>', 'Tag$Value' => '<p>A user-defined value, which is optional in a tag. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>. </p>', 'VolumeSpecification$VolumeType' => '<p>The volume type. Volume types supported are gp2, io1, and standard.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'Application$Args' => '<p>Arguments for Amazon EMR to pass to the application.</p>', 'Command$Args' => '<p>Arguments for Amazon EMR to pass to the command for execution.</p>', 'Ec2InstanceAttributes$AdditionalMasterSecurityGroups' => '<p>A list of additional Amazon EC2 security group IDs for the master node.</p>', 'Ec2InstanceAttributes$AdditionalSlaveSecurityGroups' => '<p>A list of additional Amazon EC2 security group IDs for the core and task nodes.</p>', 'HadoopStepConfig$Args' => '<p>The list of command line arguments to pass to the JAR file\'s main function for execution.</p>', 'ListReleaseLabelsOutput$ReleaseLabels' => '<p>The returned release labels.</p>', 'RemoveTagsInput$TagKeys' => '<p>A list of tag keys to remove from the resource.</p>', ], ], 'StringMap' => [ 'base' => NULL, 'refs' => [ 'Application$AdditionalInfo' => '<p>This option is for advanced users only. This is meta information about third-party applications that third-party vendors use for testing purposes.</p>', 'Configuration$Properties' => '<p>A set of properties specified within a configuration classification.</p>', 'HadoopStepConfig$Properties' => '<p>The list of Java properties that are set when the step runs. You can use these properties to pass key-value pairs to your main function.</p>', ], ], 'Studio' => [ 'base' => '<p>Details for an Amazon EMR Studio including ID, creation time, name, and so on.</p>', 'refs' => [ 'DescribeStudioOutput$Studio' => '<p>The Amazon EMR Studio details.</p>', ], ], 'StudioSummary' => [ 'base' => '<p>Details for an Amazon EMR Studio, including ID, Name, VPC, and Description. The details do not include subnets, IAM roles, security groups, or tags associated with the Studio.</p>', 'refs' => [ 'StudioSummaryList$member' => NULL, ], ], 'StudioSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListStudiosOutput$Studios' => '<p>The list of Studio summary objects.</p>', ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'CreateStudioInput$SubnetIds' => '<p>A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by <code>VpcId</code>. Studio users can create a Workspace in any of the specified subnets.</p>', 'Studio$SubnetIds' => '<p>The list of IDs of the subnets associated with the Amazon EMR Studio.</p>', 'UpdateStudioInput$SubnetIds' => '<p>A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio. </p>', ], ], 'SupportedProductConfig' => [ 'base' => '<p>The list of supported product configurations that allow user-supplied arguments. EMR accepts these arguments and forwards them to the corresponding installation script as bootstrap action arguments.</p>', 'refs' => [ 'NewSupportedProductsList$member' => NULL, ], ], 'SupportedProductsList' => [ 'base' => NULL, 'refs' => [ 'JobFlowDetail$SupportedProducts' => '<p>A list of strings set by third-party software when the job flow is launched. If you are not using third-party software to manage the job flow, this value is empty.</p>', 'RunJobFlowInput$SupportedProducts' => '<note> <p>For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and later, use Applications.</p> </note> <p>A list of strings that indicates third-party software to use. For more information, see the <a href="https://docs.aws.amazon.com/emr/latest/DeveloperGuide/emr-dg.pdf">Amazon EMR Developer Guide</a>. Currently supported values are:</p> <ul> <li> <p>"mapr-m3" - launch the job flow using MapR M3 Edition.</p> </li> <li> <p>"mapr-m5" - launch the job flow using MapR M5 Edition.</p> </li> </ul>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair containing user-defined metadata that you can associate with an Amazon EMR resource. Tags make it easier to associate clusters in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters</a>. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsInput$Tags' => '<p>A list of tags to associate with a resource. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.</p>', 'Cluster$Tags' => '<p>A list of tags associated with a cluster.</p>', 'CreateStudioInput$Tags' => '<p>A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.</p>', 'NotebookExecution$Tags' => '<p>A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters.</p>', 'RunJobFlowInput$Tags' => '<p>A list of tags to associate with a cluster and propagate to Amazon EC2 instances.</p>', 'StartNotebookExecutionInput$Tags' => '<p>A list of tags associated with a notebook execution. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters and an optional value string with a maximum of 256 characters.</p>', 'Studio$Tags' => '<p>A list of tags associated with the Amazon EMR Studio.</p>', ], ], 'TerminateJobFlowsInput' => [ 'base' => '<p> Input to the <a>TerminateJobFlows</a> operation. </p>', 'refs' => [], ], 'ThroughputVal' => [ 'base' => NULL, 'refs' => [ 'VolumeSpecification$Throughput' => '<p>The throughput, in mebibyte per second (MiB/s). This optional parameter can be a number from 125 - 1000 and is valid only for gp3 volumes.</p>', ], ], 'Unit' => [ 'base' => NULL, 'refs' => [ 'CloudWatchAlarmDefinition$Unit' => '<p>The unit of measure associated with the CloudWatch metric being watched. The value specified for <code>Unit</code> must correspond to the units specified in the CloudWatch metric.</p>', ], ], 'UpdateStudioInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStudioSessionMappingInput' => [ 'base' => NULL, 'refs' => [], ], 'VolumeSpecification' => [ 'base' => '<p>EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an EC2 instance in the cluster.</p>', 'refs' => [ 'EbsBlockDevice$VolumeSpecification' => '<p>EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an EC2 instance in the cluster.</p>', 'EbsBlockDeviceConfig$VolumeSpecification' => '<p>EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an EC2 instance in the cluster.</p>', ], ], 'WholeNumber' => [ 'base' => NULL, 'refs' => [ 'InstanceFleet$TargetOnDemandCapacity' => '<p>The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to provision On-Demand Instances as specified by <a>InstanceTypeConfig</a>. Each instance configuration has a specified <code>WeightedCapacity</code>. When an On-Demand Instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units. You can use <a>InstanceFleet$ProvisionedOnDemandCapacity</a> to determine the Spot capacity units that have been provisioned for the instance fleet.</p> <note> <p>If not specified or set to 0, only Spot Instances are provisioned for the instance fleet using <code>TargetSpotCapacity</code>. At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p> </note>', 'InstanceFleet$TargetSpotCapacity' => '<p>The target capacity of Spot units for the instance fleet, which determines how many Spot Instances to provision. When the instance fleet launches, Amazon EMR tries to provision Spot Instances as specified by <a>InstanceTypeConfig</a>. Each instance configuration has a specified <code>WeightedCapacity</code>. When a Spot instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units. You can use <a>InstanceFleet$ProvisionedSpotCapacity</a> to determine the Spot capacity units that have been provisioned for the instance fleet.</p> <note> <p>If not specified or set to 0, only On-Demand Instances are provisioned for the instance fleet. At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p> </note>', 'InstanceFleet$ProvisionedOnDemandCapacity' => '<p>The number of On-Demand units that have been provisioned for the instance fleet to fulfill <code>TargetOnDemandCapacity</code>. This provisioned capacity might be less than or greater than <code>TargetOnDemandCapacity</code>.</p>', 'InstanceFleet$ProvisionedSpotCapacity' => '<p>The number of Spot units that have been provisioned for this instance fleet to fulfill <code>TargetSpotCapacity</code>. This provisioned capacity might be less than or greater than <code>TargetSpotCapacity</code>.</p>', 'InstanceFleetConfig$TargetOnDemandCapacity' => '<p>The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand Instances to provision. When the instance fleet launches, Amazon EMR tries to provision On-Demand Instances as specified by <a>InstanceTypeConfig</a>. Each instance configuration has a specified <code>WeightedCapacity</code>. When an On-Demand Instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.</p> <note> <p>If not specified or set to 0, only Spot Instances are provisioned for the instance fleet using <code>TargetSpotCapacity</code>. At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p> </note>', 'InstanceFleetConfig$TargetSpotCapacity' => '<p>The target capacity of Spot units for the instance fleet, which determines how many Spot Instances to provision. When the instance fleet launches, Amazon EMR tries to provision Spot Instances as specified by <a>InstanceTypeConfig</a>. Each instance configuration has a specified <code>WeightedCapacity</code>. When a Spot Instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.</p> <note> <p>If not specified or set to 0, only On-Demand Instances are provisioned for the instance fleet. At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.</p> </note>', 'InstanceFleetModifyConfig$TargetOnDemandCapacity' => '<p>The target capacity of On-Demand units for the instance fleet. For more information see <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.</p>', 'InstanceFleetModifyConfig$TargetSpotCapacity' => '<p>The target capacity of Spot units for the instance fleet. For more information, see <a>InstanceFleetConfig$TargetSpotCapacity</a>.</p>', 'InstanceTypeConfig$WeightedCapacity' => '<p>The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in <a>InstanceFleetConfig</a>. This value is 1 for a master instance fleet, and must be 1 or greater for core and task instance fleets. Defaults to 1 if not specified. </p>', 'InstanceTypeSpecification$WeightedCapacity' => '<p>The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in <a>InstanceFleetConfig</a>. Capacity values represent performance characteristics such as vCPUs, memory, or I/O. If not specified, the default value is 1.</p>', 'SpotProvisioningSpecification$TimeoutDurationMinutes' => '<p>The spot provisioning timeout period in minutes. If Spot Instances are not provisioned within this time period, the <code>TimeOutAction</code> is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.</p>', 'SpotProvisioningSpecification$BlockDurationMinutes' => '<p>The defined duration for Spot Instances (also known as Spot blocks) in minutes. When specified, the Spot Instance does not terminate before the defined duration expires, and defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot Instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and provides a Spot Instance termination notice, which gives the instance a two-minute warning before it terminates. </p> <note> <p>Spot Instances with a defined duration (also known as Spot blocks) are no longer available to new customers from July 1, 2021. For customers who have previously used the feature, we will continue to support Spot Instances with a defined duration until December 31, 2022. </p> </note>', ], ], 'XmlString' => [ 'base' => NULL, 'refs' => [ 'Cluster$SecurityConfiguration' => '<p>The name of the security configuration applied to the cluster.</p>', 'Cluster$AutoScalingRole' => '<p>An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.</p>', 'CreateSecurityConfigurationInput$Name' => '<p>The name of the security configuration.</p>', 'CreateSecurityConfigurationOutput$Name' => '<p>The name of the security configuration.</p>', 'CreateStudioInput$ServiceRole' => '<p>The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.</p>', 'CreateStudioInput$UserRole' => '<p>The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a <code>UserRole</code> when you use Amazon Web Services SSO authentication. The permissions attached to the <code>UserRole</code> can be scoped down for each user or group using session policies.</p>', 'CreateStudioInput$DefaultS3Location' => '<p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.</p>', 'CreateStudioInput$IdpAuthUrl' => '<p>The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.</p>', 'CreateStudioOutput$Url' => '<p>The unique Studio access URL.</p>', 'DeleteSecurityConfigurationInput$Name' => '<p>The name of the security configuration.</p>', 'DescribeSecurityConfigurationInput$Name' => '<p>The name of the security configuration.</p>', 'DescribeSecurityConfigurationOutput$Name' => '<p>The name of the security configuration.</p>', 'HadoopJarStepConfig$Jar' => '<p>A path to a JAR file run during the step.</p>', 'HadoopJarStepConfig$MainClass' => '<p>The name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.</p>', 'InstanceGroupDetail$LastStateChangeReason' => '<p>Details regarding the state of the instance group.</p>', 'JobFlowDetail$LogUri' => '<p>The location in Amazon S3 where log files for the job are stored.</p>', 'JobFlowDetail$LogEncryptionKmsKeyId' => '<p>The KMS key used for encrypting log files. This attribute is only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.</p>', 'JobFlowDetail$JobFlowRole' => '<p>The IAM role that was specified when the job flow was launched. The EC2 instances of the job flow assume this role.</p>', 'JobFlowDetail$ServiceRole' => '<p>The IAM role that is assumed by the Amazon EMR service to access Amazon Web Services resources on your behalf.</p>', 'JobFlowDetail$AutoScalingRole' => '<p>An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides a way for the automatic scaling feature to get the required permissions it needs to launch and terminate EC2 instances in an instance group.</p>', 'JobFlowExecutionStatusDetail$LastStateChangeReason' => '<p>Description of the job flow last changed state.</p>', 'JobFlowInstancesDetail$MasterPublicDnsName' => '<p>The DNS name of the master node. If the cluster is on a private subnet, this is the private DNS name. On a public subnet, this is the public DNS name.</p>', 'JobFlowInstancesDetail$MasterInstanceId' => '<p>The Amazon EC2 instance identifier of the master node.</p>', 'KeyValue$Key' => '<p>The unique identifier of a key-value pair.</p>', 'KeyValue$Value' => '<p>The value part of the identified key.</p>', 'NotebookExecution$NotebookParams' => '<p>Input parameters in JSON format passed to the EMR Notebook at runtime for execution.</p>', 'NotebookExecution$OutputNotebookURI' => '<p>The location of the notebook execution\'s output file in Amazon S3.</p>', 'NotebookExecution$LastStateChangeReason' => '<p>The reason for the latest status change of the notebook execution.</p>', 'PlacementType$AvailabilityZone' => '<p>The Amazon EC2 Availability Zone for the cluster. <code>AvailabilityZone</code> is used for uniform instance groups, while <code>AvailabilityZones</code> (plural) is used for instance fleets.</p>', 'RunJobFlowInput$LogUri' => '<p>The location in Amazon S3 to write the log files of the job flow. If a value is not provided, logs are not created.</p>', 'RunJobFlowInput$LogEncryptionKmsKeyId' => '<p>The KMS key used for encrypting log files. If a value is not provided, the logs remain encrypted by AES-256. This attribute is only available with Amazon EMR version 5.30.0 and later, excluding Amazon EMR 6.0.0.</p>', 'RunJobFlowInput$AdditionalInfo' => '<p>A JSON string for selecting additional features.</p>', 'RunJobFlowInput$JobFlowRole' => '<p>Also called instance profile and EC2 role. An IAM role for an EMR cluster. The EC2 instances of the cluster assume this role. The default role is <code>EMR_EC2_DefaultRole</code>. In order to use the default role, you must have already created it using the CLI or console.</p>', 'RunJobFlowInput$ServiceRole' => '<p>The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on your behalf.</p>', 'RunJobFlowInput$SecurityConfiguration' => '<p>The name of a security configuration to apply to the cluster.</p>', 'RunJobFlowInput$AutoScalingRole' => '<p>An IAM role for automatic scaling policies. The default role is <code>EMR_AutoScaling_DefaultRole</code>. The IAM role provides permissions that the automatic scaling feature requires to launch and terminate EC2 instances in an instance group.</p>', 'ScriptBootstrapActionConfig$Path' => '<p>Location in Amazon S3 of the script to run during a bootstrap action.</p>', 'SecurityConfigurationSummary$Name' => '<p>The name of the security configuration.</p>', 'StartNotebookExecutionInput$RelativePath' => '<p>The path and file name of the notebook file for this execution, relative to the path specified for the EMR Notebook. For example, if you specify a path of <code>s3://MyBucket/MyNotebooks</code> when you create an EMR Notebook for a notebook with an ID of <code>e-ABCDEFGHIJK1234567890ABCD</code> (the <code>EditorID</code> of this request), and you specify a <code>RelativePath</code> of <code>my_notebook_executions/notebook_execution.ipynb</code>, the location of the file for the notebook execution is <code>s3://MyBucket/MyNotebooks/e-ABCDEFGHIJK1234567890ABCD/my_notebook_executions/notebook_execution.ipynb</code>.</p>', 'StartNotebookExecutionInput$NotebookParams' => '<p>Input parameters in JSON format passed to the EMR Notebook at runtime for execution.</p>', 'StartNotebookExecutionInput$ServiceRole' => '<p>The name or ARN of the IAM role that is used as the service role for Amazon EMR (the EMR role) for the notebook execution.</p>', 'StepExecutionStatusDetail$LastStateChangeReason' => '<p>A description of the step\'s current state.</p>', 'Studio$ServiceRole' => '<p>The name of the IAM role assumed by the Amazon EMR Studio.</p>', 'Studio$UserRole' => '<p>The name of the IAM role assumed by users logged in to the Amazon EMR Studio. A Studio only requires a <code>UserRole</code> when you use IAM authentication.</p>', 'Studio$Url' => '<p>The unique access URL of the Amazon EMR Studio.</p>', 'Studio$DefaultS3Location' => '<p>The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.</p>', 'Studio$IdpAuthUrl' => '<p>Your identity provider\'s authentication endpoint. Amazon EMR Studio redirects federated users to this endpoint for authentication when logging in to a Studio with the Studio URL.</p>', 'UpdateStudioInput$DefaultS3Location' => '<p>The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio.</p>', 'XmlStringList$member' => NULL, ], ], 'XmlStringList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobFlowsInput$JobFlowIds' => '<p>Return only job flows whose job flow ID is contained in this list.</p>', 'HadoopJarStepConfig$Args' => '<p>A list of command line arguments passed to the JAR file\'s main function when executed.</p>', 'ListStepsInput$StepIds' => '<p>The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step IDs. The character constraint applies to the overall length of the array.</p>', 'ScriptBootstrapActionConfig$Args' => '<p>A list of command line arguments to pass to the bootstrap action script.</p>', 'SetTerminationProtectionInput$JobFlowIds' => '<p> A list of strings that uniquely identify the clusters to protect. This identifier is returned by <a>RunJobFlow</a> and can also be obtained from <a>DescribeJobFlows</a> . </p>', 'SetVisibleToAllUsersInput$JobFlowIds' => '<p>The unique identifier of the job flow (cluster).</p>', 'SupportedProductConfig$Args' => '<p>The list of user-supplied arguments.</p>', 'TerminateJobFlowsInput$JobFlowIds' => '<p>A list of job flows to be shut down.</p>', ], ], 'XmlStringMaxLen256' => [ 'base' => NULL, 'refs' => [ 'AddInstanceFleetInput$ClusterId' => '<p>The unique identifier of the cluster.</p>', 'AddInstanceFleetOutput$ClusterId' => '<p>The unique identifier of the cluster.</p>', 'AddInstanceGroupsInput$JobFlowId' => '<p>Job flow in which to add the instance groups.</p>', 'AddInstanceGroupsOutput$JobFlowId' => '<p>The job flow ID in which the instance groups are added.</p>', 'AddJobFlowStepsInput$JobFlowId' => '<p>A string that uniquely identifies the job flow. This identifier is returned by <a>RunJobFlow</a> and can also be obtained from <a>ListClusters</a>. </p>', 'BootstrapActionConfig$Name' => '<p>The name of the bootstrap action.</p>', 'CancelStepsInput$ClusterId' => '<p>The <code>ClusterID</code> for the specified steps that will be canceled. Use <a>RunJobFlow</a> and <a>ListClusters</a> to get ClusterIDs. </p>', 'Cluster$CustomAmiId' => '<p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI if the cluster uses a custom AMI.</p>', 'CreateStudioInput$Name' => '<p>A descriptive name for the Amazon EMR Studio.</p>', 'CreateStudioInput$Description' => '<p>A detailed description of the Amazon EMR Studio.</p>', 'CreateStudioInput$VpcId' => '<p>The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.</p>', 'CreateStudioInput$WorkspaceSecurityGroupId' => '<p>The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by <code>VpcId</code>.</p>', 'CreateStudioInput$EngineSecurityGroupId' => '<p>The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by <code>VpcId</code>.</p>', 'CreateStudioInput$IdpRelayStateParameterName' => '<p>The name that your identity provider (IdP) uses for its <code>RelayState</code> parameter. For example, <code>RelayState</code> or <code>TargetSource</code>. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The <code>RelayState</code> parameter differs by IdP.</p>', 'CreateStudioOutput$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'CreateStudioSessionMappingInput$StudioId' => '<p>The ID of the Amazon EMR Studio to which the user or group will be mapped.</p>', 'CreateStudioSessionMappingInput$IdentityId' => '<p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>', 'CreateStudioSessionMappingInput$IdentityName' => '<p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified, but not both.</p>', 'CreateStudioSessionMappingInput$SessionPolicyArn' => '<p>The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-user-role.html">Create an EMR Studio User Role with Session Policies</a>.</p>', 'DeleteStudioInput$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'DeleteStudioSessionMappingInput$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'DeleteStudioSessionMappingInput$IdentityId' => '<p>The globally unique identifier (GUID) of the user or group to remove from the Amazon EMR Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>', 'DeleteStudioSessionMappingInput$IdentityName' => '<p>The name of the user name or group to remove from the Amazon EMR Studio. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>', 'DescribeNotebookExecutionInput$NotebookExecutionId' => '<p>The unique identifier of the notebook execution.</p>', 'DescribeStudioInput$StudioId' => '<p>The Amazon EMR Studio ID.</p>', 'ExecutionEngineConfig$Id' => '<p>The unique identifier of the execution engine. For an EMR cluster, this is the cluster ID.</p>', 'ExecutionEngineConfig$MasterInstanceSecurityGroupId' => '<p>An optional unique ID of an EC2 security group to associate with the master instance of the EMR cluster for this notebook execution. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying EC2 Security Groups for EMR Notebooks</a> in the <i>EMR Management Guide</i>.</p>', 'GetStudioSessionMappingInput$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'GetStudioSessionMappingInput$IdentityId' => '<p>The globally unique identifier (GUID) of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>', 'GetStudioSessionMappingInput$IdentityName' => '<p>The name of the user or group to fetch. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>', 'InstanceFleet$Name' => '<p>A friendly name for the instance fleet.</p>', 'InstanceFleetConfig$Name' => '<p>The friendly name of the instance fleet.</p>', 'InstanceGroup$CustomAmiId' => '<p>The custom AMI ID to use for the provisioned instance group.</p>', 'InstanceGroupConfig$Name' => '<p>Friendly name given to the instance group.</p>', 'InstanceGroupConfig$BidPrice' => '<p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>', 'InstanceGroupConfig$CustomAmiId' => '<p>The custom AMI ID to use for the provisioned instance group.</p>', 'InstanceGroupDetail$InstanceGroupId' => '<p>Unique identifier for the instance group.</p>', 'InstanceGroupDetail$Name' => '<p>Friendly name for the instance group.</p>', 'InstanceGroupDetail$BidPrice' => '<p>If specified, indicates that the instance group uses Spot Instances. This is the maximum price you are willing to pay for Spot Instances. Specify <code>OnDemandPrice</code> to set the amount equal to the On-Demand price, or specify an amount in USD.</p>', 'InstanceGroupDetail$CustomAmiId' => '<p>The custom AMI ID to use for the provisioned instance group.</p>', 'InstanceGroupIdsList$member' => NULL, 'InstanceGroupModifyConfig$InstanceGroupId' => '<p>Unique ID of the instance group to modify.</p>', 'InstanceTypeConfig$BidPrice' => '<p>The bid price for each EC2 Spot Instance type as defined by <code>InstanceType</code>. Expressed in USD. If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%. </p>', 'InstanceTypeConfig$CustomAmiId' => '<p>The custom AMI ID to use for the instance type.</p>', 'InstanceTypeSpecification$BidPrice' => '<p>The bid price for each EC2 Spot Instance type as defined by <code>InstanceType</code>. Expressed in USD.</p>', 'InstanceTypeSpecification$CustomAmiId' => '<p>The custom AMI ID to use for the instance type.</p>', 'JobFlowDetail$JobFlowId' => '<p>The job flow identifier.</p>', 'JobFlowDetail$Name' => '<p>The name of the job flow.</p>', 'JobFlowDetail$AmiVersion' => '<p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use <code>CustomAmiID</code>.</p>', 'JobFlowInstancesConfig$Ec2KeyName' => '<p>The name of the EC2 key pair that can be used to connect to the master node using SSH as the user called "hadoop."</p>', 'JobFlowInstancesConfig$HadoopVersion' => '<p>Applies only to Amazon EMR release versions earlier than 4.0. The Hadoop version for the cluster. Valid inputs are "0.18" (no longer maintained), "0.20" (no longer maintained), "0.20.205" (no longer maintained), "1.0.3", "2.2.0", or "2.4.0". If you do not set this value, the default of 0.18 is used, unless the <code>AmiVersion</code> parameter is set in the RunJobFlow call, in which case the default version of Hadoop for that AMI version is used.</p>', 'JobFlowInstancesConfig$Ec2SubnetId' => '<p>Applies to clusters that use the uniform instance group configuration. To launch the cluster in Amazon Virtual Private Cloud (Amazon VPC), set this parameter to the identifier of the Amazon VPC subnet where you want the cluster to launch. If you do not specify this value and your account supports EC2-Classic, the cluster launches in EC2-Classic.</p>', 'JobFlowInstancesConfig$EmrManagedMasterSecurityGroup' => '<p>The identifier of the Amazon EC2 security group for the master node. If you specify <code>EmrManagedMasterSecurityGroup</code>, you must also specify <code>EmrManagedSlaveSecurityGroup</code>.</p>', 'JobFlowInstancesConfig$EmrManagedSlaveSecurityGroup' => '<p>The identifier of the Amazon EC2 security group for the core and task nodes. If you specify <code>EmrManagedSlaveSecurityGroup</code>, you must also specify <code>EmrManagedMasterSecurityGroup</code>.</p>', 'JobFlowInstancesConfig$ServiceAccessSecurityGroup' => '<p>The identifier of the Amazon EC2 security group for the Amazon EMR service to access clusters in VPC private subnets.</p>', 'JobFlowInstancesDetail$Ec2KeyName' => '<p>The name of an Amazon EC2 key pair that can be used to connect to the master node using SSH.</p>', 'JobFlowInstancesDetail$Ec2SubnetId' => '<p>For clusters launched within Amazon Virtual Private Cloud, this is the identifier of the subnet where the cluster was launched.</p>', 'JobFlowInstancesDetail$HadoopVersion' => '<p>The Hadoop version for the cluster.</p>', 'KerberosAttributes$Realm' => '<p>The name of the Kerberos realm to which all nodes in a cluster belong. For example, <code>EC2.INTERNAL</code>. </p>', 'KerberosAttributes$KdcAdminPassword' => '<p>The password used within the cluster for the kadmin service on the cluster-dedicated KDC, which maintains Kerberos principals, password policies, and keytabs for the cluster.</p>', 'KerberosAttributes$CrossRealmTrustPrincipalPassword' => '<p>Required only when establishing a cross-realm trust with a KDC in a different realm. The cross-realm principal password, which must be identical across realms.</p>', 'KerberosAttributes$ADDomainJoinUser' => '<p>Required only when establishing a cross-realm trust with an Active Directory domain. A user with sufficient privileges to join resources to the domain.</p>', 'KerberosAttributes$ADDomainJoinPassword' => '<p>The Active Directory password for <code>ADDomainJoinUser</code>.</p>', 'ListNotebookExecutionsInput$EditorId' => '<p>The unique ID of the editor associated with the notebook execution.</p>', 'ListStudioSessionMappingsInput$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'NotebookExecution$NotebookExecutionId' => '<p>The unique identifier of a notebook execution.</p>', 'NotebookExecution$EditorId' => '<p>The unique identifier of the EMR Notebook that is used for the notebook execution.</p>', 'NotebookExecution$NotebookExecutionName' => '<p>A name for the notebook execution.</p>', 'NotebookExecution$Arn' => '<p>The Amazon Resource Name (ARN) of the notebook execution.</p>', 'NotebookExecution$NotebookInstanceSecurityGroupId' => '<p>The unique identifier of the EC2 security group associated with the EMR Notebook instance. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-notebooks-security-groups.html">Specifying EC2 Security Groups for EMR Notebooks</a> in the <i>EMR Management Guide</i>.</p>', 'NotebookExecutionSummary$NotebookExecutionId' => '<p>The unique identifier of the notebook execution.</p>', 'NotebookExecutionSummary$EditorId' => '<p>The unique identifier of the editor associated with the notebook execution.</p>', 'NotebookExecutionSummary$NotebookExecutionName' => '<p>The name of the notebook execution.</p>', 'OnDemandCapacityReservationOptions$CapacityReservationResourceGroupArn' => '<p>The ARN of the Capacity Reservation resource group in which to run the instance.</p>', 'RunJobFlowInput$Name' => '<p>The name of the job flow.</p>', 'RunJobFlowInput$AmiVersion' => '<p>Applies only to Amazon EMR AMI versions 3.x and 2.x. For Amazon EMR releases 4.0 and later, <code>ReleaseLabel</code> is used. To specify a custom AMI, use <code>CustomAmiID</code>.</p>', 'RunJobFlowInput$ReleaseLabel' => '<p>The Amazon EMR release label, which determines the version of open-source application packages installed on the cluster. Release labels are in the form <code>emr-x.x.x</code>, where x.x.x is an Amazon EMR release version such as <code>emr-5.14.0</code>. For more information about Amazon EMR release versions and included application versions and features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/</a>. The release label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use <code>AmiVersion</code>.</p>', 'RunJobFlowInput$CustomAmiId' => '<p>Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon EBS-backed Linux AMI. If specified, Amazon EMR uses this AMI when it launches cluster EC2 instances. For more information about custom AMIs in Amazon EMR, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-custom-ami.html">Using a Custom AMI</a> in the <i>Amazon EMR Management Guide</i>. If omitted, the cluster uses the base Linux AMI for the <code>ReleaseLabel</code> specified. For Amazon EMR versions 2.x and 3.x, use <code>AmiVersion</code> instead.</p> <p>For information about creating a custom AMI, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html">Creating an Amazon EBS-Backed Linux AMI</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>. For information about finding an AMI ID, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Finding a Linux AMI</a>. </p>', 'RunJobFlowInput$OSReleaseLabel' => '<p>Specifies a particular Amazon Linux release for all nodes in a cluster launch RunJobFlow request. If a release is not specified, Amazon EMR uses the latest validated Amazon Linux release for cluster launch.</p>', 'RunJobFlowOutput$JobFlowId' => '<p>A unique identifier for the job flow.</p>', 'SecurityGroupsList$member' => NULL, 'SessionMappingDetail$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'SessionMappingDetail$IdentityId' => '<p>The globally unique identifier (GUID) of the user or group.</p>', 'SessionMappingDetail$IdentityName' => '<p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.</p>', 'SessionMappingDetail$SessionPolicyArn' => '<p>The Amazon Resource Name (ARN) of the session policy associated with the user or group.</p>', 'SessionMappingSummary$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'SessionMappingSummary$IdentityId' => '<p>The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.</p>', 'SessionMappingSummary$IdentityName' => '<p>The name of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>.</p>', 'SessionMappingSummary$SessionPolicyArn' => '<p>The Amazon Resource Name (ARN) of the session policy associated with the user or group.</p>', 'StartNotebookExecutionInput$EditorId' => '<p>The unique identifier of the EMR Notebook to use for notebook execution.</p>', 'StartNotebookExecutionInput$NotebookExecutionName' => '<p>An optional name for the notebook execution.</p>', 'StartNotebookExecutionInput$NotebookInstanceSecurityGroupId' => '<p>The unique identifier of the Amazon EC2 security group to associate with the EMR Notebook for this notebook execution.</p>', 'StartNotebookExecutionOutput$NotebookExecutionId' => '<p>The unique identifier of the notebook execution.</p>', 'StepConfig$Name' => '<p>The name of the step.</p>', 'StepIdsList$member' => NULL, 'StopNotebookExecutionInput$NotebookExecutionId' => '<p>The unique identifier of the notebook execution.</p>', 'Studio$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'Studio$StudioArn' => '<p>The Amazon Resource Name (ARN) of the Amazon EMR Studio.</p>', 'Studio$Name' => '<p>The name of the Amazon EMR Studio.</p>', 'Studio$Description' => '<p>The detailed description of the Amazon EMR Studio.</p>', 'Studio$VpcId' => '<p>The ID of the VPC associated with the Amazon EMR Studio.</p>', 'Studio$WorkspaceSecurityGroupId' => '<p>The ID of the Workspace security group associated with the Amazon EMR Studio. The Workspace security group allows outbound network traffic to resources in the Engine security group and to the internet.</p>', 'Studio$EngineSecurityGroupId' => '<p>The ID of the Engine security group associated with the Amazon EMR Studio. The Engine security group allows inbound network traffic from resources in the Workspace security group.</p>', 'Studio$IdpRelayStateParameterName' => '<p>The name of your identity provider\'s <code>RelayState</code> parameter.</p>', 'StudioSummary$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'StudioSummary$Name' => '<p>The name of the Amazon EMR Studio.</p>', 'StudioSummary$VpcId' => '<p>The ID of the Virtual Private Cloud (Amazon VPC) associated with the Amazon EMR Studio.</p>', 'StudioSummary$Description' => '<p>The detailed description of the Amazon EMR Studio.</p>', 'StudioSummary$Url' => '<p>The unique access URL of the Amazon EMR Studio.</p>', 'SupportedProductConfig$Name' => '<p>The name of the product configuration.</p>', 'SupportedProductsList$member' => NULL, 'UpdateStudioInput$StudioId' => '<p>The ID of the Amazon EMR Studio to update.</p>', 'UpdateStudioInput$Name' => '<p>A descriptive name for the Amazon EMR Studio.</p>', 'UpdateStudioInput$Description' => '<p>A detailed description to assign to the Amazon EMR Studio.</p>', 'UpdateStudioSessionMappingInput$StudioId' => '<p>The ID of the Amazon EMR Studio.</p>', 'UpdateStudioSessionMappingInput$IdentityId' => '<p>The globally unique identifier (GUID) of the user or group. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId">UserId</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId">GroupId</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>', 'UpdateStudioSessionMappingInput$IdentityName' => '<p>The name of the user or group to update. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName">UserName</a> and <a href="https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName">DisplayName</a> in the <i>Amazon Web Services SSO Identity Store API Reference</i>. Either <code>IdentityName</code> or <code>IdentityId</code> must be specified.</p>', 'UpdateStudioSessionMappingInput$SessionPolicyArn' => '<p>The Amazon Resource Name (ARN) of the session policy to associate with the specified user or group.</p>', 'XmlStringMaxLen256List$member' => NULL, ], ], 'XmlStringMaxLen256List' => [ 'base' => NULL, 'refs' => [ 'Ec2InstanceAttributes$RequestedEc2SubnetIds' => '<p>Applies to clusters configured with the instance fleets option. Specifies the unique identifier of one or more Amazon EC2 subnets in which to launch EC2 cluster instances. Subnets must exist within the same VPC. Amazon EMR chooses the EC2 subnet with the best fit from among the list of <code>RequestedEc2SubnetIds</code>, and then launches all cluster instances within that Subnet. If this value is not specified, and the account and Region support EC2-Classic networks, the cluster launches instances in the EC2-Classic network and uses <code>RequestedEc2AvailabilityZones</code> instead of this setting. If EC2-Classic is not supported, and no Subnet is specified, Amazon EMR chooses the subnet for you. <code>RequestedEc2SubnetIDs</code> and <code>RequestedEc2AvailabilityZones</code> cannot be specified together.</p>', 'Ec2InstanceAttributes$RequestedEc2AvailabilityZones' => '<p>Applies to clusters configured with the instance fleets option. Specifies one or more Availability Zones in which to launch EC2 cluster instances when the EC2-Classic network configuration is supported. Amazon EMR chooses the Availability Zone with the best fit from among the list of <code>RequestedEc2AvailabilityZones</code>, and then launches all cluster instances within that Availability Zone. If you do not specify this value, Amazon EMR chooses the Availability Zone for you. <code>RequestedEc2SubnetIDs</code> and <code>RequestedEc2AvailabilityZones</code> cannot be specified together.</p>', 'JobFlowInstancesConfig$Ec2SubnetIds' => '<p>Applies to clusters that use the instance fleet configuration. When multiple EC2 subnet IDs are specified, Amazon EMR evaluates them and launches instances in the optimal subnet.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', 'PlacementType$AvailabilityZones' => '<p>When multiple Availability Zones are specified, Amazon EMR evaluates them and launches instances in the optimal Availability Zone. <code>AvailabilityZones</code> is used for instance fleets, while <code>AvailabilityZone</code> (singular) is used for uniform instance groups.</p> <note> <p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.</p> </note>', ], ], ],];
