<?php
// This file was auto-generated from sdk-root/src/data/batch/2016-08-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Batch</fullname> <p>Using Batch, you can run batch computing workloads on the Amazon Web Services Cloud. Batch computing is a common means for developers, scientists, and engineers to access large amounts of compute resources. Batch uses the advantages of this computing workload to remove the undifferentiated heavy lifting of configuring and managing required infrastructure. At the same time, it also adopts a familiar batch computing software approach. Given these advantages, Batch can help you to efficiently provision resources in response to jobs submitted, thus effectively helping you to eliminate capacity constraints, reduce compute costs, and deliver your results more quickly.</p> <p>As a fully managed service, Batch can run batch computing workloads of any scale. Batch automatically provisions compute resources and optimizes workload distribution based on the quantity and scale of your specific workloads. With Batch, there\'s no need to install or manage batch computing software. This means that you can focus your time and energy on analyzing results and solving your specific problems.</p>', 'operations' => [ 'CancelJob' => '<p>Cancels a job in an Batch job queue. Jobs that are in the <code>SUBMITTED</code>, <code>PENDING</code>, or <code>RUNNABLE</code> state are canceled. Jobs that have progressed to <code>STARTING</code> or <code>RUNNING</code> aren\'t canceled, but the API operation still succeeds, even if no job is canceled. These jobs must be terminated with the <a>TerminateJob</a> operation.</p>', 'CreateComputeEnvironment' => '<p>Creates an Batch compute environment. You can create <code>MANAGED</code> or <code>UNMANAGED</code> compute environments. <code>MANAGED</code> compute environments can use Amazon EC2 or Fargate resources. <code>UNMANAGED</code> compute environments can only use EC2 resources.</p> <p>In a managed compute environment, Batch manages the capacity and instance types of the compute resources within the environment. This is based on the compute resource specification that you define or the <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html">launch template</a> that you specify when you create the compute environment. Either, you can choose to use EC2 On-Demand Instances and EC2 Spot Instances. Or, you can use Fargate and Fargate Spot capacity in your managed compute environment. You can optionally set a maximum price so that Spot Instances only launch when the Spot Instance price is less than a specified percentage of the On-Demand price.</p> <note> <p>Multi-node parallel jobs aren\'t supported on Spot Instances.</p> </note> <p>In an unmanaged compute environment, you can manage your own EC2 compute resources and have a lot of flexibility with how you configure your compute resources. For example, you can use custom AMIs. However, you must verify that each of your AMIs meet the Amazon ECS container instance AMI specification. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container_instance_AMIs.html">container instance AMIs</a> in the <i>Amazon Elastic Container Service Developer Guide</i>. After you created your unmanaged compute environment, you can use the <a>DescribeComputeEnvironments</a> operation to find the Amazon ECS cluster that\'s associated with it. Then, launch your container instances into that Amazon ECS cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_container_instance.html">Launching an Amazon ECS container instance</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> <note> <p>Batch doesn\'t automatically upgrade the AMIs in a compute environment after it\'s created. For example, it also doesn\'t update the AMIs in your compute environment when a newer version of the Amazon ECS optimized AMI is available. You\'re responsible for the management of the guest operating system. This includes any updates and security patches. You\'re also responsible for any additional application software or utilities that you install on the compute resources. There are two ways to use a new AMI for your Batch jobs. The original method is to complete these steps:</p> <ol> <li> <p>Create a new compute environment with the new AMI.</p> </li> <li> <p>Add the compute environment to an existing job queue.</p> </li> <li> <p>Remove the earlier compute environment from your job queue.</p> </li> <li> <p>Delete the earlier compute environment.</p> </li> </ol> <p>In April 2022, Batch added enhanced support for updating compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a>. To use the enhanced updating of compute environments to update AMIs, follow these rules:</p> <ul> <li> <p>Either do not set the service role (<code>serviceRole</code>) parameter or set it to the <b>AWSBatchServiceRole</b> service-linked role.</p> </li> <li> <p>Set the allocation strategy (<code>allocationStrategy</code>) parameter to <code>BEST_FIT_PROGRESSIVE</code> or <code>SPOT_CAPACITY_OPTIMIZED</code>.</p> </li> <li> <p>Set the update to latest image version (<code>updateToLatestImageVersion</code>) parameter to <code>true</code>.</p> </li> <li> <p>Do not specify an AMI ID in <code>imageId</code>, <code>imageIdOverride</code> (in <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_Ec2Configuration.html"> <code>ec2Configuration</code> </a>), or in the launch template (<code>launchTemplate</code>). In that case Batch will select the latest Amazon ECS optimized AMI supported by Batch at the time the infrastructure update is initiated. Alternatively you can specify the AMI ID in the <code>imageId</code> or <code>imageIdOverride</code> parameters, or the launch template identified by the <code>LaunchTemplate</code> properties. Changing any of these properties will trigger an infrastructure update. If the AMI ID is specified in the launch template, it can not be replaced by specifying an AMI ID in either the <code>imageId</code> or <code>imageIdOverride</code> parameters. It can only be replaced by specifying a different launch template, or if the launch template version is set to <code>$Default</code> or <code>$Latest</code>, by setting either a new default version for the launch template (if <code>$Default</code>)or by adding a new version to the launch template (if <code>$Latest</code>).</p> </li> </ul> <p>If these rules are followed, any update that triggers an infrastructure update will cause the AMI ID to be re-selected. If the <code>version</code> setting in the launch template (<code>launchTemplate</code>) is set to <code>$Latest</code> or <code>$Default</code>, the latest or default version of the launch template will be evaluated up at the time of the infrastructure update, even if the <code>launchTemplate</code> was not updated.</p> </note>', 'CreateJobQueue' => '<p>Creates an Batch job queue. When you create a job queue, you associate one or more compute environments to the queue and assign an order of preference for the compute environments.</p> <p>You also set a priority to the job queue that determines the order that the Batch scheduler places jobs onto its associated compute environments. For example, if a compute environment is associated with more than one job queue, the job queue with a higher priority is given preference for scheduling jobs to that compute environment.</p>', 'CreateSchedulingPolicy' => '<p>Creates an Batch scheduling policy.</p>', 'DeleteComputeEnvironment' => '<p>Deletes an Batch compute environment.</p> <p>Before you can delete a compute environment, you must set its state to <code>DISABLED</code> with the <a>UpdateComputeEnvironment</a> API operation and disassociate it from any job queues with the <a>UpdateJobQueue</a> API operation. Compute environments that use Fargate resources must terminate all active jobs on that compute environment before deleting the compute environment. If this isn\'t done, the compute environment enters an invalid state.</p>', 'DeleteJobQueue' => '<p>Deletes the specified job queue. You must first disable submissions for a queue with the <a>UpdateJobQueue</a> operation. All jobs in the queue are eventually terminated when you delete a job queue. The jobs are terminated at a rate of about 16 jobs each second.</p> <p>It\'s not necessary to disassociate compute environments from a queue before submitting a <code>DeleteJobQueue</code> request.</p>', 'DeleteSchedulingPolicy' => '<p>Deletes the specified scheduling policy.</p> <p>You can\'t delete a scheduling policy that\'s used in any job queues.</p>', 'DeregisterJobDefinition' => '<p>Deregisters an Batch job definition. Job definitions are permanently deleted after 180 days.</p>', 'DescribeComputeEnvironments' => '<p>Describes one or more of your compute environments.</p> <p>If you\'re using an unmanaged compute environment, you can use the <code>DescribeComputeEnvironment</code> operation to determine the <code>ecsClusterArn</code> that you launch your Amazon ECS container instances into.</p>', 'DescribeJobDefinitions' => '<p>Describes a list of job definitions. You can specify a <code>status</code> (such as <code>ACTIVE</code>) to only return job definitions that match that status.</p>', 'DescribeJobQueues' => '<p>Describes one or more of your job queues.</p>', 'DescribeJobs' => '<p>Describes a list of Batch jobs.</p>', 'DescribeSchedulingPolicies' => '<p>Describes one or more of your scheduling policies.</p>', 'ListJobs' => '<p>Returns a list of Batch jobs.</p> <p>You must specify only one of the following items:</p> <ul> <li> <p>A job queue ID to return a list of jobs in that job queue</p> </li> <li> <p>A multi-node parallel job ID to return a list of nodes for that job</p> </li> <li> <p>An array job ID to return a list of the children for that job</p> </li> </ul> <p>You can filter the results by job status with the <code>jobStatus</code> parameter. If you don\'t specify a status, only <code>RUNNING</code> jobs are returned.</p>', 'ListSchedulingPolicies' => '<p>Returns a list of Batch scheduling policies.</p>', 'ListTagsForResource' => '<p>Lists the tags for an Batch resource. Batch resources that support tags are compute environments, jobs, job definitions, job queues, and scheduling policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs are not supported.</p>', 'RegisterJobDefinition' => '<p>Registers an Batch job definition.</p>', 'SubmitJob' => '<p>Submits an Batch job from a job definition. Parameters that are specified during <a>SubmitJob</a> override parameters defined in the job definition. vCPU and memory requirements that are specified in the <code>resourceRequirements</code> objects in the job definition are the exception. They can\'t be overridden this way using the <code>memory</code> and <code>vcpus</code> parameters. Rather, you must specify updates to job definition parameters in a <code>resourceRequirements</code> object that\'s included in the <code>containerOverrides</code> parameter.</p> <note> <p>Job queues with a scheduling policy are limited to 500 active fair share identifiers at a time. </p> </note> <important> <p>Jobs that run on Fargate resources can\'t be guaranteed to run for more than 14 days. This is because, after 14 days, Fargate resources might become unavailable and job might be terminated.</p> </important>', 'TagResource' => '<p>Associates the specified tags to a resource with the specified <code>resourceArn</code>. If existing tags on a resource aren\'t specified in the request parameters, they aren\'t changed. When a resource is deleted, the tags that are associated with that resource are deleted as well. Batch resources that support tags are compute environments, jobs, job definitions, job queues, and scheduling policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs are not supported.</p>', 'TerminateJob' => '<p>Terminates a job in a job queue. Jobs that are in the <code>STARTING</code> or <code>RUNNING</code> state are terminated, which causes them to transition to <code>FAILED</code>. Jobs that have not progressed to the <code>STARTING</code> state are cancelled.</p>', 'UntagResource' => '<p>Deletes specified tags from an Batch resource.</p>', 'UpdateComputeEnvironment' => '<p>Updates an Batch compute environment.</p>', 'UpdateJobQueue' => '<p>Updates a job queue.</p>', 'UpdateSchedulingPolicy' => '<p>Updates a scheduling policy.</p>', ], 'shapes' => [ 'ArrayJobDependency' => [ 'base' => NULL, 'refs' => [ 'JobDependency$type' => '<p>The type of the job dependency.</p>', ], ], 'ArrayJobStatusSummary' => [ 'base' => NULL, 'refs' => [ 'ArrayPropertiesDetail$statusSummary' => '<p>A summary of the number of array job children in each available job status. This parameter is returned for parent array jobs.</p>', ], ], 'ArrayProperties' => [ 'base' => '<p>An object representing an Batch array job.</p>', 'refs' => [ 'SubmitJobRequest$arrayProperties' => '<p>The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/array_jobs.html">Array Jobs</a> in the <i>Batch User Guide</i>.</p>', ], ], 'ArrayPropertiesDetail' => [ 'base' => '<p>An object representing the array properties of a job.</p>', 'refs' => [ 'JobDetail$arrayProperties' => '<p>The array properties of the job, if it is an array job.</p>', ], ], 'ArrayPropertiesSummary' => [ 'base' => '<p>An object representing the array properties of a job.</p>', 'refs' => [ 'JobSummary$arrayProperties' => '<p>The array properties of the job, if it is an array job.</p>', ], ], 'AssignPublicIp' => [ 'base' => NULL, 'refs' => [ 'NetworkConfiguration$assignPublicIp' => '<p>Indicates whether the job should have a public IP address. For a job that is running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS task networking</a>. The default value is "DISABLED".</p>', ], ], 'AttemptContainerDetail' => [ 'base' => '<p>An object representing the details of a container that\'s part of a job attempt.</p>', 'refs' => [ 'AttemptDetail$container' => '<p>Details about the container in this job attempt.</p>', ], ], 'AttemptDetail' => [ 'base' => '<p>An object representing a job attempt.</p>', 'refs' => [ 'AttemptDetails$member' => NULL, ], ], 'AttemptDetails' => [ 'base' => NULL, 'refs' => [ 'JobDetail$attempts' => '<p>A list of job attempts associated with this job.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ComputeResourceUpdate$updateToLatestImageVersion' => '<p>Specifies whether the AMI ID is updated to the latest one that\'s supported by Batch when the compute environment has an infrastructure update. The default value is <code>false</code>.</p> <note> <p>If an AMI ID is specified in the <code>imageId</code> or <code>imageIdOverride</code> parameters or by the launch template specified in the <code>launchTemplate</code> parameter, this parameter is ignored. For more information on updating AMI IDs during an infrastructure update, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html#updating-compute-environments-ami">Updating the AMI ID</a> in the <i>Batch User Guide</i>.</p> </note> <p>When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p>', 'ContainerDetail$readonlyRootFilesystem' => '<p>When this parameter is true, the container is given read-only access to its root file system. This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to <a href="https://docs.docker.com/engine/reference/commandline/run/"> <code>docker run</code> </a>.</p>', 'ContainerDetail$privileged' => '<p>When this parameter is true, the container is given elevated permissions on the host container instance (similar to the <code>root</code> user). The default value is false.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided, or specified as false.</p> </note>', 'ContainerProperties$readonlyRootFilesystem' => '<p>When this parameter is true, the container is given read-only access to its root file system. This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to <code>docker run</code>.</p>', 'ContainerProperties$privileged' => '<p>When this parameter is true, the container is given elevated permissions on the host container instance (similar to the <code>root</code> user). This parameter maps to <code>Privileged</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. The default value is false.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided, or specified as false.</p> </note>', 'JobDefinition$propagateTags' => '<p>Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren\'t propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.</p>', 'JobDetail$propagateTags' => '<p>Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren\'t propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.</p>', 'LinuxParameters$initProcessEnabled' => '<p>If true, run an <code>init</code> process inside the container that forwards signals and reaps processes. This parameter maps to the <code>--init</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log into your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code> </p>', 'MountPoint$readOnly' => '<p>If this value is <code>true</code>, the container has read-only access to the volume. Otherwise, the container can write to the volume. The default value is <code>false</code>.</p>', 'NodeDetails$isMainNode' => '<p>Specifies whether the current node is the main node for a multi-node parallel job.</p>', 'NodePropertiesSummary$isMainNode' => '<p>Specifies whether the current node is the main node for a multi-node parallel job.</p>', 'RegisterJobDefinitionRequest$propagateTags' => '<p>Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags are not propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.</p>', 'SubmitJobRequest$propagateTags' => '<p>Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If no value is specified, the tags aren\'t propagated. Tags can only be propagated to the tasks during task creation. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state. When specified, this overrides the tag propagation setting in the job definition.</p>', 'UpdatePolicy$terminateJobsOnUpdate' => '<p>Specifies whether jobs are automatically terminated when the computer environment infrastructure is updated. The default value is <code>false</code>.</p>', ], ], 'CEState' => [ 'base' => NULL, 'refs' => [ 'ComputeEnvironmentDetail$state' => '<p>The state of the compute environment. The valid values are <code>ENABLED</code> or <code>DISABLED</code>.</p> <p>If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.</p> <p>If the state is <code>DISABLED</code>, then the Batch scheduler doesn\'t attempt to place jobs within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed compute environments in the <code>DISABLED</code> state don\'t scale out. However, they scale in to <code>minvCpus</code> value after instances become idle.</p>', 'CreateComputeEnvironmentRequest$state' => '<p>The state of the compute environment. If the state is <code>ENABLED</code>, then the compute environment accepts jobs from a queue and can scale out automatically based on queues.</p> <p>If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.</p> <p>If the state is <code>DISABLED</code>, then the Batch scheduler doesn\'t attempt to place jobs within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed compute environments in the <code>DISABLED</code> state don\'t scale out. However, they scale in to <code>minvCpus</code> value after instances become idle.</p>', 'UpdateComputeEnvironmentRequest$state' => '<p>The state of the compute environment. Compute environments in the <code>ENABLED</code> state can accept jobs from a queue and scale in or out automatically based on the workload demand of its associated queues.</p> <p>If the state is <code>ENABLED</code>, then the Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.</p> <p>If the state is <code>DISABLED</code>, then the Batch scheduler doesn\'t attempt to place jobs within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed compute environments in the <code>DISABLED</code> state don\'t scale out. However, they scale in to <code>minvCpus</code> value after instances become idle.</p>', ], ], 'CEStatus' => [ 'base' => NULL, 'refs' => [ 'ComputeEnvironmentDetail$status' => '<p>The current status of the compute environment (for example, <code>CREATING</code> or <code>VALID</code>).</p>', ], ], 'CEType' => [ 'base' => NULL, 'refs' => [ 'ComputeEnvironmentDetail$type' => '<p>The type of the compute environment: <code>MANAGED</code> or <code>UNMANAGED</code>. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a> in the <i>Batch User Guide</i>.</p>', 'CreateComputeEnvironmentRequest$type' => '<p>The type of the compute environment: <code>MANAGED</code> or <code>UNMANAGED</code>. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the <i>Batch User Guide</i>.</p>', ], ], 'CRAllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'ComputeResource$allocationStrategy' => '<p>The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service limits</a>. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation strategies</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note> <dl> <dt>BEST_FIT (default)</dt> <dd> <p>Batch selects an instance type that best fits the needs of the jobs with a preference for the lowest-cost instance type. If additional instances of the selected instance type aren\'t available, Batch waits for the additional instances to be available. If there aren\'t enough instances available, or if the user is reaching <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service limits</a> then additional jobs aren\'t run until the currently running jobs have completed. This allocation strategy keeps costs lower but can limit scaling. If you are using Spot Fleets with <code>BEST_FIT</code> then the Spot Fleet IAM Role must be specified. Compute resources that use a <code>BEST_FIT</code> allocation strategy don\'t support infrastructure updates and can\'t update some parameters. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> </dd> <dt>BEST_FIT_PROGRESSIVE</dt> <dd> <p>Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren\'t available, Batch will select new instance types.</p> </dd> <dt>SPOT_CAPACITY_OPTIMIZED</dt> <dd> <p>Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.</p> </dd> </dl> <p>With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> strategies, Batch might need to go above <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a single instance.</p>', ], ], 'CRType' => [ 'base' => NULL, 'refs' => [ 'ComputeResource$type' => '<p>The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or <code>FARGATE_SPOT</code>. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a> in the <i>Batch User Guide</i>.</p> <p> If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the <code>spotIamFleetRole</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet role</a> in the <i>Batch User Guide</i>.</p>', 'ComputeResourceUpdate$type' => '<p>The type of compute environment: <code>EC2</code>, <code>SPOT</code>, <code>FARGATE</code>, or <code>FARGATE_SPOT</code>. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a> in the <i>Batch User Guide</i>.</p> <p> If you choose <code>SPOT</code>, you must also specify an Amazon EC2 Spot Fleet role with the <code>spotIamFleetRole</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet role</a> in the <i>Batch User Guide</i>.</p> <p>When updating a compute environment, changing the type of a compute environment requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p>', ], ], 'CRUpdateAllocationStrategy' => [ 'base' => NULL, 'refs' => [ 'ComputeResourceUpdate$allocationStrategy' => '<p>The allocation strategy to use for the compute resource if not enough instances of the best fitting instance type can be allocated. This might be because of availability of the instance type in the Region or <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html">Amazon EC2 service limits</a>. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/allocation-strategies.html">Allocation strategies</a> in the <i>Batch User Guide</i>.</p> <p>When updating a compute environment, changing the allocation strategy requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>. <code>BEST_FIT</code> isn\'t supported when updating a compute environment.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note> <dl> <dt>BEST_FIT_PROGRESSIVE</dt> <dd> <p>Batch will select additional instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types with a lower cost per unit vCPU. If additional instances of the previously selected instance types aren\'t available, Batch will select new instance types.</p> </dd> <dt>SPOT_CAPACITY_OPTIMIZED</dt> <dd> <p>Batch will select one or more instance types that are large enough to meet the requirements of the jobs in the queue, with a preference for instance types that are less likely to be interrupted. This allocation strategy is only available for Spot Instance compute resources.</p> </dd> </dl> <p>With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> strategies, Batch might need to go above <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a single instance.</p>', ], ], 'CancelJobRequest' => [ 'base' => '<p>Contains the parameters for <code>CancelJob</code>.</p>', 'refs' => [], ], 'CancelJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientException' => [ 'base' => '<p>These errors are usually caused by a client action, such as using an action or resource on behalf of a user that doesn\'t have permissions to use the action or resource, or specifying an identifier that\'s not valid.</p>', 'refs' => [], ], 'ComputeEnvironmentDetail' => [ 'base' => '<p>An object representing an Batch compute environment.</p>', 'refs' => [ 'ComputeEnvironmentDetailList$member' => NULL, ], ], 'ComputeEnvironmentDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeComputeEnvironmentsResponse$computeEnvironments' => '<p>The list of compute environments.</p>', ], ], 'ComputeEnvironmentOrder' => [ 'base' => '<p>The order in which compute environments are tried for job placement within a queue. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower order integer value is tried for job placement first. Compute environments must be in the <code>VALID</code> state before you can associate them with a job queue. All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>); EC2 and Fargate compute environments can\'t be mixed.</p> <note> <p>All compute environments that are associated with a job queue must share the same architecture. Batch doesn\'t support mixing compute environment architecture types in a single job queue.</p> </note>', 'refs' => [ 'ComputeEnvironmentOrders$member' => NULL, ], ], 'ComputeEnvironmentOrders' => [ 'base' => NULL, 'refs' => [ 'CreateJobQueueRequest$computeEnvironmentOrder' => '<p>The set of compute environments mapped to a job queue and their order relative to each other. The job scheduler uses this parameter to determine which compute environment runs a specific job. Compute environments must be in the <code>VALID</code> state before you can associate them with a job queue. You can associate up to three compute environments with a job queue. All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>); EC2 and Fargate compute environments can\'t be mixed.</p> <note> <p>All compute environments that are associated with a job queue must share the same architecture. Batch doesn\'t support mixing compute environment architecture types in a single job queue.</p> </note>', 'JobQueueDetail$computeEnvironmentOrder' => '<p>The compute environments that are attached to the job queue and the order that job placement is preferred. Compute environments are selected for job placement in ascending order.</p>', 'UpdateJobQueueRequest$computeEnvironmentOrder' => '<p>Details the set of compute environments mapped to a job queue and their order relative to each other. This is one of the parameters used by the job scheduler to determine which compute environment runs a given job. Compute environments must be in the <code>VALID</code> state before you can associate them with a job queue. All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate compute environments can\'t be mixed.</p> <note> <p>All compute environments that are associated with a job queue must share the same architecture. Batch doesn\'t support mixing compute environment architecture types in a single job queue.</p> </note>', ], ], 'ComputeResource' => [ 'base' => '<p>An object representing an Batch compute resource. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a> in the <i>Batch User Guide</i>.</p>', 'refs' => [ 'ComputeEnvironmentDetail$computeResources' => '<p>The compute resources defined for the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute environments</a> in the <i>Batch User Guide</i>.</p>', 'CreateComputeEnvironmentRequest$computeResources' => '<p>Details about the compute resources managed by the compute environment. This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the <i>Batch User Guide</i>.</p>', ], ], 'ComputeResourceUpdate' => [ 'base' => '<p>An object representing the attributes of a compute environment that can be updated. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p>', 'refs' => [ 'UpdateComputeEnvironmentRequest$computeResources' => '<p>Details of the compute resources managed by the compute environment. Required for a managed compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the <i>Batch User Guide</i>.</p>', ], ], 'ContainerDetail' => [ 'base' => '<p>An object representing the details of a container that\'s part of a job.</p>', 'refs' => [ 'JobDetail$container' => '<p>An object representing the details of the container that\'s associated with the job.</p>', ], ], 'ContainerOverrides' => [ 'base' => '<p>The overrides that should be sent to a container.</p>', 'refs' => [ 'NodePropertyOverride$containerOverrides' => '<p>The overrides that should be sent to a node range.</p>', 'SubmitJobRequest$containerOverrides' => '<p>A list of container overrides in the JSON format that specify the name of a container in the specified job definition and the overrides it receives. You can override the default command for a container, which is specified in the job definition or the Docker image, with a <code>command</code> override. You can also override existing environment variables on a container or add new environment variables to it with an <code>environment</code> override.</p>', ], ], 'ContainerProperties' => [ 'base' => '<p>Container properties are used in job definitions to describe the container that\'s launched as part of a job.</p>', 'refs' => [ 'JobDefinition$containerProperties' => '<p>An object with various properties specific to container-based jobs.</p>', 'NodeRangeProperty$container' => '<p>The container details for the node range.</p>', 'RegisterJobDefinitionRequest$containerProperties' => '<p>An object with various properties specific to single-node container-based jobs. If the job definition\'s <code>type</code> parameter is <code>container</code>, then you must specify either <code>containerProperties</code> or <code>nodeProperties</code>.</p> <note> <p>If the job runs on Fargate resources, then you must not specify <code>nodeProperties</code>; use only <code>containerProperties</code>.</p> </note>', ], ], 'ContainerSummary' => [ 'base' => '<p>An object representing summary details of a container within a job.</p>', 'refs' => [ 'JobSummary$container' => '<p>An object representing the details of the container that\'s associated with the job.</p>', ], ], 'CreateComputeEnvironmentRequest' => [ 'base' => '<p>Contains the parameters for <code>CreateComputeEnvironment</code>.</p>', 'refs' => [], ], 'CreateComputeEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobQueueRequest' => [ 'base' => '<p>Contains the parameters for <code>CreateJobQueue</code>.</p>', 'refs' => [], ], 'CreateJobQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSchedulingPolicyRequest' => [ 'base' => '<p>Contains the parameters for <code>CreateSchedulingPolicy</code>.</p>', 'refs' => [], ], 'CreateSchedulingPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComputeEnvironmentRequest' => [ 'base' => '<p>Contains the parameters for <code>DeleteComputeEnvironment</code>.</p>', 'refs' => [], ], 'DeleteComputeEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobQueueRequest' => [ 'base' => '<p>Contains the parameters for <code>DeleteJobQueue</code>.</p>', 'refs' => [], ], 'DeleteJobQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSchedulingPolicyRequest' => [ 'base' => '<p>Contains the parameters for <code>DeleteSchedulingPolicy</code>.</p>', 'refs' => [], ], 'DeleteSchedulingPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterJobDefinitionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeregisterJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeComputeEnvironmentsRequest' => [ 'base' => '<p>Contains the parameters for <code>DescribeComputeEnvironments</code>.</p>', 'refs' => [], ], 'DescribeComputeEnvironmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobDefinitionsRequest' => [ 'base' => '<p>Contains the parameters for <code>DescribeJobDefinitions</code>.</p>', 'refs' => [], ], 'DescribeJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobQueuesRequest' => [ 'base' => '<p>Contains the parameters for <code>DescribeJobQueues</code>.</p>', 'refs' => [], ], 'DescribeJobQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobsRequest' => [ 'base' => '<p>Contains the parameters for <code>DescribeJobs</code>.</p>', 'refs' => [], ], 'DescribeJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSchedulingPoliciesRequest' => [ 'base' => '<p>Contains the parameters for <code>DescribeSchedulingPolicies</code>.</p>', 'refs' => [], ], 'DescribeSchedulingPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Device' => [ 'base' => '<p>An object representing a container instance host device.</p> <note> <p>This object isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided.</p> </note>', 'refs' => [ 'DevicesList$member' => NULL, ], ], 'DeviceCgroupPermission' => [ 'base' => NULL, 'refs' => [ 'DeviceCgroupPermissions$member' => NULL, ], ], 'DeviceCgroupPermissions' => [ 'base' => NULL, 'refs' => [ 'Device$permissions' => '<p>The explicit permissions to provide to the container for the device. By default, the container has permissions for <code>read</code>, <code>write</code>, and <code>mknod</code> for the device.</p>', ], ], 'DevicesList' => [ 'base' => NULL, 'refs' => [ 'LinuxParameters$devices' => '<p>Any host devices to expose to the container. This parameter maps to <code>Devices</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided.</p> </note>', ], ], 'EFSAuthorizationConfig' => [ 'base' => '<p>The authorization configuration details for the Amazon EFS file system.</p>', 'refs' => [ 'EFSVolumeConfiguration$authorizationConfig' => '<p>The authorization configuration details for the Amazon EFS file system.</p>', ], ], 'EFSAuthorizationConfigIAM' => [ 'base' => NULL, 'refs' => [ 'EFSAuthorizationConfig$iam' => '<p>Whether or not to use the Batch job IAM role defined in a job definition when mounting the Amazon EFS file system. If enabled, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code>. If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints">Using Amazon EFS access points</a> in the <i>Batch User Guide</i>. EFS IAM authorization requires that <code>TransitEncryption</code> be <code>ENABLED</code> and that a <code>JobRoleArn</code> is specified.</p>', ], ], 'EFSTransitEncryption' => [ 'base' => NULL, 'refs' => [ 'EFSVolumeConfiguration$transitEncryption' => '<p>Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">Encrypting data in transit</a> in the <i>Amazon Elastic File System User Guide</i>.</p>', ], ], 'EFSVolumeConfiguration' => [ 'base' => '<p>This is used when you\'re using an Amazon Elastic File System file system for job storage. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html">Amazon EFS Volumes</a> in the <i>Batch User Guide</i>.</p>', 'refs' => [ 'Volume$efsVolumeConfiguration' => '<p>This parameter is specified when you are using an Amazon Elastic File System file system for job storage. Jobs that are running on Fargate resources must specify a <code>platformVersion</code> of at least <code>1.4.0</code>.</p>', ], ], 'Ec2Configuration' => [ 'base' => '<p>Provides information used to select Amazon Machine Images (AMIs) for instances in the compute environment. If <code>Ec2Configuration</code> isn\'t specified, the default is <code>ECS_AL2</code> (<a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon Linux 2</a>).</p> <note> <p>This object isn\'t applicable to jobs that are running on Fargate resources.</p> </note>', 'refs' => [ 'Ec2ConfigurationList$member' => NULL, ], ], 'Ec2ConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ComputeResource$ec2Configuration' => '<p>Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If <code>Ec2Configuration</code> isn\'t specified, the default is <code>ECS_AL2</code>.</p> <p>One or two values can be provided.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResourceUpdate$ec2Configuration' => '<p>Provides information used to select Amazon Machine Images (AMIs) for EC2 instances in the compute environment. If <code>Ec2Configuration</code> isn\'t specified, the default is <code>ECS_AL2</code>.</p> <p>When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>. To remove the EC2 configuration and any custom AMI ID specified in <code>imageIdOverride</code>, set this value to an empty string.</p> <p>One or two values can be provided.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', ], ], 'EnvironmentVariables' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$environment' => '<p>The environment variables to pass to a container.</p> <note> <p>Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved for variables that are set by the Batch service.</p> </note>', 'ContainerOverrides$environment' => '<p>The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the job definition.</p> <note> <p>Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved for variables that are set by the Batch service.</p> </note>', 'ContainerProperties$environment' => '<p>The environment variables to pass to a container. This parameter maps to <code>Env</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <important> <p>We don\'t recommend using plaintext environment variables for sensitive information, such as credential data.</p> </important> <note> <p>Environment variables must not start with <code>AWS_BATCH</code>; this naming convention is reserved for variables that are set by the Batch service.</p> </note>', ], ], 'EvaluateOnExit' => [ 'base' => '<p>Specifies a set of conditions to be met, and an action to take (<code>RETRY</code> or <code>EXIT</code>) if all conditions are met.</p>', 'refs' => [ 'EvaluateOnExitList$member' => NULL, ], ], 'EvaluateOnExitList' => [ 'base' => NULL, 'refs' => [ 'RetryStrategy$evaluateOnExit' => '<p>Array of up to 5 objects that specify conditions under which the job should be retried or failed. If this parameter is specified, then the <code>attempts</code> parameter must also be specified.</p>', ], ], 'FairsharePolicy' => [ 'base' => '<p>The fair share policy for a scheduling policy.</p>', 'refs' => [ 'CreateSchedulingPolicyRequest$fairsharePolicy' => '<p>The fair share policy of the scheduling policy.</p>', 'SchedulingPolicyDetail$fairsharePolicy' => '<p>The fair share policy for the scheduling policy.</p>', 'UpdateSchedulingPolicyRequest$fairsharePolicy' => '<p>The fair share policy.</p>', ], ], 'FargatePlatformConfiguration' => [ 'base' => '<p>The platform configuration for jobs that are running on Fargate resources. Jobs that run on EC2 resources must not specify this parameter.</p>', 'refs' => [ 'ContainerDetail$fargatePlatformConfiguration' => '<p>The platform configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.</p>', 'ContainerProperties$fargatePlatformConfiguration' => '<p>The platform configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.</p>', ], ], 'Float' => [ 'base' => NULL, 'refs' => [ 'ShareAttributes$weightFactor' => '<p>The weight factor for the fair share identifier. The default value is 1.0. A lower value has a higher priority for compute resources. For example, jobs that use a share identifier with a weight factor of 0.125 (1/8) get 8 times the compute resources of jobs that use a share identifier with a weight factor of 1.</p> <p>The smallest supported value is 0.0001, and the largest supported value is 999.9999.</p>', ], ], 'Host' => [ 'base' => '<p>Determine whether your data volume persists on the host container instance and where it is stored. If this parameter is empty, then the Docker daemon assigns a host path for your data volume, but the data isn\'t guaranteed to persist after the containers associated with it stop running.</p>', 'refs' => [ 'Volume$host' => '<p>The contents of the <code>host</code> parameter determine whether your data volume persists on the host container instance and where it is stored. If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn\'t guaranteed to persist after the containers associated with it stop running.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided.</p> </note>', ], ], 'ImageIdOverride' => [ 'base' => NULL, 'refs' => [ 'Ec2Configuration$imageIdOverride' => '<p>The AMI ID used for instances launched in the compute environment that match the image type. This setting overrides the <code>imageId</code> set in the <code>computeResource</code> object.</p> <note> <p>The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html">Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> </note>', ], ], 'ImageType' => [ 'base' => NULL, 'refs' => [ 'Ec2Configuration$imageType' => '<p>The image type to match with the instance type to select an AMI. If the <code>imageIdOverride</code> parameter isn\'t specified, then a recent <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon ECS-optimized Amazon Linux 2 AMI</a> (<code>ECS_AL2</code>) is used. If a new image type is specified in an update, but neither an <code>imageId</code> nor a <code>imageIdOverride</code> parameter is specified, then the latest Amazon ECS optimized AMI for that image type that\'s supported by Batch is used.</p> <dl> <dt>ECS_AL2</dt> <dd> <p> <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami">Amazon Linux 2</a>− Default for all non-GPU instance families.</p> </dd> <dt>ECS_AL2_NVIDIA</dt> <dd> <p> <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami">Amazon Linux 2 (GPU)</a>−Default for all GPU instance families (for example <code>P4</code> and <code>G4</code>) and can be used for all non Amazon Web Services Graviton-based instance types.</p> </dd> <dt>ECS_AL1</dt> <dd> <p> <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami">Amazon Linux</a>. Amazon Linux is reaching the end-of-life of standard support. For more information, see <a href="http://aws.amazon.com/amazon-linux-ami/">Amazon Linux AMI</a>.</p> </dd> </dl>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ArrayJobStatusSummary$value' => NULL, 'ArrayProperties$size' => '<p>The size of the array job.</p>', 'ArrayPropertiesDetail$size' => '<p>The size of the array job. This parameter is returned for parent array jobs.</p>', 'ArrayPropertiesDetail$index' => '<p>The job index within the array that\'s associated with this job. This parameter is returned for array job children.</p>', 'ArrayPropertiesSummary$size' => '<p>The size of the array job. This parameter is returned for parent array jobs.</p>', 'ArrayPropertiesSummary$index' => '<p>The job index within the array that\'s associated with this job. This parameter is returned for children of array jobs.</p>', 'AttemptContainerDetail$exitCode' => '<p>The exit code for the job attempt. A non-zero exit code is considered a failure.</p>', 'ComputeEnvironmentDetail$unmanagedvCpus' => '<p>The maximum number of VCPUs expected to be used for an unmanaged compute environment.</p>', 'ComputeEnvironmentOrder$order' => '<p>The order of the compute environment. Compute environments are tried in ascending order. For example, if two compute environments are associated with a job queue, the compute environment with a lower <code>order</code> integer value is tried for job placement first.</p>', 'ComputeResource$minvCpus' => '<p>The minimum number of Amazon EC2 vCPUs that an environment should maintain (even if the compute environment is <code>DISABLED</code>).</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResource$maxvCpus' => '<p>The maximum number of Amazon EC2 vCPUs that a compute environment can reach.</p> <note> <p>With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> allocation strategies, Batch might need to exceed <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a single instance. For example, no more than a single instance from among those specified in your compute environment is allocated.</p> </note>', 'ComputeResource$desiredvCpus' => '<p>The desired number of Amazon EC2 vCPUS in the compute environment. Batch modifies this value between the minimum and maximum values, based on job queue demand.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResource$bidPercentage' => '<p>The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, then the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage. If you leave this field empty, the default value is 100% of the On-Demand price.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResourceUpdate$minvCpus' => '<p>The minimum number of Amazon EC2 vCPUs that an environment should maintain (even if the compute environment is <code>DISABLED</code>).</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResourceUpdate$maxvCpus' => '<p>The maximum number of Amazon EC2 vCPUs that an environment can reach.</p> <note> <p>With both <code>BEST_FIT_PROGRESSIVE</code> and <code>SPOT_CAPACITY_OPTIMIZED</code> allocation strategies, Batch might need to exceed <code>maxvCpus</code> to meet your capacity requirements. In this event, Batch never exceeds <code>maxvCpus</code> by more than a single instance. That is, no more than a single instance from among those specified in your compute environment.</p> </note>', 'ComputeResourceUpdate$desiredvCpus' => '<p>The desired number of Amazon EC2 vCPUS in the compute environment. Batch modifies this value between the minimum and maximum values based on job queue demand.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResourceUpdate$bidPercentage' => '<p>The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched. For example, if your maximum percentage is 20%, then the Spot price must be less than 20% of the current On-Demand price for that Amazon EC2 instance. You always pay the lowest (market) price and never more than your maximum percentage.</p> <p>When updating a compute environment, changing the bid percentage requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ContainerDetail$vcpus' => '<p>The number of vCPUs reserved for the container. For jobs that run on EC2 resources, you can specify the vCPU requirement for the job using <code>resourceRequirements</code>, but you can\'t specify the vCPU requirements in both the <code>vcpus</code> and <code>resourceRequirements</code> object. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Each vCPU is equivalent to 1,024 CPU shares. You must specify at least one vCPU. This is required but can be specified in several places. It must be specified for each node at least once.</p> <note> <p>This parameter isn\'t applicable to jobs that run on Fargate resources. For jobs that run on Fargate resources, you must specify the vCPU requirement for the job using <code>resourceRequirements</code>.</p> </note>', 'ContainerDetail$memory' => '<p>For jobs running on EC2 resources that didn\'t specify memory requirements using <code>resourceRequirements</code>, the number of MiB of memory reserved for the job. For other jobs, including all run on Fargate resources, see <code>resourceRequirements</code>.</p>', 'ContainerDetail$exitCode' => '<p>The exit code to return upon completion.</p>', 'ContainerOverrides$vcpus' => '<p>This parameter is deprecated, use <code>resourceRequirements</code> to override the <code>vcpus</code> parameter that\'s set in the job definition. It\'s not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it overrides the <code>vcpus</code> parameter set in the job definition, but doesn\'t override any vCPU requirement specified in the <code>resourceRequirements</code> structure in the job definition. To override vCPU requirements that are specified in the <code>resourceRequirements</code> structure in the job definition, <code>resourceRequirements</code> must be specified in the <code>SubmitJob</code> request, with <code>type</code> set to <code>VCPU</code> and <code>value</code> set to the new value. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements">Can\'t override job definition resource requirements</a> in the <i>Batch User Guide</i>.</p>', 'ContainerOverrides$memory' => '<p>This parameter is deprecated, use <code>resourceRequirements</code> to override the memory requirements specified in the job definition. It\'s not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it overrides the <code>memory</code> parameter set in the job definition, but doesn\'t override any memory requirement specified in the <code>resourceRequirements</code> structure in the job definition. To override memory requirements that are specified in the <code>resourceRequirements</code> structure in the job definition, <code>resourceRequirements</code> must be specified in the <code>SubmitJob</code> request, with <code>type</code> set to <code>MEMORY</code> and <code>value</code> set to the new value. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#override-resource-requirements">Can\'t override job definition resource requirements</a> in the <i>Batch User Guide</i>.</p>', 'ContainerProperties$vcpus' => '<p>This parameter is deprecated, use <code>resourceRequirements</code> to specify the vCPU requirements for the job definition. It\'s not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it specifies the number of vCPUs reserved for the job.</p> <p>Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.</p>', 'ContainerProperties$memory' => '<p>This parameter is deprecated, use <code>resourceRequirements</code> to specify the memory requirements for the job definition. It\'s not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it\'s terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.</p>', 'ContainerSummary$exitCode' => '<p>The exit code to return upon completion.</p>', 'CreateComputeEnvironmentRequest$unmanagedvCpus' => '<p>The maximum number of vCPUs for an unmanaged compute environment. This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn\'t provided for a fair share job queue, no vCPU capacity is reserved.</p> <note> <p>This parameter is only supported when the <code>type</code> parameter is set to <code>UNMANAGED</code>.</p> </note>', 'CreateJobQueueRequest$priority' => '<p>The priority of the job queue. Job queues with a higher priority (or a higher integer value for the <code>priority</code> parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of <code>10</code> is given scheduling preference over a job queue with a priority value of <code>1</code>. All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>); EC2 and Fargate compute environments can\'t be mixed.</p>', 'DescribeComputeEnvironmentsRequest$maxResults' => '<p>The maximum number of cluster results returned by <code>DescribeComputeEnvironments</code> in paginated output. When this parameter is used, <code>DescribeComputeEnvironments</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeComputeEnvironments</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn\'t used, then <code>DescribeComputeEnvironments</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'DescribeJobDefinitionsRequest$maxResults' => '<p>The maximum number of results returned by <code>DescribeJobDefinitions</code> in paginated output. When this parameter is used, <code>DescribeJobDefinitions</code> only returns <code>maxResults</code> results in a single page and a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeJobDefinitions</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn\'t used, then <code>DescribeJobDefinitions</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'DescribeJobQueuesRequest$maxResults' => '<p>The maximum number of results returned by <code>DescribeJobQueues</code> in paginated output. When this parameter is used, <code>DescribeJobQueues</code> only returns <code>maxResults</code> results in a single page and a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>DescribeJobQueues</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn\'t used, then <code>DescribeJobQueues</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'EFSVolumeConfiguration$transitEncryptionPort' => '<p>The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you don\'t specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">EFS mount helper</a> in the <i>Amazon Elastic File System User Guide</i>.</p>', 'FairsharePolicy$shareDecaySeconds' => '<p>The time period to use to calculate a fair share percentage for each fair share identifier in use, in seconds. A value of zero (0) indicates that only current usage should be measured. The decay allows for more recently run jobs to have more weight than jobs that ran earlier. The maximum supported value is 604800 (1 week).</p>', 'FairsharePolicy$computeReservation' => '<p>A value used to reserve some of the available maximum vCPU for fair share identifiers that have not yet been used.</p> <p>The reserved ratio is <code>(<i>computeReservation</i>/100)^<i>ActiveFairShares</i> </code> where <code> <i>ActiveFairShares</i> </code> is the number of active fair share identifiers.</p> <p>For example, a <code>computeReservation</code> value of 50 indicates that Batch should reserve 50% of the maximum available vCPU if there is only one fair share identifier, 25% if there are two fair share identifiers, and 12.5% if there are three fair share identifiers. A <code>computeReservation</code> value of 25 indicates that Batch should reserve 25% of the maximum available vCPU if there is only one fair share identifier, 6.25% if there are two fair share identifiers, and 1.56% if there are three fair share identifiers.</p> <p>The minimum value is 0 and the maximum value is 99.</p>', 'JobDefinition$revision' => '<p>The revision of the job definition.</p>', 'JobDefinition$schedulingPriority' => '<p>The scheduling priority of the job definition. This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.</p>', 'JobDetail$schedulingPriority' => '<p>The scheduling policy of the job definition. This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.</p>', 'JobQueueDetail$priority' => '<p>The priority of the job queue. Job queues with a higher priority (or a higher integer value for the <code>priority</code> parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order, for example, a job queue with a priority value of <code>10</code> is given scheduling preference over a job queue with a priority value of <code>1</code>. All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>); EC2 and Fargate compute environments can\'t be mixed.</p>', 'JobTimeout$attemptDurationSeconds' => '<p>The time duration in seconds (measured from the job attempt\'s <code>startedAt</code> timestamp) after which Batch terminates your jobs if they have not finished. The minimum value for the timeout is 60 seconds.</p>', 'LinuxParameters$sharedMemorySize' => '<p>The value for the size (in MiB) of the <code>/dev/shm</code> volume. This parameter maps to the <code>--shm-size</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided.</p> </note>', 'LinuxParameters$maxSwap' => '<p>The total amount of swap memory (in MiB) a container can use. This parameter is translated to the <code>--memory-swap</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a> where the value is the sum of the container memory plus the <code>maxSwap</code> value. For more information, see <a href="https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details"> <code>--memory-swap</code> details</a> in the Docker documentation.</p> <p>If a <code>maxSwap</code> value of <code>0</code> is specified, the container doesn\'t use swap. Accepted values are <code>0</code> or any positive integer. If the <code>maxSwap</code> parameter is omitted, the container doesn\'t use the swap configuration for the container instance it is running on. A <code>maxSwap</code> value must be set for the <code>swappiness</code> parameter to be used.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided.</p> </note>', 'LinuxParameters$swappiness' => '<p>This allows you to tune a container\'s memory swappiness behavior. A <code>swappiness</code> value of <code>0</code> causes swapping not to happen unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> causes pages to be swapped very aggressively. Accepted values are whole numbers between <code>0</code> and <code>100</code>. If the <code>swappiness</code> parameter isn\'t specified, a default value of <code>60</code> is used. If a value isn\'t specified for <code>maxSwap</code>, then this parameter is ignored. If <code>maxSwap</code> is set to 0, the container doesn\'t use swap. This parameter maps to the <code>--memory-swappiness</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <p>Consider the following when you use a per-container swap configuration.</p> <ul> <li> <p>Swap space must be enabled and allocated on the container instance for the containers to use.</p> <note> <p>The Amazon ECS optimized AMIs don\'t have swap enabled by default. You must enable swap on the instance to use this feature. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html">Instance store swap volumes</a> in the <i>Amazon EC2 User Guide for Linux Instances</i> or <a href="http://aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/">How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?</a> </p> </note> </li> <li> <p>The swap space parameters are only supported for job definitions using EC2 resources.</p> </li> <li> <p>If the <code>maxSwap</code> and <code>swappiness</code> parameters are omitted from a job definition, each container will have a default <code>swappiness</code> value of 60, and the total swap usage will be limited to two times the memory reservation of the container.</p> </li> </ul> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided.</p> </note>', 'ListJobsRequest$maxResults' => '<p>The maximum number of results returned by <code>ListJobs</code> in paginated output. When this parameter is used, <code>ListJobs</code> only returns <code>maxResults</code> results in a single page and a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListJobs</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn\'t used, then <code>ListJobs</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'ListSchedulingPoliciesRequest$maxResults' => '<p>The maximum number of results that\'s returned by <code>ListSchedulingPolicies</code> in paginated output. When this parameter is used, <code>ListSchedulingPolicies</code> only returns <code>maxResults</code> results in a single page and a <code>nextToken</code> response element. You can see the remaining results of the initial request by sending another <code>ListSchedulingPolicies</code> request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If this parameter isn\'t used, <code>ListSchedulingPolicies</code> returns up to 100 results and a <code>nextToken</code> value if applicable.</p>', 'NodeDetails$nodeIndex' => '<p>The node index for the node. Node index numbering begins at zero. This index is also available on the node with the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.</p>', 'NodeOverrides$numNodes' => '<p>The number of nodes to use with a multi-node parallel job. This value overrides the number of nodes that are specified in the job definition. To use this override:</p> <ul> <li> <p>There must be at least one node range in your job definition that has an open upper boundary (such as <code>:</code> or <code>n:</code>).</p> </li> <li> <p>The lower boundary of the node range specified in the job definition must be fewer than the number of nodes specified in the override.</p> </li> <li> <p>The main node index specified in the job definition must be fewer than the number of nodes specified in the override.</p> </li> </ul>', 'NodeProperties$numNodes' => '<p>The number of nodes associated with a multi-node parallel job.</p>', 'NodeProperties$mainNode' => '<p>Specifies the node index for the main node of a multi-node parallel job. This node index value must be fewer than the number of nodes.</p>', 'NodePropertiesSummary$numNodes' => '<p>The number of nodes associated with a multi-node parallel job.</p>', 'NodePropertiesSummary$nodeIndex' => '<p>The node index for the node. Node index numbering begins at zero. This index is also available on the node with the <code>AWS_BATCH_JOB_NODE_INDEX</code> environment variable.</p>', 'RegisterJobDefinitionRequest$schedulingPriority' => '<p>The scheduling priority for jobs that are submitted with this job definition. This will only affect jobs in job queues with a fair share policy. Jobs with a higher scheduling priority will be scheduled before jobs with a lower scheduling priority.</p> <p>The minimum supported value is 0 and the maximum supported value is 9999.</p>', 'RegisterJobDefinitionResponse$revision' => '<p>The revision of the job definition.</p>', 'RetryStrategy$attempts' => '<p>The number of times to move a job to the <code>RUNNABLE</code> status. You can specify between 1 and 10 attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of attempts as the value.</p>', 'SubmitJobRequest$schedulingPriorityOverride' => '<p>The scheduling priority for the job. This will only affect jobs in job queues with a fair share policy. Jobs with a higher scheduling priority will be scheduled before jobs with a lower scheduling priority. This will override any scheduling priority in the job definition.</p> <p>The minimum supported value is 0 and the maximum supported value is 9999.</p>', 'Tmpfs$size' => '<p>The size (in MiB) of the tmpfs volume.</p>', 'Ulimit$hardLimit' => '<p>The hard limit for the <code>ulimit</code> type.</p>', 'Ulimit$softLimit' => '<p>The soft limit for the <code>ulimit</code> type.</p>', 'UpdateComputeEnvironmentRequest$unmanagedvCpus' => '<p>The maximum number of vCPUs expected to be used for an unmanaged compute environment. Do not specify this parameter for a managed compute environment. This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter is not provided for a fair share job queue, no vCPU capacity will be reserved.</p>', 'UpdateJobQueueRequest$priority' => '<p>The priority of the job queue. Job queues with a higher priority (or a higher integer value for the <code>priority</code> parameter) are evaluated first when associated with the same compute environment. Priority is determined in descending order. For example, a job queue with a priority value of <code>10</code> is given scheduling preference over a job queue with a priority value of <code>1</code>. All of the compute environments must be either EC2 (<code>EC2</code> or <code>SPOT</code>) or Fargate (<code>FARGATE</code> or <code>FARGATE_SPOT</code>). EC2 and Fargate compute environments can\'t be mixed.</p>', ], ], 'JQState' => [ 'base' => NULL, 'refs' => [ 'CreateJobQueueRequest$state' => '<p>The state of the job queue. If the job queue state is <code>ENABLED</code>, it is able to accept jobs. If the job queue state is <code>DISABLED</code>, new jobs can\'t be added to the queue, but jobs already in the queue can finish.</p>', 'JobQueueDetail$state' => '<p>Describes the ability of the queue to accept new jobs. If the job queue state is <code>ENABLED</code>, it\'s able to accept jobs. If the job queue state is <code>DISABLED</code>, new jobs can\'t be added to the queue, but jobs already in the queue can finish.</p>', 'UpdateJobQueueRequest$state' => '<p>Describes the queue\'s ability to accept new jobs. If the job queue state is <code>ENABLED</code>, it can accept jobs. If the job queue state is <code>DISABLED</code>, new jobs can\'t be added to the queue, but jobs already in the queue can finish.</p>', ], ], 'JQStatus' => [ 'base' => NULL, 'refs' => [ 'JobQueueDetail$status' => '<p>The status of the job queue (for example, <code>CREATING</code> or <code>VALID</code>).</p>', ], ], 'JobDefinition' => [ 'base' => '<p>An object representing an Batch job definition.</p>', 'refs' => [ 'JobDefinitionList$member' => NULL, ], ], 'JobDefinitionList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobDefinitionsResponse$jobDefinitions' => '<p>The list of job definitions.</p>', ], ], 'JobDefinitionType' => [ 'base' => NULL, 'refs' => [ 'RegisterJobDefinitionRequest$type' => '<p>The type of job definition. For more information about multi-node parallel jobs, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html">Creating a multi-node parallel job definition</a> in the <i>Batch User Guide</i>.</p> <note> <p>If the job is run on Fargate resources, then <code>multinode</code> isn\'t supported.</p> </note>', ], ], 'JobDependency' => [ 'base' => '<p>An object representing an Batch job dependency.</p>', 'refs' => [ 'JobDependencyList$member' => NULL, ], ], 'JobDependencyList' => [ 'base' => NULL, 'refs' => [ 'JobDetail$dependsOn' => '<p>A list of job IDs that this job depends on.</p>', 'SubmitJobRequest$dependsOn' => '<p>A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin.</p>', ], ], 'JobDetail' => [ 'base' => '<p>An object representing an Batch job.</p>', 'refs' => [ 'JobDetailList$member' => NULL, ], ], 'JobDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobsResponse$jobs' => '<p>The list of jobs.</p>', ], ], 'JobExecutionTimeoutMinutes' => [ 'base' => NULL, 'refs' => [ 'UpdatePolicy$jobExecutionTimeoutMinutes' => '<p>Specifies the job timeout, in minutes, when the compute environment infrastructure is updated. The default value is 30.</p>', ], ], 'JobQueueDetail' => [ 'base' => '<p>An object representing the details of an Batch job queue.</p>', 'refs' => [ 'JobQueueDetailList$member' => NULL, ], ], 'JobQueueDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeJobQueuesResponse$jobQueues' => '<p>The list of job queues.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'JobDetail$status' => '<p>The current status for the job.</p> <note> <p>If your jobs don\'t progress to <code>STARTING</code>, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs stuck in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.</p> </note>', 'JobSummary$status' => '<p>The current status for the job.</p>', 'ListJobsRequest$jobStatus' => '<p>The job status used to filter jobs in the specified queue. If the <code>filters</code> parameter is specified, the <code>jobStatus</code> parameter is ignored and jobs with any status are returned. If you don\'t specify a status, only <code>RUNNING</code> jobs are returned.</p>', ], ], 'JobSummary' => [ 'base' => '<p>An object representing summary details of a job.</p>', 'refs' => [ 'JobSummaryList$member' => NULL, ], ], 'JobSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListJobsResponse$jobSummaryList' => '<p>A list of job summaries that match the request.</p>', ], ], 'JobTimeout' => [ 'base' => '<p>An object representing a job timeout configuration.</p>', 'refs' => [ 'JobDefinition$timeout' => '<p>The timeout configuration for jobs that are submitted with this job definition. You can specify a timeout duration after which Batch terminates your jobs if they haven\'t finished.</p>', 'JobDetail$timeout' => '<p>The timeout configuration for the job.</p>', 'RegisterJobDefinitionRequest$timeout' => '<p>The timeout configuration for jobs that are submitted with this job definition, after which Batch terminates your jobs if they have not finished. If a job is terminated due to a timeout, it isn\'t retried. The minimum value for the timeout is 60 seconds. Any timeout configuration that\'s specified during a <a>SubmitJob</a> operation overrides the timeout configuration defined here. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_timeouts.html">Job Timeouts</a> in the <i>Batch User Guide</i>.</p>', 'SubmitJobRequest$timeout' => '<p>The timeout configuration for this <a>SubmitJob</a> operation. You can specify a timeout duration after which Batch terminates your jobs if they haven\'t finished. If a job is terminated due to a timeout, it isn\'t retried. The minimum value for the timeout is 60 seconds. This configuration overrides any timeout configuration specified in the job definition. For array jobs, child jobs have the same timeout configuration as the parent job. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/job_timeouts.html">Job Timeouts</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', ], ], 'KeyValuePair' => [ 'base' => '<p>A key-value pair object.</p>', 'refs' => [ 'EnvironmentVariables$member' => NULL, ], ], 'KeyValuesPair' => [ 'base' => '<p>A filter name and value pair that\'s used to return a more specific list of results from a <code>ListJobs</code> API operation.</p>', 'refs' => [ 'ListJobsFilterList$member' => NULL, ], ], 'LaunchTemplateSpecification' => [ 'base' => '<p>An object representing a launch template associated with a compute resource. You must specify either the launch template ID or launch template name in the request, but not both.</p> <p>If security groups are specified using both the <code>securityGroupIds</code> parameter of <code>CreateComputeEnvironment</code> and the launch template, the values in the <code>securityGroupIds</code> parameter of <code>CreateComputeEnvironment</code> will be used.</p> <note> <p>This object isn\'t applicable to jobs that are running on Fargate resources.</p> </note>', 'refs' => [ 'ComputeResource$launchTemplate' => '<p>The launch template to use for your compute resources. Any other compute resource parameters that you specify in a <a>CreateComputeEnvironment</a> API operation override the same parameters in the launch template. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch template support</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResourceUpdate$launchTemplate' => '<p>The updated launch template to use for your compute resources. You must specify either the launch template ID or launch template name in the request, but not both. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/launch-templates.html">Launch template support</a> in the <i>Batch User Guide</i>. To remove the custom launch template and use the default launch template, set <code>launchTemplateId</code> or <code>launchTemplateName</code> member of the launch template specification to an empty string. Removing the launch template from a compute environment will not remove the AMI specified in the launch template. In order to update the AMI specified in a launch template, the <code>updateToLatestImageVersion</code> parameter must be set to <code>true</code>.</p> <p>When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', ], ], 'LinuxParameters' => [ 'base' => '<p>Linux-specific modifications that are applied to the container, such as details for device mappings.</p>', 'refs' => [ 'ContainerDetail$linuxParameters' => '<p>Linux-specific modifications that are applied to the container, such as details for device mappings.</p>', 'ContainerProperties$linuxParameters' => '<p>Linux-specific modifications that are applied to the container, such as details for device mappings.</p>', ], ], 'ListJobsFilterList' => [ 'base' => NULL, 'refs' => [ 'ListJobsRequest$filters' => '<p>The filter to apply to the query. Only one filter can be used at a time. When the filter is used, <code>jobStatus</code> is ignored. The filter doesn\'t apply to child jobs in an array or multi-node parallel (MNP) jobs. The results are sorted by the <code>createdAt</code> field, with the most recent jobs being first.</p> <dl> <dt>JOB_NAME</dt> <dd> <p>The value of the filter is a case-insensitive match for the job name. If the value ends with an asterisk (*), the filter will match any job name that begins with the string before the \'*\'. This corresponds to the <code>jobName</code> value. For example, <code>test1</code> matches both <code>Test1</code> and <code>test1</code>, and <code>test1*</code> matches both <code>test1</code> and <code>Test10</code>. When the <code>JOB_NAME</code> filter is used, the results are grouped by the job name and version.</p> </dd> <dt>JOB_DEFINITION</dt> <dd> <p>The value for the filter is the name or Amazon Resource Name (ARN) of the job definition. This corresponds to the <code>jobDefinition</code> value. The value is case sensitive. When the value for the filter is the job definition name, the results include all the jobs that used any revision of that job definition name. If the value ends with an asterisk (*), the filter will match any job definition name that begins with the string before the \'*\'. For example, <code>jd1</code> matches only <code>jd1</code>, and <code>jd1*</code> matches both <code>jd1</code> and <code>jd1A</code>. The version of the job definition that\'s used doesn\'t affect the sort order. When the <code>JOB_DEFINITION</code> filter is used and the ARN is used (which is in the form <code>arn:${Partition}:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code>), the results include jobs that used the specified revision of the job definition. Asterisk (*) is not supported when the ARN is used.</p> </dd> <dt>BEFORE_CREATED_AT</dt> <dd> <p>The value for the filter is the time that\'s before the job was created. This corresponds to the <code>createdAt</code> value. The value is a string representation of the number of milliseconds since 00:00:00 UTC (midnight) on January 1, 1970.</p> </dd> <dt>AFTER_CREATED_AT</dt> <dd> <p>The value for the filter is the time that\'s after the job was created. This corresponds to the <code>createdAt</code> value. The value is a string representation of the number of milliseconds since 00:00:00 UTC (midnight) on January 1, 1970.</p> </dd> </dl>', ], ], 'ListJobsRequest' => [ 'base' => '<p>Contains the parameters for <code>ListJobs</code>.</p>', 'refs' => [], ], 'ListJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSchedulingPoliciesRequest' => [ 'base' => '<p>Contains the parameters for <code>ListSchedulingPolicies</code>.</p>', 'refs' => [], ], 'ListSchedulingPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => '<p>Contains the parameters for <code>ListTagsForResource</code>.</p>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogConfiguration' => [ 'base' => '<p>Log configuration options to send to a custom log driver for the container.</p>', 'refs' => [ 'ContainerDetail$logConfiguration' => '<p>The log configuration specification for the container.</p> <p>This parameter maps to <code>LogConfig</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance. Or, alternatively, it must be configured on a different log server for remote logging options. For more information on the options for different supported log drivers, see <a href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.</p> <note> <p>Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the <a>LogConfiguration</a> data type). Additional log drivers might be available in future releases of the Amazon ECS container agent.</p> </note> <p>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log into your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code> </p> <note> <p>The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> </note>', 'ContainerProperties$logConfiguration' => '<p>The log configuration specification for the container.</p> <p>This parameter maps to <code>LogConfig</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.</p> <note> <p>Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the <a>LogConfiguration</a> data type).</p> </note> <p>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log into your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code> </p> <note> <p>The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> </note>', ], ], 'LogConfigurationOptionsMap' => [ 'base' => NULL, 'refs' => [ 'LogConfiguration$options' => '<p>The configuration options to send to the log driver. This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log into your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code> </p>', ], ], 'LogDriver' => [ 'base' => NULL, 'refs' => [ 'LogConfiguration$logDriver' => '<p>The log driver to use for the container. The valid values listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.</p> <p>The supported log drivers are <code>awslogs</code>, <code>fluentd</code>, <code>gelf</code>, <code>json-file</code>, <code>journald</code>, <code>logentries</code>, <code>syslog</code>, and <code>splunk</code>.</p> <note> <p>Jobs that are running on Fargate resources are restricted to the <code>awslogs</code> and <code>splunk</code> log drivers.</p> </note> <dl> <dt>awslogs</dt> <dd> <p>Specifies the Amazon CloudWatch Logs logging driver. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html">Using the awslogs log driver</a> in the <i>Batch User Guide</i> and <a href="https://docs.docker.com/config/containers/logging/awslogs/">Amazon CloudWatch Logs logging driver</a> in the Docker documentation.</p> </dd> <dt>fluentd</dt> <dd> <p>Specifies the Fluentd logging driver. For more information, including usage and options, see <a href="https://docs.docker.com/config/containers/logging/fluentd/">Fluentd logging driver</a> in the Docker documentation.</p> </dd> <dt>gelf</dt> <dd> <p>Specifies the Graylog Extended Format (GELF) logging driver. For more information, including usage and options, see <a href="https://docs.docker.com/config/containers/logging/gelf/">Graylog Extended Format logging driver</a> in the Docker documentation.</p> </dd> <dt>journald</dt> <dd> <p>Specifies the journald logging driver. For more information, including usage and options, see <a href="https://docs.docker.com/config/containers/logging/journald/">Journald logging driver</a> in the Docker documentation.</p> </dd> <dt>json-file</dt> <dd> <p>Specifies the JSON file logging driver. For more information, including usage and options, see <a href="https://docs.docker.com/config/containers/logging/json-file/">JSON File logging driver</a> in the Docker documentation.</p> </dd> <dt>splunk</dt> <dd> <p>Specifies the Splunk logging driver. For more information, including usage and options, see <a href="https://docs.docker.com/config/containers/logging/splunk/">Splunk logging driver</a> in the Docker documentation.</p> </dd> <dt>syslog</dt> <dd> <p>Specifies the syslog logging driver. For more information, including usage and options, see <a href="https://docs.docker.com/config/containers/logging/syslog/">Syslog logging driver</a> in the Docker documentation.</p> </dd> </dl> <note> <p>If you have a custom driver that\'s not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that\'s <a href="https://github.com/aws/amazon-ecs-agent">available on GitHub</a> and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn\'t currently support running modified copies of this software.</p> </note> <p>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log into your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code> </p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AttemptDetail$startedAt' => '<p>The Unix timestamp (in milliseconds) for when the attempt was started (when the attempt transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state).</p>', 'AttemptDetail$stoppedAt' => '<p>The Unix timestamp (in milliseconds) for when the attempt was stopped (when the attempt transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).</p>', 'JobDetail$createdAt' => '<p>The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this is when the job entered the <code>SUBMITTED</code> state (at the time <a>SubmitJob</a> was called). For array child jobs, this is when the child job was spawned by its parent and entered the <code>PENDING</code> state.</p>', 'JobDetail$startedAt' => '<p>The Unix timestamp (in milliseconds) for when the job was started (when the job transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state). This parameter isn\'t provided for child jobs of array jobs or multi-node parallel jobs.</p>', 'JobDetail$stoppedAt' => '<p>The Unix timestamp (in milliseconds) for when the job was stopped (when the job transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).</p>', 'JobSummary$createdAt' => '<p>The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this is when the job entered the <code>SUBMITTED</code> state (at the time <a>SubmitJob</a> was called). For array child jobs, this is when the child job was spawned by its parent and entered the <code>PENDING</code> state.</p>', 'JobSummary$startedAt' => '<p>The Unix timestamp for when the job was started (when the job transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state).</p>', 'JobSummary$stoppedAt' => '<p>The Unix timestamp for when the job was stopped (when the job transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or <code>FAILED</code>).</p>', ], ], 'MountPoint' => [ 'base' => '<p>Details on a Docker volume mount point that\'s used in a job\'s container properties. This parameter maps to <code>Volumes</code> in the <a href="https://docs.docker.com/engine/reference/api/docker_remote_api_v1.19/#create-a-container">Create a container</a> section of the Docker Remote API and the <code>--volume</code> option to docker run.</p>', 'refs' => [ 'MountPoints$member' => NULL, ], ], 'MountPoints' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$mountPoints' => '<p>The mount points for data volumes in your container.</p>', 'ContainerProperties$mountPoints' => '<p>The mount points for data volumes in your container. This parameter maps to <code>Volumes</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>', ], ], 'NetworkConfiguration' => [ 'base' => '<p>The network configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.</p>', 'refs' => [ 'ContainerDetail$networkConfiguration' => '<p>The network configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.</p>', 'ContainerProperties$networkConfiguration' => '<p>The network configuration for jobs that are running on Fargate resources. Jobs that are running on EC2 resources must not specify this parameter.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>An object representing the elastic network interface for a multi-node parallel job node.</p>', 'refs' => [ 'NetworkInterfaceList$member' => NULL, ], ], 'NetworkInterfaceList' => [ 'base' => NULL, 'refs' => [ 'AttemptContainerDetail$networkInterfaces' => '<p>The network interfaces associated with the job attempt.</p>', 'ContainerDetail$networkInterfaces' => '<p>The network interfaces associated with the job.</p>', ], ], 'NodeDetails' => [ 'base' => '<p>An object representing the details of a multi-node parallel job node.</p>', 'refs' => [ 'JobDetail$nodeDetails' => '<p>An object representing the details of a node that\'s associated with a multi-node parallel job.</p>', ], ], 'NodeOverrides' => [ 'base' => '<p>Object representing any node overrides to a job definition that\'s used in a <a>SubmitJob</a> API operation.</p> <note> <p>This isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided; use <code>containerOverrides</code> instead.</p> </note>', 'refs' => [ 'SubmitJobRequest$nodeOverrides' => '<p>A list of node overrides in JSON format that specify the node range to target and the container overrides for that node range.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources; use <code>containerOverrides</code> instead.</p> </note>', ], ], 'NodeProperties' => [ 'base' => '<p>An object representing the node properties of a multi-node parallel job.</p>', 'refs' => [ 'JobDefinition$nodeProperties' => '<p>An object with various properties specific to multi-node parallel jobs.</p> <note> <p>If the job runs on Fargate resources, then you must not specify <code>nodeProperties</code>; use <code>containerProperties</code> instead.</p> </note>', 'JobDetail$nodeProperties' => '<p>An object representing the node properties of a multi-node parallel job.</p> <note> <p>This isn\'t applicable to jobs that are running on Fargate resources.</p> </note>', 'RegisterJobDefinitionRequest$nodeProperties' => '<p>An object with various properties specific to multi-node parallel jobs. If you specify node properties for a job, it becomes a multi-node parallel job. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/multi-node-parallel-jobs.html">Multi-node Parallel Jobs</a> in the <i>Batch User Guide</i>. If the job definition\'s <code>type</code> parameter is <code>container</code>, then you must specify either <code>containerProperties</code> or <code>nodeProperties</code>.</p> <note> <p>If the job runs on Fargate resources, then you must not specify <code>nodeProperties</code>; use <code>containerProperties</code> instead.</p> </note>', ], ], 'NodePropertiesSummary' => [ 'base' => '<p>An object representing the properties of a node that\'s associated with a multi-node parallel job.</p>', 'refs' => [ 'JobSummary$nodeProperties' => '<p>The node properties for a single node in a job summary list.</p> <note> <p>This isn\'t applicable to jobs that are running on Fargate resources.</p> </note>', ], ], 'NodePropertyOverride' => [ 'base' => '<p>Object representing any node overrides to a job definition that\'s used in a <a>SubmitJob</a> API operation.</p>', 'refs' => [ 'NodePropertyOverrides$member' => NULL, ], ], 'NodePropertyOverrides' => [ 'base' => NULL, 'refs' => [ 'NodeOverrides$nodePropertyOverrides' => '<p>The node property overrides for the job.</p>', ], ], 'NodeRangeProperties' => [ 'base' => NULL, 'refs' => [ 'NodeProperties$nodeRangeProperties' => '<p>A list of node ranges and their properties associated with a multi-node parallel job.</p>', ], ], 'NodeRangeProperty' => [ 'base' => '<p>An object representing the properties of the node range for a multi-node parallel job.</p>', 'refs' => [ 'NodeRangeProperties$member' => NULL, ], ], 'ParametersMap' => [ 'base' => NULL, 'refs' => [ 'JobDefinition$parameters' => '<p>Default parameters or parameter substitution placeholders that are set in the job definition. Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition. For more information about specifying parameters, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job definition parameters</a> in the <i>Batch User Guide</i>.</p>', 'JobDetail$parameters' => '<p>Additional parameters passed to the job that replace parameter substitution placeholders or override any corresponding parameter defaults from the job definition.</p>', 'RegisterJobDefinitionRequest$parameters' => '<p>Default parameter substitution placeholders to set in the job definition. Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.</p>', 'SubmitJobRequest$parameters' => '<p>Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition.</p>', ], ], 'PlatformCapability' => [ 'base' => NULL, 'refs' => [ 'PlatformCapabilityList$member' => NULL, ], ], 'PlatformCapabilityList' => [ 'base' => NULL, 'refs' => [ 'JobDefinition$platformCapabilities' => '<p>The platform capabilities required by the job definition. If no value is specified, it defaults to <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.</p>', 'JobDetail$platformCapabilities' => '<p>The platform capabilities required by the job definition. If no value is specified, it defaults to <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.</p>', 'RegisterJobDefinitionRequest$platformCapabilities' => '<p>The platform capabilities required by the job definition. If no value is specified, it defaults to <code>EC2</code>. To run the job on Fargate resources, specify <code>FARGATE</code>.</p>', ], ], 'RegisterJobDefinitionRequest' => [ 'base' => '<p>Contains the parameters for <code>RegisterJobDefinition</code>.</p>', 'refs' => [], ], 'RegisterJobDefinitionResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceRequirement' => [ 'base' => '<p>The type and amount of a resource to assign to a container. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.</p>', 'refs' => [ 'ResourceRequirements$member' => NULL, ], ], 'ResourceRequirements' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$resourceRequirements' => '<p>The type and amount of resources to assign to a container. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.</p>', 'ContainerOverrides$resourceRequirements' => '<p>The type and amount of resources to assign to a container. This overrides the settings in the job definition. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.</p>', 'ContainerProperties$resourceRequirements' => '<p>The type and amount of resources to assign to a container. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceRequirement$type' => '<p>The type of resource to assign to a container. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.</p>', ], ], 'RetryAction' => [ 'base' => NULL, 'refs' => [ 'EvaluateOnExit$action' => '<p>Specifies the action to take if all of the specified conditions (<code>onStatusReason</code>, <code>onReason</code>, and <code>onExitCode</code>) are met. The values aren\'t case sensitive.</p>', ], ], 'RetryStrategy' => [ 'base' => '<p>The retry strategy associated with a job. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html">Automated job retries</a> in the <i>Batch User Guide</i>.</p>', 'refs' => [ 'JobDefinition$retryStrategy' => '<p>The retry strategy to use for failed jobs that are submitted with this job definition.</p>', 'JobDetail$retryStrategy' => '<p>The retry strategy to use for this job if an attempt fails.</p>', 'RegisterJobDefinitionRequest$retryStrategy' => '<p>The retry strategy to use for failed jobs that are submitted with this job definition. Any retry strategy that\'s specified during a <a>SubmitJob</a> operation overrides the retry strategy defined here. If a job is terminated due to a timeout, it isn\'t retried.</p>', 'SubmitJobRequest$retryStrategy' => '<p>The retry strategy to use for failed jobs from this <a>SubmitJob</a> operation. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.</p>', ], ], 'SchedulingPolicyDetail' => [ 'base' => '<p>An object that represents a scheduling policy.</p>', 'refs' => [ 'SchedulingPolicyDetailList$member' => NULL, ], ], 'SchedulingPolicyDetailList' => [ 'base' => NULL, 'refs' => [ 'DescribeSchedulingPoliciesResponse$schedulingPolicies' => '<p>The list of scheduling policies.</p>', ], ], 'SchedulingPolicyListingDetail' => [ 'base' => '<p>An object that contains the details of a scheduling policy that\'s returned in a <code>ListSchedulingPolicy</code> action.</p>', 'refs' => [ 'SchedulingPolicyListingDetailList$member' => NULL, ], ], 'SchedulingPolicyListingDetailList' => [ 'base' => NULL, 'refs' => [ 'ListSchedulingPoliciesResponse$schedulingPolicies' => '<p>A list of scheduling policies that match the request.</p>', ], ], 'Secret' => [ 'base' => '<p>An object representing the secret to expose to your container. Secrets can be exposed to a container in the following ways:</p> <ul> <li> <p>To inject sensitive data into your containers as environment variables, use the <code>secrets</code> container definition parameter.</p> </li> <li> <p>To reference sensitive information in the log configuration of a container, use the <code>secretOptions</code> container definition parameter.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <i>Batch User Guide</i>.</p>', 'refs' => [ 'SecretList$member' => NULL, ], ], 'SecretList' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$secrets' => '<p>The secrets to pass to the container. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <i>Batch User Guide</i>.</p>', 'ContainerProperties$secrets' => '<p>The secrets for the container. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <i>Batch User Guide</i>.</p>', 'LogConfiguration$secretOptions' => '<p>The secrets to pass to the log configuration. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <i>Batch User Guide</i>.</p>', ], ], 'ServerException' => [ 'base' => '<p>These errors are usually caused by a server issue.</p>', 'refs' => [], ], 'ShareAttributes' => [ 'base' => '<p>Specifies the weights for the fair share identifiers for the fair share policy. Fair share identifiers that aren\'t included have a default weight of <code>1.0</code>.</p>', 'refs' => [ 'ShareAttributesList$member' => NULL, ], ], 'ShareAttributesList' => [ 'base' => NULL, 'refs' => [ 'FairsharePolicy$shareDistribution' => '<p>An array of <code>SharedIdentifier</code> objects that contain the weights for the fair share identifiers for the fair share policy. Fair share identifiers that aren\'t included have a default weight of <code>1.0</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ArrayJobStatusSummary$key' => NULL, 'AttemptContainerDetail$containerInstanceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon ECS container instance that hosts the job attempt.</p>', 'AttemptContainerDetail$taskArn' => '<p>The Amazon Resource Name (ARN) of the Amazon ECS task that\'s associated with the job attempt. Each container attempt receives a task ARN when they reach the <code>STARTING</code> status.</p>', 'AttemptContainerDetail$reason' => '<p>A short (255 max characters) human-readable string to provide additional details about a running or stopped container.</p>', 'AttemptContainerDetail$logStreamName' => '<p>The name of the CloudWatch Logs log stream associated with the container. The log group for Batch jobs is <code>/aws/batch/job</code>. Each container attempt receives a log stream name when they reach the <code>RUNNING</code> status.</p>', 'AttemptDetail$statusReason' => '<p>A short, human-readable string to provide additional details about the current status of the job attempt.</p>', 'CancelJobRequest$jobId' => '<p>The Batch job ID of the job to cancel.</p>', 'CancelJobRequest$reason' => '<p>A message to attach to the job that explains the reason for canceling it. This message is returned by future <a>DescribeJobs</a> operations on the job. This message is also recorded in the Batch activity logs.</p>', 'ClientException$message' => NULL, 'ComputeEnvironmentDetail$computeEnvironmentName' => '<p>The name of the compute environment. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).</p>', 'ComputeEnvironmentDetail$computeEnvironmentArn' => '<p>The Amazon Resource Name (ARN) of the compute environment.</p>', 'ComputeEnvironmentDetail$ecsClusterArn' => '<p>The Amazon Resource Name (ARN) of the underlying Amazon ECS cluster used by the compute environment.</p>', 'ComputeEnvironmentDetail$statusReason' => '<p>A short, human-readable string to provide additional details about the current status of the compute environment.</p>', 'ComputeEnvironmentDetail$serviceRole' => '<p>The service role associated with the compute environment that allows Batch to make calls to Amazon Web Services API operations on your behalf. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">Batch service IAM role</a> in the <i>Batch User Guide</i>.</p>', 'ComputeEnvironmentOrder$computeEnvironment' => '<p>The Amazon Resource Name (ARN) of the compute environment.</p>', 'ComputeResource$imageId' => '<p>The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the <code>imageIdOverride</code> member of the <code>Ec2Configuration</code> structure.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note> <note> <p>The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html">Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> </note>', 'ComputeResource$ec2KeyPair' => '<p>The Amazon EC2 key pair that\'s used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResource$instanceRole' => '<p>The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, <code> <i>ecsInstanceRole</i> </code> or <code>arn:aws:iam::<i>&lt;aws_account_id&gt;</i>:instance-profile/<i>ecsInstanceRole</i> </code>. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html">Amazon ECS instance role</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResource$placementGroup' => '<p>The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResource$spotIamFleetRole' => '<p>The Amazon Resource Name (ARN) of the Amazon EC2 Spot Fleet IAM role applied to a <code>SPOT</code> compute environment. This role is required if the allocation strategy set to <code>BEST_FIT</code> or if the allocation strategy isn\'t specified. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/spot_fleet_IAM_role.html">Amazon EC2 spot fleet role</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note> <important> <p>To tag your Spot Instances on creation, the Spot Fleet IAM role specified here must use the newer <b>AmazonEC2SpotFleetTaggingRole</b> managed policy. The previously recommended <b>AmazonEC2SpotFleetRole</b> managed policy doesn\'t have the required permissions to tag Spot Instances. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#spot-instance-no-tag">Spot instances not tagged on creation</a> in the <i>Batch User Guide</i>.</p> </important>', 'ComputeResourceUpdate$ec2KeyPair' => '<p>The Amazon EC2 key pair that\'s used for instances launched in the compute environment. You can use this key pair to log in to your instances with SSH. To remove the Amazon EC2 key pair, set this value to an empty string.</p> <p>When updating a compute environment, changing the EC2 key pair requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResourceUpdate$instanceRole' => '<p>The Amazon ECS instance profile applied to Amazon EC2 instances in a compute environment. You can specify the short name or full Amazon Resource Name (ARN) of an instance profile. For example, <code> <i>ecsInstanceRole</i> </code> or <code>arn:aws:iam::<i>&lt;aws_account_id&gt;</i>:instance-profile/<i>ecsInstanceRole</i> </code>. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/instance_IAM_role.html">Amazon ECS instance role</a> in the <i>Batch User Guide</i>.</p> <p>When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResourceUpdate$placementGroup' => '<p>The Amazon EC2 placement group to associate with your compute resources. If you intend to submit multi-node parallel jobs to your compute environment, you should consider creating a cluster placement group and associate it with your compute resources. This keeps your multi-node parallel job on a logical grouping of instances within a single Availability Zone with high network flow potential. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p> <p>When updating a compute environment, changing the placement group requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResourceUpdate$imageId' => '<p>The Amazon Machine Image (AMI) ID used for instances launched in the compute environment. This parameter is overridden by the <code>imageIdOverride</code> member of the <code>Ec2Configuration</code> structure. To remove the custom AMI ID and use the default AMI ID, set this value to an empty string.</p> <p>When updating a compute environment, changing the AMI ID requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note> <note> <p>The AMI that you choose for a compute environment must match the architecture of the instance types that you intend to use for that compute environment. For example, if your compute environment uses A1 instance types, the compute resource AMI that you choose must support ARM instances. Amazon ECS vends both x86 and ARM versions of the Amazon ECS-optimized Amazon Linux 2 AMI. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#ecs-optimized-ami-linux-variants.html">Amazon ECS-optimized Amazon Linux 2 AMI</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> </note>', 'ContainerDetail$image' => '<p>The image used to start the container.</p>', 'ContainerDetail$jobRoleArn' => '<p>The Amazon Resource Name (ARN) associated with the job upon execution.</p>', 'ContainerDetail$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the execution role that Batch can assume. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">Batch execution IAM role</a> in the <i>Batch User Guide</i>.</p>', 'ContainerDetail$user' => '<p>The user name to use inside the container. This parameter maps to <code>User</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--user</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>', 'ContainerDetail$reason' => '<p>A short (255 max characters) human-readable string to provide additional details about a running or stopped container.</p>', 'ContainerDetail$containerInstanceArn' => '<p>The Amazon Resource Name (ARN) of the container instance that the container is running on.</p>', 'ContainerDetail$taskArn' => '<p>The Amazon Resource Name (ARN) of the Amazon ECS task that\'s associated with the container job. Each container attempt receives a task ARN when they reach the <code>STARTING</code> status.</p>', 'ContainerDetail$logStreamName' => '<p>The name of the CloudWatch Logs log stream associated with the container. The log group for Batch jobs is <code>/aws/batch/job</code>. Each container attempt receives a log stream name when they reach the <code>RUNNING</code> status.</p>', 'ContainerDetail$instanceType' => '<p>The instance type of the underlying host infrastructure of a multi-node parallel job.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources.</p> </note>', 'ContainerOverrides$instanceType' => '<p>The instance type to use for a multi-node parallel job.</p> <note> <p>This parameter isn\'t applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn\'t be provided.</p> </note>', 'ContainerProperties$image' => '<p>The image used to start a container. This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with <code> <i>repository-url</i>/<i>image</i>:<i>tag</i> </code>. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to <code>Image</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>IMAGE</code> parameter of <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <note> <p>Docker image architecture must match the processor architecture of the compute resources that they\'re scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.</p> </note> <ul> <li> <p>Images in Amazon ECR Public repositories use the full <code>registry/repository[:tag]</code> or <code>registry/repository[@digest]</code> naming conventions. For example, <code>public.ecr.aws/<i>registry_alias</i>/<i>my-web-app</i>:<i>latest</i> </code>.</p> </li> <li> <p>Images in Amazon ECR repositories use the full registry and repository URI (for example, <code>012345678910.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code>).</p> </li> <li> <p>Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or <code>mongo</code>).</p> </li> <li> <p>Images in other repositories on Docker Hub are qualified with an organization name (for example, <code>amazon/amazon-ecs-agent</code>).</p> </li> <li> <p>Images in other online repositories are qualified further by a domain name (for example, <code>quay.io/assemblyline/ubuntu</code>).</p> </li> </ul>', 'ContainerProperties$jobRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that the container can assume for Amazon Web Services permissions. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM roles for tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', 'ContainerProperties$executionRoleArn' => '<p>The Amazon Resource Name (ARN) of the execution role that Batch can assume. For jobs that run on Fargate resources, you must provide an execution role. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">Batch execution IAM role</a> in the <i>Batch User Guide</i>.</p>', 'ContainerProperties$user' => '<p>The user name to use inside the container. This parameter maps to <code>User</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--user</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p>', 'ContainerProperties$instanceType' => '<p>The instance type to use for a multi-node parallel job. All node groups in a multi-node parallel job must use the same instance type.</p> <note> <p>This parameter isn\'t applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn\'t be provided.</p> </note>', 'ContainerSummary$reason' => '<p>A short (255 max characters) human-readable string to provide additional details about a running or stopped container.</p>', 'CreateComputeEnvironmentRequest$computeEnvironmentName' => '<p>The name for your compute environment. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).</p>', 'CreateComputeEnvironmentRequest$serviceRole' => '<p>The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon Web Services services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">Batch service IAM role</a> in the <i>Batch User Guide</i>.</p> <important> <p>If your account already created the Batch service-linked role, that role is used by default for your compute environment unless you specify a different role here. If the Batch service-linked role doesn\'t exist in your account, and no role is specified here, the service attempts to create the Batch service-linked role in your account.</p> </important> <p>If your specified role has a path other than <code>/</code>, then you must specify either the full role ARN (recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <i>IAM User Guide</i>.</p> <note> <p>Depending on how you created your Batch service role, its ARN might contain the <code>service-role</code> path prefix. When you only specify the name of the service role, Batch assumes that your ARN doesn\'t use the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.</p> </note>', 'CreateComputeEnvironmentResponse$computeEnvironmentName' => '<p>The name of the compute environment. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).</p>', 'CreateComputeEnvironmentResponse$computeEnvironmentArn' => '<p>The Amazon Resource Name (ARN) of the compute environment.</p>', 'CreateJobQueueRequest$jobQueueName' => '<p>The name of the job queue. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).</p>', 'CreateJobQueueRequest$schedulingPolicyArn' => '<p>The Amazon Resource Name (ARN) of the fair share scheduling policy. If this parameter is specified, the job queue uses a fair share scheduling policy. If this parameter isn\'t specified, the job queue uses a first in, first out (FIFO) scheduling policy. After a job queue is created, you can replace but can\'t remove the fair share scheduling policy. The format is <code>aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> </code>. An example is <code>aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy</code>.</p>', 'CreateJobQueueResponse$jobQueueName' => '<p>The name of the job queue.</p>', 'CreateJobQueueResponse$jobQueueArn' => '<p>The Amazon Resource Name (ARN) of the job queue.</p>', 'CreateSchedulingPolicyRequest$name' => '<p>The name of the scheduling policy. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).</p>', 'CreateSchedulingPolicyResponse$name' => '<p>The name of the scheduling policy.</p>', 'CreateSchedulingPolicyResponse$arn' => '<p>The Amazon Resource Name (ARN) of the scheduling policy. The format is <code>aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> </code>. For example, <code>aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy</code>.</p>', 'DeleteComputeEnvironmentRequest$computeEnvironment' => '<p>The name or Amazon Resource Name (ARN) of the compute environment to delete.</p>', 'DeleteJobQueueRequest$jobQueue' => '<p>The short name or full Amazon Resource Name (ARN) of the queue to delete.</p>', 'DeleteSchedulingPolicyRequest$arn' => '<p>The Amazon Resource Name (ARN) of the scheduling policy to delete.</p>', 'DeregisterJobDefinitionRequest$jobDefinition' => '<p>The name and revision (<code>name:revision</code>) or full Amazon Resource Name (ARN) of the job definition to deregister.</p>', 'DescribeComputeEnvironmentsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeComputeEnvironments</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that\'s only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeComputeEnvironmentsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeComputeEnvironments</code> request. When the results of a <code>DescribeComputeEnvironments</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeJobDefinitionsRequest$jobDefinitionName' => '<p>The name of the job definition to describe.</p>', 'DescribeJobDefinitionsRequest$status' => '<p>The status used to filter job definitions.</p>', 'DescribeJobDefinitionsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobDefinitions</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that\'s only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeJobDefinitionsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeJobDefinitions</code> request. When the results of a <code>DescribeJobDefinitions</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'DescribeJobQueuesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeJobQueues</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that\'s only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'DescribeJobQueuesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeJobQueues</code> request. When the results of a <code>DescribeJobQueues</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'Device$hostPath' => '<p>The path for the device on the host container instance.</p>', 'Device$containerPath' => '<p>The path inside the container that\'s used to expose the host device. By default, the <code>hostPath</code> value is used.</p>', 'EFSAuthorizationConfig$accessPointId' => '<p>The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set to <code>/</code> which will enforce the path set on the EFS access point. If an access point is used, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code>. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon EFS access points</a> in the <i>Amazon Elastic File System User Guide</i>.</p>', 'EFSVolumeConfiguration$fileSystemId' => '<p>The Amazon EFS file system ID to use.</p>', 'EFSVolumeConfiguration$rootDirectory' => '<p>The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying <code>/</code> has the same effect as omitting this parameter. The maximum length is 4,096 characters.</p> <important> <p>If an EFS access point is specified in the <code>authorizationConfig</code>, the root directory parameter must either be omitted or set to <code>/</code>, which enforces the path set on the Amazon EFS access point.</p> </important>', 'EvaluateOnExit$onStatusReason' => '<p>Contains a glob pattern to match against the <code>StatusReason</code> returned for a job. The pattern can be up to 512 characters in length. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.</p> <p>The string can be between 1 and 512 characters in length.</p>', 'EvaluateOnExit$onReason' => '<p>Contains a glob pattern to match against the <code>Reason</code> returned for a job. The pattern can be up to 512 characters in length. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.</p> <p>The string can be between 1 and 512 characters in length.</p>', 'EvaluateOnExit$onExitCode' => '<p>Contains a glob pattern to match against the decimal representation of the <code>ExitCode</code> returned for a job. The pattern can be up to 512 characters in length. It can contain only numbers, and can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.</p> <p>The string can be between 1 and 512 characters in length.</p>', 'FargatePlatformConfiguration$platformVersion' => '<p>The Fargate platform version where the jobs are running. A platform version is specified only for jobs that are running on Fargate resources. If one isn\'t specified, the <code>LATEST</code> platform version is used by default. This uses a recent, approved version of the Fargate platform for compute resources. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate platform versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', 'Host$sourcePath' => '<p>The path on the host container instance that\'s presented to the container. If this parameter is empty, then the Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the source path location doesn\'t exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.</p> <note> <p>This parameter isn\'t applicable to jobs that run on Fargate resources and shouldn\'t be provided.</p> </note>', 'JobDefinition$jobDefinitionName' => '<p>The name of the job definition.</p>', 'JobDefinition$jobDefinitionArn' => '<p>The Amazon Resource Name (ARN) for the job definition.</p>', 'JobDefinition$status' => '<p>The status of the job definition.</p>', 'JobDefinition$type' => '<p>The type of job definition, either <code>container</code> or <code>multinode</code>. If the job is run on Fargate resources, then <code>multinode</code> isn\'t supported. For more information about multi-node parallel jobs, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html">Creating a multi-node parallel job definition</a> in the <i>Batch User Guide</i>.</p>', 'JobDependency$jobId' => '<p>The job ID of the Batch job associated with this dependency.</p>', 'JobDetail$jobArn' => '<p>The Amazon Resource Name (ARN) of the job.</p>', 'JobDetail$jobName' => '<p>The name of the job.</p>', 'JobDetail$jobId' => '<p>The ID for the job.</p>', 'JobDetail$jobQueue' => '<p>The Amazon Resource Name (ARN) of the job queue that the job is associated with.</p>', 'JobDetail$shareIdentifier' => '<p>The share identifier for the job.</p>', 'JobDetail$statusReason' => '<p>A short, human-readable string to provide additional details about the current status of the job.</p>', 'JobDetail$jobDefinition' => '<p>The Amazon Resource Name (ARN) of the job definition that\'s used by this job.</p>', 'JobQueueDetail$jobQueueName' => '<p>The name of the job queue.</p>', 'JobQueueDetail$jobQueueArn' => '<p>The Amazon Resource Name (ARN) of the job queue.</p>', 'JobQueueDetail$schedulingPolicyArn' => '<p>The Amazon Resource Name (ARN) of the scheduling policy. The format is <code>aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> </code>. For example, <code>aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy</code>.</p>', 'JobQueueDetail$statusReason' => '<p>A short, human-readable string to provide additional details about the current status of the job queue.</p>', 'JobSummary$jobArn' => '<p>The Amazon Resource Name (ARN) of the job.</p>', 'JobSummary$jobId' => '<p>The ID of the job.</p>', 'JobSummary$jobName' => '<p>The name of the job.</p>', 'JobSummary$statusReason' => '<p>A short, human-readable string to provide additional details about the current status of the job.</p>', 'JobSummary$jobDefinition' => '<p>The Amazon Resource Name (ARN) of the job definition.</p>', 'KeyValuePair$name' => '<p>The name of the key-value pair. For environment variables, this is the name of the environment variable.</p>', 'KeyValuePair$value' => '<p>The value of the key-value pair. For environment variables, this is the value of the environment variable.</p>', 'KeyValuesPair$name' => '<p>The name of the filter. Filter names are case sensitive.</p>', 'LaunchTemplateSpecification$launchTemplateId' => '<p>The ID of the launch template.</p>', 'LaunchTemplateSpecification$launchTemplateName' => '<p>The name of the launch template.</p>', 'LaunchTemplateSpecification$version' => '<p>The version number of the launch template, <code>$Latest</code>, or <code>$Default</code>.</p> <p>If the value is <code>$Latest</code>, the latest version of the launch template is used. If the value is <code>$Default</code>, the default version of the launch template is used.</p> <important> <p>If the AMI ID that\'s used in a compute environment is from the launch template, the AMI isn\'t changed when the compute environment is updated. It\'s only changed if the <code>updateToLatestImageVersion</code> parameter for the compute environment is set to <code>true</code>. During an infrastructure update, if either <code>$Latest</code> or <code>$Default</code> is specified, Batch re-evaluates the launch template version, and it might use a different version of the launch template. This is the case even if the launch template isn\'t specified in the update. When updating a compute environment, changing the launch template requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> </important> <p>Default: <code>$Default</code>.</p>', 'ListJobsRequest$jobQueue' => '<p>The name or full Amazon Resource Name (ARN) of the job queue used to list jobs.</p>', 'ListJobsRequest$arrayJobId' => '<p>The job ID for an array job. Specifying an array job ID with this parameter lists all child jobs from within the specified array.</p>', 'ListJobsRequest$multiNodeJobId' => '<p>The job ID for a multi-node parallel job. Specifying a multi-node parallel job ID with this parameter lists all nodes that are associated with the specified job.</p>', 'ListJobsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListJobs</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that\'s only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListJobsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListJobs</code> request. When the results of a <code>ListJobs</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListSchedulingPoliciesRequest$nextToken' => '<p>The <code>nextToken</code> value that\'s returned from a previous paginated <code>ListSchedulingPolicies</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code> when there are no more results to return.</p> <note> <p>This token should be treated as an opaque identifier that\'s only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListSchedulingPoliciesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListSchedulingPolicies</code> request. When the results of a <code>ListSchedulingPolicies</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the resource that tags are listed for. Batch resources that support tags are compute environments, jobs, job definitions, job queues, and scheduling policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs are not supported.</p>', 'LogConfigurationOptionsMap$key' => NULL, 'LogConfigurationOptionsMap$value' => NULL, 'MountPoint$containerPath' => '<p>The path on the container where the host volume is mounted.</p>', 'MountPoint$sourceVolume' => '<p>The name of the volume to mount.</p>', 'NetworkInterface$attachmentId' => '<p>The attachment ID for the network interface.</p>', 'NetworkInterface$ipv6Address' => '<p>The private IPv6 address for the network interface.</p>', 'NetworkInterface$privateIpv4Address' => '<p>The private IPv4 address for the network interface.</p>', 'NodePropertyOverride$targetNodes' => '<p>The range of nodes, using node index values, that\'s used to override. A range of <code>0:3</code> indicates nodes with index values of <code>0</code> through <code>3</code>. If the starting range value is omitted (<code>:n</code>), then <code>0</code> is used to start the range. If the ending range value is omitted (<code>n:</code>), then the highest possible node index is used to end the range.</p>', 'NodeRangeProperty$targetNodes' => '<p>The range of nodes, using node index values. A range of <code>0:3</code> indicates nodes with index values of <code>0</code> through <code>3</code>. If the starting range value is omitted (<code>:n</code>), then <code>0</code> is used to start the range. If the ending range value is omitted (<code>n:</code>), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes (<code>0:n</code>). You can nest node ranges, for example <code>0:10</code> and <code>4:5</code>, in which case the <code>4:5</code> range properties override the <code>0:10</code> properties.</p>', 'ParametersMap$key' => NULL, 'ParametersMap$value' => NULL, 'RegisterJobDefinitionRequest$jobDefinitionName' => '<p>The name of the job definition to register. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).</p>', 'RegisterJobDefinitionResponse$jobDefinitionName' => '<p>The name of the job definition.</p>', 'RegisterJobDefinitionResponse$jobDefinitionArn' => '<p>The Amazon Resource Name (ARN) of the job definition.</p>', 'ResourceRequirement$value' => '<p>The quantity of the specified resource to reserve for the container. The values vary based on the <code>type</code> specified.</p> <dl> <dt>type="GPU"</dt> <dd> <p>The number of physical GPUs to reserve for the container. The number of GPUs reserved for all containers in a job shouldn\'t exceed the number of available GPUs on the compute resource that the job is launched on.</p> <note> <p>GPUs are not available for jobs that are running on Fargate resources.</p> </note> </dd> <dt>type="MEMORY"</dt> <dd> <p>The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <note> <p>If you\'re trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <i>Batch User Guide</i>.</p> </note> <p>For jobs that are running on Fargate resources, then <code>value</code> is the hard limit (in MiB), and must match one of the supported values and the <code>VCPU</code> values must be one of the values supported for that memory value.</p> <dl> <dt>value = 512</dt> <dd> <p> <code>VCPU</code> = 0.25</p> </dd> <dt>value = 1024</dt> <dd> <p> <code>VCPU</code> = 0.25 or 0.5</p> </dd> <dt>value = 2048</dt> <dd> <p> <code>VCPU</code> = 0.25, 0.5, or 1</p> </dd> <dt>value = 3072</dt> <dd> <p> <code>VCPU</code> = 0.5, or 1</p> </dd> <dt>value = 4096</dt> <dd> <p> <code>VCPU</code> = 0.5, 1, or 2</p> </dd> <dt>value = 5120, 6144, or 7168</dt> <dd> <p> <code>VCPU</code> = 1 or 2</p> </dd> <dt>value = 8192</dt> <dd> <p> <code>VCPU</code> = 1, 2, or 4</p> </dd> <dt>value = 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384</dt> <dd> <p> <code>VCPU</code> = 2 or 4</p> </dd> <dt>value = 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720</dt> <dd> <p> <code>VCPU</code> = 4</p> </dd> </dl> </dd> <dt>type="VCPU"</dt> <dd> <p>The number of vCPUs reserved for the container. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Each vCPU is equivalent to 1,024 CPU shares. For EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.</p> <p>For jobs that are running on Fargate resources, then <code>value</code> must match one of the supported values and the <code>MEMORY</code> values must be one of the values supported for that <code>VCPU</code> value. The supported values are 0.25, 0.5, 1, 2, and 4</p> <dl> <dt>value = 0.25</dt> <dd> <p> <code>MEMORY</code> = 512, 1024, or 2048</p> </dd> <dt>value = 0.5</dt> <dd> <p> <code>MEMORY</code> = 1024, 2048, 3072, or 4096</p> </dd> <dt>value = 1</dt> <dd> <p> <code>MEMORY</code> = 2048, 3072, 4096, 5120, 6144, 7168, or 8192</p> </dd> <dt>value = 2</dt> <dd> <p> <code>MEMORY</code> = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384</p> </dd> <dt>value = 4</dt> <dd> <p> <code>MEMORY</code> = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720</p> </dd> </dl> </dd> </dl>', 'SchedulingPolicyDetail$name' => '<p>The name of the scheduling policy.</p>', 'SchedulingPolicyDetail$arn' => '<p>The Amazon Resource Name (ARN) of the scheduling policy. An example is <code>arn:<i>aws</i>:batch:<i>us-east-1</i>:<i>123456789012</i>:scheduling-policy/<i>HighPriority</i> </code>.</p>', 'SchedulingPolicyListingDetail$arn' => '<p>Amazon Resource Name (ARN) of the scheduling policy.</p>', 'Secret$name' => '<p>The name of the secret.</p>', 'Secret$valueFrom' => '<p>The secret to expose to the container. The supported values are either the full ARN of the Secrets Manager secret or the full ARN of the parameter in the Amazon Web Services Systems Manager Parameter Store.</p> <note> <p>If the Amazon Web Services Systems Manager Parameter Store parameter exists in the same Region as the job you\'re launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.</p> </note>', 'ServerException$message' => NULL, 'ShareAttributes$shareIdentifier' => '<p>A fair share identifier or fair share identifier prefix. If the string ends with an asterisk (*), this entry specifies the weight factor to use for fair share identifiers that start with that prefix. The list of fair share identifiers in a fair share policy cannot overlap. For example, you can\'t have one that specifies a <code>shareIdentifier</code> of <code>UserA*</code> and another that specifies a <code>shareIdentifier</code> of <code>UserA-1</code>.</p> <p>There can be no more than 500 fair share identifiers active in a job queue.</p> <p>The string is limited to 255 alphanumeric characters, optionally followed by an asterisk (*).</p>', 'StringList$member' => NULL, 'SubmitJobRequest$jobName' => '<p>The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).</p>', 'SubmitJobRequest$jobQueue' => '<p>The job queue where the job is submitted. You can specify either the name or the Amazon Resource Name (ARN) of the queue.</p>', 'SubmitJobRequest$shareIdentifier' => '<p>The share identifier for the job. If the job queue does not have a scheduling policy, then this parameter must not be specified. If the job queue has a scheduling policy, then this parameter must be specified.</p>', 'SubmitJobRequest$jobDefinition' => '<p>The job definition used by this job. This value can be one of <code>name</code>, <code>name:revision</code>, or the Amazon Resource Name (ARN) for the job definition. If <code>name</code> is specified without a revision then the latest active revision is used.</p>', 'SubmitJobResponse$jobArn' => '<p>The Amazon Resource Name (ARN) for the job.</p>', 'SubmitJobResponse$jobName' => '<p>The name of the job.</p>', 'SubmitJobResponse$jobId' => '<p>The unique identifier for the job.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource that tags are added to. Batch resources that support tags are compute environments, jobs, job definitions, job queues, and scheduling policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs are not supported.</p>', 'TagsMap$key' => NULL, 'TagsMap$value' => NULL, 'TerminateJobRequest$jobId' => '<p>The Batch job ID of the job to terminate.</p>', 'TerminateJobRequest$reason' => '<p>A message to attach to the job that explains the reason for canceling it. This message is returned by future <a>DescribeJobs</a> operations on the job. This message is also recorded in the Batch activity logs.</p>', 'Tmpfs$containerPath' => '<p>The absolute file path in the container where the tmpfs volume is mounted.</p>', 'Ulimit$name' => '<p>The <code>type</code> of the <code>ulimit</code>.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource from which to delete tags. Batch resources that support tags are compute environments, jobs, job definitions, job queues, and scheduling policies. ARNs for child jobs of array and multi-node parallel (MNP) jobs are not supported.</p>', 'UpdateComputeEnvironmentRequest$computeEnvironment' => '<p>The name or full Amazon Resource Name (ARN) of the compute environment to update.</p>', 'UpdateComputeEnvironmentRequest$serviceRole' => '<p>The full Amazon Resource Name (ARN) of the IAM role that allows Batch to make calls to other Amazon Web Services services on your behalf. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">Batch service IAM role</a> in the <i>Batch User Guide</i>.</p> <important> <p>If the compute environment has a service-linked role, it can\'t be changed to use a regular IAM role. Likewise, if the compute environment has a regular IAM role, it can\'t be changed to use a service-linked role. To update the parameters for the compute environment that require an infrastructure update to change, the <b>AWSServiceRoleForBatch</b> service-linked role must be used. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> </important> <p>If your specified role has a path other than <code>/</code>, then you must either specify the full role ARN (recommended) or prefix the role name with the path.</p> <note> <p>Depending on how you created your Batch service role, its ARN might contain the <code>service-role</code> path prefix. When you only specify the name of the service role, Batch assumes that your ARN doesn\'t use the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.</p> </note>', 'UpdateComputeEnvironmentResponse$computeEnvironmentName' => '<p>The name of the compute environment. It can be up to 128 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).</p>', 'UpdateComputeEnvironmentResponse$computeEnvironmentArn' => '<p>The Amazon Resource Name (ARN) of the compute environment.</p>', 'UpdateJobQueueRequest$jobQueue' => '<p>The name or the Amazon Resource Name (ARN) of the job queue.</p>', 'UpdateJobQueueRequest$schedulingPolicyArn' => '<p>Amazon Resource Name (ARN) of the fair share scheduling policy. Once a job queue is created, the fair share scheduling policy can be replaced but not removed. The format is <code>aws:<i>Partition</i>:batch:<i>Region</i>:<i>Account</i>:scheduling-policy/<i>Name</i> </code>. For example, <code>aws:aws:batch:us-west-2:012345678910:scheduling-policy/MySchedulingPolicy</code>.</p>', 'UpdateJobQueueResponse$jobQueueName' => '<p>The name of the job queue.</p>', 'UpdateJobQueueResponse$jobQueueArn' => '<p>The Amazon Resource Name (ARN) of the job queue.</p>', 'UpdateSchedulingPolicyRequest$arn' => '<p>The Amazon Resource Name (ARN) of the scheduling policy to update.</p>', 'Volume$name' => '<p>The name of the volume. It can be up to 255 letters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the <code>sourceVolume</code> parameter of container definition <code>mountPoints</code>.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'ComputeResource$instanceTypes' => '<p>The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, <code>c5</code> or <code>p3</code>), or you can specify specific sizes within a family (such as <code>c5.8xlarge</code>). You can also choose <code>optimal</code> to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note> <note> <p>When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can\'t mix x86 and ARM instances in the same compute environment.</p> </note> <note> <p>Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In Regions that don\'t have instance types from those instance families, instance types from the C5, M5. and R5 instance families are used.</p> </note>', 'ComputeResource$subnets' => '<p>The VPC subnets where the compute resources are launched. These subnets must be within the same VPC. Fargate compute resources can contain up to 16 subnets. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the <i>Amazon VPC User Guide</i>.</p>', 'ComputeResource$securityGroupIds' => '<p>The Amazon EC2 security groups associated with instances launched in the compute environment. One or more security groups must be specified, either in <code>securityGroupIds</code> or using a launch template referenced in <code>launchTemplate</code>. This parameter is required for jobs that are running on Fargate resources and must contain at least one security group. Fargate doesn\'t support launch templates. If security groups are specified using both <code>securityGroupIds</code> and <code>launchTemplate</code>, the values in <code>securityGroupIds</code> are used.</p>', 'ComputeResourceUpdate$subnets' => '<p>The VPC subnets where the compute resources are launched. Fargate compute resources can contain up to 16 subnets. For Fargate compute resources, providing an empty list will be handled as if this parameter wasn\'t specified and no change is made. For EC2 compute resources, providing an empty list removes the VPC subnets from the compute resource. For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the <i>Amazon VPC User Guide</i>.</p> <p>When updating a compute environment, changing the VPC subnets requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p>', 'ComputeResourceUpdate$securityGroupIds' => '<p>The Amazon EC2 security groups associated with instances launched in the compute environment. This parameter is required for Fargate compute resources, where it can contain up to 5 security groups. For Fargate compute resources, providing an empty list is handled as if this parameter wasn\'t specified and no change is made. For EC2 compute resources, providing an empty list removes the security groups from the compute resource.</p> <p>When updating a compute environment, changing the EC2 security groups requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p>', 'ComputeResourceUpdate$instanceTypes' => '<p>The instances types that can be launched. You can specify instance families to launch any instance type within those families (for example, <code>c5</code> or <code>p3</code>), or you can specify specific sizes within a family (such as <code>c5.8xlarge</code>). You can also choose <code>optimal</code> to select instance types (from the C4, M4, and R4 instance families) that match the demand of your job queues.</p> <p>When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note> <note> <p>When you create a compute environment, the instance types that you select for the compute environment must share the same architecture. For example, you can\'t mix x86 and ARM instances in the same compute environment.</p> </note> <note> <p>Currently, <code>optimal</code> uses instance types from the C4, M4, and R4 instance families. In Regions that don\'t have instance types from those instance families, instance types from the C5, M5. and R5 instance families are used.</p> </note>', 'ContainerDetail$command' => '<p>The command that\'s passed to the container.</p>', 'ContainerOverrides$command' => '<p>The command to send to the container that overrides the default command from the Docker image or the job definition.</p>', 'ContainerProperties$command' => '<p>The command that\'s passed to the container. This parameter maps to <code>Cmd</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. For more information, see <a href="https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a>.</p>', 'DescribeComputeEnvironmentsRequest$computeEnvironments' => '<p>A list of up to 100 compute environment names or full Amazon Resource Name (ARN) entries.</p>', 'DescribeJobDefinitionsRequest$jobDefinitions' => '<p>A list of up to 100 job definitions. Each entry in the list can either be an ARN in the format <code>arn:aws:batch:${Region}:${Account}:job-definition/${JobDefinitionName}:${Revision}</code> or a short version using the form <code>${JobDefinitionName}:${Revision}</code>.</p>', 'DescribeJobQueuesRequest$jobQueues' => '<p>A list of up to 100 queue names or full queue Amazon Resource Name (ARN) entries.</p>', 'DescribeJobsRequest$jobs' => '<p>A list of up to 100 job IDs.</p>', 'DescribeSchedulingPoliciesRequest$arns' => '<p>A list of up to 100 scheduling policy Amazon Resource Name (ARN) entries.</p>', 'KeyValuesPair$values' => '<p>The filter values.</p>', 'Tmpfs$mountOptions' => '<p>The list of tmpfs volume mount options.</p> <p>Valid values: "<code>defaults</code>" | "<code>ro</code>" | "<code>rw</code>" | "<code>suid</code>" | "<code>nosuid</code>" | "<code>dev</code>" | "<code>nodev</code>" | "<code>exec</code>" | "<code>noexec</code>" | "<code>sync</code>" | "<code>async</code>" | "<code>dirsync</code>" | "<code>remount</code>" | "<code>mand</code>" | "<code>nomand</code>" | "<code>atime</code>" | "<code>noatime</code>" | "<code>diratime</code>" | "<code>nodiratime</code>" | "<code>bind</code>" | "<code>rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime</code>" | "<code>norelatime</code>" | "<code>strictatime</code>" | "<code>nostrictatime</code>" | "<code>mode</code>" | "<code>uid</code>" | "<code>gid</code>" | "<code>nr_inodes</code>" | "<code>nr_blocks</code>" | "<code>mpol</code>"</p>', ], ], 'SubmitJobRequest' => [ 'base' => '<p>Contains the parameters for <code>SubmitJob</code>.</p>', 'refs' => [], ], 'SubmitJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeysList$member' => NULL, 'TagrisTagsMap$key' => NULL, ], ], 'TagKeysList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to be removed.</p>', ], ], 'TagResourceRequest' => [ 'base' => '<p>Contains the parameters for <code>TagResource</code>.</p>', 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagrisTagsMap$value' => NULL, ], ], 'TagrisTagsMap' => [ 'base' => NULL, 'refs' => [ 'ComputeEnvironmentDetail$tags' => '<p>The tags applied to the compute environment.</p>', 'CreateComputeEnvironmentRequest$tags' => '<p>The tags that you apply to the compute environment to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in <i>Amazon Web Services General Reference</i>.</p> <p>These tags can be updated or removed using the <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a> API operations. These tags don\'t propagate to the underlying compute resources.</p>', 'CreateJobQueueRequest$tags' => '<p>The tags that you apply to the job queue to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch resources</a> in <i>Batch User Guide</i>.</p>', 'CreateSchedulingPolicyRequest$tags' => '<p>The tags that you apply to the scheduling policy to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in <i>Amazon Web Services General Reference</i>.</p> <p>These tags can be updated or removed using the <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_TagResource.html">TagResource</a> and <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_UntagResource.html">UntagResource</a> API operations.</p>', 'JobDefinition$tags' => '<p>The tags applied to the job definition.</p>', 'JobDetail$tags' => '<p>The tags applied to the job.</p>', 'JobQueueDetail$tags' => '<p>The tags applied to the job queue. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging your Batch resources</a> in <i>Batch User Guide</i>.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags for the resource.</p>', 'RegisterJobDefinitionRequest$tags' => '<p>The tags that you apply to the job definition to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using-tags.html">Tagging Amazon Web Services Resources</a> in <i>Batch User Guide</i>.</p>', 'SchedulingPolicyDetail$tags' => '<p>The tags that you apply to the scheduling policy to categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a> in <i>Amazon Web Services General Reference</i>.</p>', 'SubmitJobRequest$tags' => '<p>The tags that you apply to the job request to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in <i>Amazon Web Services General Reference</i>.</p>', 'TagResourceRequest$tags' => '<p>The tags that you apply to the resource to help you categorize and organize your resources. Each tag consists of a key and an optional value. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a> in <i>Amazon Web Services General Reference</i>.</p>', ], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'ComputeResource$tags' => '<p>Key-value pair tags to be applied to EC2 resources that are launched in the compute environment. For Batch, these take the form of "String1": "String2", where String1 is the tag key and String2 is the tag value−for example, <code>{ "Name": "Batch Instance - C4OnDemand" }</code>. This is helpful for recognizing your Batch instances in the Amazon EC2 console. Updating these tags requires an infrastructure update to the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>. These tags aren\'t seen when using the Batch <code>ListTagsForResource</code> API operation.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', 'ComputeResourceUpdate$tags' => '<p>Key-value pair tags to be applied to EC2 resources that are launched in the compute environment. For Batch, these take the form of "String1": "String2", where String1 is the tag key and String2 is the tag value−for example, <code>{ "Name": "Batch Instance - C4OnDemand" }</code>. This is helpful for recognizing your Batch instances in the Amazon EC2 console. These tags aren\'t seen when using the Batch <code>ListTagsForResource</code> API operation.</p> <p>When updating a compute environment, changing this setting requires an infrastructure update of the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources, and shouldn\'t be specified.</p> </note>', ], ], 'TerminateJobRequest' => [ 'base' => '<p>Contains the parameters for <code>TerminateJob</code>.</p>', 'refs' => [], ], 'TerminateJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'Tmpfs' => [ 'base' => '<p>The container path, mount options, and size of the tmpfs mount.</p> <note> <p>This object isn\'t applicable to jobs that are running on Fargate resources.</p> </note>', 'refs' => [ 'TmpfsList$member' => NULL, ], ], 'TmpfsList' => [ 'base' => NULL, 'refs' => [ 'LinuxParameters$tmpfs' => '<p>The container path, mount options, and size (in MiB) of the tmpfs mount. This parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided.</p> </note>', ], ], 'Ulimit' => [ 'base' => '<p>The <code>ulimit</code> settings to pass to the container.</p> <note> <p>This object isn\'t applicable to jobs that are running on Fargate resources.</p> </note>', 'refs' => [ 'Ulimits$member' => NULL, ], ], 'Ulimits' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$ulimits' => '<p>A list of <code>ulimit</code> values to set in the container. This parameter maps to <code>Ulimits</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources.</p> </note>', 'ContainerProperties$ulimits' => '<p>A list of <code>ulimits</code> to set in the container. This parameter maps to <code>Ulimits</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <note> <p>This parameter isn\'t applicable to jobs that are running on Fargate resources and shouldn\'t be provided.</p> </note>', ], ], 'UntagResourceRequest' => [ 'base' => '<p>Contains the parameters for <code>UntagResource</code>.</p>', 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComputeEnvironmentRequest' => [ 'base' => '<p>Contains the parameters for <code>UpdateComputeEnvironment</code>.</p>', 'refs' => [], ], 'UpdateComputeEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateJobQueueRequest' => [ 'base' => '<p>Contains the parameters for <code>UpdateJobQueue</code>.</p>', 'refs' => [], ], 'UpdateJobQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePolicy' => [ 'base' => '<p>Specifies the infrastructure update policy for the compute environment. For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/infrastructure-updates.html">Infrastructure updates</a> in the <i>Batch User Guide</i>.</p>', 'refs' => [ 'ComputeEnvironmentDetail$updatePolicy' => '<p>Specifies the infrastructure update policy for the compute environment. For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p>', 'UpdateComputeEnvironmentRequest$updatePolicy' => '<p>Specifies the updated infrastructure update policy for the compute environment. For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <i>Batch User Guide</i>.</p>', ], ], 'UpdateSchedulingPolicyRequest' => [ 'base' => '<p>Contains the parameters for <code>UpdateSchedulingPolicy</code>.</p>', 'refs' => [], ], 'UpdateSchedulingPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Volume' => [ 'base' => '<p>A data volume used in a job\'s container properties.</p>', 'refs' => [ 'Volumes$member' => NULL, ], ], 'Volumes' => [ 'base' => NULL, 'refs' => [ 'ContainerDetail$volumes' => '<p>A list of volumes associated with the job.</p>', 'ContainerProperties$volumes' => '<p>A list of data volumes used in a job.</p>', ], ], ],];
