<?php
// This file was auto-generated from sdk-root/src/data/sso-admin/2020-07-20/docs-2.json
return [ 'version' => '2.0', 'service' => '<p/>', 'operations' => [ 'AttachCustomerManagedPolicyReferenceToPermissionSet' => '<p>Attaches the specified customer managed policy to the specified <a>PermissionSet</a>.</p>', 'AttachManagedPolicyToPermissionSet' => '<p>Attaches an Amazon Web Services managed policy ARN to a permission set.</p> <note> <p>If the permission set is already referenced by one or more account assignments, you will need to call <code> <a>ProvisionPermissionSet</a> </code> after this operation. Calling <code>ProvisionPermissionSet</code> applies the corresponding IAM policy updates to all assigned accounts.</p> </note>', 'CreateAccountAssignment' => '<p>Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.</p> <note> <p>The term <i>principal</i> here refers to a user or group that is defined in Amazon Web Services SSO.</p> </note> <note> <p>As part of a successful <code>CreateAccountAssignment</code> call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role created in Amazon Web Services SSO. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call <code> <a>ProvisionPermissionSet</a> </code> to make these updates.</p> </note>', 'CreateInstanceAccessControlAttributeConfiguration' => '<p>Enables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>', 'CreatePermissionSet' => '<p>Creates a permission set within a specified Amazon Web Services SSO instance.</p> <note> <p>To grant users and groups access to Amazon Web Services account resources, use <code> <a>CreateAccountAssignment</a> </code>.</p> </note>', 'DeleteAccountAssignment' => '<p>Deletes a principal\'s access from a specified Amazon Web Services account using a specified permission set.</p>', 'DeleteInlinePolicyFromPermissionSet' => '<p>Deletes the inline policy from a specified permission set.</p>', 'DeleteInstanceAccessControlAttributeConfiguration' => '<p>Disables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>', 'DeletePermissionSet' => '<p>Deletes the specified permission set.</p>', 'DeletePermissionsBoundaryFromPermissionSet' => '<p>Deletes the permissions boundary from a specified <a>PermissionSet</a>.</p>', 'DescribeAccountAssignmentCreationStatus' => '<p>Describes the status of the assignment creation request.</p>', 'DescribeAccountAssignmentDeletionStatus' => '<p>Describes the status of the assignment deletion request.</p>', 'DescribeInstanceAccessControlAttributeConfiguration' => '<p>Returns the list of Amazon Web Services SSO identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified Amazon Web Services SSO instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>', 'DescribePermissionSet' => '<p>Gets the details of the permission set.</p>', 'DescribePermissionSetProvisioningStatus' => '<p>Describes the status for the given permission set provisioning request.</p>', 'DetachCustomerManagedPolicyReferenceFromPermissionSet' => '<p>Detaches the specified customer managed policy from the specified <a>PermissionSet</a>.</p>', 'DetachManagedPolicyFromPermissionSet' => '<p>Detaches the attached Amazon Web Services managed policy ARN from the specified permission set.</p>', 'GetInlinePolicyForPermissionSet' => '<p>Obtains the inline policy assigned to the permission set.</p>', 'GetPermissionsBoundaryForPermissionSet' => '<p>Obtains the permissions boundary for a specified <a>PermissionSet</a>.</p>', 'ListAccountAssignmentCreationStatus' => '<p>Lists the status of the Amazon Web Services account assignment creation requests for a specified Amazon Web Services SSO instance.</p>', 'ListAccountAssignmentDeletionStatus' => '<p>Lists the status of the Amazon Web Services account assignment deletion requests for a specified Amazon Web Services SSO instance.</p>', 'ListAccountAssignments' => '<p>Lists the assignee of the specified Amazon Web Services account with the specified permission set.</p>', 'ListAccountsForProvisionedPermissionSet' => '<p>Lists all the Amazon Web Services accounts where the specified permission set is provisioned.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSet' => '<p>Lists all customer managed policies attached to a specified <a>PermissionSet</a>.</p>', 'ListInstances' => '<p>Lists the Amazon Web Services SSO instances that the caller has access to.</p>', 'ListManagedPoliciesInPermissionSet' => '<p>Lists the Amazon Web Services managed policy that is attached to a specified permission set.</p>', 'ListPermissionSetProvisioningStatus' => '<p>Lists the status of the permission set provisioning requests for a specified Amazon Web Services SSO instance.</p>', 'ListPermissionSets' => '<p>Lists the <a>PermissionSet</a>s in an Amazon Web Services SSO instance.</p>', 'ListPermissionSetsProvisionedToAccount' => '<p>Lists all the permission sets that are provisioned to a specified Amazon Web Services account.</p>', 'ListTagsForResource' => '<p>Lists the tags that are attached to a specified resource.</p>', 'ProvisionPermissionSet' => '<p>The process by which a specified permission set is provisioned to the specified target.</p>', 'PutInlinePolicyToPermissionSet' => '<p>Attaches an inline policy to a permission set.</p> <note> <p>If the permission set is already referenced by one or more account assignments, you will need to call <code> <a>ProvisionPermissionSet</a> </code> after this action to apply the corresponding IAM policy updates to all assigned accounts.</p> </note>', 'PutPermissionsBoundaryToPermissionSet' => '<p>Attaches an Amazon Web Services managed or customer managed policy to the specified <a>PermissionSet</a> as a permissions boundary.</p>', 'TagResource' => '<p>Associates a set of tags with a specified resource.</p>', 'UntagResource' => '<p>Disassociates a set of tags from a specified resource.</p>', 'UpdateInstanceAccessControlAttributeConfiguration' => '<p>Updates the Amazon Web Services SSO identity store attributes that you can use with the Amazon Web Services SSO instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO replaces the attribute value with the value from the Amazon Web Services SSO identity store. For more information about ABAC, see <a href="/singlesignon/latest/userguide/abac.html">Attribute-Based Access Control</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>', 'UpdatePermissionSet' => '<p>Updates an existing permission set.</p>', ], 'shapes' => [ 'AccessControlAttribute' => [ 'base' => '<p>These are Amazon Web Services SSO identity store attributes that you can configure for use in attributes-based access control (ABAC). You can create permissions policies that determine who can access your Amazon Web Services resources based upon the configured attribute values. When you enable ABAC and specify <code>AccessControlAttributes</code>, Amazon Web Services SSO passes the attribute values of the authenticated user into IAM for use in policy evaluation.</p>', 'refs' => [ 'AccessControlAttributeList$member' => NULL, ], ], 'AccessControlAttributeKey' => [ 'base' => NULL, 'refs' => [ 'AccessControlAttribute$Key' => '<p>The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in Amazon Web Services SSO.</p>', ], ], 'AccessControlAttributeList' => [ 'base' => NULL, 'refs' => [ 'InstanceAccessControlAttributeConfiguration$AccessControlAttributes' => '<p>Lists the attributes that are configured for ABAC in the specified Amazon Web Services SSO instance.</p>', ], ], 'AccessControlAttributeValue' => [ 'base' => '<p>The value used for mapping a specified attribute to an identity source. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/attributemappingsconcept.html">Attribute mappings</a> in the <i>Amazon Web Services SSO User Guide</i>.</p>', 'refs' => [ 'AccessControlAttribute$Value' => '<p>The value used for mapping a specified attribute to an identity source.</p>', ], ], 'AccessControlAttributeValueSource' => [ 'base' => NULL, 'refs' => [ 'AccessControlAttributeValueSourceList$member' => NULL, ], ], 'AccessControlAttributeValueSourceList' => [ 'base' => NULL, 'refs' => [ 'AccessControlAttributeValue$Source' => '<p>The identity source to use when mapping a specified attribute to Amazon Web Services SSO.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccessDeniedExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, ], ], 'AccountAssignment' => [ 'base' => '<p>The assignment that indicates a principal\'s limited access to a specified Amazon Web Services account with a specified permission set.</p> <note> <p>The term <i>principal</i> here refers to a user or group that is defined in Amazon Web Services SSO.</p> </note>', 'refs' => [ 'AccountAssignmentList$member' => NULL, ], ], 'AccountAssignmentList' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssignmentsResponse$AccountAssignments' => '<p>The list of assignments that match the input Amazon Web Services account and permission set.</p>', ], ], 'AccountAssignmentOperationStatus' => [ 'base' => '<p>The status of the creation or deletion operation of an assignment that a principal needs to access an account.</p>', 'refs' => [ 'CreateAccountAssignmentResponse$AccountAssignmentCreationStatus' => '<p>The status object for the account assignment creation operation.</p>', 'DeleteAccountAssignmentResponse$AccountAssignmentDeletionStatus' => '<p>The status object for the account assignment deletion operation.</p>', 'DescribeAccountAssignmentCreationStatusResponse$AccountAssignmentCreationStatus' => '<p>The status object for the account assignment creation operation.</p>', 'DescribeAccountAssignmentDeletionStatusResponse$AccountAssignmentDeletionStatus' => '<p>The status object for the account assignment deletion operation.</p>', ], ], 'AccountAssignmentOperationStatusList' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssignmentCreationStatusResponse$AccountAssignmentsCreationStatus' => '<p>The status object for the account assignment creation operation.</p>', 'ListAccountAssignmentDeletionStatusResponse$AccountAssignmentsDeletionStatus' => '<p>The status object for the account assignment deletion operation.</p>', ], ], 'AccountAssignmentOperationStatusMetadata' => [ 'base' => '<p>Provides information about the <a>AccountAssignment</a> creation request.</p>', 'refs' => [ 'AccountAssignmentOperationStatusList$member' => NULL, ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountAssignment$AccountId' => '<p>The identifier of the Amazon Web Services account.</p>', 'AccountList$member' => NULL, 'ListPermissionSetsProvisionedToAccountRequest$AccountId' => '<p>The identifier of the Amazon Web Services account from which to list the assignments.</p>', 'PermissionSetProvisioningStatus$AccountId' => '<p>The identifier of the Amazon Web Services account from which to list the assignments.</p>', ], ], 'AccountList' => [ 'base' => NULL, 'refs' => [ 'ListAccountsForProvisionedPermissionSetResponse$AccountIds' => '<p>The list of Amazon Web Services <code>AccountIds</code>.</p>', ], ], 'AttachCustomerManagedPolicyReferenceToPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachCustomerManagedPolicyReferenceToPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttachManagedPolicyToPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AttachManagedPolicyToPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'AttachedManagedPolicy' => [ 'base' => '<p>A structure that stores the details of the Amazon Web Services managed policy.</p>', 'refs' => [ 'AttachedManagedPolicyList$member' => NULL, ], ], 'AttachedManagedPolicyList' => [ 'base' => NULL, 'refs' => [ 'ListManagedPoliciesInPermissionSetResponse$AttachedManagedPolicies' => '<p>An array of the <a>AttachedManagedPolicy</a> data type object.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Occurs when a conflict with a previous successful write is detected. This generally occurs when the previous write did not have time to propagate to the host serving the current request. A retry (with appropriate backoff logic) is the recommended response to this exception.</p>', 'refs' => [], ], 'ConflictExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Message' => NULL, ], ], 'CreateAccountAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccountAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceAccessControlAttributeConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceAccessControlAttributeConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomerManagedPolicyReference' => [ 'base' => '<p>Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each Amazon Web Services account where you want to deploy your permission set.</p>', 'refs' => [ 'AttachCustomerManagedPolicyReferenceToPermissionSetRequest$CustomerManagedPolicyReference' => '<p>Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each Amazon Web Services account where you want to deploy your permission set.</p>', 'CustomerManagedPolicyReferenceList$member' => NULL, 'DetachCustomerManagedPolicyReferenceFromPermissionSetRequest$CustomerManagedPolicyReference' => '<p>Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each Amazon Web Services account where you want to deploy your permission set.</p>', 'PermissionsBoundary$CustomerManagedPolicyReference' => '<p>Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each Amazon Web Services account where you want to deploy your permission set.</p>', ], ], 'CustomerManagedPolicyReferenceList' => [ 'base' => NULL, 'refs' => [ 'ListCustomerManagedPolicyReferencesInPermissionSetResponse$CustomerManagedPolicyReferences' => '<p>Specifies the names and paths of the customer managed policies that you have attached to your permission set.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$CreatedDate' => '<p>The date that the permission set was created.</p>', 'AccountAssignmentOperationStatusMetadata$CreatedDate' => '<p>The date that the permission set was created.</p>', 'PermissionSet$CreatedDate' => '<p>The date that the permission set was created.</p>', 'PermissionSetProvisioningStatus$CreatedDate' => '<p>The date that the permission set was created.</p>', 'PermissionSetProvisioningStatusMetadata$CreatedDate' => '<p>The date that the permission set was created.</p>', ], ], 'DeleteAccountAssignmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccountAssignmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInlinePolicyFromPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInlinePolicyFromPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceAccessControlAttributeConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceAccessControlAttributeConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionsBoundaryFromPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePermissionsBoundaryFromPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAssignmentCreationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAssignmentCreationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAssignmentDeletionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAccountAssignmentDeletionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAccessControlAttributeConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAccessControlAttributeConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePermissionSetProvisioningStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePermissionSetProvisioningStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetachCustomerManagedPolicyReferenceFromPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachCustomerManagedPolicyReferenceFromPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetachManagedPolicyFromPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DetachManagedPolicyFromPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Duration' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionSetRequest$SessionDuration' => '<p>The length of time that the application user sessions are valid in the ISO-8601 standard.</p>', 'PermissionSet$SessionDuration' => '<p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>', 'UpdatePermissionSetRequest$SessionDuration' => '<p>The length of time that the application user sessions are valid for in the ISO-8601 standard.</p>', ], ], 'GetInlinePolicyForPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInlinePolicyForPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionsBoundaryForPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPermissionsBoundaryForPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'InstanceMetadata$IdentityStoreId' => '<p>The identifier of the identity store that is connected to the Amazon Web Services SSO instance.</p>', ], ], 'InstanceAccessControlAttributeConfiguration' => [ 'base' => '<p>Specifies the attributes to add to your attribute-based access control (ABAC) configuration.</p>', 'refs' => [ 'CreateInstanceAccessControlAttributeConfigurationRequest$InstanceAccessControlAttributeConfiguration' => '<p>Specifies the Amazon Web Services SSO identity store attributes to add to your ABAC configuration. When using an external identity provider as an identity source, you can pass attributes through the SAML assertion. Doing so provides an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO will replace the attribute value with the value from the Amazon Web Services SSO identity store.</p>', 'DescribeInstanceAccessControlAttributeConfigurationResponse$InstanceAccessControlAttributeConfiguration' => '<p>Gets the list of Amazon Web Services SSO identity store attributes that have been added to your ABAC configuration.</p>', 'UpdateInstanceAccessControlAttributeConfigurationRequest$InstanceAccessControlAttributeConfiguration' => '<p>Updates the attributes for your ABAC configuration.</p>', ], ], 'InstanceAccessControlAttributeConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceAccessControlAttributeConfigurationResponse$Status' => '<p>The status of the attribute configuration process.</p>', ], ], 'InstanceAccessControlAttributeConfigurationStatusReason' => [ 'base' => NULL, 'refs' => [ 'DescribeInstanceAccessControlAttributeConfigurationResponse$StatusReason' => '<p>Provides more details about the current status of the specified attribute.</p>', ], ], 'InstanceArn' => [ 'base' => NULL, 'refs' => [ 'AttachCustomerManagedPolicyReferenceToPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. </p>', 'AttachManagedPolicyToPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CreateAccountAssignmentRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'CreateInstanceAccessControlAttributeConfigurationRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed.</p>', 'CreatePermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DeleteAccountAssignmentRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DeleteInlinePolicyFromPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DeleteInstanceAccessControlAttributeConfigurationRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed.</p>', 'DeletePermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DeletePermissionsBoundaryFromPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. </p>', 'DescribeAccountAssignmentCreationStatusRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribeAccountAssignmentDeletionStatusRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribeInstanceAccessControlAttributeConfigurationRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed.</p>', 'DescribePermissionSetProvisioningStatusRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DescribePermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DetachCustomerManagedPolicyReferenceFromPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. </p>', 'DetachManagedPolicyFromPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'GetInlinePolicyForPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'GetPermissionsBoundaryForPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. </p>', 'InstanceMetadata$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListAccountAssignmentCreationStatusRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListAccountAssignmentDeletionStatusRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListAccountAssignmentsRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListAccountsForProvisionedPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. </p>', 'ListManagedPoliciesInPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListPermissionSetProvisioningStatusRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListPermissionSetsProvisionedToAccountRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListPermissionSetsRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListTagsForResourceRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ProvisionPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'PutInlinePolicyToPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'PutPermissionsBoundaryToPermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. </p>', 'TagResourceRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'UntagResourceRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'UpdateInstanceAccessControlAttributeConfigurationRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed.</p>', 'UpdatePermissionSetRequest$InstanceArn' => '<p>The ARN of the Amazon Web Services SSO instance under which the operation will be executed. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', ], ], 'InstanceList' => [ 'base' => NULL, 'refs' => [ 'ListInstancesResponse$Instances' => '<p>Lists the Amazon Web Services SSO instances that the caller has access to.</p>', ], ], 'InstanceMetadata' => [ 'base' => '<p>Provides information about the Amazon Web Services SSO instance.</p>', 'refs' => [ 'InstanceList$member' => NULL, ], ], 'InternalFailureMessage' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$Message' => NULL, ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception, or failure with an internal server.</p>', 'refs' => [], ], 'ListAccountAssignmentCreationStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentCreationStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentDeletionStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentDeletionStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountAssignmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsForProvisionedPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccountsForProvisionedPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomerManagedPolicyReferencesInPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomerManagedPolicyReferencesInPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedPoliciesInPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedPoliciesInPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetProvisioningStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetProvisioningStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetsProvisionedToAccountRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetsProvisionedToAccountResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPermissionSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ManagedPolicyArn' => [ 'base' => NULL, 'refs' => [ 'AttachManagedPolicyToPermissionSetRequest$ManagedPolicyArn' => '<p>The Amazon Web Services managed policy ARN to be attached to a permission set.</p>', 'AttachedManagedPolicy$Arn' => '<p>The ARN of the Amazon Web Services managed policy. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'DetachManagedPolicyFromPermissionSetRequest$ManagedPolicyArn' => '<p>The Amazon Web Services managed policy ARN to be detached from a permission set.</p>', 'PermissionsBoundary$ManagedPolicyArn' => '<p>The Amazon Web Services managed policy ARN that you want to attach to a permission set as a permissions boundary.</p>', ], ], 'ManagedPolicyName' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedPolicyReference$Name' => '<p>The name of the IAM policy that you have configured in each account where you want to deploy your permission set.</p>', ], ], 'ManagedPolicyPath' => [ 'base' => NULL, 'refs' => [ 'CustomerManagedPolicyReference$Path' => '<p>The path to the IAM policy that you have configured in each account where you want to deploy your permission set. The default is <code>/</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <i>Identity and Access Management User Guide</i>.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssignmentCreationStatusRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListAccountAssignmentDeletionStatusRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListAccountAssignmentsRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListAccountsForProvisionedPermissionSetRequest$MaxResults' => '<p>The maximum number of results to display for the <a>PermissionSet</a>.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetRequest$MaxResults' => '<p>The maximum number of results to display for the list call.</p>', 'ListInstancesRequest$MaxResults' => '<p>The maximum number of results to display for the instance.</p>', 'ListManagedPoliciesInPermissionSetRequest$MaxResults' => '<p>The maximum number of results to display for the <a>PermissionSet</a>.</p>', 'ListPermissionSetProvisioningStatusRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListPermissionSetsProvisionedToAccountRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', 'ListPermissionSetsRequest$MaxResults' => '<p>The maximum number of results to display for the assignment.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'AttachedManagedPolicy$Name' => '<p>The name of the Amazon Web Services managed policy.</p>', ], ], 'OperationStatusFilter' => [ 'base' => '<p>Filters he operation status list based on the passed attribute value.</p>', 'refs' => [ 'ListAccountAssignmentCreationStatusRequest$Filter' => '<p>Filters results based on the passed attribute value.</p>', 'ListAccountAssignmentDeletionStatusRequest$Filter' => '<p>Filters results based on the passed attribute value.</p>', 'ListPermissionSetProvisioningStatusRequest$Filter' => '<p>Filters results based on the passed attribute value.</p>', ], ], 'PermissionSet' => [ 'base' => '<p>An entity that contains IAM policies.</p>', 'refs' => [ 'CreatePermissionSetResponse$PermissionSet' => '<p>Defines the level of access on an Amazon Web Services account.</p>', 'DescribePermissionSetResponse$PermissionSet' => '<p>Describes the level of access on an Amazon Web Services account.</p>', ], ], 'PermissionSetArn' => [ 'base' => NULL, 'refs' => [ 'AccountAssignment$PermissionSetArn' => '<p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'AccountAssignmentOperationStatus$PermissionSetArn' => '<p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'AttachCustomerManagedPolicyReferenceToPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'AttachManagedPolicyToPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <a>PermissionSet</a> that the managed policy should be attached to.</p>', 'CreateAccountAssignmentRequest$PermissionSetArn' => '<p>The ARN of the permission set that the admin wants to grant the principal access to.</p>', 'DeleteAccountAssignmentRequest$PermissionSetArn' => '<p>The ARN of the permission set that will be used to remove access.</p>', 'DeleteInlinePolicyFromPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set that will be used to remove access.</p>', 'DeletePermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set that should be deleted.</p>', 'DeletePermissionsBoundaryFromPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'DescribePermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set. </p>', 'DetachCustomerManagedPolicyReferenceFromPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'DetachManagedPolicyFromPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <a>PermissionSet</a> from which the policy should be detached.</p>', 'GetInlinePolicyForPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set.</p>', 'GetPermissionsBoundaryForPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'ListAccountAssignmentsRequest$PermissionSetArn' => '<p>The ARN of the permission set from which to list assignments.</p>', 'ListAccountsForProvisionedPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <a>PermissionSet</a> from which the associated Amazon Web Services accounts will be listed.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>. </p>', 'ListManagedPoliciesInPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <a>PermissionSet</a> whose managed policies will be listed.</p>', 'PermissionSet$PermissionSetArn' => '<p>The ARN of the permission set. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'PermissionSetList$member' => NULL, 'PermissionSetProvisioningStatus$PermissionSetArn' => '<p>The ARN of the permission set that is being provisioned. For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ProvisionPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set.</p>', 'PutInlinePolicyToPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set.</p>', 'PutPermissionsBoundaryToPermissionSetRequest$PermissionSetArn' => '<p>The ARN of the <code>PermissionSet</code>.</p>', 'UpdatePermissionSetRequest$PermissionSetArn' => '<p>The ARN of the permission set.</p>', ], ], 'PermissionSetDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionSetRequest$Description' => '<p>The description of the <a>PermissionSet</a>.</p>', 'PermissionSet$Description' => '<p>The description of the <a>PermissionSet</a>.</p>', 'UpdatePermissionSetRequest$Description' => '<p>The description of the <a>PermissionSet</a>.</p>', ], ], 'PermissionSetList' => [ 'base' => NULL, 'refs' => [ 'ListPermissionSetsProvisionedToAccountResponse$PermissionSets' => '<p>Defines the level of access that an Amazon Web Services account has.</p>', 'ListPermissionSetsResponse$PermissionSets' => '<p>Defines the level of access on an Amazon Web Services account.</p>', ], ], 'PermissionSetName' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionSetRequest$Name' => '<p>The name of the <a>PermissionSet</a>.</p>', 'PermissionSet$Name' => '<p>The name of the permission set.</p>', ], ], 'PermissionSetPolicyDocument' => [ 'base' => NULL, 'refs' => [ 'GetInlinePolicyForPermissionSetResponse$InlinePolicy' => '<p>The inline policy that is attached to the permission set.</p>', 'PutInlinePolicyToPermissionSetRequest$InlinePolicy' => '<p>The inline policy to attach to a <a>PermissionSet</a>.</p>', ], ], 'PermissionSetProvisioningStatus' => [ 'base' => '<p>A structure that is used to provide the status of the provisioning operation for a specified permission set.</p>', 'refs' => [ 'DescribePermissionSetProvisioningStatusResponse$PermissionSetProvisioningStatus' => '<p>The status object for the permission set provisioning operation.</p>', 'ProvisionPermissionSetResponse$PermissionSetProvisioningStatus' => '<p>The status object for the permission set provisioning operation.</p>', ], ], 'PermissionSetProvisioningStatusList' => [ 'base' => NULL, 'refs' => [ 'ListPermissionSetProvisioningStatusResponse$PermissionSetsProvisioningStatus' => '<p>The status object for the permission set provisioning operation.</p>', ], ], 'PermissionSetProvisioningStatusMetadata' => [ 'base' => '<p>Provides information about the permission set provisioning status.</p>', 'refs' => [ 'PermissionSetProvisioningStatusList$member' => NULL, ], ], 'PermissionsBoundary' => [ 'base' => '<p>Specifies the configuration of the Amazon Web Services managed or customer managed policy that you want to set as a permissions boundary. Specify either <code>CustomerManagedPolicyReference</code> to use the name and path of a customer managed policy, or <code>ManagedPolicyArn</code> to use the ARN of an Amazon Web Services managed policy. A permissions boundary represents the maximum permissions that any policy can grant your role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM entities</a> in the <i>Identity and Access Management User Guide</i>.</p> <important> <p>Policies used as permissions boundaries don\'t provide permissions. You must also attach an IAM policy to the role. To learn how the effective permissions for a role are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy evaluation logic</a> in the <i>Identity and Access Management User Guide</i>.</p> </important>', 'refs' => [ 'GetPermissionsBoundaryForPermissionSetResponse$PermissionsBoundary' => '<p>The permissions boundary attached to the specified permission set.</p>', 'PutPermissionsBoundaryToPermissionSetRequest$PermissionsBoundary' => '<p>The permissions boundary that you want to attach to a <code>PermissionSet</code>.</p>', ], ], 'PrincipalId' => [ 'base' => NULL, 'refs' => [ 'AccountAssignment$PrincipalId' => '<p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>', 'AccountAssignmentOperationStatus$PrincipalId' => '<p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>', 'CreateAccountAssignmentRequest$PrincipalId' => '<p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>', 'DeleteAccountAssignmentRequest$PrincipalId' => '<p>An identifier for an object in Amazon Web Services SSO, such as a user or group. PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6). For more information about PrincipalIds in Amazon Web Services SSO, see the <a href="/singlesignon/latest/IdentityStoreAPIReference/welcome.html">Amazon Web Services SSO Identity Store API Reference</a>.</p>', ], ], 'PrincipalType' => [ 'base' => NULL, 'refs' => [ 'AccountAssignment$PrincipalType' => '<p>The entity type for which the assignment will be created.</p>', 'AccountAssignmentOperationStatus$PrincipalType' => '<p>The entity type for which the assignment will be created.</p>', 'CreateAccountAssignmentRequest$PrincipalType' => '<p>The entity type for which the assignment will be created.</p>', 'DeleteAccountAssignmentRequest$PrincipalType' => '<p>The entity type for which the assignment will be deleted.</p>', ], ], 'ProvisionPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ProvisionTargetType' => [ 'base' => NULL, 'refs' => [ 'ProvisionPermissionSetRequest$TargetType' => '<p>The entity type for which the assignment will be created.</p>', ], ], 'ProvisioningStatus' => [ 'base' => NULL, 'refs' => [ 'ListAccountsForProvisionedPermissionSetRequest$ProvisioningStatus' => '<p>The permission set provisioning status for an Amazon Web Services account.</p>', 'ListPermissionSetsProvisionedToAccountRequest$ProvisioningStatus' => '<p>The status object for the permission set provisioning operation.</p>', ], ], 'PutInlinePolicyToPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutInlinePolicyToPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutPermissionsBoundaryToPermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPermissionsBoundaryToPermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'Reason' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$FailureReason' => '<p>The message that contains an error or exception in case of an operation failure.</p>', 'PermissionSetProvisioningStatus$FailureReason' => '<p>The message that contains an error or exception in case of an operation failure.</p>', ], ], 'RelayState' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionSetRequest$RelayState' => '<p>Used to redirect users within the application during the federation authentication process.</p>', 'PermissionSet$RelayState' => '<p>Used to redirect users within the application during the federation authentication process.</p>', 'UpdatePermissionSetRequest$RelayState' => '<p>Used to redirect users within the application during the federation authentication process.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Indicates that a requested resource is not found.</p>', 'refs' => [], ], 'ResourceNotFoundMessage' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$Message' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Indicates that the principal has crossed the permitted number of resources that can be created.</p>', 'refs' => [], ], 'ServiceQuotaExceededMessage' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$Message' => NULL, ], ], 'StatusValues' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$Status' => '<p>The status of the permission set provisioning process.</p>', 'AccountAssignmentOperationStatusMetadata$Status' => '<p>The status of the permission set provisioning process.</p>', 'OperationStatusFilter$Status' => '<p>Filters the list operations result based on the status attribute.</p>', 'PermissionSetProvisioningStatus$Status' => '<p>The status of the permission set provisioning process.</p>', 'PermissionSetProvisioningStatusMetadata$Status' => '<p>The status of the permission set provisioning process.</p>', ], ], 'Tag' => [ 'base' => '<p>A set of key-value pairs that are used to manage the resource. Tags can only be applied to permission sets and cannot be applied to corresponding roles that Amazon Web Services SSO creates in Amazon Web Services accounts.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key for the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of tags that are attached to the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreatePermissionSetRequest$Tags' => '<p>The tags to attach to the new <a>PermissionSet</a>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A set of key-value pairs that are used to manage the resource.</p>', 'TagResourceRequest$Tags' => '<p>A set of key-value pairs that are used to manage the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value of the tag.</p>', ], ], 'TaggableResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>The ARN of the resource with the tags to be listed.</p>', 'TagResourceRequest$ResourceArn' => '<p>The ARN of the resource with the tags to be listed.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The ARN of the resource with the tags to be listed.</p>', ], ], 'TargetId' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$TargetId' => '<p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>', 'CreateAccountAssignmentRequest$TargetId' => '<p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>', 'DeleteAccountAssignmentRequest$TargetId' => '<p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>', 'ListAccountAssignmentsRequest$AccountId' => '<p>The identifier of the Amazon Web Services account from which to list the assignments.</p>', 'ProvisionPermissionSetRequest$TargetId' => '<p>TargetID is an Amazon Web Services account identifier, typically a 10-12 digit string (For example, 123456789012).</p>', ], ], 'TargetType' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$TargetType' => '<p>The entity type for which the assignment will be created.</p>', 'CreateAccountAssignmentRequest$TargetType' => '<p>The entity type for which the assignment will be created.</p>', 'DeleteAccountAssignmentRequest$TargetType' => '<p>The entity type for which the assignment will be deleted.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>Indicates that the principal has crossed the throttling limits of the API operations.</p>', 'refs' => [], ], 'ThrottlingExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ThrottlingException$Message' => NULL, ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'ListAccountAssignmentCreationStatusRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentCreationStatusResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentDeletionStatusRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentDeletionStatusResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentsRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountAssignmentsResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountsForProvisionedPermissionSetRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListAccountsForProvisionedPermissionSetResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListCustomerManagedPolicyReferencesInPermissionSetResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListInstancesRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListInstancesResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListManagedPoliciesInPermissionSetRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListManagedPoliciesInPermissionSetResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetProvisioningStatusRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetProvisioningStatusResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetsProvisionedToAccountRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetsProvisionedToAccountResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetsRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListPermissionSetsResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListTagsForResourceRequest$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', 'ListTagsForResourceResponse$NextToken' => '<p>The pagination token for the list API. Initially the value is null. Use the output of previous API calls to make subsequent calls.</p>', ], ], 'UUId' => [ 'base' => NULL, 'refs' => [ 'AccountAssignmentOperationStatus$RequestId' => '<p>The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.</p>', 'AccountAssignmentOperationStatusMetadata$RequestId' => '<p>The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.</p>', 'DescribeAccountAssignmentCreationStatusRequest$AccountAssignmentCreationRequestId' => '<p>The identifier that is used to track the request operation progress.</p>', 'DescribeAccountAssignmentDeletionStatusRequest$AccountAssignmentDeletionRequestId' => '<p>The identifier that is used to track the request operation progress.</p>', 'DescribePermissionSetProvisioningStatusRequest$ProvisionPermissionSetRequestId' => '<p>The identifier that is provided by the <a>ProvisionPermissionSet</a> call to retrieve the current status of the provisioning workflow.</p>', 'PermissionSetProvisioningStatus$RequestId' => '<p>The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.</p>', 'PermissionSetProvisioningStatusMetadata$RequestId' => '<p>The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceAccessControlAttributeConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceAccessControlAttributeConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePermissionSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePermissionSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The request failed because it contains a syntax error.</p>', 'refs' => [], ], 'ValidationExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Message' => NULL, ], ], ],];
