<?php
// This file was auto-generated from sdk-root/src/data/m2/2021-04-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services Mainframe Modernization provides tools and resources to help you plan and implement migration and modernization from mainframes to Amazon Web Services managed runtime environments. It provides tools for analyzing existing mainframe applications, developing or updating mainframe applications using COBOL or PL/I, and implementing an automated pipeline for continuous integration and continuous delivery (CI/CD) of the applications.</p>', 'operations' => [ 'CancelBatchJobExecution' => '<p>Cancels the running of a specific batch job execution.</p>', 'CreateApplication' => '<p>Creates a new application with given parameters. Requires an existing environment and application definition file.</p>', 'CreateDataSetImportTask' => '<p>Starts a data set import task for a specific application.</p>', 'CreateDeployment' => '<p>Creates and starts a deployment to deploy an application into an environment.</p>', 'CreateEnvironment' => '<p>Creates a runtime environment for a given runtime engine.</p>', 'DeleteApplication' => '<p>Deletes a specific application. You cannot delete a running application.</p>', 'DeleteApplicationFromEnvironment' => '<p>Deletes a specific application from a specified environment where it has been previously deployed. You cannot delete an environment using DeleteEnvironment, if any application has ever been deployed to it. This API removes the association of the application with the environment so you can delete the environment smoothly.</p>', 'DeleteEnvironment' => '<p>Deletes a specific environment. The environment cannot contain deployed applications. If it does, you must delete those applications before you delete the environment.</p>', 'GetApplication' => '<p>Describes the details of a specific application.</p>', 'GetApplicationVersion' => '<p>Returns details about a specific version of a specific application.</p>', 'GetBatchJobExecution' => '<p>Gets the details of a specific batch job execution for a specific application.</p>', 'GetDataSetDetails' => '<p>Gets the details of a specific data set.</p>', 'GetDataSetImportTask' => '<p>Gets the status of a data set import task initiated with the <a>CreateDataSetImportTask</a> operation.</p>', 'GetDeployment' => '<p>Gets details of a specific deployment with a given deployment identifier.</p>', 'GetEnvironment' => '<p>Describes a specific runtime environment.</p>', 'ListApplicationVersions' => '<p>Returns a list of the application versions for a specific application.</p>', 'ListApplications' => '<p>Lists the applications associated with a specific Amazon Web Services account. You can provide the unique identifier of a specific environment in a query parameter to see all applications associated with that environment.</p>', 'ListBatchJobDefinitions' => '<p>Lists all the available batch job definitions based on the batch job resources uploaded during the application creation. The listed batch job definitions can then be used to start a batch job.</p>', 'ListBatchJobExecutions' => '<p>Lists historical, current, and scheduled batch job executions for a specific application.</p>', 'ListDataSetImportHistory' => '<p>Lists the data set imports for the specified application.</p>', 'ListDataSets' => '<p>Lists the data sets imported for a specific application. In Amazon Web Services Mainframe Modernization, data sets are associated with applications deployed on environments. This is known as importing data sets. Currently, Amazon Web Services Mainframe Modernization can import data sets into catalogs using <a href="https://docs.aws.amazon.com/m2/latest/APIReference/API_CreateDataSetImportTask.html">CreateDataSetImportTask</a>.</p>', 'ListDeployments' => '<p>Returns a list of all deployments of a specific application. A deployment is a combination of a specific application and a specific version of that application. Each deployment is mapped to a particular application version.</p>', 'ListEngineVersions' => '<p>Lists the available engine versions.</p>', 'ListEnvironments' => '<p>Lists the runtime environments.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p>', 'StartApplication' => '<p>Starts an application that is currently stopped.</p>', 'StartBatchJob' => '<p>Starts a batch job and returns the unique identifier of this execution of the batch job. The associated application must be running in order to start the batch job.</p>', 'StopApplication' => '<p>Stops a running application.</p>', 'TagResource' => '<p>Adds one or more tags to the specified resource.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified resource.</p>', 'UpdateApplication' => '<p>Updates an application and creates a new version.</p>', 'UpdateEnvironment' => '<p>Updates the configuration details for a specific environment.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The account or role doesn\'t have the right permissions to make the request.</p>', 'refs' => [], ], 'AlternateKey' => [ 'base' => '<p>Defines an alternate key. This value is optional. A legacy data set might not have any alternate key defined but if those alternate keys definitions exist, provide them, as some applications will make use of them.</p>', 'refs' => [ 'AlternateKeyList$member' => NULL, ], ], 'AlternateKeyList' => [ 'base' => NULL, 'refs' => [ 'VsamAttributes$alternateKeys' => '<p>The alternate key definitions, if any. A legacy dataset might not have any alternate key defined, but if those alternate keys definitions exist, provide them as some applications will make use of them.</p>', 'VsamDetailAttributes$alternateKeys' => '<p>The alternate key definitions, if any. A legacy dataset might not have any alternate key defined, but if those alternate keys definitions exist, provide them as some applications will make use of them.</p>', ], ], 'ApplicationDeploymentLifecycle' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$deploymentStatus' => '<p>Indicates whether there is an ongoing deployment or if the application has ever deployed successfully.</p>', ], ], 'ApplicationLifecycle' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$status' => '<p>The status of the application.</p>', 'GetApplicationResponse$status' => '<p>The status of the application.</p>', ], ], 'ApplicationSummary' => [ 'base' => '<p>A subset of the possible application attributes. Used in the application list.</p>', 'refs' => [ 'ApplicationSummaryList$member' => NULL, ], ], 'ApplicationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsResponse$applications' => '<p>Returns a list of summary details for all the applications in an environment.</p>', ], ], 'ApplicationVersionLifecycle' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$versionStatus' => '<p>Indicates the status of the latest version of the application.</p>', 'ApplicationVersionSummary$status' => '<p>The status of the application.</p>', 'GetApplicationVersionResponse$status' => '<p>The status of the application version.</p>', ], ], 'ApplicationVersionSummary' => [ 'base' => '<p>Defines an application version summary.</p>', 'refs' => [ 'ApplicationVersionSummaryList$member' => NULL, 'GetApplicationResponse$latestVersion' => '<p>The latest version of the application.</p>', ], ], 'ApplicationVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationVersionsResponse$applicationVersions' => '<p>The list of application versions.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$applicationArn' => '<p>The Amazon Resource Name (ARN) of the application.</p>', 'ArnList$member' => NULL, 'CreateApplicationResponse$applicationArn' => '<p>The Amazon Resource Name (ARN) of the application.</p>', 'EnvironmentSummary$environmentArn' => '<p>The Amazon Resource Name (ARN) of a particular runtime environment.</p>', 'GetApplicationResponse$applicationArn' => '<p>The Amazon Resource Name (ARN) of the application.</p>', 'GetEnvironmentResponse$environmentArn' => '<p>The Amazon Resource Name (ARN) of the runtime environment.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'GetApplicationResponse$listenerArns' => '<p>The Amazon Resource Name (ARN) for the network load balancer listener created in your Amazon Web Services account. Amazon Web Services Mainframe Modernization creates this listener on your behalf the first time you deploy an application.</p>', 'GetApplicationResponse$targetGroupArns' => '<p>Returns the Amazon Resource Names (ARNs) of the target groups that are attached to the network load balancer.</p>', ], ], 'BatchJobDefinition' => [ 'base' => '<p>Defines the details of a batch job.</p>', 'refs' => [ 'BatchJobDefinitions$member' => NULL, ], ], 'BatchJobDefinitions' => [ 'base' => NULL, 'refs' => [ 'ListBatchJobDefinitionsResponse$batchJobDefinitions' => '<p>The list of batch job definitions.</p>', ], ], 'BatchJobExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'BatchJobExecutionSummary$status' => '<p>The status of a particular batch job execution.</p>', 'GetBatchJobExecutionResponse$status' => '<p>The status of the batch job execution.</p>', 'ListBatchJobExecutionsRequest$status' => '<p>The status of the batch job executions.</p>', ], ], 'BatchJobExecutionSummary' => [ 'base' => '<p>A subset of the possible batch job attributes. Used in the batch job list.</p>', 'refs' => [ 'BatchJobExecutionSummaryList$member' => NULL, ], ], 'BatchJobExecutionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListBatchJobExecutionsResponse$batchJobExecutions' => '<p>Returns a list of batch job executions for an application.</p>', ], ], 'BatchJobIdentifier' => [ 'base' => '<p>Identifies a specific batch job.</p>', 'refs' => [ 'StartBatchJobRequest$batchJobIdentifier' => '<p>The unique identifier of the batch job.</p>', ], ], 'BatchJobParametersMap' => [ 'base' => '<p>Job parameters are optional. Can contain up to 500 entries.</p>', 'refs' => [ 'StartBatchJobRequest$jobParams' => '<p>The collection of batch job parameters. For details about limits for keys and values, see <a href="https://www.ibm.com/docs/en/workload-automation/9.3.0?topic=zos-coding-variables-in-jcl">Coding variables in JCL</a>.</p>', ], ], 'BatchJobType' => [ 'base' => NULL, 'refs' => [ 'BatchJobExecutionSummary$jobType' => '<p>The type of a particular batch job execution.</p>', 'GetBatchJobExecutionResponse$jobType' => '<p>The type of job.</p>', ], ], 'BatchParamKey' => [ 'base' => '<p>Parameter key: the first character must be alphabetic. Can be of up to 8 alphanumeric characters.</p>', 'refs' => [ 'BatchJobParametersMap$key' => NULL, ], ], 'BatchParamValue' => [ 'base' => '<p>Parameter value can be of up to 44 alphanumeric characters.</p>', 'refs' => [ 'BatchJobParametersMap$value' => NULL, ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AlternateKey$allowDuplicates' => '<p>Indicates whether the alternate key values are supposed to be unique for the given data set.</p>', 'CreateEnvironmentRequest$publiclyAccessible' => '<p>Specifies whether the environment is publicly accessible.</p>', 'GetEnvironmentResponse$publiclyAccessible' => '<p>Whether applications running in this runtime environment are publicly accessible. </p>', 'StopApplicationRequest$forceStop' => '<p>Stopping an application process can take a long time. Setting this parameter to true lets you force stop the application so you don\'t need to wait until the process finishes to apply another action on the application. The default value is false.</p>', 'UpdateEnvironmentRequest$applyDuringMaintenanceWindow' => '<p>Indicates whether to update the environment during the maintenance window. The default is false. Currently, Amazon Web Services Mainframe Modernization accepts the <code>engineVersion</code> parameter only if <code>applyDuringMaintenanceWindow</code> is true. If any parameter other than <code>engineVersion</code> is provided in <code>UpdateEnvironmentRequest</code>, it will fail if <code>applyDuringMaintenanceWindow</code> is set to true.</p>', 'VsamAttributes$compressed' => '<p>Indicates whether indexes for this dataset are stored as compressed values. If you have a large data set (typically &gt; 100 Mb), consider setting this flag to True.</p>', 'VsamDetailAttributes$cacheAtStartup' => '<p>If set to True, enforces loading the data set into cache before it’s used by the application.</p>', 'VsamDetailAttributes$compressed' => '<p>Indicates whether indexes for this dataset are stored as compressed values. If you have a large data set (typically &gt; 100 Mb), consider setting this flag to True.</p>', ], ], 'CancelBatchJobExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelBatchJobExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CapacityValue' => [ 'base' => NULL, 'refs' => [ 'GetEnvironmentResponse$actualCapacity' => '<p>The number of instances included in the runtime environment. A standalone runtime environment has a maxiumum of one instance. Currently, a high availability runtime environment has a maximum of two instances. </p>', 'HighAvailabilityConfig$desiredCapacity' => '<p>The number of instances in a high availability configuration.</p>', 'UpdateEnvironmentRequest$desiredCapacity' => '<p>The desired capacity for the environment to update.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The parameters provided in the request conflict with existing resources.</p>', 'refs' => [], ], 'CreateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSetImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataSetImportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataSet' => [ 'base' => '<p>Defines a data set.</p>', 'refs' => [ 'DataSetImportItem$dataSet' => '<p>The data set.</p>', ], ], 'DataSetImportConfig' => [ 'base' => '<p>Identifies one or more data sets you want to import with the <a>CreateDataSetImportTask</a> operation.</p>', 'refs' => [ 'CreateDataSetImportTaskRequest$importConfig' => '<p>The data set import task configuration.</p>', ], ], 'DataSetImportItem' => [ 'base' => '<p>Identifies a specific data set to import from an external location.</p>', 'refs' => [ 'DataSetImportList$member' => NULL, ], ], 'DataSetImportList' => [ 'base' => NULL, 'refs' => [ 'DataSetImportConfig$dataSets' => '<p>The data sets.</p>', ], ], 'DataSetImportSummary' => [ 'base' => '<p>Represents a summary of data set imports.</p>', 'refs' => [ 'DataSetImportTask$summary' => '<p>A summary of the data set import task.</p>', 'GetDataSetImportTaskResponse$summary' => '<p>A summary of the status of the task.</p>', ], ], 'DataSetImportTask' => [ 'base' => '<p>Contains information about a data set import task.</p>', 'refs' => [ 'DataSetImportTaskList$member' => NULL, ], ], 'DataSetImportTaskList' => [ 'base' => NULL, 'refs' => [ 'ListDataSetImportHistoryResponse$dataSetImportTasks' => '<p>The data set import tasks.</p>', ], ], 'DataSetSummary' => [ 'base' => '<p>A subset of the possible data set attributes.</p>', 'refs' => [ 'DataSetsSummaryList$member' => NULL, ], ], 'DataSetTaskLifecycle' => [ 'base' => NULL, 'refs' => [ 'DataSetImportTask$status' => '<p>The status of the data set import task.</p>', 'GetDataSetImportTaskResponse$status' => '<p>The status of the task.</p>', ], ], 'DataSetsSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDataSetsResponse$dataSets' => '<p>The list of data sets, containing ionformation including the creating time, the data set name, the data set organization, the data set format, and the last time the data set was referenced or updated.</p>', ], ], 'DatasetDetailOrgAttributes' => [ 'base' => '<p>Additional details about the data set. Different attributes correspond to different data set organizations. The values are populated based on datasetOrg, storageType and backend (Blu Age or Micro Focus).</p>', 'refs' => [ 'GetDataSetDetailsResponse$dataSetOrg' => '<p>The type of data set. Possible values include VSAM, IS, PS, GDG, PO, PS, or unknown.</p>', ], ], 'DatasetOrgAttributes' => [ 'base' => '<p>Additional details about the data set. Different attributes correspond to different data set organizations. The values are populated based on datasetOrg, storageType and backend (Blu Age or Micro Focus).</p>', 'refs' => [ 'DataSet$datasetOrg' => '<p>The type of dataset. Possible values include VSAM, IS, PS, GDG, PO, PS, UNKNOWN etc.</p>', ], ], 'Definition' => [ 'base' => '<p>The application definition for a particular application. </p>', 'refs' => [ 'CreateApplicationRequest$definition' => '<p>The application definition for this application. You can specify either inline JSON or an S3 bucket location.</p>', 'UpdateApplicationRequest$definition' => '<p>The application definition for this application. You can specify either inline JSON or an S3 bucket location.</p>', ], ], 'DeleteApplicationFromEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationFromEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeployedVersionSummary' => [ 'base' => '<p>Contains a summary of a deployed application.</p>', 'refs' => [ 'GetApplicationResponse$deployedVersion' => '<p>The version of the application that is deployed.</p>', ], ], 'DeploymentLifecycle' => [ 'base' => NULL, 'refs' => [ 'DeployedVersionSummary$status' => '<p>The status of the deployment.</p>', 'DeploymentSummary$status' => '<p>The current status of the deployment.</p>', 'GetDeploymentResponse$status' => '<p>The status of the deployment.</p>', ], ], 'DeploymentList' => [ 'base' => NULL, 'refs' => [ 'ListDeploymentsResponse$deployments' => '<p>The list of deployments that is returned.</p>', ], ], 'DeploymentSummary' => [ 'base' => '<p>A subset of information about a specific deployment.</p>', 'refs' => [ 'DeploymentList$member' => NULL, ], ], 'EfsStorageConfiguration' => [ 'base' => '<p>Defines the storage configuration for an Amazon EFS file system.</p>', 'refs' => [ 'StorageConfiguration$efs' => '<p>Defines the storage configuration for an Amazon EFS file system.</p>', ], ], 'EngineType' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$engineType' => '<p>The type of the target platform for this application.</p>', 'CreateApplicationRequest$engineType' => '<p>The type of the target platform for this application.</p>', 'CreateEnvironmentRequest$engineType' => '<p>The engine type for the environment.</p>', 'EnvironmentSummary$engineType' => '<p>The target platform for the environment.</p>', 'GetApplicationResponse$engineType' => '<p>The type of the target platform for the application.</p>', 'GetEnvironmentResponse$engineType' => '<p>The target platform for the runtime environment.</p>', 'ListEngineVersionsRequest$engineType' => '<p>The type of target platform.</p>', 'ListEnvironmentsRequest$engineType' => '<p>The engine type for the environment.</p>', ], ], 'EngineVersion' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$engineVersion' => '<p>The version of the engine type for the environment.</p>', 'EnvironmentSummary$engineVersion' => '<p>The version of the runtime engine.</p>', 'GetEnvironmentResponse$engineVersion' => '<p>The version of the runtime engine.</p>', 'UpdateEnvironmentRequest$engineVersion' => '<p>The version of the runtime engine for the environment.</p>', ], ], 'EngineVersionsSummary' => [ 'base' => '<p>A subset of information about the engine version for a specific application.</p>', 'refs' => [ 'EngineVersionsSummaryList$member' => NULL, ], ], 'EngineVersionsSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEngineVersionsResponse$engineVersions' => '<p>Returns the engine versions.</p>', ], ], 'EntityDescription' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$description' => '<p>The description of the application.</p>', 'CreateApplicationRequest$description' => '<p>The description of the application.</p>', 'CreateEnvironmentRequest$description' => '<p>The description of the environment.</p>', 'GetApplicationResponse$description' => '<p>The description of the application.</p>', 'GetApplicationVersionResponse$description' => '<p>The application description.</p>', 'GetEnvironmentResponse$description' => '<p>The description of the runtime environment.</p>', 'UpdateApplicationRequest$description' => '<p>The description of the application to update.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$name' => '<p>The name of the application.</p>', 'CreateApplicationRequest$name' => '<p>The unique identifier of the application.</p>', 'CreateEnvironmentRequest$name' => '<p>The unique identifier of the environment.</p>', 'EntityNameList$member' => NULL, 'EnvironmentSummary$name' => '<p>The name of the environment.</p>', 'GetApplicationResponse$name' => '<p>The unique identifier of the application.</p>', 'GetApplicationVersionResponse$name' => '<p>The name of the application version.</p>', 'GetEnvironmentResponse$name' => '<p>The name of the runtime environment. </p>', ], ], 'EntityNameList' => [ 'base' => NULL, 'refs' => [ 'ListApplicationsRequest$names' => '<p>The names of the applications.</p>', 'ListEnvironmentsRequest$names' => '<p>The name of the environment.</p>', ], ], 'EnvironmentLifecycle' => [ 'base' => NULL, 'refs' => [ 'EnvironmentSummary$status' => '<p>The status of the environment</p>', 'GetEnvironmentResponse$status' => '<p>The status of the runtime environment.</p>', ], ], 'EnvironmentSummary' => [ 'base' => '<p>Contains a subset of the possible environment attributes. Used in the environment list.</p>', 'refs' => [ 'EnvironmentSummaryList$member' => NULL, ], ], 'EnvironmentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsResponse$environments' => '<p>Returns a list of summary details for all the environments in your account. </p>', ], ], 'ExternalLocation' => [ 'base' => '<p>Defines an external storage location.</p>', 'refs' => [ 'DataSetImportItem$externalLocation' => '<p>The location of the data set.</p>', ], ], 'FileBatchJobDefinition' => [ 'base' => '<p>A file containing a batch job definition.</p>', 'refs' => [ 'BatchJobDefinition$fileBatchJobDefinition' => '<p>Specifies a file containing a batch job definition.</p>', ], ], 'FileBatchJobIdentifier' => [ 'base' => '<p>A batch job identifier in which the batch job to run is identified by the file name and the relative path to the file name.</p>', 'refs' => [ 'BatchJobIdentifier$fileBatchJobIdentifier' => '<p>Specifies a file associated with a specific batch job.</p>', ], ], 'FsxStorageConfiguration' => [ 'base' => '<p>Defines the storage configuration for an Amazon FSx file system.</p>', 'refs' => [ 'StorageConfiguration$fsx' => '<p>Defines the storage configuration for an Amazon FSx file system.</p>', ], ], 'GdgAttributes' => [ 'base' => '<p>The required attributes for a generation data group data set. A generation data set is one of a collection of successive, historically related, catalogued data sets that together are known as a generation data group (GDG). Use this structure when you want to import a GDG. For more information on GDG, see <a href="https://www.ibm.com/docs/en/zos/2.3.0?topic=guide-generation-data-sets">Generation data sets</a>.</p>', 'refs' => [ 'DatasetOrgAttributes$gdg' => '<p>The generation data group of the data set.</p>', ], ], 'GdgDetailAttributes' => [ 'base' => '<p>The required attributes for a generation data group data set. A generation data set is one of a collection of successive, historically related, catalogued data sets that together are known as a generation data group (GDG). Use this structure when you want to import a GDG. For more information on GDG, see <a href="https://www.ibm.com/docs/en/zos/2.3.0?topic=guide-generation-data-sets">Generation data sets</a>.</p>', 'refs' => [ 'DatasetDetailOrgAttributes$gdg' => '<p>The generation data group of the data set.</p>', ], ], 'GetApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetBatchJobExecutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetBatchJobExecutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSetDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSetDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSetImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDataSetImportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDeploymentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDeploymentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'HighAvailabilityConfig' => [ 'base' => '<p>Defines the details of a high availability configuration.</p>', 'refs' => [ 'CreateEnvironmentRequest$highAvailabilityConfig' => '<p>The details of a high availability configuration for this runtime environment.</p>', 'GetEnvironmentResponse$highAvailabilityConfig' => '<p>The desired capacity of the high availability configuration for the runtime environment.</p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$applicationId' => '<p>The unique identifier of the application.</p>', 'ApplicationSummary$environmentId' => '<p>The unique identifier of the runtime environment that hosts this application.</p>', 'BatchJobExecutionSummary$applicationId' => '<p>The unique identifier of the application that hosts this batch job.</p>', 'BatchJobExecutionSummary$executionId' => '<p>The unique identifier of this execution of the batch job.</p>', 'CancelBatchJobExecutionRequest$applicationId' => '<p>The unique identifier of the application.</p>', 'CancelBatchJobExecutionRequest$executionId' => '<p>The unique identifier of the batch job execution.</p>', 'CreateApplicationResponse$applicationId' => '<p>The unique application identifier.</p>', 'CreateDataSetImportTaskRequest$applicationId' => '<p>The unique identifier of the application for which you want to import data sets.</p>', 'CreateDataSetImportTaskResponse$taskId' => '<p>The task identifier. This operation is asynchronous. Use this identifier with the <a>GetDataSetImportTask</a> operation to obtain the status of this task.</p>', 'CreateDeploymentRequest$applicationId' => '<p>The application identifier.</p>', 'CreateDeploymentRequest$environmentId' => '<p>The identifier of the environment where this application will be deployed.</p>', 'CreateDeploymentResponse$deploymentId' => '<p>The unique identifier of the deployment.</p>', 'CreateEnvironmentResponse$environmentId' => '<p>The identifier of this environment.</p>', 'DataSetImportTask$taskId' => '<p>The identifier of the data set import task.</p>', 'DeleteApplicationFromEnvironmentRequest$applicationId' => '<p>The unique identifier of the application you want to delete.</p>', 'DeleteApplicationFromEnvironmentRequest$environmentId' => '<p>The unique identifier of the runtime environment where the application was previously deployed.</p>', 'DeleteApplicationRequest$applicationId' => '<p>The unique identifier of the application you want to delete.</p>', 'DeleteEnvironmentRequest$environmentId' => '<p>The unique identifier of the runtime environment you want to delete.</p>', 'DeploymentSummary$applicationId' => '<p>The unique identifier of the application.</p>', 'DeploymentSummary$deploymentId' => '<p>The unique identifier of the deployment.</p>', 'DeploymentSummary$environmentId' => '<p>The unique identifier of the environment.</p>', 'EnvironmentSummary$environmentId' => '<p>The unique identifier of a particular runtime environment.</p>', 'GetApplicationRequest$applicationId' => '<p>The identifier of the application.</p>', 'GetApplicationResponse$applicationId' => '<p>The identifier of the application.</p>', 'GetApplicationResponse$environmentId' => '<p>The identifier of the environment where the application will be deployed.</p>', 'GetApplicationVersionRequest$applicationId' => '<p>The unique identifier of the application.</p>', 'GetBatchJobExecutionRequest$applicationId' => '<p>The identifier of the application.</p>', 'GetBatchJobExecutionRequest$executionId' => '<p>The unique identifier of the batch job execution.</p>', 'GetBatchJobExecutionResponse$applicationId' => '<p>The identifier of the application.</p>', 'GetBatchJobExecutionResponse$executionId' => '<p>The unique identifier for this batch job execution.</p>', 'GetDataSetDetailsRequest$applicationId' => '<p>The unique identifier of the application that this data set is associated with.</p>', 'GetDataSetImportTaskRequest$applicationId' => '<p>The application identifier.</p>', 'GetDataSetImportTaskRequest$taskId' => '<p>The task identifier returned by the <a>CreateDataSetImportTask</a> operation. </p>', 'GetDataSetImportTaskResponse$taskId' => '<p>The task identifier.</p>', 'GetDeploymentRequest$applicationId' => '<p>The unique identifier of the application.</p>', 'GetDeploymentRequest$deploymentId' => '<p>The unique identifier for the deployment.</p>', 'GetDeploymentResponse$applicationId' => '<p>The unique identifier of the application.</p>', 'GetDeploymentResponse$deploymentId' => '<p>The unique identifier of the deployment.</p>', 'GetDeploymentResponse$environmentId' => '<p>The unique identifier of the runtime environment.</p>', 'GetEnvironmentRequest$environmentId' => '<p>The unique identifier of the runtime environment.</p>', 'GetEnvironmentResponse$environmentId' => '<p>The unique identifier of the runtime environment.</p>', 'IdentifierList$member' => NULL, 'ListApplicationVersionsRequest$applicationId' => '<p>The unique identifier of the application.</p>', 'ListApplicationsRequest$environmentId' => '<p>The unique identifier of the runtime environment where the applications are deployed.</p>', 'ListBatchJobDefinitionsRequest$applicationId' => '<p>The identifier of the application.</p>', 'ListBatchJobExecutionsRequest$applicationId' => '<p>The unique identifier of the application.</p>', 'ListDataSetImportHistoryRequest$applicationId' => '<p>The unique identifier of the application.</p>', 'ListDataSetsRequest$applicationId' => '<p>The unique identifier of the application for which you want to list the associated data sets.</p>', 'ListDeploymentsRequest$applicationId' => '<p>The application identifier.</p>', 'StartApplicationRequest$applicationId' => '<p>The unique identifier of the application you want to start.</p>', 'StartBatchJobRequest$applicationId' => '<p>The unique identifier of the application associated with this batch job.</p>', 'StartBatchJobResponse$executionId' => '<p>The unique identifier of this execution of the batch job.</p>', 'StopApplicationRequest$applicationId' => '<p>The unique identifier of the application you want to stop.</p>', 'UpdateApplicationRequest$applicationId' => '<p>The unique identifier of the application you want to update.</p>', 'UpdateEnvironmentRequest$environmentId' => '<p>The unique identifier of the runtime environment that you want to update.</p>', 'UpdateEnvironmentResponse$environmentId' => '<p>The unique identifier of the runtime environment that was updated.</p>', ], ], 'IdentifierList' => [ 'base' => NULL, 'refs' => [ 'ListBatchJobExecutionsRequest$executionIds' => '<p>The unique identifier of each batch job execution.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AlternateKey$length' => '<p>A strictly positive integer value representing the length of the alternate key.</p>', 'AlternateKey$offset' => '<p>A positive integer value representing the offset to mark the start of the alternate key part in the record byte array.</p>', 'DataSetImportSummary$failed' => '<p>The number of data set imports that have failed.</p>', 'DataSetImportSummary$inProgress' => '<p>The number of data set imports that are in progress.</p>', 'DataSetImportSummary$pending' => '<p>The number of data set imports that are pending.</p>', 'DataSetImportSummary$succeeded' => '<p>The number of data set imports that have succeeded.</p>', 'DataSetImportSummary$total' => '<p>The total number of data set imports.</p>', 'GdgAttributes$limit' => '<p>The maximum number of generation data sets, up to 255, in a GDG.</p>', 'GdgDetailAttributes$limit' => '<p>The maximum number of generation data sets, up to 255, in a GDG.</p>', 'GetDataSetDetailsResponse$blocksize' => '<p>The size of the block on disk. </p>', 'GetDataSetDetailsResponse$recordLength' => '<p>The length of records in the data set.</p>', 'InternalServerException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the request.</p>', 'PortList$member' => NULL, 'PrimaryKey$length' => '<p>A strictly positive integer value representing the length of the primary key. </p>', 'PrimaryKey$offset' => '<p>A positive integer value representing the offset to mark the start of the primary key in the record byte array.</p>', 'RecordLength$max' => '<p>The maximum record length. In case of fixed, both minimum and maximum are the same.</p>', 'RecordLength$min' => '<p>The minimum record length of a record.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the request.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error occurred during the processing of the request.</p>', 'refs' => [], ], 'ListApplicationVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBatchJobDefinitionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBatchJobDefinitionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBatchJobExecutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBatchJobExecutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetImportHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetImportHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataSetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDeploymentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDeploymentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEngineVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEngineVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupIdentifier' => [ 'base' => NULL, 'refs' => [ 'LogGroupSummary$logGroupName' => '<p>The name of the log group.</p>', ], ], 'LogGroupSummaries' => [ 'base' => NULL, 'refs' => [ 'GetApplicationResponse$logGroups' => '<p>The list of log summaries. Each log summary includes the log type as well as the log group identifier. These are CloudWatch logs. The Amazon Web Services Mainframe Modernization application log is pushed to CloudWatch under the customer\'s account.</p>', ], ], 'LogGroupSummary' => [ 'base' => '<p>A subset of the attributes about a log group. In CloudWatch a log group is a group of log streams that share the same retention, monitoring, and access control settings.</p>', 'refs' => [ 'LogGroupSummaries$member' => NULL, ], ], 'MaintenanceSchedule' => [ 'base' => '<p>The information about the maintenance schedule.</p>', 'refs' => [ 'PendingMaintenance$schedule' => '<p>The maintenance schedule for the engine version.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListApplicationVersionsRequest$maxResults' => '<p>The maximum number of application versions to return.</p>', 'ListApplicationsRequest$maxResults' => '<p>The maximum number of applications to return.</p>', 'ListBatchJobDefinitionsRequest$maxResults' => '<p>The maximum number of batch job definitions to return.</p>', 'ListBatchJobExecutionsRequest$maxResults' => '<p>The maximum number of batch job executions to return.</p>', 'ListDataSetImportHistoryRequest$maxResults' => '<p>The maximum number of objects to return.</p>', 'ListDataSetsRequest$maxResults' => '<p>The maximum number of objects to return.</p>', 'ListDeploymentsRequest$maxResults' => '<p>The maximum number of objects to return.</p>', 'ListEngineVersionsRequest$maxResults' => '<p>The maximum number of objects to return.</p>', 'ListEnvironmentsRequest$maxResults' => '<p>The maximum number of environments to return.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListApplicationVersionsRequest$nextToken' => '<p>A pagination token returned from a previous call to this operation. This specifies the next item to return. To return to the beginning of the list, exclude this parameter.</p>', 'ListApplicationVersionsResponse$nextToken' => '<p>If there are more items to return, this contains a token that is passed to a subsequent call to this operation to retrieve the next set of items.</p>', 'ListApplicationsRequest$nextToken' => '<p>A pagination token to control the number of applications displayed in the list.</p>', 'ListApplicationsResponse$nextToken' => '<p>A pagination token that\'s returned when the response doesn\'t contain all applications.</p>', 'ListBatchJobDefinitionsRequest$nextToken' => '<p>A pagination token returned from a previous call to this operation. This specifies the next item to return. To return to the beginning of the list, exclude this parameter.</p>', 'ListBatchJobDefinitionsResponse$nextToken' => '<p>If there are more items to return, this contains a token that is passed to a subsequent call to this operation to retrieve the next set of items.</p>', 'ListBatchJobExecutionsRequest$nextToken' => '<p>A pagination token to control the number of batch job executions displayed in the list.</p>', 'ListBatchJobExecutionsResponse$nextToken' => '<p>A pagination token that\'s returned when the response doesn\'t contain all batch job executions.</p>', 'ListDataSetImportHistoryRequest$nextToken' => '<p>A pagination token returned from a previous call to this operation. This specifies the next item to return. To return to the beginning of the list, exclude this parameter.</p>', 'ListDataSetImportHistoryResponse$nextToken' => '<p>If there are more items to return, this contains a token that is passed to a subsequent call to this operation to retrieve the next set of items.</p>', 'ListDataSetsRequest$nextToken' => '<p>A pagination token returned from a previous call to this operation. This specifies the next item to return. To return to the beginning of the list, exclude this parameter.</p>', 'ListDataSetsResponse$nextToken' => '<p>If there are more items to return, this contains a token that is passed to a subsequent call to this operation to retrieve the next set of items.</p>', 'ListDeploymentsRequest$nextToken' => '<p>A pagination token returned from a previous call to this operation. This specifies the next item to return. To return to the beginning of the list, exclude this parameter.</p>', 'ListDeploymentsResponse$nextToken' => '<p>If there are more items to return, this contains a token that is passed to a subsequent call to this operation to retrieve the next set of items.</p>', 'ListEngineVersionsRequest$nextToken' => '<p>A pagination token returned from a previous call to this operation. This specifies the next item to return. To return to the beginning of the list, exclude this parameter.</p>', 'ListEngineVersionsResponse$nextToken' => '<p>If there are more items to return, this contains a token that is passed to a subsequent call to this operation to retrieve the next set of items.</p>', 'ListEnvironmentsRequest$nextToken' => '<p>A pagination token to control the number of environments displayed in the list.</p>', 'ListEnvironmentsResponse$nextToken' => '<p>A pagination token that\'s returned when the response doesn\'t contain all the environments.</p>', ], ], 'PendingMaintenance' => [ 'base' => '<p>The scheduled maintenance for a runtime engine.</p>', 'refs' => [ 'GetEnvironmentResponse$pendingMaintenance' => '<p>Indicates the pending maintenance scheduled on this environment.</p>', ], ], 'PortList' => [ 'base' => NULL, 'refs' => [ 'GetApplicationResponse$listenerPorts' => '<p>The port associated with the network load balancer listener created in your Amazon Web Services account.</p>', ], ], 'PrimaryKey' => [ 'base' => '<p>The primary key for a KSDS data set.</p>', 'refs' => [ 'VsamAttributes$primaryKey' => '<p>The primary key of the data set.</p>', 'VsamDetailAttributes$primaryKey' => '<p>The primary key of the data set.</p>', ], ], 'RecordLength' => [ 'base' => '<p>The length of the records in the data set.</p>', 'refs' => [ 'DataSet$recordLength' => '<p>The length of a record.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'ScriptBatchJobDefinition' => [ 'base' => '<p>A batch job definition contained in a script.</p>', 'refs' => [ 'BatchJobDefinition$scriptBatchJobDefinition' => '<p>A script containing a batch job definition.</p>', ], ], 'ScriptBatchJobIdentifier' => [ 'base' => '<p>A batch job identifier in which the batch job to run is identified by the script name.</p>', 'refs' => [ 'BatchJobIdentifier$scriptBatchJobIdentifier' => '<p>A batch job identifier in which the batch job to run is identified by the script name.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>One or more quotas for Amazon Web Services Mainframe Modernization exceeds the limit.</p>', 'refs' => [], ], 'StartApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartBatchJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartBatchJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StorageConfiguration' => [ 'base' => '<p>Defines the storage configuration for an environment.</p>', 'refs' => [ 'StorageConfigurationList$member' => NULL, ], ], 'StorageConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$storageConfigurations' => '<p>Optional. The storage configurations for this environment.</p>', 'GetEnvironmentResponse$storageConfigurations' => '<p>The storage configurations defined for the runtime environment.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AlternateKey$name' => '<p>The name of the alternate key.</p>', 'ApplicationVersionSummary$statusReason' => '<p>The reason for the reported status.</p>', 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the conflicting resource.</p>', 'ConflictException$resourceType' => '<p>The type of the conflicting resource.</p>', 'CreateApplicationRequest$clientToken' => '<p>Unique, case-sensitive identifier the service generates to ensure the idempotency of the request to create an application. The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same response. The service also handles deleting the clientToken after it expires. </p>', 'CreateDataSetImportTaskRequest$clientToken' => '<p> Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a data set import. The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same response. The service also handles deleting the clientToken after it expires. </p>', 'CreateDeploymentRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create a deployment. The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same response. The service also handles deleting the clientToken after it expires. </p>', 'CreateEnvironmentRequest$clientToken' => '<p>Unique, case-sensitive identifier you provide to ensure the idempotency of the request to create an environment. The service generates the clientToken when the API call is triggered. The token expires after one hour, so if you retry the API within this timeframe with the same clientToken, you will get the same response. The service also handles deleting the clientToken after it expires. </p>', 'DataSet$datasetName' => '<p>The logical identifier for a specific data set (in mainframe format).</p>', 'DataSet$relativePath' => '<p>The relative location of the data set in the database or file system. </p>', 'DataSet$storageType' => '<p>The storage type of the data set: database or file system. For Micro Focus, database corresponds to datastore and file system corresponds to EFS/FSX. For Blu Age, there is no support of file system and database corresponds to Blusam. </p>', 'DeployedVersionSummary$statusReason' => '<p>The reason for the reported status.</p>', 'DeploymentSummary$statusReason' => '<p>The reason for the reported status.</p>', 'EngineVersionsSummary$engineType' => '<p>The type of target platform for the application.</p>', 'EngineVersionsSummary$engineVersion' => '<p>The version of the engine type used by the application.</p>', 'FileBatchJobDefinition$fileName' => '<p>The name of the file containing the batch job definition.</p>', 'FileBatchJobDefinition$folderPath' => '<p>The path to the file containing the batch job definition.</p>', 'FileBatchJobIdentifier$fileName' => '<p>The file name for the batch job identifier.</p>', 'FileBatchJobIdentifier$folderPath' => '<p>The relative path to the file name for the batch job identifier.</p>', 'GdgAttributes$rollDisposition' => '<p>The disposition of the data set in the catalog.</p>', 'GetApplicationResponse$statusReason' => '<p>The reason for the reported status.</p>', 'GetApplicationVersionResponse$statusReason' => '<p>The reason for the reported status.</p>', 'GetBatchJobExecutionResponse$statusReason' => '<p>The reason for the reported status.</p>', 'GetDeploymentResponse$statusReason' => '<p>The reason for the reported status.</p>', 'GetEnvironmentResponse$loadBalancerArn' => '<p>The Amazon Resource Name (ARN) for the load balancer used with the runtime environment.</p>', 'GetEnvironmentResponse$preferredMaintenanceWindow' => '<p>Configures a desired maintenance window for the environment. If you do not provide a value, a random system-generated value will be assigned.</p>', 'GetEnvironmentResponse$statusReason' => '<p>The reason for the reported status.</p>', 'InternalServerException$message' => NULL, 'ListBatchJobDefinitionsRequest$prefix' => '<p>If the batch job definition is a FileBatchJobDefinition, the prefix allows you to search on the file names of FileBatchJobDefinitions.</p>', 'PendingMaintenance$engineVersion' => '<p>The specific runtime engine that the maintenance schedule applies to.</p>', 'PrimaryKey$name' => '<p>A name for the Primary Key.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourceNotFoundException$resourceId' => '<p>The ID of the missing resource.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of the missing resource.</p>', 'ScriptBatchJobDefinition$scriptName' => '<p>The name of the script containing the batch job definition.</p>', 'ScriptBatchJobIdentifier$scriptName' => '<p>The name of the script containing the batch job definition.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$quotaCode' => '<p>The identifier of the exceeded quota.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>The ID of the resource that is exceeding the quota limit.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The type of resource that is exceeding the quota limit for Amazon Web Services Mainframe Modernization.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>A code that identifies the service that the exceeded quota belongs to.</p>', 'ThrottlingException$message' => NULL, 'ThrottlingException$quotaCode' => '<p>The identifier of the throttled reuqest.</p>', 'ThrottlingException$serviceCode' => '<p>The identifier of the service that the throttled request was made to.</p>', 'UpdateEnvironmentRequest$preferredMaintenanceWindow' => '<p>Configures a desired maintenance window for the environment. If you do not provide a value, a random system-generated value will be assigned.</p>', 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>The message of the exception field.</p>', 'ValidationExceptionField$name' => '<p>The name of the exception field.</p>', 'VsamAttributes$encoding' => '<p>The character set used by the data set. Can be ASCII, EBCDIC, or unknown.</p>', 'VsamAttributes$format' => '<p>The record format of the data set.</p>', ], ], 'String100' => [ 'base' => NULL, 'refs' => [ 'BatchJobExecutionSummary$jobId' => '<p>The unique identifier of a particular batch job.</p>', 'BatchJobExecutionSummary$jobName' => '<p>The name of a particular batch job.</p>', 'GetApplicationResponse$loadBalancerDnsName' => '<p>The public DNS name of the load balancer created in your Amazon Web Services account.</p>', 'GetBatchJobExecutionResponse$jobId' => '<p>The unique identifier for this batch job.</p>', 'GetBatchJobExecutionResponse$jobName' => '<p>The name of this batch job.</p>', 'GetBatchJobExecutionResponse$jobUser' => '<p>The user for the job.</p>', 'ListBatchJobExecutionsRequest$jobName' => '<p>The name of each batch job execution.</p>', ], ], 'String20' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$instanceType' => '<p>The type of instance for the environment.</p>', 'DataSetSummary$dataSetOrg' => '<p>The type of data set. Possible values include VSAM, IS, PS, GDG, PO, PS, or unknown.</p>', 'DataSetSummary$format' => '<p>The format of the data set. </p>', 'EnvironmentSummary$instanceType' => '<p>The instance type of the environment.</p>', 'GetEnvironmentResponse$instanceType' => '<p>The type of instance underlying the runtime environment.</p>', 'LogGroupSummary$logType' => '<p>The type of log.</p>', 'UpdateEnvironmentRequest$instanceType' => '<p>The instance type for the environment to update.</p>', 'VsamDetailAttributes$encoding' => '<p>The character set used by the data set. Can be ASCII, EBCDIC, or unknown.</p>', 'VsamDetailAttributes$recordFormat' => '<p>The record format of the data set.</p>', ], ], 'String200' => [ 'base' => NULL, 'refs' => [ 'DataSetSummary$dataSetName' => '<p>The name of the data set.</p>', 'EfsStorageConfiguration$fileSystemId' => '<p>The file system identifier.</p>', 'EfsStorageConfiguration$mountPoint' => '<p>The mount point for the file system.</p>', 'FsxStorageConfiguration$fileSystemId' => '<p>The file system identifier.</p>', 'FsxStorageConfiguration$mountPoint' => '<p>The mount point for the file system.</p>', 'GetDataSetDetailsRequest$dataSetName' => '<p>The name of the data set.</p>', 'GetDataSetDetailsResponse$dataSetName' => '<p>The name of the data set.</p>', 'ListDataSetsRequest$prefix' => '<p>The prefix of the data set name, which you can use to filter the list of data sets.</p>', ], ], 'String2000' => [ 'base' => NULL, 'refs' => [ 'DataSetImportConfig$s3Location' => '<p>The Amazon S3 location of the data sets.</p>', 'Definition$s3Location' => '<p>The S3 bucket that contains the application definition.</p>', 'ExternalLocation$s3Location' => '<p>The URI of the Amazon S3 bucket.</p>', 'GetDataSetDetailsResponse$location' => '<p>The locaion where the data set is stored.</p>', ], ], 'String50' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$preferredMaintenanceWindow' => '<p>Configures a desired maintenance window for the environment. If you do not provide a value, a random system-generated value will be assigned.</p>', 'GdgDetailAttributes$rollDisposition' => '<p>The disposition of the data set in the catalog.</p>', 'GetEnvironmentResponse$vpcId' => '<p>The unique identifier for the VPC used with this runtime environment.</p>', 'String50List$member' => NULL, ], ], 'String50List' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$securityGroupIds' => '<p>The list of security groups for the VPC associated with this environment.</p>', 'CreateEnvironmentRequest$subnetIds' => '<p>The list of subnets associated with the VPC for this environment.</p>', 'GetEnvironmentResponse$securityGroupIds' => '<p>The unique identifiers of the security groups assigned to this runtime environment.</p>', 'GetEnvironmentResponse$subnetIds' => '<p>The unique identifiers of the subnets assigned to this runtime environment.</p>', ], ], 'StringFree65000' => [ 'base' => NULL, 'refs' => [ 'Definition$content' => '<p>The content of the application definition. This is a JSON object that contains the resource configuration/definitions that identify an application.</p>', 'GetApplicationVersionResponse$definitionContent' => '<p>The content of the application definition. This is a JSON object that contains the resource configuration/definitions that identify an application.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to remove.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$tags' => '<p>A list of tags to apply to the application.</p>', 'CreateEnvironmentRequest$tags' => '<p>The tags for the environment.</p>', 'GetApplicationResponse$tags' => '<p>A list of tags associated with the application.</p>', 'GetEnvironmentResponse$tags' => '<p>The tags defined for this runtime environment.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags for the resource.</p>', 'TagResourceRequest$tags' => '<p>The tags to add to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The number of requests made exceeds the limit.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$creationTime' => '<p>The timestamp when the application was created.</p>', 'ApplicationSummary$lastStartTime' => '<p>The timestamp when the application was last started. Null until the application has started running for the first time.</p>', 'ApplicationVersionSummary$creationTime' => '<p>The timestamp when the application version was created.</p>', 'BatchJobExecutionSummary$endTime' => '<p>The timestamp when this batch job execution ended.</p>', 'BatchJobExecutionSummary$startTime' => '<p>The timestamp when a particular batch job execution started.</p>', 'DataSetSummary$creationTime' => '<p>The timestamp when the data set was created.</p>', 'DataSetSummary$lastReferencedTime' => '<p>The last time the data set was referenced.</p>', 'DataSetSummary$lastUpdatedTime' => '<p>The last time the data set was updated.</p>', 'DeploymentSummary$creationTime' => '<p>The timestamp when the deployment was created.</p>', 'EnvironmentSummary$creationTime' => '<p>The timestamp when the environment was created.</p>', 'GetApplicationResponse$creationTime' => '<p>The timestamp when this application was created.</p>', 'GetApplicationResponse$lastStartTime' => '<p>The timestamp when the application was last started. Null until the application has started running for the first time.</p>', 'GetApplicationVersionResponse$creationTime' => '<p>The timestamp when the application version was created.</p>', 'GetBatchJobExecutionResponse$endTime' => '<p>The timestamp when the batch job execution ended.</p>', 'GetBatchJobExecutionResponse$startTime' => '<p>The timestamp when the batch job execution started.</p>', 'GetDataSetDetailsResponse$creationTime' => '<p>The timestamp when the data set was created.</p>', 'GetDataSetDetailsResponse$lastReferencedTime' => '<p>The last time the data set was referenced.</p>', 'GetDataSetDetailsResponse$lastUpdatedTime' => '<p>The last time the data set was updated.</p>', 'GetDeploymentResponse$creationTime' => '<p>The timestamp when the deployment was created.</p>', 'GetEnvironmentResponse$creationTime' => '<p>The timestamp when the runtime environment was created.</p>', 'ListBatchJobExecutionsRequest$startedAfter' => '<p>The time after which the batch job executions started.</p>', 'ListBatchJobExecutionsRequest$startedBefore' => '<p>The time before the batch job executions started.</p>', 'MaintenanceSchedule$endTime' => '<p>The time the scheduled maintenance is to end.</p>', 'MaintenanceSchedule$startTime' => '<p>The time the scheduled maintenance is to start.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>One or more parameters provided in the request is not valid.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Contains information about a validation exception field.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The list of fields that failed service validation.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason why it failed service validation.</p>', ], ], 'Version' => [ 'base' => NULL, 'refs' => [ 'ApplicationSummary$applicationVersion' => '<p>The version of the application.</p>', 'ApplicationVersionSummary$applicationVersion' => '<p>The application version.</p>', 'CreateApplicationResponse$applicationVersion' => '<p>The version number of the application.</p>', 'CreateDeploymentRequest$applicationVersion' => '<p>The version of the application to deploy.</p>', 'DeployedVersionSummary$applicationVersion' => '<p>The version of the deployed application.</p>', 'DeploymentSummary$applicationVersion' => '<p>The version of the application.</p>', 'GetApplicationVersionRequest$applicationVersion' => '<p>The specific version of the application.</p>', 'GetApplicationVersionResponse$applicationVersion' => '<p>The specific version of the application.</p>', 'GetDeploymentResponse$applicationVersion' => '<p>The application version.</p>', 'UpdateApplicationRequest$currentApplicationVersion' => '<p>The current version of the application to update.</p>', 'UpdateApplicationResponse$applicationVersion' => '<p>The new version of the application.</p>', ], ], 'VsamAttributes' => [ 'base' => '<p>The attributes of a VSAM type data set.</p>', 'refs' => [ 'DatasetOrgAttributes$vsam' => '<p>The details of a VSAM data set.</p>', ], ], 'VsamDetailAttributes' => [ 'base' => '<p>The attributes of a VSAM type data set.</p>', 'refs' => [ 'DatasetDetailOrgAttributes$vsam' => '<p>The details of a VSAM data set.</p>', ], ], ],];
