<?php
// This file was auto-generated from sdk-root/src/data/fsx/2018-03-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon FSx is a fully managed service that makes it easy for storage and application administrators to launch and use shared file storage.</p>', 'operations' => [ 'AssociateFileSystemAliases' => '<p>Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system. A file system can have a maximum of 50 DNS aliases associated with it at any one time. If you try to associate a DNS alias that is already associated with the file system, FSx takes no action on that alias in the request. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a> and <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">Walkthrough 5: Using DNS aliases to access your file system</a>, including additional steps you must take to be able to access your file system using a DNS alias.</p> <p>The system response shows the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system.</p>', 'CancelDataRepositoryTask' => '<p>Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the <code>PENDING</code> or <code>EXECUTING</code> state. When you cancel a task, Amazon FSx does the following.</p> <ul> <li> <p>Any files that FSx has already exported are not reverted.</p> </li> <li> <p>FSx continues to export any files that are "in-flight" when the cancel operation is received.</p> </li> <li> <p>FSx does not export any files that have not yet been exported.</p> </li> </ul>', 'CopyBackup' => '<p>Copies an existing backup within the same Amazon Web Services account to another Amazon Web Services Region (cross-Region copy) or within the same Amazon Web Services Region (in-Region copy). You can have up to five backup copy requests in progress to a single destination Region per account.</p> <p>You can use cross-Region backup copies for cross-Region disaster recovery. You can periodically take backups and copy them to another Region so that in the event of a disaster in the primary Region, you can restore from backup and recover availability quickly in the other Region. You can make cross-Region copies only within your Amazon Web Services partition. A partition is a grouping of Regions. Amazon Web Services currently has three partitions: <code>aws</code> (Standard Regions), <code>aws-cn</code> (China Regions), and <code>aws-us-gov</code> (Amazon Web Services GovCloud [US] Regions).</p> <p>You can also use backup copies to clone your file dataset to another Region or within the same Region.</p> <p>You can use the <code>SourceRegion</code> parameter to specify the Amazon Web Services Region from which the backup will be copied. For example, if you make the call from the <code>us-west-1</code> Region and want to copy a backup from the <code>us-east-2</code> Region, you specify <code>us-east-2</code> in the <code>SourceRegion</code> parameter to make a cross-Region copy. If you don\'t specify a Region, the backup copy is created in the same Region where the request is sent from (in-Region copy).</p> <p>For more information about creating backup copies, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#copy-backups"> Copying backups</a> in the <i>Amazon FSx for Windows User Guide</i>, <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html#copy-backups">Copying backups</a> in the <i>Amazon FSx for Lustre User Guide</i>, and <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html#copy-backups">Copying backups</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.</p>', 'CreateBackup' => '<p>Creates a backup of an existing Amazon FSx for Windows File Server file system, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system. We recommend creating regular backups so that you can restore a file system or volume from a backup if an issue arises with the original file system or volume.</p> <p>For Amazon FSx for Lustre file systems, you can create a backup only for file systems that have the following configuration:</p> <ul> <li> <p>A Persistent deployment type</p> </li> <li> <p>Are <i>not</i> linked to a data repository</p> </li> </ul> <p>For more information about backups, see the following:</p> <ul> <li> <p>For Amazon FSx for Lustre, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html">Working with FSx for Lustre backups</a>.</p> </li> <li> <p>For Amazon FSx for Windows, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html">Working with FSx for Windows backups</a>.</p> </li> <li> <p>For Amazon FSx for NetApp ONTAP, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/using-backups.html">Working with FSx for NetApp ONTAP backups</a>.</p> </li> <li> <p>For Amazon FSx for OpenZFS, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/using-backups.html">Working with FSx for OpenZFS backups</a>.</p> </li> </ul> <p>If a backup with the specified client request token exists and the parameters match, this operation returns the description of the existing backup. If a backup with the specified client request token exists and the parameters don\'t match, this operation returns <code>IncompatibleParameterError</code>. If a backup with the specified client request token doesn\'t exist, <code>CreateBackup</code> does the following: </p> <ul> <li> <p>Creates a new Amazon FSx backup with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.</p> </li> <li> <p>Returns the description of the backup.</p> </li> </ul> <p>By using the idempotent operation, you can retry a <code>CreateBackup</code> operation without the risk of creating an extra backup. This approach can be useful when an initial call fails in a way that makes it unclear whether a backup was created. If you use the same client request token and the initial call created a backup, the operation returns a successful result because all the parameters are the same.</p> <p>The <code>CreateBackup</code> operation returns while the backup\'s lifecycle state is still <code>CREATING</code>. You can check the backup creation status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeBackups.html">DescribeBackups</a> operation, which returns the backup state along with other information.</p>', 'CreateDataRepositoryAssociation' => '<p>Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported only for file systems with the <code>Persistent_2</code> deployment type.</p> <p>Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html">Linking your file system to an S3 bucket</a>.</p>', 'CreateDataRepositoryTask' => '<p>Creates an Amazon FSx for Lustre data repository task. You use data repository tasks to perform bulk operations between your Amazon FSx file system and its linked data repositories. An example of a data repository task is exporting any data and metadata changes, including POSIX metadata, to files, directories, and symbolic links (symlinks) from your FSx file system to a linked data repository. A <code>CreateDataRepositoryTask</code> operation will fail if a data repository is not linked to the FSx file system. To learn more about data repository tasks, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html">Data Repository Tasks</a>. To learn more about linking a data repository to your file system, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html">Linking your file system to an S3 bucket</a>.</p>', 'CreateFileSystem' => '<p>Creates a new, empty Amazon FSx file system. You can create the following supported Amazon FSx file systems using the <code>CreateFileSystem</code> API operation:</p> <ul> <li> <p>Amazon FSx for Lustre</p> </li> <li> <p>Amazon FSx for NetApp ONTAP</p> </li> <li> <p>Amazon FSx for OpenZFS</p> </li> <li> <p>Amazon FSx for Windows File Server</p> </li> </ul> <p>This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a <code>CreateFileSystem</code> operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives success as long as the parameters are the same.</p> <p>If a file system with the specified client request token exists and the parameters match, <code>CreateFileSystem</code> returns the description of the existing file system. If a file system with the specified client request token exists and the parameters don\'t match, this call returns <code>IncompatibleParameterError</code>. If a file system with the specified client request token doesn\'t exist, <code>CreateFileSystem</code> does the following: </p> <ul> <li> <p>Creates a new, empty Amazon FSx file system with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.</p> </li> <li> <p>Returns the description of the file system in JSON format.</p> </li> </ul> <p>This operation requires a client request token in the request that Amazon FSx uses to ensure idempotent creation. This means that calling the operation multiple times with the same client request token has no effect. By using the idempotent operation, you can retry a <code>CreateFileSystem</code> operation without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport-level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.</p> <note> <p>The <code>CreateFileSystem</code> call returns while the file system\'s lifecycle state is still <code>CREATING</code>. You can check the file-system creation status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html">DescribeFileSystems</a> operation, which returns the file system state along with other information.</p> </note>', 'CreateFileSystemFromBackup' => '<p>Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server, or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup.</p> <p>If a file system with the specified client request token exists and the parameters match, this operation returns the description of the file system. If a file system with the specified client request token exists but the parameters don\'t match, this call returns <code>IncompatibleParameterError</code>. If a file system with the specified client request token doesn\'t exist, this operation does the following:</p> <ul> <li> <p>Creates a new Amazon FSx file system from backup with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.</p> </li> <li> <p>Returns the description of the file system.</p> </li> </ul> <p>Parameters like the Active Directory, default share name, automatic backup, and backup settings default to the parameters of the file system that was backed up, unless overridden. You can explicitly supply other settings.</p> <p>By using the idempotent operation, you can retry a <code>CreateFileSystemFromBackup</code> call without the risk of creating an extra file system. This approach can be useful when an initial call fails in a way that makes it unclear whether a file system was created. Examples are if a transport level timeout occurred, or your connection was reset. If you use the same client request token and the initial call created a file system, the client receives a success message as long as the parameters are the same.</p> <note> <p>The <code>CreateFileSystemFromBackup</code> call returns while the file system\'s lifecycle state is still <code>CREATING</code>. You can check the file-system creation status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html"> DescribeFileSystems</a> operation, which returns the file system state along with other information.</p> </note>', 'CreateSnapshot' => '<p>Creates a snapshot of an existing Amazon FSx for OpenZFS volume. With snapshots, you can easily undo file changes and compare file versions by restoring the volume to a previous version.</p> <p>If a snapshot with the specified client request token exists, and the parameters match, this operation returns the description of the existing snapshot. If a snapshot with the specified client request token exists, and the parameters don\'t match, this operation returns <code>IncompatibleParameterError</code>. If a snapshot with the specified client request token doesn\'t exist, <code>CreateSnapshot</code> does the following:</p> <ul> <li> <p>Creates a new OpenZFS snapshot with an assigned ID, and an initial lifecycle state of <code>CREATING</code>.</p> </li> <li> <p>Returns the description of the snapshot.</p> </li> </ul> <p>By using the idempotent operation, you can retry a <code>CreateSnapshot</code> operation without the risk of creating an extra snapshot. This approach can be useful when an initial call fails in a way that makes it unclear whether a snapshot was created. If you use the same client request token and the initial call created a snapshot, the operation returns a successful result because all the parameters are the same.</p> <p>The <code>CreateSnapshot</code> operation returns while the snapshot\'s lifecycle state is still <code>CREATING</code>. You can check the snapshot creation status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeSnapshots.html">DescribeSnapshots</a> operation, which returns the snapshot state along with other information.</p>', 'CreateStorageVirtualMachine' => '<p>Creates a storage virtual machine (SVM) for an Amazon FSx for ONTAP file system.</p>', 'CreateVolume' => '<p>Creates an FSx for ONTAP or Amazon FSx for OpenZFS storage volume.</p>', 'CreateVolumeFromBackup' => '<p>Creates a new Amazon FSx for NetApp ONTAP volume from an existing Amazon FSx volume backup.</p>', 'DeleteBackup' => '<p>Deletes an Amazon FSx backup. After deletion, the backup no longer exists, and its data is gone.</p> <p>The <code>DeleteBackup</code> call returns instantly. The backup won\'t show up in later <code>DescribeBackups</code> calls.</p> <important> <p>The data in a deleted backup is also deleted and can\'t be recovered by any means.</p> </important>', 'DeleteDataRepositoryAssociation' => '<p>Deletes a data repository association on an Amazon FSx for Lustre file system. Deleting the data repository association unlinks the file system from the Amazon S3 bucket. When deleting a data repository association, you have the option of deleting the data in the file system that corresponds to the data repository association. Data repository associations are supported only for file systems with the <code>Persistent_2</code> deployment type.</p>', 'DeleteFileSystem' => '<p>Deletes a file system. After deletion, the file system no longer exists, and its data is gone. Any existing automatic backups and snapshots are also deleted.</p> <p>To delete an Amazon FSx for NetApp ONTAP file system, first delete all the volumes and storage virtual machines (SVMs) on the file system. Then provide a <code>FileSystemId</code> value to the <code>DeleFileSystem</code> operation.</p> <p>By default, when you delete an Amazon FSx for Windows File Server file system, a final backup is created upon deletion. This final backup isn\'t subject to the file system\'s retention policy, and must be manually deleted.</p> <p>The <code>DeleteFileSystem</code> operation returns while the file system has the <code>DELETING</code> status. You can check the file system deletion status by calling the <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DescribeFileSystems.html">DescribeFileSystems</a> operation, which returns a list of file systems in your account. If you pass the file system ID for a deleted file system, the <code>DescribeFileSystems</code> operation returns a <code>FileSystemNotFound</code> error.</p> <note> <p>If a data repository task is in a <code>PENDING</code> or <code>EXECUTING</code> state, deleting an Amazon FSx for Lustre file system will fail with an HTTP status code 400 (Bad Request).</p> </note> <important> <p>The data in a deleted file system is also deleted and can\'t be recovered by any means.</p> </important>', 'DeleteSnapshot' => '<p>Deletes an Amazon FSx for OpenZFS snapshot. After deletion, the snapshot no longer exists, and its data is gone. Deleting a snapshot doesn\'t affect snapshots stored in a file system backup. </p> <p>The <code>DeleteSnapshot</code> operation returns instantly. The snapshot appears with the lifecycle status of <code>DELETING</code> until the deletion is complete.</p>', 'DeleteStorageVirtualMachine' => '<p>Deletes an existing Amazon FSx for ONTAP storage virtual machine (SVM). Prior to deleting an SVM, you must delete all non-root volumes in the SVM, otherwise the operation will fail.</p>', 'DeleteVolume' => '<p>Deletes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.</p>', 'DescribeBackups' => '<p>Returns the description of a specific Amazon FSx backup, if a <code>BackupIds</code> value is provided for that backup. Otherwise, it returns all backups owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you\'re calling.</p> <p>When retrieving all backups, you can optionally specify the <code>MaxResults</code> parameter to limit the number of backups in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of the <code>NextToken</code> value from the last response.</p> <p>This operation is used in an iterative process to retrieve a list of your backups. <code>DescribeBackups</code> is called first without a <code>NextToken</code> value. Then the operation continues to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has no <code>NextToken</code> value.</p> <p>When using this operation, keep the following in mind:</p> <ul> <li> <p>The operation might return fewer than the <code>MaxResults</code> value of backup descriptions while still including a <code>NextToken</code> value.</p> </li> <li> <p>The order of the backups returned in the response of one <code>DescribeBackups</code> call and the order of the backups returned across the responses of a multi-call iteration is unspecified.</p> </li> </ul>', 'DescribeDataRepositoryAssociations' => '<p>Returns the description of specific Amazon FSx for Lustre data repository associations, if one or more <code>AssociationIds</code> values are provided in the request, or if filters are used in the request. Data repository associations are supported only for file systems with the <code>Persistent_2</code> deployment type.</p> <p>You can use filters to narrow the response to include just data repository associations for specific file systems (use the <code>file-system-id</code> filter with the ID of the file system) or data repository associations for a specific repository type (use the <code>data-repository-type</code> filter with a value of <code>S3</code>). If you don\'t use filters, the response returns all data repository associations owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you\'re calling.</p> <p>When retrieving all data repository associations, you can paginate the response by using the optional <code>MaxResults</code> parameter to limit the number of data repository associations returned in a response. If more data repository associations remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response.</p>', 'DescribeDataRepositoryTasks' => '<p>Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more <code>TaskIds</code> values are provided in the request, or if filters are used in the request. You can use filters to narrow the response to include just tasks for specific file systems, or tasks in a specific lifecycle state. Otherwise, it returns all data repository tasks owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you\'re calling.</p> <p>When retrieving all tasks, you can paginate the response by using the optional <code>MaxResults</code> parameter to limit the number of tasks returned in a response. If more tasks remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response.</p>', 'DescribeFileSystemAliases' => '<p>Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system. A history of all DNS aliases that have been associated with and disassociated from the file system is available in the list of <a>AdministrativeAction</a> provided in the <a>DescribeFileSystems</a> operation response.</p>', 'DescribeFileSystems' => '<p>Returns the description of specific Amazon FSx file systems, if a <code>FileSystemIds</code> value is provided for that file system. Otherwise, it returns descriptions of all file systems owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you\'re calling.</p> <p>When retrieving all file system descriptions, you can optionally specify the <code>MaxResults</code> parameter to limit the number of descriptions in a response. If more file system descriptions remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response.</p> <p>This operation is used in an iterative process to retrieve a list of your file system descriptions. <code>DescribeFileSystems</code> is called first without a <code>NextToken</code>value. Then the operation continues to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has no <code>NextToken</code>.</p> <p>When using this operation, keep the following in mind:</p> <ul> <li> <p>The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including a <code>NextToken</code> value.</p> </li> <li> <p>The order of file systems returned in the response of one <code>DescribeFileSystems</code> call and the order of file systems returned across the responses of a multicall iteration is unspecified.</p> </li> </ul>', 'DescribeSnapshots' => '<p>Returns the description of specific Amazon FSx for OpenZFS snapshots, if a <code>SnapshotIds</code> value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you\'re calling.</p> <p>When retrieving all snapshots, you can optionally specify the <code>MaxResults</code> parameter to limit the number of snapshots in a response. If more backups remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response. </p> <p>Use this operation in an iterative process to retrieve a list of your snapshots. <code>DescribeSnapshots</code> is called first without a <code>NextToken</code> value. Then the operation continues to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has no <code>NextToken</code> value.</p> <p>When using this operation, keep the following in mind:</p> <ul> <li> <p>The operation might return fewer than the <code>MaxResults</code> value of snapshot descriptions while still including a <code>NextToken</code> value.</p> </li> <li> <p>The order of snapshots returned in the response of one <code>DescribeSnapshots</code> call and the order of backups returned across the responses of a multi-call iteration is unspecified. </p> </li> </ul>', 'DescribeStorageVirtualMachines' => '<p>Describes one or more Amazon FSx for NetApp ONTAP storage virtual machines (SVMs).</p>', 'DescribeVolumes' => '<p>Describes one or more Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volumes.</p>', 'DisassociateFileSystemAliases' => '<p>Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system. If you attempt to disassociate a DNS alias that is not associated with the file system, Amazon FSx responds with a 400 Bad Request. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a>.</p> <p>The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is disassociating with the file system.</p>', 'ListTagsForResource' => '<p>Lists tags for Amazon FSx resources.</p> <p>When retrieving all tags, you can optionally specify the <code>MaxResults</code> parameter to limit the number of tags in a response. If more tags remain, Amazon FSx returns a <code>NextToken</code> value in the response. In this case, send a later request with the <code>NextToken</code> request parameter set to the value of <code>NextToken</code> from the last response.</p> <p>This action is used in an iterative process to retrieve a list of your tags. <code>ListTagsForResource</code> is called first without a <code>NextToken</code>value. Then the action continues to be called with the <code>NextToken</code> parameter set to the value of the last <code>NextToken</code> value until a response has no <code>NextToken</code>.</p> <p>When using this action, keep the following in mind:</p> <ul> <li> <p>The implementation might return fewer than <code>MaxResults</code> file system descriptions while still including a <code>NextToken</code> value.</p> </li> <li> <p>The order of tags returned in the response of one <code>ListTagsForResource</code> call and the order of tags returned across the responses of a multi-call iteration is unspecified.</p> </li> </ul>', 'ReleaseFileSystemNfsV3Locks' => '<p>Releases the file system lock from an Amazon FSx for OpenZFS file system.</p>', 'RestoreVolumeFromSnapshot' => '<p>Returns an Amazon FSx for OpenZFS volume to the state saved by the specified snapshot. </p>', 'TagResource' => '<p>Tags an Amazon FSx resource.</p>', 'UntagResource' => '<p>This action removes a tag from an Amazon FSx resource.</p>', 'UpdateDataRepositoryAssociation' => '<p>Updates the configuration of an existing data repository association on an Amazon FSx for Lustre file system. Data repository associations are supported only for file systems with the <code>Persistent_2</code> deployment type.</p>', 'UpdateFileSystem' => '<p>Use this operation to update the configuration of an existing Amazon FSx file system. You can update multiple properties in a single request.</p> <p>For Amazon FSx for Windows File Server file systems, you can update the following properties:</p> <ul> <li> <p> <code>AuditLogConfiguration</code> </p> </li> <li> <p> <code>AutomaticBackupRetentionDays</code> </p> </li> <li> <p> <code>DailyAutomaticBackupStartTime</code> </p> </li> <li> <p> <code>SelfManagedActiveDirectoryConfiguration</code> </p> </li> <li> <p> <code>StorageCapacity</code> </p> </li> <li> <p> <code>ThroughputCapacity</code> </p> </li> <li> <p> <code>WeeklyMaintenanceStartTime</code> </p> </li> </ul> <p>For Amazon FSx for Lustre file systems, you can update the following properties:</p> <ul> <li> <p> <code>AutoImportPolicy</code> </p> </li> <li> <p> <code>AutomaticBackupRetentionDays</code> </p> </li> <li> <p> <code>DailyAutomaticBackupStartTime</code> </p> </li> <li> <p> <code>DataCompressionType</code> </p> </li> <li> <p> <code>LustreRootSquashConfiguration</code> </p> </li> <li> <p> <code>StorageCapacity</code> </p> </li> <li> <p> <code>WeeklyMaintenanceStartTime</code> </p> </li> </ul> <p>For Amazon FSx for NetApp ONTAP file systems, you can update the following properties:</p> <ul> <li> <p> <code>AutomaticBackupRetentionDays</code> </p> </li> <li> <p> <code>DailyAutomaticBackupStartTime</code> </p> </li> <li> <p> <code>DiskIopsConfiguration</code> </p> </li> <li> <p> <code>FsxAdminPassword</code> </p> </li> <li> <p> <code>StorageCapacity</code> </p> </li> <li> <p> <code>ThroughputCapacity</code> </p> </li> <li> <p> <code>WeeklyMaintenanceStartTime</code> </p> </li> </ul> <p>For the Amazon FSx for OpenZFS file systems, you can update the following properties:</p> <ul> <li> <p> <code>AutomaticBackupRetentionDays</code> </p> </li> <li> <p> <code>CopyTagsToBackups</code> </p> </li> <li> <p> <code>CopyTagsToVolumes</code> </p> </li> <li> <p> <code>DailyAutomaticBackupStartTime</code> </p> </li> <li> <p> <code>ThroughputCapacity</code> </p> </li> <li> <p> <code>WeeklyMaintenanceStartTime</code> </p> </li> </ul>', 'UpdateSnapshot' => '<p>Updates the name of an Amazon FSx for OpenZFS snapshot.</p>', 'UpdateStorageVirtualMachine' => '<p>Updates an Amazon FSx for ONTAP storage virtual machine (SVM).</p>', 'UpdateVolume' => '<p>Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.</p>', ], 'shapes' => [ 'AWSAccountId' => [ 'base' => '<p>An Amazon Web Services account ID. This ID is a 12-digit number that you use to construct Amazon Resource Names (ARNs) for resources.</p>', 'refs' => [ 'Backup$OwnerId' => NULL, 'FileSystem$OwnerId' => '<p>The Amazon Web Services account that created the file system. If the file system was created by an Identity and Access Management (IAM) user, the Amazon Web Services account to which the IAM user belongs is the owner.</p>', ], ], 'ActiveDirectoryBackupAttributes' => [ 'base' => '<p>The Microsoft Active Directory attributes of the Amazon FSx for Windows File Server file system.</p>', 'refs' => [ 'Backup$DirectoryInformation' => '<p>The configuration of the self-managed Microsoft Active Directory directory to which the Windows File Server instance is joined.</p>', ], ], 'ActiveDirectoryError' => [ 'base' => '<p>An Active Directory error.</p>', 'refs' => [], ], 'ActiveDirectoryErrorType' => [ 'base' => '<p>The type of error relating to Microsoft Active Directory. NOT_FOUND means that no directory was found by specifying the given directory. INCOMPATIBLE_MODE means that the directory specified is not a Microsoft AD directory. WRONG_VPC means that the specified directory isn\'t accessible from the specified VPC. WRONG_STAGE means that the specified directory isn\'t currently in the ACTIVE state.</p>', 'refs' => [ 'ActiveDirectoryError$Type' => '<p>The type of Active Directory error.</p>', ], ], 'ActiveDirectoryFullyQualifiedName' => [ 'base' => NULL, 'refs' => [ 'ActiveDirectoryBackupAttributes$DomainName' => '<p>The fully qualified domain name of the self-managed Active Directory directory.</p>', 'SelfManagedActiveDirectoryAttributes$DomainName' => '<p>The fully qualified domain name of the self-managed AD directory.</p>', 'SelfManagedActiveDirectoryConfiguration$DomainName' => '<p>The fully qualified domain name of the self-managed AD directory, such as <code>corp.example.com</code>.</p>', ], ], 'AdminPassword' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemOntapConfiguration$FsxAdminPassword' => '<p>The ONTAP administrative password for the <code>fsxadmin</code> user with which you administer your file system using the NetApp ONTAP CLI and REST API.</p>', 'CreateStorageVirtualMachineRequest$SvmAdminPassword' => '<p>The password to use when managing the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system\'s <code>fsxadmin</code> user to manage the SVM.</p>', 'UpdateFileSystemOntapConfiguration$FsxAdminPassword' => '<p>The ONTAP administrative password for the <code>fsxadmin</code> user.</p>', 'UpdateStorageVirtualMachineRequest$SvmAdminPassword' => '<p>Enter a new SvmAdminPassword if you are updating it.</p>', ], ], 'AdministrativeAction' => [ 'base' => '<p>Describes a specific Amazon FSx administrative action for the current Windows, Lustre, or OpenZFS file system.</p>', 'refs' => [ 'AdministrativeActions$member' => NULL, ], ], 'AdministrativeActionFailureDetails' => [ 'base' => '<p>Provides information about a failed administrative action.</p>', 'refs' => [ 'AdministrativeAction$FailureDetails' => NULL, ], ], 'AdministrativeActionType' => [ 'base' => '<p>Describes the type of administrative action, as follows:</p> <ul> <li> <p> <code>FILE_SYSTEM_UPDATE</code> - A file system update administrative action initiated from the Amazon FSx console, API (<code>UpdateFileSystem</code>), or CLI (<code>update-file-system</code>).</p> </li> <li> <p> <code>STORAGE_OPTIMIZATION</code> - After the <code>FILE_SYSTEM_UPDATE</code> task to increase a file system\'s storage capacity has been completed successfully, a <code>STORAGE_OPTIMIZATION</code> task starts. </p> <ul> <li> <p>For Windows and ONTAP, storage optimization is the process of migrating the file system data to newer larger disks.</p> </li> <li> <p>For Lustre, storage optimization consists of rebalancing the data across the existing and newly added file servers.</p> </li> </ul> <p>You can track the storage-optimization progress using the <code>ProgressPercent</code> property. When <code>STORAGE_OPTIMIZATION</code> has been completed successfully, the parent <code>FILE_SYSTEM_UPDATE</code> action status changes to <code>COMPLETED</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>, <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>, and <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html">Managing storage capacity and provisioned IOPS</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.</p> </li> <li> <p> <code>FILE_SYSTEM_ALIAS_ASSOCIATION</code> - A file system update to associate a new Domain Name System (DNS) alias with the file system. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_AssociateFileSystemAliases.html"> AssociateFileSystemAliases</a>.</p> </li> <li> <p> <code>FILE_SYSTEM_ALIAS_DISASSOCIATION</code> - A file system update to disassociate a DNS alias from the file system. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/APIReference/API_DisassociateFileSystemAliases.html">DisassociateFileSystemAliases</a>.</p> </li> <li> <p> <code>VOLUME_UPDATE</code> - A volume update to an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (<code>UpdateVolume</code>), or CLI (<code>update-volume</code>).</p> </li> <li> <p> <code>SNAPSHOT_UPDATE</code> - A snapshot update to an Amazon FSx for OpenZFS volume initiated from the Amazon FSx console, API (<code>UpdateSnapshot</code>), or CLI (<code>update-snapshot</code>).</p> </li> <li> <p> <code>RELEASE_NFS_V3_LOCKS</code> - Tracks the release of Network File System (NFS) V3 locks on an Amazon FSx for OpenZFS file system. </p> </li> </ul>', 'refs' => [ 'AdministrativeAction$AdministrativeActionType' => NULL, ], ], 'AdministrativeActions' => [ 'base' => NULL, 'refs' => [ 'FileSystem$AdministrativeActions' => '<p>A list of administrative actions for the file system that are in process or waiting to be processed. Administrative actions describe changes to the Amazon FSx system that you have initiated using the <code>UpdateFileSystem</code> operation.</p>', 'Snapshot$AdministrativeActions' => '<p>A list of administrative actions for the file system that are in process or waiting to be processed. Administrative actions describe changes to the Amazon FSx system.</p>', 'Volume$AdministrativeActions' => '<p>A list of administrative actions for the file system that are in process or waiting to be processed. Administrative actions describe changes to the Amazon FSx system that you initiated.</p>', ], ], 'Alias' => [ 'base' => '<p>A DNS alias that is associated with the file system. You can use a DNS alias to access a file system using user-defined DNS names, in addition to the default DNS name that Amazon FSx assigns to the file system. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">DNS aliases</a> in the <i>FSx for Windows File Server User Guide</i>.</p>', 'refs' => [ 'Aliases$member' => NULL, ], ], 'AliasLifecycle' => [ 'base' => NULL, 'refs' => [ 'Alias$Lifecycle' => '<p>Describes the state of the DNS alias.</p> <ul> <li> <p>AVAILABLE - The DNS alias is associated with an Amazon FSx file system.</p> </li> <li> <p>CREATING - Amazon FSx is creating the DNS alias and associating it with the file system.</p> </li> <li> <p>CREATE_FAILED - Amazon FSx was unable to associate the DNS alias with the file system.</p> </li> <li> <p>DELETING - Amazon FSx is disassociating the DNS alias from the file system and deleting it.</p> </li> <li> <p>DELETE_FAILED - Amazon FSx was unable to disassociate the DNS alias from the file system.</p> </li> </ul>', ], ], 'Aliases' => [ 'base' => '<p>An array of one or more DNS aliases that are currently associated with the Amazon FSx file system. Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system. You can associate up to 50 aliases with a file system at any time. You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation. You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation. You only need to specify the alias name in the request payload. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">DNS aliases</a>.</p>', 'refs' => [ 'AssociateFileSystemAliasesResponse$Aliases' => '<p>An array of the DNS aliases that Amazon FSx is associating with the file system.</p>', 'DescribeFileSystemAliasesResponse$Aliases' => '<p>An array of one or more DNS aliases currently associated with the specified file system.</p>', 'DisassociateFileSystemAliasesResponse$Aliases' => '<p>An array of one or more DNS aliases that Amazon FSx is attempting to disassociate from the file system.</p>', 'WindowsFileSystemConfiguration$Aliases' => NULL, ], ], 'AlternateDNSName' => [ 'base' => NULL, 'refs' => [ 'Alias$Name' => '<p>The name of the DNS alias. The alias name has to meet the following requirements:</p> <ul> <li> <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p> </li> <li> <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p> </li> <li> <p>Cannot start or end with a hyphen.</p> </li> <li> <p>Can start with a numeric.</p> </li> </ul> <p>For DNS names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>', 'AlternateDNSNames$member' => NULL, ], ], 'AlternateDNSNames' => [ 'base' => NULL, 'refs' => [ 'AssociateFileSystemAliasesRequest$Aliases' => '<p>An array of one or more DNS alias names to associate with the file system. The alias name has to comply with the following formatting requirements:</p> <ul> <li> <p>Formatted as a fully-qualified domain name (FQDN), <i> <code>hostname.domain</code> </i>, for example, <code>accounting.corp.example.com</code>.</p> </li> <li> <p>Can contain alphanumeric characters and the hyphen (-).</p> </li> <li> <p>Cannot start or end with a hyphen.</p> </li> <li> <p>Can start with a numeric.</p> </li> </ul> <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>', 'CreateFileSystemWindowsConfiguration$Aliases' => '<p>An array of one or more DNS alias names that you want to associate with the Amazon FSx file system. Aliases allow you to use existing DNS names to access the data in your Amazon FSx file system. You can associate up to 50 aliases with a file system at any time. You can associate additional DNS aliases after you create the file system using the AssociateFileSystemAliases operation. You can remove DNS aliases from the file system after it is created using the DisassociateFileSystemAliases operation. You only need to specify the alias name in the request payload.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html">Working with DNS Aliases</a> and <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html">Walkthrough 5: Using DNS aliases to access your file system</a>, including additional steps you must take to be able to access your file system using a DNS alias.</p> <p>An alias name has to meet the following requirements:</p> <ul> <li> <p>Formatted as a fully-qualified domain name (FQDN), <code>hostname.domain</code>, for example, <code>accounting.example.com</code>.</p> </li> <li> <p>Can contain alphanumeric characters, the underscore (_), and the hyphen (-).</p> </li> <li> <p>Cannot start or end with a hyphen.</p> </li> <li> <p>Can start with a numeric.</p> </li> </ul> <p>For DNS alias names, Amazon FSx stores alphabetic characters as lowercase letters (a-z), regardless of how you specify them: as uppercase letters, lowercase letters, or the corresponding letters in escape codes.</p>', 'DisassociateFileSystemAliasesRequest$Aliases' => '<p>An array of one or more DNS alias names to disassociate, or remove, from the file system.</p>', ], ], 'ArchivePath' => [ 'base' => NULL, 'refs' => [ 'CompletionReport$Path' => '<p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the location of the report on the file system\'s linked S3 data repository. An absolute path that defines where the completion report will be stored in the destination location. The <code>Path</code> you provide must be located within the file system’s ExportPath. An example <code>Path</code> value is "s3://myBucket/myExportPath/optionalPrefix". The report provides the following information for each file in the report: FilePath, FileStatus, and ErrorCode. To learn more about a file system\'s <code>ExportPath</code>, see . </p>', 'CreateDataRepositoryAssociationRequest$DataRepositoryPath' => '<p>The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format <code>s3://myBucket/myPrefix/</code>. This path specifies where in the S3 data repository files will be imported from or exported to.</p>', 'CreateFileSystemLustreConfiguration$ImportPath' => '<p>(Optional) The path to the Amazon S3 bucket (including the optional prefix) that you\'re using as the data repository for your Amazon FSx for Lustre file system. The root of your FSx for Lustre file system will be mapped to the root of the Amazon S3 bucket you select. An example is <code>s3://import-bucket/optional-prefix</code>. If you specify a prefix after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.</p> <note> <p>This parameter is not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p> </note>', 'CreateFileSystemLustreConfiguration$ExportPath' => '<p>(Optional) Available with <code>Scratch</code> and <code>Persistent_1</code> deployment types. Specifies the path in the Amazon S3 bucket where the root of your Amazon FSx file system is exported. The path must use the same Amazon S3 bucket as specified in ImportPath. You can provide an optional prefix to which new and changed data is to be exported from your Amazon FSx for Lustre file system. If an <code>ExportPath</code> value is not provided, Amazon FSx sets a default export path, <code>s3://import-bucket/FSxLustre[creation-timestamp]</code>. The timestamp is in UTC format, for example <code>s3://import-bucket/FSxLustre20181105T222312Z</code>.</p> <p>The Amazon S3 export bucket must be the same as the import bucket specified by <code>ImportPath</code>. If you specify only a bucket name, such as <code>s3://import-bucket</code>, you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping means that the input data in S3 is overwritten on export. If you provide a custom prefix in the export path, such as <code>s3://import-bucket/[custom-optional-prefix]</code>, Amazon FSx exports the contents of your file system to that export prefix in the Amazon S3 bucket.</p> <note> <p>This parameter is not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p> </note>', 'DataRepositoryAssociation$DataRepositoryPath' => '<p>The path to the Amazon S3 data repository that will be linked to the file system. The path can be an S3 bucket or prefix in the format <code>s3://myBucket/myPrefix/</code>. This path specifies where in the S3 data repository files will be imported from or exported to.</p>', 'DataRepositoryConfiguration$ImportPath' => '<p>The import path to the Amazon S3 bucket (and optional prefix) that you\'re using as the data repository for your FSx for Lustre file system, for example <code>s3://import-bucket/optional-prefix</code>. If a prefix is specified after the Amazon S3 bucket name, only object keys with that prefix are loaded into the file system.</p>', 'DataRepositoryConfiguration$ExportPath' => '<p>The export path to the Amazon S3 bucket (and prefix) that you are using to store new and changed Lustre file system files in S3.</p>', ], ], 'AssociateFileSystemAliasesRequest' => [ 'base' => '<p>The request object specifying one or more DNS alias names to associate with an Amazon FSx for Windows File Server file system.</p>', 'refs' => [], ], 'AssociateFileSystemAliasesResponse' => [ 'base' => '<p>The system generated response showing the DNS aliases that Amazon FSx is attempting to associate with the file system. Use the API operation to monitor the status of the aliases Amazon FSx is associating with the file system. It can take up to 2.5 minutes for the alias status to change from <code>CREATING</code> to <code>AVAILABLE</code>. </p>', 'refs' => [], ], 'AutoExportPolicy' => [ 'base' => '<p>Describes a data repository association\'s automatic export policy. The <code>AutoExportPolicy</code> defines the types of updated objects on the file system that will be automatically exported to the data repository. As you create, modify, or delete files, Amazon FSx automatically exports the defined changes asynchronously once your application finishes modifying the file.</p> <p>This <code>AutoExportPolicy</code> is supported only for file systems with the <code>Persistent_2</code> deployment type.</p>', 'refs' => [ 'S3DataRepositoryConfiguration$AutoExportPolicy' => '<p>Specifies the type of updated objects (new, changed, deleted) that will be automatically exported from your file system to the linked S3 bucket.</p>', ], ], 'AutoImportPolicy' => [ 'base' => '<p>Describes the data repository association\'s automatic import policy. The AutoImportPolicy defines how Amazon FSx keeps your file metadata and directory listings up to date by importing changes to your file system as you modify objects in a linked S3 bucket.</p> <p>This <code>AutoImportPolicy</code> is supported only for file systems with the <code>Persistent_2</code> deployment type.</p>', 'refs' => [ 'S3DataRepositoryConfiguration$AutoImportPolicy' => '<p>Specifies the type of updated objects (new, changed, deleted) that will be automatically imported from the linked S3 bucket to your file system.</p>', ], ], 'AutoImportPolicyType' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemLustreConfiguration$AutoImportPolicy' => '<p> (Optional) Available with <code>Scratch</code> and <code>Persistent_1</code> deployment types. When you create your file system, your existing S3 objects appear as file and directory listings. Use this property to choose how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:</p> <ul> <li> <p> <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or changed objects after choosing this option.</p> </li> <li> <p> <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system. </p> </li> <li> <p> <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.</p> </li> <li> <p> <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/older-deployment-types.html#legacy-auto-import-from-s3"> Automatically import updates from your S3 bucket</a>.</p> <note> <p>This parameter is not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p> </note>', 'DataRepositoryConfiguration$AutoImportPolicy' => '<p>Describes the file system\'s linked S3 data repository\'s <code>AutoImportPolicy</code>. The AutoImportPolicy configures how Amazon FSx keeps your file and directory listings up to date as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:</p> <ul> <li> <p> <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update file and directory listings for any new or changed objects after choosing this option.</p> </li> <li> <p> <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system. </p> </li> <li> <p> <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.</p> </li> <li> <p> <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.</p> </li> </ul>', 'UpdateFileSystemLustreConfiguration$AutoImportPolicy' => '<p> (Optional) When you create your file system, your existing S3 objects appear as file and directory listings. Use this property to choose how Amazon FSx keeps your file and directory listing up to date as you add or modify objects in your linked S3 bucket. <code>AutoImportPolicy</code> can have the following values:</p> <ul> <li> <p> <code>NONE</code> - (Default) AutoImport is off. Amazon FSx only updates file and directory listings from the linked S3 bucket when the file system is created. FSx does not update the file and directory listing for any new or changed objects after choosing this option.</p> </li> <li> <p> <code>NEW</code> - AutoImport is on. Amazon FSx automatically imports directory listings of any new objects added to the linked S3 bucket that do not currently exist in the FSx file system. </p> </li> <li> <p> <code>NEW_CHANGED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket and any existing objects that are changed in the S3 bucket after you choose this option.</p> </li> <li> <p> <code>NEW_CHANGED_DELETED</code> - AutoImport is on. Amazon FSx automatically imports file and directory listings of any new objects added to the S3 bucket, any existing objects that are changed in the S3 bucket, and any objects that were deleted in the S3 bucket.</p> </li> </ul> <p>The <code>AutoImportPolicy</code> parameter is not supported for Lustre file systems with the <code>Persistent_2</code> deployment type. Instead, use to update a data repository association on your <code>Persistent_2</code> file system.</p>', ], ], 'AutomaticBackupRetentionDays' => [ 'base' => '<p>The number of days to retain automatic backups. Setting this property to <code>0</code> disables automatic backups. You can retain automatic backups for a maximum of 90 days. The default is <code>0</code>.</p>', 'refs' => [ 'CreateFileSystemLustreConfiguration$AutomaticBackupRetentionDays' => NULL, 'CreateFileSystemOntapConfiguration$AutomaticBackupRetentionDays' => NULL, 'CreateFileSystemOpenZFSConfiguration$AutomaticBackupRetentionDays' => NULL, 'CreateFileSystemWindowsConfiguration$AutomaticBackupRetentionDays' => '<p>The number of days to retain automatic backups. The default is to retain backups for 7 days. Setting this value to 0 disables the creation of automatic backups. The maximum retention period for backups is 90 days.</p>', 'LustreFileSystemConfiguration$AutomaticBackupRetentionDays' => NULL, 'OntapFileSystemConfiguration$AutomaticBackupRetentionDays' => NULL, 'OpenZFSFileSystemConfiguration$AutomaticBackupRetentionDays' => NULL, 'UpdateFileSystemLustreConfiguration$AutomaticBackupRetentionDays' => NULL, 'UpdateFileSystemOntapConfiguration$AutomaticBackupRetentionDays' => NULL, 'UpdateFileSystemOpenZFSConfiguration$AutomaticBackupRetentionDays' => NULL, 'UpdateFileSystemWindowsConfiguration$AutomaticBackupRetentionDays' => '<p>The number of days to retain automatic daily backups. Setting this to zero (0) disables automatic daily backups. You can retain automatic daily backups for a maximum of 90 days. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups">Working with Automatic Daily Backups</a>.</p>', 'WindowsFileSystemConfiguration$AutomaticBackupRetentionDays' => '<p>The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.</p>', ], ], 'Backup' => [ 'base' => '<p>A backup of an Amazon FSx for Windows File Server, Amazon FSx for Lustre file system, Amazon FSx for NetApp ONTAP volume, or Amazon FSx for OpenZFS file system.</p>', 'refs' => [ 'Backups$member' => NULL, 'CopyBackupResponse$Backup' => NULL, 'CreateBackupResponse$Backup' => '<p>A description of the backup.</p>', ], ], 'BackupBeingCopied' => [ 'base' => '<p>You can\'t delete a backup while it\'s being copied.</p>', 'refs' => [], ], 'BackupFailureDetails' => [ 'base' => '<p>If backup creation fails, this structure contains the details of that failure.</p>', 'refs' => [ 'Backup$FailureDetails' => '<p>Details explaining any failures that occurred when creating a backup.</p>', ], ], 'BackupId' => [ 'base' => '<p>The ID of the source backup. Specifies the backup that you are copying.</p>', 'refs' => [ 'Backup$BackupId' => '<p>The ID of the backup.</p>', 'Backup$SourceBackupId' => NULL, 'BackupBeingCopied$BackupId' => NULL, 'BackupIds$member' => NULL, 'CreateFileSystemFromBackupRequest$BackupId' => NULL, 'CreateVolumeFromBackupRequest$BackupId' => NULL, 'DeleteBackupRequest$BackupId' => '<p>The ID of the backup that you want to delete.</p>', 'DeleteBackupResponse$BackupId' => '<p>The ID of the backup that was deleted.</p>', 'DeleteFileSystemLustreResponse$FinalBackupId' => '<p>The ID of the final backup for this file system.</p>', 'DeleteFileSystemOpenZFSResponse$FinalBackupId' => NULL, 'DeleteFileSystemWindowsResponse$FinalBackupId' => '<p>The ID of the final backup for this file system.</p>', 'DeleteVolumeOntapResponse$FinalBackupId' => NULL, 'SourceBackupUnavailable$BackupId' => NULL, ], ], 'BackupIds' => [ 'base' => '<p>A list of backup IDs.</p>', 'refs' => [ 'DescribeBackupsRequest$BackupIds' => '<p>The IDs of the backups that you want to retrieve. This parameter value overrides any filters. If any IDs aren\'t found, a <code>BackupNotFound</code> error occurs.</p>', ], ], 'BackupInProgress' => [ 'base' => '<p>Another backup is already under way. Wait for completion before initiating additional backups of this file system.</p>', 'refs' => [], ], 'BackupLifecycle' => [ 'base' => '<p>The lifecycle status of the backup.</p> <ul> <li> <p> <code>AVAILABLE</code> - The backup is fully available.</p> </li> <li> <p> <code>PENDING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx hasn\'t started creating the backup.</p> </li> <li> <p> <code>CREATING</code> - Amazon FSx is creating the new user-initiated backup.</p> </li> <li> <p> <code>TRANSFERRING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx is backing up the file system.</p> </li> <li> <p> <code>COPYING</code> - Amazon FSx is copying the backup.</p> </li> <li> <p> <code>DELETED</code> - Amazon FSx deleted the backup and it\'s no longer available.</p> </li> <li> <p> <code>FAILED</code> - Amazon FSx couldn\'t finish the backup.</p> </li> </ul>', 'refs' => [ 'Backup$Lifecycle' => '<p>The lifecycle status of the backup.</p> <ul> <li> <p> <code>AVAILABLE</code> - The backup is fully available.</p> </li> <li> <p> <code>PENDING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx hasn\'t started creating the backup.</p> </li> <li> <p> <code>CREATING</code> - Amazon FSx is creating the backup.</p> </li> <li> <p> <code>TRANSFERRING</code> - For user-initiated backups on Lustre file systems only; Amazon FSx is transferring the backup to Amazon S3.</p> </li> <li> <p> <code>COPYING</code> - Amazon FSx is copying the backup.</p> </li> <li> <p> <code>DELETED</code> - Amazon FSx deleted the backup and it\'s no longer available.</p> </li> <li> <p> <code>FAILED</code> - Amazon FSx couldn\'t finish the backup.</p> </li> </ul>', 'DeleteBackupResponse$Lifecycle' => '<p>The lifecycle status of the backup. If the <code>DeleteBackup</code> operation is successful, the status is <code>DELETED</code>.</p>', ], ], 'BackupNotFound' => [ 'base' => '<p>No Amazon FSx backups were found based upon the supplied parameters.</p>', 'refs' => [], ], 'BackupRestoring' => [ 'base' => '<p>You can\'t delete a backup while it\'s being used to restore a file system.</p>', 'refs' => [], ], 'BackupType' => [ 'base' => '<p>The type of the backup.</p>', 'refs' => [ 'Backup$Type' => '<p>The type of the file-system backup.</p>', ], ], 'Backups' => [ 'base' => '<p>A list of file system backups.</p>', 'refs' => [ 'DescribeBackupsResponse$Backups' => '<p>An array of backups.</p>', ], ], 'BadRequest' => [ 'base' => '<p>A generic error indicating a failure with a client request.</p>', 'refs' => [], ], 'BatchImportMetaDataOnCreate' => [ 'base' => NULL, 'refs' => [ 'CreateDataRepositoryAssociationRequest$BatchImportMetaDataOnCreate' => '<p>Set to <code>true</code> to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Default is <code>false</code>.</p>', 'DataRepositoryAssociation$BatchImportMetaDataOnCreate' => '<p>A boolean flag indicating whether an import data repository task to import metadata should run after the data repository association is created. The task runs if this flag is set to <code>true</code>.</p>', ], ], 'CancelDataRepositoryTaskRequest' => [ 'base' => '<p>Cancels a data repository task.</p>', 'refs' => [], ], 'CancelDataRepositoryTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClientRequestToken' => [ 'base' => '<p>(Optional) An idempotency token for resource creation, in a string of up to 64 ASCII characters. This token is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>', 'refs' => [ 'AssociateFileSystemAliasesRequest$ClientRequestToken' => NULL, 'CopyBackupRequest$ClientRequestToken' => NULL, 'CreateBackupRequest$ClientRequestToken' => '<p>(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>', 'CreateDataRepositoryAssociationRequest$ClientRequestToken' => NULL, 'CreateDataRepositoryTaskRequest$ClientRequestToken' => NULL, 'CreateFileSystemFromBackupRequest$ClientRequestToken' => '<p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>', 'CreateFileSystemRequest$ClientRequestToken' => '<p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>', 'CreateSnapshotRequest$ClientRequestToken' => NULL, 'CreateStorageVirtualMachineRequest$ClientRequestToken' => NULL, 'CreateVolumeFromBackupRequest$ClientRequestToken' => NULL, 'CreateVolumeRequest$ClientRequestToken' => NULL, 'DeleteBackupRequest$ClientRequestToken' => '<p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This parameter is automatically filled on your behalf when using the CLI or SDK.</p>', 'DeleteDataRepositoryAssociationRequest$ClientRequestToken' => NULL, 'DeleteFileSystemRequest$ClientRequestToken' => '<p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent deletion. This token is automatically filled on your behalf when using the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>', 'DeleteSnapshotRequest$ClientRequestToken' => NULL, 'DeleteStorageVirtualMachineRequest$ClientRequestToken' => NULL, 'DeleteVolumeRequest$ClientRequestToken' => NULL, 'DescribeFileSystemAliasesRequest$ClientRequestToken' => NULL, 'DisassociateFileSystemAliasesRequest$ClientRequestToken' => NULL, 'ReleaseFileSystemNfsV3LocksRequest$ClientRequestToken' => NULL, 'RestoreVolumeFromSnapshotRequest$ClientRequestToken' => NULL, 'UpdateDataRepositoryAssociationRequest$ClientRequestToken' => NULL, 'UpdateFileSystemRequest$ClientRequestToken' => '<p>A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent updates. This string is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.</p>', 'UpdateSnapshotRequest$ClientRequestToken' => NULL, 'UpdateStorageVirtualMachineRequest$ClientRequestToken' => NULL, 'UpdateVolumeRequest$ClientRequestToken' => NULL, ], ], 'CompletionReport' => [ 'base' => '<p>Provides a report detailing the data repository task results of the files processed that match the criteria specified in the report <code>Scope</code> parameter. FSx delivers the report to the file system\'s linked data repository in Amazon S3, using the path specified in the report <code>Path</code> parameter. You can specify whether or not a report gets generated for a task using the <code>Enabled</code> parameter.</p>', 'refs' => [ 'CreateDataRepositoryTaskRequest$Report' => '<p>Defines whether or not Amazon FSx provides a CompletionReport once the task has completed. A CompletionReport provides a detailed report on the files that Amazon FSx processed that meet the criteria specified by the <code>Scope</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html">Working with Task Completion Reports</a>.</p>', 'DataRepositoryTask$Report' => NULL, ], ], 'CoolingPeriod' => [ 'base' => NULL, 'refs' => [ 'TieringPolicy$CoolingPeriod' => '<p>Specifies the number of days that user data in a volume must remain inactive before it is considered "cold" and moved to the capacity pool. Used with the <code>AUTO</code> and <code>SNAPSHOT_ONLY</code> tiering policies. Enter a whole number between 2 and 183. Default values are 31 days for <code>AUTO</code> and 2 days for <code>SNAPSHOT_ONLY</code>.</p>', ], ], 'CopyBackupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopyBackupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBackupRequest' => [ 'base' => '<p>The request object for the <code>CreateBackup</code> operation.</p>', 'refs' => [], ], 'CreateBackupResponse' => [ 'base' => '<p>The response object for the <code>CreateBackup</code> operation.</p>', 'refs' => [], ], 'CreateDataRepositoryAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataRepositoryAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataRepositoryTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataRepositoryTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFileSystemFromBackupRequest' => [ 'base' => '<p>The request object for the <code>CreateFileSystemFromBackup</code> operation.</p>', 'refs' => [], ], 'CreateFileSystemFromBackupResponse' => [ 'base' => '<p>The response object for the <code>CreateFileSystemFromBackup</code> operation.</p>', 'refs' => [], ], 'CreateFileSystemLustreConfiguration' => [ 'base' => '<p>The Lustre configuration for the file system being created.</p> <note> <p>The following parameters are not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p> <ul> <li> <p> <code>AutoImportPolicy</code> </p> </li> <li> <p> <code>ExportPath</code> </p> </li> <li> <p> <code>ImportedChunkSize</code> </p> </li> <li> <p> <code>ImportPath</code> </p> </li> </ul> </note>', 'refs' => [ 'CreateFileSystemFromBackupRequest$LustreConfiguration' => NULL, 'CreateFileSystemRequest$LustreConfiguration' => NULL, ], ], 'CreateFileSystemOntapConfiguration' => [ 'base' => '<p>The ONTAP configuration properties of the FSx for ONTAP file system that you are creating.</p>', 'refs' => [ 'CreateFileSystemRequest$OntapConfiguration' => NULL, ], ], 'CreateFileSystemOpenZFSConfiguration' => [ 'base' => '<p>The Amazon FSx for OpenZFS configuration properties for the file system that you are creating.</p>', 'refs' => [ 'CreateFileSystemFromBackupRequest$OpenZFSConfiguration' => '<p>The OpenZFS configuration for the file system that\'s being created. </p>', 'CreateFileSystemRequest$OpenZFSConfiguration' => '<p>The OpenZFS configuration for the file system that\'s being created.</p>', ], ], 'CreateFileSystemRequest' => [ 'base' => '<p>The request object used to create a new Amazon FSx file system.</p>', 'refs' => [], ], 'CreateFileSystemResponse' => [ 'base' => '<p>The response object returned after the file system is created.</p>', 'refs' => [], ], 'CreateFileSystemWindowsConfiguration' => [ 'base' => '<p>The configuration object for the Microsoft Windows file system used in <code>CreateFileSystem</code> and <code>CreateFileSystemFromBackup</code> operations.</p>', 'refs' => [ 'CreateFileSystemFromBackupRequest$WindowsConfiguration' => '<p>The configuration for this Microsoft Windows file system.</p>', 'CreateFileSystemRequest$WindowsConfiguration' => '<p>The Microsoft Windows configuration for the file system that\'s being created. </p>', ], ], 'CreateOntapVolumeConfiguration' => [ 'base' => '<p>Specifies the configuration of the ONTAP volume that you are creating.</p>', 'refs' => [ 'CreateVolumeFromBackupRequest$OntapConfiguration' => '<p>Specifies the configuration of the ONTAP volume that you are creating.</p>', 'CreateVolumeRequest$OntapConfiguration' => '<p>Specifies the configuration to use when creating the ONTAP volume.</p>', ], ], 'CreateOpenZFSOriginSnapshotConfiguration' => [ 'base' => '<p>The snapshot configuration to use when creating an OpenZFS volume from a snapshot. </p>', 'refs' => [ 'CreateOpenZFSVolumeConfiguration$OriginSnapshot' => '<p>The configuration object that specifies the snapshot to use as the origin of the data for the volume.</p>', ], ], 'CreateOpenZFSVolumeConfiguration' => [ 'base' => '<p>Specifies the configuration of the Amazon FSx for OpenZFS volume that you are creating.</p>', 'refs' => [ 'CreateVolumeRequest$OpenZFSConfiguration' => '<p>Specifies the configuration to use when creating the OpenZFS volume.</p>', ], ], 'CreateSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateStorageVirtualMachineRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateStorageVirtualMachineResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSvmActiveDirectoryConfiguration' => [ 'base' => '<p>The configuration that Amazon FSx uses to join the ONTAP storage virtual machine (SVM) to your self-managed (including on-premises) Microsoft Active Directory (AD) directory.</p>', 'refs' => [ 'CreateStorageVirtualMachineRequest$ActiveDirectoryConfiguration' => '<p>Describes the self-managed Microsoft Active Directory to which you want to join the SVM. Joining an Active Directory provides user authentication and access control for SMB clients, including Microsoft Windows and macOS client accessing the file system.</p>', ], ], 'CreateVolumeFromBackupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVolumeFromBackupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVolumeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationTime' => [ 'base' => '<p>The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.</p>', 'refs' => [ 'Backup$CreationTime' => '<p>The time when a particular backup was created.</p>', 'DataRepositoryAssociation$CreationTime' => NULL, 'DataRepositoryTask$CreationTime' => NULL, 'FileSystem$CreationTime' => '<p>The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z), also known as Unix time.</p>', 'Snapshot$CreationTime' => NULL, 'StorageVirtualMachine$CreationTime' => NULL, 'Volume$CreationTime' => NULL, ], ], 'DNSName' => [ 'base' => '<p>The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.</p>', 'refs' => [ 'FileSystem$DNSName' => '<p>The Domain Name System (DNS) name for the file system.</p>', 'FileSystemEndpoint$DNSName' => NULL, 'SvmEndpoint$DNSName' => NULL, 'WindowsFileSystemConfiguration$RemoteAdministrationEndpoint' => '<p>For <code>MULTI_AZ_1</code> deployment types, use this endpoint when performing administrative tasks on the file system using Amazon FSx Remote PowerShell.</p> <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this is the DNS name of the file system.</p> <p>This endpoint is temporarily unavailable when the file system is undergoing maintenance.</p>', ], ], 'DailyTime' => [ 'base' => '<p>A recurring daily time, in the format <code>HH:MM</code>. <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. For example, <code>05:00</code> specifies 5 AM daily. </p>', 'refs' => [ 'CreateFileSystemLustreConfiguration$DailyAutomaticBackupStartTime' => NULL, 'CreateFileSystemOntapConfiguration$DailyAutomaticBackupStartTime' => NULL, 'CreateFileSystemOpenZFSConfiguration$DailyAutomaticBackupStartTime' => NULL, 'CreateFileSystemWindowsConfiguration$DailyAutomaticBackupStartTime' => '<p>The preferred time to take daily automatic backups, formatted HH:MM in the UTC time zone.</p>', 'LustreFileSystemConfiguration$DailyAutomaticBackupStartTime' => NULL, 'OntapFileSystemConfiguration$DailyAutomaticBackupStartTime' => NULL, 'OpenZFSFileSystemConfiguration$DailyAutomaticBackupStartTime' => NULL, 'UpdateFileSystemLustreConfiguration$DailyAutomaticBackupStartTime' => NULL, 'UpdateFileSystemOntapConfiguration$DailyAutomaticBackupStartTime' => NULL, 'UpdateFileSystemOpenZFSConfiguration$DailyAutomaticBackupStartTime' => NULL, 'UpdateFileSystemWindowsConfiguration$DailyAutomaticBackupStartTime' => '<p>The preferred time to start the daily automatic backup, in the UTC time zone, for example, <code>02:00</code> </p>', 'WindowsFileSystemConfiguration$DailyAutomaticBackupStartTime' => '<p>The preferred time to take daily automatic backups, in the UTC time zone.</p>', ], ], 'DataCompressionType' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemLustreConfiguration$DataCompressionType' => '<p>Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the following values:</p> <ul> <li> <p> <code>NONE</code> - (Default) Data compression is turned off when the file system is created.</p> </li> <li> <p> <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a> in the <i>Amazon FSx for Lustre User Guide</i>.</p>', 'LustreFileSystemConfiguration$DataCompressionType' => '<p>The data compression configuration for the file system. <code>DataCompressionType</code> can have the following values:</p> <ul> <li> <p> <code>NONE</code> - Data compression is turned off for the file system.</p> </li> <li> <p> <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>', 'UpdateFileSystemLustreConfiguration$DataCompressionType' => '<p>Sets the data compression configuration for the file system. <code>DataCompressionType</code> can have the following values:</p> <ul> <li> <p> <code>NONE</code> - Data compression is turned off for the file system.</p> </li> <li> <p> <code>LZ4</code> - Data compression is turned on with the LZ4 algorithm.</p> </li> </ul> <p>If you don\'t use <code>DataCompressionType</code>, the file system retains its current data compression configuration.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-compression.html">Lustre data compression</a>.</p>', ], ], 'DataRepositoryAssociation' => [ 'base' => '<p>The configuration of a data repository association that links an Amazon FSx for Lustre file system to an Amazon S3 bucket. The data repository association configuration object is returned in the response of the following operations:</p> <ul> <li> <p> <code>CreateDataRepositoryAssociation</code> </p> </li> <li> <p> <code>UpdateDataRepositoryAssociation</code> </p> </li> <li> <p> <code>DescribeDataRepositoryAssociations</code> </p> </li> </ul> <p>Data repository associations are supported only for file systems with the <code>Persistent_2</code> deployment type.</p>', 'refs' => [ 'CreateDataRepositoryAssociationResponse$Association' => '<p>The response object returned after the data repository association is created.</p>', 'DataRepositoryAssociations$member' => NULL, 'UpdateDataRepositoryAssociationResponse$Association' => '<p>The response object returned after the data repository association is updated.</p>', ], ], 'DataRepositoryAssociationId' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryAssociation$AssociationId' => '<p>The system-generated, unique ID of the data repository association.</p>', 'DataRepositoryAssociationIds$member' => NULL, 'DeleteDataRepositoryAssociationRequest$AssociationId' => '<p>The ID of the data repository association that you want to delete.</p>', 'DeleteDataRepositoryAssociationResponse$AssociationId' => '<p>The ID of the data repository association being deleted.</p>', 'UpdateDataRepositoryAssociationRequest$AssociationId' => '<p>The ID of the data repository association that you are updating.</p>', ], ], 'DataRepositoryAssociationIds' => [ 'base' => NULL, 'refs' => [ 'DescribeDataRepositoryAssociationsRequest$AssociationIds' => '<p>IDs of the data repository associations whose descriptions you want to retrieve (String).</p>', ], ], 'DataRepositoryAssociationNotFound' => [ 'base' => '<p>No data repository associations were found based upon the supplied parameters.</p>', 'refs' => [], ], 'DataRepositoryAssociations' => [ 'base' => NULL, 'refs' => [ 'DescribeDataRepositoryAssociationsResponse$Associations' => '<p>An array of one ore more data repository association descriptions.</p>', ], ], 'DataRepositoryConfiguration' => [ 'base' => '<p>The data repository configuration object for Lustre file systems returned in the response of the <code>CreateFileSystem</code> operation.</p> <p>This data type is not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use .</p>', 'refs' => [ 'LustreFileSystemConfiguration$DataRepositoryConfiguration' => NULL, ], ], 'DataRepositoryFailureDetails' => [ 'base' => '<p>Provides detailed information about the data respository if its <code>Lifecycle</code> is set to <code>MISCONFIGURED</code> or <code>FAILED</code>.</p>', 'refs' => [ 'DataRepositoryAssociation$FailureDetails' => NULL, 'DataRepositoryConfiguration$FailureDetails' => NULL, ], ], 'DataRepositoryLifecycle' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryAssociation$Lifecycle' => '<p>Describes the state of a data repository association. The lifecycle can have the following values:</p> <ul> <li> <p> <code>CREATING</code> - The data repository association between the FSx file system and the S3 data repository is being created. The data repository is unavailable.</p> </li> <li> <p> <code>AVAILABLE</code> - The data repository association is available for use.</p> </li> <li> <p> <code>MISCONFIGURED</code> - Amazon FSx cannot automatically import updates from the S3 bucket or automatically export updates to the S3 bucket until the data repository association configuration is corrected.</p> </li> <li> <p> <code>UPDATING</code> - The data repository association is undergoing a customer initiated update that might affect its availability.</p> </li> <li> <p> <code>DELETING</code> - The data repository association is undergoing a customer initiated deletion.</p> </li> <li> <p> <code>FAILED</code> - The data repository association is in a terminal state that cannot be recovered.</p> </li> </ul>', 'DataRepositoryConfiguration$Lifecycle' => '<p>Describes the state of the file system\'s S3 durable data repository, if it is configured with an S3 repository. The lifecycle can have the following values:</p> <ul> <li> <p> <code>CREATING</code> - The data repository configuration between the FSx file system and the linked S3 data repository is being created. The data repository is unavailable.</p> </li> <li> <p> <code>AVAILABLE</code> - The data repository is available for use.</p> </li> <li> <p> <code>MISCONFIGURED</code> - Amazon FSx cannot automatically import updates from the S3 bucket until the data repository configuration is corrected. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/troubleshooting.html#troubleshooting-misconfigured-data-repository">Troubleshooting a Misconfigured linked S3 bucket</a>. </p> </li> <li> <p> <code>UPDATING</code> - The data repository is undergoing a customer initiated update and availability may be impacted.</p> </li> <li> <p> <code>FAILED</code> - The data repository is in a terminal state that cannot be recovered.</p> </li> </ul>', 'DeleteDataRepositoryAssociationResponse$Lifecycle' => '<p>Describes the lifecycle state of the data repository association being deleted.</p>', ], ], 'DataRepositoryTask' => [ 'base' => '<p>A description of the data repository task. You use data repository tasks to perform bulk transfer operations between your Amazon FSx file system and a linked data repository.</p>', 'refs' => [ 'CreateDataRepositoryTaskResponse$DataRepositoryTask' => '<p>The description of the data repository task that you just created.</p>', 'DataRepositoryTasks$member' => NULL, ], ], 'DataRepositoryTaskEnded' => [ 'base' => '<p>The data repository task could not be canceled because the task has already ended.</p>', 'refs' => [], ], 'DataRepositoryTaskExecuting' => [ 'base' => '<p>An existing data repository task is currently executing on the file system. Wait until the existing task has completed, then create the new task.</p>', 'refs' => [], ], 'DataRepositoryTaskFailureDetails' => [ 'base' => '<p>Provides information about why a data repository task failed. Only populated when the task <code>Lifecycle</code> is set to <code>FAILED</code>.</p>', 'refs' => [ 'DataRepositoryTask$FailureDetails' => '<p>Failure message describing why the task failed, it is populated only when <code>Lifecycle</code> is set to <code>FAILED</code>.</p>', ], ], 'DataRepositoryTaskFilter' => [ 'base' => '<p>(Optional) An array of filter objects you can use to filter the response of data repository tasks you will see in the the response. You can filter the tasks returned in the response by one or more file system IDs, task lifecycles, and by task type. A filter object consists of a filter <code>Name</code>, and one or more <code>Values</code> for the filter.</p>', 'refs' => [ 'DataRepositoryTaskFilters$member' => NULL, ], ], 'DataRepositoryTaskFilterName' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTaskFilter$Name' => '<p>Name of the task property to use in filtering the tasks returned in the response.</p> <ul> <li> <p>Use <code>file-system-id</code> to retrieve data repository tasks for specific file systems.</p> </li> <li> <p>Use <code>task-lifecycle</code> to retrieve data repository tasks with one or more specific lifecycle states, as follows: CANCELED, EXECUTING, FAILED, PENDING, and SUCCEEDED.</p> </li> </ul>', ], ], 'DataRepositoryTaskFilterValue' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTaskFilterValues$member' => NULL, ], ], 'DataRepositoryTaskFilterValues' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTaskFilter$Values' => '<p>Use Values to include the specific file system IDs and task lifecycle states for the filters you are using.</p>', ], ], 'DataRepositoryTaskFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeDataRepositoryTasksRequest$Filters' => '<p>(Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to include just tasks for specific file systems, or tasks in a specific lifecycle state.</p>', ], ], 'DataRepositoryTaskLifecycle' => [ 'base' => NULL, 'refs' => [ 'CancelDataRepositoryTaskResponse$Lifecycle' => '<p>The lifecycle status of the data repository task, as follows:</p> <ul> <li> <p> <code>PENDING</code> - Amazon FSx has not started the task.</p> </li> <li> <p> <code>EXECUTING</code> - Amazon FSx is processing the task.</p> </li> <li> <p> <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task failures.</p> </li> <li> <p> <code>SUCCEEDED</code> - FSx completed the task successfully.</p> </li> <li> <p> <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p> </li> <li> <p> <code>CANCELING</code> - FSx is in process of canceling the task.</p> </li> </ul>', 'DataRepositoryTask$Lifecycle' => '<p>The lifecycle status of the data repository task, as follows:</p> <ul> <li> <p> <code>PENDING</code> - Amazon FSx has not started the task.</p> </li> <li> <p> <code>EXECUTING</code> - Amazon FSx is processing the task.</p> </li> <li> <p> <code>FAILED</code> - Amazon FSx was not able to complete the task. For example, there may be files the task failed to process. The <a>DataRepositoryTaskFailureDetails</a> property provides more information about task failures.</p> </li> <li> <p> <code>SUCCEEDED</code> - FSx completed the task successfully.</p> </li> <li> <p> <code>CANCELED</code> - Amazon FSx canceled the task and it did not complete.</p> </li> <li> <p> <code>CANCELING</code> - FSx is in process of canceling the task.</p> </li> </ul> <note> <p>You cannot delete an FSx for Lustre file system if there are data repository tasks for the file system in the <code>PENDING</code> or <code>EXECUTING</code> states. Please retry when the data repository task is finished (with a status of <code>CANCELED</code>, <code>SUCCEEDED</code>, or <code>FAILED</code>). You can use the DescribeDataRepositoryTask action to monitor the task status. Contact the FSx team if you need to delete your file system immediately.</p> </note>', ], ], 'DataRepositoryTaskNotFound' => [ 'base' => '<p>The data repository task or tasks you specified could not be found.</p>', 'refs' => [], ], 'DataRepositoryTaskPath' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTaskPaths$member' => NULL, ], ], 'DataRepositoryTaskPaths' => [ 'base' => NULL, 'refs' => [ 'CreateDataRepositoryTaskRequest$Paths' => '<p>A list of paths for the data repository task to use when the task is processed. If a path that you provide isn\'t valid, the task fails.</p> <ul> <li> <p>For export tasks, the list contains paths on the Amazon FSx file system from which the files are exported to the Amazon S3 bucket. The default path is the file system root directory. The paths you provide need to be relative to the mount point of the file system. If the mount point is <code>/mnt/fsx</code> and <code>/mnt/fsx/path1</code> is a directory or file on the file system you want to export, then the path to provide is <code>path1</code>.</p> </li> <li> <p>For import tasks, the list contains paths in the Amazon S3 bucket from which POSIX metadata changes are imported to the Amazon FSx file system. The path can be an S3 bucket or prefix in the format <code>s3://myBucket/myPrefix</code> (where <code>myPrefix</code> is optional).</p> </li> </ul>', 'DataRepositoryTask$Paths' => '<p>An array of paths on the Amazon FSx for Lustre file system that specify the data for the data repository task to process. For example, in an EXPORT_TO_REPOSITORY task, the paths specify which data to export to the linked data repository.</p> <p>(Default) If <code>Paths</code> is not specified, Amazon FSx uses the file system root directory.</p>', ], ], 'DataRepositoryTaskStatus' => [ 'base' => '<p>Provides the task status showing a running total of the total number of files to be processed, the number successfully processed, and the number of files the task failed to process.</p>', 'refs' => [ 'DataRepositoryTask$Status' => '<p>Provides the status of the number of files that the task has processed successfully and failed to process.</p>', ], ], 'DataRepositoryTaskType' => [ 'base' => NULL, 'refs' => [ 'CreateDataRepositoryTaskRequest$Type' => '<p>Specifies the type of data repository task to create.</p>', 'DataRepositoryTask$Type' => '<p>The type of data repository task.</p> <ul> <li> <p>The <code>EXPORT_TO_REPOSITORY</code> data repository task exports from your Lustre file system from to a linked S3 bucket.</p> </li> <li> <p>The <code>IMPORT_METADATA_FROM_REPOSITORY</code> data repository task imports metadata changes from a linked S3 bucket to your Lustre file system.</p> </li> </ul>', ], ], 'DataRepositoryTasks' => [ 'base' => NULL, 'refs' => [ 'DescribeDataRepositoryTasksResponse$DataRepositoryTasks' => '<p>The collection of data repository task descriptions returned.</p>', ], ], 'DeleteBackupRequest' => [ 'base' => '<p>The request object for the <code>DeleteBackup</code> operation.</p>', 'refs' => [], ], 'DeleteBackupResponse' => [ 'base' => '<p>The response object for the <code>DeleteBackup</code> operation.</p>', 'refs' => [], ], 'DeleteDataInFileSystem' => [ 'base' => NULL, 'refs' => [ 'DeleteDataRepositoryAssociationRequest$DeleteDataInFileSystem' => '<p>Set to <code>true</code> to delete the data in the file system that corresponds to the data repository association.</p>', 'DeleteDataRepositoryAssociationResponse$DeleteDataInFileSystem' => '<p>Indicates whether data in the file system that corresponds to the data repository association is being deleted. Default is <code>false</code>.</p>', ], ], 'DeleteDataRepositoryAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDataRepositoryAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFileSystemLustreConfiguration' => [ 'base' => '<p>The configuration object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>', 'refs' => [ 'DeleteFileSystemRequest$LustreConfiguration' => NULL, ], ], 'DeleteFileSystemLustreResponse' => [ 'base' => '<p>The response object for the Amazon FSx for Lustre file system being deleted in the <code>DeleteFileSystem</code> operation.</p>', 'refs' => [ 'DeleteFileSystemResponse$LustreResponse' => NULL, ], ], 'DeleteFileSystemOpenZFSConfiguration' => [ 'base' => '<p>The configuration object for the Amazon FSx for OpenZFS file system used in the <code>DeleteFileSystem</code> operation.</p>', 'refs' => [ 'DeleteFileSystemRequest$OpenZFSConfiguration' => '<p>The configuration object for the OpenZFS file system used in the <code>DeleteFileSystem</code> operation.</p>', ], ], 'DeleteFileSystemOpenZFSOption' => [ 'base' => NULL, 'refs' => [ 'DeleteFileSystemOpenZFSOptions$member' => NULL, ], ], 'DeleteFileSystemOpenZFSOptions' => [ 'base' => NULL, 'refs' => [ 'DeleteFileSystemOpenZFSConfiguration$Options' => '<p>To delete a file system if there are child volumes present below the root volume, use the string <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don\'t use this option, the delete request will fail.</p>', ], ], 'DeleteFileSystemOpenZFSResponse' => [ 'base' => '<p>The response object for the Amazon FSx for OpenZFS file system that\'s being deleted in the <code>DeleteFileSystem</code> operation.</p>', 'refs' => [ 'DeleteFileSystemResponse$OpenZFSResponse' => '<p>The response object for the OpenZFS file system that\'s being deleted in the <code>DeleteFileSystem</code> operation.</p>', ], ], 'DeleteFileSystemRequest' => [ 'base' => '<p>The request object for <code>DeleteFileSystem</code> operation.</p>', 'refs' => [], ], 'DeleteFileSystemResponse' => [ 'base' => '<p>The response object for the <code>DeleteFileSystem</code> operation.</p>', 'refs' => [], ], 'DeleteFileSystemWindowsConfiguration' => [ 'base' => '<p>The configuration object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>', 'refs' => [ 'DeleteFileSystemRequest$WindowsConfiguration' => NULL, ], ], 'DeleteFileSystemWindowsResponse' => [ 'base' => '<p>The response object for the Microsoft Windows file system used in the <code>DeleteFileSystem</code> operation.</p>', 'refs' => [ 'DeleteFileSystemResponse$WindowsResponse' => NULL, ], ], 'DeleteOpenZFSVolumeOption' => [ 'base' => NULL, 'refs' => [ 'DeleteOpenZFSVolumeOptions$member' => NULL, ], ], 'DeleteOpenZFSVolumeOptions' => [ 'base' => NULL, 'refs' => [ 'DeleteVolumeOpenZFSConfiguration$Options' => '<p>To delete the volume\'s child volumes, snapshots, and clones, use the string <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>.</p>', ], ], 'DeleteSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageVirtualMachineRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteStorageVirtualMachineResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVolumeOntapConfiguration' => [ 'base' => '<p>Use to specify skipping a final backup, or to add tags to a final backup.</p>', 'refs' => [ 'DeleteVolumeRequest$OntapConfiguration' => '<p>For Amazon FSx for ONTAP volumes, specify whether to take a final backup of the volume and apply tags to the backup. To apply tags to the backup, you must have the <code>fsx:TagResource</code> permission.</p>', ], ], 'DeleteVolumeOntapResponse' => [ 'base' => '<p>The response object for the Amazon FSx for NetApp ONTAP volume being deleted in the <code>DeleteVolume</code> operation.</p>', 'refs' => [ 'DeleteVolumeResponse$OntapResponse' => '<p>Returned after a <code>DeleteVolume</code> request, showing the status of the delete request.</p>', ], ], 'DeleteVolumeOpenZFSConfiguration' => [ 'base' => '<p>A value that specifies whether to delete all child volumes and snapshots. </p>', 'refs' => [ 'DeleteVolumeRequest$OpenZFSConfiguration' => '<p>For Amazon FSx for OpenZFS volumes, specify whether to delete all child volumes and snapshots.</p>', ], ], 'DeleteVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVolumeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBackupsRequest' => [ 'base' => '<p>The request object for the <code>DescribeBackups</code> operation.</p>', 'refs' => [], ], 'DescribeBackupsResponse' => [ 'base' => '<p>Response object for the <code>DescribeBackups</code> operation.</p>', 'refs' => [], ], 'DescribeDataRepositoryAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataRepositoryAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataRepositoryTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataRepositoryTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFileSystemAliasesRequest' => [ 'base' => '<p>The request object for <code>DescribeFileSystemAliases</code> operation.</p>', 'refs' => [], ], 'DescribeFileSystemAliasesResponse' => [ 'base' => '<p>The response object for <code>DescribeFileSystemAliases</code> operation.</p>', 'refs' => [], ], 'DescribeFileSystemsRequest' => [ 'base' => '<p>The request object for <code>DescribeFileSystems</code> operation.</p>', 'refs' => [], ], 'DescribeFileSystemsResponse' => [ 'base' => '<p>The response object for <code>DescribeFileSystems</code> operation.</p>', 'refs' => [], ], 'DescribeSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorageVirtualMachinesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeStorageVirtualMachinesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVolumesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DirectoryId' => [ 'base' => NULL, 'refs' => [ 'ActiveDirectoryBackupAttributes$ActiveDirectoryId' => '<p>The ID of the Amazon Web Services Managed Microsoft Active Directory instance to which the file system is joined.</p>', 'ActiveDirectoryError$ActiveDirectoryId' => '<p>The directory ID of the directory that an error pertains to.</p>', 'CreateFileSystemWindowsConfiguration$ActiveDirectoryId' => '<p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory (AD) instance that the file system should join when it\'s created.</p>', 'WindowsFileSystemConfiguration$ActiveDirectoryId' => '<p>The ID for an existing Amazon Web Services Managed Microsoft Active Directory instance that the file system is joined to.</p>', ], ], 'DirectoryPassword' => [ 'base' => NULL, 'refs' => [ 'SelfManagedActiveDirectoryConfiguration$Password' => '<p>The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.</p>', 'SelfManagedActiveDirectoryConfigurationUpdates$Password' => '<p>The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.</p>', ], ], 'DirectoryUserName' => [ 'base' => NULL, 'refs' => [ 'SelfManagedActiveDirectoryAttributes$UserName' => '<p>The user name for the service account on your self-managed AD domain that FSx uses to join to your AD domain.</p>', 'SelfManagedActiveDirectoryConfiguration$UserName' => '<p>The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain. This account must have the permission to join computers to the domain in the organizational unit provided in <code>OrganizationalUnitDistinguishedName</code>, or in the default location of your AD domain.</p>', 'SelfManagedActiveDirectoryConfigurationUpdates$UserName' => '<p>The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain. This account must have the permission to join computers to the domain in the organizational unit provided in <code>OrganizationalUnitDistinguishedName</code>.</p>', ], ], 'DisassociateFileSystemAliasesRequest' => [ 'base' => '<p>The request object of DNS aliases to disassociate from an Amazon FSx for Windows File Server file system.</p>', 'refs' => [], ], 'DisassociateFileSystemAliasesResponse' => [ 'base' => '<p>The system generated response showing the DNS aliases that Amazon FSx is attempting to disassociate from the file system. Use the API operation to monitor the status of the aliases Amazon FSx is removing from the file system.</p>', 'refs' => [], ], 'DiskIopsConfiguration' => [ 'base' => '<p>The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS file system. The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS per GB of storage. The configuration consists of the total number of provisioned SSD IOPS and how the amount was provisioned (by the customer or by the system).</p>', 'refs' => [ 'CreateFileSystemOntapConfiguration$DiskIopsConfiguration' => '<p>The SSD IOPS configuration for the FSx for ONTAP file system.</p>', 'CreateFileSystemOpenZFSConfiguration$DiskIopsConfiguration' => NULL, 'OntapFileSystemConfiguration$DiskIopsConfiguration' => '<p>The SSD IOPS configuration for the ONTAP file system, specifying the number of provisioned IOPS and the provision mode.</p>', 'OpenZFSFileSystemConfiguration$DiskIopsConfiguration' => NULL, 'UpdateFileSystemOntapConfiguration$DiskIopsConfiguration' => '<p>The SSD IOPS (input/output operations per second) configuration for an Amazon FSx for NetApp ONTAP file system. The default is 3 IOPS per GB of storage capacity, but you can provision additional IOPS per GB of storage. The configuration consists of an IOPS mode (<code>AUTOMATIC</code> or <code>USER_PROVISIONED</code>), and in the case of <code>USER_PROVISIONED</code> IOPS, the total number of SSD IOPS provisioned.</p>', 'UpdateFileSystemOpenZFSConfiguration$DiskIopsConfiguration' => NULL, ], ], 'DiskIopsConfigurationMode' => [ 'base' => NULL, 'refs' => [ 'DiskIopsConfiguration$Mode' => '<p>Specifies whether the number of IOPS for the file system is using the system default (<code>AUTOMATIC</code>) or was provisioned by the customer (<code>USER_PROVISIONED</code>).</p>', ], ], 'DnsIps' => [ 'base' => NULL, 'refs' => [ 'SelfManagedActiveDirectoryAttributes$DnsIps' => '<p>A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.</p>', 'SelfManagedActiveDirectoryConfiguration$DnsIps' => '<p>A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory. </p>', 'SelfManagedActiveDirectoryConfigurationUpdates$DnsIps' => '<p>A list of up to three IP addresses of DNS servers or domain controllers in the self-managed AD directory.</p>', ], ], 'DriveCacheType' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemLustreConfiguration$DriveCacheType' => '<p>The type of drive cache used by <code>PERSISTENT_1</code> file systems that are provisioned with HDD storage devices. This parameter is required when storage type is HDD. Set this property to <code>READ</code> to improve the performance for frequently accessed files by caching up to 20% of the total storage capacity of the file system.</p> <p>This parameter is required when <code>StorageType</code> is set to <code>HDD</code>.</p>', 'LustreFileSystemConfiguration$DriveCacheType' => '<p>The type of drive cache used by <code>PERSISTENT_1</code> file systems that are provisioned with HDD storage devices. This parameter is required when <code>StorageType</code> is HDD. When set to <code>READ</code> the file system has an SSD storage cache that is sized to 20% of the file system\'s storage capacity. This improves the performance for frequently accessed files by caching up to 20% of the total storage capacity.</p> <p>This parameter is required when <code>StorageType</code> is set to HDD.</p>', ], ], 'EndTime' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTask$EndTime' => '<p>The time that Amazon FSx completed processing the task, populated after the task is complete.</p>', ], ], 'ErrorMessage' => [ 'base' => '<p>A detailed error message.</p>', 'refs' => [ 'ActiveDirectoryError$Message' => NULL, 'AdministrativeActionFailureDetails$Message' => '<p>Error message providing details about the failed administrative action.</p>', 'BackupBeingCopied$Message' => NULL, 'BackupFailureDetails$Message' => '<p>A message describing the backup-creation failure.</p>', 'BackupInProgress$Message' => NULL, 'BackupNotFound$Message' => NULL, 'BackupRestoring$Message' => NULL, 'BadRequest$Message' => NULL, 'DataRepositoryAssociationNotFound$Message' => NULL, 'DataRepositoryFailureDetails$Message' => NULL, 'DataRepositoryTaskEnded$Message' => NULL, 'DataRepositoryTaskExecuting$Message' => NULL, 'DataRepositoryTaskFailureDetails$Message' => NULL, 'DataRepositoryTaskNotFound$Message' => NULL, 'FileSystemFailureDetails$Message' => '<p>A message describing any failures that occurred during file system creation.</p>', 'FileSystemNotFound$Message' => NULL, 'IncompatibleParameterError$Message' => NULL, 'IncompatibleRegionForMultiAZ$Message' => NULL, 'InternalServerError$Message' => NULL, 'InvalidDataRepositoryType$Message' => NULL, 'InvalidDestinationKmsKey$Message' => NULL, 'InvalidExportPath$Message' => NULL, 'InvalidImportPath$Message' => NULL, 'InvalidNetworkSettings$Message' => '<p>Error message explaining what\'s wrong with network settings.</p>', 'InvalidPerUnitStorageThroughput$Message' => NULL, 'InvalidRegion$Message' => NULL, 'InvalidSourceKmsKey$Message' => NULL, 'LifecycleTransitionReason$Message' => NULL, 'MissingFileSystemConfiguration$Message' => NULL, 'MissingVolumeConfiguration$Message' => NULL, 'NotServiceResourceError$Message' => NULL, 'ResourceDoesNotSupportTagging$Message' => NULL, 'ResourceNotFound$Message' => NULL, 'ServiceLimitExceeded$Message' => NULL, 'SnapshotNotFound$Message' => NULL, 'SourceBackupUnavailable$Message' => NULL, 'StorageVirtualMachineNotFound$Message' => NULL, 'UnsupportedOperation$Message' => NULL, 'VolumeNotFound$Message' => NULL, ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'EventTypes$member' => NULL, ], ], 'EventTypes' => [ 'base' => NULL, 'refs' => [ 'AutoExportPolicy$Events' => '<p>The <code>AutoExportPolicy</code> can have the following event values:</p> <ul> <li> <p> <code>NEW</code> - Amazon FSx automatically exports new files and directories to the data repository as they are added to the file system.</p> </li> <li> <p> <code>CHANGED</code> - Amazon FSx automatically exports changes to files and directories on the file system to the data repository.</p> </li> <li> <p> <code>DELETED</code> - Files and directories are automatically deleted on the data repository when they are deleted on the file system.</p> </li> </ul> <p>You can define any combination of event types for your <code>AutoExportPolicy</code>.</p>', 'AutoImportPolicy$Events' => '<p>The <code>AutoImportPolicy</code> can have the following event values:</p> <ul> <li> <p> <code>NEW</code> - Amazon FSx automatically imports metadata of files added to the linked S3 bucket that do not currently exist in the FSx file system.</p> </li> <li> <p> <code>CHANGED</code> - Amazon FSx automatically updates file metadata and invalidates existing file content on the file system as files change in the data repository.</p> </li> <li> <p> <code>DELETED</code> - Amazon FSx automatically deletes files on the file system as corresponding files are deleted in the data repository.</p> </li> </ul> <p>You can define any combination of event types for your <code>AutoImportPolicy</code>.</p>', ], ], 'FailedCount' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTaskStatus$FailedCount' => '<p>A running total of the number of files that the task failed to process.</p>', ], ], 'FileSystem' => [ 'base' => '<p>A description of a specific Amazon FSx file system.</p>', 'refs' => [ 'AdministrativeAction$TargetFileSystemValues' => '<p>Describes the target value for the administration action, provided in the <code>UpdateFileSystem</code> operation. Returned for <code>FILE_SYSTEM_UPDATE</code> administrative actions. </p>', 'Backup$FileSystem' => '<p>The metadata of the file system associated with the backup. This metadata is persisted even if the file system is deleted.</p>', 'CreateFileSystemFromBackupResponse$FileSystem' => '<p>A description of the file system.</p>', 'CreateFileSystemResponse$FileSystem' => '<p>The configuration of the file system that was created.</p>', 'FileSystems$member' => NULL, 'ReleaseFileSystemNfsV3LocksResponse$FileSystem' => NULL, 'UpdateFileSystemResponse$FileSystem' => '<p>A description of the file system that was updated.</p>', ], ], 'FileSystemAdministratorsGroupName' => [ 'base' => NULL, 'refs' => [ 'SelfManagedActiveDirectoryAttributes$FileSystemAdministratorsGroup' => '<p>The name of the domain group whose members have administrative privileges for the FSx file system.</p>', 'SelfManagedActiveDirectoryConfiguration$FileSystemAdministratorsGroup' => '<p>(Optional) The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, setting audit controls (audit ACLs) on files and folders, and administering the file system remotely by using the FSx Remote PowerShell. The group that you specify must already exist in your domain. If you don\'t provide one, your AD domain\'s Domain Admins group is used.</p>', ], ], 'FileSystemEndpoint' => [ 'base' => '<p>An Amazon FSx for NetApp ONTAP file system has two endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. They are the <code>Management</code> and <code>Intercluster</code> endpoints.</p>', 'refs' => [ 'FileSystemEndpoints$Intercluster' => '<p>An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems.</p>', 'FileSystemEndpoints$Management' => '<p>An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API.</p>', ], ], 'FileSystemEndpoints' => [ 'base' => '<p>An Amazon FSx for NetApp ONTAP file system has the following endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror.</p>', 'refs' => [ 'OntapFileSystemConfiguration$Endpoints' => '<p>The <code>Management</code> and <code>Intercluster</code> endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror.</p>', ], ], 'FileSystemFailureDetails' => [ 'base' => '<p>A structure providing details of any failures that occurred when creating a file system.</p>', 'refs' => [ 'FileSystem$FailureDetails' => NULL, ], ], 'FileSystemId' => [ 'base' => '<p>The globally unique ID of the file system, assigned by Amazon FSx.</p>', 'refs' => [ 'AssociateFileSystemAliasesRequest$FileSystemId' => '<p>Specifies the file system with which you want to associate one or more DNS aliases.</p>', 'BackupRestoring$FileSystemId' => '<p>The ID of a file system being restored from the backup.</p>', 'CreateBackupRequest$FileSystemId' => '<p>The ID of the file system to back up.</p>', 'CreateDataRepositoryAssociationRequest$FileSystemId' => NULL, 'CreateDataRepositoryTaskRequest$FileSystemId' => NULL, 'CreateStorageVirtualMachineRequest$FileSystemId' => NULL, 'DataRepositoryAssociation$FileSystemId' => NULL, 'DataRepositoryTask$FileSystemId' => NULL, 'DeleteFileSystemRequest$FileSystemId' => '<p>The ID of the file system that you want to delete.</p>', 'DeleteFileSystemResponse$FileSystemId' => '<p>The ID of the file system that\'s being deleted.</p>', 'DescribeFileSystemAliasesRequest$FileSystemId' => '<p>The ID of the file system to return the associated DNS aliases for (String).</p>', 'DisassociateFileSystemAliasesRequest$FileSystemId' => '<p>Specifies the file system from which to disassociate the DNS aliases.</p>', 'FileSystem$FileSystemId' => '<p>The system-generated, unique 17-digit ID of the file system.</p>', 'FileSystemIds$member' => NULL, 'ReleaseFileSystemNfsV3LocksRequest$FileSystemId' => NULL, 'StorageVirtualMachine$FileSystemId' => NULL, 'UpdateFileSystemRequest$FileSystemId' => '<p>The ID of the file system that you are updating.</p>', 'Volume$FileSystemId' => NULL, ], ], 'FileSystemIds' => [ 'base' => '<p>A list of file system IDs.</p>', 'refs' => [ 'DescribeFileSystemsRequest$FileSystemIds' => '<p>IDs of the file systems whose descriptions you want to retrieve (String).</p>', ], ], 'FileSystemLifecycle' => [ 'base' => '<p>The lifecycle status of the file system.</p>', 'refs' => [ 'DeleteFileSystemResponse$Lifecycle' => '<p>The file system lifecycle for the deletion request. If the <code>DeleteFileSystem</code> operation is successful, this status is <code>DELETING</code>.</p>', 'FileSystem$Lifecycle' => '<p>The lifecycle status of the file system. The following are the possible values and what they mean:</p> <ul> <li> <p> <code>AVAILABLE</code> - The file system is in a healthy state, and is reachable and available for use.</p> </li> <li> <p> <code>CREATING</code> - Amazon FSx is creating the new file system.</p> </li> <li> <p> <code>DELETING</code> - Amazon FSx is deleting an existing file system.</p> </li> <li> <p> <code>FAILED</code> - An existing file system has experienced an unrecoverable failure. When creating a new file system, Amazon FSx was unable to create the file system.</p> </li> <li> <p> <code>MISCONFIGURED</code> - The file system is in a failed but recoverable state.</p> </li> <li> <p> <code>MISCONFIGURED_UNAVAILABLE</code> - (Amazon FSx for Windows File Server only) The file system is currently unavailable due to a change in your Active Directory configuration.</p> </li> <li> <p> <code>UPDATING</code> - The file system is undergoing a customer-initiated update.</p> </li> </ul>', ], ], 'FileSystemMaintenanceOperation' => [ 'base' => '<p>An enumeration specifying the currently ongoing maintenance operation.</p>', 'refs' => [ 'FileSystemMaintenanceOperations$member' => NULL, ], ], 'FileSystemMaintenanceOperations' => [ 'base' => '<p>A list of maintenance operations.</p>', 'refs' => [ 'WindowsFileSystemConfiguration$MaintenanceOperationsInProgress' => '<p>The list of maintenance operations in progress for this file system.</p>', ], ], 'FileSystemNotFound' => [ 'base' => '<p>No Amazon FSx file systems were found based upon supplied parameters.</p>', 'refs' => [], ], 'FileSystemType' => [ 'base' => '<p>The type of file system.</p>', 'refs' => [ 'CreateFileSystemRequest$FileSystemType' => '<p>The type of Amazon FSx file system to create. Valid values are <code>WINDOWS</code>, <code>LUSTRE</code>, <code>ONTAP</code>, and <code>OPENZFS</code>.</p>', 'FileSystem$FileSystemType' => '<p>The type of Amazon FSx file system, which can be <code>LUSTRE</code>, <code>WINDOWS</code>, <code>ONTAP</code>, or <code>OPENZFS</code>.</p>', ], ], 'FileSystemTypeVersion' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemFromBackupRequest$FileSystemTypeVersion' => '<p>Sets the version for the Amazon FSx for Lustre file system that you\'re creating from a backup. Valid values are <code>2.10</code> and <code>2.12</code>.</p> <p>You don\'t need to specify <code>FileSystemTypeVersion</code> because it will be applied using the backup\'s <code>FileSystemTypeVersion</code> setting. If you choose to specify <code>FileSystemTypeVersion</code> when creating from backup, the value must match the backup\'s <code>FileSystemTypeVersion</code> setting.</p>', 'CreateFileSystemRequest$FileSystemTypeVersion' => '<p>(Optional) For FSx for Lustre file systems, sets the Lustre version for the file system that you\'re creating. Valid values are <code>2.10</code> and <code>2.12</code>:</p> <ul> <li> <p>2.10 is supported by the Scratch and Persistent_1 Lustre deployment types.</p> </li> <li> <p>2.12 is supported by all Lustre deployment types. <code>2.12</code> is required when setting FSx for Lustre <code>DeploymentType</code> to <code>PERSISTENT_2</code>.</p> </li> </ul> <p>Default value = <code>2.10</code>, except when <code>DeploymentType</code> is set to <code>PERSISTENT_2</code>, then the default is <code>2.12</code>.</p> <note> <p>If you set <code>FileSystemTypeVersion</code> to <code>2.10</code> for a <code>PERSISTENT_2</code> Lustre deployment type, the <code>CreateFileSystem</code> operation fails.</p> </note>', 'FileSystem$FileSystemTypeVersion' => '<p>The Lustre version of the Amazon FSx for Lustre file system, either <code>2.10</code> or <code>2.12</code>.</p>', ], ], 'FileSystems' => [ 'base' => '<p>A list of file system resource descriptions.</p>', 'refs' => [ 'DescribeFileSystemsResponse$FileSystems' => '<p>An array of file system descriptions.</p>', ], ], 'Filter' => [ 'base' => '<p>A filter used to restrict the results of describe calls. You can use multiple filters to return results that meet all applied filter requirements.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterName' => [ 'base' => '<p>The name for a filter.</p>', 'refs' => [ 'Filter$Name' => '<p>The name for this filter.</p>', ], ], 'FilterValue' => [ 'base' => '<p>The value for a filter.</p>', 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => '<p>A list of filter values.</p>', 'refs' => [ 'Filter$Values' => '<p>The values of the filter. These are all the values for any of the applied filters.</p>', ], ], 'Filters' => [ 'base' => '<p>A list of <code>Filter</code> elements.</p>', 'refs' => [ 'DescribeBackupsRequest$Filters' => '<p>The filters structure. The supported names are <code>file-system-id</code>, <code>backup-type</code>, <code>file-system-type</code>, and <code>volume-id</code>.</p>', 'DescribeDataRepositoryAssociationsRequest$Filters' => NULL, ], ], 'Flag' => [ 'base' => NULL, 'refs' => [ 'CompletionReport$Enabled' => '<p>Set <code>Enabled</code> to <code>True</code> to generate a <code>CompletionReport</code> when the task completes. If set to <code>true</code>, then you need to provide a report <code>Scope</code>, <code>Path</code>, and <code>Format</code>. Set <code>Enabled</code> to <code>False</code> if you do not want a <code>CompletionReport</code> generated when the task completes.</p>', 'CopyBackupRequest$CopyTags' => '<p>A Boolean flag indicating whether tags from the source backup should be copied to the backup copy. This value defaults to <code>false</code>.</p> <p>If you set <code>CopyTags</code> to <code>true</code> and the source backup has existing tags, you can use the <code>Tags</code> parameter to create new tags, provided that the sum of the source backup tags and the new tags doesn\'t exceed 50. Both sets of tags are merged. If there are tag conflicts (for example, two tags with the same key but different values), the tags created with the <code>Tags</code> parameter take precedence.</p>', 'CreateFileSystemLustreConfiguration$CopyTagsToBackups' => '<p>(Optional) Not available for use with file systems that are linked to a data repository. A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false. If <code>CopyTagsToBackups</code> is set to true, all file system tags are copied to all automatic and user-initiated backups when the user doesn\'t specify any backup-specific tags. If <code>CopyTagsToBackups</code> is set to true and you specify one or more backup tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.</p> <p>(Default = <code>false</code>)</p> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-backups-fsx.html"> Working with backups</a> in the <i>Amazon FSx for Lustre User Guide</i>.</p>', 'CreateFileSystemOpenZFSConfiguration$CopyTagsToBackups' => '<p>A Boolean value indicating whether tags for the file system should be copied to backups. This value defaults to <code>false</code>. If it\'s set to <code>true</code>, all tags for the file system are copied to all automatic and user-initiated backups where the user doesn\'t specify tags. If this value is <code>true</code>, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.</p>', 'CreateFileSystemOpenZFSConfiguration$CopyTagsToVolumes' => '<p>A Boolean value indicating whether tags for the file system should be copied to volumes. This value defaults to <code>false</code>. If it\'s set to <code>true</code>, all tags for the file system are copied to volumes where the user doesn\'t specify tags. If this value is <code>true</code>, and you specify one or more tags, only the specified tags are copied to volumes. If you specify one or more tags when creating the volume, no tags are copied from the file system, regardless of this value.</p>', 'CreateFileSystemWindowsConfiguration$CopyTagsToBackups' => '<p>A boolean flag indicating whether tags for the file system should be copied to backups. This value defaults to false. If it\'s set to true, all tags for the file system are copied to all automatic and user-initiated backups where the user doesn\'t specify tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.</p>', 'CreateOntapVolumeConfiguration$StorageEfficiencyEnabled' => '<p>Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.</p>', 'CreateOpenZFSVolumeConfiguration$CopyTagsToSnapshots' => '<p>A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to <code>false</code>. If it\'s set to <code>true</code>, all tags for the volume are copied to snapshots where the user doesn\'t specify tags. If this value is <code>true</code>, and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.</p>', 'DeleteFileSystemLustreConfiguration$SkipFinalBackup' => '<p>Set <code>SkipFinalBackup</code> to false if you want to take a final backup of the file system you are deleting. By default, Amazon FSx will not take a final backup on your behalf when the <code>DeleteFileSystem</code> operation is invoked. (Default = true)</p> <note> <p>The <code>fsx:CreateBackup</code> permission is required if you set <code>SkipFinalBackup</code> to <code>false</code> in order to delete the file system and take a final backup.</p> </note>', 'DeleteFileSystemOpenZFSConfiguration$SkipFinalBackup' => '<p>By default, Amazon FSx for OpenZFS takes a final backup on your behalf when the <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you from data loss, and we highly recommend taking the final backup. If you want to skip taking a final backup, set this value to <code>true</code>.</p>', 'DeleteFileSystemWindowsConfiguration$SkipFinalBackup' => '<p>By default, Amazon FSx for Windows takes a final backup on your behalf when the <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you from data loss, and we highly recommend taking the final backup. If you want to skip this backup, use this flag to do so.</p>', 'DeleteVolumeOntapConfiguration$SkipFinalBackup' => '<p>Set to true if you want to skip taking a final backup of the volume you are deleting.</p>', 'LustreFileSystemConfiguration$CopyTagsToBackups' => '<p>A boolean flag indicating whether tags on the file system are copied to backups. If it\'s set to true, all tags on the file system are copied to all automatic backups and any user-initiated backups where the user doesn\'t specify any tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value. (Default = false)</p>', 'OntapVolumeConfiguration$StorageEfficiencyEnabled' => '<p>The volume\'s storage efficiency setting.</p>', 'OntapVolumeConfiguration$StorageVirtualMachineRoot' => '<p>A Boolean flag indicating whether this volume is the root volume for its storage virtual machine (SVM). Only one volume on an SVM can be the root volume. This value defaults to <code>false</code>. If this value is <code>true</code>, then this is the SVM root volume.</p> <p>This flag is useful when you\'re deleting an SVM, because you must first delete all non-root volumes. This flag, when set to <code>false</code>, helps you identify which volumes to delete before you can delete the SVM.</p>', 'OpenZFSCreateRootVolumeConfiguration$CopyTagsToSnapshots' => '<p>A Boolean value indicating whether tags for the volume should be copied to snapshots of the volume. This value defaults to <code>false</code>. If it\'s set to <code>true</code>, all tags for the volume are copied to snapshots where the user doesn\'t specify tags. If this value is <code>true</code> and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value. </p>', 'OpenZFSFileSystemConfiguration$CopyTagsToBackups' => '<p>A Boolean value indicating whether tags on the file system should be copied to backups. If it\'s set to <code>true</code>, all tags on the file system are copied to all automatic backups and any user-initiated backups where the user doesn\'t specify any tags. If this value is <code>true</code> and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value. </p>', 'OpenZFSFileSystemConfiguration$CopyTagsToVolumes' => '<p>A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to <code>false</code>. If it\'s set to <code>true</code>, all tags for the volume are copied to snapshots where the user doesn\'t specify tags. If this value is <code>true</code> and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value. </p>', 'OpenZFSVolumeConfiguration$CopyTagsToSnapshots' => '<p>A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to <code>false</code>. If it\'s set to <code>true</code>, all tags for the volume are copied to snapshots where the user doesn\'t specify tags. If this value is <code>true</code> and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.</p>', 'UpdateFileSystemOpenZFSConfiguration$CopyTagsToBackups' => '<p>A Boolean value indicating whether tags for the file system should be copied to backups. This value defaults to <code>false</code>. If it\'s set to <code>true</code>, all tags for the file system are copied to all automatic and user-initiated backups where the user doesn\'t specify tags. If this value is <code>true</code> and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.</p>', 'UpdateFileSystemOpenZFSConfiguration$CopyTagsToVolumes' => '<p>A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to <code>false</code>. If it\'s set to <code>true</code>, all tags for the volume are copied to snapshots where the user doesn\'t specify tags. If this value is <code>true</code> and you specify one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are copied from the volume, regardless of this value.</p>', 'UpdateOntapVolumeConfiguration$StorageEfficiencyEnabled' => '<p>Default is <code>false</code>. Set to true to enable the deduplication, compression, and compaction storage efficiency features on the volume.</p>', 'WindowsFileSystemConfiguration$CopyTagsToBackups' => '<p>A boolean flag indicating whether tags on the file system should be copied to backups. This value defaults to false. If it\'s set to true, all tags on the file system are copied to all automatic backups and any user-initiated backups where the user doesn\'t specify any tags. If this value is true, and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this value.</p>', ], ], 'FlexCacheEndpointType' => [ 'base' => NULL, 'refs' => [ 'OntapVolumeConfiguration$FlexCacheEndpointType' => '<p>Specifies the FlexCache endpoint type of the volume. Valid values are the following:</p> <ul> <li> <p> <code>NONE</code> specifies that the volume doesn\'t have a FlexCache configuration. <code>NONE</code> is the default.</p> </li> <li> <p> <code>ORIGIN</code> specifies that the volume is the origin volume for a FlexCache volume.</p> </li> <li> <p> <code>CACHE</code> specifies that the volume is a FlexCache volume.</p> </li> </ul>', ], ], 'GeneralARN' => [ 'base' => NULL, 'refs' => [ 'LustreLogConfiguration$Destination' => '<p>The Amazon Resource Name (ARN) that specifies the destination of the logs. The destination can be any Amazon CloudWatch Logs log group ARN. The destination ARN must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>', 'LustreLogCreateConfiguration$Destination' => '<p>The Amazon Resource Name (ARN) that specifies the destination of the logs.</p> <p>The destination can be any Amazon CloudWatch Logs log group ARN, with the following requirements:</p> <ul> <li> <p>The destination ARN that you provide must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p> </li> <li> <p>The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix.</p> </li> <li> <p>If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs <code>/aws/fsx/lustre</code> log group.</p> </li> <li> <p>If <code>Destination</code> is provided and the resource does not exist, the request will fail with a <code>BadRequest</code> error.</p> </li> <li> <p>If <code>Level</code> is set to <code>DISABLED</code>, you cannot specify a destination in <code>Destination</code>.</p> </li> </ul>', 'WindowsAuditLogConfiguration$AuditLogDestination' => '<p>The Amazon Resource Name (ARN) for the destination of the audit logs. The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN.</p> <p>The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p> <p>The destination ARN (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p>', 'WindowsAuditLogCreateConfiguration$AuditLogDestination' => '<p>The Amazon Resource Name (ARN) that specifies the destination of the audit logs.</p> <p>The destination can be any Amazon CloudWatch Logs log group ARN or Amazon Kinesis Data Firehose delivery stream ARN, with the following requirements:</p> <ul> <li> <p>The destination ARN that you provide (either CloudWatch Logs log group or Kinesis Data Firehose delivery stream) must be in the same Amazon Web Services partition, Amazon Web Services Region, and Amazon Web Services account as your Amazon FSx file system.</p> </li> <li> <p>The name of the Amazon CloudWatch Logs log group must begin with the <code>/aws/fsx</code> prefix. The name of the Amazon Kinesis Data Firehouse delivery stream must begin with the <code>aws-fsx</code> prefix.</p> </li> <li> <p>If you do not provide a destination in <code>AuditLogDestination</code>, Amazon FSx will create and use a log stream in the CloudWatch Logs <code>/aws/fsx/windows</code> log group.</p> </li> <li> <p>If <code>AuditLogDestination</code> is provided and the resource does not exist, the request will fail with a <code>BadRequest</code> error.</p> </li> <li> <p>If <code>FileAccessAuditLogLevel</code> and <code>FileShareAccessAuditLogLevel</code> are both set to <code>DISABLED</code>, you cannot specify a destination in <code>AuditLogDestination</code>.</p> </li> </ul>', ], ], 'IncompatibleParameterError' => [ 'base' => '<p>The error returned when a second request is received with the same client request token but different parameters settings. A client request token should always uniquely identify a single request.</p>', 'refs' => [], ], 'IncompatibleRegionForMultiAZ' => [ 'base' => '<p>Amazon FSx doesn\'t support Multi-AZ Windows File Server copy backup in the destination Region, so the copied backup can\'t be restored.</p>', 'refs' => [], ], 'IntegerNoMax' => [ 'base' => NULL, 'refs' => [ 'OpenZFSUserOrGroupQuota$Id' => '<p>The ID of the user or group.</p>', 'OpenZFSUserOrGroupQuota$StorageCapacityQuotaGiB' => '<p>The amount of storage that the user or group can use in gibibytes (GiB).</p>', 'OpenZFSVolumeConfiguration$StorageCapacityReservationGiB' => '<p>The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can\'t reserve more storage than the parent volume has reserved.</p>', 'OpenZFSVolumeConfiguration$StorageCapacityQuotaGiB' => '<p>The maximum amount of storage in gibibtyes (GiB) that the volume can use from its parent. You can specify a quota larger than the storage on the parent volume.</p>', ], ], 'IntegerNoMaxFromNegativeOne' => [ 'base' => NULL, 'refs' => [ 'CreateOpenZFSVolumeConfiguration$StorageCapacityReservationGiB' => '<p>Specifies the amount of storage in gibibytes (GiB) to reserve from the parent volume. Setting <code>StorageCapacityReservationGiB</code> guarantees that the specified amount of storage space on the parent volume will always be available for the volume. You can\'t reserve more storage than the parent volume has. To <i>not</i> specify a storage capacity reservation, set this to <code>0</code> or <code>-1</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.</p>', 'CreateOpenZFSVolumeConfiguration$StorageCapacityQuotaGiB' => '<p>Sets the maximum storage size in gibibytes (GiB) for the volume. You can specify a quota that is larger than the storage on the parent volume. A volume quota limits the amount of storage that the volume can consume to the configured amount, but does not guarantee the space will be available on the parent volume. To guarantee quota space, you must also set <code>StorageCapacityReservationGiB</code>. To <i>not</i> specify a storage capacity quota, set this to <code>-1</code>. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/managing-volumes.html#volume-properties">Volume properties</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.</p>', 'UpdateOpenZFSVolumeConfiguration$StorageCapacityReservationGiB' => '<p>The amount of storage in gibibytes (GiB) to reserve from the parent volume. You can\'t reserve more storage than the parent volume has reserved. You can specify a value of <code>-1</code> to unset a volume\'s storage capacity reservation.</p>', 'UpdateOpenZFSVolumeConfiguration$StorageCapacityQuotaGiB' => '<p>The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent. You can specify a quota larger than the storage on the parent volume. You can specify a value of <code>-1</code> to unset a volume\'s storage capacity quota.</p>', ], ], 'IntegerRecordSizeKiB' => [ 'base' => NULL, 'refs' => [ 'CreateOpenZFSVolumeConfiguration$RecordSizeKiB' => '<p>Specifies the suggested block size for a volume in a ZFS dataset, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. We recommend using the default setting for the majority of use cases. Generally, workloads that write in fixed small or large record sizes may benefit from setting a custom record size, like database workloads (small record size) or media streaming workloads (large record size). For additional guidance on when to set a custom record size, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#record-size-performance"> ZFS Record size</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.</p>', 'OpenZFSCreateRootVolumeConfiguration$RecordSizeKiB' => '<p>Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database workflows can benefit from a smaller record size, while streaming workflows can benefit from a larger record size. For additional guidance on setting a custom record size, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs"> Tips for maximizing performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.</p>', 'OpenZFSVolumeConfiguration$RecordSizeKiB' => '<p>The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. For guidance on when to set a custom record size, see the <i>Amazon FSx for OpenZFS User Guide</i>.</p>', 'UpdateOpenZFSVolumeConfiguration$RecordSizeKiB' => '<p>Specifies the record size of an OpenZFS volume, in kibibytes (KiB). Valid values are 4, 8, 16, 32, 64, 128, 256, 512, or 1024 KiB. The default is 128 KiB. Most workloads should use the default record size. Database workflows can benefit from a smaller record size, while streaming workflows can benefit from a larger record size. For additional guidance on when to set a custom record size, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs"> Tips for maximizing performance</a> in the <i>Amazon FSx for OpenZFS User Guide</i>.</p>', ], ], 'InternalServerError' => [ 'base' => '<p>A generic error indicating a server-side failure.</p>', 'refs' => [], ], 'InvalidDataRepositoryType' => [ 'base' => '<p>You have filtered the response to a data repository type that is not supported.</p>', 'refs' => [], ], 'InvalidDestinationKmsKey' => [ 'base' => '<p>The Key Management Service (KMS) key of the destination backup is not valid.</p>', 'refs' => [], ], 'InvalidExportPath' => [ 'base' => '<p>The path provided for data repository export isn\'t valid.</p>', 'refs' => [], ], 'InvalidImportPath' => [ 'base' => '<p>The path provided for data repository import isn\'t valid.</p>', 'refs' => [], ], 'InvalidNetworkSettings' => [ 'base' => '<p>One or more network settings specified in the request are invalid.</p>', 'refs' => [], ], 'InvalidPerUnitStorageThroughput' => [ 'base' => '<p>An invalid value for <code>PerUnitStorageThroughput</code> was provided. Please create your file system again, using a valid value.</p>', 'refs' => [], ], 'InvalidRegion' => [ 'base' => '<p>The Region provided for <code>SourceRegion</code> is not valid or is in a different Amazon Web Services partition.</p>', 'refs' => [], ], 'InvalidSourceKmsKey' => [ 'base' => '<p>The Key Management Service (KMS) key of the source backup is not valid.</p>', 'refs' => [], ], 'Iops' => [ 'base' => NULL, 'refs' => [ 'DiskIopsConfiguration$Iops' => '<p>The total number of SSD IOPS provisioned for the file system.</p>', ], ], 'IpAddress' => [ 'base' => NULL, 'refs' => [ 'DnsIps$member' => NULL, 'OntapEndpointIpAddresses$member' => NULL, 'WindowsFileSystemConfiguration$PreferredFileServerIp' => '<p>For <code>MULTI_AZ_1</code> deployment types, the IP address of the primary, or preferred, file server.</p> <p>Use this IP address when mounting the file system on Linux SMB clients or Windows SMB clients that are not joined to a Microsoft Active Directory. Applicable for all Windows file system deployment types. This IP address is temporarily unavailable when the file system is undergoing maintenance. For Linux and Windows SMB clients that are joined to an Active Directory, use the file system\'s DNSName instead. For more information on mapping and mounting file shares, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html">Accessing File Shares</a>.</p>', ], ], 'IpAddressRange' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemOntapConfiguration$EndpointIpAddressRange' => '<p>(Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.</p> <important> <p>The Endpoint IP address range you select for your file system must exist outside the VPC\'s CIDR range and must be at least /30 or larger.</p> </important>', 'OntapFileSystemConfiguration$EndpointIpAddressRange' => '<p>(Multi-AZ only) The IP address range in which the endpoints to access your file system are created.</p> <important> <p>The Endpoint IP address range you select for your file system must exist outside the VPC\'s CIDR range and must be at least /30 or larger. If you do not specify this optional parameter, Amazon FSx will automatically select a CIDR block for you.</p> </important>', ], ], 'JunctionPath' => [ 'base' => NULL, 'refs' => [ 'CreateOntapVolumeConfiguration$JunctionPath' => '<p>Specifies the location in the SVM\'s namespace where the volume is mounted. The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>', 'OntapVolumeConfiguration$JunctionPath' => '<p>Specifies the directory that network-attached storage (NAS) clients use to mount the volume, along with the storage virtual machine (SVM) Domain Name System (DNS) name or IP address. You can create a <code>JunctionPath</code> directly below a parent volume junction or on a directory within a volume. A <code>JunctionPath</code> for a volume named <code>vol3</code> might be <code>/vol1/vol2/vol3</code>, or <code>/vol1/dir2/vol3</code>, or even <code>/dir1/dir2/vol3</code>.</p>', 'UpdateOntapVolumeConfiguration$JunctionPath' => '<p>Specifies the location in the SVM\'s namespace where the volume is mounted. The <code>JunctionPath</code> must have a leading forward slash, such as <code>/vol3</code>.</p>', ], ], 'KmsKeyId' => [ 'base' => '<p>Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on Amazon FSx file systems, as follows:</p> <ul> <li> <p>Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment types only.</p> <p> <code>SCRATCH_1</code> and <code>SCRATCH_2</code> types are encrypted using the Amazon FSx service KMS key for your account.</p> </li> <li> <p>Amazon FSx for NetApp ONTAP</p> </li> <li> <p>Amazon FSx for OpenZFS</p> </li> <li> <p>Amazon FSx for Windows File Server</p> </li> </ul> <p>If a <code>KmsKeyId</code> isn\'t specified, the Amazon FSx-managed KMS key for your account is used. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key Management Service API Reference</i>.</p>', 'refs' => [ 'Backup$KmsKeyId' => '<p>The ID of the Key Management Service (KMS) key used to encrypt the backup of the Amazon FSx file system\'s data at rest. </p>', 'CopyBackupRequest$KmsKeyId' => NULL, 'CreateFileSystemFromBackupRequest$KmsKeyId' => NULL, 'CreateFileSystemRequest$KmsKeyId' => NULL, 'FileSystem$KmsKeyId' => '<p>The ID of the Key Management Service (KMS) key used to encrypt Amazon FSx file system data. Used as follows with Amazon FSx file system types:</p> <ul> <li> <p>Amazon FSx for Lustre <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment types only.</p> <p> <code>SCRATCH_1</code> and <code>SCRATCH_2</code> types are encrypted using the Amazon FSx service KMS key for your account.</p> </li> <li> <p>Amazon FSx for NetApp ONTAP</p> </li> <li> <p>Amazon FSx for OpenZFS</p> </li> <li> <p>Amazon FSx for Windows File Server</p> </li> </ul>', ], ], 'LastUpdatedTime' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTaskStatus$LastUpdatedTime' => '<p>The time at which the task status was last updated.</p>', ], ], 'LifecycleTransitionReason' => [ 'base' => '<p>Describes why a resource lifecycle state changed.</p>', 'refs' => [ 'Snapshot$LifecycleTransitionReason' => NULL, 'StorageVirtualMachine$LifecycleTransitionReason' => '<p>Describes why the SVM lifecycle state changed.</p>', 'Volume$LifecycleTransitionReason' => '<p>The reason why the volume lifecycle status changed.</p>', ], ], 'LimitedMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeDataRepositoryAssociationsRequest$MaxResults' => '<p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>', ], ], 'ListTagsForResourceRequest' => [ 'base' => '<p>The request object for <code>ListTagsForResource</code> operation.</p>', 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => '<p>The response object for <code>ListTagsForResource</code> operation.</p>', 'refs' => [], ], 'LustreAccessAuditLogLevel' => [ 'base' => NULL, 'refs' => [ 'LustreLogConfiguration$Level' => '<p>The data repository events that are logged by Amazon FSx.</p> <ul> <li> <p> <code>WARN_ONLY</code> - only warning events are logged.</p> </li> <li> <p> <code>ERROR_ONLY</code> - only error events are logged.</p> </li> <li> <p> <code>WARN_ERROR</code> - both warning events and error events are logged.</p> </li> <li> <p> <code>DISABLED</code> - logging of data repository events is turned off.</p> </li> </ul>', 'LustreLogCreateConfiguration$Level' => '<p>Sets which data repository events are logged by Amazon FSx.</p> <ul> <li> <p> <code>WARN_ONLY</code> - only warning events are logged.</p> </li> <li> <p> <code>ERROR_ONLY</code> - only error events are logged.</p> </li> <li> <p> <code>WARN_ERROR</code> - both warning events and error events are logged.</p> </li> <li> <p> <code>DISABLED</code> - logging of data repository events is turned off.</p> </li> </ul>', ], ], 'LustreDeploymentType' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemLustreConfiguration$DeploymentType' => '<p>(Optional) Choose <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types when you need temporary storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.</p> <p>Choose <code>PERSISTENT_1</code> for longer-term storage and for throughput-focused workloads that aren’t latency-sensitive. <code>PERSISTENT_1</code> supports encryption of data in transit, and is available in all Amazon Web Services Regions in which FSx for Lustre is available.</p> <p>Choose <code>PERSISTENT_2</code> for longer-term storage and for latency-sensitive workloads that require the highest levels of IOPS/throughput. <code>PERSISTENT_2</code> supports SSD storage, and offers higher <code>PerUnitStorageThroughput</code> (up to 1000 MB/s/TiB). <code>PERSISTENT_2</code> is available in a limited number of Amazon Web Services Regions. For more information, and an up-to-date list of Amazon Web Services Regions in which <code>PERSISTENT_2</code> is available, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/using-fsx-lustre.html#lustre-deployment-types">File system deployment options for FSx for Lustre</a> in the <i>Amazon FSx for Lustre User Guide</i>.</p> <note> <p>If you choose <code>PERSISTENT_2</code>, and you set <code>FileSystemTypeVersion</code> to <code>2.10</code>, the <code>CreateFileSystem</code> operation fails.</p> </note> <p>Encryption of data in transit is automatically turned on when you access <code>SCRATCH_2</code>, <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> file systems from Amazon EC2 instances that <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html">support automatic encryption</a> in the Amazon Web Services Regions where they are available. For more information about encryption in transit for FSx for Lustre file systems, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html">Encrypting data in transit</a> in the <i>Amazon FSx for Lustre User Guide</i>. </p> <p>(Default = <code>SCRATCH_1</code>)</p>', 'LustreFileSystemConfiguration$DeploymentType' => '<p>The deployment type of the FSx for Lustre file system. <i>Scratch deployment type</i> is designed for temporary storage and shorter-term processing of data.</p> <p> <code>SCRATCH_1</code> and <code>SCRATCH_2</code> deployment types are best suited for when you need temporary storage and shorter-term processing of data. The <code>SCRATCH_2</code> deployment type provides in-transit encryption of data and higher burst throughput capacity than <code>SCRATCH_1</code>.</p> <p>The <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment type is used for longer-term storage and workloads and encryption of data in transit. <code>PERSISTENT_2</code> is built on Lustre v2.12 and offers higher <code>PerUnitStorageThroughput</code> (up to 1000 MB/s/TiB) along with a lower minimum storage capacity requirement (600 GiB). To learn more about FSx for Lustre deployment types, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html"> FSx for Lustre deployment options</a>.</p> <p>The default is <code>SCRATCH_1</code>.</p>', ], ], 'LustreFileSystemConfiguration' => [ 'base' => '<p>The configuration for the Amazon FSx for Lustre file system.</p>', 'refs' => [ 'FileSystem$LustreConfiguration' => NULL, ], ], 'LustreFileSystemMountName' => [ 'base' => NULL, 'refs' => [ 'LustreFileSystemConfiguration$MountName' => '<p>You use the <code>MountName</code> value when mounting the file system.</p> <p>For the <code>SCRATCH_1</code> deployment type, this value is always "<code>fsx</code>". For <code>SCRATCH_2</code>, <code>PERSISTENT_1</code>, and <code>PERSISTENT_2</code> deployment types, this value is a string that is unique within an Amazon Web Services Region. </p>', ], ], 'LustreLogConfiguration' => [ 'base' => '<p>The configuration for Lustre logging used to write the enabled logging events for your file system to Amazon CloudWatch Logs.</p> <p>When logging is enabled, Lustre logs error and warning events from data repository operations such as automatic export and data repository tasks. To learn more about Lustre logging, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/cw-event-logging.html">Logging with Amazon CloudWatch Logs</a>. </p>', 'refs' => [ 'LustreFileSystemConfiguration$LogConfiguration' => '<p>The Lustre logging configuration. Lustre logging writes the enabled log events for your file system to Amazon CloudWatch Logs.</p>', ], ], 'LustreLogCreateConfiguration' => [ 'base' => '<p>The Lustre logging configuration used when creating or updating an Amazon FSx for Lustre file system. Lustre logging writes the enabled logging events for your file system to Amazon CloudWatch Logs.</p> <p>Error and warning events can be logged from the following data repository operations:</p> <ul> <li> <p>Automatic export</p> </li> <li> <p>Data repository tasks</p> </li> </ul> <p>To learn more about Lustre logging, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/cw-event-logging.html">Logging to Amazon CloudWatch Logs</a>.</p>', 'refs' => [ 'CreateFileSystemLustreConfiguration$LogConfiguration' => '<p>The Lustre logging configuration used when creating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.</p>', 'UpdateFileSystemLustreConfiguration$LogConfiguration' => '<p>The Lustre logging configuration used when updating an Amazon FSx for Lustre file system. When logging is enabled, Lustre logs error and warning events for data repositories associated with your file system to Amazon CloudWatch Logs.</p>', ], ], 'LustreNoSquashNid' => [ 'base' => NULL, 'refs' => [ 'LustreNoSquashNids$member' => NULL, ], ], 'LustreNoSquashNids' => [ 'base' => NULL, 'refs' => [ 'LustreRootSquashConfiguration$NoSquashNids' => '<p>When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses:</p> <ul> <li> <p>A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, <code>10.0.1.6@tcp</code>).</p> </li> <li> <p>An address range is described using a dash to separate the range (for example, <code>10.0.[2-10].[1-255]@tcp</code>).</p> </li> </ul>', ], ], 'LustreRootSquash' => [ 'base' => NULL, 'refs' => [ 'LustreRootSquashConfiguration$RootSquash' => '<p>You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format <code>UID:GID</code> (for example, <code>365534:65534</code>). The UID and GID values can range from <code>0</code> to <code>4294967294</code>:</p> <ul> <li> <p>A non-zero value for UID and GID enables root squash. The UID and GID values can be different, but each must be a non-zero value.</p> </li> <li> <p>A value of <code>0</code> (zero) for UID and GID indicates root, and therefore disables root squash.</p> </li> </ul> <p>When root squash is enabled, the user ID and group ID of a root user accessing the file system are re-mapped to the UID and GID you provide.</p>', ], ], 'LustreRootSquashConfiguration' => [ 'base' => '<p>The configuration for Lustre root squash used to restrict root-level access from clients that try to access your FSx for Lustre file system as root. Use the <code>RootSquash</code> parameter to enable root squash. To learn more about Lustre root squash, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/root-squash.html">Lustre root squash</a>.</p> <p>You can also use the <code>NoSquashNids</code> parameter to provide an array of clients who are not affected by the root squash setting. These clients will access the file system as root, with unrestricted privileges.</p>', 'refs' => [ 'CreateFileSystemLustreConfiguration$RootSquashConfiguration' => '<p>The Lustre root squash configuration used when creating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.</p>', 'LustreFileSystemConfiguration$RootSquashConfiguration' => '<p>The Lustre root squash configuration for an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.</p>', 'UpdateFileSystemLustreConfiguration$RootSquashConfiguration' => '<p>The Lustre root squash configuration used when updating an Amazon FSx for Lustre file system. When enabled, root squash restricts root-level access from clients that try to access your file system as a root user.</p>', ], ], 'MaxResults' => [ 'base' => '<p>The maximum number of resources to return in the response. This value must be an integer greater than zero.</p>', 'refs' => [ 'DescribeBackupsRequest$MaxResults' => '<p>Maximum number of backups to return in the response. This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service\'s internal maximum number of items per page.</p>', 'DescribeDataRepositoryTasksRequest$MaxResults' => NULL, 'DescribeFileSystemAliasesRequest$MaxResults' => '<p>Maximum number of DNS aliases to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service\'s internal maximum number of items per page.</p>', 'DescribeFileSystemsRequest$MaxResults' => '<p>Maximum number of file systems to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service\'s internal maximum number of items per page.</p>', 'DescribeSnapshotsRequest$MaxResults' => NULL, 'DescribeStorageVirtualMachinesRequest$MaxResults' => NULL, 'DescribeVolumesRequest$MaxResults' => NULL, 'ListTagsForResourceRequest$MaxResults' => '<p>Maximum number of tags to return in the response (integer). This parameter value must be greater than 0. The number of items that Amazon FSx returns is the minimum of the <code>MaxResults</code> parameter specified in the request and the service\'s internal maximum number of items per page.</p>', ], ], 'Megabytes' => [ 'base' => NULL, 'refs' => [ 'CreateDataRepositoryAssociationRequest$ImportedFileChunkSize' => '<p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p> <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>', 'CreateFileSystemLustreConfiguration$ImportedFileChunkSize' => '<p>(Optional) For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p> <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p> <p>This parameter is not supported for file systems with the <code>Persistent_2</code> deployment type. Instead, use <code>CreateDataRepositoryAssociation</code> to create a data repository association to link your Lustre file system to a data repository.</p>', 'DataRepositoryAssociation$ImportedFileChunkSize' => '<p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p> <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>', 'DataRepositoryConfiguration$ImportedFileChunkSize' => '<p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p> <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>', 'UpdateDataRepositoryAssociationRequest$ImportedFileChunkSize' => '<p>For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.</p> <p>The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.</p>', ], ], 'MegabytesPerSecond' => [ 'base' => '<p>The sustained throughput of an Amazon FSx file system in Megabytes per second (MBps).</p>', 'refs' => [ 'CreateFileSystemOntapConfiguration$ThroughputCapacity' => '<p>Sets the throughput capacity for the file system that you\'re creating. Valid values are 128, 256, 512, 1024, and 2048 MBps.</p>', 'CreateFileSystemOpenZFSConfiguration$ThroughputCapacity' => '<p>Specifies the throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second (MB/s). Valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s. You pay for additional throughput capacity that you provision.</p>', 'CreateFileSystemWindowsConfiguration$ThroughputCapacity' => '<p>Sets the throughput capacity of an Amazon FSx file system, measured in megabytes per second (MB/s), in 2 to the <i>n</i>th increments, between 2^3 (8) and 2^11 (2048).</p>', 'OntapFileSystemConfiguration$ThroughputCapacity' => NULL, 'OpenZFSFileSystemConfiguration$ThroughputCapacity' => '<p>The throughput of an Amazon FSx file system, measured in megabytes per second (MBps). Valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.</p>', 'UpdateFileSystemOntapConfiguration$ThroughputCapacity' => '<p>Specifies the throughput of an FSx for NetApp ONTAP file system, measured in megabytes per second (MBps). Valid values are 128, 256, 512, 1024, or 2048 MB/s.</p>', 'UpdateFileSystemOpenZFSConfiguration$ThroughputCapacity' => '<p>The throughput of an Amazon FSx file system, measured in megabytes per second (MBps). Valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.</p>', 'UpdateFileSystemWindowsConfiguration$ThroughputCapacity' => '<p>Sets the target value for a file system\'s throughput capacity, in MB/s, that you are updating the file system to. Valid values are 8, 16, 32, 64, 128, 256, 512, 1024, 2048. You cannot make a throughput capacity update request if there is an existing throughput capacity update request in progress. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html">Managing Throughput Capacity</a>.</p>', 'WindowsFileSystemConfiguration$ThroughputCapacity' => '<p>The throughput of the Amazon FSx file system, measured in megabytes per second.</p>', ], ], 'MissingFileSystemConfiguration' => [ 'base' => '<p>A file system configuration is required for this operation.</p>', 'refs' => [], ], 'MissingVolumeConfiguration' => [ 'base' => '<p>A volume configuration is required for this operation.</p>', 'refs' => [], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'CreateDataRepositoryAssociationRequest$FileSystemPath' => '<p>A path on the file system that points to a high-level directory (such as <code>/ns1/</code>) or subdirectory (such as <code>/ns1/subdir/</code>) that will be mapped 1-1 with <code>DataRepositoryPath</code>. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path <code>/ns1/</code>, then you cannot link another data repository with file system path <code>/ns1/ns2</code>.</p> <p>This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.</p> <note> <p>If you specify only a forward slash (<code>/</code>) as the file system path, you can link only 1 data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.</p> </note>', 'DataRepositoryAssociation$FileSystemPath' => '<p>A path on the file system that points to a high-level directory (such as <code>/ns1/</code>) or subdirectory (such as <code>/ns1/subdir/</code>) that will be mapped 1-1 with <code>DataRepositoryPath</code>. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path <code>/ns1/</code>, then you cannot link another data repository with file system path <code>/ns1/ns2</code>.</p> <p>This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.</p> <note> <p>If you specify only a forward slash (<code>/</code>) as the file system path, you can link only 1 data repository to the file system. You can only specify "/" as the file system path for the first data repository associated with a file system.</p> </note>', ], ], 'NetBiosAlias' => [ 'base' => NULL, 'refs' => [ 'CreateSvmActiveDirectoryConfiguration$NetBiosName' => '<p>The NetBIOS name of the Active Directory computer object that will be created for your SVM.</p>', 'SvmActiveDirectoryConfiguration$NetBiosName' => '<p>The NetBIOS name of the Active Directory computer object that is joined to your SVM.</p>', ], ], 'NetworkInterfaceId' => [ 'base' => '<p>An elastic network interface ID. An elastic network interface is a logical networking component in a virtual private cloud (VPC) that represents a virtual network card. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces</a> in the <i>Amazon EC2 User Guide for Linux Instances</i>.</p>', 'refs' => [ 'NetworkInterfaceIds$member' => NULL, ], ], 'NetworkInterfaceIds' => [ 'base' => '<p>A list of network interface IDs.</p>', 'refs' => [ 'FileSystem$NetworkInterfaceIds' => '<p>The IDs of the elastic network interfaces from which a specific file system is accessible. The elastic network interface is automatically created in the same virtual private cloud (VPC) that the Amazon FSx file system was created in. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html">Elastic Network Interfaces</a> in the <i>Amazon EC2 User Guide.</i> </p> <p>For an Amazon FSx for Windows File Server file system, you can have one network interface ID. For an Amazon FSx for Lustre file system, you can have more than one.</p>', ], ], 'NextToken' => [ 'base' => '<p>(Optional) Opaque pagination token returned from a previous operation (String). If present, this token indicates from what point you can continue processing the request, where the previous <code>NextToken</code> value left off.</p>', 'refs' => [ 'DescribeBackupsRequest$NextToken' => '<p>An opaque pagination token returned from a previous <code>DescribeBackups</code> operation. If a token is present, the operation continues the list from where the returning call left off.</p>', 'DescribeBackupsResponse$NextToken' => '<p>A <code>NextToken</code> value is present if there are more backups than returned in the response. You can use the <code>NextToken</code> value in the subsequent request to fetch the backups. </p>', 'DescribeDataRepositoryAssociationsRequest$NextToken' => NULL, 'DescribeDataRepositoryAssociationsResponse$NextToken' => NULL, 'DescribeDataRepositoryTasksRequest$NextToken' => NULL, 'DescribeDataRepositoryTasksResponse$NextToken' => NULL, 'DescribeFileSystemAliasesRequest$NextToken' => '<p>Opaque pagination token returned from a previous <code>DescribeFileSystemAliases</code> operation (String). If a token is included in the request, the action continues the list from where the previous returning call left off.</p>', 'DescribeFileSystemAliasesResponse$NextToken' => '<p>Present if there are more DNS aliases than returned in the response (String). You can use the <code>NextToken</code> value in a later request to fetch additional descriptions. </p>', 'DescribeFileSystemsRequest$NextToken' => '<p>Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String). If a token present, the operation continues the list from where the returning call left off.</p>', 'DescribeFileSystemsResponse$NextToken' => '<p>Present if there are more file systems than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the descriptions. </p>', 'DescribeSnapshotsRequest$NextToken' => NULL, 'DescribeSnapshotsResponse$NextToken' => NULL, 'DescribeStorageVirtualMachinesRequest$NextToken' => NULL, 'DescribeStorageVirtualMachinesResponse$NextToken' => NULL, 'DescribeVolumesRequest$NextToken' => NULL, 'DescribeVolumesResponse$NextToken' => NULL, 'ListTagsForResourceRequest$NextToken' => '<p>Opaque pagination token returned from a previous <code>ListTagsForResource</code> operation (String). If a token present, the action continues the list from where the returning call left off.</p>', 'ListTagsForResourceResponse$NextToken' => '<p>This is present if there are more tags than returned in the response (String). You can use the <code>NextToken</code> value in the later request to fetch the tags. </p>', ], ], 'NotServiceResourceError' => [ 'base' => '<p>The resource specified for the tagging operation is not a resource type owned by Amazon FSx. Use the API of the relevant service to perform the operation. </p>', 'refs' => [], ], 'OntapDeploymentType' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemOntapConfiguration$DeploymentType' => '<p>Specifies the FSx for ONTAP file system deployment type to use in creating the file system. </p> <ul> <li> <p> <code>MULTI_AZ_1</code> - (Default) A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. </p> </li> <li> <p> <code>SINGLE_AZ_1</code> - A file system configured for Single-AZ redundancy.</p> </li> </ul> <p>For information about the use cases for Multi-AZ and Single-AZ deployments, refer to <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-AZ.html">Choosing a file system deployment type</a>. </p>', 'OntapFileSystemConfiguration$DeploymentType' => '<p>Specifies the FSx for ONTAP file system deployment type in use in the file system. </p> <ul> <li> <p> <code>MULTI_AZ_1</code> - (Default) A high availability file system configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. </p> </li> <li> <p> <code>SINGLE_AZ_1</code> - A file system configured for Single-AZ redundancy.</p> </li> </ul> <p>For information about the use cases for Multi-AZ and Single-AZ deployments, refer to <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html">Choosing Multi-AZ or Single-AZ file system deployment</a>. </p>', ], ], 'OntapEndpointIpAddresses' => [ 'base' => NULL, 'refs' => [ 'FileSystemEndpoint$IpAddresses' => '<p>IP addresses of the file system endpoint.</p>', 'SvmEndpoint$IpAddresses' => '<p>The SVM endpoint\'s IP addresses.</p>', ], ], 'OntapFileSystemConfiguration' => [ 'base' => '<p>Configuration for the FSx for NetApp ONTAP file system.</p>', 'refs' => [ 'FileSystem$OntapConfiguration' => '<p>The configuration for this Amazon FSx for NetApp ONTAP file system.</p>', ], ], 'OntapVolumeConfiguration' => [ 'base' => '<p>The configuration of an Amazon FSx for NetApp ONTAP volume.</p>', 'refs' => [ 'Volume$OntapConfiguration' => NULL, ], ], 'OntapVolumeType' => [ 'base' => NULL, 'refs' => [ 'OntapVolumeConfiguration$OntapVolumeType' => '<p>Specifies the type of volume. Valid values are the following:</p> <ul> <li> <p> <code>RW</code> specifies a read/write volume. <code>RW</code> is the default.</p> </li> <li> <p> <code>DP</code> specifies a data-protection volume. You can protect data by replicating it to data-protection mirror copies. If a disaster occurs, you can use these data-protection mirror copies to recover data.</p> </li> <li> <p> <code>LS</code> specifies a load-sharing mirror volume. A load-sharing mirror reduces the network traffic to a FlexVol volume by providing additional read-only access to clients.</p> </li> </ul>', ], ], 'OpenZFSClientConfiguration' => [ 'base' => '<p>Specifies who can mount an OpenZFS file system and the options available while mounting the file system.</p>', 'refs' => [ 'OpenZFSClientConfigurations$member' => NULL, ], ], 'OpenZFSClientConfigurations' => [ 'base' => NULL, 'refs' => [ 'OpenZFSNfsExport$ClientConfigurations' => '<p>A list of configuration objects that contain the client and options for mounting the OpenZFS file system. </p>', ], ], 'OpenZFSClients' => [ 'base' => NULL, 'refs' => [ 'OpenZFSClientConfiguration$Clients' => '<p>A value that specifies who can mount the file system. You can provide a wildcard character (<code>*</code>), an IP address (<code>0.0.0.0</code>), or a CIDR address (<code>192.0.2.0/24</code>). By default, Amazon FSx uses the wildcard character when specifying the client. </p>', ], ], 'OpenZFSCopyStrategy' => [ 'base' => NULL, 'refs' => [ 'CreateOpenZFSOriginSnapshotConfiguration$CopyStrategy' => '<p>The strategy used when copying data from the snapshot to the new volume. </p> <ul> <li> <p> <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying data from the snapshot to a new volume and doesn\'t consume disk throughput. However, the origin snapshot can\'t be deleted if there is a volume using its copied data. </p> </li> <li> <p> <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume. </p> </li> </ul>', 'OpenZFSOriginSnapshotConfiguration$CopyStrategy' => '<p>The strategy used when copying data from the snapshot to the new volume. </p> <ul> <li> <p> <code>CLONE</code> - The new volume references the data in the origin snapshot. Cloning a snapshot is faster than copying the data from a snapshot to a new volume and doesn\'t consume disk throughput. However, the origin snapshot can\'t be deleted if there is a volume using its copied data. </p> </li> <li> <p> <code>FULL_COPY</code> - Copies all data from the snapshot to the new volume. </p> </li> </ul>', ], ], 'OpenZFSCreateRootVolumeConfiguration' => [ 'base' => '<p>The configuration of an Amazon FSx for OpenZFS root volume.</p>', 'refs' => [ 'CreateFileSystemOpenZFSConfiguration$RootVolumeConfiguration' => '<p>The configuration Amazon FSx uses when creating the root value of the Amazon FSx for OpenZFS file system. All volumes are children of the root volume. </p>', ], ], 'OpenZFSDataCompressionType' => [ 'base' => NULL, 'refs' => [ 'CreateOpenZFSVolumeConfiguration$DataCompressionType' => '<p>Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by default.</p> <ul> <li> <p> <code>NONE</code> - Doesn\'t compress the data on the volume. <code>NONE</code> is the default.</p> </li> <li> <p> <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. ZSTD compression provides a higher level of data compression and higher read throughput performance than LZ4 compression.</p> </li> <li> <p> <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. LZ4 compression provides a lower level of compression and higher write throughput performance than ZSTD compression.</p> </li> </ul> <p>For more information about volume compression types and the performance of your Amazon FSx for OpenZFS file system, see <a href="https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/performance.html#performance-tips-zfs"> Tips for maximizing performance</a> File system and volume settings in the <i>Amazon FSx for OpenZFS User Guide</i>.</p>', 'OpenZFSCreateRootVolumeConfiguration$DataCompressionType' => '<p>Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by default.</p> <ul> <li> <p> <code>NONE</code> - Doesn\'t compress the data on the volume. <code>NONE</code> is the default.</p> </li> <li> <p> <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.</p> </li> <li> <p> <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.</p> </li> </ul>', 'OpenZFSVolumeConfiguration$DataCompressionType' => '<p>Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by default.</p> <ul> <li> <p> <code>NONE</code> - Doesn\'t compress the data on the volume. <code>NONE</code> is the default.</p> </li> <li> <p> <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.</p> </li> <li> <p> <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.</p> </li> </ul>', 'UpdateOpenZFSVolumeConfiguration$DataCompressionType' => '<p>Specifies the method used to compress the data on the volume. The compression type is <code>NONE</code> by default.</p> <ul> <li> <p> <code>NONE</code> - Doesn\'t compress the data on the volume. <code>NONE</code> is the default.</p> </li> <li> <p> <code>ZSTD</code> - Compresses the data in the volume using the Zstandard (ZSTD) compression algorithm. Compared to LZ4, Z-Standard provides a better compression ratio to minimize on-disk storage utilization.</p> </li> <li> <p> <code>LZ4</code> - Compresses the data in the volume using the LZ4 compression algorithm. Compared to Z-Standard, LZ4 is less compute-intensive and delivers higher write throughput speeds.</p> </li> </ul>', ], ], 'OpenZFSDeploymentType' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemOpenZFSConfiguration$DeploymentType' => '<p>Specifies the file system deployment type. Amazon FSx for OpenZFS supports <code>SINGLE_AZ_1</code>. <code>SINGLE_AZ_1</code> deployment type is configured for redundancy within a single Availability Zone.</p>', 'OpenZFSFileSystemConfiguration$DeploymentType' => '<p>Specifies the file-system deployment type. Amazon FSx for OpenZFS supports <code>SINGLE_AZ_1</code>. <code>SINGLE_AZ_1</code> is a file system configured for a single Availability Zone (AZ) of redundancy. </p>', ], ], 'OpenZFSFileSystemConfiguration' => [ 'base' => '<p>The configuration for the Amazon FSx for OpenZFS file system. </p>', 'refs' => [ 'FileSystem$OpenZFSConfiguration' => '<p>The configuration for this Amazon FSx for OpenZFS file system.</p>', ], ], 'OpenZFSNfsExport' => [ 'base' => '<p>The Network File System (NFS) configurations for mounting an Amazon FSx for OpenZFS file system. </p>', 'refs' => [ 'OpenZFSNfsExports$member' => NULL, ], ], 'OpenZFSNfsExportOption' => [ 'base' => NULL, 'refs' => [ 'OpenZFSNfsExportOptions$member' => NULL, ], ], 'OpenZFSNfsExportOptions' => [ 'base' => NULL, 'refs' => [ 'OpenZFSClientConfiguration$Options' => '<p>The options to use when mounting the file system. For a list of options that you can use with Network File System (NFS), see the <a href="https://linux.die.net/man/5/exports">exports(5) - Linux man page</a>. When choosing your options, consider the following:</p> <ul> <li> <p> <code>crossmnt</code> is used by default. If you don\'t specify <code>crossmnt</code> when changing the client configuration, you won\'t be able to see or access snapshots in your file system\'s snapshot directory.</p> </li> <li> <p> <code>sync</code> is used by default. If you instead specify <code>async</code>, the system acknowledges writes before writing to disk. If the system crashes before the writes are finished, you lose the unwritten data. </p> </li> </ul>', ], ], 'OpenZFSNfsExports' => [ 'base' => NULL, 'refs' => [ 'CreateOpenZFSVolumeConfiguration$NfsExports' => '<p>The configuration object for mounting a Network File System (NFS) file system.</p>', 'OpenZFSCreateRootVolumeConfiguration$NfsExports' => '<p>The configuration object for mounting a file system.</p>', 'OpenZFSVolumeConfiguration$NfsExports' => '<p>The configuration object for mounting a Network File System (NFS) file system.</p>', 'UpdateOpenZFSVolumeConfiguration$NfsExports' => '<p>The configuration object for mounting a Network File System (NFS) file system.</p>', ], ], 'OpenZFSOriginSnapshotConfiguration' => [ 'base' => '<p>The snapshot configuration to use when creating an OpenZFS volume from a snapshot.</p>', 'refs' => [ 'OpenZFSVolumeConfiguration$OriginSnapshot' => '<p>The configuration object that specifies the snapshot to use as the origin of the data for the volume.</p>', ], ], 'OpenZFSQuotaType' => [ 'base' => NULL, 'refs' => [ 'OpenZFSUserOrGroupQuota$Type' => '<p>A value that specifies whether the quota applies to a user or group.</p>', ], ], 'OpenZFSUserAndGroupQuotas' => [ 'base' => NULL, 'refs' => [ 'CreateOpenZFSVolumeConfiguration$UserAndGroupQuotas' => '<p>An object specifying how much storage users or groups can use on the volume.</p>', 'OpenZFSCreateRootVolumeConfiguration$UserAndGroupQuotas' => '<p>An object specifying how much storage users or groups can use on the volume.</p>', 'OpenZFSVolumeConfiguration$UserAndGroupQuotas' => '<p>An object specifying how much storage users or groups can use on the volume.</p>', 'UpdateOpenZFSVolumeConfiguration$UserAndGroupQuotas' => '<p>An object specifying how much storage users or groups can use on the volume.</p>', ], ], 'OpenZFSUserOrGroupQuota' => [ 'base' => '<p>The configuration for how much storage a user or group can use on the volume. </p>', 'refs' => [ 'OpenZFSUserAndGroupQuotas$member' => NULL, ], ], 'OpenZFSVolumeConfiguration' => [ 'base' => '<p>The configuration of an Amazon FSx for OpenZFS volume.</p>', 'refs' => [ 'Volume$OpenZFSConfiguration' => '<p>The configuration of an Amazon FSx for OpenZFS volume.</p>', ], ], 'OrganizationalUnitDistinguishedName' => [ 'base' => NULL, 'refs' => [ 'SelfManagedActiveDirectoryAttributes$OrganizationalUnitDistinguishedName' => '<p>The fully qualified distinguished name of the organizational unit within the self-managed AD directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>', 'SelfManagedActiveDirectoryConfiguration$OrganizationalUnitDistinguishedName' => '<p>(Optional) The fully qualified distinguished name of the organizational unit within your self-managed AD directory. Amazon FSx only accepts OU as the direct parent of the file system. An example is <code>OU=FSx,DC=yourdomain,DC=corp,DC=com</code>. To learn more, see <a href="https://tools.ietf.org/html/rfc2253">RFC 2253</a>. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. </p> <important> <p>Only Organizational Unit (OU) objects can be the direct parent of the file system that you\'re creating.</p> </important>', ], ], 'Parameter' => [ 'base' => '<p>The name of a parameter for the request. Parameter names are returned in PascalCase.</p>', 'refs' => [ 'IncompatibleParameterError$Parameter' => '<p>A parameter that is incompatible with the earlier request.</p>', ], ], 'PerUnitStorageThroughput' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemLustreConfiguration$PerUnitStorageThroughput' => '<p>Required with <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment types, provisions the amount of read and write throughput for each 1 tebibyte (TiB) of file system storage capacity, in MB/s/TiB. File system throughput capacity is calculated by multiplying ﬁle system storage capacity (TiB) by the <code>PerUnitStorageThroughput</code> (MB/s/TiB). For a 2.4-TiB ﬁle system, provisioning 50 MB/s/TiB of <code>PerUnitStorageThroughput</code> yields 120 MB/s of ﬁle system throughput. You pay for the amount of throughput that you provision. </p> <p>Valid values:</p> <ul> <li> <p>For <code>PERSISTENT_1</code> SSD storage: 50, 100, 200 MB/s/TiB.</p> </li> <li> <p>For <code>PERSISTENT_1</code> HDD storage: 12, 40 MB/s/TiB.</p> </li> <li> <p>For <code>PERSISTENT_2</code> SSD storage: 125, 250, 500, 1000 MB/s/TiB.</p> </li> </ul>', 'LustreFileSystemConfiguration$PerUnitStorageThroughput' => '<p>Per unit storage throughput represents the megabytes per second of read or write throughput per 1 tebibyte of storage provisioned. File system throughput capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB). This option is only valid for <code>PERSISTENT_1</code> and <code>PERSISTENT_2</code> deployment types. </p> <p>Valid values:</p> <ul> <li> <p>For <code>PERSISTENT_1</code> SSD storage: 50, 100, 200.</p> </li> <li> <p>For <code>PERSISTENT_1</code> HDD storage: 12, 40.</p> </li> <li> <p>For <code>PERSISTENT_2</code> SSD storage: 125, 250, 500, 1000.</p> </li> </ul>', ], ], 'ProgressPercent' => [ 'base' => '<p>The current percent of progress of an asynchronous task.</p>', 'refs' => [ 'AdministrativeAction$ProgressPercent' => '<p>The percentage-complete status of a <code>STORAGE_OPTIMIZATION</code> administrative action. Does not apply to any other administrative action type.</p>', 'Backup$ProgressPercent' => NULL, ], ], 'ReadOnly' => [ 'base' => NULL, 'refs' => [ 'CreateOpenZFSVolumeConfiguration$ReadOnly' => '<p>A Boolean value indicating whether the volume is read-only.</p>', 'OpenZFSCreateRootVolumeConfiguration$ReadOnly' => '<p>A Boolean value indicating whether the volume is read-only. Setting this value to <code>true</code> can be useful after you have completed changes to a volume and no longer want changes to occur. </p>', 'OpenZFSVolumeConfiguration$ReadOnly' => '<p>A Boolean value indicating whether the volume is read-only.</p>', 'UpdateOpenZFSVolumeConfiguration$ReadOnly' => '<p>A Boolean value indicating whether the volume is read-only.</p>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'Backup$SourceBackupRegion' => '<p>The source Region of the backup. Specifies the Region from where this backup is copied.</p>', 'CopyBackupRequest$SourceRegion' => '<p>The source Amazon Web Services Region of the backup. Specifies the Amazon Web Services Region from which the backup is being copied. The source and destination Regions must be in the same Amazon Web Services partition. If you don\'t specify a Region, <code>SourceRegion</code> defaults to the Region where the request is sent from (in-Region copy).</p>', ], ], 'ReleaseFileSystemNfsV3LocksRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReleaseFileSystemNfsV3LocksResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReportFormat' => [ 'base' => NULL, 'refs' => [ 'CompletionReport$Format' => '<p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the format of the <code>CompletionReport</code>. <code>REPORT_CSV_20191124</code> is the only format currently supported. When <code>Format</code> is set to <code>REPORT_CSV_20191124</code>, the <code>CompletionReport</code> is provided in CSV format, and is delivered to <code>{path}/task-{id}/failures.csv</code>. </p>', ], ], 'ReportScope' => [ 'base' => NULL, 'refs' => [ 'CompletionReport$Scope' => '<p>Required if <code>Enabled</code> is set to <code>true</code>. Specifies the scope of the <code>CompletionReport</code>; <code>FAILED_FILES_ONLY</code> is the only scope currently supported. When <code>Scope</code> is set to <code>FAILED_FILES_ONLY</code>, the <code>CompletionReport</code> only contains information about files that the data repository task failed to process.</p>', ], ], 'RequestTime' => [ 'base' => NULL, 'refs' => [ 'AdministrativeAction$RequestTime' => '<p>The time that the administrative action request was received.</p>', ], ], 'ResourceARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify Amazon Web Services resources. We require an ARN when you need to specify a resource unambiguously across all of Amazon Web Services. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'refs' => [ 'ActiveDirectoryBackupAttributes$ResourceARN' => NULL, 'Backup$ResourceARN' => '<p>The Amazon Resource Name (ARN) for the backup resource.</p>', 'CreateOpenZFSOriginSnapshotConfiguration$SnapshotARN' => NULL, 'DataRepositoryAssociation$ResourceARN' => NULL, 'DataRepositoryTask$ResourceARN' => NULL, 'FileSystem$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the file system resource.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The ARN of the Amazon FSx resource that will have its tags listed.</p>', 'NotServiceResourceError$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the non-Amazon FSx resource.</p>', 'OpenZFSOriginSnapshotConfiguration$SnapshotARN' => NULL, 'ResourceDoesNotSupportTagging$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the resource that doesn\'t support tagging.</p>', 'ResourceNotFound$ResourceARN' => '<p>The resource ARN of the resource that can\'t be found.</p>', 'Snapshot$ResourceARN' => NULL, 'StorageVirtualMachine$ResourceARN' => NULL, 'TagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) of the Amazon FSx resource that you want to tag.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The ARN of the Amazon FSx resource to untag.</p>', 'Volume$ResourceARN' => NULL, ], ], 'ResourceDoesNotSupportTagging' => [ 'base' => '<p>The resource specified does not support tagging. </p>', 'refs' => [], ], 'ResourceNotFound' => [ 'base' => '<p>The resource specified by the Amazon Resource Name (ARN) can\'t be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'Backup$ResourceType' => '<p>Specifies the resource type that\'s backed up.</p>', ], ], 'RestoreOpenZFSVolumeOption' => [ 'base' => NULL, 'refs' => [ 'RestoreOpenZFSVolumeOptions$member' => NULL, ], ], 'RestoreOpenZFSVolumeOptions' => [ 'base' => NULL, 'refs' => [ 'RestoreVolumeFromSnapshotRequest$Options' => '<p>The settings used when restoring the specified volume from snapshot. </p> <ul> <li> <p> <code>DELETE_INTERMEDIATE_SNAPSHOTS</code> - Deletes snapshots between the current state and the specified snapshot. If there are intermediate snapshots and this option isn\'t used, <code>RestoreVolumeFromSnapshot</code> fails.</p> </li> <li> <p> <code>DELETE_CLONED_VOLUMES</code> - Deletes any dependent clone volumes created from intermediate snapshots. If there are any dependent clone volumes and this option isn\'t used, <code>RestoreVolumeFromSnapshot</code> fails.</p> </li> </ul>', ], ], 'RestoreVolumeFromSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreVolumeFromSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'RouteTableId' => [ 'base' => NULL, 'refs' => [ 'InvalidNetworkSettings$InvalidRouteTableId' => '<p>The route table ID is either invalid or not part of the VPC specified.</p>', 'RouteTableIds$member' => NULL, ], ], 'RouteTableIds' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemOntapConfiguration$RouteTableIds' => '<p>(Multi-AZ only) Specifies the virtual private cloud (VPC) route tables in which your file system\'s endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC\'s default route table.</p>', 'OntapFileSystemConfiguration$RouteTableIds' => '<p>(Multi-AZ only) The VPC route tables in which your file system\'s endpoints are created.</p>', ], ], 'S3DataRepositoryConfiguration' => [ 'base' => '<p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration consists of an <code>AutoImportPolicy</code> that defines file events on the data repository are automatically imported to the file system and an <code>AutoExportPolicy</code> that defines which file events on the file system are automatically exported to the data repository. File events are when files or directories are added, changed, or deleted on the file system or the data repository.</p>', 'refs' => [ 'CreateDataRepositoryAssociationRequest$S3' => '<p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.</p>', 'DataRepositoryAssociation$S3' => '<p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.</p>', 'UpdateDataRepositoryAssociationRequest$S3' => '<p>The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.</p>', ], ], 'SecurityGroupId' => [ 'base' => '<p>The ID of your Amazon EC2 security group. This ID is used to control network access to the endpoint that Amazon FSx creates on your behalf in each subnet. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html">Amazon EC2 Security groups for Linux instances</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'refs' => [ 'InvalidNetworkSettings$InvalidSecurityGroupId' => '<p>The security group ID is either invalid or not part of the VPC specified.</p>', 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => '<p>A list of security group IDs.</p>', 'refs' => [ 'CreateFileSystemFromBackupRequest$SecurityGroupIds' => '<p>A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups apply to all network interfaces. This value isn\'t returned in later <code>DescribeFileSystem</code> requests.</p>', 'CreateFileSystemRequest$SecurityGroupIds' => '<p>A list of IDs specifying the security groups to apply to all network interfaces created for file system access. This list isn\'t returned in later requests to describe the file system.</p>', ], ], 'SecurityStyle' => [ 'base' => NULL, 'refs' => [ 'CreateOntapVolumeConfiguration$SecurityStyle' => '<p>The security style for the volume. Specify one of the following values:</p> <ul> <li> <p> <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account. <code>UNIX</code> is the default.</p> </li> <li> <p> <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</p> </li> <li> <p> <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</p> </li> </ul>', 'OntapVolumeConfiguration$SecurityStyle' => '<p>The security style for the volume, which can be <code>UNIX</code>, <code>NTFS</code>, or <code>MIXED</code>.</p>', 'UpdateOntapVolumeConfiguration$SecurityStyle' => '<p>The security style for the volume, which can be <code>UNIX</code>. <code>NTFS</code>, or <code>MIXED</code>.</p>', ], ], 'SelfManagedActiveDirectoryAttributes' => [ 'base' => '<p>The configuration of the self-managed Microsoft Active Directory (AD) directory to which the Windows File Server or ONTAP storage virtual machine (SVM) instance is joined.</p>', 'refs' => [ 'SvmActiveDirectoryConfiguration$SelfManagedActiveDirectoryConfiguration' => NULL, 'WindowsFileSystemConfiguration$SelfManagedActiveDirectoryConfiguration' => NULL, ], ], 'SelfManagedActiveDirectoryConfiguration' => [ 'base' => '<p>The configuration that Amazon FSx uses to join a FSx for Windows File Server file system or an ONTAP storage virtual machine (SVM) to a self-managed (including on-premises) Microsoft Active Directory (AD) directory. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/self-managed-AD.html"> Using Amazon FSx with your self-managed Microsoft Active Directory</a> or <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html">Managing SVMs</a>.</p>', 'refs' => [ 'CreateFileSystemWindowsConfiguration$SelfManagedActiveDirectoryConfiguration' => NULL, 'CreateSvmActiveDirectoryConfiguration$SelfManagedActiveDirectoryConfiguration' => NULL, ], ], 'SelfManagedActiveDirectoryConfigurationUpdates' => [ 'base' => '<p>The configuration that Amazon FSx uses to join the Windows File Server instance to a self-managed Microsoft Active Directory (AD) directory.</p>', 'refs' => [ 'UpdateFileSystemWindowsConfiguration$SelfManagedActiveDirectoryConfiguration' => '<p>The configuration Amazon FSx uses to join the Windows File Server instance to the self-managed Microsoft AD directory. You cannot make a self-managed Microsoft AD update request if there is an existing self-managed Microsoft AD update request in progress.</p>', 'UpdateSvmActiveDirectoryConfiguration$SelfManagedActiveDirectoryConfiguration' => NULL, ], ], 'ServiceLimit' => [ 'base' => '<p>The types of limits on your service utilization. Limits include file system count, total throughput capacity, total storage, and total user-initiated backups. These limits apply for a specific account in a specific Amazon Web Services Region. You can increase some of them by contacting Amazon Web Services Support.</p>', 'refs' => [ 'ServiceLimitExceeded$Limit' => '<p>Enumeration of the service limit that was exceeded. </p>', ], ], 'ServiceLimitExceeded' => [ 'base' => '<p>An error indicating that a particular service limit was exceeded. You can increase some service limits by contacting Amazon Web Services Support.</p>', 'refs' => [], ], 'Snapshot' => [ 'base' => '<p>A snapshot of an Amazon FSx for OpenZFS volume.</p>', 'refs' => [ 'AdministrativeAction$TargetSnapshotValues' => NULL, 'CreateSnapshotResponse$Snapshot' => '<p>A description of the snapshot.</p>', 'Snapshots$member' => NULL, 'UpdateSnapshotResponse$Snapshot' => '<p>Returned after a successful <code>UpdateSnapshot</code> operation, describing the snapshot that you updated.</p>', ], ], 'SnapshotFilter' => [ 'base' => '<p>A filter used to restrict the results of <code>DescribeSnapshots</code> calls. You can use multiple filters to return results that meet all applied filter requirements.</p>', 'refs' => [ 'SnapshotFilters$member' => NULL, ], ], 'SnapshotFilterName' => [ 'base' => NULL, 'refs' => [ 'SnapshotFilter$Name' => '<p>The name of the filter to use. You can filter by the <code>file-system-id</code> or by <code>volume-id</code>.</p>', ], ], 'SnapshotFilterValue' => [ 'base' => NULL, 'refs' => [ 'SnapshotFilterValues$member' => NULL, ], ], 'SnapshotFilterValues' => [ 'base' => NULL, 'refs' => [ 'SnapshotFilter$Values' => '<p>The <code>file-system-id</code> or <code>volume-id</code> that you are filtering for.</p>', ], ], 'SnapshotFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsRequest$Filters' => '<p>The filters structure. The supported names are <code>file-system-id</code> or <code>volume-id</code>.</p>', ], ], 'SnapshotId' => [ 'base' => NULL, 'refs' => [ 'DeleteSnapshotRequest$SnapshotId' => '<p>The ID of the snapshot that you want to delete.</p>', 'DeleteSnapshotResponse$SnapshotId' => '<p>The ID of the deleted snapshot.</p>', 'RestoreVolumeFromSnapshotRequest$SnapshotId' => '<p>The ID of the source snapshot. Specifies the snapshot that you are restoring from.</p>', 'Snapshot$SnapshotId' => '<p>The ID of the snapshot.</p>', 'SnapshotIds$member' => NULL, 'UpdateSnapshotRequest$SnapshotId' => '<p>The ID of the snapshot that you want to update, in the format <code>fsvolsnap-0123456789abcdef0</code>.</p>', ], ], 'SnapshotIds' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsRequest$SnapshotIds' => '<p>The IDs of the snapshots that you want to retrieve. This parameter value overrides any filters. If any IDs aren\'t found, a <code>SnapshotNotFound</code> error occurs.</p>', ], ], 'SnapshotLifecycle' => [ 'base' => NULL, 'refs' => [ 'DeleteSnapshotResponse$Lifecycle' => '<p>The lifecycle status of the snapshot. If the <code>DeleteSnapshot</code> operation is successful, this status is <code>DELETING</code>.</p>', 'Snapshot$Lifecycle' => '<p>The lifecycle status of the snapshot.</p> <ul> <li> <p> <code>PENDING</code> - Amazon FSx hasn\'t started creating the snapshot.</p> </li> <li> <p> <code>CREATING</code> - Amazon FSx is creating the snapshot.</p> </li> <li> <p> <code>DELETING</code> - Amazon FSx is deleting the snapshot.</p> </li> <li> <p> <code>AVAILABLE</code> - The snapshot is fully available.</p> </li> </ul>', ], ], 'SnapshotName' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotRequest$Name' => '<p>The name of the snapshot. </p>', 'Snapshot$Name' => '<p>The name of the snapshot.</p>', 'UpdateSnapshotRequest$Name' => '<p>The name of the snapshot to update.</p>', ], ], 'SnapshotNotFound' => [ 'base' => '<p>No Amazon FSx snapshots were found based on the supplied parameters.</p>', 'refs' => [], ], 'Snapshots' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsResponse$Snapshots' => '<p>An array of snapshots.</p>', ], ], 'SourceBackupId' => [ 'base' => NULL, 'refs' => [ 'CopyBackupRequest$SourceBackupId' => '<p>The ID of the source backup. Specifies the ID of the backup that\'s being copied.</p>', ], ], 'SourceBackupUnavailable' => [ 'base' => '<p>The request was rejected because the lifecycle status of the source backup isn\'t <code>AVAILABLE</code>.</p>', 'refs' => [], ], 'StartTime' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTask$StartTime' => '<p>The time that Amazon FSx began processing the task.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'AdministrativeAction$Status' => '<p>Describes the status of the administrative action, as follows:</p> <ul> <li> <p> <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.</p> </li> <li> <p> <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.</p> </li> <li> <p> <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.</p> </li> <li> <p> <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.</p> </li> <li> <p> <code>UPDATED_OPTIMIZING</code> - For a storage-capacity increase update, Amazon FSx has updated the file system with the new storage capacity, and is now performing the storage-optimization process. </p> </li> </ul>', ], ], 'StorageCapacity' => [ 'base' => '<p>The storage capacity for your Amazon FSx file system, in gibibytes.</p>', 'refs' => [ 'CreateFileSystemRequest$StorageCapacity' => '<p>Sets the storage capacity of the file system that you\'re creating, in gibibytes (GiB).</p> <p> <b>FSx for Lustre file systems</b> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> and the Lustre <code>DeploymentType</code>, as follows:</p> <ul> <li> <p>For <code>SCRATCH_2</code>, <code>PERSISTENT_2</code> and <code>PERSISTENT_1</code> deployment types using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.</p> </li> <li> <p>For <code>PERSISTENT_1</code> HDD file systems, valid values are increments of 6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for 40 MB/s/TiB file systems.</p> </li> <li> <p>For <code>SCRATCH_1</code> deployment type, valid values are 1200 GiB, 2400 GiB, and increments of 3600 GiB.</p> </li> </ul> <p> <b>FSx for ONTAP file systems</b> - The amount of storage capacity that you can configure is from 1024 GiB up to 196,608 GiB (192 TiB).</p> <p> <b>FSx for OpenZFS file systems</b> - The amount of storage capacity that you can configure is from 64 GiB up to 524,288 GiB (512 TiB).</p> <p> <b>FSx for Windows File Server file systems</b> - The amount of storage capacity that you can configure depends on the value that you set for <code>StorageType</code> as follows:</p> <ul> <li> <p>For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).</p> </li> <li> <p>For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).</p> </li> </ul>', 'FileSystem$StorageCapacity' => '<p>The storage capacity of the file system in gibibytes (GiB).</p>', 'UpdateFileSystemRequest$StorageCapacity' => '<p>Use this parameter to increase the storage capacity of an Amazon FSx for Windows File Server, Amazon FSx for Lustre, or Amazon FSx for NetApp ONTAP file system. Specifies the storage capacity target value, in GiB, to increase the storage capacity for the file system that you\'re updating. </p> <note> <p>You can\'t make a storage capacity increase request if there is an existing storage capacity increase request in progress.</p> </note> <p>For Windows file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. To increase storage capacity, the file system must have at least 16 MBps of throughput capacity. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html">Managing storage capacity</a> in the <i>Amazon FSx for Windows File Server User Guide</i>.</p> <p>For Lustre file systems, the storage capacity target value can be the following:</p> <ul> <li> <p>For <code>SCRATCH_2</code>, <code>PERSISTENT_1</code>, and <code>PERSISTENT_2 SSD</code> deployment types, valid values are in multiples of 2400 GiB. The value must be greater than the current storage capacity.</p> </li> <li> <p>For <code>PERSISTENT HDD</code> file systems, valid values are multiples of 6000 GiB for 12-MBps throughput per TiB file systems and multiples of 1800 GiB for 40-MBps throughput per TiB file systems. The values must be greater than the current storage capacity.</p> </li> <li> <p>For <code>SCRATCH_1</code> file systems, you can\'t increase the storage capacity.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/managing-storage-capacity.html">Managing storage and throughput capacity</a> in the <i>Amazon FSx for Lustre User Guide</i>.</p> <p>For ONTAP file systems, the storage capacity target value must be at least 10 percent greater than the current storage capacity value. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-storage-capacity.html">Managing storage capacity and provisioned IOPS</a> in the <i>Amazon FSx for NetApp ONTAP User Guide</i>.</p>', ], ], 'StorageType' => [ 'base' => '<p>The storage type for your Amazon FSx file system.</p>', 'refs' => [ 'CreateFileSystemFromBackupRequest$StorageType' => '<p>Sets the storage type for the Windows or OpenZFS file system that you\'re creating from a backup. Valid values are <code>SSD</code> and <code>HDD</code>.</p> <ul> <li> <p>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS deployment types.</p> </li> <li> <p>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.</p> </li> </ul> <p> The default value is <code>SSD</code>. </p> <note> <p>HDD and SSD storage types have different minimum storage capacity requirements. A restored file system\'s storage capacity is tied to the file system that was backed up. You can create a file system that uses HDD storage from a backup of a file system that used SSD storage if the original SSD file system had a storage capacity of at least 2000 GiB.</p> </note>', 'CreateFileSystemRequest$StorageType' => '<p>Sets the storage type for the file system that you\'re creating. Valid values are <code>SSD</code> and <code>HDD</code>.</p> <ul> <li> <p>Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows, Lustre, ONTAP, and OpenZFS deployment types.</p> </li> <li> <p>Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and <code>MULTI_AZ_1</code> Windows file system deployment types, and on <code>PERSISTENT_1</code> Lustre file system deployment types. </p> </li> </ul> <p>Default value is <code>SSD</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options"> Storage type options</a> in the <i>FSx for Windows File Server User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options">Multiple storage options</a> in the <i>FSx for Lustre User Guide</i>. </p>', 'FileSystem$StorageType' => '<p>The type of storage the file system is using. If set to <code>SSD</code>, the file system uses solid state drive storage. If set to <code>HDD</code>, the file system uses hard disk drive storage. </p>', ], ], 'StorageVirtualMachine' => [ 'base' => '<p>Describes the Amazon FSx for NetApp ONTAP storage virtual machine (SVM) configuration.</p>', 'refs' => [ 'CreateStorageVirtualMachineResponse$StorageVirtualMachine' => '<p>Returned after a successful <code>CreateStorageVirtualMachine</code> operation; describes the SVM just created.</p>', 'StorageVirtualMachines$member' => NULL, 'UpdateStorageVirtualMachineResponse$StorageVirtualMachine' => NULL, ], ], 'StorageVirtualMachineFilter' => [ 'base' => '<p>A filter used to restrict the results of describe calls for Amazon FSx for NetApp ONTAP storage virtual machines (SVMs). You can use multiple filters to return results that meet all applied filter requirements.</p>', 'refs' => [ 'StorageVirtualMachineFilters$member' => NULL, ], ], 'StorageVirtualMachineFilterName' => [ 'base' => NULL, 'refs' => [ 'StorageVirtualMachineFilter$Name' => '<p>The name for this filter.</p>', ], ], 'StorageVirtualMachineFilterValue' => [ 'base' => NULL, 'refs' => [ 'StorageVirtualMachineFilterValues$member' => NULL, ], ], 'StorageVirtualMachineFilterValues' => [ 'base' => NULL, 'refs' => [ 'StorageVirtualMachineFilter$Values' => '<p>The values of the filter. These are all the values for any of the applied filters.</p>', ], ], 'StorageVirtualMachineFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageVirtualMachinesRequest$Filters' => '<p>Enter a filter name:value pair to view a select set of SVMs.</p>', ], ], 'StorageVirtualMachineId' => [ 'base' => NULL, 'refs' => [ 'CreateOntapVolumeConfiguration$StorageVirtualMachineId' => '<p>Specifies the ONTAP SVM in which to create the volume.</p>', 'DeleteStorageVirtualMachineRequest$StorageVirtualMachineId' => '<p>The ID of the SVM that you want to delete.</p>', 'DeleteStorageVirtualMachineResponse$StorageVirtualMachineId' => '<p>The ID of the SVM Amazon FSx is deleting.</p>', 'OntapVolumeConfiguration$StorageVirtualMachineId' => '<p>The ID of the volume\'s storage virtual machine.</p>', 'StorageVirtualMachine$StorageVirtualMachineId' => '<p>The SVM\'s system generated unique ID.</p>', 'StorageVirtualMachineIds$member' => NULL, 'UpdateStorageVirtualMachineRequest$StorageVirtualMachineId' => '<p>The ID of the SVM that you want to update, in the format <code>svm-0123456789abcdef0</code>.</p>', ], ], 'StorageVirtualMachineIds' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageVirtualMachinesRequest$StorageVirtualMachineIds' => '<p>Enter the ID of one or more SVMs that you want to view.</p>', ], ], 'StorageVirtualMachineLifecycle' => [ 'base' => NULL, 'refs' => [ 'DeleteStorageVirtualMachineResponse$Lifecycle' => '<p>Describes the lifecycle state of the SVM being deleted.</p>', 'StorageVirtualMachine$Lifecycle' => '<p>Describes the SVM\'s lifecycle status.</p> <ul> <li> <p> <code>CREATED</code> - The SVM is fully available for use.</p> </li> <li> <p> <code>CREATING</code> - Amazon FSx is creating the new SVM.</p> </li> <li> <p> <code>DELETING</code> - Amazon FSx is deleting an existing SVM.</p> </li> <li> <p> <code>FAILED</code> - Amazon FSx was unable to create the SVM.</p> </li> <li> <p> <code>MISCONFIGURED</code> - The SVM is in a failed but recoverable state.</p> </li> <li> <p> <code>PENDING</code> - Amazon FSx has not started creating the SVM.</p> </li> </ul>', ], ], 'StorageVirtualMachineName' => [ 'base' => NULL, 'refs' => [ 'CreateStorageVirtualMachineRequest$Name' => '<p>The name of the SVM.</p>', 'StorageVirtualMachine$Name' => '<p>The name of the SVM, if provisioned.</p>', ], ], 'StorageVirtualMachineNotFound' => [ 'base' => '<p>No FSx for ONTAP SVMs were found based upon the supplied parameters.</p>', 'refs' => [], ], 'StorageVirtualMachineRootVolumeSecurityStyle' => [ 'base' => NULL, 'refs' => [ 'CreateStorageVirtualMachineRequest$RootVolumeSecurityStyle' => '<p>The security style of the root volume of the SVM. Specify one of the following values:</p> <ul> <li> <p> <code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</p> </li> <li> <p> <code>NTFS</code> if the file system is managed by a Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Windows user as the service account.</p> </li> <li> <p> <code>MIXED</code> if the file system is managed by both UNIX and Windows administrators and users consist of both NFS and SMB clients.</p> </li> </ul>', 'StorageVirtualMachine$RootVolumeSecurityStyle' => '<p>The security style of the root volume of the SVM.</p>', ], ], 'StorageVirtualMachineSubtype' => [ 'base' => NULL, 'refs' => [ 'StorageVirtualMachine$Subtype' => '<p>Describes the SVM\'s subtype.</p>', ], ], 'StorageVirtualMachines' => [ 'base' => NULL, 'refs' => [ 'DescribeStorageVirtualMachinesResponse$StorageVirtualMachines' => '<p>Returned after a successful <code>DescribeStorageVirtualMachines</code> operation, describing each SVM.</p>', ], ], 'SubnetId' => [ 'base' => '<p>The ID for a subnet. A <i>subnet</i> is a range of IP addresses in your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and subnets</a> in the <i>Amazon VPC User Guide.</i> </p>', 'refs' => [ 'CreateFileSystemOntapConfiguration$PreferredSubnetId' => '<p>Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet in which you want the preferred file server to be located.</p>', 'CreateFileSystemWindowsConfiguration$PreferredSubnetId' => '<p>Required when <code>DeploymentType</code> is set to <code>MULTI_AZ_1</code>. This specifies the subnet in which you want the preferred file server to be located. For in-Amazon Web Services applications, we recommend that you launch your clients in the same Availability Zone (AZ) as your preferred file server to reduce cross-AZ data transfer costs and minimize latency. </p>', 'InvalidNetworkSettings$InvalidSubnetId' => '<p>The subnet ID that is either invalid or not part of the VPC specified.</p>', 'OntapFileSystemConfiguration$PreferredSubnetId' => NULL, 'SubnetIds$member' => NULL, 'WindowsFileSystemConfiguration$PreferredSubnetId' => '<p>For <code>MULTI_AZ_1</code> deployment types, it specifies the ID of the subnet where the preferred file server is located. Must be one of the two subnet IDs specified in <code>SubnetIds</code> property. Amazon FSx serves traffic from this subnet except in the event of a failover to the secondary file server.</p> <p>For <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> deployment types, this value is the same as that for <code>SubnetIDs</code>. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources">Availability and durability: Single-AZ and Multi-AZ file systems</a>.</p>', ], ], 'SubnetIds' => [ 'base' => '<p>A list of subnet IDs. Currently, you can specify only one subnet ID in a call to the <code>CreateFileSystem</code> operation.</p>', 'refs' => [ 'CreateFileSystemFromBackupRequest$SubnetIds' => '<p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.</p> <p>Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre file systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that subnet\'s Availability Zone.</p>', 'CreateFileSystemRequest$SubnetIds' => '<p>Specifies the IDs of the subnets that the file system will be accessible from. For Windows and ONTAP <code>MULTI_AZ_1</code> deployment types,provide exactly two subnet IDs, one for the preferred file server and one for the standby file server. You specify one of these subnets as the preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> or <code>OntapConfiguration &gt; PreferredSubnetID</code> properties. For more information about Multi-AZ file system configuration, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> Availability and durability: Single-AZ and Multi-AZ file systems</a> in the <i>Amazon FSx for Windows User Guide</i> and <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/high-availability-multiAZ.html"> Availability and durability</a> in the <i>Amazon FSx for ONTAP User Guide</i>.</p> <p>For Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> and all Lustre deployment types, provide exactly one subnet ID. The file server is launched in that subnet\'s Availability Zone.</p>', 'FileSystem$SubnetIds' => '<p>Specifies the IDs of the subnets that the file system is accessible from. For the Amazon FSx Windows and ONTAP <code>MULTI_AZ_1</code> file system deployment type, there are two subnet IDs, one for the preferred file server and one for the standby file server. The preferred file server subnet identified in the <code>PreferredSubnetID</code> property. All other file systems have only one subnet ID.</p> <p>For FSx for Lustre file systems, and Single-AZ Windows file systems, this is the ID of the subnet that contains the file system\'s endpoint. For <code>MULTI_AZ_1</code> Windows and ONTAP file systems, the file system endpoint is available in the <code>PreferredSubnetID</code>.</p>', ], ], 'SucceededCount' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTaskStatus$SucceededCount' => '<p>A running total of the number of files that the task has successfully processed.</p>', ], ], 'SvmActiveDirectoryConfiguration' => [ 'base' => '<p>Describes the configuration of the Microsoft Active Directory (AD) directory to which the Amazon FSx for ONTAP storage virtual machine (SVM) is joined. Pleae note, account credentials are not returned in the response payload.</p>', 'refs' => [ 'StorageVirtualMachine$ActiveDirectoryConfiguration' => '<p>Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.</p>', ], ], 'SvmEndpoint' => [ 'base' => '<p>An Amazon FSx for NetApp ONTAP storage virtual machine (SVM) has four endpoints that are used to access data or to manage the SVM using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They are the <code>Iscsi</code>, <code>Management</code>, <code>Nfs</code>, and <code>Smb</code> endpoints.</p>', 'refs' => [ 'SvmEndpoints$Iscsi' => '<p>An endpoint for connecting using the Internet Small Computer Systems Interface (iSCSI) protocol.</p>', 'SvmEndpoints$Management' => '<p>An endpoint for managing SVMs using the NetApp ONTAP CLI, NetApp ONTAP API, or NetApp CloudManager.</p>', 'SvmEndpoints$Nfs' => '<p>An endpoint for connecting using the Network File System (NFS) protocol.</p>', 'SvmEndpoints$Smb' => '<p>An endpoint for connecting using the Server Message Block (SMB) protocol.</p>', ], ], 'SvmEndpoints' => [ 'base' => '<p>An Amazon FSx for NetApp ONTAP storage virtual machine (SVM) has the following endpoints that are used to access data or to manage the SVM using the NetApp ONTAP CLI, REST API, or NetApp CloudManager.</p>', 'refs' => [ 'StorageVirtualMachine$Endpoints' => '<p>The endpoints that are used to access data or to manage the SVM using the NetApp ONTAP CLI, REST API, or NetApp CloudManager. They are the <code>Iscsi</code>, <code>Management</code>, <code>Nfs</code>, and <code>Smb</code> endpoints.</p>', ], ], 'Tag' => [ 'base' => '<p>Specifies a key-value pair for a resource tag.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => '<p>A string of 1 to 128 characters that specifies the key for a tag. Tag keys must be unique for the resource to which they are attached.</p>', 'refs' => [ 'Tag$Key' => '<p>A value that specifies the <code>TagKey</code>, the name of the tag. Tag keys must be unique for the resource to which they are attached.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => '<p>A list of <code>TagKey</code> values, with a maximum of 50 elements.</p>', 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>A list of keys of tags on the resource to untag. In case the tag key doesn\'t exist, the call will still succeed to be idempotent.</p>', ], ], 'TagResourceRequest' => [ 'base' => '<p>The request object for the <code>TagResource</code> operation.</p>', 'refs' => [], ], 'TagResourceResponse' => [ 'base' => '<p>The response object for the <code>TagResource</code> operation.</p>', 'refs' => [], ], 'TagValue' => [ 'base' => '<p>A string of 0 to 256 characters that specifies the value for a tag. Tag values can be null and don\'t have to be unique in a tag set.</p>', 'refs' => [ 'Tag$Value' => '<p>A value that specifies the <code>TagValue</code>, the value assigned to the corresponding tag key. Tag values can be null and don\'t have to be unique in a tag set. For example, you can have a key-value pair in a tag set of <code>finances : April</code> and also of <code>payroll : April</code>.</p>', ], ], 'Tags' => [ 'base' => '<p>A list of <code>Tag</code> values, with a maximum of 50 elements.</p>', 'refs' => [ 'Backup$Tags' => '<p>The tags associated with a particular file system.</p>', 'CopyBackupRequest$Tags' => NULL, 'CreateBackupRequest$Tags' => '<p>(Optional) The tags to apply to the backup at backup creation. The key value of the <code>Name</code> tag appears in the console as the backup name. If you have set <code>CopyTagsToBackups</code> to <code>true</code>, and you specify one or more tags using the <code>CreateBackup</code> operation, no existing file system tags are copied from the file system to the backup.</p>', 'CreateDataRepositoryAssociationRequest$Tags' => NULL, 'CreateDataRepositoryTaskRequest$Tags' => NULL, 'CreateFileSystemFromBackupRequest$Tags' => '<p>The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag appears in the console as the file system name.</p>', 'CreateFileSystemRequest$Tags' => '<p>The tags to apply to the file system that\'s being created. The key value of the <code>Name</code> tag appears in the console as the file system name.</p>', 'CreateSnapshotRequest$Tags' => NULL, 'CreateStorageVirtualMachineRequest$Tags' => NULL, 'CreateVolumeFromBackupRequest$Tags' => NULL, 'CreateVolumeRequest$Tags' => NULL, 'DataRepositoryAssociation$Tags' => NULL, 'DataRepositoryTask$Tags' => NULL, 'DeleteFileSystemLustreConfiguration$FinalBackupTags' => '<p>Use if <code>SkipFinalBackup</code> is set to <code>false</code>, and you want to apply an array of tags to the final backup. If you have set the file system property <code>CopyTagsToBackups</code> to true, and you specify one or more <code>FinalBackupTags</code> when deleting a file system, Amazon FSx will not copy any existing file system tags to the backup.</p>', 'DeleteFileSystemLustreResponse$FinalBackupTags' => '<p>The set of tags applied to the final backup.</p>', 'DeleteFileSystemOpenZFSConfiguration$FinalBackupTags' => '<p>A list of tags to apply to the file system\'s final backup.</p>', 'DeleteFileSystemOpenZFSResponse$FinalBackupTags' => NULL, 'DeleteFileSystemWindowsConfiguration$FinalBackupTags' => '<p>A set of tags for your final backup.</p>', 'DeleteFileSystemWindowsResponse$FinalBackupTags' => '<p>The set of tags applied to the final backup.</p>', 'DeleteVolumeOntapConfiguration$FinalBackupTags' => NULL, 'DeleteVolumeOntapResponse$FinalBackupTags' => NULL, 'FileSystem$Tags' => '<p>The tags to associate with the file system. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a> in the <i>Amazon EC2 User Guide</i>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>A list of tags on the resource.</p>', 'Snapshot$Tags' => NULL, 'StorageVirtualMachine$Tags' => NULL, 'TagResourceRequest$Tags' => '<p>A list of tags for the resource. If a tag with a given key already exists, the value is replaced by the one specified in this parameter.</p>', 'Volume$Tags' => NULL, ], ], 'TaskId' => [ 'base' => NULL, 'refs' => [ 'CancelDataRepositoryTaskRequest$TaskId' => '<p>Specifies the data repository task to cancel.</p>', 'CancelDataRepositoryTaskResponse$TaskId' => '<p>The ID of the task being canceled.</p>', 'DataRepositoryTask$TaskId' => '<p>The system-generated, unique 17-digit ID of the data repository task.</p>', 'TaskIds$member' => NULL, ], ], 'TaskIds' => [ 'base' => NULL, 'refs' => [ 'DescribeDataRepositoryTasksRequest$TaskIds' => '<p>(Optional) IDs of the tasks whose descriptions you want to retrieve (String).</p>', ], ], 'TieringPolicy' => [ 'base' => '<p>Describes the data tiering policy for an ONTAP volume. When enabled, Amazon FSx for ONTAP\'s intelligent tiering automatically transitions a volume\'s data between the file system\'s primary storage and capacity pool storage based on your access patterns.</p> <p>Valid tiering policies are the following:</p> <ul> <li> <p> <code>SNAPSHOT_ONLY</code> - (Default value) moves cold snapshots to the capacity pool storage tier.</p> </li> </ul> <ul> <li> <p> <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</p> </li> </ul> <ul> <li> <p> <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</p> </li> </ul> <ul> <li> <p> <code>NONE</code> - keeps a volume\'s data in the primary storage tier, preventing it from being moved to the capacity pool tier.</p> </li> </ul>', 'refs' => [ 'CreateOntapVolumeConfiguration$TieringPolicy' => NULL, 'OntapVolumeConfiguration$TieringPolicy' => '<p>The volume\'s <code>TieringPolicy</code> setting.</p>', 'UpdateOntapVolumeConfiguration$TieringPolicy' => '<p>Update the volume\'s data tiering policy.</p>', ], ], 'TieringPolicyName' => [ 'base' => NULL, 'refs' => [ 'TieringPolicy$Name' => '<p>Specifies the tiering policy used to transition data. Default value is <code>SNAPSHOT_ONLY</code>.</p> <ul> <li> <p> <code>SNAPSHOT_ONLY</code> - moves cold snapshots to the capacity pool storage tier.</p> </li> <li> <p> <code>AUTO</code> - moves cold user data and snapshots to the capacity pool storage tier based on your access patterns.</p> </li> <li> <p> <code>ALL</code> - moves all user data blocks in both the active file system and Snapshot copies to the storage pool tier.</p> </li> <li> <p> <code>NONE</code> - keeps a volume\'s data in the primary storage tier, preventing it from being moved to the capacity pool tier.</p> </li> </ul>', ], ], 'TotalCount' => [ 'base' => NULL, 'refs' => [ 'DataRepositoryTaskStatus$TotalCount' => '<p>The total number of files that the task will process. While a task is executing, the sum of <code>SucceededCount</code> plus <code>FailedCount</code> may not equal <code>TotalCount</code>. When the task is complete, <code>TotalCount</code> equals the sum of <code>SucceededCount</code> plus <code>FailedCount</code>.</p>', ], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'OntapVolumeConfiguration$UUID' => '<p>The volume\'s universally unique identifier (UUID).</p>', 'StorageVirtualMachine$UUID' => '<p>The SVM\'s UUID (universally unique identifier).</p>', ], ], 'UnsupportedOperation' => [ 'base' => '<p>The requested operation is not supported for this resource or API.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => '<p>The request object for <code>UntagResource</code> action.</p>', 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => '<p>The response object for <code>UntagResource</code> action.</p>', 'refs' => [], ], 'UpdateDataRepositoryAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDataRepositoryAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateFileSystemLustreConfiguration' => [ 'base' => '<p>The configuration object for Amazon FSx for Lustre file systems used in the <code>UpdateFileSystem</code> operation.</p>', 'refs' => [ 'UpdateFileSystemRequest$LustreConfiguration' => NULL, ], ], 'UpdateFileSystemOntapConfiguration' => [ 'base' => '<p>The configuration updates for an Amazon FSx for NetApp ONTAP file system.</p>', 'refs' => [ 'UpdateFileSystemRequest$OntapConfiguration' => NULL, ], ], 'UpdateFileSystemOpenZFSConfiguration' => [ 'base' => '<p>The configuration updates for an Amazon FSx for OpenZFS file system.</p>', 'refs' => [ 'UpdateFileSystemRequest$OpenZFSConfiguration' => '<p>The configuration updates for an Amazon FSx for OpenZFS file system.</p>', ], ], 'UpdateFileSystemRequest' => [ 'base' => '<p>The request object for the <code>UpdateFileSystem</code> operation.</p>', 'refs' => [], ], 'UpdateFileSystemResponse' => [ 'base' => '<p>The response object for the <code>UpdateFileSystem</code> operation.</p>', 'refs' => [], ], 'UpdateFileSystemWindowsConfiguration' => [ 'base' => '<p>Updates the configuration for an existing Amazon FSx for Windows File Server file system. Amazon FSx only overwrites existing properties with non-null values provided in the request.</p>', 'refs' => [ 'UpdateFileSystemRequest$WindowsConfiguration' => '<p>The configuration updates for an Amazon FSx for Windows File Server file system.</p>', ], ], 'UpdateOntapVolumeConfiguration' => [ 'base' => '<p>Used to specify changes to the ONTAP configuration for the volume you are updating.</p>', 'refs' => [ 'UpdateVolumeRequest$OntapConfiguration' => '<p>The configuration of the ONTAP volume that you are updating.</p>', ], ], 'UpdateOpenZFSVolumeConfiguration' => [ 'base' => '<p>Used to specify changes to the OpenZFS configuration for the volume that you are updating.</p>', 'refs' => [ 'UpdateVolumeRequest$OpenZFSConfiguration' => '<p>The configuration of the OpenZFS volume that you are updating.</p>', ], ], 'UpdateSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStorageVirtualMachineRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateStorageVirtualMachineResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSvmActiveDirectoryConfiguration' => [ 'base' => '<p>Updates the Microsoft Active Directory (AD) configuration of an SVM joined to an AD. Please note, account credentials are not returned in the response payload.</p>', 'refs' => [ 'UpdateStorageVirtualMachineRequest$ActiveDirectoryConfiguration' => '<p>Updates the Microsoft Active Directory (AD) configuration for an SVM that is joined to an AD.</p>', ], ], 'UpdateVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVolumeResponse' => [ 'base' => NULL, 'refs' => [], ], 'Volume' => [ 'base' => '<p>Describes an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.</p>', 'refs' => [ 'AdministrativeAction$TargetVolumeValues' => NULL, 'Backup$Volume' => NULL, 'CreateVolumeFromBackupResponse$Volume' => '<p>Returned after a successful <code>CreateVolumeFromBackup</code> API operation, describing the volume just created.</p>', 'CreateVolumeResponse$Volume' => '<p>Returned after a successful <code>CreateVolume</code> API operation, describing the volume just created.</p>', 'UpdateVolumeResponse$Volume' => '<p>A description of the volume just updated. Returned after a successful <code>UpdateVolume</code> API operation.</p>', 'Volumes$member' => NULL, ], ], 'VolumeCapacity' => [ 'base' => NULL, 'refs' => [ 'CreateOntapVolumeConfiguration$SizeInMegabytes' => '<p>Specifies the size of the volume, in megabytes (MB), that you are creating.</p>', 'OntapVolumeConfiguration$SizeInMegabytes' => '<p>The configured size of the volume, in megabytes (MBs).</p>', 'UpdateOntapVolumeConfiguration$SizeInMegabytes' => '<p>Specifies the size of the volume in megabytes.</p>', ], ], 'VolumeFilter' => [ 'base' => '<p>A filter used to restrict the results of describe calls for Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volumes. You can use multiple filters to return results that meet all applied filter requirements.</p>', 'refs' => [ 'VolumeFilters$member' => NULL, ], ], 'VolumeFilterName' => [ 'base' => NULL, 'refs' => [ 'VolumeFilter$Name' => '<p>The name for this filter.</p>', ], ], 'VolumeFilterValue' => [ 'base' => NULL, 'refs' => [ 'VolumeFilterValues$member' => NULL, ], ], 'VolumeFilterValues' => [ 'base' => NULL, 'refs' => [ 'VolumeFilter$Values' => '<p>The values of the filter. These are all the values for any of the applied filters.</p>', ], ], 'VolumeFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeVolumesRequest$Filters' => '<p>Enter a filter <code>Name</code> and <code>Values</code> pair to view a select set of volumes.</p>', ], ], 'VolumeId' => [ 'base' => NULL, 'refs' => [ 'CreateBackupRequest$VolumeId' => '<p>(Optional) The ID of the FSx for ONTAP volume to back up.</p>', 'CreateOpenZFSVolumeConfiguration$ParentVolumeId' => '<p>The ID of the volume to use as the parent volume of the volume that you are creating.</p>', 'CreateSnapshotRequest$VolumeId' => '<p>The ID of the volume that you are taking a snapshot of.</p>', 'DeleteVolumeRequest$VolumeId' => '<p>The ID of the volume that you are deleting.</p>', 'DeleteVolumeResponse$VolumeId' => '<p>The ID of the volume that\'s being deleted.</p>', 'OpenZFSFileSystemConfiguration$RootVolumeId' => '<p>The ID of the root volume of the OpenZFS file system. </p>', 'OpenZFSVolumeConfiguration$ParentVolumeId' => '<p>The ID of the parent volume.</p>', 'RestoreVolumeFromSnapshotRequest$VolumeId' => '<p>The ID of the volume that you are restoring.</p>', 'RestoreVolumeFromSnapshotResponse$VolumeId' => '<p>The ID of the volume that you restored.</p>', 'Snapshot$VolumeId' => '<p>The ID of the volume that the snapshot is of.</p>', 'UpdateVolumeRequest$VolumeId' => '<p>The ID of the volume that you want to update, in the format <code>fsvol-0123456789abcdef0</code>.</p>', 'Volume$VolumeId' => '<p>The system-generated, unique ID of the volume.</p>', 'VolumeIds$member' => NULL, ], ], 'VolumeIds' => [ 'base' => NULL, 'refs' => [ 'DescribeVolumesRequest$VolumeIds' => '<p>The IDs of the volumes whose descriptions you want to retrieve.</p>', ], ], 'VolumeLifecycle' => [ 'base' => NULL, 'refs' => [ 'DeleteVolumeResponse$Lifecycle' => '<p>The lifecycle state of the volume being deleted. If the <code>DeleteVolume</code> operation is successful, this value is <code>DELETING</code>.</p>', 'RestoreVolumeFromSnapshotResponse$Lifecycle' => '<p>The lifecycle state of the volume being restored.</p>', 'Volume$Lifecycle' => '<p>The lifecycle status of the volume.</p> <ul> <li> <p> <code>AVAILABLE</code> - The volume is fully available for use.</p> </li> <li> <p> <code>CREATED</code> - The volume has been created.</p> </li> <li> <p> <code>CREATING</code> - Amazon FSx is creating the new volume.</p> </li> <li> <p> <code>DELETING</code> - Amazon FSx is deleting an existing volume.</p> </li> <li> <p> <code>FAILED</code> - Amazon FSx was unable to create the volume.</p> </li> <li> <p> <code>MISCONFIGURED</code> - The volume is in a failed but recoverable state.</p> </li> <li> <p> <code>PENDING</code> - Amazon FSx hasn\'t started creating the volume.</p> </li> </ul>', ], ], 'VolumeName' => [ 'base' => NULL, 'refs' => [ 'CreateVolumeFromBackupRequest$Name' => '<p>The name of the new volume you\'re creating.</p>', 'CreateVolumeRequest$Name' => '<p>Specifies the name of the volume that you\'re creating.</p>', 'UpdateVolumeRequest$Name' => '<p>The name of the OpenZFS volume. OpenZFS root volumes are automatically named <code>FSX</code>. Child volume names must be unique among their parent volume\'s children. The name of the volume is part of the mount string for the OpenZFS volume. </p>', 'Volume$Name' => '<p>The name of the volume.</p>', ], ], 'VolumeNotFound' => [ 'base' => '<p>No Amazon FSx volumes were found based upon the supplied parameters.</p>', 'refs' => [], ], 'VolumePath' => [ 'base' => NULL, 'refs' => [ 'OpenZFSVolumeConfiguration$VolumePath' => '<p>The path to the volume from the root volume. For example, <code>fsx/parentVolume/volume1</code>.</p>', ], ], 'VolumeType' => [ 'base' => NULL, 'refs' => [ 'CreateVolumeRequest$VolumeType' => '<p>Specifies the type of volume to create; <code>ONTAP</code> and <code>OPENZFS</code> are the only valid volume types.</p>', 'Volume$VolumeType' => '<p>The type of the volume.</p>', ], ], 'Volumes' => [ 'base' => NULL, 'refs' => [ 'DescribeVolumesResponse$Volumes' => '<p>Returned after a successful <code>DescribeVolumes</code> operation, describing each volume.</p>', ], ], 'VpcId' => [ 'base' => '<p>The ID of your virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Subnets.html">VPC and subnets</a> in the <i>Amazon VPC User Guide</i>.</p>', 'refs' => [ 'FileSystem$VpcId' => '<p>The ID of the primary virtual private cloud (VPC) for the file system.</p>', ], ], 'WeeklyTime' => [ 'base' => '<p>A recurring weekly time, in the format <code>D:HH:MM</code>. </p> <p> <code>D</code> is the day of the week, for which 1 represents Monday and 7 represents Sunday. For further details, see <a href="https://en.wikipedia.org/wiki/ISO_week_date">the ISO-8601 spec as described on Wikipedia</a>.</p> <p> <code>HH</code> is the zero-padded hour of the day (0-23), and <code>MM</code> is the zero-padded minute of the hour. </p> <p>For example, <code>1:05:00</code> specifies maintenance at 5 AM Monday.</p>', 'refs' => [ 'CreateFileSystemLustreConfiguration$WeeklyMaintenanceStartTime' => '<p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>', 'CreateFileSystemOntapConfiguration$WeeklyMaintenanceStartTime' => NULL, 'CreateFileSystemOpenZFSConfiguration$WeeklyMaintenanceStartTime' => NULL, 'CreateFileSystemWindowsConfiguration$WeeklyMaintenanceStartTime' => '<p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone, where d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>', 'LustreFileSystemConfiguration$WeeklyMaintenanceStartTime' => '<p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Here, <code>d</code> is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>', 'OntapFileSystemConfiguration$WeeklyMaintenanceStartTime' => NULL, 'OpenZFSFileSystemConfiguration$WeeklyMaintenanceStartTime' => NULL, 'UpdateFileSystemLustreConfiguration$WeeklyMaintenanceStartTime' => '<p>(Optional) The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>', 'UpdateFileSystemOntapConfiguration$WeeklyMaintenanceStartTime' => NULL, 'UpdateFileSystemOpenZFSConfiguration$WeeklyMaintenanceStartTime' => NULL, 'UpdateFileSystemWindowsConfiguration$WeeklyMaintenanceStartTime' => '<p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. Where d is the weekday number, from 1 through 7, with 1 = Monday and 7 = Sunday.</p>', 'WindowsFileSystemConfiguration$WeeklyMaintenanceStartTime' => '<p>The preferred start time to perform weekly maintenance, formatted d:HH:MM in the UTC time zone. d is the weekday number, from 1 through 7, beginning with Monday and ending with Sunday.</p>', ], ], 'WindowsAccessAuditLogLevel' => [ 'base' => NULL, 'refs' => [ 'WindowsAuditLogConfiguration$FileAccessAuditLogLevel' => '<p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p> <ul> <li> <p> <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.</p> </li> <li> <p> <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.</p> </li> <li> <p> <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or folders are logged.</p> </li> <li> <p> <code>DISABLED</code> - access auditing of files and folders is turned off.</p> </li> </ul>', 'WindowsAuditLogConfiguration$FileShareAccessAuditLogLevel' => '<p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p> <ul> <li> <p> <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.</p> </li> <li> <p> <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.</p> </li> <li> <p> <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are logged.</p> </li> <li> <p> <code>DISABLED</code> - access auditing of file shares is turned off.</p> </li> </ul>', 'WindowsAuditLogCreateConfiguration$FileAccessAuditLogLevel' => '<p>Sets which attempt type is logged by Amazon FSx for file and folder accesses.</p> <ul> <li> <p> <code>SUCCESS_ONLY</code> - only successful attempts to access files or folders are logged.</p> </li> <li> <p> <code>FAILURE_ONLY</code> - only failed attempts to access files or folders are logged.</p> </li> <li> <p> <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access files or folders are logged.</p> </li> <li> <p> <code>DISABLED</code> - access auditing of files and folders is turned off.</p> </li> </ul>', 'WindowsAuditLogCreateConfiguration$FileShareAccessAuditLogLevel' => '<p>Sets which attempt type is logged by Amazon FSx for file share accesses.</p> <ul> <li> <p> <code>SUCCESS_ONLY</code> - only successful attempts to access file shares are logged.</p> </li> <li> <p> <code>FAILURE_ONLY</code> - only failed attempts to access file shares are logged.</p> </li> <li> <p> <code>SUCCESS_AND_FAILURE</code> - both successful attempts and failed attempts to access file shares are logged.</p> </li> <li> <p> <code>DISABLED</code> - access auditing of file shares is turned off.</p> </li> </ul>', ], ], 'WindowsAuditLogConfiguration' => [ 'base' => '<p>The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/file-access-auditing.html"> File access auditing</a>.</p>', 'refs' => [ 'WindowsFileSystemConfiguration$AuditLogConfiguration' => '<p>The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.</p>', ], ], 'WindowsAuditLogCreateConfiguration' => [ 'base' => '<p>The Windows file access auditing configuration used when creating or updating an Amazon FSx for Windows File Server file system.</p>', 'refs' => [ 'CreateFileSystemWindowsConfiguration$AuditLogConfiguration' => '<p>The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system.</p>', 'UpdateFileSystemWindowsConfiguration$AuditLogConfiguration' => '<p>The configuration that Amazon FSx for Windows File Server uses to audit and log user accesses of files, folders, and file shares on the Amazon FSx for Windows File Server file system..</p>', ], ], 'WindowsDeploymentType' => [ 'base' => NULL, 'refs' => [ 'CreateFileSystemWindowsConfiguration$DeploymentType' => '<p>Specifies the file system deployment type, valid values are the following:</p> <ul> <li> <p> <code>MULTI_AZ_1</code> - Deploys a high availability file system that is configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability. You can only deploy a Multi-AZ file system in Amazon Web Services Regions that have a minimum of three Availability Zones. Also supports HDD storage type</p> </li> <li> <p> <code>SINGLE_AZ_1</code> - (Default) Choose to deploy a file system that is configured for single AZ redundancy.</p> </li> <li> <p> <code>SINGLE_AZ_2</code> - The latest generation Single AZ file system. Specifies a file system that is configured for single AZ redundancy and supports HDD storage type.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html"> Availability and Durability: Single-AZ and Multi-AZ File Systems</a>.</p>', 'WindowsFileSystemConfiguration$DeploymentType' => '<p>Specifies the file system deployment type, valid values are the following:</p> <ul> <li> <p> <code>MULTI_AZ_1</code> - Specifies a high availability file system that is configured for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability, and supports SSD and HDD storage.</p> </li> <li> <p> <code>SINGLE_AZ_1</code> - (Default) Specifies a file system that is configured for single AZ redundancy, only supports SSD storage.</p> </li> <li> <p> <code>SINGLE_AZ_2</code> - Latest generation Single AZ file system. Specifies a file system that is configured for single AZ redundancy and supports SSD and HDD storage.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html">Single-AZ and Multi-AZ File Systems</a>.</p>', ], ], 'WindowsFileSystemConfiguration' => [ 'base' => '<p>The configuration for this Microsoft Windows file system.</p>', 'refs' => [ 'FileSystem$WindowsConfiguration' => '<p>The configuration for this Amazon FSx for Windows File Server file system.</p>', ], ], ],];
